<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for process_action
 */
class process_action extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $process;
	public $confirm_process;
	public $process_other;
	public $location;
	public $godown;
	public $code;
	public $code_last;
	public $employee_1;
	public $employee_2;
	public $employee_3;
	public $employee_id;
	public $qty;
	public $roll_no;
	public $operator;
	public $datetime;
	public $size_actual;
	public $weight_actual;
	public $lines_in_30cm;
	public $valuation;
	public $deduction;
	public $remark;
	public $upload;
	public $uid;
	public $payment;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'process_action';
		$this->TableName = 'process_action';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`process_action`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('process_action', 'process_action', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// process
		$this->process = new DbField('process_action', 'process_action', 'x_process', 'process', '`process`', '`process`', 2, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Nullable = FALSE; // NOT NULL field
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process->Lookup = new Lookup('process', 'sub_process_type', FALSE, 'id', ["name","","",""], [], ["x_confirm_process"], [], [], [], [], '`name` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// confirm_process
		$this->confirm_process = new DbField('process_action', 'process_action', 'x_confirm_process', 'confirm_process', '`confirm_process`', '`confirm_process`', 2, -1, FALSE, '`confirm_process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->confirm_process->Nullable = FALSE; // NOT NULL field
		$this->confirm_process->Required = TRUE; // Required field
		$this->confirm_process->Sortable = FALSE; // Allow sort
		$this->confirm_process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->confirm_process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->confirm_process->Lookup = new Lookup('confirm_process', 'sub_process_type', FALSE, 'id', ["name","","",""], ["x_process"], [], ["id"], ["x_id"], [], [], '`name` ASC', '');
		$this->confirm_process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['confirm_process'] = &$this->confirm_process;

		// process_other
		$this->process_other = new DbField('process_action', 'process_action', 'x_process_other', 'process_other', '`process_other`', '`process_other`', 200, -1, FALSE, '`process_other`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->process_other->Sortable = TRUE; // Allow sort
		$this->process_other->Lookup = new Lookup('process_other', 'sub_process_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`s_grp` ASC', '');
		$this->fields['process_other'] = &$this->process_other;

		// location
		$this->location = new DbField('process_action', 'process_action', 'x_location', 'location', '`location`', '`location`', 2, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->Nullable = FALSE; // NOT NULL field
		$this->location->Required = TRUE; // Required field
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->location->Lookup = new Lookup('location', 'godown', TRUE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// godown
		$this->godown = new DbField('process_action', 'process_action', 'x_godown', 'godown', '`godown`', '`godown`', 2, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->godown->Lookup = new Lookup('godown', 'godown', TRUE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// code
		$this->code = new DbField('process_action', 'process_action', 'x_code', 'code', '`code`', '`code`', 200, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code->Nullable = FALSE; // NOT NULL field
		$this->code->Required = TRUE; // Required field
		$this->code->Sortable = TRUE; // Allow sort
		$this->fields['code'] = &$this->code;

		// code_last
		$this->code_last = new DbField('process_action', 'process_action', 'x_code_last', 'code_last', '`code_last`', '`code_last`', 200, -1, FALSE, '`code_last`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code_last->Nullable = FALSE; // NOT NULL field
		$this->code_last->Required = TRUE; // Required field
		$this->code_last->Sortable = TRUE; // Allow sort
		$this->fields['code_last'] = &$this->code_last;

		// employee_1
		$this->employee_1 = new DbField('process_action', 'process_action', 'x_employee_1', 'employee_1', '`employee_1`', '`employee_1`', 18, -1, FALSE, '`employee_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->employee_1->Required = TRUE; // Required field
		$this->employee_1->Sortable = FALSE; // Allow sort
		$this->employee_1->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->employee_1->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->employee_1->Lookup = new Lookup('employee_1', 'production_employee', TRUE, 'id', ["id","user_name","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->fields['employee_1'] = &$this->employee_1;

		// employee_2
		$this->employee_2 = new DbField('process_action', 'process_action', 'x_employee_2', 'employee_2', '`employee_2`', '`employee_2`', 18, -1, FALSE, '`employee_2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->employee_2->Required = TRUE; // Required field
		$this->employee_2->Sortable = FALSE; // Allow sort
		$this->employee_2->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->employee_2->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->employee_2->Lookup = new Lookup('employee_2', 'production_employee', TRUE, 'id', ["id","user_name","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->employee_2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_2'] = &$this->employee_2;

		// employee_3
		$this->employee_3 = new DbField('process_action', 'process_action', 'x_employee_3', 'employee_3', '`employee_3`', '`employee_3`', 18, -1, FALSE, '`employee_3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->employee_3->Required = TRUE; // Required field
		$this->employee_3->Sortable = FALSE; // Allow sort
		$this->employee_3->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->employee_3->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->employee_3->Lookup = new Lookup('employee_3', 'production_employee', TRUE, 'id', ["id","user_name","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->employee_3->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_3'] = &$this->employee_3;

		// employee_id
		$this->employee_id = new DbField('process_action', 'process_action', 'x_employee_id', 'employee_id', '`employee_id`', '`employee_id`', 200, -1, FALSE, '`employee_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->employee_id->Sortable = TRUE; // Allow sort
		$this->employee_id->Lookup = new Lookup('employee_id', 'production_employee', TRUE, 'id', ["id","user_name","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->fields['employee_id'] = &$this->employee_id;

		// qty
		$this->qty = new DbField('process_action', 'process_action', 'x_qty', 'qty', '`qty`', '`qty`', 2, -1, FALSE, '`qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty->Sortable = TRUE; // Allow sort
		$this->fields['qty'] = &$this->qty;

		// roll_no
		$this->roll_no = new DbField('process_action', 'process_action', 'x_roll_no', 'roll_no', '`roll_no`', '`roll_no`', 2, -1, FALSE, '`roll_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->roll_no->Sortable = TRUE; // Allow sort
		$this->fields['roll_no'] = &$this->roll_no;

		// operator
		$this->operator = new DbField('process_action', 'process_action', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('process_action', 'process_action', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 117, "DB"), 135, 117, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// size_actual
		$this->size_actual = new DbField('process_action', 'process_action', 'x_size_actual', 'size_actual', '`size_actual`', '`size_actual`', 200, -1, FALSE, '`size_actual`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_actual->Sortable = TRUE; // Allow sort
		$this->fields['size_actual'] = &$this->size_actual;

		// weight_actual
		$this->weight_actual = new DbField('process_action', 'process_action', 'x_weight_actual', 'weight_actual', '`weight_actual`', '`weight_actual`', 131, -1, FALSE, '`weight_actual`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weight_actual->Sortable = TRUE; // Allow sort
		$this->weight_actual->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['weight_actual'] = &$this->weight_actual;

		// lines_in_30cm
		$this->lines_in_30cm = new DbField('process_action', 'process_action', 'x_lines_in_30cm', 'lines_in_30cm', '`lines_in_30cm`', '`lines_in_30cm`', 131, -1, FALSE, '`lines_in_30cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lines_in_30cm->Sortable = TRUE; // Allow sort
		$this->lines_in_30cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['lines_in_30cm'] = &$this->lines_in_30cm;

		// valuation
		$this->valuation = new DbField('process_action', 'process_action', 'x_valuation', 'valuation', '`valuation`', '`valuation`', 2, -1, FALSE, '`valuation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->valuation->Sortable = TRUE; // Allow sort
		$this->valuation->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->valuation->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->valuation->Lookup = new Lookup('valuation', 'process_action', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->valuation->OptionCount = 5;
		$this->valuation->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['valuation'] = &$this->valuation;

		// deduction
		$this->deduction = new DbField('process_action', 'process_action', 'x_deduction', 'deduction', '`deduction`', '`deduction`', 131, -1, FALSE, '`deduction`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->deduction->Nullable = FALSE; // NOT NULL field
		$this->deduction->Sortable = TRUE; // Allow sort
		$this->deduction->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['deduction'] = &$this->deduction;

		// remark
		$this->remark = new DbField('process_action', 'process_action', 'x_remark', 'remark', '`remark`', '`remark`', 201, -1, FALSE, '`remark`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remark->Sortable = TRUE; // Allow sort
		$this->fields['remark'] = &$this->remark;

		// upload
		$this->upload = new DbField('process_action', 'process_action', 'x_upload', 'upload', '`upload`', '`upload`', 200, -1, TRUE, '`upload`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->upload->Sortable = TRUE; // Allow sort
		$this->fields['upload'] = &$this->upload;

		// uid
		$this->uid = new DbField('process_action', 'process_action', 'x_uid', 'uid', '`uid`', '`uid`', 200, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->uid->Nullable = FALSE; // NOT NULL field
		$this->uid->Required = TRUE; // Required field
		$this->uid->Sortable = FALSE; // Allow sort
		$this->fields['uid'] = &$this->uid;

		// payment
		$this->payment = new DbField('process_action', 'process_action', 'x_payment', 'payment', '`payment`', '`payment`', 18, -1, FALSE, '`payment`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment->Required = TRUE; // Required field
		$this->payment->Sortable = FALSE; // Allow sort
		$this->payment->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment->Lookup = new Lookup('payment', 'payment_period', FALSE, 'id', ["payment_description","","",""], [], [], [], [], [], [], '`payment_description` ASC', '');
		$this->payment->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['payment'] = &$this->payment;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`process_action`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site() == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`location`, '" . User_Site() . "') and `process` = " .$_COOKIE["prid"]. "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->process->DbValue = $row['process'];
		$this->confirm_process->DbValue = $row['confirm_process'];
		$this->process_other->DbValue = $row['process_other'];
		$this->location->DbValue = $row['location'];
		$this->godown->DbValue = $row['godown'];
		$this->code->DbValue = $row['code'];
		$this->code_last->DbValue = $row['code_last'];
		$this->employee_1->DbValue = $row['employee_1'];
		$this->employee_2->DbValue = $row['employee_2'];
		$this->employee_3->DbValue = $row['employee_3'];
		$this->employee_id->DbValue = $row['employee_id'];
		$this->qty->DbValue = $row['qty'];
		$this->roll_no->DbValue = $row['roll_no'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->size_actual->DbValue = $row['size_actual'];
		$this->weight_actual->DbValue = $row['weight_actual'];
		$this->lines_in_30cm->DbValue = $row['lines_in_30cm'];
		$this->valuation->DbValue = $row['valuation'];
		$this->deduction->DbValue = $row['deduction'];
		$this->remark->DbValue = $row['remark'];
		$this->upload->Upload->DbValue = $row['upload'];
		$this->uid->DbValue = $row['uid'];
		$this->payment->DbValue = $row['payment'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->upload->OldUploadPath = '.p_uploads/weaving/';
		$oldFiles = EmptyValue($row['upload']) ? [] : [$row['upload']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->upload->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "process_actionlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "process_actionview.php")
			return $Language->phrase("View");
		elseif ($pageName == "process_actionedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "process_actionadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "process_actionlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("process_actionview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("process_actionview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "process_actionadd.php?" . $this->getUrlParm($parm);
		else
			$url = "process_actionadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("process_actionedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("process_actionadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("process_actiondelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->process->setDbValue($rs->fields('process'));
		$this->confirm_process->setDbValue($rs->fields('confirm_process'));
		$this->process_other->setDbValue($rs->fields('process_other'));
		$this->location->setDbValue($rs->fields('location'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->code->setDbValue($rs->fields('code'));
		$this->code_last->setDbValue($rs->fields('code_last'));
		$this->employee_1->setDbValue($rs->fields('employee_1'));
		$this->employee_2->setDbValue($rs->fields('employee_2'));
		$this->employee_3->setDbValue($rs->fields('employee_3'));
		$this->employee_id->setDbValue($rs->fields('employee_id'));
		$this->qty->setDbValue($rs->fields('qty'));
		$this->roll_no->setDbValue($rs->fields('roll_no'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->size_actual->setDbValue($rs->fields('size_actual'));
		$this->weight_actual->setDbValue($rs->fields('weight_actual'));
		$this->lines_in_30cm->setDbValue($rs->fields('lines_in_30cm'));
		$this->valuation->setDbValue($rs->fields('valuation'));
		$this->deduction->setDbValue($rs->fields('deduction'));
		$this->remark->setDbValue($rs->fields('remark'));
		$this->upload->Upload->DbValue = $rs->fields('upload');
		$this->uid->setDbValue($rs->fields('uid'));
		$this->payment->setDbValue($rs->fields('payment'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// process
		// confirm_process

		$this->confirm_process->CellCssStyle = "white-space: nowrap;";

		// process_other
		// location
		// godown
		// code
		// code_last
		// employee_1

		$this->employee_1->CellCssStyle = "white-space: nowrap;";

		// employee_2
		$this->employee_2->CellCssStyle = "white-space: nowrap;";

		// employee_3
		$this->employee_3->CellCssStyle = "white-space: nowrap;";

		// employee_id
		// qty
		// roll_no
		// operator
		// datetime
		// size_actual
		// weight_actual
		// lines_in_30cm
		// valuation
		// deduction
		// remark
		// upload
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// payment
		$this->payment->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `type` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// confirm_process
		$curVal = strval($this->confirm_process->CurrentValue);
		if ($curVal <> "") {
			$this->confirm_process->ViewValue = $this->confirm_process->lookupCacheOption($curVal);
			if ($this->confirm_process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->confirm_process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->confirm_process->ViewValue = $this->confirm_process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->confirm_process->ViewValue = $this->confirm_process->CurrentValue;
				}
			}
		} else {
			$this->confirm_process->ViewValue = NULL;
		}
		$this->confirm_process->ViewCustomAttributes = "";

		// process_other
		$curVal = strval($this->process_other->CurrentValue);
		if ($curVal <> "") {
			$this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
			if ($this->process_other->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_other->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_other->ViewValue->add($this->process_other->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process_other->ViewValue = $this->process_other->CurrentValue;
				}
			}
		} else {
			$this->process_other->ViewValue = NULL;
		}
		$this->process_other->ViewCustomAttributes = "";

		// location
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// godown
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`= 1 and `id` > 1 && `id` != 10";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// code_last
		$this->code_last->ViewValue = $this->code_last->CurrentValue;
		$this->code_last->ViewCustomAttributes = "";

		// employee_1
		$curVal = strval($this->employee_1->CurrentValue);
		if ($curVal <> "") {
			$this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
			if ($this->employee_1->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->employee_1->ViewValue = $this->employee_1->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->employee_1->ViewValue = $this->employee_1->CurrentValue;
				}
			}
		} else {
			$this->employee_1->ViewValue = NULL;
		}
		$this->employee_1->ViewCustomAttributes = "";

		// employee_2
		$curVal = strval($this->employee_2->CurrentValue);
		if ($curVal <> "") {
			$this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
			if ($this->employee_2->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_2->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->employee_2->ViewValue = $this->employee_2->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->employee_2->ViewValue = $this->employee_2->CurrentValue;
				}
			}
		} else {
			$this->employee_2->ViewValue = NULL;
		}
		$this->employee_2->ViewCustomAttributes = "";

		// employee_3
		$curVal = strval($this->employee_3->CurrentValue);
		if ($curVal <> "") {
			$this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
			if ($this->employee_3->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->employee_3->ViewValue = $this->employee_3->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->employee_3->ViewValue = $this->employee_3->CurrentValue;
				}
			}
		} else {
			$this->employee_3->ViewValue = NULL;
		}
		$this->employee_3->ViewCustomAttributes = "";

		// employee_id
		$curVal = strval($this->employee_id->CurrentValue);
		if ($curVal <> "") {
			$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			if ($this->employee_id->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
				}
			}
		} else {
			$this->employee_id->ViewValue = NULL;
		}
		$this->employee_id->ViewCustomAttributes = "";

		// qty
		$this->qty->ViewValue = $this->qty->CurrentValue;
		$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
		$this->qty->ViewCustomAttributes = "";

		// roll_no
		$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
		$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
		$this->roll_no->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 117);
		$this->datetime->ViewCustomAttributes = "";

		// size_actual
		$this->size_actual->ViewValue = $this->size_actual->CurrentValue;
		$this->size_actual->ViewCustomAttributes = "";

		// weight_actual
		$this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
		$this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, 2, -2, -2, -2);
		$this->weight_actual->ViewCustomAttributes = "";

		// lines_in_30cm
		$this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
		$this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, 2, -2, -2, -2);
		$this->lines_in_30cm->ViewCustomAttributes = "";

		// valuation
		if (strval($this->valuation->CurrentValue) <> "") {
			$this->valuation->ViewValue = $this->valuation->optionCaption($this->valuation->CurrentValue);
		} else {
			$this->valuation->ViewValue = NULL;
		}
		$this->valuation->ViewCustomAttributes = "";

		// deduction
		$this->deduction->ViewValue = $this->deduction->CurrentValue;
		$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 2, -2, -2, -2);
		$this->deduction->ViewCustomAttributes = "";

		// remark
		$this->remark->ViewValue = $this->remark->CurrentValue;
		$this->remark->ViewCustomAttributes = "";

		// upload
		$this->upload->UploadPath = '.p_uploads/weaving/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->ViewValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->ViewValue = "";
		}
		$this->upload->ViewCustomAttributes = "";

		// uid
		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// payment
		$curVal = strval($this->payment->CurrentValue);
		if ($curVal <> "") {
			$this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
			if ($this->payment->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->payment->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->payment->ViewValue = $this->payment->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->payment->ViewValue = $this->payment->CurrentValue;
				}
			}
		} else {
			$this->payment->ViewValue = NULL;
		}
		$this->payment->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		if (!EmptyValue($this->process->CurrentValue)) {
			$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
			$this->process->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
		} else {
			$this->process->HrefValue = "";
		}
		$this->process->TooltipValue = "";

		// confirm_process
		$this->confirm_process->LinkCustomAttributes = "";
		$this->confirm_process->HrefValue = "";
		$this->confirm_process->TooltipValue = "";

		// process_other
		$this->process_other->LinkCustomAttributes = "";
		$this->process_other->HrefValue = "";
		$this->process_other->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		$this->godown->HrefValue = "";
		$this->godown->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		if (!EmptyValue($this->code->CurrentValue)) {
			$this->code->HrefValue = "bcodelist.php?x__barcode=" . $this->code->CurrentValue; // Add prefix/suffix
			$this->code->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
		} else {
			$this->code->HrefValue = "";
		}
		$this->code->TooltipValue = "";

		// code_last
		$this->code_last->LinkCustomAttributes = "";
		$this->code_last->HrefValue = "";
		$this->code_last->TooltipValue = "";

		// employee_1
		$this->employee_1->LinkCustomAttributes = "";
		if (!EmptyValue($this->employee_1->CurrentValue)) {
			$this->employee_1->HrefValue = "process_actionlist.php?x_emp_name=" . $this->employee_1->CurrentValue; // Add prefix/suffix
			$this->employee_1->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->employee_1->HrefValue = FullUrl($this->employee_1->HrefValue, "href");
		} else {
			$this->employee_1->HrefValue = "";
		}
		$this->employee_1->TooltipValue = "";

		// employee_2
		$this->employee_2->LinkCustomAttributes = "";
		$this->employee_2->HrefValue = "";
		$this->employee_2->TooltipValue = "";

		// employee_3
		$this->employee_3->LinkCustomAttributes = "";
		$this->employee_3->HrefValue = "";
		$this->employee_3->TooltipValue = "";

		// employee_id
		$this->employee_id->LinkCustomAttributes = "";
		$this->employee_id->HrefValue = "";
		$this->employee_id->TooltipValue = "";

		// qty
		$this->qty->LinkCustomAttributes = "";
		$this->qty->HrefValue = "";
		$this->qty->TooltipValue = "";

		// roll_no
		$this->roll_no->LinkCustomAttributes = "";
		$this->roll_no->HrefValue = "";
		$this->roll_no->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// size_actual
		$this->size_actual->LinkCustomAttributes = "";
		$this->size_actual->HrefValue = "";
		$this->size_actual->TooltipValue = "";

		// weight_actual
		$this->weight_actual->LinkCustomAttributes = "";
		$this->weight_actual->HrefValue = "";
		$this->weight_actual->TooltipValue = "";

		// lines_in_30cm
		$this->lines_in_30cm->LinkCustomAttributes = "";
		$this->lines_in_30cm->HrefValue = "";
		$this->lines_in_30cm->TooltipValue = "";

		// valuation
		$this->valuation->LinkCustomAttributes = "";
		$this->valuation->HrefValue = "";
		$this->valuation->TooltipValue = "";

		// deduction
		$this->deduction->LinkCustomAttributes = "";
		$this->deduction->HrefValue = "";
		$this->deduction->TooltipValue = "";

		// remark
		$this->remark->LinkCustomAttributes = "";
		$this->remark->HrefValue = "";
		$this->remark->TooltipValue = "";

		// upload
		$this->upload->LinkCustomAttributes = "";
		$this->upload->UploadPath = '.p_uploads/weaving/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->Upload->DbValue); // Add prefix/suffix
			$this->upload->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
		} else {
			$this->upload->HrefValue = "";
		}
		$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
		$this->upload->TooltipValue = "";
		if ($this->upload->UseColorbox) {
			if (EmptyValue($this->upload->TooltipValue))
				$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->upload->LinkAttrs["data-rel"] = "process_action_x_upload";
			AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
		}

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// payment
		$this->payment->LinkCustomAttributes = "";
		$this->payment->HrefValue = "";
		$this->payment->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->EditValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `type` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process->EditValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->EditValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->EditValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// confirm_process
		$this->confirm_process->EditAttrs["class"] = "form-control";
		$this->confirm_process->EditCustomAttributes = "";
		$curVal = strval($this->confirm_process->CurrentValue);
		if ($curVal <> "") {
			$this->confirm_process->EditValue = $this->confirm_process->lookupCacheOption($curVal);
			if ($this->confirm_process->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->confirm_process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->confirm_process->EditValue = $this->confirm_process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->confirm_process->EditValue = $this->confirm_process->CurrentValue;
				}
			}
		} else {
			$this->confirm_process->EditValue = NULL;
		}
		$this->confirm_process->ViewCustomAttributes = "";

		// process_other
		$this->process_other->EditAttrs["class"] = "form-control";
		$this->process_other->EditCustomAttributes = "";
		$curVal = strval($this->process_other->CurrentValue);
		if ($curVal <> "") {
			$this->process_other->EditValue = $this->process_other->lookupCacheOption($curVal);
			if ($this->process_other->EditValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_other->EditValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_other->EditValue->add($this->process_other->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process_other->EditValue = $this->process_other->CurrentValue;
				}
			}
		} else {
			$this->process_other->EditValue = NULL;
		}
		$this->process_other->ViewCustomAttributes = "";

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->EditValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->location->EditValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->EditValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->EditValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = 'autofocus';
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// code_last
		$this->code_last->EditAttrs["class"] = "form-control";
		$this->code_last->EditCustomAttributes = "";
		$this->code_last->EditValue = $this->code_last->CurrentValue;
		$this->code_last->ViewCustomAttributes = "";

		// employee_1
		$this->employee_1->EditAttrs["class"] = "form-control";
		$this->employee_1->EditCustomAttributes = "";

		// employee_2
		$this->employee_2->EditAttrs["class"] = "form-control";
		$this->employee_2->EditCustomAttributes = "";

		// employee_3
		$this->employee_3->EditAttrs["class"] = "form-control";
		$this->employee_3->EditCustomAttributes = "";

		// employee_id
		$this->employee_id->EditCustomAttributes = "";

		// qty
		$this->qty->EditAttrs["class"] = "form-control";
		$this->qty->EditCustomAttributes = "";
		$this->qty->EditValue = $this->qty->CurrentValue;
		$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

		// roll_no
		$this->roll_no->EditAttrs["class"] = "form-control";
		$this->roll_no->EditCustomAttributes = "";
		$this->roll_no->EditValue = $this->roll_no->CurrentValue;
		$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

		// operator
		// datetime
		// size_actual

		$this->size_actual->EditAttrs["class"] = "form-control";
		$this->size_actual->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_actual->CurrentValue = HtmlDecode($this->size_actual->CurrentValue);
		$this->size_actual->EditValue = $this->size_actual->CurrentValue;
		$this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

		// weight_actual
		$this->weight_actual->EditAttrs["class"] = "form-control";
		$this->weight_actual->EditCustomAttributes = "";
		$this->weight_actual->EditValue = $this->weight_actual->CurrentValue;
		$this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());
		if (strval($this->weight_actual->EditValue) <> "" && is_numeric($this->weight_actual->EditValue))
			$this->weight_actual->EditValue = FormatNumber($this->weight_actual->EditValue, -2, -2, -2, -2);

		// lines_in_30cm
		$this->lines_in_30cm->EditAttrs["class"] = "form-control";
		$this->lines_in_30cm->EditCustomAttributes = "";
		$this->lines_in_30cm->EditValue = $this->lines_in_30cm->CurrentValue;
		$this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());
		if (strval($this->lines_in_30cm->EditValue) <> "" && is_numeric($this->lines_in_30cm->EditValue))
			$this->lines_in_30cm->EditValue = FormatNumber($this->lines_in_30cm->EditValue, -2, -2, -2, -2);

		// valuation
		$this->valuation->EditAttrs["class"] = "form-control";
		$this->valuation->EditCustomAttributes = "";
		$this->valuation->EditValue = $this->valuation->options(TRUE);

		// deduction
		$this->deduction->EditAttrs["class"] = "form-control";
		$this->deduction->EditCustomAttributes = "";
		$this->deduction->EditValue = $this->deduction->CurrentValue;
		$this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
		if (strval($this->deduction->EditValue) <> "" && is_numeric($this->deduction->EditValue))
			$this->deduction->EditValue = FormatNumber($this->deduction->EditValue, -2, -2, -2, -2);

		// remark
		$this->remark->EditAttrs["class"] = "form-control";
		$this->remark->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
		$this->remark->EditValue = $this->remark->CurrentValue;
		$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

		// upload
		$this->upload->EditAttrs["class"] = "form-control";
		$this->upload->EditCustomAttributes = "";
		$this->upload->UploadPath = '.p_uploads/weaving/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->EditValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->EditValue = "";
		}
		if (!EmptyValue($this->upload->CurrentValue))
				$this->upload->Upload->FileName = $this->upload->CurrentValue;

		// uid
		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

		// payment
		$this->payment->EditAttrs["class"] = "form-control";
		$this->payment->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->confirm_process);
					$doc->exportCaption($this->process_other);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->code_last);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->roll_no);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->size_actual);
					$doc->exportCaption($this->weight_actual);
					$doc->exportCaption($this->lines_in_30cm);
					$doc->exportCaption($this->valuation);
					$doc->exportCaption($this->deduction);
					$doc->exportCaption($this->remark);
					$doc->exportCaption($this->upload);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->process_other);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->code_last);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->roll_no);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->size_actual);
					$doc->exportCaption($this->weight_actual);
					$doc->exportCaption($this->lines_in_30cm);
					$doc->exportCaption($this->valuation);
					$doc->exportCaption($this->deduction);
					$doc->exportCaption($this->remark);
					$doc->exportCaption($this->upload);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->process);
						$doc->exportField($this->confirm_process);
						$doc->exportField($this->process_other);
						$doc->exportField($this->location);
						$doc->exportField($this->godown);
						$doc->exportField($this->code);
						$doc->exportField($this->code_last);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->qty);
						$doc->exportField($this->roll_no);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->size_actual);
						$doc->exportField($this->weight_actual);
						$doc->exportField($this->lines_in_30cm);
						$doc->exportField($this->valuation);
						$doc->exportField($this->deduction);
						$doc->exportField($this->remark);
						$doc->exportField($this->upload);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->process);
						$doc->exportField($this->process_other);
						$doc->exportField($this->location);
						$doc->exportField($this->godown);
						$doc->exportField($this->code);
						$doc->exportField($this->code_last);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->qty);
						$doc->exportField($this->roll_no);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->size_actual);
						$doc->exportField($this->weight_actual);
						$doc->exportField($this->lines_in_30cm);
						$doc->exportField($this->valuation);
						$doc->exportField($this->deduction);
						$doc->exportField($this->remark);
						$doc->exportField($this->upload);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'upload') {
			$fldName = "upload";
			$fileNameFld = "upload";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>