<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_add extends process_action
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action';

	// Page object name
	public $PageObjName = "process_action_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action)
		if (!isset($GLOBALS["process_action"]) || get_class($GLOBALS["process_action"]) == PROJECT_NAMESPACE . "process_action") {
			$GLOBALS["process_action"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "process_actionview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_actionlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->process->setVisibility();
		$this->confirm_process->setVisibility();
		$this->process_other->setVisibility();
		$this->location->setVisibility();
		$this->godown->setVisibility();
		$this->code->setVisibility();
		$this->code_last->setVisibility();
		$this->employee_1->setVisibility();
		$this->employee_2->setVisibility();
		$this->employee_3->setVisibility();
		$this->employee_id->setVisibility();
		$this->qty->setVisibility();
		$this->roll_no->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->size_actual->setVisibility();
		$this->weight_actual->setVisibility();
		$this->lines_in_30cm->setVisibility();
		$this->valuation->setVisibility();
		$this->deduction->setVisibility();
		$this->remark->setVisibility();
		$this->upload->setVisibility();
		$this->uid->Visible = FALSE;
		$this->payment->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->confirm_process);
		$this->setupLookupOptions($this->process_other);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->employee_1);
		$this->setupLookupOptions($this->employee_2);
		$this->setupLookupOptions($this->employee_3);
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->payment);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("process_actionlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->GetAddUrl();
					if (GetPageName($returnUrl) == "process_actionlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "process_actionview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->upload->Upload->Index = $CurrentForm->Index;
		$this->upload->Upload->uploadFile();
		$this->upload->CurrentValue = $this->upload->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->process->CurrentValue = ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
		$this->confirm_process->CurrentValue = ((isset($_GET["prid"]))? $_GET["prid"]:((isset($_COOKIE["prid"]))? $_COOKIE["prid"]:''));
		$this->process_other->CurrentValue = ((isset($_COOKIE["poa"]))? $_COOKIE["poa"]:'');
		$this->location->CurrentValue = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
		$this->godown->CurrentValue = NULL;
		$this->godown->OldValue = $this->godown->CurrentValue;
		$this->code->CurrentValue = NULL;
		$this->code->OldValue = $this->code->CurrentValue;
		$this->code_last->CurrentValue = NULL;
		$this->code_last->OldValue = $this->code_last->CurrentValue;
		$this->employee_1->CurrentValue = ((isset($_COOKIE["PA_LID1"]))? $_COOKIE["PA_LID1"]:'10000');
		$this->employee_2->CurrentValue = 10000;
		$this->employee_3->CurrentValue = 10000;
		$this->employee_id->CurrentValue = NULL;
		$this->employee_id->OldValue = $this->employee_id->CurrentValue;
		$this->qty->CurrentValue = ((isset($_COOKIE["nop"]))? $_COOKIE["nop"]:0);
		$this->roll_no->CurrentValue = ((isset($_COOKIE["rn"]))? $_COOKIE["rn"]:0);
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->size_actual->CurrentValue = NULL;
		$this->size_actual->OldValue = $this->size_actual->CurrentValue;
		$this->weight_actual->CurrentValue = NULL;
		$this->weight_actual->OldValue = $this->weight_actual->CurrentValue;
		$this->lines_in_30cm->CurrentValue = NULL;
		$this->lines_in_30cm->OldValue = $this->lines_in_30cm->CurrentValue;
		$this->valuation->CurrentValue = 0;
		$this->deduction->CurrentValue = 0.00;
		$this->remark->CurrentValue = NULL;
		$this->remark->OldValue = $this->remark->CurrentValue;
		$this->upload->Upload->DbValue = NULL;
		$this->upload->OldValue = $this->upload->Upload->DbValue;
		$this->upload->CurrentValue = NULL; // Clear file related field
		$this->uid->CurrentValue = NULL;
		$this->uid->OldValue = $this->uid->CurrentValue;
		$this->payment->CurrentValue = NULL;
		$this->payment->OldValue = $this->payment->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'confirm_process' first before field var 'x_confirm_process'
		$val = $CurrentForm->hasValue("confirm_process") ? $CurrentForm->getValue("confirm_process") : $CurrentForm->getValue("x_confirm_process");
		if (!$this->confirm_process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->confirm_process->Visible = FALSE; // Disable update for API request
			else
				$this->confirm_process->setFormValue($val);
		}

		// Check field name 'process_other' first before field var 'x_process_other'
		$val = $CurrentForm->hasValue("process_other") ? $CurrentForm->getValue("process_other") : $CurrentForm->getValue("x_process_other");
		if (!$this->process_other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process_other->Visible = FALSE; // Disable update for API request
			else
				$this->process_other->setFormValue($val);
		}

		// Check field name 'location' first before field var 'x_location'
		$val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
		if (!$this->location->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->location->Visible = FALSE; // Disable update for API request
			else
				$this->location->setFormValue($val);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'code' first before field var 'x_code'
		$val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
		if (!$this->code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->code->Visible = FALSE; // Disable update for API request
			else
				$this->code->setFormValue($val);
		}

		// Check field name 'code_last' first before field var 'x_code_last'
		$val = $CurrentForm->hasValue("code_last") ? $CurrentForm->getValue("code_last") : $CurrentForm->getValue("x_code_last");
		if (!$this->code_last->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->code_last->Visible = FALSE; // Disable update for API request
			else
				$this->code_last->setFormValue($val);
		}

		// Check field name 'employee_1' first before field var 'x_employee_1'
		$val = $CurrentForm->hasValue("employee_1") ? $CurrentForm->getValue("employee_1") : $CurrentForm->getValue("x_employee_1");
		if (!$this->employee_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_1->Visible = FALSE; // Disable update for API request
			else
				$this->employee_1->setFormValue($val);
		}

		// Check field name 'employee_2' first before field var 'x_employee_2'
		$val = $CurrentForm->hasValue("employee_2") ? $CurrentForm->getValue("employee_2") : $CurrentForm->getValue("x_employee_2");
		if (!$this->employee_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_2->Visible = FALSE; // Disable update for API request
			else
				$this->employee_2->setFormValue($val);
		}

		// Check field name 'employee_3' first before field var 'x_employee_3'
		$val = $CurrentForm->hasValue("employee_3") ? $CurrentForm->getValue("employee_3") : $CurrentForm->getValue("x_employee_3");
		if (!$this->employee_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_3->Visible = FALSE; // Disable update for API request
			else
				$this->employee_3->setFormValue($val);
		}

		// Check field name 'employee_id' first before field var 'x_employee_id'
		$val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
		if (!$this->employee_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_id->Visible = FALSE; // Disable update for API request
			else
				$this->employee_id->setFormValue($val);
		}

		// Check field name 'qty' first before field var 'x_qty'
		$val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
		if (!$this->qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty->Visible = FALSE; // Disable update for API request
			else
				$this->qty->setFormValue($val);
		}

		// Check field name 'roll_no' first before field var 'x_roll_no'
		$val = $CurrentForm->hasValue("roll_no") ? $CurrentForm->getValue("roll_no") : $CurrentForm->getValue("x_roll_no");
		if (!$this->roll_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->roll_no->Visible = FALSE; // Disable update for API request
			else
				$this->roll_no->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 117);
		}

		// Check field name 'size_actual' first before field var 'x_size_actual'
		$val = $CurrentForm->hasValue("size_actual") ? $CurrentForm->getValue("size_actual") : $CurrentForm->getValue("x_size_actual");
		if (!$this->size_actual->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size_actual->Visible = FALSE; // Disable update for API request
			else
				$this->size_actual->setFormValue($val);
		}

		// Check field name 'weight_actual' first before field var 'x_weight_actual'
		$val = $CurrentForm->hasValue("weight_actual") ? $CurrentForm->getValue("weight_actual") : $CurrentForm->getValue("x_weight_actual");
		if (!$this->weight_actual->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weight_actual->Visible = FALSE; // Disable update for API request
			else
				$this->weight_actual->setFormValue($val);
		}

		// Check field name 'lines_in_30cm' first before field var 'x_lines_in_30cm'
		$val = $CurrentForm->hasValue("lines_in_30cm") ? $CurrentForm->getValue("lines_in_30cm") : $CurrentForm->getValue("x_lines_in_30cm");
		if (!$this->lines_in_30cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lines_in_30cm->Visible = FALSE; // Disable update for API request
			else
				$this->lines_in_30cm->setFormValue($val);
		}

		// Check field name 'valuation' first before field var 'x_valuation'
		$val = $CurrentForm->hasValue("valuation") ? $CurrentForm->getValue("valuation") : $CurrentForm->getValue("x_valuation");
		if (!$this->valuation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->valuation->Visible = FALSE; // Disable update for API request
			else
				$this->valuation->setFormValue($val);
		}

		// Check field name 'deduction' first before field var 'x_deduction'
		$val = $CurrentForm->hasValue("deduction") ? $CurrentForm->getValue("deduction") : $CurrentForm->getValue("x_deduction");
		if (!$this->deduction->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->deduction->Visible = FALSE; // Disable update for API request
			else
				$this->deduction->setFormValue($val);
		}

		// Check field name 'remark' first before field var 'x_remark'
		$val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
		if (!$this->remark->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remark->Visible = FALSE; // Disable update for API request
			else
				$this->remark->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->confirm_process->CurrentValue = $this->confirm_process->FormValue;
		$this->process_other->CurrentValue = $this->process_other->FormValue;
		$this->location->CurrentValue = $this->location->FormValue;
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->code->CurrentValue = $this->code->FormValue;
		$this->code_last->CurrentValue = $this->code_last->FormValue;
		$this->employee_1->CurrentValue = $this->employee_1->FormValue;
		$this->employee_2->CurrentValue = $this->employee_2->FormValue;
		$this->employee_3->CurrentValue = $this->employee_3->FormValue;
		$this->employee_id->CurrentValue = $this->employee_id->FormValue;
		$this->qty->CurrentValue = $this->qty->FormValue;
		$this->roll_no->CurrentValue = $this->roll_no->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 117);
		$this->size_actual->CurrentValue = $this->size_actual->FormValue;
		$this->weight_actual->CurrentValue = $this->weight_actual->FormValue;
		$this->lines_in_30cm->CurrentValue = $this->lines_in_30cm->FormValue;
		$this->valuation->CurrentValue = $this->valuation->FormValue;
		$this->deduction->CurrentValue = $this->deduction->FormValue;
		$this->remark->CurrentValue = $this->remark->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->process->setDbValue($row['process']);
		$this->confirm_process->setDbValue($row['confirm_process']);
		$this->process_other->setDbValue($row['process_other']);
		$this->location->setDbValue($row['location']);
		$this->godown->setDbValue($row['godown']);
		$this->code->setDbValue($row['code']);
		$this->code_last->setDbValue($row['code_last']);
		$this->employee_1->setDbValue($row['employee_1']);
		$this->employee_2->setDbValue($row['employee_2']);
		$this->employee_3->setDbValue($row['employee_3']);
		$this->employee_id->setDbValue($row['employee_id']);
		$this->qty->setDbValue($row['qty']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->size_actual->setDbValue($row['size_actual']);
		$this->weight_actual->setDbValue($row['weight_actual']);
		$this->lines_in_30cm->setDbValue($row['lines_in_30cm']);
		$this->valuation->setDbValue($row['valuation']);
		$this->deduction->setDbValue($row['deduction']);
		$this->remark->setDbValue($row['remark']);
		$this->upload->Upload->DbValue = $row['upload'];
		$this->upload->setDbValue($this->upload->Upload->DbValue);
		$this->uid->setDbValue($row['uid']);
		$this->payment->setDbValue($row['payment']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['process'] = $this->process->CurrentValue;
		$row['confirm_process'] = $this->confirm_process->CurrentValue;
		$row['process_other'] = $this->process_other->CurrentValue;
		$row['location'] = $this->location->CurrentValue;
		$row['godown'] = $this->godown->CurrentValue;
		$row['code'] = $this->code->CurrentValue;
		$row['code_last'] = $this->code_last->CurrentValue;
		$row['employee_1'] = $this->employee_1->CurrentValue;
		$row['employee_2'] = $this->employee_2->CurrentValue;
		$row['employee_3'] = $this->employee_3->CurrentValue;
		$row['employee_id'] = $this->employee_id->CurrentValue;
		$row['qty'] = $this->qty->CurrentValue;
		$row['roll_no'] = $this->roll_no->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['size_actual'] = $this->size_actual->CurrentValue;
		$row['weight_actual'] = $this->weight_actual->CurrentValue;
		$row['lines_in_30cm'] = $this->lines_in_30cm->CurrentValue;
		$row['valuation'] = $this->valuation->CurrentValue;
		$row['deduction'] = $this->deduction->CurrentValue;
		$row['remark'] = $this->remark->CurrentValue;
		$row['upload'] = $this->upload->Upload->DbValue;
		$row['uid'] = $this->uid->CurrentValue;
		$row['payment'] = $this->payment->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->weight_actual->FormValue == $this->weight_actual->CurrentValue && is_numeric(ConvertToFloatString($this->weight_actual->CurrentValue)))
			$this->weight_actual->CurrentValue = ConvertToFloatString($this->weight_actual->CurrentValue);

		// Convert decimal values if posted back
		if ($this->lines_in_30cm->FormValue == $this->lines_in_30cm->CurrentValue && is_numeric(ConvertToFloatString($this->lines_in_30cm->CurrentValue)))
			$this->lines_in_30cm->CurrentValue = ConvertToFloatString($this->lines_in_30cm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->deduction->FormValue == $this->deduction->CurrentValue && is_numeric(ConvertToFloatString($this->deduction->CurrentValue)))
			$this->deduction->CurrentValue = ConvertToFloatString($this->deduction->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// process
		// confirm_process
		// process_other
		// location
		// godown
		// code
		// code_last
		// employee_1
		// employee_2
		// employee_3
		// employee_id
		// qty
		// roll_no
		// operator
		// datetime
		// size_actual
		// weight_actual
		// lines_in_30cm
		// valuation
		// deduction
		// remark
		// upload
		// uid
		// payment

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// confirm_process
			$curVal = strval($this->confirm_process->CurrentValue);
			if ($curVal <> "") {
				$this->confirm_process->ViewValue = $this->confirm_process->lookupCacheOption($curVal);
				if ($this->confirm_process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->confirm_process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->confirm_process->ViewValue = $this->confirm_process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->confirm_process->ViewValue = $this->confirm_process->CurrentValue;
					}
				}
			} else {
				$this->confirm_process->ViewValue = NULL;
			}
			$this->confirm_process->ViewCustomAttributes = "";

			// process_other
			$curVal = strval($this->process_other->CurrentValue);
			if ($curVal <> "") {
				$this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
				if ($this->process_other->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_other->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_other->ViewValue->add($this->process_other->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_other->ViewValue = $this->process_other->CurrentValue;
					}
				}
			} else {
				$this->process_other->ViewValue = NULL;
			}
			$this->process_other->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`= 1 and `id` > 1 && `id` != 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// code_last
			$this->code_last->ViewValue = $this->code_last->CurrentValue;
			$this->code_last->ViewCustomAttributes = "";

			// employee_1
			$curVal = strval($this->employee_1->CurrentValue);
			if ($curVal <> "") {
				$this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
				if ($this->employee_1->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_1->ViewValue = $this->employee_1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_1->ViewValue = $this->employee_1->CurrentValue;
					}
				}
			} else {
				$this->employee_1->ViewValue = NULL;
			}
			$this->employee_1->ViewCustomAttributes = "";

			// employee_2
			$curVal = strval($this->employee_2->CurrentValue);
			if ($curVal <> "") {
				$this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
				if ($this->employee_2->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_2->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_2->ViewValue = $this->employee_2->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_2->ViewValue = $this->employee_2->CurrentValue;
					}
				}
			} else {
				$this->employee_2->ViewValue = NULL;
			}
			$this->employee_2->ViewCustomAttributes = "";

			// employee_3
			$curVal = strval($this->employee_3->CurrentValue);
			if ($curVal <> "") {
				$this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
				if ($this->employee_3->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_3->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->employee_3->ViewValue = $this->employee_3->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_3->ViewValue = $this->employee_3->CurrentValue;
					}
				}
			} else {
				$this->employee_3->ViewValue = NULL;
			}
			$this->employee_3->ViewCustomAttributes = "";

			// employee_id
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->employee_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			$this->employee_id->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 117);
			$this->datetime->ViewCustomAttributes = "";

			// size_actual
			$this->size_actual->ViewValue = $this->size_actual->CurrentValue;
			$this->size_actual->ViewCustomAttributes = "";

			// weight_actual
			$this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
			$this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, 2, -2, -2, -2);
			$this->weight_actual->ViewCustomAttributes = "";

			// lines_in_30cm
			$this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
			$this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, 2, -2, -2, -2);
			$this->lines_in_30cm->ViewCustomAttributes = "";

			// valuation
			if (strval($this->valuation->CurrentValue) <> "") {
				$this->valuation->ViewValue = $this->valuation->optionCaption($this->valuation->CurrentValue);
			} else {
				$this->valuation->ViewValue = NULL;
			}
			$this->valuation->ViewCustomAttributes = "";

			// deduction
			$this->deduction->ViewValue = $this->deduction->CurrentValue;
			$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 2, -2, -2, -2);
			$this->deduction->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// confirm_process
			$this->confirm_process->LinkCustomAttributes = "";
			$this->confirm_process->HrefValue = "";
			$this->confirm_process->TooltipValue = "";

			// process_other
			$this->process_other->LinkCustomAttributes = "";
			$this->process_other->HrefValue = "";
			$this->process_other->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";
			$this->godown->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			if (!EmptyValue($this->code->CurrentValue)) {
				$this->code->HrefValue = "bcodelist.php?x__barcode=" . $this->code->CurrentValue; // Add prefix/suffix
				$this->code->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
			} else {
				$this->code->HrefValue = "";
			}
			$this->code->TooltipValue = "";

			// code_last
			$this->code_last->LinkCustomAttributes = "";
			$this->code_last->HrefValue = "";
			$this->code_last->TooltipValue = "";

			// employee_1
			$this->employee_1->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_1->CurrentValue)) {
				$this->employee_1->HrefValue = "process_actionlist.php?x_emp_name=" . $this->employee_1->CurrentValue; // Add prefix/suffix
				$this->employee_1->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->employee_1->HrefValue = FullUrl($this->employee_1->HrefValue, "href");
			} else {
				$this->employee_1->HrefValue = "";
			}
			$this->employee_1->TooltipValue = "";

			// employee_2
			$this->employee_2->LinkCustomAttributes = "";
			$this->employee_2->HrefValue = "";
			$this->employee_2->TooltipValue = "";

			// employee_3
			$this->employee_3->LinkCustomAttributes = "";
			$this->employee_3->HrefValue = "";
			$this->employee_3->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			$this->employee_id->HrefValue = "";
			$this->employee_id->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// size_actual
			$this->size_actual->LinkCustomAttributes = "";
			$this->size_actual->HrefValue = "";
			$this->size_actual->TooltipValue = "";

			// weight_actual
			$this->weight_actual->LinkCustomAttributes = "";
			$this->weight_actual->HrefValue = "";
			$this->weight_actual->TooltipValue = "";

			// lines_in_30cm
			$this->lines_in_30cm->LinkCustomAttributes = "";
			$this->lines_in_30cm->HrefValue = "";
			$this->lines_in_30cm->TooltipValue = "";

			// valuation
			$this->valuation->LinkCustomAttributes = "";
			$this->valuation->HrefValue = "";
			$this->valuation->TooltipValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";
			$this->deduction->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->Upload->DbValue); // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "process_action_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->CurrentValue));
			if ($curVal <> "")
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `type` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// confirm_process
			$this->confirm_process->EditAttrs["class"] = "form-control";
			$this->confirm_process->EditCustomAttributes = "";
			$curVal = trim(strval($this->confirm_process->CurrentValue));
			if ($curVal <> "")
				$this->confirm_process->ViewValue = $this->confirm_process->lookupCacheOption($curVal);
			else
				$this->confirm_process->ViewValue = $this->confirm_process->Lookup !== NULL && is_array($this->confirm_process->Lookup->Options) ? $curVal : NULL;
			if ($this->confirm_process->ViewValue !== NULL) { // Load from cache
				$this->confirm_process->EditValue = array_values($this->confirm_process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->confirm_process->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->confirm_process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->confirm_process->EditValue = $arwrk;
			}

			// process_other
			$this->process_other->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_other->CurrentValue));
			if ($curVal <> "")
				$this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
			else
				$this->process_other->ViewValue = $this->process_other->Lookup !== NULL && is_array($this->process_other->Lookup->Options) ? $curVal : NULL;
			if ($this->process_other->ViewValue !== NULL) { // Load from cache
				$this->process_other->EditValue = array_values($this->process_other->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_other->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_other->EditValue = $arwrk;
			}

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->CurrentValue));
			if ($curVal <> "")
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->location->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->CurrentValue));
			if ($curVal <> "")
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`= 1 and `id` > 1 && `id` != 10";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = 'autofocus';
			if (REMOVE_XSS)
				$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
			$this->code->EditValue = HtmlEncode($this->code->CurrentValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// code_last
			$this->code_last->EditAttrs["class"] = "form-control";
			$this->code_last->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->code_last->CurrentValue = HtmlDecode($this->code_last->CurrentValue);
			$this->code_last->EditValue = HtmlEncode($this->code_last->CurrentValue);
			$this->code_last->PlaceHolder = RemoveHtml($this->code_last->caption());

			// employee_1
			$this->employee_1->EditAttrs["class"] = "form-control";
			$this->employee_1->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_1->CurrentValue));
			if ($curVal <> "")
				$this->employee_1->ViewValue = $this->employee_1->lookupCacheOption($curVal);
			else
				$this->employee_1->ViewValue = $this->employee_1->Lookup !== NULL && is_array($this->employee_1->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_1->ViewValue !== NULL) { // Load from cache
				$this->employee_1->EditValue = array_values($this->employee_1->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->employee_1->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_1->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_1->EditValue = $arwrk;
			}

			// employee_2
			$this->employee_2->EditAttrs["class"] = "form-control";
			$this->employee_2->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_2->CurrentValue));
			if ($curVal <> "")
				$this->employee_2->ViewValue = $this->employee_2->lookupCacheOption($curVal);
			else
				$this->employee_2->ViewValue = $this->employee_2->Lookup !== NULL && is_array($this->employee_2->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_2->ViewValue !== NULL) { // Load from cache
				$this->employee_2->EditValue = array_values($this->employee_2->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->employee_2->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_2->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_2->EditValue = $arwrk;
			}

			// employee_3
			$this->employee_3->EditAttrs["class"] = "form-control";
			$this->employee_3->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_3->CurrentValue));
			if ($curVal <> "")
				$this->employee_3->ViewValue = $this->employee_3->lookupCacheOption($curVal);
			else
				$this->employee_3->ViewValue = $this->employee_3->Lookup !== NULL && is_array($this->employee_3->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_3->ViewValue !== NULL) { // Load from cache
				$this->employee_3->EditValue = array_values($this->employee_3->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->employee_3->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_3->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_3->EditValue = $arwrk;
			}

			// employee_id
			$this->employee_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_id->CurrentValue));
			if ($curVal <> "")
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			else
				$this->employee_id->ViewValue = $this->employee_id->Lookup !== NULL && is_array($this->employee_id->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_id->ViewValue !== NULL) { // Load from cache
				$this->employee_id->EditValue = array_values($this->employee_id->Lookup->Options);
				if ($this->employee_id->ViewValue == "")
					$this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_id->EditValue = $arwrk;
			}

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->CurrentValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->CurrentValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// operator
			// datetime
			// size_actual

			$this->size_actual->EditAttrs["class"] = "form-control";
			$this->size_actual->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_actual->CurrentValue = HtmlDecode($this->size_actual->CurrentValue);
			$this->size_actual->EditValue = HtmlEncode($this->size_actual->CurrentValue);
			$this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

			// weight_actual
			$this->weight_actual->EditAttrs["class"] = "form-control";
			$this->weight_actual->EditCustomAttributes = "";
			$this->weight_actual->EditValue = HtmlEncode($this->weight_actual->CurrentValue);
			$this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());
			if (strval($this->weight_actual->EditValue) <> "" && is_numeric($this->weight_actual->EditValue))
				$this->weight_actual->EditValue = FormatNumber($this->weight_actual->EditValue, -2, -2, -2, -2);

			// lines_in_30cm
			$this->lines_in_30cm->EditAttrs["class"] = "form-control";
			$this->lines_in_30cm->EditCustomAttributes = "";
			$this->lines_in_30cm->EditValue = HtmlEncode($this->lines_in_30cm->CurrentValue);
			$this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());
			if (strval($this->lines_in_30cm->EditValue) <> "" && is_numeric($this->lines_in_30cm->EditValue))
				$this->lines_in_30cm->EditValue = FormatNumber($this->lines_in_30cm->EditValue, -2, -2, -2, -2);

			// valuation
			$this->valuation->EditAttrs["class"] = "form-control";
			$this->valuation->EditCustomAttributes = "";
			$this->valuation->EditValue = $this->valuation->options(TRUE);

			// deduction
			$this->deduction->EditAttrs["class"] = "form-control";
			$this->deduction->EditCustomAttributes = "";
			$this->deduction->EditValue = HtmlEncode($this->deduction->CurrentValue);
			$this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
			if (strval($this->deduction->EditValue) <> "" && is_numeric($this->deduction->EditValue))
				$this->deduction->EditValue = FormatNumber($this->deduction->EditValue, -2, -2, -2, -2);

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
			$this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// upload
			$this->upload->EditAttrs["class"] = "form-control";
			$this->upload->EditCustomAttributes = "";
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->EditValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->EditValue = "";
			}
			if (!EmptyValue($this->upload->CurrentValue))
					$this->upload->Upload->FileName = $this->upload->CurrentValue;
			if (($this->isShow() || $this->isCopy()) && !$this->EventCancelled)
				RenderUploadField($this->upload);

			// Add refer script
			// process

			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}

			// confirm_process
			$this->confirm_process->LinkCustomAttributes = "";
			$this->confirm_process->HrefValue = "";

			// process_other
			$this->process_other->LinkCustomAttributes = "";
			$this->process_other->HrefValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			if (!EmptyValue($this->code->CurrentValue)) {
				$this->code->HrefValue = "bcodelist.php?x__barcode=" . $this->code->CurrentValue; // Add prefix/suffix
				$this->code->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
			} else {
				$this->code->HrefValue = "";
			}

			// code_last
			$this->code_last->LinkCustomAttributes = "";
			$this->code_last->HrefValue = "";

			// employee_1
			$this->employee_1->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_1->CurrentValue)) {
				$this->employee_1->HrefValue = "process_actionlist.php?x_emp_name=" . $this->employee_1->CurrentValue; // Add prefix/suffix
				$this->employee_1->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->employee_1->HrefValue = FullUrl($this->employee_1->HrefValue, "href");
			} else {
				$this->employee_1->HrefValue = "";
			}

			// employee_2
			$this->employee_2->LinkCustomAttributes = "";
			$this->employee_2->HrefValue = "";

			// employee_3
			$this->employee_3->LinkCustomAttributes = "";
			$this->employee_3->HrefValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			$this->employee_id->HrefValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// size_actual
			$this->size_actual->LinkCustomAttributes = "";
			$this->size_actual->HrefValue = "";

			// weight_actual
			$this->weight_actual->LinkCustomAttributes = "";
			$this->weight_actual->HrefValue = "";

			// lines_in_30cm
			$this->lines_in_30cm->LinkCustomAttributes = "";
			$this->lines_in_30cm->HrefValue = "";

			// valuation
			$this->valuation->LinkCustomAttributes = "";
			$this->valuation->HrefValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->Upload->DbValue); // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->confirm_process->Required) {
			if (!$this->confirm_process->IsDetailKey && $this->confirm_process->FormValue != NULL && $this->confirm_process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->confirm_process->caption(), $this->confirm_process->RequiredErrorMessage));
			}
		}
		if ($this->process_other->Required) {
			if ($this->process_other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_other->caption(), $this->process_other->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->code_last->Required) {
			if (!$this->code_last->IsDetailKey && $this->code_last->FormValue != NULL && $this->code_last->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code_last->caption(), $this->code_last->RequiredErrorMessage));
			}
		}
		if ($this->employee_1->Required) {
			if (!$this->employee_1->IsDetailKey && $this->employee_1->FormValue != NULL && $this->employee_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_1->caption(), $this->employee_1->RequiredErrorMessage));
			}
		}
		if ($this->employee_2->Required) {
			if (!$this->employee_2->IsDetailKey && $this->employee_2->FormValue != NULL && $this->employee_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_2->caption(), $this->employee_2->RequiredErrorMessage));
			}
		}
		if ($this->employee_3->Required) {
			if (!$this->employee_3->IsDetailKey && $this->employee_3->FormValue != NULL && $this->employee_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_3->caption(), $this->employee_3->RequiredErrorMessage));
			}
		}
		if ($this->employee_id->Required) {
			if ($this->employee_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
			}
		}
		if ($this->qty->Required) {
			if (!$this->qty->IsDetailKey && $this->qty->FormValue != NULL && $this->qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
			}
		}
		if ($this->roll_no->Required) {
			if (!$this->roll_no->IsDetailKey && $this->roll_no->FormValue != NULL && $this->roll_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->roll_no->caption(), $this->roll_no->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->size_actual->Required) {
			if (!$this->size_actual->IsDetailKey && $this->size_actual->FormValue != NULL && $this->size_actual->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size_actual->caption(), $this->size_actual->RequiredErrorMessage));
			}
		}
		if ($this->weight_actual->Required) {
			if (!$this->weight_actual->IsDetailKey && $this->weight_actual->FormValue != NULL && $this->weight_actual->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weight_actual->caption(), $this->weight_actual->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->weight_actual->FormValue)) {
			AddMessage($FormError, $this->weight_actual->errorMessage());
		}
		if ($this->lines_in_30cm->Required) {
			if (!$this->lines_in_30cm->IsDetailKey && $this->lines_in_30cm->FormValue != NULL && $this->lines_in_30cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lines_in_30cm->caption(), $this->lines_in_30cm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->lines_in_30cm->FormValue)) {
			AddMessage($FormError, $this->lines_in_30cm->errorMessage());
		}
		if ($this->valuation->Required) {
			if (!$this->valuation->IsDetailKey && $this->valuation->FormValue != NULL && $this->valuation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->valuation->caption(), $this->valuation->RequiredErrorMessage));
			}
		}
		if ($this->deduction->Required) {
			if (!$this->deduction->IsDetailKey && $this->deduction->FormValue != NULL && $this->deduction->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->deduction->caption(), $this->deduction->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->deduction->FormValue)) {
			AddMessage($FormError, $this->deduction->errorMessage());
		}
		if ($this->remark->Required) {
			if (!$this->remark->IsDetailKey && $this->remark->FormValue != NULL && $this->remark->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
			}
		}
		if ($this->upload->Required) {
			if ($this->upload->Upload->FileName == "" && !$this->upload->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->upload->caption(), $this->upload->RequiredErrorMessage));
			}
		}
		if ($this->uid->Required) {
			if (!$this->uid->IsDetailKey && $this->uid->FormValue != NULL && $this->uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
			}
		}
		if ($this->payment->Required) {
			if (!$this->payment->IsDetailKey && $this->payment->FormValue != NULL && $this->payment->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment->caption(), $this->payment->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->upload->OldUploadPath = '.p_uploads/weaving/';
			$this->upload->UploadPath = $this->upload->OldUploadPath;
		}
		$rsnew = [];

		// process
		$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, 0, FALSE);

		// confirm_process
		$this->confirm_process->setDbValueDef($rsnew, $this->confirm_process->CurrentValue, 0, FALSE);

		// process_other
		$this->process_other->setDbValueDef($rsnew, $this->process_other->CurrentValue, NULL, FALSE);

		// location
		$this->location->setDbValueDef($rsnew, $this->location->CurrentValue, 0, FALSE);

		// godown
		$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, NULL, FALSE);

		// code
		$this->code->setDbValueDef($rsnew, $this->code->CurrentValue, "", FALSE);

		// code_last
		$this->code_last->setDbValueDef($rsnew, $this->code_last->CurrentValue, "", FALSE);

		// employee_1
		$this->employee_1->setDbValueDef($rsnew, $this->employee_1->CurrentValue, NULL, FALSE);

		// employee_2
		$this->employee_2->setDbValueDef($rsnew, $this->employee_2->CurrentValue, NULL, FALSE);

		// employee_3
		$this->employee_3->setDbValueDef($rsnew, $this->employee_3->CurrentValue, NULL, FALSE);

		// employee_id
		$this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, NULL, FALSE);

		// qty
		$this->qty->setDbValueDef($rsnew, $this->qty->CurrentValue, NULL, FALSE);

		// roll_no
		$this->roll_no->setDbValueDef($rsnew, $this->roll_no->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// size_actual
		$this->size_actual->setDbValueDef($rsnew, $this->size_actual->CurrentValue, NULL, FALSE);

		// weight_actual
		$this->weight_actual->setDbValueDef($rsnew, $this->weight_actual->CurrentValue, NULL, FALSE);

		// lines_in_30cm
		$this->lines_in_30cm->setDbValueDef($rsnew, $this->lines_in_30cm->CurrentValue, NULL, FALSE);

		// valuation
		$this->valuation->setDbValueDef($rsnew, $this->valuation->CurrentValue, NULL, FALSE);

		// deduction
		$this->deduction->setDbValueDef($rsnew, $this->deduction->CurrentValue, 0, strval($this->deduction->CurrentValue) == "");

		// remark
		$this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, NULL, FALSE);

		// upload
		if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
			$this->upload->Upload->DbValue = ""; // No need to delete old file
			if ($this->upload->Upload->FileName == "") {
				$rsnew['upload'] = NULL;
			} else {
				if ($rsold && $rsold->fields['upload'] <> "" && $this->upload->Upload->FileName <> "") {
					$oldFiles = array($rsold->fields['upload']);
					$newFiles = array($this->upload->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->upload->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->upload, $this->upload->Upload->Index) . $newFiles[$i], UploadTempPath($this->upload, $this->upload->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->upload->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['upload'] = $this->upload->Upload->FileName;
			}
			$this->upload->ImageWidth = 0; // Resize width
			$this->upload->ImageHeight = 640; // Resize height
		}
		if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
			$this->upload->UploadPath = '.p_uploads/weaving/';
			$oldFiles = EmptyValue($this->upload->Upload->DbValue) ? array() : array($this->upload->Upload->DbValue);
			if (!EmptyValue($this->upload->Upload->FileName)) {
				$newFiles = array($this->upload->Upload->FileName);
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->upload, $this->upload->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->upload->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->upload, $this->upload->Upload->Index) . $file1) || file_exists($this->upload->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->upload->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->upload, $this->upload->Upload->Index) . $file, UploadTempPath($this->upload, $this->upload->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->upload->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->upload->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->upload->setDbValueDef($rsnew, $this->upload->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->upload->Upload->DbValue) ? array() : array($this->upload->Upload->DbValue);
					if (!EmptyValue($this->upload->Upload->FileName)) {
						$newFiles = array($this->upload->Upload->FileName);
						$newFiles2 = array($rsnew['upload']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->upload, $this->upload->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->upload->Upload->resizeAndSaveToFile($this->upload->ImageWidth, $this->upload->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// upload
		if ($this->upload->Upload->FileToken <> "")
			CleanUploadTempPath($this->upload->Upload->FileToken, $this->upload->Upload->Index);
		else
			CleanUploadTempPath($this->upload, $this->upload->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_actionlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_process":
					$lookupFilter = function() {
						return "`status` = 1 and `type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_confirm_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_other":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_location":
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return "`status`= 1 and `id` > 1 && `id` != 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_1":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_2":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_3":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_process":
							break;
						case "x_confirm_process":
							break;
						case "x_process_other":
							break;
						case "x_location":
							break;
						case "x_godown":
							break;
						case "x_employee_1":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_2":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_3":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_operator":
							break;
						case "x_payment":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		(isset($_COOKIE["prid"])) ? $prid = $_COOKIE["prid"] : $prid = 0; 
		if ($prid > 0)
		{
			$this->process->ReadOnly = True;
			$this->confirm_process->ReadOnly = True;
		}
			else
		{
			$_SESSION[SESSION_SUCCESS_MESSAGE] = 'Please Click on Prcess from DashBoard to Add';
			header('Location: process_actionlist.php');
			exit;
		}
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	setcookie("Code_s", '');
	setcookie("Code_e", '');
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'process_action');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) 
		{

		// Return error message in CustomError
		extract($_POST,EXTR_OVERWRITE);
		$_SESSION[SESSION_WARNING_MESSAGE] = '';
	if ($x_code != $x_code_last)
		$_SESSION[SESSION_WARNING_MESSAGE].= 'Code and Code End are Different<br>';
	if ($x_process != $x_confirm_process)
		$_SESSION[SESSION_WARNING_MESSAGE].= 'Process and Confirm Process are Different<br>';
	if (($x_process == null) || ($x_process == ''))
		$_SESSION[SESSION_WARNING_MESSAGE].= 'Process Not Selected<br>';
		$emp = ExecuteScalar("SELECT `m_employee` FROM `sub_process_type` where `sub_process_type`.`id` = $x_process");
		if  ($emp == '0' && ($x_employee_1 == null))
		{
		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Employee ID<br>";
		}
		if  ($emp == '1' && ($x_employee_1 == null) || ($x_employee_2 == null) || ($x_employee_3 == null))
		{
		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select All Employee IDs or No Employee<br>";
		}
		if  ($emp == '2' && ($x_employee_id == null))
		{
		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Multiple Employee IDs<br>";
		}
		if  ( ($x_process == '19') && ($x_qty == null))
		{
		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Enter Quantity. (Can\'t be NULL)<br>";
		}
	if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
		{return TRUE;}
		else
		{return false;}
	}	
}
?>