<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_f_add extends process_action_f
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action_f';

	// Page object name
	public $PageObjName = "process_action_f_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action_f)
		if (!isset($GLOBALS["process_action_f"]) || get_class($GLOBALS["process_action_f"]) == PROJECT_NAMESPACE . "process_action_f") {
			$GLOBALS["process_action_f"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action_f"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_f');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action_f;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action_f);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "process_action_fview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_action_flist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->emp_name->setVisibility();
		$this->process->setVisibility();
		$this->code->setVisibility();
		$this->payment->setVisibility();
		$this->material->setVisibility();
		$this->packing->setVisibility();
		$this->lot_no->setVisibility();
		$this->i_quantity->setVisibility();
		$this->sub_process->setVisibility();
		$this->process_method->setVisibility();
		$this->remark->setVisibility();
		$this->opeartor->setVisibility();
		$this->datetime->setVisibility();
		$this->grp->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("process_action_flist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "process_action_flist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "process_action_fview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->emp_name->CurrentValue = NULL;
		$this->emp_name->OldValue = $this->emp_name->CurrentValue;
		$this->process->CurrentValue = NULL;
		$this->process->OldValue = $this->process->CurrentValue;
		$this->code->CurrentValue = NULL;
		$this->code->OldValue = $this->code->CurrentValue;
		$this->payment->CurrentValue = NULL;
		$this->payment->OldValue = $this->payment->CurrentValue;
		$this->material->CurrentValue = NULL;
		$this->material->OldValue = $this->material->CurrentValue;
		$this->packing->CurrentValue = NULL;
		$this->packing->OldValue = $this->packing->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->i_quantity->CurrentValue = NULL;
		$this->i_quantity->OldValue = $this->i_quantity->CurrentValue;
		$this->sub_process->CurrentValue = NULL;
		$this->sub_process->OldValue = $this->sub_process->CurrentValue;
		$this->process_method->CurrentValue = NULL;
		$this->process_method->OldValue = $this->process_method->CurrentValue;
		$this->remark->CurrentValue = NULL;
		$this->remark->OldValue = $this->remark->CurrentValue;
		$this->opeartor->CurrentValue = NULL;
		$this->opeartor->OldValue = $this->opeartor->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}

		// Check field name 'emp_name' first before field var 'x_emp_name'
		$val = $CurrentForm->hasValue("emp_name") ? $CurrentForm->getValue("emp_name") : $CurrentForm->getValue("x_emp_name");
		if (!$this->emp_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emp_name->Visible = FALSE; // Disable update for API request
			else
				$this->emp_name->setFormValue($val);
		}

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'code' first before field var 'x_code'
		$val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
		if (!$this->code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->code->Visible = FALSE; // Disable update for API request
			else
				$this->code->setFormValue($val);
		}

		// Check field name 'payment' first before field var 'x_payment'
		$val = $CurrentForm->hasValue("payment") ? $CurrentForm->getValue("payment") : $CurrentForm->getValue("x_payment");
		if (!$this->payment->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment->Visible = FALSE; // Disable update for API request
			else
				$this->payment->setFormValue($val);
		}

		// Check field name 'material' first before field var 'x_material'
		$val = $CurrentForm->hasValue("material") ? $CurrentForm->getValue("material") : $CurrentForm->getValue("x_material");
		if (!$this->material->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material->Visible = FALSE; // Disable update for API request
			else
				$this->material->setFormValue($val);
		}

		// Check field name 'packing' first before field var 'x_packing'
		$val = $CurrentForm->hasValue("packing") ? $CurrentForm->getValue("packing") : $CurrentForm->getValue("x_packing");
		if (!$this->packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing->Visible = FALSE; // Disable update for API request
			else
				$this->packing->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'i_quantity' first before field var 'x_i_quantity'
		$val = $CurrentForm->hasValue("i_quantity") ? $CurrentForm->getValue("i_quantity") : $CurrentForm->getValue("x_i_quantity");
		if (!$this->i_quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->i_quantity->Visible = FALSE; // Disable update for API request
			else
				$this->i_quantity->setFormValue($val);
		}

		// Check field name 'sub_process' first before field var 'x_sub_process'
		$val = $CurrentForm->hasValue("sub_process") ? $CurrentForm->getValue("sub_process") : $CurrentForm->getValue("x_sub_process");
		if (!$this->sub_process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sub_process->Visible = FALSE; // Disable update for API request
			else
				$this->sub_process->setFormValue($val);
		}

		// Check field name 'process_method' first before field var 'x_process_method'
		$val = $CurrentForm->hasValue("process_method") ? $CurrentForm->getValue("process_method") : $CurrentForm->getValue("x_process_method");
		if (!$this->process_method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process_method->Visible = FALSE; // Disable update for API request
			else
				$this->process_method->setFormValue($val);
		}

		// Check field name 'remark' first before field var 'x_remark'
		$val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
		if (!$this->remark->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remark->Visible = FALSE; // Disable update for API request
			else
				$this->remark->setFormValue($val);
		}

		// Check field name 'opeartor' first before field var 'x_opeartor'
		$val = $CurrentForm->hasValue("opeartor") ? $CurrentForm->getValue("opeartor") : $CurrentForm->getValue("x_opeartor");
		if (!$this->opeartor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->opeartor->Visible = FALSE; // Disable update for API request
			else
				$this->opeartor->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->emp_name->CurrentValue = $this->emp_name->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->code->CurrentValue = $this->code->FormValue;
		$this->payment->CurrentValue = $this->payment->FormValue;
		$this->material->CurrentValue = $this->material->FormValue;
		$this->packing->CurrentValue = $this->packing->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->i_quantity->CurrentValue = $this->i_quantity->FormValue;
		$this->sub_process->CurrentValue = $this->sub_process->FormValue;
		$this->process_method->CurrentValue = $this->process_method->FormValue;
		$this->remark->CurrentValue = $this->remark->FormValue;
		$this->opeartor->CurrentValue = $this->opeartor->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->grp->CurrentValue = $this->grp->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->emp_name->setDbValue($row['emp_name']);
		$this->process->setDbValue($row['process']);
		$this->code->setDbValue($row['code']);
		$this->payment->setDbValue($row['payment']);
		$this->material->setDbValue($row['material']);
		$this->packing->setDbValue($row['packing']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->i_quantity->setDbValue($row['i_quantity']);
		$this->sub_process->setDbValue($row['sub_process']);
		$this->process_method->setDbValue($row['process_method']);
		$this->remark->setDbValue($row['remark']);
		$this->opeartor->setDbValue($row['opeartor']);
		$this->datetime->setDbValue($row['datetime']);
		$this->grp->setDbValue($row['grp']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['emp_name'] = $this->emp_name->CurrentValue;
		$row['process'] = $this->process->CurrentValue;
		$row['code'] = $this->code->CurrentValue;
		$row['payment'] = $this->payment->CurrentValue;
		$row['material'] = $this->material->CurrentValue;
		$row['packing'] = $this->packing->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['i_quantity'] = $this->i_quantity->CurrentValue;
		$row['sub_process'] = $this->sub_process->CurrentValue;
		$row['process_method'] = $this->process_method->CurrentValue;
		$row['remark'] = $this->remark->CurrentValue;
		$row['opeartor'] = $this->opeartor->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->i_quantity->FormValue == $this->i_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->i_quantity->CurrentValue)))
			$this->i_quantity->CurrentValue = ConvertToFloatString($this->i_quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// emp_name
		// process
		// code
		// payment
		// material
		// packing
		// lot_no
		// i_quantity
		// sub_process
		// process_method
		// remark
		// opeartor
		// datetime
		// grp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// emp_name
			$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
			$this->emp_name->ViewCustomAttributes = "";

			// process
			$this->process->ViewValue = $this->process->CurrentValue;
			$this->process->ViewValue = FormatNumber($this->process->ViewValue, 0, -2, -2, -2);
			$this->process->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewValue = FormatNumber($this->code->ViewValue, 0, -2, -2, -2);
			$this->code->ViewCustomAttributes = "";

			// payment
			$this->payment->ViewValue = $this->payment->CurrentValue;
			$this->payment->ViewCustomAttributes = "";

			// material
			$this->material->ViewValue = $this->material->CurrentValue;
			$this->material->ViewValue = FormatNumber($this->material->ViewValue, 0, -2, -2, -2);
			$this->material->ViewCustomAttributes = "";

			// packing
			$this->packing->ViewValue = $this->packing->CurrentValue;
			$this->packing->ViewValue = FormatNumber($this->packing->ViewValue, 0, -2, -2, -2);
			$this->packing->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// i_quantity
			$this->i_quantity->ViewValue = $this->i_quantity->CurrentValue;
			$this->i_quantity->ViewValue = FormatNumber($this->i_quantity->ViewValue, 2, -2, -2, -2);
			$this->i_quantity->ViewCustomAttributes = "";

			// sub_process
			$this->sub_process->ViewValue = $this->sub_process->CurrentValue;
			$this->sub_process->ViewValue = FormatNumber($this->sub_process->ViewValue, 0, -2, -2, -2);
			$this->sub_process->ViewCustomAttributes = "";

			// process_method
			$this->process_method->ViewValue = $this->process_method->CurrentValue;
			$this->process_method->ViewValue = FormatNumber($this->process_method->ViewValue, 0, -2, -2, -2);
			$this->process_method->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// opeartor
			$this->opeartor->ViewValue = $this->opeartor->CurrentValue;
			$this->opeartor->ViewValue = FormatNumber($this->opeartor->ViewValue, 0, -2, -2, -2);
			$this->opeartor->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			$this->emp_name->HrefValue = "";
			$this->emp_name->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";
			$this->payment->TooltipValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";
			$this->material->TooltipValue = "";

			// packing
			$this->packing->LinkCustomAttributes = "";
			$this->packing->HrefValue = "";
			$this->packing->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// i_quantity
			$this->i_quantity->LinkCustomAttributes = "";
			$this->i_quantity->HrefValue = "";
			$this->i_quantity->TooltipValue = "";

			// sub_process
			$this->sub_process->LinkCustomAttributes = "";
			$this->sub_process->HrefValue = "";
			$this->sub_process->TooltipValue = "";

			// process_method
			$this->process_method->LinkCustomAttributes = "";
			$this->process_method->HrefValue = "";
			$this->process_method->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// opeartor
			$this->opeartor->LinkCustomAttributes = "";
			$this->opeartor->HrefValue = "";
			$this->opeartor->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->id->CurrentValue = HtmlDecode($this->id->CurrentValue);
			$this->id->EditValue = HtmlEncode($this->id->CurrentValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// emp_name
			$this->emp_name->EditAttrs["class"] = "form-control";
			$this->emp_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->emp_name->CurrentValue = HtmlDecode($this->emp_name->CurrentValue);
			$this->emp_name->EditValue = HtmlEncode($this->emp_name->CurrentValue);
			$this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$this->process->EditValue = HtmlEncode($this->process->CurrentValue);
			$this->process->PlaceHolder = RemoveHtml($this->process->caption());

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			$this->code->EditValue = HtmlEncode($this->code->CurrentValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// payment
			$this->payment->EditAttrs["class"] = "form-control";
			$this->payment->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment->CurrentValue = HtmlDecode($this->payment->CurrentValue);
			$this->payment->EditValue = HtmlEncode($this->payment->CurrentValue);
			$this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

			// material
			$this->material->EditAttrs["class"] = "form-control";
			$this->material->EditCustomAttributes = "";
			$this->material->EditValue = HtmlEncode($this->material->CurrentValue);
			$this->material->PlaceHolder = RemoveHtml($this->material->caption());

			// packing
			$this->packing->EditAttrs["class"] = "form-control";
			$this->packing->EditCustomAttributes = "";
			$this->packing->EditValue = HtmlEncode($this->packing->CurrentValue);
			$this->packing->PlaceHolder = RemoveHtml($this->packing->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// i_quantity
			$this->i_quantity->EditAttrs["class"] = "form-control";
			$this->i_quantity->EditCustomAttributes = "";
			$this->i_quantity->EditValue = HtmlEncode($this->i_quantity->CurrentValue);
			$this->i_quantity->PlaceHolder = RemoveHtml($this->i_quantity->caption());
			if (strval($this->i_quantity->EditValue) <> "" && is_numeric($this->i_quantity->EditValue))
				$this->i_quantity->EditValue = FormatNumber($this->i_quantity->EditValue, -2, -2, -2, -2);

			// sub_process
			$this->sub_process->EditAttrs["class"] = "form-control";
			$this->sub_process->EditCustomAttributes = "";
			$this->sub_process->EditValue = HtmlEncode($this->sub_process->CurrentValue);
			$this->sub_process->PlaceHolder = RemoveHtml($this->sub_process->caption());

			// process_method
			$this->process_method->EditAttrs["class"] = "form-control";
			$this->process_method->EditCustomAttributes = "";
			$this->process_method->EditValue = HtmlEncode($this->process_method->CurrentValue);
			$this->process_method->PlaceHolder = RemoveHtml($this->process_method->caption());

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
			$this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// opeartor
			$this->opeartor->EditAttrs["class"] = "form-control";
			$this->opeartor->EditCustomAttributes = "";
			$this->opeartor->EditValue = HtmlEncode($this->opeartor->CurrentValue);
			$this->opeartor->PlaceHolder = RemoveHtml($this->opeartor->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = HtmlEncode($this->grp->CurrentValue);
			$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			$this->emp_name->HrefValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";

			// packing
			$this->packing->LinkCustomAttributes = "";
			$this->packing->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// i_quantity
			$this->i_quantity->LinkCustomAttributes = "";
			$this->i_quantity->HrefValue = "";

			// sub_process
			$this->sub_process->LinkCustomAttributes = "";
			$this->sub_process->HrefValue = "";

			// process_method
			$this->process_method->LinkCustomAttributes = "";
			$this->process_method->HrefValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";

			// opeartor
			$this->opeartor->LinkCustomAttributes = "";
			$this->opeartor->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id->FormValue)) {
			AddMessage($FormError, $this->id->errorMessage());
		}
		if ($this->emp_name->Required) {
			if (!$this->emp_name->IsDetailKey && $this->emp_name->FormValue != NULL && $this->emp_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emp_name->caption(), $this->emp_name->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->emp_name->FormValue)) {
			AddMessage($FormError, $this->emp_name->errorMessage());
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->process->FormValue)) {
			AddMessage($FormError, $this->process->errorMessage());
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->code->FormValue)) {
			AddMessage($FormError, $this->code->errorMessage());
		}
		if ($this->payment->Required) {
			if (!$this->payment->IsDetailKey && $this->payment->FormValue != NULL && $this->payment->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment->caption(), $this->payment->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->payment->FormValue)) {
			AddMessage($FormError, $this->payment->errorMessage());
		}
		if ($this->material->Required) {
			if (!$this->material->IsDetailKey && $this->material->FormValue != NULL && $this->material->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material->caption(), $this->material->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->material->FormValue)) {
			AddMessage($FormError, $this->material->errorMessage());
		}
		if ($this->packing->Required) {
			if (!$this->packing->IsDetailKey && $this->packing->FormValue != NULL && $this->packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing->caption(), $this->packing->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->packing->FormValue)) {
			AddMessage($FormError, $this->packing->errorMessage());
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->lot_no->FormValue)) {
			AddMessage($FormError, $this->lot_no->errorMessage());
		}
		if ($this->i_quantity->Required) {
			if (!$this->i_quantity->IsDetailKey && $this->i_quantity->FormValue != NULL && $this->i_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->i_quantity->caption(), $this->i_quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->i_quantity->FormValue)) {
			AddMessage($FormError, $this->i_quantity->errorMessage());
		}
		if ($this->sub_process->Required) {
			if (!$this->sub_process->IsDetailKey && $this->sub_process->FormValue != NULL && $this->sub_process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sub_process->caption(), $this->sub_process->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->sub_process->FormValue)) {
			AddMessage($FormError, $this->sub_process->errorMessage());
		}
		if ($this->process_method->Required) {
			if (!$this->process_method->IsDetailKey && $this->process_method->FormValue != NULL && $this->process_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_method->caption(), $this->process_method->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->process_method->FormValue)) {
			AddMessage($FormError, $this->process_method->errorMessage());
		}
		if ($this->remark->Required) {
			if (!$this->remark->IsDetailKey && $this->remark->FormValue != NULL && $this->remark->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
			}
		}
		if ($this->opeartor->Required) {
			if (!$this->opeartor->IsDetailKey && $this->opeartor->FormValue != NULL && $this->opeartor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->opeartor->caption(), $this->opeartor->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->opeartor->FormValue)) {
			AddMessage($FormError, $this->opeartor->errorMessage());
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->datetime->FormValue)) {
			AddMessage($FormError, $this->datetime->errorMessage());
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->grp->FormValue)) {
			AddMessage($FormError, $this->grp->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// id
		$this->id->setDbValueDef($rsnew, $this->id->CurrentValue, "", FALSE);

		// emp_name
		$this->emp_name->setDbValueDef($rsnew, $this->emp_name->CurrentValue, "", FALSE);

		// process
		$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, 0, FALSE);

		// code
		$this->code->setDbValueDef($rsnew, $this->code->CurrentValue, 0, FALSE);

		// payment
		$this->payment->setDbValueDef($rsnew, $this->payment->CurrentValue, NULL, FALSE);

		// material
		$this->material->setDbValueDef($rsnew, $this->material->CurrentValue, 0, FALSE);

		// packing
		$this->packing->setDbValueDef($rsnew, $this->packing->CurrentValue, 0, FALSE);

		// lot_no
		$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, "", FALSE);

		// i_quantity
		$this->i_quantity->setDbValueDef($rsnew, $this->i_quantity->CurrentValue, 0, FALSE);

		// sub_process
		$this->sub_process->setDbValueDef($rsnew, $this->sub_process->CurrentValue, 0, FALSE);

		// process_method
		$this->process_method->setDbValueDef($rsnew, $this->process_method->CurrentValue, 0, FALSE);

		// remark
		$this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, NULL, FALSE);

		// opeartor
		$this->opeartor->setDbValueDef($rsnew, $this->opeartor->CurrentValue, 0, FALSE);

		// datetime
		$this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, 0), CurrentDate(), FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['id']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter();
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_action_flist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			$this->grp->ReadOnly=true;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>