<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for process_action_material
 */
class process_action_material extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $site;
	public $process;
	public $sub_process;
	public $emp_name;
	public $jc_no;
	public $grp;
	public $s_grp;
	public $product;
	public $rid_1;
	public $packing;
	public $rid_2;
	public $rid;
	public $godown;
	public $avg_quantity;
	public $lot_no;
	public $avialable_qty;
	public $ply;
	public $rid_new;
	public $rid_new_lot_no;
	public $poid_new;
	public $poid_1;
	public $poid;
	public $quantity;
	public $packets;
	public $process_method;
	public $payment;
	public $remark;
	public $dated;
	public $opeartor;
	public $datetime;
	public $company_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'process_action_material';
		$this->TableName = 'process_action_material';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`process_action_material`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('process_action_material', 'process_action_material', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// site
		$this->site = new DbField('process_action_material', 'process_action_material', 'x_site', 'site', '`site`', '`site`', 2, -1, FALSE, '`site`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->site->Nullable = FALSE; // NOT NULL field
		$this->site->Required = TRUE; // Required field
		$this->site->Sortable = TRUE; // Allow sort
		$this->site->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->site->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->site->Lookup = new Lookup('site', 'godown_table', FALSE, 'id', ["name","code","",""], [], ["x_emp_name","x_rid_1","x_rid_2"], [], [], [], [], '`name` ASC', '');
		$this->site->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['site'] = &$this->site;

		// process
		$this->process = new DbField('process_action_material', 'process_action_material', 'x_process', 'process', '`process`', '`process`', 2, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Nullable = FALSE; // NOT NULL field
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process->Lookup = new Lookup('process', 'sub_process_type', TRUE, 'id', ["name","","",""], [], ["x_emp_name","x_jc_no"], [], [], [], [], '`name` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// sub_process
		$this->sub_process = new DbField('process_action_material', 'process_action_material', 'x_sub_process', 'sub_process', '`sub_process`', '`sub_process`', 18, -1, FALSE, '`sub_process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->sub_process->Nullable = FALSE; // NOT NULL field
		$this->sub_process->Required = TRUE; // Required field
		$this->sub_process->Sortable = TRUE; // Allow sort
		$this->sub_process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->sub_process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->sub_process->Lookup = new Lookup('sub_process', 'packing_type_table', FALSE, 'id', ["packing","code","",""], [], ["x_poid_1[]"], [], [], [], [], '`packing` ASC', '');
		$this->sub_process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sub_process'] = &$this->sub_process;

		// emp_name
		$this->emp_name = new DbField('process_action_material', 'process_action_material', 'x_emp_name', 'emp_name', '`emp_name`', '`emp_name`', 200, -1, FALSE, '`emp_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->emp_name->Nullable = FALSE; // NOT NULL field
		$this->emp_name->Required = TRUE; // Required field
		$this->emp_name->Sortable = TRUE; // Allow sort
		$this->emp_name->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->emp_name->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->emp_name->Lookup = new Lookup('emp_name', 'production_employee_view_pw', TRUE, 'id', ["id","user_name","",""], ["x_process","x_site"], [], ["process","site"], ["x_process","x_site"], [], [], '`id` ASC', '');
		$this->fields['emp_name'] = &$this->emp_name;

		// jc_no
		$this->jc_no = new DbField('process_action_material', 'process_action_material', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 19, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->jc_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->jc_no->Lookup = new Lookup('jc_no', 'job_card', FALSE, 'id', ["jc_no","product_code","",""], ["x_process"], [], ["pro_unit"], ["x_pro_unit"], ["grp","s_grp","product","packing_type"], ["x_grp","x_s_grp","x_product","x_packing"], '`item` ASC', '');
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// grp
		$this->grp = new DbField('process_action_material', 'process_action_material', 'x_grp', 'grp', '`grp`', '`grp`', 17, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('process_action_material', 'process_action_material', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 2, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('process_action_material', 'process_action_material', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = FALSE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid_1","x_rid_2"], ["s_grp"], ["x_s_grp[]"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid_1
		$this->rid_1 = new DbField('process_action_material', 'process_action_material', 'x_rid_1', 'rid_1', '\' \'', '\' \'', 200, -1, FALSE, '\' \'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid_1->IsCustom = TRUE; // Custom field
		$this->rid_1->Sortable = FALSE; // Allow sort
		$this->rid_1->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid_1->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid_1->Lookup = new Lookup('rid_1', 'stock_lcgp', FALSE, 'id', ["packing_type_n","lot_no","Balance","product_code"], ["x_product","x_site"], [], ["product","godown"], ["x_product","x_godown"], ["packing_type","rid","godown","avg_quantity","lot_no","Balance"], ["x_packing","x_rid","x_godown","x_avg_quantity","x_lot_no","x_avialable_qty"], '`product_code` ASC', '');
		$this->fields['rid_1'] = &$this->rid_1;

		// packing
		$this->packing = new DbField('process_action_material', 'process_action_material', 'x_packing', 'packing', '`packing`', '`packing`', 18, -1, FALSE, '`packing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing->Nullable = FALSE; // NOT NULL field
		$this->packing->Required = TRUE; // Required field
		$this->packing->Sortable = TRUE; // Allow sort
		$this->packing->Lookup = new Lookup('packing', 'packing_type_table', TRUE, 'id', ["code","packing","",""], [], ["x_rid_2"], [], [], [], [], '`packing` ASC', '');
		$this->packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing'] = &$this->packing;

		// rid_2
		$this->rid_2 = new DbField('process_action_material', 'process_action_material', 'x_rid_2', 'rid_2', '`rid_2`', '`rid_2`', 200, -1, FALSE, '`rid_2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid_2->Sortable = FALSE; // Allow sort
		$this->rid_2->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid_2->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid_2->Lookup = new Lookup('rid_2', 'stock_lcgp', FALSE, 'id', ["product_code","packing_type_n","lot_no","Balance"], ["x_product","x_site","x_packing"], [], ["product","godown","packing_type"], ["x_product","x_godown","x_packing_type"], ["rid","godown","avg_quantity","lot_no","Balance"], ["x_rid","x_godown","x_avg_quantity","x_lot_no","x_avialable_qty"], '`product_code` ASC', '');
		$this->fields['rid_2'] = &$this->rid_2;

		// rid
		$this->rid = new DbField('process_action_material', 'process_action_material', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`EV__rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], [], ["x_poid_1[]"], [], [], [], [], '`product_code` ASC', '');
		$this->fields['rid'] = &$this->rid;

		// godown
		$this->godown = new DbField('process_action_material', 'process_action_material', 'x_godown', 'godown', '`godown`', '`godown`', 18, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown->Nullable = FALSE; // NOT NULL field
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = FALSE; // Allow sort
		$this->godown->Lookup = new Lookup('godown', 'godown', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// avg_quantity
		$this->avg_quantity = new DbField('process_action_material', 'process_action_material', 'x_avg_quantity', 'avg_quantity', '0.00', '0.00', 131, -1, FALSE, '0.00', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->IsCustom = TRUE; // Custom field
		$this->avg_quantity->Sortable = TRUE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// lot_no
		$this->lot_no = new DbField('process_action_material', 'process_action_material', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Nullable = FALSE; // NOT NULL field
		$this->lot_no->Required = TRUE; // Required field
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// avialable_qty
		$this->avialable_qty = new DbField('process_action_material', 'process_action_material', 'x_avialable_qty', 'avialable_qty', '0.000', '0.000', 131, -1, FALSE, '0.000', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avialable_qty->IsCustom = TRUE; // Custom field
		$this->avialable_qty->Sortable = TRUE; // Allow sort
		$this->avialable_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['avialable_qty'] = &$this->avialable_qty;

		// ply
		$this->ply = new DbField('process_action_material', 'process_action_material', 'x_ply', 'ply', '`ply`', '`ply`', 18, -1, FALSE, '`ply`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ply->Sortable = TRUE; // Allow sort
		$this->ply->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ply'] = &$this->ply;

		// rid_new
		$this->rid_new = new DbField('process_action_material', 'process_action_material', 'x_rid_new', 'rid_new', '`rid_new`', '`rid_new`', 2, -1, FALSE, '`rid_new`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid_new->Sortable = TRUE; // Allow sort
		$this->rid_new->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid_new->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid_new->Lookup = new Lookup('rid_new', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->rid_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid_new'] = &$this->rid_new;

		// rid_new_lot_no
		$this->rid_new_lot_no = new DbField('process_action_material', 'process_action_material', 'x_rid_new_lot_no', 'rid_new_lot_no', '`rid_new_lot_no`', '`rid_new_lot_no`', 200, -1, FALSE, '`rid_new_lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid_new_lot_no->Sortable = TRUE; // Allow sort
		$this->fields['rid_new_lot_no'] = &$this->rid_new_lot_no;

		// poid_new
		$this->poid_new = new DbField('process_action_material', 'process_action_material', 'x_poid_new', 'poid_new', '\'\'', '\'\'', 201, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->poid_new->IsCustom = TRUE; // Custom field
		$this->poid_new->Sortable = FALSE; // Allow sort
		$this->fields['poid_new'] = &$this->poid_new;

		// poid_1
		$this->poid_1 = new DbField('process_action_material', 'process_action_material', 'x_poid_1', 'poid_1', '\'\'', '\'\'', 201, -1, FALSE, '\'\'', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->poid_1->IsCustom = TRUE; // Custom field
		$this->poid_1->Sortable = FALSE; // Allow sort
		$this->poid_1->Lookup = new Lookup('poid_1', 'po_pending_wbc', FALSE, 'id', ["po","jc_no","product_code","pending_qty"], ["x_rid","x_sub_process"], [], ["rid","packing_type"], ["x_rid","x_packing_type"], [], [], '`id` ASC', '<span class="text-info">PO : {{:df1}}, {{:df2}}, Code : {{:df3}}, Qty : {{:df4}}</span>');
		$this->fields['poid_1'] = &$this->poid_1;

		// poid
		$this->poid = new DbField('process_action_material', 'process_action_material', 'x_poid', 'poid', '`poid`', '`poid`', 200, -1, FALSE, '`poid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->poid->Sortable = TRUE; // Allow sort
		$this->fields['poid'] = &$this->poid;

		// quantity
		$this->quantity = new DbField('process_action_material', 'process_action_material', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// packets
		$this->packets = new DbField('process_action_material', 'process_action_material', 'x_packets', 'packets', '`packets`', '`packets`', 131, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packets'] = &$this->packets;

		// process_method
		$this->process_method = new DbField('process_action_material', 'process_action_material', 'x_process_method', 'process_method', '`process_method`', '`process_method`', 18, -1, FALSE, '`process_method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process_method->Nullable = FALSE; // NOT NULL field
		$this->process_method->Required = TRUE; // Required field
		$this->process_method->Sortable = TRUE; // Allow sort
		$this->process_method->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process_method->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process_method->Lookup = new Lookup('process_method', 'process_action_material', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->process_method->OptionCount = 2;
		$this->process_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_method'] = &$this->process_method;

		// payment
		$this->payment = new DbField('process_action_material', 'process_action_material', 'x_payment', 'payment', '`payment`', '`payment`', 200, -1, FALSE, '`payment`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment->Required = TRUE; // Required field
		$this->payment->Sortable = TRUE; // Allow sort
		$this->payment->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment->Lookup = new Lookup('payment', 'payment_period', FALSE, 'id', ["payment_description","","",""], [], [], [], [], [], [], '`payment_description` ASC', '');
		$this->payment->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['payment'] = &$this->payment;

		// remark
		$this->remark = new DbField('process_action_material', 'process_action_material', 'x_remark', 'remark', '`remark`', '`remark`', 200, -1, FALSE, '`remark`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remark->Sortable = FALSE; // Allow sort
		$this->fields['remark'] = &$this->remark;

		// dated
		$this->dated = new DbField('process_action_material', 'process_action_material', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 133, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Nullable = FALSE; // NOT NULL field
		$this->dated->Required = TRUE; // Required field
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// opeartor
		$this->opeartor = new DbField('process_action_material', 'process_action_material', 'x_opeartor', 'opeartor', '`opeartor`', '`opeartor`', 2, -1, FALSE, '`opeartor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->opeartor->Nullable = FALSE; // NOT NULL field
		$this->opeartor->Sortable = TRUE; // Allow sort
		$this->opeartor->Lookup = new Lookup('opeartor', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->opeartor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['opeartor'] = &$this->opeartor;

		// datetime
		$this->datetime = new DbField('process_action_material', 'process_action_material', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// company_id
		$this->company_id = new DbField('process_action_material', 'process_action_material', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Sortable = FALSE; // Allow sort
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`process_action_material`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, ' ' AS `rid_1`, 0.00 AS `avg_quantity`, 0.000 AS `avialable_qty`, '' AS `poid_new`, '' AS `poid_1` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, ' ' AS `rid_1`, 0.00 AS `avg_quantity`, 0.000 AS `avialable_qty`, '' AS `poid_new`, '' AS `poid_1`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `process_action_material`.`rid` LIMIT 1) AS `EV__rid` FROM `process_action_material`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site()  == 0)? "" : "FIND_IN_SET(`site`, '" . User_Site() . "')";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->site->DbValue = $row['site'];
		$this->process->DbValue = $row['process'];
		$this->sub_process->DbValue = $row['sub_process'];
		$this->emp_name->DbValue = $row['emp_name'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid_1->DbValue = $row['rid_1'];
		$this->packing->DbValue = $row['packing'];
		$this->rid_2->DbValue = $row['rid_2'];
		$this->rid->DbValue = $row['rid'];
		$this->godown->DbValue = $row['godown'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->avialable_qty->DbValue = $row['avialable_qty'];
		$this->ply->DbValue = $row['ply'];
		$this->rid_new->DbValue = $row['rid_new'];
		$this->rid_new_lot_no->DbValue = $row['rid_new_lot_no'];
		$this->poid_new->DbValue = $row['poid_new'];
		$this->poid_1->DbValue = $row['poid_1'];
		$this->poid->DbValue = $row['poid'];
		$this->quantity->DbValue = $row['quantity'];
		$this->packets->DbValue = $row['packets'];
		$this->process_method->DbValue = $row['process_method'];
		$this->payment->DbValue = $row['payment'];
		$this->remark->DbValue = $row['remark'];
		$this->dated->DbValue = $row['dated'];
		$this->opeartor->DbValue = $row['opeartor'];
		$this->datetime->DbValue = $row['datetime'];
		$this->company_id->DbValue = $row['company_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "process_action_materiallist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "process_action_materialview.php")
			return $Language->phrase("View");
		elseif ($pageName == "process_action_materialedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "process_action_materialadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "process_action_materiallist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("process_action_materialview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("process_action_materialview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "process_action_materialadd.php?" . $this->getUrlParm($parm);
		else
			$url = "process_action_materialadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("process_action_materialedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("process_action_materialadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("process_action_materialdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->site->setDbValue($rs->fields('site'));
		$this->process->setDbValue($rs->fields('process'));
		$this->sub_process->setDbValue($rs->fields('sub_process'));
		$this->emp_name->setDbValue($rs->fields('emp_name'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid_1->setDbValue($rs->fields('rid_1'));
		$this->packing->setDbValue($rs->fields('packing'));
		$this->rid_2->setDbValue($rs->fields('rid_2'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->avialable_qty->setDbValue($rs->fields('avialable_qty'));
		$this->ply->setDbValue($rs->fields('ply'));
		$this->rid_new->setDbValue($rs->fields('rid_new'));
		$this->rid_new_lot_no->setDbValue($rs->fields('rid_new_lot_no'));
		$this->poid_new->setDbValue($rs->fields('poid_new'));
		$this->poid_1->setDbValue($rs->fields('poid_1'));
		$this->poid->setDbValue($rs->fields('poid'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->process_method->setDbValue($rs->fields('process_method'));
		$this->payment->setDbValue($rs->fields('payment'));
		$this->remark->setDbValue($rs->fields('remark'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->opeartor->setDbValue($rs->fields('opeartor'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->company_id->setDbValue($rs->fields('company_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// site
		// process
		// sub_process

		$this->sub_process->CellCssStyle = "white-space: nowrap;";

		// emp_name
		// jc_no
		// grp

		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// product
		$this->product->CellCssStyle = "white-space: nowrap;";

		// rid_1
		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// packing
		$this->packing->CellCssStyle = "white-space: nowrap;";

		// rid_2
		$this->rid_2->CellCssStyle = "white-space: nowrap;";

		// rid
		// godown

		$this->godown->CellCssStyle = "white-space: nowrap;";

		// avg_quantity
		$this->avg_quantity->CellCssStyle = "white-space: nowrap;";

		// lot_no
		$this->lot_no->CellCssStyle = "white-space: nowrap;";

		// avialable_qty
		// ply
		// rid_new
		// rid_new_lot_no
		// poid_new
		// poid_1

		$this->poid_1->CellCssStyle = "white-space: nowrap;";

		// poid
		$this->poid->CellCssStyle = "white-space: nowrap;";

		// quantity
		// packets

		$this->packets->CellCssStyle = "white-space: nowrap;";

		// process_method
		// payment

		$this->payment->CellCssStyle = "white-space: nowrap;";

		// remark
		$this->remark->CellCssStyle = "white-space: nowrap;";

		// dated
		// opeartor
		// datetime
		// company_id

		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// site
		$curVal = strval($this->site->CurrentValue);
		if ($curVal <> "") {
			$this->site->ViewValue = $this->site->lookupCacheOption($curVal);
			if ($this->site->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site() == 0) ? "`status` = 1 and `id` > 0 && `id` != 10" : "`status` = 1 and `id` > 0 && `id` != 10 and FIND_IN_SET(`id`,". User_Site() .")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->site->ViewValue = $this->site->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->site->ViewValue = $this->site->CurrentValue;
				}
			}
		} else {
			$this->site->ViewValue = NULL;
		}
		$this->site->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `type_cat` = 101";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// sub_process
		$curVal = strval($this->sub_process->CurrentValue);
		if ($curVal <> "") {
			$this->sub_process->ViewValue = $this->sub_process->lookupCacheOption($curVal);
			if ($this->sub_process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return " `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->sub_process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->sub_process->ViewValue = $this->sub_process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->sub_process->ViewValue = $this->sub_process->CurrentValue;
				}
			}
		} else {
			$this->sub_process->ViewValue = NULL;
		}
		$this->sub_process->ViewCustomAttributes = "";

		// emp_name
		$curVal = strval($this->emp_name->CurrentValue);
		if ($curVal <> "") {
			$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
			if ($this->emp_name->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->emp_name->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
				}
			}
		} else {
			$this->emp_name->ViewValue = NULL;
		}
		$this->emp_name->ViewCustomAttributes = "";

		// jc_no
		$curVal = strval($this->jc_no->CurrentValue);
		if ($curVal <> "") {
			$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
			if ($this->jc_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
				}
			}
		} else {
			$this->jc_no->ViewValue = NULL;
		}
		$this->jc_no->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `type`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid_1
		$curVal = strval($this->rid_1->CurrentValue);
		if ($curVal <> "") {
			$this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
			if ($this->rid_1->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
					$arwrk[4] = $rswrk->fields('df4');
					$this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
				}
			}
		} else {
			$this->rid_1->ViewValue = NULL;
		}
		$this->rid_1->ViewCustomAttributes = "";

		// packing
		$this->packing->ViewValue = $this->packing->CurrentValue;
		$curVal = strval($this->packing->CurrentValue);
		if ($curVal <> "") {
			$this->packing->ViewValue = $this->packing->lookupCacheOption($curVal);
			if ($this->packing->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing->ViewValue = $this->packing->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing->ViewValue = $this->packing->CurrentValue;
				}
			}
		} else {
			$this->packing->ViewValue = NULL;
		}
		$this->packing->ViewCustomAttributes = "";

		// rid_2
		$curVal = strval($this->rid_2->CurrentValue);
		if ($curVal <> "") {
			$this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
			if ($this->rid_2->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$lookupFilter = function() {
					return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_2->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
					$this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_2->ViewValue = $this->rid_2->CurrentValue;
				}
			}
		} else {
			$this->rid_2->ViewValue = NULL;
		}
		$this->rid_2->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
			$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// godown
		$this->godown->ViewValue = $this->godown->CurrentValue;
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 2, -2, -2, -2);
		$this->avg_quantity->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// avialable_qty
		$this->avialable_qty->ViewValue = $this->avialable_qty->CurrentValue;
		$this->avialable_qty->ViewValue = FormatNumber($this->avialable_qty->ViewValue, 4, -2, -2, 0);
		$this->avialable_qty->ViewCustomAttributes = "";

		// ply
		$this->ply->ViewValue = $this->ply->CurrentValue;
		$this->ply->ViewValue = FormatNumber($this->ply->ViewValue, 0, -2, -2, -2);
		$this->ply->ViewCustomAttributes = "";

		// rid_new
		$curVal = strval($this->rid_new->CurrentValue);
		if ($curVal <> "") {
			$this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
			if ($this->rid_new->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `product` = 51";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_new->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid_new->ViewValue = $this->rid_new->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_new->ViewValue = $this->rid_new->CurrentValue;
				}
			}
		} else {
			$this->rid_new->ViewValue = NULL;
		}
		$this->rid_new->ViewCustomAttributes = "";

		// rid_new_lot_no
		$this->rid_new_lot_no->ViewValue = $this->rid_new_lot_no->CurrentValue;
		$this->rid_new_lot_no->ViewCustomAttributes = "";

		// poid_new
		$this->poid_new->ViewValue = $this->poid_new->CurrentValue;
		$this->poid_new->ViewCustomAttributes = "";

		// poid_1
		$curVal = strval($this->poid_1->CurrentValue);
		if ($curVal <> "") {
			$this->poid_1->ViewValue = $this->poid_1->lookupCacheOption($curVal);
			if ($this->poid_1->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`pending_qty`>0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->poid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->poid_1->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->poid_1->ViewValue->add($this->poid_1->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->poid_1->ViewValue = $this->poid_1->CurrentValue;
				}
			}
		} else {
			$this->poid_1->ViewValue = NULL;
		}
		$this->poid_1->ViewCustomAttributes = "";

		// poid
		$this->poid->ViewValue = $this->poid->CurrentValue;
		$this->poid->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 2, -2, -2, -2);
		$this->packets->ViewCustomAttributes = "";

		// process_method
		if (strval($this->process_method->CurrentValue) <> "") {
			$this->process_method->ViewValue = $this->process_method->optionCaption($this->process_method->CurrentValue);
		} else {
			$this->process_method->ViewValue = NULL;
		}
		$this->process_method->ViewCustomAttributes = "";

		// payment
		$curVal = strval($this->payment->CurrentValue);
		if ($curVal <> "") {
			$this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
			if ($this->payment->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->payment->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->payment->ViewValue = $this->payment->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->payment->ViewValue = $this->payment->CurrentValue;
				}
			}
		} else {
			$this->payment->ViewValue = NULL;
		}
		$this->payment->ViewCustomAttributes = "";

		// remark
		$this->remark->ViewValue = $this->remark->CurrentValue;
		$this->remark->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// opeartor
		$this->opeartor->ViewValue = $this->opeartor->CurrentValue;
		$curVal = strval($this->opeartor->CurrentValue);
		if ($curVal <> "") {
			$this->opeartor->ViewValue = $this->opeartor->lookupCacheOption($curVal);
			if ($this->opeartor->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->opeartor->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->opeartor->ViewValue = $this->opeartor->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->opeartor->ViewValue = $this->opeartor->CurrentValue;
				}
			}
		} else {
			$this->opeartor->ViewValue = NULL;
		}
		$this->opeartor->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
		$this->company_id->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// site
		$this->site->LinkCustomAttributes = "";
		$this->site->HrefValue = "";
		$this->site->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		if (!EmptyValue($this->process->CurrentValue)) {
			$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
			$this->process->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
		} else {
			$this->process->HrefValue = "";
		}
		$this->process->TooltipValue = "";

		// sub_process
		$this->sub_process->LinkCustomAttributes = "";
		$this->sub_process->HrefValue = "";
		$this->sub_process->TooltipValue = "";

		// emp_name
		$this->emp_name->LinkCustomAttributes = "";
		$this->emp_name->HrefValue = "";
		$this->emp_name->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// rid_1
		$this->rid_1->LinkCustomAttributes = "";
		$this->rid_1->HrefValue = "";
		$this->rid_1->TooltipValue = "";

		// packing
		$this->packing->LinkCustomAttributes = "";
		$this->packing->HrefValue = "";
		$this->packing->TooltipValue = "";

		// rid_2
		$this->rid_2->LinkCustomAttributes = "";
		$this->rid_2->HrefValue = "";
		$this->rid_2->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		$this->godown->HrefValue = "";
		$this->godown->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// avialable_qty
		$this->avialable_qty->LinkCustomAttributes = "";
		$this->avialable_qty->HrefValue = "";
		$this->avialable_qty->TooltipValue = "";

		// ply
		$this->ply->LinkCustomAttributes = "";
		$this->ply->HrefValue = "";
		$this->ply->TooltipValue = "";

		// rid_new
		$this->rid_new->LinkCustomAttributes = "";
		$this->rid_new->HrefValue = "";
		$this->rid_new->TooltipValue = "";

		// rid_new_lot_no
		$this->rid_new_lot_no->LinkCustomAttributes = "";
		$this->rid_new_lot_no->HrefValue = "";
		$this->rid_new_lot_no->TooltipValue = "";

		// poid_new
		$this->poid_new->LinkCustomAttributes = "";
		$this->poid_new->HrefValue = "";
		$this->poid_new->TooltipValue = "";

		// poid_1
		$this->poid_1->LinkCustomAttributes = "";
		$this->poid_1->HrefValue = "";
		$this->poid_1->TooltipValue = "";

		// poid
		$this->poid->LinkCustomAttributes = "";
		$this->poid->HrefValue = "";
		$this->poid->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// process_method
		$this->process_method->LinkCustomAttributes = "";
		$this->process_method->HrefValue = "";
		$this->process_method->TooltipValue = "";

		// payment
		$this->payment->LinkCustomAttributes = "";
		$this->payment->HrefValue = "";
		$this->payment->TooltipValue = "";

		// remark
		$this->remark->LinkCustomAttributes = "";
		$this->remark->HrefValue = "";
		$this->remark->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// opeartor
		$this->opeartor->LinkCustomAttributes = "";
		$this->opeartor->HrefValue = "";
		$this->opeartor->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// site
		$this->site->EditAttrs["class"] = "form-control";
		$this->site->EditCustomAttributes = "";
		$curVal = strval($this->site->CurrentValue);
		if ($curVal <> "") {
			$this->site->EditValue = $this->site->lookupCacheOption($curVal);
			if ($this->site->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site() == 0) ? "`status` = 1 and `id` > 0 && `id` != 10" : "`status` = 1 and `id` > 0 && `id` != 10 and FIND_IN_SET(`id`,". User_Site() .")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->site->EditValue = $this->site->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->site->EditValue = $this->site->CurrentValue;
				}
			}
		} else {
			$this->site->EditValue = NULL;
		}
		$this->site->ViewCustomAttributes = "";

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->EditValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `type_cat` = 101";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process->EditValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->EditValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->EditValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// sub_process
		$this->sub_process->EditAttrs["class"] = "form-control";
		$this->sub_process->EditCustomAttributes = "";

		// emp_name
		$this->emp_name->EditAttrs["class"] = "form-control";
		$this->emp_name->EditCustomAttributes = "";

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `type`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->EditValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->EditValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->EditValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->EditValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->EditValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->EditValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->EditAttrs["class"] = "form-control";
		$this->rid_1->EditCustomAttributes = "";

		// packing
		$this->packing->EditAttrs["class"] = "form-control";
		$this->packing->EditCustomAttributes = "";
		$this->packing->EditValue = $this->packing->CurrentValue;
		$this->packing->PlaceHolder = RemoveHtml($this->packing->caption());

		// rid_2
		$this->rid_2->EditAttrs["class"] = "form-control";
		$this->rid_2->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = 'ReadOnly';
		$this->godown->EditValue = $this->godown->CurrentValue;
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->EditValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->EditValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->EditValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = 'ReadOnly';
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->EditValue = FormatNumber($this->avg_quantity->EditValue, 2, -2, -2, -2);
		$this->avg_quantity->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = 'ReadOnly';
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// avialable_qty
		$this->avialable_qty->EditAttrs["class"] = "form-control";
		$this->avialable_qty->EditCustomAttributes = 'ReadOnly';
		$this->avialable_qty->EditValue = $this->avialable_qty->CurrentValue;
		$this->avialable_qty->PlaceHolder = RemoveHtml($this->avialable_qty->caption());
		if (strval($this->avialable_qty->EditValue) <> "" && is_numeric($this->avialable_qty->EditValue))
			$this->avialable_qty->EditValue = FormatNumber($this->avialable_qty->EditValue, -2, -2, -2, 0);

		// ply
		$this->ply->EditAttrs["class"] = "form-control";
		$this->ply->EditCustomAttributes = "";
		$this->ply->EditValue = $this->ply->CurrentValue;
		$this->ply->EditValue = FormatNumber($this->ply->EditValue, 0, -2, -2, -2);
		$this->ply->ViewCustomAttributes = "";

		// rid_new
		$this->rid_new->EditAttrs["class"] = "form-control";
		$this->rid_new->EditCustomAttributes = "";
		$curVal = strval($this->rid_new->CurrentValue);
		if ($curVal <> "") {
			$this->rid_new->EditValue = $this->rid_new->lookupCacheOption($curVal);
			if ($this->rid_new->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `product` = 51";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_new->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid_new->EditValue = $this->rid_new->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_new->EditValue = $this->rid_new->CurrentValue;
				}
			}
		} else {
			$this->rid_new->EditValue = NULL;
		}
		$this->rid_new->ViewCustomAttributes = "";

		// rid_new_lot_no
		$this->rid_new_lot_no->EditAttrs["class"] = "form-control";
		$this->rid_new_lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rid_new_lot_no->CurrentValue = HtmlDecode($this->rid_new_lot_no->CurrentValue);
		$this->rid_new_lot_no->EditValue = $this->rid_new_lot_no->CurrentValue;
		$this->rid_new_lot_no->PlaceHolder = RemoveHtml($this->rid_new_lot_no->caption());

		// poid_new
		$this->poid_new->EditAttrs["class"] = "form-control";
		$this->poid_new->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->poid_new->CurrentValue = HtmlDecode($this->poid_new->CurrentValue);
		$this->poid_new->EditValue = $this->poid_new->CurrentValue;
		$this->poid_new->PlaceHolder = RemoveHtml($this->poid_new->caption());

		// poid_1
		$this->poid_1->EditCustomAttributes = "";

		// poid
		$this->poid->EditAttrs["class"] = "form-control";
		$this->poid->EditCustomAttributes = 'ReadOnly';
		if (REMOVE_XSS)
			$this->poid->CurrentValue = HtmlDecode($this->poid->CurrentValue);
		$this->poid->EditValue = $this->poid->CurrentValue;
		$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
		if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
			$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -2, -2, -2);

		// process_method
		$this->process_method->EditAttrs["class"] = "form-control";
		$this->process_method->EditCustomAttributes = "";
		$this->process_method->EditValue = $this->process_method->options(TRUE);

		// payment
		$this->payment->EditAttrs["class"] = "form-control";
		$this->payment->EditCustomAttributes = "";

		// remark
		$this->remark->EditAttrs["class"] = "form-control";
		$this->remark->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
		$this->remark->EditValue = $this->remark->CurrentValue;
		$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = $this->dated->CurrentValue;
		$this->dated->EditValue = FormatDateTime($this->dated->EditValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// opeartor
		// datetime
		// company_id

		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->site);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->sub_process);
					$doc->exportCaption($this->emp_name);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->packing);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->avialable_qty);
					$doc->exportCaption($this->ply);
					$doc->exportCaption($this->rid_new);
					$doc->exportCaption($this->rid_new_lot_no);
					$doc->exportCaption($this->poid_new);
					$doc->exportCaption($this->poid_1);
					$doc->exportCaption($this->poid);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->process_method);
					$doc->exportCaption($this->payment);
					$doc->exportCaption($this->remark);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->opeartor);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->site);
					$doc->exportCaption($this->sub_process);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->rid_new_lot_no);
					$doc->exportCaption($this->quantity);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->site);
						$doc->exportField($this->process);
						$doc->exportField($this->sub_process);
						$doc->exportField($this->emp_name);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->packing);
						$doc->exportField($this->rid);
						$doc->exportField($this->godown);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->avialable_qty);
						$doc->exportField($this->ply);
						$doc->exportField($this->rid_new);
						$doc->exportField($this->rid_new_lot_no);
						$doc->exportField($this->poid_new);
						$doc->exportField($this->poid_1);
						$doc->exportField($this->poid);
						$doc->exportField($this->quantity);
						$doc->exportField($this->packets);
						$doc->exportField($this->process_method);
						$doc->exportField($this->payment);
						$doc->exportField($this->remark);
						$doc->exportField($this->dated);
						$doc->exportField($this->opeartor);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->site);
						$doc->exportField($this->sub_process);
						$doc->exportField($this->rid);
						$doc->exportField($this->rid_new_lot_no);
						$doc->exportField($this->quantity);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->site, '');
				$doc->exportAggregate($this->sub_process, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->rid_new_lot_no, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'process_action_material';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'process_action_material';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'process_action_material';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'process_action_material';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>