<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_material_add extends process_action_material
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action_material';

	// Page object name
	public $PageObjName = "process_action_material_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action_material)
		if (!isset($GLOBALS["process_action_material"]) || get_class($GLOBALS["process_action_material"]) == PROJECT_NAMESPACE . "process_action_material") {
			$GLOBALS["process_action_material"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action_material"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_material');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action_material;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action_material);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "process_action_materialview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_action_materiallist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->site->setVisibility();
		$this->process->setVisibility();
		$this->sub_process->setVisibility();
		$this->emp_name->setVisibility();
		$this->jc_no->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid_1->setVisibility();
		$this->packing->setVisibility();
		$this->rid_2->setVisibility();
		$this->rid->setVisibility();
		$this->godown->setVisibility();
		$this->avg_quantity->setVisibility();
		$this->lot_no->setVisibility();
		$this->avialable_qty->setVisibility();
		$this->ply->setVisibility();
		$this->rid_new->setVisibility();
		$this->rid_new_lot_no->setVisibility();
		$this->poid_new->setVisibility();
		$this->poid_1->setVisibility();
		$this->poid->setVisibility();
		$this->quantity->setVisibility();
		$this->packets->setVisibility();
		$this->process_method->setVisibility();
		$this->payment->Visible = FALSE;
		$this->remark->setVisibility();
		$this->dated->setVisibility();
		$this->opeartor->setVisibility();
		$this->datetime->setVisibility();
		$this->company_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->site);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->sub_process);
		$this->setupLookupOptions($this->emp_name);
		$this->setupLookupOptions($this->jc_no);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid_1);
		$this->setupLookupOptions($this->packing);
		$this->setupLookupOptions($this->rid_2);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->rid_new);
		$this->setupLookupOptions($this->poid_1);
		$this->setupLookupOptions($this->payment);
		$this->setupLookupOptions($this->opeartor);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("process_action_materiallist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->GetAddUrl();
					if (GetPageName($returnUrl) == "process_action_materiallist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "process_action_materialview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->site->CurrentValue = ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:'');
		$this->process->CurrentValue = ((isset($_COOKIE["PROC"]))? $_COOKIE["PROC"]:'');
		$this->sub_process->CurrentValue = pamot();
		$this->emp_name->CurrentValue = NULL;
		$this->emp_name->OldValue = $this->emp_name->CurrentValue;
		$this->jc_no->CurrentValue = NULL;
		$this->jc_no->OldValue = $this->jc_no->CurrentValue;
		$this->grp->CurrentValue = (isset($_GET['GRP'])) ? $_GET['GRP'] :((isset($_COOKIE['GRP'])) ? $_COOKIE['GRP'] : 2);
		$this->s_grp->CurrentValue = (isset($_GET['SGRP']))  ? $_GET['SGRP'] : ((isset($_COOKIE['SGRP']))  ? $_COOKIE['SGRP'] : '');
		$this->product->CurrentValue = (isset($_GET['PR']))  ? $_GET['PR'] : ((isset($_COOKIE['PR']))  ? $_COOKIE['PR'] : '');
		$this->rid_1->CurrentValue = NULL;
		$this->rid_1->OldValue = $this->rid_1->CurrentValue;
		$this->packing->CurrentValue = (isset($_GET['PK']))  ? $_GET['PK'] : ((isset($_COOKIE['PK']))  ? $_COOKIE['PK'] : '');
		$this->rid_2->CurrentValue = NULL;
		$this->rid_2->OldValue = $this->rid_2->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->godown->CurrentValue = NULL;
		$this->godown->OldValue = $this->godown->CurrentValue;
		$this->avg_quantity->CurrentValue = NULL;
		$this->avg_quantity->OldValue = $this->avg_quantity->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->avialable_qty->CurrentValue = NULL;
		$this->avialable_qty->OldValue = $this->avialable_qty->CurrentValue;
		$this->ply->CurrentValue = NULL;
		$this->ply->OldValue = $this->ply->CurrentValue;
		$this->rid_new->CurrentValue = NULL;
		$this->rid_new->OldValue = $this->rid_new->CurrentValue;
		$this->rid_new_lot_no->CurrentValue = NULL;
		$this->rid_new_lot_no->OldValue = $this->rid_new_lot_no->CurrentValue;
		$this->poid_new->CurrentValue = NULL;
		$this->poid_new->OldValue = $this->poid_new->CurrentValue;
		$this->poid_1->CurrentValue = NULL;
		$this->poid_1->OldValue = $this->poid_1->CurrentValue;
		$this->poid->CurrentValue = 0;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->packets->CurrentValue = NULL;
		$this->packets->OldValue = $this->packets->CurrentValue;
		$this->process_method->CurrentValue = NULL;
		$this->process_method->OldValue = $this->process_method->CurrentValue;
		$this->payment->CurrentValue = NULL;
		$this->payment->OldValue = $this->payment->CurrentValue;
		$this->remark->CurrentValue = NULL;
		$this->remark->OldValue = $this->remark->CurrentValue;
		$this->dated->CurrentValue = CurrentDate();
		$this->opeartor->CurrentValue = NULL;
		$this->opeartor->OldValue = $this->opeartor->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->company_id->CurrentValue = NULL;
		$this->company_id->OldValue = $this->company_id->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'site' first before field var 'x_site'
		$val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
		if (!$this->site->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->site->Visible = FALSE; // Disable update for API request
			else
				$this->site->setFormValue($val);
		}

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'sub_process' first before field var 'x_sub_process'
		$val = $CurrentForm->hasValue("sub_process") ? $CurrentForm->getValue("sub_process") : $CurrentForm->getValue("x_sub_process");
		if (!$this->sub_process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sub_process->Visible = FALSE; // Disable update for API request
			else
				$this->sub_process->setFormValue($val);
		}

		// Check field name 'emp_name' first before field var 'x_emp_name'
		$val = $CurrentForm->hasValue("emp_name") ? $CurrentForm->getValue("emp_name") : $CurrentForm->getValue("x_emp_name");
		if (!$this->emp_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emp_name->Visible = FALSE; // Disable update for API request
			else
				$this->emp_name->setFormValue($val);
		}

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid_1' first before field var 'x_rid_1'
		$val = $CurrentForm->hasValue("rid_1") ? $CurrentForm->getValue("rid_1") : $CurrentForm->getValue("x_rid_1");
		if (!$this->rid_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_1->Visible = FALSE; // Disable update for API request
			else
				$this->rid_1->setFormValue($val);
		}

		// Check field name 'packing' first before field var 'x_packing'
		$val = $CurrentForm->hasValue("packing") ? $CurrentForm->getValue("packing") : $CurrentForm->getValue("x_packing");
		if (!$this->packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing->Visible = FALSE; // Disable update for API request
			else
				$this->packing->setFormValue($val);
		}

		// Check field name 'rid_2' first before field var 'x_rid_2'
		$val = $CurrentForm->hasValue("rid_2") ? $CurrentForm->getValue("rid_2") : $CurrentForm->getValue("x_rid_2");
		if (!$this->rid_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_2->Visible = FALSE; // Disable update for API request
			else
				$this->rid_2->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'avg_quantity' first before field var 'x_avg_quantity'
		$val = $CurrentForm->hasValue("avg_quantity") ? $CurrentForm->getValue("avg_quantity") : $CurrentForm->getValue("x_avg_quantity");
		if (!$this->avg_quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->avg_quantity->Visible = FALSE; // Disable update for API request
			else
				$this->avg_quantity->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'avialable_qty' first before field var 'x_avialable_qty'
		$val = $CurrentForm->hasValue("avialable_qty") ? $CurrentForm->getValue("avialable_qty") : $CurrentForm->getValue("x_avialable_qty");
		if (!$this->avialable_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->avialable_qty->Visible = FALSE; // Disable update for API request
			else
				$this->avialable_qty->setFormValue($val);
		}

		// Check field name 'ply' first before field var 'x_ply'
		$val = $CurrentForm->hasValue("ply") ? $CurrentForm->getValue("ply") : $CurrentForm->getValue("x_ply");
		if (!$this->ply->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply->Visible = FALSE; // Disable update for API request
			else
				$this->ply->setFormValue($val);
		}

		// Check field name 'rid_new' first before field var 'x_rid_new'
		$val = $CurrentForm->hasValue("rid_new") ? $CurrentForm->getValue("rid_new") : $CurrentForm->getValue("x_rid_new");
		if (!$this->rid_new->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_new->Visible = FALSE; // Disable update for API request
			else
				$this->rid_new->setFormValue($val);
		}

		// Check field name 'rid_new_lot_no' first before field var 'x_rid_new_lot_no'
		$val = $CurrentForm->hasValue("rid_new_lot_no") ? $CurrentForm->getValue("rid_new_lot_no") : $CurrentForm->getValue("x_rid_new_lot_no");
		if (!$this->rid_new_lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_new_lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->rid_new_lot_no->setFormValue($val);
		}

		// Check field name 'poid_new' first before field var 'x_poid_new'
		$val = $CurrentForm->hasValue("poid_new") ? $CurrentForm->getValue("poid_new") : $CurrentForm->getValue("x_poid_new");
		if (!$this->poid_new->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid_new->Visible = FALSE; // Disable update for API request
			else
				$this->poid_new->setFormValue($val);
		}

		// Check field name 'poid_1' first before field var 'x_poid_1'
		$val = $CurrentForm->hasValue("poid_1") ? $CurrentForm->getValue("poid_1") : $CurrentForm->getValue("x_poid_1");
		if (!$this->poid_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid_1->Visible = FALSE; // Disable update for API request
			else
				$this->poid_1->setFormValue($val);
		}

		// Check field name 'poid' first before field var 'x_poid'
		$val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
		if (!$this->poid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid->Visible = FALSE; // Disable update for API request
			else
				$this->poid->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'packets' first before field var 'x_packets'
		$val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
		if (!$this->packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets->Visible = FALSE; // Disable update for API request
			else
				$this->packets->setFormValue($val);
		}

		// Check field name 'process_method' first before field var 'x_process_method'
		$val = $CurrentForm->hasValue("process_method") ? $CurrentForm->getValue("process_method") : $CurrentForm->getValue("x_process_method");
		if (!$this->process_method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process_method->Visible = FALSE; // Disable update for API request
			else
				$this->process_method->setFormValue($val);
		}

		// Check field name 'remark' first before field var 'x_remark'
		$val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
		if (!$this->remark->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remark->Visible = FALSE; // Disable update for API request
			else
				$this->remark->setFormValue($val);
		}

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		}

		// Check field name 'opeartor' first before field var 'x_opeartor'
		$val = $CurrentForm->hasValue("opeartor") ? $CurrentForm->getValue("opeartor") : $CurrentForm->getValue("x_opeartor");
		if (!$this->opeartor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->opeartor->Visible = FALSE; // Disable update for API request
			else
				$this->opeartor->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->site->CurrentValue = $this->site->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->sub_process->CurrentValue = $this->sub_process->FormValue;
		$this->emp_name->CurrentValue = $this->emp_name->FormValue;
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid_1->CurrentValue = $this->rid_1->FormValue;
		$this->packing->CurrentValue = $this->packing->FormValue;
		$this->rid_2->CurrentValue = $this->rid_2->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->avg_quantity->CurrentValue = $this->avg_quantity->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->avialable_qty->CurrentValue = $this->avialable_qty->FormValue;
		$this->ply->CurrentValue = $this->ply->FormValue;
		$this->rid_new->CurrentValue = $this->rid_new->FormValue;
		$this->rid_new_lot_no->CurrentValue = $this->rid_new_lot_no->FormValue;
		$this->poid_new->CurrentValue = $this->poid_new->FormValue;
		$this->poid_1->CurrentValue = $this->poid_1->FormValue;
		$this->poid->CurrentValue = $this->poid->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->packets->CurrentValue = $this->packets->FormValue;
		$this->process_method->CurrentValue = $this->process_method->FormValue;
		$this->remark->CurrentValue = $this->remark->FormValue;
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		$this->opeartor->CurrentValue = $this->opeartor->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->site->setDbValue($row['site']);
		$this->process->setDbValue($row['process']);
		$this->sub_process->setDbValue($row['sub_process']);
		$this->emp_name->setDbValue($row['emp_name']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->packing->setDbValue($row['packing']);
		$this->rid_2->setDbValue($row['rid_2']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->godown->setDbValue($row['godown']);
		$this->avg_quantity->setDbValue($row['avg_quantity']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->avialable_qty->setDbValue($row['avialable_qty']);
		$this->ply->setDbValue($row['ply']);
		$this->rid_new->setDbValue($row['rid_new']);
		$this->rid_new_lot_no->setDbValue($row['rid_new_lot_no']);
		$this->poid_new->setDbValue($row['poid_new']);
		$this->poid_1->setDbValue($row['poid_1']);
		$this->poid->setDbValue($row['poid']);
		$this->quantity->setDbValue($row['quantity']);
		$this->packets->setDbValue($row['packets']);
		$this->process_method->setDbValue($row['process_method']);
		$this->payment->setDbValue($row['payment']);
		$this->remark->setDbValue($row['remark']);
		$this->dated->setDbValue($row['dated']);
		$this->opeartor->setDbValue($row['opeartor']);
		$this->datetime->setDbValue($row['datetime']);
		$this->company_id->setDbValue($row['company_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['site'] = $this->site->CurrentValue;
		$row['process'] = $this->process->CurrentValue;
		$row['sub_process'] = $this->sub_process->CurrentValue;
		$row['emp_name'] = $this->emp_name->CurrentValue;
		$row['jc_no'] = $this->jc_no->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['rid_1'] = $this->rid_1->CurrentValue;
		$row['packing'] = $this->packing->CurrentValue;
		$row['rid_2'] = $this->rid_2->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['godown'] = $this->godown->CurrentValue;
		$row['avg_quantity'] = $this->avg_quantity->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['avialable_qty'] = $this->avialable_qty->CurrentValue;
		$row['ply'] = $this->ply->CurrentValue;
		$row['rid_new'] = $this->rid_new->CurrentValue;
		$row['rid_new_lot_no'] = $this->rid_new_lot_no->CurrentValue;
		$row['poid_new'] = $this->poid_new->CurrentValue;
		$row['poid_1'] = $this->poid_1->CurrentValue;
		$row['poid'] = $this->poid->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['packets'] = $this->packets->CurrentValue;
		$row['process_method'] = $this->process_method->CurrentValue;
		$row['payment'] = $this->payment->CurrentValue;
		$row['remark'] = $this->remark->CurrentValue;
		$row['dated'] = $this->dated->CurrentValue;
		$row['opeartor'] = $this->opeartor->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->avg_quantity->FormValue == $this->avg_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->avg_quantity->CurrentValue)))
			$this->avg_quantity->CurrentValue = ConvertToFloatString($this->avg_quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->avialable_qty->FormValue == $this->avialable_qty->CurrentValue && is_numeric(ConvertToFloatString($this->avialable_qty->CurrentValue)))
			$this->avialable_qty->CurrentValue = ConvertToFloatString($this->avialable_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets->FormValue == $this->packets->CurrentValue && is_numeric(ConvertToFloatString($this->packets->CurrentValue)))
			$this->packets->CurrentValue = ConvertToFloatString($this->packets->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// site
		// process
		// sub_process
		// emp_name
		// jc_no
		// grp
		// s_grp
		// product
		// rid_1
		// packing
		// rid_2
		// rid
		// godown
		// avg_quantity
		// lot_no
		// avialable_qty
		// ply
		// rid_new
		// rid_new_lot_no
		// poid_new
		// poid_1
		// poid
		// quantity
		// packets
		// process_method
		// payment
		// remark
		// dated
		// opeartor
		// datetime
		// company_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// site
			$curVal = strval($this->site->CurrentValue);
			if ($curVal <> "") {
				$this->site->ViewValue = $this->site->lookupCacheOption($curVal);
				if ($this->site->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `id` > 0 && `id` != 10" : "`status` = 1 and `id` > 0 && `id` != 10 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->site->ViewValue = $this->site->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->site->ViewValue = $this->site->CurrentValue;
					}
				}
			} else {
				$this->site->ViewValue = NULL;
			}
			$this->site->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `type_cat` = 101";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// sub_process
			$curVal = strval($this->sub_process->CurrentValue);
			if ($curVal <> "") {
				$this->sub_process->ViewValue = $this->sub_process->lookupCacheOption($curVal);
				if ($this->sub_process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return " `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->sub_process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->sub_process->ViewValue = $this->sub_process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->sub_process->ViewValue = $this->sub_process->CurrentValue;
					}
				}
			} else {
				$this->sub_process->ViewValue = NULL;
			}
			$this->sub_process->ViewCustomAttributes = "";

			// emp_name
			$curVal = strval($this->emp_name->CurrentValue);
			if ($curVal <> "") {
				$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
				if ($this->emp_name->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->emp_name->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
					}
				}
			} else {
				$this->emp_name->ViewValue = NULL;
			}
			$this->emp_name->ViewCustomAttributes = "";

			// jc_no
			$curVal = strval($this->jc_no->CurrentValue);
			if ($curVal <> "") {
				$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
				if ($this->jc_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
					}
				}
			} else {
				$this->jc_no->ViewValue = NULL;
			}
			$this->jc_no->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `type`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid_1
			$curVal = strval($this->rid_1->CurrentValue);
			if ($curVal <> "") {
				$this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
				if ($this->rid_1->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
						$arwrk[4] = $rswrk->fields('df4');
						$this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
					}
				}
			} else {
				$this->rid_1->ViewValue = NULL;
			}
			$this->rid_1->ViewCustomAttributes = "";

			// packing
			$this->packing->ViewValue = $this->packing->CurrentValue;
			$curVal = strval($this->packing->CurrentValue);
			if ($curVal <> "") {
				$this->packing->ViewValue = $this->packing->lookupCacheOption($curVal);
				if ($this->packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing->ViewValue = $this->packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing->ViewValue = $this->packing->CurrentValue;
					}
				}
			} else {
				$this->packing->ViewValue = NULL;
			}
			$this->packing->ViewCustomAttributes = "";

			// rid_2
			$curVal = strval($this->rid_2->CurrentValue);
			if ($curVal <> "") {
				$this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
				if ($this->rid_2->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_2->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
						$this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_2->ViewValue = $this->rid_2->CurrentValue;
					}
				}
			} else {
				$this->rid_2->ViewValue = NULL;
			}
			$this->rid_2->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
				$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// godown
			$this->godown->ViewValue = $this->godown->CurrentValue;
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// avg_quantity
			$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
			$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 2, -2, -2, -2);
			$this->avg_quantity->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// avialable_qty
			$this->avialable_qty->ViewValue = $this->avialable_qty->CurrentValue;
			$this->avialable_qty->ViewValue = FormatNumber($this->avialable_qty->ViewValue, 4, -2, -2, 0);
			$this->avialable_qty->ViewCustomAttributes = "";

			// ply
			$this->ply->ViewValue = $this->ply->CurrentValue;
			$this->ply->ViewValue = FormatNumber($this->ply->ViewValue, 0, -2, -2, -2);
			$this->ply->ViewCustomAttributes = "";

			// rid_new
			$curVal = strval($this->rid_new->CurrentValue);
			if ($curVal <> "") {
				$this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
				if ($this->rid_new->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `product` = 51";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid_new->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid_new->ViewValue = $this->rid_new->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_new->ViewValue = $this->rid_new->CurrentValue;
					}
				}
			} else {
				$this->rid_new->ViewValue = NULL;
			}
			$this->rid_new->ViewCustomAttributes = "";

			// rid_new_lot_no
			$this->rid_new_lot_no->ViewValue = $this->rid_new_lot_no->CurrentValue;
			$this->rid_new_lot_no->ViewCustomAttributes = "";

			// poid_new
			$this->poid_new->ViewValue = $this->poid_new->CurrentValue;
			$this->poid_new->ViewCustomAttributes = "";

			// poid_1
			$curVal = strval($this->poid_1->CurrentValue);
			if ($curVal <> "") {
				$this->poid_1->ViewValue = $this->poid_1->lookupCacheOption($curVal);
				if ($this->poid_1->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`pending_qty`>0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->poid_1->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->poid_1->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = $rswrk->fields('df3');
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->poid_1->ViewValue->add($this->poid_1->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->poid_1->ViewValue = $this->poid_1->CurrentValue;
					}
				}
			} else {
				$this->poid_1->ViewValue = NULL;
			}
			$this->poid_1->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 2, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// process_method
			if (strval($this->process_method->CurrentValue) <> "") {
				$this->process_method->ViewValue = $this->process_method->optionCaption($this->process_method->CurrentValue);
			} else {
				$this->process_method->ViewValue = NULL;
			}
			$this->process_method->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// opeartor
			$this->opeartor->ViewValue = $this->opeartor->CurrentValue;
			$curVal = strval($this->opeartor->CurrentValue);
			if ($curVal <> "") {
				$this->opeartor->ViewValue = $this->opeartor->lookupCacheOption($curVal);
				if ($this->opeartor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->opeartor->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->opeartor->ViewValue = $this->opeartor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->opeartor->ViewValue = $this->opeartor->CurrentValue;
					}
				}
			} else {
				$this->opeartor->ViewValue = NULL;
			}
			$this->opeartor->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// site
			$this->site->LinkCustomAttributes = "";
			$this->site->HrefValue = "";
			$this->site->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// sub_process
			$this->sub_process->LinkCustomAttributes = "";
			$this->sub_process->HrefValue = "";
			$this->sub_process->TooltipValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			$this->emp_name->HrefValue = "";
			$this->emp_name->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";
			$this->rid_1->TooltipValue = "";

			// packing
			$this->packing->LinkCustomAttributes = "";
			$this->packing->HrefValue = "";
			$this->packing->TooltipValue = "";

			// rid_2
			$this->rid_2->LinkCustomAttributes = "";
			$this->rid_2->HrefValue = "";
			$this->rid_2->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";
			$this->godown->TooltipValue = "";

			// avg_quantity
			$this->avg_quantity->LinkCustomAttributes = "";
			$this->avg_quantity->HrefValue = "";
			$this->avg_quantity->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// avialable_qty
			$this->avialable_qty->LinkCustomAttributes = "";
			$this->avialable_qty->HrefValue = "";
			$this->avialable_qty->TooltipValue = "";

			// ply
			$this->ply->LinkCustomAttributes = "";
			$this->ply->HrefValue = "";
			$this->ply->TooltipValue = "";

			// rid_new
			$this->rid_new->LinkCustomAttributes = "";
			$this->rid_new->HrefValue = "";
			$this->rid_new->TooltipValue = "";

			// rid_new_lot_no
			$this->rid_new_lot_no->LinkCustomAttributes = "";
			$this->rid_new_lot_no->HrefValue = "";
			$this->rid_new_lot_no->TooltipValue = "";

			// poid_new
			$this->poid_new->LinkCustomAttributes = "";
			$this->poid_new->HrefValue = "";
			$this->poid_new->TooltipValue = "";

			// poid_1
			$this->poid_1->LinkCustomAttributes = "";
			$this->poid_1->HrefValue = "";
			$this->poid_1->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// process_method
			$this->process_method->LinkCustomAttributes = "";
			$this->process_method->HrefValue = "";
			$this->process_method->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// opeartor
			$this->opeartor->LinkCustomAttributes = "";
			$this->opeartor->HrefValue = "";
			$this->opeartor->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// site
			$this->site->EditAttrs["class"] = "form-control";
			$this->site->EditCustomAttributes = "";
			$curVal = trim(strval($this->site->CurrentValue));
			if ($curVal <> "")
				$this->site->ViewValue = $this->site->lookupCacheOption($curVal);
			else
				$this->site->ViewValue = $this->site->Lookup !== NULL && is_array($this->site->Lookup->Options) ? $curVal : NULL;
			if ($this->site->ViewValue !== NULL) { // Load from cache
				$this->site->EditValue = array_values($this->site->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->site->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Site() == 0) ? "`status` = 1 and `id` > 0 && `id` != 10" : "`status` = 1 and `id` > 0 && `id` != 10 and FIND_IN_SET(`id`,". User_Site() .")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->site->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->site->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->CurrentValue));
			if ($curVal <> "")
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `type_cat` = 101";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// sub_process
			$this->sub_process->EditAttrs["class"] = "form-control";
			$this->sub_process->EditCustomAttributes = "";
			$curVal = trim(strval($this->sub_process->CurrentValue));
			if ($curVal <> "")
				$this->sub_process->ViewValue = $this->sub_process->lookupCacheOption($curVal);
			else
				$this->sub_process->ViewValue = $this->sub_process->Lookup !== NULL && is_array($this->sub_process->Lookup->Options) ? $curVal : NULL;
			if ($this->sub_process->ViewValue !== NULL) { // Load from cache
				$this->sub_process->EditValue = array_values($this->sub_process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->sub_process->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return " `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->sub_process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->sub_process->EditValue = $arwrk;
			}

			// emp_name
			$this->emp_name->EditAttrs["class"] = "form-control";
			$this->emp_name->EditCustomAttributes = "";
			$curVal = trim(strval($this->emp_name->CurrentValue));
			if ($curVal <> "")
				$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
			else
				$this->emp_name->ViewValue = $this->emp_name->Lookup !== NULL && is_array($this->emp_name->Lookup->Options) ? $curVal : NULL;
			if ($this->emp_name->ViewValue !== NULL) { // Load from cache
				$this->emp_name->EditValue = array_values($this->emp_name->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->emp_name->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->emp_name->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->emp_name->EditValue = $arwrk;
			}

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->jc_no->CurrentValue));
			if ($curVal <> "")
				$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
			else
				$this->jc_no->ViewValue = $this->jc_no->Lookup !== NULL && is_array($this->jc_no->Lookup->Options) ? $curVal : NULL;
			if ($this->jc_no->ViewValue !== NULL) { // Load from cache
				$this->jc_no->EditValue = array_values($this->jc_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->jc_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->jc_no->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->jc_no->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `type`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// rid_1
			$this->rid_1->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid_1->CurrentValue));
			if ($curVal <> "")
				$this->rid_1->ViewValue = $this->rid_1->lookupCacheOption($curVal);
			else
				$this->rid_1->ViewValue = $this->rid_1->Lookup !== NULL && is_array($this->rid_1->Lookup->Options) ? $curVal : NULL;
			if ($this->rid_1->ViewValue !== NULL) { // Load from cache
				$this->rid_1->EditValue = array_values($this->rid_1->Lookup->Options);
				if ($this->rid_1->ViewValue == "")
					$this->rid_1->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid_1->CurrentValue, DATATYPE_MEMO, "");
				}
				$lookupFilter = function() {
					return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_1->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0));
					$arwrk[4] = HtmlEncode($rswrk->fields('df4'));
					$this->rid_1->ViewValue = $this->rid_1->displayValue($arwrk);
				} else {
					$this->rid_1->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, 0);
				}
				$this->rid_1->EditValue = $arwrk;
			}

			// packing
			$this->packing->EditAttrs["class"] = "form-control";
			$this->packing->EditCustomAttributes = "";
			$this->packing->EditValue = HtmlEncode($this->packing->CurrentValue);
			$curVal = strval($this->packing->CurrentValue);
			if ($curVal <> "") {
				$this->packing->EditValue = $this->packing->lookupCacheOption($curVal);
				if ($this->packing->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->packing->EditValue = $this->packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing->EditValue = HtmlEncode($this->packing->CurrentValue);
					}
				}
			} else {
				$this->packing->EditValue = NULL;
			}
			$this->packing->PlaceHolder = RemoveHtml($this->packing->caption());

			// rid_2
			$this->rid_2->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid_2->CurrentValue));
			if ($curVal <> "")
				$this->rid_2->ViewValue = $this->rid_2->lookupCacheOption($curVal);
			else
				$this->rid_2->ViewValue = $this->rid_2->Lookup !== NULL && is_array($this->rid_2->Lookup->Options) ? $curVal : NULL;
			if ($this->rid_2->ViewValue !== NULL) { // Load from cache
				$this->rid_2->EditValue = array_values($this->rid_2->Lookup->Options);
				if ($this->rid_2->ViewValue == "")
					$this->rid_2->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid_2->CurrentValue, DATATYPE_MEMO, "");
				}
				$lookupFilter = function() {
					return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_2->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
					$arwrk[4] = HtmlEncode(FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0));
					$this->rid_2->ViewValue = $this->rid_2->displayValue($arwrk);
				} else {
					$this->rid_2->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, 0);
				}
				$this->rid_2->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = 'ReadOnly';
			$this->godown->EditValue = HtmlEncode($this->godown->CurrentValue);
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->godown->EditValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->EditValue = HtmlEncode($this->godown->CurrentValue);
					}
				}
			} else {
				$this->godown->EditValue = NULL;
			}
			$this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

			// avg_quantity
			$this->avg_quantity->EditAttrs["class"] = "form-control";
			$this->avg_quantity->EditCustomAttributes = 'ReadOnly';
			$this->avg_quantity->EditValue = HtmlEncode($this->avg_quantity->CurrentValue);
			$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());
			if (strval($this->avg_quantity->EditValue) <> "" && is_numeric($this->avg_quantity->EditValue))
				$this->avg_quantity->EditValue = FormatNumber($this->avg_quantity->EditValue, -2, -2, -2, -2);

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// avialable_qty
			$this->avialable_qty->EditAttrs["class"] = "form-control";
			$this->avialable_qty->EditCustomAttributes = 'ReadOnly';
			$this->avialable_qty->EditValue = HtmlEncode($this->avialable_qty->CurrentValue);
			$this->avialable_qty->PlaceHolder = RemoveHtml($this->avialable_qty->caption());
			if (strval($this->avialable_qty->EditValue) <> "" && is_numeric($this->avialable_qty->EditValue))
				$this->avialable_qty->EditValue = FormatNumber($this->avialable_qty->EditValue, -2, -2, -2, 0);

			// ply
			$this->ply->EditAttrs["class"] = "form-control";
			$this->ply->EditCustomAttributes = "";
			$this->ply->EditValue = HtmlEncode($this->ply->CurrentValue);
			$this->ply->PlaceHolder = RemoveHtml($this->ply->caption());

			// rid_new
			$this->rid_new->EditAttrs["class"] = "form-control";
			$this->rid_new->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid_new->CurrentValue));
			if ($curVal <> "")
				$this->rid_new->ViewValue = $this->rid_new->lookupCacheOption($curVal);
			else
				$this->rid_new->ViewValue = $this->rid_new->Lookup !== NULL && is_array($this->rid_new->Lookup->Options) ? $curVal : NULL;
			if ($this->rid_new->ViewValue !== NULL) { // Load from cache
				$this->rid_new->EditValue = array_values($this->rid_new->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid_new->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `product` = 51";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid_new->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->rid_new->EditValue = $arwrk;
			}

			// rid_new_lot_no
			$this->rid_new_lot_no->EditAttrs["class"] = "form-control";
			$this->rid_new_lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rid_new_lot_no->CurrentValue = HtmlDecode($this->rid_new_lot_no->CurrentValue);
			$this->rid_new_lot_no->EditValue = HtmlEncode($this->rid_new_lot_no->CurrentValue);
			$this->rid_new_lot_no->PlaceHolder = RemoveHtml($this->rid_new_lot_no->caption());

			// poid_new
			$this->poid_new->EditAttrs["class"] = "form-control";
			$this->poid_new->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->poid_new->CurrentValue = HtmlDecode($this->poid_new->CurrentValue);
			$this->poid_new->EditValue = HtmlEncode($this->poid_new->CurrentValue);
			$this->poid_new->PlaceHolder = RemoveHtml($this->poid_new->caption());

			// poid_1
			$this->poid_1->EditCustomAttributes = "";
			$curVal = trim(strval($this->poid_1->CurrentValue));
			if ($curVal <> "")
				$this->poid_1->ViewValue = $this->poid_1->lookupCacheOption($curVal);
			else
				$this->poid_1->ViewValue = $this->poid_1->Lookup !== NULL && is_array($this->poid_1->Lookup->Options) ? $curVal : NULL;
			if ($this->poid_1->ViewValue !== NULL) { // Load from cache
				$this->poid_1->EditValue = array_values($this->poid_1->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`pending_qty`>0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->poid_1->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->poid_1->EditValue = $arwrk;
			}

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->poid->CurrentValue = HtmlDecode($this->poid->CurrentValue);
			$this->poid->EditValue = HtmlEncode($this->poid->CurrentValue);
			$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->CurrentValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
			if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
				$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -2, -2, -2);

			// process_method
			$this->process_method->EditAttrs["class"] = "form-control";
			$this->process_method->EditCustomAttributes = "";
			$this->process_method->EditValue = $this->process_method->options(TRUE);

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
			$this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// opeartor
			// datetime
			// Add refer script
			// site

			$this->site->LinkCustomAttributes = "";
			$this->site->HrefValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}

			// sub_process
			$this->sub_process->LinkCustomAttributes = "";
			$this->sub_process->HrefValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			$this->emp_name->HrefValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";

			// packing
			$this->packing->LinkCustomAttributes = "";
			$this->packing->HrefValue = "";

			// rid_2
			$this->rid_2->LinkCustomAttributes = "";
			$this->rid_2->HrefValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";

			// avg_quantity
			$this->avg_quantity->LinkCustomAttributes = "";
			$this->avg_quantity->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// avialable_qty
			$this->avialable_qty->LinkCustomAttributes = "";
			$this->avialable_qty->HrefValue = "";

			// ply
			$this->ply->LinkCustomAttributes = "";
			$this->ply->HrefValue = "";

			// rid_new
			$this->rid_new->LinkCustomAttributes = "";
			$this->rid_new->HrefValue = "";

			// rid_new_lot_no
			$this->rid_new_lot_no->LinkCustomAttributes = "";
			$this->rid_new_lot_no->HrefValue = "";

			// poid_new
			$this->poid_new->LinkCustomAttributes = "";
			$this->poid_new->HrefValue = "";

			// poid_1
			$this->poid_1->LinkCustomAttributes = "";
			$this->poid_1->HrefValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";

			// process_method
			$this->process_method->LinkCustomAttributes = "";
			$this->process_method->HrefValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// opeartor
			$this->opeartor->LinkCustomAttributes = "";
			$this->opeartor->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->site->Required) {
			if (!$this->site->IsDetailKey && $this->site->FormValue != NULL && $this->site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->sub_process->Required) {
			if (!$this->sub_process->IsDetailKey && $this->sub_process->FormValue != NULL && $this->sub_process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sub_process->caption(), $this->sub_process->RequiredErrorMessage));
			}
		}
		if ($this->emp_name->Required) {
			if (!$this->emp_name->IsDetailKey && $this->emp_name->FormValue != NULL && $this->emp_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emp_name->caption(), $this->emp_name->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid_1->Required) {
			if (!$this->rid_1->IsDetailKey && $this->rid_1->FormValue != NULL && $this->rid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
			}
		}
		if ($this->packing->Required) {
			if (!$this->packing->IsDetailKey && $this->packing->FormValue != NULL && $this->packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing->caption(), $this->packing->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->packing->FormValue)) {
			AddMessage($FormError, $this->packing->errorMessage());
		}
		if ($this->rid_2->Required) {
			if (!$this->rid_2->IsDetailKey && $this->rid_2->FormValue != NULL && $this->rid_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_2->caption(), $this->rid_2->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->godown->FormValue)) {
			AddMessage($FormError, $this->godown->errorMessage());
		}
		if ($this->avg_quantity->Required) {
			if (!$this->avg_quantity->IsDetailKey && $this->avg_quantity->FormValue != NULL && $this->avg_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->avg_quantity->caption(), $this->avg_quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->avg_quantity->FormValue)) {
			AddMessage($FormError, $this->avg_quantity->errorMessage());
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->avialable_qty->Required) {
			if (!$this->avialable_qty->IsDetailKey && $this->avialable_qty->FormValue != NULL && $this->avialable_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->avialable_qty->caption(), $this->avialable_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->avialable_qty->FormValue)) {
			AddMessage($FormError, $this->avialable_qty->errorMessage());
		}
		if ($this->ply->Required) {
			if (!$this->ply->IsDetailKey && $this->ply->FormValue != NULL && $this->ply->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply->caption(), $this->ply->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->ply->FormValue)) {
			AddMessage($FormError, $this->ply->errorMessage());
		}
		if ($this->rid_new->Required) {
			if (!$this->rid_new->IsDetailKey && $this->rid_new->FormValue != NULL && $this->rid_new->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_new->caption(), $this->rid_new->RequiredErrorMessage));
			}
		}
		if ($this->rid_new_lot_no->Required) {
			if (!$this->rid_new_lot_no->IsDetailKey && $this->rid_new_lot_no->FormValue != NULL && $this->rid_new_lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_new_lot_no->caption(), $this->rid_new_lot_no->RequiredErrorMessage));
			}
		}
		if ($this->poid_new->Required) {
			if (!$this->poid_new->IsDetailKey && $this->poid_new->FormValue != NULL && $this->poid_new->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid_new->caption(), $this->poid_new->RequiredErrorMessage));
			}
		}
		if ($this->poid_1->Required) {
			if ($this->poid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid_1->caption(), $this->poid_1->RequiredErrorMessage));
			}
		}
		if ($this->poid->Required) {
			if (!$this->poid->IsDetailKey && $this->poid->FormValue != NULL && $this->poid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->packets->Required) {
			if (!$this->packets->IsDetailKey && $this->packets->FormValue != NULL && $this->packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->packets->FormValue)) {
			AddMessage($FormError, $this->packets->errorMessage());
		}
		if ($this->process_method->Required) {
			if (!$this->process_method->IsDetailKey && $this->process_method->FormValue != NULL && $this->process_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_method->caption(), $this->process_method->RequiredErrorMessage));
			}
		}
		if ($this->payment->Required) {
			if (!$this->payment->IsDetailKey && $this->payment->FormValue != NULL && $this->payment->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment->caption(), $this->payment->RequiredErrorMessage));
			}
		}
		if ($this->remark->Required) {
			if (!$this->remark->IsDetailKey && $this->remark->FormValue != NULL && $this->remark->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
			}
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dated->FormValue)) {
			AddMessage($FormError, $this->dated->errorMessage());
		}
		if ($this->opeartor->Required) {
			if (!$this->opeartor->IsDetailKey && $this->opeartor->FormValue != NULL && $this->opeartor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->opeartor->caption(), $this->opeartor->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// site
		$this->site->setDbValueDef($rsnew, $this->site->CurrentValue, 0, FALSE);

		// process
		$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, 0, FALSE);

		// sub_process
		$this->sub_process->setDbValueDef($rsnew, $this->sub_process->CurrentValue, 0, FALSE);

		// emp_name
		$this->emp_name->setDbValueDef($rsnew, $this->emp_name->CurrentValue, "", FALSE);

		// jc_no
		$this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, 0, strval($this->jc_no->CurrentValue) == "");

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, FALSE);

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// rid_1
		$this->rid_1->setDbValueDef($rsnew, $this->rid_1->CurrentValue, "", FALSE);

		// packing
		$this->packing->setDbValueDef($rsnew, $this->packing->CurrentValue, 0, FALSE);

		// rid_2
		$this->rid_2->setDbValueDef($rsnew, $this->rid_2->CurrentValue, NULL, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, 0, FALSE);

		// godown
		$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, 0, FALSE);

		// avg_quantity
		$this->avg_quantity->setDbValueDef($rsnew, $this->avg_quantity->CurrentValue, 0, FALSE);

		// lot_no
		$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, "", FALSE);

		// avialable_qty
		$this->avialable_qty->setDbValueDef($rsnew, $this->avialable_qty->CurrentValue, 0, FALSE);

		// ply
		$this->ply->setDbValueDef($rsnew, $this->ply->CurrentValue, NULL, strval($this->ply->CurrentValue) == "");

		// rid_new
		$this->rid_new->setDbValueDef($rsnew, $this->rid_new->CurrentValue, NULL, FALSE);

		// rid_new_lot_no
		$this->rid_new_lot_no->setDbValueDef($rsnew, $this->rid_new_lot_no->CurrentValue, NULL, FALSE);

		// poid_new
		$this->poid_new->setDbValueDef($rsnew, $this->poid_new->CurrentValue, "", FALSE);

		// poid_1
		$this->poid_1->setDbValueDef($rsnew, $this->poid_1->CurrentValue, "", FALSE);

		// poid
		$this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, NULL, FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, FALSE);

		// packets
		$this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, NULL, FALSE);

		// process_method
		$this->process_method->setDbValueDef($rsnew, $this->process_method->CurrentValue, 0, FALSE);

		// remark
		$this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, NULL, FALSE);

		// dated
		$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 0), CurrentDate(), FALSE);

		// opeartor
		$this->opeartor->setDbValueDef($rsnew, CurrentUserID(), 0);
		$rsnew['opeartor'] = &$this->opeartor->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_action_materiallist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_site":
					$lookupFilter = function() {
						return (User_Site() == 0) ? "`status` = 1 and `id` > 0 && `id` != 10" : "`status` = 1 and `id` > 0 && `id` != 10 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status` = 1 and `type_cat` = 101";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_sub_process":
					$lookupFilter = function() {
						return " `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1 and `type`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_1":
					$lookupFilter = function() {
						return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_2":
					$lookupFilter = function() {
						return (isset($_GET['RID1'])) ? ("`rid` = ". $_GET['RID1'] ." and `Balance` > 0") :  ("`Balance` > 0");
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid_new":
					$lookupFilter = function() {
						return "`status`=1 and `product` = 51";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_poid_1":
					$lookupFilter = function() {
						return "`pending_qty`>0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_site":
							break;
						case "x_process":
							break;
						case "x_sub_process":
							break;
						case "x_emp_name":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_jc_no":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid_1":
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							break;
						case "x_packing":
							break;
						case "x_rid_2":
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_rid":
							break;
						case "x_godown":
							break;
						case "x_rid_new":
							break;
						case "x_poid_1":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_payment":
							break;
						case "x_opeartor":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {
			$CUID = CurrentUserID();
			$row = ExecuteScalar("SELECT IFNULL((Select `id` from `process_action_material` where `opeartor` = $CUID order by id desc LIMIT 1),0)");
			$msg = 'Last Insert ID: ' . $row;
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'process_action_material');
		$this->rid->ReadOnly = True;	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>