<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_material_old_edit extends process_action_material_old
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action_material_old';

	// Page object name
	public $PageObjName = "process_action_material_old_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action_material_old)
		if (!isset($GLOBALS["process_action_material_old"]) || get_class($GLOBALS["process_action_material_old"]) == PROJECT_NAMESPACE . "process_action_material_old") {
			$GLOBALS["process_action_material_old"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action_material_old"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_material_old');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action_material_old;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action_material_old);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "process_action_material_oldview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_action_material_oldlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->site->setVisibility();
		$this->process->setVisibility();
		$this->poid->setVisibility();
		$this->jc_no->setVisibility();
		$this->emp_name->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->rid_2->setVisibility();
		$this->quantity->setVisibility();
		$this->packets->setVisibility();
		$this->lot_no->setVisibility();
		$this->packing->setVisibility();
		$this->godown->setVisibility();
		$this->company_id->setVisibility();
		$this->sub_process->setVisibility();
		$this->process_method->setVisibility();
		$this->ply->setVisibility();
		$this->rid_new->setVisibility();
		$this->remark->setVisibility();
		$this->payment->setVisibility();
		$this->dated->setVisibility();
		$this->opeartor->setVisibility();
		$this->datetime->setVisibility();
		$this->rid_new_lot_no->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("process_action_material_oldlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "process_action_material_oldlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'site' first before field var 'x_site'
		$val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
		if (!$this->site->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->site->Visible = FALSE; // Disable update for API request
			else
				$this->site->setFormValue($val);
		}

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'poid' first before field var 'x_poid'
		$val = $CurrentForm->hasValue("poid") ? $CurrentForm->getValue("poid") : $CurrentForm->getValue("x_poid");
		if (!$this->poid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->poid->Visible = FALSE; // Disable update for API request
			else
				$this->poid->setFormValue($val);
		}

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'emp_name' first before field var 'x_emp_name'
		$val = $CurrentForm->hasValue("emp_name") ? $CurrentForm->getValue("emp_name") : $CurrentForm->getValue("x_emp_name");
		if (!$this->emp_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emp_name->Visible = FALSE; // Disable update for API request
			else
				$this->emp_name->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'rid_2' first before field var 'x_rid_2'
		$val = $CurrentForm->hasValue("rid_2") ? $CurrentForm->getValue("rid_2") : $CurrentForm->getValue("x_rid_2");
		if (!$this->rid_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_2->Visible = FALSE; // Disable update for API request
			else
				$this->rid_2->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'packets' first before field var 'x_packets'
		$val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
		if (!$this->packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets->Visible = FALSE; // Disable update for API request
			else
				$this->packets->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'packing' first before field var 'x_packing'
		$val = $CurrentForm->hasValue("packing") ? $CurrentForm->getValue("packing") : $CurrentForm->getValue("x_packing");
		if (!$this->packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing->Visible = FALSE; // Disable update for API request
			else
				$this->packing->setFormValue($val);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'sub_process' first before field var 'x_sub_process'
		$val = $CurrentForm->hasValue("sub_process") ? $CurrentForm->getValue("sub_process") : $CurrentForm->getValue("x_sub_process");
		if (!$this->sub_process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sub_process->Visible = FALSE; // Disable update for API request
			else
				$this->sub_process->setFormValue($val);
		}

		// Check field name 'process_method' first before field var 'x_process_method'
		$val = $CurrentForm->hasValue("process_method") ? $CurrentForm->getValue("process_method") : $CurrentForm->getValue("x_process_method");
		if (!$this->process_method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process_method->Visible = FALSE; // Disable update for API request
			else
				$this->process_method->setFormValue($val);
		}

		// Check field name 'ply' first before field var 'x_ply'
		$val = $CurrentForm->hasValue("ply") ? $CurrentForm->getValue("ply") : $CurrentForm->getValue("x_ply");
		if (!$this->ply->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply->Visible = FALSE; // Disable update for API request
			else
				$this->ply->setFormValue($val);
		}

		// Check field name 'rid_new' first before field var 'x_rid_new'
		$val = $CurrentForm->hasValue("rid_new") ? $CurrentForm->getValue("rid_new") : $CurrentForm->getValue("x_rid_new");
		if (!$this->rid_new->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_new->Visible = FALSE; // Disable update for API request
			else
				$this->rid_new->setFormValue($val);
		}

		// Check field name 'remark' first before field var 'x_remark'
		$val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
		if (!$this->remark->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remark->Visible = FALSE; // Disable update for API request
			else
				$this->remark->setFormValue($val);
		}

		// Check field name 'payment' first before field var 'x_payment'
		$val = $CurrentForm->hasValue("payment") ? $CurrentForm->getValue("payment") : $CurrentForm->getValue("x_payment");
		if (!$this->payment->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment->Visible = FALSE; // Disable update for API request
			else
				$this->payment->setFormValue($val);
		}

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		}

		// Check field name 'opeartor' first before field var 'x_opeartor'
		$val = $CurrentForm->hasValue("opeartor") ? $CurrentForm->getValue("opeartor") : $CurrentForm->getValue("x_opeartor");
		if (!$this->opeartor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->opeartor->Visible = FALSE; // Disable update for API request
			else
				$this->opeartor->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'rid_new_lot_no' first before field var 'x_rid_new_lot_no'
		$val = $CurrentForm->hasValue("rid_new_lot_no") ? $CurrentForm->getValue("rid_new_lot_no") : $CurrentForm->getValue("x_rid_new_lot_no");
		if (!$this->rid_new_lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_new_lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->rid_new_lot_no->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->site->CurrentValue = $this->site->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->poid->CurrentValue = $this->poid->FormValue;
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->emp_name->CurrentValue = $this->emp_name->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->rid_2->CurrentValue = $this->rid_2->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->packets->CurrentValue = $this->packets->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->packing->CurrentValue = $this->packing->FormValue;
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->sub_process->CurrentValue = $this->sub_process->FormValue;
		$this->process_method->CurrentValue = $this->process_method->FormValue;
		$this->ply->CurrentValue = $this->ply->FormValue;
		$this->rid_new->CurrentValue = $this->rid_new->FormValue;
		$this->remark->CurrentValue = $this->remark->FormValue;
		$this->payment->CurrentValue = $this->payment->FormValue;
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		$this->opeartor->CurrentValue = $this->opeartor->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->rid_new_lot_no->CurrentValue = $this->rid_new_lot_no->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->site->setDbValue($row['site']);
		$this->process->setDbValue($row['process']);
		$this->poid->setDbValue($row['poid']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->emp_name->setDbValue($row['emp_name']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->rid_2->setDbValue($row['rid_2']);
		$this->quantity->setDbValue($row['quantity']);
		$this->packets->setDbValue($row['packets']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->packing->setDbValue($row['packing']);
		$this->godown->setDbValue($row['godown']);
		$this->company_id->setDbValue($row['company_id']);
		$this->sub_process->setDbValue($row['sub_process']);
		$this->process_method->setDbValue($row['process_method']);
		$this->ply->setDbValue($row['ply']);
		$this->rid_new->setDbValue($row['rid_new']);
		$this->remark->setDbValue($row['remark']);
		$this->payment->setDbValue($row['payment']);
		$this->dated->setDbValue($row['dated']);
		$this->opeartor->setDbValue($row['opeartor']);
		$this->datetime->setDbValue($row['datetime']);
		$this->rid_new_lot_no->setDbValue($row['rid_new_lot_no']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['site'] = NULL;
		$row['process'] = NULL;
		$row['poid'] = NULL;
		$row['jc_no'] = NULL;
		$row['emp_name'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['rid_2'] = NULL;
		$row['quantity'] = NULL;
		$row['packets'] = NULL;
		$row['lot_no'] = NULL;
		$row['packing'] = NULL;
		$row['godown'] = NULL;
		$row['company_id'] = NULL;
		$row['sub_process'] = NULL;
		$row['process_method'] = NULL;
		$row['ply'] = NULL;
		$row['rid_new'] = NULL;
		$row['remark'] = NULL;
		$row['payment'] = NULL;
		$row['dated'] = NULL;
		$row['opeartor'] = NULL;
		$row['datetime'] = NULL;
		$row['rid_new_lot_no'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets->FormValue == $this->packets->CurrentValue && is_numeric(ConvertToFloatString($this->packets->CurrentValue)))
			$this->packets->CurrentValue = ConvertToFloatString($this->packets->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// site
		// process
		// poid
		// jc_no
		// emp_name
		// grp
		// s_grp
		// product
		// rid
		// rid_2
		// quantity
		// packets
		// lot_no
		// packing
		// godown
		// company_id
		// sub_process
		// process_method
		// ply
		// rid_new
		// remark
		// payment
		// dated
		// opeartor
		// datetime
		// rid_new_lot_no

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// site
			$this->site->ViewValue = $this->site->CurrentValue;
			$this->site->ViewValue = FormatNumber($this->site->ViewValue, 0, -2, -2, -2);
			$this->site->ViewCustomAttributes = "";

			// process
			$this->process->ViewValue = $this->process->CurrentValue;
			$this->process->ViewValue = FormatNumber($this->process->ViewValue, 0, -2, -2, -2);
			$this->process->ViewCustomAttributes = "";

			// poid
			$this->poid->ViewValue = $this->poid->CurrentValue;
			$this->poid->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// emp_name
			$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
			$this->emp_name->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$this->rid->ViewValue = FormatNumber($this->rid->ViewValue, 0, -2, -2, -2);
			$this->rid->ViewCustomAttributes = "";

			// rid_2
			$this->rid_2->ViewValue = $this->rid_2->CurrentValue;
			$this->rid_2->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 2, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// packing
			$this->packing->ViewValue = $this->packing->CurrentValue;
			$this->packing->ViewValue = FormatNumber($this->packing->ViewValue, 0, -2, -2, -2);
			$this->packing->ViewCustomAttributes = "";

			// godown
			$this->godown->ViewValue = $this->godown->CurrentValue;
			$this->godown->ViewValue = FormatNumber($this->godown->ViewValue, 0, -2, -2, -2);
			$this->godown->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
			$this->company_id->ViewCustomAttributes = "";

			// sub_process
			$this->sub_process->ViewValue = $this->sub_process->CurrentValue;
			$this->sub_process->ViewValue = FormatNumber($this->sub_process->ViewValue, 0, -2, -2, -2);
			$this->sub_process->ViewCustomAttributes = "";

			// process_method
			$this->process_method->ViewValue = $this->process_method->CurrentValue;
			$this->process_method->ViewValue = FormatNumber($this->process_method->ViewValue, 0, -2, -2, -2);
			$this->process_method->ViewCustomAttributes = "";

			// ply
			$this->ply->ViewValue = $this->ply->CurrentValue;
			$this->ply->ViewValue = FormatNumber($this->ply->ViewValue, 0, -2, -2, -2);
			$this->ply->ViewCustomAttributes = "";

			// rid_new
			$this->rid_new->ViewValue = $this->rid_new->CurrentValue;
			$this->rid_new->ViewValue = FormatNumber($this->rid_new->ViewValue, 0, -2, -2, -2);
			$this->rid_new->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// payment
			$this->payment->ViewValue = $this->payment->CurrentValue;
			$this->payment->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// opeartor
			$this->opeartor->ViewValue = $this->opeartor->CurrentValue;
			$this->opeartor->ViewValue = FormatNumber($this->opeartor->ViewValue, 0, -2, -2, -2);
			$this->opeartor->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// rid_new_lot_no
			$this->rid_new_lot_no->ViewValue = $this->rid_new_lot_no->CurrentValue;
			$this->rid_new_lot_no->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// site
			$this->site->LinkCustomAttributes = "";
			$this->site->HrefValue = "";
			$this->site->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";
			$this->poid->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			$this->emp_name->HrefValue = "";
			$this->emp_name->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// rid_2
			$this->rid_2->LinkCustomAttributes = "";
			$this->rid_2->HrefValue = "";
			$this->rid_2->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// packing
			$this->packing->LinkCustomAttributes = "";
			$this->packing->HrefValue = "";
			$this->packing->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";
			$this->godown->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// sub_process
			$this->sub_process->LinkCustomAttributes = "";
			$this->sub_process->HrefValue = "";
			$this->sub_process->TooltipValue = "";

			// process_method
			$this->process_method->LinkCustomAttributes = "";
			$this->process_method->HrefValue = "";
			$this->process_method->TooltipValue = "";

			// ply
			$this->ply->LinkCustomAttributes = "";
			$this->ply->HrefValue = "";
			$this->ply->TooltipValue = "";

			// rid_new
			$this->rid_new->LinkCustomAttributes = "";
			$this->rid_new->HrefValue = "";
			$this->rid_new->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";
			$this->payment->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// opeartor
			$this->opeartor->LinkCustomAttributes = "";
			$this->opeartor->HrefValue = "";
			$this->opeartor->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// rid_new_lot_no
			$this->rid_new_lot_no->LinkCustomAttributes = "";
			$this->rid_new_lot_no->HrefValue = "";
			$this->rid_new_lot_no->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// site
			$this->site->EditAttrs["class"] = "form-control";
			$this->site->EditCustomAttributes = "";
			$this->site->EditValue = HtmlEncode($this->site->CurrentValue);
			$this->site->PlaceHolder = RemoveHtml($this->site->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$this->process->EditValue = HtmlEncode($this->process->CurrentValue);
			$this->process->PlaceHolder = RemoveHtml($this->process->caption());

			// poid
			$this->poid->EditAttrs["class"] = "form-control";
			$this->poid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->poid->CurrentValue = HtmlDecode($this->poid->CurrentValue);
			$this->poid->EditValue = HtmlEncode($this->poid->CurrentValue);
			$this->poid->PlaceHolder = RemoveHtml($this->poid->caption());

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->CurrentValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// emp_name
			$this->emp_name->EditAttrs["class"] = "form-control";
			$this->emp_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->emp_name->CurrentValue = HtmlDecode($this->emp_name->CurrentValue);
			$this->emp_name->EditValue = HtmlEncode($this->emp_name->CurrentValue);
			$this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = HtmlEncode($this->grp->CurrentValue);
			$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// rid_2
			$this->rid_2->EditAttrs["class"] = "form-control";
			$this->rid_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rid_2->CurrentValue = HtmlDecode($this->rid_2->CurrentValue);
			$this->rid_2->EditValue = HtmlEncode($this->rid_2->CurrentValue);
			$this->rid_2->PlaceHolder = RemoveHtml($this->rid_2->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->CurrentValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
			if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
				$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -2, -2, -2);

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// packing
			$this->packing->EditAttrs["class"] = "form-control";
			$this->packing->EditCustomAttributes = "";
			$this->packing->EditValue = HtmlEncode($this->packing->CurrentValue);
			$this->packing->PlaceHolder = RemoveHtml($this->packing->caption());

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$this->godown->EditValue = HtmlEncode($this->godown->CurrentValue);
			$this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// sub_process
			$this->sub_process->EditAttrs["class"] = "form-control";
			$this->sub_process->EditCustomAttributes = "";
			$this->sub_process->EditValue = HtmlEncode($this->sub_process->CurrentValue);
			$this->sub_process->PlaceHolder = RemoveHtml($this->sub_process->caption());

			// process_method
			$this->process_method->EditAttrs["class"] = "form-control";
			$this->process_method->EditCustomAttributes = "";
			$this->process_method->EditValue = HtmlEncode($this->process_method->CurrentValue);
			$this->process_method->PlaceHolder = RemoveHtml($this->process_method->caption());

			// ply
			$this->ply->EditAttrs["class"] = "form-control";
			$this->ply->EditCustomAttributes = "";
			$this->ply->EditValue = HtmlEncode($this->ply->CurrentValue);
			$this->ply->PlaceHolder = RemoveHtml($this->ply->caption());

			// rid_new
			$this->rid_new->EditAttrs["class"] = "form-control";
			$this->rid_new->EditCustomAttributes = "";
			$this->rid_new->EditValue = HtmlEncode($this->rid_new->CurrentValue);
			$this->rid_new->PlaceHolder = RemoveHtml($this->rid_new->caption());

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
			$this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// payment
			$this->payment->EditAttrs["class"] = "form-control";
			$this->payment->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment->CurrentValue = HtmlDecode($this->payment->CurrentValue);
			$this->payment->EditValue = HtmlEncode($this->payment->CurrentValue);
			$this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// opeartor
			$this->opeartor->EditAttrs["class"] = "form-control";
			$this->opeartor->EditCustomAttributes = "";
			$this->opeartor->EditValue = HtmlEncode($this->opeartor->CurrentValue);
			$this->opeartor->PlaceHolder = RemoveHtml($this->opeartor->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// rid_new_lot_no
			$this->rid_new_lot_no->EditAttrs["class"] = "form-control";
			$this->rid_new_lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rid_new_lot_no->CurrentValue = HtmlDecode($this->rid_new_lot_no->CurrentValue);
			$this->rid_new_lot_no->EditValue = HtmlEncode($this->rid_new_lot_no->CurrentValue);
			$this->rid_new_lot_no->PlaceHolder = RemoveHtml($this->rid_new_lot_no->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// site
			$this->site->LinkCustomAttributes = "";
			$this->site->HrefValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";

			// poid
			$this->poid->LinkCustomAttributes = "";
			$this->poid->HrefValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			$this->emp_name->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// rid_2
			$this->rid_2->LinkCustomAttributes = "";
			$this->rid_2->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// packing
			$this->packing->LinkCustomAttributes = "";
			$this->packing->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// sub_process
			$this->sub_process->LinkCustomAttributes = "";
			$this->sub_process->HrefValue = "";

			// process_method
			$this->process_method->LinkCustomAttributes = "";
			$this->process_method->HrefValue = "";

			// ply
			$this->ply->LinkCustomAttributes = "";
			$this->ply->HrefValue = "";

			// rid_new
			$this->rid_new->LinkCustomAttributes = "";
			$this->rid_new->HrefValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// opeartor
			$this->opeartor->LinkCustomAttributes = "";
			$this->opeartor->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// rid_new_lot_no
			$this->rid_new_lot_no->LinkCustomAttributes = "";
			$this->rid_new_lot_no->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->site->Required) {
			if (!$this->site->IsDetailKey && $this->site->FormValue != NULL && $this->site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->site->FormValue)) {
			AddMessage($FormError, $this->site->errorMessage());
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->process->FormValue)) {
			AddMessage($FormError, $this->process->errorMessage());
		}
		if ($this->poid->Required) {
			if (!$this->poid->IsDetailKey && $this->poid->FormValue != NULL && $this->poid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->poid->caption(), $this->poid->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_no->FormValue)) {
			AddMessage($FormError, $this->jc_no->errorMessage());
		}
		if ($this->emp_name->Required) {
			if (!$this->emp_name->IsDetailKey && $this->emp_name->FormValue != NULL && $this->emp_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emp_name->caption(), $this->emp_name->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->grp->FormValue)) {
			AddMessage($FormError, $this->grp->errorMessage());
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->s_grp->FormValue)) {
			AddMessage($FormError, $this->s_grp->errorMessage());
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->product->FormValue)) {
			AddMessage($FormError, $this->product->errorMessage());
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->rid->FormValue)) {
			AddMessage($FormError, $this->rid->errorMessage());
		}
		if ($this->rid_2->Required) {
			if (!$this->rid_2->IsDetailKey && $this->rid_2->FormValue != NULL && $this->rid_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_2->caption(), $this->rid_2->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->packets->Required) {
			if (!$this->packets->IsDetailKey && $this->packets->FormValue != NULL && $this->packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->packets->FormValue)) {
			AddMessage($FormError, $this->packets->errorMessage());
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->packing->Required) {
			if (!$this->packing->IsDetailKey && $this->packing->FormValue != NULL && $this->packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing->caption(), $this->packing->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->packing->FormValue)) {
			AddMessage($FormError, $this->packing->errorMessage());
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->godown->FormValue)) {
			AddMessage($FormError, $this->godown->errorMessage());
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->sub_process->Required) {
			if (!$this->sub_process->IsDetailKey && $this->sub_process->FormValue != NULL && $this->sub_process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sub_process->caption(), $this->sub_process->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->sub_process->FormValue)) {
			AddMessage($FormError, $this->sub_process->errorMessage());
		}
		if ($this->process_method->Required) {
			if (!$this->process_method->IsDetailKey && $this->process_method->FormValue != NULL && $this->process_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_method->caption(), $this->process_method->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->process_method->FormValue)) {
			AddMessage($FormError, $this->process_method->errorMessage());
		}
		if ($this->ply->Required) {
			if (!$this->ply->IsDetailKey && $this->ply->FormValue != NULL && $this->ply->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply->caption(), $this->ply->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->ply->FormValue)) {
			AddMessage($FormError, $this->ply->errorMessage());
		}
		if ($this->rid_new->Required) {
			if (!$this->rid_new->IsDetailKey && $this->rid_new->FormValue != NULL && $this->rid_new->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_new->caption(), $this->rid_new->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->rid_new->FormValue)) {
			AddMessage($FormError, $this->rid_new->errorMessage());
		}
		if ($this->remark->Required) {
			if (!$this->remark->IsDetailKey && $this->remark->FormValue != NULL && $this->remark->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
			}
		}
		if ($this->payment->Required) {
			if (!$this->payment->IsDetailKey && $this->payment->FormValue != NULL && $this->payment->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment->caption(), $this->payment->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->payment->FormValue)) {
			AddMessage($FormError, $this->payment->errorMessage());
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dated->FormValue)) {
			AddMessage($FormError, $this->dated->errorMessage());
		}
		if ($this->opeartor->Required) {
			if (!$this->opeartor->IsDetailKey && $this->opeartor->FormValue != NULL && $this->opeartor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->opeartor->caption(), $this->opeartor->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->opeartor->FormValue)) {
			AddMessage($FormError, $this->opeartor->errorMessage());
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->datetime->FormValue)) {
			AddMessage($FormError, $this->datetime->errorMessage());
		}
		if ($this->rid_new_lot_no->Required) {
			if (!$this->rid_new_lot_no->IsDetailKey && $this->rid_new_lot_no->FormValue != NULL && $this->rid_new_lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_new_lot_no->caption(), $this->rid_new_lot_no->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// site
			$this->site->setDbValueDef($rsnew, $this->site->CurrentValue, 0, $this->site->ReadOnly);

			// process
			$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, 0, $this->process->ReadOnly);

			// poid
			$this->poid->setDbValueDef($rsnew, $this->poid->CurrentValue, NULL, $this->poid->ReadOnly);

			// jc_no
			$this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, 0, $this->jc_no->ReadOnly);

			// emp_name
			$this->emp_name->setDbValueDef($rsnew, $this->emp_name->CurrentValue, "", $this->emp_name->ReadOnly);

			// grp
			$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, $this->grp->ReadOnly);

			// s_grp
			$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, $this->s_grp->ReadOnly);

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, $this->product->ReadOnly);

			// rid
			$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, 0, $this->rid->ReadOnly);

			// rid_2
			$this->rid_2->setDbValueDef($rsnew, $this->rid_2->CurrentValue, NULL, $this->rid_2->ReadOnly);

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, $this->quantity->ReadOnly);

			// packets
			$this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, NULL, $this->packets->ReadOnly);

			// lot_no
			$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, "", $this->lot_no->ReadOnly);

			// packing
			$this->packing->setDbValueDef($rsnew, $this->packing->CurrentValue, 0, $this->packing->ReadOnly);

			// godown
			$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, 0, $this->godown->ReadOnly);

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// sub_process
			$this->sub_process->setDbValueDef($rsnew, $this->sub_process->CurrentValue, 0, $this->sub_process->ReadOnly);

			// process_method
			$this->process_method->setDbValueDef($rsnew, $this->process_method->CurrentValue, 0, $this->process_method->ReadOnly);

			// ply
			$this->ply->setDbValueDef($rsnew, $this->ply->CurrentValue, NULL, $this->ply->ReadOnly);

			// rid_new
			$this->rid_new->setDbValueDef($rsnew, $this->rid_new->CurrentValue, NULL, $this->rid_new->ReadOnly);

			// remark
			$this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, NULL, $this->remark->ReadOnly);

			// payment
			$this->payment->setDbValueDef($rsnew, $this->payment->CurrentValue, NULL, $this->payment->ReadOnly);

			// dated
			$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 0), CurrentDate(), $this->dated->ReadOnly);

			// opeartor
			$this->opeartor->setDbValueDef($rsnew, $this->opeartor->CurrentValue, 0, $this->opeartor->ReadOnly);

			// datetime
			$this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, 0), CurrentDate(), $this->datetime->ReadOnly);

			// rid_new_lot_no
			$this->rid_new_lot_no->setDbValueDef($rsnew, $this->rid_new_lot_no->CurrentValue, NULL, $this->rid_new_lot_no->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_action_material_oldlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>