<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for process_action_payment
 */
class process_action_payment extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $location;
	public $process;
	public $emp_id;
	public $emp_grp;
	public $code;
	public $ref;
	public $size_wl;
	public $process_40;
	public $final_amount;
	public $amount;
	public $c_charge;
	public $custom_size;
	public $ded_jc;
	public $ded_pa;
	public $c_id;
	public $payment_type;
	public $sqm;
	public $sqm_grp;
	public $_2_srm;
	public $_4_srm;
	public $process_fix;
	public $method;
	public $datetime;
	public $payment;
	public $grp;
	public $remark;
	public $pps;
	public $uid;
	public $c_method;
	public $category;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'process_action_payment';
		$this->TableName = 'process_action_payment';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`process_action_payment`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('process_action_payment', 'process_action_payment', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// location
		$this->location = new DbField('process_action_payment', 'process_action_payment', 'x_location', 'location', '`location`', '`location`', 18, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->location->Lookup = new Lookup('location', 'godown_table', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// process
		$this->process = new DbField('process_action_payment', 'process_action_payment', 'x_process', 'process', '`process`', '`process`', 2, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process->Lookup = new Lookup('process', 'sub_process_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// emp_id
		$this->emp_id = new DbField('process_action_payment', 'process_action_payment', 'x_emp_id', 'emp_id', '`emp_id`', '`emp_id`', 2, -1, FALSE, '`emp_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->emp_id->Sortable = TRUE; // Allow sort
		$this->emp_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->emp_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->emp_id->Lookup = new Lookup('emp_id', 'production_employee', FALSE, 'id', ["id","user_name","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->emp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['emp_id'] = &$this->emp_id;

		// emp_grp
		$this->emp_grp = new DbField('process_action_payment', 'process_action_payment', 'x_emp_grp', 'emp_grp', '`emp_grp`', '`emp_grp`', 200, -1, FALSE, '`emp_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emp_grp->Nullable = FALSE; // NOT NULL field
		$this->emp_grp->Required = TRUE; // Required field
		$this->emp_grp->Sortable = TRUE; // Allow sort
		$this->fields['emp_grp'] = &$this->emp_grp;

		// code
		$this->code = new DbField('process_action_payment', 'process_action_payment', 'x_code', 'code', '`code`', '`code`', 20, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code->Nullable = FALSE; // NOT NULL field
		$this->code->Required = TRUE; // Required field
		$this->code->Sortable = TRUE; // Allow sort
		$this->fields['code'] = &$this->code;

		// ref
		$this->ref = new DbField('process_action_payment', 'process_action_payment', 'x_ref', 'ref', '`ref`', '`ref`', 200, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ref->Nullable = FALSE; // NOT NULL field
		$this->ref->Required = TRUE; // Required field
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->ref->Lookup = new Lookup('ref', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['ref'] = &$this->ref;

		// size_wl
		$this->size_wl = new DbField('process_action_payment', 'process_action_payment', 'x_size_wl', 'size_wl', '`size_wl`', '`size_wl`', 200, -1, FALSE, '`size_wl`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_wl->Sortable = TRUE; // Allow sort
		$this->size_wl->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['size_wl'] = &$this->size_wl;

		// process_@
		$this->process_40 = new DbField('process_action_payment', 'process_action_payment', 'x_process_40', 'process_@', '`process_@`', '`process_@`', 4, -1, FALSE, '`process_@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process_40->Sortable = TRUE; // Allow sort
		$this->process_40->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_@'] = &$this->process_40;

		// final_amount
		$this->final_amount = new DbField('process_action_payment', 'process_action_payment', 'x_final_amount', 'final_amount', '`final_amount`', '`final_amount`', 4, -1, FALSE, '`final_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->final_amount->Nullable = FALSE; // NOT NULL field
		$this->final_amount->Sortable = TRUE; // Allow sort
		$this->final_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['final_amount'] = &$this->final_amount;

		// amount
		$this->amount = new DbField('process_action_payment', 'process_action_payment', 'x_amount', 'amount', '`amount`', '`amount`', 4, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Nullable = FALSE; // NOT NULL field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// c_charge
		$this->c_charge = new DbField('process_action_payment', 'process_action_payment', 'x_c_charge', 'c_charge', '`c_charge`', '`c_charge`', 4, -1, FALSE, '`c_charge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->c_charge->Nullable = FALSE; // NOT NULL field
		$this->c_charge->Sortable = TRUE; // Allow sort
		$this->c_charge->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['c_charge'] = &$this->c_charge;

		// custom_size
		$this->custom_size = new DbField('process_action_payment', 'process_action_payment', 'x_custom_size', 'custom_size', '`custom_size`', '`custom_size`', 4, -1, FALSE, '`custom_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->custom_size->Nullable = FALSE; // NOT NULL field
		$this->custom_size->Sortable = TRUE; // Allow sort
		$this->custom_size->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['custom_size'] = &$this->custom_size;

		// ded_jc
		$this->ded_jc = new DbField('process_action_payment', 'process_action_payment', 'x_ded_jc', 'ded_jc', '`ded_jc`', '`ded_jc`', 131, -1, FALSE, '`ded_jc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ded_jc->Sortable = TRUE; // Allow sort
		$this->ded_jc->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ded_jc'] = &$this->ded_jc;

		// ded_pa
		$this->ded_pa = new DbField('process_action_payment', 'process_action_payment', 'x_ded_pa', 'ded_pa', '`ded_pa`', '`ded_pa`', 131, -1, FALSE, '`ded_pa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ded_pa->Sortable = TRUE; // Allow sort
		$this->ded_pa->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ded_pa'] = &$this->ded_pa;

		// c_id
		$this->c_id = new DbField('process_action_payment', 'process_action_payment', 'x_c_id', 'c_id', '`c_id`', '`c_id`', 18, -1, FALSE, '`c_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->c_id->Nullable = FALSE; // NOT NULL field
		$this->c_id->Sortable = TRUE; // Allow sort
		$this->c_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->c_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->c_id->Lookup = new Lookup('c_id', 'production_employee', FALSE, 'id', ["id","user_name","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->c_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['c_id'] = &$this->c_id;

		// payment_type
		$this->payment_type = new DbField('process_action_payment', 'process_action_payment', 'x_payment_type', 'payment_type', '`payment_type`', '`payment_type`', 16, -1, FALSE, '`payment_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment_type->Nullable = FALSE; // NOT NULL field
		$this->payment_type->Required = TRUE; // Required field
		$this->payment_type->Sortable = TRUE; // Allow sort
		$this->payment_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment_type->Lookup = new Lookup('payment_type', 'payment_plan', FALSE, 'id', ["yes_no","","",""], [], [], [], [], [], [], '`yes_no` ASC', '');
		$this->payment_type->OptionCount = 2;
		$this->payment_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['payment_type'] = &$this->payment_type;

		// sqm
		$this->sqm = new DbField('process_action_payment', 'process_action_payment', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 4, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// sqm_grp
		$this->sqm_grp = new DbField('process_action_payment', 'process_action_payment', 'x_sqm_grp', 'sqm_grp', '`sqm_grp`', '`sqm_grp`', 4, -1, FALSE, '`sqm_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_grp->Sortable = TRUE; // Allow sort
		$this->sqm_grp->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_grp'] = &$this->sqm_grp;

		// 2_srm
		$this->_2_srm = new DbField('process_action_payment', 'process_action_payment', 'x__2_srm', '2_srm', '`2_srm`', '`2_srm`', 4, -1, FALSE, '`2_srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2_srm->Sortable = TRUE; // Allow sort
		$this->_2_srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['2_srm'] = &$this->_2_srm;

		// 4_srm
		$this->_4_srm = new DbField('process_action_payment', 'process_action_payment', 'x__4_srm', '4_srm', '`4_srm`', '`4_srm`', 4, -1, FALSE, '`4_srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4_srm->Sortable = TRUE; // Allow sort
		$this->_4_srm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['4_srm'] = &$this->_4_srm;

		// process_fix
		$this->process_fix = new DbField('process_action_payment', 'process_action_payment', 'x_process_fix', 'process_fix', '`process_fix`', '`process_fix`', 2, -1, FALSE, '`process_fix`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process_fix->Sortable = TRUE; // Allow sort
		$this->process_fix->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process_fix->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process_fix->Lookup = new Lookup('process_fix', 'payment_plan', FALSE, 'id', ["fix","","",""], [], [], [], [], [], [], '`fix` ASC', '');
		$this->process_fix->OptionCount = 2;
		$this->process_fix->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_fix'] = &$this->process_fix;

		// method
		$this->method = new DbField('process_action_payment', 'process_action_payment', 'x_method', 'method', '`method`', '`method`', 2, -1, FALSE, '`method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->method->Sortable = TRUE; // Allow sort
		$this->method->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->method->Lookup = new Lookup('method', 'payment_plan', FALSE, 'id', ["method","","",""], [], [], [], [], [], [], '`method` ASC', '');
		$this->method->OptionCount = 4;
		$this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['method'] = &$this->method;

		// datetime
		$this->datetime = new DbField('process_action_payment', 'process_action_payment', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// payment
		$this->payment = new DbField('process_action_payment', 'process_action_payment', 'x_payment', 'payment', '`payment`', '`payment`', 200, -1, FALSE, '`payment`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->payment->Sortable = TRUE; // Allow sort
		$this->payment->Lookup = new Lookup('payment', 'payment_period', FALSE, 'id', ["payment_description","","",""], [], [], [], [], [], [], '`payment_description` ASC', '');
		$this->payment->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['payment'] = &$this->payment;

		// grp
		$this->grp = new DbField('process_action_payment', 'process_action_payment', 'x_grp', 'grp', '`grp`', '`grp`', 16, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// remark
		$this->remark = new DbField('process_action_payment', 'process_action_payment', 'x_remark', 'remark', '`remark`', '`remark`', 201, -1, FALSE, '`remark`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remark->Nullable = FALSE; // NOT NULL field
		$this->remark->Required = TRUE; // Required field
		$this->remark->Sortable = TRUE; // Allow sort
		$this->fields['remark'] = &$this->remark;

		// pps
		$this->pps = new DbField('process_action_payment', 'process_action_payment', 'x_pps', 'pps', '`pps`', '`pps`', 18, -1, FALSE, '`pps`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pps->Nullable = FALSE; // NOT NULL field
		$this->pps->Sortable = TRUE; // Allow sort
		$this->pps->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pps'] = &$this->pps;

		// uid
		$this->uid = new DbField('process_action_payment', 'process_action_payment', 'x_uid', 'uid', '`uid`', '`uid`', 200, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->uid->Sortable = FALSE; // Allow sort
		$this->fields['uid'] = &$this->uid;

		// c_method
		$this->c_method = new DbField('process_action_payment', 'process_action_payment', 'x_c_method', 'c_method', '`c_method`', '`c_method`', 2, -1, FALSE, '`c_method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->c_method->Sortable = TRUE; // Allow sort
		$this->c_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['c_method'] = &$this->c_method;

		// category
		$this->category = new DbField('process_action_payment', 'process_action_payment', 'x_category', 'category', '`category`', '`category`', 2, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['category'] = &$this->category;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`process_action_payment`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->location->DbValue = $row['location'];
		$this->process->DbValue = $row['process'];
		$this->emp_id->DbValue = $row['emp_id'];
		$this->emp_grp->DbValue = $row['emp_grp'];
		$this->code->DbValue = $row['code'];
		$this->ref->DbValue = $row['ref'];
		$this->size_wl->DbValue = $row['size_wl'];
		$this->process_40->DbValue = $row['process_@'];
		$this->final_amount->DbValue = $row['final_amount'];
		$this->amount->DbValue = $row['amount'];
		$this->c_charge->DbValue = $row['c_charge'];
		$this->custom_size->DbValue = $row['custom_size'];
		$this->ded_jc->DbValue = $row['ded_jc'];
		$this->ded_pa->DbValue = $row['ded_pa'];
		$this->c_id->DbValue = $row['c_id'];
		$this->payment_type->DbValue = $row['payment_type'];
		$this->sqm->DbValue = $row['sqm'];
		$this->sqm_grp->DbValue = $row['sqm_grp'];
		$this->_2_srm->DbValue = $row['2_srm'];
		$this->_4_srm->DbValue = $row['4_srm'];
		$this->process_fix->DbValue = $row['process_fix'];
		$this->method->DbValue = $row['method'];
		$this->datetime->DbValue = $row['datetime'];
		$this->payment->DbValue = $row['payment'];
		$this->grp->DbValue = $row['grp'];
		$this->remark->DbValue = $row['remark'];
		$this->pps->DbValue = $row['pps'];
		$this->uid->DbValue = $row['uid'];
		$this->c_method->DbValue = $row['c_method'];
		$this->category->DbValue = $row['category'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "process_action_paymentlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "process_action_paymentview.php")
			return $Language->phrase("View");
		elseif ($pageName == "process_action_paymentedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "process_action_paymentadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "process_action_paymentlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("process_action_paymentview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("process_action_paymentview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "process_action_paymentadd.php?" . $this->getUrlParm($parm);
		else
			$url = "process_action_paymentadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("process_action_paymentedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("process_action_paymentadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("process_action_paymentdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->location->setDbValue($rs->fields('location'));
		$this->process->setDbValue($rs->fields('process'));
		$this->emp_id->setDbValue($rs->fields('emp_id'));
		$this->emp_grp->setDbValue($rs->fields('emp_grp'));
		$this->code->setDbValue($rs->fields('code'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->size_wl->setDbValue($rs->fields('size_wl'));
		$this->process_40->setDbValue($rs->fields('process_@'));
		$this->final_amount->setDbValue($rs->fields('final_amount'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->c_charge->setDbValue($rs->fields('c_charge'));
		$this->custom_size->setDbValue($rs->fields('custom_size'));
		$this->ded_jc->setDbValue($rs->fields('ded_jc'));
		$this->ded_pa->setDbValue($rs->fields('ded_pa'));
		$this->c_id->setDbValue($rs->fields('c_id'));
		$this->payment_type->setDbValue($rs->fields('payment_type'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->sqm_grp->setDbValue($rs->fields('sqm_grp'));
		$this->_2_srm->setDbValue($rs->fields('2_srm'));
		$this->_4_srm->setDbValue($rs->fields('4_srm'));
		$this->process_fix->setDbValue($rs->fields('process_fix'));
		$this->method->setDbValue($rs->fields('method'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->payment->setDbValue($rs->fields('payment'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->remark->setDbValue($rs->fields('remark'));
		$this->pps->setDbValue($rs->fields('pps'));
		$this->uid->setDbValue($rs->fields('uid'));
		$this->c_method->setDbValue($rs->fields('c_method'));
		$this->category->setDbValue($rs->fields('category'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// location
		// process
		// emp_id
		// emp_grp
		// code
		// ref
		// size_wl
		// process_@
		// final_amount
		// amount
		// c_charge
		// custom_size
		// ded_jc
		// ded_pa
		// c_id
		// payment_type
		// sqm
		// sqm_grp
		// 2_srm
		// 4_srm
		// process_fix
		// method
		// datetime
		// payment
		// grp
		// remark
		// pps
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// c_method
		// category
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// location
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// emp_id
		$curVal = strval($this->emp_id->CurrentValue);
		if ($curVal <> "") {
			$this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
			if ($this->emp_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->emp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->emp_id->ViewValue = $this->emp_id->CurrentValue;
				}
			}
		} else {
			$this->emp_id->ViewValue = NULL;
		}
		$this->emp_id->ViewCustomAttributes = "";

		// emp_grp
		$this->emp_grp->ViewValue = $this->emp_grp->CurrentValue;
		$this->emp_grp->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// ref
		$curVal = strval($this->ref->CurrentValue);
		if ($curVal <> "") {
			$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
			if ($this->ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ref->ViewValue = $this->ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ref->ViewValue = $this->ref->CurrentValue;
				}
			}
		} else {
			$this->ref->ViewValue = NULL;
		}
		$this->ref->ViewCustomAttributes = "";

		// size_wl
		$this->size_wl->ViewValue = $this->size_wl->CurrentValue;
		$this->size_wl->ViewCustomAttributes = "";

		// process_@
		$this->process_40->ViewValue = $this->process_40->CurrentValue;
		$this->process_40->ViewValue = FormatNumber($this->process_40->ViewValue, 2, -2, -2, -2);
		$this->process_40->ViewCustomAttributes = "";

		// final_amount
		$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
		$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
		$this->final_amount->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// c_charge
		$this->c_charge->ViewValue = $this->c_charge->CurrentValue;
		$this->c_charge->ViewValue = FormatNumber($this->c_charge->ViewValue, 2, -2, -2, -2);
		$this->c_charge->ViewCustomAttributes = "";

		// custom_size
		$this->custom_size->ViewValue = $this->custom_size->CurrentValue;
		$this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, 2, -2, -2, -2);
		$this->custom_size->ViewCustomAttributes = "";

		// ded_jc
		$this->ded_jc->ViewValue = $this->ded_jc->CurrentValue;
		$this->ded_jc->ViewValue = FormatNumber($this->ded_jc->ViewValue, 2, -2, -2, -2);
		$this->ded_jc->ViewCustomAttributes = "";

		// ded_pa
		$this->ded_pa->ViewValue = $this->ded_pa->CurrentValue;
		$this->ded_pa->ViewValue = FormatNumber($this->ded_pa->ViewValue, 2, -2, -2, -2);
		$this->ded_pa->ViewCustomAttributes = "";

		// c_id
		$curVal = strval($this->c_id->CurrentValue);
		if ($curVal <> "") {
			$this->c_id->ViewValue = $this->c_id->lookupCacheOption($curVal);
			if ($this->c_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`=99 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->c_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->c_id->ViewValue = $this->c_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->c_id->ViewValue = $this->c_id->CurrentValue;
				}
			}
		} else {
			$this->c_id->ViewValue = NULL;
		}
		$this->c_id->ViewCustomAttributes = "";

		// payment_type
		if (strval($this->payment_type->CurrentValue) <> "") {
			$this->payment_type->ViewValue = $this->payment_type->optionCaption($this->payment_type->CurrentValue);
		} else {
			$this->payment_type->ViewValue = NULL;
		}
		$this->payment_type->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_grp
		$this->sqm_grp->ViewValue = $this->sqm_grp->CurrentValue;
		$this->sqm_grp->ViewValue = FormatNumber($this->sqm_grp->ViewValue, 2, -2, -2, -2);
		$this->sqm_grp->ViewCustomAttributes = "";

		// 2_srm
		$this->_2_srm->ViewValue = $this->_2_srm->CurrentValue;
		$this->_2_srm->ViewValue = FormatNumber($this->_2_srm->ViewValue, 2, -2, -2, -2);
		$this->_2_srm->ViewCustomAttributes = "";

		// 4_srm
		$this->_4_srm->ViewValue = $this->_4_srm->CurrentValue;
		$this->_4_srm->ViewValue = FormatNumber($this->_4_srm->ViewValue, 2, -2, -2, -2);
		$this->_4_srm->ViewCustomAttributes = "";

		// process_fix
		if (strval($this->process_fix->CurrentValue) <> "") {
			$this->process_fix->ViewValue = $this->process_fix->optionCaption($this->process_fix->CurrentValue);
		} else {
			$this->process_fix->ViewValue = NULL;
		}
		$this->process_fix->ViewCustomAttributes = "";

		// method
		if (strval($this->method->CurrentValue) <> "") {
			$this->method->ViewValue = $this->method->optionCaption($this->method->CurrentValue);
		} else {
			$this->method->ViewValue = NULL;
		}
		$this->method->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// payment
		$curVal = strval($this->payment->CurrentValue);
		if ($curVal <> "") {
			$this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
			if ($this->payment->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->payment->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->payment->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment->ViewValue->add($this->payment->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->payment->ViewValue = $this->payment->CurrentValue;
				}
			}
		} else {
			$this->payment->ViewValue = NULL;
		}
		$this->payment->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// remark
		$this->remark->ViewValue = $this->remark->CurrentValue;
		$this->remark->ViewCustomAttributes = "";

		// pps
		$this->pps->ViewValue = $this->pps->CurrentValue;
		$this->pps->ViewValue = FormatNumber($this->pps->ViewValue, 0, -2, -2, -2);
		$this->pps->ViewCustomAttributes = "";

		// uid
		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// c_method
		$this->c_method->ViewValue = $this->c_method->CurrentValue;
		$this->c_method->ViewValue = FormatNumber($this->c_method->ViewValue, 0, -2, -2, -2);
		$this->c_method->ViewCustomAttributes = "";

		// category
		$this->category->ViewValue = $this->category->CurrentValue;
		$this->category->ViewValue = FormatNumber($this->category->ViewValue, 0, -2, -2, -2);
		$this->category->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// emp_id
		$this->emp_id->LinkCustomAttributes = "";
		$this->emp_id->HrefValue = "";
		$this->emp_id->TooltipValue = "";

		// emp_grp
		$this->emp_grp->LinkCustomAttributes = "";
		$this->emp_grp->HrefValue = "";
		$this->emp_grp->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		$this->code->HrefValue = "";
		$this->code->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// size_wl
		$this->size_wl->LinkCustomAttributes = "";
		$this->size_wl->HrefValue = "";
		$this->size_wl->TooltipValue = "";

		// process_@
		$this->process_40->LinkCustomAttributes = "";
		$this->process_40->HrefValue = "";
		$this->process_40->TooltipValue = "";

		// final_amount
		$this->final_amount->LinkCustomAttributes = "";
		$this->final_amount->HrefValue = "";
		$this->final_amount->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// c_charge
		$this->c_charge->LinkCustomAttributes = "";
		$this->c_charge->HrefValue = "";
		$this->c_charge->TooltipValue = "";

		// custom_size
		$this->custom_size->LinkCustomAttributes = "";
		$this->custom_size->HrefValue = "";
		$this->custom_size->TooltipValue = "";

		// ded_jc
		$this->ded_jc->LinkCustomAttributes = "";
		$this->ded_jc->HrefValue = "";
		$this->ded_jc->TooltipValue = "";

		// ded_pa
		$this->ded_pa->LinkCustomAttributes = "";
		$this->ded_pa->HrefValue = "";
		$this->ded_pa->TooltipValue = "";

		// c_id
		$this->c_id->LinkCustomAttributes = "";
		$this->c_id->HrefValue = "";
		$this->c_id->TooltipValue = "";

		// payment_type
		$this->payment_type->LinkCustomAttributes = "";
		$this->payment_type->HrefValue = "";
		$this->payment_type->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// sqm_grp
		$this->sqm_grp->LinkCustomAttributes = "";
		$this->sqm_grp->HrefValue = "";
		$this->sqm_grp->TooltipValue = "";

		// 2_srm
		$this->_2_srm->LinkCustomAttributes = "";
		$this->_2_srm->HrefValue = "";
		$this->_2_srm->TooltipValue = "";

		// 4_srm
		$this->_4_srm->LinkCustomAttributes = "";
		$this->_4_srm->HrefValue = "";
		$this->_4_srm->TooltipValue = "";

		// process_fix
		$this->process_fix->LinkCustomAttributes = "";
		$this->process_fix->HrefValue = "";
		$this->process_fix->TooltipValue = "";

		// method
		$this->method->LinkCustomAttributes = "";
		$this->method->HrefValue = "";
		$this->method->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// payment
		$this->payment->LinkCustomAttributes = "";
		$this->payment->HrefValue = "";
		$this->payment->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// remark
		$this->remark->LinkCustomAttributes = "";
		$this->remark->HrefValue = "";
		$this->remark->TooltipValue = "";

		// pps
		$this->pps->LinkCustomAttributes = "";
		$this->pps->HrefValue = "";
		$this->pps->TooltipValue = "";

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// c_method
		$this->c_method->LinkCustomAttributes = "";
		$this->c_method->HrefValue = "";
		$this->c_method->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";

		// emp_id
		$this->emp_id->EditAttrs["class"] = "form-control";
		$this->emp_id->EditCustomAttributes = "";

		// emp_grp
		$this->emp_grp->EditAttrs["class"] = "form-control";
		$this->emp_grp->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->emp_grp->CurrentValue = HtmlDecode($this->emp_grp->CurrentValue);
		$this->emp_grp->EditValue = $this->emp_grp->CurrentValue;
		$this->emp_grp->PlaceHolder = RemoveHtml($this->emp_grp->caption());

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = "";
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->PlaceHolder = RemoveHtml($this->code->caption());

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";

		// size_wl
		$this->size_wl->EditAttrs["class"] = "form-control";
		$this->size_wl->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_wl->CurrentValue = HtmlDecode($this->size_wl->CurrentValue);
		$this->size_wl->EditValue = $this->size_wl->CurrentValue;
		$this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

		// process_@
		$this->process_40->EditAttrs["class"] = "form-control";
		$this->process_40->EditCustomAttributes = "";
		$this->process_40->EditValue = $this->process_40->CurrentValue;
		$this->process_40->PlaceHolder = RemoveHtml($this->process_40->caption());
		if (strval($this->process_40->EditValue) <> "" && is_numeric($this->process_40->EditValue))
			$this->process_40->EditValue = FormatNumber($this->process_40->EditValue, -2, -2, -2, -2);

		// final_amount
		$this->final_amount->EditAttrs["class"] = "form-control";
		$this->final_amount->EditCustomAttributes = "";
		$this->final_amount->EditValue = $this->final_amount->CurrentValue;
		$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());
		if (strval($this->final_amount->EditValue) <> "" && is_numeric($this->final_amount->EditValue))
			$this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, -2, -2, -2, -2);

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// c_charge
		$this->c_charge->EditAttrs["class"] = "form-control";
		$this->c_charge->EditCustomAttributes = "";
		$this->c_charge->EditValue = $this->c_charge->CurrentValue;
		$this->c_charge->PlaceHolder = RemoveHtml($this->c_charge->caption());
		if (strval($this->c_charge->EditValue) <> "" && is_numeric($this->c_charge->EditValue))
			$this->c_charge->EditValue = FormatNumber($this->c_charge->EditValue, -2, -2, -2, -2);

		// custom_size
		$this->custom_size->EditAttrs["class"] = "form-control";
		$this->custom_size->EditCustomAttributes = "";
		$this->custom_size->EditValue = $this->custom_size->CurrentValue;
		$this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());
		if (strval($this->custom_size->EditValue) <> "" && is_numeric($this->custom_size->EditValue))
			$this->custom_size->EditValue = FormatNumber($this->custom_size->EditValue, -2, -2, -2, -2);

		// ded_jc
		$this->ded_jc->EditAttrs["class"] = "form-control";
		$this->ded_jc->EditCustomAttributes = "";
		$this->ded_jc->EditValue = $this->ded_jc->CurrentValue;
		$this->ded_jc->PlaceHolder = RemoveHtml($this->ded_jc->caption());
		if (strval($this->ded_jc->EditValue) <> "" && is_numeric($this->ded_jc->EditValue))
			$this->ded_jc->EditValue = FormatNumber($this->ded_jc->EditValue, -2, -2, -2, -2);

		// ded_pa
		$this->ded_pa->EditAttrs["class"] = "form-control";
		$this->ded_pa->EditCustomAttributes = "";
		$this->ded_pa->EditValue = $this->ded_pa->CurrentValue;
		$this->ded_pa->PlaceHolder = RemoveHtml($this->ded_pa->caption());
		if (strval($this->ded_pa->EditValue) <> "" && is_numeric($this->ded_pa->EditValue))
			$this->ded_pa->EditValue = FormatNumber($this->ded_pa->EditValue, -2, -2, -2, -2);

		// c_id
		$this->c_id->EditAttrs["class"] = "form-control";
		$this->c_id->EditCustomAttributes = "";

		// payment_type
		$this->payment_type->EditAttrs["class"] = "form-control";
		$this->payment_type->EditCustomAttributes = "";
		$this->payment_type->EditValue = $this->payment_type->options(TRUE);

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// sqm_grp
		$this->sqm_grp->EditAttrs["class"] = "form-control";
		$this->sqm_grp->EditCustomAttributes = "";
		$this->sqm_grp->EditValue = $this->sqm_grp->CurrentValue;
		$this->sqm_grp->PlaceHolder = RemoveHtml($this->sqm_grp->caption());
		if (strval($this->sqm_grp->EditValue) <> "" && is_numeric($this->sqm_grp->EditValue))
			$this->sqm_grp->EditValue = FormatNumber($this->sqm_grp->EditValue, -2, -2, -2, -2);

		// 2_srm
		$this->_2_srm->EditAttrs["class"] = "form-control";
		$this->_2_srm->EditCustomAttributes = "";
		$this->_2_srm->EditValue = $this->_2_srm->CurrentValue;
		$this->_2_srm->PlaceHolder = RemoveHtml($this->_2_srm->caption());
		if (strval($this->_2_srm->EditValue) <> "" && is_numeric($this->_2_srm->EditValue))
			$this->_2_srm->EditValue = FormatNumber($this->_2_srm->EditValue, -2, -2, -2, -2);

		// 4_srm
		$this->_4_srm->EditAttrs["class"] = "form-control";
		$this->_4_srm->EditCustomAttributes = "";
		$this->_4_srm->EditValue = $this->_4_srm->CurrentValue;
		$this->_4_srm->PlaceHolder = RemoveHtml($this->_4_srm->caption());
		if (strval($this->_4_srm->EditValue) <> "" && is_numeric($this->_4_srm->EditValue))
			$this->_4_srm->EditValue = FormatNumber($this->_4_srm->EditValue, -2, -2, -2, -2);

		// process_fix
		$this->process_fix->EditAttrs["class"] = "form-control";
		$this->process_fix->EditCustomAttributes = "";
		$this->process_fix->EditValue = $this->process_fix->options(TRUE);

		// method
		$this->method->EditAttrs["class"] = "form-control";
		$this->method->EditCustomAttributes = "";
		$this->method->EditValue = $this->method->options(TRUE);

		// datetime
		// payment

		$this->payment->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// remark
		$this->remark->EditAttrs["class"] = "form-control";
		$this->remark->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
		$this->remark->EditValue = $this->remark->CurrentValue;
		$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

		// pps
		$this->pps->EditAttrs["class"] = "form-control";
		$this->pps->EditCustomAttributes = "";
		$this->pps->EditValue = $this->pps->CurrentValue;
		$this->pps->PlaceHolder = RemoveHtml($this->pps->caption());

		// uid
		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

		// c_method
		$this->c_method->EditAttrs["class"] = "form-control";
		$this->c_method->EditCustomAttributes = "";
		$this->c_method->EditValue = $this->c_method->CurrentValue;
		$this->c_method->PlaceHolder = RemoveHtml($this->c_method->caption());

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";
		$this->category->EditValue = $this->category->CurrentValue;
		$this->category->PlaceHolder = RemoveHtml($this->category->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->final_amount->CurrentValue))
				$this->final_amount->Total += $this->final_amount->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->final_amount->CurrentValue = $this->final_amount->Total;
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";
			$this->final_amount->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->emp_id);
					$doc->exportCaption($this->emp_grp);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->size_wl);
					$doc->exportCaption($this->process_40);
					$doc->exportCaption($this->final_amount);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->c_charge);
					$doc->exportCaption($this->custom_size);
					$doc->exportCaption($this->ded_jc);
					$doc->exportCaption($this->ded_pa);
					$doc->exportCaption($this->c_id);
					$doc->exportCaption($this->payment_type);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->sqm_grp);
					$doc->exportCaption($this->_2_srm);
					$doc->exportCaption($this->_4_srm);
					$doc->exportCaption($this->process_fix);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->payment);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->remark);
					$doc->exportCaption($this->pps);
					$doc->exportCaption($this->c_method);
					$doc->exportCaption($this->category);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->emp_id);
					$doc->exportCaption($this->emp_grp);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->size_wl);
					$doc->exportCaption($this->process_40);
					$doc->exportCaption($this->final_amount);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->c_charge);
					$doc->exportCaption($this->custom_size);
					$doc->exportCaption($this->ded_jc);
					$doc->exportCaption($this->ded_pa);
					$doc->exportCaption($this->c_id);
					$doc->exportCaption($this->payment_type);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->sqm_grp);
					$doc->exportCaption($this->_2_srm);
					$doc->exportCaption($this->_4_srm);
					$doc->exportCaption($this->process_fix);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->payment);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->remark);
					$doc->exportCaption($this->pps);
					$doc->exportCaption($this->c_method);
					$doc->exportCaption($this->category);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->location);
						$doc->exportField($this->process);
						$doc->exportField($this->emp_id);
						$doc->exportField($this->emp_grp);
						$doc->exportField($this->code);
						$doc->exportField($this->ref);
						$doc->exportField($this->size_wl);
						$doc->exportField($this->process_40);
						$doc->exportField($this->final_amount);
						$doc->exportField($this->amount);
						$doc->exportField($this->c_charge);
						$doc->exportField($this->custom_size);
						$doc->exportField($this->ded_jc);
						$doc->exportField($this->ded_pa);
						$doc->exportField($this->c_id);
						$doc->exportField($this->payment_type);
						$doc->exportField($this->sqm);
						$doc->exportField($this->sqm_grp);
						$doc->exportField($this->_2_srm);
						$doc->exportField($this->_4_srm);
						$doc->exportField($this->process_fix);
						$doc->exportField($this->method);
						$doc->exportField($this->datetime);
						$doc->exportField($this->payment);
						$doc->exportField($this->grp);
						$doc->exportField($this->remark);
						$doc->exportField($this->pps);
						$doc->exportField($this->c_method);
						$doc->exportField($this->category);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->location);
						$doc->exportField($this->process);
						$doc->exportField($this->emp_id);
						$doc->exportField($this->emp_grp);
						$doc->exportField($this->code);
						$doc->exportField($this->ref);
						$doc->exportField($this->size_wl);
						$doc->exportField($this->process_40);
						$doc->exportField($this->final_amount);
						$doc->exportField($this->amount);
						$doc->exportField($this->c_charge);
						$doc->exportField($this->custom_size);
						$doc->exportField($this->ded_jc);
						$doc->exportField($this->ded_pa);
						$doc->exportField($this->c_id);
						$doc->exportField($this->payment_type);
						$doc->exportField($this->sqm);
						$doc->exportField($this->sqm_grp);
						$doc->exportField($this->_2_srm);
						$doc->exportField($this->_4_srm);
						$doc->exportField($this->process_fix);
						$doc->exportField($this->method);
						$doc->exportField($this->datetime);
						$doc->exportField($this->payment);
						$doc->exportField($this->grp);
						$doc->exportField($this->remark);
						$doc->exportField($this->pps);
						$doc->exportField($this->c_method);
						$doc->exportField($this->category);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->location, '');
				$doc->exportAggregate($this->process, '');
				$doc->exportAggregate($this->emp_id, '');
				$doc->exportAggregate($this->emp_grp, '');
				$doc->exportAggregate($this->code, '');
				$doc->exportAggregate($this->ref, '');
				$doc->exportAggregate($this->size_wl, '');
				$doc->exportAggregate($this->process_40, '');
				$doc->exportAggregate($this->final_amount, 'TOTAL');
				$doc->exportAggregate($this->amount, '');
				$doc->exportAggregate($this->c_charge, '');
				$doc->exportAggregate($this->custom_size, '');
				$doc->exportAggregate($this->ded_jc, '');
				$doc->exportAggregate($this->ded_pa, '');
				$doc->exportAggregate($this->c_id, '');
				$doc->exportAggregate($this->payment_type, '');
				$doc->exportAggregate($this->sqm, '');
				$doc->exportAggregate($this->sqm_grp, '');
				$doc->exportAggregate($this->_2_srm, '');
				$doc->exportAggregate($this->_4_srm, '');
				$doc->exportAggregate($this->process_fix, '');
				$doc->exportAggregate($this->method, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->exportAggregate($this->payment, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->remark, '');
				$doc->exportAggregate($this->pps, '');
				$doc->exportAggregate($this->c_method, '');
				$doc->exportAggregate($this->category, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'process_action_payment';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'process_action_payment';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'process_action_payment';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'process_action_payment';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>