<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_payment_list extends process_action_payment
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action_payment';

	// Page object name
	public $PageObjName = "process_action_payment_list";

	// Grid form hidden field names
	public $FormName = "fprocess_action_paymentlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action_payment)
		if (!isset($GLOBALS["process_action_payment"]) || get_class($GLOBALS["process_action_payment"]) == PROJECT_NAMESPACE . "process_action_payment") {
			$GLOBALS["process_action_payment"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action_payment"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "process_action_paymentadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "process_action_paymentdelete.php";
		$this->MultiUpdateUrl = "process_action_paymentupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_payment');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fprocess_action_paymentlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action_payment;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action_payment);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->location->setVisibility();
		$this->process->setVisibility();
		$this->emp_id->setVisibility();
		$this->emp_grp->setVisibility();
		$this->code->setVisibility();
		$this->ref->setVisibility();
		$this->size_wl->setVisibility();
		$this->process_40->setVisibility();
		$this->final_amount->setVisibility();
		$this->amount->setVisibility();
		$this->c_charge->setVisibility();
		$this->custom_size->setVisibility();
		$this->ded_jc->setVisibility();
		$this->ded_pa->setVisibility();
		$this->c_id->setVisibility();
		$this->payment_type->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_grp->setVisibility();
		$this->_2_srm->setVisibility();
		$this->_4_srm->setVisibility();
		$this->process_fix->setVisibility();
		$this->method->setVisibility();
		$this->datetime->setVisibility();
		$this->payment->setVisibility();
		$this->grp->Visible = FALSE;
		$this->remark->setVisibility();
		$this->pps->Visible = FALSE;
		$this->uid->Visible = FALSE;
		$this->c_method->setVisibility();
		$this->category->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->emp_id);
		$this->setupLookupOptions($this->ref);
		$this->setupLookupOptions($this->c_id);
		$this->setupLookupOptions($this->payment);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fprocess_action_paymentlistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->location->AdvancedSearch->toJson(), ","); // Field location
		$filterList = Concat($filterList, $this->process->AdvancedSearch->toJson(), ","); // Field process
		$filterList = Concat($filterList, $this->emp_id->AdvancedSearch->toJson(), ","); // Field emp_id
		$filterList = Concat($filterList, $this->code->AdvancedSearch->toJson(), ","); // Field code
		$filterList = Concat($filterList, $this->ref->AdvancedSearch->toJson(), ","); // Field ref
		$filterList = Concat($filterList, $this->size_wl->AdvancedSearch->toJson(), ","); // Field size_wl
		$filterList = Concat($filterList, $this->process_40->AdvancedSearch->toJson(), ","); // Field process_@
		$filterList = Concat($filterList, $this->final_amount->AdvancedSearch->toJson(), ","); // Field final_amount
		$filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
		$filterList = Concat($filterList, $this->c_charge->AdvancedSearch->toJson(), ","); // Field c_charge
		$filterList = Concat($filterList, $this->custom_size->AdvancedSearch->toJson(), ","); // Field custom_size
		$filterList = Concat($filterList, $this->ded_jc->AdvancedSearch->toJson(), ","); // Field ded_jc
		$filterList = Concat($filterList, $this->ded_pa->AdvancedSearch->toJson(), ","); // Field ded_pa
		$filterList = Concat($filterList, $this->c_id->AdvancedSearch->toJson(), ","); // Field c_id
		$filterList = Concat($filterList, $this->payment_type->AdvancedSearch->toJson(), ","); // Field payment_type
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->sqm_grp->AdvancedSearch->toJson(), ","); // Field sqm_grp
		$filterList = Concat($filterList, $this->_2_srm->AdvancedSearch->toJson(), ","); // Field 2_srm
		$filterList = Concat($filterList, $this->_4_srm->AdvancedSearch->toJson(), ","); // Field 4_srm
		$filterList = Concat($filterList, $this->process_fix->AdvancedSearch->toJson(), ","); // Field process_fix
		$filterList = Concat($filterList, $this->method->AdvancedSearch->toJson(), ","); // Field method
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->payment->AdvancedSearch->toJson(), ","); // Field payment
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->remark->AdvancedSearch->toJson(), ","); // Field remark
		$filterList = Concat($filterList, $this->pps->AdvancedSearch->toJson(), ","); // Field pps
		$filterList = Concat($filterList, $this->c_method->AdvancedSearch->toJson(), ","); // Field c_method
		$filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fprocess_action_paymentlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field location
		$this->location->AdvancedSearch->SearchValue = @$filter["x_location"];
		$this->location->AdvancedSearch->SearchOperator = @$filter["z_location"];
		$this->location->AdvancedSearch->SearchCondition = @$filter["v_location"];
		$this->location->AdvancedSearch->SearchValue2 = @$filter["y_location"];
		$this->location->AdvancedSearch->SearchOperator2 = @$filter["w_location"];
		$this->location->AdvancedSearch->save();

		// Field process
		$this->process->AdvancedSearch->SearchValue = @$filter["x_process"];
		$this->process->AdvancedSearch->SearchOperator = @$filter["z_process"];
		$this->process->AdvancedSearch->SearchCondition = @$filter["v_process"];
		$this->process->AdvancedSearch->SearchValue2 = @$filter["y_process"];
		$this->process->AdvancedSearch->SearchOperator2 = @$filter["w_process"];
		$this->process->AdvancedSearch->save();

		// Field emp_id
		$this->emp_id->AdvancedSearch->SearchValue = @$filter["x_emp_id"];
		$this->emp_id->AdvancedSearch->SearchOperator = @$filter["z_emp_id"];
		$this->emp_id->AdvancedSearch->SearchCondition = @$filter["v_emp_id"];
		$this->emp_id->AdvancedSearch->SearchValue2 = @$filter["y_emp_id"];
		$this->emp_id->AdvancedSearch->SearchOperator2 = @$filter["w_emp_id"];
		$this->emp_id->AdvancedSearch->save();

		// Field code
		$this->code->AdvancedSearch->SearchValue = @$filter["x_code"];
		$this->code->AdvancedSearch->SearchOperator = @$filter["z_code"];
		$this->code->AdvancedSearch->SearchCondition = @$filter["v_code"];
		$this->code->AdvancedSearch->SearchValue2 = @$filter["y_code"];
		$this->code->AdvancedSearch->SearchOperator2 = @$filter["w_code"];
		$this->code->AdvancedSearch->save();

		// Field ref
		$this->ref->AdvancedSearch->SearchValue = @$filter["x_ref"];
		$this->ref->AdvancedSearch->SearchOperator = @$filter["z_ref"];
		$this->ref->AdvancedSearch->SearchCondition = @$filter["v_ref"];
		$this->ref->AdvancedSearch->SearchValue2 = @$filter["y_ref"];
		$this->ref->AdvancedSearch->SearchOperator2 = @$filter["w_ref"];
		$this->ref->AdvancedSearch->save();

		// Field size_wl
		$this->size_wl->AdvancedSearch->SearchValue = @$filter["x_size_wl"];
		$this->size_wl->AdvancedSearch->SearchOperator = @$filter["z_size_wl"];
		$this->size_wl->AdvancedSearch->SearchCondition = @$filter["v_size_wl"];
		$this->size_wl->AdvancedSearch->SearchValue2 = @$filter["y_size_wl"];
		$this->size_wl->AdvancedSearch->SearchOperator2 = @$filter["w_size_wl"];
		$this->size_wl->AdvancedSearch->save();

		// Field process_@
		$this->process_40->AdvancedSearch->SearchValue = @$filter["x_process_40"];
		$this->process_40->AdvancedSearch->SearchOperator = @$filter["z_process_40"];
		$this->process_40->AdvancedSearch->SearchCondition = @$filter["v_process_40"];
		$this->process_40->AdvancedSearch->SearchValue2 = @$filter["y_process_40"];
		$this->process_40->AdvancedSearch->SearchOperator2 = @$filter["w_process_40"];
		$this->process_40->AdvancedSearch->save();

		// Field final_amount
		$this->final_amount->AdvancedSearch->SearchValue = @$filter["x_final_amount"];
		$this->final_amount->AdvancedSearch->SearchOperator = @$filter["z_final_amount"];
		$this->final_amount->AdvancedSearch->SearchCondition = @$filter["v_final_amount"];
		$this->final_amount->AdvancedSearch->SearchValue2 = @$filter["y_final_amount"];
		$this->final_amount->AdvancedSearch->SearchOperator2 = @$filter["w_final_amount"];
		$this->final_amount->AdvancedSearch->save();

		// Field amount
		$this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
		$this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
		$this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
		$this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
		$this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
		$this->amount->AdvancedSearch->save();

		// Field c_charge
		$this->c_charge->AdvancedSearch->SearchValue = @$filter["x_c_charge"];
		$this->c_charge->AdvancedSearch->SearchOperator = @$filter["z_c_charge"];
		$this->c_charge->AdvancedSearch->SearchCondition = @$filter["v_c_charge"];
		$this->c_charge->AdvancedSearch->SearchValue2 = @$filter["y_c_charge"];
		$this->c_charge->AdvancedSearch->SearchOperator2 = @$filter["w_c_charge"];
		$this->c_charge->AdvancedSearch->save();

		// Field custom_size
		$this->custom_size->AdvancedSearch->SearchValue = @$filter["x_custom_size"];
		$this->custom_size->AdvancedSearch->SearchOperator = @$filter["z_custom_size"];
		$this->custom_size->AdvancedSearch->SearchCondition = @$filter["v_custom_size"];
		$this->custom_size->AdvancedSearch->SearchValue2 = @$filter["y_custom_size"];
		$this->custom_size->AdvancedSearch->SearchOperator2 = @$filter["w_custom_size"];
		$this->custom_size->AdvancedSearch->save();

		// Field ded_jc
		$this->ded_jc->AdvancedSearch->SearchValue = @$filter["x_ded_jc"];
		$this->ded_jc->AdvancedSearch->SearchOperator = @$filter["z_ded_jc"];
		$this->ded_jc->AdvancedSearch->SearchCondition = @$filter["v_ded_jc"];
		$this->ded_jc->AdvancedSearch->SearchValue2 = @$filter["y_ded_jc"];
		$this->ded_jc->AdvancedSearch->SearchOperator2 = @$filter["w_ded_jc"];
		$this->ded_jc->AdvancedSearch->save();

		// Field ded_pa
		$this->ded_pa->AdvancedSearch->SearchValue = @$filter["x_ded_pa"];
		$this->ded_pa->AdvancedSearch->SearchOperator = @$filter["z_ded_pa"];
		$this->ded_pa->AdvancedSearch->SearchCondition = @$filter["v_ded_pa"];
		$this->ded_pa->AdvancedSearch->SearchValue2 = @$filter["y_ded_pa"];
		$this->ded_pa->AdvancedSearch->SearchOperator2 = @$filter["w_ded_pa"];
		$this->ded_pa->AdvancedSearch->save();

		// Field c_id
		$this->c_id->AdvancedSearch->SearchValue = @$filter["x_c_id"];
		$this->c_id->AdvancedSearch->SearchOperator = @$filter["z_c_id"];
		$this->c_id->AdvancedSearch->SearchCondition = @$filter["v_c_id"];
		$this->c_id->AdvancedSearch->SearchValue2 = @$filter["y_c_id"];
		$this->c_id->AdvancedSearch->SearchOperator2 = @$filter["w_c_id"];
		$this->c_id->AdvancedSearch->save();

		// Field payment_type
		$this->payment_type->AdvancedSearch->SearchValue = @$filter["x_payment_type"];
		$this->payment_type->AdvancedSearch->SearchOperator = @$filter["z_payment_type"];
		$this->payment_type->AdvancedSearch->SearchCondition = @$filter["v_payment_type"];
		$this->payment_type->AdvancedSearch->SearchValue2 = @$filter["y_payment_type"];
		$this->payment_type->AdvancedSearch->SearchOperator2 = @$filter["w_payment_type"];
		$this->payment_type->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field sqm_grp
		$this->sqm_grp->AdvancedSearch->SearchValue = @$filter["x_sqm_grp"];
		$this->sqm_grp->AdvancedSearch->SearchOperator = @$filter["z_sqm_grp"];
		$this->sqm_grp->AdvancedSearch->SearchCondition = @$filter["v_sqm_grp"];
		$this->sqm_grp->AdvancedSearch->SearchValue2 = @$filter["y_sqm_grp"];
		$this->sqm_grp->AdvancedSearch->SearchOperator2 = @$filter["w_sqm_grp"];
		$this->sqm_grp->AdvancedSearch->save();

		// Field 2_srm
		$this->_2_srm->AdvancedSearch->SearchValue = @$filter["x__2_srm"];
		$this->_2_srm->AdvancedSearch->SearchOperator = @$filter["z__2_srm"];
		$this->_2_srm->AdvancedSearch->SearchCondition = @$filter["v__2_srm"];
		$this->_2_srm->AdvancedSearch->SearchValue2 = @$filter["y__2_srm"];
		$this->_2_srm->AdvancedSearch->SearchOperator2 = @$filter["w__2_srm"];
		$this->_2_srm->AdvancedSearch->save();

		// Field 4_srm
		$this->_4_srm->AdvancedSearch->SearchValue = @$filter["x__4_srm"];
		$this->_4_srm->AdvancedSearch->SearchOperator = @$filter["z__4_srm"];
		$this->_4_srm->AdvancedSearch->SearchCondition = @$filter["v__4_srm"];
		$this->_4_srm->AdvancedSearch->SearchValue2 = @$filter["y__4_srm"];
		$this->_4_srm->AdvancedSearch->SearchOperator2 = @$filter["w__4_srm"];
		$this->_4_srm->AdvancedSearch->save();

		// Field process_fix
		$this->process_fix->AdvancedSearch->SearchValue = @$filter["x_process_fix"];
		$this->process_fix->AdvancedSearch->SearchOperator = @$filter["z_process_fix"];
		$this->process_fix->AdvancedSearch->SearchCondition = @$filter["v_process_fix"];
		$this->process_fix->AdvancedSearch->SearchValue2 = @$filter["y_process_fix"];
		$this->process_fix->AdvancedSearch->SearchOperator2 = @$filter["w_process_fix"];
		$this->process_fix->AdvancedSearch->save();

		// Field method
		$this->method->AdvancedSearch->SearchValue = @$filter["x_method"];
		$this->method->AdvancedSearch->SearchOperator = @$filter["z_method"];
		$this->method->AdvancedSearch->SearchCondition = @$filter["v_method"];
		$this->method->AdvancedSearch->SearchValue2 = @$filter["y_method"];
		$this->method->AdvancedSearch->SearchOperator2 = @$filter["w_method"];
		$this->method->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field payment
		$this->payment->AdvancedSearch->SearchValue = @$filter["x_payment"];
		$this->payment->AdvancedSearch->SearchOperator = @$filter["z_payment"];
		$this->payment->AdvancedSearch->SearchCondition = @$filter["v_payment"];
		$this->payment->AdvancedSearch->SearchValue2 = @$filter["y_payment"];
		$this->payment->AdvancedSearch->SearchOperator2 = @$filter["w_payment"];
		$this->payment->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field remark
		$this->remark->AdvancedSearch->SearchValue = @$filter["x_remark"];
		$this->remark->AdvancedSearch->SearchOperator = @$filter["z_remark"];
		$this->remark->AdvancedSearch->SearchCondition = @$filter["v_remark"];
		$this->remark->AdvancedSearch->SearchValue2 = @$filter["y_remark"];
		$this->remark->AdvancedSearch->SearchOperator2 = @$filter["w_remark"];
		$this->remark->AdvancedSearch->save();

		// Field pps
		$this->pps->AdvancedSearch->SearchValue = @$filter["x_pps"];
		$this->pps->AdvancedSearch->SearchOperator = @$filter["z_pps"];
		$this->pps->AdvancedSearch->SearchCondition = @$filter["v_pps"];
		$this->pps->AdvancedSearch->SearchValue2 = @$filter["y_pps"];
		$this->pps->AdvancedSearch->SearchOperator2 = @$filter["w_pps"];
		$this->pps->AdvancedSearch->save();

		// Field c_method
		$this->c_method->AdvancedSearch->SearchValue = @$filter["x_c_method"];
		$this->c_method->AdvancedSearch->SearchOperator = @$filter["z_c_method"];
		$this->c_method->AdvancedSearch->SearchCondition = @$filter["v_c_method"];
		$this->c_method->AdvancedSearch->SearchValue2 = @$filter["y_c_method"];
		$this->c_method->AdvancedSearch->SearchOperator2 = @$filter["w_c_method"];
		$this->c_method->AdvancedSearch->save();

		// Field category
		$this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
		$this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
		$this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
		$this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
		$this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
		$this->category->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->location, $default, FALSE); // location
		$this->buildSearchSql($where, $this->process, $default, FALSE); // process
		$this->buildSearchSql($where, $this->emp_id, $default, FALSE); // emp_id
		$this->buildSearchSql($where, $this->code, $default, FALSE); // code
		$this->buildSearchSql($where, $this->ref, $default, FALSE); // ref
		$this->buildSearchSql($where, $this->size_wl, $default, FALSE); // size_wl
		$this->buildSearchSql($where, $this->process_40, $default, FALSE); // process_@
		$this->buildSearchSql($where, $this->final_amount, $default, FALSE); // final_amount
		$this->buildSearchSql($where, $this->amount, $default, FALSE); // amount
		$this->buildSearchSql($where, $this->c_charge, $default, FALSE); // c_charge
		$this->buildSearchSql($where, $this->custom_size, $default, FALSE); // custom_size
		$this->buildSearchSql($where, $this->ded_jc, $default, FALSE); // ded_jc
		$this->buildSearchSql($where, $this->ded_pa, $default, FALSE); // ded_pa
		$this->buildSearchSql($where, $this->c_id, $default, FALSE); // c_id
		$this->buildSearchSql($where, $this->payment_type, $default, FALSE); // payment_type
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->sqm_grp, $default, FALSE); // sqm_grp
		$this->buildSearchSql($where, $this->_2_srm, $default, FALSE); // 2_srm
		$this->buildSearchSql($where, $this->_4_srm, $default, FALSE); // 4_srm
		$this->buildSearchSql($where, $this->process_fix, $default, FALSE); // process_fix
		$this->buildSearchSql($where, $this->method, $default, FALSE); // method
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->payment, $default, TRUE); // payment
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->remark, $default, FALSE); // remark
		$this->buildSearchSql($where, $this->pps, $default, FALSE); // pps
		$this->buildSearchSql($where, $this->c_method, $default, FALSE); // c_method
		$this->buildSearchSql($where, $this->category, $default, FALSE); // category

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->location->AdvancedSearch->save(); // location
			$this->process->AdvancedSearch->save(); // process
			$this->emp_id->AdvancedSearch->save(); // emp_id
			$this->code->AdvancedSearch->save(); // code
			$this->ref->AdvancedSearch->save(); // ref
			$this->size_wl->AdvancedSearch->save(); // size_wl
			$this->process_40->AdvancedSearch->save(); // process_@
			$this->final_amount->AdvancedSearch->save(); // final_amount
			$this->amount->AdvancedSearch->save(); // amount
			$this->c_charge->AdvancedSearch->save(); // c_charge
			$this->custom_size->AdvancedSearch->save(); // custom_size
			$this->ded_jc->AdvancedSearch->save(); // ded_jc
			$this->ded_pa->AdvancedSearch->save(); // ded_pa
			$this->c_id->AdvancedSearch->save(); // c_id
			$this->payment_type->AdvancedSearch->save(); // payment_type
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->sqm_grp->AdvancedSearch->save(); // sqm_grp
			$this->_2_srm->AdvancedSearch->save(); // 2_srm
			$this->_4_srm->AdvancedSearch->save(); // 4_srm
			$this->process_fix->AdvancedSearch->save(); // process_fix
			$this->method->AdvancedSearch->save(); // method
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->payment->AdvancedSearch->save(); // payment
			$this->grp->AdvancedSearch->save(); // grp
			$this->remark->AdvancedSearch->save(); // remark
			$this->pps->AdvancedSearch->save(); // pps
			$this->c_method->AdvancedSearch->save(); // c_method
			$this->category->AdvancedSearch->save(); // category
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remark, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->location->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->emp_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->size_wl->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process_40->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->final_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->c_charge->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->custom_size->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ded_jc->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ded_pa->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->c_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->payment_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_2_srm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_4_srm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process_fix->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->method->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->payment->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remark->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pps->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->c_method->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->category->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->location->AdvancedSearch->unsetSession();
		$this->process->AdvancedSearch->unsetSession();
		$this->emp_id->AdvancedSearch->unsetSession();
		$this->code->AdvancedSearch->unsetSession();
		$this->ref->AdvancedSearch->unsetSession();
		$this->size_wl->AdvancedSearch->unsetSession();
		$this->process_40->AdvancedSearch->unsetSession();
		$this->final_amount->AdvancedSearch->unsetSession();
		$this->amount->AdvancedSearch->unsetSession();
		$this->c_charge->AdvancedSearch->unsetSession();
		$this->custom_size->AdvancedSearch->unsetSession();
		$this->ded_jc->AdvancedSearch->unsetSession();
		$this->ded_pa->AdvancedSearch->unsetSession();
		$this->c_id->AdvancedSearch->unsetSession();
		$this->payment_type->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->sqm_grp->AdvancedSearch->unsetSession();
		$this->_2_srm->AdvancedSearch->unsetSession();
		$this->_4_srm->AdvancedSearch->unsetSession();
		$this->process_fix->AdvancedSearch->unsetSession();
		$this->method->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->payment->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->remark->AdvancedSearch->unsetSession();
		$this->pps->AdvancedSearch->unsetSession();
		$this->c_method->AdvancedSearch->unsetSession();
		$this->category->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->emp_id->AdvancedSearch->load();
		$this->code->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->size_wl->AdvancedSearch->load();
		$this->process_40->AdvancedSearch->load();
		$this->final_amount->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->c_charge->AdvancedSearch->load();
		$this->custom_size->AdvancedSearch->load();
		$this->ded_jc->AdvancedSearch->load();
		$this->ded_pa->AdvancedSearch->load();
		$this->c_id->AdvancedSearch->load();
		$this->payment_type->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_grp->AdvancedSearch->load();
		$this->_2_srm->AdvancedSearch->load();
		$this->_4_srm->AdvancedSearch->load();
		$this->process_fix->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->payment->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->remark->AdvancedSearch->load();
		$this->pps->AdvancedSearch->load();
		$this->c_method->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->location, $ctrl); // location
			$this->updateSort($this->process, $ctrl); // process
			$this->updateSort($this->emp_id, $ctrl); // emp_id
			$this->updateSort($this->emp_grp, $ctrl); // emp_grp
			$this->updateSort($this->code, $ctrl); // code
			$this->updateSort($this->ref, $ctrl); // ref
			$this->updateSort($this->size_wl, $ctrl); // size_wl
			$this->updateSort($this->process_40, $ctrl); // process_@
			$this->updateSort($this->final_amount, $ctrl); // final_amount
			$this->updateSort($this->amount, $ctrl); // amount
			$this->updateSort($this->c_charge, $ctrl); // c_charge
			$this->updateSort($this->custom_size, $ctrl); // custom_size
			$this->updateSort($this->ded_jc, $ctrl); // ded_jc
			$this->updateSort($this->ded_pa, $ctrl); // ded_pa
			$this->updateSort($this->c_id, $ctrl); // c_id
			$this->updateSort($this->payment_type, $ctrl); // payment_type
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->sqm_grp, $ctrl); // sqm_grp
			$this->updateSort($this->_2_srm, $ctrl); // 2_srm
			$this->updateSort($this->_4_srm, $ctrl); // 4_srm
			$this->updateSort($this->process_fix, $ctrl); // process_fix
			$this->updateSort($this->method, $ctrl); // method
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->payment, $ctrl); // payment
			$this->updateSort($this->remark, $ctrl); // remark
			$this->updateSort($this->c_method, $ctrl); // c_method
			$this->updateSort($this->category, $ctrl); // category
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->location->setSort("");
				$this->process->setSort("");
				$this->emp_id->setSort("");
				$this->emp_grp->setSort("");
				$this->code->setSort("");
				$this->ref->setSort("");
				$this->size_wl->setSort("");
				$this->process_40->setSort("");
				$this->final_amount->setSort("");
				$this->amount->setSort("");
				$this->c_charge->setSort("");
				$this->custom_size->setSort("");
				$this->ded_jc->setSort("");
				$this->ded_pa->setSort("");
				$this->c_id->setSort("");
				$this->payment_type->setSort("");
				$this->sqm->setSort("");
				$this->sqm_grp->setSort("");
				$this->_2_srm->setSort("");
				$this->_4_srm->setSort("");
				$this->process_fix->setSort("");
				$this->method->setSort("");
				$this->datetime->setSort("");
				$this->payment->setSort("");
				$this->remark->setSort("");
				$this->c_method->setSort("");
				$this->category->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fprocess_action_paymentlistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fprocess_action_paymentlistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fprocess_action_paymentlist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fprocess_action_paymentlistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"process_action_paymentsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"process_action_payment\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'process_action_paymentsrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fprocess_action_paymentlistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue(Get("x_location", Get("location", "")));
		if ($this->location->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->location->AdvancedSearch->setSearchOperator(Get("z_location", ""));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue(Get("x_process", Get("process", "")));
		if ($this->process->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process->AdvancedSearch->setSearchOperator(Get("z_process", ""));

		// emp_id
		if (!$this->isAddOrEdit())
			$this->emp_id->AdvancedSearch->setSearchValue(Get("x_emp_id", Get("emp_id", "")));
		if ($this->emp_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->emp_id->AdvancedSearch->setSearchOperator(Get("z_emp_id", ""));

		// code
		if (!$this->isAddOrEdit())
			$this->code->AdvancedSearch->setSearchValue(Get("x_code", Get("code", "")));
		if ($this->code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->code->AdvancedSearch->setSearchOperator(Get("z_code", ""));
		$this->code->AdvancedSearch->setSearchCondition(Get("v_code", ""));
		$this->code->AdvancedSearch->setSearchValue2(Get("y_code", ""));
		if ($this->code->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->code->AdvancedSearch->setSearchOperator2(Get("w_code", ""));

		// ref
		if (!$this->isAddOrEdit())
			$this->ref->AdvancedSearch->setSearchValue(Get("x_ref", Get("ref", "")));
		if ($this->ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ref->AdvancedSearch->setSearchOperator(Get("z_ref", ""));

		// size_wl
		if (!$this->isAddOrEdit())
			$this->size_wl->AdvancedSearch->setSearchValue(Get("x_size_wl", Get("size_wl", "")));
		if ($this->size_wl->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->size_wl->AdvancedSearch->setSearchOperator(Get("z_size_wl", ""));

		// process_@
		if (!$this->isAddOrEdit())
			$this->process_40->AdvancedSearch->setSearchValue(Get("x_process_40", Get("process_40", "")));
		if ($this->process_40->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process_40->AdvancedSearch->setSearchOperator(Get("z_process_40", ""));

		// final_amount
		if (!$this->isAddOrEdit())
			$this->final_amount->AdvancedSearch->setSearchValue(Get("x_final_amount", Get("final_amount", "")));
		if ($this->final_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->final_amount->AdvancedSearch->setSearchOperator(Get("z_final_amount", ""));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue(Get("x_amount", Get("amount", "")));
		if ($this->amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount->AdvancedSearch->setSearchOperator(Get("z_amount", ""));

		// c_charge
		if (!$this->isAddOrEdit())
			$this->c_charge->AdvancedSearch->setSearchValue(Get("x_c_charge", Get("c_charge", "")));
		if ($this->c_charge->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->c_charge->AdvancedSearch->setSearchOperator(Get("z_c_charge", ""));

		// custom_size
		if (!$this->isAddOrEdit())
			$this->custom_size->AdvancedSearch->setSearchValue(Get("x_custom_size", Get("custom_size", "")));
		if ($this->custom_size->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->custom_size->AdvancedSearch->setSearchOperator(Get("z_custom_size", ""));

		// ded_jc
		if (!$this->isAddOrEdit())
			$this->ded_jc->AdvancedSearch->setSearchValue(Get("x_ded_jc", Get("ded_jc", "")));
		if ($this->ded_jc->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ded_jc->AdvancedSearch->setSearchOperator(Get("z_ded_jc", ""));

		// ded_pa
		if (!$this->isAddOrEdit())
			$this->ded_pa->AdvancedSearch->setSearchValue(Get("x_ded_pa", Get("ded_pa", "")));
		if ($this->ded_pa->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ded_pa->AdvancedSearch->setSearchOperator(Get("z_ded_pa", ""));

		// c_id
		if (!$this->isAddOrEdit())
			$this->c_id->AdvancedSearch->setSearchValue(Get("x_c_id", Get("c_id", "")));
		if ($this->c_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->c_id->AdvancedSearch->setSearchOperator(Get("z_c_id", ""));

		// payment_type
		if (!$this->isAddOrEdit())
			$this->payment_type->AdvancedSearch->setSearchValue(Get("x_payment_type", Get("payment_type", "")));
		if ($this->payment_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->payment_type->AdvancedSearch->setSearchOperator(Get("z_payment_type", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// sqm_grp
		if (!$this->isAddOrEdit())
			$this->sqm_grp->AdvancedSearch->setSearchValue(Get("x_sqm_grp", Get("sqm_grp", "")));
		if ($this->sqm_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm_grp->AdvancedSearch->setSearchOperator(Get("z_sqm_grp", ""));

		// 2_srm
		if (!$this->isAddOrEdit())
			$this->_2_srm->AdvancedSearch->setSearchValue(Get("x__2_srm", Get("_2_srm", "")));
		if ($this->_2_srm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_2_srm->AdvancedSearch->setSearchOperator(Get("z__2_srm", ""));

		// 4_srm
		if (!$this->isAddOrEdit())
			$this->_4_srm->AdvancedSearch->setSearchValue(Get("x__4_srm", Get("_4_srm", "")));
		if ($this->_4_srm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_4_srm->AdvancedSearch->setSearchOperator(Get("z__4_srm", ""));

		// process_fix
		if (!$this->isAddOrEdit())
			$this->process_fix->AdvancedSearch->setSearchValue(Get("x_process_fix", Get("process_fix", "")));
		if ($this->process_fix->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process_fix->AdvancedSearch->setSearchOperator(Get("z_process_fix", ""));

		// method
		if (!$this->isAddOrEdit())
			$this->method->AdvancedSearch->setSearchValue(Get("x_method", Get("method", "")));
		if ($this->method->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->method->AdvancedSearch->setSearchOperator(Get("z_method", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchCondition(Get("v_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchValue2(Get("y_datetime", ""));
		if ($this->datetime->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator2(Get("w_datetime", ""));

		// payment
		if (!$this->isAddOrEdit())
			$this->payment->AdvancedSearch->setSearchValue(Get("x_payment", Get("payment", "")));
		if ($this->payment->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->payment->AdvancedSearch->setSearchOperator(Get("z_payment", ""));
		$this->payment->AdvancedSearch->setSearchCondition(Get("v_payment", ""));
		$this->payment->AdvancedSearch->setSearchValue2(Get("y_payment", ""));
		if ($this->payment->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->payment->AdvancedSearch->setSearchOperator2(Get("w_payment", ""));
		if (is_array($this->payment->AdvancedSearch->SearchValue))
			$this->payment->AdvancedSearch->SearchValue = implode(",", $this->payment->AdvancedSearch->SearchValue);
		if (is_array($this->payment->AdvancedSearch->SearchValue2))
			$this->payment->AdvancedSearch->SearchValue2 = implode(",", $this->payment->AdvancedSearch->SearchValue2);

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// remark
		if (!$this->isAddOrEdit())
			$this->remark->AdvancedSearch->setSearchValue(Get("x_remark", Get("remark", "")));
		if ($this->remark->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remark->AdvancedSearch->setSearchOperator(Get("z_remark", ""));

		// pps
		if (!$this->isAddOrEdit())
			$this->pps->AdvancedSearch->setSearchValue(Get("x_pps", Get("pps", "")));
		if ($this->pps->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pps->AdvancedSearch->setSearchOperator(Get("z_pps", ""));

		// c_method
		if (!$this->isAddOrEdit())
			$this->c_method->AdvancedSearch->setSearchValue(Get("x_c_method", Get("c_method", "")));
		if ($this->c_method->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->c_method->AdvancedSearch->setSearchOperator(Get("z_c_method", ""));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue(Get("x_category", Get("category", "")));
		if ($this->category->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->category->AdvancedSearch->setSearchOperator(Get("z_category", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->location->setDbValue($row['location']);
		$this->process->setDbValue($row['process']);
		$this->emp_id->setDbValue($row['emp_id']);
		$this->emp_grp->setDbValue($row['emp_grp']);
		$this->code->setDbValue($row['code']);
		$this->ref->setDbValue($row['ref']);
		$this->size_wl->setDbValue($row['size_wl']);
		$this->process_40->setDbValue($row['process_@']);
		$this->final_amount->setDbValue($row['final_amount']);
		$this->amount->setDbValue($row['amount']);
		$this->c_charge->setDbValue($row['c_charge']);
		$this->custom_size->setDbValue($row['custom_size']);
		$this->ded_jc->setDbValue($row['ded_jc']);
		$this->ded_pa->setDbValue($row['ded_pa']);
		$this->c_id->setDbValue($row['c_id']);
		$this->payment_type->setDbValue($row['payment_type']);
		$this->sqm->setDbValue($row['sqm']);
		$this->sqm_grp->setDbValue($row['sqm_grp']);
		$this->_2_srm->setDbValue($row['2_srm']);
		$this->_4_srm->setDbValue($row['4_srm']);
		$this->process_fix->setDbValue($row['process_fix']);
		$this->method->setDbValue($row['method']);
		$this->datetime->setDbValue($row['datetime']);
		$this->payment->setDbValue($row['payment']);
		$this->grp->setDbValue($row['grp']);
		$this->remark->setDbValue($row['remark']);
		$this->pps->setDbValue($row['pps']);
		$this->uid->setDbValue($row['uid']);
		$this->c_method->setDbValue($row['c_method']);
		$this->category->setDbValue($row['category']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['location'] = NULL;
		$row['process'] = NULL;
		$row['emp_id'] = NULL;
		$row['emp_grp'] = NULL;
		$row['code'] = NULL;
		$row['ref'] = NULL;
		$row['size_wl'] = NULL;
		$row['process_@'] = NULL;
		$row['final_amount'] = NULL;
		$row['amount'] = NULL;
		$row['c_charge'] = NULL;
		$row['custom_size'] = NULL;
		$row['ded_jc'] = NULL;
		$row['ded_pa'] = NULL;
		$row['c_id'] = NULL;
		$row['payment_type'] = NULL;
		$row['sqm'] = NULL;
		$row['sqm_grp'] = NULL;
		$row['2_srm'] = NULL;
		$row['4_srm'] = NULL;
		$row['process_fix'] = NULL;
		$row['method'] = NULL;
		$row['datetime'] = NULL;
		$row['payment'] = NULL;
		$row['grp'] = NULL;
		$row['remark'] = NULL;
		$row['pps'] = NULL;
		$row['uid'] = NULL;
		$row['c_method'] = NULL;
		$row['category'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->process_40->FormValue == $this->process_40->CurrentValue && is_numeric(ConvertToFloatString($this->process_40->CurrentValue)))
			$this->process_40->CurrentValue = ConvertToFloatString($this->process_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->c_charge->FormValue == $this->c_charge->CurrentValue && is_numeric(ConvertToFloatString($this->c_charge->CurrentValue)))
			$this->c_charge->CurrentValue = ConvertToFloatString($this->c_charge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_size->FormValue == $this->custom_size->CurrentValue && is_numeric(ConvertToFloatString($this->custom_size->CurrentValue)))
			$this->custom_size->CurrentValue = ConvertToFloatString($this->custom_size->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_jc->FormValue == $this->ded_jc->CurrentValue && is_numeric(ConvertToFloatString($this->ded_jc->CurrentValue)))
			$this->ded_jc->CurrentValue = ConvertToFloatString($this->ded_jc->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_pa->FormValue == $this->ded_pa->CurrentValue && is_numeric(ConvertToFloatString($this->ded_pa->CurrentValue)))
			$this->ded_pa->CurrentValue = ConvertToFloatString($this->ded_pa->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_grp->FormValue == $this->sqm_grp->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_grp->CurrentValue)))
			$this->sqm_grp->CurrentValue = ConvertToFloatString($this->sqm_grp->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_2_srm->FormValue == $this->_2_srm->CurrentValue && is_numeric(ConvertToFloatString($this->_2_srm->CurrentValue)))
			$this->_2_srm->CurrentValue = ConvertToFloatString($this->_2_srm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_4_srm->FormValue == $this->_4_srm->CurrentValue && is_numeric(ConvertToFloatString($this->_4_srm->CurrentValue)))
			$this->_4_srm->CurrentValue = ConvertToFloatString($this->_4_srm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// location
		// process
		// emp_id
		// emp_grp
		// code
		// ref
		// size_wl
		// process_@
		// final_amount
		// amount
		// c_charge
		// custom_size
		// ded_jc
		// ded_pa
		// c_id
		// payment_type
		// sqm
		// sqm_grp
		// 2_srm
		// 4_srm
		// process_fix
		// method
		// datetime
		// payment
		// grp
		// remark
		// pps
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// c_method
		// category
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->final_amount->CurrentValue))
				$this->final_amount->Total += $this->final_amount->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// emp_id
			$curVal = strval($this->emp_id->CurrentValue);
			if ($curVal <> "") {
				$this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
				if ($this->emp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->emp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->emp_id->ViewValue = $this->emp_id->CurrentValue;
					}
				}
			} else {
				$this->emp_id->ViewValue = NULL;
			}
			$this->emp_id->ViewCustomAttributes = "";

			// emp_grp
			$this->emp_grp->ViewValue = $this->emp_grp->CurrentValue;
			$this->emp_grp->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// ref
			$curVal = strval($this->ref->CurrentValue);
			if ($curVal <> "") {
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
				if ($this->ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ref->ViewValue = $this->ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ref->ViewValue = $this->ref->CurrentValue;
					}
				}
			} else {
				$this->ref->ViewValue = NULL;
			}
			$this->ref->ViewCustomAttributes = "";

			// size_wl
			$this->size_wl->ViewValue = $this->size_wl->CurrentValue;
			$this->size_wl->ViewCustomAttributes = "";

			// process_@
			$this->process_40->ViewValue = $this->process_40->CurrentValue;
			$this->process_40->ViewValue = FormatNumber($this->process_40->ViewValue, 2, -2, -2, -2);
			$this->process_40->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// c_charge
			$this->c_charge->ViewValue = $this->c_charge->CurrentValue;
			$this->c_charge->ViewValue = FormatNumber($this->c_charge->ViewValue, 2, -2, -2, -2);
			$this->c_charge->ViewCustomAttributes = "";

			// custom_size
			$this->custom_size->ViewValue = $this->custom_size->CurrentValue;
			$this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, 2, -2, -2, -2);
			$this->custom_size->ViewCustomAttributes = "";

			// ded_jc
			$this->ded_jc->ViewValue = $this->ded_jc->CurrentValue;
			$this->ded_jc->ViewValue = FormatNumber($this->ded_jc->ViewValue, 2, -2, -2, -2);
			$this->ded_jc->ViewCustomAttributes = "";

			// ded_pa
			$this->ded_pa->ViewValue = $this->ded_pa->CurrentValue;
			$this->ded_pa->ViewValue = FormatNumber($this->ded_pa->ViewValue, 2, -2, -2, -2);
			$this->ded_pa->ViewCustomAttributes = "";

			// c_id
			$curVal = strval($this->c_id->CurrentValue);
			if ($curVal <> "") {
				$this->c_id->ViewValue = $this->c_id->lookupCacheOption($curVal);
				if ($this->c_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=99 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->c_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->c_id->ViewValue = $this->c_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->c_id->ViewValue = $this->c_id->CurrentValue;
					}
				}
			} else {
				$this->c_id->ViewValue = NULL;
			}
			$this->c_id->ViewCustomAttributes = "";

			// payment_type
			if (strval($this->payment_type->CurrentValue) <> "") {
				$this->payment_type->ViewValue = $this->payment_type->optionCaption($this->payment_type->CurrentValue);
			} else {
				$this->payment_type->ViewValue = NULL;
			}
			$this->payment_type->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_grp
			$this->sqm_grp->ViewValue = $this->sqm_grp->CurrentValue;
			$this->sqm_grp->ViewValue = FormatNumber($this->sqm_grp->ViewValue, 2, -2, -2, -2);
			$this->sqm_grp->ViewCustomAttributes = "";

			// 2_srm
			$this->_2_srm->ViewValue = $this->_2_srm->CurrentValue;
			$this->_2_srm->ViewValue = FormatNumber($this->_2_srm->ViewValue, 2, -2, -2, -2);
			$this->_2_srm->ViewCustomAttributes = "";

			// 4_srm
			$this->_4_srm->ViewValue = $this->_4_srm->CurrentValue;
			$this->_4_srm->ViewValue = FormatNumber($this->_4_srm->ViewValue, 2, -2, -2, -2);
			$this->_4_srm->ViewCustomAttributes = "";

			// process_fix
			if (strval($this->process_fix->CurrentValue) <> "") {
				$this->process_fix->ViewValue = $this->process_fix->optionCaption($this->process_fix->CurrentValue);
			} else {
				$this->process_fix->ViewValue = NULL;
			}
			$this->process_fix->ViewCustomAttributes = "";

			// method
			if (strval($this->method->CurrentValue) <> "") {
				$this->method->ViewValue = $this->method->optionCaption($this->method->CurrentValue);
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// payment
			$curVal = strval($this->payment->CurrentValue);
			if ($curVal <> "") {
				$this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
				if ($this->payment->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->payment->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->payment->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->payment->ViewValue->add($this->payment->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->payment->ViewValue = $this->payment->CurrentValue;
					}
				}
			} else {
				$this->payment->ViewValue = NULL;
			}
			$this->payment->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// pps
			$this->pps->ViewValue = $this->pps->CurrentValue;
			$this->pps->ViewValue = FormatNumber($this->pps->ViewValue, 0, -2, -2, -2);
			$this->pps->ViewCustomAttributes = "";

			// c_method
			$this->c_method->ViewValue = $this->c_method->CurrentValue;
			$this->c_method->ViewValue = FormatNumber($this->c_method->ViewValue, 0, -2, -2, -2);
			$this->c_method->ViewCustomAttributes = "";

			// category
			$this->category->ViewValue = $this->category->CurrentValue;
			$this->category->ViewValue = FormatNumber($this->category->ViewValue, 0, -2, -2, -2);
			$this->category->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// emp_id
			$this->emp_id->LinkCustomAttributes = "";
			$this->emp_id->HrefValue = "";
			$this->emp_id->TooltipValue = "";

			// emp_grp
			$this->emp_grp->LinkCustomAttributes = "";
			$this->emp_grp->HrefValue = "";
			$this->emp_grp->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";
			if (!$this->isExport())
				$this->code->ViewValue = $this->highlightValue($this->code);

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// size_wl
			$this->size_wl->LinkCustomAttributes = "";
			$this->size_wl->HrefValue = "";
			$this->size_wl->TooltipValue = "";

			// process_@
			$this->process_40->LinkCustomAttributes = "";
			$this->process_40->HrefValue = "";
			$this->process_40->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// c_charge
			$this->c_charge->LinkCustomAttributes = "";
			$this->c_charge->HrefValue = "";
			$this->c_charge->TooltipValue = "";

			// custom_size
			$this->custom_size->LinkCustomAttributes = "";
			$this->custom_size->HrefValue = "";
			$this->custom_size->TooltipValue = "";

			// ded_jc
			$this->ded_jc->LinkCustomAttributes = "";
			$this->ded_jc->HrefValue = "";
			$this->ded_jc->TooltipValue = "";

			// ded_pa
			$this->ded_pa->LinkCustomAttributes = "";
			$this->ded_pa->HrefValue = "";
			$this->ded_pa->TooltipValue = "";

			// c_id
			$this->c_id->LinkCustomAttributes = "";
			$this->c_id->HrefValue = "";
			$this->c_id->TooltipValue = "";

			// payment_type
			$this->payment_type->LinkCustomAttributes = "";
			$this->payment_type->HrefValue = "";
			$this->payment_type->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_grp
			$this->sqm_grp->LinkCustomAttributes = "";
			$this->sqm_grp->HrefValue = "";
			$this->sqm_grp->TooltipValue = "";

			// 2_srm
			$this->_2_srm->LinkCustomAttributes = "";
			$this->_2_srm->HrefValue = "";
			$this->_2_srm->TooltipValue = "";

			// 4_srm
			$this->_4_srm->LinkCustomAttributes = "";
			$this->_4_srm->HrefValue = "";
			$this->_4_srm->TooltipValue = "";

			// process_fix
			$this->process_fix->LinkCustomAttributes = "";
			$this->process_fix->HrefValue = "";
			$this->process_fix->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";
			$this->payment->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";
			if (!$this->isExport())
				$this->remark->ViewValue = $this->highlightValue($this->remark);

			// c_method
			$this->c_method->LinkCustomAttributes = "";
			$this->c_method->HrefValue = "";
			$this->c_method->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->location->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// emp_id
			$this->emp_id->EditAttrs["class"] = "form-control";
			$this->emp_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->emp_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->lookupCacheOption($curVal);
			else
				$this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->Lookup !== NULL && is_array($this->emp_id->Lookup->Options) ? $curVal : NULL;
			if ($this->emp_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->emp_id->EditValue = array_values($this->emp_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->emp_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->emp_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->emp_id->EditValue = $arwrk;
			}

			// emp_grp
			$this->emp_grp->EditAttrs["class"] = "form-control";
			$this->emp_grp->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->emp_grp->AdvancedSearch->SearchValue = HtmlDecode($this->emp_grp->AdvancedSearch->SearchValue);
			$this->emp_grp->EditValue = HtmlEncode($this->emp_grp->AdvancedSearch->SearchValue);
			$this->emp_grp->PlaceHolder = RemoveHtml($this->emp_grp->caption());

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			$this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			$this->code->EditValue2 = HtmlEncode($this->code->AdvancedSearch->SearchValue2);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";

			// size_wl
			$this->size_wl->EditAttrs["class"] = "form-control";
			$this->size_wl->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_wl->AdvancedSearch->SearchValue = HtmlDecode($this->size_wl->AdvancedSearch->SearchValue);
			$this->size_wl->EditValue = HtmlEncode($this->size_wl->AdvancedSearch->SearchValue);
			$this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

			// process_@
			$this->process_40->EditAttrs["class"] = "form-control";
			$this->process_40->EditCustomAttributes = "";
			$this->process_40->EditValue = HtmlEncode($this->process_40->AdvancedSearch->SearchValue);
			$this->process_40->PlaceHolder = RemoveHtml($this->process_40->caption());

			// final_amount
			$this->final_amount->EditAttrs["class"] = "form-control";
			$this->final_amount->EditCustomAttributes = "";
			$this->final_amount->EditValue = HtmlEncode($this->final_amount->AdvancedSearch->SearchValue);
			$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// c_charge
			$this->c_charge->EditAttrs["class"] = "form-control";
			$this->c_charge->EditCustomAttributes = "";
			$this->c_charge->EditValue = HtmlEncode($this->c_charge->AdvancedSearch->SearchValue);
			$this->c_charge->PlaceHolder = RemoveHtml($this->c_charge->caption());

			// custom_size
			$this->custom_size->EditAttrs["class"] = "form-control";
			$this->custom_size->EditCustomAttributes = "";
			$this->custom_size->EditValue = HtmlEncode($this->custom_size->AdvancedSearch->SearchValue);
			$this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

			// ded_jc
			$this->ded_jc->EditAttrs["class"] = "form-control";
			$this->ded_jc->EditCustomAttributes = "";
			$this->ded_jc->EditValue = HtmlEncode($this->ded_jc->AdvancedSearch->SearchValue);
			$this->ded_jc->PlaceHolder = RemoveHtml($this->ded_jc->caption());

			// ded_pa
			$this->ded_pa->EditAttrs["class"] = "form-control";
			$this->ded_pa->EditCustomAttributes = "";
			$this->ded_pa->EditValue = HtmlEncode($this->ded_pa->AdvancedSearch->SearchValue);
			$this->ded_pa->PlaceHolder = RemoveHtml($this->ded_pa->caption());

			// c_id
			$this->c_id->EditAttrs["class"] = "form-control";
			$this->c_id->EditCustomAttributes = "";

			// payment_type
			$this->payment_type->EditAttrs["class"] = "form-control";
			$this->payment_type->EditCustomAttributes = "";
			$this->payment_type->EditValue = $this->payment_type->options(TRUE);

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// sqm_grp
			$this->sqm_grp->EditAttrs["class"] = "form-control";
			$this->sqm_grp->EditCustomAttributes = "";
			$this->sqm_grp->EditValue = HtmlEncode($this->sqm_grp->AdvancedSearch->SearchValue);
			$this->sqm_grp->PlaceHolder = RemoveHtml($this->sqm_grp->caption());

			// 2_srm
			$this->_2_srm->EditAttrs["class"] = "form-control";
			$this->_2_srm->EditCustomAttributes = "";
			$this->_2_srm->EditValue = HtmlEncode($this->_2_srm->AdvancedSearch->SearchValue);
			$this->_2_srm->PlaceHolder = RemoveHtml($this->_2_srm->caption());

			// 4_srm
			$this->_4_srm->EditAttrs["class"] = "form-control";
			$this->_4_srm->EditCustomAttributes = "";
			$this->_4_srm->EditValue = HtmlEncode($this->_4_srm->AdvancedSearch->SearchValue);
			$this->_4_srm->PlaceHolder = RemoveHtml($this->_4_srm->caption());

			// process_fix
			$this->process_fix->EditAttrs["class"] = "form-control";
			$this->process_fix->EditCustomAttributes = "";
			$this->process_fix->EditValue = $this->process_fix->options(TRUE);

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$this->method->EditValue = $this->method->options(TRUE);

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// payment
			$this->payment->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->payment->AdvancedSearch->ViewValue = $this->payment->lookupCacheOption($curVal);
			else
				$this->payment->AdvancedSearch->ViewValue = $this->payment->Lookup !== NULL && is_array($this->payment->Lookup->Options) ? $curVal : NULL;
			if ($this->payment->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->payment->EditValue = array_values($this->payment->Lookup->Options);
				if ($this->payment->AdvancedSearch->ViewValue == "")
					$this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->payment->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->payment->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->payment->AdvancedSearch->ViewValue->add($this->payment->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment->EditValue = $arwrk;
			}
			$this->payment->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->payment->AdvancedSearch->ViewValue2 = $this->payment->lookupCacheOption($curVal);
			else
				$this->payment->AdvancedSearch->ViewValue2 = $this->payment->Lookup !== NULL && is_array($this->payment->Lookup->Options) ? $curVal : NULL;
			if ($this->payment->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->payment->EditValue2 = array_values($this->payment->Lookup->Options);
				if ($this->payment->AdvancedSearch->ViewValue2 == "")
					$this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->payment->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->payment->AdvancedSearch->ViewValue2 = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->payment->AdvancedSearch->ViewValue2->add($this->payment->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment->EditValue2 = $arwrk;
			}

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// c_method
			$this->c_method->EditAttrs["class"] = "form-control";
			$this->c_method->EditCustomAttributes = "";
			$this->c_method->EditValue = HtmlEncode($this->c_method->AdvancedSearch->SearchValue);
			$this->c_method->PlaceHolder = RemoveHtml($this->c_method->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$this->category->EditValue = HtmlEncode($this->category->AdvancedSearch->SearchValue);
			$this->category->PlaceHolder = RemoveHtml($this->category->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->final_amount->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->final_amount->CurrentValue = $this->final_amount->Total;
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";
			$this->final_amount->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->emp_id->AdvancedSearch->load();
		$this->code->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->size_wl->AdvancedSearch->load();
		$this->process_40->AdvancedSearch->load();
		$this->final_amount->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->c_charge->AdvancedSearch->load();
		$this->custom_size->AdvancedSearch->load();
		$this->ded_jc->AdvancedSearch->load();
		$this->ded_pa->AdvancedSearch->load();
		$this->c_id->AdvancedSearch->load();
		$this->payment_type->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_grp->AdvancedSearch->load();
		$this->_2_srm->AdvancedSearch->load();
		$this->_4_srm->AdvancedSearch->load();
		$this->process_fix->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->payment->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->remark->AdvancedSearch->load();
		$this->pps->AdvancedSearch->load();
		$this->c_method->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fprocess_action_paymentlist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fprocess_action_paymentlist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fprocess_action_paymentlist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_process_action_payment\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_process_action_payment',hdr:ew.language.phrase('ExportToEmailText'),f:document.fprocess_action_paymentlist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_emp_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_c_id":
					$lookupFilter = function() {
						return "`category`=99 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_process":
							break;
						case "x_emp_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_ref":
							break;
						case "x_c_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_payment":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>