<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_payment_search extends process_action_payment
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action_payment';

	// Page object name
	public $PageObjName = "process_action_payment_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action_payment)
		if (!isset($GLOBALS["process_action_payment"]) || get_class($GLOBALS["process_action_payment"]) == PROJECT_NAMESPACE . "process_action_payment") {
			$GLOBALS["process_action_payment"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action_payment"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_payment');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action_payment;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action_payment);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "process_action_paymentview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_action_paymentlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->location->setVisibility();
		$this->process->setVisibility();
		$this->emp_id->setVisibility();
		$this->emp_grp->Visible = FALSE;
		$this->code->setVisibility();
		$this->ref->setVisibility();
		$this->size_wl->setVisibility();
		$this->process_40->setVisibility();
		$this->final_amount->setVisibility();
		$this->amount->setVisibility();
		$this->c_charge->setVisibility();
		$this->custom_size->setVisibility();
		$this->ded_jc->setVisibility();
		$this->ded_pa->setVisibility();
		$this->c_id->setVisibility();
		$this->payment_type->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_grp->setVisibility();
		$this->_2_srm->setVisibility();
		$this->_4_srm->setVisibility();
		$this->process_fix->setVisibility();
		$this->method->setVisibility();
		$this->datetime->setVisibility();
		$this->payment->setVisibility();
		$this->grp->setVisibility();
		$this->remark->setVisibility();
		$this->pps->setVisibility();
		$this->uid->Visible = FALSE;
		$this->c_method->setVisibility();
		$this->category->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->emp_id);
		$this->setupLookupOptions($this->ref);
		$this->setupLookupOptions($this->c_id);
		$this->setupLookupOptions($this->payment);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "process_action_paymentlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->location); // location
		$this->buildSearchUrl($srchUrl, $this->process); // process
		$this->buildSearchUrl($srchUrl, $this->emp_id); // emp_id
		$this->buildSearchUrl($srchUrl, $this->code); // code
		$this->buildSearchUrl($srchUrl, $this->ref); // ref
		$this->buildSearchUrl($srchUrl, $this->size_wl); // size_wl
		$this->buildSearchUrl($srchUrl, $this->process_40); // process_@
		$this->buildSearchUrl($srchUrl, $this->final_amount); // final_amount
		$this->buildSearchUrl($srchUrl, $this->amount); // amount
		$this->buildSearchUrl($srchUrl, $this->c_charge); // c_charge
		$this->buildSearchUrl($srchUrl, $this->custom_size); // custom_size
		$this->buildSearchUrl($srchUrl, $this->ded_jc); // ded_jc
		$this->buildSearchUrl($srchUrl, $this->ded_pa); // ded_pa
		$this->buildSearchUrl($srchUrl, $this->c_id); // c_id
		$this->buildSearchUrl($srchUrl, $this->payment_type); // payment_type
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->sqm_grp); // sqm_grp
		$this->buildSearchUrl($srchUrl, $this->_2_srm); // 2_srm
		$this->buildSearchUrl($srchUrl, $this->_4_srm); // 4_srm
		$this->buildSearchUrl($srchUrl, $this->process_fix); // process_fix
		$this->buildSearchUrl($srchUrl, $this->method); // method
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->payment); // payment
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->remark); // remark
		$this->buildSearchUrl($srchUrl, $this->pps); // pps
		$this->buildSearchUrl($srchUrl, $this->c_method); // c_method
		$this->buildSearchUrl($srchUrl, $this->category); // category
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_location"));
		$this->location->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_location"));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process"));
		$this->process->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process"));

		// emp_id
		if (!$this->isAddOrEdit())
			$this->emp_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_emp_id"));
		$this->emp_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_emp_id"));

		// code
		if (!$this->isAddOrEdit())
			$this->code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_code"));
		$this->code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_code"));
		$this->code->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_code"));
		$this->code->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_code"));
		$this->code->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_code"));

		// ref
		if (!$this->isAddOrEdit())
			$this->ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ref"));
		$this->ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ref"));

		// size_wl
		if (!$this->isAddOrEdit())
			$this->size_wl->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size_wl"));
		$this->size_wl->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size_wl"));

		// process_@
		if (!$this->isAddOrEdit())
			$this->process_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_40"));
		$this->process_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_40"));

		// final_amount
		if (!$this->isAddOrEdit())
			$this->final_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_final_amount"));
		$this->final_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_final_amount"));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_amount"));
		$this->amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_amount"));

		// c_charge
		if (!$this->isAddOrEdit())
			$this->c_charge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_c_charge"));
		$this->c_charge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_c_charge"));

		// custom_size
		if (!$this->isAddOrEdit())
			$this->custom_size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_custom_size"));
		$this->custom_size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_custom_size"));

		// ded_jc
		if (!$this->isAddOrEdit())
			$this->ded_jc->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ded_jc"));
		$this->ded_jc->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ded_jc"));

		// ded_pa
		if (!$this->isAddOrEdit())
			$this->ded_pa->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ded_pa"));
		$this->ded_pa->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ded_pa"));

		// c_id
		if (!$this->isAddOrEdit())
			$this->c_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_c_id"));
		$this->c_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_c_id"));

		// payment_type
		if (!$this->isAddOrEdit())
			$this->payment_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_type"));
		$this->payment_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_type"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// sqm_grp
		if (!$this->isAddOrEdit())
			$this->sqm_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm_grp"));
		$this->sqm_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm_grp"));

		// 2_srm
		if (!$this->isAddOrEdit())
			$this->_2_srm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__2_srm"));
		$this->_2_srm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__2_srm"));

		// 4_srm
		if (!$this->isAddOrEdit())
			$this->_4_srm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__4_srm"));
		$this->_4_srm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__4_srm"));

		// process_fix
		if (!$this->isAddOrEdit())
			$this->process_fix->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_fix"));
		$this->process_fix->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_fix"));

		// method
		if (!$this->isAddOrEdit())
			$this->method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_method"));
		$this->method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_method"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
		$this->datetime->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_datetime"));
		$this->datetime->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_datetime"));

		// payment
		if (!$this->isAddOrEdit())
			$this->payment->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment"));
		$this->payment->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment"));
		$this->payment->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_payment"));
		$this->payment->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_payment"));
		$this->payment->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_payment"));
		if (is_array($this->payment->AdvancedSearch->SearchValue))
			$this->payment->AdvancedSearch->SearchValue = implode(",", $this->payment->AdvancedSearch->SearchValue);
		if (is_array($this->payment->AdvancedSearch->SearchValue2))
			$this->payment->AdvancedSearch->SearchValue2 = implode(",", $this->payment->AdvancedSearch->SearchValue2);

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// remark
		if (!$this->isAddOrEdit())
			$this->remark->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remark"));
		$this->remark->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remark"));

		// pps
		if (!$this->isAddOrEdit())
			$this->pps->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pps"));
		$this->pps->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pps"));

		// c_method
		if (!$this->isAddOrEdit())
			$this->c_method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_c_method"));
		$this->c_method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_c_method"));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->process_40->FormValue == $this->process_40->CurrentValue && is_numeric(ConvertToFloatString($this->process_40->CurrentValue)))
			$this->process_40->CurrentValue = ConvertToFloatString($this->process_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->c_charge->FormValue == $this->c_charge->CurrentValue && is_numeric(ConvertToFloatString($this->c_charge->CurrentValue)))
			$this->c_charge->CurrentValue = ConvertToFloatString($this->c_charge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_size->FormValue == $this->custom_size->CurrentValue && is_numeric(ConvertToFloatString($this->custom_size->CurrentValue)))
			$this->custom_size->CurrentValue = ConvertToFloatString($this->custom_size->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_jc->FormValue == $this->ded_jc->CurrentValue && is_numeric(ConvertToFloatString($this->ded_jc->CurrentValue)))
			$this->ded_jc->CurrentValue = ConvertToFloatString($this->ded_jc->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_pa->FormValue == $this->ded_pa->CurrentValue && is_numeric(ConvertToFloatString($this->ded_pa->CurrentValue)))
			$this->ded_pa->CurrentValue = ConvertToFloatString($this->ded_pa->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_grp->FormValue == $this->sqm_grp->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_grp->CurrentValue)))
			$this->sqm_grp->CurrentValue = ConvertToFloatString($this->sqm_grp->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_2_srm->FormValue == $this->_2_srm->CurrentValue && is_numeric(ConvertToFloatString($this->_2_srm->CurrentValue)))
			$this->_2_srm->CurrentValue = ConvertToFloatString($this->_2_srm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_4_srm->FormValue == $this->_4_srm->CurrentValue && is_numeric(ConvertToFloatString($this->_4_srm->CurrentValue)))
			$this->_4_srm->CurrentValue = ConvertToFloatString($this->_4_srm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// location
		// process
		// emp_id
		// emp_grp
		// code
		// ref
		// size_wl
		// process_@
		// final_amount
		// amount
		// c_charge
		// custom_size
		// ded_jc
		// ded_pa
		// c_id
		// payment_type
		// sqm
		// sqm_grp
		// 2_srm
		// 4_srm
		// process_fix
		// method
		// datetime
		// payment
		// grp
		// remark
		// pps
		// uid
		// c_method
		// category

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// emp_id
			$curVal = strval($this->emp_id->CurrentValue);
			if ($curVal <> "") {
				$this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
				if ($this->emp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->emp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->emp_id->ViewValue = $this->emp_id->CurrentValue;
					}
				}
			} else {
				$this->emp_id->ViewValue = NULL;
			}
			$this->emp_id->ViewCustomAttributes = "";

			// emp_grp
			$this->emp_grp->ViewValue = $this->emp_grp->CurrentValue;
			$this->emp_grp->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// ref
			$curVal = strval($this->ref->CurrentValue);
			if ($curVal <> "") {
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
				if ($this->ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ref->ViewValue = $this->ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ref->ViewValue = $this->ref->CurrentValue;
					}
				}
			} else {
				$this->ref->ViewValue = NULL;
			}
			$this->ref->ViewCustomAttributes = "";

			// size_wl
			$this->size_wl->ViewValue = $this->size_wl->CurrentValue;
			$this->size_wl->ViewCustomAttributes = "";

			// process_@
			$this->process_40->ViewValue = $this->process_40->CurrentValue;
			$this->process_40->ViewValue = FormatNumber($this->process_40->ViewValue, 2, -2, -2, -2);
			$this->process_40->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// c_charge
			$this->c_charge->ViewValue = $this->c_charge->CurrentValue;
			$this->c_charge->ViewValue = FormatNumber($this->c_charge->ViewValue, 2, -2, -2, -2);
			$this->c_charge->ViewCustomAttributes = "";

			// custom_size
			$this->custom_size->ViewValue = $this->custom_size->CurrentValue;
			$this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, 2, -2, -2, -2);
			$this->custom_size->ViewCustomAttributes = "";

			// ded_jc
			$this->ded_jc->ViewValue = $this->ded_jc->CurrentValue;
			$this->ded_jc->ViewValue = FormatNumber($this->ded_jc->ViewValue, 2, -2, -2, -2);
			$this->ded_jc->ViewCustomAttributes = "";

			// ded_pa
			$this->ded_pa->ViewValue = $this->ded_pa->CurrentValue;
			$this->ded_pa->ViewValue = FormatNumber($this->ded_pa->ViewValue, 2, -2, -2, -2);
			$this->ded_pa->ViewCustomAttributes = "";

			// c_id
			$curVal = strval($this->c_id->CurrentValue);
			if ($curVal <> "") {
				$this->c_id->ViewValue = $this->c_id->lookupCacheOption($curVal);
				if ($this->c_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=99 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->c_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$this->c_id->ViewValue = $this->c_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->c_id->ViewValue = $this->c_id->CurrentValue;
					}
				}
			} else {
				$this->c_id->ViewValue = NULL;
			}
			$this->c_id->ViewCustomAttributes = "";

			// payment_type
			if (strval($this->payment_type->CurrentValue) <> "") {
				$this->payment_type->ViewValue = $this->payment_type->optionCaption($this->payment_type->CurrentValue);
			} else {
				$this->payment_type->ViewValue = NULL;
			}
			$this->payment_type->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_grp
			$this->sqm_grp->ViewValue = $this->sqm_grp->CurrentValue;
			$this->sqm_grp->ViewValue = FormatNumber($this->sqm_grp->ViewValue, 2, -2, -2, -2);
			$this->sqm_grp->ViewCustomAttributes = "";

			// 2_srm
			$this->_2_srm->ViewValue = $this->_2_srm->CurrentValue;
			$this->_2_srm->ViewValue = FormatNumber($this->_2_srm->ViewValue, 2, -2, -2, -2);
			$this->_2_srm->ViewCustomAttributes = "";

			// 4_srm
			$this->_4_srm->ViewValue = $this->_4_srm->CurrentValue;
			$this->_4_srm->ViewValue = FormatNumber($this->_4_srm->ViewValue, 2, -2, -2, -2);
			$this->_4_srm->ViewCustomAttributes = "";

			// process_fix
			if (strval($this->process_fix->CurrentValue) <> "") {
				$this->process_fix->ViewValue = $this->process_fix->optionCaption($this->process_fix->CurrentValue);
			} else {
				$this->process_fix->ViewValue = NULL;
			}
			$this->process_fix->ViewCustomAttributes = "";

			// method
			if (strval($this->method->CurrentValue) <> "") {
				$this->method->ViewValue = $this->method->optionCaption($this->method->CurrentValue);
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// payment
			$curVal = strval($this->payment->CurrentValue);
			if ($curVal <> "") {
				$this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
				if ($this->payment->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->payment->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->payment->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->payment->ViewValue->add($this->payment->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->payment->ViewValue = $this->payment->CurrentValue;
					}
				}
			} else {
				$this->payment->ViewValue = NULL;
			}
			$this->payment->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// pps
			$this->pps->ViewValue = $this->pps->CurrentValue;
			$this->pps->ViewValue = FormatNumber($this->pps->ViewValue, 0, -2, -2, -2);
			$this->pps->ViewCustomAttributes = "";

			// c_method
			$this->c_method->ViewValue = $this->c_method->CurrentValue;
			$this->c_method->ViewValue = FormatNumber($this->c_method->ViewValue, 0, -2, -2, -2);
			$this->c_method->ViewCustomAttributes = "";

			// category
			$this->category->ViewValue = $this->category->CurrentValue;
			$this->category->ViewValue = FormatNumber($this->category->ViewValue, 0, -2, -2, -2);
			$this->category->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// emp_id
			$this->emp_id->LinkCustomAttributes = "";
			$this->emp_id->HrefValue = "";
			$this->emp_id->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// size_wl
			$this->size_wl->LinkCustomAttributes = "";
			$this->size_wl->HrefValue = "";
			$this->size_wl->TooltipValue = "";

			// process_@
			$this->process_40->LinkCustomAttributes = "";
			$this->process_40->HrefValue = "";
			$this->process_40->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// c_charge
			$this->c_charge->LinkCustomAttributes = "";
			$this->c_charge->HrefValue = "";
			$this->c_charge->TooltipValue = "";

			// custom_size
			$this->custom_size->LinkCustomAttributes = "";
			$this->custom_size->HrefValue = "";
			$this->custom_size->TooltipValue = "";

			// ded_jc
			$this->ded_jc->LinkCustomAttributes = "";
			$this->ded_jc->HrefValue = "";
			$this->ded_jc->TooltipValue = "";

			// ded_pa
			$this->ded_pa->LinkCustomAttributes = "";
			$this->ded_pa->HrefValue = "";
			$this->ded_pa->TooltipValue = "";

			// c_id
			$this->c_id->LinkCustomAttributes = "";
			$this->c_id->HrefValue = "";
			$this->c_id->TooltipValue = "";

			// payment_type
			$this->payment_type->LinkCustomAttributes = "";
			$this->payment_type->HrefValue = "";
			$this->payment_type->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_grp
			$this->sqm_grp->LinkCustomAttributes = "";
			$this->sqm_grp->HrefValue = "";
			$this->sqm_grp->TooltipValue = "";

			// 2_srm
			$this->_2_srm->LinkCustomAttributes = "";
			$this->_2_srm->HrefValue = "";
			$this->_2_srm->TooltipValue = "";

			// 4_srm
			$this->_4_srm->LinkCustomAttributes = "";
			$this->_4_srm->HrefValue = "";
			$this->_4_srm->TooltipValue = "";

			// process_fix
			$this->process_fix->LinkCustomAttributes = "";
			$this->process_fix->HrefValue = "";
			$this->process_fix->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";
			$this->payment->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// pps
			$this->pps->LinkCustomAttributes = "";
			$this->pps->HrefValue = "";
			$this->pps->TooltipValue = "";

			// c_method
			$this->c_method->LinkCustomAttributes = "";
			$this->c_method->HrefValue = "";
			$this->c_method->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->location->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// emp_id
			$this->emp_id->EditAttrs["class"] = "form-control";
			$this->emp_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->emp_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->lookupCacheOption($curVal);
			else
				$this->emp_id->AdvancedSearch->ViewValue = $this->emp_id->Lookup !== NULL && is_array($this->emp_id->Lookup->Options) ? $curVal : NULL;
			if ($this->emp_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->emp_id->EditValue = array_values($this->emp_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->emp_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->emp_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->emp_id->EditValue = $arwrk;
			}

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			$this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			$this->code->EditValue2 = HtmlEncode($this->code->AdvancedSearch->SearchValue2);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->ref->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->ref->AdvancedSearch->ViewValue = $this->ref->lookupCacheOption($curVal);
			else
				$this->ref->AdvancedSearch->ViewValue = $this->ref->Lookup !== NULL && is_array($this->ref->Lookup->Options) ? $curVal : NULL;
			if ($this->ref->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->ref->EditValue = array_values($this->ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->ref->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ref->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ref->EditValue = $arwrk;
			}

			// size_wl
			$this->size_wl->EditAttrs["class"] = "form-control";
			$this->size_wl->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_wl->AdvancedSearch->SearchValue = HtmlDecode($this->size_wl->AdvancedSearch->SearchValue);
			$this->size_wl->EditValue = HtmlEncode($this->size_wl->AdvancedSearch->SearchValue);
			$this->size_wl->PlaceHolder = RemoveHtml($this->size_wl->caption());

			// process_@
			$this->process_40->EditAttrs["class"] = "form-control";
			$this->process_40->EditCustomAttributes = "";
			$this->process_40->EditValue = HtmlEncode($this->process_40->AdvancedSearch->SearchValue);
			$this->process_40->PlaceHolder = RemoveHtml($this->process_40->caption());

			// final_amount
			$this->final_amount->EditAttrs["class"] = "form-control";
			$this->final_amount->EditCustomAttributes = "";
			$this->final_amount->EditValue = HtmlEncode($this->final_amount->AdvancedSearch->SearchValue);
			$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// c_charge
			$this->c_charge->EditAttrs["class"] = "form-control";
			$this->c_charge->EditCustomAttributes = "";
			$this->c_charge->EditValue = HtmlEncode($this->c_charge->AdvancedSearch->SearchValue);
			$this->c_charge->PlaceHolder = RemoveHtml($this->c_charge->caption());

			// custom_size
			$this->custom_size->EditAttrs["class"] = "form-control";
			$this->custom_size->EditCustomAttributes = "";
			$this->custom_size->EditValue = HtmlEncode($this->custom_size->AdvancedSearch->SearchValue);
			$this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

			// ded_jc
			$this->ded_jc->EditAttrs["class"] = "form-control";
			$this->ded_jc->EditCustomAttributes = "";
			$this->ded_jc->EditValue = HtmlEncode($this->ded_jc->AdvancedSearch->SearchValue);
			$this->ded_jc->PlaceHolder = RemoveHtml($this->ded_jc->caption());

			// ded_pa
			$this->ded_pa->EditAttrs["class"] = "form-control";
			$this->ded_pa->EditCustomAttributes = "";
			$this->ded_pa->EditValue = HtmlEncode($this->ded_pa->AdvancedSearch->SearchValue);
			$this->ded_pa->PlaceHolder = RemoveHtml($this->ded_pa->caption());

			// c_id
			$this->c_id->EditAttrs["class"] = "form-control";
			$this->c_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->c_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->c_id->AdvancedSearch->ViewValue = $this->c_id->lookupCacheOption($curVal);
			else
				$this->c_id->AdvancedSearch->ViewValue = $this->c_id->Lookup !== NULL && is_array($this->c_id->Lookup->Options) ? $curVal : NULL;
			if ($this->c_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->c_id->EditValue = array_values($this->c_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->c_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=99 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->c_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->c_id->EditValue = $arwrk;
			}

			// payment_type
			$this->payment_type->EditAttrs["class"] = "form-control";
			$this->payment_type->EditCustomAttributes = "";
			$this->payment_type->EditValue = $this->payment_type->options(TRUE);

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// sqm_grp
			$this->sqm_grp->EditAttrs["class"] = "form-control";
			$this->sqm_grp->EditCustomAttributes = "";
			$this->sqm_grp->EditValue = HtmlEncode($this->sqm_grp->AdvancedSearch->SearchValue);
			$this->sqm_grp->PlaceHolder = RemoveHtml($this->sqm_grp->caption());

			// 2_srm
			$this->_2_srm->EditAttrs["class"] = "form-control";
			$this->_2_srm->EditCustomAttributes = "";
			$this->_2_srm->EditValue = HtmlEncode($this->_2_srm->AdvancedSearch->SearchValue);
			$this->_2_srm->PlaceHolder = RemoveHtml($this->_2_srm->caption());

			// 4_srm
			$this->_4_srm->EditAttrs["class"] = "form-control";
			$this->_4_srm->EditCustomAttributes = "";
			$this->_4_srm->EditValue = HtmlEncode($this->_4_srm->AdvancedSearch->SearchValue);
			$this->_4_srm->PlaceHolder = RemoveHtml($this->_4_srm->caption());

			// process_fix
			$this->process_fix->EditAttrs["class"] = "form-control";
			$this->process_fix->EditCustomAttributes = "";
			$this->process_fix->EditValue = $this->process_fix->options(TRUE);

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$this->method->EditValue = $this->method->options(TRUE);

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// payment
			$this->payment->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->payment->AdvancedSearch->ViewValue = $this->payment->lookupCacheOption($curVal);
			else
				$this->payment->AdvancedSearch->ViewValue = $this->payment->Lookup !== NULL && is_array($this->payment->Lookup->Options) ? $curVal : NULL;
			if ($this->payment->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->payment->EditValue = array_values($this->payment->Lookup->Options);
				if ($this->payment->AdvancedSearch->ViewValue == "")
					$this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->payment->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->payment->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->payment->AdvancedSearch->ViewValue->add($this->payment->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->payment->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment->EditValue = $arwrk;
			}
			$this->payment->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->payment->AdvancedSearch->ViewValue2 = $this->payment->lookupCacheOption($curVal);
			else
				$this->payment->AdvancedSearch->ViewValue2 = $this->payment->Lookup !== NULL && is_array($this->payment->Lookup->Options) ? $curVal : NULL;
			if ($this->payment->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->payment->EditValue2 = array_values($this->payment->Lookup->Options);
				if ($this->payment->AdvancedSearch->ViewValue2 == "")
					$this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->payment->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->payment->AdvancedSearch->ViewValue2 = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->payment->AdvancedSearch->ViewValue2->add($this->payment->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->payment->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment->EditValue2 = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = HtmlEncode($this->grp->AdvancedSearch->SearchValue);
			$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// pps
			$this->pps->EditAttrs["class"] = "form-control";
			$this->pps->EditCustomAttributes = "";
			$this->pps->EditValue = HtmlEncode($this->pps->AdvancedSearch->SearchValue);
			$this->pps->PlaceHolder = RemoveHtml($this->pps->caption());

			// c_method
			$this->c_method->EditAttrs["class"] = "form-control";
			$this->c_method->EditCustomAttributes = "";
			$this->c_method->EditValue = HtmlEncode($this->c_method->AdvancedSearch->SearchValue);
			$this->c_method->PlaceHolder = RemoveHtml($this->c_method->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$this->category->EditValue = HtmlEncode($this->category->AdvancedSearch->SearchValue);
			$this->category->PlaceHolder = RemoveHtml($this->category->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->size_wl->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->size_wl->errorMessage());
		}
		if (!CheckInteger($this->process_40->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->process_40->errorMessage());
		}
		if (!CheckNumber($this->final_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->final_amount->errorMessage());
		}
		if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->amount->errorMessage());
		}
		if (!CheckNumber($this->c_charge->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->c_charge->errorMessage());
		}
		if (!CheckNumber($this->custom_size->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->custom_size->errorMessage());
		}
		if (!CheckNumber($this->ded_jc->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->ded_jc->errorMessage());
		}
		if (!CheckNumber($this->ded_pa->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->ded_pa->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckNumber($this->sqm_grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm_grp->errorMessage());
		}
		if (!CheckInteger($this->_2_srm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_2_srm->errorMessage());
		}
		if (!CheckInteger($this->_4_srm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_4_srm->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->grp->errorMessage());
		}
		if (!CheckInteger($this->pps->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pps->errorMessage());
		}
		if (!CheckInteger($this->c_method->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->c_method->errorMessage());
		}
		if (!CheckInteger($this->category->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->category->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->emp_id->AdvancedSearch->load();
		$this->code->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->size_wl->AdvancedSearch->load();
		$this->process_40->AdvancedSearch->load();
		$this->final_amount->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->c_charge->AdvancedSearch->load();
		$this->custom_size->AdvancedSearch->load();
		$this->ded_jc->AdvancedSearch->load();
		$this->ded_pa->AdvancedSearch->load();
		$this->c_id->AdvancedSearch->load();
		$this->payment_type->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_grp->AdvancedSearch->load();
		$this->_2_srm->AdvancedSearch->load();
		$this->_4_srm->AdvancedSearch->load();
		$this->process_fix->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->payment->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->remark->AdvancedSearch->load();
		$this->pps->AdvancedSearch->load();
		$this->c_method->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_action_paymentlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_emp_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_c_id":
					$lookupFilter = function() {
						return "`category`=99 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_process":
							break;
						case "x_emp_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_ref":
							break;
						case "x_c_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_payment":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>