<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_search extends process_action
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action';

	// Page object name
	public $PageObjName = "process_action_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action)
		if (!isset($GLOBALS["process_action"]) || get_class($GLOBALS["process_action"]) == PROJECT_NAMESPACE . "process_action") {
			$GLOBALS["process_action"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "process_actionview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_actionlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->process->setVisibility();
		$this->confirm_process->Visible = FALSE;
		$this->process_other->setVisibility();
		$this->location->setVisibility();
		$this->godown->setVisibility();
		$this->code->setVisibility();
		$this->code_last->setVisibility();
		$this->employee_1->Visible = FALSE;
		$this->employee_2->Visible = FALSE;
		$this->employee_3->Visible = FALSE;
		$this->employee_id->setVisibility();
		$this->qty->setVisibility();
		$this->roll_no->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->size_actual->setVisibility();
		$this->weight_actual->setVisibility();
		$this->lines_in_30cm->setVisibility();
		$this->valuation->setVisibility();
		$this->deduction->setVisibility();
		$this->remark->setVisibility();
		$this->upload->setVisibility();
		$this->uid->Visible = FALSE;
		$this->payment->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->confirm_process);
		$this->setupLookupOptions($this->process_other);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->employee_1);
		$this->setupLookupOptions($this->employee_2);
		$this->setupLookupOptions($this->employee_3);
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->payment);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "process_actionlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->process); // process
		$this->buildSearchUrl($srchUrl, $this->process_other); // process_other
		$this->buildSearchUrl($srchUrl, $this->location); // location
		$this->buildSearchUrl($srchUrl, $this->godown); // godown
		$this->buildSearchUrl($srchUrl, $this->code); // code
		$this->buildSearchUrl($srchUrl, $this->code_last); // code_last
		$this->buildSearchUrl($srchUrl, $this->employee_id); // employee_id
		$this->buildSearchUrl($srchUrl, $this->qty); // qty
		$this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->size_actual); // size_actual
		$this->buildSearchUrl($srchUrl, $this->weight_actual); // weight_actual
		$this->buildSearchUrl($srchUrl, $this->lines_in_30cm); // lines_in_30cm
		$this->buildSearchUrl($srchUrl, $this->valuation); // valuation
		$this->buildSearchUrl($srchUrl, $this->deduction); // deduction
		$this->buildSearchUrl($srchUrl, $this->remark); // remark
		$this->buildSearchUrl($srchUrl, $this->upload); // upload
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process"));
		$this->process->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process"));

		// process_other
		if (!$this->isAddOrEdit())
			$this->process_other->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_other"));
		$this->process_other->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_other"));
		if (is_array($this->process_other->AdvancedSearch->SearchValue))
			$this->process_other->AdvancedSearch->SearchValue = implode(",", $this->process_other->AdvancedSearch->SearchValue);
		if (is_array($this->process_other->AdvancedSearch->SearchValue2))
			$this->process_other->AdvancedSearch->SearchValue2 = implode(",", $this->process_other->AdvancedSearch->SearchValue2);

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_location"));
		$this->location->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_location"));

		// godown
		if (!$this->isAddOrEdit())
			$this->godown->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_godown"));
		$this->godown->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_godown"));

		// code
		if (!$this->isAddOrEdit())
			$this->code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_code"));
		$this->code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_code"));
		$this->code->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_code"));
		$this->code->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_code"));
		$this->code->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_code"));

		// code_last
		if (!$this->isAddOrEdit())
			$this->code_last->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_code_last"));
		$this->code_last->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_code_last"));
		$this->code_last->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_code_last"));
		$this->code_last->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_code_last"));
		$this->code_last->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_code_last"));

		// employee_id
		if (!$this->isAddOrEdit())
			$this->employee_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_employee_id"));
		$this->employee_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_employee_id"));
		$this->employee_id->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_employee_id"));
		$this->employee_id->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_employee_id"));
		$this->employee_id->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_employee_id"));
		if (is_array($this->employee_id->AdvancedSearch->SearchValue))
			$this->employee_id->AdvancedSearch->SearchValue = implode(",", $this->employee_id->AdvancedSearch->SearchValue);
		if (is_array($this->employee_id->AdvancedSearch->SearchValue2))
			$this->employee_id->AdvancedSearch->SearchValue2 = implode(",", $this->employee_id->AdvancedSearch->SearchValue2);

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty"));
		$this->qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty"));

		// roll_no
		if (!$this->isAddOrEdit())
			$this->roll_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_roll_no"));
		$this->roll_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_roll_no"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
		$this->datetime->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_datetime"));
		$this->datetime->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_datetime"));

		// size_actual
		if (!$this->isAddOrEdit())
			$this->size_actual->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size_actual"));
		$this->size_actual->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size_actual"));

		// weight_actual
		if (!$this->isAddOrEdit())
			$this->weight_actual->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_weight_actual"));
		$this->weight_actual->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_weight_actual"));

		// lines_in_30cm
		if (!$this->isAddOrEdit())
			$this->lines_in_30cm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lines_in_30cm"));
		$this->lines_in_30cm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lines_in_30cm"));

		// valuation
		if (!$this->isAddOrEdit())
			$this->valuation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_valuation"));
		$this->valuation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_valuation"));

		// deduction
		if (!$this->isAddOrEdit())
			$this->deduction->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_deduction"));
		$this->deduction->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_deduction"));

		// remark
		if (!$this->isAddOrEdit())
			$this->remark->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remark"));
		$this->remark->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remark"));

		// upload
		if (!$this->isAddOrEdit())
			$this->upload->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_upload"));
		$this->upload->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_upload"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->weight_actual->FormValue == $this->weight_actual->CurrentValue && is_numeric(ConvertToFloatString($this->weight_actual->CurrentValue)))
			$this->weight_actual->CurrentValue = ConvertToFloatString($this->weight_actual->CurrentValue);

		// Convert decimal values if posted back
		if ($this->lines_in_30cm->FormValue == $this->lines_in_30cm->CurrentValue && is_numeric(ConvertToFloatString($this->lines_in_30cm->CurrentValue)))
			$this->lines_in_30cm->CurrentValue = ConvertToFloatString($this->lines_in_30cm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->deduction->FormValue == $this->deduction->CurrentValue && is_numeric(ConvertToFloatString($this->deduction->CurrentValue)))
			$this->deduction->CurrentValue = ConvertToFloatString($this->deduction->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// process
		// confirm_process
		// process_other
		// location
		// godown
		// code
		// code_last
		// employee_1
		// employee_2
		// employee_3
		// employee_id
		// qty
		// roll_no
		// operator
		// datetime
		// size_actual
		// weight_actual
		// lines_in_30cm
		// valuation
		// deduction
		// remark
		// upload
		// uid
		// payment

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_other
			$curVal = strval($this->process_other->CurrentValue);
			if ($curVal <> "") {
				$this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
				if ($this->process_other->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_other->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_other->ViewValue->add($this->process_other->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_other->ViewValue = $this->process_other->CurrentValue;
					}
				}
			} else {
				$this->process_other->ViewValue = NULL;
			}
			$this->process_other->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`= 1 and `id` > 1 && `id` != 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// code_last
			$this->code_last->ViewValue = $this->code_last->CurrentValue;
			$this->code_last->ViewCustomAttributes = "";

			// employee_id
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->employee_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			$this->employee_id->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 117);
			$this->datetime->ViewCustomAttributes = "";

			// size_actual
			$this->size_actual->ViewValue = $this->size_actual->CurrentValue;
			$this->size_actual->ViewCustomAttributes = "";

			// weight_actual
			$this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
			$this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, 2, -2, -2, -2);
			$this->weight_actual->ViewCustomAttributes = "";

			// lines_in_30cm
			$this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
			$this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, 2, -2, -2, -2);
			$this->lines_in_30cm->ViewCustomAttributes = "";

			// valuation
			if (strval($this->valuation->CurrentValue) <> "") {
				$this->valuation->ViewValue = $this->valuation->optionCaption($this->valuation->CurrentValue);
			} else {
				$this->valuation->ViewValue = NULL;
			}
			$this->valuation->ViewCustomAttributes = "";

			// deduction
			$this->deduction->ViewValue = $this->deduction->CurrentValue;
			$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 2, -2, -2, -2);
			$this->deduction->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// process_other
			$this->process_other->LinkCustomAttributes = "";
			$this->process_other->HrefValue = "";
			$this->process_other->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";
			$this->godown->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			if (!EmptyValue($this->code->CurrentValue)) {
				$this->code->HrefValue = "bcodelist.php?x__barcode=" . $this->code->CurrentValue; // Add prefix/suffix
				$this->code->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
			} else {
				$this->code->HrefValue = "";
			}
			$this->code->TooltipValue = "";

			// code_last
			$this->code_last->LinkCustomAttributes = "";
			$this->code_last->HrefValue = "";
			$this->code_last->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			$this->employee_id->HrefValue = "";
			$this->employee_id->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// size_actual
			$this->size_actual->LinkCustomAttributes = "";
			$this->size_actual->HrefValue = "";
			$this->size_actual->TooltipValue = "";

			// weight_actual
			$this->weight_actual->LinkCustomAttributes = "";
			$this->weight_actual->HrefValue = "";
			$this->weight_actual->TooltipValue = "";

			// lines_in_30cm
			$this->lines_in_30cm->LinkCustomAttributes = "";
			$this->lines_in_30cm->HrefValue = "";
			$this->lines_in_30cm->TooltipValue = "";

			// valuation
			$this->valuation->LinkCustomAttributes = "";
			$this->valuation->HrefValue = "";
			$this->valuation->TooltipValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";
			$this->deduction->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->Upload->DbValue); // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "process_action_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `type` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// process_other
			$this->process_other->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_other->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process_other->AdvancedSearch->ViewValue = $this->process_other->lookupCacheOption($curVal);
			else
				$this->process_other->AdvancedSearch->ViewValue = $this->process_other->Lookup !== NULL && is_array($this->process_other->Lookup->Options) ? $curVal : NULL;
			if ($this->process_other->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process_other->EditValue = array_values($this->process_other->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_other->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_other->EditValue = $arwrk;
			}

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->location->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->godown->AdvancedSearch->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->AdvancedSearch->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`= 1 and `id` > 1 && `id` != 10";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = 'autofocus';
			if (REMOVE_XSS)
				$this->code->AdvancedSearch->SearchValue = HtmlDecode($this->code->AdvancedSearch->SearchValue);
			$this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = 'autofocus';
			if (REMOVE_XSS)
				$this->code->AdvancedSearch->SearchValue2 = HtmlDecode($this->code->AdvancedSearch->SearchValue2);
			$this->code->EditValue2 = HtmlEncode($this->code->AdvancedSearch->SearchValue2);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// code_last
			$this->code_last->EditAttrs["class"] = "form-control";
			$this->code_last->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->code_last->AdvancedSearch->SearchValue = HtmlDecode($this->code_last->AdvancedSearch->SearchValue);
			$this->code_last->EditValue = HtmlEncode($this->code_last->AdvancedSearch->SearchValue);
			$this->code_last->PlaceHolder = RemoveHtml($this->code_last->caption());
			$this->code_last->EditAttrs["class"] = "form-control";
			$this->code_last->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->code_last->AdvancedSearch->SearchValue2 = HtmlDecode($this->code_last->AdvancedSearch->SearchValue2);
			$this->code_last->EditValue2 = HtmlEncode($this->code_last->AdvancedSearch->SearchValue2);
			$this->code_last->PlaceHolder = RemoveHtml($this->code_last->caption());

			// employee_id
			$this->employee_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			else
				$this->employee_id->AdvancedSearch->ViewValue = $this->employee_id->Lookup !== NULL && is_array($this->employee_id->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->employee_id->EditValue = array_values($this->employee_id->Lookup->Options);
				if ($this->employee_id->AdvancedSearch->ViewValue == "")
					$this->employee_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_id->AdvancedSearch->ViewValue->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->employee_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_id->EditValue = $arwrk;
			}
			$this->employee_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_id->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->employee_id->AdvancedSearch->ViewValue2 = $this->employee_id->lookupCacheOption($curVal);
			else
				$this->employee_id->AdvancedSearch->ViewValue2 = $this->employee_id->Lookup !== NULL && is_array($this->employee_id->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_id->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->employee_id->EditValue2 = array_values($this->employee_id->Lookup->Options);
				if ($this->employee_id->AdvancedSearch->ViewValue2 == "")
					$this->employee_id->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->AdvancedSearch->ViewValue2 = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_id->AdvancedSearch->ViewValue2->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->employee_id->AdvancedSearch->ViewValue2 = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_id->EditValue2 = $arwrk;
			}

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->AdvancedSearch->SearchValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 117), 117));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, 117), 117));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// size_actual
			$this->size_actual->EditAttrs["class"] = "form-control";
			$this->size_actual->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_actual->AdvancedSearch->SearchValue = HtmlDecode($this->size_actual->AdvancedSearch->SearchValue);
			$this->size_actual->EditValue = HtmlEncode($this->size_actual->AdvancedSearch->SearchValue);
			$this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

			// weight_actual
			$this->weight_actual->EditAttrs["class"] = "form-control";
			$this->weight_actual->EditCustomAttributes = "";
			$this->weight_actual->EditValue = HtmlEncode($this->weight_actual->AdvancedSearch->SearchValue);
			$this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());

			// lines_in_30cm
			$this->lines_in_30cm->EditAttrs["class"] = "form-control";
			$this->lines_in_30cm->EditCustomAttributes = "";
			$this->lines_in_30cm->EditValue = HtmlEncode($this->lines_in_30cm->AdvancedSearch->SearchValue);
			$this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());

			// valuation
			$this->valuation->EditAttrs["class"] = "form-control";
			$this->valuation->EditCustomAttributes = "";
			$this->valuation->EditValue = $this->valuation->options(TRUE);

			// deduction
			$this->deduction->EditAttrs["class"] = "form-control";
			$this->deduction->EditCustomAttributes = "";
			$this->deduction->EditValue = HtmlEncode($this->deduction->AdvancedSearch->SearchValue);
			$this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// upload
			$this->upload->EditAttrs["class"] = "form-control";
			$this->upload->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->upload->AdvancedSearch->SearchValue = HtmlDecode($this->upload->AdvancedSearch->SearchValue);
			$this->upload->EditValue = HtmlEncode($this->upload->AdvancedSearch->SearchValue);
			$this->upload->PlaceHolder = RemoveHtml($this->upload->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckNumber($this->weight_actual->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->weight_actual->errorMessage());
		}
		if (!CheckNumber($this->lines_in_30cm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->lines_in_30cm->errorMessage());
		}
		if (!CheckNumber($this->deduction->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->deduction->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->process_other->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->code->AdvancedSearch->load();
		$this->code_last->AdvancedSearch->load();
		$this->employee_id->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->size_actual->AdvancedSearch->load();
		$this->weight_actual->AdvancedSearch->load();
		$this->lines_in_30cm->AdvancedSearch->load();
		$this->valuation->AdvancedSearch->load();
		$this->deduction->AdvancedSearch->load();
		$this->remark->AdvancedSearch->load();
		$this->upload->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_actionlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_process":
					$lookupFilter = function() {
						return "`status` = 1 and `type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_confirm_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_other":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_location":
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0 && `id` != 10" : "`id` > 0 && `id` != 10 && FIND_IN_SET(`id`, '" . User_Site() . "')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return "`status`= 1 and `id` > 1 && `id` != 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_1":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_2":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_3":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_process":
							break;
						case "x_confirm_process":
							break;
						case "x_process_other":
							break;
						case "x_location":
							break;
						case "x_godown":
							break;
						case "x_employee_1":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_2":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_3":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_operator":
							break;
						case "x_payment":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'process_action');	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>