<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_action_single_delete extends process_action_single
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_action_single';

	// Page object name
	public $PageObjName = "process_action_single_delete";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_action_single)
		if (!isset($GLOBALS["process_action_single"]) || get_class($GLOBALS["process_action_single"]) == PROJECT_NAMESPACE . "process_action_single") {
			$GLOBALS["process_action_single"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_action_single"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_action_single');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_action_single;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_action_single);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $TotalRecs = 0;
	public $RecCnt;
	public $RecKeys = array();
	public $StartRowCnt = 1;
	public $RowCnt = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_action_singlelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->location->setVisibility();
		$this->process->setVisibility();
		$this->employee_1->Visible = FALSE;
		$this->employee_2->Visible = FALSE;
		$this->employee_3->Visible = FALSE;
		$this->employee_id->setVisibility();
		$this->confirm_process->Visible = FALSE;
		$this->code->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->roll_no->setVisibility();
		$this->qty->setVisibility();
		$this->size_actual->setVisibility();
		$this->weight_actual->setVisibility();
		$this->valuation->setVisibility();
		$this->deduction->setVisibility();
		$this->upload->setVisibility();
		$this->payment->setVisibility();
		$this->remark->setVisibility();
		$this->tmp_id->setVisibility();
		$this->process_other->setVisibility();
		$this->uid->Visible = FALSE;
		$this->buyer_id->setVisibility();
		$this->design_id->setVisibility();
		$this->size_cm->setVisibility();
		$this->sqm->setVisibility();
		$this->jc_no->setVisibility();
		$this->loom_id->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->employee_1);
		$this->setupLookupOptions($this->employee_2);
		$this->setupLookupOptions($this->employee_3);
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->confirm_process);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->payment);
		$this->setupLookupOptions($this->process_other);
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->design_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("process_action_singlelist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("process_action_singlelist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->location->setDbValue($row['location']);
		$this->process->setDbValue($row['process']);
		$this->employee_1->setDbValue($row['employee_1']);
		$this->employee_2->setDbValue($row['employee_2']);
		$this->employee_3->setDbValue($row['employee_3']);
		$this->employee_id->setDbValue($row['employee_id']);
		$this->confirm_process->setDbValue($row['confirm_process']);
		$this->code->setDbValue($row['code']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->qty->setDbValue($row['qty']);
		$this->size_actual->setDbValue($row['size_actual']);
		$this->weight_actual->setDbValue($row['weight_actual']);
		$this->valuation->setDbValue($row['valuation']);
		$this->deduction->setDbValue($row['deduction']);
		$this->upload->Upload->DbValue = $row['upload'];
		$this->upload->setDbValue($this->upload->Upload->DbValue);
		$this->payment->setDbValue($row['payment']);
		$this->remark->setDbValue($row['remark']);
		$this->tmp_id->setDbValue($row['tmp_id']);
		$this->process_other->setDbValue($row['process_other']);
		$this->uid->setDbValue($row['uid']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		if (array_key_exists('EV__buyer_id', $rs->fields)) {
			$this->buyer_id->VirtualValue = $rs->fields('EV__buyer_id'); // Set up virtual field value
		} else {
			$this->buyer_id->VirtualValue = ""; // Clear value
		}
		$this->design_id->setDbValue($row['design_id']);
		if (array_key_exists('EV__design_id', $rs->fields)) {
			$this->design_id->VirtualValue = $rs->fields('EV__design_id'); // Set up virtual field value
		} else {
			$this->design_id->VirtualValue = ""; // Clear value
		}
		$this->size_cm->setDbValue($row['size_cm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->loom_id->setDbValue($row['loom_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['location'] = NULL;
		$row['process'] = NULL;
		$row['employee_1'] = NULL;
		$row['employee_2'] = NULL;
		$row['employee_3'] = NULL;
		$row['employee_id'] = NULL;
		$row['confirm_process'] = NULL;
		$row['code'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['roll_no'] = NULL;
		$row['qty'] = NULL;
		$row['size_actual'] = NULL;
		$row['weight_actual'] = NULL;
		$row['valuation'] = NULL;
		$row['deduction'] = NULL;
		$row['upload'] = NULL;
		$row['payment'] = NULL;
		$row['remark'] = NULL;
		$row['tmp_id'] = NULL;
		$row['process_other'] = NULL;
		$row['uid'] = NULL;
		$row['buyer_id'] = NULL;
		$row['design_id'] = NULL;
		$row['size_cm'] = NULL;
		$row['sqm'] = NULL;
		$row['jc_no'] = NULL;
		$row['loom_id'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->weight_actual->FormValue == $this->weight_actual->CurrentValue && is_numeric(ConvertToFloatString($this->weight_actual->CurrentValue)))
			$this->weight_actual->CurrentValue = ConvertToFloatString($this->weight_actual->CurrentValue);

		// Convert decimal values if posted back
		if ($this->deduction->FormValue == $this->deduction->CurrentValue && is_numeric(ConvertToFloatString($this->deduction->CurrentValue)))
			$this->deduction->CurrentValue = ConvertToFloatString($this->deduction->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// location
		// process
		// employee_1

		$this->employee_1->CellCssStyle = "white-space: nowrap;";

		// employee_2
		$this->employee_2->CellCssStyle = "white-space: nowrap;";

		// employee_3
		$this->employee_3->CellCssStyle = "white-space: nowrap;";

		// employee_id
		// confirm_process

		$this->confirm_process->CellCssStyle = "white-space: nowrap;";

		// code
		// operator
		// datetime
		// roll_no
		// qty
		// size_actual
		// weight_actual
		// valuation
		// deduction
		// upload
		// payment

		$this->payment->CellCssStyle = "white-space: nowrap;";

		// remark
		// tmp_id

		$this->tmp_id->CellCssStyle = "white-space: nowrap;";

		// process_other
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// buyer_id
		// design_id
		// size_cm
		// sqm
		// jc_no
		// loom_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// employee_id
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->employee_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			$this->employee_id->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 11);
			$this->datetime->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// size_actual
			$this->size_actual->ViewValue = $this->size_actual->CurrentValue;
			$this->size_actual->ViewCustomAttributes = "";

			// weight_actual
			$this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
			$this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, 2, -2, -2, -2);
			$this->weight_actual->ViewCustomAttributes = "";

			// valuation
			if (strval($this->valuation->CurrentValue) <> "") {
				$this->valuation->ViewValue = $this->valuation->optionCaption($this->valuation->CurrentValue);
			} else {
				$this->valuation->ViewValue = NULL;
			}
			$this->valuation->ViewCustomAttributes = "";

			// deduction
			$this->deduction->ViewValue = $this->deduction->CurrentValue;
			$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 2, -2, -2, -2);
			$this->deduction->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// payment
			$curVal = strval($this->payment->CurrentValue);
			if ($curVal <> "") {
				$this->payment->ViewValue = $this->payment->lookupCacheOption($curVal);
				if ($this->payment->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->payment->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->payment->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->payment->ViewValue->add($this->payment->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->payment->ViewValue = $this->payment->CurrentValue;
					}
				}
			} else {
				$this->payment->ViewValue = NULL;
			}
			$this->payment->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// tmp_id
			$this->tmp_id->ViewValue = $this->tmp_id->CurrentValue;
			$this->tmp_id->ViewValue = FormatNumber($this->tmp_id->ViewValue, 0, -2, -2, -2);
			$this->tmp_id->ViewCustomAttributes = "";

			// process_other
			$curVal = strval($this->process_other->CurrentValue);
			if ($curVal <> "") {
				$this->process_other->ViewValue = $this->process_other->lookupCacheOption($curVal);
				if ($this->process_other->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_other->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_other->ViewValue->add($this->process_other->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_other->ViewValue = $this->process_other->CurrentValue;
					}
				}
			} else {
				$this->process_other->ViewValue = NULL;
			}
			$this->process_other->ViewCustomAttributes = "";

			// buyer_id
			if ($this->buyer_id->VirtualValue <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->VirtualValue;
			} else {
				$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// design_id
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->ViewValue = $this->design_id->VirtualValue;
			} else {
				$this->design_id->ViewValue = $this->design_id->CurrentValue;
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// loom_id
			$this->loom_id->ViewValue = $this->loom_id->CurrentValue;
			$this->loom_id->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "process_actionlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			$this->employee_id->HrefValue = "";
			$this->employee_id->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			if (!EmptyValue($this->code->CurrentValue)) {
				$this->code->HrefValue = "bcodelist.php?x__barcode=" . $this->code->CurrentValue; // Add prefix/suffix
				$this->code->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->code->HrefValue = FullUrl($this->code->HrefValue, "href");
			} else {
				$this->code->HrefValue = "";
			}
			$this->code->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// size_actual
			$this->size_actual->LinkCustomAttributes = "";
			$this->size_actual->HrefValue = "";
			$this->size_actual->TooltipValue = "";

			// weight_actual
			$this->weight_actual->LinkCustomAttributes = "";
			$this->weight_actual->HrefValue = "";
			$this->weight_actual->TooltipValue = "";

			// valuation
			$this->valuation->LinkCustomAttributes = "";
			$this->valuation->HrefValue = "";
			$this->valuation->TooltipValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";
			$this->deduction->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = '.p_uploads/weaving/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = GetFileUploadUrl($this->upload, $this->upload->Upload->DbValue); // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "process_action_single_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";
			$this->payment->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// tmp_id
			$this->tmp_id->LinkCustomAttributes = "";
			$this->tmp_id->HrefValue = "";
			$this->tmp_id->TooltipValue = "";

			// process_other
			$this->process_other->LinkCustomAttributes = "";
			$this->process_other->HrefValue = "";
			$this->process_other->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			$this->design_id->HrefValue = "";
			$this->design_id->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// loom_id
			$this->loom_id->LinkCustomAttributes = "";
			$this->loom_id->HrefValue = "";
			$this->loom_id->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();
		if ($this->AuditTrailOnDelete)
			$this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
		} else {
			$conn->rollbackTrans(); // Rollback changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_action_singlelist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status` = 1 and `type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_1":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_2":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_3":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  ($_COOKIE['Location']  == 0)? "Process like '%". $_COOKIE['prid'] ."%' and status = 1" : "FIND_IN_SET(" . $_COOKIE['Location'] . ",`site`) and `status` = 1 and Process like '%". $_COOKIE['prid'] . "%'" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_confirm_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_other":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ?  "`status` = 1 and `id` != " . $_COOKIE["prid"] . " and FIND_IN_SET(". $_COOKIE["prid"] .", `pao`)" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_design_id":
					$lookupFilter = function() {
						return "`grp`=3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_process":
							break;
						case "x_employee_1":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_2":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_3":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_confirm_process":
							break;
						case "x_operator":
							break;
						case "x_payment":
							break;
						case "x_process_other":
							break;
						case "x_buyer_id":
							break;
						case "x_design_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";\
		PageFieldValidate($this,'process_action_single');			
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>