<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class process_table_fp_delete extends process_table_fp
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'process_table_fp';

	// Page object name
	public $PageObjName = "process_table_fp_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (process_table_fp)
		if (!isset($GLOBALS["process_table_fp"]) || get_class($GLOBALS["process_table_fp"]) == PROJECT_NAMESPACE . "process_table_fp") {
			$GLOBALS["process_table_fp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["process_table_fp"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'process_table_fp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $process_table_fp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($process_table_fp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $TotalRecs = 0;
	public $RecCnt;
	public $RecKeys = array();
	public $StartRowCnt = 1;
	public $RowCnt = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("process_table_fplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->ref->setVisibility();
		$this->product_new->Visible = FALSE;
		$this->batch_no->setVisibility();
		$this->process->setVisibility();
		$this->product_code_new->setVisibility();
		$this->emp_name->setVisibility();
		$this->packets->setVisibility();
		$this->quantity_avg_act->setVisibility();
		$this->quantity->setVisibility();
		$this->packing_type->setVisibility();
		$this->payment->setVisibility();
		$this->godown->setVisibility();
		$this->dated->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->product->Visible = FALSE;
		$this->rid->setVisibility();
		$this->remarks->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->ref);
		$this->setupLookupOptions($this->product_new);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->product_code_new);
		$this->setupLookupOptions($this->emp_name);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("process_table_fplist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("process_table_fplist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->ref->setDbValue($row['ref']);
		$this->product_new->setDbValue($row['product_new']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->process->setDbValue($row['process']);
		$this->product_code_new->setDbValue($row['product_code_new']);
		$this->emp_name->setDbValue($row['emp_name']);
		$this->packets->setDbValue($row['packets']);
		$this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
		$this->quantity->setDbValue($row['quantity']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->payment->setDbValue($row['payment']);
		$this->godown->setDbValue($row['godown']);
		$this->dated->setDbValue($row['dated']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->remarks->setDbValue($row['remarks']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['ref'] = NULL;
		$row['product_new'] = NULL;
		$row['batch_no'] = NULL;
		$row['process'] = NULL;
		$row['product_code_new'] = NULL;
		$row['emp_name'] = NULL;
		$row['packets'] = NULL;
		$row['quantity_avg_act'] = NULL;
		$row['quantity'] = NULL;
		$row['packing_type'] = NULL;
		$row['payment'] = NULL;
		$row['godown'] = NULL;
		$row['dated'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['remarks'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->payment->FormValue == $this->payment->CurrentValue && is_numeric(ConvertToFloatString($this->payment->CurrentValue)))
			$this->payment->CurrentValue = ConvertToFloatString($this->payment->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// ref
		// product_new

		$this->product_new->CellCssStyle = "white-space: nowrap;";

		// batch_no
		// process
		// product_code_new
		// emp_name
		// packets
		// quantity_avg_act
		// quantity
		// packing_type
		// payment
		// godown
		// dated
		// operator
		// datetime
		// product

		$this->product->CellCssStyle = "white-space: nowrap;";

		// rid
		$this->rid->CellCssStyle = "white-space: nowrap;";

		// remarks
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// ref
			$curVal = strval($this->ref->CurrentValue);
			if ($curVal <> "") {
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
				if ($this->ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`balance_quantity` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->ref->ViewValue = $this->ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ref->ViewValue = $this->ref->CurrentValue;
					}
				}
			} else {
				$this->ref->ViewValue = NULL;
			}
			$this->ref->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
			$this->batch_no->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`process`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// product_code_new
			$curVal = strval($this->product_code_new->CurrentValue);
			if ($curVal <> "") {
				$this->product_code_new->ViewValue = $this->product_code_new->lookupCacheOption($curVal);
				if ($this->product_code_new->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_code_new->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_code_new->ViewValue = $this->product_code_new->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_code_new->ViewValue = $this->product_code_new->CurrentValue;
					}
				}
			} else {
				$this->product_code_new->ViewValue = NULL;
			}
			$this->product_code_new->ViewCustomAttributes = "";

			// emp_name
			$curVal = strval($this->emp_name->CurrentValue);
			if ($curVal <> "") {
				$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
				if ($this->emp_name->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`uid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->emp_name->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
					}
				}
			} else {
				$this->emp_name->ViewValue = NULL;
			}
			$this->emp_name->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// quantity_avg_act
			if (strval($this->quantity_avg_act->CurrentValue) <> "") {
				$this->quantity_avg_act->ViewValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
			} else {
				$this->quantity_avg_act->ViewValue = NULL;
			}
			$this->quantity_avg_act->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// payment
			$this->payment->ViewValue = $this->payment->CurrentValue;
			$this->payment->ViewValue = FormatNumber($this->payment->ViewValue, 2, -2, -2, -2);
			$this->payment->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`,'0,2')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// rid
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->ref->CurrentValue)) {
				$this->ref->HrefValue = "process_table_fplist.php?x_ref=" . $this->ref->CurrentValue; // Add prefix/suffix
				$this->ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
			} else {
				$this->ref->HrefValue = "";
			}
			$this->ref->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "process_table_fplist.php?x_batch_no=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "process_table_fpadd.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// product_code_new
			$this->product_code_new->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code_new->CurrentValue)) {
				$this->product_code_new->HrefValue = "process_table_fplist.php?x_product_code_new=" . $this->product_code_new->CurrentValue; // Add prefix/suffix
				$this->product_code_new->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code_new->HrefValue = FullUrl($this->product_code_new->HrefValue, "href");
			} else {
				$this->product_code_new->HrefValue = "";
			}
			$this->product_code_new->TooltipValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			if (!EmptyValue($this->emp_name->CurrentValue)) {
				$this->emp_name->HrefValue = "process_table_fpadd.php?x_emp_name=" . $this->emp_name->CurrentValue; // Add prefix/suffix
				$this->emp_name->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->emp_name->HrefValue = FullUrl($this->emp_name->HrefValue, "href");
			} else {
				$this->emp_name->HrefValue = "";
			}
			$this->emp_name->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// quantity_avg_act
			$this->quantity_avg_act->LinkCustomAttributes = "";
			$this->quantity_avg_act->HrefValue = "";
			$this->quantity_avg_act->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "process_table_fpadd.php?x_packing _type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// payment
			$this->payment->LinkCustomAttributes = "";
			$this->payment->HrefValue = "";
			$this->payment->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "process_table_fpadd.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "process_table_fpadd.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("process_table_fplist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_ref":
					$lookupFilter = function() {
						return "`balance_quantity` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`,'0,2')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_ref":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_product_new":
							break;
						case "x_process":
							break;
						case "x_product_code_new":
							break;
						case "x_emp_name":
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_packing_type":
							break;
						case "x_godown":
							break;
						case "x_operator":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>