<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for process_table_hs
 */
class process_table_hs extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $grp;
	public $godown;
	public $emp_name;
	public $ref;
	public $rid;
	public $batch_no;
	public $count;
	public $count_received;
	public $twist;
	public $quantity_avg_act;
	public $quantity;
	public $status;
	public $std_rate;
	public $_40;
	public $total_amount;
	public $payment;
	public $remarks;
	public $operator;
	public $datetime;
	public $product;
	public $process;
	public $packets;
	public $packing_type;
	public $product_code_new;
	public $product_new;
	public $dated;
	public $s_grp;
	public $lot_no;
	public $tmp_lot;
	public $shortage;
	public $shortage_amount;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'process_table_hs';
		$this->TableName = 'process_table_hs';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`process_table_hs`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('process_table_hs', 'process_table_hs', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// grp
		$this->grp = new DbField('process_table_hs', 'process_table_hs', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'process_table_hs', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->grp->OptionCount = 1;
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// godown
		$this->godown = new DbField('process_table_hs', 'process_table_hs', 'x_godown', 'godown', '`godown`', '`godown`', 17, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->godown->Nullable = FALSE; // NOT NULL field
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["name","code","",""], [], ["x_emp_name"], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// emp_name
		$this->emp_name = new DbField('process_table_hs', 'process_table_hs', 'x_emp_name', 'emp_name', '`emp_name`', '`emp_name`', 200, -1, FALSE, '`EV__emp_name`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->emp_name->Nullable = FALSE; // NOT NULL field
		$this->emp_name->Required = TRUE; // Required field
		$this->emp_name->Sortable = TRUE; // Allow sort
		$this->emp_name->Lookup = new Lookup('emp_name', 'stock_material_out_emp_hs', TRUE, 'emp_id', ["emp_id","emp_name","",""], ["x_godown"], ["x_ref","x_product"], ["godown"], ["x_godown"], ["outid"], ["x_ref"], '`emp_name` ASC', '');
		$this->fields['emp_name'] = &$this->emp_name;

		// ref
		$this->ref = new DbField('process_table_hs', 'process_table_hs', 'x_ref', 'ref', '`ref`', '`ref`', 18, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ref->Nullable = FALSE; // NOT NULL field
		$this->ref->Required = TRUE; // Required field
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->ref->Lookup = new Lookup('ref', 'stock_material_out_emp_hs', FALSE, 'jc_no', ["jc_no","item_code","Balance",""], ["x_emp_name"], [], ["emp_id"], ["x_emp_id"], ["item","batch_no","count","Balance"], ["x_rid","x_batch_no","x_count","x_quantity_avg_act"], '`item` ASC', '');
		$this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ref'] = &$this->ref;

		// rid
		$this->rid = new DbField('process_table_hs', 'process_table_hs', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = FALSE; // Allow sort
		$this->rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid->Lookup = new Lookup('rid', 'stock_material_out_emp_hs', FALSE, 'item', ["item_code","","",""], [], ["x_std_rate"], [], [], [], [], '`item` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// batch_no
		$this->batch_no = new DbField('process_table_hs', 'process_table_hs', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Nullable = FALSE; // NOT NULL field
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// count
		$this->count = new DbField('process_table_hs', 'process_table_hs', 'x_count', 'count', '`count`', '`count`', 2, -1, FALSE, '`count`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->count->Nullable = FALSE; // NOT NULL field
		$this->count->Required = TRUE; // Required field
		$this->count->Sortable = TRUE; // Allow sort
		$this->count->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['count'] = &$this->count;

		// count_received
		$this->count_received = new DbField('process_table_hs', 'process_table_hs', 'x_count_received', 'count_received', '`count_received`', '`count_received`', 200, -1, FALSE, '`count_received`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->count_received->Nullable = FALSE; // NOT NULL field
		$this->count_received->Required = TRUE; // Required field
		$this->count_received->Sortable = TRUE; // Allow sort
		$this->count_received->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['count_received'] = &$this->count_received;

		// twist
		$this->twist = new DbField('process_table_hs', 'process_table_hs', 'x_twist', 'twist', '`twist`', '`twist`', 18, -1, FALSE, '`twist`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->twist->Nullable = FALSE; // NOT NULL field
		$this->twist->Required = TRUE; // Required field
		$this->twist->Sortable = TRUE; // Allow sort
		$this->twist->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->twist->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->twist->Lookup = new Lookup('twist', 'process_table_hs', FALSE, '', ["","","",""], [], [], [], [], ["@","@"], ["x_std_rate","x__40"], '', '');
		$this->twist->OptionCount = 3;
		$this->twist->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['twist'] = &$this->twist;

		// quantity_avg_act
		$this->quantity_avg_act = new DbField('process_table_hs', 'process_table_hs', 'x_quantity_avg_act', 'quantity_avg_act', '`quantity_avg_act`', '`quantity_avg_act`', 131, -1, FALSE, '`quantity_avg_act`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity_avg_act->Nullable = FALSE; // NOT NULL field
		$this->quantity_avg_act->Required = TRUE; // Required field
		$this->quantity_avg_act->Sortable = TRUE; // Allow sort
		$this->quantity_avg_act->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity_avg_act'] = &$this->quantity_avg_act;

		// quantity
		$this->quantity = new DbField('process_table_hs', 'process_table_hs', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// status
		$this->status = new DbField('process_table_hs', 'process_table_hs', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->Lookup = new Lookup('status', 'process_table_hs', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// std_rate
		$this->std_rate = new DbField('process_table_hs', 'process_table_hs', 'x_std_rate', 'std_rate', '`std_rate`', '`std_rate`', 131, -1, FALSE, '`std_rate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->std_rate->Sortable = TRUE; // Allow sort
		$this->std_rate->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->std_rate->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->std_rate->Lookup = new Lookup('std_rate', 'payment_plan_hs', FALSE, '@', ["@","","",""], ["x_rid"], [], ["rid"], ["x_rid"], [], [], '`@` ASC', '');
		$this->std_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['std_rate'] = &$this->std_rate;

		// @
		$this->_40 = new DbField('process_table_hs', 'process_table_hs', 'x__40', '@', '`@`', '`@`', 131, -1, FALSE, '`@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40->Nullable = FALSE; // NOT NULL field
		$this->_40->Required = TRUE; // Required field
		$this->_40->Sortable = TRUE; // Allow sort
		$this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@'] = &$this->_40;

		// total_amount
		$this->total_amount = new DbField('process_table_hs', 'process_table_hs', 'x_total_amount', 'total_amount', '`total_amount`', '`total_amount`', 131, -1, FALSE, '`total_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->total_amount->Nullable = FALSE; // NOT NULL field
		$this->total_amount->Required = TRUE; // Required field
		$this->total_amount->Sortable = TRUE; // Allow sort
		$this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['total_amount'] = &$this->total_amount;

		// payment
		$this->payment = new DbField('process_table_hs', 'process_table_hs', 'x_payment', 'payment', '`payment`', '`payment`', 131, -1, FALSE, '`payment`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment->Nullable = FALSE; // NOT NULL field
		$this->payment->Required = TRUE; // Required field
		$this->payment->Sortable = FALSE; // Allow sort
		$this->payment->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['payment'] = &$this->payment;

		// remarks
		$this->remarks = new DbField('process_table_hs', 'process_table_hs', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// operator
		$this->operator = new DbField('process_table_hs', 'process_table_hs', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('process_table_hs', 'process_table_hs', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// product
		$this->product = new DbField('process_table_hs', 'process_table_hs', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = FALSE; // Allow sort
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// process
		$this->process = new DbField('process_table_hs', 'process_table_hs', 'x_process', 'process', '`process`', '`process`', 18, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Nullable = FALSE; // NOT NULL field
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = FALSE; // Allow sort
		$this->process->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process->Lookup = new Lookup('process', 'process', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// packets
		$this->packets = new DbField('process_table_hs', 'process_table_hs', 'x_packets', 'packets', '`packets`', '`packets`', 18, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Nullable = FALSE; // NOT NULL field
		$this->packets->Required = TRUE; // Required field
		$this->packets->Sortable = FALSE; // Allow sort
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packets'] = &$this->packets;

		// packing_type
		$this->packing_type = new DbField('process_table_hs', 'process_table_hs', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 17, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = FALSE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","code","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// product_code_new
		$this->product_code_new = new DbField('process_table_hs', 'process_table_hs', 'x_product_code_new', 'product_code_new', '`product_code_new`', '`product_code_new`', 18, -1, FALSE, '`product_code_new`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_code_new->Nullable = FALSE; // NOT NULL field
		$this->product_code_new->Required = TRUE; // Required field
		$this->product_code_new->Sortable = FALSE; // Allow sort
		$this->product_code_new->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_code_new->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_code_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_code_new'] = &$this->product_code_new;

		// product_new
		$this->product_new = new DbField('process_table_hs', 'process_table_hs', 'x_product_new', 'product_new', '`product_new`', '`product_new`', 18, -1, FALSE, '`product_new`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_new->Nullable = FALSE; // NOT NULL field
		$this->product_new->Required = TRUE; // Required field
		$this->product_new->Sortable = FALSE; // Allow sort
		$this->product_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_new'] = &$this->product_new;

		// dated
		$this->dated = new DbField('process_table_hs', 'process_table_hs', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 133, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Nullable = FALSE; // NOT NULL field
		$this->dated->Sortable = FALSE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// s_grp
		$this->s_grp = new DbField('process_table_hs', 'process_table_hs', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 2, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'process_table_hs', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->s_grp->OptionCount = 1;
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// lot_no
		$this->lot_no = new DbField('process_table_hs', 'process_table_hs', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 2, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Nullable = FALSE; // NOT NULL field
		$this->lot_no->Required = TRUE; // Required field
		$this->lot_no->Sortable = FALSE; // Allow sort
		$this->lot_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['lot_no'] = &$this->lot_no;

		// tmp_lot
		$this->tmp_lot = new DbField('process_table_hs', 'process_table_hs', 'x_tmp_lot', 'tmp_lot', '`tmp_lot`', '`tmp_lot`', 2, -1, FALSE, '`tmp_lot`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tmp_lot->Nullable = FALSE; // NOT NULL field
		$this->tmp_lot->Required = TRUE; // Required field
		$this->tmp_lot->Sortable = FALSE; // Allow sort
		$this->tmp_lot->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tmp_lot'] = &$this->tmp_lot;

		// shortage
		$this->shortage = new DbField('process_table_hs', 'process_table_hs', 'x_shortage', 'shortage', '`shortage`', '`shortage`', 131, -1, FALSE, '`shortage`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shortage->Sortable = FALSE; // Allow sort
		$this->shortage->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['shortage'] = &$this->shortage;

		// shortage_amount
		$this->shortage_amount = new DbField('process_table_hs', 'process_table_hs', 'x_shortage_amount', 'shortage_amount', '`shortage_amount`', '`shortage_amount`', 131, -1, FALSE, '`shortage_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shortage_amount->Sortable = FALSE; // Allow sort
		$this->shortage_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['shortage_amount'] = &$this->shortage_amount;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`process_table_hs`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT DISTINCT CONCAT(COALESCE(`emp_id`, ''),'" . ValueSeparator(1, $this->emp_name) . "',COALESCE(`emp_name`,'')) FROM `stock_material_out_emp_hs` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`emp_id` = `process_table_hs`.`emp_name` LIMIT 1) AS `EV__emp_name` FROM `process_table_hs`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->emp_name->AdvancedSearch->SearchValue <> "" ||
			$this->emp_name->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->emp_name->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->emp_name->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->grp->DbValue = $row['grp'];
		$this->godown->DbValue = $row['godown'];
		$this->emp_name->DbValue = $row['emp_name'];
		$this->ref->DbValue = $row['ref'];
		$this->rid->DbValue = $row['rid'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->count->DbValue = $row['count'];
		$this->count_received->DbValue = $row['count_received'];
		$this->twist->DbValue = $row['twist'];
		$this->quantity_avg_act->DbValue = $row['quantity_avg_act'];
		$this->quantity->DbValue = $row['quantity'];
		$this->status->DbValue = $row['status'];
		$this->std_rate->DbValue = $row['std_rate'];
		$this->_40->DbValue = $row['@'];
		$this->total_amount->DbValue = $row['total_amount'];
		$this->payment->DbValue = $row['payment'];
		$this->remarks->DbValue = $row['remarks'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->product->DbValue = $row['product'];
		$this->process->DbValue = $row['process'];
		$this->packets->DbValue = $row['packets'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->product_code_new->DbValue = $row['product_code_new'];
		$this->product_new->DbValue = $row['product_new'];
		$this->dated->DbValue = $row['dated'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->tmp_lot->DbValue = $row['tmp_lot'];
		$this->shortage->DbValue = $row['shortage'];
		$this->shortage_amount->DbValue = $row['shortage_amount'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "process_table_hslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "process_table_hsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "process_table_hsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "process_table_hsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "process_table_hslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("process_table_hsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("process_table_hsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "process_table_hsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "process_table_hsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("process_table_hsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("process_table_hsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("process_table_hsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->emp_name->setDbValue($rs->fields('emp_name'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->count->setDbValue($rs->fields('count'));
		$this->count_received->setDbValue($rs->fields('count_received'));
		$this->twist->setDbValue($rs->fields('twist'));
		$this->quantity_avg_act->setDbValue($rs->fields('quantity_avg_act'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->status->setDbValue($rs->fields('status'));
		$this->std_rate->setDbValue($rs->fields('std_rate'));
		$this->_40->setDbValue($rs->fields('@'));
		$this->total_amount->setDbValue($rs->fields('total_amount'));
		$this->payment->setDbValue($rs->fields('payment'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->product->setDbValue($rs->fields('product'));
		$this->process->setDbValue($rs->fields('process'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->product_code_new->setDbValue($rs->fields('product_code_new'));
		$this->product_new->setDbValue($rs->fields('product_new'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->tmp_lot->setDbValue($rs->fields('tmp_lot'));
		$this->shortage->setDbValue($rs->fields('shortage'));
		$this->shortage_amount->setDbValue($rs->fields('shortage_amount'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// grp
		// godown
		// emp_name
		// ref
		// rid
		// batch_no
		// count
		// count_received
		// twist
		// quantity_avg_act
		// quantity
		// status
		// std_rate
		// @
		// total_amount
		// payment
		// remarks
		// operator
		// datetime
		// product

		$this->product->CellCssStyle = "white-space: nowrap;";

		// process
		$this->process->CellCssStyle = "white-space: nowrap;";

		// packets
		$this->packets->CellCssStyle = "white-space: nowrap;";

		// packing_type
		$this->packing_type->CellCssStyle = "white-space: nowrap;";

		// product_code_new
		$this->product_code_new->CellCssStyle = "white-space: nowrap;";

		// product_new
		$this->product_new->CellCssStyle = "white-space: nowrap;";

		// dated
		$this->dated->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// lot_no
		$this->lot_no->CellCssStyle = "white-space: nowrap;";

		// tmp_lot
		$this->tmp_lot->CellCssStyle = "white-space: nowrap;";

		// shortage
		$this->shortage->CellCssStyle = "white-space: nowrap;";

		// shortage_amount
		$this->shortage_amount->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		if (strval($this->grp->CurrentValue) <> "") {
			$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// godown
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// emp_name
		if ($this->emp_name->VirtualValue <> "") {
			$this->emp_name->ViewValue = $this->emp_name->VirtualValue;
		} else {
			$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
		$curVal = strval($this->emp_name->CurrentValue);
		if ($curVal <> "") {
			$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
			if ($this->emp_name->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`emp_id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$lookupFilter = function() {
					return "`Balance` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->emp_name->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
				}
			}
		} else {
			$this->emp_name->ViewValue = NULL;
		}
		}
		$this->emp_name->ViewCustomAttributes = "";

		// ref
		$curVal = strval($this->ref->CurrentValue);
		if ($curVal <> "") {
			$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
			if ($this->ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`Balance`> 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
					$this->ref->ViewValue = $this->ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ref->ViewValue = $this->ref->CurrentValue;
				}
			}
		} else {
			$this->ref->ViewValue = NULL;
		}
		$this->ref->ViewCustomAttributes = "";

		// rid
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
		$this->batch_no->ViewCustomAttributes = "";

		// count
		$this->count->ViewValue = $this->count->CurrentValue;
		$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
		$this->count->ViewCustomAttributes = "";

		// count_received
		$this->count_received->ViewValue = $this->count_received->CurrentValue;
		$this->count_received->ViewCustomAttributes = "";

		// twist
		if (strval($this->twist->CurrentValue) <> "") {
			$this->twist->ViewValue = $this->twist->optionCaption($this->twist->CurrentValue);
		} else {
			$this->twist->ViewValue = NULL;
		}
		$this->twist->ViewCustomAttributes = "";

		// quantity_avg_act
		$this->quantity_avg_act->ViewValue = $this->quantity_avg_act->CurrentValue;
		$this->quantity_avg_act->ViewValue = FormatNumber($this->quantity_avg_act->ViewValue, 0, -2, -2, -2);
		$this->quantity_avg_act->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// std_rate
		$curVal = strval($this->std_rate->CurrentValue);
		if ($curVal <> "") {
			$this->std_rate->ViewValue = $this->std_rate->lookupCacheOption($curVal);
			if ($this->std_rate->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`@`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->std_rate->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->std_rate->ViewValue = $this->std_rate->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->std_rate->ViewValue = $this->std_rate->CurrentValue;
				}
			}
		} else {
			$this->std_rate->ViewValue = NULL;
		}
		$this->std_rate->ViewCustomAttributes = "";

		// @
		$this->_40->ViewValue = $this->_40->CurrentValue;
		$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
		$this->_40->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
		$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// payment
		$this->payment->ViewValue = $this->payment->CurrentValue;
		$this->payment->ViewValue = FormatNumber($this->payment->ViewValue, 2, -2, -2, -2);
		$this->payment->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
		$this->product->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` = 23";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
		$this->packets->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// product_code_new
		$this->product_code_new->ViewValue = FormatNumber($this->product_code_new->ViewValue, 0, -2, -2, -2);
		$this->product_code_new->ViewCustomAttributes = "";

		// product_new
		$this->product_new->ViewValue = $this->product_new->CurrentValue;
		$this->product_new->ViewValue = FormatNumber($this->product_new->ViewValue, 0, -2, -2, -2);
		$this->product_new->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// s_grp
		if (strval($this->s_grp->CurrentValue) <> "") {
			$this->s_grp->ViewValue = $this->s_grp->optionCaption($this->s_grp->CurrentValue);
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewValue = FormatNumber($this->lot_no->ViewValue, 0, -2, -2, -2);
		$this->lot_no->ViewCustomAttributes = "";

		// tmp_lot
		$this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->ViewValue = FormatNumber($this->tmp_lot->ViewValue, 2, -2, -2, -2);
		$this->tmp_lot->ViewCustomAttributes = "";

		// shortage
		$this->shortage->ViewValue = $this->shortage->CurrentValue;
		$this->shortage->ViewValue = FormatNumber($this->shortage->ViewValue, 2, -2, -2, -2);
		$this->shortage->ViewCustomAttributes = "";

		// shortage_amount
		$this->shortage_amount->ViewValue = $this->shortage_amount->CurrentValue;
		$this->shortage_amount->ViewValue = FormatNumber($this->shortage_amount->ViewValue, 2, -2, -2, -2);
		$this->shortage_amount->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "process_table_hslist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// emp_name
		$this->emp_name->LinkCustomAttributes = "";
		if (!EmptyValue($this->emp_name->CurrentValue)) {
			$this->emp_name->HrefValue = "process_table_hslist.php?x_emp_name=" . $this->emp_name->CurrentValue; // Add prefix/suffix
			$this->emp_name->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->emp_name->HrefValue = FullUrl($this->emp_name->HrefValue, "href");
		} else {
			$this->emp_name->HrefValue = "";
		}
		$this->emp_name->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "process_table_hslist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// count
		$this->count->LinkCustomAttributes = "";
		$this->count->HrefValue = "";
		$this->count->TooltipValue = "";

		// count_received
		$this->count_received->LinkCustomAttributes = "";
		$this->count_received->HrefValue = "";
		$this->count_received->TooltipValue = "";

		// twist
		$this->twist->LinkCustomAttributes = "";
		$this->twist->HrefValue = "";
		$this->twist->TooltipValue = "";

		// quantity_avg_act
		$this->quantity_avg_act->LinkCustomAttributes = "";
		$this->quantity_avg_act->HrefValue = "";
		$this->quantity_avg_act->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// std_rate
		$this->std_rate->LinkCustomAttributes = "";
		$this->std_rate->HrefValue = "";
		$this->std_rate->TooltipValue = "";

		// @
		$this->_40->LinkCustomAttributes = "";
		$this->_40->HrefValue = "";
		$this->_40->TooltipValue = "";

		// total_amount
		$this->total_amount->LinkCustomAttributes = "";
		$this->total_amount->HrefValue = "";
		$this->total_amount->TooltipValue = "";

		// payment
		$this->payment->LinkCustomAttributes = "";
		$this->payment->HrefValue = "";
		$this->payment->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "process_table_hslist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		if (!EmptyValue($this->process->CurrentValue)) {
			$this->process->HrefValue = "process_table_hslist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
			$this->process->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
		} else {
			$this->process->HrefValue = "";
		}
		$this->process->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->packing_type->CurrentValue)) {
			$this->packing_type->HrefValue = "process_table_hslist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
			$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
		} else {
			$this->packing_type->HrefValue = "";
		}
		$this->packing_type->TooltipValue = "";

		// product_code_new
		$this->product_code_new->LinkCustomAttributes = "";
		$this->product_code_new->HrefValue = "";
		$this->product_code_new->TooltipValue = "";

		// product_new
		$this->product_new->LinkCustomAttributes = "";
		$this->product_new->HrefValue = "";
		$this->product_new->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// tmp_lot
		$this->tmp_lot->LinkCustomAttributes = "";
		$this->tmp_lot->HrefValue = "";
		$this->tmp_lot->TooltipValue = "";

		// shortage
		$this->shortage->LinkCustomAttributes = "";
		$this->shortage->HrefValue = "";
		$this->shortage->TooltipValue = "";

		// shortage_amount
		$this->shortage_amount->LinkCustomAttributes = "";
		$this->shortage_amount->HrefValue = "";
		$this->shortage_amount->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->options(TRUE);

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";

		// emp_name
		$this->emp_name->EditAttrs["class"] = "form-control";
		$this->emp_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->emp_name->CurrentValue = HtmlDecode($this->emp_name->CurrentValue);
		$this->emp_name->EditValue = $this->emp_name->CurrentValue;
		$this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		$curVal = strval($this->ref->CurrentValue);
		if ($curVal <> "") {
			$this->ref->EditValue = $this->ref->lookupCacheOption($curVal);
			if ($this->ref->EditValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`Balance`> 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
					$this->ref->EditValue = $this->ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ref->EditValue = $this->ref->CurrentValue;
				}
			}
		} else {
			$this->ref->EditValue = NULL;
		}
		$this->ref->ViewCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->EditValue = FormatNumber($this->batch_no->EditValue, 0, -2, -2, -2);
		$this->batch_no->ViewCustomAttributes = "";

		// count
		$this->count->EditAttrs["class"] = "form-control";
		$this->count->EditCustomAttributes = "";
		$this->count->EditValue = $this->count->CurrentValue;
		$this->count->PlaceHolder = RemoveHtml($this->count->caption());

		// count_received
		$this->count_received->EditAttrs["class"] = "form-control";
		$this->count_received->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
		$this->count_received->EditValue = $this->count_received->CurrentValue;
		$this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

		// twist
		$this->twist->EditAttrs["class"] = "form-control";
		$this->twist->EditCustomAttributes = "";
		$this->twist->EditValue = $this->twist->options(TRUE);

		// quantity_avg_act
		$this->quantity_avg_act->EditAttrs["class"] = "form-control";
		$this->quantity_avg_act->EditCustomAttributes = "";
		$this->quantity_avg_act->EditValue = $this->quantity_avg_act->CurrentValue;
		$this->quantity_avg_act->PlaceHolder = RemoveHtml($this->quantity_avg_act->caption());
		if (strval($this->quantity_avg_act->EditValue) <> "" && is_numeric($this->quantity_avg_act->EditValue))
			$this->quantity_avg_act->EditValue = FormatNumber($this->quantity_avg_act->EditValue, -2, -2, -2, -2);

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// status
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(FALSE);

		// std_rate
		$this->std_rate->EditAttrs["class"] = "form-control";
		$this->std_rate->EditCustomAttributes = "";

		// @
		$this->_40->EditAttrs["class"] = "form-control";
		$this->_40->EditCustomAttributes = "";
		$this->_40->EditValue = $this->_40->CurrentValue;
		$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
		if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
			$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

		// total_amount
		$this->total_amount->EditAttrs["class"] = "form-control";
		$this->total_amount->EditCustomAttributes = "";
		$this->total_amount->EditValue = $this->total_amount->CurrentValue;
		$this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
		if (strval($this->total_amount->EditValue) <> "" && is_numeric($this->total_amount->EditValue))
			$this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, -2, -2, -2, -2);

		// payment
		$this->payment->EditAttrs["class"] = "form-control";
		$this->payment->EditCustomAttributes = "";
		$this->payment->EditValue = $this->payment->CurrentValue;
		$this->payment->EditValue = FormatNumber($this->payment->EditValue, 2, -2, -2, -2);
		$this->payment->ViewCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// operator
		// datetime
		// product

		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// product_code_new
		$this->product_code_new->EditAttrs["class"] = "form-control";
		$this->product_code_new->EditCustomAttributes = "";

		// product_new
		$this->product_new->EditAttrs["class"] = "form-control";
		$this->product_new->EditCustomAttributes = "";
		$this->product_new->EditValue = $this->product_new->CurrentValue;
		$this->product_new->PlaceHolder = RemoveHtml($this->product_new->caption());

		// dated
		// s_grp

		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->options(TRUE);

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// tmp_lot
		$this->tmp_lot->EditAttrs["class"] = "form-control";
		$this->tmp_lot->EditCustomAttributes = "";
		$this->tmp_lot->EditValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->PlaceHolder = RemoveHtml($this->tmp_lot->caption());

		// shortage
		$this->shortage->EditAttrs["class"] = "form-control";
		$this->shortage->EditCustomAttributes = "";
		$this->shortage->EditValue = $this->shortage->CurrentValue;
		$this->shortage->PlaceHolder = RemoveHtml($this->shortage->caption());
		if (strval($this->shortage->EditValue) <> "" && is_numeric($this->shortage->EditValue))
			$this->shortage->EditValue = FormatNumber($this->shortage->EditValue, -2, -2, -2, -2);

		// shortage_amount
		$this->shortage_amount->EditAttrs["class"] = "form-control";
		$this->shortage_amount->EditCustomAttributes = "";
		$this->shortage_amount->EditValue = $this->shortage_amount->CurrentValue;
		$this->shortage_amount->PlaceHolder = RemoveHtml($this->shortage_amount->caption());
		if (strval($this->shortage_amount->EditValue) <> "" && is_numeric($this->shortage_amount->EditValue))
			$this->shortage_amount->EditValue = FormatNumber($this->shortage_amount->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->emp_name);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->count_received);
					$doc->exportCaption($this->twist);
					$doc->exportCaption($this->quantity_avg_act);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->std_rate);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->emp_name);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->count_received);
					$doc->exportCaption($this->twist);
					$doc->exportCaption($this->quantity_avg_act);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->std_rate);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->payment);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->godown);
						$doc->exportField($this->emp_name);
						$doc->exportField($this->ref);
						$doc->exportField($this->rid);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->count);
						$doc->exportField($this->count_received);
						$doc->exportField($this->twist);
						$doc->exportField($this->quantity_avg_act);
						$doc->exportField($this->quantity);
						$doc->exportField($this->status);
						$doc->exportField($this->std_rate);
						$doc->exportField($this->_40);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->godown);
						$doc->exportField($this->emp_name);
						$doc->exportField($this->ref);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->count);
						$doc->exportField($this->count_received);
						$doc->exportField($this->twist);
						$doc->exportField($this->quantity_avg_act);
						$doc->exportField($this->quantity);
						$doc->exportField($this->status);
						$doc->exportField($this->std_rate);
						$doc->exportField($this->_40);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->payment);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>