<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_cart_b_edit extends product_cart_b
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_cart_b';

	// Page object name
	public $PageObjName = "product_cart_b_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_cart_b)
		if (!isset($GLOBALS["product_cart_b"]) || get_class($GLOBALS["product_cart_b"]) == PROJECT_NAMESPACE . "product_cart_b") {
			$GLOBALS["product_cart_b"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["product_cart_b"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (po_b)
		if (!isset($GLOBALS['po_b']))
			$GLOBALS['po_b'] = new po_b();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_b');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $product_cart_b;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_cart_b);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "product_cart_bview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $DisplayRecs = 1;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $RecCnt;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("product_cart_blist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->po_id->setVisibility();
		$this->location->setVisibility();
		$this->company_id->setVisibility();
		$this->partner_order_no->setVisibility();
		$this->partner_id->setVisibility();
		$this->partner_rid->setVisibility();
		$this->partner_code->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->packing_type->setVisibility();
		$this->batch_no->setVisibility();
		$this->shape->setVisibility();
		$this->product_type->setVisibility();
		$this->unit->setVisibility();
		$this->w->setVisibility();
		$this->w_cm->setVisibility();
		$this->l->setVisibility();
		$this->l_cm->setVisibility();
		$this->h->setVisibility();
		$this->h_cm->setVisibility();
		$this->partner_size->setVisibility();
		$this->size->Visible = FALSE;
		$this->sqm_u->Visible = FALSE;
		$this->sqm->setVisibility();
		$this->quantity->setVisibility();
		$this->price->setVisibility();
		$this->currency->setVisibility();
		$this->amount->setVisibility();
		$this->status->setVisibility();
		$this->cart_id->Visible = FALSE;
		$this->rid_1->Visible = FALSE;
		$this->hsn_code->Visible = FALSE;
		$this->despatch_date->Visible = FALSE;
		$this->pkt_quantity->Visible = FALSE;
		$this->multiprice_id->Visible = FALSE;
		$this->cbm->Visible = FALSE;
		$this->tax->Visible = FALSE;
		$this->tax_amount->Visible = FALSE;
		$this->shipping_method->Visible = FALSE;
		$this->shipping_local->Visible = FALSE;
		$this->shipping_abroad->Visible = FALSE;
		$this->shipping_charge->setVisibility();
		$this->additional_discount->setVisibility();
		$this->total_amount->Visible = FALSE;
		$this->buyer_uid->setVisibility();
		$this->buyer_loc->setVisibility();
		$this->discount_price->Visible = FALSE;
		$this->label->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->o_datetime->Visible = FALSE;
		$this->cart_amount->Visible = FALSE;
		$this->c_total->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->_1->Visible = FALSE;
		$this->_2->Visible = FALSE;
		$this->_3->Visible = FALSE;
		$this->_4->Visible = FALSE;
		$this->_5->Visible = FALSE;
		$this->_6->Visible = FALSE;
		$this->_7->Visible = FALSE;
		$this->_8->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->t_id->Visible = FALSE;
		$this->_9->Visible = FALSE;
		$this->_10->Visible = FALSE;
		$this->_11->Visible = FALSE;
		$this->_12->Visible = FALSE;
		$this->m_out_id->Visible = FALSE;
		$this->reports_to->Visible = FALSE;
		$this->q_sku->Visible = FALSE;
		$this->pam_qty->Visible = FALSE;
		$this->grp_type->Visible = FALSE;
		$this->jc_qty->Visible = FALSE;
		$this->d_remarks->setVisibility();
		$this->level->setVisibility();
		$this->dispatch_week->setVisibility();
		$this->sale_id->setVisibility();
		$this->sale_qty->setVisibility();
		$this->balance->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->po_id->Required = FALSE;
		$this->partner_id->Required = FALSE;
		$this->grp->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->po_id);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->partner_rid);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";

		// Load record by position
		$loadByPosition = FALSE;
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
			if (!$loadByQuery)
				$loadByPosition = TRUE;
		}

		// Set up master detail parameters
		$this->setupMasterParms();

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($rs = $this->loadRecordset()) // Load records
			$this->TotalRecs = $rs->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$this->terminate("product_cart_blist.php"); // Return to list page
		} elseif ($loadByPosition) { // Load record by position
			$this->setupStartRec(); // Set up start record position

			// Point to current record
			if ($this->StartRec <= $this->TotalRecs) {
				$rs->move($this->StartRec - 1);
				$loaded = TRUE;
			}
		} else { // Match key values
			if ($this->id->CurrentValue != NULL) {
				while (!$rs->EOF) {
					if (SameString($this->id->CurrentValue, $rs->fields('id'))) {
						$this->setStartRecordNumber($this->StartRec); // Save record position
						$loaded = TRUE;
						break;
					} else {
						$this->StartRec++;
						$rs->moveNext();
					}
				}
			}
		}

		// Load current row values
		if ($loaded)
			$this->loadRowValues($rs);

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
					$this->terminate("product_cart_blist.php"); // Return to list page
				} else {
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "product_cart_blist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'po_id' first before field var 'x_po_id'
		$val = $CurrentForm->hasValue("po_id") ? $CurrentForm->getValue("po_id") : $CurrentForm->getValue("x_po_id");
		if (!$this->po_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_id->Visible = FALSE; // Disable update for API request
			else
				$this->po_id->setFormValue($val);
		}

		// Check field name 'location' first before field var 'x_location'
		$val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
		if (!$this->location->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->location->Visible = FALSE; // Disable update for API request
			else
				$this->location->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'partner_order_no' first before field var 'x_partner_order_no'
		$val = $CurrentForm->hasValue("partner_order_no") ? $CurrentForm->getValue("partner_order_no") : $CurrentForm->getValue("x_partner_order_no");
		if (!$this->partner_order_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_order_no->Visible = FALSE; // Disable update for API request
			else
				$this->partner_order_no->setFormValue($val);
		}

		// Check field name 'partner_id' first before field var 'x_partner_id'
		$val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
		if (!$this->partner_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_id->Visible = FALSE; // Disable update for API request
			else
				$this->partner_id->setFormValue($val);
		}

		// Check field name 'partner_rid' first before field var 'x_partner_rid'
		$val = $CurrentForm->hasValue("partner_rid") ? $CurrentForm->getValue("partner_rid") : $CurrentForm->getValue("x_partner_rid");
		if (!$this->partner_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_rid->Visible = FALSE; // Disable update for API request
			else
				$this->partner_rid->setFormValue($val);
		}

		// Check field name 'partner_code' first before field var 'x_partner_code'
		$val = $CurrentForm->hasValue("partner_code") ? $CurrentForm->getValue("partner_code") : $CurrentForm->getValue("x_partner_code");
		if (!$this->partner_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_code->Visible = FALSE; // Disable update for API request
			else
				$this->partner_code->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'shape' first before field var 'x_shape'
		$val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
		if (!$this->shape->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shape->Visible = FALSE; // Disable update for API request
			else
				$this->shape->setFormValue($val);
		}

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'w' first before field var 'x_w'
		$val = $CurrentForm->hasValue("w") ? $CurrentForm->getValue("w") : $CurrentForm->getValue("x_w");
		if (!$this->w->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->w->Visible = FALSE; // Disable update for API request
			else
				$this->w->setFormValue($val);
		}

		// Check field name 'w_cm' first before field var 'x_w_cm'
		$val = $CurrentForm->hasValue("w_cm") ? $CurrentForm->getValue("w_cm") : $CurrentForm->getValue("x_w_cm");
		if (!$this->w_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->w_cm->Visible = FALSE; // Disable update for API request
			else
				$this->w_cm->setFormValue($val);
		}

		// Check field name 'l' first before field var 'x_l'
		$val = $CurrentForm->hasValue("l") ? $CurrentForm->getValue("l") : $CurrentForm->getValue("x_l");
		if (!$this->l->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->l->Visible = FALSE; // Disable update for API request
			else
				$this->l->setFormValue($val);
		}

		// Check field name 'l_cm' first before field var 'x_l_cm'
		$val = $CurrentForm->hasValue("l_cm") ? $CurrentForm->getValue("l_cm") : $CurrentForm->getValue("x_l_cm");
		if (!$this->l_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->l_cm->Visible = FALSE; // Disable update for API request
			else
				$this->l_cm->setFormValue($val);
		}

		// Check field name 'h' first before field var 'x_h'
		$val = $CurrentForm->hasValue("h") ? $CurrentForm->getValue("h") : $CurrentForm->getValue("x_h");
		if (!$this->h->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->h->Visible = FALSE; // Disable update for API request
			else
				$this->h->setFormValue($val);
		}

		// Check field name 'h_cm' first before field var 'x_h_cm'
		$val = $CurrentForm->hasValue("h_cm") ? $CurrentForm->getValue("h_cm") : $CurrentForm->getValue("x_h_cm");
		if (!$this->h_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->h_cm->Visible = FALSE; // Disable update for API request
			else
				$this->h_cm->setFormValue($val);
		}

		// Check field name 'partner_size' first before field var 'x_partner_size'
		$val = $CurrentForm->hasValue("partner_size") ? $CurrentForm->getValue("partner_size") : $CurrentForm->getValue("x_partner_size");
		if (!$this->partner_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_size->Visible = FALSE; // Disable update for API request
			else
				$this->partner_size->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'currency' first before field var 'x_currency'
		$val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
		if (!$this->currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency->Visible = FALSE; // Disable update for API request
			else
				$this->currency->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'shipping_charge' first before field var 'x_shipping_charge'
		$val = $CurrentForm->hasValue("shipping_charge") ? $CurrentForm->getValue("shipping_charge") : $CurrentForm->getValue("x_shipping_charge");
		if (!$this->shipping_charge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_charge->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_charge->setFormValue($val);
		}

		// Check field name 'additional_discount' first before field var 'x_additional_discount'
		$val = $CurrentForm->hasValue("additional_discount") ? $CurrentForm->getValue("additional_discount") : $CurrentForm->getValue("x_additional_discount");
		if (!$this->additional_discount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->additional_discount->Visible = FALSE; // Disable update for API request
			else
				$this->additional_discount->setFormValue($val);
		}

		// Check field name 'buyer_uid' first before field var 'x_buyer_uid'
		$val = $CurrentForm->hasValue("buyer_uid") ? $CurrentForm->getValue("buyer_uid") : $CurrentForm->getValue("x_buyer_uid");
		if (!$this->buyer_uid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_uid->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_uid->setFormValue($val);
		}

		// Check field name 'buyer_loc' first before field var 'x_buyer_loc'
		$val = $CurrentForm->hasValue("buyer_loc") ? $CurrentForm->getValue("buyer_loc") : $CurrentForm->getValue("x_buyer_loc");
		if (!$this->buyer_loc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_loc->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_loc->setFormValue($val);
		}

		// Check field name 'label' first before field var 'x_label'
		$val = $CurrentForm->hasValue("label") ? $CurrentForm->getValue("label") : $CurrentForm->getValue("x_label");
		if (!$this->label->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->label->Visible = FALSE; // Disable update for API request
			else
				$this->label->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		}

		// Check field name 'd_remarks' first before field var 'x_d_remarks'
		$val = $CurrentForm->hasValue("d_remarks") ? $CurrentForm->getValue("d_remarks") : $CurrentForm->getValue("x_d_remarks");
		if (!$this->d_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->d_remarks->setFormValue($val);
		}

		// Check field name 'level' first before field var 'x_level'
		$val = $CurrentForm->hasValue("level") ? $CurrentForm->getValue("level") : $CurrentForm->getValue("x_level");
		if (!$this->level->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->level->Visible = FALSE; // Disable update for API request
			else
				$this->level->setFormValue($val);
		}

		// Check field name 'dispatch_week' first before field var 'x_dispatch_week'
		$val = $CurrentForm->hasValue("dispatch_week") ? $CurrentForm->getValue("dispatch_week") : $CurrentForm->getValue("x_dispatch_week");
		if (!$this->dispatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dispatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->dispatch_week->setFormValue($val);
		}

		// Check field name 'sale_id' first before field var 'x_sale_id'
		$val = $CurrentForm->hasValue("sale_id") ? $CurrentForm->getValue("sale_id") : $CurrentForm->getValue("x_sale_id");
		if (!$this->sale_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sale_id->Visible = FALSE; // Disable update for API request
			else
				$this->sale_id->setFormValue($val);
		}

		// Check field name 'sale_qty' first before field var 'x_sale_qty'
		$val = $CurrentForm->hasValue("sale_qty") ? $CurrentForm->getValue("sale_qty") : $CurrentForm->getValue("x_sale_qty");
		if (!$this->sale_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sale_qty->Visible = FALSE; // Disable update for API request
			else
				$this->sale_qty->setFormValue($val);
		}

		// Check field name 'balance' first before field var 'x_balance'
		$val = $CurrentForm->hasValue("balance") ? $CurrentForm->getValue("balance") : $CurrentForm->getValue("x_balance");
		if (!$this->balance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->balance->Visible = FALSE; // Disable update for API request
			else
				$this->balance->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->po_id->CurrentValue = $this->po_id->FormValue;
		$this->location->CurrentValue = $this->location->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->partner_order_no->CurrentValue = $this->partner_order_no->FormValue;
		$this->partner_id->CurrentValue = $this->partner_id->FormValue;
		$this->partner_rid->CurrentValue = $this->partner_rid->FormValue;
		$this->partner_code->CurrentValue = $this->partner_code->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->shape->CurrentValue = $this->shape->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->w->CurrentValue = $this->w->FormValue;
		$this->w_cm->CurrentValue = $this->w_cm->FormValue;
		$this->l->CurrentValue = $this->l->FormValue;
		$this->l_cm->CurrentValue = $this->l_cm->FormValue;
		$this->h->CurrentValue = $this->h->FormValue;
		$this->h_cm->CurrentValue = $this->h_cm->FormValue;
		$this->partner_size->CurrentValue = $this->partner_size->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->currency->CurrentValue = $this->currency->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->shipping_charge->CurrentValue = $this->shipping_charge->FormValue;
		$this->additional_discount->CurrentValue = $this->additional_discount->FormValue;
		$this->buyer_uid->CurrentValue = $this->buyer_uid->FormValue;
		$this->buyer_loc->CurrentValue = $this->buyer_loc->FormValue;
		$this->label->CurrentValue = $this->label->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		$this->d_remarks->CurrentValue = $this->d_remarks->FormValue;
		$this->level->CurrentValue = $this->level->FormValue;
		$this->dispatch_week->CurrentValue = $this->dispatch_week->FormValue;
		$this->sale_id->CurrentValue = $this->sale_id->FormValue;
		$this->sale_qty->CurrentValue = $this->sale_qty->FormValue;
		$this->balance->CurrentValue = $this->balance->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->po_id->setDbValue($row['po_id']);
		$this->location->setDbValue($row['location']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_order_no->setDbValue($row['partner_order_no']);
		$this->partner_id->setDbValue($row['partner_id']);
		$this->partner_rid->setDbValue($row['partner_rid']);
		if (array_key_exists('EV__partner_rid', $rs->fields)) {
			$this->partner_rid->VirtualValue = $rs->fields('EV__partner_rid'); // Set up virtual field value
		} else {
			$this->partner_rid->VirtualValue = ""; // Clear value
		}
		$this->partner_code->setDbValue($row['partner_code']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->shape->setDbValue($row['shape']);
		$this->product_type->setDbValue($row['product_type']);
		$this->unit->setDbValue($row['unit']);
		$this->w->setDbValue($row['w']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l->setDbValue($row['l']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->h->setDbValue($row['h']);
		$this->h_cm->setDbValue($row['h_cm']);
		$this->partner_size->setDbValue($row['partner_size']);
		$this->size->setDbValue($row['size']);
		$this->sqm_u->setDbValue($row['sqm_u']);
		$this->sqm->setDbValue($row['sqm']);
		$this->quantity->setDbValue($row['quantity']);
		$this->price->setDbValue($row['price']);
		$this->currency->setDbValue($row['currency']);
		$this->amount->setDbValue($row['amount']);
		$this->status->setDbValue($row['status']);
		$this->cart_id->setDbValue($row['cart_id']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->hsn_code->setDbValue($row['hsn_code']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->pkt_quantity->setDbValue($row['pkt_quantity']);
		$this->multiprice_id->setDbValue($row['multiprice_id']);
		$this->cbm->setDbValue($row['cbm']);
		$this->tax->setDbValue($row['tax']);
		$this->tax_amount->setDbValue($row['tax_amount']);
		$this->shipping_method->setDbValue($row['shipping_method']);
		$this->shipping_local->setDbValue($row['shipping_local']);
		$this->shipping_abroad->setDbValue($row['shipping_abroad']);
		$this->shipping_charge->setDbValue($row['shipping_charge']);
		$this->additional_discount->setDbValue($row['additional_discount']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->buyer_loc->setDbValue($row['buyer_loc']);
		$this->discount_price->setDbValue($row['discount_price']);
		$this->label->setDbValue($row['label']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->o_datetime->setDbValue($row['o_datetime']);
		$this->cart_amount->setDbValue($row['cart_amount']);
		$this->c_total->setDbValue($row['c_total']);
		$this->image->setDbValue($row['image']);
		$this->_1->setDbValue($row['1']);
		$this->_2->setDbValue($row['2']);
		$this->_3->setDbValue($row['3']);
		$this->_4->setDbValue($row['4']);
		$this->_5->setDbValue($row['5']);
		$this->_6->setDbValue($row['6']);
		$this->_7->setDbValue($row['7']);
		$this->_8->setDbValue($row['8']);
		$this->r_text->setDbValue($row['r_text']);
		$this->t_id->setDbValue($row['t_id']);
		$this->_9->setDbValue($row['9']);
		$this->_10->setDbValue($row['10']);
		$this->_11->setDbValue($row['11']);
		$this->_12->setDbValue($row['12']);
		$this->m_out_id->setDbValue($row['m_out_id']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->pam_qty->setDbValue($row['pam_qty']);
		$this->grp_type->setDbValue($row['grp_type']);
		$this->jc_qty->setDbValue($row['jc_qty']);
		$this->d_remarks->setDbValue($row['d_remarks']);
		$this->level->setDbValue($row['level']);
		$this->dispatch_week->setDbValue($row['dispatch_week']);
		$this->sale_id->setDbValue($row['sale_id']);
		$this->sale_qty->setDbValue($row['sale_qty']);
		$this->balance->setDbValue($row['balance']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['po_id'] = NULL;
		$row['location'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_order_no'] = NULL;
		$row['partner_id'] = NULL;
		$row['partner_rid'] = NULL;
		$row['partner_code'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['packing_type'] = NULL;
		$row['batch_no'] = NULL;
		$row['shape'] = NULL;
		$row['product_type'] = NULL;
		$row['unit'] = NULL;
		$row['w'] = NULL;
		$row['w_cm'] = NULL;
		$row['l'] = NULL;
		$row['l_cm'] = NULL;
		$row['h'] = NULL;
		$row['h_cm'] = NULL;
		$row['partner_size'] = NULL;
		$row['size'] = NULL;
		$row['sqm_u'] = NULL;
		$row['sqm'] = NULL;
		$row['quantity'] = NULL;
		$row['price'] = NULL;
		$row['currency'] = NULL;
		$row['amount'] = NULL;
		$row['status'] = NULL;
		$row['cart_id'] = NULL;
		$row['rid_1'] = NULL;
		$row['hsn_code'] = NULL;
		$row['despatch_date'] = NULL;
		$row['pkt_quantity'] = NULL;
		$row['multiprice_id'] = NULL;
		$row['cbm'] = NULL;
		$row['tax'] = NULL;
		$row['tax_amount'] = NULL;
		$row['shipping_method'] = NULL;
		$row['shipping_local'] = NULL;
		$row['shipping_abroad'] = NULL;
		$row['shipping_charge'] = NULL;
		$row['additional_discount'] = NULL;
		$row['total_amount'] = NULL;
		$row['buyer_uid'] = NULL;
		$row['buyer_loc'] = NULL;
		$row['discount_price'] = NULL;
		$row['label'] = NULL;
		$row['remarks'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['o_datetime'] = NULL;
		$row['cart_amount'] = NULL;
		$row['c_total'] = NULL;
		$row['image'] = NULL;
		$row['1'] = NULL;
		$row['2'] = NULL;
		$row['3'] = NULL;
		$row['4'] = NULL;
		$row['5'] = NULL;
		$row['6'] = NULL;
		$row['7'] = NULL;
		$row['8'] = NULL;
		$row['r_text'] = NULL;
		$row['t_id'] = NULL;
		$row['9'] = NULL;
		$row['10'] = NULL;
		$row['11'] = NULL;
		$row['12'] = NULL;
		$row['m_out_id'] = NULL;
		$row['reports_to'] = NULL;
		$row['q_sku'] = NULL;
		$row['pam_qty'] = NULL;
		$row['grp_type'] = NULL;
		$row['jc_qty'] = NULL;
		$row['d_remarks'] = NULL;
		$row['level'] = NULL;
		$row['dispatch_week'] = NULL;
		$row['sale_id'] = NULL;
		$row['sale_qty'] = NULL;
		$row['balance'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->w_cm->FormValue == $this->w_cm->CurrentValue && is_numeric(ConvertToFloatString($this->w_cm->CurrentValue)))
			$this->w_cm->CurrentValue = ConvertToFloatString($this->w_cm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->l_cm->FormValue == $this->l_cm->CurrentValue && is_numeric(ConvertToFloatString($this->l_cm->CurrentValue)))
			$this->l_cm->CurrentValue = ConvertToFloatString($this->l_cm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->h_cm->FormValue == $this->h_cm->CurrentValue && is_numeric(ConvertToFloatString($this->h_cm->CurrentValue)))
			$this->h_cm->CurrentValue = ConvertToFloatString($this->h_cm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->shipping_charge->FormValue == $this->shipping_charge->CurrentValue && is_numeric(ConvertToFloatString($this->shipping_charge->CurrentValue)))
			$this->shipping_charge->CurrentValue = ConvertToFloatString($this->shipping_charge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->additional_discount->FormValue == $this->additional_discount->CurrentValue && is_numeric(ConvertToFloatString($this->additional_discount->CurrentValue)))
			$this->additional_discount->CurrentValue = ConvertToFloatString($this->additional_discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sale_qty->FormValue == $this->sale_qty->CurrentValue && is_numeric(ConvertToFloatString($this->sale_qty->CurrentValue)))
			$this->sale_qty->CurrentValue = ConvertToFloatString($this->sale_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->balance->FormValue == $this->balance->CurrentValue && is_numeric(ConvertToFloatString($this->balance->CurrentValue)))
			$this->balance->CurrentValue = ConvertToFloatString($this->balance->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// po_id
		// location
		// company_id
		// partner_order_no
		// partner_id
		// partner_rid
		// partner_code
		// grp
		// s_grp
		// product
		// rid
		// packing_type
		// batch_no
		// shape
		// product_type
		// unit
		// w
		// w_cm
		// l
		// l_cm
		// h
		// h_cm
		// partner_size
		// size
		// sqm_u
		// sqm
		// quantity
		// price
		// currency
		// amount
		// status
		// cart_id
		// rid_1
		// hsn_code
		// despatch_date
		// pkt_quantity
		// multiprice_id
		// cbm
		// tax
		// tax_amount
		// shipping_method
		// shipping_local
		// shipping_abroad
		// shipping_charge
		// additional_discount
		// total_amount
		// buyer_uid
		// buyer_loc
		// discount_price
		// label
		// remarks
		// operator
		// datetime
		// o_datetime
		// cart_amount
		// c_total
		// image
		// 1
		// 2
		// 3
		// 4
		// 5
		// 6
		// 7
		// 8
		// r_text
		// t_id
		// 9
		// 10
		// 11
		// 12
		// m_out_id
		// reports_to
		// q_sku
		// pam_qty
		// grp_type
		// jc_qty
		// d_remarks
		// level
		// dispatch_week
		// sale_id
		// sale_qty
		// balance

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po_id
			$curVal = strval($this->po_id->CurrentValue);
			if ($curVal <> "") {
				$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
				if ($this->po_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_id->ViewValue = $this->po_id->CurrentValue;
					}
				}
			} else {
				$this->po_id->ViewValue = NULL;
			}
			$this->po_id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
			 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
			 : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_order_no
			$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
			$this->partner_order_no->ViewCustomAttributes = "";

			// partner_id
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			$this->partner_id->ViewCustomAttributes = "";

			// partner_rid
			if ($this->partner_rid->VirtualValue <> "") {
				$this->partner_rid->ViewValue = $this->partner_rid->VirtualValue;
			} else {
				$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
			$curVal = strval($this->partner_rid->CurrentValue);
			if ($curVal <> "") {
				$this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
				if ($this->partner_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
					}
				}
			} else {
				$this->partner_rid->ViewValue = NULL;
			}
			}
			$this->partner_rid->ViewCustomAttributes = "";

			// partner_code
			$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
			$this->partner_code->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// w
			$this->w->ViewValue = $this->w->CurrentValue;
			$this->w->ViewCustomAttributes = "";

			// w_cm
			$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
			$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
			$this->w_cm->ViewCustomAttributes = "";

			// l
			$this->l->ViewValue = $this->l->CurrentValue;
			$this->l->ViewCustomAttributes = "";

			// l_cm
			$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
			$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
			$this->l_cm->ViewCustomAttributes = "";

			// h
			$this->h->ViewValue = $this->h->CurrentValue;
			$this->h->ViewCustomAttributes = "";

			// h_cm
			$this->h_cm->ViewValue = $this->h_cm->CurrentValue;
			$this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, 2, -2, -2, -2);
			$this->h_cm->ViewCustomAttributes = "";

			// partner_size
			$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
			$this->partner_size->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 4, -2, -2, 0);
			$this->sqm->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
			$this->quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, 0);
			$this->price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, 0);
			$this->amount->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// shipping_charge
			$this->shipping_charge->ViewValue = $this->shipping_charge->CurrentValue;
			$this->shipping_charge->ViewValue = FormatNumber($this->shipping_charge->ViewValue, 2, -2, -2, -2);
			$this->shipping_charge->ViewCustomAttributes = "";

			// additional_discount
			$this->additional_discount->ViewValue = $this->additional_discount->CurrentValue;
			$this->additional_discount->ViewValue = FormatNumber($this->additional_discount->ViewValue, 2, -2, -2, -2);
			$this->additional_discount->ViewCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
			$this->buyer_uid->ViewCustomAttributes = "";

			// buyer_loc
			$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
			$this->buyer_loc->ViewCustomAttributes = "";

			// label
			$this->label->ViewValue = $this->label->CurrentValue;
			$this->label->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// d_remarks
			$this->d_remarks->ViewValue = $this->d_remarks->CurrentValue;
			$this->d_remarks->ViewCustomAttributes = "";

			// level
			$this->level->ViewValue = $this->level->CurrentValue;
			$this->level->ViewValue = FormatNumber($this->level->ViewValue, 0, -2, -2, -2);
			$this->level->ViewCustomAttributes = "";

			// dispatch_week
			$this->dispatch_week->ViewValue = $this->dispatch_week->CurrentValue;
			$this->dispatch_week->ViewValue = FormatNumber($this->dispatch_week->ViewValue, 0, -2, -2, -2);
			$this->dispatch_week->ViewCustomAttributes = "";

			// sale_id
			$this->sale_id->ViewValue = $this->sale_id->CurrentValue;
			$this->sale_id->ViewCustomAttributes = "";

			// sale_qty
			$this->sale_qty->ViewValue = $this->sale_qty->CurrentValue;
			$this->sale_qty->ViewValue = FormatNumber($this->sale_qty->ViewValue, 2, -2, -2, -2);
			$this->sale_qty->ViewCustomAttributes = "";

			// balance
			$this->balance->ViewValue = $this->balance->CurrentValue;
			$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
			$this->balance->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->po_id->CurrentValue)) {
				$this->po_id->HrefValue = "product_cart_blist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
				$this->po_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
			} else {
				$this->po_id->HrefValue = "";
			}
			$this->po_id->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";
			$this->partner_order_no->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// partner_rid
			$this->partner_rid->LinkCustomAttributes = "";
			$this->partner_rid->HrefValue = "";
			$this->partner_rid->TooltipValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";
			$this->partner_code->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			if (!EmptyValue($this->unit->CurrentValue)) {
				$this->unit->HrefValue = "product_cart_blist.php?x_ref=" . $this->unit->CurrentValue; // Add prefix/suffix
				$this->unit->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
			} else {
				$this->unit->HrefValue = "";
			}
			$this->unit->TooltipValue = "";

			// w
			$this->w->LinkCustomAttributes = "";
			$this->w->HrefValue = "";
			$this->w->TooltipValue = "";

			// w_cm
			$this->w_cm->LinkCustomAttributes = "";
			$this->w_cm->HrefValue = "";
			$this->w_cm->TooltipValue = "";

			// l
			$this->l->LinkCustomAttributes = "";
			$this->l->HrefValue = "";
			$this->l->TooltipValue = "";

			// l_cm
			$this->l_cm->LinkCustomAttributes = "";
			$this->l_cm->HrefValue = "";
			$this->l_cm->TooltipValue = "";

			// h
			$this->h->LinkCustomAttributes = "";
			$this->h->HrefValue = "";
			$this->h->TooltipValue = "";

			// h_cm
			$this->h_cm->LinkCustomAttributes = "";
			$this->h_cm->HrefValue = "";
			$this->h_cm->TooltipValue = "";

			// partner_size
			$this->partner_size->LinkCustomAttributes = "";
			$this->partner_size->HrefValue = "";
			$this->partner_size->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// shipping_charge
			$this->shipping_charge->LinkCustomAttributes = "";
			$this->shipping_charge->HrefValue = "";
			$this->shipping_charge->TooltipValue = "";

			// additional_discount
			$this->additional_discount->LinkCustomAttributes = "";
			$this->additional_discount->HrefValue = "";
			$this->additional_discount->TooltipValue = "";

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";
			$this->buyer_uid->TooltipValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";
			$this->buyer_loc->TooltipValue = "";

			// label
			$this->label->LinkCustomAttributes = "";
			$this->label->HrefValue = "";
			$this->label->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// d_remarks
			$this->d_remarks->LinkCustomAttributes = "";
			$this->d_remarks->HrefValue = "";
			$this->d_remarks->TooltipValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";

			// dispatch_week
			$this->dispatch_week->LinkCustomAttributes = "";
			$this->dispatch_week->HrefValue = "";
			$this->dispatch_week->TooltipValue = "";

			// sale_id
			$this->sale_id->LinkCustomAttributes = "";
			$this->sale_id->HrefValue = "";
			$this->sale_id->TooltipValue = "";

			// sale_qty
			$this->sale_qty->LinkCustomAttributes = "";
			$this->sale_qty->HrefValue = "";
			$this->sale_qty->TooltipValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";
			$this->balance->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po_id
			$this->po_id->EditAttrs["class"] = "form-control";
			$this->po_id->EditCustomAttributes = "";
			$curVal = strval($this->po_id->CurrentValue);
			if ($curVal <> "") {
				$this->po_id->EditValue = $this->po_id->lookupCacheOption($curVal);
				if ($this->po_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po_id->EditValue = $this->po_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_id->EditValue = $this->po_id->CurrentValue;
					}
				}
			} else {
				$this->po_id->EditValue = NULL;
			}
			$this->po_id->ViewCustomAttributes = "";

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->CurrentValue));
			if ($curVal <> "")
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->location->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
			 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
			 : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// partner_order_no
			$this->partner_order_no->EditAttrs["class"] = "form-control";
			$this->partner_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->EditValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->EditValue = NULL;
			}
			$this->partner_id->ViewCustomAttributes = "";

			// partner_rid
			$this->partner_rid->EditAttrs["class"] = "form-control";
			$this->partner_rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_rid->CurrentValue = HtmlDecode($this->partner_rid->CurrentValue);
			$this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
			$curVal = strval($this->partner_rid->CurrentValue);
			if ($curVal <> "") {
				$this->partner_rid->EditValue = $this->partner_rid->lookupCacheOption($curVal);
				if ($this->partner_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->partner_rid->EditValue = $this->partner_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
					}
				}
			} else {
				$this->partner_rid->EditValue = NULL;
			}
			$this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

			// partner_code
			$this->partner_code->EditAttrs["class"] = "form-control";
			$this->partner_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
			$this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
			$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = $this->grp->CurrentValue;
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rid->CurrentValue = HtmlDecode($this->rid->CurrentValue);
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->CurrentValue));
			if ($curVal <> "")
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
				if ($this->batch_no->ViewValue == "")
					$this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
				} else {
					$this->batch_no->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->CurrentValue));
			if ($curVal <> "")
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->shape->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->CurrentValue));
			if ($curVal <> "")
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$this->unit->EditValue = $this->unit->options(TRUE);

			// w
			$this->w->EditAttrs["class"] = "form-control";
			$this->w->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
			$this->w->EditValue = HtmlEncode($this->w->CurrentValue);
			$this->w->PlaceHolder = RemoveHtml($this->w->caption());

			// w_cm
			$this->w_cm->EditAttrs["class"] = "form-control";
			$this->w_cm->EditCustomAttributes = 'tabindex="999"';
			$this->w_cm->EditValue = HtmlEncode($this->w_cm->CurrentValue);
			$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
			if (strval($this->w_cm->EditValue) <> "" && is_numeric($this->w_cm->EditValue))
				$this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, -2, -2, -2, -2);

			// l
			$this->l->EditAttrs["class"] = "form-control";
			$this->l->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
			$this->l->EditValue = HtmlEncode($this->l->CurrentValue);
			$this->l->PlaceHolder = RemoveHtml($this->l->caption());

			// l_cm
			$this->l_cm->EditAttrs["class"] = "form-control";
			$this->l_cm->EditCustomAttributes = 'tabindex="999"';
			$this->l_cm->EditValue = HtmlEncode($this->l_cm->CurrentValue);
			$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
			if (strval($this->l_cm->EditValue) <> "" && is_numeric($this->l_cm->EditValue))
				$this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, -2, -2, -2, -2);

			// h
			$this->h->EditAttrs["class"] = "form-control";
			$this->h->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
			$this->h->EditValue = HtmlEncode($this->h->CurrentValue);
			$this->h->PlaceHolder = RemoveHtml($this->h->caption());

			// h_cm
			$this->h_cm->EditAttrs["class"] = "form-control";
			$this->h_cm->EditCustomAttributes = 'tabindex="999"';
			$this->h_cm->EditValue = HtmlEncode($this->h_cm->CurrentValue);
			$this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
			if (strval($this->h_cm->EditValue) <> "" && is_numeric($this->h_cm->EditValue))
				$this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, -2, -2, -2, -2);

			// partner_size
			$this->partner_size->EditAttrs["class"] = "form-control";
			$this->partner_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
			$this->partner_size->EditValue = HtmlEncode($this->partner_size->CurrentValue);
			$this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = 'tabindex="999"';
			$this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
			if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
				$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, 0);

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, 0);

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, 0);

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->CurrentValue));
			if ($curVal <> "")
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
			if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
				$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, 0);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// shipping_charge
			$this->shipping_charge->EditAttrs["class"] = "form-control";
			$this->shipping_charge->EditCustomAttributes = "";
			$this->shipping_charge->EditValue = HtmlEncode($this->shipping_charge->CurrentValue);
			$this->shipping_charge->PlaceHolder = RemoveHtml($this->shipping_charge->caption());
			if (strval($this->shipping_charge->EditValue) <> "" && is_numeric($this->shipping_charge->EditValue))
				$this->shipping_charge->EditValue = FormatNumber($this->shipping_charge->EditValue, -2, -2, -2, -2);

			// additional_discount
			$this->additional_discount->EditAttrs["class"] = "form-control";
			$this->additional_discount->EditCustomAttributes = "";
			$this->additional_discount->EditValue = HtmlEncode($this->additional_discount->CurrentValue);
			$this->additional_discount->PlaceHolder = RemoveHtml($this->additional_discount->caption());
			if (strval($this->additional_discount->EditValue) <> "" && is_numeric($this->additional_discount->EditValue))
				$this->additional_discount->EditValue = FormatNumber($this->additional_discount->EditValue, -2, -2, -2, -2);

			// buyer_uid
			$this->buyer_uid->EditAttrs["class"] = "form-control";
			$this->buyer_uid->EditCustomAttributes = "";
			$this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->CurrentValue);
			$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

			// buyer_loc
			$this->buyer_loc->EditAttrs["class"] = "form-control";
			$this->buyer_loc->EditCustomAttributes = "";
			$this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->CurrentValue);
			$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

			// label
			$this->label->EditAttrs["class"] = "form-control";
			$this->label->EditCustomAttributes = "";
			$this->label->EditValue = HtmlEncode($this->label->CurrentValue);
			$this->label->PlaceHolder = RemoveHtml($this->label->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			// datetime
			// d_remarks

			$this->d_remarks->EditAttrs["class"] = "form-control";
			$this->d_remarks->EditCustomAttributes = "";
			$this->d_remarks->EditValue = HtmlEncode($this->d_remarks->CurrentValue);
			$this->d_remarks->PlaceHolder = RemoveHtml($this->d_remarks->caption());

			// level
			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = HtmlEncode($this->level->CurrentValue);
			$this->level->PlaceHolder = RemoveHtml($this->level->caption());

			// dispatch_week
			$this->dispatch_week->EditAttrs["class"] = "form-control";
			$this->dispatch_week->EditCustomAttributes = "";
			$this->dispatch_week->EditValue = HtmlEncode($this->dispatch_week->CurrentValue);
			$this->dispatch_week->PlaceHolder = RemoveHtml($this->dispatch_week->caption());

			// sale_id
			$this->sale_id->EditAttrs["class"] = "form-control";
			$this->sale_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sale_id->CurrentValue = HtmlDecode($this->sale_id->CurrentValue);
			$this->sale_id->EditValue = HtmlEncode($this->sale_id->CurrentValue);
			$this->sale_id->PlaceHolder = RemoveHtml($this->sale_id->caption());

			// sale_qty
			$this->sale_qty->EditAttrs["class"] = "form-control";
			$this->sale_qty->EditCustomAttributes = "";
			$this->sale_qty->EditValue = HtmlEncode($this->sale_qty->CurrentValue);
			$this->sale_qty->PlaceHolder = RemoveHtml($this->sale_qty->caption());
			if (strval($this->sale_qty->EditValue) <> "" && is_numeric($this->sale_qty->EditValue))
				$this->sale_qty->EditValue = FormatNumber($this->sale_qty->EditValue, -2, -2, -2, -2);

			// balance
			$this->balance->EditAttrs["class"] = "form-control";
			$this->balance->EditCustomAttributes = "";
			$this->balance->EditValue = HtmlEncode($this->balance->CurrentValue);
			$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
			if (strval($this->balance->EditValue) <> "" && is_numeric($this->balance->EditValue))
				$this->balance->EditValue = FormatNumber($this->balance->EditValue, -2, -2, -2, -2);

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->po_id->CurrentValue)) {
				$this->po_id->HrefValue = "product_cart_blist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
				$this->po_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
			} else {
				$this->po_id->HrefValue = "";
			}
			$this->po_id->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// partner_rid
			$this->partner_rid->LinkCustomAttributes = "";
			$this->partner_rid->HrefValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			if (!EmptyValue($this->unit->CurrentValue)) {
				$this->unit->HrefValue = "product_cart_blist.php?x_ref=" . $this->unit->CurrentValue; // Add prefix/suffix
				$this->unit->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
			} else {
				$this->unit->HrefValue = "";
			}

			// w
			$this->w->LinkCustomAttributes = "";
			$this->w->HrefValue = "";

			// w_cm
			$this->w_cm->LinkCustomAttributes = "";
			$this->w_cm->HrefValue = "";

			// l
			$this->l->LinkCustomAttributes = "";
			$this->l->HrefValue = "";

			// l_cm
			$this->l_cm->LinkCustomAttributes = "";
			$this->l_cm->HrefValue = "";

			// h
			$this->h->LinkCustomAttributes = "";
			$this->h->HrefValue = "";

			// h_cm
			$this->h_cm->LinkCustomAttributes = "";
			$this->h_cm->HrefValue = "";

			// partner_size
			$this->partner_size->LinkCustomAttributes = "";
			$this->partner_size->HrefValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// shipping_charge
			$this->shipping_charge->LinkCustomAttributes = "";
			$this->shipping_charge->HrefValue = "";

			// additional_discount
			$this->additional_discount->LinkCustomAttributes = "";
			$this->additional_discount->HrefValue = "";

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";

			// label
			$this->label->LinkCustomAttributes = "";
			$this->label->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// d_remarks
			$this->d_remarks->LinkCustomAttributes = "";
			$this->d_remarks->HrefValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";

			// dispatch_week
			$this->dispatch_week->LinkCustomAttributes = "";
			$this->dispatch_week->HrefValue = "";

			// sale_id
			$this->sale_id->LinkCustomAttributes = "";
			$this->sale_id->HrefValue = "";

			// sale_qty
			$this->sale_qty->LinkCustomAttributes = "";
			$this->sale_qty->HrefValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->po_id->Required) {
			if (!$this->po_id->IsDetailKey && $this->po_id->FormValue != NULL && $this->po_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_id->caption(), $this->po_id->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->partner_order_no->Required) {
			if (!$this->partner_order_no->IsDetailKey && $this->partner_order_no->FormValue != NULL && $this->partner_order_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_order_no->caption(), $this->partner_order_no->RequiredErrorMessage));
			}
		}
		if ($this->partner_id->Required) {
			if (!$this->partner_id->IsDetailKey && $this->partner_id->FormValue != NULL && $this->partner_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
			}
		}
		if ($this->partner_rid->Required) {
			if (!$this->partner_rid->IsDetailKey && $this->partner_rid->FormValue != NULL && $this->partner_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_rid->caption(), $this->partner_rid->RequiredErrorMessage));
			}
		}
		if ($this->partner_code->Required) {
			if (!$this->partner_code->IsDetailKey && $this->partner_code->FormValue != NULL && $this->partner_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if (!$this->shape->IsDetailKey && $this->shape->FormValue != NULL && $this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->w->Required) {
			if (!$this->w->IsDetailKey && $this->w->FormValue != NULL && $this->w->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w->caption(), $this->w->RequiredErrorMessage));
			}
		}
		if ($this->w_cm->Required) {
			if (!$this->w_cm->IsDetailKey && $this->w_cm->FormValue != NULL && $this->w_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->w_cm->FormValue)) {
			AddMessage($FormError, $this->w_cm->errorMessage());
		}
		if ($this->l->Required) {
			if (!$this->l->IsDetailKey && $this->l->FormValue != NULL && $this->l->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l->caption(), $this->l->RequiredErrorMessage));
			}
		}
		if ($this->l_cm->Required) {
			if (!$this->l_cm->IsDetailKey && $this->l_cm->FormValue != NULL && $this->l_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->l_cm->FormValue)) {
			AddMessage($FormError, $this->l_cm->errorMessage());
		}
		if ($this->h->Required) {
			if (!$this->h->IsDetailKey && $this->h->FormValue != NULL && $this->h->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h->caption(), $this->h->RequiredErrorMessage));
			}
		}
		if ($this->h_cm->Required) {
			if (!$this->h_cm->IsDetailKey && $this->h_cm->FormValue != NULL && $this->h_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h_cm->caption(), $this->h_cm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->h_cm->FormValue)) {
			AddMessage($FormError, $this->h_cm->errorMessage());
		}
		if ($this->partner_size->Required) {
			if (!$this->partner_size->IsDetailKey && $this->partner_size->FormValue != NULL && $this->partner_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_size->caption(), $this->partner_size->RequiredErrorMessage));
			}
		}
		if ($this->size->Required) {
			if (!$this->size->IsDetailKey && $this->size->FormValue != NULL && $this->size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
			}
		}
		if ($this->sqm_u->Required) {
			if (!$this->sqm_u->IsDetailKey && $this->sqm_u->FormValue != NULL && $this->sqm_u->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm_u->caption(), $this->sqm_u->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->sqm->FormValue)) {
			AddMessage($FormError, $this->sqm->errorMessage());
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price->FormValue)) {
			AddMessage($FormError, $this->price->errorMessage());
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount->FormValue)) {
			AddMessage($FormError, $this->amount->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->cart_id->Required) {
			if (!$this->cart_id->IsDetailKey && $this->cart_id->FormValue != NULL && $this->cart_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_id->caption(), $this->cart_id->RequiredErrorMessage));
			}
		}
		if ($this->rid_1->Required) {
			if (!$this->rid_1->IsDetailKey && $this->rid_1->FormValue != NULL && $this->rid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
			}
		}
		if ($this->hsn_code->Required) {
			if (!$this->hsn_code->IsDetailKey && $this->hsn_code->FormValue != NULL && $this->hsn_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hsn_code->caption(), $this->hsn_code->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if ($this->pkt_quantity->Required) {
			if (!$this->pkt_quantity->IsDetailKey && $this->pkt_quantity->FormValue != NULL && $this->pkt_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pkt_quantity->caption(), $this->pkt_quantity->RequiredErrorMessage));
			}
		}
		if ($this->multiprice_id->Required) {
			if (!$this->multiprice_id->IsDetailKey && $this->multiprice_id->FormValue != NULL && $this->multiprice_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->multiprice_id->caption(), $this->multiprice_id->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if ($this->tax->Required) {
			if (!$this->tax->IsDetailKey && $this->tax->FormValue != NULL && $this->tax->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax->caption(), $this->tax->RequiredErrorMessage));
			}
		}
		if ($this->tax_amount->Required) {
			if (!$this->tax_amount->IsDetailKey && $this->tax_amount->FormValue != NULL && $this->tax_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax_amount->caption(), $this->tax_amount->RequiredErrorMessage));
			}
		}
		if ($this->shipping_method->Required) {
			if (!$this->shipping_method->IsDetailKey && $this->shipping_method->FormValue != NULL && $this->shipping_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_method->caption(), $this->shipping_method->RequiredErrorMessage));
			}
		}
		if ($this->shipping_local->Required) {
			if (!$this->shipping_local->IsDetailKey && $this->shipping_local->FormValue != NULL && $this->shipping_local->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_local->caption(), $this->shipping_local->RequiredErrorMessage));
			}
		}
		if ($this->shipping_abroad->Required) {
			if (!$this->shipping_abroad->IsDetailKey && $this->shipping_abroad->FormValue != NULL && $this->shipping_abroad->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_abroad->caption(), $this->shipping_abroad->RequiredErrorMessage));
			}
		}
		if ($this->shipping_charge->Required) {
			if (!$this->shipping_charge->IsDetailKey && $this->shipping_charge->FormValue != NULL && $this->shipping_charge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_charge->caption(), $this->shipping_charge->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->shipping_charge->FormValue)) {
			AddMessage($FormError, $this->shipping_charge->errorMessage());
		}
		if ($this->additional_discount->Required) {
			if (!$this->additional_discount->IsDetailKey && $this->additional_discount->FormValue != NULL && $this->additional_discount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->additional_discount->caption(), $this->additional_discount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->additional_discount->FormValue)) {
			AddMessage($FormError, $this->additional_discount->errorMessage());
		}
		if ($this->total_amount->Required) {
			if (!$this->total_amount->IsDetailKey && $this->total_amount->FormValue != NULL && $this->total_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
			}
		}
		if ($this->buyer_uid->Required) {
			if (!$this->buyer_uid->IsDetailKey && $this->buyer_uid->FormValue != NULL && $this->buyer_uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_uid->caption(), $this->buyer_uid->RequiredErrorMessage));
			}
		}
		if ($this->buyer_loc->Required) {
			if (!$this->buyer_loc->IsDetailKey && $this->buyer_loc->FormValue != NULL && $this->buyer_loc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_loc->caption(), $this->buyer_loc->RequiredErrorMessage));
			}
		}
		if ($this->discount_price->Required) {
			if (!$this->discount_price->IsDetailKey && $this->discount_price->FormValue != NULL && $this->discount_price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->discount_price->caption(), $this->discount_price->RequiredErrorMessage));
			}
		}
		if ($this->label->Required) {
			if (!$this->label->IsDetailKey && $this->label->FormValue != NULL && $this->label->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->label->caption(), $this->label->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->o_datetime->Required) {
			if (!$this->o_datetime->IsDetailKey && $this->o_datetime->FormValue != NULL && $this->o_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->o_datetime->caption(), $this->o_datetime->RequiredErrorMessage));
			}
		}
		if ($this->cart_amount->Required) {
			if (!$this->cart_amount->IsDetailKey && $this->cart_amount->FormValue != NULL && $this->cart_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_amount->caption(), $this->cart_amount->RequiredErrorMessage));
			}
		}
		if ($this->c_total->Required) {
			if (!$this->c_total->IsDetailKey && $this->c_total->FormValue != NULL && $this->c_total->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_total->caption(), $this->c_total->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if (!$this->image->IsDetailKey && $this->image->FormValue != NULL && $this->image->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->_1->Required) {
			if (!$this->_1->IsDetailKey && $this->_1->FormValue != NULL && $this->_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
			}
		}
		if ($this->_2->Required) {
			if (!$this->_2->IsDetailKey && $this->_2->FormValue != NULL && $this->_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
			}
		}
		if ($this->_3->Required) {
			if (!$this->_3->IsDetailKey && $this->_3->FormValue != NULL && $this->_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
			}
		}
		if ($this->_4->Required) {
			if (!$this->_4->IsDetailKey && $this->_4->FormValue != NULL && $this->_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
			}
		}
		if ($this->_5->Required) {
			if (!$this->_5->IsDetailKey && $this->_5->FormValue != NULL && $this->_5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
			}
		}
		if ($this->_6->Required) {
			if (!$this->_6->IsDetailKey && $this->_6->FormValue != NULL && $this->_6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
			}
		}
		if ($this->_7->Required) {
			if (!$this->_7->IsDetailKey && $this->_7->FormValue != NULL && $this->_7->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
			}
		}
		if ($this->_8->Required) {
			if (!$this->_8->IsDetailKey && $this->_8->FormValue != NULL && $this->_8->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
			}
		}
		if ($this->r_text->Required) {
			if (!$this->r_text->IsDetailKey && $this->r_text->FormValue != NULL && $this->r_text->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_text->caption(), $this->r_text->RequiredErrorMessage));
			}
		}
		if ($this->t_id->Required) {
			if (!$this->t_id->IsDetailKey && $this->t_id->FormValue != NULL && $this->t_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_id->caption(), $this->t_id->RequiredErrorMessage));
			}
		}
		if ($this->_9->Required) {
			if (!$this->_9->IsDetailKey && $this->_9->FormValue != NULL && $this->_9->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_9->caption(), $this->_9->RequiredErrorMessage));
			}
		}
		if ($this->_10->Required) {
			if (!$this->_10->IsDetailKey && $this->_10->FormValue != NULL && $this->_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_10->caption(), $this->_10->RequiredErrorMessage));
			}
		}
		if ($this->_11->Required) {
			if (!$this->_11->IsDetailKey && $this->_11->FormValue != NULL && $this->_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_11->caption(), $this->_11->RequiredErrorMessage));
			}
		}
		if ($this->_12->Required) {
			if (!$this->_12->IsDetailKey && $this->_12->FormValue != NULL && $this->_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_12->caption(), $this->_12->RequiredErrorMessage));
			}
		}
		if ($this->m_out_id->Required) {
			if (!$this->m_out_id->IsDetailKey && $this->m_out_id->FormValue != NULL && $this->m_out_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_out_id->caption(), $this->m_out_id->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->q_sku->Required) {
			if (!$this->q_sku->IsDetailKey && $this->q_sku->FormValue != NULL && $this->q_sku->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
			}
		}
		if ($this->pam_qty->Required) {
			if (!$this->pam_qty->IsDetailKey && $this->pam_qty->FormValue != NULL && $this->pam_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pam_qty->caption(), $this->pam_qty->RequiredErrorMessage));
			}
		}
		if ($this->grp_type->Required) {
			if (!$this->grp_type->IsDetailKey && $this->grp_type->FormValue != NULL && $this->grp_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp_type->caption(), $this->grp_type->RequiredErrorMessage));
			}
		}
		if ($this->jc_qty->Required) {
			if (!$this->jc_qty->IsDetailKey && $this->jc_qty->FormValue != NULL && $this->jc_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_qty->caption(), $this->jc_qty->RequiredErrorMessage));
			}
		}
		if ($this->d_remarks->Required) {
			if (!$this->d_remarks->IsDetailKey && $this->d_remarks->FormValue != NULL && $this->d_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_remarks->caption(), $this->d_remarks->RequiredErrorMessage));
			}
		}
		if ($this->level->Required) {
			if (!$this->level->IsDetailKey && $this->level->FormValue != NULL && $this->level->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->level->caption(), $this->level->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->level->FormValue)) {
			AddMessage($FormError, $this->level->errorMessage());
		}
		if ($this->dispatch_week->Required) {
			if (!$this->dispatch_week->IsDetailKey && $this->dispatch_week->FormValue != NULL && $this->dispatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dispatch_week->caption(), $this->dispatch_week->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->dispatch_week->FormValue)) {
			AddMessage($FormError, $this->dispatch_week->errorMessage());
		}
		if ($this->sale_id->Required) {
			if (!$this->sale_id->IsDetailKey && $this->sale_id->FormValue != NULL && $this->sale_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sale_id->caption(), $this->sale_id->RequiredErrorMessage));
			}
		}
		if ($this->sale_qty->Required) {
			if (!$this->sale_qty->IsDetailKey && $this->sale_qty->FormValue != NULL && $this->sale_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sale_qty->caption(), $this->sale_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->sale_qty->FormValue)) {
			AddMessage($FormError, $this->sale_qty->errorMessage());
		}
		if ($this->balance->Required) {
			if (!$this->balance->IsDetailKey && $this->balance->FormValue != NULL && $this->balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance->caption(), $this->balance->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->balance->FormValue)) {
			AddMessage($FormError, $this->balance->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// location
			$this->location->setDbValueDef($rsnew, $this->location->CurrentValue, NULL, $this->location->ReadOnly);

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// partner_order_no
			$this->partner_order_no->setDbValueDef($rsnew, $this->partner_order_no->CurrentValue, NULL, $this->partner_order_no->ReadOnly);

			// partner_rid
			$this->partner_rid->setDbValueDef($rsnew, $this->partner_rid->CurrentValue, NULL, $this->partner_rid->ReadOnly);

			// partner_code
			$this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, NULL, $this->partner_code->ReadOnly);

			// s_grp
			$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, $this->s_grp->ReadOnly);

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, $this->product->ReadOnly);

			// rid
			$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, $this->rid->ReadOnly);

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, $this->packing_type->ReadOnly);

			// batch_no
			$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, NULL, $this->batch_no->ReadOnly);

			// shape
			$this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, NULL, $this->shape->ReadOnly);

			// product_type
			$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, 0, $this->product_type->ReadOnly);

			// unit
			$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, $this->unit->ReadOnly);

			// w
			$this->w->setDbValueDef($rsnew, $this->w->CurrentValue, NULL, $this->w->ReadOnly);

			// w_cm
			$this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, NULL, $this->w_cm->ReadOnly);

			// l
			$this->l->setDbValueDef($rsnew, $this->l->CurrentValue, NULL, $this->l->ReadOnly);

			// l_cm
			$this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, NULL, $this->l_cm->ReadOnly);

			// h
			$this->h->setDbValueDef($rsnew, $this->h->CurrentValue, NULL, $this->h->ReadOnly);

			// h_cm
			$this->h_cm->setDbValueDef($rsnew, $this->h_cm->CurrentValue, NULL, $this->h_cm->ReadOnly);

			// partner_size
			$this->partner_size->setDbValueDef($rsnew, $this->partner_size->CurrentValue, NULL, $this->partner_size->ReadOnly);

			// sqm
			$this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, NULL, $this->sqm->ReadOnly);

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, $this->quantity->ReadOnly);

			// price
			$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, 0, $this->price->ReadOnly);

			// currency
			$this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, 0, $this->currency->ReadOnly);

			// amount
			$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, NULL, $this->amount->ReadOnly);

			// shipping_charge
			$this->shipping_charge->setDbValueDef($rsnew, $this->shipping_charge->CurrentValue, NULL, $this->shipping_charge->ReadOnly);

			// additional_discount
			$this->additional_discount->setDbValueDef($rsnew, $this->additional_discount->CurrentValue, NULL, $this->additional_discount->ReadOnly);

			// buyer_uid
			$this->buyer_uid->setDbValueDef($rsnew, $this->buyer_uid->CurrentValue, NULL, $this->buyer_uid->ReadOnly);

			// buyer_loc
			$this->buyer_loc->setDbValueDef($rsnew, $this->buyer_loc->CurrentValue, NULL, $this->buyer_loc->ReadOnly);

			// label
			$this->label->setDbValueDef($rsnew, $this->label->CurrentValue, NULL, $this->label->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// d_remarks
			$this->d_remarks->setDbValueDef($rsnew, $this->d_remarks->CurrentValue, NULL, $this->d_remarks->ReadOnly);

			// level
			$this->level->setDbValueDef($rsnew, $this->level->CurrentValue, NULL, $this->level->ReadOnly);

			// dispatch_week
			$this->dispatch_week->setDbValueDef($rsnew, $this->dispatch_week->CurrentValue, NULL, $this->dispatch_week->ReadOnly);

			// sale_id
			$this->sale_id->setDbValueDef($rsnew, $this->sale_id->CurrentValue, "", $this->sale_id->ReadOnly);

			// sale_qty
			$this->sale_qty->setDbValueDef($rsnew, $this->sale_qty->CurrentValue, 0, $this->sale_qty->ReadOnly);

			// balance
			$this->balance->setDbValueDef($rsnew, $this->balance->CurrentValue, NULL, $this->balance->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "po_b") {
				$validMaster = TRUE;
				if (Get("fk_id") !== NULL) {
					$this->po_id->setQueryStringValue(Get("fk_id"));
					$this->po_id->setSessionValue($this->po_id->QueryStringValue);
					if (!is_numeric($this->po_id->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "po_b") {
				$validMaster = TRUE;
				if (Post("fk_id") !== NULL) {
					$this->po_id->setFormValue(Post("fk_id"));
					$this->po_id->setSessionValue($this->po_id->FormValue);
					if (!is_numeric($this->po_id->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);
			$this->setSessionWhere($this->getDetailFilter());

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "po_b") {
				if ($this->po_id->CurrentValue == "")
					$this->po_id->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("product_cart_blist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
 : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_rid":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_po_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_location":
							break;
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_partner_rid":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_batch_no":
							break;
						case "x_shape":
							break;
						case "x_product_type":
							break;
						case "x_currency":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'product_cart_b');
		$this->w_cm->ReadOnly = True;
		$this->l_cm->ReadOnly = True;
		$this->h_cm->ReadOnly = True;
		$this->sqm->ReadOnly = True;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>