<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_cart_b_grid extends product_cart_b
{

	// Page ID
	public $PageID = "grid";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_cart_b';

	// Page object name
	public $PageObjName = "product_cart_b_grid";

	// Grid form hidden field names
	public $FormName = "fproduct_cart_bgrid";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$this->FormActionName .= "_" . $this->FormName;
		$this->FormKeyName .= "_" . $this->FormName;
		$this->FormOldKeyName .= "_" . $this->FormName;
		$this->FormBlankRowName .= "_" . $this->FormName;
		$this->FormKeyCountName .= "_" . $this->FormName;
		$GLOBALS["Grid"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_cart_b)
		if (!isset($GLOBALS["product_cart_b"]) || get_class($GLOBALS["product_cart_b"]) == PROJECT_NAMESPACE . "product_cart_b") {
			$GLOBALS["product_cart_b"] = &$this;

			// $GLOBALS["MasterTable"] = &$GLOBALS["Table"];
			// if (!isset($GLOBALS["Table"]))
			// 	$GLOBALS["Table"] = &$GLOBALS["product_cart_b"];

		}
		$this->AddUrl = "product_cart_badd.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'grid');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_b');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Export
		global $EXPORT, $product_cart_b;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_cart_b);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}

//		$GLOBALS["Table"] = &$GLOBALS["MasterTable"];
		unset($GLOBALS["Grid"]);
		if ($url === "")
			return;
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $ShowOtherOptions = FALSE;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->id->setVisibility();
		$this->po_id->setVisibility();
		$this->location->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->partner_order_no->setVisibility();
		$this->partner_id->setVisibility();
		$this->partner_rid->setVisibility();
		$this->partner_code->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->packing_type->setVisibility();
		$this->batch_no->Visible = FALSE;
		$this->shape->Visible = FALSE;
		$this->product_type->setVisibility();
		$this->unit->Visible = FALSE;
		$this->w->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->h->Visible = FALSE;
		$this->h_cm->Visible = FALSE;
		$this->partner_size->Visible = FALSE;
		$this->size->setVisibility();
		$this->sqm_u->Visible = FALSE;
		$this->sqm->Visible = FALSE;
		$this->quantity->setVisibility();
		$this->price->setVisibility();
		$this->currency->Visible = FALSE;
		$this->amount->setVisibility();
		$this->status->setVisibility();
		$this->cart_id->Visible = FALSE;
		$this->rid_1->Visible = FALSE;
		$this->hsn_code->Visible = FALSE;
		$this->despatch_date->Visible = FALSE;
		$this->pkt_quantity->Visible = FALSE;
		$this->multiprice_id->Visible = FALSE;
		$this->cbm->Visible = FALSE;
		$this->tax->Visible = FALSE;
		$this->tax_amount->Visible = FALSE;
		$this->shipping_method->Visible = FALSE;
		$this->shipping_local->Visible = FALSE;
		$this->shipping_abroad->Visible = FALSE;
		$this->shipping_charge->Visible = FALSE;
		$this->additional_discount->setVisibility();
		$this->total_amount->Visible = FALSE;
		$this->buyer_uid->Visible = FALSE;
		$this->buyer_loc->setVisibility();
		$this->discount_price->Visible = FALSE;
		$this->label->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->o_datetime->Visible = FALSE;
		$this->cart_amount->Visible = FALSE;
		$this->c_total->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->_1->Visible = FALSE;
		$this->_2->Visible = FALSE;
		$this->_3->Visible = FALSE;
		$this->_4->Visible = FALSE;
		$this->_5->Visible = FALSE;
		$this->_6->Visible = FALSE;
		$this->_7->Visible = FALSE;
		$this->_8->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->t_id->Visible = FALSE;
		$this->_9->Visible = FALSE;
		$this->_10->Visible = FALSE;
		$this->_11->Visible = FALSE;
		$this->_12->Visible = FALSE;
		$this->m_out_id->Visible = FALSE;
		$this->reports_to->Visible = FALSE;
		$this->q_sku->Visible = FALSE;
		$this->pam_qty->Visible = FALSE;
		$this->grp_type->Visible = FALSE;
		$this->jc_qty->Visible = FALSE;
		$this->d_remarks->Visible = FALSE;
		$this->level->setVisibility();
		$this->dispatch_week->setVisibility();
		$this->sale_id->setVisibility();
		$this->sale_qty->setVisibility();
		$this->balance->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up master detail parameters
		$this->setupMasterParms();

		// Setup other options
		$this->setupOtherOptions();

		// Set up lookup cache
		$this->setupLookupOptions($this->po_id);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->partner_rid);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Show grid delete link for grid add / grid edit
			if ($this->AllowAddDeleteRow) {
				if ($this->isGridAdd() || $this->isGridEdit()) {
					$item = &$this->ListOptions->getItem("griddelete");
					if ($item)
						$item->Visible = TRUE;
				}
			}

			// Set up sorting order
			$this->setupSortOrder();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records

		// Restore master/detail filter
		$this->DbMasterFilter = $this->getMasterFilter(); // Restore master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Restore detail filter
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Load master record
		if ($this->CurrentMode <> "add" && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "po_b") {
			global $po_b;
			$rsmaster = $po_b->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("po_blist.php"); // Return to master page
			} else {
				$po_b->loadListRowValues($rsmaster);
				$po_b->RowType = ROWTYPE_MASTER; // Master row
				$po_b->renderListRow();
				$rsmaster->close();
			}
		}

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			if ($this->CurrentMode == "copy") {
				$selectLimit = $this->UseSelectLimit;
				if ($selectLimit) {
					$this->TotalRecs = $this->listRecordCount();
					$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);
				} else {
					if ($this->Recordset = $this->loadRecordset())
						$this->TotalRecs = $this->Recordset->RecordCount();
				}
				$this->StartRec = 1;
				$this->DisplayRecs = $this->TotalRecs;
			} else {
				$this->CurrentFilter = "0=1";
				$this->StartRec = 1;
				$this->DisplayRecs = $this->GridAddRowCount;
			}
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			$this->DisplayRecs = $this->TotalRecs; // Display all records
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->quantity->FormValue = ""; // Clear form value
		$this->price->FormValue = ""; // Clear form value
		$this->amount->FormValue = ""; // Clear form value
		$this->additional_discount->FormValue = ""; // Clear form value
		$this->sale_qty->FormValue = ""; // Clear form value
		$this->balance->FormValue = ""; // Clear form value
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Grid Add mode
	protected function gridAddMode()
	{
		$this->CurrentAction = "gridadd";
		$_SESSION[SESSION_INLINE_MODE] = "gridadd";
		$this->hideFieldsForAddEdit();
	}

	// Switch to Grid Edit mode
	protected function gridEditMode()
	{
		$this->CurrentAction = "gridedit";
		$_SESSION[SESSION_INLINE_MODE] = "gridedit";
		$this->hideFieldsForAddEdit();
	}

	// Perform update to grid
	public function gridUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$gridUpdate = TRUE;

		// Get old recordset
		$this->CurrentFilter = $this->buildKeyFilter();
		if ($this->CurrentFilter == "")
			$this->CurrentFilter = "0=1";
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sql)) {
			$rsold = $rs->getRows();
			$rs->close();
		}

		// Call Grid Updating event
		if (!$this->Grid_Updating($rsold)) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
			return FALSE;
		}
		if ($this->AuditTrailOnEdit)
			$this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
		$key = "";

		// Update row index and get row key
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Update all rows based on key
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
			$CurrentForm->Index = $rowindex;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));

			// Load all values and keys
			if ($rowaction <> "insertdelete") { // Skip insert then deleted rows
				$this->loadFormValues(); // Get form values
				if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
					$gridUpdate = $this->setupKeyValues($rowkey); // Set up key values
				} else {
					$gridUpdate = TRUE;
				}

				// Skip empty row
				if ($rowaction == "insert" && $this->emptyRow()) {

					// No action required
				// Validate form and insert/update/delete record

				} elseif ($gridUpdate) {
					if ($rowaction == "delete") {
						$this->CurrentFilter = $this->getRecordFilter();
						$gridUpdate = $this->deleteRows(); // Delete this row
					} else if (!$this->validateForm()) {
						$gridUpdate = FALSE; // Form error, reset action
						$this->setFailureMessage($FormError);
					} else {
						if ($rowaction == "insert") {
							$gridUpdate = $this->addRow(); // Insert this row
						} else {
							if ($rowkey <> "") {
								$this->SendEmail = FALSE; // Do not send email on update success
								$gridUpdate = $this->editRow(); // Update this row
							}
						} // End update
					}
				}
				if ($gridUpdate) {
					if ($key <> "")
						$key .= ", ";
					$key .= $rowkey;
				} else {
					break;
				}
			}
		}
		if ($gridUpdate) {

			// Get new recordset
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Updated event
			$this->Grid_Updated($rsold, $rsnew);
			if ($this->AuditTrailOnEdit)
				$this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			if ($this->AuditTrailOnEdit)
				$this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
		}
		return $gridUpdate;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Perform Grid Add
	public function gridInsert()
	{
		global $Language, $CurrentForm, $FormError;
		$rowindex = 1;
		$gridInsert = FALSE;
		$conn = &$this->getConnection();

		// Call Grid Inserting event
		if (!$this->Grid_Inserting()) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
			return FALSE;
		}

		// Init key filter
		$wrkfilter = "";
		$addcnt = 0;
		if ($this->AuditTrailOnAdd)
			$this->writeAuditTrailDummy($Language->phrase("BatchInsertBegin")); // Batch insert begin
		$key = "";

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Insert all rows
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "" && $rowaction <> "insert")
				continue; // Skip
			if ($rowaction == "insert") {
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
				$this->loadOldRecord(); // Load old record
			}
			$this->loadFormValues(); // Get form values
			if (!$this->emptyRow()) {
				$addcnt++;
				$this->SendEmail = FALSE; // Do not send email on insert success

				// Validate form
				if (!$this->validateForm()) {
					$gridInsert = FALSE; // Form error, reset action
					$this->setFailureMessage($FormError);
				} else {
					$gridInsert = $this->addRow($this->OldRecordset); // Insert this row
				}
				if ($gridInsert) {
					if ($key <> "")
						$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
					$key .= $this->id->CurrentValue;

					// Add filter for this record
					$filter = $this->getRecordFilter();
					if ($wrkfilter <> "")
						$wrkfilter .= " OR ";
					$wrkfilter .= $filter;
				} else {
					break;
				}
			}
		}
		if ($addcnt == 0) { // No record inserted
			$this->clearInlineMode(); // Clear grid add mode and return
			return TRUE;
		}
		if ($gridInsert) {

			// Get new recordset
			$this->CurrentFilter = $wrkfilter;
			$sql = $this->getCurrentSql();
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Inserted event
			$this->Grid_Inserted($rsnew);
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailDummy($Language->phrase("BatchInsertSuccess")); // Batch insert success
			$this->clearInlineMode(); // Clear grid add mode
		} else {
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailDummy($Language->phrase("BatchInsertRollback")); // Batch insert rollback
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
		}
		return $gridInsert;
	}

	// Check if empty row
	public function emptyRow()
	{
		global $CurrentForm;
		if ($CurrentForm->hasValue("x_po_id") && $CurrentForm->hasValue("o_po_id") && $this->po_id->CurrentValue <> $this->po_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_company_id") && $CurrentForm->hasValue("o_company_id") && $this->company_id->CurrentValue <> $this->company_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_partner_order_no") && $CurrentForm->hasValue("o_partner_order_no") && $this->partner_order_no->CurrentValue <> $this->partner_order_no->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_partner_id") && $CurrentForm->hasValue("o_partner_id") && $this->partner_id->CurrentValue <> $this->partner_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_partner_rid") && $CurrentForm->hasValue("o_partner_rid") && $this->partner_rid->CurrentValue <> $this->partner_rid->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_partner_code") && $CurrentForm->hasValue("o_partner_code") && $this->partner_code->CurrentValue <> $this->partner_code->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_grp") && $CurrentForm->hasValue("o_grp") && $this->grp->CurrentValue <> $this->grp->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_s_grp") && $CurrentForm->hasValue("o_s_grp") && $this->s_grp->CurrentValue <> $this->s_grp->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_product") && $CurrentForm->hasValue("o_product") && $this->product->CurrentValue <> $this->product->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_rid") && $CurrentForm->hasValue("o_rid") && $this->rid->CurrentValue <> $this->rid->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_packing_type") && $CurrentForm->hasValue("o_packing_type") && $this->packing_type->CurrentValue <> $this->packing_type->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_product_type") && $CurrentForm->hasValue("o_product_type") && $this->product_type->CurrentValue <> $this->product_type->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_size") && $CurrentForm->hasValue("o_size") && $this->size->CurrentValue <> $this->size->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_quantity") && $CurrentForm->hasValue("o_quantity") && $this->quantity->CurrentValue <> $this->quantity->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_price") && $CurrentForm->hasValue("o_price") && $this->price->CurrentValue <> $this->price->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_amount") && $CurrentForm->hasValue("o_amount") && $this->amount->CurrentValue <> $this->amount->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_status") && $CurrentForm->hasValue("o_status") && $this->status->CurrentValue <> $this->status->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_additional_discount") && $CurrentForm->hasValue("o_additional_discount") && $this->additional_discount->CurrentValue <> $this->additional_discount->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_buyer_loc") && $CurrentForm->hasValue("o_buyer_loc") && $this->buyer_loc->CurrentValue <> $this->buyer_loc->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_level") && $CurrentForm->hasValue("o_level") && $this->level->CurrentValue <> $this->level->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_dispatch_week") && $CurrentForm->hasValue("o_dispatch_week") && $this->dispatch_week->CurrentValue <> $this->dispatch_week->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_sale_id") && $CurrentForm->hasValue("o_sale_id") && $this->sale_id->CurrentValue <> $this->sale_id->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_sale_qty") && $CurrentForm->hasValue("o_sale_qty") && $this->sale_qty->CurrentValue <> $this->sale_qty->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_balance") && $CurrentForm->hasValue("o_balance") && $this->balance->CurrentValue <> $this->balance->OldValue)
			return FALSE;
		return TRUE;
	}

	// Validate grid form
	public function validateGridForm()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Validate all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else if (!$this->validateForm()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	// Get all form values of the grid
	public function getGridFormValues()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;
		$rows = array();

		// Loop through all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else {
					$rows[] = $this->getFieldValues("FormValue"); // Return row as array
				}
			}
		}
		return $rows; // Return as array of array
	}

	// Restore form values for current row
	public function restoreCurrentRowFormValues($idx)
	{
		global $CurrentForm;

		// Get row based on current index
		$CurrentForm->Index = $idx;
		$this->loadFormValues(); // Load form values
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset master/detail keys
			if ($this->Command == "resetall") {
				$this->setCurrentMasterTable(""); // Clear master table
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
				$this->po_id->setSessionValue("");
			}

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// "griddelete"
		if ($this->AllowAddDeleteRow) {
			$item = &$this->ListOptions->add("griddelete");
			$item->CssClass = "text-nowrap";
			$item->OnLeft = TRUE;
			$item->Visible = FALSE; // Default hidden
		}

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode <> "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($CurrentForm->hasValue($this->FormOldKeyName))
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
			if ($this->RowOldKey <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($this->RowOldKey) . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "delete"
		if ($this->AllowAddDeleteRow) {
			if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
				$options = &$this->ListOptions;
				$options->UseButtonGroup = TRUE; // Use button group for grid delete button
				$opt = &$options->Items["griddelete"];
				if (!$Security->canDelete() && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
					$opt->Body = "&nbsp;";
				} else {
					$opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
				}
			}
		}
		if ($this->CurrentMode == "view") { // View mode

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";
		} // End View mode
		if ($this->CurrentMode == "edit" && is_numeric($this->RowIndex)) {
			$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . $this->id->CurrentValue . "\">";
		}
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set record key
	public function setRecordKey(&$key, $rs)
	{
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs->fields('id');
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$option = &$this->OtherOptions["addedit"];
		$option->UseDropDownButton = FALSE;
		$option->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$option->UseButtonGroup = TRUE;

		//$option->ButtonClass = ""; // Class for button group
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Add
		if ($this->CurrentMode == "view") { // Check view mode
			$item = &$option->add("add");
			$addcaption = HtmlTitle($Language->phrase("AddLink"));
			$this->AddUrl = $this->getAddUrl();
			$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
			$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		}
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		if (($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") && !$this->isConfirm()) { // Check add/copy/edit mode
			if ($this->AllowAddDeleteRow) {
				$option = &$options["addedit"];
				$option->UseDropDownButton = FALSE;
				$item = &$option->add("addblankrow");
				$item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"javascript:void(0);\" onclick=\"ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
				$item->Visible = $Security->canAdd();
				$this->ShowOtherOptions = $item->Visible;
			}
		}
		if ($this->CurrentMode == "view") { // Check view mode
			$option = &$options["addedit"];
			$item = &$option->getItem("add");
			$this->ShowOtherOptions = $item && $item->Visible;
		}
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->po_id->CurrentValue = NULL;
		$this->po_id->OldValue = $this->po_id->CurrentValue;
		$this->location->CurrentValue = ((isset($_COOKIE["location"]))? $_COOKIE["location"]:((isset($_COOKIE["pcl"]))? $_COOKIE["pcl"]:User_Site()));
		$this->location->OldValue = $this->location->CurrentValue;
		$this->company_id->CurrentValue = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["company_id"]))? $_COOKIE["company_id"]:User_Company_ID()));
		$this->company_id->OldValue = $this->company_id->CurrentValue;
		$this->partner_order_no->CurrentValue = ((isset($_GET["POD"]))? $_GET["POD"]:((isset($_COOKIE["POD"]))? $_COOKIE["POD"]:''));
		$this->partner_order_no->OldValue = $this->partner_order_no->CurrentValue;
		$this->partner_id->CurrentValue = ((isset($_GET["PID"]))? $_GET["PID"]:((isset($_COOKIE["partner_id"]))? $_COOKIE["partner_id"]:''));
		$this->partner_id->OldValue = $this->partner_id->CurrentValue;
		$this->partner_rid->CurrentValue = NULL;
		$this->partner_rid->OldValue = $this->partner_rid->CurrentValue;
		$this->partner_code->CurrentValue = NULL;
		$this->partner_code->OldValue = $this->partner_code->CurrentValue;
		$this->grp->CurrentValue = ((isset($_GET["grp"]))? $_GET["grp"]:((isset($_COOKIE["grp"]))? $_COOKIE["grp"]:''));
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = ((isset($_GET["s_grp"]))? $_GET["s_grp"]:((isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:''));
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = ((isset($_GET["product"]))? $_GET["product"]:((isset($_COOKIE["product"]))? $_COOKIE["product"]:''));
		$this->product->OldValue = $this->product->CurrentValue;
		$this->rid->CurrentValue = ((isset($_GET["rid"]))? $_GET["rid"]:'');
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->packing_type->CurrentValue = ((isset($_GET["pt"]))? $_GET["pt"]:((isset($_COOKIE["pt"]))? $_COOKIE["pt"]:''));
		$this->packing_type->OldValue = $this->packing_type->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->shape->CurrentValue = 1;
		$this->shape->OldValue = $this->shape->CurrentValue;
		$this->product_type->CurrentValue = 0;
		$this->product_type->OldValue = $this->product_type->CurrentValue;
		$this->unit->CurrentValue = ((isset($_COOKIE["unit"]))? $_COOKIE["unit"]:'');
		$this->unit->OldValue = $this->unit->CurrentValue;
		$this->w->CurrentValue = 00;
		$this->w->OldValue = $this->w->CurrentValue;
		$this->w_cm->CurrentValue = NULL;
		$this->w_cm->OldValue = $this->w_cm->CurrentValue;
		$this->l->CurrentValue = 00;
		$this->l->OldValue = $this->l->CurrentValue;
		$this->l_cm->CurrentValue = NULL;
		$this->l_cm->OldValue = $this->l_cm->CurrentValue;
		$this->h->CurrentValue = 00;
		$this->h->OldValue = $this->h->CurrentValue;
		$this->h_cm->CurrentValue = NULL;
		$this->h_cm->OldValue = $this->h_cm->CurrentValue;
		$this->partner_size->CurrentValue = NULL;
		$this->partner_size->OldValue = $this->partner_size->CurrentValue;
		$this->size->CurrentValue = NULL;
		$this->size->OldValue = $this->size->CurrentValue;
		$this->sqm_u->CurrentValue = NULL;
		$this->sqm_u->OldValue = $this->sqm_u->CurrentValue;
		$this->sqm->CurrentValue = NULL;
		$this->sqm->OldValue = $this->sqm->CurrentValue;
		$this->quantity->CurrentValue = ((isset($_GET["qty"]))? $_GET["qty"]:'2');
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->price->CurrentValue = 0;
		$this->price->OldValue = $this->price->CurrentValue;
		$this->currency->CurrentValue = ((isset($_COOKIE["partner_cur"]))? $_COOKIE["partner_cur"]:'');
		$this->currency->OldValue = $this->currency->CurrentValue;
		$this->amount->CurrentValue = 0;
		$this->amount->OldValue = $this->amount->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->cart_id->CurrentValue = NULL;
		$this->cart_id->OldValue = $this->cart_id->CurrentValue;
		$this->rid_1->CurrentValue = NULL;
		$this->rid_1->OldValue = $this->rid_1->CurrentValue;
		$this->hsn_code->CurrentValue = NULL;
		$this->hsn_code->OldValue = $this->hsn_code->CurrentValue;
		$this->despatch_date->CurrentValue = NULL;
		$this->despatch_date->OldValue = $this->despatch_date->CurrentValue;
		$this->pkt_quantity->CurrentValue = NULL;
		$this->pkt_quantity->OldValue = $this->pkt_quantity->CurrentValue;
		$this->multiprice_id->CurrentValue = NULL;
		$this->multiprice_id->OldValue = $this->multiprice_id->CurrentValue;
		$this->cbm->CurrentValue = NULL;
		$this->cbm->OldValue = $this->cbm->CurrentValue;
		$this->tax->CurrentValue = NULL;
		$this->tax->OldValue = $this->tax->CurrentValue;
		$this->tax_amount->CurrentValue = NULL;
		$this->tax_amount->OldValue = $this->tax_amount->CurrentValue;
		$this->shipping_method->CurrentValue = NULL;
		$this->shipping_method->OldValue = $this->shipping_method->CurrentValue;
		$this->shipping_local->CurrentValue = NULL;
		$this->shipping_local->OldValue = $this->shipping_local->CurrentValue;
		$this->shipping_abroad->CurrentValue = NULL;
		$this->shipping_abroad->OldValue = $this->shipping_abroad->CurrentValue;
		$this->shipping_charge->CurrentValue = 0.00;
		$this->shipping_charge->OldValue = $this->shipping_charge->CurrentValue;
		$this->additional_discount->CurrentValue = NULL;
		$this->additional_discount->OldValue = $this->additional_discount->CurrentValue;
		$this->total_amount->CurrentValue = NULL;
		$this->total_amount->OldValue = $this->total_amount->CurrentValue;
		$this->buyer_uid->CurrentValue = ((isset($_COOKIE["buyer_uid"]))? $_COOKIE["buyer_uid"]:'');
		$this->buyer_uid->OldValue = $this->buyer_uid->CurrentValue;
		$this->buyer_loc->CurrentValue = NULL;
		$this->buyer_loc->OldValue = $this->buyer_loc->CurrentValue;
		$this->discount_price->CurrentValue = NULL;
		$this->discount_price->OldValue = $this->discount_price->CurrentValue;
		$this->label->CurrentValue = ((isset($_COOKIE["label"]))? $_COOKIE["label"]:'');
		$this->label->OldValue = $this->label->CurrentValue;
		$this->remarks->CurrentValue = ((isset($_COOKIE["remarks"]))? $_COOKIE["remarks"]:'');
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->o_datetime->CurrentValue = NULL;
		$this->o_datetime->OldValue = $this->o_datetime->CurrentValue;
		$this->cart_amount->CurrentValue = NULL;
		$this->cart_amount->OldValue = $this->cart_amount->CurrentValue;
		$this->c_total->CurrentValue = NULL;
		$this->c_total->OldValue = $this->c_total->CurrentValue;
		$this->image->CurrentValue = NULL;
		$this->image->OldValue = $this->image->CurrentValue;
		$this->_1->CurrentValue = NULL;
		$this->_1->OldValue = $this->_1->CurrentValue;
		$this->_2->CurrentValue = NULL;
		$this->_2->OldValue = $this->_2->CurrentValue;
		$this->_3->CurrentValue = NULL;
		$this->_3->OldValue = $this->_3->CurrentValue;
		$this->_4->CurrentValue = NULL;
		$this->_4->OldValue = $this->_4->CurrentValue;
		$this->_5->CurrentValue = NULL;
		$this->_5->OldValue = $this->_5->CurrentValue;
		$this->_6->CurrentValue = NULL;
		$this->_6->OldValue = $this->_6->CurrentValue;
		$this->_7->CurrentValue = NULL;
		$this->_7->OldValue = $this->_7->CurrentValue;
		$this->_8->CurrentValue = NULL;
		$this->_8->OldValue = $this->_8->CurrentValue;
		$this->r_text->CurrentValue = NULL;
		$this->r_text->OldValue = $this->r_text->CurrentValue;
		$this->t_id->CurrentValue = NULL;
		$this->t_id->OldValue = $this->t_id->CurrentValue;
		$this->_9->CurrentValue = NULL;
		$this->_9->OldValue = $this->_9->CurrentValue;
		$this->_10->CurrentValue = NULL;
		$this->_10->OldValue = $this->_10->CurrentValue;
		$this->_11->CurrentValue = NULL;
		$this->_11->OldValue = $this->_11->CurrentValue;
		$this->_12->CurrentValue = NULL;
		$this->_12->OldValue = $this->_12->CurrentValue;
		$this->m_out_id->CurrentValue = NULL;
		$this->m_out_id->OldValue = $this->m_out_id->CurrentValue;
		$this->reports_to->CurrentValue = NULL;
		$this->reports_to->OldValue = $this->reports_to->CurrentValue;
		$this->q_sku->CurrentValue = 0.00;
		$this->q_sku->OldValue = $this->q_sku->CurrentValue;
		$this->pam_qty->CurrentValue = 0.000;
		$this->pam_qty->OldValue = $this->pam_qty->CurrentValue;
		$this->grp_type->CurrentValue = NULL;
		$this->grp_type->OldValue = $this->grp_type->CurrentValue;
		$this->jc_qty->CurrentValue = 0.000;
		$this->jc_qty->OldValue = $this->jc_qty->CurrentValue;
		$this->d_remarks->CurrentValue = NULL;
		$this->d_remarks->OldValue = $this->d_remarks->CurrentValue;
		$this->level->CurrentValue = 0;
		$this->level->OldValue = $this->level->CurrentValue;
		$this->dispatch_week->CurrentValue = NULL;
		$this->dispatch_week->OldValue = $this->dispatch_week->CurrentValue;
		$this->sale_id->CurrentValue = NULL;
		$this->sale_id->OldValue = $this->sale_id->CurrentValue;
		$this->sale_qty->CurrentValue = NULL;
		$this->sale_qty->OldValue = $this->sale_qty->CurrentValue;
		$this->balance->CurrentValue = NULL;
		$this->balance->OldValue = $this->balance->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$CurrentForm->FormName = $this->FormName;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd())
			$this->id->setFormValue($val);

		// Check field name 'po_id' first before field var 'x_po_id'
		$val = $CurrentForm->hasValue("po_id") ? $CurrentForm->getValue("po_id") : $CurrentForm->getValue("x_po_id");
		if (!$this->po_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_id->Visible = FALSE; // Disable update for API request
			else
				$this->po_id->setFormValue($val);
		}
		$this->po_id->setOldValue($CurrentForm->getValue("o_po_id"));

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}
		$this->company_id->setOldValue($CurrentForm->getValue("o_company_id"));

		// Check field name 'partner_order_no' first before field var 'x_partner_order_no'
		$val = $CurrentForm->hasValue("partner_order_no") ? $CurrentForm->getValue("partner_order_no") : $CurrentForm->getValue("x_partner_order_no");
		if (!$this->partner_order_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_order_no->Visible = FALSE; // Disable update for API request
			else
				$this->partner_order_no->setFormValue($val);
		}
		$this->partner_order_no->setOldValue($CurrentForm->getValue("o_partner_order_no"));

		// Check field name 'partner_id' first before field var 'x_partner_id'
		$val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
		if (!$this->partner_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_id->Visible = FALSE; // Disable update for API request
			else
				$this->partner_id->setFormValue($val);
		}
		$this->partner_id->setOldValue($CurrentForm->getValue("o_partner_id"));

		// Check field name 'partner_rid' first before field var 'x_partner_rid'
		$val = $CurrentForm->hasValue("partner_rid") ? $CurrentForm->getValue("partner_rid") : $CurrentForm->getValue("x_partner_rid");
		if (!$this->partner_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_rid->Visible = FALSE; // Disable update for API request
			else
				$this->partner_rid->setFormValue($val);
		}
		$this->partner_rid->setOldValue($CurrentForm->getValue("o_partner_rid"));

		// Check field name 'partner_code' first before field var 'x_partner_code'
		$val = $CurrentForm->hasValue("partner_code") ? $CurrentForm->getValue("partner_code") : $CurrentForm->getValue("x_partner_code");
		if (!$this->partner_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_code->Visible = FALSE; // Disable update for API request
			else
				$this->partner_code->setFormValue($val);
		}
		$this->partner_code->setOldValue($CurrentForm->getValue("o_partner_code"));

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}
		$this->grp->setOldValue($CurrentForm->getValue("o_grp"));

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}
		$this->s_grp->setOldValue($CurrentForm->getValue("o_s_grp"));

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}
		$this->product->setOldValue($CurrentForm->getValue("o_product"));

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}
		$this->rid->setOldValue($CurrentForm->getValue("o_rid"));

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}
		$this->packing_type->setOldValue($CurrentForm->getValue("o_packing_type"));

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}
		$this->product_type->setOldValue($CurrentForm->getValue("o_product_type"));

		// Check field name 'size' first before field var 'x_size'
		$val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
		if (!$this->size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size->Visible = FALSE; // Disable update for API request
			else
				$this->size->setFormValue($val);
		}
		$this->size->setOldValue($CurrentForm->getValue("o_size"));

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}
		$this->quantity->setOldValue($CurrentForm->getValue("o_quantity"));

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}
		$this->price->setOldValue($CurrentForm->getValue("o_price"));

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}
		$this->amount->setOldValue($CurrentForm->getValue("o_amount"));

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}
		$this->status->setOldValue($CurrentForm->getValue("o_status"));

		// Check field name 'additional_discount' first before field var 'x_additional_discount'
		$val = $CurrentForm->hasValue("additional_discount") ? $CurrentForm->getValue("additional_discount") : $CurrentForm->getValue("x_additional_discount");
		if (!$this->additional_discount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->additional_discount->Visible = FALSE; // Disable update for API request
			else
				$this->additional_discount->setFormValue($val);
		}
		$this->additional_discount->setOldValue($CurrentForm->getValue("o_additional_discount"));

		// Check field name 'buyer_loc' first before field var 'x_buyer_loc'
		$val = $CurrentForm->hasValue("buyer_loc") ? $CurrentForm->getValue("buyer_loc") : $CurrentForm->getValue("x_buyer_loc");
		if (!$this->buyer_loc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_loc->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_loc->setFormValue($val);
		}
		$this->buyer_loc->setOldValue($CurrentForm->getValue("o_buyer_loc"));

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}
		$this->operator->setOldValue($CurrentForm->getValue("o_operator"));

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		}
		$this->datetime->setOldValue($CurrentForm->getValue("o_datetime"));

		// Check field name 'level' first before field var 'x_level'
		$val = $CurrentForm->hasValue("level") ? $CurrentForm->getValue("level") : $CurrentForm->getValue("x_level");
		if (!$this->level->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->level->Visible = FALSE; // Disable update for API request
			else
				$this->level->setFormValue($val);
		}
		$this->level->setOldValue($CurrentForm->getValue("o_level"));

		// Check field name 'dispatch_week' first before field var 'x_dispatch_week'
		$val = $CurrentForm->hasValue("dispatch_week") ? $CurrentForm->getValue("dispatch_week") : $CurrentForm->getValue("x_dispatch_week");
		if (!$this->dispatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dispatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->dispatch_week->setFormValue($val);
		}
		$this->dispatch_week->setOldValue($CurrentForm->getValue("o_dispatch_week"));

		// Check field name 'sale_id' first before field var 'x_sale_id'
		$val = $CurrentForm->hasValue("sale_id") ? $CurrentForm->getValue("sale_id") : $CurrentForm->getValue("x_sale_id");
		if (!$this->sale_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sale_id->Visible = FALSE; // Disable update for API request
			else
				$this->sale_id->setFormValue($val);
		}
		$this->sale_id->setOldValue($CurrentForm->getValue("o_sale_id"));

		// Check field name 'sale_qty' first before field var 'x_sale_qty'
		$val = $CurrentForm->hasValue("sale_qty") ? $CurrentForm->getValue("sale_qty") : $CurrentForm->getValue("x_sale_qty");
		if (!$this->sale_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sale_qty->Visible = FALSE; // Disable update for API request
			else
				$this->sale_qty->setFormValue($val);
		}
		$this->sale_qty->setOldValue($CurrentForm->getValue("o_sale_qty"));

		// Check field name 'balance' first before field var 'x_balance'
		$val = $CurrentForm->hasValue("balance") ? $CurrentForm->getValue("balance") : $CurrentForm->getValue("x_balance");
		if (!$this->balance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->balance->Visible = FALSE; // Disable update for API request
			else
				$this->balance->setFormValue($val);
		}
		$this->balance->setOldValue($CurrentForm->getValue("o_balance"));
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		if (!$this->isGridAdd() && !$this->isAdd())
			$this->id->CurrentValue = $this->id->FormValue;
		$this->po_id->CurrentValue = $this->po_id->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->partner_order_no->CurrentValue = $this->partner_order_no->FormValue;
		$this->partner_id->CurrentValue = $this->partner_id->FormValue;
		$this->partner_rid->CurrentValue = $this->partner_rid->FormValue;
		$this->partner_code->CurrentValue = $this->partner_code->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->size->CurrentValue = $this->size->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->additional_discount->CurrentValue = $this->additional_discount->FormValue;
		$this->buyer_loc->CurrentValue = $this->buyer_loc->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		$this->level->CurrentValue = $this->level->FormValue;
		$this->dispatch_week->CurrentValue = $this->dispatch_week->FormValue;
		$this->sale_id->CurrentValue = $this->sale_id->FormValue;
		$this->sale_qty->CurrentValue = $this->sale_qty->FormValue;
		$this->balance->CurrentValue = $this->balance->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->po_id->setDbValue($row['po_id']);
		$this->location->setDbValue($row['location']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_order_no->setDbValue($row['partner_order_no']);
		$this->partner_id->setDbValue($row['partner_id']);
		$this->partner_rid->setDbValue($row['partner_rid']);
		if (array_key_exists('EV__partner_rid', $rs->fields)) {
			$this->partner_rid->VirtualValue = $rs->fields('EV__partner_rid'); // Set up virtual field value
		} else {
			$this->partner_rid->VirtualValue = ""; // Clear value
		}
		$this->partner_code->setDbValue($row['partner_code']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->shape->setDbValue($row['shape']);
		$this->product_type->setDbValue($row['product_type']);
		$this->unit->setDbValue($row['unit']);
		$this->w->setDbValue($row['w']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l->setDbValue($row['l']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->h->setDbValue($row['h']);
		$this->h_cm->setDbValue($row['h_cm']);
		$this->partner_size->setDbValue($row['partner_size']);
		$this->size->setDbValue($row['size']);
		$this->sqm_u->setDbValue($row['sqm_u']);
		$this->sqm->setDbValue($row['sqm']);
		$this->quantity->setDbValue($row['quantity']);
		$this->price->setDbValue($row['price']);
		$this->currency->setDbValue($row['currency']);
		$this->amount->setDbValue($row['amount']);
		$this->status->setDbValue($row['status']);
		$this->cart_id->setDbValue($row['cart_id']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->hsn_code->setDbValue($row['hsn_code']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->pkt_quantity->setDbValue($row['pkt_quantity']);
		$this->multiprice_id->setDbValue($row['multiprice_id']);
		$this->cbm->setDbValue($row['cbm']);
		$this->tax->setDbValue($row['tax']);
		$this->tax_amount->setDbValue($row['tax_amount']);
		$this->shipping_method->setDbValue($row['shipping_method']);
		$this->shipping_local->setDbValue($row['shipping_local']);
		$this->shipping_abroad->setDbValue($row['shipping_abroad']);
		$this->shipping_charge->setDbValue($row['shipping_charge']);
		$this->additional_discount->setDbValue($row['additional_discount']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->buyer_loc->setDbValue($row['buyer_loc']);
		$this->discount_price->setDbValue($row['discount_price']);
		$this->label->setDbValue($row['label']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->o_datetime->setDbValue($row['o_datetime']);
		$this->cart_amount->setDbValue($row['cart_amount']);
		$this->c_total->setDbValue($row['c_total']);
		$this->image->setDbValue($row['image']);
		$this->_1->setDbValue($row['1']);
		$this->_2->setDbValue($row['2']);
		$this->_3->setDbValue($row['3']);
		$this->_4->setDbValue($row['4']);
		$this->_5->setDbValue($row['5']);
		$this->_6->setDbValue($row['6']);
		$this->_7->setDbValue($row['7']);
		$this->_8->setDbValue($row['8']);
		$this->r_text->setDbValue($row['r_text']);
		$this->t_id->setDbValue($row['t_id']);
		$this->_9->setDbValue($row['9']);
		$this->_10->setDbValue($row['10']);
		$this->_11->setDbValue($row['11']);
		$this->_12->setDbValue($row['12']);
		$this->m_out_id->setDbValue($row['m_out_id']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->pam_qty->setDbValue($row['pam_qty']);
		$this->grp_type->setDbValue($row['grp_type']);
		$this->jc_qty->setDbValue($row['jc_qty']);
		$this->d_remarks->setDbValue($row['d_remarks']);
		$this->level->setDbValue($row['level']);
		$this->dispatch_week->setDbValue($row['dispatch_week']);
		$this->sale_id->setDbValue($row['sale_id']);
		$this->sale_qty->setDbValue($row['sale_qty']);
		$this->balance->setDbValue($row['balance']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['po_id'] = $this->po_id->CurrentValue;
		$row['location'] = $this->location->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['partner_order_no'] = $this->partner_order_no->CurrentValue;
		$row['partner_id'] = $this->partner_id->CurrentValue;
		$row['partner_rid'] = $this->partner_rid->CurrentValue;
		$row['partner_code'] = $this->partner_code->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['packing_type'] = $this->packing_type->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['shape'] = $this->shape->CurrentValue;
		$row['product_type'] = $this->product_type->CurrentValue;
		$row['unit'] = $this->unit->CurrentValue;
		$row['w'] = $this->w->CurrentValue;
		$row['w_cm'] = $this->w_cm->CurrentValue;
		$row['l'] = $this->l->CurrentValue;
		$row['l_cm'] = $this->l_cm->CurrentValue;
		$row['h'] = $this->h->CurrentValue;
		$row['h_cm'] = $this->h_cm->CurrentValue;
		$row['partner_size'] = $this->partner_size->CurrentValue;
		$row['size'] = $this->size->CurrentValue;
		$row['sqm_u'] = $this->sqm_u->CurrentValue;
		$row['sqm'] = $this->sqm->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['price'] = $this->price->CurrentValue;
		$row['currency'] = $this->currency->CurrentValue;
		$row['amount'] = $this->amount->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['cart_id'] = $this->cart_id->CurrentValue;
		$row['rid_1'] = $this->rid_1->CurrentValue;
		$row['hsn_code'] = $this->hsn_code->CurrentValue;
		$row['despatch_date'] = $this->despatch_date->CurrentValue;
		$row['pkt_quantity'] = $this->pkt_quantity->CurrentValue;
		$row['multiprice_id'] = $this->multiprice_id->CurrentValue;
		$row['cbm'] = $this->cbm->CurrentValue;
		$row['tax'] = $this->tax->CurrentValue;
		$row['tax_amount'] = $this->tax_amount->CurrentValue;
		$row['shipping_method'] = $this->shipping_method->CurrentValue;
		$row['shipping_local'] = $this->shipping_local->CurrentValue;
		$row['shipping_abroad'] = $this->shipping_abroad->CurrentValue;
		$row['shipping_charge'] = $this->shipping_charge->CurrentValue;
		$row['additional_discount'] = $this->additional_discount->CurrentValue;
		$row['total_amount'] = $this->total_amount->CurrentValue;
		$row['buyer_uid'] = $this->buyer_uid->CurrentValue;
		$row['buyer_loc'] = $this->buyer_loc->CurrentValue;
		$row['discount_price'] = $this->discount_price->CurrentValue;
		$row['label'] = $this->label->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['o_datetime'] = $this->o_datetime->CurrentValue;
		$row['cart_amount'] = $this->cart_amount->CurrentValue;
		$row['c_total'] = $this->c_total->CurrentValue;
		$row['image'] = $this->image->CurrentValue;
		$row['1'] = $this->_1->CurrentValue;
		$row['2'] = $this->_2->CurrentValue;
		$row['3'] = $this->_3->CurrentValue;
		$row['4'] = $this->_4->CurrentValue;
		$row['5'] = $this->_5->CurrentValue;
		$row['6'] = $this->_6->CurrentValue;
		$row['7'] = $this->_7->CurrentValue;
		$row['8'] = $this->_8->CurrentValue;
		$row['r_text'] = $this->r_text->CurrentValue;
		$row['t_id'] = $this->t_id->CurrentValue;
		$row['9'] = $this->_9->CurrentValue;
		$row['10'] = $this->_10->CurrentValue;
		$row['11'] = $this->_11->CurrentValue;
		$row['12'] = $this->_12->CurrentValue;
		$row['m_out_id'] = $this->m_out_id->CurrentValue;
		$row['reports_to'] = $this->reports_to->CurrentValue;
		$row['q_sku'] = $this->q_sku->CurrentValue;
		$row['pam_qty'] = $this->pam_qty->CurrentValue;
		$row['grp_type'] = $this->grp_type->CurrentValue;
		$row['jc_qty'] = $this->jc_qty->CurrentValue;
		$row['d_remarks'] = $this->d_remarks->CurrentValue;
		$row['level'] = $this->level->CurrentValue;
		$row['dispatch_week'] = $this->dispatch_week->CurrentValue;
		$row['sale_id'] = $this->sale_id->CurrentValue;
		$row['sale_qty'] = $this->sale_qty->CurrentValue;
		$row['balance'] = $this->balance->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		$arKeys[] = $this->RowOldKey;
		$cnt = count($arKeys);
		if ($cnt >= 1) {
			if (strval($arKeys[0]) <> "")
				$this->id->CurrentValue = strval($arKeys[0]); // id
			else
				$validKey = FALSE;
		} else {
			$validKey = FALSE;
		}

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->additional_discount->FormValue == $this->additional_discount->CurrentValue && is_numeric(ConvertToFloatString($this->additional_discount->CurrentValue)))
			$this->additional_discount->CurrentValue = ConvertToFloatString($this->additional_discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sale_qty->FormValue == $this->sale_qty->CurrentValue && is_numeric(ConvertToFloatString($this->sale_qty->CurrentValue)))
			$this->sale_qty->CurrentValue = ConvertToFloatString($this->sale_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->balance->FormValue == $this->balance->CurrentValue && is_numeric(ConvertToFloatString($this->balance->CurrentValue)))
			$this->balance->CurrentValue = ConvertToFloatString($this->balance->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// po_id
		// location
		// company_id
		// partner_order_no
		// partner_id
		// partner_rid
		// partner_code
		// grp
		// s_grp
		// product
		// rid
		// packing_type
		// batch_no
		// shape
		// product_type
		// unit
		// w
		// w_cm
		// l
		// l_cm
		// h
		// h_cm
		// partner_size
		// size
		// sqm_u

		$this->sqm_u->CellCssStyle = "white-space: nowrap;";

		// sqm
		// quantity
		// price
		// currency
		// amount

		$this->amount->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// cart_id
		$this->cart_id->CellCssStyle = "white-space: nowrap;";

		// rid_1
		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// hsn_code
		$this->hsn_code->CellCssStyle = "white-space: nowrap;";

		// despatch_date
		$this->despatch_date->CellCssStyle = "white-space: nowrap;";

		// pkt_quantity
		$this->pkt_quantity->CellCssStyle = "white-space: nowrap;";

		// multiprice_id
		$this->multiprice_id->CellCssStyle = "white-space: nowrap;";

		// cbm
		// tax

		$this->tax->CellCssStyle = "white-space: nowrap;";

		// tax_amount
		$this->tax_amount->CellCssStyle = "white-space: nowrap;";

		// shipping_method
		$this->shipping_method->CellCssStyle = "white-space: nowrap;";

		// shipping_local
		$this->shipping_local->CellCssStyle = "white-space: nowrap;";

		// shipping_abroad
		$this->shipping_abroad->CellCssStyle = "white-space: nowrap;";

		// shipping_charge
		$this->shipping_charge->CellCssStyle = "white-space: nowrap;";

		// additional_discount
		// total_amount

		$this->total_amount->CellCssStyle = "white-space: nowrap;";

		// buyer_uid
		// buyer_loc
		// discount_price

		$this->discount_price->CellCssStyle = "white-space: nowrap;";

		// label
		// remarks
		// operator
		// datetime
		// o_datetime

		$this->o_datetime->CellCssStyle = "white-space: nowrap;";

		// cart_amount
		$this->cart_amount->CellCssStyle = "white-space: nowrap;";

		// c_total
		// image

		$this->image->CellCssStyle = "white-space: nowrap;";

		// 1
		$this->_1->CellCssStyle = "white-space: nowrap;";

		// 2
		$this->_2->CellCssStyle = "white-space: nowrap;";

		// 3
		$this->_3->CellCssStyle = "white-space: nowrap;";

		// 4
		$this->_4->CellCssStyle = "white-space: nowrap;";

		// 5
		$this->_5->CellCssStyle = "white-space: nowrap;";

		// 6
		$this->_6->CellCssStyle = "white-space: nowrap;";

		// 7
		$this->_7->CellCssStyle = "white-space: nowrap;";

		// 8
		$this->_8->CellCssStyle = "white-space: nowrap;";

		// r_text
		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// t_id
		$this->t_id->CellCssStyle = "white-space: nowrap;";

		// 9
		$this->_9->CellCssStyle = "white-space: nowrap;";

		// 10
		$this->_10->CellCssStyle = "white-space: nowrap;";

		// 11
		$this->_11->CellCssStyle = "white-space: nowrap;";

		// 12
		$this->_12->CellCssStyle = "white-space: nowrap;";

		// m_out_id
		$this->m_out_id->CellCssStyle = "white-space: nowrap;";

		// reports_to
		$this->reports_to->CellCssStyle = "white-space: nowrap;";

		// q_sku
		$this->q_sku->CellCssStyle = "white-space: nowrap;";

		// pam_qty
		$this->pam_qty->CellCssStyle = "white-space: nowrap;";

		// grp_type
		$this->grp_type->CellCssStyle = "white-space: nowrap;";

		// jc_qty
		$this->jc_qty->CellCssStyle = "white-space: nowrap;";

		// d_remarks
		// level
		// dispatch_week
		// sale_id
		// sale_qty
		// balance

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po_id
			$curVal = strval($this->po_id->CurrentValue);
			if ($curVal <> "") {
				$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
				if ($this->po_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_id->ViewValue = $this->po_id->CurrentValue;
					}
				}
			} else {
				$this->po_id->ViewValue = NULL;
			}
			$this->po_id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
			 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
			 : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_order_no
			$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
			$this->partner_order_no->ViewCustomAttributes = "";

			// partner_id
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			$this->partner_id->ViewCustomAttributes = "";

			// partner_rid
			if ($this->partner_rid->VirtualValue <> "") {
				$this->partner_rid->ViewValue = $this->partner_rid->VirtualValue;
			} else {
				$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
			$curVal = strval($this->partner_rid->CurrentValue);
			if ($curVal <> "") {
				$this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
				if ($this->partner_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
					}
				}
			} else {
				$this->partner_rid->ViewValue = NULL;
			}
			}
			$this->partner_rid->ViewCustomAttributes = "";

			// partner_code
			$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
			$this->partner_code->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// w
			$this->w->ViewValue = $this->w->CurrentValue;
			$this->w->ViewCustomAttributes = "";

			// w_cm
			$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
			$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
			$this->w_cm->ViewCustomAttributes = "";

			// l
			$this->l->ViewValue = $this->l->CurrentValue;
			$this->l->ViewCustomAttributes = "";

			// l_cm
			$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
			$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
			$this->l_cm->ViewCustomAttributes = "";

			// h
			$this->h->ViewValue = $this->h->CurrentValue;
			$this->h->ViewCustomAttributes = "";

			// h_cm
			$this->h_cm->ViewValue = $this->h_cm->CurrentValue;
			$this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, 2, -2, -2, -2);
			$this->h_cm->ViewCustomAttributes = "";

			// partner_size
			$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
			$this->partner_size->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 4, -2, -2, 0);
			$this->sqm->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
			$this->quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, 0);
			$this->price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, 0);
			$this->amount->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// additional_discount
			$this->additional_discount->ViewValue = $this->additional_discount->CurrentValue;
			$this->additional_discount->ViewValue = FormatNumber($this->additional_discount->ViewValue, 2, -2, -2, -2);
			$this->additional_discount->ViewCustomAttributes = "";

			// buyer_loc
			$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
			$this->buyer_loc->ViewCustomAttributes = "";

			// label
			$this->label->ViewValue = $this->label->CurrentValue;
			$this->label->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// level
			$this->level->ViewValue = $this->level->CurrentValue;
			$this->level->ViewValue = FormatNumber($this->level->ViewValue, 0, -2, -2, -2);
			$this->level->ViewCustomAttributes = "";

			// dispatch_week
			$this->dispatch_week->ViewValue = $this->dispatch_week->CurrentValue;
			$this->dispatch_week->ViewValue = FormatNumber($this->dispatch_week->ViewValue, 0, -2, -2, -2);
			$this->dispatch_week->ViewCustomAttributes = "";

			// sale_id
			$this->sale_id->ViewValue = $this->sale_id->CurrentValue;
			$this->sale_id->ViewCustomAttributes = "";

			// sale_qty
			$this->sale_qty->ViewValue = $this->sale_qty->CurrentValue;
			$this->sale_qty->ViewValue = FormatNumber($this->sale_qty->ViewValue, 2, -2, -2, -2);
			$this->sale_qty->ViewCustomAttributes = "";

			// balance
			$this->balance->ViewValue = $this->balance->CurrentValue;
			$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
			$this->balance->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->po_id->CurrentValue)) {
				$this->po_id->HrefValue = "product_cart_blist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
				$this->po_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
			} else {
				$this->po_id->HrefValue = "";
			}
			$this->po_id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";
			$this->partner_order_no->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_order_no->ViewValue = $this->highlightValue($this->partner_order_no);

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// partner_rid
			$this->partner_rid->LinkCustomAttributes = "";
			$this->partner_rid->HrefValue = "";
			$this->partner_rid->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_rid->ViewValue = $this->highlightValue($this->partner_rid);

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";
			$this->partner_code->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_code->ViewValue = $this->highlightValue($this->partner_code);

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";
			if (!$this->isExport())
				$this->grp->ViewValue = $this->highlightValue($this->grp);

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";
			if (!$this->isExport())
				$this->s_grp->ViewValue = $this->highlightValue($this->s_grp);

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";
			if (!$this->isExport())
				$this->product->ViewValue = $this->highlightValue($this->product);

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";
			if (!$this->isExport())
				$this->rid->ViewValue = $this->highlightValue($this->rid);

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";
			if (!$this->isExport())
				$this->size->ViewValue = $this->highlightValue($this->size);

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// additional_discount
			$this->additional_discount->LinkCustomAttributes = "";
			$this->additional_discount->HrefValue = "";
			$this->additional_discount->TooltipValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";
			$this->buyer_loc->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_loc->ViewValue = $this->highlightValue($this->buyer_loc);

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";

			// dispatch_week
			$this->dispatch_week->LinkCustomAttributes = "";
			$this->dispatch_week->HrefValue = "";
			$this->dispatch_week->TooltipValue = "";

			// sale_id
			$this->sale_id->LinkCustomAttributes = "";
			$this->sale_id->HrefValue = "";
			$this->sale_id->TooltipValue = "";
			if (!$this->isExport())
				$this->sale_id->ViewValue = $this->highlightValue($this->sale_id);

			// sale_qty
			$this->sale_qty->LinkCustomAttributes = "";
			$this->sale_qty->HrefValue = "";
			$this->sale_qty->TooltipValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";
			$this->balance->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			// po_id

			$this->po_id->EditAttrs["class"] = "form-control";
			$this->po_id->EditCustomAttributes = "";
			if ($this->po_id->getSessionValue() <> "") {
				$this->po_id->CurrentValue = $this->po_id->getSessionValue();
				$this->po_id->OldValue = $this->po_id->CurrentValue;
			$curVal = strval($this->po_id->CurrentValue);
			if ($curVal <> "") {
				$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
				if ($this->po_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_id->ViewValue = $this->po_id->CurrentValue;
					}
				}
			} else {
				$this->po_id->ViewValue = NULL;
			}
			$this->po_id->ViewCustomAttributes = "";
			} else {
			$curVal = trim(strval($this->po_id->CurrentValue));
			if ($curVal <> "")
				$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
			else
				$this->po_id->ViewValue = $this->po_id->Lookup !== NULL && is_array($this->po_id->Lookup->Options) ? $curVal : NULL;
			if ($this->po_id->ViewValue !== NULL) { // Load from cache
				$this->po_id->EditValue = array_values($this->po_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->po_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->po_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->po_id->EditValue = $arwrk;
			}
			}

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// partner_order_no
			$this->partner_order_no->EditAttrs["class"] = "form-control";
			$this->partner_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->partner_id->CurrentValue));
			if ($curVal <> "")
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			else
				$this->partner_id->ViewValue = $this->partner_id->Lookup !== NULL && is_array($this->partner_id->Lookup->Options) ? $curVal : NULL;
			if ($this->partner_id->ViewValue !== NULL) { // Load from cache
				$this->partner_id->EditValue = array_values($this->partner_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->partner_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->partner_id->EditValue = $arwrk;
			}

			// partner_rid
			$this->partner_rid->EditAttrs["class"] = "form-control";
			$this->partner_rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_rid->CurrentValue = HtmlDecode($this->partner_rid->CurrentValue);
			$this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
			$curVal = strval($this->partner_rid->CurrentValue);
			if ($curVal <> "") {
				$this->partner_rid->EditValue = $this->partner_rid->lookupCacheOption($curVal);
				if ($this->partner_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->partner_rid->EditValue = $this->partner_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
					}
				}
			} else {
				$this->partner_rid->EditValue = NULL;
			}
			$this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

			// partner_code
			$this->partner_code->EditAttrs["class"] = "form-control";
			$this->partner_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
			$this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
			$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = HtmlEncode($this->grp->CurrentValue);
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = HtmlEncode($this->grp->CurrentValue);
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rid->CurrentValue = HtmlDecode($this->rid->CurrentValue);
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->CurrentValue));
			if ($curVal <> "")
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
			$this->size->EditValue = HtmlEncode($this->size->CurrentValue);
			$this->size->PlaceHolder = RemoveHtml($this->size->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue)) {
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, 0);
				$this->quantity->OldValue = $this->quantity->EditValue;
			}

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue)) {
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, 0);
				$this->price->OldValue = $this->price->EditValue;
			}

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
			if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue)) {
				$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, 0);
				$this->amount->OldValue = $this->amount->EditValue;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// additional_discount
			$this->additional_discount->EditAttrs["class"] = "form-control";
			$this->additional_discount->EditCustomAttributes = "";
			$this->additional_discount->EditValue = HtmlEncode($this->additional_discount->CurrentValue);
			$this->additional_discount->PlaceHolder = RemoveHtml($this->additional_discount->caption());
			if (strval($this->additional_discount->EditValue) <> "" && is_numeric($this->additional_discount->EditValue)) {
				$this->additional_discount->EditValue = FormatNumber($this->additional_discount->EditValue, -2, -2, -2, -2);
				$this->additional_discount->OldValue = $this->additional_discount->EditValue;
			}

			// buyer_loc
			$this->buyer_loc->EditAttrs["class"] = "form-control";
			$this->buyer_loc->EditCustomAttributes = "";
			$this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->CurrentValue);
			$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

			// operator
			// datetime
			// level

			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = HtmlEncode($this->level->CurrentValue);
			$this->level->PlaceHolder = RemoveHtml($this->level->caption());

			// dispatch_week
			$this->dispatch_week->EditAttrs["class"] = "form-control";
			$this->dispatch_week->EditCustomAttributes = "";
			$this->dispatch_week->EditValue = HtmlEncode($this->dispatch_week->CurrentValue);
			$this->dispatch_week->PlaceHolder = RemoveHtml($this->dispatch_week->caption());

			// sale_id
			$this->sale_id->EditAttrs["class"] = "form-control";
			$this->sale_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sale_id->CurrentValue = HtmlDecode($this->sale_id->CurrentValue);
			$this->sale_id->EditValue = HtmlEncode($this->sale_id->CurrentValue);
			$this->sale_id->PlaceHolder = RemoveHtml($this->sale_id->caption());

			// sale_qty
			$this->sale_qty->EditAttrs["class"] = "form-control";
			$this->sale_qty->EditCustomAttributes = "";
			$this->sale_qty->EditValue = HtmlEncode($this->sale_qty->CurrentValue);
			$this->sale_qty->PlaceHolder = RemoveHtml($this->sale_qty->caption());
			if (strval($this->sale_qty->EditValue) <> "" && is_numeric($this->sale_qty->EditValue)) {
				$this->sale_qty->EditValue = FormatNumber($this->sale_qty->EditValue, -2, -2, -2, -2);
				$this->sale_qty->OldValue = $this->sale_qty->EditValue;
			}

			// balance
			$this->balance->EditAttrs["class"] = "form-control";
			$this->balance->EditCustomAttributes = "";
			$this->balance->EditValue = HtmlEncode($this->balance->CurrentValue);
			$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
			if (strval($this->balance->EditValue) <> "" && is_numeric($this->balance->EditValue)) {
				$this->balance->EditValue = FormatNumber($this->balance->EditValue, -2, -2, -2, -2);
				$this->balance->OldValue = $this->balance->EditValue;
			}

			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->po_id->CurrentValue)) {
				$this->po_id->HrefValue = "product_cart_blist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
				$this->po_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
			} else {
				$this->po_id->HrefValue = "";
			}

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";

			// partner_rid
			$this->partner_rid->LinkCustomAttributes = "";
			$this->partner_rid->HrefValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// additional_discount
			$this->additional_discount->LinkCustomAttributes = "";
			$this->additional_discount->HrefValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";

			// dispatch_week
			$this->dispatch_week->LinkCustomAttributes = "";
			$this->dispatch_week->HrefValue = "";

			// sale_id
			$this->sale_id->LinkCustomAttributes = "";
			$this->sale_id->HrefValue = "";

			// sale_qty
			$this->sale_qty->LinkCustomAttributes = "";
			$this->sale_qty->HrefValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po_id
			$this->po_id->EditAttrs["class"] = "form-control";
			$this->po_id->EditCustomAttributes = "";
			$curVal = strval($this->po_id->CurrentValue);
			if ($curVal <> "") {
				$this->po_id->EditValue = $this->po_id->lookupCacheOption($curVal);
				if ($this->po_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po_id->EditValue = $this->po_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_id->EditValue = $this->po_id->CurrentValue;
					}
				}
			} else {
				$this->po_id->EditValue = NULL;
			}
			$this->po_id->ViewCustomAttributes = "";

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// partner_order_no
			$this->partner_order_no->EditAttrs["class"] = "form-control";
			$this->partner_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->EditValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->EditValue = NULL;
			}
			$this->partner_id->ViewCustomAttributes = "";

			// partner_rid
			$this->partner_rid->EditAttrs["class"] = "form-control";
			$this->partner_rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_rid->CurrentValue = HtmlDecode($this->partner_rid->CurrentValue);
			$this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
			$curVal = strval($this->partner_rid->CurrentValue);
			if ($curVal <> "") {
				$this->partner_rid->EditValue = $this->partner_rid->lookupCacheOption($curVal);
				if ($this->partner_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->partner_rid->EditValue = $this->partner_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_rid->EditValue = HtmlEncode($this->partner_rid->CurrentValue);
					}
				}
			} else {
				$this->partner_rid->EditValue = NULL;
			}
			$this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

			// partner_code
			$this->partner_code->EditAttrs["class"] = "form-control";
			$this->partner_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
			$this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
			$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = $this->grp->CurrentValue;
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rid->CurrentValue = HtmlDecode($this->rid->CurrentValue);
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->CurrentValue));
			if ($curVal <> "")
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
			$this->size->EditValue = HtmlEncode($this->size->CurrentValue);
			$this->size->PlaceHolder = RemoveHtml($this->size->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue)) {
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, 0);
				$this->quantity->OldValue = $this->quantity->EditValue;
			}

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue)) {
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, 0);
				$this->price->OldValue = $this->price->EditValue;
			}

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
			if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue)) {
				$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, 0);
				$this->amount->OldValue = $this->amount->EditValue;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// additional_discount
			$this->additional_discount->EditAttrs["class"] = "form-control";
			$this->additional_discount->EditCustomAttributes = "";
			$this->additional_discount->EditValue = HtmlEncode($this->additional_discount->CurrentValue);
			$this->additional_discount->PlaceHolder = RemoveHtml($this->additional_discount->caption());
			if (strval($this->additional_discount->EditValue) <> "" && is_numeric($this->additional_discount->EditValue)) {
				$this->additional_discount->EditValue = FormatNumber($this->additional_discount->EditValue, -2, -2, -2, -2);
				$this->additional_discount->OldValue = $this->additional_discount->EditValue;
			}

			// buyer_loc
			$this->buyer_loc->EditAttrs["class"] = "form-control";
			$this->buyer_loc->EditCustomAttributes = "";
			$this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->CurrentValue);
			$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

			// operator
			// datetime
			// level

			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = HtmlEncode($this->level->CurrentValue);
			$this->level->PlaceHolder = RemoveHtml($this->level->caption());

			// dispatch_week
			$this->dispatch_week->EditAttrs["class"] = "form-control";
			$this->dispatch_week->EditCustomAttributes = "";
			$this->dispatch_week->EditValue = HtmlEncode($this->dispatch_week->CurrentValue);
			$this->dispatch_week->PlaceHolder = RemoveHtml($this->dispatch_week->caption());

			// sale_id
			$this->sale_id->EditAttrs["class"] = "form-control";
			$this->sale_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sale_id->CurrentValue = HtmlDecode($this->sale_id->CurrentValue);
			$this->sale_id->EditValue = HtmlEncode($this->sale_id->CurrentValue);
			$this->sale_id->PlaceHolder = RemoveHtml($this->sale_id->caption());

			// sale_qty
			$this->sale_qty->EditAttrs["class"] = "form-control";
			$this->sale_qty->EditCustomAttributes = "";
			$this->sale_qty->EditValue = HtmlEncode($this->sale_qty->CurrentValue);
			$this->sale_qty->PlaceHolder = RemoveHtml($this->sale_qty->caption());
			if (strval($this->sale_qty->EditValue) <> "" && is_numeric($this->sale_qty->EditValue)) {
				$this->sale_qty->EditValue = FormatNumber($this->sale_qty->EditValue, -2, -2, -2, -2);
				$this->sale_qty->OldValue = $this->sale_qty->EditValue;
			}

			// balance
			$this->balance->EditAttrs["class"] = "form-control";
			$this->balance->EditCustomAttributes = "";
			$this->balance->EditValue = HtmlEncode($this->balance->CurrentValue);
			$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
			if (strval($this->balance->EditValue) <> "" && is_numeric($this->balance->EditValue)) {
				$this->balance->EditValue = FormatNumber($this->balance->EditValue, -2, -2, -2, -2);
				$this->balance->OldValue = $this->balance->EditValue;
			}

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->po_id->CurrentValue)) {
				$this->po_id->HrefValue = "product_cart_blist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
				$this->po_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
			} else {
				$this->po_id->HrefValue = "";
			}
			$this->po_id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// partner_rid
			$this->partner_rid->LinkCustomAttributes = "";
			$this->partner_rid->HrefValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// additional_discount
			$this->additional_discount->LinkCustomAttributes = "";
			$this->additional_discount->HrefValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";

			// dispatch_week
			$this->dispatch_week->LinkCustomAttributes = "";
			$this->dispatch_week->HrefValue = "";

			// sale_id
			$this->sale_id->LinkCustomAttributes = "";
			$this->sale_id->HrefValue = "";

			// sale_qty
			$this->sale_qty->LinkCustomAttributes = "";
			$this->sale_qty->HrefValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->po_id->Required) {
			if (!$this->po_id->IsDetailKey && $this->po_id->FormValue != NULL && $this->po_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_id->caption(), $this->po_id->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->partner_order_no->Required) {
			if (!$this->partner_order_no->IsDetailKey && $this->partner_order_no->FormValue != NULL && $this->partner_order_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_order_no->caption(), $this->partner_order_no->RequiredErrorMessage));
			}
		}
		if ($this->partner_id->Required) {
			if (!$this->partner_id->IsDetailKey && $this->partner_id->FormValue != NULL && $this->partner_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
			}
		}
		if ($this->partner_rid->Required) {
			if (!$this->partner_rid->IsDetailKey && $this->partner_rid->FormValue != NULL && $this->partner_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_rid->caption(), $this->partner_rid->RequiredErrorMessage));
			}
		}
		if ($this->partner_code->Required) {
			if (!$this->partner_code->IsDetailKey && $this->partner_code->FormValue != NULL && $this->partner_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if (!$this->shape->IsDetailKey && $this->shape->FormValue != NULL && $this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->w->Required) {
			if (!$this->w->IsDetailKey && $this->w->FormValue != NULL && $this->w->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w->caption(), $this->w->RequiredErrorMessage));
			}
		}
		if ($this->w_cm->Required) {
			if (!$this->w_cm->IsDetailKey && $this->w_cm->FormValue != NULL && $this->w_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
			}
		}
		if ($this->l->Required) {
			if (!$this->l->IsDetailKey && $this->l->FormValue != NULL && $this->l->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l->caption(), $this->l->RequiredErrorMessage));
			}
		}
		if ($this->l_cm->Required) {
			if (!$this->l_cm->IsDetailKey && $this->l_cm->FormValue != NULL && $this->l_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
			}
		}
		if ($this->h->Required) {
			if (!$this->h->IsDetailKey && $this->h->FormValue != NULL && $this->h->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h->caption(), $this->h->RequiredErrorMessage));
			}
		}
		if ($this->h_cm->Required) {
			if (!$this->h_cm->IsDetailKey && $this->h_cm->FormValue != NULL && $this->h_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h_cm->caption(), $this->h_cm->RequiredErrorMessage));
			}
		}
		if ($this->partner_size->Required) {
			if (!$this->partner_size->IsDetailKey && $this->partner_size->FormValue != NULL && $this->partner_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_size->caption(), $this->partner_size->RequiredErrorMessage));
			}
		}
		if ($this->size->Required) {
			if (!$this->size->IsDetailKey && $this->size->FormValue != NULL && $this->size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
			}
		}
		if ($this->sqm_u->Required) {
			if (!$this->sqm_u->IsDetailKey && $this->sqm_u->FormValue != NULL && $this->sqm_u->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm_u->caption(), $this->sqm_u->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price->FormValue)) {
			AddMessage($FormError, $this->price->errorMessage());
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount->FormValue)) {
			AddMessage($FormError, $this->amount->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->cart_id->Required) {
			if (!$this->cart_id->IsDetailKey && $this->cart_id->FormValue != NULL && $this->cart_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_id->caption(), $this->cart_id->RequiredErrorMessage));
			}
		}
		if ($this->rid_1->Required) {
			if (!$this->rid_1->IsDetailKey && $this->rid_1->FormValue != NULL && $this->rid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
			}
		}
		if ($this->hsn_code->Required) {
			if (!$this->hsn_code->IsDetailKey && $this->hsn_code->FormValue != NULL && $this->hsn_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hsn_code->caption(), $this->hsn_code->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if ($this->pkt_quantity->Required) {
			if (!$this->pkt_quantity->IsDetailKey && $this->pkt_quantity->FormValue != NULL && $this->pkt_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pkt_quantity->caption(), $this->pkt_quantity->RequiredErrorMessage));
			}
		}
		if ($this->multiprice_id->Required) {
			if (!$this->multiprice_id->IsDetailKey && $this->multiprice_id->FormValue != NULL && $this->multiprice_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->multiprice_id->caption(), $this->multiprice_id->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if ($this->tax->Required) {
			if (!$this->tax->IsDetailKey && $this->tax->FormValue != NULL && $this->tax->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax->caption(), $this->tax->RequiredErrorMessage));
			}
		}
		if ($this->tax_amount->Required) {
			if (!$this->tax_amount->IsDetailKey && $this->tax_amount->FormValue != NULL && $this->tax_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax_amount->caption(), $this->tax_amount->RequiredErrorMessage));
			}
		}
		if ($this->shipping_method->Required) {
			if (!$this->shipping_method->IsDetailKey && $this->shipping_method->FormValue != NULL && $this->shipping_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_method->caption(), $this->shipping_method->RequiredErrorMessage));
			}
		}
		if ($this->shipping_local->Required) {
			if (!$this->shipping_local->IsDetailKey && $this->shipping_local->FormValue != NULL && $this->shipping_local->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_local->caption(), $this->shipping_local->RequiredErrorMessage));
			}
		}
		if ($this->shipping_abroad->Required) {
			if (!$this->shipping_abroad->IsDetailKey && $this->shipping_abroad->FormValue != NULL && $this->shipping_abroad->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_abroad->caption(), $this->shipping_abroad->RequiredErrorMessage));
			}
		}
		if ($this->shipping_charge->Required) {
			if (!$this->shipping_charge->IsDetailKey && $this->shipping_charge->FormValue != NULL && $this->shipping_charge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_charge->caption(), $this->shipping_charge->RequiredErrorMessage));
			}
		}
		if ($this->additional_discount->Required) {
			if (!$this->additional_discount->IsDetailKey && $this->additional_discount->FormValue != NULL && $this->additional_discount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->additional_discount->caption(), $this->additional_discount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->additional_discount->FormValue)) {
			AddMessage($FormError, $this->additional_discount->errorMessage());
		}
		if ($this->total_amount->Required) {
			if (!$this->total_amount->IsDetailKey && $this->total_amount->FormValue != NULL && $this->total_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
			}
		}
		if ($this->buyer_uid->Required) {
			if (!$this->buyer_uid->IsDetailKey && $this->buyer_uid->FormValue != NULL && $this->buyer_uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_uid->caption(), $this->buyer_uid->RequiredErrorMessage));
			}
		}
		if ($this->buyer_loc->Required) {
			if (!$this->buyer_loc->IsDetailKey && $this->buyer_loc->FormValue != NULL && $this->buyer_loc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_loc->caption(), $this->buyer_loc->RequiredErrorMessage));
			}
		}
		if ($this->discount_price->Required) {
			if (!$this->discount_price->IsDetailKey && $this->discount_price->FormValue != NULL && $this->discount_price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->discount_price->caption(), $this->discount_price->RequiredErrorMessage));
			}
		}
		if ($this->label->Required) {
			if (!$this->label->IsDetailKey && $this->label->FormValue != NULL && $this->label->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->label->caption(), $this->label->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->o_datetime->Required) {
			if (!$this->o_datetime->IsDetailKey && $this->o_datetime->FormValue != NULL && $this->o_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->o_datetime->caption(), $this->o_datetime->RequiredErrorMessage));
			}
		}
		if ($this->cart_amount->Required) {
			if (!$this->cart_amount->IsDetailKey && $this->cart_amount->FormValue != NULL && $this->cart_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_amount->caption(), $this->cart_amount->RequiredErrorMessage));
			}
		}
		if ($this->c_total->Required) {
			if (!$this->c_total->IsDetailKey && $this->c_total->FormValue != NULL && $this->c_total->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_total->caption(), $this->c_total->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if (!$this->image->IsDetailKey && $this->image->FormValue != NULL && $this->image->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->_1->Required) {
			if (!$this->_1->IsDetailKey && $this->_1->FormValue != NULL && $this->_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
			}
		}
		if ($this->_2->Required) {
			if (!$this->_2->IsDetailKey && $this->_2->FormValue != NULL && $this->_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
			}
		}
		if ($this->_3->Required) {
			if (!$this->_3->IsDetailKey && $this->_3->FormValue != NULL && $this->_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
			}
		}
		if ($this->_4->Required) {
			if (!$this->_4->IsDetailKey && $this->_4->FormValue != NULL && $this->_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
			}
		}
		if ($this->_5->Required) {
			if (!$this->_5->IsDetailKey && $this->_5->FormValue != NULL && $this->_5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
			}
		}
		if ($this->_6->Required) {
			if (!$this->_6->IsDetailKey && $this->_6->FormValue != NULL && $this->_6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
			}
		}
		if ($this->_7->Required) {
			if (!$this->_7->IsDetailKey && $this->_7->FormValue != NULL && $this->_7->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
			}
		}
		if ($this->_8->Required) {
			if (!$this->_8->IsDetailKey && $this->_8->FormValue != NULL && $this->_8->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
			}
		}
		if ($this->r_text->Required) {
			if (!$this->r_text->IsDetailKey && $this->r_text->FormValue != NULL && $this->r_text->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_text->caption(), $this->r_text->RequiredErrorMessage));
			}
		}
		if ($this->t_id->Required) {
			if (!$this->t_id->IsDetailKey && $this->t_id->FormValue != NULL && $this->t_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_id->caption(), $this->t_id->RequiredErrorMessage));
			}
		}
		if ($this->_9->Required) {
			if (!$this->_9->IsDetailKey && $this->_9->FormValue != NULL && $this->_9->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_9->caption(), $this->_9->RequiredErrorMessage));
			}
		}
		if ($this->_10->Required) {
			if (!$this->_10->IsDetailKey && $this->_10->FormValue != NULL && $this->_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_10->caption(), $this->_10->RequiredErrorMessage));
			}
		}
		if ($this->_11->Required) {
			if (!$this->_11->IsDetailKey && $this->_11->FormValue != NULL && $this->_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_11->caption(), $this->_11->RequiredErrorMessage));
			}
		}
		if ($this->_12->Required) {
			if (!$this->_12->IsDetailKey && $this->_12->FormValue != NULL && $this->_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_12->caption(), $this->_12->RequiredErrorMessage));
			}
		}
		if ($this->m_out_id->Required) {
			if (!$this->m_out_id->IsDetailKey && $this->m_out_id->FormValue != NULL && $this->m_out_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_out_id->caption(), $this->m_out_id->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->q_sku->Required) {
			if (!$this->q_sku->IsDetailKey && $this->q_sku->FormValue != NULL && $this->q_sku->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
			}
		}
		if ($this->pam_qty->Required) {
			if (!$this->pam_qty->IsDetailKey && $this->pam_qty->FormValue != NULL && $this->pam_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pam_qty->caption(), $this->pam_qty->RequiredErrorMessage));
			}
		}
		if ($this->grp_type->Required) {
			if (!$this->grp_type->IsDetailKey && $this->grp_type->FormValue != NULL && $this->grp_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp_type->caption(), $this->grp_type->RequiredErrorMessage));
			}
		}
		if ($this->jc_qty->Required) {
			if (!$this->jc_qty->IsDetailKey && $this->jc_qty->FormValue != NULL && $this->jc_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_qty->caption(), $this->jc_qty->RequiredErrorMessage));
			}
		}
		if ($this->d_remarks->Required) {
			if (!$this->d_remarks->IsDetailKey && $this->d_remarks->FormValue != NULL && $this->d_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_remarks->caption(), $this->d_remarks->RequiredErrorMessage));
			}
		}
		if ($this->level->Required) {
			if (!$this->level->IsDetailKey && $this->level->FormValue != NULL && $this->level->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->level->caption(), $this->level->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->level->FormValue)) {
			AddMessage($FormError, $this->level->errorMessage());
		}
		if ($this->dispatch_week->Required) {
			if (!$this->dispatch_week->IsDetailKey && $this->dispatch_week->FormValue != NULL && $this->dispatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dispatch_week->caption(), $this->dispatch_week->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->dispatch_week->FormValue)) {
			AddMessage($FormError, $this->dispatch_week->errorMessage());
		}
		if ($this->sale_id->Required) {
			if (!$this->sale_id->IsDetailKey && $this->sale_id->FormValue != NULL && $this->sale_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sale_id->caption(), $this->sale_id->RequiredErrorMessage));
			}
		}
		if ($this->sale_qty->Required) {
			if (!$this->sale_qty->IsDetailKey && $this->sale_qty->FormValue != NULL && $this->sale_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sale_qty->caption(), $this->sale_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->sale_qty->FormValue)) {
			AddMessage($FormError, $this->sale_qty->errorMessage());
		}
		if ($this->balance->Required) {
			if (!$this->balance->IsDetailKey && $this->balance->FormValue != NULL && $this->balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance->caption(), $this->balance->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->balance->FormValue)) {
			AddMessage($FormError, $this->balance->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		if ($this->AuditTrailOnDelete)
			$this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// partner_order_no
			$this->partner_order_no->setDbValueDef($rsnew, $this->partner_order_no->CurrentValue, NULL, $this->partner_order_no->ReadOnly);

			// partner_rid
			$this->partner_rid->setDbValueDef($rsnew, $this->partner_rid->CurrentValue, NULL, $this->partner_rid->ReadOnly);

			// partner_code
			$this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, NULL, $this->partner_code->ReadOnly);

			// s_grp
			$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, $this->s_grp->ReadOnly);

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, $this->product->ReadOnly);

			// rid
			$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, $this->rid->ReadOnly);

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, $this->packing_type->ReadOnly);

			// product_type
			$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, 0, $this->product_type->ReadOnly);

			// size
			$this->size->setDbValueDef($rsnew, $this->size->CurrentValue, NULL, $this->size->ReadOnly);

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, $this->quantity->ReadOnly);

			// price
			$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, 0, $this->price->ReadOnly);

			// amount
			$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, NULL, $this->amount->ReadOnly);

			// additional_discount
			$this->additional_discount->setDbValueDef($rsnew, $this->additional_discount->CurrentValue, NULL, $this->additional_discount->ReadOnly);

			// buyer_loc
			$this->buyer_loc->setDbValueDef($rsnew, $this->buyer_loc->CurrentValue, NULL, $this->buyer_loc->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// level
			$this->level->setDbValueDef($rsnew, $this->level->CurrentValue, NULL, $this->level->ReadOnly);

			// dispatch_week
			$this->dispatch_week->setDbValueDef($rsnew, $this->dispatch_week->CurrentValue, NULL, $this->dispatch_week->ReadOnly);

			// sale_id
			$this->sale_id->setDbValueDef($rsnew, $this->sale_id->CurrentValue, "", $this->sale_id->ReadOnly);

			// sale_qty
			$this->sale_qty->setDbValueDef($rsnew, $this->sale_qty->CurrentValue, 0, $this->sale_qty->ReadOnly);

			// balance
			$this->balance->setDbValueDef($rsnew, $this->balance->CurrentValue, NULL, $this->balance->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Set up foreign key field value from Session
			if ($this->getCurrentMasterTable() == "po_b") {
				$this->po_id->CurrentValue = $this->po_id->getSessionValue();
			}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// po_id
		$this->po_id->setDbValueDef($rsnew, $this->po_id->CurrentValue, NULL, strval($this->po_id->CurrentValue) == "");

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, FALSE);

		// partner_order_no
		$this->partner_order_no->setDbValueDef($rsnew, $this->partner_order_no->CurrentValue, NULL, FALSE);

		// partner_id
		$this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, NULL, FALSE);

		// partner_rid
		$this->partner_rid->setDbValueDef($rsnew, $this->partner_rid->CurrentValue, NULL, FALSE);

		// partner_code
		$this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, NULL, FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, FALSE);

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, FALSE);

		// packing_type
		$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, strval($this->packing_type->CurrentValue) == "");

		// product_type
		$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, 0, FALSE);

		// size
		$this->size->setDbValueDef($rsnew, $this->size->CurrentValue, NULL, FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, FALSE);

		// price
		$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, 0, FALSE);

		// amount
		$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, strval($this->status->CurrentValue) == "");

		// additional_discount
		$this->additional_discount->setDbValueDef($rsnew, $this->additional_discount->CurrentValue, NULL, FALSE);

		// buyer_loc
		$this->buyer_loc->setDbValueDef($rsnew, $this->buyer_loc->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// level
		$this->level->setDbValueDef($rsnew, $this->level->CurrentValue, NULL, strval($this->level->CurrentValue) == "");

		// dispatch_week
		$this->dispatch_week->setDbValueDef($rsnew, $this->dispatch_week->CurrentValue, NULL, FALSE);

		// sale_id
		$this->sale_id->setDbValueDef($rsnew, $this->sale_id->CurrentValue, "", FALSE);

		// sale_qty
		$this->sale_qty->setDbValueDef($rsnew, $this->sale_qty->CurrentValue, 0, FALSE);

		// balance
		$this->balance->setDbValueDef($rsnew, $this->balance->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{

		// Hide foreign keys
		$masterTblVar = $this->getCurrentMasterTable();
		if ($masterTblVar == "po_b") {
			$this->po_id->Visible = FALSE;
			if ($GLOBALS["po_b"]->EventCancelled)
				$this->EventCancelled = TRUE;
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
 : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_rid":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_po_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_location":
							break;
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_partner_rid":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_batch_no":
							break;
						case "x_shape":
							break;
						case "x_product_type":
							break;
						case "x_currency":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		$CUID = CurrentUserID();
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'product_cart_b');
		$item = &$this->OtherOptions['action']->Add("Create Order");
		$item->Body = "<button class=\"btn btn-danger ew-action\" onclick=\"javascript:CreateOrder()\">Create Order From Selected</button>";
		$item->Visible = True;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}
}
?>