<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_cart_b_sample_delete extends product_cart_b_sample
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_cart_b_sample';

	// Page object name
	public $PageObjName = "product_cart_b_sample_delete";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_cart_b_sample)
		if (!isset($GLOBALS["product_cart_b_sample"]) || get_class($GLOBALS["product_cart_b_sample"]) == PROJECT_NAMESPACE . "product_cart_b_sample") {
			$GLOBALS["product_cart_b_sample"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["product_cart_b_sample"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_b_sample');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $product_cart_b_sample;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_cart_b_sample);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $TotalRecs = 0;
	public $RecCnt;
	public $RecKeys = array();
	public $StartRowCnt = 1;
	public $RowCnt = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("product_cart_b_samplelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->po_id->setVisibility();
		$this->company_id->setVisibility();
		$this->partner_id->setVisibility();
		$this->product_type->Visible = FALSE;
		$this->grp->setVisibility();
		$this->s_grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->rid->Visible = FALSE;
		$this->rid_1->setVisibility();
		$this->_1->Visible = FALSE;
		$this->shape->Visible = FALSE;
		$this->unit->Visible = FALSE;
		$this->w->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->h->Visible = FALSE;
		$this->h_cm->Visible = FALSE;
		$this->partner_size->setVisibility();
		$this->sqm->Visible = FALSE;
		$this->quantity->setVisibility();
		$this->price->Visible = FALSE;
		$this->currency->Visible = FALSE;
		$this->amount->Visible = FALSE;
		$this->_2->Visible = FALSE;
		$this->_3->Visible = FALSE;
		$this->_4->Visible = FALSE;
		$this->_5->Visible = FALSE;
		$this->_6->Visible = FALSE;
		$this->_7->Visible = FALSE;
		$this->_8->Visible = FALSE;
		$this->_9->Visible = FALSE;
		$this->_10->Visible = FALSE;
		$this->_11->Visible = FALSE;
		$this->_12->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->buyer_uid->Visible = FALSE;
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->r_text->Visible = FALSE;
		$this->t_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->po_id);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("product_cart_b_samplelist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("product_cart_b_samplelist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->po_id->setDbValue($row['po_id']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->product_type->setDbValue($row['product_type']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->_1->setDbValue($row['1']);
		$this->shape->setDbValue($row['shape']);
		$this->unit->setDbValue($row['unit']);
		$this->w->setDbValue($row['w']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l->setDbValue($row['l']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->h->setDbValue($row['h']);
		$this->h_cm->setDbValue($row['h_cm']);
		$this->partner_size->setDbValue($row['partner_size']);
		$this->sqm->setDbValue($row['sqm']);
		$this->quantity->setDbValue($row['quantity']);
		$this->price->setDbValue($row['price']);
		$this->currency->setDbValue($row['currency']);
		$this->amount->setDbValue($row['amount']);
		$this->_2->setDbValue($row['2']);
		$this->_3->setDbValue($row['3']);
		$this->_4->setDbValue($row['4']);
		$this->_5->setDbValue($row['5']);
		$this->_6->setDbValue($row['6']);
		$this->_7->setDbValue($row['7']);
		$this->_8->setDbValue($row['8']);
		$this->_9->setDbValue($row['9']);
		$this->_10->setDbValue($row['10']);
		$this->_11->setDbValue($row['11']);
		$this->_12->setDbValue($row['12']);
		$this->remarks->setDbValue($row['remarks']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->r_text->setDbValue($row['r_text']);
		$this->t_id->setDbValue($row['t_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['po_id'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['product_type'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['rid_1'] = NULL;
		$row['1'] = NULL;
		$row['shape'] = NULL;
		$row['unit'] = NULL;
		$row['w'] = NULL;
		$row['w_cm'] = NULL;
		$row['l'] = NULL;
		$row['l_cm'] = NULL;
		$row['h'] = NULL;
		$row['h_cm'] = NULL;
		$row['partner_size'] = NULL;
		$row['sqm'] = NULL;
		$row['quantity'] = NULL;
		$row['price'] = NULL;
		$row['currency'] = NULL;
		$row['amount'] = NULL;
		$row['2'] = NULL;
		$row['3'] = NULL;
		$row['4'] = NULL;
		$row['5'] = NULL;
		$row['6'] = NULL;
		$row['7'] = NULL;
		$row['8'] = NULL;
		$row['9'] = NULL;
		$row['10'] = NULL;
		$row['11'] = NULL;
		$row['12'] = NULL;
		$row['remarks'] = NULL;
		$row['image'] = NULL;
		$row['buyer_uid'] = NULL;
		$row['status'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['r_text'] = NULL;
		$row['t_id'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// po_id
		// company_id
		// partner_id
		// product_type
		// grp
		// s_grp
		// product
		// rid

		$this->rid->CellCssStyle = "white-space: nowrap;";

		// rid_1
		// 1

		$this->_1->CellCssStyle = "white-space: nowrap;";

		// shape
		// unit
		// w
		// w_cm
		// l
		// l_cm
		// h

		$this->h->CellCssStyle = "white-space: nowrap;";

		// h_cm
		$this->h_cm->CellCssStyle = "white-space: nowrap;";

		// partner_size
		// sqm
		// quantity
		// price
		// currency
		// amount

		$this->amount->CellCssStyle = "white-space: nowrap;";

		// 2
		$this->_2->CellCssStyle = "white-space: nowrap;";

		// 3
		$this->_3->CellCssStyle = "white-space: nowrap;";

		// 4
		$this->_4->CellCssStyle = "white-space: nowrap;";

		// 5
		$this->_5->CellCssStyle = "white-space: nowrap;";

		// 6
		$this->_6->CellCssStyle = "white-space: nowrap;";

		// 7
		$this->_7->CellCssStyle = "white-space: nowrap;";

		// 8
		$this->_8->CellCssStyle = "white-space: nowrap;";

		// 9
		// 10
		// 11
		// 12
		// remarks

		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// image
		// buyer_uid
		// status
		// operator
		// datetime
		// r_text

		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// t_id
		$this->t_id->CellCssStyle = "white-space: nowrap;";
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po_id
			$curVal = strval($this->po_id->CurrentValue);
			if ($curVal <> "") {
				$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
				if ($this->po_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_id->ViewValue = $this->po_id->CurrentValue;
					}
				}
			} else {
				$this->po_id->ViewValue = NULL;
			}
			$this->po_id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `partner_type` = 2 and `id` >= 1000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `partner_type` = 1 and `id` >= 200000" : "`status` = 1 and `id` >= 200000 and `partner_type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// product_type
			if (strval($this->product_type->CurrentValue) <> "") {
				$this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// rid_1
			$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
			$this->rid_1->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// w
			$this->w->ViewValue = $this->w->CurrentValue;
			$this->w->ViewCustomAttributes = "";

			// w_cm
			$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
			$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
			$this->w_cm->ViewCustomAttributes = "";

			// l
			$this->l->ViewValue = $this->l->CurrentValue;
			$this->l->ViewCustomAttributes = "";

			// l_cm
			$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
			$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
			$this->l_cm->ViewCustomAttributes = "";

			// partner_size
			$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
			$this->partner_size->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
			$this->quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// 9
			$this->_9->ViewValue = $this->_9->CurrentValue;
			$this->_9->ViewCustomAttributes = "";

			// 10
			$this->_10->ViewValue = $this->_10->CurrentValue;
			$this->_10->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			$this->po_id->HrefValue = "";
			$this->po_id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";
			$this->rid_1->TooltipValue = "";

			// partner_size
			$this->partner_size->LinkCustomAttributes = "";
			$this->partner_size->HrefValue = "";
			$this->partner_size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();
		if ($this->AuditTrailOnDelete)
			$this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
		} else {
			$conn->rollbackTrans(); // Rollback changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("product_cart_b_samplelist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `partner_type` = 2 and `id` >= 1000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `partner_type` = 1 and `id` >= 200000" : "`status` = 1 and `id` >= 200000 and `partner_type` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_po_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_shape":
							break;
						case "x_currency":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'product_cart_b_sample');		
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>