<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for product_cart_b_wbc
 */
class product_cart_b_wbc extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $company_id;
	public $partner_order_no;
	public $reports_to;
	public $location;
	public $cart_id;
	public $po_id;
	public $partner_id;
	public $partner_rid;
	public $partner_code;
	public $product_type;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $packing_type;
	public $batch_no;
	public $unit;
	public $shape;
	public $partner_size;
	public $size;
	public $rid_1;
	public $hsn_code;
	public $quantity;
	public $despatch_date;
	public $pkt_quantity;
	public $multiprice_id;
	public $price;
	public $currency;
	public $discount_price;
	public $amount;
	public $cart_amount;
	public $label;
	public $cbm;
	public $sqm;
	public $sqm_u;
	public $tax;
	public $tax_amount;
	public $shipping_method;
	public $shipping_local;
	public $shipping_abroad;
	public $shipping_charge;
	public $additional_discount;
	public $total_amount;
	public $status;
	public $remarks;
	public $image;
	public $buyer_uid;
	public $buyer_loc;
	public $operator;
	public $o_datetime;
	public $datetime;
	public $q_sku;
	public $w;
	public $l;
	public $h;
	public $w_cm;
	public $l_cm;
	public $h_cm;
	public $c_total;
	public $_1;
	public $_2;
	public $_3;
	public $_4;
	public $_5;
	public $_6;
	public $_7;
	public $_8;
	public $_9;
	public $_10;
	public $_11;
	public $_12;
	public $r_text;
	public $t_id;
	public $m_out_id;
	public $pam_qty;
	public $grp_type;
	public $level;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'product_cart_b_wbc';
		$this->TableName = 'product_cart_b_wbc';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`product_cart_b_wbc`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// company_id
		$this->company_id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', TRUE, 'id', ["name","","",""], [], ["x_partner_rid"], [], [], ["currency"], ["x_currency"], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_order_no
		$this->partner_order_no = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_partner_order_no', 'partner_order_no', '`partner_order_no`', '`partner_order_no`', 200, -1, FALSE, '`partner_order_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_order_no->Required = TRUE; // Required field
		$this->partner_order_no->Sortable = TRUE; // Allow sort
		$this->fields['partner_order_no'] = &$this->partner_order_no;

		// reports_to
		$this->reports_to = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 2, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reports_to->Sortable = FALSE; // Allow sort
		$this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reports_to'] = &$this->reports_to;

		// location
		$this->location = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_location', 'location', '`location`', '`location`', 18, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->location->Lookup = new Lookup('location', 'godown_table', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// cart_id
		$this->cart_id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_cart_id', 'cart_id', '`cart_id`', '`cart_id`', 19, -1, FALSE, '`cart_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_id->Required = TRUE; // Required field
		$this->cart_id->Sortable = FALSE; // Allow sort
		$this->cart_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cart_id'] = &$this->cart_id;

		// po_id
		$this->po_id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_po_id', 'po_id', '`po_id`', '`po_id`', 18, -1, FALSE, '`po_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_id->Required = TRUE; // Required field
		$this->po_id->Sortable = TRUE; // Allow sort
		$this->po_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_id->Lookup = new Lookup('po_id', 'po_b', FALSE, 'id', ["po","","",""], [], [], [], [], [], [], '`po` ASC', '');
		$this->po_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_id'] = &$this->po_id;

		// partner_id
		$this->partner_id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`EV__partner_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'production_partner', TRUE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = str_replace(array("%1", "%2"), array("100000", ""), $Language->phrase("IncorrectRange"));
		$this->fields['partner_id'] = &$this->partner_id;

		// partner_rid
		$this->partner_rid = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_partner_rid', 'partner_rid', '`partner_rid`', '`partner_rid`', 200, -1, FALSE, '`EV__partner_rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_rid->Sortable = TRUE; // Allow sort
		$this->partner_rid->Lookup = new Lookup('partner_rid', 'partner_product_ref', FALSE, 'id', ["partner_ref","barcode","partner_code",""], ["x_company_id"], [], ["partner"], ["x_partner"], ["barcode","grp","s_grp","product","rid","packing_type","batch_no","shape","product_type","unit","w","w_cm","l","l_cm","h","h_cm","partner_size","sqm","price","currency"], ["x_partner_code","x_grp","x_s_grp","x_product","x_rid","x_packing_type","x_batch_no","x_shape","x_product_type","x_unit","x_w","x_w_cm","x_l","x_l_cm","x_h","x_h_cm","x_partner_size","x_sqm","x_price","x_currency"], '`partner_ref` ASC', '');
		$this->fields['partner_rid'] = &$this->partner_rid;

		// partner_code
		$this->partner_code = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_partner_code', 'partner_code', '`partner_code`', '`partner_code`', 200, -1, FALSE, '`partner_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_code->Sortable = TRUE; // Allow sort
		$this->fields['partner_code'] = &$this->partner_code;

		// product_type
		$this->product_type = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 18, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_type->Nullable = FALSE; // NOT NULL field
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_type->Lookup = new Lookup('product_type', 'product_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_type'] = &$this->product_type;

		// grp
		$this->grp = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product","x_rid"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->Lookup = new Lookup('product', '_product_view', TRUE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_rid', 'rid', '`rid`', '`rid`', 200, -1, FALSE, '`EV__rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], ["x_s_grp","x_product"], ["x_batch_no"], ["s_grp","product"], ["x_s_grp","x_product"], ["sqm","sqm"], ["x_sqm_u","x_sqm"], '`product_code` ASC', '');
		$this->fields['rid'] = &$this->rid;

		// packing_type
		$this->packing_type = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["code","packing","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// batch_no
		$this->batch_no = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 2, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', TRUE, 'id', ["id","batch_no","description",""], ["x_rid"], [], ["rid"], ["x_rid"], [], [], '`batch_no` ASC', '');
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// unit
		$this->unit = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_unit', 'unit', '`unit`', '`unit`', 18, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Required = TRUE; // Required field
		$this->unit->Sortable = FALSE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'product_cart_b_wbc', FALSE, '', ["","","",""], [], [], [], [], ["currency"], ["x_currency"], '', '');
		$this->unit->OptionCount = 5;
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// shape
		$this->shape = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_shape', 'shape', '`shape`', '`shape`', 17, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Sortable = FALSE; // Allow sort
		$this->shape->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shape->Lookup = new Lookup('shape', 'shape', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shape'] = &$this->shape;

		// partner_size
		$this->partner_size = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_partner_size', 'partner_size', '`partner_size`', '`partner_size`', 200, -1, FALSE, '`partner_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_size->Sortable = FALSE; // Allow sort
		$this->fields['partner_size'] = &$this->partner_size;

		// size
		$this->size = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_size', 'size', '`size`', '`size`', 200, -1, FALSE, '`size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size->Sortable = FALSE; // Allow sort
		$this->fields['size'] = &$this->size;

		// rid_1
		$this->rid_1 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_rid_1', 'rid_1', '`rid_1`', '`rid_1`', 201, -1, FALSE, '`rid_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid_1->Sortable = FALSE; // Allow sort
		$this->fields['rid_1'] = &$this->rid_1;

		// hsn_code
		$this->hsn_code = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_hsn_code', 'hsn_code', '`hsn_code`', '`hsn_code`', 200, -1, FALSE, '`hsn_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->hsn_code->Required = TRUE; // Required field
		$this->hsn_code->Sortable = FALSE; // Allow sort
		$this->fields['hsn_code'] = &$this->hsn_code;

		// quantity
		$this->quantity = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// despatch_date
		$this->despatch_date = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Required = TRUE; // Required field
		$this->despatch_date->Sortable = FALSE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// pkt_quantity
		$this->pkt_quantity = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_pkt_quantity', 'pkt_quantity', '`pkt_quantity`', '`pkt_quantity`', 131, -1, FALSE, '`pkt_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pkt_quantity->Required = TRUE; // Required field
		$this->pkt_quantity->Sortable = FALSE; // Allow sort
		$this->pkt_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pkt_quantity'] = &$this->pkt_quantity;

		// multiprice_id
		$this->multiprice_id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_multiprice_id', 'multiprice_id', '`multiprice_id`', '`multiprice_id`', 18, -1, FALSE, '`multiprice_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->multiprice_id->Required = TRUE; // Required field
		$this->multiprice_id->Sortable = FALSE; // Allow sort
		$this->multiprice_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['multiprice_id'] = &$this->multiprice_id;

		// price
		$this->price = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Nullable = FALSE; // NOT NULL field
		$this->price->Required = TRUE; // Required field
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// currency
		$this->currency = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Nullable = FALSE; // NOT NULL field
		$this->currency->Required = TRUE; // Required field
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// discount_price
		$this->discount_price = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_discount_price', 'discount_price', '`discount_price`', '`discount_price`', 5, -1, FALSE, '`discount_price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->discount_price->Nullable = FALSE; // NOT NULL field
		$this->discount_price->Required = TRUE; // Required field
		$this->discount_price->Sortable = FALSE; // Allow sort
		$this->discount_price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['discount_price'] = &$this->discount_price;

		// amount
		$this->amount = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// cart_amount
		$this->cart_amount = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_cart_amount', 'cart_amount', '`cart_amount`', '`cart_amount`', 4, -1, FALSE, '`cart_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_amount->Sortable = FALSE; // Allow sort
		$this->cart_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cart_amount'] = &$this->cart_amount;

		// label
		$this->label = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_label', 'label', '`label`', '`label`', 200, -1, FALSE, '`label`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->label->Sortable = FALSE; // Allow sort
		$this->fields['label'] = &$this->label;

		// cbm
		$this->cbm = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 131, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cbm'] = &$this->cbm;

		// sqm
		$this->sqm = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// sqm_u
		$this->sqm_u = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_sqm_u', 'sqm_u', '`sqm_u`', '`sqm_u`', 200, -1, FALSE, '`sqm_u`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_u->Sortable = FALSE; // Allow sort
		$this->fields['sqm_u'] = &$this->sqm_u;

		// tax
		$this->tax = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_tax', 'tax', '`tax`', '`tax`', 4, -1, FALSE, '`tax`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tax->Required = TRUE; // Required field
		$this->tax->Sortable = FALSE; // Allow sort
		$this->tax->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tax'] = &$this->tax;

		// tax_amount
		$this->tax_amount = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_tax_amount', 'tax_amount', '`tax_amount`', '`tax_amount`', 131, -1, FALSE, '`tax_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tax_amount->Required = TRUE; // Required field
		$this->tax_amount->Sortable = FALSE; // Allow sort
		$this->tax_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tax_amount'] = &$this->tax_amount;

		// shipping_method
		$this->shipping_method = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_shipping_method', 'shipping_method', '`shipping_method`', '`shipping_method`', 17, -1, FALSE, '`shipping_method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_method->Required = TRUE; // Required field
		$this->shipping_method->Sortable = FALSE; // Allow sort
		$this->shipping_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shipping_method'] = &$this->shipping_method;

		// shipping_local
		$this->shipping_local = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_shipping_local', 'shipping_local', '`shipping_local`', '`shipping_local`', 2, -1, FALSE, '`shipping_local`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_local->Required = TRUE; // Required field
		$this->shipping_local->Sortable = FALSE; // Allow sort
		$this->shipping_local->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shipping_local'] = &$this->shipping_local;

		// shipping_abroad
		$this->shipping_abroad = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_shipping_abroad', 'shipping_abroad', '`shipping_abroad`', '`shipping_abroad`', 5, -1, FALSE, '`shipping_abroad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_abroad->Required = TRUE; // Required field
		$this->shipping_abroad->Sortable = FALSE; // Allow sort
		$this->shipping_abroad->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['shipping_abroad'] = &$this->shipping_abroad;

		// shipping_charge
		$this->shipping_charge = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_shipping_charge', 'shipping_charge', '`shipping_charge`', '`shipping_charge`', 5, -1, FALSE, '`shipping_charge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_charge->Sortable = FALSE; // Allow sort
		$this->shipping_charge->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['shipping_charge'] = &$this->shipping_charge;

		// additional_discount
		$this->additional_discount = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_additional_discount', 'additional_discount', '`additional_discount`', '`additional_discount`', 131, -1, FALSE, '`additional_discount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->additional_discount->Required = TRUE; // Required field
		$this->additional_discount->Sortable = FALSE; // Allow sort
		$this->additional_discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['additional_discount'] = &$this->additional_discount;

		// total_amount
		$this->total_amount = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_total_amount', 'total_amount', '`total_amount`', '`total_amount`', 131, -1, FALSE, '`total_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->total_amount->Required = TRUE; // Required field
		$this->total_amount->Sortable = FALSE; // Allow sort
		$this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['total_amount'] = &$this->total_amount;

		// status
		$this->status = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_status', 'status', '`status`', '`status`', 16, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = FALSE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'product_cart_b_wbc', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 8;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// remarks
		$this->remarks = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// image
		$this->image = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_image', 'image', '`image`', '`image`', 200, -1, FALSE, '`image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->image->Sortable = FALSE; // Allow sort
		$this->fields['image'] = &$this->image;

		// buyer_uid
		$this->buyer_uid = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_buyer_uid', 'buyer_uid', '`buyer_uid`', '`buyer_uid`', 201, -1, FALSE, '`buyer_uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->buyer_uid->Sortable = FALSE; // Allow sort
		$this->fields['buyer_uid'] = &$this->buyer_uid;

		// buyer_loc
		$this->buyer_loc = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_buyer_loc', 'buyer_loc', '`buyer_loc`', '`buyer_loc`', 200, -1, FALSE, '`buyer_loc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->buyer_loc->Sortable = FALSE; // Allow sort
		$this->fields['buyer_loc'] = &$this->buyer_loc;

		// operator
		$this->operator = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// o_datetime
		$this->o_datetime = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_o_datetime', 'o_datetime', '`o_datetime`', CastDateFieldForLike('`o_datetime`', 0, "DB"), 135, 0, FALSE, '`o_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->o_datetime->Required = TRUE; // Required field
		$this->o_datetime->Sortable = FALSE; // Allow sort
		$this->o_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['o_datetime'] = &$this->o_datetime;

		// datetime
		$this->datetime = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 7, "DB"), 135, 7, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// q_sku
		$this->q_sku = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_q_sku', 'q_sku', '`q_sku`', '`q_sku`', 131, -1, FALSE, '`q_sku`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->q_sku->Sortable = FALSE; // Allow sort
		$this->q_sku->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['q_sku'] = &$this->q_sku;

		// w
		$this->w = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_w', 'w', '`w`', '`w`', 200, -1, FALSE, '`w`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w->Sortable = FALSE; // Allow sort
		$this->fields['w'] = &$this->w;

		// l
		$this->l = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_l', 'l', '`l`', '`l`', 200, -1, FALSE, '`l`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l->Sortable = FALSE; // Allow sort
		$this->fields['l'] = &$this->l;

		// h
		$this->h = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_h', 'h', '`h`', '`h`', 200, -1, FALSE, '`h`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->h->Sortable = FALSE; // Allow sort
		$this->fields['h'] = &$this->h;

		// w_cm
		$this->w_cm = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 4, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Sortable = FALSE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['w_cm'] = &$this->w_cm;

		// l_cm
		$this->l_cm = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_l_cm', 'l_cm', '`l_cm`', '`l_cm`', 4, -1, FALSE, '`l_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l_cm->Sortable = FALSE; // Allow sort
		$this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['l_cm'] = &$this->l_cm;

		// h_cm
		$this->h_cm = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_h_cm', 'h_cm', '`h_cm`', '`h_cm`', 4, -1, FALSE, '`h_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->h_cm->Sortable = FALSE; // Allow sort
		$this->h_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['h_cm'] = &$this->h_cm;

		// c_total
		$this->c_total = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_c_total', 'c_total', '`c_total`', '`c_total`', 2, -1, FALSE, '`c_total`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->c_total->Sortable = FALSE; // Allow sort
		$this->c_total->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['c_total'] = &$this->c_total;

		// 1
		$this->_1 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__1', '1', '`1`', '`1`', 200, -1, FALSE, '`1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_1->Sortable = FALSE; // Allow sort
		$this->fields['1'] = &$this->_1;

		// 2
		$this->_2 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__2', '2', '`2`', '`2`', 200, -1, FALSE, '`2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2->Sortable = FALSE; // Allow sort
		$this->fields['2'] = &$this->_2;

		// 3
		$this->_3 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__3', '3', '`3`', '`3`', 200, -1, FALSE, '`3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_3->Sortable = FALSE; // Allow sort
		$this->fields['3'] = &$this->_3;

		// 4
		$this->_4 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__4', '4', '`4`', '`4`', 200, -1, FALSE, '`4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4->Sortable = FALSE; // Allow sort
		$this->fields['4'] = &$this->_4;

		// 5
		$this->_5 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__5', '5', '`5`', '`5`', 200, -1, FALSE, '`5`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_5->Sortable = FALSE; // Allow sort
		$this->fields['5'] = &$this->_5;

		// 6
		$this->_6 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__6', '6', '`6`', '`6`', 200, -1, FALSE, '`6`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_6->Sortable = FALSE; // Allow sort
		$this->fields['6'] = &$this->_6;

		// 7
		$this->_7 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__7', '7', '`7`', '`7`', 200, -1, FALSE, '`7`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_7->Sortable = FALSE; // Allow sort
		$this->fields['7'] = &$this->_7;

		// 8
		$this->_8 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__8', '8', '`8`', '`8`', 200, -1, FALSE, '`8`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_8->Sortable = FALSE; // Allow sort
		$this->fields['8'] = &$this->_8;

		// 9
		$this->_9 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__9', '9', '`9`', '`9`', 200, -1, FALSE, '`9`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_9->Sortable = FALSE; // Allow sort
		$this->fields['9'] = &$this->_9;

		// 10
		$this->_10 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__10', '10', '`10`', '`10`', 200, -1, FALSE, '`10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_10->Sortable = FALSE; // Allow sort
		$this->fields['10'] = &$this->_10;

		// 11
		$this->_11 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__11', '11', '`11`', '`11`', 200, -1, FALSE, '`11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_11->Sortable = FALSE; // Allow sort
		$this->fields['11'] = &$this->_11;

		// 12
		$this->_12 = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x__12', '12', '`12`', '`12`', 200, -1, FALSE, '`12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_12->Sortable = FALSE; // Allow sort
		$this->fields['12'] = &$this->_12;

		// r_text
		$this->r_text = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_r_text', 'r_text', '`r_text`', '`r_text`', 201, -1, FALSE, '`r_text`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->r_text->Sortable = FALSE; // Allow sort
		$this->fields['r_text'] = &$this->r_text;

		// t_id
		$this->t_id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_t_id', 't_id', '`t_id`', '`t_id`', 3, -1, FALSE, '`t_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_id->Sortable = FALSE; // Allow sort
		$this->t_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['t_id'] = &$this->t_id;

		// m_out_id
		$this->m_out_id = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_m_out_id', 'm_out_id', '`m_out_id`', '`m_out_id`', 201, -1, FALSE, '`m_out_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->m_out_id->Sortable = FALSE; // Allow sort
		$this->fields['m_out_id'] = &$this->m_out_id;

		// pam_qty
		$this->pam_qty = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_pam_qty', 'pam_qty', '`pam_qty`', '`pam_qty`', 131, -1, FALSE, '`pam_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pam_qty->Sortable = FALSE; // Allow sort
		$this->pam_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pam_qty'] = &$this->pam_qty;

		// grp_type
		$this->grp_type = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_grp_type', 'grp_type', '`grp_type`', '`grp_type`', 2, -1, FALSE, '`grp_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp_type->Sortable = FALSE; // Allow sort
		$this->grp_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp_type'] = &$this->grp_type;

		// level
		$this->level = new DbField('product_cart_b_wbc', 'product_cart_b_wbc', 'x_level', 'level', '`level`', '`level`', 2, -1, FALSE, '`level`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->level->Sortable = TRUE; // Allow sort
		$this->level->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['level'] = &$this->level;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`product_cart_b_wbc`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT DISTINCT CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->partner_id) . "',COALESCE(`code`,'')) FROM `production_partner` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `product_cart_b_wbc`.`partner_id` LIMIT 1) AS `EV__partner_id`, (SELECT CONCAT(COALESCE(`partner_ref`, ''),'" . ValueSeparator(1, $this->partner_rid) . "',COALESCE(`barcode`,''),'" . ValueSeparator(2, $this->partner_rid) . "',COALESCE(`partner_code`,'')) FROM `partner_product_ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `product_cart_b_wbc`.`partner_rid` LIMIT 1) AS `EV__partner_rid`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `product_cart_b_wbc`.`rid` LIMIT 1) AS `EV__rid` FROM `product_cart_b_wbc`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`grp_type` = 2" : "`operator` = " . CurrentUserID() ." and `grp_type` = 2") : ("(`company_id` = ".User_Company_ID()." || `operator` = ".CurrentUserID()." || `partner_id` = ".User_Company_ID() . ") and `grp_type` = 2");
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if ($this->partner_rid->AdvancedSearch->SearchValue <> "" ||
			$this->partner_rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_rid->VirtualExpression . " "))
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_order_no->DbValue = $row['partner_order_no'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->location->DbValue = $row['location'];
		$this->cart_id->DbValue = $row['cart_id'];
		$this->po_id->DbValue = $row['po_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->partner_rid->DbValue = $row['partner_rid'];
		$this->partner_code->DbValue = $row['partner_code'];
		$this->product_type->DbValue = $row['product_type'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->unit->DbValue = $row['unit'];
		$this->shape->DbValue = $row['shape'];
		$this->partner_size->DbValue = $row['partner_size'];
		$this->size->DbValue = $row['size'];
		$this->rid_1->DbValue = $row['rid_1'];
		$this->hsn_code->DbValue = $row['hsn_code'];
		$this->quantity->DbValue = $row['quantity'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->pkt_quantity->DbValue = $row['pkt_quantity'];
		$this->multiprice_id->DbValue = $row['multiprice_id'];
		$this->price->DbValue = $row['price'];
		$this->currency->DbValue = $row['currency'];
		$this->discount_price->DbValue = $row['discount_price'];
		$this->amount->DbValue = $row['amount'];
		$this->cart_amount->DbValue = $row['cart_amount'];
		$this->label->DbValue = $row['label'];
		$this->cbm->DbValue = $row['cbm'];
		$this->sqm->DbValue = $row['sqm'];
		$this->sqm_u->DbValue = $row['sqm_u'];
		$this->tax->DbValue = $row['tax'];
		$this->tax_amount->DbValue = $row['tax_amount'];
		$this->shipping_method->DbValue = $row['shipping_method'];
		$this->shipping_local->DbValue = $row['shipping_local'];
		$this->shipping_abroad->DbValue = $row['shipping_abroad'];
		$this->shipping_charge->DbValue = $row['shipping_charge'];
		$this->additional_discount->DbValue = $row['additional_discount'];
		$this->total_amount->DbValue = $row['total_amount'];
		$this->status->DbValue = $row['status'];
		$this->remarks->DbValue = $row['remarks'];
		$this->image->DbValue = $row['image'];
		$this->buyer_uid->DbValue = $row['buyer_uid'];
		$this->buyer_loc->DbValue = $row['buyer_loc'];
		$this->operator->DbValue = $row['operator'];
		$this->o_datetime->DbValue = $row['o_datetime'];
		$this->datetime->DbValue = $row['datetime'];
		$this->q_sku->DbValue = $row['q_sku'];
		$this->w->DbValue = $row['w'];
		$this->l->DbValue = $row['l'];
		$this->h->DbValue = $row['h'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->l_cm->DbValue = $row['l_cm'];
		$this->h_cm->DbValue = $row['h_cm'];
		$this->c_total->DbValue = $row['c_total'];
		$this->_1->DbValue = $row['1'];
		$this->_2->DbValue = $row['2'];
		$this->_3->DbValue = $row['3'];
		$this->_4->DbValue = $row['4'];
		$this->_5->DbValue = $row['5'];
		$this->_6->DbValue = $row['6'];
		$this->_7->DbValue = $row['7'];
		$this->_8->DbValue = $row['8'];
		$this->_9->DbValue = $row['9'];
		$this->_10->DbValue = $row['10'];
		$this->_11->DbValue = $row['11'];
		$this->_12->DbValue = $row['12'];
		$this->r_text->DbValue = $row['r_text'];
		$this->t_id->DbValue = $row['t_id'];
		$this->m_out_id->DbValue = $row['m_out_id'];
		$this->pam_qty->DbValue = $row['pam_qty'];
		$this->grp_type->DbValue = $row['grp_type'];
		$this->level->DbValue = $row['level'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "product_cart_b_wbclist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "product_cart_b_wbcview.php")
			return $Language->phrase("View");
		elseif ($pageName == "product_cart_b_wbcedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "product_cart_b_wbcadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "product_cart_b_wbclist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("product_cart_b_wbcview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("product_cart_b_wbcview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "product_cart_b_wbcadd.php?" . $this->getUrlParm($parm);
		else
			$url = "product_cart_b_wbcadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("product_cart_b_wbcedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("product_cart_b_wbcadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("product_cart_b_wbcdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_order_no->setDbValue($rs->fields('partner_order_no'));
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->location->setDbValue($rs->fields('location'));
		$this->cart_id->setDbValue($rs->fields('cart_id'));
		$this->po_id->setDbValue($rs->fields('po_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->partner_rid->setDbValue($rs->fields('partner_rid'));
		$this->partner_code->setDbValue($rs->fields('partner_code'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->partner_size->setDbValue($rs->fields('partner_size'));
		$this->size->setDbValue($rs->fields('size'));
		$this->rid_1->setDbValue($rs->fields('rid_1'));
		$this->hsn_code->setDbValue($rs->fields('hsn_code'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->pkt_quantity->setDbValue($rs->fields('pkt_quantity'));
		$this->multiprice_id->setDbValue($rs->fields('multiprice_id'));
		$this->price->setDbValue($rs->fields('price'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->discount_price->setDbValue($rs->fields('discount_price'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->cart_amount->setDbValue($rs->fields('cart_amount'));
		$this->label->setDbValue($rs->fields('label'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->sqm_u->setDbValue($rs->fields('sqm_u'));
		$this->tax->setDbValue($rs->fields('tax'));
		$this->tax_amount->setDbValue($rs->fields('tax_amount'));
		$this->shipping_method->setDbValue($rs->fields('shipping_method'));
		$this->shipping_local->setDbValue($rs->fields('shipping_local'));
		$this->shipping_abroad->setDbValue($rs->fields('shipping_abroad'));
		$this->shipping_charge->setDbValue($rs->fields('shipping_charge'));
		$this->additional_discount->setDbValue($rs->fields('additional_discount'));
		$this->total_amount->setDbValue($rs->fields('total_amount'));
		$this->status->setDbValue($rs->fields('status'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->image->setDbValue($rs->fields('image'));
		$this->buyer_uid->setDbValue($rs->fields('buyer_uid'));
		$this->buyer_loc->setDbValue($rs->fields('buyer_loc'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->o_datetime->setDbValue($rs->fields('o_datetime'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->q_sku->setDbValue($rs->fields('q_sku'));
		$this->w->setDbValue($rs->fields('w'));
		$this->l->setDbValue($rs->fields('l'));
		$this->h->setDbValue($rs->fields('h'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->l_cm->setDbValue($rs->fields('l_cm'));
		$this->h_cm->setDbValue($rs->fields('h_cm'));
		$this->c_total->setDbValue($rs->fields('c_total'));
		$this->_1->setDbValue($rs->fields('1'));
		$this->_2->setDbValue($rs->fields('2'));
		$this->_3->setDbValue($rs->fields('3'));
		$this->_4->setDbValue($rs->fields('4'));
		$this->_5->setDbValue($rs->fields('5'));
		$this->_6->setDbValue($rs->fields('6'));
		$this->_7->setDbValue($rs->fields('7'));
		$this->_8->setDbValue($rs->fields('8'));
		$this->_9->setDbValue($rs->fields('9'));
		$this->_10->setDbValue($rs->fields('10'));
		$this->_11->setDbValue($rs->fields('11'));
		$this->_12->setDbValue($rs->fields('12'));
		$this->r_text->setDbValue($rs->fields('r_text'));
		$this->t_id->setDbValue($rs->fields('t_id'));
		$this->m_out_id->setDbValue($rs->fields('m_out_id'));
		$this->pam_qty->setDbValue($rs->fields('pam_qty'));
		$this->grp_type->setDbValue($rs->fields('grp_type'));
		$this->level->setDbValue($rs->fields('level'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// company_id
		// partner_order_no
		// reports_to

		$this->reports_to->CellCssStyle = "white-space: nowrap;";

		// location
		// cart_id

		$this->cart_id->CellCssStyle = "white-space: nowrap;";

		// po_id
		// partner_id
		// partner_rid
		// partner_code
		// product_type
		// grp
		// s_grp
		// product
		// rid
		// packing_type
		// batch_no
		// unit

		$this->unit->CellCssStyle = "white-space: nowrap;";

		// shape
		$this->shape->CellCssStyle = "white-space: nowrap;";

		// partner_size
		$this->partner_size->CellCssStyle = "white-space: nowrap;";

		// size
		$this->size->CellCssStyle = "white-space: nowrap;";

		// rid_1
		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// hsn_code
		$this->hsn_code->CellCssStyle = "white-space: nowrap;";

		// quantity
		// despatch_date

		$this->despatch_date->CellCssStyle = "white-space: nowrap;";

		// pkt_quantity
		$this->pkt_quantity->CellCssStyle = "white-space: nowrap;";

		// multiprice_id
		$this->multiprice_id->CellCssStyle = "white-space: nowrap;";

		// price
		// currency
		// discount_price

		$this->discount_price->CellCssStyle = "white-space: nowrap;";

		// amount
		$this->amount->CellCssStyle = "white-space: nowrap;";

		// cart_amount
		$this->cart_amount->CellCssStyle = "white-space: nowrap;";

		// label
		$this->label->CellCssStyle = "white-space: nowrap;";

		// cbm
		// sqm
		// sqm_u

		$this->sqm_u->CellCssStyle = "white-space: nowrap;";

		// tax
		$this->tax->CellCssStyle = "white-space: nowrap;";

		// tax_amount
		$this->tax_amount->CellCssStyle = "white-space: nowrap;";

		// shipping_method
		$this->shipping_method->CellCssStyle = "white-space: nowrap;";

		// shipping_local
		$this->shipping_local->CellCssStyle = "white-space: nowrap;";

		// shipping_abroad
		$this->shipping_abroad->CellCssStyle = "white-space: nowrap;";

		// shipping_charge
		$this->shipping_charge->CellCssStyle = "white-space: nowrap;";

		// additional_discount
		$this->additional_discount->CellCssStyle = "white-space: nowrap;";

		// total_amount
		$this->total_amount->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// remarks
		// image

		$this->image->CellCssStyle = "white-space: nowrap;";

		// buyer_uid
		$this->buyer_uid->CellCssStyle = "white-space: nowrap;";

		// buyer_loc
		$this->buyer_loc->CellCssStyle = "white-space: nowrap;";

		// operator
		// o_datetime

		$this->o_datetime->CellCssStyle = "white-space: nowrap;";

		// datetime
		// q_sku

		$this->q_sku->CellCssStyle = "white-space: nowrap;";

		// w
		$this->w->CellCssStyle = "white-space: nowrap;";

		// l
		$this->l->CellCssStyle = "white-space: nowrap;";

		// h
		$this->h->CellCssStyle = "white-space: nowrap;";

		// w_cm
		$this->w_cm->CellCssStyle = "white-space: nowrap;";

		// l_cm
		$this->l_cm->CellCssStyle = "white-space: nowrap;";

		// h_cm
		$this->h_cm->CellCssStyle = "white-space: nowrap;";

		// c_total
		$this->c_total->CellCssStyle = "white-space: nowrap;";

		// 1
		$this->_1->CellCssStyle = "white-space: nowrap;";

		// 2
		$this->_2->CellCssStyle = "white-space: nowrap;";

		// 3
		$this->_3->CellCssStyle = "white-space: nowrap;";

		// 4
		$this->_4->CellCssStyle = "white-space: nowrap;";

		// 5
		$this->_5->CellCssStyle = "white-space: nowrap;";

		// 6
		$this->_6->CellCssStyle = "white-space: nowrap;";

		// 7
		$this->_7->CellCssStyle = "white-space: nowrap;";

		// 8
		$this->_8->CellCssStyle = "white-space: nowrap;";

		// 9
		$this->_9->CellCssStyle = "white-space: nowrap;";

		// 10
		$this->_10->CellCssStyle = "white-space: nowrap;";

		// 11
		$this->_11->CellCssStyle = "white-space: nowrap;";

		// 12
		$this->_12->CellCssStyle = "white-space: nowrap;";

		// r_text
		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// t_id
		$this->t_id->CellCssStyle = "white-space: nowrap;";

		// m_out_id
		$this->m_out_id->CellCssStyle = "white-space: nowrap;";

		// pam_qty
		$this->pam_qty->CellCssStyle = "white-space: nowrap;";

		// grp_type
		$this->grp_type->CellCssStyle = "white-space: nowrap;";

		// level
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_order_no
		$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->ViewCustomAttributes = "";

		// reports_to
		$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
		$this->reports_to->ViewValue = FormatNumber($this->reports_to->ViewValue, 0, -2, -2, -2);
		$this->reports_to->ViewCustomAttributes = "";

		// location
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
		 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
		 : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// cart_id
		$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
		$this->cart_id->ViewValue = FormatNumber($this->cart_id->ViewValue, 0, -2, -2, -2);
		$this->cart_id->ViewCustomAttributes = "";

		// po_id
		$curVal = strval($this->po_id->CurrentValue);
		if ($curVal <> "") {
			$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
			if ($this->po_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po_id->ViewValue = $this->po_id->CurrentValue;
				}
			}
		} else {
			$this->po_id->ViewValue = NULL;
		}
		$this->po_id->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// partner_rid
		if ($this->partner_rid->VirtualValue <> "") {
			$this->partner_rid->ViewValue = $this->partner_rid->VirtualValue;
		} else {
			$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
		$curVal = strval($this->partner_rid->CurrentValue);
		if ($curVal <> "") {
			$this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
			if ($this->partner_rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
				}
			}
		} else {
			$this->partner_rid->ViewValue = NULL;
		}
		}
		$this->partner_rid->ViewCustomAttributes = "";

		// partner_code
		$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
		$this->partner_code->ViewCustomAttributes = "";

		// product_type
		$curVal = strval($this->product_type->CurrentValue);
		if ($curVal <> "") {
			$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			if ($this->product_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_type->ViewValue = $this->product_type->CurrentValue;
				}
			}
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and type = 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
			$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// unit
		if (strval($this->unit->CurrentValue) <> "") {
			$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->ViewValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// partner_size
		$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
		$this->partner_size->ViewCustomAttributes = "";

		// size
		$this->size->ViewValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
		$this->rid_1->ViewCustomAttributes = "";

		// hsn_code
		$this->hsn_code->ViewValue = $this->hsn_code->CurrentValue;
		$this->hsn_code->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
		$this->quantity->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// pkt_quantity
		$this->pkt_quantity->ViewValue = $this->pkt_quantity->CurrentValue;
		$this->pkt_quantity->ViewValue = FormatNumber($this->pkt_quantity->ViewValue, 2, -2, -2, -2);
		$this->pkt_quantity->ViewCustomAttributes = "";

		// multiprice_id
		$this->multiprice_id->ViewValue = $this->multiprice_id->CurrentValue;
		$this->multiprice_id->ViewValue = FormatNumber($this->multiprice_id->ViewValue, 0, -2, -2, -2);
		$this->multiprice_id->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, 0);
		$this->price->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// discount_price
		$this->discount_price->ViewValue = $this->discount_price->CurrentValue;
		$this->discount_price->ViewValue = FormatNumber($this->discount_price->ViewValue, 2, -2, -2, -2);
		$this->discount_price->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, 0);
		$this->amount->ViewCustomAttributes = "";

		// cart_amount
		$this->cart_amount->ViewValue = $this->cart_amount->CurrentValue;
		$this->cart_amount->ViewValue = FormatNumber($this->cart_amount->ViewValue, 2, -2, -2, -2);
		$this->cart_amount->ViewCustomAttributes = "";

		// label
		$this->label->ViewValue = $this->label->CurrentValue;
		$this->label->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
		$this->cbm->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 4, -2, -2, 0);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_u
		$this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
		$this->sqm_u->ViewCustomAttributes = "";

		// tax
		$this->tax->ViewValue = $this->tax->CurrentValue;
		$this->tax->ViewValue = FormatNumber($this->tax->ViewValue, 2, -2, -2, -2);
		$this->tax->ViewCustomAttributes = "";

		// tax_amount
		$this->tax_amount->ViewValue = $this->tax_amount->CurrentValue;
		$this->tax_amount->ViewValue = FormatNumber($this->tax_amount->ViewValue, 2, -2, -2, -2);
		$this->tax_amount->ViewCustomAttributes = "";

		// shipping_method
		$this->shipping_method->ViewValue = $this->shipping_method->CurrentValue;
		$this->shipping_method->ViewValue = FormatNumber($this->shipping_method->ViewValue, 0, -2, -2, -2);
		$this->shipping_method->ViewCustomAttributes = "";

		// shipping_local
		$this->shipping_local->ViewValue = $this->shipping_local->CurrentValue;
		$this->shipping_local->ViewValue = FormatNumber($this->shipping_local->ViewValue, 0, -2, -2, -2);
		$this->shipping_local->ViewCustomAttributes = "";

		// shipping_abroad
		$this->shipping_abroad->ViewValue = $this->shipping_abroad->CurrentValue;
		$this->shipping_abroad->ViewValue = FormatNumber($this->shipping_abroad->ViewValue, 2, -2, -2, -2);
		$this->shipping_abroad->ViewCustomAttributes = "";

		// shipping_charge
		$this->shipping_charge->ViewValue = $this->shipping_charge->CurrentValue;
		$this->shipping_charge->ViewValue = FormatNumber($this->shipping_charge->ViewValue, 2, -2, -2, -2);
		$this->shipping_charge->ViewCustomAttributes = "";

		// additional_discount
		$this->additional_discount->ViewValue = $this->additional_discount->CurrentValue;
		$this->additional_discount->ViewValue = FormatNumber($this->additional_discount->ViewValue, 2, -2, -2, -2);
		$this->additional_discount->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
		$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// image
		$this->image->ViewValue = $this->image->CurrentValue;
		$this->image->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->ViewCustomAttributes = "";

		// buyer_loc
		$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
		$this->buyer_loc->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// o_datetime
		$this->o_datetime->ViewValue = $this->o_datetime->CurrentValue;
		$this->o_datetime->ViewValue = FormatDateTime($this->o_datetime->ViewValue, 0);
		$this->o_datetime->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
		$this->datetime->ViewCustomAttributes = "";

		// q_sku
		$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
		$this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, 2, -2, -2, -2);
		$this->q_sku->ViewCustomAttributes = "";

		// w
		$this->w->ViewValue = $this->w->CurrentValue;
		$this->w->ViewCustomAttributes = "";

		// l
		$this->l->ViewValue = $this->l->CurrentValue;
		$this->l->ViewCustomAttributes = "";

		// h
		$this->h->ViewValue = $this->h->CurrentValue;
		$this->h->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// l_cm
		$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
		$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
		$this->l_cm->ViewCustomAttributes = "";

		// h_cm
		$this->h_cm->ViewValue = $this->h_cm->CurrentValue;
		$this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, 2, -2, -2, -2);
		$this->h_cm->ViewCustomAttributes = "";

		// c_total
		$this->c_total->ViewValue = $this->c_total->CurrentValue;
		$this->c_total->ViewValue = FormatNumber($this->c_total->ViewValue, 0, -2, -2, -2);
		$this->c_total->ViewCustomAttributes = "";

		// 1
		$this->_1->ViewValue = $this->_1->CurrentValue;
		$this->_1->ViewCustomAttributes = "";

		// 2
		$this->_2->ViewValue = $this->_2->CurrentValue;
		$this->_2->ViewCustomAttributes = "";

		// 3
		$this->_3->ViewValue = $this->_3->CurrentValue;
		$this->_3->ViewCustomAttributes = "";

		// 4
		$this->_4->ViewValue = $this->_4->CurrentValue;
		$this->_4->ViewCustomAttributes = "";

		// 5
		$this->_5->ViewValue = $this->_5->CurrentValue;
		$this->_5->ViewCustomAttributes = "";

		// 6
		$this->_6->ViewValue = $this->_6->CurrentValue;
		$this->_6->ViewCustomAttributes = "";

		// 7
		$this->_7->ViewValue = $this->_7->CurrentValue;
		$this->_7->ViewCustomAttributes = "";

		// 8
		$this->_8->ViewValue = $this->_8->CurrentValue;
		$this->_8->ViewCustomAttributes = "";

		// 9
		$this->_9->ViewValue = $this->_9->CurrentValue;
		$this->_9->ViewCustomAttributes = "";

		// 10
		$this->_10->ViewValue = $this->_10->CurrentValue;
		$this->_10->ViewCustomAttributes = "";

		// 11
		$this->_11->ViewValue = $this->_11->CurrentValue;
		$this->_11->ViewCustomAttributes = "";

		// 12
		$this->_12->ViewValue = $this->_12->CurrentValue;
		$this->_12->ViewCustomAttributes = "";

		// r_text
		$this->r_text->ViewValue = $this->r_text->CurrentValue;
		$this->r_text->ViewCustomAttributes = "";

		// t_id
		$this->t_id->ViewValue = $this->t_id->CurrentValue;
		$this->t_id->ViewValue = FormatNumber($this->t_id->ViewValue, 0, -2, -2, -2);
		$this->t_id->ViewCustomAttributes = "";

		// m_out_id
		$this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;
		$this->m_out_id->ViewCustomAttributes = "";

		// pam_qty
		$this->pam_qty->ViewValue = $this->pam_qty->CurrentValue;
		$this->pam_qty->ViewValue = FormatNumber($this->pam_qty->ViewValue, 2, -2, -2, -2);
		$this->pam_qty->ViewCustomAttributes = "";

		// grp_type
		$this->grp_type->ViewValue = $this->grp_type->CurrentValue;
		$this->grp_type->ViewValue = FormatNumber($this->grp_type->ViewValue, 0, -2, -2, -2);
		$this->grp_type->ViewCustomAttributes = "";

		// level
		$this->level->ViewValue = $this->level->CurrentValue;
		$this->level->ViewValue = FormatNumber($this->level->ViewValue, 0, -2, -2, -2);
		$this->level->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_order_no
		$this->partner_order_no->LinkCustomAttributes = "";
		$this->partner_order_no->HrefValue = "";
		$this->partner_order_no->TooltipValue = "";

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// cart_id
		$this->cart_id->LinkCustomAttributes = "";
		$this->cart_id->HrefValue = "";
		$this->cart_id->TooltipValue = "";

		// po_id
		$this->po_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->po_id->CurrentValue)) {
			$this->po_id->HrefValue = "product_cart_blist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
			$this->po_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
		} else {
			$this->po_id->HrefValue = "";
		}
		$this->po_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		$this->partner_id->HrefValue = "";
		$this->partner_id->TooltipValue = "";

		// partner_rid
		$this->partner_rid->LinkCustomAttributes = "";
		$this->partner_rid->HrefValue = "";
		$this->partner_rid->TooltipValue = "";

		// partner_code
		$this->partner_code->LinkCustomAttributes = "";
		$this->partner_code->HrefValue = "";
		$this->partner_code->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		if (!EmptyValue($this->unit->CurrentValue)) {
			$this->unit->HrefValue = "product_cart_blist.php?x_ref=" . $this->unit->CurrentValue; // Add prefix/suffix
			$this->unit->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
		} else {
			$this->unit->HrefValue = "";
		}
		$this->unit->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// partner_size
		$this->partner_size->LinkCustomAttributes = "";
		$this->partner_size->HrefValue = "";
		$this->partner_size->TooltipValue = "";

		// size
		$this->size->LinkCustomAttributes = "";
		$this->size->HrefValue = "";
		$this->size->TooltipValue = "";

		// rid_1
		$this->rid_1->LinkCustomAttributes = "";
		$this->rid_1->HrefValue = "";
		$this->rid_1->TooltipValue = "";

		// hsn_code
		$this->hsn_code->LinkCustomAttributes = "";
		$this->hsn_code->HrefValue = "";
		$this->hsn_code->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// pkt_quantity
		$this->pkt_quantity->LinkCustomAttributes = "";
		$this->pkt_quantity->HrefValue = "";
		$this->pkt_quantity->TooltipValue = "";

		// multiprice_id
		$this->multiprice_id->LinkCustomAttributes = "";
		$this->multiprice_id->HrefValue = "";
		$this->multiprice_id->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// discount_price
		$this->discount_price->LinkCustomAttributes = "";
		$this->discount_price->HrefValue = "";
		$this->discount_price->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// cart_amount
		$this->cart_amount->LinkCustomAttributes = "";
		$this->cart_amount->HrefValue = "";
		$this->cart_amount->TooltipValue = "";

		// label
		$this->label->LinkCustomAttributes = "";
		$this->label->HrefValue = "";
		$this->label->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// sqm_u
		$this->sqm_u->LinkCustomAttributes = "";
		$this->sqm_u->HrefValue = "";
		$this->sqm_u->TooltipValue = "";

		// tax
		$this->tax->LinkCustomAttributes = "";
		$this->tax->HrefValue = "";
		$this->tax->TooltipValue = "";

		// tax_amount
		$this->tax_amount->LinkCustomAttributes = "";
		$this->tax_amount->HrefValue = "";
		$this->tax_amount->TooltipValue = "";

		// shipping_method
		$this->shipping_method->LinkCustomAttributes = "";
		$this->shipping_method->HrefValue = "";
		$this->shipping_method->TooltipValue = "";

		// shipping_local
		$this->shipping_local->LinkCustomAttributes = "";
		$this->shipping_local->HrefValue = "";
		$this->shipping_local->TooltipValue = "";

		// shipping_abroad
		$this->shipping_abroad->LinkCustomAttributes = "";
		$this->shipping_abroad->HrefValue = "";
		$this->shipping_abroad->TooltipValue = "";

		// shipping_charge
		$this->shipping_charge->LinkCustomAttributes = "";
		$this->shipping_charge->HrefValue = "";
		$this->shipping_charge->TooltipValue = "";

		// additional_discount
		$this->additional_discount->LinkCustomAttributes = "";
		$this->additional_discount->HrefValue = "";
		$this->additional_discount->TooltipValue = "";

		// total_amount
		$this->total_amount->LinkCustomAttributes = "";
		$this->total_amount->HrefValue = "";
		$this->total_amount->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->HrefValue = "";
		$this->image->TooltipValue = "";

		// buyer_uid
		$this->buyer_uid->LinkCustomAttributes = "";
		$this->buyer_uid->HrefValue = "";
		$this->buyer_uid->TooltipValue = "";

		// buyer_loc
		$this->buyer_loc->LinkCustomAttributes = "";
		$this->buyer_loc->HrefValue = "";
		$this->buyer_loc->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// o_datetime
		$this->o_datetime->LinkCustomAttributes = "";
		$this->o_datetime->HrefValue = "";
		$this->o_datetime->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// q_sku
		$this->q_sku->LinkCustomAttributes = "";
		$this->q_sku->HrefValue = "";
		$this->q_sku->TooltipValue = "";

		// w
		$this->w->LinkCustomAttributes = "";
		$this->w->HrefValue = "";
		$this->w->TooltipValue = "";

		// l
		$this->l->LinkCustomAttributes = "";
		$this->l->HrefValue = "";
		$this->l->TooltipValue = "";

		// h
		$this->h->LinkCustomAttributes = "";
		$this->h->HrefValue = "";
		$this->h->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// l_cm
		$this->l_cm->LinkCustomAttributes = "";
		$this->l_cm->HrefValue = "";
		$this->l_cm->TooltipValue = "";

		// h_cm
		$this->h_cm->LinkCustomAttributes = "";
		$this->h_cm->HrefValue = "";
		$this->h_cm->TooltipValue = "";

		// c_total
		$this->c_total->LinkCustomAttributes = "";
		$this->c_total->HrefValue = "";
		$this->c_total->TooltipValue = "";

		// 1
		$this->_1->LinkCustomAttributes = "";
		$this->_1->HrefValue = "";
		$this->_1->TooltipValue = "";

		// 2
		$this->_2->LinkCustomAttributes = "";
		$this->_2->HrefValue = "";
		$this->_2->TooltipValue = "";

		// 3
		$this->_3->LinkCustomAttributes = "";
		$this->_3->HrefValue = "";
		$this->_3->TooltipValue = "";

		// 4
		$this->_4->LinkCustomAttributes = "";
		$this->_4->HrefValue = "";
		$this->_4->TooltipValue = "";

		// 5
		$this->_5->LinkCustomAttributes = "";
		$this->_5->HrefValue = "";
		$this->_5->TooltipValue = "";

		// 6
		$this->_6->LinkCustomAttributes = "";
		$this->_6->HrefValue = "";
		$this->_6->TooltipValue = "";

		// 7
		$this->_7->LinkCustomAttributes = "";
		$this->_7->HrefValue = "";
		$this->_7->TooltipValue = "";

		// 8
		$this->_8->LinkCustomAttributes = "";
		$this->_8->HrefValue = "";
		$this->_8->TooltipValue = "";

		// 9
		$this->_9->LinkCustomAttributes = "";
		$this->_9->HrefValue = "";
		$this->_9->TooltipValue = "";

		// 10
		$this->_10->LinkCustomAttributes = "";
		$this->_10->HrefValue = "";
		$this->_10->TooltipValue = "";

		// 11
		$this->_11->LinkCustomAttributes = "";
		$this->_11->HrefValue = "";
		$this->_11->TooltipValue = "";

		// 12
		$this->_12->LinkCustomAttributes = "";
		$this->_12->HrefValue = "";
		$this->_12->TooltipValue = "";

		// r_text
		$this->r_text->LinkCustomAttributes = "";
		$this->r_text->HrefValue = "";
		$this->r_text->TooltipValue = "";

		// t_id
		$this->t_id->LinkCustomAttributes = "";
		$this->t_id->HrefValue = "";
		$this->t_id->TooltipValue = "";

		// m_out_id
		$this->m_out_id->LinkCustomAttributes = "";
		$this->m_out_id->HrefValue = "";
		$this->m_out_id->TooltipValue = "";

		// pam_qty
		$this->pam_qty->LinkCustomAttributes = "";
		$this->pam_qty->HrefValue = "";
		$this->pam_qty->TooltipValue = "";

		// grp_type
		$this->grp_type->LinkCustomAttributes = "";
		$this->grp_type->HrefValue = "";
		$this->grp_type->TooltipValue = "";

		// level
		$this->level->LinkCustomAttributes = "";
		$this->level->HrefValue = "";
		$this->level->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// partner_order_no
		$this->partner_order_no->EditAttrs["class"] = "form-control";
		$this->partner_order_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
		$this->partner_order_no->EditValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";
		$this->reports_to->EditValue = $this->reports_to->CurrentValue;
		$this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";

		// cart_id
		$this->cart_id->EditAttrs["class"] = "form-control";
		$this->cart_id->EditCustomAttributes = "";
		$this->cart_id->EditValue = $this->cart_id->CurrentValue;
		$this->cart_id->PlaceHolder = RemoveHtml($this->cart_id->caption());

		// po_id
		$this->po_id->EditAttrs["class"] = "form-control";
		$this->po_id->EditCustomAttributes = "";
		$curVal = strval($this->po_id->CurrentValue);
		if ($curVal <> "") {
			$this->po_id->EditValue = $this->po_id->lookupCacheOption($curVal);
			if ($this->po_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->po_id->EditValue = $this->po_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po_id->EditValue = $this->po_id->CurrentValue;
				}
			}
		} else {
			$this->po_id->EditValue = NULL;
		}
		$this->po_id->ViewCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

		// partner_rid
		$this->partner_rid->EditAttrs["class"] = "form-control";
		$this->partner_rid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_rid->CurrentValue = HtmlDecode($this->partner_rid->CurrentValue);
		$this->partner_rid->EditValue = $this->partner_rid->CurrentValue;
		$this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

		// partner_code
		$this->partner_code->EditAttrs["class"] = "form-control";
		$this->partner_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
		$this->partner_code->EditValue = $this->partner_code->CurrentValue;
		$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and type = 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->EditValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->EditValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if ($this->rid->VirtualValue <> "") {
			$this->rid->EditValue = $this->rid->VirtualValue;
		} else {
			$this->rid->EditValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$this->unit->EditValue = $this->unit->options(TRUE);

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";

		// partner_size
		$this->partner_size->EditAttrs["class"] = "form-control";
		$this->partner_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
		$this->partner_size->EditValue = $this->partner_size->CurrentValue;
		$this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

		// size
		$this->size->EditAttrs["class"] = "form-control";
		$this->size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
		$this->size->EditValue = $this->size->CurrentValue;
		$this->size->PlaceHolder = RemoveHtml($this->size->caption());

		// rid_1
		$this->rid_1->EditAttrs["class"] = "form-control";
		$this->rid_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rid_1->CurrentValue = HtmlDecode($this->rid_1->CurrentValue);
		$this->rid_1->EditValue = $this->rid_1->CurrentValue;
		$this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

		// hsn_code
		$this->hsn_code->EditAttrs["class"] = "form-control";
		$this->hsn_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->hsn_code->CurrentValue = HtmlDecode($this->hsn_code->CurrentValue);
		$this->hsn_code->EditValue = $this->hsn_code->CurrentValue;
		$this->hsn_code->PlaceHolder = RemoveHtml($this->hsn_code->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, 0);

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// pkt_quantity
		$this->pkt_quantity->EditAttrs["class"] = "form-control";
		$this->pkt_quantity->EditCustomAttributes = "";
		$this->pkt_quantity->EditValue = $this->pkt_quantity->CurrentValue;
		$this->pkt_quantity->PlaceHolder = RemoveHtml($this->pkt_quantity->caption());
		if (strval($this->pkt_quantity->EditValue) <> "" && is_numeric($this->pkt_quantity->EditValue))
			$this->pkt_quantity->EditValue = FormatNumber($this->pkt_quantity->EditValue, -2, -2, -2, -2);

		// multiprice_id
		$this->multiprice_id->EditAttrs["class"] = "form-control";
		$this->multiprice_id->EditCustomAttributes = "";
		$this->multiprice_id->EditValue = $this->multiprice_id->CurrentValue;
		$this->multiprice_id->PlaceHolder = RemoveHtml($this->multiprice_id->caption());

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, 0);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// discount_price
		$this->discount_price->EditAttrs["class"] = "form-control";
		$this->discount_price->EditCustomAttributes = "";
		$this->discount_price->EditValue = $this->discount_price->CurrentValue;
		$this->discount_price->PlaceHolder = RemoveHtml($this->discount_price->caption());
		if (strval($this->discount_price->EditValue) <> "" && is_numeric($this->discount_price->EditValue))
			$this->discount_price->EditValue = FormatNumber($this->discount_price->EditValue, -2, -2, -2, -2);

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = 'ReadOnly';
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, 0);

		// cart_amount
		$this->cart_amount->EditAttrs["class"] = "form-control";
		$this->cart_amount->EditCustomAttributes = "";
		$this->cart_amount->EditValue = $this->cart_amount->CurrentValue;
		$this->cart_amount->PlaceHolder = RemoveHtml($this->cart_amount->caption());
		if (strval($this->cart_amount->EditValue) <> "" && is_numeric($this->cart_amount->EditValue))
			$this->cart_amount->EditValue = FormatNumber($this->cart_amount->EditValue, -2, -2, -2, -2);

		// label
		$this->label->EditAttrs["class"] = "form-control";
		$this->label->EditCustomAttributes = "";
		$this->label->EditValue = $this->label->CurrentValue;
		$this->label->PlaceHolder = RemoveHtml($this->label->caption());

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = "";
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
		if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
			$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = 'tabindex="999"';
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, 0);

		// sqm_u
		$this->sqm_u->EditAttrs["class"] = "form-control";
		$this->sqm_u->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->sqm_u->CurrentValue = HtmlDecode($this->sqm_u->CurrentValue);
		$this->sqm_u->EditValue = $this->sqm_u->CurrentValue;
		$this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());

		// tax
		$this->tax->EditAttrs["class"] = "form-control";
		$this->tax->EditCustomAttributes = "";
		$this->tax->EditValue = $this->tax->CurrentValue;
		$this->tax->PlaceHolder = RemoveHtml($this->tax->caption());
		if (strval($this->tax->EditValue) <> "" && is_numeric($this->tax->EditValue))
			$this->tax->EditValue = FormatNumber($this->tax->EditValue, -2, -2, -2, -2);

		// tax_amount
		$this->tax_amount->EditAttrs["class"] = "form-control";
		$this->tax_amount->EditCustomAttributes = "";
		$this->tax_amount->EditValue = $this->tax_amount->CurrentValue;
		$this->tax_amount->PlaceHolder = RemoveHtml($this->tax_amount->caption());
		if (strval($this->tax_amount->EditValue) <> "" && is_numeric($this->tax_amount->EditValue))
			$this->tax_amount->EditValue = FormatNumber($this->tax_amount->EditValue, -2, -2, -2, -2);

		// shipping_method
		$this->shipping_method->EditAttrs["class"] = "form-control";
		$this->shipping_method->EditCustomAttributes = "";
		$this->shipping_method->EditValue = $this->shipping_method->CurrentValue;
		$this->shipping_method->PlaceHolder = RemoveHtml($this->shipping_method->caption());

		// shipping_local
		$this->shipping_local->EditAttrs["class"] = "form-control";
		$this->shipping_local->EditCustomAttributes = "";
		$this->shipping_local->EditValue = $this->shipping_local->CurrentValue;
		$this->shipping_local->PlaceHolder = RemoveHtml($this->shipping_local->caption());

		// shipping_abroad
		$this->shipping_abroad->EditAttrs["class"] = "form-control";
		$this->shipping_abroad->EditCustomAttributes = "";
		$this->shipping_abroad->EditValue = $this->shipping_abroad->CurrentValue;
		$this->shipping_abroad->PlaceHolder = RemoveHtml($this->shipping_abroad->caption());
		if (strval($this->shipping_abroad->EditValue) <> "" && is_numeric($this->shipping_abroad->EditValue))
			$this->shipping_abroad->EditValue = FormatNumber($this->shipping_abroad->EditValue, -2, -2, -2, -2);

		// shipping_charge
		$this->shipping_charge->EditAttrs["class"] = "form-control";
		$this->shipping_charge->EditCustomAttributes = "";
		$this->shipping_charge->EditValue = $this->shipping_charge->CurrentValue;
		$this->shipping_charge->PlaceHolder = RemoveHtml($this->shipping_charge->caption());
		if (strval($this->shipping_charge->EditValue) <> "" && is_numeric($this->shipping_charge->EditValue))
			$this->shipping_charge->EditValue = FormatNumber($this->shipping_charge->EditValue, -2, -2, -2, -2);

		// additional_discount
		$this->additional_discount->EditAttrs["class"] = "form-control";
		$this->additional_discount->EditCustomAttributes = "";
		$this->additional_discount->EditValue = $this->additional_discount->CurrentValue;
		$this->additional_discount->PlaceHolder = RemoveHtml($this->additional_discount->caption());
		if (strval($this->additional_discount->EditValue) <> "" && is_numeric($this->additional_discount->EditValue))
			$this->additional_discount->EditValue = FormatNumber($this->additional_discount->EditValue, -2, -2, -2, -2);

		// total_amount
		$this->total_amount->EditAttrs["class"] = "form-control";
		$this->total_amount->EditCustomAttributes = "";
		$this->total_amount->EditValue = $this->total_amount->CurrentValue;
		$this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
		if (strval($this->total_amount->EditValue) <> "" && is_numeric($this->total_amount->EditValue))
			$this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, -2, -2, -2, -2);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->image->CurrentValue = HtmlDecode($this->image->CurrentValue);
		$this->image->EditValue = $this->image->CurrentValue;
		$this->image->PlaceHolder = RemoveHtml($this->image->caption());

		// buyer_uid
		$this->buyer_uid->EditAttrs["class"] = "form-control";
		$this->buyer_uid->EditCustomAttributes = "";
		$this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

		// buyer_loc
		$this->buyer_loc->EditAttrs["class"] = "form-control";
		$this->buyer_loc->EditCustomAttributes = "";
		$this->buyer_loc->EditValue = $this->buyer_loc->CurrentValue;
		$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

		// operator
		// o_datetime

		$this->o_datetime->EditAttrs["class"] = "form-control";
		$this->o_datetime->EditCustomAttributes = "";
		$this->o_datetime->EditValue = FormatDateTime($this->o_datetime->CurrentValue, 8);
		$this->o_datetime->PlaceHolder = RemoveHtml($this->o_datetime->caption());

		// datetime
		// q_sku

		$this->q_sku->EditAttrs["class"] = "form-control";
		$this->q_sku->EditCustomAttributes = "";
		$this->q_sku->EditValue = $this->q_sku->CurrentValue;
		$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
		if (strval($this->q_sku->EditValue) <> "" && is_numeric($this->q_sku->EditValue))
			$this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, -2, -2, -2, -2);

		// w
		$this->w->EditAttrs["class"] = "form-control";
		$this->w->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
		$this->w->EditValue = $this->w->CurrentValue;
		$this->w->PlaceHolder = RemoveHtml($this->w->caption());

		// l
		$this->l->EditAttrs["class"] = "form-control";
		$this->l->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
		$this->l->EditValue = $this->l->CurrentValue;
		$this->l->PlaceHolder = RemoveHtml($this->l->caption());

		// h
		$this->h->EditAttrs["class"] = "form-control";
		$this->h->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
		$this->h->EditValue = $this->h->CurrentValue;
		$this->h->PlaceHolder = RemoveHtml($this->h->caption());

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = 'tabindex="999"';
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
		if (strval($this->w_cm->EditValue) <> "" && is_numeric($this->w_cm->EditValue))
			$this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, -2, -2, -2, -2);

		// l_cm
		$this->l_cm->EditAttrs["class"] = "form-control";
		$this->l_cm->EditCustomAttributes = 'tabindex="999"';
		$this->l_cm->EditValue = $this->l_cm->CurrentValue;
		$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
		if (strval($this->l_cm->EditValue) <> "" && is_numeric($this->l_cm->EditValue))
			$this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, -2, -2, -2, -2);

		// h_cm
		$this->h_cm->EditAttrs["class"] = "form-control";
		$this->h_cm->EditCustomAttributes = 'tabindex="999"';
		$this->h_cm->EditValue = $this->h_cm->CurrentValue;
		$this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
		if (strval($this->h_cm->EditValue) <> "" && is_numeric($this->h_cm->EditValue))
			$this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, -2, -2, -2, -2);

		// c_total
		$this->c_total->EditAttrs["class"] = "form-control";
		$this->c_total->EditCustomAttributes = "";
		$this->c_total->EditValue = $this->c_total->CurrentValue;
		$this->c_total->PlaceHolder = RemoveHtml($this->c_total->caption());

		// 1
		$this->_1->EditAttrs["class"] = "form-control";
		$this->_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
		$this->_1->EditValue = $this->_1->CurrentValue;
		$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

		// 2
		$this->_2->EditAttrs["class"] = "form-control";
		$this->_2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
		$this->_2->EditValue = $this->_2->CurrentValue;
		$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

		// 3
		$this->_3->EditAttrs["class"] = "form-control";
		$this->_3->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
		$this->_3->EditValue = $this->_3->CurrentValue;
		$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

		// 4
		$this->_4->EditAttrs["class"] = "form-control";
		$this->_4->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
		$this->_4->EditValue = $this->_4->CurrentValue;
		$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

		// 5
		$this->_5->EditAttrs["class"] = "form-control";
		$this->_5->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
		$this->_5->EditValue = $this->_5->CurrentValue;
		$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

		// 6
		$this->_6->EditAttrs["class"] = "form-control";
		$this->_6->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
		$this->_6->EditValue = $this->_6->CurrentValue;
		$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

		// 7
		$this->_7->EditAttrs["class"] = "form-control";
		$this->_7->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
		$this->_7->EditValue = $this->_7->CurrentValue;
		$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

		// 8
		$this->_8->EditAttrs["class"] = "form-control";
		$this->_8->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
		$this->_8->EditValue = $this->_8->CurrentValue;
		$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

		// 9
		$this->_9->EditAttrs["class"] = "form-control";
		$this->_9->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_9->CurrentValue = HtmlDecode($this->_9->CurrentValue);
		$this->_9->EditValue = $this->_9->CurrentValue;
		$this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

		// 10
		$this->_10->EditAttrs["class"] = "form-control";
		$this->_10->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_10->CurrentValue = HtmlDecode($this->_10->CurrentValue);
		$this->_10->EditValue = $this->_10->CurrentValue;
		$this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

		// 11
		$this->_11->EditAttrs["class"] = "form-control";
		$this->_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_11->CurrentValue = HtmlDecode($this->_11->CurrentValue);
		$this->_11->EditValue = $this->_11->CurrentValue;
		$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

		// 12
		$this->_12->EditAttrs["class"] = "form-control";
		$this->_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_12->CurrentValue = HtmlDecode($this->_12->CurrentValue);
		$this->_12->EditValue = $this->_12->CurrentValue;
		$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

		// r_text
		$this->r_text->EditAttrs["class"] = "form-control";
		$this->r_text->EditCustomAttributes = "";
		$this->r_text->EditValue = $this->r_text->CurrentValue;
		$this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

		// t_id
		$this->t_id->EditAttrs["class"] = "form-control";
		$this->t_id->EditCustomAttributes = "";
		$this->t_id->EditValue = $this->t_id->CurrentValue;
		$this->t_id->PlaceHolder = RemoveHtml($this->t_id->caption());

		// m_out_id
		$this->m_out_id->EditAttrs["class"] = "form-control";
		$this->m_out_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->m_out_id->CurrentValue = HtmlDecode($this->m_out_id->CurrentValue);
		$this->m_out_id->EditValue = $this->m_out_id->CurrentValue;
		$this->m_out_id->PlaceHolder = RemoveHtml($this->m_out_id->caption());

		// pam_qty
		$this->pam_qty->EditAttrs["class"] = "form-control";
		$this->pam_qty->EditCustomAttributes = "";
		$this->pam_qty->EditValue = $this->pam_qty->CurrentValue;
		$this->pam_qty->PlaceHolder = RemoveHtml($this->pam_qty->caption());
		if (strval($this->pam_qty->EditValue) <> "" && is_numeric($this->pam_qty->EditValue))
			$this->pam_qty->EditValue = FormatNumber($this->pam_qty->EditValue, -2, -2, -2, -2);

		// grp_type
		$this->grp_type->EditAttrs["class"] = "form-control";
		$this->grp_type->EditCustomAttributes = "";
		$this->grp_type->EditValue = $this->grp_type->CurrentValue;
		$this->grp_type->PlaceHolder = RemoveHtml($this->grp_type->caption());

		// level
		$this->level->EditAttrs["class"] = "form-control";
		$this->level->EditCustomAttributes = "";
		$this->level->EditValue = $this->level->CurrentValue;
		$this->level->PlaceHolder = RemoveHtml($this->level->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_order_no);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->partner_rid);
					$doc->exportCaption($this->partner_code);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->level);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_order_no);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->partner_rid);
					$doc->exportCaption($this->partner_code);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->level);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_order_no);
						$doc->exportField($this->location);
						$doc->exportField($this->po_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->partner_rid);
						$doc->exportField($this->partner_code);
						$doc->exportField($this->product_type);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->quantity);
						$doc->exportField($this->price);
						$doc->exportField($this->currency);
						$doc->exportField($this->cbm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->level);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_order_no);
						$doc->exportField($this->location);
						$doc->exportField($this->po_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->partner_rid);
						$doc->exportField($this->partner_code);
						$doc->exportField($this->product_type);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->quantity);
						$doc->exportField($this->price);
						$doc->exportField($this->currency);
						$doc->exportField($this->amount);
						$doc->exportField($this->cbm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->level);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->company_id, '');
				$doc->exportAggregate($this->partner_order_no, '');
				$doc->exportAggregate($this->location, '');
				$doc->exportAggregate($this->po_id, '');
				$doc->exportAggregate($this->partner_id, '');
				$doc->exportAggregate($this->partner_rid, '');
				$doc->exportAggregate($this->partner_code, '');
				$doc->exportAggregate($this->product_type, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->s_grp, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->packing_type, '');
				$doc->exportAggregate($this->batch_no, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->price, '');
				$doc->exportAggregate($this->currency, '');
				$doc->exportAggregate($this->amount, '');
				$doc->exportAggregate($this->cbm, '');
				$doc->exportAggregate($this->sqm, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->exportAggregate($this->level, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'product_cart_b_wbc';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'product_cart_b_wbc';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'product_cart_b_wbc';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'product_cart_b_wbc';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>