<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_cart_b_wbc_list extends product_cart_b_wbc
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_cart_b_wbc';

	// Page object name
	public $PageObjName = "product_cart_b_wbc_list";

	// Grid form hidden field names
	public $FormName = "fproduct_cart_b_wbclist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_cart_b_wbc)
		if (!isset($GLOBALS["product_cart_b_wbc"]) || get_class($GLOBALS["product_cart_b_wbc"]) == PROJECT_NAMESPACE . "product_cart_b_wbc") {
			$GLOBALS["product_cart_b_wbc"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["product_cart_b_wbc"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "product_cart_b_wbcadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "product_cart_b_wbcdelete.php";
		$this->MultiUpdateUrl = "product_cart_b_wbcupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_cart_b_wbc');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fproduct_cart_b_wbclistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $product_cart_b_wbc;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_cart_b_wbc);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->company_id->setVisibility();
		$this->partner_order_no->setVisibility();
		$this->reports_to->Visible = FALSE;
		$this->location->Visible = FALSE;
		$this->cart_id->Visible = FALSE;
		$this->po_id->setVisibility();
		$this->partner_id->setVisibility();
		$this->partner_rid->setVisibility();
		$this->partner_code->setVisibility();
		$this->product_type->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->packing_type->setVisibility();
		$this->batch_no->Visible = FALSE;
		$this->unit->Visible = FALSE;
		$this->shape->Visible = FALSE;
		$this->partner_size->Visible = FALSE;
		$this->size->Visible = FALSE;
		$this->rid_1->Visible = FALSE;
		$this->hsn_code->Visible = FALSE;
		$this->quantity->setVisibility();
		$this->despatch_date->Visible = FALSE;
		$this->pkt_quantity->Visible = FALSE;
		$this->multiprice_id->Visible = FALSE;
		$this->price->setVisibility();
		$this->currency->Visible = FALSE;
		$this->discount_price->Visible = FALSE;
		$this->amount->setVisibility();
		$this->cart_amount->Visible = FALSE;
		$this->label->Visible = FALSE;
		$this->cbm->Visible = FALSE;
		$this->sqm->Visible = FALSE;
		$this->sqm_u->Visible = FALSE;
		$this->tax->Visible = FALSE;
		$this->tax_amount->Visible = FALSE;
		$this->shipping_method->Visible = FALSE;
		$this->shipping_local->Visible = FALSE;
		$this->shipping_abroad->Visible = FALSE;
		$this->shipping_charge->Visible = FALSE;
		$this->additional_discount->Visible = FALSE;
		$this->total_amount->Visible = FALSE;
		$this->status->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->buyer_uid->Visible = FALSE;
		$this->buyer_loc->Visible = FALSE;
		$this->operator->setVisibility();
		$this->o_datetime->Visible = FALSE;
		$this->datetime->setVisibility();
		$this->q_sku->Visible = FALSE;
		$this->w->Visible = FALSE;
		$this->l->Visible = FALSE;
		$this->h->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->h_cm->Visible = FALSE;
		$this->c_total->Visible = FALSE;
		$this->_1->Visible = FALSE;
		$this->_2->Visible = FALSE;
		$this->_3->Visible = FALSE;
		$this->_4->Visible = FALSE;
		$this->_5->Visible = FALSE;
		$this->_6->Visible = FALSE;
		$this->_7->Visible = FALSE;
		$this->_8->Visible = FALSE;
		$this->_9->Visible = FALSE;
		$this->_10->Visible = FALSE;
		$this->_11->Visible = FALSE;
		$this->_12->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->t_id->Visible = FALSE;
		$this->m_out_id->Visible = FALSE;
		$this->pam_qty->Visible = FALSE;
		$this->grp_type->Visible = FALSE;
		$this->level->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->po_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->partner_rid);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export selected records
		if ($this->isExport())
			$this->CurrentFilter = $this->buildExportSelectedFilter();

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fproduct_cart_b_wbclistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->partner_order_no->AdvancedSearch->toJson(), ","); // Field partner_order_no
		$filterList = Concat($filterList, $this->location->AdvancedSearch->toJson(), ","); // Field location
		$filterList = Concat($filterList, $this->po_id->AdvancedSearch->toJson(), ","); // Field po_id
		$filterList = Concat($filterList, $this->partner_id->AdvancedSearch->toJson(), ","); // Field partner_id
		$filterList = Concat($filterList, $this->partner_rid->AdvancedSearch->toJson(), ","); // Field partner_rid
		$filterList = Concat($filterList, $this->partner_code->AdvancedSearch->toJson(), ","); // Field partner_code
		$filterList = Concat($filterList, $this->product_type->AdvancedSearch->toJson(), ","); // Field product_type
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
		$filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
		$filterList = Concat($filterList, $this->rid->AdvancedSearch->toJson(), ","); // Field rid
		$filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
		$filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
		$filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
		$filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->w->AdvancedSearch->toJson(), ","); // Field w
		$filterList = Concat($filterList, $this->l->AdvancedSearch->toJson(), ","); // Field l
		$filterList = Concat($filterList, $this->h->AdvancedSearch->toJson(), ","); // Field h
		$filterList = Concat($filterList, $this->w_cm->AdvancedSearch->toJson(), ","); // Field w_cm
		$filterList = Concat($filterList, $this->l_cm->AdvancedSearch->toJson(), ","); // Field l_cm
		$filterList = Concat($filterList, $this->h_cm->AdvancedSearch->toJson(), ","); // Field h_cm
		$filterList = Concat($filterList, $this->level->AdvancedSearch->toJson(), ","); // Field level
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fproduct_cart_b_wbclistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field partner_order_no
		$this->partner_order_no->AdvancedSearch->SearchValue = @$filter["x_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchOperator = @$filter["z_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchCondition = @$filter["v_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchValue2 = @$filter["y_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchOperator2 = @$filter["w_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->save();

		// Field location
		$this->location->AdvancedSearch->SearchValue = @$filter["x_location"];
		$this->location->AdvancedSearch->SearchOperator = @$filter["z_location"];
		$this->location->AdvancedSearch->SearchCondition = @$filter["v_location"];
		$this->location->AdvancedSearch->SearchValue2 = @$filter["y_location"];
		$this->location->AdvancedSearch->SearchOperator2 = @$filter["w_location"];
		$this->location->AdvancedSearch->save();

		// Field po_id
		$this->po_id->AdvancedSearch->SearchValue = @$filter["x_po_id"];
		$this->po_id->AdvancedSearch->SearchOperator = @$filter["z_po_id"];
		$this->po_id->AdvancedSearch->SearchCondition = @$filter["v_po_id"];
		$this->po_id->AdvancedSearch->SearchValue2 = @$filter["y_po_id"];
		$this->po_id->AdvancedSearch->SearchOperator2 = @$filter["w_po_id"];
		$this->po_id->AdvancedSearch->save();

		// Field partner_id
		$this->partner_id->AdvancedSearch->SearchValue = @$filter["x_partner_id"];
		$this->partner_id->AdvancedSearch->SearchOperator = @$filter["z_partner_id"];
		$this->partner_id->AdvancedSearch->SearchCondition = @$filter["v_partner_id"];
		$this->partner_id->AdvancedSearch->SearchValue2 = @$filter["y_partner_id"];
		$this->partner_id->AdvancedSearch->SearchOperator2 = @$filter["w_partner_id"];
		$this->partner_id->AdvancedSearch->save();

		// Field partner_rid
		$this->partner_rid->AdvancedSearch->SearchValue = @$filter["x_partner_rid"];
		$this->partner_rid->AdvancedSearch->SearchOperator = @$filter["z_partner_rid"];
		$this->partner_rid->AdvancedSearch->SearchCondition = @$filter["v_partner_rid"];
		$this->partner_rid->AdvancedSearch->SearchValue2 = @$filter["y_partner_rid"];
		$this->partner_rid->AdvancedSearch->SearchOperator2 = @$filter["w_partner_rid"];
		$this->partner_rid->AdvancedSearch->save();

		// Field partner_code
		$this->partner_code->AdvancedSearch->SearchValue = @$filter["x_partner_code"];
		$this->partner_code->AdvancedSearch->SearchOperator = @$filter["z_partner_code"];
		$this->partner_code->AdvancedSearch->SearchCondition = @$filter["v_partner_code"];
		$this->partner_code->AdvancedSearch->SearchValue2 = @$filter["y_partner_code"];
		$this->partner_code->AdvancedSearch->SearchOperator2 = @$filter["w_partner_code"];
		$this->partner_code->AdvancedSearch->save();

		// Field product_type
		$this->product_type->AdvancedSearch->SearchValue = @$filter["x_product_type"];
		$this->product_type->AdvancedSearch->SearchOperator = @$filter["z_product_type"];
		$this->product_type->AdvancedSearch->SearchCondition = @$filter["v_product_type"];
		$this->product_type->AdvancedSearch->SearchValue2 = @$filter["y_product_type"];
		$this->product_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_type"];
		$this->product_type->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field s_grp
		$this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
		$this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
		$this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
		$this->s_grp->AdvancedSearch->save();

		// Field product
		$this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
		$this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
		$this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
		$this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
		$this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
		$this->product->AdvancedSearch->save();

		// Field rid
		$this->rid->AdvancedSearch->SearchValue = @$filter["x_rid"];
		$this->rid->AdvancedSearch->SearchOperator = @$filter["z_rid"];
		$this->rid->AdvancedSearch->SearchCondition = @$filter["v_rid"];
		$this->rid->AdvancedSearch->SearchValue2 = @$filter["y_rid"];
		$this->rid->AdvancedSearch->SearchOperator2 = @$filter["w_rid"];
		$this->rid->AdvancedSearch->save();

		// Field packing_type
		$this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
		$this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
		$this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
		$this->packing_type->AdvancedSearch->save();

		// Field batch_no
		$this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
		$this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
		$this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
		$this->batch_no->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field price
		$this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
		$this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
		$this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
		$this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
		$this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
		$this->price->AdvancedSearch->save();

		// Field currency
		$this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
		$this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
		$this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
		$this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
		$this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
		$this->currency->AdvancedSearch->save();

		// Field cbm
		$this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
		$this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
		$this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
		$this->cbm->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field w
		$this->w->AdvancedSearch->SearchValue = @$filter["x_w"];
		$this->w->AdvancedSearch->SearchOperator = @$filter["z_w"];
		$this->w->AdvancedSearch->SearchCondition = @$filter["v_w"];
		$this->w->AdvancedSearch->SearchValue2 = @$filter["y_w"];
		$this->w->AdvancedSearch->SearchOperator2 = @$filter["w_w"];
		$this->w->AdvancedSearch->save();

		// Field l
		$this->l->AdvancedSearch->SearchValue = @$filter["x_l"];
		$this->l->AdvancedSearch->SearchOperator = @$filter["z_l"];
		$this->l->AdvancedSearch->SearchCondition = @$filter["v_l"];
		$this->l->AdvancedSearch->SearchValue2 = @$filter["y_l"];
		$this->l->AdvancedSearch->SearchOperator2 = @$filter["w_l"];
		$this->l->AdvancedSearch->save();

		// Field h
		$this->h->AdvancedSearch->SearchValue = @$filter["x_h"];
		$this->h->AdvancedSearch->SearchOperator = @$filter["z_h"];
		$this->h->AdvancedSearch->SearchCondition = @$filter["v_h"];
		$this->h->AdvancedSearch->SearchValue2 = @$filter["y_h"];
		$this->h->AdvancedSearch->SearchOperator2 = @$filter["w_h"];
		$this->h->AdvancedSearch->save();

		// Field w_cm
		$this->w_cm->AdvancedSearch->SearchValue = @$filter["x_w_cm"];
		$this->w_cm->AdvancedSearch->SearchOperator = @$filter["z_w_cm"];
		$this->w_cm->AdvancedSearch->SearchCondition = @$filter["v_w_cm"];
		$this->w_cm->AdvancedSearch->SearchValue2 = @$filter["y_w_cm"];
		$this->w_cm->AdvancedSearch->SearchOperator2 = @$filter["w_w_cm"];
		$this->w_cm->AdvancedSearch->save();

		// Field l_cm
		$this->l_cm->AdvancedSearch->SearchValue = @$filter["x_l_cm"];
		$this->l_cm->AdvancedSearch->SearchOperator = @$filter["z_l_cm"];
		$this->l_cm->AdvancedSearch->SearchCondition = @$filter["v_l_cm"];
		$this->l_cm->AdvancedSearch->SearchValue2 = @$filter["y_l_cm"];
		$this->l_cm->AdvancedSearch->SearchOperator2 = @$filter["w_l_cm"];
		$this->l_cm->AdvancedSearch->save();

		// Field h_cm
		$this->h_cm->AdvancedSearch->SearchValue = @$filter["x_h_cm"];
		$this->h_cm->AdvancedSearch->SearchOperator = @$filter["z_h_cm"];
		$this->h_cm->AdvancedSearch->SearchCondition = @$filter["v_h_cm"];
		$this->h_cm->AdvancedSearch->SearchValue2 = @$filter["y_h_cm"];
		$this->h_cm->AdvancedSearch->SearchOperator2 = @$filter["w_h_cm"];
		$this->h_cm->AdvancedSearch->save();

		// Field level
		$this->level->AdvancedSearch->SearchValue = @$filter["x_level"];
		$this->level->AdvancedSearch->SearchOperator = @$filter["z_level"];
		$this->level->AdvancedSearch->SearchCondition = @$filter["v_level"];
		$this->level->AdvancedSearch->SearchValue2 = @$filter["y_level"];
		$this->level->AdvancedSearch->SearchOperator2 = @$filter["w_level"];
		$this->level->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->partner_order_no, $default, FALSE); // partner_order_no
		$this->buildSearchSql($where, $this->location, $default, FALSE); // location
		$this->buildSearchSql($where, $this->po_id, $default, FALSE); // po_id
		$this->buildSearchSql($where, $this->partner_id, $default, FALSE); // partner_id
		$this->buildSearchSql($where, $this->partner_rid, $default, FALSE); // partner_rid
		$this->buildSearchSql($where, $this->partner_code, $default, FALSE); // partner_code
		$this->buildSearchSql($where, $this->product_type, $default, FALSE); // product_type
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->s_grp, $default, FALSE); // s_grp
		$this->buildSearchSql($where, $this->product, $default, FALSE); // product
		$this->buildSearchSql($where, $this->rid, $default, FALSE); // rid
		$this->buildSearchSql($where, $this->packing_type, $default, FALSE); // packing_type
		$this->buildSearchSql($where, $this->batch_no, $default, FALSE); // batch_no
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->price, $default, FALSE); // price
		$this->buildSearchSql($where, $this->currency, $default, FALSE); // currency
		$this->buildSearchSql($where, $this->cbm, $default, FALSE); // cbm
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->w, $default, FALSE); // w
		$this->buildSearchSql($where, $this->l, $default, FALSE); // l
		$this->buildSearchSql($where, $this->h, $default, FALSE); // h
		$this->buildSearchSql($where, $this->w_cm, $default, FALSE); // w_cm
		$this->buildSearchSql($where, $this->l_cm, $default, FALSE); // l_cm
		$this->buildSearchSql($where, $this->h_cm, $default, FALSE); // h_cm
		$this->buildSearchSql($where, $this->level, $default, FALSE); // level

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->partner_order_no->AdvancedSearch->save(); // partner_order_no
			$this->location->AdvancedSearch->save(); // location
			$this->po_id->AdvancedSearch->save(); // po_id
			$this->partner_id->AdvancedSearch->save(); // partner_id
			$this->partner_rid->AdvancedSearch->save(); // partner_rid
			$this->partner_code->AdvancedSearch->save(); // partner_code
			$this->product_type->AdvancedSearch->save(); // product_type
			$this->grp->AdvancedSearch->save(); // grp
			$this->s_grp->AdvancedSearch->save(); // s_grp
			$this->product->AdvancedSearch->save(); // product
			$this->rid->AdvancedSearch->save(); // rid
			$this->packing_type->AdvancedSearch->save(); // packing_type
			$this->batch_no->AdvancedSearch->save(); // batch_no
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->price->AdvancedSearch->save(); // price
			$this->currency->AdvancedSearch->save(); // currency
			$this->cbm->AdvancedSearch->save(); // cbm
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->w->AdvancedSearch->save(); // w
			$this->l->AdvancedSearch->save(); // l
			$this->h->AdvancedSearch->save(); // h
			$this->w_cm->AdvancedSearch->save(); // w_cm
			$this->l_cm->AdvancedSearch->save(); // l_cm
			$this->h_cm->AdvancedSearch->save(); // h_cm
			$this->level->AdvancedSearch->save(); // level
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->company_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_order_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->reports_to, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->location, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cart_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_rid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->rid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->packing_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->batch_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->quantity, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->price, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->currency, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cbm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sqm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_order_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->location->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_rid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packing_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->batch_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->currency->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->w->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->l->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->h->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->w_cm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->l_cm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->h_cm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->level->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->partner_order_no->AdvancedSearch->unsetSession();
		$this->location->AdvancedSearch->unsetSession();
		$this->po_id->AdvancedSearch->unsetSession();
		$this->partner_id->AdvancedSearch->unsetSession();
		$this->partner_rid->AdvancedSearch->unsetSession();
		$this->partner_code->AdvancedSearch->unsetSession();
		$this->product_type->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->s_grp->AdvancedSearch->unsetSession();
		$this->product->AdvancedSearch->unsetSession();
		$this->rid->AdvancedSearch->unsetSession();
		$this->packing_type->AdvancedSearch->unsetSession();
		$this->batch_no->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->price->AdvancedSearch->unsetSession();
		$this->currency->AdvancedSearch->unsetSession();
		$this->cbm->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->w->AdvancedSearch->unsetSession();
		$this->l->AdvancedSearch->unsetSession();
		$this->h->AdvancedSearch->unsetSession();
		$this->w_cm->AdvancedSearch->unsetSession();
		$this->l_cm->AdvancedSearch->unsetSession();
		$this->h_cm->AdvancedSearch->unsetSession();
		$this->level->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->partner_order_no->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->po_id->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->partner_rid->AdvancedSearch->load();
		$this->partner_code->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->w->AdvancedSearch->load();
		$this->l->AdvancedSearch->load();
		$this->h->AdvancedSearch->load();
		$this->w_cm->AdvancedSearch->load();
		$this->l_cm->AdvancedSearch->load();
		$this->h_cm->AdvancedSearch->load();
		$this->level->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id); // id
			$this->updateSort($this->company_id); // company_id
			$this->updateSort($this->partner_order_no); // partner_order_no
			$this->updateSort($this->po_id); // po_id
			$this->updateSort($this->partner_id); // partner_id
			$this->updateSort($this->partner_rid); // partner_rid
			$this->updateSort($this->partner_code); // partner_code
			$this->updateSort($this->product_type); // product_type
			$this->updateSort($this->grp); // grp
			$this->updateSort($this->s_grp); // s_grp
			$this->updateSort($this->product); // product
			$this->updateSort($this->rid); // rid
			$this->updateSort($this->packing_type); // packing_type
			$this->updateSort($this->quantity); // quantity
			$this->updateSort($this->price); // price
			$this->updateSort($this->amount); // amount
			$this->updateSort($this->status); // status
			$this->updateSort($this->operator); // operator
			$this->updateSort($this->datetime); // datetime
			$this->updateSort($this->level); // level
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->company_id->setSort("");
				$this->partner_order_no->setSort("");
				$this->po_id->setSort("");
				$this->partner_id->setSort("");
				$this->partner_rid->setSort("");
				$this->partner_code->setSort("");
				$this->product_type->setSort("");
				$this->grp->setSort("");
				$this->s_grp->setSort("");
				$this->product->setSort("");
				$this->rid->setSort("");
				$this->packing_type->setSort("");
				$this->quantity->setSort("");
				$this->price->setSort("");
				$this->amount->setSort("");
				$this->status->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->level->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = TRUE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fproduct_cart_b_wbclistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fproduct_cart_b_wbclistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fproduct_cart_b_wbclist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fproduct_cart_b_wbclistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"product_cart_b_wbcsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fproduct_cart_b_wbclistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// partner_order_no
		if (!$this->isAddOrEdit())
			$this->partner_order_no->AdvancedSearch->setSearchValue(Get("x_partner_order_no", Get("partner_order_no", "")));
		if ($this->partner_order_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_order_no->AdvancedSearch->setSearchOperator(Get("z_partner_order_no", ""));

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue(Get("x_location", Get("location", "")));
		if ($this->location->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->location->AdvancedSearch->setSearchOperator(Get("z_location", ""));

		// po_id
		if (!$this->isAddOrEdit())
			$this->po_id->AdvancedSearch->setSearchValue(Get("x_po_id", Get("po_id", "")));
		if ($this->po_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_id->AdvancedSearch->setSearchOperator(Get("z_po_id", ""));

		// partner_id
		if (!$this->isAddOrEdit())
			$this->partner_id->AdvancedSearch->setSearchValue(Get("x_partner_id", Get("partner_id", "")));
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_id->AdvancedSearch->setSearchOperator(Get("z_partner_id", ""));

		// partner_rid
		if (!$this->isAddOrEdit())
			$this->partner_rid->AdvancedSearch->setSearchValue(Get("x_partner_rid", Get("partner_rid", "")));
		if ($this->partner_rid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_rid->AdvancedSearch->setSearchOperator(Get("z_partner_rid", ""));

		// partner_code
		if (!$this->isAddOrEdit())
			$this->partner_code->AdvancedSearch->setSearchValue(Get("x_partner_code", Get("partner_code", "")));
		if ($this->partner_code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_code->AdvancedSearch->setSearchOperator(Get("z_partner_code", ""));

		// product_type
		if (!$this->isAddOrEdit())
			$this->product_type->AdvancedSearch->setSearchValue(Get("x_product_type", Get("product_type", "")));
		if ($this->product_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_type->AdvancedSearch->setSearchOperator(Get("z_product_type", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue(Get("x_s_grp", Get("s_grp", "")));
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_grp->AdvancedSearch->setSearchOperator(Get("z_s_grp", ""));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue(Get("x_product", Get("product", "")));
		if ($this->product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product->AdvancedSearch->setSearchOperator(Get("z_product", ""));

		// rid
		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue(Get("x_rid", Get("rid", "")));
		if ($this->rid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rid->AdvancedSearch->setSearchOperator(Get("z_rid", ""));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue(Get("x_packing_type", Get("packing_type", "")));
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packing_type->AdvancedSearch->setSearchOperator(Get("z_packing_type", ""));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue(Get("x_batch_no", Get("batch_no", "")));
		if ($this->batch_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->batch_no->AdvancedSearch->setSearchOperator(Get("z_batch_no", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue(Get("x_price", Get("price", "")));
		if ($this->price->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price->AdvancedSearch->setSearchOperator(Get("z_price", ""));

		// currency
		if (!$this->isAddOrEdit())
			$this->currency->AdvancedSearch->setSearchValue(Get("x_currency", Get("currency", "")));
		if ($this->currency->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->currency->AdvancedSearch->setSearchOperator(Get("z_currency", ""));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue(Get("x_cbm", Get("cbm", "")));
		if ($this->cbm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cbm->AdvancedSearch->setSearchOperator(Get("z_cbm", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// w
		if (!$this->isAddOrEdit())
			$this->w->AdvancedSearch->setSearchValue(Get("x_w", Get("w", "")));
		if ($this->w->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->w->AdvancedSearch->setSearchOperator(Get("z_w", ""));

		// l
		if (!$this->isAddOrEdit())
			$this->l->AdvancedSearch->setSearchValue(Get("x_l", Get("l", "")));
		if ($this->l->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->l->AdvancedSearch->setSearchOperator(Get("z_l", ""));

		// h
		if (!$this->isAddOrEdit())
			$this->h->AdvancedSearch->setSearchValue(Get("x_h", Get("h", "")));
		if ($this->h->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->h->AdvancedSearch->setSearchOperator(Get("z_h", ""));

		// w_cm
		if (!$this->isAddOrEdit())
			$this->w_cm->AdvancedSearch->setSearchValue(Get("x_w_cm", Get("w_cm", "")));
		if ($this->w_cm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->w_cm->AdvancedSearch->setSearchOperator(Get("z_w_cm", ""));

		// l_cm
		if (!$this->isAddOrEdit())
			$this->l_cm->AdvancedSearch->setSearchValue(Get("x_l_cm", Get("l_cm", "")));
		if ($this->l_cm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->l_cm->AdvancedSearch->setSearchOperator(Get("z_l_cm", ""));

		// h_cm
		if (!$this->isAddOrEdit())
			$this->h_cm->AdvancedSearch->setSearchValue(Get("x_h_cm", Get("h_cm", "")));
		if ($this->h_cm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->h_cm->AdvancedSearch->setSearchOperator(Get("z_h_cm", ""));

		// level
		if (!$this->isAddOrEdit())
			$this->level->AdvancedSearch->setSearchValue(Get("x_level", Get("level", "")));
		if ($this->level->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->level->AdvancedSearch->setSearchOperator(Get("z_level", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_order_no->setDbValue($row['partner_order_no']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->location->setDbValue($row['location']);
		$this->cart_id->setDbValue($row['cart_id']);
		$this->po_id->setDbValue($row['po_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->partner_rid->setDbValue($row['partner_rid']);
		if (array_key_exists('EV__partner_rid', $rs->fields)) {
			$this->partner_rid->VirtualValue = $rs->fields('EV__partner_rid'); // Set up virtual field value
		} else {
			$this->partner_rid->VirtualValue = ""; // Clear value
		}
		$this->partner_code->setDbValue($row['partner_code']);
		$this->product_type->setDbValue($row['product_type']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->packing_type->setDbValue($row['packing_type']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->unit->setDbValue($row['unit']);
		$this->shape->setDbValue($row['shape']);
		$this->partner_size->setDbValue($row['partner_size']);
		$this->size->setDbValue($row['size']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->hsn_code->setDbValue($row['hsn_code']);
		$this->quantity->setDbValue($row['quantity']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->pkt_quantity->setDbValue($row['pkt_quantity']);
		$this->multiprice_id->setDbValue($row['multiprice_id']);
		$this->price->setDbValue($row['price']);
		$this->currency->setDbValue($row['currency']);
		$this->discount_price->setDbValue($row['discount_price']);
		$this->amount->setDbValue($row['amount']);
		$this->cart_amount->setDbValue($row['cart_amount']);
		$this->label->setDbValue($row['label']);
		$this->cbm->setDbValue($row['cbm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->sqm_u->setDbValue($row['sqm_u']);
		$this->tax->setDbValue($row['tax']);
		$this->tax_amount->setDbValue($row['tax_amount']);
		$this->shipping_method->setDbValue($row['shipping_method']);
		$this->shipping_local->setDbValue($row['shipping_local']);
		$this->shipping_abroad->setDbValue($row['shipping_abroad']);
		$this->shipping_charge->setDbValue($row['shipping_charge']);
		$this->additional_discount->setDbValue($row['additional_discount']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->status->setDbValue($row['status']);
		$this->remarks->setDbValue($row['remarks']);
		$this->image->setDbValue($row['image']);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->buyer_loc->setDbValue($row['buyer_loc']);
		$this->operator->setDbValue($row['operator']);
		$this->o_datetime->setDbValue($row['o_datetime']);
		$this->datetime->setDbValue($row['datetime']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->w->setDbValue($row['w']);
		$this->l->setDbValue($row['l']);
		$this->h->setDbValue($row['h']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->h_cm->setDbValue($row['h_cm']);
		$this->c_total->setDbValue($row['c_total']);
		$this->_1->setDbValue($row['1']);
		$this->_2->setDbValue($row['2']);
		$this->_3->setDbValue($row['3']);
		$this->_4->setDbValue($row['4']);
		$this->_5->setDbValue($row['5']);
		$this->_6->setDbValue($row['6']);
		$this->_7->setDbValue($row['7']);
		$this->_8->setDbValue($row['8']);
		$this->_9->setDbValue($row['9']);
		$this->_10->setDbValue($row['10']);
		$this->_11->setDbValue($row['11']);
		$this->_12->setDbValue($row['12']);
		$this->r_text->setDbValue($row['r_text']);
		$this->t_id->setDbValue($row['t_id']);
		$this->m_out_id->setDbValue($row['m_out_id']);
		$this->pam_qty->setDbValue($row['pam_qty']);
		$this->grp_type->setDbValue($row['grp_type']);
		$this->level->setDbValue($row['level']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_order_no'] = NULL;
		$row['reports_to'] = NULL;
		$row['location'] = NULL;
		$row['cart_id'] = NULL;
		$row['po_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['partner_rid'] = NULL;
		$row['partner_code'] = NULL;
		$row['product_type'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['packing_type'] = NULL;
		$row['batch_no'] = NULL;
		$row['unit'] = NULL;
		$row['shape'] = NULL;
		$row['partner_size'] = NULL;
		$row['size'] = NULL;
		$row['rid_1'] = NULL;
		$row['hsn_code'] = NULL;
		$row['quantity'] = NULL;
		$row['despatch_date'] = NULL;
		$row['pkt_quantity'] = NULL;
		$row['multiprice_id'] = NULL;
		$row['price'] = NULL;
		$row['currency'] = NULL;
		$row['discount_price'] = NULL;
		$row['amount'] = NULL;
		$row['cart_amount'] = NULL;
		$row['label'] = NULL;
		$row['cbm'] = NULL;
		$row['sqm'] = NULL;
		$row['sqm_u'] = NULL;
		$row['tax'] = NULL;
		$row['tax_amount'] = NULL;
		$row['shipping_method'] = NULL;
		$row['shipping_local'] = NULL;
		$row['shipping_abroad'] = NULL;
		$row['shipping_charge'] = NULL;
		$row['additional_discount'] = NULL;
		$row['total_amount'] = NULL;
		$row['status'] = NULL;
		$row['remarks'] = NULL;
		$row['image'] = NULL;
		$row['buyer_uid'] = NULL;
		$row['buyer_loc'] = NULL;
		$row['operator'] = NULL;
		$row['o_datetime'] = NULL;
		$row['datetime'] = NULL;
		$row['q_sku'] = NULL;
		$row['w'] = NULL;
		$row['l'] = NULL;
		$row['h'] = NULL;
		$row['w_cm'] = NULL;
		$row['l_cm'] = NULL;
		$row['h_cm'] = NULL;
		$row['c_total'] = NULL;
		$row['1'] = NULL;
		$row['2'] = NULL;
		$row['3'] = NULL;
		$row['4'] = NULL;
		$row['5'] = NULL;
		$row['6'] = NULL;
		$row['7'] = NULL;
		$row['8'] = NULL;
		$row['9'] = NULL;
		$row['10'] = NULL;
		$row['11'] = NULL;
		$row['12'] = NULL;
		$row['r_text'] = NULL;
		$row['t_id'] = NULL;
		$row['m_out_id'] = NULL;
		$row['pam_qty'] = NULL;
		$row['grp_type'] = NULL;
		$row['level'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// company_id
		// partner_order_no
		// reports_to

		$this->reports_to->CellCssStyle = "white-space: nowrap;";

		// location
		// cart_id

		$this->cart_id->CellCssStyle = "white-space: nowrap;";

		// po_id
		// partner_id
		// partner_rid
		// partner_code
		// product_type
		// grp
		// s_grp
		// product
		// rid
		// packing_type
		// batch_no
		// unit

		$this->unit->CellCssStyle = "white-space: nowrap;";

		// shape
		$this->shape->CellCssStyle = "white-space: nowrap;";

		// partner_size
		$this->partner_size->CellCssStyle = "white-space: nowrap;";

		// size
		$this->size->CellCssStyle = "white-space: nowrap;";

		// rid_1
		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// hsn_code
		$this->hsn_code->CellCssStyle = "white-space: nowrap;";

		// quantity
		// despatch_date

		$this->despatch_date->CellCssStyle = "white-space: nowrap;";

		// pkt_quantity
		$this->pkt_quantity->CellCssStyle = "white-space: nowrap;";

		// multiprice_id
		$this->multiprice_id->CellCssStyle = "white-space: nowrap;";

		// price
		// currency
		// discount_price

		$this->discount_price->CellCssStyle = "white-space: nowrap;";

		// amount
		$this->amount->CellCssStyle = "white-space: nowrap;";

		// cart_amount
		$this->cart_amount->CellCssStyle = "white-space: nowrap;";

		// label
		$this->label->CellCssStyle = "white-space: nowrap;";

		// cbm
		// sqm
		// sqm_u

		$this->sqm_u->CellCssStyle = "white-space: nowrap;";

		// tax
		$this->tax->CellCssStyle = "white-space: nowrap;";

		// tax_amount
		$this->tax_amount->CellCssStyle = "white-space: nowrap;";

		// shipping_method
		$this->shipping_method->CellCssStyle = "white-space: nowrap;";

		// shipping_local
		$this->shipping_local->CellCssStyle = "white-space: nowrap;";

		// shipping_abroad
		$this->shipping_abroad->CellCssStyle = "white-space: nowrap;";

		// shipping_charge
		$this->shipping_charge->CellCssStyle = "white-space: nowrap;";

		// additional_discount
		$this->additional_discount->CellCssStyle = "white-space: nowrap;";

		// total_amount
		$this->total_amount->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// remarks
		// image

		$this->image->CellCssStyle = "white-space: nowrap;";

		// buyer_uid
		$this->buyer_uid->CellCssStyle = "white-space: nowrap;";

		// buyer_loc
		$this->buyer_loc->CellCssStyle = "white-space: nowrap;";

		// operator
		// o_datetime

		$this->o_datetime->CellCssStyle = "white-space: nowrap;";

		// datetime
		// q_sku

		$this->q_sku->CellCssStyle = "white-space: nowrap;";

		// w
		$this->w->CellCssStyle = "white-space: nowrap;";

		// l
		$this->l->CellCssStyle = "white-space: nowrap;";

		// h
		$this->h->CellCssStyle = "white-space: nowrap;";

		// w_cm
		$this->w_cm->CellCssStyle = "white-space: nowrap;";

		// l_cm
		$this->l_cm->CellCssStyle = "white-space: nowrap;";

		// h_cm
		$this->h_cm->CellCssStyle = "white-space: nowrap;";

		// c_total
		$this->c_total->CellCssStyle = "white-space: nowrap;";

		// 1
		$this->_1->CellCssStyle = "white-space: nowrap;";

		// 2
		$this->_2->CellCssStyle = "white-space: nowrap;";

		// 3
		$this->_3->CellCssStyle = "white-space: nowrap;";

		// 4
		$this->_4->CellCssStyle = "white-space: nowrap;";

		// 5
		$this->_5->CellCssStyle = "white-space: nowrap;";

		// 6
		$this->_6->CellCssStyle = "white-space: nowrap;";

		// 7
		$this->_7->CellCssStyle = "white-space: nowrap;";

		// 8
		$this->_8->CellCssStyle = "white-space: nowrap;";

		// 9
		$this->_9->CellCssStyle = "white-space: nowrap;";

		// 10
		$this->_10->CellCssStyle = "white-space: nowrap;";

		// 11
		$this->_11->CellCssStyle = "white-space: nowrap;";

		// 12
		$this->_12->CellCssStyle = "white-space: nowrap;";

		// r_text
		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// t_id
		$this->t_id->CellCssStyle = "white-space: nowrap;";

		// m_out_id
		$this->m_out_id->CellCssStyle = "white-space: nowrap;";

		// pam_qty
		$this->pam_qty->CellCssStyle = "white-space: nowrap;";

		// grp_type
		$this->grp_type->CellCssStyle = "white-space: nowrap;";

		// level
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_order_no
			$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
			$this->partner_order_no->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
			 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
			 : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// po_id
			$curVal = strval($this->po_id->CurrentValue);
			if ($curVal <> "") {
				$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
				if ($this->po_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_id->ViewValue = $this->po_id->CurrentValue;
					}
				}
			} else {
				$this->po_id->ViewValue = NULL;
			}
			$this->po_id->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// partner_rid
			if ($this->partner_rid->VirtualValue <> "") {
				$this->partner_rid->ViewValue = $this->partner_rid->VirtualValue;
			} else {
				$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
			$curVal = strval($this->partner_rid->CurrentValue);
			if ($curVal <> "") {
				$this->partner_rid->ViewValue = $this->partner_rid->lookupCacheOption($curVal);
				if ($this->partner_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->partner_rid->ViewValue = $this->partner_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_rid->ViewValue = $this->partner_rid->CurrentValue;
					}
				}
			} else {
				$this->partner_rid->ViewValue = NULL;
			}
			}
			$this->partner_rid->ViewCustomAttributes = "";

			// partner_code
			$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
			$this->partner_code->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and type = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
				$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
			$this->quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, 0);
			$this->price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, 0);
			$this->amount->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 4, -2, -2, 0);
			$this->sqm->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// level
			$this->level->ViewValue = $this->level->CurrentValue;
			$this->level->ViewValue = FormatNumber($this->level->ViewValue, 0, -2, -2, -2);
			$this->level->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";
			$this->partner_order_no->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_order_no->ViewValue = $this->highlightValue($this->partner_order_no);

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->po_id->CurrentValue)) {
				$this->po_id->HrefValue = "product_cart_blist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
				$this->po_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
			} else {
				$this->po_id->HrefValue = "";
			}
			$this->po_id->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_id->ViewValue = $this->highlightValue($this->partner_id);

			// partner_rid
			$this->partner_rid->LinkCustomAttributes = "";
			$this->partner_rid->HrefValue = "";
			$this->partner_rid->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_rid->ViewValue = $this->highlightValue($this->partner_rid);

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";
			$this->partner_code->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_code->ViewValue = $this->highlightValue($this->partner_code);

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";
			if (!$this->isExport())
				$this->grp->ViewValue = $this->highlightValue($this->grp);

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";
			if (!$this->isExport())
				$this->s_grp->ViewValue = $this->highlightValue($this->s_grp);

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";
			if (!$this->isExport())
				$this->product->ViewValue = $this->highlightValue($this->product);

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";
			if (!$this->isExport())
				$this->rid->ViewValue = $this->highlightValue($this->rid);

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->AdvancedSearch->SearchValue);
			$curVal = strval($this->company_id->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// partner_order_no
			$this->partner_order_no->EditAttrs["class"] = "form-control";
			$this->partner_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_order_no->AdvancedSearch->SearchValue = HtmlDecode($this->partner_order_no->AdvancedSearch->SearchValue);
			$this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->AdvancedSearch->SearchValue);
			$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

			// po_id
			$this->po_id->EditAttrs["class"] = "form-control";
			$this->po_id->EditCustomAttributes = "";

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

			// partner_rid
			$this->partner_rid->EditAttrs["class"] = "form-control";
			$this->partner_rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_rid->AdvancedSearch->SearchValue = HtmlDecode($this->partner_rid->AdvancedSearch->SearchValue);
			$this->partner_rid->EditValue = HtmlEncode($this->partner_rid->AdvancedSearch->SearchValue);
			$this->partner_rid->PlaceHolder = RemoveHtml($this->partner_rid->caption());

			// partner_code
			$this->partner_code->EditAttrs["class"] = "form-control";
			$this->partner_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_code->AdvancedSearch->SearchValue = HtmlDecode($this->partner_code->AdvancedSearch->SearchValue);
			$this->partner_code->EditValue = HtmlEncode($this->partner_code->AdvancedSearch->SearchValue);
			$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = HtmlEncode($this->grp->AdvancedSearch->SearchValue);
			$curVal = strval($this->grp->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and type = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = HtmlEncode($this->grp->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->AdvancedSearch->SearchValue);
			$curVal = strval($this->s_grp->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = HtmlEncode($this->s_grp->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->AdvancedSearch->SearchValue);
			$curVal = strval($this->product->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = HtmlEncode($this->product->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rid->AdvancedSearch->SearchValue = HtmlDecode($this->rid->AdvancedSearch->SearchValue);
			$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->AdvancedSearch->SearchValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 7), 7));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// level
			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = HtmlEncode($this->level->AdvancedSearch->SearchValue);
			$this->level->PlaceHolder = RemoveHtml($this->level->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->quantity->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->company_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->company_id->errorMessage());
		}
		if (!CheckInteger($this->grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->grp->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->partner_order_no->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->po_id->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->partner_rid->AdvancedSearch->load();
		$this->partner_code->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->w->AdvancedSearch->load();
		$this->l->AdvancedSearch->load();
		$this->h->AdvancedSearch->load();
		$this->w_cm->AdvancedSearch->load();
		$this->l_cm->AdvancedSearch->load();
		$this->h_cm->AdvancedSearch->load();
		$this->level->AdvancedSearch->load();
	}

	// Build export filter for selected records
	protected function buildExportSelectedFilter()
	{
		global $Language;
		$wrkFilter = "";
		if ($this->isExport())
			$wrkFilter = $this->getFilterFromRecordKeys();
		return $wrkFilter;
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','excel',true,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','excel',false,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','word',true,true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','word',false,true);\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','pdf',true,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','pdf',false,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','html',false,true);\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','xml',false,true);\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','csv',false,true);\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" onclick=\"ew.export(document.fproduct_cart_b_wbclist,'" . CurrentPageName() . "','print',false,true);\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_product_cart_b_wbc\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_product_cart_b_wbc',hdr:ew.language.phrase('ExportToEmailText'),f:document.fproduct_cart_b_wbclist,sel:true" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_location":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ?
 ((User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")") 
 : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_rid":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1 and type = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_location":
							break;
						case "x_po_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_partner_id":
							break;
						case "x_partner_rid":
							break;
						case "x_product_type":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_batch_no":
							break;
						case "x_shape":
							break;
						case "x_currency":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		$CUID = CurrentUserID();	
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'product_cart_b_wbc');
		$item = &$this->OtherOptions['action']->Add("Create Order");
		$item->Body = "<button class=\"btn btn-danger ew-action\" onclick=\"javascript:CreateOrder()\">Create Order From Selected</button>";
		$item->Visible = True;	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		if (($this->po_id->CurrentValue == 0) && ($this->status->CurrentValue == 0))
			{
				$this->ListOptions->Add("Create Order"); 
				$this->ListOptions->Items["Create Order"]->Body = '<a href="po_b_wbcadd.php?CID=' . $this->company_id->CurrentValue . '&PID=' . $this->partner_id->CurrentValue . '&CAID=' .  $this->id->CurrentValue . '" data-original-title ="Create Order"><i data-phrase="Create Order"  class="fa fa-sign-out ew-icon" ></i></a>';
			}
		if (($this->status->CurrentValue == 9) && ($this->t_id->CurrentValue == 0))
			{
				$this->ListOptions->Add("Transfer Order"); 
				$this->ListOptions->Items["Transfer Order"]->Body = '<a href="autoprogramme.php?apcid=7fa732b517cbed14a48843d74526c11a&id=' . $this->id->CurrentValue . '" data-original-title ="Transfer Order"><i data-phrase="Transfer Order"  class="fa fa-retweet ew-icon" ></i></a>';
			}		
		if ($this->status->CurrentValue == 0)
		{
			$this->ListOptions->Items['edit']->Visible=True;
			$this->ListOptions->Items['delete']->Visible=True;
			$this->ListOptions->Items['Create Order']->Visible=True;
		} 
		else if ($this->status->CurrentValue == 1)
		{
			$this->ListOptions->Items['edit']->Visible=True;
			$this->ListOptions->Items['delete']->Visible=True;
			$this->ListOptions->Items['Create Order']->Visible=False;
			$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-hand-paper-o fa-lg"></i>';
		}
		else if ($this->status->CurrentValue > 1)
		{
			$this->ListOptions->Items['edit']->Visible=False;
			$this->ListOptions->Items['delete']->Visible=False;
			$this->ListOptions->Items['Create Order']->Visible=False;
			$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-hand-paper-o fa-lg"></i>';
		}
		if (is_null($this->batch_no->CurrentValue))
				$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-ban fa-lg" style="color:red"></i>';		
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>