<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for product_cart_s_sample
 */
class product_cart_s_sample extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $po_id;
	public $company_id;
	public $partner_id;
	public $product_type;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $rid_1;
	public $_1;
	public $shape;
	public $unit;
	public $w;
	public $w_cm;
	public $l;
	public $l_cm;
	public $h;
	public $h_cm;
	public $partner_size;
	public $sqm;
	public $quantity;
	public $price;
	public $currency;
	public $amount;
	public $_2;
	public $_3;
	public $_4;
	public $_5;
	public $_6;
	public $_7;
	public $_8;
	public $_9;
	public $_10;
	public $_11;
	public $_12;
	public $remarks;
	public $image;
	public $buyer_uid;
	public $status;
	public $operator;
	public $datetime;
	public $r_text;
	public $t_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'product_cart_s_sample';
		$this->TableName = 'product_cart_s_sample';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`product_cart_s_sample`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// po_id
		$this->po_id = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_po_id', 'po_id', '`po_id`', '`po_id`', 18, -1, FALSE, '`po_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_id->Sortable = TRUE; // Allow sort
		$this->po_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_id->Lookup = new Lookup('po_id', 'po_s', FALSE, 'id', ["po","","",""], [], [], [], [], [], [], '`po` ASC', '');
		$this->po_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_id'] = &$this->po_id;

		// company_id
		$this->company_id = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], ["currency"], ["x_currency"], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_id
		$this->partner_id = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`EV__partner_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->partner_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['partner_id'] = &$this->partner_id;

		// product_type
		$this->product_type = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 18, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_type->Nullable = FALSE; // NOT NULL field
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_type->Lookup = new Lookup('product_type', 'product_cart_s_sample', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->product_type->OptionCount = 1;
		$this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_type'] = &$this->product_type;

		// grp
		$this->grp = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', TRUE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_rid', 'rid', '`rid`', '`rid`', 200, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], ["x_product"], [], ["product"], ["x_product"], [], [], '`product_code` ASC', '');
		$this->fields['rid'] = &$this->rid;

		// rid_1
		$this->rid_1 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_rid_1', 'rid_1', '`rid_1`', '`rid_1`', 201, -1, FALSE, '`rid_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->rid_1->Sortable = TRUE; // Allow sort
		$this->fields['rid_1'] = &$this->rid_1;

		// 1
		$this->_1 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__1', '1', '`1`', '`1`', 200, -1, FALSE, '`1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_1->Sortable = FALSE; // Allow sort
		$this->fields['1'] = &$this->_1;

		// shape
		$this->shape = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_shape', 'shape', '`shape`', '`shape`', 16, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Sortable = TRUE; // Allow sort
		$this->shape->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shape->Lookup = new Lookup('shape', 'shape', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shape'] = &$this->shape;

		// unit
		$this->unit = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_unit', 'unit', '`unit`', '`unit`', 18, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Required = TRUE; // Required field
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'product_cart_s_sample', FALSE, '', ["","","",""], [], [], [], [], ["currency"], ["x_currency"], '', '');
		$this->unit->OptionCount = 5;
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// w
		$this->w = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_w', 'w', '`w`', '`w`', 200, -1, FALSE, '`w`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w->Sortable = TRUE; // Allow sort
		$this->fields['w'] = &$this->w;

		// w_cm
		$this->w_cm = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 4, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Sortable = TRUE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['w_cm'] = &$this->w_cm;

		// l
		$this->l = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_l', 'l', '`l`', '`l`', 200, -1, FALSE, '`l`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l->Sortable = TRUE; // Allow sort
		$this->fields['l'] = &$this->l;

		// l_cm
		$this->l_cm = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_l_cm', 'l_cm', '`l_cm`', '`l_cm`', 4, -1, FALSE, '`l_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l_cm->Sortable = TRUE; // Allow sort
		$this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['l_cm'] = &$this->l_cm;

		// h
		$this->h = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_h', 'h', '`h`', '`h`', 200, -1, FALSE, '`h`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->h->Sortable = FALSE; // Allow sort
		$this->fields['h'] = &$this->h;

		// h_cm
		$this->h_cm = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_h_cm', 'h_cm', '`h_cm`', '`h_cm`', 4, -1, FALSE, '`h_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->h_cm->Sortable = FALSE; // Allow sort
		$this->h_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['h_cm'] = &$this->h_cm;

		// partner_size
		$this->partner_size = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_partner_size', 'partner_size', '`partner_size`', '`partner_size`', 200, -1, FALSE, '`partner_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_size->Sortable = TRUE; // Allow sort
		$this->fields['partner_size'] = &$this->partner_size;

		// sqm
		$this->sqm = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// quantity
		$this->quantity = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// price
		$this->price = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Nullable = FALSE; // NOT NULL field
		$this->price->Required = TRUE; // Required field
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// currency
		$this->currency = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Nullable = FALSE; // NOT NULL field
		$this->currency->Required = TRUE; // Required field
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// amount
		$this->amount = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Nullable = FALSE; // NOT NULL field
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = FALSE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// 2
		$this->_2 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__2', '2', '`2`', '`2`', 200, -1, FALSE, '`2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2->Sortable = FALSE; // Allow sort
		$this->fields['2'] = &$this->_2;

		// 3
		$this->_3 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__3', '3', '`3`', '`3`', 200, -1, FALSE, '`3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_3->Sortable = FALSE; // Allow sort
		$this->fields['3'] = &$this->_3;

		// 4
		$this->_4 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__4', '4', '`4`', '`4`', 200, -1, FALSE, '`4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4->Sortable = FALSE; // Allow sort
		$this->fields['4'] = &$this->_4;

		// 5
		$this->_5 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__5', '5', '`5`', '`5`', 200, -1, FALSE, '`5`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_5->Sortable = FALSE; // Allow sort
		$this->fields['5'] = &$this->_5;

		// 6
		$this->_6 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__6', '6', '`6`', '`6`', 200, -1, FALSE, '`6`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_6->Sortable = FALSE; // Allow sort
		$this->fields['6'] = &$this->_6;

		// 7
		$this->_7 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__7', '7', '`7`', '`7`', 200, -1, FALSE, '`7`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_7->Sortable = FALSE; // Allow sort
		$this->fields['7'] = &$this->_7;

		// 8
		$this->_8 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__8', '8', '`8`', '`8`', 200, -1, FALSE, '`8`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_8->Sortable = FALSE; // Allow sort
		$this->fields['8'] = &$this->_8;

		// 9
		$this->_9 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__9', '9', '`9`', '`9`', 200, -1, FALSE, '`9`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_9->Sortable = TRUE; // Allow sort
		$this->fields['9'] = &$this->_9;

		// 10
		$this->_10 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__10', '10', '`10`', '`10`', 200, -1, FALSE, '`10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_10->Sortable = TRUE; // Allow sort
		$this->fields['10'] = &$this->_10;

		// 11
		$this->_11 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__11', '11', '`11`', '`11`', 200, -1, FALSE, '`11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_11->Sortable = TRUE; // Allow sort
		$this->fields['11'] = &$this->_11;

		// 12
		$this->_12 = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x__12', '12', '`12`', '`12`', 200, -1, FALSE, '`12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_12->Sortable = TRUE; // Allow sort
		$this->fields['12'] = &$this->_12;

		// remarks
		$this->remarks = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = FALSE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// image
		$this->image = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_image', 'image', '`image`', '`image`', 200, -1, TRUE, '`image`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->image->Sortable = TRUE; // Allow sort
		$this->image->ImageResize = TRUE;
		$this->image->UploadMultiple = TRUE;
		$this->image->Upload->UploadMultiple = TRUE;
		$this->image->UploadMaxFileCount = 0;
		$this->fields['image'] = &$this->image;

		// buyer_uid
		$this->buyer_uid = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_buyer_uid', 'buyer_uid', '`buyer_uid`', '`buyer_uid`', 201, -1, FALSE, '`buyer_uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->buyer_uid->Sortable = TRUE; // Allow sort
		$this->fields['buyer_uid'] = &$this->buyer_uid;

		// status
		$this->status = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_status', 'status', '`status`', '`status`', 16, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'product_cart_s_sample', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 5;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 7, "DB"), 135, 7, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// r_text
		$this->r_text = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_r_text', 'r_text', '`r_text`', '`r_text`', 201, -1, FALSE, '`r_text`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->r_text->Sortable = FALSE; // Allow sort
		$this->fields['r_text'] = &$this->r_text;

		// t_id
		$this->t_id = new DbField('product_cart_s_sample', 'product_cart_s_sample', 'x_t_id', 't_id', '`t_id`', '`t_id`', 3, -1, FALSE, '`t_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_id->Sortable = FALSE; // Allow sort
		$this->t_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['t_id'] = &$this->t_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`product_cart_s_sample`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `buyer_seller_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `product_cart_s_sample`.`partner_id` LIMIT 1) AS `EV__partner_id` FROM `product_cart_s_sample`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->po_id->DbValue = $row['po_id'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->product_type->DbValue = $row['product_type'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->rid_1->DbValue = $row['rid_1'];
		$this->_1->DbValue = $row['1'];
		$this->shape->DbValue = $row['shape'];
		$this->unit->DbValue = $row['unit'];
		$this->w->DbValue = $row['w'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->l->DbValue = $row['l'];
		$this->l_cm->DbValue = $row['l_cm'];
		$this->h->DbValue = $row['h'];
		$this->h_cm->DbValue = $row['h_cm'];
		$this->partner_size->DbValue = $row['partner_size'];
		$this->sqm->DbValue = $row['sqm'];
		$this->quantity->DbValue = $row['quantity'];
		$this->price->DbValue = $row['price'];
		$this->currency->DbValue = $row['currency'];
		$this->amount->DbValue = $row['amount'];
		$this->_2->DbValue = $row['2'];
		$this->_3->DbValue = $row['3'];
		$this->_4->DbValue = $row['4'];
		$this->_5->DbValue = $row['5'];
		$this->_6->DbValue = $row['6'];
		$this->_7->DbValue = $row['7'];
		$this->_8->DbValue = $row['8'];
		$this->_9->DbValue = $row['9'];
		$this->_10->DbValue = $row['10'];
		$this->_11->DbValue = $row['11'];
		$this->_12->DbValue = $row['12'];
		$this->remarks->DbValue = $row['remarks'];
		$this->image->Upload->DbValue = $row['image'];
		$this->buyer_uid->DbValue = $row['buyer_uid'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->r_text->DbValue = $row['r_text'];
		$this->t_id->DbValue = $row['t_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->image->OldUploadPath = 'product_images/o/sample_cart/';
		$oldFiles = EmptyValue($row['image']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['image']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "product_cart_s_samplelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "product_cart_s_sampleview.php")
			return $Language->phrase("View");
		elseif ($pageName == "product_cart_s_sampleedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "product_cart_s_sampleadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "product_cart_s_samplelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("product_cart_s_sampleview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("product_cart_s_sampleview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "product_cart_s_sampleadd.php?" . $this->getUrlParm($parm);
		else
			$url = "product_cart_s_sampleadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("product_cart_s_sampleedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("product_cart_s_sampleadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("product_cart_s_sampledelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->po_id->setDbValue($rs->fields('po_id'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->rid_1->setDbValue($rs->fields('rid_1'));
		$this->_1->setDbValue($rs->fields('1'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->w->setDbValue($rs->fields('w'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->l->setDbValue($rs->fields('l'));
		$this->l_cm->setDbValue($rs->fields('l_cm'));
		$this->h->setDbValue($rs->fields('h'));
		$this->h_cm->setDbValue($rs->fields('h_cm'));
		$this->partner_size->setDbValue($rs->fields('partner_size'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->price->setDbValue($rs->fields('price'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->_2->setDbValue($rs->fields('2'));
		$this->_3->setDbValue($rs->fields('3'));
		$this->_4->setDbValue($rs->fields('4'));
		$this->_5->setDbValue($rs->fields('5'));
		$this->_6->setDbValue($rs->fields('6'));
		$this->_7->setDbValue($rs->fields('7'));
		$this->_8->setDbValue($rs->fields('8'));
		$this->_9->setDbValue($rs->fields('9'));
		$this->_10->setDbValue($rs->fields('10'));
		$this->_11->setDbValue($rs->fields('11'));
		$this->_12->setDbValue($rs->fields('12'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->image->Upload->DbValue = $rs->fields('image');
		$this->buyer_uid->setDbValue($rs->fields('buyer_uid'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->r_text->setDbValue($rs->fields('r_text'));
		$this->t_id->setDbValue($rs->fields('t_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// po_id
		// company_id
		// partner_id
		// product_type
		// grp
		// s_grp
		// product
		// rid

		$this->rid->CellCssStyle = "white-space: nowrap;";

		// rid_1
		// 1

		$this->_1->CellCssStyle = "white-space: nowrap;";

		// shape
		// unit
		// w
		// w_cm
		// l
		// l_cm
		// h

		$this->h->CellCssStyle = "white-space: nowrap;";

		// h_cm
		$this->h_cm->CellCssStyle = "white-space: nowrap;";

		// partner_size
		// sqm
		// quantity
		// price
		// currency
		// amount

		$this->amount->CellCssStyle = "white-space: nowrap;";

		// 2
		$this->_2->CellCssStyle = "white-space: nowrap;";

		// 3
		$this->_3->CellCssStyle = "white-space: nowrap;";

		// 4
		$this->_4->CellCssStyle = "white-space: nowrap;";

		// 5
		$this->_5->CellCssStyle = "white-space: nowrap;";

		// 6
		$this->_6->CellCssStyle = "white-space: nowrap;";

		// 7
		$this->_7->CellCssStyle = "white-space: nowrap;";

		// 8
		$this->_8->CellCssStyle = "white-space: nowrap;";

		// 9
		// 10
		// 11
		// 12
		// remarks

		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// image
		// buyer_uid
		// status
		// operator
		// datetime
		// r_text

		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// t_id
		$this->t_id->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// po_id
		$curVal = strval($this->po_id->CurrentValue);
		if ($curVal <> "") {
			$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
			if ($this->po_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po_id->ViewValue = $this->po_id->CurrentValue;
				}
			}
		} else {
			$this->po_id->ViewValue = NULL;
		}
		$this->po_id->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1 and `partner_type` = 2 and `id` > 1000" : "((`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 1000 and `partner_type` = 2) or (`id` = 200000))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1 and `partner_type` = 1 and `id` > 0" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 0 and `partner_type` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// product_type
		if (strval($this->product_type->CurrentValue) <> "") {
			$this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
		$this->rid_1->ViewCustomAttributes = "";

		// 1
		$this->_1->ViewValue = $this->_1->CurrentValue;
		$this->_1->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->ViewValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// unit
		if (strval($this->unit->CurrentValue) <> "") {
			$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// w
		$this->w->ViewValue = $this->w->CurrentValue;
		$this->w->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// l
		$this->l->ViewValue = $this->l->CurrentValue;
		$this->l->ViewCustomAttributes = "";

		// l_cm
		$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
		$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
		$this->l_cm->ViewCustomAttributes = "";

		// h
		$this->h->ViewValue = $this->h->CurrentValue;
		$this->h->ViewCustomAttributes = "";

		// h_cm
		$this->h_cm->ViewValue = $this->h_cm->CurrentValue;
		$this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, 2, -2, -2, -2);
		$this->h_cm->ViewCustomAttributes = "";

		// partner_size
		$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
		$this->partner_size->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, 0);
		$this->quantity->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// 2
		$this->_2->ViewValue = $this->_2->CurrentValue;
		$this->_2->ViewCustomAttributes = "";

		// 3
		$this->_3->ViewValue = $this->_3->CurrentValue;
		$this->_3->ViewCustomAttributes = "";

		// 4
		$this->_4->ViewValue = $this->_4->CurrentValue;
		$this->_4->ViewCustomAttributes = "";

		// 5
		$this->_5->ViewValue = $this->_5->CurrentValue;
		$this->_5->ViewCustomAttributes = "";

		// 6
		$this->_6->ViewValue = $this->_6->CurrentValue;
		$this->_6->ViewCustomAttributes = "";

		// 7
		$this->_7->ViewValue = $this->_7->CurrentValue;
		$this->_7->ViewCustomAttributes = "";

		// 8
		$this->_8->ViewValue = $this->_8->CurrentValue;
		$this->_8->ViewCustomAttributes = "";

		// 9
		$this->_9->ViewValue = $this->_9->CurrentValue;
		$this->_9->ViewCustomAttributes = "";

		// 10
		$this->_10->ViewValue = $this->_10->CurrentValue;
		$this->_10->ViewCustomAttributes = "";

		// 11
		$this->_11->ViewValue = $this->_11->CurrentValue;
		$this->_11->ViewCustomAttributes = "";

		// 12
		$this->_12->ViewValue = $this->_12->CurrentValue;
		$this->_12->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// image
		$this->image->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 50;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->ViewValue = $this->image->Upload->DbValue;
		} else {
			$this->image->ViewValue = "";
		}
		$this->image->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
		$this->datetime->ViewCustomAttributes = "";

		// r_text
		$this->r_text->ViewValue = $this->r_text->CurrentValue;
		$this->r_text->ViewCustomAttributes = "";

		// t_id
		$this->t_id->ViewValue = $this->t_id->CurrentValue;
		$this->t_id->ViewValue = FormatNumber($this->t_id->ViewValue, 0, -2, -2, -2);
		$this->t_id->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// po_id
		$this->po_id->LinkCustomAttributes = "";
		$this->po_id->HrefValue = "";
		$this->po_id->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		$this->partner_id->HrefValue = "";
		$this->partner_id->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// rid_1
		$this->rid_1->LinkCustomAttributes = "";
		$this->rid_1->HrefValue = "";
		$this->rid_1->TooltipValue = "";

		// 1
		$this->_1->LinkCustomAttributes = "";
		$this->_1->HrefValue = "";
		$this->_1->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		if (!EmptyValue($this->unit->CurrentValue)) {
			$this->unit->HrefValue = "product_cart_blist.php?x_ref=" . $this->unit->CurrentValue; // Add prefix/suffix
			$this->unit->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
		} else {
			$this->unit->HrefValue = "";
		}
		$this->unit->TooltipValue = "";

		// w
		$this->w->LinkCustomAttributes = "";
		$this->w->HrefValue = "";
		$this->w->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// l
		$this->l->LinkCustomAttributes = "";
		$this->l->HrefValue = "";
		$this->l->TooltipValue = "";

		// l_cm
		$this->l_cm->LinkCustomAttributes = "";
		$this->l_cm->HrefValue = "";
		$this->l_cm->TooltipValue = "";

		// h
		$this->h->LinkCustomAttributes = "";
		$this->h->HrefValue = "";
		$this->h->TooltipValue = "";

		// h_cm
		$this->h_cm->LinkCustomAttributes = "";
		$this->h_cm->HrefValue = "";
		$this->h_cm->TooltipValue = "";

		// partner_size
		$this->partner_size->LinkCustomAttributes = "";
		$this->partner_size->HrefValue = "";
		$this->partner_size->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// 2
		$this->_2->LinkCustomAttributes = "";
		$this->_2->HrefValue = "";
		$this->_2->TooltipValue = "";

		// 3
		$this->_3->LinkCustomAttributes = "";
		$this->_3->HrefValue = "";
		$this->_3->TooltipValue = "";

		// 4
		$this->_4->LinkCustomAttributes = "";
		$this->_4->HrefValue = "";
		$this->_4->TooltipValue = "";

		// 5
		$this->_5->LinkCustomAttributes = "";
		$this->_5->HrefValue = "";
		$this->_5->TooltipValue = "";

		// 6
		$this->_6->LinkCustomAttributes = "";
		$this->_6->HrefValue = "";
		$this->_6->TooltipValue = "";

		// 7
		$this->_7->LinkCustomAttributes = "";
		$this->_7->HrefValue = "";
		$this->_7->TooltipValue = "";

		// 8
		$this->_8->LinkCustomAttributes = "";
		$this->_8->HrefValue = "";
		$this->_8->TooltipValue = "";

		// 9
		$this->_9->LinkCustomAttributes = "";
		$this->_9->HrefValue = "";
		$this->_9->TooltipValue = "";

		// 10
		$this->_10->LinkCustomAttributes = "";
		$this->_10->HrefValue = "";
		$this->_10->TooltipValue = "";

		// 11
		$this->_11->LinkCustomAttributes = "";
		$this->_11->HrefValue = "";
		$this->_11->TooltipValue = "";

		// 12
		$this->_12->LinkCustomAttributes = "";
		$this->_12->HrefValue = "";
		$this->_12->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->HrefValue = "%u"; // Add prefix/suffix
			$this->image->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
		} else {
			$this->image->HrefValue = "";
		}
		$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		$this->image->TooltipValue = "";
		if ($this->image->UseColorbox) {
			if (EmptyValue($this->image->TooltipValue))
				$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->image->LinkAttrs["data-rel"] = "product_cart_s_sample_x_image";
			AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
		}

		// buyer_uid
		$this->buyer_uid->LinkCustomAttributes = "";
		$this->buyer_uid->HrefValue = "";
		$this->buyer_uid->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// r_text
		$this->r_text->LinkCustomAttributes = "";
		$this->r_text->HrefValue = "";
		$this->r_text->TooltipValue = "";

		// t_id
		$this->t_id->LinkCustomAttributes = "";
		$this->t_id->HrefValue = "";
		$this->t_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// po_id
		$this->po_id->EditAttrs["class"] = "form-control";
		$this->po_id->EditCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = 'ReadOnly';
		$this->product_type->EditValue = $this->product_type->options(TRUE);

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";

		// rid_1
		$this->rid_1->EditAttrs["class"] = "form-control";
		$this->rid_1->EditCustomAttributes = "";
		$this->rid_1->EditValue = $this->rid_1->CurrentValue;
		$this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

		// 1
		$this->_1->EditAttrs["class"] = "form-control";
		$this->_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
		$this->_1->EditValue = $this->_1->CurrentValue;
		$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$this->unit->EditValue = $this->unit->options(TRUE);

		// w
		$this->w->EditAttrs["class"] = "form-control";
		$this->w->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
		$this->w->EditValue = $this->w->CurrentValue;
		$this->w->PlaceHolder = RemoveHtml($this->w->caption());

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = 'ReadOnly';
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());
		if (strval($this->w_cm->EditValue) <> "" && is_numeric($this->w_cm->EditValue))
			$this->w_cm->EditValue = FormatNumber($this->w_cm->EditValue, -2, -2, -2, -2);

		// l
		$this->l->EditAttrs["class"] = "form-control";
		$this->l->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
		$this->l->EditValue = $this->l->CurrentValue;
		$this->l->PlaceHolder = RemoveHtml($this->l->caption());

		// l_cm
		$this->l_cm->EditAttrs["class"] = "form-control";
		$this->l_cm->EditCustomAttributes = 'ReadOnly';
		$this->l_cm->EditValue = $this->l_cm->CurrentValue;
		$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());
		if (strval($this->l_cm->EditValue) <> "" && is_numeric($this->l_cm->EditValue))
			$this->l_cm->EditValue = FormatNumber($this->l_cm->EditValue, -2, -2, -2, -2);

		// h
		$this->h->EditAttrs["class"] = "form-control";
		$this->h->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
		$this->h->EditValue = $this->h->CurrentValue;
		$this->h->PlaceHolder = RemoveHtml($this->h->caption());

		// h_cm
		$this->h_cm->EditAttrs["class"] = "form-control";
		$this->h_cm->EditCustomAttributes = 'ReadOnly';
		$this->h_cm->EditValue = $this->h_cm->CurrentValue;
		$this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());
		if (strval($this->h_cm->EditValue) <> "" && is_numeric($this->h_cm->EditValue))
			$this->h_cm->EditValue = FormatNumber($this->h_cm->EditValue, -2, -2, -2, -2);

		// partner_size
		$this->partner_size->EditAttrs["class"] = "form-control";
		$this->partner_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
		$this->partner_size->EditValue = $this->partner_size->CurrentValue;
		$this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = 'ReadOnly';
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, 0);

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = 'ReadOnly';
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// 2
		$this->_2->EditAttrs["class"] = "form-control";
		$this->_2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
		$this->_2->EditValue = $this->_2->CurrentValue;
		$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

		// 3
		$this->_3->EditAttrs["class"] = "form-control";
		$this->_3->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
		$this->_3->EditValue = $this->_3->CurrentValue;
		$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

		// 4
		$this->_4->EditAttrs["class"] = "form-control";
		$this->_4->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
		$this->_4->EditValue = $this->_4->CurrentValue;
		$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

		// 5
		$this->_5->EditAttrs["class"] = "form-control";
		$this->_5->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
		$this->_5->EditValue = $this->_5->CurrentValue;
		$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

		// 6
		$this->_6->EditAttrs["class"] = "form-control";
		$this->_6->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
		$this->_6->EditValue = $this->_6->CurrentValue;
		$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

		// 7
		$this->_7->EditAttrs["class"] = "form-control";
		$this->_7->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
		$this->_7->EditValue = $this->_7->CurrentValue;
		$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

		// 8
		$this->_8->EditAttrs["class"] = "form-control";
		$this->_8->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
		$this->_8->EditValue = $this->_8->CurrentValue;
		$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

		// 9
		$this->_9->EditAttrs["class"] = "form-control";
		$this->_9->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_9->CurrentValue = HtmlDecode($this->_9->CurrentValue);
		$this->_9->EditValue = $this->_9->CurrentValue;
		$this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

		// 10
		$this->_10->EditAttrs["class"] = "form-control";
		$this->_10->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_10->CurrentValue = HtmlDecode($this->_10->CurrentValue);
		$this->_10->EditValue = $this->_10->CurrentValue;
		$this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

		// 11
		$this->_11->EditAttrs["class"] = "form-control";
		$this->_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_11->CurrentValue = HtmlDecode($this->_11->CurrentValue);
		$this->_11->EditValue = $this->_11->CurrentValue;
		$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

		// 12
		$this->_12->EditAttrs["class"] = "form-control";
		$this->_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_12->CurrentValue = HtmlDecode($this->_12->CurrentValue);
		$this->_12->EditValue = $this->_12->CurrentValue;
		$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		$this->image->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 50;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->EditValue = $this->image->Upload->DbValue;
		} else {
			$this->image->EditValue = "";
		}
		if (!EmptyValue($this->image->CurrentValue))
				$this->image->Upload->FileName = $this->image->CurrentValue;

		// buyer_uid
		$this->buyer_uid->EditAttrs["class"] = "form-control";
		$this->buyer_uid->EditCustomAttributes = "";
		$this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		// datetime
		// r_text

		$this->r_text->EditAttrs["class"] = "form-control";
		$this->r_text->EditCustomAttributes = "";
		$this->r_text->EditValue = $this->r_text->CurrentValue;
		$this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

		// t_id
		$this->t_id->EditAttrs["class"] = "form-control";
		$this->t_id->EditCustomAttributes = "";
		$this->t_id->EditValue = $this->t_id->CurrentValue;
		$this->t_id->PlaceHolder = RemoveHtml($this->t_id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->rid_1);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->w);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->l);
					$doc->exportCaption($this->l_cm);
					$doc->exportCaption($this->h);
					$doc->exportCaption($this->h_cm);
					$doc->exportCaption($this->partner_size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->_9);
					$doc->exportCaption($this->_10);
					$doc->exportCaption($this->_11);
					$doc->exportCaption($this->_12);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->buyer_uid);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->t_id);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->rid_1);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->w);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->l);
					$doc->exportCaption($this->l_cm);
					$doc->exportCaption($this->partner_size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->_9);
					$doc->exportCaption($this->_10);
					$doc->exportCaption($this->_11);
					$doc->exportCaption($this->_12);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->po_id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->product_type);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->rid_1);
						$doc->exportField($this->shape);
						$doc->exportField($this->unit);
						$doc->exportField($this->w);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->l);
						$doc->exportField($this->l_cm);
						$doc->exportField($this->h);
						$doc->exportField($this->h_cm);
						$doc->exportField($this->partner_size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->quantity);
						$doc->exportField($this->price);
						$doc->exportField($this->currency);
						$doc->exportField($this->_9);
						$doc->exportField($this->_10);
						$doc->exportField($this->_11);
						$doc->exportField($this->_12);
						$doc->exportField($this->remarks);
						$doc->exportField($this->image);
						$doc->exportField($this->buyer_uid);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->t_id);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->po_id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->product_type);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->rid_1);
						$doc->exportField($this->shape);
						$doc->exportField($this->unit);
						$doc->exportField($this->w);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->l);
						$doc->exportField($this->l_cm);
						$doc->exportField($this->partner_size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->quantity);
						$doc->exportField($this->price);
						$doc->exportField($this->currency);
						$doc->exportField($this->_9);
						$doc->exportField($this->_10);
						$doc->exportField($this->_11);
						$doc->exportField($this->_12);
						$doc->exportField($this->image);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'image') {
			$fldName = "image";
			$fileNameFld = "image";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'product_cart_s_sample';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'product_cart_s_sample';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'product_cart_s_sample';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'product_cart_s_sample';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>