<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_group_add extends product_group
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_group';

	// Page object name
	public $PageObjName = "product_group_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_group)
		if (!isset($GLOBALS["product_group"]) || get_class($GLOBALS["product_group"]) == PROJECT_NAMESPACE . "product_group") {
			$GLOBALS["product_group"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["product_group"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $product_group;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_group);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "product_groupview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("product_grouplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->grp->setVisibility();
		$this->product_group->setVisibility();
		$this->calculation_method->setVisibility();
		$this->shape->setVisibility();
		$this->sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->process->setVisibility();
		$this->status->setVisibility();
		$this->v_00->setVisibility();
		$this->v_01->setVisibility();
		$this->v_01_validation->setVisibility();
		$this->v_02->setVisibility();
		$this->v_02_validation->setVisibility();
		$this->v_03->setVisibility();
		$this->v_03_validation->setVisibility();
		$this->v_04->setVisibility();
		$this->v_04_validation->setVisibility();
		$this->v_05->setVisibility();
		$this->v_05_validation->setVisibility();
		$this->v_06->setVisibility();
		$this->v_06_validation->setVisibility();
		$this->v_07->setVisibility();
		$this->v_07_validation->setVisibility();
		$this->v_08->setVisibility();
		$this->v_08_validation->setVisibility();
		$this->v_09->setVisibility();
		$this->v_09_validation->setVisibility();
		$this->v_10->setVisibility();
		$this->v_10_validation->setVisibility();
		$this->b_01_head->setVisibility();
		$this->b_02_head->setVisibility();
		$this->b_03_head->setVisibility();
		$this->b_04_head->setVisibility();
		$this->b_05_head->setVisibility();
		$this->b_06_head->setVisibility();
		$this->b_07_head->setVisibility();
		$this->b_08_head->setVisibility();
		$this->b_09_head->setVisibility();
		$this->b_10_head->setVisibility();
		$this->b_11_head->setVisibility();
		$this->b_12_head->setVisibility();
		$this->b_13_head->setVisibility();
		$this->b_14_head->setVisibility();
		$this->b_15_head->setVisibility();
		$this->q_sku->setVisibility();
		$this->t_01_head->setVisibility();
		$this->t_02_head->setVisibility();
		$this->t_03_head->setVisibility();
		$this->t_04_head->setVisibility();
		$this->t_05_head->setVisibility();
		$this->t_06_head->setVisibility();
		$this->t_07_head->setVisibility();
		$this->t_08_head->setVisibility();
		$this->t_09_head->setVisibility();
		$this->t_10_head->setVisibility();
		$this->t_11_head->setVisibility();
		$this->t_12_head->setVisibility();
		$this->t_13_head->setVisibility();
		$this->t_14_head->setVisibility();
		$this->t_15_head->setVisibility();
		$this->po_01_head->setVisibility();
		$this->po_02_head->setVisibility();
		$this->po_03_head->setVisibility();
		$this->po_04_head->setVisibility();
		$this->po_05_head->setVisibility();
		$this->po_06_head->setVisibility();
		$this->po_07_head->setVisibility();
		$this->po_08_head->setVisibility();
		$this->po_17_head->setVisibility();
		$this->po_18_head->setVisibility();
		$this->po_19_head->setVisibility();
		$this->po_20_head->setVisibility();
		$this->jc_01_head->setVisibility();
		$this->jc_02_head->setVisibility();
		$this->jc_03_head->setVisibility();
		$this->jc_04_head->setVisibility();
		$this->jc_05_head->setVisibility();
		$this->jc_06_head->setVisibility();
		$this->jc_07_head->setVisibility();
		$this->jc_08_head->setVisibility();
		$this->jc_09_head->setVisibility();
		$this->jc_10_head->setVisibility();
		$this->pc_shape->setVisibility();
		$this->pc_unit->setVisibility();
		$this->pc_w->setVisibility();
		$this->pc_l->setVisibility();
		$this->pc_h->setVisibility();
		$this->pc_partner_size->setVisibility();
		$this->pc_sqm->setVisibility();
		$this->pc_01_head->setVisibility();
		$this->pc_02_head->setVisibility();
		$this->pc_03_head->setVisibility();
		$this->pc_04_head->setVisibility();
		$this->pc_05_head->setVisibility();
		$this->pc_06_head->setVisibility();
		$this->pc_07_head->setVisibility();
		$this->pc_08_head->setVisibility();
		$this->pc_09_head->setVisibility();
		$this->pc_10_head->setVisibility();
		$this->pc_11_head->setVisibility();
		$this->pc_12_head->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->image->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->calculation_method);
		$this->setupLookupOptions($this->process);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("product_grouplist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "product_grouplist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "product_groupview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->image->Upload->Index = $CurrentForm->Index;
		$this->image->Upload->uploadFile();
		$this->image->CurrentValue = $this->image->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->product_group->CurrentValue = NULL;
		$this->product_group->OldValue = $this->product_group->CurrentValue;
		$this->calculation_method->CurrentValue = NULL;
		$this->calculation_method->OldValue = $this->calculation_method->CurrentValue;
		$this->shape->CurrentValue = NULL;
		$this->shape->OldValue = $this->shape->CurrentValue;
		$this->sqm->CurrentValue = NULL;
		$this->sqm->OldValue = $this->sqm->CurrentValue;
		$this->cbm->CurrentValue = NULL;
		$this->cbm->OldValue = $this->cbm->CurrentValue;
		$this->process->CurrentValue = NULL;
		$this->process->OldValue = $this->process->CurrentValue;
		$this->status->CurrentValue = 1;
		$this->v_00->CurrentValue = "--NA--";
		$this->v_01->CurrentValue = "--NA--";
		$this->v_01_validation->CurrentValue = "1,12";
		$this->v_02->CurrentValue = "--NA--";
		$this->v_02_validation->CurrentValue = "1,12";
		$this->v_03->CurrentValue = "--NA--";
		$this->v_03_validation->CurrentValue = "1,12";
		$this->v_04->CurrentValue = "--NA--";
		$this->v_04_validation->CurrentValue = "1,12";
		$this->v_05->CurrentValue = "--NA--";
		$this->v_05_validation->CurrentValue = "1,12";
		$this->v_06->CurrentValue = "--NA--";
		$this->v_06_validation->CurrentValue = "1,12";
		$this->v_07->CurrentValue = "--NA--";
		$this->v_07_validation->CurrentValue = "1,12";
		$this->v_08->CurrentValue = "--NA--";
		$this->v_08_validation->CurrentValue = "1,12";
		$this->v_09->CurrentValue = "--NA--";
		$this->v_09_validation->CurrentValue = "1,12";
		$this->v_10->CurrentValue = "--NA--";
		$this->v_10_validation->CurrentValue = "1,12";
		$this->b_01_head->CurrentValue = "--NA--";
		$this->b_02_head->CurrentValue = "--NA--";
		$this->b_03_head->CurrentValue = "--NA--";
		$this->b_04_head->CurrentValue = "--NA--";
		$this->b_05_head->CurrentValue = "--NA--";
		$this->b_06_head->CurrentValue = "--NA--";
		$this->b_07_head->CurrentValue = "--NA--";
		$this->b_08_head->CurrentValue = "--NA--";
		$this->b_09_head->CurrentValue = "--NA--";
		$this->b_10_head->CurrentValue = "--NA--";
		$this->b_11_head->CurrentValue = "--NA--";
		$this->b_12_head->CurrentValue = "--NA--";
		$this->b_13_head->CurrentValue = "--NA--";
		$this->b_14_head->CurrentValue = "--NA--";
		$this->b_15_head->CurrentValue = "--NA--";
		$this->q_sku->CurrentValue = 1.00;
		$this->t_01_head->CurrentValue = "--NA--";
		$this->t_02_head->CurrentValue = "--NA--";
		$this->t_03_head->CurrentValue = "--NA--";
		$this->t_04_head->CurrentValue = "--NA--";
		$this->t_05_head->CurrentValue = "--NA--";
		$this->t_06_head->CurrentValue = "--NA--";
		$this->t_07_head->CurrentValue = "--NA--";
		$this->t_08_head->CurrentValue = "--NA--";
		$this->t_09_head->CurrentValue = "--NA--";
		$this->t_10_head->CurrentValue = "--NA--";
		$this->t_11_head->CurrentValue = "--NA--";
		$this->t_12_head->CurrentValue = "--NA--";
		$this->t_13_head->CurrentValue = "--NA--";
		$this->t_14_head->CurrentValue = "--NA--";
		$this->t_15_head->CurrentValue = "--NA--";
		$this->po_01_head->CurrentValue = "--NA--";
		$this->po_02_head->CurrentValue = "--NA--";
		$this->po_03_head->CurrentValue = "--NA--";
		$this->po_04_head->CurrentValue = "--NA--";
		$this->po_05_head->CurrentValue = "--NA--";
		$this->po_06_head->CurrentValue = "--NA--";
		$this->po_07_head->CurrentValue = "--NA--";
		$this->po_08_head->CurrentValue = "--NA--";
		$this->po_17_head->CurrentValue = "--NA--";
		$this->po_18_head->CurrentValue = "--NA--";
		$this->po_19_head->CurrentValue = "--NA--";
		$this->po_20_head->CurrentValue = "--NA--";
		$this->jc_01_head->CurrentValue = NULL;
		$this->jc_01_head->OldValue = $this->jc_01_head->CurrentValue;
		$this->jc_02_head->CurrentValue = NULL;
		$this->jc_02_head->OldValue = $this->jc_02_head->CurrentValue;
		$this->jc_03_head->CurrentValue = NULL;
		$this->jc_03_head->OldValue = $this->jc_03_head->CurrentValue;
		$this->jc_04_head->CurrentValue = NULL;
		$this->jc_04_head->OldValue = $this->jc_04_head->CurrentValue;
		$this->jc_05_head->CurrentValue = NULL;
		$this->jc_05_head->OldValue = $this->jc_05_head->CurrentValue;
		$this->jc_06_head->CurrentValue = NULL;
		$this->jc_06_head->OldValue = $this->jc_06_head->CurrentValue;
		$this->jc_07_head->CurrentValue = NULL;
		$this->jc_07_head->OldValue = $this->jc_07_head->CurrentValue;
		$this->jc_08_head->CurrentValue = NULL;
		$this->jc_08_head->OldValue = $this->jc_08_head->CurrentValue;
		$this->jc_09_head->CurrentValue = NULL;
		$this->jc_09_head->OldValue = $this->jc_09_head->CurrentValue;
		$this->jc_10_head->CurrentValue = NULL;
		$this->jc_10_head->OldValue = $this->jc_10_head->CurrentValue;
		$this->pc_shape->CurrentValue = "--NA--";
		$this->pc_unit->CurrentValue = "--NA--";
		$this->pc_w->CurrentValue = "--NA--";
		$this->pc_l->CurrentValue = "--NA--";
		$this->pc_h->CurrentValue = "--NA--";
		$this->pc_partner_size->CurrentValue = "--NA--";
		$this->pc_sqm->CurrentValue = "--NA--";
		$this->pc_01_head->CurrentValue = "--NA--";
		$this->pc_02_head->CurrentValue = "--NA--";
		$this->pc_03_head->CurrentValue = "--NA--";
		$this->pc_04_head->CurrentValue = "--NA--";
		$this->pc_05_head->CurrentValue = "--NA--";
		$this->pc_06_head->CurrentValue = "--NA--";
		$this->pc_07_head->CurrentValue = "--NA--";
		$this->pc_08_head->CurrentValue = "--NA--";
		$this->pc_09_head->CurrentValue = "--NA--";
		$this->pc_10_head->CurrentValue = "--NA--";
		$this->pc_11_head->CurrentValue = "--NA--";
		$this->pc_12_head->CurrentValue = "--NA--";
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->image->Upload->DbValue = NULL;
		$this->image->OldValue = $this->image->Upload->DbValue;
		$this->image->CurrentValue = NULL; // Clear file related field
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'product_group' first before field var 'x_product_group'
		$val = $CurrentForm->hasValue("product_group") ? $CurrentForm->getValue("product_group") : $CurrentForm->getValue("x_product_group");
		if (!$this->product_group->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_group->Visible = FALSE; // Disable update for API request
			else
				$this->product_group->setFormValue($val);
		}

		// Check field name 'calculation_method' first before field var 'x_calculation_method'
		$val = $CurrentForm->hasValue("calculation_method") ? $CurrentForm->getValue("calculation_method") : $CurrentForm->getValue("x_calculation_method");
		if (!$this->calculation_method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->calculation_method->Visible = FALSE; // Disable update for API request
			else
				$this->calculation_method->setFormValue($val);
		}

		// Check field name 'shape' first before field var 'x_shape'
		$val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
		if (!$this->shape->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shape->Visible = FALSE; // Disable update for API request
			else
				$this->shape->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'cbm' first before field var 'x_cbm'
		$val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
		if (!$this->cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cbm->Visible = FALSE; // Disable update for API request
			else
				$this->cbm->setFormValue($val);
		}

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'v_00' first before field var 'x_v_00'
		$val = $CurrentForm->hasValue("v_00") ? $CurrentForm->getValue("v_00") : $CurrentForm->getValue("x_v_00");
		if (!$this->v_00->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_00->Visible = FALSE; // Disable update for API request
			else
				$this->v_00->setFormValue($val);
		}

		// Check field name 'v_01' first before field var 'x_v_01'
		$val = $CurrentForm->hasValue("v_01") ? $CurrentForm->getValue("v_01") : $CurrentForm->getValue("x_v_01");
		if (!$this->v_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_01->Visible = FALSE; // Disable update for API request
			else
				$this->v_01->setFormValue($val);
		}

		// Check field name 'v_01_validation' first before field var 'x_v_01_validation'
		$val = $CurrentForm->hasValue("v_01_validation") ? $CurrentForm->getValue("v_01_validation") : $CurrentForm->getValue("x_v_01_validation");
		if (!$this->v_01_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_01_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_01_validation->setFormValue($val);
		}

		// Check field name 'v_02' first before field var 'x_v_02'
		$val = $CurrentForm->hasValue("v_02") ? $CurrentForm->getValue("v_02") : $CurrentForm->getValue("x_v_02");
		if (!$this->v_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_02->Visible = FALSE; // Disable update for API request
			else
				$this->v_02->setFormValue($val);
		}

		// Check field name 'v_02_validation' first before field var 'x_v_02_validation'
		$val = $CurrentForm->hasValue("v_02_validation") ? $CurrentForm->getValue("v_02_validation") : $CurrentForm->getValue("x_v_02_validation");
		if (!$this->v_02_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_02_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_02_validation->setFormValue($val);
		}

		// Check field name 'v_03' first before field var 'x_v_03'
		$val = $CurrentForm->hasValue("v_03") ? $CurrentForm->getValue("v_03") : $CurrentForm->getValue("x_v_03");
		if (!$this->v_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_03->Visible = FALSE; // Disable update for API request
			else
				$this->v_03->setFormValue($val);
		}

		// Check field name 'v_03_validation' first before field var 'x_v_03_validation'
		$val = $CurrentForm->hasValue("v_03_validation") ? $CurrentForm->getValue("v_03_validation") : $CurrentForm->getValue("x_v_03_validation");
		if (!$this->v_03_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_03_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_03_validation->setFormValue($val);
		}

		// Check field name 'v_04' first before field var 'x_v_04'
		$val = $CurrentForm->hasValue("v_04") ? $CurrentForm->getValue("v_04") : $CurrentForm->getValue("x_v_04");
		if (!$this->v_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_04->Visible = FALSE; // Disable update for API request
			else
				$this->v_04->setFormValue($val);
		}

		// Check field name 'v_04_validation' first before field var 'x_v_04_validation'
		$val = $CurrentForm->hasValue("v_04_validation") ? $CurrentForm->getValue("v_04_validation") : $CurrentForm->getValue("x_v_04_validation");
		if (!$this->v_04_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_04_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_04_validation->setFormValue($val);
		}

		// Check field name 'v_05' first before field var 'x_v_05'
		$val = $CurrentForm->hasValue("v_05") ? $CurrentForm->getValue("v_05") : $CurrentForm->getValue("x_v_05");
		if (!$this->v_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_05->Visible = FALSE; // Disable update for API request
			else
				$this->v_05->setFormValue($val);
		}

		// Check field name 'v_05_validation' first before field var 'x_v_05_validation'
		$val = $CurrentForm->hasValue("v_05_validation") ? $CurrentForm->getValue("v_05_validation") : $CurrentForm->getValue("x_v_05_validation");
		if (!$this->v_05_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_05_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_05_validation->setFormValue($val);
		}

		// Check field name 'v_06' first before field var 'x_v_06'
		$val = $CurrentForm->hasValue("v_06") ? $CurrentForm->getValue("v_06") : $CurrentForm->getValue("x_v_06");
		if (!$this->v_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_06->Visible = FALSE; // Disable update for API request
			else
				$this->v_06->setFormValue($val);
		}

		// Check field name 'v_06_validation' first before field var 'x_v_06_validation'
		$val = $CurrentForm->hasValue("v_06_validation") ? $CurrentForm->getValue("v_06_validation") : $CurrentForm->getValue("x_v_06_validation");
		if (!$this->v_06_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_06_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_06_validation->setFormValue($val);
		}

		// Check field name 'v_07' first before field var 'x_v_07'
		$val = $CurrentForm->hasValue("v_07") ? $CurrentForm->getValue("v_07") : $CurrentForm->getValue("x_v_07");
		if (!$this->v_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_07->Visible = FALSE; // Disable update for API request
			else
				$this->v_07->setFormValue($val);
		}

		// Check field name 'v_07_validation' first before field var 'x_v_07_validation'
		$val = $CurrentForm->hasValue("v_07_validation") ? $CurrentForm->getValue("v_07_validation") : $CurrentForm->getValue("x_v_07_validation");
		if (!$this->v_07_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_07_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_07_validation->setFormValue($val);
		}

		// Check field name 'v_08' first before field var 'x_v_08'
		$val = $CurrentForm->hasValue("v_08") ? $CurrentForm->getValue("v_08") : $CurrentForm->getValue("x_v_08");
		if (!$this->v_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_08->Visible = FALSE; // Disable update for API request
			else
				$this->v_08->setFormValue($val);
		}

		// Check field name 'v_08_validation' first before field var 'x_v_08_validation'
		$val = $CurrentForm->hasValue("v_08_validation") ? $CurrentForm->getValue("v_08_validation") : $CurrentForm->getValue("x_v_08_validation");
		if (!$this->v_08_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_08_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_08_validation->setFormValue($val);
		}

		// Check field name 'v_09' first before field var 'x_v_09'
		$val = $CurrentForm->hasValue("v_09") ? $CurrentForm->getValue("v_09") : $CurrentForm->getValue("x_v_09");
		if (!$this->v_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_09->Visible = FALSE; // Disable update for API request
			else
				$this->v_09->setFormValue($val);
		}

		// Check field name 'v_09_validation' first before field var 'x_v_09_validation'
		$val = $CurrentForm->hasValue("v_09_validation") ? $CurrentForm->getValue("v_09_validation") : $CurrentForm->getValue("x_v_09_validation");
		if (!$this->v_09_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_09_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_09_validation->setFormValue($val);
		}

		// Check field name 'v_10' first before field var 'x_v_10'
		$val = $CurrentForm->hasValue("v_10") ? $CurrentForm->getValue("v_10") : $CurrentForm->getValue("x_v_10");
		if (!$this->v_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_10->Visible = FALSE; // Disable update for API request
			else
				$this->v_10->setFormValue($val);
		}

		// Check field name 'v_10_validation' first before field var 'x_v_10_validation'
		$val = $CurrentForm->hasValue("v_10_validation") ? $CurrentForm->getValue("v_10_validation") : $CurrentForm->getValue("x_v_10_validation");
		if (!$this->v_10_validation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_10_validation->Visible = FALSE; // Disable update for API request
			else
				$this->v_10_validation->setFormValue($val);
		}

		// Check field name 'b_01_head' first before field var 'x_b_01_head'
		$val = $CurrentForm->hasValue("b_01_head") ? $CurrentForm->getValue("b_01_head") : $CurrentForm->getValue("x_b_01_head");
		if (!$this->b_01_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_01_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_01_head->setFormValue($val);
		}

		// Check field name 'b_02_head' first before field var 'x_b_02_head'
		$val = $CurrentForm->hasValue("b_02_head") ? $CurrentForm->getValue("b_02_head") : $CurrentForm->getValue("x_b_02_head");
		if (!$this->b_02_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_02_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_02_head->setFormValue($val);
		}

		// Check field name 'b_03_head' first before field var 'x_b_03_head'
		$val = $CurrentForm->hasValue("b_03_head") ? $CurrentForm->getValue("b_03_head") : $CurrentForm->getValue("x_b_03_head");
		if (!$this->b_03_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_03_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_03_head->setFormValue($val);
		}

		// Check field name 'b_04_head' first before field var 'x_b_04_head'
		$val = $CurrentForm->hasValue("b_04_head") ? $CurrentForm->getValue("b_04_head") : $CurrentForm->getValue("x_b_04_head");
		if (!$this->b_04_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_04_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_04_head->setFormValue($val);
		}

		// Check field name 'b_05_head' first before field var 'x_b_05_head'
		$val = $CurrentForm->hasValue("b_05_head") ? $CurrentForm->getValue("b_05_head") : $CurrentForm->getValue("x_b_05_head");
		if (!$this->b_05_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_05_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_05_head->setFormValue($val);
		}

		// Check field name 'b_06_head' first before field var 'x_b_06_head'
		$val = $CurrentForm->hasValue("b_06_head") ? $CurrentForm->getValue("b_06_head") : $CurrentForm->getValue("x_b_06_head");
		if (!$this->b_06_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_06_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_06_head->setFormValue($val);
		}

		// Check field name 'b_07_head' first before field var 'x_b_07_head'
		$val = $CurrentForm->hasValue("b_07_head") ? $CurrentForm->getValue("b_07_head") : $CurrentForm->getValue("x_b_07_head");
		if (!$this->b_07_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_07_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_07_head->setFormValue($val);
		}

		// Check field name 'b_08_head' first before field var 'x_b_08_head'
		$val = $CurrentForm->hasValue("b_08_head") ? $CurrentForm->getValue("b_08_head") : $CurrentForm->getValue("x_b_08_head");
		if (!$this->b_08_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_08_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_08_head->setFormValue($val);
		}

		// Check field name 'b_09_head' first before field var 'x_b_09_head'
		$val = $CurrentForm->hasValue("b_09_head") ? $CurrentForm->getValue("b_09_head") : $CurrentForm->getValue("x_b_09_head");
		if (!$this->b_09_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_09_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_09_head->setFormValue($val);
		}

		// Check field name 'b_10_head' first before field var 'x_b_10_head'
		$val = $CurrentForm->hasValue("b_10_head") ? $CurrentForm->getValue("b_10_head") : $CurrentForm->getValue("x_b_10_head");
		if (!$this->b_10_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_10_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_10_head->setFormValue($val);
		}

		// Check field name 'b_11_head' first before field var 'x_b_11_head'
		$val = $CurrentForm->hasValue("b_11_head") ? $CurrentForm->getValue("b_11_head") : $CurrentForm->getValue("x_b_11_head");
		if (!$this->b_11_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_11_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_11_head->setFormValue($val);
		}

		// Check field name 'b_12_head' first before field var 'x_b_12_head'
		$val = $CurrentForm->hasValue("b_12_head") ? $CurrentForm->getValue("b_12_head") : $CurrentForm->getValue("x_b_12_head");
		if (!$this->b_12_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_12_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_12_head->setFormValue($val);
		}

		// Check field name 'b_13_head' first before field var 'x_b_13_head'
		$val = $CurrentForm->hasValue("b_13_head") ? $CurrentForm->getValue("b_13_head") : $CurrentForm->getValue("x_b_13_head");
		if (!$this->b_13_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_13_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_13_head->setFormValue($val);
		}

		// Check field name 'b_14_head' first before field var 'x_b_14_head'
		$val = $CurrentForm->hasValue("b_14_head") ? $CurrentForm->getValue("b_14_head") : $CurrentForm->getValue("x_b_14_head");
		if (!$this->b_14_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_14_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_14_head->setFormValue($val);
		}

		// Check field name 'b_15_head' first before field var 'x_b_15_head'
		$val = $CurrentForm->hasValue("b_15_head") ? $CurrentForm->getValue("b_15_head") : $CurrentForm->getValue("x_b_15_head");
		if (!$this->b_15_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_15_head->Visible = FALSE; // Disable update for API request
			else
				$this->b_15_head->setFormValue($val);
		}

		// Check field name 'q_sku' first before field var 'x_q_sku'
		$val = $CurrentForm->hasValue("q_sku") ? $CurrentForm->getValue("q_sku") : $CurrentForm->getValue("x_q_sku");
		if (!$this->q_sku->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->q_sku->Visible = FALSE; // Disable update for API request
			else
				$this->q_sku->setFormValue($val);
		}

		// Check field name 't_01_head' first before field var 'x_t_01_head'
		$val = $CurrentForm->hasValue("t_01_head") ? $CurrentForm->getValue("t_01_head") : $CurrentForm->getValue("x_t_01_head");
		if (!$this->t_01_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_01_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_01_head->setFormValue($val);
		}

		// Check field name 't_02_head' first before field var 'x_t_02_head'
		$val = $CurrentForm->hasValue("t_02_head") ? $CurrentForm->getValue("t_02_head") : $CurrentForm->getValue("x_t_02_head");
		if (!$this->t_02_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_02_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_02_head->setFormValue($val);
		}

		// Check field name 't_03_head' first before field var 'x_t_03_head'
		$val = $CurrentForm->hasValue("t_03_head") ? $CurrentForm->getValue("t_03_head") : $CurrentForm->getValue("x_t_03_head");
		if (!$this->t_03_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_03_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_03_head->setFormValue($val);
		}

		// Check field name 't_04_head' first before field var 'x_t_04_head'
		$val = $CurrentForm->hasValue("t_04_head") ? $CurrentForm->getValue("t_04_head") : $CurrentForm->getValue("x_t_04_head");
		if (!$this->t_04_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_04_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_04_head->setFormValue($val);
		}

		// Check field name 't_05_head' first before field var 'x_t_05_head'
		$val = $CurrentForm->hasValue("t_05_head") ? $CurrentForm->getValue("t_05_head") : $CurrentForm->getValue("x_t_05_head");
		if (!$this->t_05_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_05_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_05_head->setFormValue($val);
		}

		// Check field name 't_06_head' first before field var 'x_t_06_head'
		$val = $CurrentForm->hasValue("t_06_head") ? $CurrentForm->getValue("t_06_head") : $CurrentForm->getValue("x_t_06_head");
		if (!$this->t_06_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_06_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_06_head->setFormValue($val);
		}

		// Check field name 't_07_head' first before field var 'x_t_07_head'
		$val = $CurrentForm->hasValue("t_07_head") ? $CurrentForm->getValue("t_07_head") : $CurrentForm->getValue("x_t_07_head");
		if (!$this->t_07_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_07_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_07_head->setFormValue($val);
		}

		// Check field name 't_08_head' first before field var 'x_t_08_head'
		$val = $CurrentForm->hasValue("t_08_head") ? $CurrentForm->getValue("t_08_head") : $CurrentForm->getValue("x_t_08_head");
		if (!$this->t_08_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_08_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_08_head->setFormValue($val);
		}

		// Check field name 't_09_head' first before field var 'x_t_09_head'
		$val = $CurrentForm->hasValue("t_09_head") ? $CurrentForm->getValue("t_09_head") : $CurrentForm->getValue("x_t_09_head");
		if (!$this->t_09_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_09_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_09_head->setFormValue($val);
		}

		// Check field name 't_10_head' first before field var 'x_t_10_head'
		$val = $CurrentForm->hasValue("t_10_head") ? $CurrentForm->getValue("t_10_head") : $CurrentForm->getValue("x_t_10_head");
		if (!$this->t_10_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_10_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_10_head->setFormValue($val);
		}

		// Check field name 't_11_head' first before field var 'x_t_11_head'
		$val = $CurrentForm->hasValue("t_11_head") ? $CurrentForm->getValue("t_11_head") : $CurrentForm->getValue("x_t_11_head");
		if (!$this->t_11_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_11_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_11_head->setFormValue($val);
		}

		// Check field name 't_12_head' first before field var 'x_t_12_head'
		$val = $CurrentForm->hasValue("t_12_head") ? $CurrentForm->getValue("t_12_head") : $CurrentForm->getValue("x_t_12_head");
		if (!$this->t_12_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_12_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_12_head->setFormValue($val);
		}

		// Check field name 't_13_head' first before field var 'x_t_13_head'
		$val = $CurrentForm->hasValue("t_13_head") ? $CurrentForm->getValue("t_13_head") : $CurrentForm->getValue("x_t_13_head");
		if (!$this->t_13_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_13_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_13_head->setFormValue($val);
		}

		// Check field name 't_14_head' first before field var 'x_t_14_head'
		$val = $CurrentForm->hasValue("t_14_head") ? $CurrentForm->getValue("t_14_head") : $CurrentForm->getValue("x_t_14_head");
		if (!$this->t_14_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_14_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_14_head->setFormValue($val);
		}

		// Check field name 't_15_head' first before field var 'x_t_15_head'
		$val = $CurrentForm->hasValue("t_15_head") ? $CurrentForm->getValue("t_15_head") : $CurrentForm->getValue("x_t_15_head");
		if (!$this->t_15_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_15_head->Visible = FALSE; // Disable update for API request
			else
				$this->t_15_head->setFormValue($val);
		}

		// Check field name 'po_01_head' first before field var 'x_po_01_head'
		$val = $CurrentForm->hasValue("po_01_head") ? $CurrentForm->getValue("po_01_head") : $CurrentForm->getValue("x_po_01_head");
		if (!$this->po_01_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_01_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_01_head->setFormValue($val);
		}

		// Check field name 'po_02_head' first before field var 'x_po_02_head'
		$val = $CurrentForm->hasValue("po_02_head") ? $CurrentForm->getValue("po_02_head") : $CurrentForm->getValue("x_po_02_head");
		if (!$this->po_02_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_02_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_02_head->setFormValue($val);
		}

		// Check field name 'po_03_head' first before field var 'x_po_03_head'
		$val = $CurrentForm->hasValue("po_03_head") ? $CurrentForm->getValue("po_03_head") : $CurrentForm->getValue("x_po_03_head");
		if (!$this->po_03_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_03_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_03_head->setFormValue($val);
		}

		// Check field name 'po_04_head' first before field var 'x_po_04_head'
		$val = $CurrentForm->hasValue("po_04_head") ? $CurrentForm->getValue("po_04_head") : $CurrentForm->getValue("x_po_04_head");
		if (!$this->po_04_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_04_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_04_head->setFormValue($val);
		}

		// Check field name 'po_05_head' first before field var 'x_po_05_head'
		$val = $CurrentForm->hasValue("po_05_head") ? $CurrentForm->getValue("po_05_head") : $CurrentForm->getValue("x_po_05_head");
		if (!$this->po_05_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_05_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_05_head->setFormValue($val);
		}

		// Check field name 'po_06_head' first before field var 'x_po_06_head'
		$val = $CurrentForm->hasValue("po_06_head") ? $CurrentForm->getValue("po_06_head") : $CurrentForm->getValue("x_po_06_head");
		if (!$this->po_06_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_06_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_06_head->setFormValue($val);
		}

		// Check field name 'po_07_head' first before field var 'x_po_07_head'
		$val = $CurrentForm->hasValue("po_07_head") ? $CurrentForm->getValue("po_07_head") : $CurrentForm->getValue("x_po_07_head");
		if (!$this->po_07_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_07_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_07_head->setFormValue($val);
		}

		// Check field name 'po_08_head' first before field var 'x_po_08_head'
		$val = $CurrentForm->hasValue("po_08_head") ? $CurrentForm->getValue("po_08_head") : $CurrentForm->getValue("x_po_08_head");
		if (!$this->po_08_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_08_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_08_head->setFormValue($val);
		}

		// Check field name 'po_17_head' first before field var 'x_po_17_head'
		$val = $CurrentForm->hasValue("po_17_head") ? $CurrentForm->getValue("po_17_head") : $CurrentForm->getValue("x_po_17_head");
		if (!$this->po_17_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_17_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_17_head->setFormValue($val);
		}

		// Check field name 'po_18_head' first before field var 'x_po_18_head'
		$val = $CurrentForm->hasValue("po_18_head") ? $CurrentForm->getValue("po_18_head") : $CurrentForm->getValue("x_po_18_head");
		if (!$this->po_18_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_18_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_18_head->setFormValue($val);
		}

		// Check field name 'po_19_head' first before field var 'x_po_19_head'
		$val = $CurrentForm->hasValue("po_19_head") ? $CurrentForm->getValue("po_19_head") : $CurrentForm->getValue("x_po_19_head");
		if (!$this->po_19_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_19_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_19_head->setFormValue($val);
		}

		// Check field name 'po_20_head' first before field var 'x_po_20_head'
		$val = $CurrentForm->hasValue("po_20_head") ? $CurrentForm->getValue("po_20_head") : $CurrentForm->getValue("x_po_20_head");
		if (!$this->po_20_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_20_head->Visible = FALSE; // Disable update for API request
			else
				$this->po_20_head->setFormValue($val);
		}

		// Check field name 'jc_01_head' first before field var 'x_jc_01_head'
		$val = $CurrentForm->hasValue("jc_01_head") ? $CurrentForm->getValue("jc_01_head") : $CurrentForm->getValue("x_jc_01_head");
		if (!$this->jc_01_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_01_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_01_head->setFormValue($val);
		}

		// Check field name 'jc_02_head' first before field var 'x_jc_02_head'
		$val = $CurrentForm->hasValue("jc_02_head") ? $CurrentForm->getValue("jc_02_head") : $CurrentForm->getValue("x_jc_02_head");
		if (!$this->jc_02_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_02_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_02_head->setFormValue($val);
		}

		// Check field name 'jc_03_head' first before field var 'x_jc_03_head'
		$val = $CurrentForm->hasValue("jc_03_head") ? $CurrentForm->getValue("jc_03_head") : $CurrentForm->getValue("x_jc_03_head");
		if (!$this->jc_03_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_03_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_03_head->setFormValue($val);
		}

		// Check field name 'jc_04_head' first before field var 'x_jc_04_head'
		$val = $CurrentForm->hasValue("jc_04_head") ? $CurrentForm->getValue("jc_04_head") : $CurrentForm->getValue("x_jc_04_head");
		if (!$this->jc_04_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_04_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_04_head->setFormValue($val);
		}

		// Check field name 'jc_05_head' first before field var 'x_jc_05_head'
		$val = $CurrentForm->hasValue("jc_05_head") ? $CurrentForm->getValue("jc_05_head") : $CurrentForm->getValue("x_jc_05_head");
		if (!$this->jc_05_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_05_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_05_head->setFormValue($val);
		}

		// Check field name 'jc_06_head' first before field var 'x_jc_06_head'
		$val = $CurrentForm->hasValue("jc_06_head") ? $CurrentForm->getValue("jc_06_head") : $CurrentForm->getValue("x_jc_06_head");
		if (!$this->jc_06_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_06_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_06_head->setFormValue($val);
		}

		// Check field name 'jc_07_head' first before field var 'x_jc_07_head'
		$val = $CurrentForm->hasValue("jc_07_head") ? $CurrentForm->getValue("jc_07_head") : $CurrentForm->getValue("x_jc_07_head");
		if (!$this->jc_07_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_07_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_07_head->setFormValue($val);
		}

		// Check field name 'jc_08_head' first before field var 'x_jc_08_head'
		$val = $CurrentForm->hasValue("jc_08_head") ? $CurrentForm->getValue("jc_08_head") : $CurrentForm->getValue("x_jc_08_head");
		if (!$this->jc_08_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_08_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_08_head->setFormValue($val);
		}

		// Check field name 'jc_09_head' first before field var 'x_jc_09_head'
		$val = $CurrentForm->hasValue("jc_09_head") ? $CurrentForm->getValue("jc_09_head") : $CurrentForm->getValue("x_jc_09_head");
		if (!$this->jc_09_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_09_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_09_head->setFormValue($val);
		}

		// Check field name 'jc_10_head' first before field var 'x_jc_10_head'
		$val = $CurrentForm->hasValue("jc_10_head") ? $CurrentForm->getValue("jc_10_head") : $CurrentForm->getValue("x_jc_10_head");
		if (!$this->jc_10_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_10_head->Visible = FALSE; // Disable update for API request
			else
				$this->jc_10_head->setFormValue($val);
		}

		// Check field name 'pc_shape' first before field var 'x_pc_shape'
		$val = $CurrentForm->hasValue("pc_shape") ? $CurrentForm->getValue("pc_shape") : $CurrentForm->getValue("x_pc_shape");
		if (!$this->pc_shape->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_shape->Visible = FALSE; // Disable update for API request
			else
				$this->pc_shape->setFormValue($val);
		}

		// Check field name 'pc_unit' first before field var 'x_pc_unit'
		$val = $CurrentForm->hasValue("pc_unit") ? $CurrentForm->getValue("pc_unit") : $CurrentForm->getValue("x_pc_unit");
		if (!$this->pc_unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_unit->Visible = FALSE; // Disable update for API request
			else
				$this->pc_unit->setFormValue($val);
		}

		// Check field name 'pc_w' first before field var 'x_pc_w'
		$val = $CurrentForm->hasValue("pc_w") ? $CurrentForm->getValue("pc_w") : $CurrentForm->getValue("x_pc_w");
		if (!$this->pc_w->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_w->Visible = FALSE; // Disable update for API request
			else
				$this->pc_w->setFormValue($val);
		}

		// Check field name 'pc_l' first before field var 'x_pc_l'
		$val = $CurrentForm->hasValue("pc_l") ? $CurrentForm->getValue("pc_l") : $CurrentForm->getValue("x_pc_l");
		if (!$this->pc_l->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_l->Visible = FALSE; // Disable update for API request
			else
				$this->pc_l->setFormValue($val);
		}

		// Check field name 'pc_h' first before field var 'x_pc_h'
		$val = $CurrentForm->hasValue("pc_h") ? $CurrentForm->getValue("pc_h") : $CurrentForm->getValue("x_pc_h");
		if (!$this->pc_h->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_h->Visible = FALSE; // Disable update for API request
			else
				$this->pc_h->setFormValue($val);
		}

		// Check field name 'pc_partner_size' first before field var 'x_pc_partner_size'
		$val = $CurrentForm->hasValue("pc_partner_size") ? $CurrentForm->getValue("pc_partner_size") : $CurrentForm->getValue("x_pc_partner_size");
		if (!$this->pc_partner_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_partner_size->Visible = FALSE; // Disable update for API request
			else
				$this->pc_partner_size->setFormValue($val);
		}

		// Check field name 'pc_sqm' first before field var 'x_pc_sqm'
		$val = $CurrentForm->hasValue("pc_sqm") ? $CurrentForm->getValue("pc_sqm") : $CurrentForm->getValue("x_pc_sqm");
		if (!$this->pc_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->pc_sqm->setFormValue($val);
		}

		// Check field name 'pc_01_head' first before field var 'x_pc_01_head'
		$val = $CurrentForm->hasValue("pc_01_head") ? $CurrentForm->getValue("pc_01_head") : $CurrentForm->getValue("x_pc_01_head");
		if (!$this->pc_01_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_01_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_01_head->setFormValue($val);
		}

		// Check field name 'pc_02_head' first before field var 'x_pc_02_head'
		$val = $CurrentForm->hasValue("pc_02_head") ? $CurrentForm->getValue("pc_02_head") : $CurrentForm->getValue("x_pc_02_head");
		if (!$this->pc_02_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_02_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_02_head->setFormValue($val);
		}

		// Check field name 'pc_03_head' first before field var 'x_pc_03_head'
		$val = $CurrentForm->hasValue("pc_03_head") ? $CurrentForm->getValue("pc_03_head") : $CurrentForm->getValue("x_pc_03_head");
		if (!$this->pc_03_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_03_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_03_head->setFormValue($val);
		}

		// Check field name 'pc_04_head' first before field var 'x_pc_04_head'
		$val = $CurrentForm->hasValue("pc_04_head") ? $CurrentForm->getValue("pc_04_head") : $CurrentForm->getValue("x_pc_04_head");
		if (!$this->pc_04_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_04_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_04_head->setFormValue($val);
		}

		// Check field name 'pc_05_head' first before field var 'x_pc_05_head'
		$val = $CurrentForm->hasValue("pc_05_head") ? $CurrentForm->getValue("pc_05_head") : $CurrentForm->getValue("x_pc_05_head");
		if (!$this->pc_05_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_05_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_05_head->setFormValue($val);
		}

		// Check field name 'pc_06_head' first before field var 'x_pc_06_head'
		$val = $CurrentForm->hasValue("pc_06_head") ? $CurrentForm->getValue("pc_06_head") : $CurrentForm->getValue("x_pc_06_head");
		if (!$this->pc_06_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_06_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_06_head->setFormValue($val);
		}

		// Check field name 'pc_07_head' first before field var 'x_pc_07_head'
		$val = $CurrentForm->hasValue("pc_07_head") ? $CurrentForm->getValue("pc_07_head") : $CurrentForm->getValue("x_pc_07_head");
		if (!$this->pc_07_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_07_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_07_head->setFormValue($val);
		}

		// Check field name 'pc_08_head' first before field var 'x_pc_08_head'
		$val = $CurrentForm->hasValue("pc_08_head") ? $CurrentForm->getValue("pc_08_head") : $CurrentForm->getValue("x_pc_08_head");
		if (!$this->pc_08_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_08_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_08_head->setFormValue($val);
		}

		// Check field name 'pc_09_head' first before field var 'x_pc_09_head'
		$val = $CurrentForm->hasValue("pc_09_head") ? $CurrentForm->getValue("pc_09_head") : $CurrentForm->getValue("x_pc_09_head");
		if (!$this->pc_09_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_09_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_09_head->setFormValue($val);
		}

		// Check field name 'pc_10_head' first before field var 'x_pc_10_head'
		$val = $CurrentForm->hasValue("pc_10_head") ? $CurrentForm->getValue("pc_10_head") : $CurrentForm->getValue("x_pc_10_head");
		if (!$this->pc_10_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_10_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_10_head->setFormValue($val);
		}

		// Check field name 'pc_11_head' first before field var 'x_pc_11_head'
		$val = $CurrentForm->hasValue("pc_11_head") ? $CurrentForm->getValue("pc_11_head") : $CurrentForm->getValue("x_pc_11_head");
		if (!$this->pc_11_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_11_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_11_head->setFormValue($val);
		}

		// Check field name 'pc_12_head' first before field var 'x_pc_12_head'
		$val = $CurrentForm->hasValue("pc_12_head") ? $CurrentForm->getValue("pc_12_head") : $CurrentForm->getValue("x_pc_12_head");
		if (!$this->pc_12_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pc_12_head->Visible = FALSE; // Disable update for API request
			else
				$this->pc_12_head->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->product_group->CurrentValue = $this->product_group->FormValue;
		$this->calculation_method->CurrentValue = $this->calculation_method->FormValue;
		$this->shape->CurrentValue = $this->shape->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->cbm->CurrentValue = $this->cbm->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->v_00->CurrentValue = $this->v_00->FormValue;
		$this->v_01->CurrentValue = $this->v_01->FormValue;
		$this->v_01_validation->CurrentValue = $this->v_01_validation->FormValue;
		$this->v_02->CurrentValue = $this->v_02->FormValue;
		$this->v_02_validation->CurrentValue = $this->v_02_validation->FormValue;
		$this->v_03->CurrentValue = $this->v_03->FormValue;
		$this->v_03_validation->CurrentValue = $this->v_03_validation->FormValue;
		$this->v_04->CurrentValue = $this->v_04->FormValue;
		$this->v_04_validation->CurrentValue = $this->v_04_validation->FormValue;
		$this->v_05->CurrentValue = $this->v_05->FormValue;
		$this->v_05_validation->CurrentValue = $this->v_05_validation->FormValue;
		$this->v_06->CurrentValue = $this->v_06->FormValue;
		$this->v_06_validation->CurrentValue = $this->v_06_validation->FormValue;
		$this->v_07->CurrentValue = $this->v_07->FormValue;
		$this->v_07_validation->CurrentValue = $this->v_07_validation->FormValue;
		$this->v_08->CurrentValue = $this->v_08->FormValue;
		$this->v_08_validation->CurrentValue = $this->v_08_validation->FormValue;
		$this->v_09->CurrentValue = $this->v_09->FormValue;
		$this->v_09_validation->CurrentValue = $this->v_09_validation->FormValue;
		$this->v_10->CurrentValue = $this->v_10->FormValue;
		$this->v_10_validation->CurrentValue = $this->v_10_validation->FormValue;
		$this->b_01_head->CurrentValue = $this->b_01_head->FormValue;
		$this->b_02_head->CurrentValue = $this->b_02_head->FormValue;
		$this->b_03_head->CurrentValue = $this->b_03_head->FormValue;
		$this->b_04_head->CurrentValue = $this->b_04_head->FormValue;
		$this->b_05_head->CurrentValue = $this->b_05_head->FormValue;
		$this->b_06_head->CurrentValue = $this->b_06_head->FormValue;
		$this->b_07_head->CurrentValue = $this->b_07_head->FormValue;
		$this->b_08_head->CurrentValue = $this->b_08_head->FormValue;
		$this->b_09_head->CurrentValue = $this->b_09_head->FormValue;
		$this->b_10_head->CurrentValue = $this->b_10_head->FormValue;
		$this->b_11_head->CurrentValue = $this->b_11_head->FormValue;
		$this->b_12_head->CurrentValue = $this->b_12_head->FormValue;
		$this->b_13_head->CurrentValue = $this->b_13_head->FormValue;
		$this->b_14_head->CurrentValue = $this->b_14_head->FormValue;
		$this->b_15_head->CurrentValue = $this->b_15_head->FormValue;
		$this->q_sku->CurrentValue = $this->q_sku->FormValue;
		$this->t_01_head->CurrentValue = $this->t_01_head->FormValue;
		$this->t_02_head->CurrentValue = $this->t_02_head->FormValue;
		$this->t_03_head->CurrentValue = $this->t_03_head->FormValue;
		$this->t_04_head->CurrentValue = $this->t_04_head->FormValue;
		$this->t_05_head->CurrentValue = $this->t_05_head->FormValue;
		$this->t_06_head->CurrentValue = $this->t_06_head->FormValue;
		$this->t_07_head->CurrentValue = $this->t_07_head->FormValue;
		$this->t_08_head->CurrentValue = $this->t_08_head->FormValue;
		$this->t_09_head->CurrentValue = $this->t_09_head->FormValue;
		$this->t_10_head->CurrentValue = $this->t_10_head->FormValue;
		$this->t_11_head->CurrentValue = $this->t_11_head->FormValue;
		$this->t_12_head->CurrentValue = $this->t_12_head->FormValue;
		$this->t_13_head->CurrentValue = $this->t_13_head->FormValue;
		$this->t_14_head->CurrentValue = $this->t_14_head->FormValue;
		$this->t_15_head->CurrentValue = $this->t_15_head->FormValue;
		$this->po_01_head->CurrentValue = $this->po_01_head->FormValue;
		$this->po_02_head->CurrentValue = $this->po_02_head->FormValue;
		$this->po_03_head->CurrentValue = $this->po_03_head->FormValue;
		$this->po_04_head->CurrentValue = $this->po_04_head->FormValue;
		$this->po_05_head->CurrentValue = $this->po_05_head->FormValue;
		$this->po_06_head->CurrentValue = $this->po_06_head->FormValue;
		$this->po_07_head->CurrentValue = $this->po_07_head->FormValue;
		$this->po_08_head->CurrentValue = $this->po_08_head->FormValue;
		$this->po_17_head->CurrentValue = $this->po_17_head->FormValue;
		$this->po_18_head->CurrentValue = $this->po_18_head->FormValue;
		$this->po_19_head->CurrentValue = $this->po_19_head->FormValue;
		$this->po_20_head->CurrentValue = $this->po_20_head->FormValue;
		$this->jc_01_head->CurrentValue = $this->jc_01_head->FormValue;
		$this->jc_02_head->CurrentValue = $this->jc_02_head->FormValue;
		$this->jc_03_head->CurrentValue = $this->jc_03_head->FormValue;
		$this->jc_04_head->CurrentValue = $this->jc_04_head->FormValue;
		$this->jc_05_head->CurrentValue = $this->jc_05_head->FormValue;
		$this->jc_06_head->CurrentValue = $this->jc_06_head->FormValue;
		$this->jc_07_head->CurrentValue = $this->jc_07_head->FormValue;
		$this->jc_08_head->CurrentValue = $this->jc_08_head->FormValue;
		$this->jc_09_head->CurrentValue = $this->jc_09_head->FormValue;
		$this->jc_10_head->CurrentValue = $this->jc_10_head->FormValue;
		$this->pc_shape->CurrentValue = $this->pc_shape->FormValue;
		$this->pc_unit->CurrentValue = $this->pc_unit->FormValue;
		$this->pc_w->CurrentValue = $this->pc_w->FormValue;
		$this->pc_l->CurrentValue = $this->pc_l->FormValue;
		$this->pc_h->CurrentValue = $this->pc_h->FormValue;
		$this->pc_partner_size->CurrentValue = $this->pc_partner_size->FormValue;
		$this->pc_sqm->CurrentValue = $this->pc_sqm->FormValue;
		$this->pc_01_head->CurrentValue = $this->pc_01_head->FormValue;
		$this->pc_02_head->CurrentValue = $this->pc_02_head->FormValue;
		$this->pc_03_head->CurrentValue = $this->pc_03_head->FormValue;
		$this->pc_04_head->CurrentValue = $this->pc_04_head->FormValue;
		$this->pc_05_head->CurrentValue = $this->pc_05_head->FormValue;
		$this->pc_06_head->CurrentValue = $this->pc_06_head->FormValue;
		$this->pc_07_head->CurrentValue = $this->pc_07_head->FormValue;
		$this->pc_08_head->CurrentValue = $this->pc_08_head->FormValue;
		$this->pc_09_head->CurrentValue = $this->pc_09_head->FormValue;
		$this->pc_10_head->CurrentValue = $this->pc_10_head->FormValue;
		$this->pc_11_head->CurrentValue = $this->pc_11_head->FormValue;
		$this->pc_12_head->CurrentValue = $this->pc_12_head->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->product_group->setDbValue($row['product_group']);
		$this->calculation_method->setDbValue($row['calculation_method']);
		$this->shape->setDbValue($row['shape']);
		$this->sqm->setDbValue($row['sqm']);
		$this->cbm->setDbValue($row['cbm']);
		$this->process->setDbValue($row['process']);
		$this->status->setDbValue($row['status']);
		$this->v_00->setDbValue($row['v_00']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_01_validation->setDbValue($row['v_01_validation']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_02_validation->setDbValue($row['v_02_validation']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_03_validation->setDbValue($row['v_03_validation']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_04_validation->setDbValue($row['v_04_validation']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_05_validation->setDbValue($row['v_05_validation']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_06_validation->setDbValue($row['v_06_validation']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_07_validation->setDbValue($row['v_07_validation']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_08_validation->setDbValue($row['v_08_validation']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_09_validation->setDbValue($row['v_09_validation']);
		$this->v_10->setDbValue($row['v_10']);
		$this->v_10_validation->setDbValue($row['v_10_validation']);
		$this->b_01_head->setDbValue($row['b_01_head']);
		$this->b_02_head->setDbValue($row['b_02_head']);
		$this->b_03_head->setDbValue($row['b_03_head']);
		$this->b_04_head->setDbValue($row['b_04_head']);
		$this->b_05_head->setDbValue($row['b_05_head']);
		$this->b_06_head->setDbValue($row['b_06_head']);
		$this->b_07_head->setDbValue($row['b_07_head']);
		$this->b_08_head->setDbValue($row['b_08_head']);
		$this->b_09_head->setDbValue($row['b_09_head']);
		$this->b_10_head->setDbValue($row['b_10_head']);
		$this->b_11_head->setDbValue($row['b_11_head']);
		$this->b_12_head->setDbValue($row['b_12_head']);
		$this->b_13_head->setDbValue($row['b_13_head']);
		$this->b_14_head->setDbValue($row['b_14_head']);
		$this->b_15_head->setDbValue($row['b_15_head']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->t_01_head->setDbValue($row['t_01_head']);
		$this->t_02_head->setDbValue($row['t_02_head']);
		$this->t_03_head->setDbValue($row['t_03_head']);
		$this->t_04_head->setDbValue($row['t_04_head']);
		$this->t_05_head->setDbValue($row['t_05_head']);
		$this->t_06_head->setDbValue($row['t_06_head']);
		$this->t_07_head->setDbValue($row['t_07_head']);
		$this->t_08_head->setDbValue($row['t_08_head']);
		$this->t_09_head->setDbValue($row['t_09_head']);
		$this->t_10_head->setDbValue($row['t_10_head']);
		$this->t_11_head->setDbValue($row['t_11_head']);
		$this->t_12_head->setDbValue($row['t_12_head']);
		$this->t_13_head->setDbValue($row['t_13_head']);
		$this->t_14_head->setDbValue($row['t_14_head']);
		$this->t_15_head->setDbValue($row['t_15_head']);
		$this->po_01_head->setDbValue($row['po_01_head']);
		$this->po_02_head->setDbValue($row['po_02_head']);
		$this->po_03_head->setDbValue($row['po_03_head']);
		$this->po_04_head->setDbValue($row['po_04_head']);
		$this->po_05_head->setDbValue($row['po_05_head']);
		$this->po_06_head->setDbValue($row['po_06_head']);
		$this->po_07_head->setDbValue($row['po_07_head']);
		$this->po_08_head->setDbValue($row['po_08_head']);
		$this->po_17_head->setDbValue($row['po_17_head']);
		$this->po_18_head->setDbValue($row['po_18_head']);
		$this->po_19_head->setDbValue($row['po_19_head']);
		$this->po_20_head->setDbValue($row['po_20_head']);
		$this->jc_01_head->setDbValue($row['jc_01_head']);
		$this->jc_02_head->setDbValue($row['jc_02_head']);
		$this->jc_03_head->setDbValue($row['jc_03_head']);
		$this->jc_04_head->setDbValue($row['jc_04_head']);
		$this->jc_05_head->setDbValue($row['jc_05_head']);
		$this->jc_06_head->setDbValue($row['jc_06_head']);
		$this->jc_07_head->setDbValue($row['jc_07_head']);
		$this->jc_08_head->setDbValue($row['jc_08_head']);
		$this->jc_09_head->setDbValue($row['jc_09_head']);
		$this->jc_10_head->setDbValue($row['jc_10_head']);
		$this->pc_shape->setDbValue($row['pc_shape']);
		$this->pc_unit->setDbValue($row['pc_unit']);
		$this->pc_w->setDbValue($row['pc_w']);
		$this->pc_l->setDbValue($row['pc_l']);
		$this->pc_h->setDbValue($row['pc_h']);
		$this->pc_partner_size->setDbValue($row['pc_partner_size']);
		$this->pc_sqm->setDbValue($row['pc_sqm']);
		$this->pc_01_head->setDbValue($row['pc_01_head']);
		$this->pc_02_head->setDbValue($row['pc_02_head']);
		$this->pc_03_head->setDbValue($row['pc_03_head']);
		$this->pc_04_head->setDbValue($row['pc_04_head']);
		$this->pc_05_head->setDbValue($row['pc_05_head']);
		$this->pc_06_head->setDbValue($row['pc_06_head']);
		$this->pc_07_head->setDbValue($row['pc_07_head']);
		$this->pc_08_head->setDbValue($row['pc_08_head']);
		$this->pc_09_head->setDbValue($row['pc_09_head']);
		$this->pc_10_head->setDbValue($row['pc_10_head']);
		$this->pc_11_head->setDbValue($row['pc_11_head']);
		$this->pc_12_head->setDbValue($row['pc_12_head']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['product_group'] = $this->product_group->CurrentValue;
		$row['calculation_method'] = $this->calculation_method->CurrentValue;
		$row['shape'] = $this->shape->CurrentValue;
		$row['sqm'] = $this->sqm->CurrentValue;
		$row['cbm'] = $this->cbm->CurrentValue;
		$row['process'] = $this->process->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['v_00'] = $this->v_00->CurrentValue;
		$row['v_01'] = $this->v_01->CurrentValue;
		$row['v_01_validation'] = $this->v_01_validation->CurrentValue;
		$row['v_02'] = $this->v_02->CurrentValue;
		$row['v_02_validation'] = $this->v_02_validation->CurrentValue;
		$row['v_03'] = $this->v_03->CurrentValue;
		$row['v_03_validation'] = $this->v_03_validation->CurrentValue;
		$row['v_04'] = $this->v_04->CurrentValue;
		$row['v_04_validation'] = $this->v_04_validation->CurrentValue;
		$row['v_05'] = $this->v_05->CurrentValue;
		$row['v_05_validation'] = $this->v_05_validation->CurrentValue;
		$row['v_06'] = $this->v_06->CurrentValue;
		$row['v_06_validation'] = $this->v_06_validation->CurrentValue;
		$row['v_07'] = $this->v_07->CurrentValue;
		$row['v_07_validation'] = $this->v_07_validation->CurrentValue;
		$row['v_08'] = $this->v_08->CurrentValue;
		$row['v_08_validation'] = $this->v_08_validation->CurrentValue;
		$row['v_09'] = $this->v_09->CurrentValue;
		$row['v_09_validation'] = $this->v_09_validation->CurrentValue;
		$row['v_10'] = $this->v_10->CurrentValue;
		$row['v_10_validation'] = $this->v_10_validation->CurrentValue;
		$row['b_01_head'] = $this->b_01_head->CurrentValue;
		$row['b_02_head'] = $this->b_02_head->CurrentValue;
		$row['b_03_head'] = $this->b_03_head->CurrentValue;
		$row['b_04_head'] = $this->b_04_head->CurrentValue;
		$row['b_05_head'] = $this->b_05_head->CurrentValue;
		$row['b_06_head'] = $this->b_06_head->CurrentValue;
		$row['b_07_head'] = $this->b_07_head->CurrentValue;
		$row['b_08_head'] = $this->b_08_head->CurrentValue;
		$row['b_09_head'] = $this->b_09_head->CurrentValue;
		$row['b_10_head'] = $this->b_10_head->CurrentValue;
		$row['b_11_head'] = $this->b_11_head->CurrentValue;
		$row['b_12_head'] = $this->b_12_head->CurrentValue;
		$row['b_13_head'] = $this->b_13_head->CurrentValue;
		$row['b_14_head'] = $this->b_14_head->CurrentValue;
		$row['b_15_head'] = $this->b_15_head->CurrentValue;
		$row['q_sku'] = $this->q_sku->CurrentValue;
		$row['t_01_head'] = $this->t_01_head->CurrentValue;
		$row['t_02_head'] = $this->t_02_head->CurrentValue;
		$row['t_03_head'] = $this->t_03_head->CurrentValue;
		$row['t_04_head'] = $this->t_04_head->CurrentValue;
		$row['t_05_head'] = $this->t_05_head->CurrentValue;
		$row['t_06_head'] = $this->t_06_head->CurrentValue;
		$row['t_07_head'] = $this->t_07_head->CurrentValue;
		$row['t_08_head'] = $this->t_08_head->CurrentValue;
		$row['t_09_head'] = $this->t_09_head->CurrentValue;
		$row['t_10_head'] = $this->t_10_head->CurrentValue;
		$row['t_11_head'] = $this->t_11_head->CurrentValue;
		$row['t_12_head'] = $this->t_12_head->CurrentValue;
		$row['t_13_head'] = $this->t_13_head->CurrentValue;
		$row['t_14_head'] = $this->t_14_head->CurrentValue;
		$row['t_15_head'] = $this->t_15_head->CurrentValue;
		$row['po_01_head'] = $this->po_01_head->CurrentValue;
		$row['po_02_head'] = $this->po_02_head->CurrentValue;
		$row['po_03_head'] = $this->po_03_head->CurrentValue;
		$row['po_04_head'] = $this->po_04_head->CurrentValue;
		$row['po_05_head'] = $this->po_05_head->CurrentValue;
		$row['po_06_head'] = $this->po_06_head->CurrentValue;
		$row['po_07_head'] = $this->po_07_head->CurrentValue;
		$row['po_08_head'] = $this->po_08_head->CurrentValue;
		$row['po_17_head'] = $this->po_17_head->CurrentValue;
		$row['po_18_head'] = $this->po_18_head->CurrentValue;
		$row['po_19_head'] = $this->po_19_head->CurrentValue;
		$row['po_20_head'] = $this->po_20_head->CurrentValue;
		$row['jc_01_head'] = $this->jc_01_head->CurrentValue;
		$row['jc_02_head'] = $this->jc_02_head->CurrentValue;
		$row['jc_03_head'] = $this->jc_03_head->CurrentValue;
		$row['jc_04_head'] = $this->jc_04_head->CurrentValue;
		$row['jc_05_head'] = $this->jc_05_head->CurrentValue;
		$row['jc_06_head'] = $this->jc_06_head->CurrentValue;
		$row['jc_07_head'] = $this->jc_07_head->CurrentValue;
		$row['jc_08_head'] = $this->jc_08_head->CurrentValue;
		$row['jc_09_head'] = $this->jc_09_head->CurrentValue;
		$row['jc_10_head'] = $this->jc_10_head->CurrentValue;
		$row['pc_shape'] = $this->pc_shape->CurrentValue;
		$row['pc_unit'] = $this->pc_unit->CurrentValue;
		$row['pc_w'] = $this->pc_w->CurrentValue;
		$row['pc_l'] = $this->pc_l->CurrentValue;
		$row['pc_h'] = $this->pc_h->CurrentValue;
		$row['pc_partner_size'] = $this->pc_partner_size->CurrentValue;
		$row['pc_sqm'] = $this->pc_sqm->CurrentValue;
		$row['pc_01_head'] = $this->pc_01_head->CurrentValue;
		$row['pc_02_head'] = $this->pc_02_head->CurrentValue;
		$row['pc_03_head'] = $this->pc_03_head->CurrentValue;
		$row['pc_04_head'] = $this->pc_04_head->CurrentValue;
		$row['pc_05_head'] = $this->pc_05_head->CurrentValue;
		$row['pc_06_head'] = $this->pc_06_head->CurrentValue;
		$row['pc_07_head'] = $this->pc_07_head->CurrentValue;
		$row['pc_08_head'] = $this->pc_08_head->CurrentValue;
		$row['pc_09_head'] = $this->pc_09_head->CurrentValue;
		$row['pc_10_head'] = $this->pc_10_head->CurrentValue;
		$row['pc_11_head'] = $this->pc_11_head->CurrentValue;
		$row['pc_12_head'] = $this->pc_12_head->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['image'] = $this->image->Upload->DbValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// product_group
		// calculation_method
		// shape
		// sqm
		// cbm
		// process
		// status
		// v_00
		// v_01
		// v_01_validation
		// v_02
		// v_02_validation
		// v_03
		// v_03_validation
		// v_04
		// v_04_validation
		// v_05
		// v_05_validation
		// v_06
		// v_06_validation
		// v_07
		// v_07_validation
		// v_08
		// v_08_validation
		// v_09
		// v_09_validation
		// v_10
		// v_10_validation
		// b_01_head
		// b_02_head
		// b_03_head
		// b_04_head
		// b_05_head
		// b_06_head
		// b_07_head
		// b_08_head
		// b_09_head
		// b_10_head
		// b_11_head
		// b_12_head
		// b_13_head
		// b_14_head
		// b_15_head
		// q_sku
		// t_01_head
		// t_02_head
		// t_03_head
		// t_04_head
		// t_05_head
		// t_06_head
		// t_07_head
		// t_08_head
		// t_09_head
		// t_10_head
		// t_11_head
		// t_12_head
		// t_13_head
		// t_14_head
		// t_15_head
		// po_01_head
		// po_02_head
		// po_03_head
		// po_04_head
		// po_05_head
		// po_06_head
		// po_07_head
		// po_08_head
		// po_17_head
		// po_18_head
		// po_19_head
		// po_20_head
		// jc_01_head
		// jc_02_head
		// jc_03_head
		// jc_04_head
		// jc_05_head
		// jc_06_head
		// jc_07_head
		// jc_08_head
		// jc_09_head
		// jc_10_head
		// pc_shape
		// pc_unit
		// pc_w
		// pc_l
		// pc_h
		// pc_partner_size
		// pc_sqm
		// pc_01_head
		// pc_02_head
		// pc_03_head
		// pc_04_head
		// pc_05_head
		// pc_06_head
		// pc_07_head
		// pc_08_head
		// pc_09_head
		// pc_10_head
		// pc_11_head
		// pc_12_head
		// operator
		// datetime
		// image

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// product_group
			$this->product_group->ViewValue = $this->product_group->CurrentValue;
			$this->product_group->ViewCustomAttributes = "";

			// calculation_method
			$curVal = strval($this->calculation_method->CurrentValue);
			if ($curVal <> "") {
				$this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
				if ($this->calculation_method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->calculation_method->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->calculation_method->ViewValue = $this->calculation_method->CurrentValue;
					}
				}
			} else {
				$this->calculation_method->ViewValue = NULL;
			}
			$this->calculation_method->ViewCustomAttributes = "";

			// shape
			$this->shape->ViewValue = $this->shape->CurrentValue;
			$this->shape->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// v_00
			$this->v_00->ViewValue = $this->v_00->CurrentValue;
			$this->v_00->ViewCustomAttributes = "";

			// v_01
			$this->v_01->ViewValue = $this->v_01->CurrentValue;
			$this->v_01->ViewCustomAttributes = "";

			// v_01_validation
			$this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;
			$this->v_01_validation->ViewCustomAttributes = "";

			// v_02
			$this->v_02->ViewValue = $this->v_02->CurrentValue;
			$this->v_02->ViewCustomAttributes = "";

			// v_02_validation
			$this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;
			$this->v_02_validation->ViewCustomAttributes = "";

			// v_03
			$this->v_03->ViewValue = $this->v_03->CurrentValue;
			$this->v_03->ViewCustomAttributes = "";

			// v_03_validation
			$this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;
			$this->v_03_validation->ViewCustomAttributes = "";

			// v_04
			$this->v_04->ViewValue = $this->v_04->CurrentValue;
			$this->v_04->ViewCustomAttributes = "";

			// v_04_validation
			$this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;
			$this->v_04_validation->ViewCustomAttributes = "";

			// v_05
			$this->v_05->ViewValue = $this->v_05->CurrentValue;
			$this->v_05->ViewCustomAttributes = "";

			// v_05_validation
			$this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;
			$this->v_05_validation->ViewCustomAttributes = "";

			// v_06
			$this->v_06->ViewValue = $this->v_06->CurrentValue;
			$this->v_06->ViewCustomAttributes = "";

			// v_06_validation
			$this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;
			$this->v_06_validation->ViewCustomAttributes = "";

			// v_07
			$this->v_07->ViewValue = $this->v_07->CurrentValue;
			$this->v_07->ViewCustomAttributes = "";

			// v_07_validation
			$this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;
			$this->v_07_validation->ViewCustomAttributes = "";

			// v_08
			$this->v_08->ViewValue = $this->v_08->CurrentValue;
			$this->v_08->ViewCustomAttributes = "";

			// v_08_validation
			$this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;
			$this->v_08_validation->ViewCustomAttributes = "";

			// v_09
			$this->v_09->ViewValue = $this->v_09->CurrentValue;
			$this->v_09->ViewCustomAttributes = "";

			// v_09_validation
			$this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;
			$this->v_09_validation->ViewCustomAttributes = "";

			// v_10
			$this->v_10->ViewValue = $this->v_10->CurrentValue;
			$this->v_10->ViewCustomAttributes = "";

			// v_10_validation
			$this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;
			$this->v_10_validation->ViewCustomAttributes = "";

			// b_01_head
			$this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;
			$this->b_01_head->ViewCustomAttributes = "";

			// b_02_head
			$this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;
			$this->b_02_head->ViewCustomAttributes = "";

			// b_03_head
			$this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;
			$this->b_03_head->ViewCustomAttributes = "";

			// b_04_head
			$this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;
			$this->b_04_head->ViewCustomAttributes = "";

			// b_05_head
			$this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;
			$this->b_05_head->ViewCustomAttributes = "";

			// b_06_head
			$this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;
			$this->b_06_head->ViewCustomAttributes = "";

			// b_07_head
			$this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;
			$this->b_07_head->ViewCustomAttributes = "";

			// b_08_head
			$this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;
			$this->b_08_head->ViewCustomAttributes = "";

			// b_09_head
			$this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;
			$this->b_09_head->ViewCustomAttributes = "";

			// b_10_head
			$this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;
			$this->b_10_head->ViewCustomAttributes = "";

			// b_11_head
			$this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;
			$this->b_11_head->ViewCustomAttributes = "";

			// b_12_head
			$this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;
			$this->b_12_head->ViewCustomAttributes = "";

			// b_13_head
			$this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;
			$this->b_13_head->ViewCustomAttributes = "";

			// b_14_head
			$this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;
			$this->b_14_head->ViewCustomAttributes = "";

			// b_15_head
			$this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;
			$this->b_15_head->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewCustomAttributes = "";

			// t_01_head
			$this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;
			$this->t_01_head->ViewCustomAttributes = "";

			// t_02_head
			$this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;
			$this->t_02_head->ViewCustomAttributes = "";

			// t_03_head
			$this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;
			$this->t_03_head->ViewCustomAttributes = "";

			// t_04_head
			$this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;
			$this->t_04_head->ViewCustomAttributes = "";

			// t_05_head
			$this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;
			$this->t_05_head->ViewCustomAttributes = "";

			// t_06_head
			$this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;
			$this->t_06_head->ViewCustomAttributes = "";

			// t_07_head
			$this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;
			$this->t_07_head->ViewCustomAttributes = "";

			// t_08_head
			$this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;
			$this->t_08_head->ViewCustomAttributes = "";

			// t_09_head
			$this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;
			$this->t_09_head->ViewCustomAttributes = "";

			// t_10_head
			$this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;
			$this->t_10_head->ViewCustomAttributes = "";

			// t_11_head
			$this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;
			$this->t_11_head->ViewCustomAttributes = "";

			// t_12_head
			$this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;
			$this->t_12_head->ViewCustomAttributes = "";

			// t_13_head
			$this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;
			$this->t_13_head->ViewCustomAttributes = "";

			// t_14_head
			$this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;
			$this->t_14_head->ViewCustomAttributes = "";

			// t_15_head
			$this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;
			$this->t_15_head->ViewCustomAttributes = "";

			// po_01_head
			$this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;
			$this->po_01_head->ViewCustomAttributes = "";

			// po_02_head
			$this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;
			$this->po_02_head->ViewCustomAttributes = "";

			// po_03_head
			$this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;
			$this->po_03_head->ViewCustomAttributes = "";

			// po_04_head
			$this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;
			$this->po_04_head->ViewCustomAttributes = "";

			// po_05_head
			$this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;
			$this->po_05_head->ViewCustomAttributes = "";

			// po_06_head
			$this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;
			$this->po_06_head->ViewCustomAttributes = "";

			// po_07_head
			$this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;
			$this->po_07_head->ViewCustomAttributes = "";

			// po_08_head
			$this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;
			$this->po_08_head->ViewCustomAttributes = "";

			// po_17_head
			$this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;
			$this->po_17_head->ViewCustomAttributes = "";

			// po_18_head
			$this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;
			$this->po_18_head->ViewCustomAttributes = "";

			// po_19_head
			$this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;
			$this->po_19_head->ViewCustomAttributes = "";

			// po_20_head
			$this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;
			$this->po_20_head->ViewCustomAttributes = "";

			// jc_01_head
			$this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;
			$this->jc_01_head->ViewCustomAttributes = "";

			// jc_02_head
			$this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;
			$this->jc_02_head->ViewCustomAttributes = "";

			// jc_03_head
			$this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;
			$this->jc_03_head->ViewCustomAttributes = "";

			// jc_04_head
			$this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;
			$this->jc_04_head->ViewCustomAttributes = "";

			// jc_05_head
			$this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;
			$this->jc_05_head->ViewCustomAttributes = "";

			// jc_06_head
			$this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;
			$this->jc_06_head->ViewCustomAttributes = "";

			// jc_07_head
			$this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;
			$this->jc_07_head->ViewCustomAttributes = "";

			// jc_08_head
			$this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;
			$this->jc_08_head->ViewCustomAttributes = "";

			// jc_09_head
			$this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;
			$this->jc_09_head->ViewCustomAttributes = "";

			// jc_10_head
			$this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;
			$this->jc_10_head->ViewCustomAttributes = "";

			// pc_shape
			$this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;
			$this->pc_shape->ViewCustomAttributes = "";

			// pc_unit
			$this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;
			$this->pc_unit->ViewCustomAttributes = "";

			// pc_w
			$this->pc_w->ViewValue = $this->pc_w->CurrentValue;
			$this->pc_w->ViewCustomAttributes = "";

			// pc_l
			$this->pc_l->ViewValue = $this->pc_l->CurrentValue;
			$this->pc_l->ViewCustomAttributes = "";

			// pc_h
			$this->pc_h->ViewValue = $this->pc_h->CurrentValue;
			$this->pc_h->ViewCustomAttributes = "";

			// pc_partner_size
			$this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;
			$this->pc_partner_size->ViewCustomAttributes = "";

			// pc_sqm
			$this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;
			$this->pc_sqm->ViewCustomAttributes = "";

			// pc_01_head
			$this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;
			$this->pc_01_head->ViewCustomAttributes = "";

			// pc_02_head
			$this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;
			$this->pc_02_head->ViewCustomAttributes = "";

			// pc_03_head
			$this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;
			$this->pc_03_head->ViewCustomAttributes = "";

			// pc_04_head
			$this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;
			$this->pc_04_head->ViewCustomAttributes = "";

			// pc_05_head
			$this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;
			$this->pc_05_head->ViewCustomAttributes = "";

			// pc_06_head
			$this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;
			$this->pc_06_head->ViewCustomAttributes = "";

			// pc_07_head
			$this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;
			$this->pc_07_head->ViewCustomAttributes = "";

			// pc_08_head
			$this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;
			$this->pc_08_head->ViewCustomAttributes = "";

			// pc_09_head
			$this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;
			$this->pc_09_head->ViewCustomAttributes = "";

			// pc_10_head
			$this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;
			$this->pc_10_head->ViewCustomAttributes = "";

			// pc_11_head
			$this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;
			$this->pc_11_head->ViewCustomAttributes = "";

			// pc_12_head
			$this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;
			$this->pc_12_head->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// product_group
			$this->product_group->LinkCustomAttributes = "";
			$this->product_group->HrefValue = "";
			$this->product_group->TooltipValue = "";

			// calculation_method
			$this->calculation_method->LinkCustomAttributes = "";
			$this->calculation_method->HrefValue = "";
			$this->calculation_method->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// v_00
			$this->v_00->LinkCustomAttributes = "";
			$this->v_00->HrefValue = "";
			$this->v_00->TooltipValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";
			$this->v_01->TooltipValue = "";

			// v_01_validation
			$this->v_01_validation->LinkCustomAttributes = "";
			$this->v_01_validation->HrefValue = "";
			$this->v_01_validation->TooltipValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";
			$this->v_02->TooltipValue = "";

			// v_02_validation
			$this->v_02_validation->LinkCustomAttributes = "";
			$this->v_02_validation->HrefValue = "";
			$this->v_02_validation->TooltipValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";
			$this->v_03->TooltipValue = "";

			// v_03_validation
			$this->v_03_validation->LinkCustomAttributes = "";
			$this->v_03_validation->HrefValue = "";
			$this->v_03_validation->TooltipValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";
			$this->v_04->TooltipValue = "";

			// v_04_validation
			$this->v_04_validation->LinkCustomAttributes = "";
			$this->v_04_validation->HrefValue = "";
			$this->v_04_validation->TooltipValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";
			$this->v_05->TooltipValue = "";

			// v_05_validation
			$this->v_05_validation->LinkCustomAttributes = "";
			$this->v_05_validation->HrefValue = "";
			$this->v_05_validation->TooltipValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";
			$this->v_06->TooltipValue = "";

			// v_06_validation
			$this->v_06_validation->LinkCustomAttributes = "";
			$this->v_06_validation->HrefValue = "";
			$this->v_06_validation->TooltipValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";
			$this->v_07->TooltipValue = "";

			// v_07_validation
			$this->v_07_validation->LinkCustomAttributes = "";
			$this->v_07_validation->HrefValue = "";
			$this->v_07_validation->TooltipValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";
			$this->v_08->TooltipValue = "";

			// v_08_validation
			$this->v_08_validation->LinkCustomAttributes = "";
			$this->v_08_validation->HrefValue = "";
			$this->v_08_validation->TooltipValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";
			$this->v_09->TooltipValue = "";

			// v_09_validation
			$this->v_09_validation->LinkCustomAttributes = "";
			$this->v_09_validation->HrefValue = "";
			$this->v_09_validation->TooltipValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";
			$this->v_10->TooltipValue = "";

			// v_10_validation
			$this->v_10_validation->LinkCustomAttributes = "";
			$this->v_10_validation->HrefValue = "";
			$this->v_10_validation->TooltipValue = "";

			// b_01_head
			$this->b_01_head->LinkCustomAttributes = "";
			$this->b_01_head->HrefValue = "";
			$this->b_01_head->TooltipValue = "";

			// b_02_head
			$this->b_02_head->LinkCustomAttributes = "";
			$this->b_02_head->HrefValue = "";
			$this->b_02_head->TooltipValue = "";

			// b_03_head
			$this->b_03_head->LinkCustomAttributes = "";
			$this->b_03_head->HrefValue = "";
			$this->b_03_head->TooltipValue = "";

			// b_04_head
			$this->b_04_head->LinkCustomAttributes = "";
			$this->b_04_head->HrefValue = "";
			$this->b_04_head->TooltipValue = "";

			// b_05_head
			$this->b_05_head->LinkCustomAttributes = "";
			$this->b_05_head->HrefValue = "";
			$this->b_05_head->TooltipValue = "";

			// b_06_head
			$this->b_06_head->LinkCustomAttributes = "";
			$this->b_06_head->HrefValue = "";
			$this->b_06_head->TooltipValue = "";

			// b_07_head
			$this->b_07_head->LinkCustomAttributes = "";
			$this->b_07_head->HrefValue = "";
			$this->b_07_head->TooltipValue = "";

			// b_08_head
			$this->b_08_head->LinkCustomAttributes = "";
			$this->b_08_head->HrefValue = "";
			$this->b_08_head->TooltipValue = "";

			// b_09_head
			$this->b_09_head->LinkCustomAttributes = "";
			$this->b_09_head->HrefValue = "";
			$this->b_09_head->TooltipValue = "";

			// b_10_head
			$this->b_10_head->LinkCustomAttributes = "";
			$this->b_10_head->HrefValue = "";
			$this->b_10_head->TooltipValue = "";

			// b_11_head
			$this->b_11_head->LinkCustomAttributes = "";
			$this->b_11_head->HrefValue = "";
			$this->b_11_head->TooltipValue = "";

			// b_12_head
			$this->b_12_head->LinkCustomAttributes = "";
			$this->b_12_head->HrefValue = "";
			$this->b_12_head->TooltipValue = "";

			// b_13_head
			$this->b_13_head->LinkCustomAttributes = "";
			$this->b_13_head->HrefValue = "";
			$this->b_13_head->TooltipValue = "";

			// b_14_head
			$this->b_14_head->LinkCustomAttributes = "";
			$this->b_14_head->HrefValue = "";
			$this->b_14_head->TooltipValue = "";

			// b_15_head
			$this->b_15_head->LinkCustomAttributes = "";
			$this->b_15_head->HrefValue = "";
			$this->b_15_head->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// t_01_head
			$this->t_01_head->LinkCustomAttributes = "";
			$this->t_01_head->HrefValue = "";
			$this->t_01_head->TooltipValue = "";

			// t_02_head
			$this->t_02_head->LinkCustomAttributes = "";
			$this->t_02_head->HrefValue = "";
			$this->t_02_head->TooltipValue = "";

			// t_03_head
			$this->t_03_head->LinkCustomAttributes = "";
			$this->t_03_head->HrefValue = "";
			$this->t_03_head->TooltipValue = "";

			// t_04_head
			$this->t_04_head->LinkCustomAttributes = "";
			$this->t_04_head->HrefValue = "";
			$this->t_04_head->TooltipValue = "";

			// t_05_head
			$this->t_05_head->LinkCustomAttributes = "";
			$this->t_05_head->HrefValue = "";
			$this->t_05_head->TooltipValue = "";

			// t_06_head
			$this->t_06_head->LinkCustomAttributes = "";
			$this->t_06_head->HrefValue = "";
			$this->t_06_head->TooltipValue = "";

			// t_07_head
			$this->t_07_head->LinkCustomAttributes = "";
			$this->t_07_head->HrefValue = "";
			$this->t_07_head->TooltipValue = "";

			// t_08_head
			$this->t_08_head->LinkCustomAttributes = "";
			$this->t_08_head->HrefValue = "";
			$this->t_08_head->TooltipValue = "";

			// t_09_head
			$this->t_09_head->LinkCustomAttributes = "";
			$this->t_09_head->HrefValue = "";
			$this->t_09_head->TooltipValue = "";

			// t_10_head
			$this->t_10_head->LinkCustomAttributes = "";
			$this->t_10_head->HrefValue = "";
			$this->t_10_head->TooltipValue = "";

			// t_11_head
			$this->t_11_head->LinkCustomAttributes = "";
			$this->t_11_head->HrefValue = "";
			$this->t_11_head->TooltipValue = "";

			// t_12_head
			$this->t_12_head->LinkCustomAttributes = "";
			$this->t_12_head->HrefValue = "";
			$this->t_12_head->TooltipValue = "";

			// t_13_head
			$this->t_13_head->LinkCustomAttributes = "";
			$this->t_13_head->HrefValue = "";
			$this->t_13_head->TooltipValue = "";

			// t_14_head
			$this->t_14_head->LinkCustomAttributes = "";
			$this->t_14_head->HrefValue = "";
			$this->t_14_head->TooltipValue = "";

			// t_15_head
			$this->t_15_head->LinkCustomAttributes = "";
			$this->t_15_head->HrefValue = "";
			$this->t_15_head->TooltipValue = "";

			// po_01_head
			$this->po_01_head->LinkCustomAttributes = "";
			$this->po_01_head->HrefValue = "";
			$this->po_01_head->TooltipValue = "";

			// po_02_head
			$this->po_02_head->LinkCustomAttributes = "";
			$this->po_02_head->HrefValue = "";
			$this->po_02_head->TooltipValue = "";

			// po_03_head
			$this->po_03_head->LinkCustomAttributes = "";
			$this->po_03_head->HrefValue = "";
			$this->po_03_head->TooltipValue = "";

			// po_04_head
			$this->po_04_head->LinkCustomAttributes = "";
			$this->po_04_head->HrefValue = "";
			$this->po_04_head->TooltipValue = "";

			// po_05_head
			$this->po_05_head->LinkCustomAttributes = "";
			$this->po_05_head->HrefValue = "";
			$this->po_05_head->TooltipValue = "";

			// po_06_head
			$this->po_06_head->LinkCustomAttributes = "";
			$this->po_06_head->HrefValue = "";
			$this->po_06_head->TooltipValue = "";

			// po_07_head
			$this->po_07_head->LinkCustomAttributes = "";
			$this->po_07_head->HrefValue = "";
			$this->po_07_head->TooltipValue = "";

			// po_08_head
			$this->po_08_head->LinkCustomAttributes = "";
			$this->po_08_head->HrefValue = "";
			$this->po_08_head->TooltipValue = "";

			// po_17_head
			$this->po_17_head->LinkCustomAttributes = "";
			$this->po_17_head->HrefValue = "";
			$this->po_17_head->TooltipValue = "";

			// po_18_head
			$this->po_18_head->LinkCustomAttributes = "";
			$this->po_18_head->HrefValue = "";
			$this->po_18_head->TooltipValue = "";

			// po_19_head
			$this->po_19_head->LinkCustomAttributes = "";
			$this->po_19_head->HrefValue = "";
			$this->po_19_head->TooltipValue = "";

			// po_20_head
			$this->po_20_head->LinkCustomAttributes = "";
			$this->po_20_head->HrefValue = "";
			$this->po_20_head->TooltipValue = "";

			// jc_01_head
			$this->jc_01_head->LinkCustomAttributes = "";
			$this->jc_01_head->HrefValue = "";
			$this->jc_01_head->TooltipValue = "";

			// jc_02_head
			$this->jc_02_head->LinkCustomAttributes = "";
			$this->jc_02_head->HrefValue = "";
			$this->jc_02_head->TooltipValue = "";

			// jc_03_head
			$this->jc_03_head->LinkCustomAttributes = "";
			$this->jc_03_head->HrefValue = "";
			$this->jc_03_head->TooltipValue = "";

			// jc_04_head
			$this->jc_04_head->LinkCustomAttributes = "";
			$this->jc_04_head->HrefValue = "";
			$this->jc_04_head->TooltipValue = "";

			// jc_05_head
			$this->jc_05_head->LinkCustomAttributes = "";
			$this->jc_05_head->HrefValue = "";
			$this->jc_05_head->TooltipValue = "";

			// jc_06_head
			$this->jc_06_head->LinkCustomAttributes = "";
			$this->jc_06_head->HrefValue = "";
			$this->jc_06_head->TooltipValue = "";

			// jc_07_head
			$this->jc_07_head->LinkCustomAttributes = "";
			$this->jc_07_head->HrefValue = "";
			$this->jc_07_head->TooltipValue = "";

			// jc_08_head
			$this->jc_08_head->LinkCustomAttributes = "";
			$this->jc_08_head->HrefValue = "";
			$this->jc_08_head->TooltipValue = "";

			// jc_09_head
			$this->jc_09_head->LinkCustomAttributes = "";
			$this->jc_09_head->HrefValue = "";
			$this->jc_09_head->TooltipValue = "";

			// jc_10_head
			$this->jc_10_head->LinkCustomAttributes = "";
			$this->jc_10_head->HrefValue = "";
			$this->jc_10_head->TooltipValue = "";

			// pc_shape
			$this->pc_shape->LinkCustomAttributes = "";
			$this->pc_shape->HrefValue = "";
			$this->pc_shape->TooltipValue = "";

			// pc_unit
			$this->pc_unit->LinkCustomAttributes = "";
			$this->pc_unit->HrefValue = "";
			$this->pc_unit->TooltipValue = "";

			// pc_w
			$this->pc_w->LinkCustomAttributes = "";
			$this->pc_w->HrefValue = "";
			$this->pc_w->TooltipValue = "";

			// pc_l
			$this->pc_l->LinkCustomAttributes = "";
			$this->pc_l->HrefValue = "";
			$this->pc_l->TooltipValue = "";

			// pc_h
			$this->pc_h->LinkCustomAttributes = "";
			$this->pc_h->HrefValue = "";
			$this->pc_h->TooltipValue = "";

			// pc_partner_size
			$this->pc_partner_size->LinkCustomAttributes = "";
			$this->pc_partner_size->HrefValue = "";
			$this->pc_partner_size->TooltipValue = "";

			// pc_sqm
			$this->pc_sqm->LinkCustomAttributes = "";
			$this->pc_sqm->HrefValue = "";
			$this->pc_sqm->TooltipValue = "";

			// pc_01_head
			$this->pc_01_head->LinkCustomAttributes = "";
			$this->pc_01_head->HrefValue = "";
			$this->pc_01_head->TooltipValue = "";

			// pc_02_head
			$this->pc_02_head->LinkCustomAttributes = "";
			$this->pc_02_head->HrefValue = "";
			$this->pc_02_head->TooltipValue = "";

			// pc_03_head
			$this->pc_03_head->LinkCustomAttributes = "";
			$this->pc_03_head->HrefValue = "";
			$this->pc_03_head->TooltipValue = "";

			// pc_04_head
			$this->pc_04_head->LinkCustomAttributes = "";
			$this->pc_04_head->HrefValue = "";
			$this->pc_04_head->TooltipValue = "";

			// pc_05_head
			$this->pc_05_head->LinkCustomAttributes = "";
			$this->pc_05_head->HrefValue = "";
			$this->pc_05_head->TooltipValue = "";

			// pc_06_head
			$this->pc_06_head->LinkCustomAttributes = "";
			$this->pc_06_head->HrefValue = "";
			$this->pc_06_head->TooltipValue = "";

			// pc_07_head
			$this->pc_07_head->LinkCustomAttributes = "";
			$this->pc_07_head->HrefValue = "";
			$this->pc_07_head->TooltipValue = "";

			// pc_08_head
			$this->pc_08_head->LinkCustomAttributes = "";
			$this->pc_08_head->HrefValue = "";
			$this->pc_08_head->TooltipValue = "";

			// pc_09_head
			$this->pc_09_head->LinkCustomAttributes = "";
			$this->pc_09_head->HrefValue = "";
			$this->pc_09_head->TooltipValue = "";

			// pc_10_head
			$this->pc_10_head->LinkCustomAttributes = "";
			$this->pc_10_head->HrefValue = "";
			$this->pc_10_head->TooltipValue = "";

			// pc_11_head
			$this->pc_11_head->LinkCustomAttributes = "";
			$this->pc_11_head->HrefValue = "";
			$this->pc_11_head->TooltipValue = "";

			// pc_12_head
			$this->pc_12_head->LinkCustomAttributes = "";
			$this->pc_12_head->HrefValue = "";
			$this->pc_12_head->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "product_group_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// product_group
			$this->product_group->EditAttrs["class"] = "form-control";
			$this->product_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_group->CurrentValue = HtmlDecode($this->product_group->CurrentValue);
			$this->product_group->EditValue = HtmlEncode($this->product_group->CurrentValue);
			$this->product_group->PlaceHolder = RemoveHtml($this->product_group->caption());

			// calculation_method
			$this->calculation_method->EditAttrs["class"] = "form-control";
			$this->calculation_method->EditCustomAttributes = "";
			$curVal = trim(strval($this->calculation_method->CurrentValue));
			if ($curVal <> "")
				$this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
			else
				$this->calculation_method->ViewValue = $this->calculation_method->Lookup !== NULL && is_array($this->calculation_method->Lookup->Options) ? $curVal : NULL;
			if ($this->calculation_method->ViewValue !== NULL) { // Load from cache
				$this->calculation_method->EditValue = array_values($this->calculation_method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->calculation_method->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->calculation_method->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->calculation_method->EditValue = $arwrk;
			}

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->shape->CurrentValue = HtmlDecode($this->shape->CurrentValue);
			$this->shape->EditValue = HtmlEncode($this->shape->CurrentValue);
			$this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sqm->CurrentValue = HtmlDecode($this->sqm->CurrentValue);
			$this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cbm->CurrentValue = HtmlDecode($this->cbm->CurrentValue);
			$this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->CurrentValue));
			if ($curVal <> "")
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// v_00
			$this->v_00->EditAttrs["class"] = "form-control";
			$this->v_00->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
			$this->v_00->EditValue = HtmlEncode($this->v_00->CurrentValue);
			$this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

			// v_01
			$this->v_01->EditAttrs["class"] = "form-control";
			$this->v_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_01->CurrentValue = HtmlDecode($this->v_01->CurrentValue);
			$this->v_01->EditValue = HtmlEncode($this->v_01->CurrentValue);
			$this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

			// v_01_validation
			$this->v_01_validation->EditAttrs["class"] = "form-control";
			$this->v_01_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_01_validation->CurrentValue = HtmlDecode($this->v_01_validation->CurrentValue);
			$this->v_01_validation->EditValue = HtmlEncode($this->v_01_validation->CurrentValue);
			$this->v_01_validation->PlaceHolder = RemoveHtml($this->v_01_validation->caption());

			// v_02
			$this->v_02->EditAttrs["class"] = "form-control";
			$this->v_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_02->CurrentValue = HtmlDecode($this->v_02->CurrentValue);
			$this->v_02->EditValue = HtmlEncode($this->v_02->CurrentValue);
			$this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

			// v_02_validation
			$this->v_02_validation->EditAttrs["class"] = "form-control";
			$this->v_02_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_02_validation->CurrentValue = HtmlDecode($this->v_02_validation->CurrentValue);
			$this->v_02_validation->EditValue = HtmlEncode($this->v_02_validation->CurrentValue);
			$this->v_02_validation->PlaceHolder = RemoveHtml($this->v_02_validation->caption());

			// v_03
			$this->v_03->EditAttrs["class"] = "form-control";
			$this->v_03->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_03->CurrentValue = HtmlDecode($this->v_03->CurrentValue);
			$this->v_03->EditValue = HtmlEncode($this->v_03->CurrentValue);
			$this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

			// v_03_validation
			$this->v_03_validation->EditAttrs["class"] = "form-control";
			$this->v_03_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_03_validation->CurrentValue = HtmlDecode($this->v_03_validation->CurrentValue);
			$this->v_03_validation->EditValue = HtmlEncode($this->v_03_validation->CurrentValue);
			$this->v_03_validation->PlaceHolder = RemoveHtml($this->v_03_validation->caption());

			// v_04
			$this->v_04->EditAttrs["class"] = "form-control";
			$this->v_04->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_04->CurrentValue = HtmlDecode($this->v_04->CurrentValue);
			$this->v_04->EditValue = HtmlEncode($this->v_04->CurrentValue);
			$this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

			// v_04_validation
			$this->v_04_validation->EditAttrs["class"] = "form-control";
			$this->v_04_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_04_validation->CurrentValue = HtmlDecode($this->v_04_validation->CurrentValue);
			$this->v_04_validation->EditValue = HtmlEncode($this->v_04_validation->CurrentValue);
			$this->v_04_validation->PlaceHolder = RemoveHtml($this->v_04_validation->caption());

			// v_05
			$this->v_05->EditAttrs["class"] = "form-control";
			$this->v_05->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_05->CurrentValue = HtmlDecode($this->v_05->CurrentValue);
			$this->v_05->EditValue = HtmlEncode($this->v_05->CurrentValue);
			$this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

			// v_05_validation
			$this->v_05_validation->EditAttrs["class"] = "form-control";
			$this->v_05_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_05_validation->CurrentValue = HtmlDecode($this->v_05_validation->CurrentValue);
			$this->v_05_validation->EditValue = HtmlEncode($this->v_05_validation->CurrentValue);
			$this->v_05_validation->PlaceHolder = RemoveHtml($this->v_05_validation->caption());

			// v_06
			$this->v_06->EditAttrs["class"] = "form-control";
			$this->v_06->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_06->CurrentValue = HtmlDecode($this->v_06->CurrentValue);
			$this->v_06->EditValue = HtmlEncode($this->v_06->CurrentValue);
			$this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

			// v_06_validation
			$this->v_06_validation->EditAttrs["class"] = "form-control";
			$this->v_06_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_06_validation->CurrentValue = HtmlDecode($this->v_06_validation->CurrentValue);
			$this->v_06_validation->EditValue = HtmlEncode($this->v_06_validation->CurrentValue);
			$this->v_06_validation->PlaceHolder = RemoveHtml($this->v_06_validation->caption());

			// v_07
			$this->v_07->EditAttrs["class"] = "form-control";
			$this->v_07->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_07->CurrentValue = HtmlDecode($this->v_07->CurrentValue);
			$this->v_07->EditValue = HtmlEncode($this->v_07->CurrentValue);
			$this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

			// v_07_validation
			$this->v_07_validation->EditAttrs["class"] = "form-control";
			$this->v_07_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_07_validation->CurrentValue = HtmlDecode($this->v_07_validation->CurrentValue);
			$this->v_07_validation->EditValue = HtmlEncode($this->v_07_validation->CurrentValue);
			$this->v_07_validation->PlaceHolder = RemoveHtml($this->v_07_validation->caption());

			// v_08
			$this->v_08->EditAttrs["class"] = "form-control";
			$this->v_08->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_08->CurrentValue = HtmlDecode($this->v_08->CurrentValue);
			$this->v_08->EditValue = HtmlEncode($this->v_08->CurrentValue);
			$this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

			// v_08_validation
			$this->v_08_validation->EditAttrs["class"] = "form-control";
			$this->v_08_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_08_validation->CurrentValue = HtmlDecode($this->v_08_validation->CurrentValue);
			$this->v_08_validation->EditValue = HtmlEncode($this->v_08_validation->CurrentValue);
			$this->v_08_validation->PlaceHolder = RemoveHtml($this->v_08_validation->caption());

			// v_09
			$this->v_09->EditAttrs["class"] = "form-control";
			$this->v_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_09->CurrentValue = HtmlDecode($this->v_09->CurrentValue);
			$this->v_09->EditValue = HtmlEncode($this->v_09->CurrentValue);
			$this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

			// v_09_validation
			$this->v_09_validation->EditAttrs["class"] = "form-control";
			$this->v_09_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_09_validation->CurrentValue = HtmlDecode($this->v_09_validation->CurrentValue);
			$this->v_09_validation->EditValue = HtmlEncode($this->v_09_validation->CurrentValue);
			$this->v_09_validation->PlaceHolder = RemoveHtml($this->v_09_validation->caption());

			// v_10
			$this->v_10->EditAttrs["class"] = "form-control";
			$this->v_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_10->CurrentValue = HtmlDecode($this->v_10->CurrentValue);
			$this->v_10->EditValue = HtmlEncode($this->v_10->CurrentValue);
			$this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

			// v_10_validation
			$this->v_10_validation->EditAttrs["class"] = "form-control";
			$this->v_10_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_10_validation->CurrentValue = HtmlDecode($this->v_10_validation->CurrentValue);
			$this->v_10_validation->EditValue = HtmlEncode($this->v_10_validation->CurrentValue);
			$this->v_10_validation->PlaceHolder = RemoveHtml($this->v_10_validation->caption());

			// b_01_head
			$this->b_01_head->EditAttrs["class"] = "form-control";
			$this->b_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_01_head->CurrentValue = HtmlDecode($this->b_01_head->CurrentValue);
			$this->b_01_head->EditValue = HtmlEncode($this->b_01_head->CurrentValue);
			$this->b_01_head->PlaceHolder = RemoveHtml($this->b_01_head->caption());

			// b_02_head
			$this->b_02_head->EditAttrs["class"] = "form-control";
			$this->b_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_02_head->CurrentValue = HtmlDecode($this->b_02_head->CurrentValue);
			$this->b_02_head->EditValue = HtmlEncode($this->b_02_head->CurrentValue);
			$this->b_02_head->PlaceHolder = RemoveHtml($this->b_02_head->caption());

			// b_03_head
			$this->b_03_head->EditAttrs["class"] = "form-control";
			$this->b_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_03_head->CurrentValue = HtmlDecode($this->b_03_head->CurrentValue);
			$this->b_03_head->EditValue = HtmlEncode($this->b_03_head->CurrentValue);
			$this->b_03_head->PlaceHolder = RemoveHtml($this->b_03_head->caption());

			// b_04_head
			$this->b_04_head->EditAttrs["class"] = "form-control";
			$this->b_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_04_head->CurrentValue = HtmlDecode($this->b_04_head->CurrentValue);
			$this->b_04_head->EditValue = HtmlEncode($this->b_04_head->CurrentValue);
			$this->b_04_head->PlaceHolder = RemoveHtml($this->b_04_head->caption());

			// b_05_head
			$this->b_05_head->EditAttrs["class"] = "form-control";
			$this->b_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_05_head->CurrentValue = HtmlDecode($this->b_05_head->CurrentValue);
			$this->b_05_head->EditValue = HtmlEncode($this->b_05_head->CurrentValue);
			$this->b_05_head->PlaceHolder = RemoveHtml($this->b_05_head->caption());

			// b_06_head
			$this->b_06_head->EditAttrs["class"] = "form-control";
			$this->b_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_06_head->CurrentValue = HtmlDecode($this->b_06_head->CurrentValue);
			$this->b_06_head->EditValue = HtmlEncode($this->b_06_head->CurrentValue);
			$this->b_06_head->PlaceHolder = RemoveHtml($this->b_06_head->caption());

			// b_07_head
			$this->b_07_head->EditAttrs["class"] = "form-control";
			$this->b_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_07_head->CurrentValue = HtmlDecode($this->b_07_head->CurrentValue);
			$this->b_07_head->EditValue = HtmlEncode($this->b_07_head->CurrentValue);
			$this->b_07_head->PlaceHolder = RemoveHtml($this->b_07_head->caption());

			// b_08_head
			$this->b_08_head->EditAttrs["class"] = "form-control";
			$this->b_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_08_head->CurrentValue = HtmlDecode($this->b_08_head->CurrentValue);
			$this->b_08_head->EditValue = HtmlEncode($this->b_08_head->CurrentValue);
			$this->b_08_head->PlaceHolder = RemoveHtml($this->b_08_head->caption());

			// b_09_head
			$this->b_09_head->EditAttrs["class"] = "form-control";
			$this->b_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_09_head->CurrentValue = HtmlDecode($this->b_09_head->CurrentValue);
			$this->b_09_head->EditValue = HtmlEncode($this->b_09_head->CurrentValue);
			$this->b_09_head->PlaceHolder = RemoveHtml($this->b_09_head->caption());

			// b_10_head
			$this->b_10_head->EditAttrs["class"] = "form-control";
			$this->b_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_10_head->CurrentValue = HtmlDecode($this->b_10_head->CurrentValue);
			$this->b_10_head->EditValue = HtmlEncode($this->b_10_head->CurrentValue);
			$this->b_10_head->PlaceHolder = RemoveHtml($this->b_10_head->caption());

			// b_11_head
			$this->b_11_head->EditAttrs["class"] = "form-control";
			$this->b_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_11_head->CurrentValue = HtmlDecode($this->b_11_head->CurrentValue);
			$this->b_11_head->EditValue = HtmlEncode($this->b_11_head->CurrentValue);
			$this->b_11_head->PlaceHolder = RemoveHtml($this->b_11_head->caption());

			// b_12_head
			$this->b_12_head->EditAttrs["class"] = "form-control";
			$this->b_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_12_head->CurrentValue = HtmlDecode($this->b_12_head->CurrentValue);
			$this->b_12_head->EditValue = HtmlEncode($this->b_12_head->CurrentValue);
			$this->b_12_head->PlaceHolder = RemoveHtml($this->b_12_head->caption());

			// b_13_head
			$this->b_13_head->EditAttrs["class"] = "form-control";
			$this->b_13_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_13_head->CurrentValue = HtmlDecode($this->b_13_head->CurrentValue);
			$this->b_13_head->EditValue = HtmlEncode($this->b_13_head->CurrentValue);
			$this->b_13_head->PlaceHolder = RemoveHtml($this->b_13_head->caption());

			// b_14_head
			$this->b_14_head->EditAttrs["class"] = "form-control";
			$this->b_14_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_14_head->CurrentValue = HtmlDecode($this->b_14_head->CurrentValue);
			$this->b_14_head->EditValue = HtmlEncode($this->b_14_head->CurrentValue);
			$this->b_14_head->PlaceHolder = RemoveHtml($this->b_14_head->caption());

			// b_15_head
			$this->b_15_head->EditAttrs["class"] = "form-control";
			$this->b_15_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_15_head->CurrentValue = HtmlDecode($this->b_15_head->CurrentValue);
			$this->b_15_head->EditValue = HtmlEncode($this->b_15_head->CurrentValue);
			$this->b_15_head->PlaceHolder = RemoveHtml($this->b_15_head->caption());

			// q_sku
			$this->q_sku->EditAttrs["class"] = "form-control";
			$this->q_sku->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->q_sku->CurrentValue = HtmlDecode($this->q_sku->CurrentValue);
			$this->q_sku->EditValue = HtmlEncode($this->q_sku->CurrentValue);
			$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

			// t_01_head
			$this->t_01_head->EditAttrs["class"] = "form-control";
			$this->t_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_01_head->CurrentValue = HtmlDecode($this->t_01_head->CurrentValue);
			$this->t_01_head->EditValue = HtmlEncode($this->t_01_head->CurrentValue);
			$this->t_01_head->PlaceHolder = RemoveHtml($this->t_01_head->caption());

			// t_02_head
			$this->t_02_head->EditAttrs["class"] = "form-control";
			$this->t_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_02_head->CurrentValue = HtmlDecode($this->t_02_head->CurrentValue);
			$this->t_02_head->EditValue = HtmlEncode($this->t_02_head->CurrentValue);
			$this->t_02_head->PlaceHolder = RemoveHtml($this->t_02_head->caption());

			// t_03_head
			$this->t_03_head->EditAttrs["class"] = "form-control";
			$this->t_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_03_head->CurrentValue = HtmlDecode($this->t_03_head->CurrentValue);
			$this->t_03_head->EditValue = HtmlEncode($this->t_03_head->CurrentValue);
			$this->t_03_head->PlaceHolder = RemoveHtml($this->t_03_head->caption());

			// t_04_head
			$this->t_04_head->EditAttrs["class"] = "form-control";
			$this->t_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_04_head->CurrentValue = HtmlDecode($this->t_04_head->CurrentValue);
			$this->t_04_head->EditValue = HtmlEncode($this->t_04_head->CurrentValue);
			$this->t_04_head->PlaceHolder = RemoveHtml($this->t_04_head->caption());

			// t_05_head
			$this->t_05_head->EditAttrs["class"] = "form-control";
			$this->t_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_05_head->CurrentValue = HtmlDecode($this->t_05_head->CurrentValue);
			$this->t_05_head->EditValue = HtmlEncode($this->t_05_head->CurrentValue);
			$this->t_05_head->PlaceHolder = RemoveHtml($this->t_05_head->caption());

			// t_06_head
			$this->t_06_head->EditAttrs["class"] = "form-control";
			$this->t_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_06_head->CurrentValue = HtmlDecode($this->t_06_head->CurrentValue);
			$this->t_06_head->EditValue = HtmlEncode($this->t_06_head->CurrentValue);
			$this->t_06_head->PlaceHolder = RemoveHtml($this->t_06_head->caption());

			// t_07_head
			$this->t_07_head->EditAttrs["class"] = "form-control";
			$this->t_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_07_head->CurrentValue = HtmlDecode($this->t_07_head->CurrentValue);
			$this->t_07_head->EditValue = HtmlEncode($this->t_07_head->CurrentValue);
			$this->t_07_head->PlaceHolder = RemoveHtml($this->t_07_head->caption());

			// t_08_head
			$this->t_08_head->EditAttrs["class"] = "form-control";
			$this->t_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_08_head->CurrentValue = HtmlDecode($this->t_08_head->CurrentValue);
			$this->t_08_head->EditValue = HtmlEncode($this->t_08_head->CurrentValue);
			$this->t_08_head->PlaceHolder = RemoveHtml($this->t_08_head->caption());

			// t_09_head
			$this->t_09_head->EditAttrs["class"] = "form-control";
			$this->t_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_09_head->CurrentValue = HtmlDecode($this->t_09_head->CurrentValue);
			$this->t_09_head->EditValue = HtmlEncode($this->t_09_head->CurrentValue);
			$this->t_09_head->PlaceHolder = RemoveHtml($this->t_09_head->caption());

			// t_10_head
			$this->t_10_head->EditAttrs["class"] = "form-control";
			$this->t_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_10_head->CurrentValue = HtmlDecode($this->t_10_head->CurrentValue);
			$this->t_10_head->EditValue = HtmlEncode($this->t_10_head->CurrentValue);
			$this->t_10_head->PlaceHolder = RemoveHtml($this->t_10_head->caption());

			// t_11_head
			$this->t_11_head->EditAttrs["class"] = "form-control";
			$this->t_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_11_head->CurrentValue = HtmlDecode($this->t_11_head->CurrentValue);
			$this->t_11_head->EditValue = HtmlEncode($this->t_11_head->CurrentValue);
			$this->t_11_head->PlaceHolder = RemoveHtml($this->t_11_head->caption());

			// t_12_head
			$this->t_12_head->EditAttrs["class"] = "form-control";
			$this->t_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_12_head->CurrentValue = HtmlDecode($this->t_12_head->CurrentValue);
			$this->t_12_head->EditValue = HtmlEncode($this->t_12_head->CurrentValue);
			$this->t_12_head->PlaceHolder = RemoveHtml($this->t_12_head->caption());

			// t_13_head
			$this->t_13_head->EditAttrs["class"] = "form-control";
			$this->t_13_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_13_head->CurrentValue = HtmlDecode($this->t_13_head->CurrentValue);
			$this->t_13_head->EditValue = HtmlEncode($this->t_13_head->CurrentValue);
			$this->t_13_head->PlaceHolder = RemoveHtml($this->t_13_head->caption());

			// t_14_head
			$this->t_14_head->EditAttrs["class"] = "form-control";
			$this->t_14_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_14_head->CurrentValue = HtmlDecode($this->t_14_head->CurrentValue);
			$this->t_14_head->EditValue = HtmlEncode($this->t_14_head->CurrentValue);
			$this->t_14_head->PlaceHolder = RemoveHtml($this->t_14_head->caption());

			// t_15_head
			$this->t_15_head->EditAttrs["class"] = "form-control";
			$this->t_15_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_15_head->CurrentValue = HtmlDecode($this->t_15_head->CurrentValue);
			$this->t_15_head->EditValue = HtmlEncode($this->t_15_head->CurrentValue);
			$this->t_15_head->PlaceHolder = RemoveHtml($this->t_15_head->caption());

			// po_01_head
			$this->po_01_head->EditAttrs["class"] = "form-control";
			$this->po_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_01_head->CurrentValue = HtmlDecode($this->po_01_head->CurrentValue);
			$this->po_01_head->EditValue = HtmlEncode($this->po_01_head->CurrentValue);
			$this->po_01_head->PlaceHolder = RemoveHtml($this->po_01_head->caption());

			// po_02_head
			$this->po_02_head->EditAttrs["class"] = "form-control";
			$this->po_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_02_head->CurrentValue = HtmlDecode($this->po_02_head->CurrentValue);
			$this->po_02_head->EditValue = HtmlEncode($this->po_02_head->CurrentValue);
			$this->po_02_head->PlaceHolder = RemoveHtml($this->po_02_head->caption());

			// po_03_head
			$this->po_03_head->EditAttrs["class"] = "form-control";
			$this->po_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_03_head->CurrentValue = HtmlDecode($this->po_03_head->CurrentValue);
			$this->po_03_head->EditValue = HtmlEncode($this->po_03_head->CurrentValue);
			$this->po_03_head->PlaceHolder = RemoveHtml($this->po_03_head->caption());

			// po_04_head
			$this->po_04_head->EditAttrs["class"] = "form-control";
			$this->po_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_04_head->CurrentValue = HtmlDecode($this->po_04_head->CurrentValue);
			$this->po_04_head->EditValue = HtmlEncode($this->po_04_head->CurrentValue);
			$this->po_04_head->PlaceHolder = RemoveHtml($this->po_04_head->caption());

			// po_05_head
			$this->po_05_head->EditAttrs["class"] = "form-control";
			$this->po_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_05_head->CurrentValue = HtmlDecode($this->po_05_head->CurrentValue);
			$this->po_05_head->EditValue = HtmlEncode($this->po_05_head->CurrentValue);
			$this->po_05_head->PlaceHolder = RemoveHtml($this->po_05_head->caption());

			// po_06_head
			$this->po_06_head->EditAttrs["class"] = "form-control";
			$this->po_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_06_head->CurrentValue = HtmlDecode($this->po_06_head->CurrentValue);
			$this->po_06_head->EditValue = HtmlEncode($this->po_06_head->CurrentValue);
			$this->po_06_head->PlaceHolder = RemoveHtml($this->po_06_head->caption());

			// po_07_head
			$this->po_07_head->EditAttrs["class"] = "form-control";
			$this->po_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_07_head->CurrentValue = HtmlDecode($this->po_07_head->CurrentValue);
			$this->po_07_head->EditValue = HtmlEncode($this->po_07_head->CurrentValue);
			$this->po_07_head->PlaceHolder = RemoveHtml($this->po_07_head->caption());

			// po_08_head
			$this->po_08_head->EditAttrs["class"] = "form-control";
			$this->po_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_08_head->CurrentValue = HtmlDecode($this->po_08_head->CurrentValue);
			$this->po_08_head->EditValue = HtmlEncode($this->po_08_head->CurrentValue);
			$this->po_08_head->PlaceHolder = RemoveHtml($this->po_08_head->caption());

			// po_17_head
			$this->po_17_head->EditAttrs["class"] = "form-control";
			$this->po_17_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_17_head->CurrentValue = HtmlDecode($this->po_17_head->CurrentValue);
			$this->po_17_head->EditValue = HtmlEncode($this->po_17_head->CurrentValue);
			$this->po_17_head->PlaceHolder = RemoveHtml($this->po_17_head->caption());

			// po_18_head
			$this->po_18_head->EditAttrs["class"] = "form-control";
			$this->po_18_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_18_head->CurrentValue = HtmlDecode($this->po_18_head->CurrentValue);
			$this->po_18_head->EditValue = HtmlEncode($this->po_18_head->CurrentValue);
			$this->po_18_head->PlaceHolder = RemoveHtml($this->po_18_head->caption());

			// po_19_head
			$this->po_19_head->EditAttrs["class"] = "form-control";
			$this->po_19_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_19_head->CurrentValue = HtmlDecode($this->po_19_head->CurrentValue);
			$this->po_19_head->EditValue = HtmlEncode($this->po_19_head->CurrentValue);
			$this->po_19_head->PlaceHolder = RemoveHtml($this->po_19_head->caption());

			// po_20_head
			$this->po_20_head->EditAttrs["class"] = "form-control";
			$this->po_20_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_20_head->CurrentValue = HtmlDecode($this->po_20_head->CurrentValue);
			$this->po_20_head->EditValue = HtmlEncode($this->po_20_head->CurrentValue);
			$this->po_20_head->PlaceHolder = RemoveHtml($this->po_20_head->caption());

			// jc_01_head
			$this->jc_01_head->EditAttrs["class"] = "form-control";
			$this->jc_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_01_head->CurrentValue = HtmlDecode($this->jc_01_head->CurrentValue);
			$this->jc_01_head->EditValue = HtmlEncode($this->jc_01_head->CurrentValue);
			$this->jc_01_head->PlaceHolder = RemoveHtml($this->jc_01_head->caption());

			// jc_02_head
			$this->jc_02_head->EditAttrs["class"] = "form-control";
			$this->jc_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_02_head->CurrentValue = HtmlDecode($this->jc_02_head->CurrentValue);
			$this->jc_02_head->EditValue = HtmlEncode($this->jc_02_head->CurrentValue);
			$this->jc_02_head->PlaceHolder = RemoveHtml($this->jc_02_head->caption());

			// jc_03_head
			$this->jc_03_head->EditAttrs["class"] = "form-control";
			$this->jc_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_03_head->CurrentValue = HtmlDecode($this->jc_03_head->CurrentValue);
			$this->jc_03_head->EditValue = HtmlEncode($this->jc_03_head->CurrentValue);
			$this->jc_03_head->PlaceHolder = RemoveHtml($this->jc_03_head->caption());

			// jc_04_head
			$this->jc_04_head->EditAttrs["class"] = "form-control";
			$this->jc_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_04_head->CurrentValue = HtmlDecode($this->jc_04_head->CurrentValue);
			$this->jc_04_head->EditValue = HtmlEncode($this->jc_04_head->CurrentValue);
			$this->jc_04_head->PlaceHolder = RemoveHtml($this->jc_04_head->caption());

			// jc_05_head
			$this->jc_05_head->EditAttrs["class"] = "form-control";
			$this->jc_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_05_head->CurrentValue = HtmlDecode($this->jc_05_head->CurrentValue);
			$this->jc_05_head->EditValue = HtmlEncode($this->jc_05_head->CurrentValue);
			$this->jc_05_head->PlaceHolder = RemoveHtml($this->jc_05_head->caption());

			// jc_06_head
			$this->jc_06_head->EditAttrs["class"] = "form-control";
			$this->jc_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_06_head->CurrentValue = HtmlDecode($this->jc_06_head->CurrentValue);
			$this->jc_06_head->EditValue = HtmlEncode($this->jc_06_head->CurrentValue);
			$this->jc_06_head->PlaceHolder = RemoveHtml($this->jc_06_head->caption());

			// jc_07_head
			$this->jc_07_head->EditAttrs["class"] = "form-control";
			$this->jc_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_07_head->CurrentValue = HtmlDecode($this->jc_07_head->CurrentValue);
			$this->jc_07_head->EditValue = HtmlEncode($this->jc_07_head->CurrentValue);
			$this->jc_07_head->PlaceHolder = RemoveHtml($this->jc_07_head->caption());

			// jc_08_head
			$this->jc_08_head->EditAttrs["class"] = "form-control";
			$this->jc_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_08_head->CurrentValue = HtmlDecode($this->jc_08_head->CurrentValue);
			$this->jc_08_head->EditValue = HtmlEncode($this->jc_08_head->CurrentValue);
			$this->jc_08_head->PlaceHolder = RemoveHtml($this->jc_08_head->caption());

			// jc_09_head
			$this->jc_09_head->EditAttrs["class"] = "form-control";
			$this->jc_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_09_head->CurrentValue = HtmlDecode($this->jc_09_head->CurrentValue);
			$this->jc_09_head->EditValue = HtmlEncode($this->jc_09_head->CurrentValue);
			$this->jc_09_head->PlaceHolder = RemoveHtml($this->jc_09_head->caption());

			// jc_10_head
			$this->jc_10_head->EditAttrs["class"] = "form-control";
			$this->jc_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_10_head->CurrentValue = HtmlDecode($this->jc_10_head->CurrentValue);
			$this->jc_10_head->EditValue = HtmlEncode($this->jc_10_head->CurrentValue);
			$this->jc_10_head->PlaceHolder = RemoveHtml($this->jc_10_head->caption());

			// pc_shape
			$this->pc_shape->EditAttrs["class"] = "form-control";
			$this->pc_shape->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_shape->CurrentValue = HtmlDecode($this->pc_shape->CurrentValue);
			$this->pc_shape->EditValue = HtmlEncode($this->pc_shape->CurrentValue);
			$this->pc_shape->PlaceHolder = RemoveHtml($this->pc_shape->caption());

			// pc_unit
			$this->pc_unit->EditAttrs["class"] = "form-control";
			$this->pc_unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_unit->CurrentValue = HtmlDecode($this->pc_unit->CurrentValue);
			$this->pc_unit->EditValue = HtmlEncode($this->pc_unit->CurrentValue);
			$this->pc_unit->PlaceHolder = RemoveHtml($this->pc_unit->caption());

			// pc_w
			$this->pc_w->EditAttrs["class"] = "form-control";
			$this->pc_w->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_w->CurrentValue = HtmlDecode($this->pc_w->CurrentValue);
			$this->pc_w->EditValue = HtmlEncode($this->pc_w->CurrentValue);
			$this->pc_w->PlaceHolder = RemoveHtml($this->pc_w->caption());

			// pc_l
			$this->pc_l->EditAttrs["class"] = "form-control";
			$this->pc_l->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_l->CurrentValue = HtmlDecode($this->pc_l->CurrentValue);
			$this->pc_l->EditValue = HtmlEncode($this->pc_l->CurrentValue);
			$this->pc_l->PlaceHolder = RemoveHtml($this->pc_l->caption());

			// pc_h
			$this->pc_h->EditAttrs["class"] = "form-control";
			$this->pc_h->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_h->CurrentValue = HtmlDecode($this->pc_h->CurrentValue);
			$this->pc_h->EditValue = HtmlEncode($this->pc_h->CurrentValue);
			$this->pc_h->PlaceHolder = RemoveHtml($this->pc_h->caption());

			// pc_partner_size
			$this->pc_partner_size->EditAttrs["class"] = "form-control";
			$this->pc_partner_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_partner_size->CurrentValue = HtmlDecode($this->pc_partner_size->CurrentValue);
			$this->pc_partner_size->EditValue = HtmlEncode($this->pc_partner_size->CurrentValue);
			$this->pc_partner_size->PlaceHolder = RemoveHtml($this->pc_partner_size->caption());

			// pc_sqm
			$this->pc_sqm->EditAttrs["class"] = "form-control";
			$this->pc_sqm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_sqm->CurrentValue = HtmlDecode($this->pc_sqm->CurrentValue);
			$this->pc_sqm->EditValue = HtmlEncode($this->pc_sqm->CurrentValue);
			$this->pc_sqm->PlaceHolder = RemoveHtml($this->pc_sqm->caption());

			// pc_01_head
			$this->pc_01_head->EditAttrs["class"] = "form-control";
			$this->pc_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_01_head->CurrentValue = HtmlDecode($this->pc_01_head->CurrentValue);
			$this->pc_01_head->EditValue = HtmlEncode($this->pc_01_head->CurrentValue);
			$this->pc_01_head->PlaceHolder = RemoveHtml($this->pc_01_head->caption());

			// pc_02_head
			$this->pc_02_head->EditAttrs["class"] = "form-control";
			$this->pc_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_02_head->CurrentValue = HtmlDecode($this->pc_02_head->CurrentValue);
			$this->pc_02_head->EditValue = HtmlEncode($this->pc_02_head->CurrentValue);
			$this->pc_02_head->PlaceHolder = RemoveHtml($this->pc_02_head->caption());

			// pc_03_head
			$this->pc_03_head->EditAttrs["class"] = "form-control";
			$this->pc_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_03_head->CurrentValue = HtmlDecode($this->pc_03_head->CurrentValue);
			$this->pc_03_head->EditValue = HtmlEncode($this->pc_03_head->CurrentValue);
			$this->pc_03_head->PlaceHolder = RemoveHtml($this->pc_03_head->caption());

			// pc_04_head
			$this->pc_04_head->EditAttrs["class"] = "form-control";
			$this->pc_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_04_head->CurrentValue = HtmlDecode($this->pc_04_head->CurrentValue);
			$this->pc_04_head->EditValue = HtmlEncode($this->pc_04_head->CurrentValue);
			$this->pc_04_head->PlaceHolder = RemoveHtml($this->pc_04_head->caption());

			// pc_05_head
			$this->pc_05_head->EditAttrs["class"] = "form-control";
			$this->pc_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_05_head->CurrentValue = HtmlDecode($this->pc_05_head->CurrentValue);
			$this->pc_05_head->EditValue = HtmlEncode($this->pc_05_head->CurrentValue);
			$this->pc_05_head->PlaceHolder = RemoveHtml($this->pc_05_head->caption());

			// pc_06_head
			$this->pc_06_head->EditAttrs["class"] = "form-control";
			$this->pc_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_06_head->CurrentValue = HtmlDecode($this->pc_06_head->CurrentValue);
			$this->pc_06_head->EditValue = HtmlEncode($this->pc_06_head->CurrentValue);
			$this->pc_06_head->PlaceHolder = RemoveHtml($this->pc_06_head->caption());

			// pc_07_head
			$this->pc_07_head->EditAttrs["class"] = "form-control";
			$this->pc_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_07_head->CurrentValue = HtmlDecode($this->pc_07_head->CurrentValue);
			$this->pc_07_head->EditValue = HtmlEncode($this->pc_07_head->CurrentValue);
			$this->pc_07_head->PlaceHolder = RemoveHtml($this->pc_07_head->caption());

			// pc_08_head
			$this->pc_08_head->EditAttrs["class"] = "form-control";
			$this->pc_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_08_head->CurrentValue = HtmlDecode($this->pc_08_head->CurrentValue);
			$this->pc_08_head->EditValue = HtmlEncode($this->pc_08_head->CurrentValue);
			$this->pc_08_head->PlaceHolder = RemoveHtml($this->pc_08_head->caption());

			// pc_09_head
			$this->pc_09_head->EditAttrs["class"] = "form-control";
			$this->pc_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_09_head->CurrentValue = HtmlDecode($this->pc_09_head->CurrentValue);
			$this->pc_09_head->EditValue = HtmlEncode($this->pc_09_head->CurrentValue);
			$this->pc_09_head->PlaceHolder = RemoveHtml($this->pc_09_head->caption());

			// pc_10_head
			$this->pc_10_head->EditAttrs["class"] = "form-control";
			$this->pc_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_10_head->CurrentValue = HtmlDecode($this->pc_10_head->CurrentValue);
			$this->pc_10_head->EditValue = HtmlEncode($this->pc_10_head->CurrentValue);
			$this->pc_10_head->PlaceHolder = RemoveHtml($this->pc_10_head->caption());

			// pc_11_head
			$this->pc_11_head->EditAttrs["class"] = "form-control";
			$this->pc_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_11_head->CurrentValue = HtmlDecode($this->pc_11_head->CurrentValue);
			$this->pc_11_head->EditValue = HtmlEncode($this->pc_11_head->CurrentValue);
			$this->pc_11_head->PlaceHolder = RemoveHtml($this->pc_11_head->caption());

			// pc_12_head
			$this->pc_12_head->EditAttrs["class"] = "form-control";
			$this->pc_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_12_head->CurrentValue = HtmlDecode($this->pc_12_head->CurrentValue);
			$this->pc_12_head->EditValue = HtmlEncode($this->pc_12_head->CurrentValue);
			$this->pc_12_head->PlaceHolder = RemoveHtml($this->pc_12_head->caption());

			// operator
			// datetime
			// image

			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->EditValue = $this->image->Upload->DbValue;
			} else {
				$this->image->EditValue = "";
			}
			if (!EmptyValue($this->image->CurrentValue))
					$this->image->Upload->FileName = $this->image->CurrentValue;
			if (($this->isShow() || $this->isCopy()) && !$this->EventCancelled)
				RenderUploadField($this->image);

			// Add refer script
			// grp

			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// product_group
			$this->product_group->LinkCustomAttributes = "";
			$this->product_group->HrefValue = "";

			// calculation_method
			$this->calculation_method->LinkCustomAttributes = "";
			$this->calculation_method->HrefValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// v_00
			$this->v_00->LinkCustomAttributes = "";
			$this->v_00->HrefValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";

			// v_01_validation
			$this->v_01_validation->LinkCustomAttributes = "";
			$this->v_01_validation->HrefValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";

			// v_02_validation
			$this->v_02_validation->LinkCustomAttributes = "";
			$this->v_02_validation->HrefValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";

			// v_03_validation
			$this->v_03_validation->LinkCustomAttributes = "";
			$this->v_03_validation->HrefValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";

			// v_04_validation
			$this->v_04_validation->LinkCustomAttributes = "";
			$this->v_04_validation->HrefValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";

			// v_05_validation
			$this->v_05_validation->LinkCustomAttributes = "";
			$this->v_05_validation->HrefValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";

			// v_06_validation
			$this->v_06_validation->LinkCustomAttributes = "";
			$this->v_06_validation->HrefValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";

			// v_07_validation
			$this->v_07_validation->LinkCustomAttributes = "";
			$this->v_07_validation->HrefValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";

			// v_08_validation
			$this->v_08_validation->LinkCustomAttributes = "";
			$this->v_08_validation->HrefValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";

			// v_09_validation
			$this->v_09_validation->LinkCustomAttributes = "";
			$this->v_09_validation->HrefValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";

			// v_10_validation
			$this->v_10_validation->LinkCustomAttributes = "";
			$this->v_10_validation->HrefValue = "";

			// b_01_head
			$this->b_01_head->LinkCustomAttributes = "";
			$this->b_01_head->HrefValue = "";

			// b_02_head
			$this->b_02_head->LinkCustomAttributes = "";
			$this->b_02_head->HrefValue = "";

			// b_03_head
			$this->b_03_head->LinkCustomAttributes = "";
			$this->b_03_head->HrefValue = "";

			// b_04_head
			$this->b_04_head->LinkCustomAttributes = "";
			$this->b_04_head->HrefValue = "";

			// b_05_head
			$this->b_05_head->LinkCustomAttributes = "";
			$this->b_05_head->HrefValue = "";

			// b_06_head
			$this->b_06_head->LinkCustomAttributes = "";
			$this->b_06_head->HrefValue = "";

			// b_07_head
			$this->b_07_head->LinkCustomAttributes = "";
			$this->b_07_head->HrefValue = "";

			// b_08_head
			$this->b_08_head->LinkCustomAttributes = "";
			$this->b_08_head->HrefValue = "";

			// b_09_head
			$this->b_09_head->LinkCustomAttributes = "";
			$this->b_09_head->HrefValue = "";

			// b_10_head
			$this->b_10_head->LinkCustomAttributes = "";
			$this->b_10_head->HrefValue = "";

			// b_11_head
			$this->b_11_head->LinkCustomAttributes = "";
			$this->b_11_head->HrefValue = "";

			// b_12_head
			$this->b_12_head->LinkCustomAttributes = "";
			$this->b_12_head->HrefValue = "";

			// b_13_head
			$this->b_13_head->LinkCustomAttributes = "";
			$this->b_13_head->HrefValue = "";

			// b_14_head
			$this->b_14_head->LinkCustomAttributes = "";
			$this->b_14_head->HrefValue = "";

			// b_15_head
			$this->b_15_head->LinkCustomAttributes = "";
			$this->b_15_head->HrefValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";

			// t_01_head
			$this->t_01_head->LinkCustomAttributes = "";
			$this->t_01_head->HrefValue = "";

			// t_02_head
			$this->t_02_head->LinkCustomAttributes = "";
			$this->t_02_head->HrefValue = "";

			// t_03_head
			$this->t_03_head->LinkCustomAttributes = "";
			$this->t_03_head->HrefValue = "";

			// t_04_head
			$this->t_04_head->LinkCustomAttributes = "";
			$this->t_04_head->HrefValue = "";

			// t_05_head
			$this->t_05_head->LinkCustomAttributes = "";
			$this->t_05_head->HrefValue = "";

			// t_06_head
			$this->t_06_head->LinkCustomAttributes = "";
			$this->t_06_head->HrefValue = "";

			// t_07_head
			$this->t_07_head->LinkCustomAttributes = "";
			$this->t_07_head->HrefValue = "";

			// t_08_head
			$this->t_08_head->LinkCustomAttributes = "";
			$this->t_08_head->HrefValue = "";

			// t_09_head
			$this->t_09_head->LinkCustomAttributes = "";
			$this->t_09_head->HrefValue = "";

			// t_10_head
			$this->t_10_head->LinkCustomAttributes = "";
			$this->t_10_head->HrefValue = "";

			// t_11_head
			$this->t_11_head->LinkCustomAttributes = "";
			$this->t_11_head->HrefValue = "";

			// t_12_head
			$this->t_12_head->LinkCustomAttributes = "";
			$this->t_12_head->HrefValue = "";

			// t_13_head
			$this->t_13_head->LinkCustomAttributes = "";
			$this->t_13_head->HrefValue = "";

			// t_14_head
			$this->t_14_head->LinkCustomAttributes = "";
			$this->t_14_head->HrefValue = "";

			// t_15_head
			$this->t_15_head->LinkCustomAttributes = "";
			$this->t_15_head->HrefValue = "";

			// po_01_head
			$this->po_01_head->LinkCustomAttributes = "";
			$this->po_01_head->HrefValue = "";

			// po_02_head
			$this->po_02_head->LinkCustomAttributes = "";
			$this->po_02_head->HrefValue = "";

			// po_03_head
			$this->po_03_head->LinkCustomAttributes = "";
			$this->po_03_head->HrefValue = "";

			// po_04_head
			$this->po_04_head->LinkCustomAttributes = "";
			$this->po_04_head->HrefValue = "";

			// po_05_head
			$this->po_05_head->LinkCustomAttributes = "";
			$this->po_05_head->HrefValue = "";

			// po_06_head
			$this->po_06_head->LinkCustomAttributes = "";
			$this->po_06_head->HrefValue = "";

			// po_07_head
			$this->po_07_head->LinkCustomAttributes = "";
			$this->po_07_head->HrefValue = "";

			// po_08_head
			$this->po_08_head->LinkCustomAttributes = "";
			$this->po_08_head->HrefValue = "";

			// po_17_head
			$this->po_17_head->LinkCustomAttributes = "";
			$this->po_17_head->HrefValue = "";

			// po_18_head
			$this->po_18_head->LinkCustomAttributes = "";
			$this->po_18_head->HrefValue = "";

			// po_19_head
			$this->po_19_head->LinkCustomAttributes = "";
			$this->po_19_head->HrefValue = "";

			// po_20_head
			$this->po_20_head->LinkCustomAttributes = "";
			$this->po_20_head->HrefValue = "";

			// jc_01_head
			$this->jc_01_head->LinkCustomAttributes = "";
			$this->jc_01_head->HrefValue = "";

			// jc_02_head
			$this->jc_02_head->LinkCustomAttributes = "";
			$this->jc_02_head->HrefValue = "";

			// jc_03_head
			$this->jc_03_head->LinkCustomAttributes = "";
			$this->jc_03_head->HrefValue = "";

			// jc_04_head
			$this->jc_04_head->LinkCustomAttributes = "";
			$this->jc_04_head->HrefValue = "";

			// jc_05_head
			$this->jc_05_head->LinkCustomAttributes = "";
			$this->jc_05_head->HrefValue = "";

			// jc_06_head
			$this->jc_06_head->LinkCustomAttributes = "";
			$this->jc_06_head->HrefValue = "";

			// jc_07_head
			$this->jc_07_head->LinkCustomAttributes = "";
			$this->jc_07_head->HrefValue = "";

			// jc_08_head
			$this->jc_08_head->LinkCustomAttributes = "";
			$this->jc_08_head->HrefValue = "";

			// jc_09_head
			$this->jc_09_head->LinkCustomAttributes = "";
			$this->jc_09_head->HrefValue = "";

			// jc_10_head
			$this->jc_10_head->LinkCustomAttributes = "";
			$this->jc_10_head->HrefValue = "";

			// pc_shape
			$this->pc_shape->LinkCustomAttributes = "";
			$this->pc_shape->HrefValue = "";

			// pc_unit
			$this->pc_unit->LinkCustomAttributes = "";
			$this->pc_unit->HrefValue = "";

			// pc_w
			$this->pc_w->LinkCustomAttributes = "";
			$this->pc_w->HrefValue = "";

			// pc_l
			$this->pc_l->LinkCustomAttributes = "";
			$this->pc_l->HrefValue = "";

			// pc_h
			$this->pc_h->LinkCustomAttributes = "";
			$this->pc_h->HrefValue = "";

			// pc_partner_size
			$this->pc_partner_size->LinkCustomAttributes = "";
			$this->pc_partner_size->HrefValue = "";

			// pc_sqm
			$this->pc_sqm->LinkCustomAttributes = "";
			$this->pc_sqm->HrefValue = "";

			// pc_01_head
			$this->pc_01_head->LinkCustomAttributes = "";
			$this->pc_01_head->HrefValue = "";

			// pc_02_head
			$this->pc_02_head->LinkCustomAttributes = "";
			$this->pc_02_head->HrefValue = "";

			// pc_03_head
			$this->pc_03_head->LinkCustomAttributes = "";
			$this->pc_03_head->HrefValue = "";

			// pc_04_head
			$this->pc_04_head->LinkCustomAttributes = "";
			$this->pc_04_head->HrefValue = "";

			// pc_05_head
			$this->pc_05_head->LinkCustomAttributes = "";
			$this->pc_05_head->HrefValue = "";

			// pc_06_head
			$this->pc_06_head->LinkCustomAttributes = "";
			$this->pc_06_head->HrefValue = "";

			// pc_07_head
			$this->pc_07_head->LinkCustomAttributes = "";
			$this->pc_07_head->HrefValue = "";

			// pc_08_head
			$this->pc_08_head->LinkCustomAttributes = "";
			$this->pc_08_head->HrefValue = "";

			// pc_09_head
			$this->pc_09_head->LinkCustomAttributes = "";
			$this->pc_09_head->HrefValue = "";

			// pc_10_head
			$this->pc_10_head->LinkCustomAttributes = "";
			$this->pc_10_head->HrefValue = "";

			// pc_11_head
			$this->pc_11_head->LinkCustomAttributes = "";
			$this->pc_11_head->HrefValue = "";

			// pc_12_head
			$this->pc_12_head->LinkCustomAttributes = "";
			$this->pc_12_head->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->product_group->Required) {
			if (!$this->product_group->IsDetailKey && $this->product_group->FormValue != NULL && $this->product_group->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_group->caption(), $this->product_group->RequiredErrorMessage));
			}
		}
		if ($this->calculation_method->Required) {
			if (!$this->calculation_method->IsDetailKey && $this->calculation_method->FormValue != NULL && $this->calculation_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->calculation_method->caption(), $this->calculation_method->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if (!$this->shape->IsDetailKey && $this->shape->FormValue != NULL && $this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->v_00->Required) {
			if (!$this->v_00->IsDetailKey && $this->v_00->FormValue != NULL && $this->v_00->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_00->caption(), $this->v_00->RequiredErrorMessage));
			}
		}
		if ($this->v_01->Required) {
			if (!$this->v_01->IsDetailKey && $this->v_01->FormValue != NULL && $this->v_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_01->caption(), $this->v_01->RequiredErrorMessage));
			}
		}
		if ($this->v_01_validation->Required) {
			if (!$this->v_01_validation->IsDetailKey && $this->v_01_validation->FormValue != NULL && $this->v_01_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_01_validation->caption(), $this->v_01_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_02->Required) {
			if (!$this->v_02->IsDetailKey && $this->v_02->FormValue != NULL && $this->v_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_02->caption(), $this->v_02->RequiredErrorMessage));
			}
		}
		if ($this->v_02_validation->Required) {
			if (!$this->v_02_validation->IsDetailKey && $this->v_02_validation->FormValue != NULL && $this->v_02_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_02_validation->caption(), $this->v_02_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_03->Required) {
			if (!$this->v_03->IsDetailKey && $this->v_03->FormValue != NULL && $this->v_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_03->caption(), $this->v_03->RequiredErrorMessage));
			}
		}
		if ($this->v_03_validation->Required) {
			if (!$this->v_03_validation->IsDetailKey && $this->v_03_validation->FormValue != NULL && $this->v_03_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_03_validation->caption(), $this->v_03_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_04->Required) {
			if (!$this->v_04->IsDetailKey && $this->v_04->FormValue != NULL && $this->v_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_04->caption(), $this->v_04->RequiredErrorMessage));
			}
		}
		if ($this->v_04_validation->Required) {
			if (!$this->v_04_validation->IsDetailKey && $this->v_04_validation->FormValue != NULL && $this->v_04_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_04_validation->caption(), $this->v_04_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_05->Required) {
			if (!$this->v_05->IsDetailKey && $this->v_05->FormValue != NULL && $this->v_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_05->caption(), $this->v_05->RequiredErrorMessage));
			}
		}
		if ($this->v_05_validation->Required) {
			if (!$this->v_05_validation->IsDetailKey && $this->v_05_validation->FormValue != NULL && $this->v_05_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_05_validation->caption(), $this->v_05_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_06->Required) {
			if (!$this->v_06->IsDetailKey && $this->v_06->FormValue != NULL && $this->v_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_06->caption(), $this->v_06->RequiredErrorMessage));
			}
		}
		if ($this->v_06_validation->Required) {
			if (!$this->v_06_validation->IsDetailKey && $this->v_06_validation->FormValue != NULL && $this->v_06_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_06_validation->caption(), $this->v_06_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_07->Required) {
			if (!$this->v_07->IsDetailKey && $this->v_07->FormValue != NULL && $this->v_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_07->caption(), $this->v_07->RequiredErrorMessage));
			}
		}
		if ($this->v_07_validation->Required) {
			if (!$this->v_07_validation->IsDetailKey && $this->v_07_validation->FormValue != NULL && $this->v_07_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_07_validation->caption(), $this->v_07_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_08->Required) {
			if (!$this->v_08->IsDetailKey && $this->v_08->FormValue != NULL && $this->v_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_08->caption(), $this->v_08->RequiredErrorMessage));
			}
		}
		if ($this->v_08_validation->Required) {
			if (!$this->v_08_validation->IsDetailKey && $this->v_08_validation->FormValue != NULL && $this->v_08_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_08_validation->caption(), $this->v_08_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_09->Required) {
			if (!$this->v_09->IsDetailKey && $this->v_09->FormValue != NULL && $this->v_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_09->caption(), $this->v_09->RequiredErrorMessage));
			}
		}
		if ($this->v_09_validation->Required) {
			if (!$this->v_09_validation->IsDetailKey && $this->v_09_validation->FormValue != NULL && $this->v_09_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_09_validation->caption(), $this->v_09_validation->RequiredErrorMessage));
			}
		}
		if ($this->v_10->Required) {
			if (!$this->v_10->IsDetailKey && $this->v_10->FormValue != NULL && $this->v_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_10->caption(), $this->v_10->RequiredErrorMessage));
			}
		}
		if ($this->v_10_validation->Required) {
			if (!$this->v_10_validation->IsDetailKey && $this->v_10_validation->FormValue != NULL && $this->v_10_validation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_10_validation->caption(), $this->v_10_validation->RequiredErrorMessage));
			}
		}
		if ($this->b_01_head->Required) {
			if (!$this->b_01_head->IsDetailKey && $this->b_01_head->FormValue != NULL && $this->b_01_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_01_head->caption(), $this->b_01_head->RequiredErrorMessage));
			}
		}
		if ($this->b_02_head->Required) {
			if (!$this->b_02_head->IsDetailKey && $this->b_02_head->FormValue != NULL && $this->b_02_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_02_head->caption(), $this->b_02_head->RequiredErrorMessage));
			}
		}
		if ($this->b_03_head->Required) {
			if (!$this->b_03_head->IsDetailKey && $this->b_03_head->FormValue != NULL && $this->b_03_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_03_head->caption(), $this->b_03_head->RequiredErrorMessage));
			}
		}
		if ($this->b_04_head->Required) {
			if (!$this->b_04_head->IsDetailKey && $this->b_04_head->FormValue != NULL && $this->b_04_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_04_head->caption(), $this->b_04_head->RequiredErrorMessage));
			}
		}
		if ($this->b_05_head->Required) {
			if (!$this->b_05_head->IsDetailKey && $this->b_05_head->FormValue != NULL && $this->b_05_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_05_head->caption(), $this->b_05_head->RequiredErrorMessage));
			}
		}
		if ($this->b_06_head->Required) {
			if (!$this->b_06_head->IsDetailKey && $this->b_06_head->FormValue != NULL && $this->b_06_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_06_head->caption(), $this->b_06_head->RequiredErrorMessage));
			}
		}
		if ($this->b_07_head->Required) {
			if (!$this->b_07_head->IsDetailKey && $this->b_07_head->FormValue != NULL && $this->b_07_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_07_head->caption(), $this->b_07_head->RequiredErrorMessage));
			}
		}
		if ($this->b_08_head->Required) {
			if (!$this->b_08_head->IsDetailKey && $this->b_08_head->FormValue != NULL && $this->b_08_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_08_head->caption(), $this->b_08_head->RequiredErrorMessage));
			}
		}
		if ($this->b_09_head->Required) {
			if (!$this->b_09_head->IsDetailKey && $this->b_09_head->FormValue != NULL && $this->b_09_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_09_head->caption(), $this->b_09_head->RequiredErrorMessage));
			}
		}
		if ($this->b_10_head->Required) {
			if (!$this->b_10_head->IsDetailKey && $this->b_10_head->FormValue != NULL && $this->b_10_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_10_head->caption(), $this->b_10_head->RequiredErrorMessage));
			}
		}
		if ($this->b_11_head->Required) {
			if (!$this->b_11_head->IsDetailKey && $this->b_11_head->FormValue != NULL && $this->b_11_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_11_head->caption(), $this->b_11_head->RequiredErrorMessage));
			}
		}
		if ($this->b_12_head->Required) {
			if (!$this->b_12_head->IsDetailKey && $this->b_12_head->FormValue != NULL && $this->b_12_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_12_head->caption(), $this->b_12_head->RequiredErrorMessage));
			}
		}
		if ($this->b_13_head->Required) {
			if (!$this->b_13_head->IsDetailKey && $this->b_13_head->FormValue != NULL && $this->b_13_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_13_head->caption(), $this->b_13_head->RequiredErrorMessage));
			}
		}
		if ($this->b_14_head->Required) {
			if (!$this->b_14_head->IsDetailKey && $this->b_14_head->FormValue != NULL && $this->b_14_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_14_head->caption(), $this->b_14_head->RequiredErrorMessage));
			}
		}
		if ($this->b_15_head->Required) {
			if (!$this->b_15_head->IsDetailKey && $this->b_15_head->FormValue != NULL && $this->b_15_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_15_head->caption(), $this->b_15_head->RequiredErrorMessage));
			}
		}
		if ($this->q_sku->Required) {
			if (!$this->q_sku->IsDetailKey && $this->q_sku->FormValue != NULL && $this->q_sku->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
			}
		}
		if ($this->t_01_head->Required) {
			if (!$this->t_01_head->IsDetailKey && $this->t_01_head->FormValue != NULL && $this->t_01_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_01_head->caption(), $this->t_01_head->RequiredErrorMessage));
			}
		}
		if ($this->t_02_head->Required) {
			if (!$this->t_02_head->IsDetailKey && $this->t_02_head->FormValue != NULL && $this->t_02_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_02_head->caption(), $this->t_02_head->RequiredErrorMessage));
			}
		}
		if ($this->t_03_head->Required) {
			if (!$this->t_03_head->IsDetailKey && $this->t_03_head->FormValue != NULL && $this->t_03_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_03_head->caption(), $this->t_03_head->RequiredErrorMessage));
			}
		}
		if ($this->t_04_head->Required) {
			if (!$this->t_04_head->IsDetailKey && $this->t_04_head->FormValue != NULL && $this->t_04_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_04_head->caption(), $this->t_04_head->RequiredErrorMessage));
			}
		}
		if ($this->t_05_head->Required) {
			if (!$this->t_05_head->IsDetailKey && $this->t_05_head->FormValue != NULL && $this->t_05_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_05_head->caption(), $this->t_05_head->RequiredErrorMessage));
			}
		}
		if ($this->t_06_head->Required) {
			if (!$this->t_06_head->IsDetailKey && $this->t_06_head->FormValue != NULL && $this->t_06_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_06_head->caption(), $this->t_06_head->RequiredErrorMessage));
			}
		}
		if ($this->t_07_head->Required) {
			if (!$this->t_07_head->IsDetailKey && $this->t_07_head->FormValue != NULL && $this->t_07_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_07_head->caption(), $this->t_07_head->RequiredErrorMessage));
			}
		}
		if ($this->t_08_head->Required) {
			if (!$this->t_08_head->IsDetailKey && $this->t_08_head->FormValue != NULL && $this->t_08_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_08_head->caption(), $this->t_08_head->RequiredErrorMessage));
			}
		}
		if ($this->t_09_head->Required) {
			if (!$this->t_09_head->IsDetailKey && $this->t_09_head->FormValue != NULL && $this->t_09_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_09_head->caption(), $this->t_09_head->RequiredErrorMessage));
			}
		}
		if ($this->t_10_head->Required) {
			if (!$this->t_10_head->IsDetailKey && $this->t_10_head->FormValue != NULL && $this->t_10_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_10_head->caption(), $this->t_10_head->RequiredErrorMessage));
			}
		}
		if ($this->t_11_head->Required) {
			if (!$this->t_11_head->IsDetailKey && $this->t_11_head->FormValue != NULL && $this->t_11_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_11_head->caption(), $this->t_11_head->RequiredErrorMessage));
			}
		}
		if ($this->t_12_head->Required) {
			if (!$this->t_12_head->IsDetailKey && $this->t_12_head->FormValue != NULL && $this->t_12_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_12_head->caption(), $this->t_12_head->RequiredErrorMessage));
			}
		}
		if ($this->t_13_head->Required) {
			if (!$this->t_13_head->IsDetailKey && $this->t_13_head->FormValue != NULL && $this->t_13_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_13_head->caption(), $this->t_13_head->RequiredErrorMessage));
			}
		}
		if ($this->t_14_head->Required) {
			if (!$this->t_14_head->IsDetailKey && $this->t_14_head->FormValue != NULL && $this->t_14_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_14_head->caption(), $this->t_14_head->RequiredErrorMessage));
			}
		}
		if ($this->t_15_head->Required) {
			if (!$this->t_15_head->IsDetailKey && $this->t_15_head->FormValue != NULL && $this->t_15_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_15_head->caption(), $this->t_15_head->RequiredErrorMessage));
			}
		}
		if ($this->po_01_head->Required) {
			if (!$this->po_01_head->IsDetailKey && $this->po_01_head->FormValue != NULL && $this->po_01_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_01_head->caption(), $this->po_01_head->RequiredErrorMessage));
			}
		}
		if ($this->po_02_head->Required) {
			if (!$this->po_02_head->IsDetailKey && $this->po_02_head->FormValue != NULL && $this->po_02_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_02_head->caption(), $this->po_02_head->RequiredErrorMessage));
			}
		}
		if ($this->po_03_head->Required) {
			if (!$this->po_03_head->IsDetailKey && $this->po_03_head->FormValue != NULL && $this->po_03_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_03_head->caption(), $this->po_03_head->RequiredErrorMessage));
			}
		}
		if ($this->po_04_head->Required) {
			if (!$this->po_04_head->IsDetailKey && $this->po_04_head->FormValue != NULL && $this->po_04_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_04_head->caption(), $this->po_04_head->RequiredErrorMessage));
			}
		}
		if ($this->po_05_head->Required) {
			if (!$this->po_05_head->IsDetailKey && $this->po_05_head->FormValue != NULL && $this->po_05_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_05_head->caption(), $this->po_05_head->RequiredErrorMessage));
			}
		}
		if ($this->po_06_head->Required) {
			if (!$this->po_06_head->IsDetailKey && $this->po_06_head->FormValue != NULL && $this->po_06_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_06_head->caption(), $this->po_06_head->RequiredErrorMessage));
			}
		}
		if ($this->po_07_head->Required) {
			if (!$this->po_07_head->IsDetailKey && $this->po_07_head->FormValue != NULL && $this->po_07_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_07_head->caption(), $this->po_07_head->RequiredErrorMessage));
			}
		}
		if ($this->po_08_head->Required) {
			if (!$this->po_08_head->IsDetailKey && $this->po_08_head->FormValue != NULL && $this->po_08_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_08_head->caption(), $this->po_08_head->RequiredErrorMessage));
			}
		}
		if ($this->po_17_head->Required) {
			if (!$this->po_17_head->IsDetailKey && $this->po_17_head->FormValue != NULL && $this->po_17_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_17_head->caption(), $this->po_17_head->RequiredErrorMessage));
			}
		}
		if ($this->po_18_head->Required) {
			if (!$this->po_18_head->IsDetailKey && $this->po_18_head->FormValue != NULL && $this->po_18_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_18_head->caption(), $this->po_18_head->RequiredErrorMessage));
			}
		}
		if ($this->po_19_head->Required) {
			if (!$this->po_19_head->IsDetailKey && $this->po_19_head->FormValue != NULL && $this->po_19_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_19_head->caption(), $this->po_19_head->RequiredErrorMessage));
			}
		}
		if ($this->po_20_head->Required) {
			if (!$this->po_20_head->IsDetailKey && $this->po_20_head->FormValue != NULL && $this->po_20_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_20_head->caption(), $this->po_20_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_01_head->Required) {
			if (!$this->jc_01_head->IsDetailKey && $this->jc_01_head->FormValue != NULL && $this->jc_01_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_01_head->caption(), $this->jc_01_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_02_head->Required) {
			if (!$this->jc_02_head->IsDetailKey && $this->jc_02_head->FormValue != NULL && $this->jc_02_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_02_head->caption(), $this->jc_02_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_03_head->Required) {
			if (!$this->jc_03_head->IsDetailKey && $this->jc_03_head->FormValue != NULL && $this->jc_03_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_03_head->caption(), $this->jc_03_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_04_head->Required) {
			if (!$this->jc_04_head->IsDetailKey && $this->jc_04_head->FormValue != NULL && $this->jc_04_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_04_head->caption(), $this->jc_04_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_05_head->Required) {
			if (!$this->jc_05_head->IsDetailKey && $this->jc_05_head->FormValue != NULL && $this->jc_05_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_05_head->caption(), $this->jc_05_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_06_head->Required) {
			if (!$this->jc_06_head->IsDetailKey && $this->jc_06_head->FormValue != NULL && $this->jc_06_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_06_head->caption(), $this->jc_06_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_07_head->Required) {
			if (!$this->jc_07_head->IsDetailKey && $this->jc_07_head->FormValue != NULL && $this->jc_07_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_07_head->caption(), $this->jc_07_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_08_head->Required) {
			if (!$this->jc_08_head->IsDetailKey && $this->jc_08_head->FormValue != NULL && $this->jc_08_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_08_head->caption(), $this->jc_08_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_09_head->Required) {
			if (!$this->jc_09_head->IsDetailKey && $this->jc_09_head->FormValue != NULL && $this->jc_09_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_09_head->caption(), $this->jc_09_head->RequiredErrorMessage));
			}
		}
		if ($this->jc_10_head->Required) {
			if (!$this->jc_10_head->IsDetailKey && $this->jc_10_head->FormValue != NULL && $this->jc_10_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_10_head->caption(), $this->jc_10_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_shape->Required) {
			if (!$this->pc_shape->IsDetailKey && $this->pc_shape->FormValue != NULL && $this->pc_shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_shape->caption(), $this->pc_shape->RequiredErrorMessage));
			}
		}
		if ($this->pc_unit->Required) {
			if (!$this->pc_unit->IsDetailKey && $this->pc_unit->FormValue != NULL && $this->pc_unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_unit->caption(), $this->pc_unit->RequiredErrorMessage));
			}
		}
		if ($this->pc_w->Required) {
			if (!$this->pc_w->IsDetailKey && $this->pc_w->FormValue != NULL && $this->pc_w->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_w->caption(), $this->pc_w->RequiredErrorMessage));
			}
		}
		if ($this->pc_l->Required) {
			if (!$this->pc_l->IsDetailKey && $this->pc_l->FormValue != NULL && $this->pc_l->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_l->caption(), $this->pc_l->RequiredErrorMessage));
			}
		}
		if ($this->pc_h->Required) {
			if (!$this->pc_h->IsDetailKey && $this->pc_h->FormValue != NULL && $this->pc_h->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_h->caption(), $this->pc_h->RequiredErrorMessage));
			}
		}
		if ($this->pc_partner_size->Required) {
			if (!$this->pc_partner_size->IsDetailKey && $this->pc_partner_size->FormValue != NULL && $this->pc_partner_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_partner_size->caption(), $this->pc_partner_size->RequiredErrorMessage));
			}
		}
		if ($this->pc_sqm->Required) {
			if (!$this->pc_sqm->IsDetailKey && $this->pc_sqm->FormValue != NULL && $this->pc_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_sqm->caption(), $this->pc_sqm->RequiredErrorMessage));
			}
		}
		if ($this->pc_01_head->Required) {
			if (!$this->pc_01_head->IsDetailKey && $this->pc_01_head->FormValue != NULL && $this->pc_01_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_01_head->caption(), $this->pc_01_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_02_head->Required) {
			if (!$this->pc_02_head->IsDetailKey && $this->pc_02_head->FormValue != NULL && $this->pc_02_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_02_head->caption(), $this->pc_02_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_03_head->Required) {
			if (!$this->pc_03_head->IsDetailKey && $this->pc_03_head->FormValue != NULL && $this->pc_03_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_03_head->caption(), $this->pc_03_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_04_head->Required) {
			if (!$this->pc_04_head->IsDetailKey && $this->pc_04_head->FormValue != NULL && $this->pc_04_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_04_head->caption(), $this->pc_04_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_05_head->Required) {
			if (!$this->pc_05_head->IsDetailKey && $this->pc_05_head->FormValue != NULL && $this->pc_05_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_05_head->caption(), $this->pc_05_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_06_head->Required) {
			if (!$this->pc_06_head->IsDetailKey && $this->pc_06_head->FormValue != NULL && $this->pc_06_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_06_head->caption(), $this->pc_06_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_07_head->Required) {
			if (!$this->pc_07_head->IsDetailKey && $this->pc_07_head->FormValue != NULL && $this->pc_07_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_07_head->caption(), $this->pc_07_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_08_head->Required) {
			if (!$this->pc_08_head->IsDetailKey && $this->pc_08_head->FormValue != NULL && $this->pc_08_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_08_head->caption(), $this->pc_08_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_09_head->Required) {
			if (!$this->pc_09_head->IsDetailKey && $this->pc_09_head->FormValue != NULL && $this->pc_09_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_09_head->caption(), $this->pc_09_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_10_head->Required) {
			if (!$this->pc_10_head->IsDetailKey && $this->pc_10_head->FormValue != NULL && $this->pc_10_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_10_head->caption(), $this->pc_10_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_11_head->Required) {
			if (!$this->pc_11_head->IsDetailKey && $this->pc_11_head->FormValue != NULL && $this->pc_11_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_11_head->caption(), $this->pc_11_head->RequiredErrorMessage));
			}
		}
		if ($this->pc_12_head->Required) {
			if (!$this->pc_12_head->IsDetailKey && $this->pc_12_head->FormValue != NULL && $this->pc_12_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pc_12_head->caption(), $this->pc_12_head->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->image->OldUploadPath = '../uploads/category/s_grp';
			$this->image->UploadPath = $this->image->OldUploadPath;
		}
		$rsnew = [];

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, FALSE);

		// product_group
		$this->product_group->setDbValueDef($rsnew, $this->product_group->CurrentValue, NULL, FALSE);

		// calculation_method
		$this->calculation_method->setDbValueDef($rsnew, $this->calculation_method->CurrentValue, 0, FALSE);

		// shape
		$this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, "", strval($this->shape->CurrentValue) == "");

		// sqm
		$this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, "", strval($this->sqm->CurrentValue) == "");

		// cbm
		$this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, "", strval($this->cbm->CurrentValue) == "");

		// process
		$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, strval($this->status->CurrentValue) == "");

		// v_00
		$this->v_00->setDbValueDef($rsnew, $this->v_00->CurrentValue, NULL, strval($this->v_00->CurrentValue) == "");

		// v_01
		$this->v_01->setDbValueDef($rsnew, $this->v_01->CurrentValue, "", strval($this->v_01->CurrentValue) == "");

		// v_01_validation
		$this->v_01_validation->setDbValueDef($rsnew, $this->v_01_validation->CurrentValue, "", strval($this->v_01_validation->CurrentValue) == "");

		// v_02
		$this->v_02->setDbValueDef($rsnew, $this->v_02->CurrentValue, "", strval($this->v_02->CurrentValue) == "");

		// v_02_validation
		$this->v_02_validation->setDbValueDef($rsnew, $this->v_02_validation->CurrentValue, "", strval($this->v_02_validation->CurrentValue) == "");

		// v_03
		$this->v_03->setDbValueDef($rsnew, $this->v_03->CurrentValue, "", strval($this->v_03->CurrentValue) == "");

		// v_03_validation
		$this->v_03_validation->setDbValueDef($rsnew, $this->v_03_validation->CurrentValue, "", strval($this->v_03_validation->CurrentValue) == "");

		// v_04
		$this->v_04->setDbValueDef($rsnew, $this->v_04->CurrentValue, "", strval($this->v_04->CurrentValue) == "");

		// v_04_validation
		$this->v_04_validation->setDbValueDef($rsnew, $this->v_04_validation->CurrentValue, "", strval($this->v_04_validation->CurrentValue) == "");

		// v_05
		$this->v_05->setDbValueDef($rsnew, $this->v_05->CurrentValue, "", strval($this->v_05->CurrentValue) == "");

		// v_05_validation
		$this->v_05_validation->setDbValueDef($rsnew, $this->v_05_validation->CurrentValue, "", strval($this->v_05_validation->CurrentValue) == "");

		// v_06
		$this->v_06->setDbValueDef($rsnew, $this->v_06->CurrentValue, "", strval($this->v_06->CurrentValue) == "");

		// v_06_validation
		$this->v_06_validation->setDbValueDef($rsnew, $this->v_06_validation->CurrentValue, "", strval($this->v_06_validation->CurrentValue) == "");

		// v_07
		$this->v_07->setDbValueDef($rsnew, $this->v_07->CurrentValue, "", strval($this->v_07->CurrentValue) == "");

		// v_07_validation
		$this->v_07_validation->setDbValueDef($rsnew, $this->v_07_validation->CurrentValue, "", strval($this->v_07_validation->CurrentValue) == "");

		// v_08
		$this->v_08->setDbValueDef($rsnew, $this->v_08->CurrentValue, "", strval($this->v_08->CurrentValue) == "");

		// v_08_validation
		$this->v_08_validation->setDbValueDef($rsnew, $this->v_08_validation->CurrentValue, "", strval($this->v_08_validation->CurrentValue) == "");

		// v_09
		$this->v_09->setDbValueDef($rsnew, $this->v_09->CurrentValue, "", strval($this->v_09->CurrentValue) == "");

		// v_09_validation
		$this->v_09_validation->setDbValueDef($rsnew, $this->v_09_validation->CurrentValue, "", strval($this->v_09_validation->CurrentValue) == "");

		// v_10
		$this->v_10->setDbValueDef($rsnew, $this->v_10->CurrentValue, "", strval($this->v_10->CurrentValue) == "");

		// v_10_validation
		$this->v_10_validation->setDbValueDef($rsnew, $this->v_10_validation->CurrentValue, "", strval($this->v_10_validation->CurrentValue) == "");

		// b_01_head
		$this->b_01_head->setDbValueDef($rsnew, $this->b_01_head->CurrentValue, "", strval($this->b_01_head->CurrentValue) == "");

		// b_02_head
		$this->b_02_head->setDbValueDef($rsnew, $this->b_02_head->CurrentValue, "", strval($this->b_02_head->CurrentValue) == "");

		// b_03_head
		$this->b_03_head->setDbValueDef($rsnew, $this->b_03_head->CurrentValue, "", strval($this->b_03_head->CurrentValue) == "");

		// b_04_head
		$this->b_04_head->setDbValueDef($rsnew, $this->b_04_head->CurrentValue, "", strval($this->b_04_head->CurrentValue) == "");

		// b_05_head
		$this->b_05_head->setDbValueDef($rsnew, $this->b_05_head->CurrentValue, "", strval($this->b_05_head->CurrentValue) == "");

		// b_06_head
		$this->b_06_head->setDbValueDef($rsnew, $this->b_06_head->CurrentValue, "", strval($this->b_06_head->CurrentValue) == "");

		// b_07_head
		$this->b_07_head->setDbValueDef($rsnew, $this->b_07_head->CurrentValue, "", strval($this->b_07_head->CurrentValue) == "");

		// b_08_head
		$this->b_08_head->setDbValueDef($rsnew, $this->b_08_head->CurrentValue, "", strval($this->b_08_head->CurrentValue) == "");

		// b_09_head
		$this->b_09_head->setDbValueDef($rsnew, $this->b_09_head->CurrentValue, "", strval($this->b_09_head->CurrentValue) == "");

		// b_10_head
		$this->b_10_head->setDbValueDef($rsnew, $this->b_10_head->CurrentValue, "", strval($this->b_10_head->CurrentValue) == "");

		// b_11_head
		$this->b_11_head->setDbValueDef($rsnew, $this->b_11_head->CurrentValue, "", strval($this->b_11_head->CurrentValue) == "");

		// b_12_head
		$this->b_12_head->setDbValueDef($rsnew, $this->b_12_head->CurrentValue, "", strval($this->b_12_head->CurrentValue) == "");

		// b_13_head
		$this->b_13_head->setDbValueDef($rsnew, $this->b_13_head->CurrentValue, "", strval($this->b_13_head->CurrentValue) == "");

		// b_14_head
		$this->b_14_head->setDbValueDef($rsnew, $this->b_14_head->CurrentValue, "", strval($this->b_14_head->CurrentValue) == "");

		// b_15_head
		$this->b_15_head->setDbValueDef($rsnew, $this->b_15_head->CurrentValue, "", strval($this->b_15_head->CurrentValue) == "");

		// q_sku
		$this->q_sku->setDbValueDef($rsnew, $this->q_sku->CurrentValue, "", strval($this->q_sku->CurrentValue) == "");

		// t_01_head
		$this->t_01_head->setDbValueDef($rsnew, $this->t_01_head->CurrentValue, "", strval($this->t_01_head->CurrentValue) == "");

		// t_02_head
		$this->t_02_head->setDbValueDef($rsnew, $this->t_02_head->CurrentValue, "", strval($this->t_02_head->CurrentValue) == "");

		// t_03_head
		$this->t_03_head->setDbValueDef($rsnew, $this->t_03_head->CurrentValue, "", strval($this->t_03_head->CurrentValue) == "");

		// t_04_head
		$this->t_04_head->setDbValueDef($rsnew, $this->t_04_head->CurrentValue, "", strval($this->t_04_head->CurrentValue) == "");

		// t_05_head
		$this->t_05_head->setDbValueDef($rsnew, $this->t_05_head->CurrentValue, "", strval($this->t_05_head->CurrentValue) == "");

		// t_06_head
		$this->t_06_head->setDbValueDef($rsnew, $this->t_06_head->CurrentValue, "", strval($this->t_06_head->CurrentValue) == "");

		// t_07_head
		$this->t_07_head->setDbValueDef($rsnew, $this->t_07_head->CurrentValue, "", strval($this->t_07_head->CurrentValue) == "");

		// t_08_head
		$this->t_08_head->setDbValueDef($rsnew, $this->t_08_head->CurrentValue, "", strval($this->t_08_head->CurrentValue) == "");

		// t_09_head
		$this->t_09_head->setDbValueDef($rsnew, $this->t_09_head->CurrentValue, "", strval($this->t_09_head->CurrentValue) == "");

		// t_10_head
		$this->t_10_head->setDbValueDef($rsnew, $this->t_10_head->CurrentValue, "", strval($this->t_10_head->CurrentValue) == "");

		// t_11_head
		$this->t_11_head->setDbValueDef($rsnew, $this->t_11_head->CurrentValue, "", strval($this->t_11_head->CurrentValue) == "");

		// t_12_head
		$this->t_12_head->setDbValueDef($rsnew, $this->t_12_head->CurrentValue, "", strval($this->t_12_head->CurrentValue) == "");

		// t_13_head
		$this->t_13_head->setDbValueDef($rsnew, $this->t_13_head->CurrentValue, "", strval($this->t_13_head->CurrentValue) == "");

		// t_14_head
		$this->t_14_head->setDbValueDef($rsnew, $this->t_14_head->CurrentValue, "", strval($this->t_14_head->CurrentValue) == "");

		// t_15_head
		$this->t_15_head->setDbValueDef($rsnew, $this->t_15_head->CurrentValue, "", strval($this->t_15_head->CurrentValue) == "");

		// po_01_head
		$this->po_01_head->setDbValueDef($rsnew, $this->po_01_head->CurrentValue, "", strval($this->po_01_head->CurrentValue) == "");

		// po_02_head
		$this->po_02_head->setDbValueDef($rsnew, $this->po_02_head->CurrentValue, "", strval($this->po_02_head->CurrentValue) == "");

		// po_03_head
		$this->po_03_head->setDbValueDef($rsnew, $this->po_03_head->CurrentValue, "", strval($this->po_03_head->CurrentValue) == "");

		// po_04_head
		$this->po_04_head->setDbValueDef($rsnew, $this->po_04_head->CurrentValue, "", strval($this->po_04_head->CurrentValue) == "");

		// po_05_head
		$this->po_05_head->setDbValueDef($rsnew, $this->po_05_head->CurrentValue, "", strval($this->po_05_head->CurrentValue) == "");

		// po_06_head
		$this->po_06_head->setDbValueDef($rsnew, $this->po_06_head->CurrentValue, "", strval($this->po_06_head->CurrentValue) == "");

		// po_07_head
		$this->po_07_head->setDbValueDef($rsnew, $this->po_07_head->CurrentValue, "", strval($this->po_07_head->CurrentValue) == "");

		// po_08_head
		$this->po_08_head->setDbValueDef($rsnew, $this->po_08_head->CurrentValue, "", strval($this->po_08_head->CurrentValue) == "");

		// po_17_head
		$this->po_17_head->setDbValueDef($rsnew, $this->po_17_head->CurrentValue, "", strval($this->po_17_head->CurrentValue) == "");

		// po_18_head
		$this->po_18_head->setDbValueDef($rsnew, $this->po_18_head->CurrentValue, "", strval($this->po_18_head->CurrentValue) == "");

		// po_19_head
		$this->po_19_head->setDbValueDef($rsnew, $this->po_19_head->CurrentValue, "", strval($this->po_19_head->CurrentValue) == "");

		// po_20_head
		$this->po_20_head->setDbValueDef($rsnew, $this->po_20_head->CurrentValue, "", strval($this->po_20_head->CurrentValue) == "");

		// jc_01_head
		$this->jc_01_head->setDbValueDef($rsnew, $this->jc_01_head->CurrentValue, "", strval($this->jc_01_head->CurrentValue) == "");

		// jc_02_head
		$this->jc_02_head->setDbValueDef($rsnew, $this->jc_02_head->CurrentValue, "", strval($this->jc_02_head->CurrentValue) == "");

		// jc_03_head
		$this->jc_03_head->setDbValueDef($rsnew, $this->jc_03_head->CurrentValue, "", strval($this->jc_03_head->CurrentValue) == "");

		// jc_04_head
		$this->jc_04_head->setDbValueDef($rsnew, $this->jc_04_head->CurrentValue, "", strval($this->jc_04_head->CurrentValue) == "");

		// jc_05_head
		$this->jc_05_head->setDbValueDef($rsnew, $this->jc_05_head->CurrentValue, "", strval($this->jc_05_head->CurrentValue) == "");

		// jc_06_head
		$this->jc_06_head->setDbValueDef($rsnew, $this->jc_06_head->CurrentValue, "", strval($this->jc_06_head->CurrentValue) == "");

		// jc_07_head
		$this->jc_07_head->setDbValueDef($rsnew, $this->jc_07_head->CurrentValue, "", strval($this->jc_07_head->CurrentValue) == "");

		// jc_08_head
		$this->jc_08_head->setDbValueDef($rsnew, $this->jc_08_head->CurrentValue, "", strval($this->jc_08_head->CurrentValue) == "");

		// jc_09_head
		$this->jc_09_head->setDbValueDef($rsnew, $this->jc_09_head->CurrentValue, "", strval($this->jc_09_head->CurrentValue) == "");

		// jc_10_head
		$this->jc_10_head->setDbValueDef($rsnew, $this->jc_10_head->CurrentValue, NULL, strval($this->jc_10_head->CurrentValue) == "");

		// pc_shape
		$this->pc_shape->setDbValueDef($rsnew, $this->pc_shape->CurrentValue, "", strval($this->pc_shape->CurrentValue) == "");

		// pc_unit
		$this->pc_unit->setDbValueDef($rsnew, $this->pc_unit->CurrentValue, "", strval($this->pc_unit->CurrentValue) == "");

		// pc_w
		$this->pc_w->setDbValueDef($rsnew, $this->pc_w->CurrentValue, "", strval($this->pc_w->CurrentValue) == "");

		// pc_l
		$this->pc_l->setDbValueDef($rsnew, $this->pc_l->CurrentValue, "", strval($this->pc_l->CurrentValue) == "");

		// pc_h
		$this->pc_h->setDbValueDef($rsnew, $this->pc_h->CurrentValue, "", strval($this->pc_h->CurrentValue) == "");

		// pc_partner_size
		$this->pc_partner_size->setDbValueDef($rsnew, $this->pc_partner_size->CurrentValue, "", strval($this->pc_partner_size->CurrentValue) == "");

		// pc_sqm
		$this->pc_sqm->setDbValueDef($rsnew, $this->pc_sqm->CurrentValue, "", strval($this->pc_sqm->CurrentValue) == "");

		// pc_01_head
		$this->pc_01_head->setDbValueDef($rsnew, $this->pc_01_head->CurrentValue, "", strval($this->pc_01_head->CurrentValue) == "");

		// pc_02_head
		$this->pc_02_head->setDbValueDef($rsnew, $this->pc_02_head->CurrentValue, "", strval($this->pc_02_head->CurrentValue) == "");

		// pc_03_head
		$this->pc_03_head->setDbValueDef($rsnew, $this->pc_03_head->CurrentValue, "", strval($this->pc_03_head->CurrentValue) == "");

		// pc_04_head
		$this->pc_04_head->setDbValueDef($rsnew, $this->pc_04_head->CurrentValue, "", strval($this->pc_04_head->CurrentValue) == "");

		// pc_05_head
		$this->pc_05_head->setDbValueDef($rsnew, $this->pc_05_head->CurrentValue, "", strval($this->pc_05_head->CurrentValue) == "");

		// pc_06_head
		$this->pc_06_head->setDbValueDef($rsnew, $this->pc_06_head->CurrentValue, "", strval($this->pc_06_head->CurrentValue) == "");

		// pc_07_head
		$this->pc_07_head->setDbValueDef($rsnew, $this->pc_07_head->CurrentValue, "", strval($this->pc_07_head->CurrentValue) == "");

		// pc_08_head
		$this->pc_08_head->setDbValueDef($rsnew, $this->pc_08_head->CurrentValue, "", strval($this->pc_08_head->CurrentValue) == "");

		// pc_09_head
		$this->pc_09_head->setDbValueDef($rsnew, $this->pc_09_head->CurrentValue, "", strval($this->pc_09_head->CurrentValue) == "");

		// pc_10_head
		$this->pc_10_head->setDbValueDef($rsnew, $this->pc_10_head->CurrentValue, "", strval($this->pc_10_head->CurrentValue) == "");

		// pc_11_head
		$this->pc_11_head->setDbValueDef($rsnew, $this->pc_11_head->CurrentValue, "", strval($this->pc_11_head->CurrentValue) == "");

		// pc_12_head
		$this->pc_12_head->setDbValueDef($rsnew, $this->pc_12_head->CurrentValue, "", strval($this->pc_12_head->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// image
		if ($this->image->Visible && !$this->image->Upload->KeepFile) {
			$this->image->Upload->DbValue = ""; // No need to delete old file
			if ($this->image->Upload->FileName == "") {
				$rsnew['image'] = NULL;
			} else {
				if ($rsold && $rsold->fields['image'] <> "" && $this->image->Upload->FileName <> "") {
					$oldFiles = array($rsold->fields['image']);
					$newFiles = array($this->image->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->image->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i], UploadTempPath($this->image, $this->image->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['image'] = $this->image->Upload->FileName;
			}
			$this->image->ImageWidth = 300; // Resize width
			$this->image->ImageHeight = 300; // Resize height
		}
		if ($this->image->Visible && !$this->image->Upload->KeepFile) {
			$this->image->UploadPath = '../uploads/category/s_grp';
			$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
			if (!EmptyValue($this->image->Upload->FileName)) {
				$newFiles = array($this->image->Upload->FileName);
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->image->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file1) || file_exists($this->image->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->image->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->image, $this->image->Upload->Index) . $file, UploadTempPath($this->image, $this->image->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->image->Visible && !$this->image->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
					if (!EmptyValue($this->image->Upload->FileName)) {
						$newFiles = array($this->image->Upload->FileName);
						$newFiles2 = array($rsnew['image']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->image->Upload->resizeAndSaveToFile($this->image->ImageWidth, $this->image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// image
		if ($this->image->Upload->FileToken <> "")
			CleanUploadTempPath($this->image->Upload->FileToken, $this->image->Upload->Index);
		else
			CleanUploadTempPath($this->image, $this->image->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("product_grouplist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_calculation_method":
							break;
						case "x_process":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>