<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_group_list extends product_group
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_group';

	// Page object name
	public $PageObjName = "product_group_list";

	// Grid form hidden field names
	public $FormName = "fproduct_grouplist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_group)
		if (!isset($GLOBALS["product_group"]) || get_class($GLOBALS["product_group"]) == PROJECT_NAMESPACE . "product_group") {
			$GLOBALS["product_group"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["product_group"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "product_groupadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "product_groupdelete.php";
		$this->MultiUpdateUrl = "product_groupupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fproduct_grouplistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $product_group;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_group);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->product_group->setVisibility();
		$this->calculation_method->setVisibility();
		$this->shape->setVisibility();
		$this->sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->process->setVisibility();
		$this->status->setVisibility();
		$this->v_00->setVisibility();
		$this->v_01->setVisibility();
		$this->v_01_validation->setVisibility();
		$this->v_02->setVisibility();
		$this->v_02_validation->setVisibility();
		$this->v_03->setVisibility();
		$this->v_03_validation->setVisibility();
		$this->v_04->setVisibility();
		$this->v_04_validation->setVisibility();
		$this->v_05->setVisibility();
		$this->v_05_validation->setVisibility();
		$this->v_06->setVisibility();
		$this->v_06_validation->setVisibility();
		$this->v_07->setVisibility();
		$this->v_07_validation->setVisibility();
		$this->v_08->setVisibility();
		$this->v_08_validation->setVisibility();
		$this->v_09->setVisibility();
		$this->v_09_validation->setVisibility();
		$this->v_10->setVisibility();
		$this->v_10_validation->setVisibility();
		$this->b_01_head->setVisibility();
		$this->b_02_head->setVisibility();
		$this->b_03_head->setVisibility();
		$this->b_04_head->setVisibility();
		$this->b_05_head->setVisibility();
		$this->b_06_head->setVisibility();
		$this->b_07_head->setVisibility();
		$this->b_08_head->setVisibility();
		$this->b_09_head->setVisibility();
		$this->b_10_head->setVisibility();
		$this->b_11_head->setVisibility();
		$this->b_12_head->setVisibility();
		$this->b_13_head->setVisibility();
		$this->b_14_head->setVisibility();
		$this->b_15_head->setVisibility();
		$this->q_sku->setVisibility();
		$this->t_01_head->setVisibility();
		$this->t_02_head->setVisibility();
		$this->t_03_head->setVisibility();
		$this->t_04_head->setVisibility();
		$this->t_05_head->setVisibility();
		$this->t_06_head->setVisibility();
		$this->t_07_head->setVisibility();
		$this->t_08_head->setVisibility();
		$this->t_09_head->setVisibility();
		$this->t_10_head->setVisibility();
		$this->t_11_head->setVisibility();
		$this->t_12_head->setVisibility();
		$this->t_13_head->setVisibility();
		$this->t_14_head->setVisibility();
		$this->t_15_head->setVisibility();
		$this->po_01_head->setVisibility();
		$this->po_02_head->setVisibility();
		$this->po_03_head->setVisibility();
		$this->po_04_head->setVisibility();
		$this->po_05_head->setVisibility();
		$this->po_06_head->setVisibility();
		$this->po_07_head->setVisibility();
		$this->po_08_head->setVisibility();
		$this->po_17_head->setVisibility();
		$this->po_18_head->setVisibility();
		$this->po_19_head->setVisibility();
		$this->po_20_head->setVisibility();
		$this->jc_01_head->setVisibility();
		$this->jc_02_head->setVisibility();
		$this->jc_03_head->setVisibility();
		$this->jc_04_head->setVisibility();
		$this->jc_05_head->setVisibility();
		$this->jc_06_head->setVisibility();
		$this->jc_07_head->setVisibility();
		$this->jc_08_head->setVisibility();
		$this->jc_09_head->setVisibility();
		$this->jc_10_head->setVisibility();
		$this->pc_shape->setVisibility();
		$this->pc_unit->setVisibility();
		$this->pc_w->setVisibility();
		$this->pc_l->setVisibility();
		$this->pc_h->setVisibility();
		$this->pc_partner_size->setVisibility();
		$this->pc_sqm->setVisibility();
		$this->pc_01_head->setVisibility();
		$this->pc_02_head->setVisibility();
		$this->pc_03_head->setVisibility();
		$this->pc_04_head->setVisibility();
		$this->pc_05_head->setVisibility();
		$this->pc_06_head->setVisibility();
		$this->pc_07_head->setVisibility();
		$this->pc_08_head->setVisibility();
		$this->pc_09_head->setVisibility();
		$this->pc_10_head->setVisibility();
		$this->pc_11_head->setVisibility();
		$this->pc_12_head->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->image->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->calculation_method);
		$this->setupLookupOptions($this->process);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fproduct_grouplistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->product_group->AdvancedSearch->toJson(), ","); // Field product_group
		$filterList = Concat($filterList, $this->calculation_method->AdvancedSearch->toJson(), ","); // Field calculation_method
		$filterList = Concat($filterList, $this->shape->AdvancedSearch->toJson(), ","); // Field shape
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
		$filterList = Concat($filterList, $this->process->AdvancedSearch->toJson(), ","); // Field process
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->v_00->AdvancedSearch->toJson(), ","); // Field v_00
		$filterList = Concat($filterList, $this->v_01->AdvancedSearch->toJson(), ","); // Field v_01
		$filterList = Concat($filterList, $this->v_01_validation->AdvancedSearch->toJson(), ","); // Field v_01_validation
		$filterList = Concat($filterList, $this->v_02->AdvancedSearch->toJson(), ","); // Field v_02
		$filterList = Concat($filterList, $this->v_02_validation->AdvancedSearch->toJson(), ","); // Field v_02_validation
		$filterList = Concat($filterList, $this->v_03->AdvancedSearch->toJson(), ","); // Field v_03
		$filterList = Concat($filterList, $this->v_03_validation->AdvancedSearch->toJson(), ","); // Field v_03_validation
		$filterList = Concat($filterList, $this->v_04->AdvancedSearch->toJson(), ","); // Field v_04
		$filterList = Concat($filterList, $this->v_04_validation->AdvancedSearch->toJson(), ","); // Field v_04_validation
		$filterList = Concat($filterList, $this->v_05->AdvancedSearch->toJson(), ","); // Field v_05
		$filterList = Concat($filterList, $this->v_05_validation->AdvancedSearch->toJson(), ","); // Field v_05_validation
		$filterList = Concat($filterList, $this->v_06->AdvancedSearch->toJson(), ","); // Field v_06
		$filterList = Concat($filterList, $this->v_06_validation->AdvancedSearch->toJson(), ","); // Field v_06_validation
		$filterList = Concat($filterList, $this->v_07->AdvancedSearch->toJson(), ","); // Field v_07
		$filterList = Concat($filterList, $this->v_07_validation->AdvancedSearch->toJson(), ","); // Field v_07_validation
		$filterList = Concat($filterList, $this->v_08->AdvancedSearch->toJson(), ","); // Field v_08
		$filterList = Concat($filterList, $this->v_08_validation->AdvancedSearch->toJson(), ","); // Field v_08_validation
		$filterList = Concat($filterList, $this->v_09->AdvancedSearch->toJson(), ","); // Field v_09
		$filterList = Concat($filterList, $this->v_09_validation->AdvancedSearch->toJson(), ","); // Field v_09_validation
		$filterList = Concat($filterList, $this->v_10->AdvancedSearch->toJson(), ","); // Field v_10
		$filterList = Concat($filterList, $this->v_10_validation->AdvancedSearch->toJson(), ","); // Field v_10_validation
		$filterList = Concat($filterList, $this->b_01_head->AdvancedSearch->toJson(), ","); // Field b_01_head
		$filterList = Concat($filterList, $this->b_02_head->AdvancedSearch->toJson(), ","); // Field b_02_head
		$filterList = Concat($filterList, $this->b_03_head->AdvancedSearch->toJson(), ","); // Field b_03_head
		$filterList = Concat($filterList, $this->b_04_head->AdvancedSearch->toJson(), ","); // Field b_04_head
		$filterList = Concat($filterList, $this->b_05_head->AdvancedSearch->toJson(), ","); // Field b_05_head
		$filterList = Concat($filterList, $this->b_06_head->AdvancedSearch->toJson(), ","); // Field b_06_head
		$filterList = Concat($filterList, $this->b_07_head->AdvancedSearch->toJson(), ","); // Field b_07_head
		$filterList = Concat($filterList, $this->b_08_head->AdvancedSearch->toJson(), ","); // Field b_08_head
		$filterList = Concat($filterList, $this->b_09_head->AdvancedSearch->toJson(), ","); // Field b_09_head
		$filterList = Concat($filterList, $this->b_10_head->AdvancedSearch->toJson(), ","); // Field b_10_head
		$filterList = Concat($filterList, $this->b_11_head->AdvancedSearch->toJson(), ","); // Field b_11_head
		$filterList = Concat($filterList, $this->b_12_head->AdvancedSearch->toJson(), ","); // Field b_12_head
		$filterList = Concat($filterList, $this->b_13_head->AdvancedSearch->toJson(), ","); // Field b_13_head
		$filterList = Concat($filterList, $this->b_14_head->AdvancedSearch->toJson(), ","); // Field b_14_head
		$filterList = Concat($filterList, $this->b_15_head->AdvancedSearch->toJson(), ","); // Field b_15_head
		$filterList = Concat($filterList, $this->q_sku->AdvancedSearch->toJson(), ","); // Field q_sku
		$filterList = Concat($filterList, $this->t_01_head->AdvancedSearch->toJson(), ","); // Field t_01_head
		$filterList = Concat($filterList, $this->t_02_head->AdvancedSearch->toJson(), ","); // Field t_02_head
		$filterList = Concat($filterList, $this->t_03_head->AdvancedSearch->toJson(), ","); // Field t_03_head
		$filterList = Concat($filterList, $this->t_04_head->AdvancedSearch->toJson(), ","); // Field t_04_head
		$filterList = Concat($filterList, $this->t_05_head->AdvancedSearch->toJson(), ","); // Field t_05_head
		$filterList = Concat($filterList, $this->t_06_head->AdvancedSearch->toJson(), ","); // Field t_06_head
		$filterList = Concat($filterList, $this->t_07_head->AdvancedSearch->toJson(), ","); // Field t_07_head
		$filterList = Concat($filterList, $this->t_08_head->AdvancedSearch->toJson(), ","); // Field t_08_head
		$filterList = Concat($filterList, $this->t_09_head->AdvancedSearch->toJson(), ","); // Field t_09_head
		$filterList = Concat($filterList, $this->t_10_head->AdvancedSearch->toJson(), ","); // Field t_10_head
		$filterList = Concat($filterList, $this->t_11_head->AdvancedSearch->toJson(), ","); // Field t_11_head
		$filterList = Concat($filterList, $this->t_12_head->AdvancedSearch->toJson(), ","); // Field t_12_head
		$filterList = Concat($filterList, $this->t_13_head->AdvancedSearch->toJson(), ","); // Field t_13_head
		$filterList = Concat($filterList, $this->t_14_head->AdvancedSearch->toJson(), ","); // Field t_14_head
		$filterList = Concat($filterList, $this->t_15_head->AdvancedSearch->toJson(), ","); // Field t_15_head
		$filterList = Concat($filterList, $this->po_01_head->AdvancedSearch->toJson(), ","); // Field po_01_head
		$filterList = Concat($filterList, $this->po_02_head->AdvancedSearch->toJson(), ","); // Field po_02_head
		$filterList = Concat($filterList, $this->po_03_head->AdvancedSearch->toJson(), ","); // Field po_03_head
		$filterList = Concat($filterList, $this->po_04_head->AdvancedSearch->toJson(), ","); // Field po_04_head
		$filterList = Concat($filterList, $this->po_05_head->AdvancedSearch->toJson(), ","); // Field po_05_head
		$filterList = Concat($filterList, $this->po_06_head->AdvancedSearch->toJson(), ","); // Field po_06_head
		$filterList = Concat($filterList, $this->po_07_head->AdvancedSearch->toJson(), ","); // Field po_07_head
		$filterList = Concat($filterList, $this->po_08_head->AdvancedSearch->toJson(), ","); // Field po_08_head
		$filterList = Concat($filterList, $this->po_17_head->AdvancedSearch->toJson(), ","); // Field po_17_head
		$filterList = Concat($filterList, $this->po_18_head->AdvancedSearch->toJson(), ","); // Field po_18_head
		$filterList = Concat($filterList, $this->po_19_head->AdvancedSearch->toJson(), ","); // Field po_19_head
		$filterList = Concat($filterList, $this->po_20_head->AdvancedSearch->toJson(), ","); // Field po_20_head
		$filterList = Concat($filterList, $this->jc_01_head->AdvancedSearch->toJson(), ","); // Field jc_01_head
		$filterList = Concat($filterList, $this->jc_02_head->AdvancedSearch->toJson(), ","); // Field jc_02_head
		$filterList = Concat($filterList, $this->jc_03_head->AdvancedSearch->toJson(), ","); // Field jc_03_head
		$filterList = Concat($filterList, $this->jc_04_head->AdvancedSearch->toJson(), ","); // Field jc_04_head
		$filterList = Concat($filterList, $this->jc_05_head->AdvancedSearch->toJson(), ","); // Field jc_05_head
		$filterList = Concat($filterList, $this->jc_06_head->AdvancedSearch->toJson(), ","); // Field jc_06_head
		$filterList = Concat($filterList, $this->jc_07_head->AdvancedSearch->toJson(), ","); // Field jc_07_head
		$filterList = Concat($filterList, $this->jc_08_head->AdvancedSearch->toJson(), ","); // Field jc_08_head
		$filterList = Concat($filterList, $this->jc_09_head->AdvancedSearch->toJson(), ","); // Field jc_09_head
		$filterList = Concat($filterList, $this->jc_10_head->AdvancedSearch->toJson(), ","); // Field jc_10_head
		$filterList = Concat($filterList, $this->pc_shape->AdvancedSearch->toJson(), ","); // Field pc_shape
		$filterList = Concat($filterList, $this->pc_unit->AdvancedSearch->toJson(), ","); // Field pc_unit
		$filterList = Concat($filterList, $this->pc_w->AdvancedSearch->toJson(), ","); // Field pc_w
		$filterList = Concat($filterList, $this->pc_l->AdvancedSearch->toJson(), ","); // Field pc_l
		$filterList = Concat($filterList, $this->pc_h->AdvancedSearch->toJson(), ","); // Field pc_h
		$filterList = Concat($filterList, $this->pc_partner_size->AdvancedSearch->toJson(), ","); // Field pc_partner_size
		$filterList = Concat($filterList, $this->pc_sqm->AdvancedSearch->toJson(), ","); // Field pc_sqm
		$filterList = Concat($filterList, $this->pc_01_head->AdvancedSearch->toJson(), ","); // Field pc_01_head
		$filterList = Concat($filterList, $this->pc_02_head->AdvancedSearch->toJson(), ","); // Field pc_02_head
		$filterList = Concat($filterList, $this->pc_03_head->AdvancedSearch->toJson(), ","); // Field pc_03_head
		$filterList = Concat($filterList, $this->pc_04_head->AdvancedSearch->toJson(), ","); // Field pc_04_head
		$filterList = Concat($filterList, $this->pc_05_head->AdvancedSearch->toJson(), ","); // Field pc_05_head
		$filterList = Concat($filterList, $this->pc_06_head->AdvancedSearch->toJson(), ","); // Field pc_06_head
		$filterList = Concat($filterList, $this->pc_07_head->AdvancedSearch->toJson(), ","); // Field pc_07_head
		$filterList = Concat($filterList, $this->pc_08_head->AdvancedSearch->toJson(), ","); // Field pc_08_head
		$filterList = Concat($filterList, $this->pc_09_head->AdvancedSearch->toJson(), ","); // Field pc_09_head
		$filterList = Concat($filterList, $this->pc_10_head->AdvancedSearch->toJson(), ","); // Field pc_10_head
		$filterList = Concat($filterList, $this->pc_11_head->AdvancedSearch->toJson(), ","); // Field pc_11_head
		$filterList = Concat($filterList, $this->pc_12_head->AdvancedSearch->toJson(), ","); // Field pc_12_head
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fproduct_grouplistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field product_group
		$this->product_group->AdvancedSearch->SearchValue = @$filter["x_product_group"];
		$this->product_group->AdvancedSearch->SearchOperator = @$filter["z_product_group"];
		$this->product_group->AdvancedSearch->SearchCondition = @$filter["v_product_group"];
		$this->product_group->AdvancedSearch->SearchValue2 = @$filter["y_product_group"];
		$this->product_group->AdvancedSearch->SearchOperator2 = @$filter["w_product_group"];
		$this->product_group->AdvancedSearch->save();

		// Field calculation_method
		$this->calculation_method->AdvancedSearch->SearchValue = @$filter["x_calculation_method"];
		$this->calculation_method->AdvancedSearch->SearchOperator = @$filter["z_calculation_method"];
		$this->calculation_method->AdvancedSearch->SearchCondition = @$filter["v_calculation_method"];
		$this->calculation_method->AdvancedSearch->SearchValue2 = @$filter["y_calculation_method"];
		$this->calculation_method->AdvancedSearch->SearchOperator2 = @$filter["w_calculation_method"];
		$this->calculation_method->AdvancedSearch->save();

		// Field shape
		$this->shape->AdvancedSearch->SearchValue = @$filter["x_shape"];
		$this->shape->AdvancedSearch->SearchOperator = @$filter["z_shape"];
		$this->shape->AdvancedSearch->SearchCondition = @$filter["v_shape"];
		$this->shape->AdvancedSearch->SearchValue2 = @$filter["y_shape"];
		$this->shape->AdvancedSearch->SearchOperator2 = @$filter["w_shape"];
		$this->shape->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field cbm
		$this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
		$this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
		$this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
		$this->cbm->AdvancedSearch->save();

		// Field process
		$this->process->AdvancedSearch->SearchValue = @$filter["x_process"];
		$this->process->AdvancedSearch->SearchOperator = @$filter["z_process"];
		$this->process->AdvancedSearch->SearchCondition = @$filter["v_process"];
		$this->process->AdvancedSearch->SearchValue2 = @$filter["y_process"];
		$this->process->AdvancedSearch->SearchOperator2 = @$filter["w_process"];
		$this->process->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field v_00
		$this->v_00->AdvancedSearch->SearchValue = @$filter["x_v_00"];
		$this->v_00->AdvancedSearch->SearchOperator = @$filter["z_v_00"];
		$this->v_00->AdvancedSearch->SearchCondition = @$filter["v_v_00"];
		$this->v_00->AdvancedSearch->SearchValue2 = @$filter["y_v_00"];
		$this->v_00->AdvancedSearch->SearchOperator2 = @$filter["w_v_00"];
		$this->v_00->AdvancedSearch->save();

		// Field v_01
		$this->v_01->AdvancedSearch->SearchValue = @$filter["x_v_01"];
		$this->v_01->AdvancedSearch->SearchOperator = @$filter["z_v_01"];
		$this->v_01->AdvancedSearch->SearchCondition = @$filter["v_v_01"];
		$this->v_01->AdvancedSearch->SearchValue2 = @$filter["y_v_01"];
		$this->v_01->AdvancedSearch->SearchOperator2 = @$filter["w_v_01"];
		$this->v_01->AdvancedSearch->save();

		// Field v_01_validation
		$this->v_01_validation->AdvancedSearch->SearchValue = @$filter["x_v_01_validation"];
		$this->v_01_validation->AdvancedSearch->SearchOperator = @$filter["z_v_01_validation"];
		$this->v_01_validation->AdvancedSearch->SearchCondition = @$filter["v_v_01_validation"];
		$this->v_01_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_01_validation"];
		$this->v_01_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_01_validation"];
		$this->v_01_validation->AdvancedSearch->save();

		// Field v_02
		$this->v_02->AdvancedSearch->SearchValue = @$filter["x_v_02"];
		$this->v_02->AdvancedSearch->SearchOperator = @$filter["z_v_02"];
		$this->v_02->AdvancedSearch->SearchCondition = @$filter["v_v_02"];
		$this->v_02->AdvancedSearch->SearchValue2 = @$filter["y_v_02"];
		$this->v_02->AdvancedSearch->SearchOperator2 = @$filter["w_v_02"];
		$this->v_02->AdvancedSearch->save();

		// Field v_02_validation
		$this->v_02_validation->AdvancedSearch->SearchValue = @$filter["x_v_02_validation"];
		$this->v_02_validation->AdvancedSearch->SearchOperator = @$filter["z_v_02_validation"];
		$this->v_02_validation->AdvancedSearch->SearchCondition = @$filter["v_v_02_validation"];
		$this->v_02_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_02_validation"];
		$this->v_02_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_02_validation"];
		$this->v_02_validation->AdvancedSearch->save();

		// Field v_03
		$this->v_03->AdvancedSearch->SearchValue = @$filter["x_v_03"];
		$this->v_03->AdvancedSearch->SearchOperator = @$filter["z_v_03"];
		$this->v_03->AdvancedSearch->SearchCondition = @$filter["v_v_03"];
		$this->v_03->AdvancedSearch->SearchValue2 = @$filter["y_v_03"];
		$this->v_03->AdvancedSearch->SearchOperator2 = @$filter["w_v_03"];
		$this->v_03->AdvancedSearch->save();

		// Field v_03_validation
		$this->v_03_validation->AdvancedSearch->SearchValue = @$filter["x_v_03_validation"];
		$this->v_03_validation->AdvancedSearch->SearchOperator = @$filter["z_v_03_validation"];
		$this->v_03_validation->AdvancedSearch->SearchCondition = @$filter["v_v_03_validation"];
		$this->v_03_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_03_validation"];
		$this->v_03_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_03_validation"];
		$this->v_03_validation->AdvancedSearch->save();

		// Field v_04
		$this->v_04->AdvancedSearch->SearchValue = @$filter["x_v_04"];
		$this->v_04->AdvancedSearch->SearchOperator = @$filter["z_v_04"];
		$this->v_04->AdvancedSearch->SearchCondition = @$filter["v_v_04"];
		$this->v_04->AdvancedSearch->SearchValue2 = @$filter["y_v_04"];
		$this->v_04->AdvancedSearch->SearchOperator2 = @$filter["w_v_04"];
		$this->v_04->AdvancedSearch->save();

		// Field v_04_validation
		$this->v_04_validation->AdvancedSearch->SearchValue = @$filter["x_v_04_validation"];
		$this->v_04_validation->AdvancedSearch->SearchOperator = @$filter["z_v_04_validation"];
		$this->v_04_validation->AdvancedSearch->SearchCondition = @$filter["v_v_04_validation"];
		$this->v_04_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_04_validation"];
		$this->v_04_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_04_validation"];
		$this->v_04_validation->AdvancedSearch->save();

		// Field v_05
		$this->v_05->AdvancedSearch->SearchValue = @$filter["x_v_05"];
		$this->v_05->AdvancedSearch->SearchOperator = @$filter["z_v_05"];
		$this->v_05->AdvancedSearch->SearchCondition = @$filter["v_v_05"];
		$this->v_05->AdvancedSearch->SearchValue2 = @$filter["y_v_05"];
		$this->v_05->AdvancedSearch->SearchOperator2 = @$filter["w_v_05"];
		$this->v_05->AdvancedSearch->save();

		// Field v_05_validation
		$this->v_05_validation->AdvancedSearch->SearchValue = @$filter["x_v_05_validation"];
		$this->v_05_validation->AdvancedSearch->SearchOperator = @$filter["z_v_05_validation"];
		$this->v_05_validation->AdvancedSearch->SearchCondition = @$filter["v_v_05_validation"];
		$this->v_05_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_05_validation"];
		$this->v_05_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_05_validation"];
		$this->v_05_validation->AdvancedSearch->save();

		// Field v_06
		$this->v_06->AdvancedSearch->SearchValue = @$filter["x_v_06"];
		$this->v_06->AdvancedSearch->SearchOperator = @$filter["z_v_06"];
		$this->v_06->AdvancedSearch->SearchCondition = @$filter["v_v_06"];
		$this->v_06->AdvancedSearch->SearchValue2 = @$filter["y_v_06"];
		$this->v_06->AdvancedSearch->SearchOperator2 = @$filter["w_v_06"];
		$this->v_06->AdvancedSearch->save();

		// Field v_06_validation
		$this->v_06_validation->AdvancedSearch->SearchValue = @$filter["x_v_06_validation"];
		$this->v_06_validation->AdvancedSearch->SearchOperator = @$filter["z_v_06_validation"];
		$this->v_06_validation->AdvancedSearch->SearchCondition = @$filter["v_v_06_validation"];
		$this->v_06_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_06_validation"];
		$this->v_06_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_06_validation"];
		$this->v_06_validation->AdvancedSearch->save();

		// Field v_07
		$this->v_07->AdvancedSearch->SearchValue = @$filter["x_v_07"];
		$this->v_07->AdvancedSearch->SearchOperator = @$filter["z_v_07"];
		$this->v_07->AdvancedSearch->SearchCondition = @$filter["v_v_07"];
		$this->v_07->AdvancedSearch->SearchValue2 = @$filter["y_v_07"];
		$this->v_07->AdvancedSearch->SearchOperator2 = @$filter["w_v_07"];
		$this->v_07->AdvancedSearch->save();

		// Field v_07_validation
		$this->v_07_validation->AdvancedSearch->SearchValue = @$filter["x_v_07_validation"];
		$this->v_07_validation->AdvancedSearch->SearchOperator = @$filter["z_v_07_validation"];
		$this->v_07_validation->AdvancedSearch->SearchCondition = @$filter["v_v_07_validation"];
		$this->v_07_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_07_validation"];
		$this->v_07_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_07_validation"];
		$this->v_07_validation->AdvancedSearch->save();

		// Field v_08
		$this->v_08->AdvancedSearch->SearchValue = @$filter["x_v_08"];
		$this->v_08->AdvancedSearch->SearchOperator = @$filter["z_v_08"];
		$this->v_08->AdvancedSearch->SearchCondition = @$filter["v_v_08"];
		$this->v_08->AdvancedSearch->SearchValue2 = @$filter["y_v_08"];
		$this->v_08->AdvancedSearch->SearchOperator2 = @$filter["w_v_08"];
		$this->v_08->AdvancedSearch->save();

		// Field v_08_validation
		$this->v_08_validation->AdvancedSearch->SearchValue = @$filter["x_v_08_validation"];
		$this->v_08_validation->AdvancedSearch->SearchOperator = @$filter["z_v_08_validation"];
		$this->v_08_validation->AdvancedSearch->SearchCondition = @$filter["v_v_08_validation"];
		$this->v_08_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_08_validation"];
		$this->v_08_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_08_validation"];
		$this->v_08_validation->AdvancedSearch->save();

		// Field v_09
		$this->v_09->AdvancedSearch->SearchValue = @$filter["x_v_09"];
		$this->v_09->AdvancedSearch->SearchOperator = @$filter["z_v_09"];
		$this->v_09->AdvancedSearch->SearchCondition = @$filter["v_v_09"];
		$this->v_09->AdvancedSearch->SearchValue2 = @$filter["y_v_09"];
		$this->v_09->AdvancedSearch->SearchOperator2 = @$filter["w_v_09"];
		$this->v_09->AdvancedSearch->save();

		// Field v_09_validation
		$this->v_09_validation->AdvancedSearch->SearchValue = @$filter["x_v_09_validation"];
		$this->v_09_validation->AdvancedSearch->SearchOperator = @$filter["z_v_09_validation"];
		$this->v_09_validation->AdvancedSearch->SearchCondition = @$filter["v_v_09_validation"];
		$this->v_09_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_09_validation"];
		$this->v_09_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_09_validation"];
		$this->v_09_validation->AdvancedSearch->save();

		// Field v_10
		$this->v_10->AdvancedSearch->SearchValue = @$filter["x_v_10"];
		$this->v_10->AdvancedSearch->SearchOperator = @$filter["z_v_10"];
		$this->v_10->AdvancedSearch->SearchCondition = @$filter["v_v_10"];
		$this->v_10->AdvancedSearch->SearchValue2 = @$filter["y_v_10"];
		$this->v_10->AdvancedSearch->SearchOperator2 = @$filter["w_v_10"];
		$this->v_10->AdvancedSearch->save();

		// Field v_10_validation
		$this->v_10_validation->AdvancedSearch->SearchValue = @$filter["x_v_10_validation"];
		$this->v_10_validation->AdvancedSearch->SearchOperator = @$filter["z_v_10_validation"];
		$this->v_10_validation->AdvancedSearch->SearchCondition = @$filter["v_v_10_validation"];
		$this->v_10_validation->AdvancedSearch->SearchValue2 = @$filter["y_v_10_validation"];
		$this->v_10_validation->AdvancedSearch->SearchOperator2 = @$filter["w_v_10_validation"];
		$this->v_10_validation->AdvancedSearch->save();

		// Field b_01_head
		$this->b_01_head->AdvancedSearch->SearchValue = @$filter["x_b_01_head"];
		$this->b_01_head->AdvancedSearch->SearchOperator = @$filter["z_b_01_head"];
		$this->b_01_head->AdvancedSearch->SearchCondition = @$filter["v_b_01_head"];
		$this->b_01_head->AdvancedSearch->SearchValue2 = @$filter["y_b_01_head"];
		$this->b_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_01_head"];
		$this->b_01_head->AdvancedSearch->save();

		// Field b_02_head
		$this->b_02_head->AdvancedSearch->SearchValue = @$filter["x_b_02_head"];
		$this->b_02_head->AdvancedSearch->SearchOperator = @$filter["z_b_02_head"];
		$this->b_02_head->AdvancedSearch->SearchCondition = @$filter["v_b_02_head"];
		$this->b_02_head->AdvancedSearch->SearchValue2 = @$filter["y_b_02_head"];
		$this->b_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_02_head"];
		$this->b_02_head->AdvancedSearch->save();

		// Field b_03_head
		$this->b_03_head->AdvancedSearch->SearchValue = @$filter["x_b_03_head"];
		$this->b_03_head->AdvancedSearch->SearchOperator = @$filter["z_b_03_head"];
		$this->b_03_head->AdvancedSearch->SearchCondition = @$filter["v_b_03_head"];
		$this->b_03_head->AdvancedSearch->SearchValue2 = @$filter["y_b_03_head"];
		$this->b_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_03_head"];
		$this->b_03_head->AdvancedSearch->save();

		// Field b_04_head
		$this->b_04_head->AdvancedSearch->SearchValue = @$filter["x_b_04_head"];
		$this->b_04_head->AdvancedSearch->SearchOperator = @$filter["z_b_04_head"];
		$this->b_04_head->AdvancedSearch->SearchCondition = @$filter["v_b_04_head"];
		$this->b_04_head->AdvancedSearch->SearchValue2 = @$filter["y_b_04_head"];
		$this->b_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_04_head"];
		$this->b_04_head->AdvancedSearch->save();

		// Field b_05_head
		$this->b_05_head->AdvancedSearch->SearchValue = @$filter["x_b_05_head"];
		$this->b_05_head->AdvancedSearch->SearchOperator = @$filter["z_b_05_head"];
		$this->b_05_head->AdvancedSearch->SearchCondition = @$filter["v_b_05_head"];
		$this->b_05_head->AdvancedSearch->SearchValue2 = @$filter["y_b_05_head"];
		$this->b_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_05_head"];
		$this->b_05_head->AdvancedSearch->save();

		// Field b_06_head
		$this->b_06_head->AdvancedSearch->SearchValue = @$filter["x_b_06_head"];
		$this->b_06_head->AdvancedSearch->SearchOperator = @$filter["z_b_06_head"];
		$this->b_06_head->AdvancedSearch->SearchCondition = @$filter["v_b_06_head"];
		$this->b_06_head->AdvancedSearch->SearchValue2 = @$filter["y_b_06_head"];
		$this->b_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_06_head"];
		$this->b_06_head->AdvancedSearch->save();

		// Field b_07_head
		$this->b_07_head->AdvancedSearch->SearchValue = @$filter["x_b_07_head"];
		$this->b_07_head->AdvancedSearch->SearchOperator = @$filter["z_b_07_head"];
		$this->b_07_head->AdvancedSearch->SearchCondition = @$filter["v_b_07_head"];
		$this->b_07_head->AdvancedSearch->SearchValue2 = @$filter["y_b_07_head"];
		$this->b_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_07_head"];
		$this->b_07_head->AdvancedSearch->save();

		// Field b_08_head
		$this->b_08_head->AdvancedSearch->SearchValue = @$filter["x_b_08_head"];
		$this->b_08_head->AdvancedSearch->SearchOperator = @$filter["z_b_08_head"];
		$this->b_08_head->AdvancedSearch->SearchCondition = @$filter["v_b_08_head"];
		$this->b_08_head->AdvancedSearch->SearchValue2 = @$filter["y_b_08_head"];
		$this->b_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_08_head"];
		$this->b_08_head->AdvancedSearch->save();

		// Field b_09_head
		$this->b_09_head->AdvancedSearch->SearchValue = @$filter["x_b_09_head"];
		$this->b_09_head->AdvancedSearch->SearchOperator = @$filter["z_b_09_head"];
		$this->b_09_head->AdvancedSearch->SearchCondition = @$filter["v_b_09_head"];
		$this->b_09_head->AdvancedSearch->SearchValue2 = @$filter["y_b_09_head"];
		$this->b_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_09_head"];
		$this->b_09_head->AdvancedSearch->save();

		// Field b_10_head
		$this->b_10_head->AdvancedSearch->SearchValue = @$filter["x_b_10_head"];
		$this->b_10_head->AdvancedSearch->SearchOperator = @$filter["z_b_10_head"];
		$this->b_10_head->AdvancedSearch->SearchCondition = @$filter["v_b_10_head"];
		$this->b_10_head->AdvancedSearch->SearchValue2 = @$filter["y_b_10_head"];
		$this->b_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_10_head"];
		$this->b_10_head->AdvancedSearch->save();

		// Field b_11_head
		$this->b_11_head->AdvancedSearch->SearchValue = @$filter["x_b_11_head"];
		$this->b_11_head->AdvancedSearch->SearchOperator = @$filter["z_b_11_head"];
		$this->b_11_head->AdvancedSearch->SearchCondition = @$filter["v_b_11_head"];
		$this->b_11_head->AdvancedSearch->SearchValue2 = @$filter["y_b_11_head"];
		$this->b_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_11_head"];
		$this->b_11_head->AdvancedSearch->save();

		// Field b_12_head
		$this->b_12_head->AdvancedSearch->SearchValue = @$filter["x_b_12_head"];
		$this->b_12_head->AdvancedSearch->SearchOperator = @$filter["z_b_12_head"];
		$this->b_12_head->AdvancedSearch->SearchCondition = @$filter["v_b_12_head"];
		$this->b_12_head->AdvancedSearch->SearchValue2 = @$filter["y_b_12_head"];
		$this->b_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_12_head"];
		$this->b_12_head->AdvancedSearch->save();

		// Field b_13_head
		$this->b_13_head->AdvancedSearch->SearchValue = @$filter["x_b_13_head"];
		$this->b_13_head->AdvancedSearch->SearchOperator = @$filter["z_b_13_head"];
		$this->b_13_head->AdvancedSearch->SearchCondition = @$filter["v_b_13_head"];
		$this->b_13_head->AdvancedSearch->SearchValue2 = @$filter["y_b_13_head"];
		$this->b_13_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_13_head"];
		$this->b_13_head->AdvancedSearch->save();

		// Field b_14_head
		$this->b_14_head->AdvancedSearch->SearchValue = @$filter["x_b_14_head"];
		$this->b_14_head->AdvancedSearch->SearchOperator = @$filter["z_b_14_head"];
		$this->b_14_head->AdvancedSearch->SearchCondition = @$filter["v_b_14_head"];
		$this->b_14_head->AdvancedSearch->SearchValue2 = @$filter["y_b_14_head"];
		$this->b_14_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_14_head"];
		$this->b_14_head->AdvancedSearch->save();

		// Field b_15_head
		$this->b_15_head->AdvancedSearch->SearchValue = @$filter["x_b_15_head"];
		$this->b_15_head->AdvancedSearch->SearchOperator = @$filter["z_b_15_head"];
		$this->b_15_head->AdvancedSearch->SearchCondition = @$filter["v_b_15_head"];
		$this->b_15_head->AdvancedSearch->SearchValue2 = @$filter["y_b_15_head"];
		$this->b_15_head->AdvancedSearch->SearchOperator2 = @$filter["w_b_15_head"];
		$this->b_15_head->AdvancedSearch->save();

		// Field q_sku
		$this->q_sku->AdvancedSearch->SearchValue = @$filter["x_q_sku"];
		$this->q_sku->AdvancedSearch->SearchOperator = @$filter["z_q_sku"];
		$this->q_sku->AdvancedSearch->SearchCondition = @$filter["v_q_sku"];
		$this->q_sku->AdvancedSearch->SearchValue2 = @$filter["y_q_sku"];
		$this->q_sku->AdvancedSearch->SearchOperator2 = @$filter["w_q_sku"];
		$this->q_sku->AdvancedSearch->save();

		// Field t_01_head
		$this->t_01_head->AdvancedSearch->SearchValue = @$filter["x_t_01_head"];
		$this->t_01_head->AdvancedSearch->SearchOperator = @$filter["z_t_01_head"];
		$this->t_01_head->AdvancedSearch->SearchCondition = @$filter["v_t_01_head"];
		$this->t_01_head->AdvancedSearch->SearchValue2 = @$filter["y_t_01_head"];
		$this->t_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_01_head"];
		$this->t_01_head->AdvancedSearch->save();

		// Field t_02_head
		$this->t_02_head->AdvancedSearch->SearchValue = @$filter["x_t_02_head"];
		$this->t_02_head->AdvancedSearch->SearchOperator = @$filter["z_t_02_head"];
		$this->t_02_head->AdvancedSearch->SearchCondition = @$filter["v_t_02_head"];
		$this->t_02_head->AdvancedSearch->SearchValue2 = @$filter["y_t_02_head"];
		$this->t_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_02_head"];
		$this->t_02_head->AdvancedSearch->save();

		// Field t_03_head
		$this->t_03_head->AdvancedSearch->SearchValue = @$filter["x_t_03_head"];
		$this->t_03_head->AdvancedSearch->SearchOperator = @$filter["z_t_03_head"];
		$this->t_03_head->AdvancedSearch->SearchCondition = @$filter["v_t_03_head"];
		$this->t_03_head->AdvancedSearch->SearchValue2 = @$filter["y_t_03_head"];
		$this->t_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_03_head"];
		$this->t_03_head->AdvancedSearch->save();

		// Field t_04_head
		$this->t_04_head->AdvancedSearch->SearchValue = @$filter["x_t_04_head"];
		$this->t_04_head->AdvancedSearch->SearchOperator = @$filter["z_t_04_head"];
		$this->t_04_head->AdvancedSearch->SearchCondition = @$filter["v_t_04_head"];
		$this->t_04_head->AdvancedSearch->SearchValue2 = @$filter["y_t_04_head"];
		$this->t_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_04_head"];
		$this->t_04_head->AdvancedSearch->save();

		// Field t_05_head
		$this->t_05_head->AdvancedSearch->SearchValue = @$filter["x_t_05_head"];
		$this->t_05_head->AdvancedSearch->SearchOperator = @$filter["z_t_05_head"];
		$this->t_05_head->AdvancedSearch->SearchCondition = @$filter["v_t_05_head"];
		$this->t_05_head->AdvancedSearch->SearchValue2 = @$filter["y_t_05_head"];
		$this->t_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_05_head"];
		$this->t_05_head->AdvancedSearch->save();

		// Field t_06_head
		$this->t_06_head->AdvancedSearch->SearchValue = @$filter["x_t_06_head"];
		$this->t_06_head->AdvancedSearch->SearchOperator = @$filter["z_t_06_head"];
		$this->t_06_head->AdvancedSearch->SearchCondition = @$filter["v_t_06_head"];
		$this->t_06_head->AdvancedSearch->SearchValue2 = @$filter["y_t_06_head"];
		$this->t_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_06_head"];
		$this->t_06_head->AdvancedSearch->save();

		// Field t_07_head
		$this->t_07_head->AdvancedSearch->SearchValue = @$filter["x_t_07_head"];
		$this->t_07_head->AdvancedSearch->SearchOperator = @$filter["z_t_07_head"];
		$this->t_07_head->AdvancedSearch->SearchCondition = @$filter["v_t_07_head"];
		$this->t_07_head->AdvancedSearch->SearchValue2 = @$filter["y_t_07_head"];
		$this->t_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_07_head"];
		$this->t_07_head->AdvancedSearch->save();

		// Field t_08_head
		$this->t_08_head->AdvancedSearch->SearchValue = @$filter["x_t_08_head"];
		$this->t_08_head->AdvancedSearch->SearchOperator = @$filter["z_t_08_head"];
		$this->t_08_head->AdvancedSearch->SearchCondition = @$filter["v_t_08_head"];
		$this->t_08_head->AdvancedSearch->SearchValue2 = @$filter["y_t_08_head"];
		$this->t_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_08_head"];
		$this->t_08_head->AdvancedSearch->save();

		// Field t_09_head
		$this->t_09_head->AdvancedSearch->SearchValue = @$filter["x_t_09_head"];
		$this->t_09_head->AdvancedSearch->SearchOperator = @$filter["z_t_09_head"];
		$this->t_09_head->AdvancedSearch->SearchCondition = @$filter["v_t_09_head"];
		$this->t_09_head->AdvancedSearch->SearchValue2 = @$filter["y_t_09_head"];
		$this->t_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_09_head"];
		$this->t_09_head->AdvancedSearch->save();

		// Field t_10_head
		$this->t_10_head->AdvancedSearch->SearchValue = @$filter["x_t_10_head"];
		$this->t_10_head->AdvancedSearch->SearchOperator = @$filter["z_t_10_head"];
		$this->t_10_head->AdvancedSearch->SearchCondition = @$filter["v_t_10_head"];
		$this->t_10_head->AdvancedSearch->SearchValue2 = @$filter["y_t_10_head"];
		$this->t_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_10_head"];
		$this->t_10_head->AdvancedSearch->save();

		// Field t_11_head
		$this->t_11_head->AdvancedSearch->SearchValue = @$filter["x_t_11_head"];
		$this->t_11_head->AdvancedSearch->SearchOperator = @$filter["z_t_11_head"];
		$this->t_11_head->AdvancedSearch->SearchCondition = @$filter["v_t_11_head"];
		$this->t_11_head->AdvancedSearch->SearchValue2 = @$filter["y_t_11_head"];
		$this->t_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_11_head"];
		$this->t_11_head->AdvancedSearch->save();

		// Field t_12_head
		$this->t_12_head->AdvancedSearch->SearchValue = @$filter["x_t_12_head"];
		$this->t_12_head->AdvancedSearch->SearchOperator = @$filter["z_t_12_head"];
		$this->t_12_head->AdvancedSearch->SearchCondition = @$filter["v_t_12_head"];
		$this->t_12_head->AdvancedSearch->SearchValue2 = @$filter["y_t_12_head"];
		$this->t_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_12_head"];
		$this->t_12_head->AdvancedSearch->save();

		// Field t_13_head
		$this->t_13_head->AdvancedSearch->SearchValue = @$filter["x_t_13_head"];
		$this->t_13_head->AdvancedSearch->SearchOperator = @$filter["z_t_13_head"];
		$this->t_13_head->AdvancedSearch->SearchCondition = @$filter["v_t_13_head"];
		$this->t_13_head->AdvancedSearch->SearchValue2 = @$filter["y_t_13_head"];
		$this->t_13_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_13_head"];
		$this->t_13_head->AdvancedSearch->save();

		// Field t_14_head
		$this->t_14_head->AdvancedSearch->SearchValue = @$filter["x_t_14_head"];
		$this->t_14_head->AdvancedSearch->SearchOperator = @$filter["z_t_14_head"];
		$this->t_14_head->AdvancedSearch->SearchCondition = @$filter["v_t_14_head"];
		$this->t_14_head->AdvancedSearch->SearchValue2 = @$filter["y_t_14_head"];
		$this->t_14_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_14_head"];
		$this->t_14_head->AdvancedSearch->save();

		// Field t_15_head
		$this->t_15_head->AdvancedSearch->SearchValue = @$filter["x_t_15_head"];
		$this->t_15_head->AdvancedSearch->SearchOperator = @$filter["z_t_15_head"];
		$this->t_15_head->AdvancedSearch->SearchCondition = @$filter["v_t_15_head"];
		$this->t_15_head->AdvancedSearch->SearchValue2 = @$filter["y_t_15_head"];
		$this->t_15_head->AdvancedSearch->SearchOperator2 = @$filter["w_t_15_head"];
		$this->t_15_head->AdvancedSearch->save();

		// Field po_01_head
		$this->po_01_head->AdvancedSearch->SearchValue = @$filter["x_po_01_head"];
		$this->po_01_head->AdvancedSearch->SearchOperator = @$filter["z_po_01_head"];
		$this->po_01_head->AdvancedSearch->SearchCondition = @$filter["v_po_01_head"];
		$this->po_01_head->AdvancedSearch->SearchValue2 = @$filter["y_po_01_head"];
		$this->po_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_01_head"];
		$this->po_01_head->AdvancedSearch->save();

		// Field po_02_head
		$this->po_02_head->AdvancedSearch->SearchValue = @$filter["x_po_02_head"];
		$this->po_02_head->AdvancedSearch->SearchOperator = @$filter["z_po_02_head"];
		$this->po_02_head->AdvancedSearch->SearchCondition = @$filter["v_po_02_head"];
		$this->po_02_head->AdvancedSearch->SearchValue2 = @$filter["y_po_02_head"];
		$this->po_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_02_head"];
		$this->po_02_head->AdvancedSearch->save();

		// Field po_03_head
		$this->po_03_head->AdvancedSearch->SearchValue = @$filter["x_po_03_head"];
		$this->po_03_head->AdvancedSearch->SearchOperator = @$filter["z_po_03_head"];
		$this->po_03_head->AdvancedSearch->SearchCondition = @$filter["v_po_03_head"];
		$this->po_03_head->AdvancedSearch->SearchValue2 = @$filter["y_po_03_head"];
		$this->po_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_03_head"];
		$this->po_03_head->AdvancedSearch->save();

		// Field po_04_head
		$this->po_04_head->AdvancedSearch->SearchValue = @$filter["x_po_04_head"];
		$this->po_04_head->AdvancedSearch->SearchOperator = @$filter["z_po_04_head"];
		$this->po_04_head->AdvancedSearch->SearchCondition = @$filter["v_po_04_head"];
		$this->po_04_head->AdvancedSearch->SearchValue2 = @$filter["y_po_04_head"];
		$this->po_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_04_head"];
		$this->po_04_head->AdvancedSearch->save();

		// Field po_05_head
		$this->po_05_head->AdvancedSearch->SearchValue = @$filter["x_po_05_head"];
		$this->po_05_head->AdvancedSearch->SearchOperator = @$filter["z_po_05_head"];
		$this->po_05_head->AdvancedSearch->SearchCondition = @$filter["v_po_05_head"];
		$this->po_05_head->AdvancedSearch->SearchValue2 = @$filter["y_po_05_head"];
		$this->po_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_05_head"];
		$this->po_05_head->AdvancedSearch->save();

		// Field po_06_head
		$this->po_06_head->AdvancedSearch->SearchValue = @$filter["x_po_06_head"];
		$this->po_06_head->AdvancedSearch->SearchOperator = @$filter["z_po_06_head"];
		$this->po_06_head->AdvancedSearch->SearchCondition = @$filter["v_po_06_head"];
		$this->po_06_head->AdvancedSearch->SearchValue2 = @$filter["y_po_06_head"];
		$this->po_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_06_head"];
		$this->po_06_head->AdvancedSearch->save();

		// Field po_07_head
		$this->po_07_head->AdvancedSearch->SearchValue = @$filter["x_po_07_head"];
		$this->po_07_head->AdvancedSearch->SearchOperator = @$filter["z_po_07_head"];
		$this->po_07_head->AdvancedSearch->SearchCondition = @$filter["v_po_07_head"];
		$this->po_07_head->AdvancedSearch->SearchValue2 = @$filter["y_po_07_head"];
		$this->po_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_07_head"];
		$this->po_07_head->AdvancedSearch->save();

		// Field po_08_head
		$this->po_08_head->AdvancedSearch->SearchValue = @$filter["x_po_08_head"];
		$this->po_08_head->AdvancedSearch->SearchOperator = @$filter["z_po_08_head"];
		$this->po_08_head->AdvancedSearch->SearchCondition = @$filter["v_po_08_head"];
		$this->po_08_head->AdvancedSearch->SearchValue2 = @$filter["y_po_08_head"];
		$this->po_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_08_head"];
		$this->po_08_head->AdvancedSearch->save();

		// Field po_17_head
		$this->po_17_head->AdvancedSearch->SearchValue = @$filter["x_po_17_head"];
		$this->po_17_head->AdvancedSearch->SearchOperator = @$filter["z_po_17_head"];
		$this->po_17_head->AdvancedSearch->SearchCondition = @$filter["v_po_17_head"];
		$this->po_17_head->AdvancedSearch->SearchValue2 = @$filter["y_po_17_head"];
		$this->po_17_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_17_head"];
		$this->po_17_head->AdvancedSearch->save();

		// Field po_18_head
		$this->po_18_head->AdvancedSearch->SearchValue = @$filter["x_po_18_head"];
		$this->po_18_head->AdvancedSearch->SearchOperator = @$filter["z_po_18_head"];
		$this->po_18_head->AdvancedSearch->SearchCondition = @$filter["v_po_18_head"];
		$this->po_18_head->AdvancedSearch->SearchValue2 = @$filter["y_po_18_head"];
		$this->po_18_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_18_head"];
		$this->po_18_head->AdvancedSearch->save();

		// Field po_19_head
		$this->po_19_head->AdvancedSearch->SearchValue = @$filter["x_po_19_head"];
		$this->po_19_head->AdvancedSearch->SearchOperator = @$filter["z_po_19_head"];
		$this->po_19_head->AdvancedSearch->SearchCondition = @$filter["v_po_19_head"];
		$this->po_19_head->AdvancedSearch->SearchValue2 = @$filter["y_po_19_head"];
		$this->po_19_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_19_head"];
		$this->po_19_head->AdvancedSearch->save();

		// Field po_20_head
		$this->po_20_head->AdvancedSearch->SearchValue = @$filter["x_po_20_head"];
		$this->po_20_head->AdvancedSearch->SearchOperator = @$filter["z_po_20_head"];
		$this->po_20_head->AdvancedSearch->SearchCondition = @$filter["v_po_20_head"];
		$this->po_20_head->AdvancedSearch->SearchValue2 = @$filter["y_po_20_head"];
		$this->po_20_head->AdvancedSearch->SearchOperator2 = @$filter["w_po_20_head"];
		$this->po_20_head->AdvancedSearch->save();

		// Field jc_01_head
		$this->jc_01_head->AdvancedSearch->SearchValue = @$filter["x_jc_01_head"];
		$this->jc_01_head->AdvancedSearch->SearchOperator = @$filter["z_jc_01_head"];
		$this->jc_01_head->AdvancedSearch->SearchCondition = @$filter["v_jc_01_head"];
		$this->jc_01_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_01_head"];
		$this->jc_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_01_head"];
		$this->jc_01_head->AdvancedSearch->save();

		// Field jc_02_head
		$this->jc_02_head->AdvancedSearch->SearchValue = @$filter["x_jc_02_head"];
		$this->jc_02_head->AdvancedSearch->SearchOperator = @$filter["z_jc_02_head"];
		$this->jc_02_head->AdvancedSearch->SearchCondition = @$filter["v_jc_02_head"];
		$this->jc_02_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_02_head"];
		$this->jc_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_02_head"];
		$this->jc_02_head->AdvancedSearch->save();

		// Field jc_03_head
		$this->jc_03_head->AdvancedSearch->SearchValue = @$filter["x_jc_03_head"];
		$this->jc_03_head->AdvancedSearch->SearchOperator = @$filter["z_jc_03_head"];
		$this->jc_03_head->AdvancedSearch->SearchCondition = @$filter["v_jc_03_head"];
		$this->jc_03_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_03_head"];
		$this->jc_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_03_head"];
		$this->jc_03_head->AdvancedSearch->save();

		// Field jc_04_head
		$this->jc_04_head->AdvancedSearch->SearchValue = @$filter["x_jc_04_head"];
		$this->jc_04_head->AdvancedSearch->SearchOperator = @$filter["z_jc_04_head"];
		$this->jc_04_head->AdvancedSearch->SearchCondition = @$filter["v_jc_04_head"];
		$this->jc_04_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_04_head"];
		$this->jc_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_04_head"];
		$this->jc_04_head->AdvancedSearch->save();

		// Field jc_05_head
		$this->jc_05_head->AdvancedSearch->SearchValue = @$filter["x_jc_05_head"];
		$this->jc_05_head->AdvancedSearch->SearchOperator = @$filter["z_jc_05_head"];
		$this->jc_05_head->AdvancedSearch->SearchCondition = @$filter["v_jc_05_head"];
		$this->jc_05_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_05_head"];
		$this->jc_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_05_head"];
		$this->jc_05_head->AdvancedSearch->save();

		// Field jc_06_head
		$this->jc_06_head->AdvancedSearch->SearchValue = @$filter["x_jc_06_head"];
		$this->jc_06_head->AdvancedSearch->SearchOperator = @$filter["z_jc_06_head"];
		$this->jc_06_head->AdvancedSearch->SearchCondition = @$filter["v_jc_06_head"];
		$this->jc_06_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_06_head"];
		$this->jc_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_06_head"];
		$this->jc_06_head->AdvancedSearch->save();

		// Field jc_07_head
		$this->jc_07_head->AdvancedSearch->SearchValue = @$filter["x_jc_07_head"];
		$this->jc_07_head->AdvancedSearch->SearchOperator = @$filter["z_jc_07_head"];
		$this->jc_07_head->AdvancedSearch->SearchCondition = @$filter["v_jc_07_head"];
		$this->jc_07_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_07_head"];
		$this->jc_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_07_head"];
		$this->jc_07_head->AdvancedSearch->save();

		// Field jc_08_head
		$this->jc_08_head->AdvancedSearch->SearchValue = @$filter["x_jc_08_head"];
		$this->jc_08_head->AdvancedSearch->SearchOperator = @$filter["z_jc_08_head"];
		$this->jc_08_head->AdvancedSearch->SearchCondition = @$filter["v_jc_08_head"];
		$this->jc_08_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_08_head"];
		$this->jc_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_08_head"];
		$this->jc_08_head->AdvancedSearch->save();

		// Field jc_09_head
		$this->jc_09_head->AdvancedSearch->SearchValue = @$filter["x_jc_09_head"];
		$this->jc_09_head->AdvancedSearch->SearchOperator = @$filter["z_jc_09_head"];
		$this->jc_09_head->AdvancedSearch->SearchCondition = @$filter["v_jc_09_head"];
		$this->jc_09_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_09_head"];
		$this->jc_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_09_head"];
		$this->jc_09_head->AdvancedSearch->save();

		// Field jc_10_head
		$this->jc_10_head->AdvancedSearch->SearchValue = @$filter["x_jc_10_head"];
		$this->jc_10_head->AdvancedSearch->SearchOperator = @$filter["z_jc_10_head"];
		$this->jc_10_head->AdvancedSearch->SearchCondition = @$filter["v_jc_10_head"];
		$this->jc_10_head->AdvancedSearch->SearchValue2 = @$filter["y_jc_10_head"];
		$this->jc_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_jc_10_head"];
		$this->jc_10_head->AdvancedSearch->save();

		// Field pc_shape
		$this->pc_shape->AdvancedSearch->SearchValue = @$filter["x_pc_shape"];
		$this->pc_shape->AdvancedSearch->SearchOperator = @$filter["z_pc_shape"];
		$this->pc_shape->AdvancedSearch->SearchCondition = @$filter["v_pc_shape"];
		$this->pc_shape->AdvancedSearch->SearchValue2 = @$filter["y_pc_shape"];
		$this->pc_shape->AdvancedSearch->SearchOperator2 = @$filter["w_pc_shape"];
		$this->pc_shape->AdvancedSearch->save();

		// Field pc_unit
		$this->pc_unit->AdvancedSearch->SearchValue = @$filter["x_pc_unit"];
		$this->pc_unit->AdvancedSearch->SearchOperator = @$filter["z_pc_unit"];
		$this->pc_unit->AdvancedSearch->SearchCondition = @$filter["v_pc_unit"];
		$this->pc_unit->AdvancedSearch->SearchValue2 = @$filter["y_pc_unit"];
		$this->pc_unit->AdvancedSearch->SearchOperator2 = @$filter["w_pc_unit"];
		$this->pc_unit->AdvancedSearch->save();

		// Field pc_w
		$this->pc_w->AdvancedSearch->SearchValue = @$filter["x_pc_w"];
		$this->pc_w->AdvancedSearch->SearchOperator = @$filter["z_pc_w"];
		$this->pc_w->AdvancedSearch->SearchCondition = @$filter["v_pc_w"];
		$this->pc_w->AdvancedSearch->SearchValue2 = @$filter["y_pc_w"];
		$this->pc_w->AdvancedSearch->SearchOperator2 = @$filter["w_pc_w"];
		$this->pc_w->AdvancedSearch->save();

		// Field pc_l
		$this->pc_l->AdvancedSearch->SearchValue = @$filter["x_pc_l"];
		$this->pc_l->AdvancedSearch->SearchOperator = @$filter["z_pc_l"];
		$this->pc_l->AdvancedSearch->SearchCondition = @$filter["v_pc_l"];
		$this->pc_l->AdvancedSearch->SearchValue2 = @$filter["y_pc_l"];
		$this->pc_l->AdvancedSearch->SearchOperator2 = @$filter["w_pc_l"];
		$this->pc_l->AdvancedSearch->save();

		// Field pc_h
		$this->pc_h->AdvancedSearch->SearchValue = @$filter["x_pc_h"];
		$this->pc_h->AdvancedSearch->SearchOperator = @$filter["z_pc_h"];
		$this->pc_h->AdvancedSearch->SearchCondition = @$filter["v_pc_h"];
		$this->pc_h->AdvancedSearch->SearchValue2 = @$filter["y_pc_h"];
		$this->pc_h->AdvancedSearch->SearchOperator2 = @$filter["w_pc_h"];
		$this->pc_h->AdvancedSearch->save();

		// Field pc_partner_size
		$this->pc_partner_size->AdvancedSearch->SearchValue = @$filter["x_pc_partner_size"];
		$this->pc_partner_size->AdvancedSearch->SearchOperator = @$filter["z_pc_partner_size"];
		$this->pc_partner_size->AdvancedSearch->SearchCondition = @$filter["v_pc_partner_size"];
		$this->pc_partner_size->AdvancedSearch->SearchValue2 = @$filter["y_pc_partner_size"];
		$this->pc_partner_size->AdvancedSearch->SearchOperator2 = @$filter["w_pc_partner_size"];
		$this->pc_partner_size->AdvancedSearch->save();

		// Field pc_sqm
		$this->pc_sqm->AdvancedSearch->SearchValue = @$filter["x_pc_sqm"];
		$this->pc_sqm->AdvancedSearch->SearchOperator = @$filter["z_pc_sqm"];
		$this->pc_sqm->AdvancedSearch->SearchCondition = @$filter["v_pc_sqm"];
		$this->pc_sqm->AdvancedSearch->SearchValue2 = @$filter["y_pc_sqm"];
		$this->pc_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_pc_sqm"];
		$this->pc_sqm->AdvancedSearch->save();

		// Field pc_01_head
		$this->pc_01_head->AdvancedSearch->SearchValue = @$filter["x_pc_01_head"];
		$this->pc_01_head->AdvancedSearch->SearchOperator = @$filter["z_pc_01_head"];
		$this->pc_01_head->AdvancedSearch->SearchCondition = @$filter["v_pc_01_head"];
		$this->pc_01_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_01_head"];
		$this->pc_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_01_head"];
		$this->pc_01_head->AdvancedSearch->save();

		// Field pc_02_head
		$this->pc_02_head->AdvancedSearch->SearchValue = @$filter["x_pc_02_head"];
		$this->pc_02_head->AdvancedSearch->SearchOperator = @$filter["z_pc_02_head"];
		$this->pc_02_head->AdvancedSearch->SearchCondition = @$filter["v_pc_02_head"];
		$this->pc_02_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_02_head"];
		$this->pc_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_02_head"];
		$this->pc_02_head->AdvancedSearch->save();

		// Field pc_03_head
		$this->pc_03_head->AdvancedSearch->SearchValue = @$filter["x_pc_03_head"];
		$this->pc_03_head->AdvancedSearch->SearchOperator = @$filter["z_pc_03_head"];
		$this->pc_03_head->AdvancedSearch->SearchCondition = @$filter["v_pc_03_head"];
		$this->pc_03_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_03_head"];
		$this->pc_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_03_head"];
		$this->pc_03_head->AdvancedSearch->save();

		// Field pc_04_head
		$this->pc_04_head->AdvancedSearch->SearchValue = @$filter["x_pc_04_head"];
		$this->pc_04_head->AdvancedSearch->SearchOperator = @$filter["z_pc_04_head"];
		$this->pc_04_head->AdvancedSearch->SearchCondition = @$filter["v_pc_04_head"];
		$this->pc_04_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_04_head"];
		$this->pc_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_04_head"];
		$this->pc_04_head->AdvancedSearch->save();

		// Field pc_05_head
		$this->pc_05_head->AdvancedSearch->SearchValue = @$filter["x_pc_05_head"];
		$this->pc_05_head->AdvancedSearch->SearchOperator = @$filter["z_pc_05_head"];
		$this->pc_05_head->AdvancedSearch->SearchCondition = @$filter["v_pc_05_head"];
		$this->pc_05_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_05_head"];
		$this->pc_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_05_head"];
		$this->pc_05_head->AdvancedSearch->save();

		// Field pc_06_head
		$this->pc_06_head->AdvancedSearch->SearchValue = @$filter["x_pc_06_head"];
		$this->pc_06_head->AdvancedSearch->SearchOperator = @$filter["z_pc_06_head"];
		$this->pc_06_head->AdvancedSearch->SearchCondition = @$filter["v_pc_06_head"];
		$this->pc_06_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_06_head"];
		$this->pc_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_06_head"];
		$this->pc_06_head->AdvancedSearch->save();

		// Field pc_07_head
		$this->pc_07_head->AdvancedSearch->SearchValue = @$filter["x_pc_07_head"];
		$this->pc_07_head->AdvancedSearch->SearchOperator = @$filter["z_pc_07_head"];
		$this->pc_07_head->AdvancedSearch->SearchCondition = @$filter["v_pc_07_head"];
		$this->pc_07_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_07_head"];
		$this->pc_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_07_head"];
		$this->pc_07_head->AdvancedSearch->save();

		// Field pc_08_head
		$this->pc_08_head->AdvancedSearch->SearchValue = @$filter["x_pc_08_head"];
		$this->pc_08_head->AdvancedSearch->SearchOperator = @$filter["z_pc_08_head"];
		$this->pc_08_head->AdvancedSearch->SearchCondition = @$filter["v_pc_08_head"];
		$this->pc_08_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_08_head"];
		$this->pc_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_08_head"];
		$this->pc_08_head->AdvancedSearch->save();

		// Field pc_09_head
		$this->pc_09_head->AdvancedSearch->SearchValue = @$filter["x_pc_09_head"];
		$this->pc_09_head->AdvancedSearch->SearchOperator = @$filter["z_pc_09_head"];
		$this->pc_09_head->AdvancedSearch->SearchCondition = @$filter["v_pc_09_head"];
		$this->pc_09_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_09_head"];
		$this->pc_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_09_head"];
		$this->pc_09_head->AdvancedSearch->save();

		// Field pc_10_head
		$this->pc_10_head->AdvancedSearch->SearchValue = @$filter["x_pc_10_head"];
		$this->pc_10_head->AdvancedSearch->SearchOperator = @$filter["z_pc_10_head"];
		$this->pc_10_head->AdvancedSearch->SearchCondition = @$filter["v_pc_10_head"];
		$this->pc_10_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_10_head"];
		$this->pc_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_10_head"];
		$this->pc_10_head->AdvancedSearch->save();

		// Field pc_11_head
		$this->pc_11_head->AdvancedSearch->SearchValue = @$filter["x_pc_11_head"];
		$this->pc_11_head->AdvancedSearch->SearchOperator = @$filter["z_pc_11_head"];
		$this->pc_11_head->AdvancedSearch->SearchCondition = @$filter["v_pc_11_head"];
		$this->pc_11_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_11_head"];
		$this->pc_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_11_head"];
		$this->pc_11_head->AdvancedSearch->save();

		// Field pc_12_head
		$this->pc_12_head->AdvancedSearch->SearchValue = @$filter["x_pc_12_head"];
		$this->pc_12_head->AdvancedSearch->SearchOperator = @$filter["z_pc_12_head"];
		$this->pc_12_head->AdvancedSearch->SearchCondition = @$filter["v_pc_12_head"];
		$this->pc_12_head->AdvancedSearch->SearchValue2 = @$filter["y_pc_12_head"];
		$this->pc_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_pc_12_head"];
		$this->pc_12_head->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field image
		$this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
		$this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
		$this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
		$this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
		$this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
		$this->image->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->product_group, $default, FALSE); // product_group
		$this->buildSearchSql($where, $this->calculation_method, $default, FALSE); // calculation_method
		$this->buildSearchSql($where, $this->shape, $default, FALSE); // shape
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->cbm, $default, FALSE); // cbm
		$this->buildSearchSql($where, $this->process, $default, FALSE); // process
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->v_00, $default, FALSE); // v_00
		$this->buildSearchSql($where, $this->v_01, $default, FALSE); // v_01
		$this->buildSearchSql($where, $this->v_01_validation, $default, FALSE); // v_01_validation
		$this->buildSearchSql($where, $this->v_02, $default, FALSE); // v_02
		$this->buildSearchSql($where, $this->v_02_validation, $default, FALSE); // v_02_validation
		$this->buildSearchSql($where, $this->v_03, $default, FALSE); // v_03
		$this->buildSearchSql($where, $this->v_03_validation, $default, FALSE); // v_03_validation
		$this->buildSearchSql($where, $this->v_04, $default, FALSE); // v_04
		$this->buildSearchSql($where, $this->v_04_validation, $default, FALSE); // v_04_validation
		$this->buildSearchSql($where, $this->v_05, $default, FALSE); // v_05
		$this->buildSearchSql($where, $this->v_05_validation, $default, FALSE); // v_05_validation
		$this->buildSearchSql($where, $this->v_06, $default, FALSE); // v_06
		$this->buildSearchSql($where, $this->v_06_validation, $default, FALSE); // v_06_validation
		$this->buildSearchSql($where, $this->v_07, $default, FALSE); // v_07
		$this->buildSearchSql($where, $this->v_07_validation, $default, FALSE); // v_07_validation
		$this->buildSearchSql($where, $this->v_08, $default, FALSE); // v_08
		$this->buildSearchSql($where, $this->v_08_validation, $default, FALSE); // v_08_validation
		$this->buildSearchSql($where, $this->v_09, $default, FALSE); // v_09
		$this->buildSearchSql($where, $this->v_09_validation, $default, FALSE); // v_09_validation
		$this->buildSearchSql($where, $this->v_10, $default, FALSE); // v_10
		$this->buildSearchSql($where, $this->v_10_validation, $default, FALSE); // v_10_validation
		$this->buildSearchSql($where, $this->b_01_head, $default, FALSE); // b_01_head
		$this->buildSearchSql($where, $this->b_02_head, $default, FALSE); // b_02_head
		$this->buildSearchSql($where, $this->b_03_head, $default, FALSE); // b_03_head
		$this->buildSearchSql($where, $this->b_04_head, $default, FALSE); // b_04_head
		$this->buildSearchSql($where, $this->b_05_head, $default, FALSE); // b_05_head
		$this->buildSearchSql($where, $this->b_06_head, $default, FALSE); // b_06_head
		$this->buildSearchSql($where, $this->b_07_head, $default, FALSE); // b_07_head
		$this->buildSearchSql($where, $this->b_08_head, $default, FALSE); // b_08_head
		$this->buildSearchSql($where, $this->b_09_head, $default, FALSE); // b_09_head
		$this->buildSearchSql($where, $this->b_10_head, $default, FALSE); // b_10_head
		$this->buildSearchSql($where, $this->b_11_head, $default, FALSE); // b_11_head
		$this->buildSearchSql($where, $this->b_12_head, $default, FALSE); // b_12_head
		$this->buildSearchSql($where, $this->b_13_head, $default, FALSE); // b_13_head
		$this->buildSearchSql($where, $this->b_14_head, $default, FALSE); // b_14_head
		$this->buildSearchSql($where, $this->b_15_head, $default, FALSE); // b_15_head
		$this->buildSearchSql($where, $this->q_sku, $default, FALSE); // q_sku
		$this->buildSearchSql($where, $this->t_01_head, $default, FALSE); // t_01_head
		$this->buildSearchSql($where, $this->t_02_head, $default, FALSE); // t_02_head
		$this->buildSearchSql($where, $this->t_03_head, $default, FALSE); // t_03_head
		$this->buildSearchSql($where, $this->t_04_head, $default, FALSE); // t_04_head
		$this->buildSearchSql($where, $this->t_05_head, $default, FALSE); // t_05_head
		$this->buildSearchSql($where, $this->t_06_head, $default, FALSE); // t_06_head
		$this->buildSearchSql($where, $this->t_07_head, $default, FALSE); // t_07_head
		$this->buildSearchSql($where, $this->t_08_head, $default, FALSE); // t_08_head
		$this->buildSearchSql($where, $this->t_09_head, $default, FALSE); // t_09_head
		$this->buildSearchSql($where, $this->t_10_head, $default, FALSE); // t_10_head
		$this->buildSearchSql($where, $this->t_11_head, $default, FALSE); // t_11_head
		$this->buildSearchSql($where, $this->t_12_head, $default, FALSE); // t_12_head
		$this->buildSearchSql($where, $this->t_13_head, $default, FALSE); // t_13_head
		$this->buildSearchSql($where, $this->t_14_head, $default, FALSE); // t_14_head
		$this->buildSearchSql($where, $this->t_15_head, $default, FALSE); // t_15_head
		$this->buildSearchSql($where, $this->po_01_head, $default, FALSE); // po_01_head
		$this->buildSearchSql($where, $this->po_02_head, $default, FALSE); // po_02_head
		$this->buildSearchSql($where, $this->po_03_head, $default, FALSE); // po_03_head
		$this->buildSearchSql($where, $this->po_04_head, $default, FALSE); // po_04_head
		$this->buildSearchSql($where, $this->po_05_head, $default, FALSE); // po_05_head
		$this->buildSearchSql($where, $this->po_06_head, $default, FALSE); // po_06_head
		$this->buildSearchSql($where, $this->po_07_head, $default, FALSE); // po_07_head
		$this->buildSearchSql($where, $this->po_08_head, $default, FALSE); // po_08_head
		$this->buildSearchSql($where, $this->po_17_head, $default, FALSE); // po_17_head
		$this->buildSearchSql($where, $this->po_18_head, $default, FALSE); // po_18_head
		$this->buildSearchSql($where, $this->po_19_head, $default, FALSE); // po_19_head
		$this->buildSearchSql($where, $this->po_20_head, $default, FALSE); // po_20_head
		$this->buildSearchSql($where, $this->jc_01_head, $default, FALSE); // jc_01_head
		$this->buildSearchSql($where, $this->jc_02_head, $default, FALSE); // jc_02_head
		$this->buildSearchSql($where, $this->jc_03_head, $default, FALSE); // jc_03_head
		$this->buildSearchSql($where, $this->jc_04_head, $default, FALSE); // jc_04_head
		$this->buildSearchSql($where, $this->jc_05_head, $default, FALSE); // jc_05_head
		$this->buildSearchSql($where, $this->jc_06_head, $default, FALSE); // jc_06_head
		$this->buildSearchSql($where, $this->jc_07_head, $default, FALSE); // jc_07_head
		$this->buildSearchSql($where, $this->jc_08_head, $default, FALSE); // jc_08_head
		$this->buildSearchSql($where, $this->jc_09_head, $default, FALSE); // jc_09_head
		$this->buildSearchSql($where, $this->jc_10_head, $default, FALSE); // jc_10_head
		$this->buildSearchSql($where, $this->pc_shape, $default, FALSE); // pc_shape
		$this->buildSearchSql($where, $this->pc_unit, $default, FALSE); // pc_unit
		$this->buildSearchSql($where, $this->pc_w, $default, FALSE); // pc_w
		$this->buildSearchSql($where, $this->pc_l, $default, FALSE); // pc_l
		$this->buildSearchSql($where, $this->pc_h, $default, FALSE); // pc_h
		$this->buildSearchSql($where, $this->pc_partner_size, $default, FALSE); // pc_partner_size
		$this->buildSearchSql($where, $this->pc_sqm, $default, FALSE); // pc_sqm
		$this->buildSearchSql($where, $this->pc_01_head, $default, FALSE); // pc_01_head
		$this->buildSearchSql($where, $this->pc_02_head, $default, FALSE); // pc_02_head
		$this->buildSearchSql($where, $this->pc_03_head, $default, FALSE); // pc_03_head
		$this->buildSearchSql($where, $this->pc_04_head, $default, FALSE); // pc_04_head
		$this->buildSearchSql($where, $this->pc_05_head, $default, FALSE); // pc_05_head
		$this->buildSearchSql($where, $this->pc_06_head, $default, FALSE); // pc_06_head
		$this->buildSearchSql($where, $this->pc_07_head, $default, FALSE); // pc_07_head
		$this->buildSearchSql($where, $this->pc_08_head, $default, FALSE); // pc_08_head
		$this->buildSearchSql($where, $this->pc_09_head, $default, FALSE); // pc_09_head
		$this->buildSearchSql($where, $this->pc_10_head, $default, FALSE); // pc_10_head
		$this->buildSearchSql($where, $this->pc_11_head, $default, FALSE); // pc_11_head
		$this->buildSearchSql($where, $this->pc_12_head, $default, FALSE); // pc_12_head
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->image, $default, FALSE); // image

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->grp->AdvancedSearch->save(); // grp
			$this->product_group->AdvancedSearch->save(); // product_group
			$this->calculation_method->AdvancedSearch->save(); // calculation_method
			$this->shape->AdvancedSearch->save(); // shape
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->cbm->AdvancedSearch->save(); // cbm
			$this->process->AdvancedSearch->save(); // process
			$this->status->AdvancedSearch->save(); // status
			$this->v_00->AdvancedSearch->save(); // v_00
			$this->v_01->AdvancedSearch->save(); // v_01
			$this->v_01_validation->AdvancedSearch->save(); // v_01_validation
			$this->v_02->AdvancedSearch->save(); // v_02
			$this->v_02_validation->AdvancedSearch->save(); // v_02_validation
			$this->v_03->AdvancedSearch->save(); // v_03
			$this->v_03_validation->AdvancedSearch->save(); // v_03_validation
			$this->v_04->AdvancedSearch->save(); // v_04
			$this->v_04_validation->AdvancedSearch->save(); // v_04_validation
			$this->v_05->AdvancedSearch->save(); // v_05
			$this->v_05_validation->AdvancedSearch->save(); // v_05_validation
			$this->v_06->AdvancedSearch->save(); // v_06
			$this->v_06_validation->AdvancedSearch->save(); // v_06_validation
			$this->v_07->AdvancedSearch->save(); // v_07
			$this->v_07_validation->AdvancedSearch->save(); // v_07_validation
			$this->v_08->AdvancedSearch->save(); // v_08
			$this->v_08_validation->AdvancedSearch->save(); // v_08_validation
			$this->v_09->AdvancedSearch->save(); // v_09
			$this->v_09_validation->AdvancedSearch->save(); // v_09_validation
			$this->v_10->AdvancedSearch->save(); // v_10
			$this->v_10_validation->AdvancedSearch->save(); // v_10_validation
			$this->b_01_head->AdvancedSearch->save(); // b_01_head
			$this->b_02_head->AdvancedSearch->save(); // b_02_head
			$this->b_03_head->AdvancedSearch->save(); // b_03_head
			$this->b_04_head->AdvancedSearch->save(); // b_04_head
			$this->b_05_head->AdvancedSearch->save(); // b_05_head
			$this->b_06_head->AdvancedSearch->save(); // b_06_head
			$this->b_07_head->AdvancedSearch->save(); // b_07_head
			$this->b_08_head->AdvancedSearch->save(); // b_08_head
			$this->b_09_head->AdvancedSearch->save(); // b_09_head
			$this->b_10_head->AdvancedSearch->save(); // b_10_head
			$this->b_11_head->AdvancedSearch->save(); // b_11_head
			$this->b_12_head->AdvancedSearch->save(); // b_12_head
			$this->b_13_head->AdvancedSearch->save(); // b_13_head
			$this->b_14_head->AdvancedSearch->save(); // b_14_head
			$this->b_15_head->AdvancedSearch->save(); // b_15_head
			$this->q_sku->AdvancedSearch->save(); // q_sku
			$this->t_01_head->AdvancedSearch->save(); // t_01_head
			$this->t_02_head->AdvancedSearch->save(); // t_02_head
			$this->t_03_head->AdvancedSearch->save(); // t_03_head
			$this->t_04_head->AdvancedSearch->save(); // t_04_head
			$this->t_05_head->AdvancedSearch->save(); // t_05_head
			$this->t_06_head->AdvancedSearch->save(); // t_06_head
			$this->t_07_head->AdvancedSearch->save(); // t_07_head
			$this->t_08_head->AdvancedSearch->save(); // t_08_head
			$this->t_09_head->AdvancedSearch->save(); // t_09_head
			$this->t_10_head->AdvancedSearch->save(); // t_10_head
			$this->t_11_head->AdvancedSearch->save(); // t_11_head
			$this->t_12_head->AdvancedSearch->save(); // t_12_head
			$this->t_13_head->AdvancedSearch->save(); // t_13_head
			$this->t_14_head->AdvancedSearch->save(); // t_14_head
			$this->t_15_head->AdvancedSearch->save(); // t_15_head
			$this->po_01_head->AdvancedSearch->save(); // po_01_head
			$this->po_02_head->AdvancedSearch->save(); // po_02_head
			$this->po_03_head->AdvancedSearch->save(); // po_03_head
			$this->po_04_head->AdvancedSearch->save(); // po_04_head
			$this->po_05_head->AdvancedSearch->save(); // po_05_head
			$this->po_06_head->AdvancedSearch->save(); // po_06_head
			$this->po_07_head->AdvancedSearch->save(); // po_07_head
			$this->po_08_head->AdvancedSearch->save(); // po_08_head
			$this->po_17_head->AdvancedSearch->save(); // po_17_head
			$this->po_18_head->AdvancedSearch->save(); // po_18_head
			$this->po_19_head->AdvancedSearch->save(); // po_19_head
			$this->po_20_head->AdvancedSearch->save(); // po_20_head
			$this->jc_01_head->AdvancedSearch->save(); // jc_01_head
			$this->jc_02_head->AdvancedSearch->save(); // jc_02_head
			$this->jc_03_head->AdvancedSearch->save(); // jc_03_head
			$this->jc_04_head->AdvancedSearch->save(); // jc_04_head
			$this->jc_05_head->AdvancedSearch->save(); // jc_05_head
			$this->jc_06_head->AdvancedSearch->save(); // jc_06_head
			$this->jc_07_head->AdvancedSearch->save(); // jc_07_head
			$this->jc_08_head->AdvancedSearch->save(); // jc_08_head
			$this->jc_09_head->AdvancedSearch->save(); // jc_09_head
			$this->jc_10_head->AdvancedSearch->save(); // jc_10_head
			$this->pc_shape->AdvancedSearch->save(); // pc_shape
			$this->pc_unit->AdvancedSearch->save(); // pc_unit
			$this->pc_w->AdvancedSearch->save(); // pc_w
			$this->pc_l->AdvancedSearch->save(); // pc_l
			$this->pc_h->AdvancedSearch->save(); // pc_h
			$this->pc_partner_size->AdvancedSearch->save(); // pc_partner_size
			$this->pc_sqm->AdvancedSearch->save(); // pc_sqm
			$this->pc_01_head->AdvancedSearch->save(); // pc_01_head
			$this->pc_02_head->AdvancedSearch->save(); // pc_02_head
			$this->pc_03_head->AdvancedSearch->save(); // pc_03_head
			$this->pc_04_head->AdvancedSearch->save(); // pc_04_head
			$this->pc_05_head->AdvancedSearch->save(); // pc_05_head
			$this->pc_06_head->AdvancedSearch->save(); // pc_06_head
			$this->pc_07_head->AdvancedSearch->save(); // pc_07_head
			$this->pc_08_head->AdvancedSearch->save(); // pc_08_head
			$this->pc_09_head->AdvancedSearch->save(); // pc_09_head
			$this->pc_10_head->AdvancedSearch->save(); // pc_10_head
			$this->pc_11_head->AdvancedSearch->save(); // pc_11_head
			$this->pc_12_head->AdvancedSearch->save(); // pc_12_head
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->image->AdvancedSearch->save(); // image
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product_group, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->shape, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sqm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cbm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_00, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_01_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_02_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_03_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_04_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_05, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_05_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_06, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_06_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_07, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_07_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_08, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_08_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_09, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_09_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_10_validation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_01_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_02_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_03_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_04_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_05_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_06_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_07_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_08_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_09_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_10_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_11_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_12_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_13_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_14_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_15_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_01_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_02_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_03_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_04_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_05_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_06_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_07_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_08_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_09_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_10_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_11_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_12_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_13_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_14_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_15_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_01_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_02_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_03_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_04_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_05_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_06_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_07_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_08_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_17_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_18_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_19_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_20_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_01_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_02_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_03_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_04_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_05_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_06_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_07_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_08_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_09_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_10_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_shape, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_unit, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_w, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_l, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_h, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_partner_size, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_sqm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_01_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_02_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_03_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_04_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_05_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_06_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_07_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_08_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_09_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_10_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_11_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pc_12_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->image, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_group->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->calculation_method->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->shape->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_00->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_01_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_02_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_03_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_04_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_05_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_06->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_06_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_07->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_07_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_08->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_08_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_09->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_09_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_10_validation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_01_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_02_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_03_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_04_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_05_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_06_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_07_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_08_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_09_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_10_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_11_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_12_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_13_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_14_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_15_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->q_sku->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_01_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_02_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_03_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_04_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_05_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_06_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_07_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_08_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_09_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_10_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_11_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_12_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_13_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_14_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_15_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_01_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_02_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_03_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_04_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_05_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_06_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_07_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_08_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_17_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_18_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_19_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_20_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_01_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_02_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_03_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_04_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_05_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_06_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_07_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_08_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_09_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_10_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_shape->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_unit->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_w->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_l->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_h->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_partner_size->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_01_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_02_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_03_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_04_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_05_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_06_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_07_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_08_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_09_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_10_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_11_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pc_12_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->image->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->product_group->AdvancedSearch->unsetSession();
		$this->calculation_method->AdvancedSearch->unsetSession();
		$this->shape->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->cbm->AdvancedSearch->unsetSession();
		$this->process->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->v_00->AdvancedSearch->unsetSession();
		$this->v_01->AdvancedSearch->unsetSession();
		$this->v_01_validation->AdvancedSearch->unsetSession();
		$this->v_02->AdvancedSearch->unsetSession();
		$this->v_02_validation->AdvancedSearch->unsetSession();
		$this->v_03->AdvancedSearch->unsetSession();
		$this->v_03_validation->AdvancedSearch->unsetSession();
		$this->v_04->AdvancedSearch->unsetSession();
		$this->v_04_validation->AdvancedSearch->unsetSession();
		$this->v_05->AdvancedSearch->unsetSession();
		$this->v_05_validation->AdvancedSearch->unsetSession();
		$this->v_06->AdvancedSearch->unsetSession();
		$this->v_06_validation->AdvancedSearch->unsetSession();
		$this->v_07->AdvancedSearch->unsetSession();
		$this->v_07_validation->AdvancedSearch->unsetSession();
		$this->v_08->AdvancedSearch->unsetSession();
		$this->v_08_validation->AdvancedSearch->unsetSession();
		$this->v_09->AdvancedSearch->unsetSession();
		$this->v_09_validation->AdvancedSearch->unsetSession();
		$this->v_10->AdvancedSearch->unsetSession();
		$this->v_10_validation->AdvancedSearch->unsetSession();
		$this->b_01_head->AdvancedSearch->unsetSession();
		$this->b_02_head->AdvancedSearch->unsetSession();
		$this->b_03_head->AdvancedSearch->unsetSession();
		$this->b_04_head->AdvancedSearch->unsetSession();
		$this->b_05_head->AdvancedSearch->unsetSession();
		$this->b_06_head->AdvancedSearch->unsetSession();
		$this->b_07_head->AdvancedSearch->unsetSession();
		$this->b_08_head->AdvancedSearch->unsetSession();
		$this->b_09_head->AdvancedSearch->unsetSession();
		$this->b_10_head->AdvancedSearch->unsetSession();
		$this->b_11_head->AdvancedSearch->unsetSession();
		$this->b_12_head->AdvancedSearch->unsetSession();
		$this->b_13_head->AdvancedSearch->unsetSession();
		$this->b_14_head->AdvancedSearch->unsetSession();
		$this->b_15_head->AdvancedSearch->unsetSession();
		$this->q_sku->AdvancedSearch->unsetSession();
		$this->t_01_head->AdvancedSearch->unsetSession();
		$this->t_02_head->AdvancedSearch->unsetSession();
		$this->t_03_head->AdvancedSearch->unsetSession();
		$this->t_04_head->AdvancedSearch->unsetSession();
		$this->t_05_head->AdvancedSearch->unsetSession();
		$this->t_06_head->AdvancedSearch->unsetSession();
		$this->t_07_head->AdvancedSearch->unsetSession();
		$this->t_08_head->AdvancedSearch->unsetSession();
		$this->t_09_head->AdvancedSearch->unsetSession();
		$this->t_10_head->AdvancedSearch->unsetSession();
		$this->t_11_head->AdvancedSearch->unsetSession();
		$this->t_12_head->AdvancedSearch->unsetSession();
		$this->t_13_head->AdvancedSearch->unsetSession();
		$this->t_14_head->AdvancedSearch->unsetSession();
		$this->t_15_head->AdvancedSearch->unsetSession();
		$this->po_01_head->AdvancedSearch->unsetSession();
		$this->po_02_head->AdvancedSearch->unsetSession();
		$this->po_03_head->AdvancedSearch->unsetSession();
		$this->po_04_head->AdvancedSearch->unsetSession();
		$this->po_05_head->AdvancedSearch->unsetSession();
		$this->po_06_head->AdvancedSearch->unsetSession();
		$this->po_07_head->AdvancedSearch->unsetSession();
		$this->po_08_head->AdvancedSearch->unsetSession();
		$this->po_17_head->AdvancedSearch->unsetSession();
		$this->po_18_head->AdvancedSearch->unsetSession();
		$this->po_19_head->AdvancedSearch->unsetSession();
		$this->po_20_head->AdvancedSearch->unsetSession();
		$this->jc_01_head->AdvancedSearch->unsetSession();
		$this->jc_02_head->AdvancedSearch->unsetSession();
		$this->jc_03_head->AdvancedSearch->unsetSession();
		$this->jc_04_head->AdvancedSearch->unsetSession();
		$this->jc_05_head->AdvancedSearch->unsetSession();
		$this->jc_06_head->AdvancedSearch->unsetSession();
		$this->jc_07_head->AdvancedSearch->unsetSession();
		$this->jc_08_head->AdvancedSearch->unsetSession();
		$this->jc_09_head->AdvancedSearch->unsetSession();
		$this->jc_10_head->AdvancedSearch->unsetSession();
		$this->pc_shape->AdvancedSearch->unsetSession();
		$this->pc_unit->AdvancedSearch->unsetSession();
		$this->pc_w->AdvancedSearch->unsetSession();
		$this->pc_l->AdvancedSearch->unsetSession();
		$this->pc_h->AdvancedSearch->unsetSession();
		$this->pc_partner_size->AdvancedSearch->unsetSession();
		$this->pc_sqm->AdvancedSearch->unsetSession();
		$this->pc_01_head->AdvancedSearch->unsetSession();
		$this->pc_02_head->AdvancedSearch->unsetSession();
		$this->pc_03_head->AdvancedSearch->unsetSession();
		$this->pc_04_head->AdvancedSearch->unsetSession();
		$this->pc_05_head->AdvancedSearch->unsetSession();
		$this->pc_06_head->AdvancedSearch->unsetSession();
		$this->pc_07_head->AdvancedSearch->unsetSession();
		$this->pc_08_head->AdvancedSearch->unsetSession();
		$this->pc_09_head->AdvancedSearch->unsetSession();
		$this->pc_10_head->AdvancedSearch->unsetSession();
		$this->pc_11_head->AdvancedSearch->unsetSession();
		$this->pc_12_head->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->image->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->product_group->AdvancedSearch->load();
		$this->calculation_method->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->v_00->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_01_validation->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_02_validation->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_03_validation->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_04_validation->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->v_05_validation->AdvancedSearch->load();
		$this->v_06->AdvancedSearch->load();
		$this->v_06_validation->AdvancedSearch->load();
		$this->v_07->AdvancedSearch->load();
		$this->v_07_validation->AdvancedSearch->load();
		$this->v_08->AdvancedSearch->load();
		$this->v_08_validation->AdvancedSearch->load();
		$this->v_09->AdvancedSearch->load();
		$this->v_09_validation->AdvancedSearch->load();
		$this->v_10->AdvancedSearch->load();
		$this->v_10_validation->AdvancedSearch->load();
		$this->b_01_head->AdvancedSearch->load();
		$this->b_02_head->AdvancedSearch->load();
		$this->b_03_head->AdvancedSearch->load();
		$this->b_04_head->AdvancedSearch->load();
		$this->b_05_head->AdvancedSearch->load();
		$this->b_06_head->AdvancedSearch->load();
		$this->b_07_head->AdvancedSearch->load();
		$this->b_08_head->AdvancedSearch->load();
		$this->b_09_head->AdvancedSearch->load();
		$this->b_10_head->AdvancedSearch->load();
		$this->b_11_head->AdvancedSearch->load();
		$this->b_12_head->AdvancedSearch->load();
		$this->b_13_head->AdvancedSearch->load();
		$this->b_14_head->AdvancedSearch->load();
		$this->b_15_head->AdvancedSearch->load();
		$this->q_sku->AdvancedSearch->load();
		$this->t_01_head->AdvancedSearch->load();
		$this->t_02_head->AdvancedSearch->load();
		$this->t_03_head->AdvancedSearch->load();
		$this->t_04_head->AdvancedSearch->load();
		$this->t_05_head->AdvancedSearch->load();
		$this->t_06_head->AdvancedSearch->load();
		$this->t_07_head->AdvancedSearch->load();
		$this->t_08_head->AdvancedSearch->load();
		$this->t_09_head->AdvancedSearch->load();
		$this->t_10_head->AdvancedSearch->load();
		$this->t_11_head->AdvancedSearch->load();
		$this->t_12_head->AdvancedSearch->load();
		$this->t_13_head->AdvancedSearch->load();
		$this->t_14_head->AdvancedSearch->load();
		$this->t_15_head->AdvancedSearch->load();
		$this->po_01_head->AdvancedSearch->load();
		$this->po_02_head->AdvancedSearch->load();
		$this->po_03_head->AdvancedSearch->load();
		$this->po_04_head->AdvancedSearch->load();
		$this->po_05_head->AdvancedSearch->load();
		$this->po_06_head->AdvancedSearch->load();
		$this->po_07_head->AdvancedSearch->load();
		$this->po_08_head->AdvancedSearch->load();
		$this->po_17_head->AdvancedSearch->load();
		$this->po_18_head->AdvancedSearch->load();
		$this->po_19_head->AdvancedSearch->load();
		$this->po_20_head->AdvancedSearch->load();
		$this->jc_01_head->AdvancedSearch->load();
		$this->jc_02_head->AdvancedSearch->load();
		$this->jc_03_head->AdvancedSearch->load();
		$this->jc_04_head->AdvancedSearch->load();
		$this->jc_05_head->AdvancedSearch->load();
		$this->jc_06_head->AdvancedSearch->load();
		$this->jc_07_head->AdvancedSearch->load();
		$this->jc_08_head->AdvancedSearch->load();
		$this->jc_09_head->AdvancedSearch->load();
		$this->jc_10_head->AdvancedSearch->load();
		$this->pc_shape->AdvancedSearch->load();
		$this->pc_unit->AdvancedSearch->load();
		$this->pc_w->AdvancedSearch->load();
		$this->pc_l->AdvancedSearch->load();
		$this->pc_h->AdvancedSearch->load();
		$this->pc_partner_size->AdvancedSearch->load();
		$this->pc_sqm->AdvancedSearch->load();
		$this->pc_01_head->AdvancedSearch->load();
		$this->pc_02_head->AdvancedSearch->load();
		$this->pc_03_head->AdvancedSearch->load();
		$this->pc_04_head->AdvancedSearch->load();
		$this->pc_05_head->AdvancedSearch->load();
		$this->pc_06_head->AdvancedSearch->load();
		$this->pc_07_head->AdvancedSearch->load();
		$this->pc_08_head->AdvancedSearch->load();
		$this->pc_09_head->AdvancedSearch->load();
		$this->pc_10_head->AdvancedSearch->load();
		$this->pc_11_head->AdvancedSearch->load();
		$this->pc_12_head->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->grp, $ctrl); // grp
			$this->updateSort($this->product_group, $ctrl); // product_group
			$this->updateSort($this->calculation_method, $ctrl); // calculation_method
			$this->updateSort($this->shape, $ctrl); // shape
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->cbm, $ctrl); // cbm
			$this->updateSort($this->process, $ctrl); // process
			$this->updateSort($this->status, $ctrl); // status
			$this->updateSort($this->v_00, $ctrl); // v_00
			$this->updateSort($this->v_01, $ctrl); // v_01
			$this->updateSort($this->v_01_validation, $ctrl); // v_01_validation
			$this->updateSort($this->v_02, $ctrl); // v_02
			$this->updateSort($this->v_02_validation, $ctrl); // v_02_validation
			$this->updateSort($this->v_03, $ctrl); // v_03
			$this->updateSort($this->v_03_validation, $ctrl); // v_03_validation
			$this->updateSort($this->v_04, $ctrl); // v_04
			$this->updateSort($this->v_04_validation, $ctrl); // v_04_validation
			$this->updateSort($this->v_05, $ctrl); // v_05
			$this->updateSort($this->v_05_validation, $ctrl); // v_05_validation
			$this->updateSort($this->v_06, $ctrl); // v_06
			$this->updateSort($this->v_06_validation, $ctrl); // v_06_validation
			$this->updateSort($this->v_07, $ctrl); // v_07
			$this->updateSort($this->v_07_validation, $ctrl); // v_07_validation
			$this->updateSort($this->v_08, $ctrl); // v_08
			$this->updateSort($this->v_08_validation, $ctrl); // v_08_validation
			$this->updateSort($this->v_09, $ctrl); // v_09
			$this->updateSort($this->v_09_validation, $ctrl); // v_09_validation
			$this->updateSort($this->v_10, $ctrl); // v_10
			$this->updateSort($this->v_10_validation, $ctrl); // v_10_validation
			$this->updateSort($this->b_01_head, $ctrl); // b_01_head
			$this->updateSort($this->b_02_head, $ctrl); // b_02_head
			$this->updateSort($this->b_03_head, $ctrl); // b_03_head
			$this->updateSort($this->b_04_head, $ctrl); // b_04_head
			$this->updateSort($this->b_05_head, $ctrl); // b_05_head
			$this->updateSort($this->b_06_head, $ctrl); // b_06_head
			$this->updateSort($this->b_07_head, $ctrl); // b_07_head
			$this->updateSort($this->b_08_head, $ctrl); // b_08_head
			$this->updateSort($this->b_09_head, $ctrl); // b_09_head
			$this->updateSort($this->b_10_head, $ctrl); // b_10_head
			$this->updateSort($this->b_11_head, $ctrl); // b_11_head
			$this->updateSort($this->b_12_head, $ctrl); // b_12_head
			$this->updateSort($this->b_13_head, $ctrl); // b_13_head
			$this->updateSort($this->b_14_head, $ctrl); // b_14_head
			$this->updateSort($this->b_15_head, $ctrl); // b_15_head
			$this->updateSort($this->q_sku, $ctrl); // q_sku
			$this->updateSort($this->t_01_head, $ctrl); // t_01_head
			$this->updateSort($this->t_02_head, $ctrl); // t_02_head
			$this->updateSort($this->t_03_head, $ctrl); // t_03_head
			$this->updateSort($this->t_04_head, $ctrl); // t_04_head
			$this->updateSort($this->t_05_head, $ctrl); // t_05_head
			$this->updateSort($this->t_06_head, $ctrl); // t_06_head
			$this->updateSort($this->t_07_head, $ctrl); // t_07_head
			$this->updateSort($this->t_08_head, $ctrl); // t_08_head
			$this->updateSort($this->t_09_head, $ctrl); // t_09_head
			$this->updateSort($this->t_10_head, $ctrl); // t_10_head
			$this->updateSort($this->t_11_head, $ctrl); // t_11_head
			$this->updateSort($this->t_12_head, $ctrl); // t_12_head
			$this->updateSort($this->t_13_head, $ctrl); // t_13_head
			$this->updateSort($this->t_14_head, $ctrl); // t_14_head
			$this->updateSort($this->t_15_head, $ctrl); // t_15_head
			$this->updateSort($this->po_01_head, $ctrl); // po_01_head
			$this->updateSort($this->po_02_head, $ctrl); // po_02_head
			$this->updateSort($this->po_03_head, $ctrl); // po_03_head
			$this->updateSort($this->po_04_head, $ctrl); // po_04_head
			$this->updateSort($this->po_05_head, $ctrl); // po_05_head
			$this->updateSort($this->po_06_head, $ctrl); // po_06_head
			$this->updateSort($this->po_07_head, $ctrl); // po_07_head
			$this->updateSort($this->po_08_head, $ctrl); // po_08_head
			$this->updateSort($this->po_17_head, $ctrl); // po_17_head
			$this->updateSort($this->po_18_head, $ctrl); // po_18_head
			$this->updateSort($this->po_19_head, $ctrl); // po_19_head
			$this->updateSort($this->po_20_head, $ctrl); // po_20_head
			$this->updateSort($this->jc_01_head, $ctrl); // jc_01_head
			$this->updateSort($this->jc_02_head, $ctrl); // jc_02_head
			$this->updateSort($this->jc_03_head, $ctrl); // jc_03_head
			$this->updateSort($this->jc_04_head, $ctrl); // jc_04_head
			$this->updateSort($this->jc_05_head, $ctrl); // jc_05_head
			$this->updateSort($this->jc_06_head, $ctrl); // jc_06_head
			$this->updateSort($this->jc_07_head, $ctrl); // jc_07_head
			$this->updateSort($this->jc_08_head, $ctrl); // jc_08_head
			$this->updateSort($this->jc_09_head, $ctrl); // jc_09_head
			$this->updateSort($this->jc_10_head, $ctrl); // jc_10_head
			$this->updateSort($this->pc_shape, $ctrl); // pc_shape
			$this->updateSort($this->pc_unit, $ctrl); // pc_unit
			$this->updateSort($this->pc_w, $ctrl); // pc_w
			$this->updateSort($this->pc_l, $ctrl); // pc_l
			$this->updateSort($this->pc_h, $ctrl); // pc_h
			$this->updateSort($this->pc_partner_size, $ctrl); // pc_partner_size
			$this->updateSort($this->pc_sqm, $ctrl); // pc_sqm
			$this->updateSort($this->pc_01_head, $ctrl); // pc_01_head
			$this->updateSort($this->pc_02_head, $ctrl); // pc_02_head
			$this->updateSort($this->pc_03_head, $ctrl); // pc_03_head
			$this->updateSort($this->pc_04_head, $ctrl); // pc_04_head
			$this->updateSort($this->pc_05_head, $ctrl); // pc_05_head
			$this->updateSort($this->pc_06_head, $ctrl); // pc_06_head
			$this->updateSort($this->pc_07_head, $ctrl); // pc_07_head
			$this->updateSort($this->pc_08_head, $ctrl); // pc_08_head
			$this->updateSort($this->pc_09_head, $ctrl); // pc_09_head
			$this->updateSort($this->pc_10_head, $ctrl); // pc_10_head
			$this->updateSort($this->pc_11_head, $ctrl); // pc_11_head
			$this->updateSort($this->pc_12_head, $ctrl); // pc_12_head
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->image, $ctrl); // image
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("ASC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->grp->setSort("");
				$this->product_group->setSort("");
				$this->calculation_method->setSort("");
				$this->shape->setSort("");
				$this->sqm->setSort("");
				$this->cbm->setSort("");
				$this->process->setSort("");
				$this->status->setSort("");
				$this->v_00->setSort("");
				$this->v_01->setSort("");
				$this->v_01_validation->setSort("");
				$this->v_02->setSort("");
				$this->v_02_validation->setSort("");
				$this->v_03->setSort("");
				$this->v_03_validation->setSort("");
				$this->v_04->setSort("");
				$this->v_04_validation->setSort("");
				$this->v_05->setSort("");
				$this->v_05_validation->setSort("");
				$this->v_06->setSort("");
				$this->v_06_validation->setSort("");
				$this->v_07->setSort("");
				$this->v_07_validation->setSort("");
				$this->v_08->setSort("");
				$this->v_08_validation->setSort("");
				$this->v_09->setSort("");
				$this->v_09_validation->setSort("");
				$this->v_10->setSort("");
				$this->v_10_validation->setSort("");
				$this->b_01_head->setSort("");
				$this->b_02_head->setSort("");
				$this->b_03_head->setSort("");
				$this->b_04_head->setSort("");
				$this->b_05_head->setSort("");
				$this->b_06_head->setSort("");
				$this->b_07_head->setSort("");
				$this->b_08_head->setSort("");
				$this->b_09_head->setSort("");
				$this->b_10_head->setSort("");
				$this->b_11_head->setSort("");
				$this->b_12_head->setSort("");
				$this->b_13_head->setSort("");
				$this->b_14_head->setSort("");
				$this->b_15_head->setSort("");
				$this->q_sku->setSort("");
				$this->t_01_head->setSort("");
				$this->t_02_head->setSort("");
				$this->t_03_head->setSort("");
				$this->t_04_head->setSort("");
				$this->t_05_head->setSort("");
				$this->t_06_head->setSort("");
				$this->t_07_head->setSort("");
				$this->t_08_head->setSort("");
				$this->t_09_head->setSort("");
				$this->t_10_head->setSort("");
				$this->t_11_head->setSort("");
				$this->t_12_head->setSort("");
				$this->t_13_head->setSort("");
				$this->t_14_head->setSort("");
				$this->t_15_head->setSort("");
				$this->po_01_head->setSort("");
				$this->po_02_head->setSort("");
				$this->po_03_head->setSort("");
				$this->po_04_head->setSort("");
				$this->po_05_head->setSort("");
				$this->po_06_head->setSort("");
				$this->po_07_head->setSort("");
				$this->po_08_head->setSort("");
				$this->po_17_head->setSort("");
				$this->po_18_head->setSort("");
				$this->po_19_head->setSort("");
				$this->po_20_head->setSort("");
				$this->jc_01_head->setSort("");
				$this->jc_02_head->setSort("");
				$this->jc_03_head->setSort("");
				$this->jc_04_head->setSort("");
				$this->jc_05_head->setSort("");
				$this->jc_06_head->setSort("");
				$this->jc_07_head->setSort("");
				$this->jc_08_head->setSort("");
				$this->jc_09_head->setSort("");
				$this->jc_10_head->setSort("");
				$this->pc_shape->setSort("");
				$this->pc_unit->setSort("");
				$this->pc_w->setSort("");
				$this->pc_l->setSort("");
				$this->pc_h->setSort("");
				$this->pc_partner_size->setSort("");
				$this->pc_sqm->setSort("");
				$this->pc_01_head->setSort("");
				$this->pc_02_head->setSort("");
				$this->pc_03_head->setSort("");
				$this->pc_04_head->setSort("");
				$this->pc_05_head->setSort("");
				$this->pc_06_head->setSort("");
				$this->pc_07_head->setSort("");
				$this->pc_08_head->setSort("");
				$this->pc_09_head->setSort("");
				$this->pc_10_head->setSort("");
				$this->pc_11_head->setSort("");
				$this->pc_12_head->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->image->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fproduct_grouplistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fproduct_grouplistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fproduct_grouplist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fproduct_grouplistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"product_groupsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"product_group\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'product_groupsrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fproduct_grouplistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// product_group
		if (!$this->isAddOrEdit())
			$this->product_group->AdvancedSearch->setSearchValue(Get("x_product_group", Get("product_group", "")));
		if ($this->product_group->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_group->AdvancedSearch->setSearchOperator(Get("z_product_group", ""));

		// calculation_method
		if (!$this->isAddOrEdit())
			$this->calculation_method->AdvancedSearch->setSearchValue(Get("x_calculation_method", Get("calculation_method", "")));
		if ($this->calculation_method->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->calculation_method->AdvancedSearch->setSearchOperator(Get("z_calculation_method", ""));

		// shape
		if (!$this->isAddOrEdit())
			$this->shape->AdvancedSearch->setSearchValue(Get("x_shape", Get("shape", "")));
		if ($this->shape->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->shape->AdvancedSearch->setSearchOperator(Get("z_shape", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue(Get("x_cbm", Get("cbm", "")));
		if ($this->cbm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cbm->AdvancedSearch->setSearchOperator(Get("z_cbm", ""));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue(Get("x_process", Get("process", "")));
		if ($this->process->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process->AdvancedSearch->setSearchOperator(Get("z_process", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// v_00
		if (!$this->isAddOrEdit())
			$this->v_00->AdvancedSearch->setSearchValue(Get("x_v_00", Get("v_00", "")));
		if ($this->v_00->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_00->AdvancedSearch->setSearchOperator(Get("z_v_00", ""));

		// v_01
		if (!$this->isAddOrEdit())
			$this->v_01->AdvancedSearch->setSearchValue(Get("x_v_01", Get("v_01", "")));
		if ($this->v_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_01->AdvancedSearch->setSearchOperator(Get("z_v_01", ""));

		// v_01_validation
		if (!$this->isAddOrEdit())
			$this->v_01_validation->AdvancedSearch->setSearchValue(Get("x_v_01_validation", Get("v_01_validation", "")));
		if ($this->v_01_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_01_validation->AdvancedSearch->setSearchOperator(Get("z_v_01_validation", ""));

		// v_02
		if (!$this->isAddOrEdit())
			$this->v_02->AdvancedSearch->setSearchValue(Get("x_v_02", Get("v_02", "")));
		if ($this->v_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_02->AdvancedSearch->setSearchOperator(Get("z_v_02", ""));

		// v_02_validation
		if (!$this->isAddOrEdit())
			$this->v_02_validation->AdvancedSearch->setSearchValue(Get("x_v_02_validation", Get("v_02_validation", "")));
		if ($this->v_02_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_02_validation->AdvancedSearch->setSearchOperator(Get("z_v_02_validation", ""));

		// v_03
		if (!$this->isAddOrEdit())
			$this->v_03->AdvancedSearch->setSearchValue(Get("x_v_03", Get("v_03", "")));
		if ($this->v_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_03->AdvancedSearch->setSearchOperator(Get("z_v_03", ""));

		// v_03_validation
		if (!$this->isAddOrEdit())
			$this->v_03_validation->AdvancedSearch->setSearchValue(Get("x_v_03_validation", Get("v_03_validation", "")));
		if ($this->v_03_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_03_validation->AdvancedSearch->setSearchOperator(Get("z_v_03_validation", ""));

		// v_04
		if (!$this->isAddOrEdit())
			$this->v_04->AdvancedSearch->setSearchValue(Get("x_v_04", Get("v_04", "")));
		if ($this->v_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_04->AdvancedSearch->setSearchOperator(Get("z_v_04", ""));

		// v_04_validation
		if (!$this->isAddOrEdit())
			$this->v_04_validation->AdvancedSearch->setSearchValue(Get("x_v_04_validation", Get("v_04_validation", "")));
		if ($this->v_04_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_04_validation->AdvancedSearch->setSearchOperator(Get("z_v_04_validation", ""));

		// v_05
		if (!$this->isAddOrEdit())
			$this->v_05->AdvancedSearch->setSearchValue(Get("x_v_05", Get("v_05", "")));
		if ($this->v_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_05->AdvancedSearch->setSearchOperator(Get("z_v_05", ""));

		// v_05_validation
		if (!$this->isAddOrEdit())
			$this->v_05_validation->AdvancedSearch->setSearchValue(Get("x_v_05_validation", Get("v_05_validation", "")));
		if ($this->v_05_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_05_validation->AdvancedSearch->setSearchOperator(Get("z_v_05_validation", ""));

		// v_06
		if (!$this->isAddOrEdit())
			$this->v_06->AdvancedSearch->setSearchValue(Get("x_v_06", Get("v_06", "")));
		if ($this->v_06->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_06->AdvancedSearch->setSearchOperator(Get("z_v_06", ""));

		// v_06_validation
		if (!$this->isAddOrEdit())
			$this->v_06_validation->AdvancedSearch->setSearchValue(Get("x_v_06_validation", Get("v_06_validation", "")));
		if ($this->v_06_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_06_validation->AdvancedSearch->setSearchOperator(Get("z_v_06_validation", ""));

		// v_07
		if (!$this->isAddOrEdit())
			$this->v_07->AdvancedSearch->setSearchValue(Get("x_v_07", Get("v_07", "")));
		if ($this->v_07->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_07->AdvancedSearch->setSearchOperator(Get("z_v_07", ""));

		// v_07_validation
		if (!$this->isAddOrEdit())
			$this->v_07_validation->AdvancedSearch->setSearchValue(Get("x_v_07_validation", Get("v_07_validation", "")));
		if ($this->v_07_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_07_validation->AdvancedSearch->setSearchOperator(Get("z_v_07_validation", ""));

		// v_08
		if (!$this->isAddOrEdit())
			$this->v_08->AdvancedSearch->setSearchValue(Get("x_v_08", Get("v_08", "")));
		if ($this->v_08->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_08->AdvancedSearch->setSearchOperator(Get("z_v_08", ""));

		// v_08_validation
		if (!$this->isAddOrEdit())
			$this->v_08_validation->AdvancedSearch->setSearchValue(Get("x_v_08_validation", Get("v_08_validation", "")));
		if ($this->v_08_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_08_validation->AdvancedSearch->setSearchOperator(Get("z_v_08_validation", ""));

		// v_09
		if (!$this->isAddOrEdit())
			$this->v_09->AdvancedSearch->setSearchValue(Get("x_v_09", Get("v_09", "")));
		if ($this->v_09->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_09->AdvancedSearch->setSearchOperator(Get("z_v_09", ""));

		// v_09_validation
		if (!$this->isAddOrEdit())
			$this->v_09_validation->AdvancedSearch->setSearchValue(Get("x_v_09_validation", Get("v_09_validation", "")));
		if ($this->v_09_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_09_validation->AdvancedSearch->setSearchOperator(Get("z_v_09_validation", ""));

		// v_10
		if (!$this->isAddOrEdit())
			$this->v_10->AdvancedSearch->setSearchValue(Get("x_v_10", Get("v_10", "")));
		if ($this->v_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_10->AdvancedSearch->setSearchOperator(Get("z_v_10", ""));

		// v_10_validation
		if (!$this->isAddOrEdit())
			$this->v_10_validation->AdvancedSearch->setSearchValue(Get("x_v_10_validation", Get("v_10_validation", "")));
		if ($this->v_10_validation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_10_validation->AdvancedSearch->setSearchOperator(Get("z_v_10_validation", ""));

		// b_01_head
		if (!$this->isAddOrEdit())
			$this->b_01_head->AdvancedSearch->setSearchValue(Get("x_b_01_head", Get("b_01_head", "")));
		if ($this->b_01_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_01_head->AdvancedSearch->setSearchOperator(Get("z_b_01_head", ""));

		// b_02_head
		if (!$this->isAddOrEdit())
			$this->b_02_head->AdvancedSearch->setSearchValue(Get("x_b_02_head", Get("b_02_head", "")));
		if ($this->b_02_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_02_head->AdvancedSearch->setSearchOperator(Get("z_b_02_head", ""));

		// b_03_head
		if (!$this->isAddOrEdit())
			$this->b_03_head->AdvancedSearch->setSearchValue(Get("x_b_03_head", Get("b_03_head", "")));
		if ($this->b_03_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_03_head->AdvancedSearch->setSearchOperator(Get("z_b_03_head", ""));

		// b_04_head
		if (!$this->isAddOrEdit())
			$this->b_04_head->AdvancedSearch->setSearchValue(Get("x_b_04_head", Get("b_04_head", "")));
		if ($this->b_04_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_04_head->AdvancedSearch->setSearchOperator(Get("z_b_04_head", ""));

		// b_05_head
		if (!$this->isAddOrEdit())
			$this->b_05_head->AdvancedSearch->setSearchValue(Get("x_b_05_head", Get("b_05_head", "")));
		if ($this->b_05_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_05_head->AdvancedSearch->setSearchOperator(Get("z_b_05_head", ""));

		// b_06_head
		if (!$this->isAddOrEdit())
			$this->b_06_head->AdvancedSearch->setSearchValue(Get("x_b_06_head", Get("b_06_head", "")));
		if ($this->b_06_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_06_head->AdvancedSearch->setSearchOperator(Get("z_b_06_head", ""));

		// b_07_head
		if (!$this->isAddOrEdit())
			$this->b_07_head->AdvancedSearch->setSearchValue(Get("x_b_07_head", Get("b_07_head", "")));
		if ($this->b_07_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_07_head->AdvancedSearch->setSearchOperator(Get("z_b_07_head", ""));

		// b_08_head
		if (!$this->isAddOrEdit())
			$this->b_08_head->AdvancedSearch->setSearchValue(Get("x_b_08_head", Get("b_08_head", "")));
		if ($this->b_08_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_08_head->AdvancedSearch->setSearchOperator(Get("z_b_08_head", ""));

		// b_09_head
		if (!$this->isAddOrEdit())
			$this->b_09_head->AdvancedSearch->setSearchValue(Get("x_b_09_head", Get("b_09_head", "")));
		if ($this->b_09_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_09_head->AdvancedSearch->setSearchOperator(Get("z_b_09_head", ""));

		// b_10_head
		if (!$this->isAddOrEdit())
			$this->b_10_head->AdvancedSearch->setSearchValue(Get("x_b_10_head", Get("b_10_head", "")));
		if ($this->b_10_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_10_head->AdvancedSearch->setSearchOperator(Get("z_b_10_head", ""));

		// b_11_head
		if (!$this->isAddOrEdit())
			$this->b_11_head->AdvancedSearch->setSearchValue(Get("x_b_11_head", Get("b_11_head", "")));
		if ($this->b_11_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_11_head->AdvancedSearch->setSearchOperator(Get("z_b_11_head", ""));

		// b_12_head
		if (!$this->isAddOrEdit())
			$this->b_12_head->AdvancedSearch->setSearchValue(Get("x_b_12_head", Get("b_12_head", "")));
		if ($this->b_12_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_12_head->AdvancedSearch->setSearchOperator(Get("z_b_12_head", ""));

		// b_13_head
		if (!$this->isAddOrEdit())
			$this->b_13_head->AdvancedSearch->setSearchValue(Get("x_b_13_head", Get("b_13_head", "")));
		if ($this->b_13_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_13_head->AdvancedSearch->setSearchOperator(Get("z_b_13_head", ""));

		// b_14_head
		if (!$this->isAddOrEdit())
			$this->b_14_head->AdvancedSearch->setSearchValue(Get("x_b_14_head", Get("b_14_head", "")));
		if ($this->b_14_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_14_head->AdvancedSearch->setSearchOperator(Get("z_b_14_head", ""));

		// b_15_head
		if (!$this->isAddOrEdit())
			$this->b_15_head->AdvancedSearch->setSearchValue(Get("x_b_15_head", Get("b_15_head", "")));
		if ($this->b_15_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_15_head->AdvancedSearch->setSearchOperator(Get("z_b_15_head", ""));

		// q_sku
		if (!$this->isAddOrEdit())
			$this->q_sku->AdvancedSearch->setSearchValue(Get("x_q_sku", Get("q_sku", "")));
		if ($this->q_sku->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->q_sku->AdvancedSearch->setSearchOperator(Get("z_q_sku", ""));

		// t_01_head
		if (!$this->isAddOrEdit())
			$this->t_01_head->AdvancedSearch->setSearchValue(Get("x_t_01_head", Get("t_01_head", "")));
		if ($this->t_01_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_01_head->AdvancedSearch->setSearchOperator(Get("z_t_01_head", ""));

		// t_02_head
		if (!$this->isAddOrEdit())
			$this->t_02_head->AdvancedSearch->setSearchValue(Get("x_t_02_head", Get("t_02_head", "")));
		if ($this->t_02_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_02_head->AdvancedSearch->setSearchOperator(Get("z_t_02_head", ""));

		// t_03_head
		if (!$this->isAddOrEdit())
			$this->t_03_head->AdvancedSearch->setSearchValue(Get("x_t_03_head", Get("t_03_head", "")));
		if ($this->t_03_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_03_head->AdvancedSearch->setSearchOperator(Get("z_t_03_head", ""));

		// t_04_head
		if (!$this->isAddOrEdit())
			$this->t_04_head->AdvancedSearch->setSearchValue(Get("x_t_04_head", Get("t_04_head", "")));
		if ($this->t_04_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_04_head->AdvancedSearch->setSearchOperator(Get("z_t_04_head", ""));

		// t_05_head
		if (!$this->isAddOrEdit())
			$this->t_05_head->AdvancedSearch->setSearchValue(Get("x_t_05_head", Get("t_05_head", "")));
		if ($this->t_05_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_05_head->AdvancedSearch->setSearchOperator(Get("z_t_05_head", ""));

		// t_06_head
		if (!$this->isAddOrEdit())
			$this->t_06_head->AdvancedSearch->setSearchValue(Get("x_t_06_head", Get("t_06_head", "")));
		if ($this->t_06_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_06_head->AdvancedSearch->setSearchOperator(Get("z_t_06_head", ""));

		// t_07_head
		if (!$this->isAddOrEdit())
			$this->t_07_head->AdvancedSearch->setSearchValue(Get("x_t_07_head", Get("t_07_head", "")));
		if ($this->t_07_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_07_head->AdvancedSearch->setSearchOperator(Get("z_t_07_head", ""));

		// t_08_head
		if (!$this->isAddOrEdit())
			$this->t_08_head->AdvancedSearch->setSearchValue(Get("x_t_08_head", Get("t_08_head", "")));
		if ($this->t_08_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_08_head->AdvancedSearch->setSearchOperator(Get("z_t_08_head", ""));

		// t_09_head
		if (!$this->isAddOrEdit())
			$this->t_09_head->AdvancedSearch->setSearchValue(Get("x_t_09_head", Get("t_09_head", "")));
		if ($this->t_09_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_09_head->AdvancedSearch->setSearchOperator(Get("z_t_09_head", ""));

		// t_10_head
		if (!$this->isAddOrEdit())
			$this->t_10_head->AdvancedSearch->setSearchValue(Get("x_t_10_head", Get("t_10_head", "")));
		if ($this->t_10_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_10_head->AdvancedSearch->setSearchOperator(Get("z_t_10_head", ""));

		// t_11_head
		if (!$this->isAddOrEdit())
			$this->t_11_head->AdvancedSearch->setSearchValue(Get("x_t_11_head", Get("t_11_head", "")));
		if ($this->t_11_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_11_head->AdvancedSearch->setSearchOperator(Get("z_t_11_head", ""));

		// t_12_head
		if (!$this->isAddOrEdit())
			$this->t_12_head->AdvancedSearch->setSearchValue(Get("x_t_12_head", Get("t_12_head", "")));
		if ($this->t_12_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_12_head->AdvancedSearch->setSearchOperator(Get("z_t_12_head", ""));

		// t_13_head
		if (!$this->isAddOrEdit())
			$this->t_13_head->AdvancedSearch->setSearchValue(Get("x_t_13_head", Get("t_13_head", "")));
		if ($this->t_13_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_13_head->AdvancedSearch->setSearchOperator(Get("z_t_13_head", ""));

		// t_14_head
		if (!$this->isAddOrEdit())
			$this->t_14_head->AdvancedSearch->setSearchValue(Get("x_t_14_head", Get("t_14_head", "")));
		if ($this->t_14_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_14_head->AdvancedSearch->setSearchOperator(Get("z_t_14_head", ""));

		// t_15_head
		if (!$this->isAddOrEdit())
			$this->t_15_head->AdvancedSearch->setSearchValue(Get("x_t_15_head", Get("t_15_head", "")));
		if ($this->t_15_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_15_head->AdvancedSearch->setSearchOperator(Get("z_t_15_head", ""));

		// po_01_head
		if (!$this->isAddOrEdit())
			$this->po_01_head->AdvancedSearch->setSearchValue(Get("x_po_01_head", Get("po_01_head", "")));
		if ($this->po_01_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_01_head->AdvancedSearch->setSearchOperator(Get("z_po_01_head", ""));

		// po_02_head
		if (!$this->isAddOrEdit())
			$this->po_02_head->AdvancedSearch->setSearchValue(Get("x_po_02_head", Get("po_02_head", "")));
		if ($this->po_02_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_02_head->AdvancedSearch->setSearchOperator(Get("z_po_02_head", ""));

		// po_03_head
		if (!$this->isAddOrEdit())
			$this->po_03_head->AdvancedSearch->setSearchValue(Get("x_po_03_head", Get("po_03_head", "")));
		if ($this->po_03_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_03_head->AdvancedSearch->setSearchOperator(Get("z_po_03_head", ""));

		// po_04_head
		if (!$this->isAddOrEdit())
			$this->po_04_head->AdvancedSearch->setSearchValue(Get("x_po_04_head", Get("po_04_head", "")));
		if ($this->po_04_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_04_head->AdvancedSearch->setSearchOperator(Get("z_po_04_head", ""));

		// po_05_head
		if (!$this->isAddOrEdit())
			$this->po_05_head->AdvancedSearch->setSearchValue(Get("x_po_05_head", Get("po_05_head", "")));
		if ($this->po_05_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_05_head->AdvancedSearch->setSearchOperator(Get("z_po_05_head", ""));

		// po_06_head
		if (!$this->isAddOrEdit())
			$this->po_06_head->AdvancedSearch->setSearchValue(Get("x_po_06_head", Get("po_06_head", "")));
		if ($this->po_06_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_06_head->AdvancedSearch->setSearchOperator(Get("z_po_06_head", ""));

		// po_07_head
		if (!$this->isAddOrEdit())
			$this->po_07_head->AdvancedSearch->setSearchValue(Get("x_po_07_head", Get("po_07_head", "")));
		if ($this->po_07_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_07_head->AdvancedSearch->setSearchOperator(Get("z_po_07_head", ""));

		// po_08_head
		if (!$this->isAddOrEdit())
			$this->po_08_head->AdvancedSearch->setSearchValue(Get("x_po_08_head", Get("po_08_head", "")));
		if ($this->po_08_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_08_head->AdvancedSearch->setSearchOperator(Get("z_po_08_head", ""));

		// po_17_head
		if (!$this->isAddOrEdit())
			$this->po_17_head->AdvancedSearch->setSearchValue(Get("x_po_17_head", Get("po_17_head", "")));
		if ($this->po_17_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_17_head->AdvancedSearch->setSearchOperator(Get("z_po_17_head", ""));

		// po_18_head
		if (!$this->isAddOrEdit())
			$this->po_18_head->AdvancedSearch->setSearchValue(Get("x_po_18_head", Get("po_18_head", "")));
		if ($this->po_18_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_18_head->AdvancedSearch->setSearchOperator(Get("z_po_18_head", ""));

		// po_19_head
		if (!$this->isAddOrEdit())
			$this->po_19_head->AdvancedSearch->setSearchValue(Get("x_po_19_head", Get("po_19_head", "")));
		if ($this->po_19_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_19_head->AdvancedSearch->setSearchOperator(Get("z_po_19_head", ""));

		// po_20_head
		if (!$this->isAddOrEdit())
			$this->po_20_head->AdvancedSearch->setSearchValue(Get("x_po_20_head", Get("po_20_head", "")));
		if ($this->po_20_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_20_head->AdvancedSearch->setSearchOperator(Get("z_po_20_head", ""));

		// jc_01_head
		if (!$this->isAddOrEdit())
			$this->jc_01_head->AdvancedSearch->setSearchValue(Get("x_jc_01_head", Get("jc_01_head", "")));
		if ($this->jc_01_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_01_head->AdvancedSearch->setSearchOperator(Get("z_jc_01_head", ""));

		// jc_02_head
		if (!$this->isAddOrEdit())
			$this->jc_02_head->AdvancedSearch->setSearchValue(Get("x_jc_02_head", Get("jc_02_head", "")));
		if ($this->jc_02_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_02_head->AdvancedSearch->setSearchOperator(Get("z_jc_02_head", ""));

		// jc_03_head
		if (!$this->isAddOrEdit())
			$this->jc_03_head->AdvancedSearch->setSearchValue(Get("x_jc_03_head", Get("jc_03_head", "")));
		if ($this->jc_03_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_03_head->AdvancedSearch->setSearchOperator(Get("z_jc_03_head", ""));

		// jc_04_head
		if (!$this->isAddOrEdit())
			$this->jc_04_head->AdvancedSearch->setSearchValue(Get("x_jc_04_head", Get("jc_04_head", "")));
		if ($this->jc_04_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_04_head->AdvancedSearch->setSearchOperator(Get("z_jc_04_head", ""));

		// jc_05_head
		if (!$this->isAddOrEdit())
			$this->jc_05_head->AdvancedSearch->setSearchValue(Get("x_jc_05_head", Get("jc_05_head", "")));
		if ($this->jc_05_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_05_head->AdvancedSearch->setSearchOperator(Get("z_jc_05_head", ""));

		// jc_06_head
		if (!$this->isAddOrEdit())
			$this->jc_06_head->AdvancedSearch->setSearchValue(Get("x_jc_06_head", Get("jc_06_head", "")));
		if ($this->jc_06_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_06_head->AdvancedSearch->setSearchOperator(Get("z_jc_06_head", ""));

		// jc_07_head
		if (!$this->isAddOrEdit())
			$this->jc_07_head->AdvancedSearch->setSearchValue(Get("x_jc_07_head", Get("jc_07_head", "")));
		if ($this->jc_07_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_07_head->AdvancedSearch->setSearchOperator(Get("z_jc_07_head", ""));

		// jc_08_head
		if (!$this->isAddOrEdit())
			$this->jc_08_head->AdvancedSearch->setSearchValue(Get("x_jc_08_head", Get("jc_08_head", "")));
		if ($this->jc_08_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_08_head->AdvancedSearch->setSearchOperator(Get("z_jc_08_head", ""));

		// jc_09_head
		if (!$this->isAddOrEdit())
			$this->jc_09_head->AdvancedSearch->setSearchValue(Get("x_jc_09_head", Get("jc_09_head", "")));
		if ($this->jc_09_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_09_head->AdvancedSearch->setSearchOperator(Get("z_jc_09_head", ""));

		// jc_10_head
		if (!$this->isAddOrEdit())
			$this->jc_10_head->AdvancedSearch->setSearchValue(Get("x_jc_10_head", Get("jc_10_head", "")));
		if ($this->jc_10_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_10_head->AdvancedSearch->setSearchOperator(Get("z_jc_10_head", ""));

		// pc_shape
		if (!$this->isAddOrEdit())
			$this->pc_shape->AdvancedSearch->setSearchValue(Get("x_pc_shape", Get("pc_shape", "")));
		if ($this->pc_shape->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_shape->AdvancedSearch->setSearchOperator(Get("z_pc_shape", ""));

		// pc_unit
		if (!$this->isAddOrEdit())
			$this->pc_unit->AdvancedSearch->setSearchValue(Get("x_pc_unit", Get("pc_unit", "")));
		if ($this->pc_unit->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_unit->AdvancedSearch->setSearchOperator(Get("z_pc_unit", ""));

		// pc_w
		if (!$this->isAddOrEdit())
			$this->pc_w->AdvancedSearch->setSearchValue(Get("x_pc_w", Get("pc_w", "")));
		if ($this->pc_w->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_w->AdvancedSearch->setSearchOperator(Get("z_pc_w", ""));

		// pc_l
		if (!$this->isAddOrEdit())
			$this->pc_l->AdvancedSearch->setSearchValue(Get("x_pc_l", Get("pc_l", "")));
		if ($this->pc_l->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_l->AdvancedSearch->setSearchOperator(Get("z_pc_l", ""));

		// pc_h
		if (!$this->isAddOrEdit())
			$this->pc_h->AdvancedSearch->setSearchValue(Get("x_pc_h", Get("pc_h", "")));
		if ($this->pc_h->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_h->AdvancedSearch->setSearchOperator(Get("z_pc_h", ""));

		// pc_partner_size
		if (!$this->isAddOrEdit())
			$this->pc_partner_size->AdvancedSearch->setSearchValue(Get("x_pc_partner_size", Get("pc_partner_size", "")));
		if ($this->pc_partner_size->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_partner_size->AdvancedSearch->setSearchOperator(Get("z_pc_partner_size", ""));

		// pc_sqm
		if (!$this->isAddOrEdit())
			$this->pc_sqm->AdvancedSearch->setSearchValue(Get("x_pc_sqm", Get("pc_sqm", "")));
		if ($this->pc_sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_sqm->AdvancedSearch->setSearchOperator(Get("z_pc_sqm", ""));

		// pc_01_head
		if (!$this->isAddOrEdit())
			$this->pc_01_head->AdvancedSearch->setSearchValue(Get("x_pc_01_head", Get("pc_01_head", "")));
		if ($this->pc_01_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_01_head->AdvancedSearch->setSearchOperator(Get("z_pc_01_head", ""));

		// pc_02_head
		if (!$this->isAddOrEdit())
			$this->pc_02_head->AdvancedSearch->setSearchValue(Get("x_pc_02_head", Get("pc_02_head", "")));
		if ($this->pc_02_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_02_head->AdvancedSearch->setSearchOperator(Get("z_pc_02_head", ""));

		// pc_03_head
		if (!$this->isAddOrEdit())
			$this->pc_03_head->AdvancedSearch->setSearchValue(Get("x_pc_03_head", Get("pc_03_head", "")));
		if ($this->pc_03_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_03_head->AdvancedSearch->setSearchOperator(Get("z_pc_03_head", ""));

		// pc_04_head
		if (!$this->isAddOrEdit())
			$this->pc_04_head->AdvancedSearch->setSearchValue(Get("x_pc_04_head", Get("pc_04_head", "")));
		if ($this->pc_04_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_04_head->AdvancedSearch->setSearchOperator(Get("z_pc_04_head", ""));

		// pc_05_head
		if (!$this->isAddOrEdit())
			$this->pc_05_head->AdvancedSearch->setSearchValue(Get("x_pc_05_head", Get("pc_05_head", "")));
		if ($this->pc_05_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_05_head->AdvancedSearch->setSearchOperator(Get("z_pc_05_head", ""));

		// pc_06_head
		if (!$this->isAddOrEdit())
			$this->pc_06_head->AdvancedSearch->setSearchValue(Get("x_pc_06_head", Get("pc_06_head", "")));
		if ($this->pc_06_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_06_head->AdvancedSearch->setSearchOperator(Get("z_pc_06_head", ""));

		// pc_07_head
		if (!$this->isAddOrEdit())
			$this->pc_07_head->AdvancedSearch->setSearchValue(Get("x_pc_07_head", Get("pc_07_head", "")));
		if ($this->pc_07_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_07_head->AdvancedSearch->setSearchOperator(Get("z_pc_07_head", ""));

		// pc_08_head
		if (!$this->isAddOrEdit())
			$this->pc_08_head->AdvancedSearch->setSearchValue(Get("x_pc_08_head", Get("pc_08_head", "")));
		if ($this->pc_08_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_08_head->AdvancedSearch->setSearchOperator(Get("z_pc_08_head", ""));

		// pc_09_head
		if (!$this->isAddOrEdit())
			$this->pc_09_head->AdvancedSearch->setSearchValue(Get("x_pc_09_head", Get("pc_09_head", "")));
		if ($this->pc_09_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_09_head->AdvancedSearch->setSearchOperator(Get("z_pc_09_head", ""));

		// pc_10_head
		if (!$this->isAddOrEdit())
			$this->pc_10_head->AdvancedSearch->setSearchValue(Get("x_pc_10_head", Get("pc_10_head", "")));
		if ($this->pc_10_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_10_head->AdvancedSearch->setSearchOperator(Get("z_pc_10_head", ""));

		// pc_11_head
		if (!$this->isAddOrEdit())
			$this->pc_11_head->AdvancedSearch->setSearchValue(Get("x_pc_11_head", Get("pc_11_head", "")));
		if ($this->pc_11_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_11_head->AdvancedSearch->setSearchOperator(Get("z_pc_11_head", ""));

		// pc_12_head
		if (!$this->isAddOrEdit())
			$this->pc_12_head->AdvancedSearch->setSearchValue(Get("x_pc_12_head", Get("pc_12_head", "")));
		if ($this->pc_12_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pc_12_head->AdvancedSearch->setSearchOperator(Get("z_pc_12_head", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue(Get("x_image", Get("image", "")));
		if ($this->image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->image->AdvancedSearch->setSearchOperator(Get("z_image", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->product_group->setDbValue($row['product_group']);
		$this->calculation_method->setDbValue($row['calculation_method']);
		$this->shape->setDbValue($row['shape']);
		$this->sqm->setDbValue($row['sqm']);
		$this->cbm->setDbValue($row['cbm']);
		$this->process->setDbValue($row['process']);
		$this->status->setDbValue($row['status']);
		$this->v_00->setDbValue($row['v_00']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_01_validation->setDbValue($row['v_01_validation']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_02_validation->setDbValue($row['v_02_validation']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_03_validation->setDbValue($row['v_03_validation']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_04_validation->setDbValue($row['v_04_validation']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_05_validation->setDbValue($row['v_05_validation']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_06_validation->setDbValue($row['v_06_validation']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_07_validation->setDbValue($row['v_07_validation']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_08_validation->setDbValue($row['v_08_validation']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_09_validation->setDbValue($row['v_09_validation']);
		$this->v_10->setDbValue($row['v_10']);
		$this->v_10_validation->setDbValue($row['v_10_validation']);
		$this->b_01_head->setDbValue($row['b_01_head']);
		$this->b_02_head->setDbValue($row['b_02_head']);
		$this->b_03_head->setDbValue($row['b_03_head']);
		$this->b_04_head->setDbValue($row['b_04_head']);
		$this->b_05_head->setDbValue($row['b_05_head']);
		$this->b_06_head->setDbValue($row['b_06_head']);
		$this->b_07_head->setDbValue($row['b_07_head']);
		$this->b_08_head->setDbValue($row['b_08_head']);
		$this->b_09_head->setDbValue($row['b_09_head']);
		$this->b_10_head->setDbValue($row['b_10_head']);
		$this->b_11_head->setDbValue($row['b_11_head']);
		$this->b_12_head->setDbValue($row['b_12_head']);
		$this->b_13_head->setDbValue($row['b_13_head']);
		$this->b_14_head->setDbValue($row['b_14_head']);
		$this->b_15_head->setDbValue($row['b_15_head']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->t_01_head->setDbValue($row['t_01_head']);
		$this->t_02_head->setDbValue($row['t_02_head']);
		$this->t_03_head->setDbValue($row['t_03_head']);
		$this->t_04_head->setDbValue($row['t_04_head']);
		$this->t_05_head->setDbValue($row['t_05_head']);
		$this->t_06_head->setDbValue($row['t_06_head']);
		$this->t_07_head->setDbValue($row['t_07_head']);
		$this->t_08_head->setDbValue($row['t_08_head']);
		$this->t_09_head->setDbValue($row['t_09_head']);
		$this->t_10_head->setDbValue($row['t_10_head']);
		$this->t_11_head->setDbValue($row['t_11_head']);
		$this->t_12_head->setDbValue($row['t_12_head']);
		$this->t_13_head->setDbValue($row['t_13_head']);
		$this->t_14_head->setDbValue($row['t_14_head']);
		$this->t_15_head->setDbValue($row['t_15_head']);
		$this->po_01_head->setDbValue($row['po_01_head']);
		$this->po_02_head->setDbValue($row['po_02_head']);
		$this->po_03_head->setDbValue($row['po_03_head']);
		$this->po_04_head->setDbValue($row['po_04_head']);
		$this->po_05_head->setDbValue($row['po_05_head']);
		$this->po_06_head->setDbValue($row['po_06_head']);
		$this->po_07_head->setDbValue($row['po_07_head']);
		$this->po_08_head->setDbValue($row['po_08_head']);
		$this->po_17_head->setDbValue($row['po_17_head']);
		$this->po_18_head->setDbValue($row['po_18_head']);
		$this->po_19_head->setDbValue($row['po_19_head']);
		$this->po_20_head->setDbValue($row['po_20_head']);
		$this->jc_01_head->setDbValue($row['jc_01_head']);
		$this->jc_02_head->setDbValue($row['jc_02_head']);
		$this->jc_03_head->setDbValue($row['jc_03_head']);
		$this->jc_04_head->setDbValue($row['jc_04_head']);
		$this->jc_05_head->setDbValue($row['jc_05_head']);
		$this->jc_06_head->setDbValue($row['jc_06_head']);
		$this->jc_07_head->setDbValue($row['jc_07_head']);
		$this->jc_08_head->setDbValue($row['jc_08_head']);
		$this->jc_09_head->setDbValue($row['jc_09_head']);
		$this->jc_10_head->setDbValue($row['jc_10_head']);
		$this->pc_shape->setDbValue($row['pc_shape']);
		$this->pc_unit->setDbValue($row['pc_unit']);
		$this->pc_w->setDbValue($row['pc_w']);
		$this->pc_l->setDbValue($row['pc_l']);
		$this->pc_h->setDbValue($row['pc_h']);
		$this->pc_partner_size->setDbValue($row['pc_partner_size']);
		$this->pc_sqm->setDbValue($row['pc_sqm']);
		$this->pc_01_head->setDbValue($row['pc_01_head']);
		$this->pc_02_head->setDbValue($row['pc_02_head']);
		$this->pc_03_head->setDbValue($row['pc_03_head']);
		$this->pc_04_head->setDbValue($row['pc_04_head']);
		$this->pc_05_head->setDbValue($row['pc_05_head']);
		$this->pc_06_head->setDbValue($row['pc_06_head']);
		$this->pc_07_head->setDbValue($row['pc_07_head']);
		$this->pc_08_head->setDbValue($row['pc_08_head']);
		$this->pc_09_head->setDbValue($row['pc_09_head']);
		$this->pc_10_head->setDbValue($row['pc_10_head']);
		$this->pc_11_head->setDbValue($row['pc_11_head']);
		$this->pc_12_head->setDbValue($row['pc_12_head']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['grp'] = NULL;
		$row['product_group'] = NULL;
		$row['calculation_method'] = NULL;
		$row['shape'] = NULL;
		$row['sqm'] = NULL;
		$row['cbm'] = NULL;
		$row['process'] = NULL;
		$row['status'] = NULL;
		$row['v_00'] = NULL;
		$row['v_01'] = NULL;
		$row['v_01_validation'] = NULL;
		$row['v_02'] = NULL;
		$row['v_02_validation'] = NULL;
		$row['v_03'] = NULL;
		$row['v_03_validation'] = NULL;
		$row['v_04'] = NULL;
		$row['v_04_validation'] = NULL;
		$row['v_05'] = NULL;
		$row['v_05_validation'] = NULL;
		$row['v_06'] = NULL;
		$row['v_06_validation'] = NULL;
		$row['v_07'] = NULL;
		$row['v_07_validation'] = NULL;
		$row['v_08'] = NULL;
		$row['v_08_validation'] = NULL;
		$row['v_09'] = NULL;
		$row['v_09_validation'] = NULL;
		$row['v_10'] = NULL;
		$row['v_10_validation'] = NULL;
		$row['b_01_head'] = NULL;
		$row['b_02_head'] = NULL;
		$row['b_03_head'] = NULL;
		$row['b_04_head'] = NULL;
		$row['b_05_head'] = NULL;
		$row['b_06_head'] = NULL;
		$row['b_07_head'] = NULL;
		$row['b_08_head'] = NULL;
		$row['b_09_head'] = NULL;
		$row['b_10_head'] = NULL;
		$row['b_11_head'] = NULL;
		$row['b_12_head'] = NULL;
		$row['b_13_head'] = NULL;
		$row['b_14_head'] = NULL;
		$row['b_15_head'] = NULL;
		$row['q_sku'] = NULL;
		$row['t_01_head'] = NULL;
		$row['t_02_head'] = NULL;
		$row['t_03_head'] = NULL;
		$row['t_04_head'] = NULL;
		$row['t_05_head'] = NULL;
		$row['t_06_head'] = NULL;
		$row['t_07_head'] = NULL;
		$row['t_08_head'] = NULL;
		$row['t_09_head'] = NULL;
		$row['t_10_head'] = NULL;
		$row['t_11_head'] = NULL;
		$row['t_12_head'] = NULL;
		$row['t_13_head'] = NULL;
		$row['t_14_head'] = NULL;
		$row['t_15_head'] = NULL;
		$row['po_01_head'] = NULL;
		$row['po_02_head'] = NULL;
		$row['po_03_head'] = NULL;
		$row['po_04_head'] = NULL;
		$row['po_05_head'] = NULL;
		$row['po_06_head'] = NULL;
		$row['po_07_head'] = NULL;
		$row['po_08_head'] = NULL;
		$row['po_17_head'] = NULL;
		$row['po_18_head'] = NULL;
		$row['po_19_head'] = NULL;
		$row['po_20_head'] = NULL;
		$row['jc_01_head'] = NULL;
		$row['jc_02_head'] = NULL;
		$row['jc_03_head'] = NULL;
		$row['jc_04_head'] = NULL;
		$row['jc_05_head'] = NULL;
		$row['jc_06_head'] = NULL;
		$row['jc_07_head'] = NULL;
		$row['jc_08_head'] = NULL;
		$row['jc_09_head'] = NULL;
		$row['jc_10_head'] = NULL;
		$row['pc_shape'] = NULL;
		$row['pc_unit'] = NULL;
		$row['pc_w'] = NULL;
		$row['pc_l'] = NULL;
		$row['pc_h'] = NULL;
		$row['pc_partner_size'] = NULL;
		$row['pc_sqm'] = NULL;
		$row['pc_01_head'] = NULL;
		$row['pc_02_head'] = NULL;
		$row['pc_03_head'] = NULL;
		$row['pc_04_head'] = NULL;
		$row['pc_05_head'] = NULL;
		$row['pc_06_head'] = NULL;
		$row['pc_07_head'] = NULL;
		$row['pc_08_head'] = NULL;
		$row['pc_09_head'] = NULL;
		$row['pc_10_head'] = NULL;
		$row['pc_11_head'] = NULL;
		$row['pc_12_head'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['image'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// product_group
		// calculation_method
		// shape
		// sqm
		// cbm
		// process
		// status
		// v_00
		// v_01
		// v_01_validation
		// v_02
		// v_02_validation
		// v_03
		// v_03_validation
		// v_04
		// v_04_validation
		// v_05
		// v_05_validation
		// v_06
		// v_06_validation
		// v_07
		// v_07_validation
		// v_08
		// v_08_validation
		// v_09
		// v_09_validation
		// v_10
		// v_10_validation
		// b_01_head
		// b_02_head
		// b_03_head
		// b_04_head
		// b_05_head
		// b_06_head
		// b_07_head
		// b_08_head
		// b_09_head
		// b_10_head
		// b_11_head
		// b_12_head
		// b_13_head
		// b_14_head
		// b_15_head
		// q_sku
		// t_01_head
		// t_02_head
		// t_03_head
		// t_04_head
		// t_05_head
		// t_06_head
		// t_07_head
		// t_08_head
		// t_09_head
		// t_10_head
		// t_11_head
		// t_12_head
		// t_13_head
		// t_14_head
		// t_15_head
		// po_01_head
		// po_02_head
		// po_03_head
		// po_04_head
		// po_05_head
		// po_06_head
		// po_07_head
		// po_08_head
		// po_17_head
		// po_18_head
		// po_19_head
		// po_20_head
		// jc_01_head
		// jc_02_head
		// jc_03_head
		// jc_04_head
		// jc_05_head
		// jc_06_head
		// jc_07_head
		// jc_08_head
		// jc_09_head
		// jc_10_head
		// pc_shape
		// pc_unit
		// pc_w
		// pc_l
		// pc_h
		// pc_partner_size
		// pc_sqm
		// pc_01_head
		// pc_02_head
		// pc_03_head
		// pc_04_head
		// pc_05_head
		// pc_06_head
		// pc_07_head
		// pc_08_head
		// pc_09_head
		// pc_10_head
		// pc_11_head
		// pc_12_head
		// operator
		// datetime
		// image

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// product_group
			$this->product_group->ViewValue = $this->product_group->CurrentValue;
			$this->product_group->ViewCustomAttributes = "";

			// calculation_method
			$curVal = strval($this->calculation_method->CurrentValue);
			if ($curVal <> "") {
				$this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
				if ($this->calculation_method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->calculation_method->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->calculation_method->ViewValue = $this->calculation_method->CurrentValue;
					}
				}
			} else {
				$this->calculation_method->ViewValue = NULL;
			}
			$this->calculation_method->ViewCustomAttributes = "";

			// shape
			$this->shape->ViewValue = $this->shape->CurrentValue;
			$this->shape->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// v_00
			$this->v_00->ViewValue = $this->v_00->CurrentValue;
			$this->v_00->ViewCustomAttributes = "";

			// v_01
			$this->v_01->ViewValue = $this->v_01->CurrentValue;
			$this->v_01->ViewCustomAttributes = "";

			// v_01_validation
			$this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;
			$this->v_01_validation->ViewCustomAttributes = "";

			// v_02
			$this->v_02->ViewValue = $this->v_02->CurrentValue;
			$this->v_02->ViewCustomAttributes = "";

			// v_02_validation
			$this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;
			$this->v_02_validation->ViewCustomAttributes = "";

			// v_03
			$this->v_03->ViewValue = $this->v_03->CurrentValue;
			$this->v_03->ViewCustomAttributes = "";

			// v_03_validation
			$this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;
			$this->v_03_validation->ViewCustomAttributes = "";

			// v_04
			$this->v_04->ViewValue = $this->v_04->CurrentValue;
			$this->v_04->ViewCustomAttributes = "";

			// v_04_validation
			$this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;
			$this->v_04_validation->ViewCustomAttributes = "";

			// v_05
			$this->v_05->ViewValue = $this->v_05->CurrentValue;
			$this->v_05->ViewCustomAttributes = "";

			// v_05_validation
			$this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;
			$this->v_05_validation->ViewCustomAttributes = "";

			// v_06
			$this->v_06->ViewValue = $this->v_06->CurrentValue;
			$this->v_06->ViewCustomAttributes = "";

			// v_06_validation
			$this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;
			$this->v_06_validation->ViewCustomAttributes = "";

			// v_07
			$this->v_07->ViewValue = $this->v_07->CurrentValue;
			$this->v_07->ViewCustomAttributes = "";

			// v_07_validation
			$this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;
			$this->v_07_validation->ViewCustomAttributes = "";

			// v_08
			$this->v_08->ViewValue = $this->v_08->CurrentValue;
			$this->v_08->ViewCustomAttributes = "";

			// v_08_validation
			$this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;
			$this->v_08_validation->ViewCustomAttributes = "";

			// v_09
			$this->v_09->ViewValue = $this->v_09->CurrentValue;
			$this->v_09->ViewCustomAttributes = "";

			// v_09_validation
			$this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;
			$this->v_09_validation->ViewCustomAttributes = "";

			// v_10
			$this->v_10->ViewValue = $this->v_10->CurrentValue;
			$this->v_10->ViewCustomAttributes = "";

			// v_10_validation
			$this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;
			$this->v_10_validation->ViewCustomAttributes = "";

			// b_01_head
			$this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;
			$this->b_01_head->ViewCustomAttributes = "";

			// b_02_head
			$this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;
			$this->b_02_head->ViewCustomAttributes = "";

			// b_03_head
			$this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;
			$this->b_03_head->ViewCustomAttributes = "";

			// b_04_head
			$this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;
			$this->b_04_head->ViewCustomAttributes = "";

			// b_05_head
			$this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;
			$this->b_05_head->ViewCustomAttributes = "";

			// b_06_head
			$this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;
			$this->b_06_head->ViewCustomAttributes = "";

			// b_07_head
			$this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;
			$this->b_07_head->ViewCustomAttributes = "";

			// b_08_head
			$this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;
			$this->b_08_head->ViewCustomAttributes = "";

			// b_09_head
			$this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;
			$this->b_09_head->ViewCustomAttributes = "";

			// b_10_head
			$this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;
			$this->b_10_head->ViewCustomAttributes = "";

			// b_11_head
			$this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;
			$this->b_11_head->ViewCustomAttributes = "";

			// b_12_head
			$this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;
			$this->b_12_head->ViewCustomAttributes = "";

			// b_13_head
			$this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;
			$this->b_13_head->ViewCustomAttributes = "";

			// b_14_head
			$this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;
			$this->b_14_head->ViewCustomAttributes = "";

			// b_15_head
			$this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;
			$this->b_15_head->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewCustomAttributes = "";

			// t_01_head
			$this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;
			$this->t_01_head->ViewCustomAttributes = "";

			// t_02_head
			$this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;
			$this->t_02_head->ViewCustomAttributes = "";

			// t_03_head
			$this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;
			$this->t_03_head->ViewCustomAttributes = "";

			// t_04_head
			$this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;
			$this->t_04_head->ViewCustomAttributes = "";

			// t_05_head
			$this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;
			$this->t_05_head->ViewCustomAttributes = "";

			// t_06_head
			$this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;
			$this->t_06_head->ViewCustomAttributes = "";

			// t_07_head
			$this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;
			$this->t_07_head->ViewCustomAttributes = "";

			// t_08_head
			$this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;
			$this->t_08_head->ViewCustomAttributes = "";

			// t_09_head
			$this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;
			$this->t_09_head->ViewCustomAttributes = "";

			// t_10_head
			$this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;
			$this->t_10_head->ViewCustomAttributes = "";

			// t_11_head
			$this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;
			$this->t_11_head->ViewCustomAttributes = "";

			// t_12_head
			$this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;
			$this->t_12_head->ViewCustomAttributes = "";

			// t_13_head
			$this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;
			$this->t_13_head->ViewCustomAttributes = "";

			// t_14_head
			$this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;
			$this->t_14_head->ViewCustomAttributes = "";

			// t_15_head
			$this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;
			$this->t_15_head->ViewCustomAttributes = "";

			// po_01_head
			$this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;
			$this->po_01_head->ViewCustomAttributes = "";

			// po_02_head
			$this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;
			$this->po_02_head->ViewCustomAttributes = "";

			// po_03_head
			$this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;
			$this->po_03_head->ViewCustomAttributes = "";

			// po_04_head
			$this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;
			$this->po_04_head->ViewCustomAttributes = "";

			// po_05_head
			$this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;
			$this->po_05_head->ViewCustomAttributes = "";

			// po_06_head
			$this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;
			$this->po_06_head->ViewCustomAttributes = "";

			// po_07_head
			$this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;
			$this->po_07_head->ViewCustomAttributes = "";

			// po_08_head
			$this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;
			$this->po_08_head->ViewCustomAttributes = "";

			// po_17_head
			$this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;
			$this->po_17_head->ViewCustomAttributes = "";

			// po_18_head
			$this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;
			$this->po_18_head->ViewCustomAttributes = "";

			// po_19_head
			$this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;
			$this->po_19_head->ViewCustomAttributes = "";

			// po_20_head
			$this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;
			$this->po_20_head->ViewCustomAttributes = "";

			// jc_01_head
			$this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;
			$this->jc_01_head->ViewCustomAttributes = "";

			// jc_02_head
			$this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;
			$this->jc_02_head->ViewCustomAttributes = "";

			// jc_03_head
			$this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;
			$this->jc_03_head->ViewCustomAttributes = "";

			// jc_04_head
			$this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;
			$this->jc_04_head->ViewCustomAttributes = "";

			// jc_05_head
			$this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;
			$this->jc_05_head->ViewCustomAttributes = "";

			// jc_06_head
			$this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;
			$this->jc_06_head->ViewCustomAttributes = "";

			// jc_07_head
			$this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;
			$this->jc_07_head->ViewCustomAttributes = "";

			// jc_08_head
			$this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;
			$this->jc_08_head->ViewCustomAttributes = "";

			// jc_09_head
			$this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;
			$this->jc_09_head->ViewCustomAttributes = "";

			// jc_10_head
			$this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;
			$this->jc_10_head->ViewCustomAttributes = "";

			// pc_shape
			$this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;
			$this->pc_shape->ViewCustomAttributes = "";

			// pc_unit
			$this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;
			$this->pc_unit->ViewCustomAttributes = "";

			// pc_w
			$this->pc_w->ViewValue = $this->pc_w->CurrentValue;
			$this->pc_w->ViewCustomAttributes = "";

			// pc_l
			$this->pc_l->ViewValue = $this->pc_l->CurrentValue;
			$this->pc_l->ViewCustomAttributes = "";

			// pc_h
			$this->pc_h->ViewValue = $this->pc_h->CurrentValue;
			$this->pc_h->ViewCustomAttributes = "";

			// pc_partner_size
			$this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;
			$this->pc_partner_size->ViewCustomAttributes = "";

			// pc_sqm
			$this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;
			$this->pc_sqm->ViewCustomAttributes = "";

			// pc_01_head
			$this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;
			$this->pc_01_head->ViewCustomAttributes = "";

			// pc_02_head
			$this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;
			$this->pc_02_head->ViewCustomAttributes = "";

			// pc_03_head
			$this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;
			$this->pc_03_head->ViewCustomAttributes = "";

			// pc_04_head
			$this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;
			$this->pc_04_head->ViewCustomAttributes = "";

			// pc_05_head
			$this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;
			$this->pc_05_head->ViewCustomAttributes = "";

			// pc_06_head
			$this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;
			$this->pc_06_head->ViewCustomAttributes = "";

			// pc_07_head
			$this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;
			$this->pc_07_head->ViewCustomAttributes = "";

			// pc_08_head
			$this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;
			$this->pc_08_head->ViewCustomAttributes = "";

			// pc_09_head
			$this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;
			$this->pc_09_head->ViewCustomAttributes = "";

			// pc_10_head
			$this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;
			$this->pc_10_head->ViewCustomAttributes = "";

			// pc_11_head
			$this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;
			$this->pc_11_head->ViewCustomAttributes = "";

			// pc_12_head
			$this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;
			$this->pc_12_head->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// product_group
			$this->product_group->LinkCustomAttributes = "";
			$this->product_group->HrefValue = "";
			$this->product_group->TooltipValue = "";
			if (!$this->isExport())
				$this->product_group->ViewValue = $this->highlightValue($this->product_group);

			// calculation_method
			$this->calculation_method->LinkCustomAttributes = "";
			$this->calculation_method->HrefValue = "";
			$this->calculation_method->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";
			if (!$this->isExport())
				$this->shape->ViewValue = $this->highlightValue($this->shape);

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";
			if (!$this->isExport())
				$this->sqm->ViewValue = $this->highlightValue($this->sqm);

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";
			if (!$this->isExport())
				$this->cbm->ViewValue = $this->highlightValue($this->cbm);

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// v_00
			$this->v_00->LinkCustomAttributes = "";
			$this->v_00->HrefValue = "";
			$this->v_00->TooltipValue = "";
			if (!$this->isExport())
				$this->v_00->ViewValue = $this->highlightValue($this->v_00);

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";
			$this->v_01->TooltipValue = "";
			if (!$this->isExport())
				$this->v_01->ViewValue = $this->highlightValue($this->v_01);

			// v_01_validation
			$this->v_01_validation->LinkCustomAttributes = "";
			$this->v_01_validation->HrefValue = "";
			$this->v_01_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_01_validation->ViewValue = $this->highlightValue($this->v_01_validation);

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";
			$this->v_02->TooltipValue = "";
			if (!$this->isExport())
				$this->v_02->ViewValue = $this->highlightValue($this->v_02);

			// v_02_validation
			$this->v_02_validation->LinkCustomAttributes = "";
			$this->v_02_validation->HrefValue = "";
			$this->v_02_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_02_validation->ViewValue = $this->highlightValue($this->v_02_validation);

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";
			$this->v_03->TooltipValue = "";
			if (!$this->isExport())
				$this->v_03->ViewValue = $this->highlightValue($this->v_03);

			// v_03_validation
			$this->v_03_validation->LinkCustomAttributes = "";
			$this->v_03_validation->HrefValue = "";
			$this->v_03_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_03_validation->ViewValue = $this->highlightValue($this->v_03_validation);

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";
			$this->v_04->TooltipValue = "";
			if (!$this->isExport())
				$this->v_04->ViewValue = $this->highlightValue($this->v_04);

			// v_04_validation
			$this->v_04_validation->LinkCustomAttributes = "";
			$this->v_04_validation->HrefValue = "";
			$this->v_04_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_04_validation->ViewValue = $this->highlightValue($this->v_04_validation);

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";
			$this->v_05->TooltipValue = "";
			if (!$this->isExport())
				$this->v_05->ViewValue = $this->highlightValue($this->v_05);

			// v_05_validation
			$this->v_05_validation->LinkCustomAttributes = "";
			$this->v_05_validation->HrefValue = "";
			$this->v_05_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_05_validation->ViewValue = $this->highlightValue($this->v_05_validation);

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";
			$this->v_06->TooltipValue = "";
			if (!$this->isExport())
				$this->v_06->ViewValue = $this->highlightValue($this->v_06);

			// v_06_validation
			$this->v_06_validation->LinkCustomAttributes = "";
			$this->v_06_validation->HrefValue = "";
			$this->v_06_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_06_validation->ViewValue = $this->highlightValue($this->v_06_validation);

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";
			$this->v_07->TooltipValue = "";
			if (!$this->isExport())
				$this->v_07->ViewValue = $this->highlightValue($this->v_07);

			// v_07_validation
			$this->v_07_validation->LinkCustomAttributes = "";
			$this->v_07_validation->HrefValue = "";
			$this->v_07_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_07_validation->ViewValue = $this->highlightValue($this->v_07_validation);

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";
			$this->v_08->TooltipValue = "";
			if (!$this->isExport())
				$this->v_08->ViewValue = $this->highlightValue($this->v_08);

			// v_08_validation
			$this->v_08_validation->LinkCustomAttributes = "";
			$this->v_08_validation->HrefValue = "";
			$this->v_08_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_08_validation->ViewValue = $this->highlightValue($this->v_08_validation);

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";
			$this->v_09->TooltipValue = "";
			if (!$this->isExport())
				$this->v_09->ViewValue = $this->highlightValue($this->v_09);

			// v_09_validation
			$this->v_09_validation->LinkCustomAttributes = "";
			$this->v_09_validation->HrefValue = "";
			$this->v_09_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_09_validation->ViewValue = $this->highlightValue($this->v_09_validation);

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";
			$this->v_10->TooltipValue = "";
			if (!$this->isExport())
				$this->v_10->ViewValue = $this->highlightValue($this->v_10);

			// v_10_validation
			$this->v_10_validation->LinkCustomAttributes = "";
			$this->v_10_validation->HrefValue = "";
			$this->v_10_validation->TooltipValue = "";
			if (!$this->isExport())
				$this->v_10_validation->ViewValue = $this->highlightValue($this->v_10_validation);

			// b_01_head
			$this->b_01_head->LinkCustomAttributes = "";
			$this->b_01_head->HrefValue = "";
			$this->b_01_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_01_head->ViewValue = $this->highlightValue($this->b_01_head);

			// b_02_head
			$this->b_02_head->LinkCustomAttributes = "";
			$this->b_02_head->HrefValue = "";
			$this->b_02_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_02_head->ViewValue = $this->highlightValue($this->b_02_head);

			// b_03_head
			$this->b_03_head->LinkCustomAttributes = "";
			$this->b_03_head->HrefValue = "";
			$this->b_03_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_03_head->ViewValue = $this->highlightValue($this->b_03_head);

			// b_04_head
			$this->b_04_head->LinkCustomAttributes = "";
			$this->b_04_head->HrefValue = "";
			$this->b_04_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_04_head->ViewValue = $this->highlightValue($this->b_04_head);

			// b_05_head
			$this->b_05_head->LinkCustomAttributes = "";
			$this->b_05_head->HrefValue = "";
			$this->b_05_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_05_head->ViewValue = $this->highlightValue($this->b_05_head);

			// b_06_head
			$this->b_06_head->LinkCustomAttributes = "";
			$this->b_06_head->HrefValue = "";
			$this->b_06_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_06_head->ViewValue = $this->highlightValue($this->b_06_head);

			// b_07_head
			$this->b_07_head->LinkCustomAttributes = "";
			$this->b_07_head->HrefValue = "";
			$this->b_07_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_07_head->ViewValue = $this->highlightValue($this->b_07_head);

			// b_08_head
			$this->b_08_head->LinkCustomAttributes = "";
			$this->b_08_head->HrefValue = "";
			$this->b_08_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_08_head->ViewValue = $this->highlightValue($this->b_08_head);

			// b_09_head
			$this->b_09_head->LinkCustomAttributes = "";
			$this->b_09_head->HrefValue = "";
			$this->b_09_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_09_head->ViewValue = $this->highlightValue($this->b_09_head);

			// b_10_head
			$this->b_10_head->LinkCustomAttributes = "";
			$this->b_10_head->HrefValue = "";
			$this->b_10_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_10_head->ViewValue = $this->highlightValue($this->b_10_head);

			// b_11_head
			$this->b_11_head->LinkCustomAttributes = "";
			$this->b_11_head->HrefValue = "";
			$this->b_11_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_11_head->ViewValue = $this->highlightValue($this->b_11_head);

			// b_12_head
			$this->b_12_head->LinkCustomAttributes = "";
			$this->b_12_head->HrefValue = "";
			$this->b_12_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_12_head->ViewValue = $this->highlightValue($this->b_12_head);

			// b_13_head
			$this->b_13_head->LinkCustomAttributes = "";
			$this->b_13_head->HrefValue = "";
			$this->b_13_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_13_head->ViewValue = $this->highlightValue($this->b_13_head);

			// b_14_head
			$this->b_14_head->LinkCustomAttributes = "";
			$this->b_14_head->HrefValue = "";
			$this->b_14_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_14_head->ViewValue = $this->highlightValue($this->b_14_head);

			// b_15_head
			$this->b_15_head->LinkCustomAttributes = "";
			$this->b_15_head->HrefValue = "";
			$this->b_15_head->TooltipValue = "";
			if (!$this->isExport())
				$this->b_15_head->ViewValue = $this->highlightValue($this->b_15_head);

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";
			if (!$this->isExport())
				$this->q_sku->ViewValue = $this->highlightValue($this->q_sku);

			// t_01_head
			$this->t_01_head->LinkCustomAttributes = "";
			$this->t_01_head->HrefValue = "";
			$this->t_01_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_01_head->ViewValue = $this->highlightValue($this->t_01_head);

			// t_02_head
			$this->t_02_head->LinkCustomAttributes = "";
			$this->t_02_head->HrefValue = "";
			$this->t_02_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_02_head->ViewValue = $this->highlightValue($this->t_02_head);

			// t_03_head
			$this->t_03_head->LinkCustomAttributes = "";
			$this->t_03_head->HrefValue = "";
			$this->t_03_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_03_head->ViewValue = $this->highlightValue($this->t_03_head);

			// t_04_head
			$this->t_04_head->LinkCustomAttributes = "";
			$this->t_04_head->HrefValue = "";
			$this->t_04_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_04_head->ViewValue = $this->highlightValue($this->t_04_head);

			// t_05_head
			$this->t_05_head->LinkCustomAttributes = "";
			$this->t_05_head->HrefValue = "";
			$this->t_05_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_05_head->ViewValue = $this->highlightValue($this->t_05_head);

			// t_06_head
			$this->t_06_head->LinkCustomAttributes = "";
			$this->t_06_head->HrefValue = "";
			$this->t_06_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_06_head->ViewValue = $this->highlightValue($this->t_06_head);

			// t_07_head
			$this->t_07_head->LinkCustomAttributes = "";
			$this->t_07_head->HrefValue = "";
			$this->t_07_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_07_head->ViewValue = $this->highlightValue($this->t_07_head);

			// t_08_head
			$this->t_08_head->LinkCustomAttributes = "";
			$this->t_08_head->HrefValue = "";
			$this->t_08_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_08_head->ViewValue = $this->highlightValue($this->t_08_head);

			// t_09_head
			$this->t_09_head->LinkCustomAttributes = "";
			$this->t_09_head->HrefValue = "";
			$this->t_09_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_09_head->ViewValue = $this->highlightValue($this->t_09_head);

			// t_10_head
			$this->t_10_head->LinkCustomAttributes = "";
			$this->t_10_head->HrefValue = "";
			$this->t_10_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_10_head->ViewValue = $this->highlightValue($this->t_10_head);

			// t_11_head
			$this->t_11_head->LinkCustomAttributes = "";
			$this->t_11_head->HrefValue = "";
			$this->t_11_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_11_head->ViewValue = $this->highlightValue($this->t_11_head);

			// t_12_head
			$this->t_12_head->LinkCustomAttributes = "";
			$this->t_12_head->HrefValue = "";
			$this->t_12_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_12_head->ViewValue = $this->highlightValue($this->t_12_head);

			// t_13_head
			$this->t_13_head->LinkCustomAttributes = "";
			$this->t_13_head->HrefValue = "";
			$this->t_13_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_13_head->ViewValue = $this->highlightValue($this->t_13_head);

			// t_14_head
			$this->t_14_head->LinkCustomAttributes = "";
			$this->t_14_head->HrefValue = "";
			$this->t_14_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_14_head->ViewValue = $this->highlightValue($this->t_14_head);

			// t_15_head
			$this->t_15_head->LinkCustomAttributes = "";
			$this->t_15_head->HrefValue = "";
			$this->t_15_head->TooltipValue = "";
			if (!$this->isExport())
				$this->t_15_head->ViewValue = $this->highlightValue($this->t_15_head);

			// po_01_head
			$this->po_01_head->LinkCustomAttributes = "";
			$this->po_01_head->HrefValue = "";
			$this->po_01_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_01_head->ViewValue = $this->highlightValue($this->po_01_head);

			// po_02_head
			$this->po_02_head->LinkCustomAttributes = "";
			$this->po_02_head->HrefValue = "";
			$this->po_02_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_02_head->ViewValue = $this->highlightValue($this->po_02_head);

			// po_03_head
			$this->po_03_head->LinkCustomAttributes = "";
			$this->po_03_head->HrefValue = "";
			$this->po_03_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_03_head->ViewValue = $this->highlightValue($this->po_03_head);

			// po_04_head
			$this->po_04_head->LinkCustomAttributes = "";
			$this->po_04_head->HrefValue = "";
			$this->po_04_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_04_head->ViewValue = $this->highlightValue($this->po_04_head);

			// po_05_head
			$this->po_05_head->LinkCustomAttributes = "";
			$this->po_05_head->HrefValue = "";
			$this->po_05_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_05_head->ViewValue = $this->highlightValue($this->po_05_head);

			// po_06_head
			$this->po_06_head->LinkCustomAttributes = "";
			$this->po_06_head->HrefValue = "";
			$this->po_06_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_06_head->ViewValue = $this->highlightValue($this->po_06_head);

			// po_07_head
			$this->po_07_head->LinkCustomAttributes = "";
			$this->po_07_head->HrefValue = "";
			$this->po_07_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_07_head->ViewValue = $this->highlightValue($this->po_07_head);

			// po_08_head
			$this->po_08_head->LinkCustomAttributes = "";
			$this->po_08_head->HrefValue = "";
			$this->po_08_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_08_head->ViewValue = $this->highlightValue($this->po_08_head);

			// po_17_head
			$this->po_17_head->LinkCustomAttributes = "";
			$this->po_17_head->HrefValue = "";
			$this->po_17_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_17_head->ViewValue = $this->highlightValue($this->po_17_head);

			// po_18_head
			$this->po_18_head->LinkCustomAttributes = "";
			$this->po_18_head->HrefValue = "";
			$this->po_18_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_18_head->ViewValue = $this->highlightValue($this->po_18_head);

			// po_19_head
			$this->po_19_head->LinkCustomAttributes = "";
			$this->po_19_head->HrefValue = "";
			$this->po_19_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_19_head->ViewValue = $this->highlightValue($this->po_19_head);

			// po_20_head
			$this->po_20_head->LinkCustomAttributes = "";
			$this->po_20_head->HrefValue = "";
			$this->po_20_head->TooltipValue = "";
			if (!$this->isExport())
				$this->po_20_head->ViewValue = $this->highlightValue($this->po_20_head);

			// jc_01_head
			$this->jc_01_head->LinkCustomAttributes = "";
			$this->jc_01_head->HrefValue = "";
			$this->jc_01_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_01_head->ViewValue = $this->highlightValue($this->jc_01_head);

			// jc_02_head
			$this->jc_02_head->LinkCustomAttributes = "";
			$this->jc_02_head->HrefValue = "";
			$this->jc_02_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_02_head->ViewValue = $this->highlightValue($this->jc_02_head);

			// jc_03_head
			$this->jc_03_head->LinkCustomAttributes = "";
			$this->jc_03_head->HrefValue = "";
			$this->jc_03_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_03_head->ViewValue = $this->highlightValue($this->jc_03_head);

			// jc_04_head
			$this->jc_04_head->LinkCustomAttributes = "";
			$this->jc_04_head->HrefValue = "";
			$this->jc_04_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_04_head->ViewValue = $this->highlightValue($this->jc_04_head);

			// jc_05_head
			$this->jc_05_head->LinkCustomAttributes = "";
			$this->jc_05_head->HrefValue = "";
			$this->jc_05_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_05_head->ViewValue = $this->highlightValue($this->jc_05_head);

			// jc_06_head
			$this->jc_06_head->LinkCustomAttributes = "";
			$this->jc_06_head->HrefValue = "";
			$this->jc_06_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_06_head->ViewValue = $this->highlightValue($this->jc_06_head);

			// jc_07_head
			$this->jc_07_head->LinkCustomAttributes = "";
			$this->jc_07_head->HrefValue = "";
			$this->jc_07_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_07_head->ViewValue = $this->highlightValue($this->jc_07_head);

			// jc_08_head
			$this->jc_08_head->LinkCustomAttributes = "";
			$this->jc_08_head->HrefValue = "";
			$this->jc_08_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_08_head->ViewValue = $this->highlightValue($this->jc_08_head);

			// jc_09_head
			$this->jc_09_head->LinkCustomAttributes = "";
			$this->jc_09_head->HrefValue = "";
			$this->jc_09_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_09_head->ViewValue = $this->highlightValue($this->jc_09_head);

			// jc_10_head
			$this->jc_10_head->LinkCustomAttributes = "";
			$this->jc_10_head->HrefValue = "";
			$this->jc_10_head->TooltipValue = "";
			if (!$this->isExport())
				$this->jc_10_head->ViewValue = $this->highlightValue($this->jc_10_head);

			// pc_shape
			$this->pc_shape->LinkCustomAttributes = "";
			$this->pc_shape->HrefValue = "";
			$this->pc_shape->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_shape->ViewValue = $this->highlightValue($this->pc_shape);

			// pc_unit
			$this->pc_unit->LinkCustomAttributes = "";
			$this->pc_unit->HrefValue = "";
			$this->pc_unit->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_unit->ViewValue = $this->highlightValue($this->pc_unit);

			// pc_w
			$this->pc_w->LinkCustomAttributes = "";
			$this->pc_w->HrefValue = "";
			$this->pc_w->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_w->ViewValue = $this->highlightValue($this->pc_w);

			// pc_l
			$this->pc_l->LinkCustomAttributes = "";
			$this->pc_l->HrefValue = "";
			$this->pc_l->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_l->ViewValue = $this->highlightValue($this->pc_l);

			// pc_h
			$this->pc_h->LinkCustomAttributes = "";
			$this->pc_h->HrefValue = "";
			$this->pc_h->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_h->ViewValue = $this->highlightValue($this->pc_h);

			// pc_partner_size
			$this->pc_partner_size->LinkCustomAttributes = "";
			$this->pc_partner_size->HrefValue = "";
			$this->pc_partner_size->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_partner_size->ViewValue = $this->highlightValue($this->pc_partner_size);

			// pc_sqm
			$this->pc_sqm->LinkCustomAttributes = "";
			$this->pc_sqm->HrefValue = "";
			$this->pc_sqm->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_sqm->ViewValue = $this->highlightValue($this->pc_sqm);

			// pc_01_head
			$this->pc_01_head->LinkCustomAttributes = "";
			$this->pc_01_head->HrefValue = "";
			$this->pc_01_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_01_head->ViewValue = $this->highlightValue($this->pc_01_head);

			// pc_02_head
			$this->pc_02_head->LinkCustomAttributes = "";
			$this->pc_02_head->HrefValue = "";
			$this->pc_02_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_02_head->ViewValue = $this->highlightValue($this->pc_02_head);

			// pc_03_head
			$this->pc_03_head->LinkCustomAttributes = "";
			$this->pc_03_head->HrefValue = "";
			$this->pc_03_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_03_head->ViewValue = $this->highlightValue($this->pc_03_head);

			// pc_04_head
			$this->pc_04_head->LinkCustomAttributes = "";
			$this->pc_04_head->HrefValue = "";
			$this->pc_04_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_04_head->ViewValue = $this->highlightValue($this->pc_04_head);

			// pc_05_head
			$this->pc_05_head->LinkCustomAttributes = "";
			$this->pc_05_head->HrefValue = "";
			$this->pc_05_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_05_head->ViewValue = $this->highlightValue($this->pc_05_head);

			// pc_06_head
			$this->pc_06_head->LinkCustomAttributes = "";
			$this->pc_06_head->HrefValue = "";
			$this->pc_06_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_06_head->ViewValue = $this->highlightValue($this->pc_06_head);

			// pc_07_head
			$this->pc_07_head->LinkCustomAttributes = "";
			$this->pc_07_head->HrefValue = "";
			$this->pc_07_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_07_head->ViewValue = $this->highlightValue($this->pc_07_head);

			// pc_08_head
			$this->pc_08_head->LinkCustomAttributes = "";
			$this->pc_08_head->HrefValue = "";
			$this->pc_08_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_08_head->ViewValue = $this->highlightValue($this->pc_08_head);

			// pc_09_head
			$this->pc_09_head->LinkCustomAttributes = "";
			$this->pc_09_head->HrefValue = "";
			$this->pc_09_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_09_head->ViewValue = $this->highlightValue($this->pc_09_head);

			// pc_10_head
			$this->pc_10_head->LinkCustomAttributes = "";
			$this->pc_10_head->HrefValue = "";
			$this->pc_10_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_10_head->ViewValue = $this->highlightValue($this->pc_10_head);

			// pc_11_head
			$this->pc_11_head->LinkCustomAttributes = "";
			$this->pc_11_head->HrefValue = "";
			$this->pc_11_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_11_head->ViewValue = $this->highlightValue($this->pc_11_head);

			// pc_12_head
			$this->pc_12_head->LinkCustomAttributes = "";
			$this->pc_12_head->HrefValue = "";
			$this->pc_12_head->TooltipValue = "";
			if (!$this->isExport())
				$this->pc_12_head->ViewValue = $this->highlightValue($this->pc_12_head);

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";
			if (!$this->isExport())
				$this->operator->ViewValue = $this->highlightValue($this->operator);

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "product_group_x" . $this->RowCnt . "_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// product_group
			$this->product_group->EditAttrs["class"] = "form-control";
			$this->product_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_group->AdvancedSearch->SearchValue = HtmlDecode($this->product_group->AdvancedSearch->SearchValue);
			$this->product_group->EditValue = HtmlEncode($this->product_group->AdvancedSearch->SearchValue);
			$this->product_group->PlaceHolder = RemoveHtml($this->product_group->caption());

			// calculation_method
			$this->calculation_method->EditAttrs["class"] = "form-control";
			$this->calculation_method->EditCustomAttributes = "";

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->shape->AdvancedSearch->SearchValue = HtmlDecode($this->shape->AdvancedSearch->SearchValue);
			$this->shape->EditValue = HtmlEncode($this->shape->AdvancedSearch->SearchValue);
			$this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sqm->AdvancedSearch->SearchValue = HtmlDecode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cbm->AdvancedSearch->SearchValue = HtmlDecode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// v_00
			$this->v_00->EditAttrs["class"] = "form-control";
			$this->v_00->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_00->AdvancedSearch->SearchValue = HtmlDecode($this->v_00->AdvancedSearch->SearchValue);
			$this->v_00->EditValue = HtmlEncode($this->v_00->AdvancedSearch->SearchValue);
			$this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

			// v_01
			$this->v_01->EditAttrs["class"] = "form-control";
			$this->v_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_01->AdvancedSearch->SearchValue = HtmlDecode($this->v_01->AdvancedSearch->SearchValue);
			$this->v_01->EditValue = HtmlEncode($this->v_01->AdvancedSearch->SearchValue);
			$this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

			// v_01_validation
			$this->v_01_validation->EditAttrs["class"] = "form-control";
			$this->v_01_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_01_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_01_validation->AdvancedSearch->SearchValue);
			$this->v_01_validation->EditValue = HtmlEncode($this->v_01_validation->AdvancedSearch->SearchValue);
			$this->v_01_validation->PlaceHolder = RemoveHtml($this->v_01_validation->caption());

			// v_02
			$this->v_02->EditAttrs["class"] = "form-control";
			$this->v_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_02->AdvancedSearch->SearchValue = HtmlDecode($this->v_02->AdvancedSearch->SearchValue);
			$this->v_02->EditValue = HtmlEncode($this->v_02->AdvancedSearch->SearchValue);
			$this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

			// v_02_validation
			$this->v_02_validation->EditAttrs["class"] = "form-control";
			$this->v_02_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_02_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_02_validation->AdvancedSearch->SearchValue);
			$this->v_02_validation->EditValue = HtmlEncode($this->v_02_validation->AdvancedSearch->SearchValue);
			$this->v_02_validation->PlaceHolder = RemoveHtml($this->v_02_validation->caption());

			// v_03
			$this->v_03->EditAttrs["class"] = "form-control";
			$this->v_03->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_03->AdvancedSearch->SearchValue = HtmlDecode($this->v_03->AdvancedSearch->SearchValue);
			$this->v_03->EditValue = HtmlEncode($this->v_03->AdvancedSearch->SearchValue);
			$this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

			// v_03_validation
			$this->v_03_validation->EditAttrs["class"] = "form-control";
			$this->v_03_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_03_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_03_validation->AdvancedSearch->SearchValue);
			$this->v_03_validation->EditValue = HtmlEncode($this->v_03_validation->AdvancedSearch->SearchValue);
			$this->v_03_validation->PlaceHolder = RemoveHtml($this->v_03_validation->caption());

			// v_04
			$this->v_04->EditAttrs["class"] = "form-control";
			$this->v_04->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_04->AdvancedSearch->SearchValue = HtmlDecode($this->v_04->AdvancedSearch->SearchValue);
			$this->v_04->EditValue = HtmlEncode($this->v_04->AdvancedSearch->SearchValue);
			$this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

			// v_04_validation
			$this->v_04_validation->EditAttrs["class"] = "form-control";
			$this->v_04_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_04_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_04_validation->AdvancedSearch->SearchValue);
			$this->v_04_validation->EditValue = HtmlEncode($this->v_04_validation->AdvancedSearch->SearchValue);
			$this->v_04_validation->PlaceHolder = RemoveHtml($this->v_04_validation->caption());

			// v_05
			$this->v_05->EditAttrs["class"] = "form-control";
			$this->v_05->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_05->AdvancedSearch->SearchValue = HtmlDecode($this->v_05->AdvancedSearch->SearchValue);
			$this->v_05->EditValue = HtmlEncode($this->v_05->AdvancedSearch->SearchValue);
			$this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

			// v_05_validation
			$this->v_05_validation->EditAttrs["class"] = "form-control";
			$this->v_05_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_05_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_05_validation->AdvancedSearch->SearchValue);
			$this->v_05_validation->EditValue = HtmlEncode($this->v_05_validation->AdvancedSearch->SearchValue);
			$this->v_05_validation->PlaceHolder = RemoveHtml($this->v_05_validation->caption());

			// v_06
			$this->v_06->EditAttrs["class"] = "form-control";
			$this->v_06->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_06->AdvancedSearch->SearchValue = HtmlDecode($this->v_06->AdvancedSearch->SearchValue);
			$this->v_06->EditValue = HtmlEncode($this->v_06->AdvancedSearch->SearchValue);
			$this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

			// v_06_validation
			$this->v_06_validation->EditAttrs["class"] = "form-control";
			$this->v_06_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_06_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_06_validation->AdvancedSearch->SearchValue);
			$this->v_06_validation->EditValue = HtmlEncode($this->v_06_validation->AdvancedSearch->SearchValue);
			$this->v_06_validation->PlaceHolder = RemoveHtml($this->v_06_validation->caption());

			// v_07
			$this->v_07->EditAttrs["class"] = "form-control";
			$this->v_07->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_07->AdvancedSearch->SearchValue = HtmlDecode($this->v_07->AdvancedSearch->SearchValue);
			$this->v_07->EditValue = HtmlEncode($this->v_07->AdvancedSearch->SearchValue);
			$this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

			// v_07_validation
			$this->v_07_validation->EditAttrs["class"] = "form-control";
			$this->v_07_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_07_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_07_validation->AdvancedSearch->SearchValue);
			$this->v_07_validation->EditValue = HtmlEncode($this->v_07_validation->AdvancedSearch->SearchValue);
			$this->v_07_validation->PlaceHolder = RemoveHtml($this->v_07_validation->caption());

			// v_08
			$this->v_08->EditAttrs["class"] = "form-control";
			$this->v_08->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_08->AdvancedSearch->SearchValue = HtmlDecode($this->v_08->AdvancedSearch->SearchValue);
			$this->v_08->EditValue = HtmlEncode($this->v_08->AdvancedSearch->SearchValue);
			$this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

			// v_08_validation
			$this->v_08_validation->EditAttrs["class"] = "form-control";
			$this->v_08_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_08_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_08_validation->AdvancedSearch->SearchValue);
			$this->v_08_validation->EditValue = HtmlEncode($this->v_08_validation->AdvancedSearch->SearchValue);
			$this->v_08_validation->PlaceHolder = RemoveHtml($this->v_08_validation->caption());

			// v_09
			$this->v_09->EditAttrs["class"] = "form-control";
			$this->v_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_09->AdvancedSearch->SearchValue = HtmlDecode($this->v_09->AdvancedSearch->SearchValue);
			$this->v_09->EditValue = HtmlEncode($this->v_09->AdvancedSearch->SearchValue);
			$this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

			// v_09_validation
			$this->v_09_validation->EditAttrs["class"] = "form-control";
			$this->v_09_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_09_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_09_validation->AdvancedSearch->SearchValue);
			$this->v_09_validation->EditValue = HtmlEncode($this->v_09_validation->AdvancedSearch->SearchValue);
			$this->v_09_validation->PlaceHolder = RemoveHtml($this->v_09_validation->caption());

			// v_10
			$this->v_10->EditAttrs["class"] = "form-control";
			$this->v_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_10->AdvancedSearch->SearchValue = HtmlDecode($this->v_10->AdvancedSearch->SearchValue);
			$this->v_10->EditValue = HtmlEncode($this->v_10->AdvancedSearch->SearchValue);
			$this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

			// v_10_validation
			$this->v_10_validation->EditAttrs["class"] = "form-control";
			$this->v_10_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_10_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_10_validation->AdvancedSearch->SearchValue);
			$this->v_10_validation->EditValue = HtmlEncode($this->v_10_validation->AdvancedSearch->SearchValue);
			$this->v_10_validation->PlaceHolder = RemoveHtml($this->v_10_validation->caption());

			// b_01_head
			$this->b_01_head->EditAttrs["class"] = "form-control";
			$this->b_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_01_head->AdvancedSearch->SearchValue);
			$this->b_01_head->EditValue = HtmlEncode($this->b_01_head->AdvancedSearch->SearchValue);
			$this->b_01_head->PlaceHolder = RemoveHtml($this->b_01_head->caption());

			// b_02_head
			$this->b_02_head->EditAttrs["class"] = "form-control";
			$this->b_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_02_head->AdvancedSearch->SearchValue);
			$this->b_02_head->EditValue = HtmlEncode($this->b_02_head->AdvancedSearch->SearchValue);
			$this->b_02_head->PlaceHolder = RemoveHtml($this->b_02_head->caption());

			// b_03_head
			$this->b_03_head->EditAttrs["class"] = "form-control";
			$this->b_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_03_head->AdvancedSearch->SearchValue);
			$this->b_03_head->EditValue = HtmlEncode($this->b_03_head->AdvancedSearch->SearchValue);
			$this->b_03_head->PlaceHolder = RemoveHtml($this->b_03_head->caption());

			// b_04_head
			$this->b_04_head->EditAttrs["class"] = "form-control";
			$this->b_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_04_head->AdvancedSearch->SearchValue);
			$this->b_04_head->EditValue = HtmlEncode($this->b_04_head->AdvancedSearch->SearchValue);
			$this->b_04_head->PlaceHolder = RemoveHtml($this->b_04_head->caption());

			// b_05_head
			$this->b_05_head->EditAttrs["class"] = "form-control";
			$this->b_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_05_head->AdvancedSearch->SearchValue);
			$this->b_05_head->EditValue = HtmlEncode($this->b_05_head->AdvancedSearch->SearchValue);
			$this->b_05_head->PlaceHolder = RemoveHtml($this->b_05_head->caption());

			// b_06_head
			$this->b_06_head->EditAttrs["class"] = "form-control";
			$this->b_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_06_head->AdvancedSearch->SearchValue);
			$this->b_06_head->EditValue = HtmlEncode($this->b_06_head->AdvancedSearch->SearchValue);
			$this->b_06_head->PlaceHolder = RemoveHtml($this->b_06_head->caption());

			// b_07_head
			$this->b_07_head->EditAttrs["class"] = "form-control";
			$this->b_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_07_head->AdvancedSearch->SearchValue);
			$this->b_07_head->EditValue = HtmlEncode($this->b_07_head->AdvancedSearch->SearchValue);
			$this->b_07_head->PlaceHolder = RemoveHtml($this->b_07_head->caption());

			// b_08_head
			$this->b_08_head->EditAttrs["class"] = "form-control";
			$this->b_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_08_head->AdvancedSearch->SearchValue);
			$this->b_08_head->EditValue = HtmlEncode($this->b_08_head->AdvancedSearch->SearchValue);
			$this->b_08_head->PlaceHolder = RemoveHtml($this->b_08_head->caption());

			// b_09_head
			$this->b_09_head->EditAttrs["class"] = "form-control";
			$this->b_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_09_head->AdvancedSearch->SearchValue);
			$this->b_09_head->EditValue = HtmlEncode($this->b_09_head->AdvancedSearch->SearchValue);
			$this->b_09_head->PlaceHolder = RemoveHtml($this->b_09_head->caption());

			// b_10_head
			$this->b_10_head->EditAttrs["class"] = "form-control";
			$this->b_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_10_head->AdvancedSearch->SearchValue);
			$this->b_10_head->EditValue = HtmlEncode($this->b_10_head->AdvancedSearch->SearchValue);
			$this->b_10_head->PlaceHolder = RemoveHtml($this->b_10_head->caption());

			// b_11_head
			$this->b_11_head->EditAttrs["class"] = "form-control";
			$this->b_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_11_head->AdvancedSearch->SearchValue);
			$this->b_11_head->EditValue = HtmlEncode($this->b_11_head->AdvancedSearch->SearchValue);
			$this->b_11_head->PlaceHolder = RemoveHtml($this->b_11_head->caption());

			// b_12_head
			$this->b_12_head->EditAttrs["class"] = "form-control";
			$this->b_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_12_head->AdvancedSearch->SearchValue);
			$this->b_12_head->EditValue = HtmlEncode($this->b_12_head->AdvancedSearch->SearchValue);
			$this->b_12_head->PlaceHolder = RemoveHtml($this->b_12_head->caption());

			// b_13_head
			$this->b_13_head->EditAttrs["class"] = "form-control";
			$this->b_13_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_13_head->AdvancedSearch->SearchValue);
			$this->b_13_head->EditValue = HtmlEncode($this->b_13_head->AdvancedSearch->SearchValue);
			$this->b_13_head->PlaceHolder = RemoveHtml($this->b_13_head->caption());

			// b_14_head
			$this->b_14_head->EditAttrs["class"] = "form-control";
			$this->b_14_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_14_head->AdvancedSearch->SearchValue);
			$this->b_14_head->EditValue = HtmlEncode($this->b_14_head->AdvancedSearch->SearchValue);
			$this->b_14_head->PlaceHolder = RemoveHtml($this->b_14_head->caption());

			// b_15_head
			$this->b_15_head->EditAttrs["class"] = "form-control";
			$this->b_15_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_15_head->AdvancedSearch->SearchValue);
			$this->b_15_head->EditValue = HtmlEncode($this->b_15_head->AdvancedSearch->SearchValue);
			$this->b_15_head->PlaceHolder = RemoveHtml($this->b_15_head->caption());

			// q_sku
			$this->q_sku->EditAttrs["class"] = "form-control";
			$this->q_sku->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->q_sku->AdvancedSearch->SearchValue = HtmlDecode($this->q_sku->AdvancedSearch->SearchValue);
			$this->q_sku->EditValue = HtmlEncode($this->q_sku->AdvancedSearch->SearchValue);
			$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

			// t_01_head
			$this->t_01_head->EditAttrs["class"] = "form-control";
			$this->t_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_01_head->AdvancedSearch->SearchValue);
			$this->t_01_head->EditValue = HtmlEncode($this->t_01_head->AdvancedSearch->SearchValue);
			$this->t_01_head->PlaceHolder = RemoveHtml($this->t_01_head->caption());

			// t_02_head
			$this->t_02_head->EditAttrs["class"] = "form-control";
			$this->t_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_02_head->AdvancedSearch->SearchValue);
			$this->t_02_head->EditValue = HtmlEncode($this->t_02_head->AdvancedSearch->SearchValue);
			$this->t_02_head->PlaceHolder = RemoveHtml($this->t_02_head->caption());

			// t_03_head
			$this->t_03_head->EditAttrs["class"] = "form-control";
			$this->t_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_03_head->AdvancedSearch->SearchValue);
			$this->t_03_head->EditValue = HtmlEncode($this->t_03_head->AdvancedSearch->SearchValue);
			$this->t_03_head->PlaceHolder = RemoveHtml($this->t_03_head->caption());

			// t_04_head
			$this->t_04_head->EditAttrs["class"] = "form-control";
			$this->t_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_04_head->AdvancedSearch->SearchValue);
			$this->t_04_head->EditValue = HtmlEncode($this->t_04_head->AdvancedSearch->SearchValue);
			$this->t_04_head->PlaceHolder = RemoveHtml($this->t_04_head->caption());

			// t_05_head
			$this->t_05_head->EditAttrs["class"] = "form-control";
			$this->t_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_05_head->AdvancedSearch->SearchValue);
			$this->t_05_head->EditValue = HtmlEncode($this->t_05_head->AdvancedSearch->SearchValue);
			$this->t_05_head->PlaceHolder = RemoveHtml($this->t_05_head->caption());

			// t_06_head
			$this->t_06_head->EditAttrs["class"] = "form-control";
			$this->t_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_06_head->AdvancedSearch->SearchValue);
			$this->t_06_head->EditValue = HtmlEncode($this->t_06_head->AdvancedSearch->SearchValue);
			$this->t_06_head->PlaceHolder = RemoveHtml($this->t_06_head->caption());

			// t_07_head
			$this->t_07_head->EditAttrs["class"] = "form-control";
			$this->t_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_07_head->AdvancedSearch->SearchValue);
			$this->t_07_head->EditValue = HtmlEncode($this->t_07_head->AdvancedSearch->SearchValue);
			$this->t_07_head->PlaceHolder = RemoveHtml($this->t_07_head->caption());

			// t_08_head
			$this->t_08_head->EditAttrs["class"] = "form-control";
			$this->t_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_08_head->AdvancedSearch->SearchValue);
			$this->t_08_head->EditValue = HtmlEncode($this->t_08_head->AdvancedSearch->SearchValue);
			$this->t_08_head->PlaceHolder = RemoveHtml($this->t_08_head->caption());

			// t_09_head
			$this->t_09_head->EditAttrs["class"] = "form-control";
			$this->t_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_09_head->AdvancedSearch->SearchValue);
			$this->t_09_head->EditValue = HtmlEncode($this->t_09_head->AdvancedSearch->SearchValue);
			$this->t_09_head->PlaceHolder = RemoveHtml($this->t_09_head->caption());

			// t_10_head
			$this->t_10_head->EditAttrs["class"] = "form-control";
			$this->t_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_10_head->AdvancedSearch->SearchValue);
			$this->t_10_head->EditValue = HtmlEncode($this->t_10_head->AdvancedSearch->SearchValue);
			$this->t_10_head->PlaceHolder = RemoveHtml($this->t_10_head->caption());

			// t_11_head
			$this->t_11_head->EditAttrs["class"] = "form-control";
			$this->t_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_11_head->AdvancedSearch->SearchValue);
			$this->t_11_head->EditValue = HtmlEncode($this->t_11_head->AdvancedSearch->SearchValue);
			$this->t_11_head->PlaceHolder = RemoveHtml($this->t_11_head->caption());

			// t_12_head
			$this->t_12_head->EditAttrs["class"] = "form-control";
			$this->t_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_12_head->AdvancedSearch->SearchValue);
			$this->t_12_head->EditValue = HtmlEncode($this->t_12_head->AdvancedSearch->SearchValue);
			$this->t_12_head->PlaceHolder = RemoveHtml($this->t_12_head->caption());

			// t_13_head
			$this->t_13_head->EditAttrs["class"] = "form-control";
			$this->t_13_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_13_head->AdvancedSearch->SearchValue);
			$this->t_13_head->EditValue = HtmlEncode($this->t_13_head->AdvancedSearch->SearchValue);
			$this->t_13_head->PlaceHolder = RemoveHtml($this->t_13_head->caption());

			// t_14_head
			$this->t_14_head->EditAttrs["class"] = "form-control";
			$this->t_14_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_14_head->AdvancedSearch->SearchValue);
			$this->t_14_head->EditValue = HtmlEncode($this->t_14_head->AdvancedSearch->SearchValue);
			$this->t_14_head->PlaceHolder = RemoveHtml($this->t_14_head->caption());

			// t_15_head
			$this->t_15_head->EditAttrs["class"] = "form-control";
			$this->t_15_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_15_head->AdvancedSearch->SearchValue);
			$this->t_15_head->EditValue = HtmlEncode($this->t_15_head->AdvancedSearch->SearchValue);
			$this->t_15_head->PlaceHolder = RemoveHtml($this->t_15_head->caption());

			// po_01_head
			$this->po_01_head->EditAttrs["class"] = "form-control";
			$this->po_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_01_head->AdvancedSearch->SearchValue);
			$this->po_01_head->EditValue = HtmlEncode($this->po_01_head->AdvancedSearch->SearchValue);
			$this->po_01_head->PlaceHolder = RemoveHtml($this->po_01_head->caption());

			// po_02_head
			$this->po_02_head->EditAttrs["class"] = "form-control";
			$this->po_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_02_head->AdvancedSearch->SearchValue);
			$this->po_02_head->EditValue = HtmlEncode($this->po_02_head->AdvancedSearch->SearchValue);
			$this->po_02_head->PlaceHolder = RemoveHtml($this->po_02_head->caption());

			// po_03_head
			$this->po_03_head->EditAttrs["class"] = "form-control";
			$this->po_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_03_head->AdvancedSearch->SearchValue);
			$this->po_03_head->EditValue = HtmlEncode($this->po_03_head->AdvancedSearch->SearchValue);
			$this->po_03_head->PlaceHolder = RemoveHtml($this->po_03_head->caption());

			// po_04_head
			$this->po_04_head->EditAttrs["class"] = "form-control";
			$this->po_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_04_head->AdvancedSearch->SearchValue);
			$this->po_04_head->EditValue = HtmlEncode($this->po_04_head->AdvancedSearch->SearchValue);
			$this->po_04_head->PlaceHolder = RemoveHtml($this->po_04_head->caption());

			// po_05_head
			$this->po_05_head->EditAttrs["class"] = "form-control";
			$this->po_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_05_head->AdvancedSearch->SearchValue);
			$this->po_05_head->EditValue = HtmlEncode($this->po_05_head->AdvancedSearch->SearchValue);
			$this->po_05_head->PlaceHolder = RemoveHtml($this->po_05_head->caption());

			// po_06_head
			$this->po_06_head->EditAttrs["class"] = "form-control";
			$this->po_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_06_head->AdvancedSearch->SearchValue);
			$this->po_06_head->EditValue = HtmlEncode($this->po_06_head->AdvancedSearch->SearchValue);
			$this->po_06_head->PlaceHolder = RemoveHtml($this->po_06_head->caption());

			// po_07_head
			$this->po_07_head->EditAttrs["class"] = "form-control";
			$this->po_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_07_head->AdvancedSearch->SearchValue);
			$this->po_07_head->EditValue = HtmlEncode($this->po_07_head->AdvancedSearch->SearchValue);
			$this->po_07_head->PlaceHolder = RemoveHtml($this->po_07_head->caption());

			// po_08_head
			$this->po_08_head->EditAttrs["class"] = "form-control";
			$this->po_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_08_head->AdvancedSearch->SearchValue);
			$this->po_08_head->EditValue = HtmlEncode($this->po_08_head->AdvancedSearch->SearchValue);
			$this->po_08_head->PlaceHolder = RemoveHtml($this->po_08_head->caption());

			// po_17_head
			$this->po_17_head->EditAttrs["class"] = "form-control";
			$this->po_17_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_17_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_17_head->AdvancedSearch->SearchValue);
			$this->po_17_head->EditValue = HtmlEncode($this->po_17_head->AdvancedSearch->SearchValue);
			$this->po_17_head->PlaceHolder = RemoveHtml($this->po_17_head->caption());

			// po_18_head
			$this->po_18_head->EditAttrs["class"] = "form-control";
			$this->po_18_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_18_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_18_head->AdvancedSearch->SearchValue);
			$this->po_18_head->EditValue = HtmlEncode($this->po_18_head->AdvancedSearch->SearchValue);
			$this->po_18_head->PlaceHolder = RemoveHtml($this->po_18_head->caption());

			// po_19_head
			$this->po_19_head->EditAttrs["class"] = "form-control";
			$this->po_19_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_19_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_19_head->AdvancedSearch->SearchValue);
			$this->po_19_head->EditValue = HtmlEncode($this->po_19_head->AdvancedSearch->SearchValue);
			$this->po_19_head->PlaceHolder = RemoveHtml($this->po_19_head->caption());

			// po_20_head
			$this->po_20_head->EditAttrs["class"] = "form-control";
			$this->po_20_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_20_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_20_head->AdvancedSearch->SearchValue);
			$this->po_20_head->EditValue = HtmlEncode($this->po_20_head->AdvancedSearch->SearchValue);
			$this->po_20_head->PlaceHolder = RemoveHtml($this->po_20_head->caption());

			// jc_01_head
			$this->jc_01_head->EditAttrs["class"] = "form-control";
			$this->jc_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_01_head->AdvancedSearch->SearchValue);
			$this->jc_01_head->EditValue = HtmlEncode($this->jc_01_head->AdvancedSearch->SearchValue);
			$this->jc_01_head->PlaceHolder = RemoveHtml($this->jc_01_head->caption());

			// jc_02_head
			$this->jc_02_head->EditAttrs["class"] = "form-control";
			$this->jc_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_02_head->AdvancedSearch->SearchValue);
			$this->jc_02_head->EditValue = HtmlEncode($this->jc_02_head->AdvancedSearch->SearchValue);
			$this->jc_02_head->PlaceHolder = RemoveHtml($this->jc_02_head->caption());

			// jc_03_head
			$this->jc_03_head->EditAttrs["class"] = "form-control";
			$this->jc_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_03_head->AdvancedSearch->SearchValue);
			$this->jc_03_head->EditValue = HtmlEncode($this->jc_03_head->AdvancedSearch->SearchValue);
			$this->jc_03_head->PlaceHolder = RemoveHtml($this->jc_03_head->caption());

			// jc_04_head
			$this->jc_04_head->EditAttrs["class"] = "form-control";
			$this->jc_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_04_head->AdvancedSearch->SearchValue);
			$this->jc_04_head->EditValue = HtmlEncode($this->jc_04_head->AdvancedSearch->SearchValue);
			$this->jc_04_head->PlaceHolder = RemoveHtml($this->jc_04_head->caption());

			// jc_05_head
			$this->jc_05_head->EditAttrs["class"] = "form-control";
			$this->jc_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_05_head->AdvancedSearch->SearchValue);
			$this->jc_05_head->EditValue = HtmlEncode($this->jc_05_head->AdvancedSearch->SearchValue);
			$this->jc_05_head->PlaceHolder = RemoveHtml($this->jc_05_head->caption());

			// jc_06_head
			$this->jc_06_head->EditAttrs["class"] = "form-control";
			$this->jc_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_06_head->AdvancedSearch->SearchValue);
			$this->jc_06_head->EditValue = HtmlEncode($this->jc_06_head->AdvancedSearch->SearchValue);
			$this->jc_06_head->PlaceHolder = RemoveHtml($this->jc_06_head->caption());

			// jc_07_head
			$this->jc_07_head->EditAttrs["class"] = "form-control";
			$this->jc_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_07_head->AdvancedSearch->SearchValue);
			$this->jc_07_head->EditValue = HtmlEncode($this->jc_07_head->AdvancedSearch->SearchValue);
			$this->jc_07_head->PlaceHolder = RemoveHtml($this->jc_07_head->caption());

			// jc_08_head
			$this->jc_08_head->EditAttrs["class"] = "form-control";
			$this->jc_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_08_head->AdvancedSearch->SearchValue);
			$this->jc_08_head->EditValue = HtmlEncode($this->jc_08_head->AdvancedSearch->SearchValue);
			$this->jc_08_head->PlaceHolder = RemoveHtml($this->jc_08_head->caption());

			// jc_09_head
			$this->jc_09_head->EditAttrs["class"] = "form-control";
			$this->jc_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_09_head->AdvancedSearch->SearchValue);
			$this->jc_09_head->EditValue = HtmlEncode($this->jc_09_head->AdvancedSearch->SearchValue);
			$this->jc_09_head->PlaceHolder = RemoveHtml($this->jc_09_head->caption());

			// jc_10_head
			$this->jc_10_head->EditAttrs["class"] = "form-control";
			$this->jc_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_10_head->AdvancedSearch->SearchValue);
			$this->jc_10_head->EditValue = HtmlEncode($this->jc_10_head->AdvancedSearch->SearchValue);
			$this->jc_10_head->PlaceHolder = RemoveHtml($this->jc_10_head->caption());

			// pc_shape
			$this->pc_shape->EditAttrs["class"] = "form-control";
			$this->pc_shape->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_shape->AdvancedSearch->SearchValue = HtmlDecode($this->pc_shape->AdvancedSearch->SearchValue);
			$this->pc_shape->EditValue = HtmlEncode($this->pc_shape->AdvancedSearch->SearchValue);
			$this->pc_shape->PlaceHolder = RemoveHtml($this->pc_shape->caption());

			// pc_unit
			$this->pc_unit->EditAttrs["class"] = "form-control";
			$this->pc_unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_unit->AdvancedSearch->SearchValue = HtmlDecode($this->pc_unit->AdvancedSearch->SearchValue);
			$this->pc_unit->EditValue = HtmlEncode($this->pc_unit->AdvancedSearch->SearchValue);
			$this->pc_unit->PlaceHolder = RemoveHtml($this->pc_unit->caption());

			// pc_w
			$this->pc_w->EditAttrs["class"] = "form-control";
			$this->pc_w->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_w->AdvancedSearch->SearchValue = HtmlDecode($this->pc_w->AdvancedSearch->SearchValue);
			$this->pc_w->EditValue = HtmlEncode($this->pc_w->AdvancedSearch->SearchValue);
			$this->pc_w->PlaceHolder = RemoveHtml($this->pc_w->caption());

			// pc_l
			$this->pc_l->EditAttrs["class"] = "form-control";
			$this->pc_l->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_l->AdvancedSearch->SearchValue = HtmlDecode($this->pc_l->AdvancedSearch->SearchValue);
			$this->pc_l->EditValue = HtmlEncode($this->pc_l->AdvancedSearch->SearchValue);
			$this->pc_l->PlaceHolder = RemoveHtml($this->pc_l->caption());

			// pc_h
			$this->pc_h->EditAttrs["class"] = "form-control";
			$this->pc_h->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_h->AdvancedSearch->SearchValue = HtmlDecode($this->pc_h->AdvancedSearch->SearchValue);
			$this->pc_h->EditValue = HtmlEncode($this->pc_h->AdvancedSearch->SearchValue);
			$this->pc_h->PlaceHolder = RemoveHtml($this->pc_h->caption());

			// pc_partner_size
			$this->pc_partner_size->EditAttrs["class"] = "form-control";
			$this->pc_partner_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_partner_size->AdvancedSearch->SearchValue = HtmlDecode($this->pc_partner_size->AdvancedSearch->SearchValue);
			$this->pc_partner_size->EditValue = HtmlEncode($this->pc_partner_size->AdvancedSearch->SearchValue);
			$this->pc_partner_size->PlaceHolder = RemoveHtml($this->pc_partner_size->caption());

			// pc_sqm
			$this->pc_sqm->EditAttrs["class"] = "form-control";
			$this->pc_sqm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_sqm->AdvancedSearch->SearchValue = HtmlDecode($this->pc_sqm->AdvancedSearch->SearchValue);
			$this->pc_sqm->EditValue = HtmlEncode($this->pc_sqm->AdvancedSearch->SearchValue);
			$this->pc_sqm->PlaceHolder = RemoveHtml($this->pc_sqm->caption());

			// pc_01_head
			$this->pc_01_head->EditAttrs["class"] = "form-control";
			$this->pc_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_01_head->AdvancedSearch->SearchValue);
			$this->pc_01_head->EditValue = HtmlEncode($this->pc_01_head->AdvancedSearch->SearchValue);
			$this->pc_01_head->PlaceHolder = RemoveHtml($this->pc_01_head->caption());

			// pc_02_head
			$this->pc_02_head->EditAttrs["class"] = "form-control";
			$this->pc_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_02_head->AdvancedSearch->SearchValue);
			$this->pc_02_head->EditValue = HtmlEncode($this->pc_02_head->AdvancedSearch->SearchValue);
			$this->pc_02_head->PlaceHolder = RemoveHtml($this->pc_02_head->caption());

			// pc_03_head
			$this->pc_03_head->EditAttrs["class"] = "form-control";
			$this->pc_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_03_head->AdvancedSearch->SearchValue);
			$this->pc_03_head->EditValue = HtmlEncode($this->pc_03_head->AdvancedSearch->SearchValue);
			$this->pc_03_head->PlaceHolder = RemoveHtml($this->pc_03_head->caption());

			// pc_04_head
			$this->pc_04_head->EditAttrs["class"] = "form-control";
			$this->pc_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_04_head->AdvancedSearch->SearchValue);
			$this->pc_04_head->EditValue = HtmlEncode($this->pc_04_head->AdvancedSearch->SearchValue);
			$this->pc_04_head->PlaceHolder = RemoveHtml($this->pc_04_head->caption());

			// pc_05_head
			$this->pc_05_head->EditAttrs["class"] = "form-control";
			$this->pc_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_05_head->AdvancedSearch->SearchValue);
			$this->pc_05_head->EditValue = HtmlEncode($this->pc_05_head->AdvancedSearch->SearchValue);
			$this->pc_05_head->PlaceHolder = RemoveHtml($this->pc_05_head->caption());

			// pc_06_head
			$this->pc_06_head->EditAttrs["class"] = "form-control";
			$this->pc_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_06_head->AdvancedSearch->SearchValue);
			$this->pc_06_head->EditValue = HtmlEncode($this->pc_06_head->AdvancedSearch->SearchValue);
			$this->pc_06_head->PlaceHolder = RemoveHtml($this->pc_06_head->caption());

			// pc_07_head
			$this->pc_07_head->EditAttrs["class"] = "form-control";
			$this->pc_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_07_head->AdvancedSearch->SearchValue);
			$this->pc_07_head->EditValue = HtmlEncode($this->pc_07_head->AdvancedSearch->SearchValue);
			$this->pc_07_head->PlaceHolder = RemoveHtml($this->pc_07_head->caption());

			// pc_08_head
			$this->pc_08_head->EditAttrs["class"] = "form-control";
			$this->pc_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_08_head->AdvancedSearch->SearchValue);
			$this->pc_08_head->EditValue = HtmlEncode($this->pc_08_head->AdvancedSearch->SearchValue);
			$this->pc_08_head->PlaceHolder = RemoveHtml($this->pc_08_head->caption());

			// pc_09_head
			$this->pc_09_head->EditAttrs["class"] = "form-control";
			$this->pc_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_09_head->AdvancedSearch->SearchValue);
			$this->pc_09_head->EditValue = HtmlEncode($this->pc_09_head->AdvancedSearch->SearchValue);
			$this->pc_09_head->PlaceHolder = RemoveHtml($this->pc_09_head->caption());

			// pc_10_head
			$this->pc_10_head->EditAttrs["class"] = "form-control";
			$this->pc_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_10_head->AdvancedSearch->SearchValue);
			$this->pc_10_head->EditValue = HtmlEncode($this->pc_10_head->AdvancedSearch->SearchValue);
			$this->pc_10_head->PlaceHolder = RemoveHtml($this->pc_10_head->caption());

			// pc_11_head
			$this->pc_11_head->EditAttrs["class"] = "form-control";
			$this->pc_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_11_head->AdvancedSearch->SearchValue);
			$this->pc_11_head->EditValue = HtmlEncode($this->pc_11_head->AdvancedSearch->SearchValue);
			$this->pc_11_head->PlaceHolder = RemoveHtml($this->pc_11_head->caption());

			// pc_12_head
			$this->pc_12_head->EditAttrs["class"] = "form-control";
			$this->pc_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_12_head->AdvancedSearch->SearchValue);
			$this->pc_12_head->EditValue = HtmlEncode($this->pc_12_head->AdvancedSearch->SearchValue);
			$this->pc_12_head->PlaceHolder = RemoveHtml($this->pc_12_head->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
			$this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
			$this->image->PlaceHolder = RemoveHtml($this->image->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->product_group->AdvancedSearch->load();
		$this->calculation_method->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->v_00->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_01_validation->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_02_validation->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_03_validation->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_04_validation->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->v_05_validation->AdvancedSearch->load();
		$this->v_06->AdvancedSearch->load();
		$this->v_06_validation->AdvancedSearch->load();
		$this->v_07->AdvancedSearch->load();
		$this->v_07_validation->AdvancedSearch->load();
		$this->v_08->AdvancedSearch->load();
		$this->v_08_validation->AdvancedSearch->load();
		$this->v_09->AdvancedSearch->load();
		$this->v_09_validation->AdvancedSearch->load();
		$this->v_10->AdvancedSearch->load();
		$this->v_10_validation->AdvancedSearch->load();
		$this->b_01_head->AdvancedSearch->load();
		$this->b_02_head->AdvancedSearch->load();
		$this->b_03_head->AdvancedSearch->load();
		$this->b_04_head->AdvancedSearch->load();
		$this->b_05_head->AdvancedSearch->load();
		$this->b_06_head->AdvancedSearch->load();
		$this->b_07_head->AdvancedSearch->load();
		$this->b_08_head->AdvancedSearch->load();
		$this->b_09_head->AdvancedSearch->load();
		$this->b_10_head->AdvancedSearch->load();
		$this->b_11_head->AdvancedSearch->load();
		$this->b_12_head->AdvancedSearch->load();
		$this->b_13_head->AdvancedSearch->load();
		$this->b_14_head->AdvancedSearch->load();
		$this->b_15_head->AdvancedSearch->load();
		$this->q_sku->AdvancedSearch->load();
		$this->t_01_head->AdvancedSearch->load();
		$this->t_02_head->AdvancedSearch->load();
		$this->t_03_head->AdvancedSearch->load();
		$this->t_04_head->AdvancedSearch->load();
		$this->t_05_head->AdvancedSearch->load();
		$this->t_06_head->AdvancedSearch->load();
		$this->t_07_head->AdvancedSearch->load();
		$this->t_08_head->AdvancedSearch->load();
		$this->t_09_head->AdvancedSearch->load();
		$this->t_10_head->AdvancedSearch->load();
		$this->t_11_head->AdvancedSearch->load();
		$this->t_12_head->AdvancedSearch->load();
		$this->t_13_head->AdvancedSearch->load();
		$this->t_14_head->AdvancedSearch->load();
		$this->t_15_head->AdvancedSearch->load();
		$this->po_01_head->AdvancedSearch->load();
		$this->po_02_head->AdvancedSearch->load();
		$this->po_03_head->AdvancedSearch->load();
		$this->po_04_head->AdvancedSearch->load();
		$this->po_05_head->AdvancedSearch->load();
		$this->po_06_head->AdvancedSearch->load();
		$this->po_07_head->AdvancedSearch->load();
		$this->po_08_head->AdvancedSearch->load();
		$this->po_17_head->AdvancedSearch->load();
		$this->po_18_head->AdvancedSearch->load();
		$this->po_19_head->AdvancedSearch->load();
		$this->po_20_head->AdvancedSearch->load();
		$this->jc_01_head->AdvancedSearch->load();
		$this->jc_02_head->AdvancedSearch->load();
		$this->jc_03_head->AdvancedSearch->load();
		$this->jc_04_head->AdvancedSearch->load();
		$this->jc_05_head->AdvancedSearch->load();
		$this->jc_06_head->AdvancedSearch->load();
		$this->jc_07_head->AdvancedSearch->load();
		$this->jc_08_head->AdvancedSearch->load();
		$this->jc_09_head->AdvancedSearch->load();
		$this->jc_10_head->AdvancedSearch->load();
		$this->pc_shape->AdvancedSearch->load();
		$this->pc_unit->AdvancedSearch->load();
		$this->pc_w->AdvancedSearch->load();
		$this->pc_l->AdvancedSearch->load();
		$this->pc_h->AdvancedSearch->load();
		$this->pc_partner_size->AdvancedSearch->load();
		$this->pc_sqm->AdvancedSearch->load();
		$this->pc_01_head->AdvancedSearch->load();
		$this->pc_02_head->AdvancedSearch->load();
		$this->pc_03_head->AdvancedSearch->load();
		$this->pc_04_head->AdvancedSearch->load();
		$this->pc_05_head->AdvancedSearch->load();
		$this->pc_06_head->AdvancedSearch->load();
		$this->pc_07_head->AdvancedSearch->load();
		$this->pc_08_head->AdvancedSearch->load();
		$this->pc_09_head->AdvancedSearch->load();
		$this->pc_10_head->AdvancedSearch->load();
		$this->pc_11_head->AdvancedSearch->load();
		$this->pc_12_head->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fproduct_grouplist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fproduct_grouplist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fproduct_grouplist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_product_group\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_product_group',hdr:ew.language.phrase('ExportToEmailText'),f:document.fproduct_grouplist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_calculation_method":
							break;
						case "x_process":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {
		if (CurrentUserID() == '-1')
		$msg = "<a href=\"autoprogramme.php?ac=93e87919d9c89e6459f4fbd0b03b5bc0&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1\" class=\"btn btn-danger ew-action\" style=\"color:blue\">Import from INT_Fibre (Missing)</a>";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		if (CurrentUserID() !=  -1)
		{
			$this->OtherOptions["addedit"]->Items["add"]->Visible = False;
		}
		if (CurrentUserID() == '-1')
		{
			$item = &$this->OtherOptions['action']->Add("Import from INT_Fibre (Missing)");
			$item->Body = "<a href=\"autoprogramme.php?ac=93e87919d9c89e6459f4fbd0b03b5bc0&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1\" class=\"btn btn-danger ew-action\" style=\"color:blue\">Import from INT_Fibre (Missing)</a>";
		$item->Visible = True;
		}
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

		$IDS = ExecuteRow("SELECT ifnull(GROUP_CONCAT(`grp`.`id`),0) as `ids` FROM `product_group` left join `int_fibre_product_group` on `int_fibre_product_group`.id = `product_group`.`id` where `int_fibre_product_group`.`product_group` != `product_group`.`product_group` || `int_fibre_product_group`.`id` is null");
	$ID = $IDS['ids'];
	$mismatch =  explode(",", $ID);
		if ((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $mismatch)))
		{
			$this->ListOptions->Add("Update to INT_Fibre (Export)"); // Replace abclink with your name of the link
			$this->ListOptions->Items["Update to INT_Fibre (Export)"]->Body ='<a href="autoprogramme.php?ac=6bd9e83aef373774188a51f80463f37b&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1&id=' . $this->id->CurrentValue . '" data-original-title ="Update to INT_Fibre (Export)"><i data-phrase="Update to INT_Fibre (Export)"  class="fa fa-recycle ew-icon" style="color:red"></i></a>';
			$NIDS = ExecuteRow("SELECT ifnull(GROUP_CONCAT(`grp`.`id`),0) as `ids` FROM `product_group` left join `int_fibre_product_group` on `int_fibre_product_group`.id = `product_group`.`id` where `int_fibre_product_group`.`id` is null");
			$NID = $NIDS['ids'];
			$Nmismatch =  explode(",", $NID);
			if (((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $Nmismatch))) === false)
			{
				$this->ListOptions->Add("Update from INT_Fibre (Import)"); // Replace abclink with your name of the link
				$this->ListOptions->Items["Update from INT_Fibre (Import)"]->Body ='<a href="autoprogramme.php?ac=fa6c0ebbc86ee0d9d7ed3e7b4fdbf486&apcid=d5cb15b7eceeb8965bb6937b1f34cfc1&id=' . $this->id->CurrentValue . '" data-original-title ="Update from INT_Fibre (Import)"><i data-phrase="Update from INT_Fibre (Import)"  class="fa fa-sign-in ew-icon" style="color:blue"></i></a>';
			}
		}
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>