<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_group_search extends product_group
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_group';

	// Page object name
	public $PageObjName = "product_group_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_group)
		if (!isset($GLOBALS["product_group"]) || get_class($GLOBALS["product_group"]) == PROJECT_NAMESPACE . "product_group") {
			$GLOBALS["product_group"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["product_group"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $product_group;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_group);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "product_groupview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("product_grouplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->product_group->setVisibility();
		$this->calculation_method->setVisibility();
		$this->shape->setVisibility();
		$this->sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->process->setVisibility();
		$this->status->setVisibility();
		$this->v_00->setVisibility();
		$this->v_01->setVisibility();
		$this->v_01_validation->setVisibility();
		$this->v_02->setVisibility();
		$this->v_02_validation->setVisibility();
		$this->v_03->setVisibility();
		$this->v_03_validation->setVisibility();
		$this->v_04->setVisibility();
		$this->v_04_validation->setVisibility();
		$this->v_05->setVisibility();
		$this->v_05_validation->setVisibility();
		$this->v_06->setVisibility();
		$this->v_06_validation->setVisibility();
		$this->v_07->setVisibility();
		$this->v_07_validation->setVisibility();
		$this->v_08->setVisibility();
		$this->v_08_validation->setVisibility();
		$this->v_09->setVisibility();
		$this->v_09_validation->setVisibility();
		$this->v_10->setVisibility();
		$this->v_10_validation->setVisibility();
		$this->b_01_head->setVisibility();
		$this->b_02_head->setVisibility();
		$this->b_03_head->setVisibility();
		$this->b_04_head->setVisibility();
		$this->b_05_head->setVisibility();
		$this->b_06_head->setVisibility();
		$this->b_07_head->setVisibility();
		$this->b_08_head->setVisibility();
		$this->b_09_head->setVisibility();
		$this->b_10_head->setVisibility();
		$this->b_11_head->setVisibility();
		$this->b_12_head->setVisibility();
		$this->b_13_head->setVisibility();
		$this->b_14_head->setVisibility();
		$this->b_15_head->setVisibility();
		$this->q_sku->setVisibility();
		$this->t_01_head->setVisibility();
		$this->t_02_head->setVisibility();
		$this->t_03_head->setVisibility();
		$this->t_04_head->setVisibility();
		$this->t_05_head->setVisibility();
		$this->t_06_head->setVisibility();
		$this->t_07_head->setVisibility();
		$this->t_08_head->setVisibility();
		$this->t_09_head->setVisibility();
		$this->t_10_head->setVisibility();
		$this->t_11_head->setVisibility();
		$this->t_12_head->setVisibility();
		$this->t_13_head->setVisibility();
		$this->t_14_head->setVisibility();
		$this->t_15_head->setVisibility();
		$this->po_01_head->setVisibility();
		$this->po_02_head->setVisibility();
		$this->po_03_head->setVisibility();
		$this->po_04_head->setVisibility();
		$this->po_05_head->setVisibility();
		$this->po_06_head->setVisibility();
		$this->po_07_head->setVisibility();
		$this->po_08_head->setVisibility();
		$this->po_17_head->setVisibility();
		$this->po_18_head->setVisibility();
		$this->po_19_head->setVisibility();
		$this->po_20_head->setVisibility();
		$this->jc_01_head->setVisibility();
		$this->jc_02_head->setVisibility();
		$this->jc_03_head->setVisibility();
		$this->jc_04_head->setVisibility();
		$this->jc_05_head->setVisibility();
		$this->jc_06_head->setVisibility();
		$this->jc_07_head->setVisibility();
		$this->jc_08_head->setVisibility();
		$this->jc_09_head->setVisibility();
		$this->jc_10_head->setVisibility();
		$this->pc_shape->setVisibility();
		$this->pc_unit->setVisibility();
		$this->pc_w->setVisibility();
		$this->pc_l->setVisibility();
		$this->pc_h->setVisibility();
		$this->pc_partner_size->setVisibility();
		$this->pc_sqm->setVisibility();
		$this->pc_01_head->setVisibility();
		$this->pc_02_head->setVisibility();
		$this->pc_03_head->setVisibility();
		$this->pc_04_head->setVisibility();
		$this->pc_05_head->setVisibility();
		$this->pc_06_head->setVisibility();
		$this->pc_07_head->setVisibility();
		$this->pc_08_head->setVisibility();
		$this->pc_09_head->setVisibility();
		$this->pc_10_head->setVisibility();
		$this->pc_11_head->setVisibility();
		$this->pc_12_head->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->image->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->calculation_method);
		$this->setupLookupOptions($this->process);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "product_grouplist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->product_group); // product_group
		$this->buildSearchUrl($srchUrl, $this->calculation_method); // calculation_method
		$this->buildSearchUrl($srchUrl, $this->shape); // shape
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->cbm); // cbm
		$this->buildSearchUrl($srchUrl, $this->process); // process
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->v_00); // v_00
		$this->buildSearchUrl($srchUrl, $this->v_01); // v_01
		$this->buildSearchUrl($srchUrl, $this->v_01_validation); // v_01_validation
		$this->buildSearchUrl($srchUrl, $this->v_02); // v_02
		$this->buildSearchUrl($srchUrl, $this->v_02_validation); // v_02_validation
		$this->buildSearchUrl($srchUrl, $this->v_03); // v_03
		$this->buildSearchUrl($srchUrl, $this->v_03_validation); // v_03_validation
		$this->buildSearchUrl($srchUrl, $this->v_04); // v_04
		$this->buildSearchUrl($srchUrl, $this->v_04_validation); // v_04_validation
		$this->buildSearchUrl($srchUrl, $this->v_05); // v_05
		$this->buildSearchUrl($srchUrl, $this->v_05_validation); // v_05_validation
		$this->buildSearchUrl($srchUrl, $this->v_06); // v_06
		$this->buildSearchUrl($srchUrl, $this->v_06_validation); // v_06_validation
		$this->buildSearchUrl($srchUrl, $this->v_07); // v_07
		$this->buildSearchUrl($srchUrl, $this->v_07_validation); // v_07_validation
		$this->buildSearchUrl($srchUrl, $this->v_08); // v_08
		$this->buildSearchUrl($srchUrl, $this->v_08_validation); // v_08_validation
		$this->buildSearchUrl($srchUrl, $this->v_09); // v_09
		$this->buildSearchUrl($srchUrl, $this->v_09_validation); // v_09_validation
		$this->buildSearchUrl($srchUrl, $this->v_10); // v_10
		$this->buildSearchUrl($srchUrl, $this->v_10_validation); // v_10_validation
		$this->buildSearchUrl($srchUrl, $this->b_01_head); // b_01_head
		$this->buildSearchUrl($srchUrl, $this->b_02_head); // b_02_head
		$this->buildSearchUrl($srchUrl, $this->b_03_head); // b_03_head
		$this->buildSearchUrl($srchUrl, $this->b_04_head); // b_04_head
		$this->buildSearchUrl($srchUrl, $this->b_05_head); // b_05_head
		$this->buildSearchUrl($srchUrl, $this->b_06_head); // b_06_head
		$this->buildSearchUrl($srchUrl, $this->b_07_head); // b_07_head
		$this->buildSearchUrl($srchUrl, $this->b_08_head); // b_08_head
		$this->buildSearchUrl($srchUrl, $this->b_09_head); // b_09_head
		$this->buildSearchUrl($srchUrl, $this->b_10_head); // b_10_head
		$this->buildSearchUrl($srchUrl, $this->b_11_head); // b_11_head
		$this->buildSearchUrl($srchUrl, $this->b_12_head); // b_12_head
		$this->buildSearchUrl($srchUrl, $this->b_13_head); // b_13_head
		$this->buildSearchUrl($srchUrl, $this->b_14_head); // b_14_head
		$this->buildSearchUrl($srchUrl, $this->b_15_head); // b_15_head
		$this->buildSearchUrl($srchUrl, $this->q_sku); // q_sku
		$this->buildSearchUrl($srchUrl, $this->t_01_head); // t_01_head
		$this->buildSearchUrl($srchUrl, $this->t_02_head); // t_02_head
		$this->buildSearchUrl($srchUrl, $this->t_03_head); // t_03_head
		$this->buildSearchUrl($srchUrl, $this->t_04_head); // t_04_head
		$this->buildSearchUrl($srchUrl, $this->t_05_head); // t_05_head
		$this->buildSearchUrl($srchUrl, $this->t_06_head); // t_06_head
		$this->buildSearchUrl($srchUrl, $this->t_07_head); // t_07_head
		$this->buildSearchUrl($srchUrl, $this->t_08_head); // t_08_head
		$this->buildSearchUrl($srchUrl, $this->t_09_head); // t_09_head
		$this->buildSearchUrl($srchUrl, $this->t_10_head); // t_10_head
		$this->buildSearchUrl($srchUrl, $this->t_11_head); // t_11_head
		$this->buildSearchUrl($srchUrl, $this->t_12_head); // t_12_head
		$this->buildSearchUrl($srchUrl, $this->t_13_head); // t_13_head
		$this->buildSearchUrl($srchUrl, $this->t_14_head); // t_14_head
		$this->buildSearchUrl($srchUrl, $this->t_15_head); // t_15_head
		$this->buildSearchUrl($srchUrl, $this->po_01_head); // po_01_head
		$this->buildSearchUrl($srchUrl, $this->po_02_head); // po_02_head
		$this->buildSearchUrl($srchUrl, $this->po_03_head); // po_03_head
		$this->buildSearchUrl($srchUrl, $this->po_04_head); // po_04_head
		$this->buildSearchUrl($srchUrl, $this->po_05_head); // po_05_head
		$this->buildSearchUrl($srchUrl, $this->po_06_head); // po_06_head
		$this->buildSearchUrl($srchUrl, $this->po_07_head); // po_07_head
		$this->buildSearchUrl($srchUrl, $this->po_08_head); // po_08_head
		$this->buildSearchUrl($srchUrl, $this->po_17_head); // po_17_head
		$this->buildSearchUrl($srchUrl, $this->po_18_head); // po_18_head
		$this->buildSearchUrl($srchUrl, $this->po_19_head); // po_19_head
		$this->buildSearchUrl($srchUrl, $this->po_20_head); // po_20_head
		$this->buildSearchUrl($srchUrl, $this->jc_01_head); // jc_01_head
		$this->buildSearchUrl($srchUrl, $this->jc_02_head); // jc_02_head
		$this->buildSearchUrl($srchUrl, $this->jc_03_head); // jc_03_head
		$this->buildSearchUrl($srchUrl, $this->jc_04_head); // jc_04_head
		$this->buildSearchUrl($srchUrl, $this->jc_05_head); // jc_05_head
		$this->buildSearchUrl($srchUrl, $this->jc_06_head); // jc_06_head
		$this->buildSearchUrl($srchUrl, $this->jc_07_head); // jc_07_head
		$this->buildSearchUrl($srchUrl, $this->jc_08_head); // jc_08_head
		$this->buildSearchUrl($srchUrl, $this->jc_09_head); // jc_09_head
		$this->buildSearchUrl($srchUrl, $this->jc_10_head); // jc_10_head
		$this->buildSearchUrl($srchUrl, $this->pc_shape); // pc_shape
		$this->buildSearchUrl($srchUrl, $this->pc_unit); // pc_unit
		$this->buildSearchUrl($srchUrl, $this->pc_w); // pc_w
		$this->buildSearchUrl($srchUrl, $this->pc_l); // pc_l
		$this->buildSearchUrl($srchUrl, $this->pc_h); // pc_h
		$this->buildSearchUrl($srchUrl, $this->pc_partner_size); // pc_partner_size
		$this->buildSearchUrl($srchUrl, $this->pc_sqm); // pc_sqm
		$this->buildSearchUrl($srchUrl, $this->pc_01_head); // pc_01_head
		$this->buildSearchUrl($srchUrl, $this->pc_02_head); // pc_02_head
		$this->buildSearchUrl($srchUrl, $this->pc_03_head); // pc_03_head
		$this->buildSearchUrl($srchUrl, $this->pc_04_head); // pc_04_head
		$this->buildSearchUrl($srchUrl, $this->pc_05_head); // pc_05_head
		$this->buildSearchUrl($srchUrl, $this->pc_06_head); // pc_06_head
		$this->buildSearchUrl($srchUrl, $this->pc_07_head); // pc_07_head
		$this->buildSearchUrl($srchUrl, $this->pc_08_head); // pc_08_head
		$this->buildSearchUrl($srchUrl, $this->pc_09_head); // pc_09_head
		$this->buildSearchUrl($srchUrl, $this->pc_10_head); // pc_10_head
		$this->buildSearchUrl($srchUrl, $this->pc_11_head); // pc_11_head
		$this->buildSearchUrl($srchUrl, $this->pc_12_head); // pc_12_head
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->image); // image
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// product_group
		if (!$this->isAddOrEdit())
			$this->product_group->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_group"));
		$this->product_group->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_group"));

		// calculation_method
		if (!$this->isAddOrEdit())
			$this->calculation_method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_calculation_method"));
		$this->calculation_method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_calculation_method"));

		// shape
		if (!$this->isAddOrEdit())
			$this->shape->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shape"));
		$this->shape->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shape"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cbm"));
		$this->cbm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cbm"));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process"));
		$this->process->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// v_00
		if (!$this->isAddOrEdit())
			$this->v_00->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_00"));
		$this->v_00->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_00"));

		// v_01
		if (!$this->isAddOrEdit())
			$this->v_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_01"));
		$this->v_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_01"));

		// v_01_validation
		if (!$this->isAddOrEdit())
			$this->v_01_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_01_validation"));
		$this->v_01_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_01_validation"));

		// v_02
		if (!$this->isAddOrEdit())
			$this->v_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_02"));
		$this->v_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_02"));

		// v_02_validation
		if (!$this->isAddOrEdit())
			$this->v_02_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_02_validation"));
		$this->v_02_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_02_validation"));

		// v_03
		if (!$this->isAddOrEdit())
			$this->v_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_03"));
		$this->v_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_03"));

		// v_03_validation
		if (!$this->isAddOrEdit())
			$this->v_03_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_03_validation"));
		$this->v_03_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_03_validation"));

		// v_04
		if (!$this->isAddOrEdit())
			$this->v_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_04"));
		$this->v_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_04"));

		// v_04_validation
		if (!$this->isAddOrEdit())
			$this->v_04_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_04_validation"));
		$this->v_04_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_04_validation"));

		// v_05
		if (!$this->isAddOrEdit())
			$this->v_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_05"));
		$this->v_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_05"));

		// v_05_validation
		if (!$this->isAddOrEdit())
			$this->v_05_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_05_validation"));
		$this->v_05_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_05_validation"));

		// v_06
		if (!$this->isAddOrEdit())
			$this->v_06->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_06"));
		$this->v_06->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_06"));

		// v_06_validation
		if (!$this->isAddOrEdit())
			$this->v_06_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_06_validation"));
		$this->v_06_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_06_validation"));

		// v_07
		if (!$this->isAddOrEdit())
			$this->v_07->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_07"));
		$this->v_07->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_07"));

		// v_07_validation
		if (!$this->isAddOrEdit())
			$this->v_07_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_07_validation"));
		$this->v_07_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_07_validation"));

		// v_08
		if (!$this->isAddOrEdit())
			$this->v_08->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_08"));
		$this->v_08->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_08"));

		// v_08_validation
		if (!$this->isAddOrEdit())
			$this->v_08_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_08_validation"));
		$this->v_08_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_08_validation"));

		// v_09
		if (!$this->isAddOrEdit())
			$this->v_09->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_09"));
		$this->v_09->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_09"));

		// v_09_validation
		if (!$this->isAddOrEdit())
			$this->v_09_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_09_validation"));
		$this->v_09_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_09_validation"));

		// v_10
		if (!$this->isAddOrEdit())
			$this->v_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_10"));
		$this->v_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_10"));

		// v_10_validation
		if (!$this->isAddOrEdit())
			$this->v_10_validation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_10_validation"));
		$this->v_10_validation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_10_validation"));

		// b_01_head
		if (!$this->isAddOrEdit())
			$this->b_01_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_01_head"));
		$this->b_01_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_01_head"));

		// b_02_head
		if (!$this->isAddOrEdit())
			$this->b_02_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_02_head"));
		$this->b_02_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_02_head"));

		// b_03_head
		if (!$this->isAddOrEdit())
			$this->b_03_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_03_head"));
		$this->b_03_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_03_head"));

		// b_04_head
		if (!$this->isAddOrEdit())
			$this->b_04_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_04_head"));
		$this->b_04_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_04_head"));

		// b_05_head
		if (!$this->isAddOrEdit())
			$this->b_05_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_05_head"));
		$this->b_05_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_05_head"));

		// b_06_head
		if (!$this->isAddOrEdit())
			$this->b_06_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_06_head"));
		$this->b_06_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_06_head"));

		// b_07_head
		if (!$this->isAddOrEdit())
			$this->b_07_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_07_head"));
		$this->b_07_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_07_head"));

		// b_08_head
		if (!$this->isAddOrEdit())
			$this->b_08_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_08_head"));
		$this->b_08_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_08_head"));

		// b_09_head
		if (!$this->isAddOrEdit())
			$this->b_09_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_09_head"));
		$this->b_09_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_09_head"));

		// b_10_head
		if (!$this->isAddOrEdit())
			$this->b_10_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_10_head"));
		$this->b_10_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_10_head"));

		// b_11_head
		if (!$this->isAddOrEdit())
			$this->b_11_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_11_head"));
		$this->b_11_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_11_head"));

		// b_12_head
		if (!$this->isAddOrEdit())
			$this->b_12_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_12_head"));
		$this->b_12_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_12_head"));

		// b_13_head
		if (!$this->isAddOrEdit())
			$this->b_13_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_13_head"));
		$this->b_13_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_13_head"));

		// b_14_head
		if (!$this->isAddOrEdit())
			$this->b_14_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_14_head"));
		$this->b_14_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_14_head"));

		// b_15_head
		if (!$this->isAddOrEdit())
			$this->b_15_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_15_head"));
		$this->b_15_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_15_head"));

		// q_sku
		if (!$this->isAddOrEdit())
			$this->q_sku->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_q_sku"));
		$this->q_sku->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_q_sku"));

		// t_01_head
		if (!$this->isAddOrEdit())
			$this->t_01_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_01_head"));
		$this->t_01_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_01_head"));

		// t_02_head
		if (!$this->isAddOrEdit())
			$this->t_02_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_02_head"));
		$this->t_02_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_02_head"));

		// t_03_head
		if (!$this->isAddOrEdit())
			$this->t_03_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_03_head"));
		$this->t_03_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_03_head"));

		// t_04_head
		if (!$this->isAddOrEdit())
			$this->t_04_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_04_head"));
		$this->t_04_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_04_head"));

		// t_05_head
		if (!$this->isAddOrEdit())
			$this->t_05_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_05_head"));
		$this->t_05_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_05_head"));

		// t_06_head
		if (!$this->isAddOrEdit())
			$this->t_06_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_06_head"));
		$this->t_06_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_06_head"));

		// t_07_head
		if (!$this->isAddOrEdit())
			$this->t_07_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_07_head"));
		$this->t_07_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_07_head"));

		// t_08_head
		if (!$this->isAddOrEdit())
			$this->t_08_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_08_head"));
		$this->t_08_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_08_head"));

		// t_09_head
		if (!$this->isAddOrEdit())
			$this->t_09_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_09_head"));
		$this->t_09_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_09_head"));

		// t_10_head
		if (!$this->isAddOrEdit())
			$this->t_10_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_10_head"));
		$this->t_10_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_10_head"));

		// t_11_head
		if (!$this->isAddOrEdit())
			$this->t_11_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_11_head"));
		$this->t_11_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_11_head"));

		// t_12_head
		if (!$this->isAddOrEdit())
			$this->t_12_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_12_head"));
		$this->t_12_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_12_head"));

		// t_13_head
		if (!$this->isAddOrEdit())
			$this->t_13_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_13_head"));
		$this->t_13_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_13_head"));

		// t_14_head
		if (!$this->isAddOrEdit())
			$this->t_14_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_14_head"));
		$this->t_14_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_14_head"));

		// t_15_head
		if (!$this->isAddOrEdit())
			$this->t_15_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_15_head"));
		$this->t_15_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_15_head"));

		// po_01_head
		if (!$this->isAddOrEdit())
			$this->po_01_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_01_head"));
		$this->po_01_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_01_head"));

		// po_02_head
		if (!$this->isAddOrEdit())
			$this->po_02_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_02_head"));
		$this->po_02_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_02_head"));

		// po_03_head
		if (!$this->isAddOrEdit())
			$this->po_03_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_03_head"));
		$this->po_03_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_03_head"));

		// po_04_head
		if (!$this->isAddOrEdit())
			$this->po_04_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_04_head"));
		$this->po_04_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_04_head"));

		// po_05_head
		if (!$this->isAddOrEdit())
			$this->po_05_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_05_head"));
		$this->po_05_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_05_head"));

		// po_06_head
		if (!$this->isAddOrEdit())
			$this->po_06_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_06_head"));
		$this->po_06_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_06_head"));

		// po_07_head
		if (!$this->isAddOrEdit())
			$this->po_07_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_07_head"));
		$this->po_07_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_07_head"));

		// po_08_head
		if (!$this->isAddOrEdit())
			$this->po_08_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_08_head"));
		$this->po_08_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_08_head"));

		// po_17_head
		if (!$this->isAddOrEdit())
			$this->po_17_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_17_head"));
		$this->po_17_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_17_head"));

		// po_18_head
		if (!$this->isAddOrEdit())
			$this->po_18_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_18_head"));
		$this->po_18_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_18_head"));

		// po_19_head
		if (!$this->isAddOrEdit())
			$this->po_19_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_19_head"));
		$this->po_19_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_19_head"));

		// po_20_head
		if (!$this->isAddOrEdit())
			$this->po_20_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_20_head"));
		$this->po_20_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_20_head"));

		// jc_01_head
		if (!$this->isAddOrEdit())
			$this->jc_01_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_01_head"));
		$this->jc_01_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_01_head"));

		// jc_02_head
		if (!$this->isAddOrEdit())
			$this->jc_02_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_02_head"));
		$this->jc_02_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_02_head"));

		// jc_03_head
		if (!$this->isAddOrEdit())
			$this->jc_03_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_03_head"));
		$this->jc_03_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_03_head"));

		// jc_04_head
		if (!$this->isAddOrEdit())
			$this->jc_04_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_04_head"));
		$this->jc_04_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_04_head"));

		// jc_05_head
		if (!$this->isAddOrEdit())
			$this->jc_05_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_05_head"));
		$this->jc_05_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_05_head"));

		// jc_06_head
		if (!$this->isAddOrEdit())
			$this->jc_06_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_06_head"));
		$this->jc_06_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_06_head"));

		// jc_07_head
		if (!$this->isAddOrEdit())
			$this->jc_07_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_07_head"));
		$this->jc_07_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_07_head"));

		// jc_08_head
		if (!$this->isAddOrEdit())
			$this->jc_08_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_08_head"));
		$this->jc_08_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_08_head"));

		// jc_09_head
		if (!$this->isAddOrEdit())
			$this->jc_09_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_09_head"));
		$this->jc_09_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_09_head"));

		// jc_10_head
		if (!$this->isAddOrEdit())
			$this->jc_10_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_10_head"));
		$this->jc_10_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_10_head"));

		// pc_shape
		if (!$this->isAddOrEdit())
			$this->pc_shape->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_shape"));
		$this->pc_shape->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_shape"));

		// pc_unit
		if (!$this->isAddOrEdit())
			$this->pc_unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_unit"));
		$this->pc_unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_unit"));

		// pc_w
		if (!$this->isAddOrEdit())
			$this->pc_w->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_w"));
		$this->pc_w->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_w"));

		// pc_l
		if (!$this->isAddOrEdit())
			$this->pc_l->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_l"));
		$this->pc_l->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_l"));

		// pc_h
		if (!$this->isAddOrEdit())
			$this->pc_h->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_h"));
		$this->pc_h->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_h"));

		// pc_partner_size
		if (!$this->isAddOrEdit())
			$this->pc_partner_size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_partner_size"));
		$this->pc_partner_size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_partner_size"));

		// pc_sqm
		if (!$this->isAddOrEdit())
			$this->pc_sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_sqm"));
		$this->pc_sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_sqm"));

		// pc_01_head
		if (!$this->isAddOrEdit())
			$this->pc_01_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_01_head"));
		$this->pc_01_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_01_head"));

		// pc_02_head
		if (!$this->isAddOrEdit())
			$this->pc_02_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_02_head"));
		$this->pc_02_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_02_head"));

		// pc_03_head
		if (!$this->isAddOrEdit())
			$this->pc_03_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_03_head"));
		$this->pc_03_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_03_head"));

		// pc_04_head
		if (!$this->isAddOrEdit())
			$this->pc_04_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_04_head"));
		$this->pc_04_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_04_head"));

		// pc_05_head
		if (!$this->isAddOrEdit())
			$this->pc_05_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_05_head"));
		$this->pc_05_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_05_head"));

		// pc_06_head
		if (!$this->isAddOrEdit())
			$this->pc_06_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_06_head"));
		$this->pc_06_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_06_head"));

		// pc_07_head
		if (!$this->isAddOrEdit())
			$this->pc_07_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_07_head"));
		$this->pc_07_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_07_head"));

		// pc_08_head
		if (!$this->isAddOrEdit())
			$this->pc_08_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_08_head"));
		$this->pc_08_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_08_head"));

		// pc_09_head
		if (!$this->isAddOrEdit())
			$this->pc_09_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_09_head"));
		$this->pc_09_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_09_head"));

		// pc_10_head
		if (!$this->isAddOrEdit())
			$this->pc_10_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_10_head"));
		$this->pc_10_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_10_head"));

		// pc_11_head
		if (!$this->isAddOrEdit())
			$this->pc_11_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_11_head"));
		$this->pc_11_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_11_head"));

		// pc_12_head
		if (!$this->isAddOrEdit())
			$this->pc_12_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pc_12_head"));
		$this->pc_12_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pc_12_head"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_image"));
		$this->image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_image"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// product_group
		// calculation_method
		// shape
		// sqm
		// cbm
		// process
		// status
		// v_00
		// v_01
		// v_01_validation
		// v_02
		// v_02_validation
		// v_03
		// v_03_validation
		// v_04
		// v_04_validation
		// v_05
		// v_05_validation
		// v_06
		// v_06_validation
		// v_07
		// v_07_validation
		// v_08
		// v_08_validation
		// v_09
		// v_09_validation
		// v_10
		// v_10_validation
		// b_01_head
		// b_02_head
		// b_03_head
		// b_04_head
		// b_05_head
		// b_06_head
		// b_07_head
		// b_08_head
		// b_09_head
		// b_10_head
		// b_11_head
		// b_12_head
		// b_13_head
		// b_14_head
		// b_15_head
		// q_sku
		// t_01_head
		// t_02_head
		// t_03_head
		// t_04_head
		// t_05_head
		// t_06_head
		// t_07_head
		// t_08_head
		// t_09_head
		// t_10_head
		// t_11_head
		// t_12_head
		// t_13_head
		// t_14_head
		// t_15_head
		// po_01_head
		// po_02_head
		// po_03_head
		// po_04_head
		// po_05_head
		// po_06_head
		// po_07_head
		// po_08_head
		// po_17_head
		// po_18_head
		// po_19_head
		// po_20_head
		// jc_01_head
		// jc_02_head
		// jc_03_head
		// jc_04_head
		// jc_05_head
		// jc_06_head
		// jc_07_head
		// jc_08_head
		// jc_09_head
		// jc_10_head
		// pc_shape
		// pc_unit
		// pc_w
		// pc_l
		// pc_h
		// pc_partner_size
		// pc_sqm
		// pc_01_head
		// pc_02_head
		// pc_03_head
		// pc_04_head
		// pc_05_head
		// pc_06_head
		// pc_07_head
		// pc_08_head
		// pc_09_head
		// pc_10_head
		// pc_11_head
		// pc_12_head
		// operator
		// datetime
		// image

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// product_group
			$this->product_group->ViewValue = $this->product_group->CurrentValue;
			$this->product_group->ViewCustomAttributes = "";

			// calculation_method
			$curVal = strval($this->calculation_method->CurrentValue);
			if ($curVal <> "") {
				$this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
				if ($this->calculation_method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->calculation_method->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->calculation_method->ViewValue = $this->calculation_method->CurrentValue;
					}
				}
			} else {
				$this->calculation_method->ViewValue = NULL;
			}
			$this->calculation_method->ViewCustomAttributes = "";

			// shape
			$this->shape->ViewValue = $this->shape->CurrentValue;
			$this->shape->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// v_00
			$this->v_00->ViewValue = $this->v_00->CurrentValue;
			$this->v_00->ViewCustomAttributes = "";

			// v_01
			$this->v_01->ViewValue = $this->v_01->CurrentValue;
			$this->v_01->ViewCustomAttributes = "";

			// v_01_validation
			$this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;
			$this->v_01_validation->ViewCustomAttributes = "";

			// v_02
			$this->v_02->ViewValue = $this->v_02->CurrentValue;
			$this->v_02->ViewCustomAttributes = "";

			// v_02_validation
			$this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;
			$this->v_02_validation->ViewCustomAttributes = "";

			// v_03
			$this->v_03->ViewValue = $this->v_03->CurrentValue;
			$this->v_03->ViewCustomAttributes = "";

			// v_03_validation
			$this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;
			$this->v_03_validation->ViewCustomAttributes = "";

			// v_04
			$this->v_04->ViewValue = $this->v_04->CurrentValue;
			$this->v_04->ViewCustomAttributes = "";

			// v_04_validation
			$this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;
			$this->v_04_validation->ViewCustomAttributes = "";

			// v_05
			$this->v_05->ViewValue = $this->v_05->CurrentValue;
			$this->v_05->ViewCustomAttributes = "";

			// v_05_validation
			$this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;
			$this->v_05_validation->ViewCustomAttributes = "";

			// v_06
			$this->v_06->ViewValue = $this->v_06->CurrentValue;
			$this->v_06->ViewCustomAttributes = "";

			// v_06_validation
			$this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;
			$this->v_06_validation->ViewCustomAttributes = "";

			// v_07
			$this->v_07->ViewValue = $this->v_07->CurrentValue;
			$this->v_07->ViewCustomAttributes = "";

			// v_07_validation
			$this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;
			$this->v_07_validation->ViewCustomAttributes = "";

			// v_08
			$this->v_08->ViewValue = $this->v_08->CurrentValue;
			$this->v_08->ViewCustomAttributes = "";

			// v_08_validation
			$this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;
			$this->v_08_validation->ViewCustomAttributes = "";

			// v_09
			$this->v_09->ViewValue = $this->v_09->CurrentValue;
			$this->v_09->ViewCustomAttributes = "";

			// v_09_validation
			$this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;
			$this->v_09_validation->ViewCustomAttributes = "";

			// v_10
			$this->v_10->ViewValue = $this->v_10->CurrentValue;
			$this->v_10->ViewCustomAttributes = "";

			// v_10_validation
			$this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;
			$this->v_10_validation->ViewCustomAttributes = "";

			// b_01_head
			$this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;
			$this->b_01_head->ViewCustomAttributes = "";

			// b_02_head
			$this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;
			$this->b_02_head->ViewCustomAttributes = "";

			// b_03_head
			$this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;
			$this->b_03_head->ViewCustomAttributes = "";

			// b_04_head
			$this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;
			$this->b_04_head->ViewCustomAttributes = "";

			// b_05_head
			$this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;
			$this->b_05_head->ViewCustomAttributes = "";

			// b_06_head
			$this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;
			$this->b_06_head->ViewCustomAttributes = "";

			// b_07_head
			$this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;
			$this->b_07_head->ViewCustomAttributes = "";

			// b_08_head
			$this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;
			$this->b_08_head->ViewCustomAttributes = "";

			// b_09_head
			$this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;
			$this->b_09_head->ViewCustomAttributes = "";

			// b_10_head
			$this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;
			$this->b_10_head->ViewCustomAttributes = "";

			// b_11_head
			$this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;
			$this->b_11_head->ViewCustomAttributes = "";

			// b_12_head
			$this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;
			$this->b_12_head->ViewCustomAttributes = "";

			// b_13_head
			$this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;
			$this->b_13_head->ViewCustomAttributes = "";

			// b_14_head
			$this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;
			$this->b_14_head->ViewCustomAttributes = "";

			// b_15_head
			$this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;
			$this->b_15_head->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewCustomAttributes = "";

			// t_01_head
			$this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;
			$this->t_01_head->ViewCustomAttributes = "";

			// t_02_head
			$this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;
			$this->t_02_head->ViewCustomAttributes = "";

			// t_03_head
			$this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;
			$this->t_03_head->ViewCustomAttributes = "";

			// t_04_head
			$this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;
			$this->t_04_head->ViewCustomAttributes = "";

			// t_05_head
			$this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;
			$this->t_05_head->ViewCustomAttributes = "";

			// t_06_head
			$this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;
			$this->t_06_head->ViewCustomAttributes = "";

			// t_07_head
			$this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;
			$this->t_07_head->ViewCustomAttributes = "";

			// t_08_head
			$this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;
			$this->t_08_head->ViewCustomAttributes = "";

			// t_09_head
			$this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;
			$this->t_09_head->ViewCustomAttributes = "";

			// t_10_head
			$this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;
			$this->t_10_head->ViewCustomAttributes = "";

			// t_11_head
			$this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;
			$this->t_11_head->ViewCustomAttributes = "";

			// t_12_head
			$this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;
			$this->t_12_head->ViewCustomAttributes = "";

			// t_13_head
			$this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;
			$this->t_13_head->ViewCustomAttributes = "";

			// t_14_head
			$this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;
			$this->t_14_head->ViewCustomAttributes = "";

			// t_15_head
			$this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;
			$this->t_15_head->ViewCustomAttributes = "";

			// po_01_head
			$this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;
			$this->po_01_head->ViewCustomAttributes = "";

			// po_02_head
			$this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;
			$this->po_02_head->ViewCustomAttributes = "";

			// po_03_head
			$this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;
			$this->po_03_head->ViewCustomAttributes = "";

			// po_04_head
			$this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;
			$this->po_04_head->ViewCustomAttributes = "";

			// po_05_head
			$this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;
			$this->po_05_head->ViewCustomAttributes = "";

			// po_06_head
			$this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;
			$this->po_06_head->ViewCustomAttributes = "";

			// po_07_head
			$this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;
			$this->po_07_head->ViewCustomAttributes = "";

			// po_08_head
			$this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;
			$this->po_08_head->ViewCustomAttributes = "";

			// po_17_head
			$this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;
			$this->po_17_head->ViewCustomAttributes = "";

			// po_18_head
			$this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;
			$this->po_18_head->ViewCustomAttributes = "";

			// po_19_head
			$this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;
			$this->po_19_head->ViewCustomAttributes = "";

			// po_20_head
			$this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;
			$this->po_20_head->ViewCustomAttributes = "";

			// jc_01_head
			$this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;
			$this->jc_01_head->ViewCustomAttributes = "";

			// jc_02_head
			$this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;
			$this->jc_02_head->ViewCustomAttributes = "";

			// jc_03_head
			$this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;
			$this->jc_03_head->ViewCustomAttributes = "";

			// jc_04_head
			$this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;
			$this->jc_04_head->ViewCustomAttributes = "";

			// jc_05_head
			$this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;
			$this->jc_05_head->ViewCustomAttributes = "";

			// jc_06_head
			$this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;
			$this->jc_06_head->ViewCustomAttributes = "";

			// jc_07_head
			$this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;
			$this->jc_07_head->ViewCustomAttributes = "";

			// jc_08_head
			$this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;
			$this->jc_08_head->ViewCustomAttributes = "";

			// jc_09_head
			$this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;
			$this->jc_09_head->ViewCustomAttributes = "";

			// jc_10_head
			$this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;
			$this->jc_10_head->ViewCustomAttributes = "";

			// pc_shape
			$this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;
			$this->pc_shape->ViewCustomAttributes = "";

			// pc_unit
			$this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;
			$this->pc_unit->ViewCustomAttributes = "";

			// pc_w
			$this->pc_w->ViewValue = $this->pc_w->CurrentValue;
			$this->pc_w->ViewCustomAttributes = "";

			// pc_l
			$this->pc_l->ViewValue = $this->pc_l->CurrentValue;
			$this->pc_l->ViewCustomAttributes = "";

			// pc_h
			$this->pc_h->ViewValue = $this->pc_h->CurrentValue;
			$this->pc_h->ViewCustomAttributes = "";

			// pc_partner_size
			$this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;
			$this->pc_partner_size->ViewCustomAttributes = "";

			// pc_sqm
			$this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;
			$this->pc_sqm->ViewCustomAttributes = "";

			// pc_01_head
			$this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;
			$this->pc_01_head->ViewCustomAttributes = "";

			// pc_02_head
			$this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;
			$this->pc_02_head->ViewCustomAttributes = "";

			// pc_03_head
			$this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;
			$this->pc_03_head->ViewCustomAttributes = "";

			// pc_04_head
			$this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;
			$this->pc_04_head->ViewCustomAttributes = "";

			// pc_05_head
			$this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;
			$this->pc_05_head->ViewCustomAttributes = "";

			// pc_06_head
			$this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;
			$this->pc_06_head->ViewCustomAttributes = "";

			// pc_07_head
			$this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;
			$this->pc_07_head->ViewCustomAttributes = "";

			// pc_08_head
			$this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;
			$this->pc_08_head->ViewCustomAttributes = "";

			// pc_09_head
			$this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;
			$this->pc_09_head->ViewCustomAttributes = "";

			// pc_10_head
			$this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;
			$this->pc_10_head->ViewCustomAttributes = "";

			// pc_11_head
			$this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;
			$this->pc_11_head->ViewCustomAttributes = "";

			// pc_12_head
			$this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;
			$this->pc_12_head->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// product_group
			$this->product_group->LinkCustomAttributes = "";
			$this->product_group->HrefValue = "";
			$this->product_group->TooltipValue = "";

			// calculation_method
			$this->calculation_method->LinkCustomAttributes = "";
			$this->calculation_method->HrefValue = "";
			$this->calculation_method->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// v_00
			$this->v_00->LinkCustomAttributes = "";
			$this->v_00->HrefValue = "";
			$this->v_00->TooltipValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";
			$this->v_01->TooltipValue = "";

			// v_01_validation
			$this->v_01_validation->LinkCustomAttributes = "";
			$this->v_01_validation->HrefValue = "";
			$this->v_01_validation->TooltipValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";
			$this->v_02->TooltipValue = "";

			// v_02_validation
			$this->v_02_validation->LinkCustomAttributes = "";
			$this->v_02_validation->HrefValue = "";
			$this->v_02_validation->TooltipValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";
			$this->v_03->TooltipValue = "";

			// v_03_validation
			$this->v_03_validation->LinkCustomAttributes = "";
			$this->v_03_validation->HrefValue = "";
			$this->v_03_validation->TooltipValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";
			$this->v_04->TooltipValue = "";

			// v_04_validation
			$this->v_04_validation->LinkCustomAttributes = "";
			$this->v_04_validation->HrefValue = "";
			$this->v_04_validation->TooltipValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";
			$this->v_05->TooltipValue = "";

			// v_05_validation
			$this->v_05_validation->LinkCustomAttributes = "";
			$this->v_05_validation->HrefValue = "";
			$this->v_05_validation->TooltipValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";
			$this->v_06->TooltipValue = "";

			// v_06_validation
			$this->v_06_validation->LinkCustomAttributes = "";
			$this->v_06_validation->HrefValue = "";
			$this->v_06_validation->TooltipValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";
			$this->v_07->TooltipValue = "";

			// v_07_validation
			$this->v_07_validation->LinkCustomAttributes = "";
			$this->v_07_validation->HrefValue = "";
			$this->v_07_validation->TooltipValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";
			$this->v_08->TooltipValue = "";

			// v_08_validation
			$this->v_08_validation->LinkCustomAttributes = "";
			$this->v_08_validation->HrefValue = "";
			$this->v_08_validation->TooltipValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";
			$this->v_09->TooltipValue = "";

			// v_09_validation
			$this->v_09_validation->LinkCustomAttributes = "";
			$this->v_09_validation->HrefValue = "";
			$this->v_09_validation->TooltipValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";
			$this->v_10->TooltipValue = "";

			// v_10_validation
			$this->v_10_validation->LinkCustomAttributes = "";
			$this->v_10_validation->HrefValue = "";
			$this->v_10_validation->TooltipValue = "";

			// b_01_head
			$this->b_01_head->LinkCustomAttributes = "";
			$this->b_01_head->HrefValue = "";
			$this->b_01_head->TooltipValue = "";

			// b_02_head
			$this->b_02_head->LinkCustomAttributes = "";
			$this->b_02_head->HrefValue = "";
			$this->b_02_head->TooltipValue = "";

			// b_03_head
			$this->b_03_head->LinkCustomAttributes = "";
			$this->b_03_head->HrefValue = "";
			$this->b_03_head->TooltipValue = "";

			// b_04_head
			$this->b_04_head->LinkCustomAttributes = "";
			$this->b_04_head->HrefValue = "";
			$this->b_04_head->TooltipValue = "";

			// b_05_head
			$this->b_05_head->LinkCustomAttributes = "";
			$this->b_05_head->HrefValue = "";
			$this->b_05_head->TooltipValue = "";

			// b_06_head
			$this->b_06_head->LinkCustomAttributes = "";
			$this->b_06_head->HrefValue = "";
			$this->b_06_head->TooltipValue = "";

			// b_07_head
			$this->b_07_head->LinkCustomAttributes = "";
			$this->b_07_head->HrefValue = "";
			$this->b_07_head->TooltipValue = "";

			// b_08_head
			$this->b_08_head->LinkCustomAttributes = "";
			$this->b_08_head->HrefValue = "";
			$this->b_08_head->TooltipValue = "";

			// b_09_head
			$this->b_09_head->LinkCustomAttributes = "";
			$this->b_09_head->HrefValue = "";
			$this->b_09_head->TooltipValue = "";

			// b_10_head
			$this->b_10_head->LinkCustomAttributes = "";
			$this->b_10_head->HrefValue = "";
			$this->b_10_head->TooltipValue = "";

			// b_11_head
			$this->b_11_head->LinkCustomAttributes = "";
			$this->b_11_head->HrefValue = "";
			$this->b_11_head->TooltipValue = "";

			// b_12_head
			$this->b_12_head->LinkCustomAttributes = "";
			$this->b_12_head->HrefValue = "";
			$this->b_12_head->TooltipValue = "";

			// b_13_head
			$this->b_13_head->LinkCustomAttributes = "";
			$this->b_13_head->HrefValue = "";
			$this->b_13_head->TooltipValue = "";

			// b_14_head
			$this->b_14_head->LinkCustomAttributes = "";
			$this->b_14_head->HrefValue = "";
			$this->b_14_head->TooltipValue = "";

			// b_15_head
			$this->b_15_head->LinkCustomAttributes = "";
			$this->b_15_head->HrefValue = "";
			$this->b_15_head->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// t_01_head
			$this->t_01_head->LinkCustomAttributes = "";
			$this->t_01_head->HrefValue = "";
			$this->t_01_head->TooltipValue = "";

			// t_02_head
			$this->t_02_head->LinkCustomAttributes = "";
			$this->t_02_head->HrefValue = "";
			$this->t_02_head->TooltipValue = "";

			// t_03_head
			$this->t_03_head->LinkCustomAttributes = "";
			$this->t_03_head->HrefValue = "";
			$this->t_03_head->TooltipValue = "";

			// t_04_head
			$this->t_04_head->LinkCustomAttributes = "";
			$this->t_04_head->HrefValue = "";
			$this->t_04_head->TooltipValue = "";

			// t_05_head
			$this->t_05_head->LinkCustomAttributes = "";
			$this->t_05_head->HrefValue = "";
			$this->t_05_head->TooltipValue = "";

			// t_06_head
			$this->t_06_head->LinkCustomAttributes = "";
			$this->t_06_head->HrefValue = "";
			$this->t_06_head->TooltipValue = "";

			// t_07_head
			$this->t_07_head->LinkCustomAttributes = "";
			$this->t_07_head->HrefValue = "";
			$this->t_07_head->TooltipValue = "";

			// t_08_head
			$this->t_08_head->LinkCustomAttributes = "";
			$this->t_08_head->HrefValue = "";
			$this->t_08_head->TooltipValue = "";

			// t_09_head
			$this->t_09_head->LinkCustomAttributes = "";
			$this->t_09_head->HrefValue = "";
			$this->t_09_head->TooltipValue = "";

			// t_10_head
			$this->t_10_head->LinkCustomAttributes = "";
			$this->t_10_head->HrefValue = "";
			$this->t_10_head->TooltipValue = "";

			// t_11_head
			$this->t_11_head->LinkCustomAttributes = "";
			$this->t_11_head->HrefValue = "";
			$this->t_11_head->TooltipValue = "";

			// t_12_head
			$this->t_12_head->LinkCustomAttributes = "";
			$this->t_12_head->HrefValue = "";
			$this->t_12_head->TooltipValue = "";

			// t_13_head
			$this->t_13_head->LinkCustomAttributes = "";
			$this->t_13_head->HrefValue = "";
			$this->t_13_head->TooltipValue = "";

			// t_14_head
			$this->t_14_head->LinkCustomAttributes = "";
			$this->t_14_head->HrefValue = "";
			$this->t_14_head->TooltipValue = "";

			// t_15_head
			$this->t_15_head->LinkCustomAttributes = "";
			$this->t_15_head->HrefValue = "";
			$this->t_15_head->TooltipValue = "";

			// po_01_head
			$this->po_01_head->LinkCustomAttributes = "";
			$this->po_01_head->HrefValue = "";
			$this->po_01_head->TooltipValue = "";

			// po_02_head
			$this->po_02_head->LinkCustomAttributes = "";
			$this->po_02_head->HrefValue = "";
			$this->po_02_head->TooltipValue = "";

			// po_03_head
			$this->po_03_head->LinkCustomAttributes = "";
			$this->po_03_head->HrefValue = "";
			$this->po_03_head->TooltipValue = "";

			// po_04_head
			$this->po_04_head->LinkCustomAttributes = "";
			$this->po_04_head->HrefValue = "";
			$this->po_04_head->TooltipValue = "";

			// po_05_head
			$this->po_05_head->LinkCustomAttributes = "";
			$this->po_05_head->HrefValue = "";
			$this->po_05_head->TooltipValue = "";

			// po_06_head
			$this->po_06_head->LinkCustomAttributes = "";
			$this->po_06_head->HrefValue = "";
			$this->po_06_head->TooltipValue = "";

			// po_07_head
			$this->po_07_head->LinkCustomAttributes = "";
			$this->po_07_head->HrefValue = "";
			$this->po_07_head->TooltipValue = "";

			// po_08_head
			$this->po_08_head->LinkCustomAttributes = "";
			$this->po_08_head->HrefValue = "";
			$this->po_08_head->TooltipValue = "";

			// po_17_head
			$this->po_17_head->LinkCustomAttributes = "";
			$this->po_17_head->HrefValue = "";
			$this->po_17_head->TooltipValue = "";

			// po_18_head
			$this->po_18_head->LinkCustomAttributes = "";
			$this->po_18_head->HrefValue = "";
			$this->po_18_head->TooltipValue = "";

			// po_19_head
			$this->po_19_head->LinkCustomAttributes = "";
			$this->po_19_head->HrefValue = "";
			$this->po_19_head->TooltipValue = "";

			// po_20_head
			$this->po_20_head->LinkCustomAttributes = "";
			$this->po_20_head->HrefValue = "";
			$this->po_20_head->TooltipValue = "";

			// jc_01_head
			$this->jc_01_head->LinkCustomAttributes = "";
			$this->jc_01_head->HrefValue = "";
			$this->jc_01_head->TooltipValue = "";

			// jc_02_head
			$this->jc_02_head->LinkCustomAttributes = "";
			$this->jc_02_head->HrefValue = "";
			$this->jc_02_head->TooltipValue = "";

			// jc_03_head
			$this->jc_03_head->LinkCustomAttributes = "";
			$this->jc_03_head->HrefValue = "";
			$this->jc_03_head->TooltipValue = "";

			// jc_04_head
			$this->jc_04_head->LinkCustomAttributes = "";
			$this->jc_04_head->HrefValue = "";
			$this->jc_04_head->TooltipValue = "";

			// jc_05_head
			$this->jc_05_head->LinkCustomAttributes = "";
			$this->jc_05_head->HrefValue = "";
			$this->jc_05_head->TooltipValue = "";

			// jc_06_head
			$this->jc_06_head->LinkCustomAttributes = "";
			$this->jc_06_head->HrefValue = "";
			$this->jc_06_head->TooltipValue = "";

			// jc_07_head
			$this->jc_07_head->LinkCustomAttributes = "";
			$this->jc_07_head->HrefValue = "";
			$this->jc_07_head->TooltipValue = "";

			// jc_08_head
			$this->jc_08_head->LinkCustomAttributes = "";
			$this->jc_08_head->HrefValue = "";
			$this->jc_08_head->TooltipValue = "";

			// jc_09_head
			$this->jc_09_head->LinkCustomAttributes = "";
			$this->jc_09_head->HrefValue = "";
			$this->jc_09_head->TooltipValue = "";

			// jc_10_head
			$this->jc_10_head->LinkCustomAttributes = "";
			$this->jc_10_head->HrefValue = "";
			$this->jc_10_head->TooltipValue = "";

			// pc_shape
			$this->pc_shape->LinkCustomAttributes = "";
			$this->pc_shape->HrefValue = "";
			$this->pc_shape->TooltipValue = "";

			// pc_unit
			$this->pc_unit->LinkCustomAttributes = "";
			$this->pc_unit->HrefValue = "";
			$this->pc_unit->TooltipValue = "";

			// pc_w
			$this->pc_w->LinkCustomAttributes = "";
			$this->pc_w->HrefValue = "";
			$this->pc_w->TooltipValue = "";

			// pc_l
			$this->pc_l->LinkCustomAttributes = "";
			$this->pc_l->HrefValue = "";
			$this->pc_l->TooltipValue = "";

			// pc_h
			$this->pc_h->LinkCustomAttributes = "";
			$this->pc_h->HrefValue = "";
			$this->pc_h->TooltipValue = "";

			// pc_partner_size
			$this->pc_partner_size->LinkCustomAttributes = "";
			$this->pc_partner_size->HrefValue = "";
			$this->pc_partner_size->TooltipValue = "";

			// pc_sqm
			$this->pc_sqm->LinkCustomAttributes = "";
			$this->pc_sqm->HrefValue = "";
			$this->pc_sqm->TooltipValue = "";

			// pc_01_head
			$this->pc_01_head->LinkCustomAttributes = "";
			$this->pc_01_head->HrefValue = "";
			$this->pc_01_head->TooltipValue = "";

			// pc_02_head
			$this->pc_02_head->LinkCustomAttributes = "";
			$this->pc_02_head->HrefValue = "";
			$this->pc_02_head->TooltipValue = "";

			// pc_03_head
			$this->pc_03_head->LinkCustomAttributes = "";
			$this->pc_03_head->HrefValue = "";
			$this->pc_03_head->TooltipValue = "";

			// pc_04_head
			$this->pc_04_head->LinkCustomAttributes = "";
			$this->pc_04_head->HrefValue = "";
			$this->pc_04_head->TooltipValue = "";

			// pc_05_head
			$this->pc_05_head->LinkCustomAttributes = "";
			$this->pc_05_head->HrefValue = "";
			$this->pc_05_head->TooltipValue = "";

			// pc_06_head
			$this->pc_06_head->LinkCustomAttributes = "";
			$this->pc_06_head->HrefValue = "";
			$this->pc_06_head->TooltipValue = "";

			// pc_07_head
			$this->pc_07_head->LinkCustomAttributes = "";
			$this->pc_07_head->HrefValue = "";
			$this->pc_07_head->TooltipValue = "";

			// pc_08_head
			$this->pc_08_head->LinkCustomAttributes = "";
			$this->pc_08_head->HrefValue = "";
			$this->pc_08_head->TooltipValue = "";

			// pc_09_head
			$this->pc_09_head->LinkCustomAttributes = "";
			$this->pc_09_head->HrefValue = "";
			$this->pc_09_head->TooltipValue = "";

			// pc_10_head
			$this->pc_10_head->LinkCustomAttributes = "";
			$this->pc_10_head->HrefValue = "";
			$this->pc_10_head->TooltipValue = "";

			// pc_11_head
			$this->pc_11_head->LinkCustomAttributes = "";
			$this->pc_11_head->HrefValue = "";
			$this->pc_11_head->TooltipValue = "";

			// pc_12_head
			$this->pc_12_head->LinkCustomAttributes = "";
			$this->pc_12_head->HrefValue = "";
			$this->pc_12_head->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "product_group_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// product_group
			$this->product_group->EditAttrs["class"] = "form-control";
			$this->product_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_group->AdvancedSearch->SearchValue = HtmlDecode($this->product_group->AdvancedSearch->SearchValue);
			$this->product_group->EditValue = HtmlEncode($this->product_group->AdvancedSearch->SearchValue);
			$this->product_group->PlaceHolder = RemoveHtml($this->product_group->caption());

			// calculation_method
			$this->calculation_method->EditAttrs["class"] = "form-control";
			$this->calculation_method->EditCustomAttributes = "";
			$curVal = trim(strval($this->calculation_method->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->calculation_method->AdvancedSearch->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
			else
				$this->calculation_method->AdvancedSearch->ViewValue = $this->calculation_method->Lookup !== NULL && is_array($this->calculation_method->Lookup->Options) ? $curVal : NULL;
			if ($this->calculation_method->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->calculation_method->EditValue = array_values($this->calculation_method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->calculation_method->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->calculation_method->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->calculation_method->EditValue = $arwrk;
			}

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->shape->AdvancedSearch->SearchValue = HtmlDecode($this->shape->AdvancedSearch->SearchValue);
			$this->shape->EditValue = HtmlEncode($this->shape->AdvancedSearch->SearchValue);
			$this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sqm->AdvancedSearch->SearchValue = HtmlDecode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cbm->AdvancedSearch->SearchValue = HtmlDecode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// v_00
			$this->v_00->EditAttrs["class"] = "form-control";
			$this->v_00->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_00->AdvancedSearch->SearchValue = HtmlDecode($this->v_00->AdvancedSearch->SearchValue);
			$this->v_00->EditValue = HtmlEncode($this->v_00->AdvancedSearch->SearchValue);
			$this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

			// v_01
			$this->v_01->EditAttrs["class"] = "form-control";
			$this->v_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_01->AdvancedSearch->SearchValue = HtmlDecode($this->v_01->AdvancedSearch->SearchValue);
			$this->v_01->EditValue = HtmlEncode($this->v_01->AdvancedSearch->SearchValue);
			$this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

			// v_01_validation
			$this->v_01_validation->EditAttrs["class"] = "form-control";
			$this->v_01_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_01_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_01_validation->AdvancedSearch->SearchValue);
			$this->v_01_validation->EditValue = HtmlEncode($this->v_01_validation->AdvancedSearch->SearchValue);
			$this->v_01_validation->PlaceHolder = RemoveHtml($this->v_01_validation->caption());

			// v_02
			$this->v_02->EditAttrs["class"] = "form-control";
			$this->v_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_02->AdvancedSearch->SearchValue = HtmlDecode($this->v_02->AdvancedSearch->SearchValue);
			$this->v_02->EditValue = HtmlEncode($this->v_02->AdvancedSearch->SearchValue);
			$this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

			// v_02_validation
			$this->v_02_validation->EditAttrs["class"] = "form-control";
			$this->v_02_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_02_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_02_validation->AdvancedSearch->SearchValue);
			$this->v_02_validation->EditValue = HtmlEncode($this->v_02_validation->AdvancedSearch->SearchValue);
			$this->v_02_validation->PlaceHolder = RemoveHtml($this->v_02_validation->caption());

			// v_03
			$this->v_03->EditAttrs["class"] = "form-control";
			$this->v_03->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_03->AdvancedSearch->SearchValue = HtmlDecode($this->v_03->AdvancedSearch->SearchValue);
			$this->v_03->EditValue = HtmlEncode($this->v_03->AdvancedSearch->SearchValue);
			$this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

			// v_03_validation
			$this->v_03_validation->EditAttrs["class"] = "form-control";
			$this->v_03_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_03_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_03_validation->AdvancedSearch->SearchValue);
			$this->v_03_validation->EditValue = HtmlEncode($this->v_03_validation->AdvancedSearch->SearchValue);
			$this->v_03_validation->PlaceHolder = RemoveHtml($this->v_03_validation->caption());

			// v_04
			$this->v_04->EditAttrs["class"] = "form-control";
			$this->v_04->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_04->AdvancedSearch->SearchValue = HtmlDecode($this->v_04->AdvancedSearch->SearchValue);
			$this->v_04->EditValue = HtmlEncode($this->v_04->AdvancedSearch->SearchValue);
			$this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

			// v_04_validation
			$this->v_04_validation->EditAttrs["class"] = "form-control";
			$this->v_04_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_04_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_04_validation->AdvancedSearch->SearchValue);
			$this->v_04_validation->EditValue = HtmlEncode($this->v_04_validation->AdvancedSearch->SearchValue);
			$this->v_04_validation->PlaceHolder = RemoveHtml($this->v_04_validation->caption());

			// v_05
			$this->v_05->EditAttrs["class"] = "form-control";
			$this->v_05->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_05->AdvancedSearch->SearchValue = HtmlDecode($this->v_05->AdvancedSearch->SearchValue);
			$this->v_05->EditValue = HtmlEncode($this->v_05->AdvancedSearch->SearchValue);
			$this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

			// v_05_validation
			$this->v_05_validation->EditAttrs["class"] = "form-control";
			$this->v_05_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_05_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_05_validation->AdvancedSearch->SearchValue);
			$this->v_05_validation->EditValue = HtmlEncode($this->v_05_validation->AdvancedSearch->SearchValue);
			$this->v_05_validation->PlaceHolder = RemoveHtml($this->v_05_validation->caption());

			// v_06
			$this->v_06->EditAttrs["class"] = "form-control";
			$this->v_06->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_06->AdvancedSearch->SearchValue = HtmlDecode($this->v_06->AdvancedSearch->SearchValue);
			$this->v_06->EditValue = HtmlEncode($this->v_06->AdvancedSearch->SearchValue);
			$this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

			// v_06_validation
			$this->v_06_validation->EditAttrs["class"] = "form-control";
			$this->v_06_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_06_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_06_validation->AdvancedSearch->SearchValue);
			$this->v_06_validation->EditValue = HtmlEncode($this->v_06_validation->AdvancedSearch->SearchValue);
			$this->v_06_validation->PlaceHolder = RemoveHtml($this->v_06_validation->caption());

			// v_07
			$this->v_07->EditAttrs["class"] = "form-control";
			$this->v_07->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_07->AdvancedSearch->SearchValue = HtmlDecode($this->v_07->AdvancedSearch->SearchValue);
			$this->v_07->EditValue = HtmlEncode($this->v_07->AdvancedSearch->SearchValue);
			$this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

			// v_07_validation
			$this->v_07_validation->EditAttrs["class"] = "form-control";
			$this->v_07_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_07_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_07_validation->AdvancedSearch->SearchValue);
			$this->v_07_validation->EditValue = HtmlEncode($this->v_07_validation->AdvancedSearch->SearchValue);
			$this->v_07_validation->PlaceHolder = RemoveHtml($this->v_07_validation->caption());

			// v_08
			$this->v_08->EditAttrs["class"] = "form-control";
			$this->v_08->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_08->AdvancedSearch->SearchValue = HtmlDecode($this->v_08->AdvancedSearch->SearchValue);
			$this->v_08->EditValue = HtmlEncode($this->v_08->AdvancedSearch->SearchValue);
			$this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

			// v_08_validation
			$this->v_08_validation->EditAttrs["class"] = "form-control";
			$this->v_08_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_08_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_08_validation->AdvancedSearch->SearchValue);
			$this->v_08_validation->EditValue = HtmlEncode($this->v_08_validation->AdvancedSearch->SearchValue);
			$this->v_08_validation->PlaceHolder = RemoveHtml($this->v_08_validation->caption());

			// v_09
			$this->v_09->EditAttrs["class"] = "form-control";
			$this->v_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_09->AdvancedSearch->SearchValue = HtmlDecode($this->v_09->AdvancedSearch->SearchValue);
			$this->v_09->EditValue = HtmlEncode($this->v_09->AdvancedSearch->SearchValue);
			$this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

			// v_09_validation
			$this->v_09_validation->EditAttrs["class"] = "form-control";
			$this->v_09_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_09_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_09_validation->AdvancedSearch->SearchValue);
			$this->v_09_validation->EditValue = HtmlEncode($this->v_09_validation->AdvancedSearch->SearchValue);
			$this->v_09_validation->PlaceHolder = RemoveHtml($this->v_09_validation->caption());

			// v_10
			$this->v_10->EditAttrs["class"] = "form-control";
			$this->v_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_10->AdvancedSearch->SearchValue = HtmlDecode($this->v_10->AdvancedSearch->SearchValue);
			$this->v_10->EditValue = HtmlEncode($this->v_10->AdvancedSearch->SearchValue);
			$this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

			// v_10_validation
			$this->v_10_validation->EditAttrs["class"] = "form-control";
			$this->v_10_validation->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_10_validation->AdvancedSearch->SearchValue = HtmlDecode($this->v_10_validation->AdvancedSearch->SearchValue);
			$this->v_10_validation->EditValue = HtmlEncode($this->v_10_validation->AdvancedSearch->SearchValue);
			$this->v_10_validation->PlaceHolder = RemoveHtml($this->v_10_validation->caption());

			// b_01_head
			$this->b_01_head->EditAttrs["class"] = "form-control";
			$this->b_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_01_head->AdvancedSearch->SearchValue);
			$this->b_01_head->EditValue = HtmlEncode($this->b_01_head->AdvancedSearch->SearchValue);
			$this->b_01_head->PlaceHolder = RemoveHtml($this->b_01_head->caption());

			// b_02_head
			$this->b_02_head->EditAttrs["class"] = "form-control";
			$this->b_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_02_head->AdvancedSearch->SearchValue);
			$this->b_02_head->EditValue = HtmlEncode($this->b_02_head->AdvancedSearch->SearchValue);
			$this->b_02_head->PlaceHolder = RemoveHtml($this->b_02_head->caption());

			// b_03_head
			$this->b_03_head->EditAttrs["class"] = "form-control";
			$this->b_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_03_head->AdvancedSearch->SearchValue);
			$this->b_03_head->EditValue = HtmlEncode($this->b_03_head->AdvancedSearch->SearchValue);
			$this->b_03_head->PlaceHolder = RemoveHtml($this->b_03_head->caption());

			// b_04_head
			$this->b_04_head->EditAttrs["class"] = "form-control";
			$this->b_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_04_head->AdvancedSearch->SearchValue);
			$this->b_04_head->EditValue = HtmlEncode($this->b_04_head->AdvancedSearch->SearchValue);
			$this->b_04_head->PlaceHolder = RemoveHtml($this->b_04_head->caption());

			// b_05_head
			$this->b_05_head->EditAttrs["class"] = "form-control";
			$this->b_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_05_head->AdvancedSearch->SearchValue);
			$this->b_05_head->EditValue = HtmlEncode($this->b_05_head->AdvancedSearch->SearchValue);
			$this->b_05_head->PlaceHolder = RemoveHtml($this->b_05_head->caption());

			// b_06_head
			$this->b_06_head->EditAttrs["class"] = "form-control";
			$this->b_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_06_head->AdvancedSearch->SearchValue);
			$this->b_06_head->EditValue = HtmlEncode($this->b_06_head->AdvancedSearch->SearchValue);
			$this->b_06_head->PlaceHolder = RemoveHtml($this->b_06_head->caption());

			// b_07_head
			$this->b_07_head->EditAttrs["class"] = "form-control";
			$this->b_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_07_head->AdvancedSearch->SearchValue);
			$this->b_07_head->EditValue = HtmlEncode($this->b_07_head->AdvancedSearch->SearchValue);
			$this->b_07_head->PlaceHolder = RemoveHtml($this->b_07_head->caption());

			// b_08_head
			$this->b_08_head->EditAttrs["class"] = "form-control";
			$this->b_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_08_head->AdvancedSearch->SearchValue);
			$this->b_08_head->EditValue = HtmlEncode($this->b_08_head->AdvancedSearch->SearchValue);
			$this->b_08_head->PlaceHolder = RemoveHtml($this->b_08_head->caption());

			// b_09_head
			$this->b_09_head->EditAttrs["class"] = "form-control";
			$this->b_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_09_head->AdvancedSearch->SearchValue);
			$this->b_09_head->EditValue = HtmlEncode($this->b_09_head->AdvancedSearch->SearchValue);
			$this->b_09_head->PlaceHolder = RemoveHtml($this->b_09_head->caption());

			// b_10_head
			$this->b_10_head->EditAttrs["class"] = "form-control";
			$this->b_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_10_head->AdvancedSearch->SearchValue);
			$this->b_10_head->EditValue = HtmlEncode($this->b_10_head->AdvancedSearch->SearchValue);
			$this->b_10_head->PlaceHolder = RemoveHtml($this->b_10_head->caption());

			// b_11_head
			$this->b_11_head->EditAttrs["class"] = "form-control";
			$this->b_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_11_head->AdvancedSearch->SearchValue);
			$this->b_11_head->EditValue = HtmlEncode($this->b_11_head->AdvancedSearch->SearchValue);
			$this->b_11_head->PlaceHolder = RemoveHtml($this->b_11_head->caption());

			// b_12_head
			$this->b_12_head->EditAttrs["class"] = "form-control";
			$this->b_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_12_head->AdvancedSearch->SearchValue);
			$this->b_12_head->EditValue = HtmlEncode($this->b_12_head->AdvancedSearch->SearchValue);
			$this->b_12_head->PlaceHolder = RemoveHtml($this->b_12_head->caption());

			// b_13_head
			$this->b_13_head->EditAttrs["class"] = "form-control";
			$this->b_13_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_13_head->AdvancedSearch->SearchValue);
			$this->b_13_head->EditValue = HtmlEncode($this->b_13_head->AdvancedSearch->SearchValue);
			$this->b_13_head->PlaceHolder = RemoveHtml($this->b_13_head->caption());

			// b_14_head
			$this->b_14_head->EditAttrs["class"] = "form-control";
			$this->b_14_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_14_head->AdvancedSearch->SearchValue);
			$this->b_14_head->EditValue = HtmlEncode($this->b_14_head->AdvancedSearch->SearchValue);
			$this->b_14_head->PlaceHolder = RemoveHtml($this->b_14_head->caption());

			// b_15_head
			$this->b_15_head->EditAttrs["class"] = "form-control";
			$this->b_15_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->b_15_head->AdvancedSearch->SearchValue);
			$this->b_15_head->EditValue = HtmlEncode($this->b_15_head->AdvancedSearch->SearchValue);
			$this->b_15_head->PlaceHolder = RemoveHtml($this->b_15_head->caption());

			// q_sku
			$this->q_sku->EditAttrs["class"] = "form-control";
			$this->q_sku->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->q_sku->AdvancedSearch->SearchValue = HtmlDecode($this->q_sku->AdvancedSearch->SearchValue);
			$this->q_sku->EditValue = HtmlEncode($this->q_sku->AdvancedSearch->SearchValue);
			$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

			// t_01_head
			$this->t_01_head->EditAttrs["class"] = "form-control";
			$this->t_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_01_head->AdvancedSearch->SearchValue);
			$this->t_01_head->EditValue = HtmlEncode($this->t_01_head->AdvancedSearch->SearchValue);
			$this->t_01_head->PlaceHolder = RemoveHtml($this->t_01_head->caption());

			// t_02_head
			$this->t_02_head->EditAttrs["class"] = "form-control";
			$this->t_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_02_head->AdvancedSearch->SearchValue);
			$this->t_02_head->EditValue = HtmlEncode($this->t_02_head->AdvancedSearch->SearchValue);
			$this->t_02_head->PlaceHolder = RemoveHtml($this->t_02_head->caption());

			// t_03_head
			$this->t_03_head->EditAttrs["class"] = "form-control";
			$this->t_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_03_head->AdvancedSearch->SearchValue);
			$this->t_03_head->EditValue = HtmlEncode($this->t_03_head->AdvancedSearch->SearchValue);
			$this->t_03_head->PlaceHolder = RemoveHtml($this->t_03_head->caption());

			// t_04_head
			$this->t_04_head->EditAttrs["class"] = "form-control";
			$this->t_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_04_head->AdvancedSearch->SearchValue);
			$this->t_04_head->EditValue = HtmlEncode($this->t_04_head->AdvancedSearch->SearchValue);
			$this->t_04_head->PlaceHolder = RemoveHtml($this->t_04_head->caption());

			// t_05_head
			$this->t_05_head->EditAttrs["class"] = "form-control";
			$this->t_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_05_head->AdvancedSearch->SearchValue);
			$this->t_05_head->EditValue = HtmlEncode($this->t_05_head->AdvancedSearch->SearchValue);
			$this->t_05_head->PlaceHolder = RemoveHtml($this->t_05_head->caption());

			// t_06_head
			$this->t_06_head->EditAttrs["class"] = "form-control";
			$this->t_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_06_head->AdvancedSearch->SearchValue);
			$this->t_06_head->EditValue = HtmlEncode($this->t_06_head->AdvancedSearch->SearchValue);
			$this->t_06_head->PlaceHolder = RemoveHtml($this->t_06_head->caption());

			// t_07_head
			$this->t_07_head->EditAttrs["class"] = "form-control";
			$this->t_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_07_head->AdvancedSearch->SearchValue);
			$this->t_07_head->EditValue = HtmlEncode($this->t_07_head->AdvancedSearch->SearchValue);
			$this->t_07_head->PlaceHolder = RemoveHtml($this->t_07_head->caption());

			// t_08_head
			$this->t_08_head->EditAttrs["class"] = "form-control";
			$this->t_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_08_head->AdvancedSearch->SearchValue);
			$this->t_08_head->EditValue = HtmlEncode($this->t_08_head->AdvancedSearch->SearchValue);
			$this->t_08_head->PlaceHolder = RemoveHtml($this->t_08_head->caption());

			// t_09_head
			$this->t_09_head->EditAttrs["class"] = "form-control";
			$this->t_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_09_head->AdvancedSearch->SearchValue);
			$this->t_09_head->EditValue = HtmlEncode($this->t_09_head->AdvancedSearch->SearchValue);
			$this->t_09_head->PlaceHolder = RemoveHtml($this->t_09_head->caption());

			// t_10_head
			$this->t_10_head->EditAttrs["class"] = "form-control";
			$this->t_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_10_head->AdvancedSearch->SearchValue);
			$this->t_10_head->EditValue = HtmlEncode($this->t_10_head->AdvancedSearch->SearchValue);
			$this->t_10_head->PlaceHolder = RemoveHtml($this->t_10_head->caption());

			// t_11_head
			$this->t_11_head->EditAttrs["class"] = "form-control";
			$this->t_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_11_head->AdvancedSearch->SearchValue);
			$this->t_11_head->EditValue = HtmlEncode($this->t_11_head->AdvancedSearch->SearchValue);
			$this->t_11_head->PlaceHolder = RemoveHtml($this->t_11_head->caption());

			// t_12_head
			$this->t_12_head->EditAttrs["class"] = "form-control";
			$this->t_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_12_head->AdvancedSearch->SearchValue);
			$this->t_12_head->EditValue = HtmlEncode($this->t_12_head->AdvancedSearch->SearchValue);
			$this->t_12_head->PlaceHolder = RemoveHtml($this->t_12_head->caption());

			// t_13_head
			$this->t_13_head->EditAttrs["class"] = "form-control";
			$this->t_13_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_13_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_13_head->AdvancedSearch->SearchValue);
			$this->t_13_head->EditValue = HtmlEncode($this->t_13_head->AdvancedSearch->SearchValue);
			$this->t_13_head->PlaceHolder = RemoveHtml($this->t_13_head->caption());

			// t_14_head
			$this->t_14_head->EditAttrs["class"] = "form-control";
			$this->t_14_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_14_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_14_head->AdvancedSearch->SearchValue);
			$this->t_14_head->EditValue = HtmlEncode($this->t_14_head->AdvancedSearch->SearchValue);
			$this->t_14_head->PlaceHolder = RemoveHtml($this->t_14_head->caption());

			// t_15_head
			$this->t_15_head->EditAttrs["class"] = "form-control";
			$this->t_15_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_15_head->AdvancedSearch->SearchValue = HtmlDecode($this->t_15_head->AdvancedSearch->SearchValue);
			$this->t_15_head->EditValue = HtmlEncode($this->t_15_head->AdvancedSearch->SearchValue);
			$this->t_15_head->PlaceHolder = RemoveHtml($this->t_15_head->caption());

			// po_01_head
			$this->po_01_head->EditAttrs["class"] = "form-control";
			$this->po_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_01_head->AdvancedSearch->SearchValue);
			$this->po_01_head->EditValue = HtmlEncode($this->po_01_head->AdvancedSearch->SearchValue);
			$this->po_01_head->PlaceHolder = RemoveHtml($this->po_01_head->caption());

			// po_02_head
			$this->po_02_head->EditAttrs["class"] = "form-control";
			$this->po_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_02_head->AdvancedSearch->SearchValue);
			$this->po_02_head->EditValue = HtmlEncode($this->po_02_head->AdvancedSearch->SearchValue);
			$this->po_02_head->PlaceHolder = RemoveHtml($this->po_02_head->caption());

			// po_03_head
			$this->po_03_head->EditAttrs["class"] = "form-control";
			$this->po_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_03_head->AdvancedSearch->SearchValue);
			$this->po_03_head->EditValue = HtmlEncode($this->po_03_head->AdvancedSearch->SearchValue);
			$this->po_03_head->PlaceHolder = RemoveHtml($this->po_03_head->caption());

			// po_04_head
			$this->po_04_head->EditAttrs["class"] = "form-control";
			$this->po_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_04_head->AdvancedSearch->SearchValue);
			$this->po_04_head->EditValue = HtmlEncode($this->po_04_head->AdvancedSearch->SearchValue);
			$this->po_04_head->PlaceHolder = RemoveHtml($this->po_04_head->caption());

			// po_05_head
			$this->po_05_head->EditAttrs["class"] = "form-control";
			$this->po_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_05_head->AdvancedSearch->SearchValue);
			$this->po_05_head->EditValue = HtmlEncode($this->po_05_head->AdvancedSearch->SearchValue);
			$this->po_05_head->PlaceHolder = RemoveHtml($this->po_05_head->caption());

			// po_06_head
			$this->po_06_head->EditAttrs["class"] = "form-control";
			$this->po_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_06_head->AdvancedSearch->SearchValue);
			$this->po_06_head->EditValue = HtmlEncode($this->po_06_head->AdvancedSearch->SearchValue);
			$this->po_06_head->PlaceHolder = RemoveHtml($this->po_06_head->caption());

			// po_07_head
			$this->po_07_head->EditAttrs["class"] = "form-control";
			$this->po_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_07_head->AdvancedSearch->SearchValue);
			$this->po_07_head->EditValue = HtmlEncode($this->po_07_head->AdvancedSearch->SearchValue);
			$this->po_07_head->PlaceHolder = RemoveHtml($this->po_07_head->caption());

			// po_08_head
			$this->po_08_head->EditAttrs["class"] = "form-control";
			$this->po_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_08_head->AdvancedSearch->SearchValue);
			$this->po_08_head->EditValue = HtmlEncode($this->po_08_head->AdvancedSearch->SearchValue);
			$this->po_08_head->PlaceHolder = RemoveHtml($this->po_08_head->caption());

			// po_17_head
			$this->po_17_head->EditAttrs["class"] = "form-control";
			$this->po_17_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_17_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_17_head->AdvancedSearch->SearchValue);
			$this->po_17_head->EditValue = HtmlEncode($this->po_17_head->AdvancedSearch->SearchValue);
			$this->po_17_head->PlaceHolder = RemoveHtml($this->po_17_head->caption());

			// po_18_head
			$this->po_18_head->EditAttrs["class"] = "form-control";
			$this->po_18_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_18_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_18_head->AdvancedSearch->SearchValue);
			$this->po_18_head->EditValue = HtmlEncode($this->po_18_head->AdvancedSearch->SearchValue);
			$this->po_18_head->PlaceHolder = RemoveHtml($this->po_18_head->caption());

			// po_19_head
			$this->po_19_head->EditAttrs["class"] = "form-control";
			$this->po_19_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_19_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_19_head->AdvancedSearch->SearchValue);
			$this->po_19_head->EditValue = HtmlEncode($this->po_19_head->AdvancedSearch->SearchValue);
			$this->po_19_head->PlaceHolder = RemoveHtml($this->po_19_head->caption());

			// po_20_head
			$this->po_20_head->EditAttrs["class"] = "form-control";
			$this->po_20_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_20_head->AdvancedSearch->SearchValue = HtmlDecode($this->po_20_head->AdvancedSearch->SearchValue);
			$this->po_20_head->EditValue = HtmlEncode($this->po_20_head->AdvancedSearch->SearchValue);
			$this->po_20_head->PlaceHolder = RemoveHtml($this->po_20_head->caption());

			// jc_01_head
			$this->jc_01_head->EditAttrs["class"] = "form-control";
			$this->jc_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_01_head->AdvancedSearch->SearchValue);
			$this->jc_01_head->EditValue = HtmlEncode($this->jc_01_head->AdvancedSearch->SearchValue);
			$this->jc_01_head->PlaceHolder = RemoveHtml($this->jc_01_head->caption());

			// jc_02_head
			$this->jc_02_head->EditAttrs["class"] = "form-control";
			$this->jc_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_02_head->AdvancedSearch->SearchValue);
			$this->jc_02_head->EditValue = HtmlEncode($this->jc_02_head->AdvancedSearch->SearchValue);
			$this->jc_02_head->PlaceHolder = RemoveHtml($this->jc_02_head->caption());

			// jc_03_head
			$this->jc_03_head->EditAttrs["class"] = "form-control";
			$this->jc_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_03_head->AdvancedSearch->SearchValue);
			$this->jc_03_head->EditValue = HtmlEncode($this->jc_03_head->AdvancedSearch->SearchValue);
			$this->jc_03_head->PlaceHolder = RemoveHtml($this->jc_03_head->caption());

			// jc_04_head
			$this->jc_04_head->EditAttrs["class"] = "form-control";
			$this->jc_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_04_head->AdvancedSearch->SearchValue);
			$this->jc_04_head->EditValue = HtmlEncode($this->jc_04_head->AdvancedSearch->SearchValue);
			$this->jc_04_head->PlaceHolder = RemoveHtml($this->jc_04_head->caption());

			// jc_05_head
			$this->jc_05_head->EditAttrs["class"] = "form-control";
			$this->jc_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_05_head->AdvancedSearch->SearchValue);
			$this->jc_05_head->EditValue = HtmlEncode($this->jc_05_head->AdvancedSearch->SearchValue);
			$this->jc_05_head->PlaceHolder = RemoveHtml($this->jc_05_head->caption());

			// jc_06_head
			$this->jc_06_head->EditAttrs["class"] = "form-control";
			$this->jc_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_06_head->AdvancedSearch->SearchValue);
			$this->jc_06_head->EditValue = HtmlEncode($this->jc_06_head->AdvancedSearch->SearchValue);
			$this->jc_06_head->PlaceHolder = RemoveHtml($this->jc_06_head->caption());

			// jc_07_head
			$this->jc_07_head->EditAttrs["class"] = "form-control";
			$this->jc_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_07_head->AdvancedSearch->SearchValue);
			$this->jc_07_head->EditValue = HtmlEncode($this->jc_07_head->AdvancedSearch->SearchValue);
			$this->jc_07_head->PlaceHolder = RemoveHtml($this->jc_07_head->caption());

			// jc_08_head
			$this->jc_08_head->EditAttrs["class"] = "form-control";
			$this->jc_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_08_head->AdvancedSearch->SearchValue);
			$this->jc_08_head->EditValue = HtmlEncode($this->jc_08_head->AdvancedSearch->SearchValue);
			$this->jc_08_head->PlaceHolder = RemoveHtml($this->jc_08_head->caption());

			// jc_09_head
			$this->jc_09_head->EditAttrs["class"] = "form-control";
			$this->jc_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_09_head->AdvancedSearch->SearchValue);
			$this->jc_09_head->EditValue = HtmlEncode($this->jc_09_head->AdvancedSearch->SearchValue);
			$this->jc_09_head->PlaceHolder = RemoveHtml($this->jc_09_head->caption());

			// jc_10_head
			$this->jc_10_head->EditAttrs["class"] = "form-control";
			$this->jc_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->jc_10_head->AdvancedSearch->SearchValue);
			$this->jc_10_head->EditValue = HtmlEncode($this->jc_10_head->AdvancedSearch->SearchValue);
			$this->jc_10_head->PlaceHolder = RemoveHtml($this->jc_10_head->caption());

			// pc_shape
			$this->pc_shape->EditAttrs["class"] = "form-control";
			$this->pc_shape->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_shape->AdvancedSearch->SearchValue = HtmlDecode($this->pc_shape->AdvancedSearch->SearchValue);
			$this->pc_shape->EditValue = HtmlEncode($this->pc_shape->AdvancedSearch->SearchValue);
			$this->pc_shape->PlaceHolder = RemoveHtml($this->pc_shape->caption());

			// pc_unit
			$this->pc_unit->EditAttrs["class"] = "form-control";
			$this->pc_unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_unit->AdvancedSearch->SearchValue = HtmlDecode($this->pc_unit->AdvancedSearch->SearchValue);
			$this->pc_unit->EditValue = HtmlEncode($this->pc_unit->AdvancedSearch->SearchValue);
			$this->pc_unit->PlaceHolder = RemoveHtml($this->pc_unit->caption());

			// pc_w
			$this->pc_w->EditAttrs["class"] = "form-control";
			$this->pc_w->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_w->AdvancedSearch->SearchValue = HtmlDecode($this->pc_w->AdvancedSearch->SearchValue);
			$this->pc_w->EditValue = HtmlEncode($this->pc_w->AdvancedSearch->SearchValue);
			$this->pc_w->PlaceHolder = RemoveHtml($this->pc_w->caption());

			// pc_l
			$this->pc_l->EditAttrs["class"] = "form-control";
			$this->pc_l->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_l->AdvancedSearch->SearchValue = HtmlDecode($this->pc_l->AdvancedSearch->SearchValue);
			$this->pc_l->EditValue = HtmlEncode($this->pc_l->AdvancedSearch->SearchValue);
			$this->pc_l->PlaceHolder = RemoveHtml($this->pc_l->caption());

			// pc_h
			$this->pc_h->EditAttrs["class"] = "form-control";
			$this->pc_h->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_h->AdvancedSearch->SearchValue = HtmlDecode($this->pc_h->AdvancedSearch->SearchValue);
			$this->pc_h->EditValue = HtmlEncode($this->pc_h->AdvancedSearch->SearchValue);
			$this->pc_h->PlaceHolder = RemoveHtml($this->pc_h->caption());

			// pc_partner_size
			$this->pc_partner_size->EditAttrs["class"] = "form-control";
			$this->pc_partner_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_partner_size->AdvancedSearch->SearchValue = HtmlDecode($this->pc_partner_size->AdvancedSearch->SearchValue);
			$this->pc_partner_size->EditValue = HtmlEncode($this->pc_partner_size->AdvancedSearch->SearchValue);
			$this->pc_partner_size->PlaceHolder = RemoveHtml($this->pc_partner_size->caption());

			// pc_sqm
			$this->pc_sqm->EditAttrs["class"] = "form-control";
			$this->pc_sqm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_sqm->AdvancedSearch->SearchValue = HtmlDecode($this->pc_sqm->AdvancedSearch->SearchValue);
			$this->pc_sqm->EditValue = HtmlEncode($this->pc_sqm->AdvancedSearch->SearchValue);
			$this->pc_sqm->PlaceHolder = RemoveHtml($this->pc_sqm->caption());

			// pc_01_head
			$this->pc_01_head->EditAttrs["class"] = "form-control";
			$this->pc_01_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_01_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_01_head->AdvancedSearch->SearchValue);
			$this->pc_01_head->EditValue = HtmlEncode($this->pc_01_head->AdvancedSearch->SearchValue);
			$this->pc_01_head->PlaceHolder = RemoveHtml($this->pc_01_head->caption());

			// pc_02_head
			$this->pc_02_head->EditAttrs["class"] = "form-control";
			$this->pc_02_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_02_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_02_head->AdvancedSearch->SearchValue);
			$this->pc_02_head->EditValue = HtmlEncode($this->pc_02_head->AdvancedSearch->SearchValue);
			$this->pc_02_head->PlaceHolder = RemoveHtml($this->pc_02_head->caption());

			// pc_03_head
			$this->pc_03_head->EditAttrs["class"] = "form-control";
			$this->pc_03_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_03_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_03_head->AdvancedSearch->SearchValue);
			$this->pc_03_head->EditValue = HtmlEncode($this->pc_03_head->AdvancedSearch->SearchValue);
			$this->pc_03_head->PlaceHolder = RemoveHtml($this->pc_03_head->caption());

			// pc_04_head
			$this->pc_04_head->EditAttrs["class"] = "form-control";
			$this->pc_04_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_04_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_04_head->AdvancedSearch->SearchValue);
			$this->pc_04_head->EditValue = HtmlEncode($this->pc_04_head->AdvancedSearch->SearchValue);
			$this->pc_04_head->PlaceHolder = RemoveHtml($this->pc_04_head->caption());

			// pc_05_head
			$this->pc_05_head->EditAttrs["class"] = "form-control";
			$this->pc_05_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_05_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_05_head->AdvancedSearch->SearchValue);
			$this->pc_05_head->EditValue = HtmlEncode($this->pc_05_head->AdvancedSearch->SearchValue);
			$this->pc_05_head->PlaceHolder = RemoveHtml($this->pc_05_head->caption());

			// pc_06_head
			$this->pc_06_head->EditAttrs["class"] = "form-control";
			$this->pc_06_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_06_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_06_head->AdvancedSearch->SearchValue);
			$this->pc_06_head->EditValue = HtmlEncode($this->pc_06_head->AdvancedSearch->SearchValue);
			$this->pc_06_head->PlaceHolder = RemoveHtml($this->pc_06_head->caption());

			// pc_07_head
			$this->pc_07_head->EditAttrs["class"] = "form-control";
			$this->pc_07_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_07_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_07_head->AdvancedSearch->SearchValue);
			$this->pc_07_head->EditValue = HtmlEncode($this->pc_07_head->AdvancedSearch->SearchValue);
			$this->pc_07_head->PlaceHolder = RemoveHtml($this->pc_07_head->caption());

			// pc_08_head
			$this->pc_08_head->EditAttrs["class"] = "form-control";
			$this->pc_08_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_08_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_08_head->AdvancedSearch->SearchValue);
			$this->pc_08_head->EditValue = HtmlEncode($this->pc_08_head->AdvancedSearch->SearchValue);
			$this->pc_08_head->PlaceHolder = RemoveHtml($this->pc_08_head->caption());

			// pc_09_head
			$this->pc_09_head->EditAttrs["class"] = "form-control";
			$this->pc_09_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_09_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_09_head->AdvancedSearch->SearchValue);
			$this->pc_09_head->EditValue = HtmlEncode($this->pc_09_head->AdvancedSearch->SearchValue);
			$this->pc_09_head->PlaceHolder = RemoveHtml($this->pc_09_head->caption());

			// pc_10_head
			$this->pc_10_head->EditAttrs["class"] = "form-control";
			$this->pc_10_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_10_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_10_head->AdvancedSearch->SearchValue);
			$this->pc_10_head->EditValue = HtmlEncode($this->pc_10_head->AdvancedSearch->SearchValue);
			$this->pc_10_head->PlaceHolder = RemoveHtml($this->pc_10_head->caption());

			// pc_11_head
			$this->pc_11_head->EditAttrs["class"] = "form-control";
			$this->pc_11_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_11_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_11_head->AdvancedSearch->SearchValue);
			$this->pc_11_head->EditValue = HtmlEncode($this->pc_11_head->AdvancedSearch->SearchValue);
			$this->pc_11_head->PlaceHolder = RemoveHtml($this->pc_11_head->caption());

			// pc_12_head
			$this->pc_12_head->EditAttrs["class"] = "form-control";
			$this->pc_12_head->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pc_12_head->AdvancedSearch->SearchValue = HtmlDecode($this->pc_12_head->AdvancedSearch->SearchValue);
			$this->pc_12_head->EditValue = HtmlEncode($this->pc_12_head->AdvancedSearch->SearchValue);
			$this->pc_12_head->PlaceHolder = RemoveHtml($this->pc_12_head->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
			$this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
			$this->image->PlaceHolder = RemoveHtml($this->image->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->product_group->AdvancedSearch->load();
		$this->calculation_method->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->v_00->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_01_validation->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_02_validation->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_03_validation->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_04_validation->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->v_05_validation->AdvancedSearch->load();
		$this->v_06->AdvancedSearch->load();
		$this->v_06_validation->AdvancedSearch->load();
		$this->v_07->AdvancedSearch->load();
		$this->v_07_validation->AdvancedSearch->load();
		$this->v_08->AdvancedSearch->load();
		$this->v_08_validation->AdvancedSearch->load();
		$this->v_09->AdvancedSearch->load();
		$this->v_09_validation->AdvancedSearch->load();
		$this->v_10->AdvancedSearch->load();
		$this->v_10_validation->AdvancedSearch->load();
		$this->b_01_head->AdvancedSearch->load();
		$this->b_02_head->AdvancedSearch->load();
		$this->b_03_head->AdvancedSearch->load();
		$this->b_04_head->AdvancedSearch->load();
		$this->b_05_head->AdvancedSearch->load();
		$this->b_06_head->AdvancedSearch->load();
		$this->b_07_head->AdvancedSearch->load();
		$this->b_08_head->AdvancedSearch->load();
		$this->b_09_head->AdvancedSearch->load();
		$this->b_10_head->AdvancedSearch->load();
		$this->b_11_head->AdvancedSearch->load();
		$this->b_12_head->AdvancedSearch->load();
		$this->b_13_head->AdvancedSearch->load();
		$this->b_14_head->AdvancedSearch->load();
		$this->b_15_head->AdvancedSearch->load();
		$this->q_sku->AdvancedSearch->load();
		$this->t_01_head->AdvancedSearch->load();
		$this->t_02_head->AdvancedSearch->load();
		$this->t_03_head->AdvancedSearch->load();
		$this->t_04_head->AdvancedSearch->load();
		$this->t_05_head->AdvancedSearch->load();
		$this->t_06_head->AdvancedSearch->load();
		$this->t_07_head->AdvancedSearch->load();
		$this->t_08_head->AdvancedSearch->load();
		$this->t_09_head->AdvancedSearch->load();
		$this->t_10_head->AdvancedSearch->load();
		$this->t_11_head->AdvancedSearch->load();
		$this->t_12_head->AdvancedSearch->load();
		$this->t_13_head->AdvancedSearch->load();
		$this->t_14_head->AdvancedSearch->load();
		$this->t_15_head->AdvancedSearch->load();
		$this->po_01_head->AdvancedSearch->load();
		$this->po_02_head->AdvancedSearch->load();
		$this->po_03_head->AdvancedSearch->load();
		$this->po_04_head->AdvancedSearch->load();
		$this->po_05_head->AdvancedSearch->load();
		$this->po_06_head->AdvancedSearch->load();
		$this->po_07_head->AdvancedSearch->load();
		$this->po_08_head->AdvancedSearch->load();
		$this->po_17_head->AdvancedSearch->load();
		$this->po_18_head->AdvancedSearch->load();
		$this->po_19_head->AdvancedSearch->load();
		$this->po_20_head->AdvancedSearch->load();
		$this->jc_01_head->AdvancedSearch->load();
		$this->jc_02_head->AdvancedSearch->load();
		$this->jc_03_head->AdvancedSearch->load();
		$this->jc_04_head->AdvancedSearch->load();
		$this->jc_05_head->AdvancedSearch->load();
		$this->jc_06_head->AdvancedSearch->load();
		$this->jc_07_head->AdvancedSearch->load();
		$this->jc_08_head->AdvancedSearch->load();
		$this->jc_09_head->AdvancedSearch->load();
		$this->jc_10_head->AdvancedSearch->load();
		$this->pc_shape->AdvancedSearch->load();
		$this->pc_unit->AdvancedSearch->load();
		$this->pc_w->AdvancedSearch->load();
		$this->pc_l->AdvancedSearch->load();
		$this->pc_h->AdvancedSearch->load();
		$this->pc_partner_size->AdvancedSearch->load();
		$this->pc_sqm->AdvancedSearch->load();
		$this->pc_01_head->AdvancedSearch->load();
		$this->pc_02_head->AdvancedSearch->load();
		$this->pc_03_head->AdvancedSearch->load();
		$this->pc_04_head->AdvancedSearch->load();
		$this->pc_05_head->AdvancedSearch->load();
		$this->pc_06_head->AdvancedSearch->load();
		$this->pc_07_head->AdvancedSearch->load();
		$this->pc_08_head->AdvancedSearch->load();
		$this->pc_09_head->AdvancedSearch->load();
		$this->pc_10_head->AdvancedSearch->load();
		$this->pc_11_head->AdvancedSearch->load();
		$this->pc_12_head->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("product_grouplist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_calculation_method":
							break;
						case "x_process":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>