<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class product_group_view extends product_group
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'product_group';

	// Page object name
	public $PageObjName = "product_group_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (product_group)
		if (!isset($GLOBALS["product_group"]) || get_class($GLOBALS["product_group"]) == PROJECT_NAMESPACE . "product_group") {
			$GLOBALS["product_group"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["product_group"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'product_group');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $product_group;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($product_group);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "product_groupview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("product_grouplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->product_group->setVisibility();
		$this->calculation_method->setVisibility();
		$this->shape->setVisibility();
		$this->sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->process->setVisibility();
		$this->status->setVisibility();
		$this->v_00->setVisibility();
		$this->v_01->setVisibility();
		$this->v_01_validation->setVisibility();
		$this->v_02->setVisibility();
		$this->v_02_validation->setVisibility();
		$this->v_03->setVisibility();
		$this->v_03_validation->setVisibility();
		$this->v_04->setVisibility();
		$this->v_04_validation->setVisibility();
		$this->v_05->setVisibility();
		$this->v_05_validation->setVisibility();
		$this->v_06->setVisibility();
		$this->v_06_validation->setVisibility();
		$this->v_07->setVisibility();
		$this->v_07_validation->setVisibility();
		$this->v_08->setVisibility();
		$this->v_08_validation->setVisibility();
		$this->v_09->setVisibility();
		$this->v_09_validation->setVisibility();
		$this->v_10->setVisibility();
		$this->v_10_validation->setVisibility();
		$this->b_01_head->setVisibility();
		$this->b_02_head->setVisibility();
		$this->b_03_head->setVisibility();
		$this->b_04_head->setVisibility();
		$this->b_05_head->setVisibility();
		$this->b_06_head->setVisibility();
		$this->b_07_head->setVisibility();
		$this->b_08_head->setVisibility();
		$this->b_09_head->setVisibility();
		$this->b_10_head->setVisibility();
		$this->b_11_head->setVisibility();
		$this->b_12_head->setVisibility();
		$this->b_13_head->setVisibility();
		$this->b_14_head->setVisibility();
		$this->b_15_head->setVisibility();
		$this->q_sku->setVisibility();
		$this->t_01_head->setVisibility();
		$this->t_02_head->setVisibility();
		$this->t_03_head->setVisibility();
		$this->t_04_head->setVisibility();
		$this->t_05_head->setVisibility();
		$this->t_06_head->setVisibility();
		$this->t_07_head->setVisibility();
		$this->t_08_head->setVisibility();
		$this->t_09_head->setVisibility();
		$this->t_10_head->setVisibility();
		$this->t_11_head->setVisibility();
		$this->t_12_head->setVisibility();
		$this->t_13_head->setVisibility();
		$this->t_14_head->setVisibility();
		$this->t_15_head->setVisibility();
		$this->po_01_head->setVisibility();
		$this->po_02_head->setVisibility();
		$this->po_03_head->setVisibility();
		$this->po_04_head->setVisibility();
		$this->po_05_head->setVisibility();
		$this->po_06_head->setVisibility();
		$this->po_07_head->setVisibility();
		$this->po_08_head->setVisibility();
		$this->po_17_head->setVisibility();
		$this->po_18_head->setVisibility();
		$this->po_19_head->setVisibility();
		$this->po_20_head->setVisibility();
		$this->jc_01_head->setVisibility();
		$this->jc_02_head->setVisibility();
		$this->jc_03_head->setVisibility();
		$this->jc_04_head->setVisibility();
		$this->jc_05_head->setVisibility();
		$this->jc_06_head->setVisibility();
		$this->jc_07_head->setVisibility();
		$this->jc_08_head->setVisibility();
		$this->jc_09_head->setVisibility();
		$this->jc_10_head->setVisibility();
		$this->pc_shape->setVisibility();
		$this->pc_unit->setVisibility();
		$this->pc_w->setVisibility();
		$this->pc_l->setVisibility();
		$this->pc_h->setVisibility();
		$this->pc_partner_size->setVisibility();
		$this->pc_sqm->setVisibility();
		$this->pc_01_head->setVisibility();
		$this->pc_02_head->setVisibility();
		$this->pc_03_head->setVisibility();
		$this->pc_04_head->setVisibility();
		$this->pc_05_head->setVisibility();
		$this->pc_06_head->setVisibility();
		$this->pc_07_head->setVisibility();
		$this->pc_08_head->setVisibility();
		$this->pc_09_head->setVisibility();
		$this->pc_10_head->setVisibility();
		$this->pc_11_head->setVisibility();
		$this->pc_12_head->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->image->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->calculation_method);
		$this->setupLookupOptions($this->process);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "product_grouplist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "product_grouplist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "product_grouplist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->canAdd());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->product_group->setDbValue($row['product_group']);
		$this->calculation_method->setDbValue($row['calculation_method']);
		$this->shape->setDbValue($row['shape']);
		$this->sqm->setDbValue($row['sqm']);
		$this->cbm->setDbValue($row['cbm']);
		$this->process->setDbValue($row['process']);
		$this->status->setDbValue($row['status']);
		$this->v_00->setDbValue($row['v_00']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_01_validation->setDbValue($row['v_01_validation']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_02_validation->setDbValue($row['v_02_validation']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_03_validation->setDbValue($row['v_03_validation']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_04_validation->setDbValue($row['v_04_validation']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_05_validation->setDbValue($row['v_05_validation']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_06_validation->setDbValue($row['v_06_validation']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_07_validation->setDbValue($row['v_07_validation']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_08_validation->setDbValue($row['v_08_validation']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_09_validation->setDbValue($row['v_09_validation']);
		$this->v_10->setDbValue($row['v_10']);
		$this->v_10_validation->setDbValue($row['v_10_validation']);
		$this->b_01_head->setDbValue($row['b_01_head']);
		$this->b_02_head->setDbValue($row['b_02_head']);
		$this->b_03_head->setDbValue($row['b_03_head']);
		$this->b_04_head->setDbValue($row['b_04_head']);
		$this->b_05_head->setDbValue($row['b_05_head']);
		$this->b_06_head->setDbValue($row['b_06_head']);
		$this->b_07_head->setDbValue($row['b_07_head']);
		$this->b_08_head->setDbValue($row['b_08_head']);
		$this->b_09_head->setDbValue($row['b_09_head']);
		$this->b_10_head->setDbValue($row['b_10_head']);
		$this->b_11_head->setDbValue($row['b_11_head']);
		$this->b_12_head->setDbValue($row['b_12_head']);
		$this->b_13_head->setDbValue($row['b_13_head']);
		$this->b_14_head->setDbValue($row['b_14_head']);
		$this->b_15_head->setDbValue($row['b_15_head']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->t_01_head->setDbValue($row['t_01_head']);
		$this->t_02_head->setDbValue($row['t_02_head']);
		$this->t_03_head->setDbValue($row['t_03_head']);
		$this->t_04_head->setDbValue($row['t_04_head']);
		$this->t_05_head->setDbValue($row['t_05_head']);
		$this->t_06_head->setDbValue($row['t_06_head']);
		$this->t_07_head->setDbValue($row['t_07_head']);
		$this->t_08_head->setDbValue($row['t_08_head']);
		$this->t_09_head->setDbValue($row['t_09_head']);
		$this->t_10_head->setDbValue($row['t_10_head']);
		$this->t_11_head->setDbValue($row['t_11_head']);
		$this->t_12_head->setDbValue($row['t_12_head']);
		$this->t_13_head->setDbValue($row['t_13_head']);
		$this->t_14_head->setDbValue($row['t_14_head']);
		$this->t_15_head->setDbValue($row['t_15_head']);
		$this->po_01_head->setDbValue($row['po_01_head']);
		$this->po_02_head->setDbValue($row['po_02_head']);
		$this->po_03_head->setDbValue($row['po_03_head']);
		$this->po_04_head->setDbValue($row['po_04_head']);
		$this->po_05_head->setDbValue($row['po_05_head']);
		$this->po_06_head->setDbValue($row['po_06_head']);
		$this->po_07_head->setDbValue($row['po_07_head']);
		$this->po_08_head->setDbValue($row['po_08_head']);
		$this->po_17_head->setDbValue($row['po_17_head']);
		$this->po_18_head->setDbValue($row['po_18_head']);
		$this->po_19_head->setDbValue($row['po_19_head']);
		$this->po_20_head->setDbValue($row['po_20_head']);
		$this->jc_01_head->setDbValue($row['jc_01_head']);
		$this->jc_02_head->setDbValue($row['jc_02_head']);
		$this->jc_03_head->setDbValue($row['jc_03_head']);
		$this->jc_04_head->setDbValue($row['jc_04_head']);
		$this->jc_05_head->setDbValue($row['jc_05_head']);
		$this->jc_06_head->setDbValue($row['jc_06_head']);
		$this->jc_07_head->setDbValue($row['jc_07_head']);
		$this->jc_08_head->setDbValue($row['jc_08_head']);
		$this->jc_09_head->setDbValue($row['jc_09_head']);
		$this->jc_10_head->setDbValue($row['jc_10_head']);
		$this->pc_shape->setDbValue($row['pc_shape']);
		$this->pc_unit->setDbValue($row['pc_unit']);
		$this->pc_w->setDbValue($row['pc_w']);
		$this->pc_l->setDbValue($row['pc_l']);
		$this->pc_h->setDbValue($row['pc_h']);
		$this->pc_partner_size->setDbValue($row['pc_partner_size']);
		$this->pc_sqm->setDbValue($row['pc_sqm']);
		$this->pc_01_head->setDbValue($row['pc_01_head']);
		$this->pc_02_head->setDbValue($row['pc_02_head']);
		$this->pc_03_head->setDbValue($row['pc_03_head']);
		$this->pc_04_head->setDbValue($row['pc_04_head']);
		$this->pc_05_head->setDbValue($row['pc_05_head']);
		$this->pc_06_head->setDbValue($row['pc_06_head']);
		$this->pc_07_head->setDbValue($row['pc_07_head']);
		$this->pc_08_head->setDbValue($row['pc_08_head']);
		$this->pc_09_head->setDbValue($row['pc_09_head']);
		$this->pc_10_head->setDbValue($row['pc_10_head']);
		$this->pc_11_head->setDbValue($row['pc_11_head']);
		$this->pc_12_head->setDbValue($row['pc_12_head']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['grp'] = NULL;
		$row['product_group'] = NULL;
		$row['calculation_method'] = NULL;
		$row['shape'] = NULL;
		$row['sqm'] = NULL;
		$row['cbm'] = NULL;
		$row['process'] = NULL;
		$row['status'] = NULL;
		$row['v_00'] = NULL;
		$row['v_01'] = NULL;
		$row['v_01_validation'] = NULL;
		$row['v_02'] = NULL;
		$row['v_02_validation'] = NULL;
		$row['v_03'] = NULL;
		$row['v_03_validation'] = NULL;
		$row['v_04'] = NULL;
		$row['v_04_validation'] = NULL;
		$row['v_05'] = NULL;
		$row['v_05_validation'] = NULL;
		$row['v_06'] = NULL;
		$row['v_06_validation'] = NULL;
		$row['v_07'] = NULL;
		$row['v_07_validation'] = NULL;
		$row['v_08'] = NULL;
		$row['v_08_validation'] = NULL;
		$row['v_09'] = NULL;
		$row['v_09_validation'] = NULL;
		$row['v_10'] = NULL;
		$row['v_10_validation'] = NULL;
		$row['b_01_head'] = NULL;
		$row['b_02_head'] = NULL;
		$row['b_03_head'] = NULL;
		$row['b_04_head'] = NULL;
		$row['b_05_head'] = NULL;
		$row['b_06_head'] = NULL;
		$row['b_07_head'] = NULL;
		$row['b_08_head'] = NULL;
		$row['b_09_head'] = NULL;
		$row['b_10_head'] = NULL;
		$row['b_11_head'] = NULL;
		$row['b_12_head'] = NULL;
		$row['b_13_head'] = NULL;
		$row['b_14_head'] = NULL;
		$row['b_15_head'] = NULL;
		$row['q_sku'] = NULL;
		$row['t_01_head'] = NULL;
		$row['t_02_head'] = NULL;
		$row['t_03_head'] = NULL;
		$row['t_04_head'] = NULL;
		$row['t_05_head'] = NULL;
		$row['t_06_head'] = NULL;
		$row['t_07_head'] = NULL;
		$row['t_08_head'] = NULL;
		$row['t_09_head'] = NULL;
		$row['t_10_head'] = NULL;
		$row['t_11_head'] = NULL;
		$row['t_12_head'] = NULL;
		$row['t_13_head'] = NULL;
		$row['t_14_head'] = NULL;
		$row['t_15_head'] = NULL;
		$row['po_01_head'] = NULL;
		$row['po_02_head'] = NULL;
		$row['po_03_head'] = NULL;
		$row['po_04_head'] = NULL;
		$row['po_05_head'] = NULL;
		$row['po_06_head'] = NULL;
		$row['po_07_head'] = NULL;
		$row['po_08_head'] = NULL;
		$row['po_17_head'] = NULL;
		$row['po_18_head'] = NULL;
		$row['po_19_head'] = NULL;
		$row['po_20_head'] = NULL;
		$row['jc_01_head'] = NULL;
		$row['jc_02_head'] = NULL;
		$row['jc_03_head'] = NULL;
		$row['jc_04_head'] = NULL;
		$row['jc_05_head'] = NULL;
		$row['jc_06_head'] = NULL;
		$row['jc_07_head'] = NULL;
		$row['jc_08_head'] = NULL;
		$row['jc_09_head'] = NULL;
		$row['jc_10_head'] = NULL;
		$row['pc_shape'] = NULL;
		$row['pc_unit'] = NULL;
		$row['pc_w'] = NULL;
		$row['pc_l'] = NULL;
		$row['pc_h'] = NULL;
		$row['pc_partner_size'] = NULL;
		$row['pc_sqm'] = NULL;
		$row['pc_01_head'] = NULL;
		$row['pc_02_head'] = NULL;
		$row['pc_03_head'] = NULL;
		$row['pc_04_head'] = NULL;
		$row['pc_05_head'] = NULL;
		$row['pc_06_head'] = NULL;
		$row['pc_07_head'] = NULL;
		$row['pc_08_head'] = NULL;
		$row['pc_09_head'] = NULL;
		$row['pc_10_head'] = NULL;
		$row['pc_11_head'] = NULL;
		$row['pc_12_head'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['image'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// product_group
		// calculation_method
		// shape
		// sqm
		// cbm
		// process
		// status
		// v_00
		// v_01
		// v_01_validation
		// v_02
		// v_02_validation
		// v_03
		// v_03_validation
		// v_04
		// v_04_validation
		// v_05
		// v_05_validation
		// v_06
		// v_06_validation
		// v_07
		// v_07_validation
		// v_08
		// v_08_validation
		// v_09
		// v_09_validation
		// v_10
		// v_10_validation
		// b_01_head
		// b_02_head
		// b_03_head
		// b_04_head
		// b_05_head
		// b_06_head
		// b_07_head
		// b_08_head
		// b_09_head
		// b_10_head
		// b_11_head
		// b_12_head
		// b_13_head
		// b_14_head
		// b_15_head
		// q_sku
		// t_01_head
		// t_02_head
		// t_03_head
		// t_04_head
		// t_05_head
		// t_06_head
		// t_07_head
		// t_08_head
		// t_09_head
		// t_10_head
		// t_11_head
		// t_12_head
		// t_13_head
		// t_14_head
		// t_15_head
		// po_01_head
		// po_02_head
		// po_03_head
		// po_04_head
		// po_05_head
		// po_06_head
		// po_07_head
		// po_08_head
		// po_17_head
		// po_18_head
		// po_19_head
		// po_20_head
		// jc_01_head
		// jc_02_head
		// jc_03_head
		// jc_04_head
		// jc_05_head
		// jc_06_head
		// jc_07_head
		// jc_08_head
		// jc_09_head
		// jc_10_head
		// pc_shape
		// pc_unit
		// pc_w
		// pc_l
		// pc_h
		// pc_partner_size
		// pc_sqm
		// pc_01_head
		// pc_02_head
		// pc_03_head
		// pc_04_head
		// pc_05_head
		// pc_06_head
		// pc_07_head
		// pc_08_head
		// pc_09_head
		// pc_10_head
		// pc_11_head
		// pc_12_head
		// operator
		// datetime
		// image

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// product_group
			$this->product_group->ViewValue = $this->product_group->CurrentValue;
			$this->product_group->ViewCustomAttributes = "";

			// calculation_method
			$curVal = strval($this->calculation_method->CurrentValue);
			if ($curVal <> "") {
				$this->calculation_method->ViewValue = $this->calculation_method->lookupCacheOption($curVal);
				if ($this->calculation_method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->calculation_method->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->calculation_method->ViewValue = $this->calculation_method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->calculation_method->ViewValue = $this->calculation_method->CurrentValue;
					}
				}
			} else {
				$this->calculation_method->ViewValue = NULL;
			}
			$this->calculation_method->ViewCustomAttributes = "";

			// shape
			$this->shape->ViewValue = $this->shape->CurrentValue;
			$this->shape->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// v_00
			$this->v_00->ViewValue = $this->v_00->CurrentValue;
			$this->v_00->ViewCustomAttributes = "";

			// v_01
			$this->v_01->ViewValue = $this->v_01->CurrentValue;
			$this->v_01->ViewCustomAttributes = "";

			// v_01_validation
			$this->v_01_validation->ViewValue = $this->v_01_validation->CurrentValue;
			$this->v_01_validation->ViewCustomAttributes = "";

			// v_02
			$this->v_02->ViewValue = $this->v_02->CurrentValue;
			$this->v_02->ViewCustomAttributes = "";

			// v_02_validation
			$this->v_02_validation->ViewValue = $this->v_02_validation->CurrentValue;
			$this->v_02_validation->ViewCustomAttributes = "";

			// v_03
			$this->v_03->ViewValue = $this->v_03->CurrentValue;
			$this->v_03->ViewCustomAttributes = "";

			// v_03_validation
			$this->v_03_validation->ViewValue = $this->v_03_validation->CurrentValue;
			$this->v_03_validation->ViewCustomAttributes = "";

			// v_04
			$this->v_04->ViewValue = $this->v_04->CurrentValue;
			$this->v_04->ViewCustomAttributes = "";

			// v_04_validation
			$this->v_04_validation->ViewValue = $this->v_04_validation->CurrentValue;
			$this->v_04_validation->ViewCustomAttributes = "";

			// v_05
			$this->v_05->ViewValue = $this->v_05->CurrentValue;
			$this->v_05->ViewCustomAttributes = "";

			// v_05_validation
			$this->v_05_validation->ViewValue = $this->v_05_validation->CurrentValue;
			$this->v_05_validation->ViewCustomAttributes = "";

			// v_06
			$this->v_06->ViewValue = $this->v_06->CurrentValue;
			$this->v_06->ViewCustomAttributes = "";

			// v_06_validation
			$this->v_06_validation->ViewValue = $this->v_06_validation->CurrentValue;
			$this->v_06_validation->ViewCustomAttributes = "";

			// v_07
			$this->v_07->ViewValue = $this->v_07->CurrentValue;
			$this->v_07->ViewCustomAttributes = "";

			// v_07_validation
			$this->v_07_validation->ViewValue = $this->v_07_validation->CurrentValue;
			$this->v_07_validation->ViewCustomAttributes = "";

			// v_08
			$this->v_08->ViewValue = $this->v_08->CurrentValue;
			$this->v_08->ViewCustomAttributes = "";

			// v_08_validation
			$this->v_08_validation->ViewValue = $this->v_08_validation->CurrentValue;
			$this->v_08_validation->ViewCustomAttributes = "";

			// v_09
			$this->v_09->ViewValue = $this->v_09->CurrentValue;
			$this->v_09->ViewCustomAttributes = "";

			// v_09_validation
			$this->v_09_validation->ViewValue = $this->v_09_validation->CurrentValue;
			$this->v_09_validation->ViewCustomAttributes = "";

			// v_10
			$this->v_10->ViewValue = $this->v_10->CurrentValue;
			$this->v_10->ViewCustomAttributes = "";

			// v_10_validation
			$this->v_10_validation->ViewValue = $this->v_10_validation->CurrentValue;
			$this->v_10_validation->ViewCustomAttributes = "";

			// b_01_head
			$this->b_01_head->ViewValue = $this->b_01_head->CurrentValue;
			$this->b_01_head->ViewCustomAttributes = "";

			// b_02_head
			$this->b_02_head->ViewValue = $this->b_02_head->CurrentValue;
			$this->b_02_head->ViewCustomAttributes = "";

			// b_03_head
			$this->b_03_head->ViewValue = $this->b_03_head->CurrentValue;
			$this->b_03_head->ViewCustomAttributes = "";

			// b_04_head
			$this->b_04_head->ViewValue = $this->b_04_head->CurrentValue;
			$this->b_04_head->ViewCustomAttributes = "";

			// b_05_head
			$this->b_05_head->ViewValue = $this->b_05_head->CurrentValue;
			$this->b_05_head->ViewCustomAttributes = "";

			// b_06_head
			$this->b_06_head->ViewValue = $this->b_06_head->CurrentValue;
			$this->b_06_head->ViewCustomAttributes = "";

			// b_07_head
			$this->b_07_head->ViewValue = $this->b_07_head->CurrentValue;
			$this->b_07_head->ViewCustomAttributes = "";

			// b_08_head
			$this->b_08_head->ViewValue = $this->b_08_head->CurrentValue;
			$this->b_08_head->ViewCustomAttributes = "";

			// b_09_head
			$this->b_09_head->ViewValue = $this->b_09_head->CurrentValue;
			$this->b_09_head->ViewCustomAttributes = "";

			// b_10_head
			$this->b_10_head->ViewValue = $this->b_10_head->CurrentValue;
			$this->b_10_head->ViewCustomAttributes = "";

			// b_11_head
			$this->b_11_head->ViewValue = $this->b_11_head->CurrentValue;
			$this->b_11_head->ViewCustomAttributes = "";

			// b_12_head
			$this->b_12_head->ViewValue = $this->b_12_head->CurrentValue;
			$this->b_12_head->ViewCustomAttributes = "";

			// b_13_head
			$this->b_13_head->ViewValue = $this->b_13_head->CurrentValue;
			$this->b_13_head->ViewCustomAttributes = "";

			// b_14_head
			$this->b_14_head->ViewValue = $this->b_14_head->CurrentValue;
			$this->b_14_head->ViewCustomAttributes = "";

			// b_15_head
			$this->b_15_head->ViewValue = $this->b_15_head->CurrentValue;
			$this->b_15_head->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewCustomAttributes = "";

			// t_01_head
			$this->t_01_head->ViewValue = $this->t_01_head->CurrentValue;
			$this->t_01_head->ViewCustomAttributes = "";

			// t_02_head
			$this->t_02_head->ViewValue = $this->t_02_head->CurrentValue;
			$this->t_02_head->ViewCustomAttributes = "";

			// t_03_head
			$this->t_03_head->ViewValue = $this->t_03_head->CurrentValue;
			$this->t_03_head->ViewCustomAttributes = "";

			// t_04_head
			$this->t_04_head->ViewValue = $this->t_04_head->CurrentValue;
			$this->t_04_head->ViewCustomAttributes = "";

			// t_05_head
			$this->t_05_head->ViewValue = $this->t_05_head->CurrentValue;
			$this->t_05_head->ViewCustomAttributes = "";

			// t_06_head
			$this->t_06_head->ViewValue = $this->t_06_head->CurrentValue;
			$this->t_06_head->ViewCustomAttributes = "";

			// t_07_head
			$this->t_07_head->ViewValue = $this->t_07_head->CurrentValue;
			$this->t_07_head->ViewCustomAttributes = "";

			// t_08_head
			$this->t_08_head->ViewValue = $this->t_08_head->CurrentValue;
			$this->t_08_head->ViewCustomAttributes = "";

			// t_09_head
			$this->t_09_head->ViewValue = $this->t_09_head->CurrentValue;
			$this->t_09_head->ViewCustomAttributes = "";

			// t_10_head
			$this->t_10_head->ViewValue = $this->t_10_head->CurrentValue;
			$this->t_10_head->ViewCustomAttributes = "";

			// t_11_head
			$this->t_11_head->ViewValue = $this->t_11_head->CurrentValue;
			$this->t_11_head->ViewCustomAttributes = "";

			// t_12_head
			$this->t_12_head->ViewValue = $this->t_12_head->CurrentValue;
			$this->t_12_head->ViewCustomAttributes = "";

			// t_13_head
			$this->t_13_head->ViewValue = $this->t_13_head->CurrentValue;
			$this->t_13_head->ViewCustomAttributes = "";

			// t_14_head
			$this->t_14_head->ViewValue = $this->t_14_head->CurrentValue;
			$this->t_14_head->ViewCustomAttributes = "";

			// t_15_head
			$this->t_15_head->ViewValue = $this->t_15_head->CurrentValue;
			$this->t_15_head->ViewCustomAttributes = "";

			// po_01_head
			$this->po_01_head->ViewValue = $this->po_01_head->CurrentValue;
			$this->po_01_head->ViewCustomAttributes = "";

			// po_02_head
			$this->po_02_head->ViewValue = $this->po_02_head->CurrentValue;
			$this->po_02_head->ViewCustomAttributes = "";

			// po_03_head
			$this->po_03_head->ViewValue = $this->po_03_head->CurrentValue;
			$this->po_03_head->ViewCustomAttributes = "";

			// po_04_head
			$this->po_04_head->ViewValue = $this->po_04_head->CurrentValue;
			$this->po_04_head->ViewCustomAttributes = "";

			// po_05_head
			$this->po_05_head->ViewValue = $this->po_05_head->CurrentValue;
			$this->po_05_head->ViewCustomAttributes = "";

			// po_06_head
			$this->po_06_head->ViewValue = $this->po_06_head->CurrentValue;
			$this->po_06_head->ViewCustomAttributes = "";

			// po_07_head
			$this->po_07_head->ViewValue = $this->po_07_head->CurrentValue;
			$this->po_07_head->ViewCustomAttributes = "";

			// po_08_head
			$this->po_08_head->ViewValue = $this->po_08_head->CurrentValue;
			$this->po_08_head->ViewCustomAttributes = "";

			// po_17_head
			$this->po_17_head->ViewValue = $this->po_17_head->CurrentValue;
			$this->po_17_head->ViewCustomAttributes = "";

			// po_18_head
			$this->po_18_head->ViewValue = $this->po_18_head->CurrentValue;
			$this->po_18_head->ViewCustomAttributes = "";

			// po_19_head
			$this->po_19_head->ViewValue = $this->po_19_head->CurrentValue;
			$this->po_19_head->ViewCustomAttributes = "";

			// po_20_head
			$this->po_20_head->ViewValue = $this->po_20_head->CurrentValue;
			$this->po_20_head->ViewCustomAttributes = "";

			// jc_01_head
			$this->jc_01_head->ViewValue = $this->jc_01_head->CurrentValue;
			$this->jc_01_head->ViewCustomAttributes = "";

			// jc_02_head
			$this->jc_02_head->ViewValue = $this->jc_02_head->CurrentValue;
			$this->jc_02_head->ViewCustomAttributes = "";

			// jc_03_head
			$this->jc_03_head->ViewValue = $this->jc_03_head->CurrentValue;
			$this->jc_03_head->ViewCustomAttributes = "";

			// jc_04_head
			$this->jc_04_head->ViewValue = $this->jc_04_head->CurrentValue;
			$this->jc_04_head->ViewCustomAttributes = "";

			// jc_05_head
			$this->jc_05_head->ViewValue = $this->jc_05_head->CurrentValue;
			$this->jc_05_head->ViewCustomAttributes = "";

			// jc_06_head
			$this->jc_06_head->ViewValue = $this->jc_06_head->CurrentValue;
			$this->jc_06_head->ViewCustomAttributes = "";

			// jc_07_head
			$this->jc_07_head->ViewValue = $this->jc_07_head->CurrentValue;
			$this->jc_07_head->ViewCustomAttributes = "";

			// jc_08_head
			$this->jc_08_head->ViewValue = $this->jc_08_head->CurrentValue;
			$this->jc_08_head->ViewCustomAttributes = "";

			// jc_09_head
			$this->jc_09_head->ViewValue = $this->jc_09_head->CurrentValue;
			$this->jc_09_head->ViewCustomAttributes = "";

			// jc_10_head
			$this->jc_10_head->ViewValue = $this->jc_10_head->CurrentValue;
			$this->jc_10_head->ViewCustomAttributes = "";

			// pc_shape
			$this->pc_shape->ViewValue = $this->pc_shape->CurrentValue;
			$this->pc_shape->ViewCustomAttributes = "";

			// pc_unit
			$this->pc_unit->ViewValue = $this->pc_unit->CurrentValue;
			$this->pc_unit->ViewCustomAttributes = "";

			// pc_w
			$this->pc_w->ViewValue = $this->pc_w->CurrentValue;
			$this->pc_w->ViewCustomAttributes = "";

			// pc_l
			$this->pc_l->ViewValue = $this->pc_l->CurrentValue;
			$this->pc_l->ViewCustomAttributes = "";

			// pc_h
			$this->pc_h->ViewValue = $this->pc_h->CurrentValue;
			$this->pc_h->ViewCustomAttributes = "";

			// pc_partner_size
			$this->pc_partner_size->ViewValue = $this->pc_partner_size->CurrentValue;
			$this->pc_partner_size->ViewCustomAttributes = "";

			// pc_sqm
			$this->pc_sqm->ViewValue = $this->pc_sqm->CurrentValue;
			$this->pc_sqm->ViewCustomAttributes = "";

			// pc_01_head
			$this->pc_01_head->ViewValue = $this->pc_01_head->CurrentValue;
			$this->pc_01_head->ViewCustomAttributes = "";

			// pc_02_head
			$this->pc_02_head->ViewValue = $this->pc_02_head->CurrentValue;
			$this->pc_02_head->ViewCustomAttributes = "";

			// pc_03_head
			$this->pc_03_head->ViewValue = $this->pc_03_head->CurrentValue;
			$this->pc_03_head->ViewCustomAttributes = "";

			// pc_04_head
			$this->pc_04_head->ViewValue = $this->pc_04_head->CurrentValue;
			$this->pc_04_head->ViewCustomAttributes = "";

			// pc_05_head
			$this->pc_05_head->ViewValue = $this->pc_05_head->CurrentValue;
			$this->pc_05_head->ViewCustomAttributes = "";

			// pc_06_head
			$this->pc_06_head->ViewValue = $this->pc_06_head->CurrentValue;
			$this->pc_06_head->ViewCustomAttributes = "";

			// pc_07_head
			$this->pc_07_head->ViewValue = $this->pc_07_head->CurrentValue;
			$this->pc_07_head->ViewCustomAttributes = "";

			// pc_08_head
			$this->pc_08_head->ViewValue = $this->pc_08_head->CurrentValue;
			$this->pc_08_head->ViewCustomAttributes = "";

			// pc_09_head
			$this->pc_09_head->ViewValue = $this->pc_09_head->CurrentValue;
			$this->pc_09_head->ViewCustomAttributes = "";

			// pc_10_head
			$this->pc_10_head->ViewValue = $this->pc_10_head->CurrentValue;
			$this->pc_10_head->ViewCustomAttributes = "";

			// pc_11_head
			$this->pc_11_head->ViewValue = $this->pc_11_head->CurrentValue;
			$this->pc_11_head->ViewCustomAttributes = "";

			// pc_12_head
			$this->pc_12_head->ViewValue = $this->pc_12_head->CurrentValue;
			$this->pc_12_head->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// product_group
			$this->product_group->LinkCustomAttributes = "";
			$this->product_group->HrefValue = "";
			$this->product_group->TooltipValue = "";

			// calculation_method
			$this->calculation_method->LinkCustomAttributes = "";
			$this->calculation_method->HrefValue = "";
			$this->calculation_method->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// v_00
			$this->v_00->LinkCustomAttributes = "";
			$this->v_00->HrefValue = "";
			$this->v_00->TooltipValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";
			$this->v_01->TooltipValue = "";

			// v_01_validation
			$this->v_01_validation->LinkCustomAttributes = "";
			$this->v_01_validation->HrefValue = "";
			$this->v_01_validation->TooltipValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";
			$this->v_02->TooltipValue = "";

			// v_02_validation
			$this->v_02_validation->LinkCustomAttributes = "";
			$this->v_02_validation->HrefValue = "";
			$this->v_02_validation->TooltipValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";
			$this->v_03->TooltipValue = "";

			// v_03_validation
			$this->v_03_validation->LinkCustomAttributes = "";
			$this->v_03_validation->HrefValue = "";
			$this->v_03_validation->TooltipValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";
			$this->v_04->TooltipValue = "";

			// v_04_validation
			$this->v_04_validation->LinkCustomAttributes = "";
			$this->v_04_validation->HrefValue = "";
			$this->v_04_validation->TooltipValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";
			$this->v_05->TooltipValue = "";

			// v_05_validation
			$this->v_05_validation->LinkCustomAttributes = "";
			$this->v_05_validation->HrefValue = "";
			$this->v_05_validation->TooltipValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";
			$this->v_06->TooltipValue = "";

			// v_06_validation
			$this->v_06_validation->LinkCustomAttributes = "";
			$this->v_06_validation->HrefValue = "";
			$this->v_06_validation->TooltipValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";
			$this->v_07->TooltipValue = "";

			// v_07_validation
			$this->v_07_validation->LinkCustomAttributes = "";
			$this->v_07_validation->HrefValue = "";
			$this->v_07_validation->TooltipValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";
			$this->v_08->TooltipValue = "";

			// v_08_validation
			$this->v_08_validation->LinkCustomAttributes = "";
			$this->v_08_validation->HrefValue = "";
			$this->v_08_validation->TooltipValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";
			$this->v_09->TooltipValue = "";

			// v_09_validation
			$this->v_09_validation->LinkCustomAttributes = "";
			$this->v_09_validation->HrefValue = "";
			$this->v_09_validation->TooltipValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";
			$this->v_10->TooltipValue = "";

			// v_10_validation
			$this->v_10_validation->LinkCustomAttributes = "";
			$this->v_10_validation->HrefValue = "";
			$this->v_10_validation->TooltipValue = "";

			// b_01_head
			$this->b_01_head->LinkCustomAttributes = "";
			$this->b_01_head->HrefValue = "";
			$this->b_01_head->TooltipValue = "";

			// b_02_head
			$this->b_02_head->LinkCustomAttributes = "";
			$this->b_02_head->HrefValue = "";
			$this->b_02_head->TooltipValue = "";

			// b_03_head
			$this->b_03_head->LinkCustomAttributes = "";
			$this->b_03_head->HrefValue = "";
			$this->b_03_head->TooltipValue = "";

			// b_04_head
			$this->b_04_head->LinkCustomAttributes = "";
			$this->b_04_head->HrefValue = "";
			$this->b_04_head->TooltipValue = "";

			// b_05_head
			$this->b_05_head->LinkCustomAttributes = "";
			$this->b_05_head->HrefValue = "";
			$this->b_05_head->TooltipValue = "";

			// b_06_head
			$this->b_06_head->LinkCustomAttributes = "";
			$this->b_06_head->HrefValue = "";
			$this->b_06_head->TooltipValue = "";

			// b_07_head
			$this->b_07_head->LinkCustomAttributes = "";
			$this->b_07_head->HrefValue = "";
			$this->b_07_head->TooltipValue = "";

			// b_08_head
			$this->b_08_head->LinkCustomAttributes = "";
			$this->b_08_head->HrefValue = "";
			$this->b_08_head->TooltipValue = "";

			// b_09_head
			$this->b_09_head->LinkCustomAttributes = "";
			$this->b_09_head->HrefValue = "";
			$this->b_09_head->TooltipValue = "";

			// b_10_head
			$this->b_10_head->LinkCustomAttributes = "";
			$this->b_10_head->HrefValue = "";
			$this->b_10_head->TooltipValue = "";

			// b_11_head
			$this->b_11_head->LinkCustomAttributes = "";
			$this->b_11_head->HrefValue = "";
			$this->b_11_head->TooltipValue = "";

			// b_12_head
			$this->b_12_head->LinkCustomAttributes = "";
			$this->b_12_head->HrefValue = "";
			$this->b_12_head->TooltipValue = "";

			// b_13_head
			$this->b_13_head->LinkCustomAttributes = "";
			$this->b_13_head->HrefValue = "";
			$this->b_13_head->TooltipValue = "";

			// b_14_head
			$this->b_14_head->LinkCustomAttributes = "";
			$this->b_14_head->HrefValue = "";
			$this->b_14_head->TooltipValue = "";

			// b_15_head
			$this->b_15_head->LinkCustomAttributes = "";
			$this->b_15_head->HrefValue = "";
			$this->b_15_head->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// t_01_head
			$this->t_01_head->LinkCustomAttributes = "";
			$this->t_01_head->HrefValue = "";
			$this->t_01_head->TooltipValue = "";

			// t_02_head
			$this->t_02_head->LinkCustomAttributes = "";
			$this->t_02_head->HrefValue = "";
			$this->t_02_head->TooltipValue = "";

			// t_03_head
			$this->t_03_head->LinkCustomAttributes = "";
			$this->t_03_head->HrefValue = "";
			$this->t_03_head->TooltipValue = "";

			// t_04_head
			$this->t_04_head->LinkCustomAttributes = "";
			$this->t_04_head->HrefValue = "";
			$this->t_04_head->TooltipValue = "";

			// t_05_head
			$this->t_05_head->LinkCustomAttributes = "";
			$this->t_05_head->HrefValue = "";
			$this->t_05_head->TooltipValue = "";

			// t_06_head
			$this->t_06_head->LinkCustomAttributes = "";
			$this->t_06_head->HrefValue = "";
			$this->t_06_head->TooltipValue = "";

			// t_07_head
			$this->t_07_head->LinkCustomAttributes = "";
			$this->t_07_head->HrefValue = "";
			$this->t_07_head->TooltipValue = "";

			// t_08_head
			$this->t_08_head->LinkCustomAttributes = "";
			$this->t_08_head->HrefValue = "";
			$this->t_08_head->TooltipValue = "";

			// t_09_head
			$this->t_09_head->LinkCustomAttributes = "";
			$this->t_09_head->HrefValue = "";
			$this->t_09_head->TooltipValue = "";

			// t_10_head
			$this->t_10_head->LinkCustomAttributes = "";
			$this->t_10_head->HrefValue = "";
			$this->t_10_head->TooltipValue = "";

			// t_11_head
			$this->t_11_head->LinkCustomAttributes = "";
			$this->t_11_head->HrefValue = "";
			$this->t_11_head->TooltipValue = "";

			// t_12_head
			$this->t_12_head->LinkCustomAttributes = "";
			$this->t_12_head->HrefValue = "";
			$this->t_12_head->TooltipValue = "";

			// t_13_head
			$this->t_13_head->LinkCustomAttributes = "";
			$this->t_13_head->HrefValue = "";
			$this->t_13_head->TooltipValue = "";

			// t_14_head
			$this->t_14_head->LinkCustomAttributes = "";
			$this->t_14_head->HrefValue = "";
			$this->t_14_head->TooltipValue = "";

			// t_15_head
			$this->t_15_head->LinkCustomAttributes = "";
			$this->t_15_head->HrefValue = "";
			$this->t_15_head->TooltipValue = "";

			// po_01_head
			$this->po_01_head->LinkCustomAttributes = "";
			$this->po_01_head->HrefValue = "";
			$this->po_01_head->TooltipValue = "";

			// po_02_head
			$this->po_02_head->LinkCustomAttributes = "";
			$this->po_02_head->HrefValue = "";
			$this->po_02_head->TooltipValue = "";

			// po_03_head
			$this->po_03_head->LinkCustomAttributes = "";
			$this->po_03_head->HrefValue = "";
			$this->po_03_head->TooltipValue = "";

			// po_04_head
			$this->po_04_head->LinkCustomAttributes = "";
			$this->po_04_head->HrefValue = "";
			$this->po_04_head->TooltipValue = "";

			// po_05_head
			$this->po_05_head->LinkCustomAttributes = "";
			$this->po_05_head->HrefValue = "";
			$this->po_05_head->TooltipValue = "";

			// po_06_head
			$this->po_06_head->LinkCustomAttributes = "";
			$this->po_06_head->HrefValue = "";
			$this->po_06_head->TooltipValue = "";

			// po_07_head
			$this->po_07_head->LinkCustomAttributes = "";
			$this->po_07_head->HrefValue = "";
			$this->po_07_head->TooltipValue = "";

			// po_08_head
			$this->po_08_head->LinkCustomAttributes = "";
			$this->po_08_head->HrefValue = "";
			$this->po_08_head->TooltipValue = "";

			// po_17_head
			$this->po_17_head->LinkCustomAttributes = "";
			$this->po_17_head->HrefValue = "";
			$this->po_17_head->TooltipValue = "";

			// po_18_head
			$this->po_18_head->LinkCustomAttributes = "";
			$this->po_18_head->HrefValue = "";
			$this->po_18_head->TooltipValue = "";

			// po_19_head
			$this->po_19_head->LinkCustomAttributes = "";
			$this->po_19_head->HrefValue = "";
			$this->po_19_head->TooltipValue = "";

			// po_20_head
			$this->po_20_head->LinkCustomAttributes = "";
			$this->po_20_head->HrefValue = "";
			$this->po_20_head->TooltipValue = "";

			// jc_01_head
			$this->jc_01_head->LinkCustomAttributes = "";
			$this->jc_01_head->HrefValue = "";
			$this->jc_01_head->TooltipValue = "";

			// jc_02_head
			$this->jc_02_head->LinkCustomAttributes = "";
			$this->jc_02_head->HrefValue = "";
			$this->jc_02_head->TooltipValue = "";

			// jc_03_head
			$this->jc_03_head->LinkCustomAttributes = "";
			$this->jc_03_head->HrefValue = "";
			$this->jc_03_head->TooltipValue = "";

			// jc_04_head
			$this->jc_04_head->LinkCustomAttributes = "";
			$this->jc_04_head->HrefValue = "";
			$this->jc_04_head->TooltipValue = "";

			// jc_05_head
			$this->jc_05_head->LinkCustomAttributes = "";
			$this->jc_05_head->HrefValue = "";
			$this->jc_05_head->TooltipValue = "";

			// jc_06_head
			$this->jc_06_head->LinkCustomAttributes = "";
			$this->jc_06_head->HrefValue = "";
			$this->jc_06_head->TooltipValue = "";

			// jc_07_head
			$this->jc_07_head->LinkCustomAttributes = "";
			$this->jc_07_head->HrefValue = "";
			$this->jc_07_head->TooltipValue = "";

			// jc_08_head
			$this->jc_08_head->LinkCustomAttributes = "";
			$this->jc_08_head->HrefValue = "";
			$this->jc_08_head->TooltipValue = "";

			// jc_09_head
			$this->jc_09_head->LinkCustomAttributes = "";
			$this->jc_09_head->HrefValue = "";
			$this->jc_09_head->TooltipValue = "";

			// jc_10_head
			$this->jc_10_head->LinkCustomAttributes = "";
			$this->jc_10_head->HrefValue = "";
			$this->jc_10_head->TooltipValue = "";

			// pc_shape
			$this->pc_shape->LinkCustomAttributes = "";
			$this->pc_shape->HrefValue = "";
			$this->pc_shape->TooltipValue = "";

			// pc_unit
			$this->pc_unit->LinkCustomAttributes = "";
			$this->pc_unit->HrefValue = "";
			$this->pc_unit->TooltipValue = "";

			// pc_w
			$this->pc_w->LinkCustomAttributes = "";
			$this->pc_w->HrefValue = "";
			$this->pc_w->TooltipValue = "";

			// pc_l
			$this->pc_l->LinkCustomAttributes = "";
			$this->pc_l->HrefValue = "";
			$this->pc_l->TooltipValue = "";

			// pc_h
			$this->pc_h->LinkCustomAttributes = "";
			$this->pc_h->HrefValue = "";
			$this->pc_h->TooltipValue = "";

			// pc_partner_size
			$this->pc_partner_size->LinkCustomAttributes = "";
			$this->pc_partner_size->HrefValue = "";
			$this->pc_partner_size->TooltipValue = "";

			// pc_sqm
			$this->pc_sqm->LinkCustomAttributes = "";
			$this->pc_sqm->HrefValue = "";
			$this->pc_sqm->TooltipValue = "";

			// pc_01_head
			$this->pc_01_head->LinkCustomAttributes = "";
			$this->pc_01_head->HrefValue = "";
			$this->pc_01_head->TooltipValue = "";

			// pc_02_head
			$this->pc_02_head->LinkCustomAttributes = "";
			$this->pc_02_head->HrefValue = "";
			$this->pc_02_head->TooltipValue = "";

			// pc_03_head
			$this->pc_03_head->LinkCustomAttributes = "";
			$this->pc_03_head->HrefValue = "";
			$this->pc_03_head->TooltipValue = "";

			// pc_04_head
			$this->pc_04_head->LinkCustomAttributes = "";
			$this->pc_04_head->HrefValue = "";
			$this->pc_04_head->TooltipValue = "";

			// pc_05_head
			$this->pc_05_head->LinkCustomAttributes = "";
			$this->pc_05_head->HrefValue = "";
			$this->pc_05_head->TooltipValue = "";

			// pc_06_head
			$this->pc_06_head->LinkCustomAttributes = "";
			$this->pc_06_head->HrefValue = "";
			$this->pc_06_head->TooltipValue = "";

			// pc_07_head
			$this->pc_07_head->LinkCustomAttributes = "";
			$this->pc_07_head->HrefValue = "";
			$this->pc_07_head->TooltipValue = "";

			// pc_08_head
			$this->pc_08_head->LinkCustomAttributes = "";
			$this->pc_08_head->HrefValue = "";
			$this->pc_08_head->TooltipValue = "";

			// pc_09_head
			$this->pc_09_head->LinkCustomAttributes = "";
			$this->pc_09_head->HrefValue = "";
			$this->pc_09_head->TooltipValue = "";

			// pc_10_head
			$this->pc_10_head->LinkCustomAttributes = "";
			$this->pc_10_head->HrefValue = "";
			$this->pc_10_head->TooltipValue = "";

			// pc_11_head
			$this->pc_11_head->LinkCustomAttributes = "";
			$this->pc_11_head->HrefValue = "";
			$this->pc_11_head->TooltipValue = "";

			// pc_12_head
			$this->pc_12_head->LinkCustomAttributes = "";
			$this->pc_12_head->HrefValue = "";
			$this->pc_12_head->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '../uploads/category/s_grp';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "product_group_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("product_grouplist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_calculation_method":
							break;
						case "x_process":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>