<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for production_employee
 */
class production_employee extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $uid;
	public $grp;
	public $site;
	public $id;
	public $user_name;
	public $salary;
	public $contractor;
	public $address;
	public $mobile;
	public $category;
	public $process;
	public $status;
	public $employee_name;
	public $gender;
	public $father_name;
	public $designation;
	public $permanent_address;
	public $city;
	public $dob;
	public $dom;
	public $mobile_other;
	public $mobile_family;
	public $marital_status;
	public $spouse_details;
	public $emergency_details;
	public $pan_no;
	public $aadhaar_no;
	public $id_proof;
	public $reference_details;
	public $other_details;
	public $doj;
	public $doc;
	public $dol;
	public $image;
	public $payment_details;
	public $bank_name;
	public $bank_ifsc_code;
	public $bank_account_no;
	public $operator;
	public $datetime;
	public $d_operator;
	public $d_datetime;
	public $am_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'production_employee';
		$this->TableName = 'production_employee';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`production_employee`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// uid
		$this->uid = new DbField('production_employee', 'production_employee', 'x_uid', 'uid', '`uid`', '`uid`', 18, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->uid->IsAutoIncrement = TRUE; // Autoincrement field
		$this->uid->IsPrimaryKey = TRUE; // Primary key field
		$this->uid->Sortable = TRUE; // Allow sort
		$this->uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['uid'] = &$this->uid;

		// grp
		$this->grp = new DbField('production_employee', 'production_employee', 'x_grp', 'grp', '`grp`', '`grp`', 200, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// site
		$this->site = new DbField('production_employee', 'production_employee', 'x_site', 'site', '`site`', '`site`', 200, -1, FALSE, '`site`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->site->Nullable = FALSE; // NOT NULL field
		$this->site->Required = TRUE; // Required field
		$this->site->Sortable = TRUE; // Allow sort
		$this->site->Lookup = new Lookup('site', 'godown', TRUE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['site'] = &$this->site;

		// id
		$this->id = new DbField('production_employee', 'production_employee', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['id'] = &$this->id;

		// user_name
		$this->user_name = new DbField('production_employee', 'production_employee', 'x_user_name', 'user_name', '`user_name`', '`user_name`', 200, -1, FALSE, '`user_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->user_name->Required = TRUE; // Required field
		$this->user_name->Sortable = TRUE; // Allow sort
		$this->fields['user_name'] = &$this->user_name;

		// salary
		$this->salary = new DbField('production_employee', 'production_employee', 'x_salary', 'salary', '`salary`', '`salary`', 3, -1, FALSE, '`salary`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->salary->Nullable = FALSE; // NOT NULL field
		$this->salary->Sortable = TRUE; // Allow sort
		$this->salary->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['salary'] = &$this->salary;

		// contractor
		$this->contractor = new DbField('production_employee', 'production_employee', 'x_contractor', 'contractor', '`contractor`', '`contractor`', 18, -1, FALSE, '`contractor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->contractor->Sortable = TRUE; // Allow sort
		$this->contractor->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->contractor->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->contractor->Lookup = new Lookup('contractor', 'production_employee', FALSE, 'id', ["id","user_name","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->contractor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['contractor'] = &$this->contractor;

		// address
		$this->address = new DbField('production_employee', 'production_employee', 'x_address', 'address', '`address`', '`address`', 200, -1, FALSE, '`address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->address->Sortable = TRUE; // Allow sort
		$this->fields['address'] = &$this->address;

		// mobile
		$this->mobile = new DbField('production_employee', 'production_employee', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 21, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Sortable = TRUE; // Allow sort
		$this->mobile->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mobile'] = &$this->mobile;

		// category
		$this->category = new DbField('production_employee', 'production_employee', 'x_category', 'category', '`category`', '`category`', 17, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->category->Nullable = FALSE; // NOT NULL field
		$this->category->Required = TRUE; // Required field
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->category->Lookup = new Lookup('category', 'production_employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->category->OptionCount = 3;
		$this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['category'] = &$this->category;

		// process
		$this->process = new DbField('production_employee', 'production_employee', 'x_process', 'process', '`process`', '`process`', 200, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->Lookup = new Lookup('process', 'sub_process_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process'] = &$this->process;

		// status
		$this->status = new DbField('production_employee', 'production_employee', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'production_employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// employee_name
		$this->employee_name = new DbField('production_employee', 'production_employee', 'x_employee_name', 'employee_name', '`employee_name`', '`employee_name`', 200, -1, FALSE, '`employee_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->employee_name->Sortable = TRUE; // Allow sort
		$this->fields['employee_name'] = &$this->employee_name;

		// gender
		$this->gender = new DbField('production_employee', 'production_employee', 'x_gender', 'gender', '`gender`', '`gender`', 17, -1, FALSE, '`gender`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->gender->Sortable = TRUE; // Allow sort
		$this->gender->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->gender->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->gender->Lookup = new Lookup('gender', 'production_employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->gender->OptionCount = 2;
		$this->gender->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gender'] = &$this->gender;

		// father_name
		$this->father_name = new DbField('production_employee', 'production_employee', 'x_father_name', 'father_name', '`father_name`', '`father_name`', 200, -1, FALSE, '`father_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->father_name->Sortable = TRUE; // Allow sort
		$this->fields['father_name'] = &$this->father_name;

		// designation
		$this->designation = new DbField('production_employee', 'production_employee', 'x_designation', 'designation', '`designation`', '`designation`', 200, -1, FALSE, '`designation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->designation->Sortable = TRUE; // Allow sort
		$this->fields['designation'] = &$this->designation;

		// permanent_address
		$this->permanent_address = new DbField('production_employee', 'production_employee', 'x_permanent_address', 'permanent_address', '`permanent_address`', '`permanent_address`', 200, -1, FALSE, '`permanent_address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->permanent_address->Sortable = TRUE; // Allow sort
		$this->fields['permanent_address'] = &$this->permanent_address;

		// city
		$this->city = new DbField('production_employee', 'production_employee', 'x_city', 'city', '`city`', '`city`', 200, -1, FALSE, '`city`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->city->Sortable = TRUE; // Allow sort
		$this->fields['city'] = &$this->city;

		// dob
		$this->dob = new DbField('production_employee', 'production_employee', 'x_dob', 'dob', '`dob`', CastDateFieldForLike('`dob`', 0, "DB"), 133, 0, FALSE, '`dob`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dob->Sortable = TRUE; // Allow sort
		$this->dob->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dob'] = &$this->dob;

		// dom
		$this->dom = new DbField('production_employee', 'production_employee', 'x_dom', 'dom', '`dom`', CastDateFieldForLike('`dom`', 0, "DB"), 133, 0, FALSE, '`dom`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dom->Sortable = TRUE; // Allow sort
		$this->dom->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dom'] = &$this->dom;

		// mobile_other
		$this->mobile_other = new DbField('production_employee', 'production_employee', 'x_mobile_other', 'mobile_other', '`mobile_other`', '`mobile_other`', 200, -1, FALSE, '`mobile_other`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile_other->Sortable = TRUE; // Allow sort
		$this->fields['mobile_other'] = &$this->mobile_other;

		// mobile_family
		$this->mobile_family = new DbField('production_employee', 'production_employee', 'x_mobile_family', 'mobile_family', '`mobile_family`', '`mobile_family`', 200, -1, FALSE, '`mobile_family`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile_family->Sortable = TRUE; // Allow sort
		$this->fields['mobile_family'] = &$this->mobile_family;

		// marital_status
		$this->marital_status = new DbField('production_employee', 'production_employee', 'x_marital_status', 'marital_status', '`marital_status`', '`marital_status`', 18, -1, FALSE, '`marital_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->marital_status->Sortable = TRUE; // Allow sort
		$this->marital_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->marital_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->marital_status->Lookup = new Lookup('marital_status', 'production_employee', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->marital_status->OptionCount = 3;
		$this->marital_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['marital_status'] = &$this->marital_status;

		// spouse_details
		$this->spouse_details = new DbField('production_employee', 'production_employee', 'x_spouse_details', 'spouse_details', '`spouse_details`', '`spouse_details`', 200, -1, FALSE, '`spouse_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->spouse_details->Sortable = TRUE; // Allow sort
		$this->fields['spouse_details'] = &$this->spouse_details;

		// emergency_details
		$this->emergency_details = new DbField('production_employee', 'production_employee', 'x_emergency_details', 'emergency_details', '`emergency_details`', '`emergency_details`', 200, -1, FALSE, '`emergency_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emergency_details->Sortable = TRUE; // Allow sort
		$this->fields['emergency_details'] = &$this->emergency_details;

		// pan_no
		$this->pan_no = new DbField('production_employee', 'production_employee', 'x_pan_no', 'pan_no', '`pan_no`', '`pan_no`', 200, -1, FALSE, '`pan_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan_no->Sortable = TRUE; // Allow sort
		$this->fields['pan_no'] = &$this->pan_no;

		// aadhaar_no
		$this->aadhaar_no = new DbField('production_employee', 'production_employee', 'x_aadhaar_no', 'aadhaar_no', '`aadhaar_no`', '`aadhaar_no`', 200, -1, FALSE, '`aadhaar_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->aadhaar_no->Sortable = TRUE; // Allow sort
		$this->aadhaar_no->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['aadhaar_no'] = &$this->aadhaar_no;

		// id_proof
		$this->id_proof = new DbField('production_employee', 'production_employee', 'x_id_proof', 'id_proof', '`id_proof`', '`id_proof`', 200, -1, TRUE, '`id_proof`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->id_proof->Sortable = TRUE; // Allow sort
		$this->id_proof->UploadMultiple = TRUE;
		$this->id_proof->Upload->UploadMultiple = TRUE;
		$this->id_proof->UploadMaxFileCount = 0;
		$this->fields['id_proof'] = &$this->id_proof;

		// reference_details
		$this->reference_details = new DbField('production_employee', 'production_employee', 'x_reference_details', 'reference_details', '`reference_details`', '`reference_details`', 200, -1, FALSE, '`reference_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reference_details->Sortable = TRUE; // Allow sort
		$this->fields['reference_details'] = &$this->reference_details;

		// other_details
		$this->other_details = new DbField('production_employee', 'production_employee', 'x_other_details', 'other_details', '`other_details`', '`other_details`', 201, -1, FALSE, '`other_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->other_details->Sortable = TRUE; // Allow sort
		$this->fields['other_details'] = &$this->other_details;

		// doj
		$this->doj = new DbField('production_employee', 'production_employee', 'x_doj', 'doj', '`doj`', CastDateFieldForLike('`doj`', 0, "DB"), 133, 0, FALSE, '`doj`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->doj->Sortable = TRUE; // Allow sort
		$this->doj->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['doj'] = &$this->doj;

		// doc
		$this->doc = new DbField('production_employee', 'production_employee', 'x_doc', 'doc', '`doc`', CastDateFieldForLike('`doc`', 0, "DB"), 133, 0, FALSE, '`doc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->doc->Sortable = FALSE; // Allow sort
		$this->doc->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['doc'] = &$this->doc;

		// dol
		$this->dol = new DbField('production_employee', 'production_employee', 'x_dol', 'dol', '`dol`', CastDateFieldForLike('`dol`', 0, "DB"), 133, 0, FALSE, '`dol`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dol->Sortable = TRUE; // Allow sort
		$this->dol->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dol'] = &$this->dol;

		// image
		$this->image = new DbField('production_employee', 'production_employee', 'x_image', 'image', '`image`', '`image`', 200, -1, TRUE, '`image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->image->Sortable = TRUE; // Allow sort
		$this->fields['image'] = &$this->image;

		// payment_details
		$this->payment_details = new DbField('production_employee', 'production_employee', 'x_payment_details', 'payment_details', '`payment_details`', '`payment_details`', 201, -1, FALSE, '`payment_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->payment_details->Sortable = TRUE; // Allow sort
		$this->fields['payment_details'] = &$this->payment_details;

		// bank_name
		$this->bank_name = new DbField('production_employee', 'production_employee', 'x_bank_name', 'bank_name', '`bank_name`', '`bank_name`', 200, -1, FALSE, '`bank_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_name->Sortable = TRUE; // Allow sort
		$this->fields['bank_name'] = &$this->bank_name;

		// bank_ifsc_code
		$this->bank_ifsc_code = new DbField('production_employee', 'production_employee', 'x_bank_ifsc_code', 'bank_ifsc_code', '`bank_ifsc_code`', '`bank_ifsc_code`', 200, -1, FALSE, '`bank_ifsc_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_ifsc_code->Sortable = TRUE; // Allow sort
		$this->fields['bank_ifsc_code'] = &$this->bank_ifsc_code;

		// bank_account_no
		$this->bank_account_no = new DbField('production_employee', 'production_employee', 'x_bank_account_no', 'bank_account_no', '`bank_account_no`', '`bank_account_no`', 200, -1, FALSE, '`bank_account_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_account_no->Sortable = TRUE; // Allow sort
		$this->fields['bank_account_no'] = &$this->bank_account_no;

		// operator
		$this->operator = new DbField('production_employee', 'production_employee', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('production_employee', 'production_employee', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// d_operator
		$this->d_operator = new DbField('production_employee', 'production_employee', 'x_d_operator', 'd_operator', '`d_operator`', '`d_operator`', 18, -1, FALSE, '`d_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_operator->Sortable = TRUE; // Allow sort
		$this->d_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_operator'] = &$this->d_operator;

		// d_datetime
		$this->d_datetime = new DbField('production_employee', 'production_employee', 'x_d_datetime', 'd_datetime', '`d_datetime`', CastDateFieldForLike('`d_datetime`', 0, "DB"), 135, 0, FALSE, '`d_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_datetime->Nullable = FALSE; // NOT NULL field
		$this->d_datetime->Sortable = TRUE; // Allow sort
		$this->d_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['d_datetime'] = &$this->d_datetime;

		// am_id
		$this->am_id = new DbField('production_employee', 'production_employee', 'x_am_id', 'am_id', '`am_id`', '`am_id`', 2, -1, FALSE, '`am_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->am_id->Sortable = TRUE; // Allow sort
		$this->am_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['am_id'] = &$this->am_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`production_employee`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->uid->setDbValue($conn->insert_ID());
			$rs['uid'] = $this->uid->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('uid', $rs))
				AddFilter($where, QuotedName('uid', $this->Dbid) . '=' . QuotedValue($rs['uid'], $this->uid->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->uid->DbValue = $row['uid'];
		$this->grp->DbValue = $row['grp'];
		$this->site->DbValue = $row['site'];
		$this->id->DbValue = $row['id'];
		$this->user_name->DbValue = $row['user_name'];
		$this->salary->DbValue = $row['salary'];
		$this->contractor->DbValue = $row['contractor'];
		$this->address->DbValue = $row['address'];
		$this->mobile->DbValue = $row['mobile'];
		$this->category->DbValue = $row['category'];
		$this->process->DbValue = $row['process'];
		$this->status->DbValue = $row['status'];
		$this->employee_name->DbValue = $row['employee_name'];
		$this->gender->DbValue = $row['gender'];
		$this->father_name->DbValue = $row['father_name'];
		$this->designation->DbValue = $row['designation'];
		$this->permanent_address->DbValue = $row['permanent_address'];
		$this->city->DbValue = $row['city'];
		$this->dob->DbValue = $row['dob'];
		$this->dom->DbValue = $row['dom'];
		$this->mobile_other->DbValue = $row['mobile_other'];
		$this->mobile_family->DbValue = $row['mobile_family'];
		$this->marital_status->DbValue = $row['marital_status'];
		$this->spouse_details->DbValue = $row['spouse_details'];
		$this->emergency_details->DbValue = $row['emergency_details'];
		$this->pan_no->DbValue = $row['pan_no'];
		$this->aadhaar_no->DbValue = $row['aadhaar_no'];
		$this->id_proof->Upload->DbValue = $row['id_proof'];
		$this->reference_details->DbValue = $row['reference_details'];
		$this->other_details->DbValue = $row['other_details'];
		$this->doj->DbValue = $row['doj'];
		$this->doc->DbValue = $row['doc'];
		$this->dol->DbValue = $row['dol'];
		$this->image->Upload->DbValue = $row['image'];
		$this->payment_details->DbValue = $row['payment_details'];
		$this->bank_name->DbValue = $row['bank_name'];
		$this->bank_ifsc_code->DbValue = $row['bank_ifsc_code'];
		$this->bank_account_no->DbValue = $row['bank_account_no'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->d_operator->DbValue = $row['d_operator'];
		$this->d_datetime->DbValue = $row['d_datetime'];
		$this->am_id->DbValue = $row['am_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->id_proof->OldUploadPath = '.p_uploads/production_employee/'. $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['id_proof']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['id_proof']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->id_proof->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->id_proof->oldPhysicalUploadPath() . $oldFile);
		}
		$this->image->OldUploadPath = '.p_uploads/production_employee/'. $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['image']) ? [] : [$row['image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`uid` = @uid@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('uid', $row) ? $row['uid'] : NULL) : $this->uid->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@uid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "production_employeelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "production_employeeview.php")
			return $Language->phrase("View");
		elseif ($pageName == "production_employeeedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "production_employeeadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "production_employeelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("production_employeeview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("production_employeeview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "production_employeeadd.php?" . $this->getUrlParm($parm);
		else
			$url = "production_employeeadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("production_employeeedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("production_employeeadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("production_employeedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "uid:" . JsonEncode($this->uid->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->uid->CurrentValue != NULL) {
			$url .= "uid=" . urlencode($this->uid->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("uid") !== NULL)
				$arKeys[] = Param("uid");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->uid->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->uid->setDbValue($rs->fields('uid'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->site->setDbValue($rs->fields('site'));
		$this->id->setDbValue($rs->fields('id'));
		$this->user_name->setDbValue($rs->fields('user_name'));
		$this->salary->setDbValue($rs->fields('salary'));
		$this->contractor->setDbValue($rs->fields('contractor'));
		$this->address->setDbValue($rs->fields('address'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->category->setDbValue($rs->fields('category'));
		$this->process->setDbValue($rs->fields('process'));
		$this->status->setDbValue($rs->fields('status'));
		$this->employee_name->setDbValue($rs->fields('employee_name'));
		$this->gender->setDbValue($rs->fields('gender'));
		$this->father_name->setDbValue($rs->fields('father_name'));
		$this->designation->setDbValue($rs->fields('designation'));
		$this->permanent_address->setDbValue($rs->fields('permanent_address'));
		$this->city->setDbValue($rs->fields('city'));
		$this->dob->setDbValue($rs->fields('dob'));
		$this->dom->setDbValue($rs->fields('dom'));
		$this->mobile_other->setDbValue($rs->fields('mobile_other'));
		$this->mobile_family->setDbValue($rs->fields('mobile_family'));
		$this->marital_status->setDbValue($rs->fields('marital_status'));
		$this->spouse_details->setDbValue($rs->fields('spouse_details'));
		$this->emergency_details->setDbValue($rs->fields('emergency_details'));
		$this->pan_no->setDbValue($rs->fields('pan_no'));
		$this->aadhaar_no->setDbValue($rs->fields('aadhaar_no'));
		$this->id_proof->Upload->DbValue = $rs->fields('id_proof');
		$this->reference_details->setDbValue($rs->fields('reference_details'));
		$this->other_details->setDbValue($rs->fields('other_details'));
		$this->doj->setDbValue($rs->fields('doj'));
		$this->doc->setDbValue($rs->fields('doc'));
		$this->dol->setDbValue($rs->fields('dol'));
		$this->image->Upload->DbValue = $rs->fields('image');
		$this->payment_details->setDbValue($rs->fields('payment_details'));
		$this->bank_name->setDbValue($rs->fields('bank_name'));
		$this->bank_ifsc_code->setDbValue($rs->fields('bank_ifsc_code'));
		$this->bank_account_no->setDbValue($rs->fields('bank_account_no'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->d_operator->setDbValue($rs->fields('d_operator'));
		$this->d_datetime->setDbValue($rs->fields('d_datetime'));
		$this->am_id->setDbValue($rs->fields('am_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// grp
		// site
		// id
		// user_name
		// salary
		// contractor
		// address
		// mobile
		// category
		// process
		// status
		// employee_name
		// gender
		// father_name
		// designation
		// permanent_address
		// city
		// dob
		// dom
		// mobile_other
		// mobile_family
		// marital_status
		// spouse_details
		// emergency_details
		// pan_no
		// aadhaar_no
		// id_proof
		// reference_details
		// other_details
		// doj
		// doc

		$this->doc->CellCssStyle = "white-space: nowrap;";

		// dol
		// image
		// payment_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// operator
		// datetime
		// d_operator
		// d_datetime
		// am_id
		// uid

		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// site
		$curVal = strval($this->site->CurrentValue);
		if ($curVal <> "") {
			$this->site->ViewValue = $this->site->lookupCacheOption($curVal);
			if ($this->site->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `id` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->site->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->site->ViewValue->add($this->site->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->site->ViewValue = $this->site->CurrentValue;
				}
			}
		} else {
			$this->site->ViewValue = NULL;
		}
		$this->site->ViewCustomAttributes = "";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// user_name
		$this->user_name->ViewValue = $this->user_name->CurrentValue;
		$this->user_name->ViewCustomAttributes = "";

		// salary
		$this->salary->ViewValue = $this->salary->CurrentValue;
		$this->salary->ViewValue = FormatNumber($this->salary->ViewValue, 0, -2, -2, -2);
		$this->salary->ViewCustomAttributes = "";

		// contractor
		$curVal = strval($this->contractor->CurrentValue);
		if ($curVal <> "") {
			$this->contractor->ViewValue = $this->contractor->lookupCacheOption($curVal);
			if ($this->contractor->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `category`  = 99";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->contractor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->contractor->ViewValue = $this->contractor->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->contractor->ViewValue = $this->contractor->CurrentValue;
				}
			}
		} else {
			$this->contractor->ViewValue = NULL;
		}
		$this->contractor->ViewCustomAttributes = "";

		// address
		$this->address->ViewValue = $this->address->CurrentValue;
		$this->address->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
		$this->mobile->ViewCustomAttributes = "";

		// category
		if (strval($this->category->CurrentValue) <> "") {
			$this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
		} else {
			$this->category->ViewValue = NULL;
		}
		$this->category->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue->add($this->process->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// employee_name
		$this->employee_name->ViewValue = $this->employee_name->CurrentValue;
		$this->employee_name->ViewCustomAttributes = "";

		// gender
		if (strval($this->gender->CurrentValue) <> "") {
			$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
		} else {
			$this->gender->ViewValue = NULL;
		}
		$this->gender->ViewCustomAttributes = "";

		// father_name
		$this->father_name->ViewValue = $this->father_name->CurrentValue;
		$this->father_name->ViewCustomAttributes = "";

		// designation
		$this->designation->ViewValue = $this->designation->CurrentValue;
		$this->designation->ViewCustomAttributes = "";

		// permanent_address
		$this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;
		$this->permanent_address->ViewCustomAttributes = "";

		// city
		$this->city->ViewValue = $this->city->CurrentValue;
		$this->city->ViewCustomAttributes = "";

		// dob
		$this->dob->ViewValue = $this->dob->CurrentValue;
		$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 0);
		$this->dob->ViewCustomAttributes = "";

		// dom
		$this->dom->ViewValue = $this->dom->CurrentValue;
		$this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, 0);
		$this->dom->ViewCustomAttributes = "";

		// mobile_other
		$this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;
		$this->mobile_other->ViewCustomAttributes = "";

		// mobile_family
		$this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;
		$this->mobile_family->ViewCustomAttributes = "";

		// marital_status
		if (strval($this->marital_status->CurrentValue) <> "") {
			$this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
		} else {
			$this->marital_status->ViewValue = NULL;
		}
		$this->marital_status->ViewCustomAttributes = "";

		// spouse_details
		$this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;
		$this->spouse_details->ViewCustomAttributes = "";

		// emergency_details
		$this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;
		$this->emergency_details->ViewCustomAttributes = "";

		// pan_no
		$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
		$this->pan_no->ViewCustomAttributes = "";

		// aadhaar_no
		$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->ViewCustomAttributes = "";

		// id_proof
		$this->id_proof->UploadPath = '.p_uploads/production_employee/'. $this->id->CurrentValue . '/';
		if (!EmptyValue($this->id_proof->Upload->DbValue)) {
			$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
		} else {
			$this->id_proof->ViewValue = "";
		}
		$this->id_proof->ViewCustomAttributes = "";

		// reference_details
		$this->reference_details->ViewValue = $this->reference_details->CurrentValue;
		$this->reference_details->ViewCustomAttributes = "";

		// other_details
		$this->other_details->ViewValue = $this->other_details->CurrentValue;
		$this->other_details->ViewCustomAttributes = "";

		// doj
		$this->doj->ViewValue = $this->doj->CurrentValue;
		$this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, 0);
		$this->doj->ViewCustomAttributes = "";

		// doc
		$this->doc->ViewValue = $this->doc->CurrentValue;
		$this->doc->ViewValue = FormatDateTime($this->doc->ViewValue, 0);
		$this->doc->ViewCustomAttributes = "";

		// dol
		$this->dol->ViewValue = $this->dol->CurrentValue;
		$this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, 0);
		$this->dol->ViewCustomAttributes = "";

		// image
		$this->image->UploadPath = '.p_uploads/production_employee/'. $this->id->CurrentValue . '/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ViewValue = $this->image->Upload->DbValue;
		} else {
			$this->image->ViewValue = "";
		}
		$this->image->ViewCustomAttributes = "";

		// payment_details
		$this->payment_details->ViewValue = $this->payment_details->CurrentValue;
		$this->payment_details->ViewCustomAttributes = "";

		// bank_name
		$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
		$this->bank_name->ViewCustomAttributes = "";

		// bank_ifsc_code
		$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
		$this->bank_ifsc_code->ViewCustomAttributes = "";

		// bank_account_no
		$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
		$this->bank_account_no->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// d_operator
		$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
		$this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, 0, -2, -2, -2);
		$this->d_operator->ViewCustomAttributes = "";

		// d_datetime
		$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
		$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 0);
		$this->d_datetime->ViewCustomAttributes = "";

		// am_id
		$this->am_id->ViewValue = $this->am_id->CurrentValue;
		$this->am_id->ViewValue = FormatNumber($this->am_id->ViewValue, 0, -2, -2, -2);
		$this->am_id->ViewCustomAttributes = "";

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// site
		$this->site->LinkCustomAttributes = "";
		if (!EmptyValue($this->site->CurrentValue)) {
			$this->site->HrefValue = "production_employeelist.php?x_site=" . $this->site->CurrentValue; // Add prefix/suffix
			$this->site->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
		} else {
			$this->site->HrefValue = "";
		}
		$this->site->TooltipValue = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// user_name
		$this->user_name->LinkCustomAttributes = "";
		$this->user_name->HrefValue = "";
		$this->user_name->TooltipValue = "";

		// salary
		$this->salary->LinkCustomAttributes = "";
		$this->salary->HrefValue = "";
		$this->salary->TooltipValue = "";

		// contractor
		$this->contractor->LinkCustomAttributes = "";
		$this->contractor->HrefValue = "";
		$this->contractor->TooltipValue = "";

		// address
		$this->address->LinkCustomAttributes = "";
		$this->address->HrefValue = "";
		$this->address->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// employee_name
		$this->employee_name->LinkCustomAttributes = "";
		$this->employee_name->HrefValue = "";
		$this->employee_name->TooltipValue = "";

		// gender
		$this->gender->LinkCustomAttributes = "";
		$this->gender->HrefValue = "";
		$this->gender->TooltipValue = "";

		// father_name
		$this->father_name->LinkCustomAttributes = "";
		$this->father_name->HrefValue = "";
		$this->father_name->TooltipValue = "";

		// designation
		$this->designation->LinkCustomAttributes = "";
		$this->designation->HrefValue = "";
		$this->designation->TooltipValue = "";

		// permanent_address
		$this->permanent_address->LinkCustomAttributes = "";
		$this->permanent_address->HrefValue = "";
		$this->permanent_address->TooltipValue = "";

		// city
		$this->city->LinkCustomAttributes = "";
		$this->city->HrefValue = "";
		$this->city->TooltipValue = "";

		// dob
		$this->dob->LinkCustomAttributes = "";
		$this->dob->HrefValue = "";
		$this->dob->TooltipValue = "";

		// dom
		$this->dom->LinkCustomAttributes = "";
		$this->dom->HrefValue = "";
		$this->dom->TooltipValue = "";

		// mobile_other
		$this->mobile_other->LinkCustomAttributes = "";
		$this->mobile_other->HrefValue = "";
		$this->mobile_other->TooltipValue = "";

		// mobile_family
		$this->mobile_family->LinkCustomAttributes = "";
		$this->mobile_family->HrefValue = "";
		$this->mobile_family->TooltipValue = "";

		// marital_status
		$this->marital_status->LinkCustomAttributes = "";
		$this->marital_status->HrefValue = "";
		$this->marital_status->TooltipValue = "";

		// spouse_details
		$this->spouse_details->LinkCustomAttributes = "";
		$this->spouse_details->HrefValue = "";
		$this->spouse_details->TooltipValue = "";

		// emergency_details
		$this->emergency_details->LinkCustomAttributes = "";
		$this->emergency_details->HrefValue = "";
		$this->emergency_details->TooltipValue = "";

		// pan_no
		$this->pan_no->LinkCustomAttributes = "";
		$this->pan_no->HrefValue = "";
		$this->pan_no->TooltipValue = "";

		// aadhaar_no
		$this->aadhaar_no->LinkCustomAttributes = "";
		$this->aadhaar_no->HrefValue = "";
		$this->aadhaar_no->TooltipValue = "";

		// id_proof
		$this->id_proof->LinkCustomAttributes = "";
		$this->id_proof->HrefValue = "";
		$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
		$this->id_proof->TooltipValue = "";

		// reference_details
		$this->reference_details->LinkCustomAttributes = "";
		$this->reference_details->HrefValue = "";
		$this->reference_details->TooltipValue = "";

		// other_details
		$this->other_details->LinkCustomAttributes = "";
		$this->other_details->HrefValue = "";
		$this->other_details->TooltipValue = "";

		// doj
		$this->doj->LinkCustomAttributes = "";
		$this->doj->HrefValue = "";
		$this->doj->TooltipValue = "";

		// doc
		$this->doc->LinkCustomAttributes = "";
		$this->doc->HrefValue = "";
		$this->doc->TooltipValue = "";

		// dol
		$this->dol->LinkCustomAttributes = "";
		$this->dol->HrefValue = "";
		$this->dol->TooltipValue = "";

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->HrefValue = "";
		$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		$this->image->TooltipValue = "";

		// payment_details
		$this->payment_details->LinkCustomAttributes = "";
		$this->payment_details->HrefValue = "";
		$this->payment_details->TooltipValue = "";

		// bank_name
		$this->bank_name->LinkCustomAttributes = "";
		$this->bank_name->HrefValue = "";
		$this->bank_name->TooltipValue = "";

		// bank_ifsc_code
		$this->bank_ifsc_code->LinkCustomAttributes = "";
		$this->bank_ifsc_code->HrefValue = "";
		$this->bank_ifsc_code->TooltipValue = "";

		// bank_account_no
		$this->bank_account_no->LinkCustomAttributes = "";
		$this->bank_account_no->HrefValue = "";
		$this->bank_account_no->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// d_operator
		$this->d_operator->LinkCustomAttributes = "";
		$this->d_operator->HrefValue = "";
		$this->d_operator->TooltipValue = "";

		// d_datetime
		$this->d_datetime->LinkCustomAttributes = "";
		$this->d_datetime->HrefValue = "";
		$this->d_datetime->TooltipValue = "";

		// am_id
		$this->am_id->LinkCustomAttributes = "";
		$this->am_id->HrefValue = "";
		$this->am_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// uid
		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// grp
		$this->grp->EditCustomAttributes = "";

		// site
		$this->site->EditCustomAttributes = "";

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// user_name
		$this->user_name->EditAttrs["class"] = "form-control";
		$this->user_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
		$this->user_name->EditValue = $this->user_name->CurrentValue;
		$this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

		// salary
		$this->salary->EditAttrs["class"] = "form-control";
		$this->salary->EditCustomAttributes = "";
		$this->salary->EditValue = $this->salary->CurrentValue;
		$this->salary->PlaceHolder = RemoveHtml($this->salary->caption());

		// contractor
		$this->contractor->EditAttrs["class"] = "form-control";
		$this->contractor->EditCustomAttributes = "";

		// address
		$this->address->EditAttrs["class"] = "form-control";
		$this->address->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
		$this->address->EditValue = $this->address->CurrentValue;
		$this->address->PlaceHolder = RemoveHtml($this->address->caption());

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";
		$this->category->EditValue = $this->category->options(TRUE);

		// process
		$this->process->EditCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// employee_name
		$this->employee_name->EditAttrs["class"] = "form-control";
		$this->employee_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->employee_name->CurrentValue = HtmlDecode($this->employee_name->CurrentValue);
		$this->employee_name->EditValue = $this->employee_name->CurrentValue;
		$this->employee_name->PlaceHolder = RemoveHtml($this->employee_name->caption());

		// gender
		$this->gender->EditAttrs["class"] = "form-control";
		$this->gender->EditCustomAttributes = "";
		$this->gender->EditValue = $this->gender->options(TRUE);

		// father_name
		$this->father_name->EditAttrs["class"] = "form-control";
		$this->father_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
		$this->father_name->EditValue = $this->father_name->CurrentValue;
		$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

		// designation
		$this->designation->EditAttrs["class"] = "form-control";
		$this->designation->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->designation->CurrentValue = HtmlDecode($this->designation->CurrentValue);
		$this->designation->EditValue = $this->designation->CurrentValue;
		$this->designation->PlaceHolder = RemoveHtml($this->designation->caption());

		// permanent_address
		$this->permanent_address->EditAttrs["class"] = "form-control";
		$this->permanent_address->EditCustomAttributes = "";
		$this->permanent_address->EditValue = $this->permanent_address->CurrentValue;
		$this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

		// city
		$this->city->EditAttrs["class"] = "form-control";
		$this->city->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
		$this->city->EditValue = $this->city->CurrentValue;
		$this->city->PlaceHolder = RemoveHtml($this->city->caption());

		// dob
		$this->dob->EditAttrs["class"] = "form-control";
		$this->dob->EditCustomAttributes = "";
		$this->dob->EditValue = FormatDateTime($this->dob->CurrentValue, 8);
		$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

		// dom
		$this->dom->EditAttrs["class"] = "form-control";
		$this->dom->EditCustomAttributes = "";
		$this->dom->EditValue = FormatDateTime($this->dom->CurrentValue, 8);
		$this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

		// mobile_other
		$this->mobile_other->EditAttrs["class"] = "form-control";
		$this->mobile_other->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
		$this->mobile_other->EditValue = $this->mobile_other->CurrentValue;
		$this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

		// mobile_family
		$this->mobile_family->EditAttrs["class"] = "form-control";
		$this->mobile_family->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
		$this->mobile_family->EditValue = $this->mobile_family->CurrentValue;
		$this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

		// marital_status
		$this->marital_status->EditAttrs["class"] = "form-control";
		$this->marital_status->EditCustomAttributes = "";
		$this->marital_status->EditValue = $this->marital_status->options(TRUE);

		// spouse_details
		$this->spouse_details->EditAttrs["class"] = "form-control";
		$this->spouse_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
		$this->spouse_details->EditValue = $this->spouse_details->CurrentValue;
		$this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

		// emergency_details
		$this->emergency_details->EditAttrs["class"] = "form-control";
		$this->emergency_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
		$this->emergency_details->EditValue = $this->emergency_details->CurrentValue;
		$this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

		// pan_no
		$this->pan_no->EditAttrs["class"] = "form-control";
		$this->pan_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
		$this->pan_no->EditValue = $this->pan_no->CurrentValue;
		$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

		// aadhaar_no
		$this->aadhaar_no->EditAttrs["class"] = "form-control";
		$this->aadhaar_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
		$this->aadhaar_no->EditValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

		// id_proof
		$this->id_proof->EditAttrs["class"] = "form-control";
		$this->id_proof->EditCustomAttributes = "";
		$this->id_proof->UploadPath = '.p_uploads/production_employee/'. $this->id->CurrentValue . '/';
		if (!EmptyValue($this->id_proof->Upload->DbValue)) {
			$this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
		} else {
			$this->id_proof->EditValue = "";
		}
		if (!EmptyValue($this->id_proof->CurrentValue))
				$this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;

		// reference_details
		$this->reference_details->EditAttrs["class"] = "form-control";
		$this->reference_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
		$this->reference_details->EditValue = $this->reference_details->CurrentValue;
		$this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

		// other_details
		$this->other_details->EditAttrs["class"] = "form-control";
		$this->other_details->EditCustomAttributes = "";
		$this->other_details->EditValue = $this->other_details->CurrentValue;
		$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

		// doj
		$this->doj->EditAttrs["class"] = "form-control";
		$this->doj->EditCustomAttributes = "";
		$this->doj->EditValue = FormatDateTime($this->doj->CurrentValue, 8);
		$this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

		// doc
		$this->doc->EditAttrs["class"] = "form-control";
		$this->doc->EditCustomAttributes = "";
		$this->doc->EditValue = FormatDateTime($this->doc->CurrentValue, 8);
		$this->doc->PlaceHolder = RemoveHtml($this->doc->caption());

		// dol
		$this->dol->EditAttrs["class"] = "form-control";
		$this->dol->EditCustomAttributes = "";
		$this->dol->EditValue = FormatDateTime($this->dol->CurrentValue, 8);
		$this->dol->PlaceHolder = RemoveHtml($this->dol->caption());

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		$this->image->UploadPath = '.p_uploads/production_employee/'. $this->id->CurrentValue . '/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->EditValue = $this->image->Upload->DbValue;
		} else {
			$this->image->EditValue = "";
		}
		if (!EmptyValue($this->image->CurrentValue))
				$this->image->Upload->FileName = $this->image->CurrentValue;

		// payment_details
		$this->payment_details->EditAttrs["class"] = "form-control";
		$this->payment_details->EditCustomAttributes = "";
		$this->payment_details->EditValue = $this->payment_details->CurrentValue;
		$this->payment_details->PlaceHolder = RemoveHtml($this->payment_details->caption());

		// bank_name
		$this->bank_name->EditAttrs["class"] = "form-control";
		$this->bank_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
		$this->bank_name->EditValue = $this->bank_name->CurrentValue;
		$this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

		// bank_ifsc_code
		$this->bank_ifsc_code->EditAttrs["class"] = "form-control";
		$this->bank_ifsc_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
		$this->bank_ifsc_code->EditValue = $this->bank_ifsc_code->CurrentValue;
		$this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

		// bank_account_no
		$this->bank_account_no->EditAttrs["class"] = "form-control";
		$this->bank_account_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
		$this->bank_account_no->EditValue = $this->bank_account_no->CurrentValue;
		$this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

		// operator
		$this->operator->EditAttrs["class"] = "form-control";
		$this->operator->EditCustomAttributes = "";
		$this->operator->EditValue = $this->operator->CurrentValue;
		$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

		// datetime
		$this->datetime->EditAttrs["class"] = "form-control";
		$this->datetime->EditCustomAttributes = "";
		$this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, 8);
		$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

		// d_operator
		// d_datetime
		// am_id

		$this->am_id->EditAttrs["class"] = "form-control";
		$this->am_id->EditCustomAttributes = "";
		$this->am_id->EditValue = $this->am_id->CurrentValue;
		$this->am_id->PlaceHolder = RemoveHtml($this->am_id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->site);
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->user_name);
					$doc->exportCaption($this->salary);
					$doc->exportCaption($this->contractor);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->employee_name);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->father_name);
					$doc->exportCaption($this->designation);
					$doc->exportCaption($this->permanent_address);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->dob);
					$doc->exportCaption($this->dom);
					$doc->exportCaption($this->mobile_other);
					$doc->exportCaption($this->mobile_family);
					$doc->exportCaption($this->marital_status);
					$doc->exportCaption($this->spouse_details);
					$doc->exportCaption($this->emergency_details);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->id_proof);
					$doc->exportCaption($this->reference_details);
					$doc->exportCaption($this->other_details);
					$doc->exportCaption($this->doj);
					$doc->exportCaption($this->dol);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->payment_details);
					$doc->exportCaption($this->bank_name);
					$doc->exportCaption($this->bank_ifsc_code);
					$doc->exportCaption($this->bank_account_no);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->d_operator);
					$doc->exportCaption($this->d_datetime);
					$doc->exportCaption($this->am_id);
				} else {
					$doc->exportCaption($this->uid);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->site);
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->user_name);
					$doc->exportCaption($this->salary);
					$doc->exportCaption($this->contractor);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->employee_name);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->father_name);
					$doc->exportCaption($this->designation);
					$doc->exportCaption($this->permanent_address);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->dob);
					$doc->exportCaption($this->dom);
					$doc->exportCaption($this->mobile_other);
					$doc->exportCaption($this->mobile_family);
					$doc->exportCaption($this->marital_status);
					$doc->exportCaption($this->spouse_details);
					$doc->exportCaption($this->emergency_details);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->id_proof);
					$doc->exportCaption($this->reference_details);
					$doc->exportCaption($this->doj);
					$doc->exportCaption($this->dol);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->bank_name);
					$doc->exportCaption($this->bank_ifsc_code);
					$doc->exportCaption($this->bank_account_no);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->d_operator);
					$doc->exportCaption($this->d_datetime);
					$doc->exportCaption($this->am_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->grp);
						$doc->exportField($this->site);
						$doc->exportField($this->id);
						$doc->exportField($this->user_name);
						$doc->exportField($this->salary);
						$doc->exportField($this->contractor);
						$doc->exportField($this->address);
						$doc->exportField($this->mobile);
						$doc->exportField($this->category);
						$doc->exportField($this->process);
						$doc->exportField($this->status);
						$doc->exportField($this->employee_name);
						$doc->exportField($this->gender);
						$doc->exportField($this->father_name);
						$doc->exportField($this->designation);
						$doc->exportField($this->permanent_address);
						$doc->exportField($this->city);
						$doc->exportField($this->dob);
						$doc->exportField($this->dom);
						$doc->exportField($this->mobile_other);
						$doc->exportField($this->mobile_family);
						$doc->exportField($this->marital_status);
						$doc->exportField($this->spouse_details);
						$doc->exportField($this->emergency_details);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->id_proof);
						$doc->exportField($this->reference_details);
						$doc->exportField($this->other_details);
						$doc->exportField($this->doj);
						$doc->exportField($this->dol);
						$doc->exportField($this->image);
						$doc->exportField($this->payment_details);
						$doc->exportField($this->bank_name);
						$doc->exportField($this->bank_ifsc_code);
						$doc->exportField($this->bank_account_no);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->d_operator);
						$doc->exportField($this->d_datetime);
						$doc->exportField($this->am_id);
					} else {
						$doc->exportField($this->uid);
						$doc->exportField($this->grp);
						$doc->exportField($this->site);
						$doc->exportField($this->id);
						$doc->exportField($this->user_name);
						$doc->exportField($this->salary);
						$doc->exportField($this->contractor);
						$doc->exportField($this->address);
						$doc->exportField($this->mobile);
						$doc->exportField($this->category);
						$doc->exportField($this->process);
						$doc->exportField($this->status);
						$doc->exportField($this->employee_name);
						$doc->exportField($this->gender);
						$doc->exportField($this->father_name);
						$doc->exportField($this->designation);
						$doc->exportField($this->permanent_address);
						$doc->exportField($this->city);
						$doc->exportField($this->dob);
						$doc->exportField($this->dom);
						$doc->exportField($this->mobile_other);
						$doc->exportField($this->mobile_family);
						$doc->exportField($this->marital_status);
						$doc->exportField($this->spouse_details);
						$doc->exportField($this->emergency_details);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->id_proof);
						$doc->exportField($this->reference_details);
						$doc->exportField($this->doj);
						$doc->exportField($this->dol);
						$doc->exportField($this->image);
						$doc->exportField($this->bank_name);
						$doc->exportField($this->bank_ifsc_code);
						$doc->exportField($this->bank_account_no);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->d_operator);
						$doc->exportField($this->d_datetime);
						$doc->exportField($this->am_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'id_proof') {
			$fldName = "id_proof";
			$fileNameFld = "id_proof";
		} elseif ($fldparm == 'image') {
			$fldName = "image";
			$fileNameFld = "image";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->uid->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>