<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class production_employee_hs_add extends production_employee_hs
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'production_employee_hs';

	// Page object name
	public $PageObjName = "production_employee_hs_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (production_employee_hs)
		if (!isset($GLOBALS["production_employee_hs"]) || get_class($GLOBALS["production_employee_hs"]) == PROJECT_NAMESPACE . "production_employee_hs") {
			$GLOBALS["production_employee_hs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["production_employee_hs"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_employee_hs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $production_employee_hs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($production_employee_hs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "production_employee_hsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['uid'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->uid->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("production_employee_hslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->uid->Visible = FALSE;
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->site->setVisibility();
		$this->user_name->setVisibility();
		$this->address->setVisibility();
		$this->mobile->setVisibility();
		$this->category->Visible = FALSE;
		$this->process->setVisibility();
		$this->employee_name->setVisibility();
		$this->gender->setVisibility();
		$this->father_name->setVisibility();
		$this->designation->setVisibility();
		$this->permanent_address->setVisibility();
		$this->city->setVisibility();
		$this->dob->setVisibility();
		$this->dom->setVisibility();
		$this->mobile_other->setVisibility();
		$this->mobile_family->setVisibility();
		$this->marital_status->setVisibility();
		$this->spouse_details->setVisibility();
		$this->emergency_details->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->id_proof->setVisibility();
		$this->reference_details->setVisibility();
		$this->other_details->setVisibility();
		$this->doj->setVisibility();
		$this->doc->setVisibility();
		$this->dol->setVisibility();
		$this->image->setVisibility();
		$this->payment_details->setVisibility();
		$this->bank_name->setVisibility();
		$this->bank_ifsc_code->setVisibility();
		$this->bank_account_no->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->d_operator->Visible = FALSE;
		$this->d_datetime->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->site);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("uid") !== NULL) {
				$this->uid->setQueryStringValue(Get("uid"));
				$this->setKey("uid", $this->uid->CurrentValue); // Set up key
			} else {
				$this->setKey("uid", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("production_employee_hslist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "production_employee_hslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "production_employee_hsview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->image->Upload->Index = $CurrentForm->Index;
		$this->image->Upload->uploadFile();
		$this->image->CurrentValue = $this->image->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->uid->CurrentValue = NULL;
		$this->uid->OldValue = $this->uid->CurrentValue;
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->grp->CurrentValue = 23;
		$this->site->CurrentValue = 9;
		$this->user_name->CurrentValue = NULL;
		$this->user_name->OldValue = $this->user_name->CurrentValue;
		$this->address->CurrentValue = NULL;
		$this->address->OldValue = $this->address->CurrentValue;
		$this->mobile->CurrentValue = NULL;
		$this->mobile->OldValue = $this->mobile->CurrentValue;
		$this->category->CurrentValue = NULL;
		$this->category->OldValue = $this->category->CurrentValue;
		$this->process->CurrentValue = 23;
		$this->employee_name->CurrentValue = NULL;
		$this->employee_name->OldValue = $this->employee_name->CurrentValue;
		$this->gender->CurrentValue = NULL;
		$this->gender->OldValue = $this->gender->CurrentValue;
		$this->father_name->CurrentValue = NULL;
		$this->father_name->OldValue = $this->father_name->CurrentValue;
		$this->designation->CurrentValue = NULL;
		$this->designation->OldValue = $this->designation->CurrentValue;
		$this->permanent_address->CurrentValue = NULL;
		$this->permanent_address->OldValue = $this->permanent_address->CurrentValue;
		$this->city->CurrentValue = NULL;
		$this->city->OldValue = $this->city->CurrentValue;
		$this->dob->CurrentValue = NULL;
		$this->dob->OldValue = $this->dob->CurrentValue;
		$this->dom->CurrentValue = NULL;
		$this->dom->OldValue = $this->dom->CurrentValue;
		$this->mobile_other->CurrentValue = NULL;
		$this->mobile_other->OldValue = $this->mobile_other->CurrentValue;
		$this->mobile_family->CurrentValue = NULL;
		$this->mobile_family->OldValue = $this->mobile_family->CurrentValue;
		$this->marital_status->CurrentValue = NULL;
		$this->marital_status->OldValue = $this->marital_status->CurrentValue;
		$this->spouse_details->CurrentValue = NULL;
		$this->spouse_details->OldValue = $this->spouse_details->CurrentValue;
		$this->emergency_details->CurrentValue = NULL;
		$this->emergency_details->OldValue = $this->emergency_details->CurrentValue;
		$this->aadhaar_no->CurrentValue = NULL;
		$this->aadhaar_no->OldValue = $this->aadhaar_no->CurrentValue;
		$this->id_proof->CurrentValue = NULL;
		$this->id_proof->OldValue = $this->id_proof->CurrentValue;
		$this->reference_details->CurrentValue = NULL;
		$this->reference_details->OldValue = $this->reference_details->CurrentValue;
		$this->other_details->CurrentValue = NULL;
		$this->other_details->OldValue = $this->other_details->CurrentValue;
		$this->doj->CurrentValue = NULL;
		$this->doj->OldValue = $this->doj->CurrentValue;
		$this->doc->CurrentValue = NULL;
		$this->doc->OldValue = $this->doc->CurrentValue;
		$this->dol->CurrentValue = NULL;
		$this->dol->OldValue = $this->dol->CurrentValue;
		$this->image->Upload->DbValue = NULL;
		$this->image->OldValue = $this->image->Upload->DbValue;
		$this->image->CurrentValue = NULL; // Clear file related field
		$this->payment_details->CurrentValue = NULL;
		$this->payment_details->OldValue = $this->payment_details->CurrentValue;
		$this->bank_name->CurrentValue = NULL;
		$this->bank_name->OldValue = $this->bank_name->CurrentValue;
		$this->bank_ifsc_code->CurrentValue = NULL;
		$this->bank_ifsc_code->OldValue = $this->bank_ifsc_code->CurrentValue;
		$this->bank_account_no->CurrentValue = NULL;
		$this->bank_account_no->OldValue = $this->bank_account_no->CurrentValue;
		$this->status->CurrentValue = 1;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->d_operator->CurrentValue = NULL;
		$this->d_operator->OldValue = $this->d_operator->CurrentValue;
		$this->d_datetime->CurrentValue = NULL;
		$this->d_datetime->OldValue = $this->d_datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'site' first before field var 'x_site'
		$val = $CurrentForm->hasValue("site") ? $CurrentForm->getValue("site") : $CurrentForm->getValue("x_site");
		if (!$this->site->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->site->Visible = FALSE; // Disable update for API request
			else
				$this->site->setFormValue($val);
		}

		// Check field name 'user_name' first before field var 'x_user_name'
		$val = $CurrentForm->hasValue("user_name") ? $CurrentForm->getValue("user_name") : $CurrentForm->getValue("x_user_name");
		if (!$this->user_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->user_name->Visible = FALSE; // Disable update for API request
			else
				$this->user_name->setFormValue($val);
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address->Visible = FALSE; // Disable update for API request
			else
				$this->address->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'employee_name' first before field var 'x_employee_name'
		$val = $CurrentForm->hasValue("employee_name") ? $CurrentForm->getValue("employee_name") : $CurrentForm->getValue("x_employee_name");
		if (!$this->employee_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_name->Visible = FALSE; // Disable update for API request
			else
				$this->employee_name->setFormValue($val);
		}

		// Check field name 'gender' first before field var 'x_gender'
		$val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
		if (!$this->gender->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gender->Visible = FALSE; // Disable update for API request
			else
				$this->gender->setFormValue($val);
		}

		// Check field name 'father_name' first before field var 'x_father_name'
		$val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
		if (!$this->father_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->father_name->Visible = FALSE; // Disable update for API request
			else
				$this->father_name->setFormValue($val);
		}

		// Check field name 'designation' first before field var 'x_designation'
		$val = $CurrentForm->hasValue("designation") ? $CurrentForm->getValue("designation") : $CurrentForm->getValue("x_designation");
		if (!$this->designation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->designation->Visible = FALSE; // Disable update for API request
			else
				$this->designation->setFormValue($val);
		}

		// Check field name 'permanent_address' first before field var 'x_permanent_address'
		$val = $CurrentForm->hasValue("permanent_address") ? $CurrentForm->getValue("permanent_address") : $CurrentForm->getValue("x_permanent_address");
		if (!$this->permanent_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->permanent_address->Visible = FALSE; // Disable update for API request
			else
				$this->permanent_address->setFormValue($val);
		}

		// Check field name 'city' first before field var 'x_city'
		$val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
		if (!$this->city->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->city->Visible = FALSE; // Disable update for API request
			else
				$this->city->setFormValue($val);
		}

		// Check field name 'dob' first before field var 'x_dob'
		$val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
		if (!$this->dob->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dob->Visible = FALSE; // Disable update for API request
			else
				$this->dob->setFormValue($val);
			$this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, 0);
		}

		// Check field name 'dom' first before field var 'x_dom'
		$val = $CurrentForm->hasValue("dom") ? $CurrentForm->getValue("dom") : $CurrentForm->getValue("x_dom");
		if (!$this->dom->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dom->Visible = FALSE; // Disable update for API request
			else
				$this->dom->setFormValue($val);
			$this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, 0);
		}

		// Check field name 'mobile_other' first before field var 'x_mobile_other'
		$val = $CurrentForm->hasValue("mobile_other") ? $CurrentForm->getValue("mobile_other") : $CurrentForm->getValue("x_mobile_other");
		if (!$this->mobile_other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile_other->Visible = FALSE; // Disable update for API request
			else
				$this->mobile_other->setFormValue($val);
		}

		// Check field name 'mobile_family' first before field var 'x_mobile_family'
		$val = $CurrentForm->hasValue("mobile_family") ? $CurrentForm->getValue("mobile_family") : $CurrentForm->getValue("x_mobile_family");
		if (!$this->mobile_family->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile_family->Visible = FALSE; // Disable update for API request
			else
				$this->mobile_family->setFormValue($val);
		}

		// Check field name 'marital_status' first before field var 'x_marital_status'
		$val = $CurrentForm->hasValue("marital_status") ? $CurrentForm->getValue("marital_status") : $CurrentForm->getValue("x_marital_status");
		if (!$this->marital_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->marital_status->Visible = FALSE; // Disable update for API request
			else
				$this->marital_status->setFormValue($val);
		}

		// Check field name 'spouse_details' first before field var 'x_spouse_details'
		$val = $CurrentForm->hasValue("spouse_details") ? $CurrentForm->getValue("spouse_details") : $CurrentForm->getValue("x_spouse_details");
		if (!$this->spouse_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->spouse_details->Visible = FALSE; // Disable update for API request
			else
				$this->spouse_details->setFormValue($val);
		}

		// Check field name 'emergency_details' first before field var 'x_emergency_details'
		$val = $CurrentForm->hasValue("emergency_details") ? $CurrentForm->getValue("emergency_details") : $CurrentForm->getValue("x_emergency_details");
		if (!$this->emergency_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emergency_details->Visible = FALSE; // Disable update for API request
			else
				$this->emergency_details->setFormValue($val);
		}

		// Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
		$val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
		if (!$this->aadhaar_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->aadhaar_no->Visible = FALSE; // Disable update for API request
			else
				$this->aadhaar_no->setFormValue($val);
		}

		// Check field name 'id_proof' first before field var 'x_id_proof'
		$val = $CurrentForm->hasValue("id_proof") ? $CurrentForm->getValue("id_proof") : $CurrentForm->getValue("x_id_proof");
		if (!$this->id_proof->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id_proof->Visible = FALSE; // Disable update for API request
			else
				$this->id_proof->setFormValue($val);
		}

		// Check field name 'reference_details' first before field var 'x_reference_details'
		$val = $CurrentForm->hasValue("reference_details") ? $CurrentForm->getValue("reference_details") : $CurrentForm->getValue("x_reference_details");
		if (!$this->reference_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reference_details->Visible = FALSE; // Disable update for API request
			else
				$this->reference_details->setFormValue($val);
		}

		// Check field name 'other_details' first before field var 'x_other_details'
		$val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
		if (!$this->other_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_details->Visible = FALSE; // Disable update for API request
			else
				$this->other_details->setFormValue($val);
		}

		// Check field name 'doj' first before field var 'x_doj'
		$val = $CurrentForm->hasValue("doj") ? $CurrentForm->getValue("doj") : $CurrentForm->getValue("x_doj");
		if (!$this->doj->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->doj->Visible = FALSE; // Disable update for API request
			else
				$this->doj->setFormValue($val);
			$this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, 0);
		}

		// Check field name 'doc' first before field var 'x_doc'
		$val = $CurrentForm->hasValue("doc") ? $CurrentForm->getValue("doc") : $CurrentForm->getValue("x_doc");
		if (!$this->doc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->doc->Visible = FALSE; // Disable update for API request
			else
				$this->doc->setFormValue($val);
			$this->doc->CurrentValue = UnFormatDateTime($this->doc->CurrentValue, 0);
		}

		// Check field name 'dol' first before field var 'x_dol'
		$val = $CurrentForm->hasValue("dol") ? $CurrentForm->getValue("dol") : $CurrentForm->getValue("x_dol");
		if (!$this->dol->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dol->Visible = FALSE; // Disable update for API request
			else
				$this->dol->setFormValue($val);
			$this->dol->CurrentValue = UnFormatDateTime($this->dol->CurrentValue, 0);
		}

		// Check field name 'payment_details' first before field var 'x_payment_details'
		$val = $CurrentForm->hasValue("payment_details") ? $CurrentForm->getValue("payment_details") : $CurrentForm->getValue("x_payment_details");
		if (!$this->payment_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_details->Visible = FALSE; // Disable update for API request
			else
				$this->payment_details->setFormValue($val);
		}

		// Check field name 'bank_name' first before field var 'x_bank_name'
		$val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
		if (!$this->bank_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_name->Visible = FALSE; // Disable update for API request
			else
				$this->bank_name->setFormValue($val);
		}

		// Check field name 'bank_ifsc_code' first before field var 'x_bank_ifsc_code'
		$val = $CurrentForm->hasValue("bank_ifsc_code") ? $CurrentForm->getValue("bank_ifsc_code") : $CurrentForm->getValue("x_bank_ifsc_code");
		if (!$this->bank_ifsc_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_ifsc_code->Visible = FALSE; // Disable update for API request
			else
				$this->bank_ifsc_code->setFormValue($val);
		}

		// Check field name 'bank_account_no' first before field var 'x_bank_account_no'
		$val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
		if (!$this->bank_account_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_account_no->Visible = FALSE; // Disable update for API request
			else
				$this->bank_account_no->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'uid' first before field var 'x_uid'
		$val = $CurrentForm->hasValue("uid") ? $CurrentForm->getValue("uid") : $CurrentForm->getValue("x_uid");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->site->CurrentValue = $this->site->FormValue;
		$this->user_name->CurrentValue = $this->user_name->FormValue;
		$this->address->CurrentValue = $this->address->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->employee_name->CurrentValue = $this->employee_name->FormValue;
		$this->gender->CurrentValue = $this->gender->FormValue;
		$this->father_name->CurrentValue = $this->father_name->FormValue;
		$this->designation->CurrentValue = $this->designation->FormValue;
		$this->permanent_address->CurrentValue = $this->permanent_address->FormValue;
		$this->city->CurrentValue = $this->city->FormValue;
		$this->dob->CurrentValue = $this->dob->FormValue;
		$this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, 0);
		$this->dom->CurrentValue = $this->dom->FormValue;
		$this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, 0);
		$this->mobile_other->CurrentValue = $this->mobile_other->FormValue;
		$this->mobile_family->CurrentValue = $this->mobile_family->FormValue;
		$this->marital_status->CurrentValue = $this->marital_status->FormValue;
		$this->spouse_details->CurrentValue = $this->spouse_details->FormValue;
		$this->emergency_details->CurrentValue = $this->emergency_details->FormValue;
		$this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
		$this->id_proof->CurrentValue = $this->id_proof->FormValue;
		$this->reference_details->CurrentValue = $this->reference_details->FormValue;
		$this->other_details->CurrentValue = $this->other_details->FormValue;
		$this->doj->CurrentValue = $this->doj->FormValue;
		$this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, 0);
		$this->doc->CurrentValue = $this->doc->FormValue;
		$this->doc->CurrentValue = UnFormatDateTime($this->doc->CurrentValue, 0);
		$this->dol->CurrentValue = $this->dol->FormValue;
		$this->dol->CurrentValue = UnFormatDateTime($this->dol->CurrentValue, 0);
		$this->payment_details->CurrentValue = $this->payment_details->FormValue;
		$this->bank_name->CurrentValue = $this->bank_name->FormValue;
		$this->bank_ifsc_code->CurrentValue = $this->bank_ifsc_code->FormValue;
		$this->bank_account_no->CurrentValue = $this->bank_account_no->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->uid->setDbValue($row['uid']);
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->site->setDbValue($row['site']);
		$this->user_name->setDbValue($row['user_name']);
		$this->address->setDbValue($row['address']);
		$this->mobile->setDbValue($row['mobile']);
		$this->category->setDbValue($row['category']);
		$this->process->setDbValue($row['process']);
		$this->employee_name->setDbValue($row['employee_name']);
		$this->gender->setDbValue($row['gender']);
		$this->father_name->setDbValue($row['father_name']);
		$this->designation->setDbValue($row['designation']);
		$this->permanent_address->setDbValue($row['permanent_address']);
		$this->city->setDbValue($row['city']);
		$this->dob->setDbValue($row['dob']);
		$this->dom->setDbValue($row['dom']);
		$this->mobile_other->setDbValue($row['mobile_other']);
		$this->mobile_family->setDbValue($row['mobile_family']);
		$this->marital_status->setDbValue($row['marital_status']);
		$this->spouse_details->setDbValue($row['spouse_details']);
		$this->emergency_details->setDbValue($row['emergency_details']);
		$this->aadhaar_no->setDbValue($row['aadhaar_no']);
		$this->id_proof->setDbValue($row['id_proof']);
		$this->reference_details->setDbValue($row['reference_details']);
		$this->other_details->setDbValue($row['other_details']);
		$this->doj->setDbValue($row['doj']);
		$this->doc->setDbValue($row['doc']);
		$this->dol->setDbValue($row['dol']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->payment_details->setDbValue($row['payment_details']);
		$this->bank_name->setDbValue($row['bank_name']);
		$this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
		$this->bank_account_no->setDbValue($row['bank_account_no']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->d_operator->setDbValue($row['d_operator']);
		$this->d_datetime->setDbValue($row['d_datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['uid'] = $this->uid->CurrentValue;
		$row['id'] = $this->id->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['site'] = $this->site->CurrentValue;
		$row['user_name'] = $this->user_name->CurrentValue;
		$row['address'] = $this->address->CurrentValue;
		$row['mobile'] = $this->mobile->CurrentValue;
		$row['category'] = $this->category->CurrentValue;
		$row['process'] = $this->process->CurrentValue;
		$row['employee_name'] = $this->employee_name->CurrentValue;
		$row['gender'] = $this->gender->CurrentValue;
		$row['father_name'] = $this->father_name->CurrentValue;
		$row['designation'] = $this->designation->CurrentValue;
		$row['permanent_address'] = $this->permanent_address->CurrentValue;
		$row['city'] = $this->city->CurrentValue;
		$row['dob'] = $this->dob->CurrentValue;
		$row['dom'] = $this->dom->CurrentValue;
		$row['mobile_other'] = $this->mobile_other->CurrentValue;
		$row['mobile_family'] = $this->mobile_family->CurrentValue;
		$row['marital_status'] = $this->marital_status->CurrentValue;
		$row['spouse_details'] = $this->spouse_details->CurrentValue;
		$row['emergency_details'] = $this->emergency_details->CurrentValue;
		$row['aadhaar_no'] = $this->aadhaar_no->CurrentValue;
		$row['id_proof'] = $this->id_proof->CurrentValue;
		$row['reference_details'] = $this->reference_details->CurrentValue;
		$row['other_details'] = $this->other_details->CurrentValue;
		$row['doj'] = $this->doj->CurrentValue;
		$row['doc'] = $this->doc->CurrentValue;
		$row['dol'] = $this->dol->CurrentValue;
		$row['image'] = $this->image->Upload->DbValue;
		$row['payment_details'] = $this->payment_details->CurrentValue;
		$row['bank_name'] = $this->bank_name->CurrentValue;
		$row['bank_ifsc_code'] = $this->bank_ifsc_code->CurrentValue;
		$row['bank_account_no'] = $this->bank_account_no->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['d_operator'] = $this->d_operator->CurrentValue;
		$row['d_datetime'] = $this->d_datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("uid")) <> "")
			$this->uid->CurrentValue = $this->getKey("uid"); // uid
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// uid
		// id
		// grp
		// site
		// user_name
		// address
		// mobile
		// category
		// process
		// employee_name
		// gender
		// father_name
		// designation
		// permanent_address
		// city
		// dob
		// dom
		// mobile_other
		// mobile_family
		// marital_status
		// spouse_details
		// emergency_details
		// aadhaar_no
		// id_proof
		// reference_details
		// other_details
		// doj
		// doc
		// dol
		// image
		// payment_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// status
		// operator
		// datetime
		// d_operator
		// d_datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// uid
			$this->uid->ViewValue = $this->uid->CurrentValue;
			$this->uid->ViewCustomAttributes = "";

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// site
			$curVal = strval($this->site->CurrentValue);
			if ($curVal <> "") {
				$this->site->ViewValue = $this->site->lookupCacheOption($curVal);
				if ($this->site->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->site->ViewValue = $this->site->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->site->ViewValue = $this->site->CurrentValue;
					}
				}
			} else {
				$this->site->ViewValue = NULL;
			}
			$this->site->ViewCustomAttributes = "";

			// user_name
			$this->user_name->ViewValue = $this->user_name->CurrentValue;
			$this->user_name->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
			$this->mobile->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`grp` = 2 AND `id` = 23";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process->ViewValue->add($this->process->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// employee_name
			$this->employee_name->ViewValue = $this->employee_name->CurrentValue;
			$this->employee_name->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) <> "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// father_name
			$this->father_name->ViewValue = $this->father_name->CurrentValue;
			$this->father_name->ViewCustomAttributes = "";

			// designation
			$this->designation->ViewValue = $this->designation->CurrentValue;
			$this->designation->ViewValue = FormatNumber($this->designation->ViewValue, 0, -2, -2, -2);
			$this->designation->ViewCustomAttributes = "";

			// permanent_address
			$this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;
			$this->permanent_address->ViewCustomAttributes = "";

			// city
			$this->city->ViewValue = $this->city->CurrentValue;
			$this->city->ViewCustomAttributes = "";

			// dob
			$this->dob->ViewValue = $this->dob->CurrentValue;
			$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 0);
			$this->dob->ViewCustomAttributes = "";

			// dom
			$this->dom->ViewValue = $this->dom->CurrentValue;
			$this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, 0);
			$this->dom->ViewCustomAttributes = "";

			// mobile_other
			$this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;
			$this->mobile_other->ViewCustomAttributes = "";

			// mobile_family
			$this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;
			$this->mobile_family->ViewCustomAttributes = "";

			// marital_status
			if (strval($this->marital_status->CurrentValue) <> "") {
				$this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
			} else {
				$this->marital_status->ViewValue = NULL;
			}
			$this->marital_status->ViewCustomAttributes = "";

			// spouse_details
			$this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;
			$this->spouse_details->ViewCustomAttributes = "";

			// emergency_details
			$this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;
			$this->emergency_details->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// id_proof
			$this->id_proof->ViewValue = $this->id_proof->CurrentValue;
			$this->id_proof->ViewCustomAttributes = "";

			// reference_details
			$this->reference_details->ViewValue = $this->reference_details->CurrentValue;
			$this->reference_details->ViewCustomAttributes = "";

			// other_details
			$this->other_details->ViewValue = $this->other_details->CurrentValue;
			$this->other_details->ViewCustomAttributes = "";

			// doj
			$this->doj->ViewValue = $this->doj->CurrentValue;
			$this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, 0);
			$this->doj->ViewCustomAttributes = "";

			// doc
			$this->doc->ViewValue = $this->doc->CurrentValue;
			$this->doc->ViewValue = FormatDateTime($this->doc->ViewValue, 0);
			$this->doc->ViewCustomAttributes = "";

			// dol
			$this->dol->ViewValue = $this->dol->CurrentValue;
			$this->dol->ViewValue = FormatDateTime($this->dol->ViewValue, 0);
			$this->dol->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '/uploads/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// payment_details
			$this->payment_details->ViewValue = $this->payment_details->CurrentValue;
			$this->payment_details->ViewCustomAttributes = "";

			// bank_name
			$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
			$this->bank_name->ViewCustomAttributes = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
			$this->bank_ifsc_code->ViewCustomAttributes = "";

			// bank_account_no
			$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
			$this->bank_account_no->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// d_operator
			$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
			$this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, 0, -2, -2, -2);
			$this->d_operator->ViewCustomAttributes = "";

			// d_datetime
			$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
			$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 0);
			$this->d_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// site
			$this->site->LinkCustomAttributes = "";
			if (!EmptyValue($this->site->CurrentValue)) {
				$this->site->HrefValue = "production_employee_hslist.php?x_site=" . $this->site->CurrentValue; // Add prefix/suffix
				$this->site->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
			} else {
				$this->site->HrefValue = "";
			}
			$this->site->TooltipValue = "";

			// user_name
			$this->user_name->LinkCustomAttributes = "";
			if (!EmptyValue($this->user_name->CurrentValue)) {
				$this->user_name->HrefValue = "production_employee_hslist.php?x_user_name=" . $this->user_name->CurrentValue; // Add prefix/suffix
				$this->user_name->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->user_name->HrefValue = FullUrl($this->user_name->HrefValue, "href");
			} else {
				$this->user_name->HrefValue = "";
			}
			$this->user_name->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "production_employee_hslist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// employee_name
			$this->employee_name->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_name->CurrentValue)) {
				$this->employee_name->HrefValue = "production_employee_hslist.php?x_employee_name=" . $this->employee_name->CurrentValue; // Add prefix/suffix
				$this->employee_name->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->employee_name->HrefValue = FullUrl($this->employee_name->HrefValue, "href");
			} else {
				$this->employee_name->HrefValue = "";
			}
			$this->employee_name->TooltipValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";
			$this->father_name->TooltipValue = "";

			// designation
			$this->designation->LinkCustomAttributes = "";
			if (!EmptyValue($this->designation->CurrentValue)) {
				$this->designation->HrefValue = "production_employee_hslist.php?x_designation=" . $this->designation->CurrentValue; // Add prefix/suffix
				$this->designation->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->designation->HrefValue = FullUrl($this->designation->HrefValue, "href");
			} else {
				$this->designation->HrefValue = "";
			}
			$this->designation->TooltipValue = "";

			// permanent_address
			$this->permanent_address->LinkCustomAttributes = "";
			$this->permanent_address->HrefValue = "";
			$this->permanent_address->TooltipValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";
			$this->city->TooltipValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";
			$this->dob->TooltipValue = "";

			// dom
			$this->dom->LinkCustomAttributes = "";
			$this->dom->HrefValue = "";
			$this->dom->TooltipValue = "";

			// mobile_other
			$this->mobile_other->LinkCustomAttributes = "";
			$this->mobile_other->HrefValue = "";
			$this->mobile_other->TooltipValue = "";

			// mobile_family
			$this->mobile_family->LinkCustomAttributes = "";
			$this->mobile_family->HrefValue = "";
			$this->mobile_family->TooltipValue = "";

			// marital_status
			$this->marital_status->LinkCustomAttributes = "";
			$this->marital_status->HrefValue = "";
			$this->marital_status->TooltipValue = "";

			// spouse_details
			$this->spouse_details->LinkCustomAttributes = "";
			$this->spouse_details->HrefValue = "";
			$this->spouse_details->TooltipValue = "";

			// emergency_details
			$this->emergency_details->LinkCustomAttributes = "";
			$this->emergency_details->HrefValue = "";
			$this->emergency_details->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = "";
			$this->id_proof->HrefValue = "";
			$this->id_proof->TooltipValue = "";

			// reference_details
			$this->reference_details->LinkCustomAttributes = "";
			$this->reference_details->HrefValue = "";
			$this->reference_details->TooltipValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";
			$this->other_details->TooltipValue = "";

			// doj
			$this->doj->LinkCustomAttributes = "";
			$this->doj->HrefValue = "";
			$this->doj->TooltipValue = "";

			// doc
			$this->doc->LinkCustomAttributes = "";
			$this->doc->HrefValue = "";
			$this->doc->TooltipValue = "";

			// dol
			$this->dol->LinkCustomAttributes = "";
			$this->dol->HrefValue = "";
			$this->dol->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";

			// payment_details
			$this->payment_details->LinkCustomAttributes = "";
			$this->payment_details->HrefValue = "";
			$this->payment_details->TooltipValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";
			$this->bank_name->TooltipValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";
			$this->bank_ifsc_code->TooltipValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";
			$this->bank_account_no->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			if (!EmptyValue($this->status->CurrentValue)) {
				$this->status->HrefValue = "production_employee_hslist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
				$this->status->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
			} else {
				$this->status->HrefValue = "";
			}
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->CurrentValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = $this->grp->options(TRUE);

			// site
			$this->site->EditAttrs["class"] = "form-control";
			$this->site->EditCustomAttributes = "";
			$curVal = trim(strval($this->site->CurrentValue));
			if ($curVal <> "")
				$this->site->ViewValue = $this->site->lookupCacheOption($curVal);
			else
				$this->site->ViewValue = $this->site->Lookup !== NULL && is_array($this->site->Lookup->Options) ? $curVal : NULL;
			if ($this->site->ViewValue !== NULL) { // Load from cache
				$this->site->EditValue = array_values($this->site->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->site->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->site->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->site->EditValue = $arwrk;
			}

			// user_name
			$this->user_name->EditAttrs["class"] = "form-control";
			$this->user_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
			$this->user_name->EditValue = HtmlEncode($this->user_name->CurrentValue);
			$this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// process
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->CurrentValue));
			if ($curVal <> "")
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`grp` = 2 AND `id` = 23";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// employee_name
			$this->employee_name->EditAttrs["class"] = "form-control";
			$this->employee_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->employee_name->CurrentValue = HtmlDecode($this->employee_name->CurrentValue);
			$this->employee_name->EditValue = HtmlEncode($this->employee_name->CurrentValue);
			$this->employee_name->PlaceHolder = RemoveHtml($this->employee_name->caption());

			// gender
			$this->gender->EditCustomAttributes = "";
			$this->gender->EditValue = $this->gender->options(FALSE);

			// father_name
			$this->father_name->EditAttrs["class"] = "form-control";
			$this->father_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
			$this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
			$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

			// designation
			$this->designation->EditAttrs["class"] = "form-control";
			$this->designation->EditCustomAttributes = "";
			$this->designation->EditValue = HtmlEncode($this->designation->CurrentValue);
			$this->designation->PlaceHolder = RemoveHtml($this->designation->caption());

			// permanent_address
			$this->permanent_address->EditAttrs["class"] = "form-control";
			$this->permanent_address->EditCustomAttributes = "";
			$this->permanent_address->EditValue = HtmlEncode($this->permanent_address->CurrentValue);
			$this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

			// city
			$this->city->EditAttrs["class"] = "form-control";
			$this->city->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
			$this->city->EditValue = HtmlEncode($this->city->CurrentValue);
			$this->city->PlaceHolder = RemoveHtml($this->city->caption());

			// dob
			$this->dob->EditAttrs["class"] = "form-control";
			$this->dob->EditCustomAttributes = "";
			$this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, 8));
			$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

			// dom
			$this->dom->EditAttrs["class"] = "form-control";
			$this->dom->EditCustomAttributes = "";
			$this->dom->EditValue = HtmlEncode(FormatDateTime($this->dom->CurrentValue, 8));
			$this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

			// mobile_other
			$this->mobile_other->EditAttrs["class"] = "form-control";
			$this->mobile_other->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
			$this->mobile_other->EditValue = HtmlEncode($this->mobile_other->CurrentValue);
			$this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

			// mobile_family
			$this->mobile_family->EditAttrs["class"] = "form-control";
			$this->mobile_family->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
			$this->mobile_family->EditValue = HtmlEncode($this->mobile_family->CurrentValue);
			$this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

			// marital_status
			$this->marital_status->EditCustomAttributes = "";
			$this->marital_status->EditValue = $this->marital_status->options(FALSE);

			// spouse_details
			$this->spouse_details->EditAttrs["class"] = "form-control";
			$this->spouse_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
			$this->spouse_details->EditValue = HtmlEncode($this->spouse_details->CurrentValue);
			$this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

			// emergency_details
			$this->emergency_details->EditAttrs["class"] = "form-control";
			$this->emergency_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
			$this->emergency_details->EditValue = HtmlEncode($this->emergency_details->CurrentValue);
			$this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// id_proof
			$this->id_proof->EditAttrs["class"] = "form-control";
			$this->id_proof->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->id_proof->CurrentValue = HtmlDecode($this->id_proof->CurrentValue);
			$this->id_proof->EditValue = HtmlEncode($this->id_proof->CurrentValue);
			$this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

			// reference_details
			$this->reference_details->EditAttrs["class"] = "form-control";
			$this->reference_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
			$this->reference_details->EditValue = HtmlEncode($this->reference_details->CurrentValue);
			$this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

			// other_details
			$this->other_details->EditAttrs["class"] = "form-control";
			$this->other_details->EditCustomAttributes = "";
			$this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
			$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

			// doj
			$this->doj->EditAttrs["class"] = "form-control";
			$this->doj->EditCustomAttributes = "";
			$this->doj->EditValue = HtmlEncode(FormatDateTime($this->doj->CurrentValue, 8));
			$this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

			// doc
			$this->doc->EditAttrs["class"] = "form-control";
			$this->doc->EditCustomAttributes = "";
			$this->doc->EditValue = HtmlEncode(FormatDateTime($this->doc->CurrentValue, 8));
			$this->doc->PlaceHolder = RemoveHtml($this->doc->caption());

			// dol
			$this->dol->EditAttrs["class"] = "form-control";
			$this->dol->EditCustomAttributes = "";
			$this->dol->EditValue = HtmlEncode(FormatDateTime($this->dol->CurrentValue, 8));
			$this->dol->PlaceHolder = RemoveHtml($this->dol->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			$this->image->UploadPath = '/uploads/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->EditValue = $this->image->Upload->DbValue;
			} else {
				$this->image->EditValue = "";
			}
			if (!EmptyValue($this->image->CurrentValue))
					$this->image->Upload->FileName = $this->image->CurrentValue;
			if (($this->isShow() || $this->isCopy()) && !$this->EventCancelled)
				RenderUploadField($this->image);

			// payment_details
			$this->payment_details->EditAttrs["class"] = "form-control";
			$this->payment_details->EditCustomAttributes = "";
			$this->payment_details->EditValue = HtmlEncode($this->payment_details->CurrentValue);
			$this->payment_details->PlaceHolder = RemoveHtml($this->payment_details->caption());

			// bank_name
			$this->bank_name->EditAttrs["class"] = "form-control";
			$this->bank_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
			$this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
			$this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

			// bank_ifsc_code
			$this->bank_ifsc_code->EditAttrs["class"] = "form-control";
			$this->bank_ifsc_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
			$this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->CurrentValue);
			$this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

			// bank_account_no
			$this->bank_account_no->EditAttrs["class"] = "form-control";
			$this->bank_account_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
			$this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
			$this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			// datetime
			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// site
			$this->site->LinkCustomAttributes = "";
			if (!EmptyValue($this->site->CurrentValue)) {
				$this->site->HrefValue = "production_employee_hslist.php?x_site=" . $this->site->CurrentValue; // Add prefix/suffix
				$this->site->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->site->HrefValue = FullUrl($this->site->HrefValue, "href");
			} else {
				$this->site->HrefValue = "";
			}

			// user_name
			$this->user_name->LinkCustomAttributes = "";
			if (!EmptyValue($this->user_name->CurrentValue)) {
				$this->user_name->HrefValue = "production_employee_hslist.php?x_user_name=" . $this->user_name->CurrentValue; // Add prefix/suffix
				$this->user_name->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->user_name->HrefValue = FullUrl($this->user_name->HrefValue, "href");
			} else {
				$this->user_name->HrefValue = "";
			}

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "production_employee_hslist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}

			// employee_name
			$this->employee_name->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_name->CurrentValue)) {
				$this->employee_name->HrefValue = "production_employee_hslist.php?x_employee_name=" . $this->employee_name->CurrentValue; // Add prefix/suffix
				$this->employee_name->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->employee_name->HrefValue = FullUrl($this->employee_name->HrefValue, "href");
			} else {
				$this->employee_name->HrefValue = "";
			}

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";

			// designation
			$this->designation->LinkCustomAttributes = "";
			if (!EmptyValue($this->designation->CurrentValue)) {
				$this->designation->HrefValue = "production_employee_hslist.php?x_designation=" . $this->designation->CurrentValue; // Add prefix/suffix
				$this->designation->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->designation->HrefValue = FullUrl($this->designation->HrefValue, "href");
			} else {
				$this->designation->HrefValue = "";
			}

			// permanent_address
			$this->permanent_address->LinkCustomAttributes = "";
			$this->permanent_address->HrefValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";

			// dom
			$this->dom->LinkCustomAttributes = "";
			$this->dom->HrefValue = "";

			// mobile_other
			$this->mobile_other->LinkCustomAttributes = "";
			$this->mobile_other->HrefValue = "";

			// mobile_family
			$this->mobile_family->LinkCustomAttributes = "";
			$this->mobile_family->HrefValue = "";

			// marital_status
			$this->marital_status->LinkCustomAttributes = "";
			$this->marital_status->HrefValue = "";

			// spouse_details
			$this->spouse_details->LinkCustomAttributes = "";
			$this->spouse_details->HrefValue = "";

			// emergency_details
			$this->emergency_details->LinkCustomAttributes = "";
			$this->emergency_details->HrefValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = "";
			$this->id_proof->HrefValue = "";

			// reference_details
			$this->reference_details->LinkCustomAttributes = "";
			$this->reference_details->HrefValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";

			// doj
			$this->doj->LinkCustomAttributes = "";
			$this->doj->HrefValue = "";

			// doc
			$this->doc->LinkCustomAttributes = "";
			$this->doc->HrefValue = "";

			// dol
			$this->dol->LinkCustomAttributes = "";
			$this->dol->HrefValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

			// payment_details
			$this->payment_details->LinkCustomAttributes = "";
			$this->payment_details->HrefValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			if (!EmptyValue($this->status->CurrentValue)) {
				$this->status->HrefValue = "production_employee_hslist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
				$this->status->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
			} else {
				$this->status->HrefValue = "";
			}

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->uid->Required) {
			if (!$this->uid->IsDetailKey && $this->uid->FormValue != NULL && $this->uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
			}
		}
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id->FormValue)) {
			AddMessage($FormError, $this->id->errorMessage());
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->site->Required) {
			if (!$this->site->IsDetailKey && $this->site->FormValue != NULL && $this->site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->site->caption(), $this->site->RequiredErrorMessage));
			}
		}
		if ($this->user_name->Required) {
			if (!$this->user_name->IsDetailKey && $this->user_name->FormValue != NULL && $this->user_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->user_name->caption(), $this->user_name->RequiredErrorMessage));
			}
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mobile->FormValue)) {
			AddMessage($FormError, $this->mobile->errorMessage());
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if ($this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->employee_name->Required) {
			if (!$this->employee_name->IsDetailKey && $this->employee_name->FormValue != NULL && $this->employee_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_name->caption(), $this->employee_name->RequiredErrorMessage));
			}
		}
		if ($this->gender->Required) {
			if ($this->gender->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
			}
		}
		if ($this->father_name->Required) {
			if (!$this->father_name->IsDetailKey && $this->father_name->FormValue != NULL && $this->father_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
			}
		}
		if ($this->designation->Required) {
			if (!$this->designation->IsDetailKey && $this->designation->FormValue != NULL && $this->designation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->designation->caption(), $this->designation->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->designation->FormValue)) {
			AddMessage($FormError, $this->designation->errorMessage());
		}
		if ($this->permanent_address->Required) {
			if (!$this->permanent_address->IsDetailKey && $this->permanent_address->FormValue != NULL && $this->permanent_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->permanent_address->caption(), $this->permanent_address->RequiredErrorMessage));
			}
		}
		if ($this->city->Required) {
			if (!$this->city->IsDetailKey && $this->city->FormValue != NULL && $this->city->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
			}
		}
		if ($this->dob->Required) {
			if (!$this->dob->IsDetailKey && $this->dob->FormValue != NULL && $this->dob->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dob->FormValue)) {
			AddMessage($FormError, $this->dob->errorMessage());
		}
		if ($this->dom->Required) {
			if (!$this->dom->IsDetailKey && $this->dom->FormValue != NULL && $this->dom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dom->caption(), $this->dom->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dom->FormValue)) {
			AddMessage($FormError, $this->dom->errorMessage());
		}
		if ($this->mobile_other->Required) {
			if (!$this->mobile_other->IsDetailKey && $this->mobile_other->FormValue != NULL && $this->mobile_other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile_other->caption(), $this->mobile_other->RequiredErrorMessage));
			}
		}
		if ($this->mobile_family->Required) {
			if (!$this->mobile_family->IsDetailKey && $this->mobile_family->FormValue != NULL && $this->mobile_family->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile_family->caption(), $this->mobile_family->RequiredErrorMessage));
			}
		}
		if ($this->marital_status->Required) {
			if ($this->marital_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->marital_status->caption(), $this->marital_status->RequiredErrorMessage));
			}
		}
		if ($this->spouse_details->Required) {
			if (!$this->spouse_details->IsDetailKey && $this->spouse_details->FormValue != NULL && $this->spouse_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->spouse_details->caption(), $this->spouse_details->RequiredErrorMessage));
			}
		}
		if ($this->emergency_details->Required) {
			if (!$this->emergency_details->IsDetailKey && $this->emergency_details->FormValue != NULL && $this->emergency_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emergency_details->caption(), $this->emergency_details->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar_no->Required) {
			if (!$this->aadhaar_no->IsDetailKey && $this->aadhaar_no->FormValue != NULL && $this->aadhaar_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
			}
		}
		if ($this->id_proof->Required) {
			if (!$this->id_proof->IsDetailKey && $this->id_proof->FormValue != NULL && $this->id_proof->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
			}
		}
		if ($this->reference_details->Required) {
			if (!$this->reference_details->IsDetailKey && $this->reference_details->FormValue != NULL && $this->reference_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reference_details->caption(), $this->reference_details->RequiredErrorMessage));
			}
		}
		if ($this->other_details->Required) {
			if (!$this->other_details->IsDetailKey && $this->other_details->FormValue != NULL && $this->other_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
			}
		}
		if ($this->doj->Required) {
			if (!$this->doj->IsDetailKey && $this->doj->FormValue != NULL && $this->doj->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->doj->caption(), $this->doj->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->doj->FormValue)) {
			AddMessage($FormError, $this->doj->errorMessage());
		}
		if ($this->doc->Required) {
			if (!$this->doc->IsDetailKey && $this->doc->FormValue != NULL && $this->doc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->doc->caption(), $this->doc->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->doc->FormValue)) {
			AddMessage($FormError, $this->doc->errorMessage());
		}
		if ($this->dol->Required) {
			if (!$this->dol->IsDetailKey && $this->dol->FormValue != NULL && $this->dol->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dol->caption(), $this->dol->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dol->FormValue)) {
			AddMessage($FormError, $this->dol->errorMessage());
		}
		if ($this->image->Required) {
			if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->payment_details->Required) {
			if (!$this->payment_details->IsDetailKey && $this->payment_details->FormValue != NULL && $this->payment_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_details->caption(), $this->payment_details->RequiredErrorMessage));
			}
		}
		if ($this->bank_name->Required) {
			if (!$this->bank_name->IsDetailKey && $this->bank_name->FormValue != NULL && $this->bank_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
			}
		}
		if ($this->bank_ifsc_code->Required) {
			if (!$this->bank_ifsc_code->IsDetailKey && $this->bank_ifsc_code->FormValue != NULL && $this->bank_ifsc_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_ifsc_code->caption(), $this->bank_ifsc_code->RequiredErrorMessage));
			}
		}
		if ($this->bank_account_no->Required) {
			if (!$this->bank_account_no->IsDetailKey && $this->bank_account_no->FormValue != NULL && $this->bank_account_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->d_operator->Required) {
			if (!$this->d_operator->IsDetailKey && $this->d_operator->FormValue != NULL && $this->d_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_operator->caption(), $this->d_operator->RequiredErrorMessage));
			}
		}
		if ($this->d_datetime->Required) {
			if (!$this->d_datetime->IsDetailKey && $this->d_datetime->FormValue != NULL && $this->d_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_datetime->caption(), $this->d_datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->image->OldUploadPath = '/uploads/';
			$this->image->UploadPath = $this->image->OldUploadPath;
		}
		$rsnew = [];

		// id
		$this->id->setDbValueDef($rsnew, $this->id->CurrentValue, 0, FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, FALSE);

		// site
		$this->site->setDbValueDef($rsnew, $this->site->CurrentValue, "", FALSE);

		// user_name
		$this->user_name->setDbValueDef($rsnew, $this->user_name->CurrentValue, NULL, FALSE);

		// address
		$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, NULL, FALSE);

		// mobile
		$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, FALSE);

		// process
		$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, NULL, FALSE);

		// employee_name
		$this->employee_name->setDbValueDef($rsnew, $this->employee_name->CurrentValue, NULL, FALSE);

		// gender
		$this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, NULL, FALSE);

		// father_name
		$this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, NULL, FALSE);

		// designation
		$this->designation->setDbValueDef($rsnew, $this->designation->CurrentValue, NULL, FALSE);

		// permanent_address
		$this->permanent_address->setDbValueDef($rsnew, $this->permanent_address->CurrentValue, NULL, FALSE);

		// city
		$this->city->setDbValueDef($rsnew, $this->city->CurrentValue, NULL, FALSE);

		// dob
		$this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, 0), NULL, FALSE);

		// dom
		$this->dom->setDbValueDef($rsnew, UnFormatDateTime($this->dom->CurrentValue, 0), NULL, FALSE);

		// mobile_other
		$this->mobile_other->setDbValueDef($rsnew, $this->mobile_other->CurrentValue, NULL, FALSE);

		// mobile_family
		$this->mobile_family->setDbValueDef($rsnew, $this->mobile_family->CurrentValue, NULL, FALSE);

		// marital_status
		$this->marital_status->setDbValueDef($rsnew, $this->marital_status->CurrentValue, NULL, FALSE);

		// spouse_details
		$this->spouse_details->setDbValueDef($rsnew, $this->spouse_details->CurrentValue, NULL, FALSE);

		// emergency_details
		$this->emergency_details->setDbValueDef($rsnew, $this->emergency_details->CurrentValue, NULL, FALSE);

		// aadhaar_no
		$this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, NULL, FALSE);

		// id_proof
		$this->id_proof->setDbValueDef($rsnew, $this->id_proof->CurrentValue, NULL, FALSE);

		// reference_details
		$this->reference_details->setDbValueDef($rsnew, $this->reference_details->CurrentValue, NULL, FALSE);

		// other_details
		$this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, NULL, FALSE);

		// doj
		$this->doj->setDbValueDef($rsnew, UnFormatDateTime($this->doj->CurrentValue, 0), NULL, FALSE);

		// doc
		$this->doc->setDbValueDef($rsnew, UnFormatDateTime($this->doc->CurrentValue, 0), NULL, FALSE);

		// dol
		$this->dol->setDbValueDef($rsnew, UnFormatDateTime($this->dol->CurrentValue, 0), NULL, FALSE);

		// image
		if ($this->image->Visible && !$this->image->Upload->KeepFile) {
			$this->image->Upload->DbValue = ""; // No need to delete old file
			if ($this->image->Upload->FileName == "") {
				$rsnew['image'] = NULL;
			} else {
				if ($rsold && $rsold->fields['image'] <> "" && $this->image->Upload->FileName <> "") {
					$oldFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsold->fields['image']);
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->image->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->image->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i], UploadTempPath($this->image, $this->image->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['image'] = $this->image->Upload->FileName;
			}
		}

		// payment_details
		$this->payment_details->setDbValueDef($rsnew, $this->payment_details->CurrentValue, NULL, FALSE);

		// bank_name
		$this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, NULL, FALSE);

		// bank_ifsc_code
		$this->bank_ifsc_code->setDbValueDef($rsnew, $this->bank_ifsc_code->CurrentValue, NULL, FALSE);

		// bank_account_no
		$this->bank_account_no->setDbValueDef($rsnew, $this->bank_account_no->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;
		if ($this->image->Visible && !$this->image->Upload->KeepFile) {
			$this->image->UploadPath = '/uploads/';
			$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->image->Upload->DbValue));
			if (!EmptyValue($this->image->Upload->FileName)) {
				$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->image->Upload->FileName));
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->image->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file1) || file_exists($this->image->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->image->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->image, $this->image->Upload->Index) . $file, UploadTempPath($this->image, $this->image->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->image->Visible && !$this->image->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->image->Upload->DbValue));
					if (!EmptyValue($this->image->Upload->FileName)) {
						$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->image->Upload->FileName);
						$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['image']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->image->Upload->saveToFile($newFiles[$i], TRUE, $i)) { // Just replace
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// image
		if ($this->image->Upload->FileToken <> "")
			CleanUploadTempPath($this->image->Upload->FileToken, $this->image->Upload->Index);
		else
			CleanUploadTempPath($this->image, $this->image->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("production_employee_hslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_site":
					$lookupFilter = function() {
						return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`grp` = 2 AND `id` = 23";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_site":
							break;
						case "x_process":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>