<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for production_partner
 */
class production_partner extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $name;
	public $code;
	public $country;
	public $region;
	public $city;
	public $address;
	public $mobile;
	public $_email;
	public $url;
	public $grp;
	public $category;
	public $reports_to;
	public $status;
	public $performance;
	public $operator;
	public $datetime;
	public $type;
	public $tax_registration;
	public $cin;
	public $pan;
	public $tan;
	public $msme;
	public $incoterm;
	public $port_air;
	public $port_sea;
	public $iec;
	public $rex;
	public $rcmc;
	public $delivery_terms;
	public $shipping_terms;
	public $payment_terms;
	public $export_type;
	public $lead_time_ss;
	public $lead_time_cs;
	public $cha;
	public $cha_email;
	public $cha_phone;
	public $forwarder;
	public $forwarder_email;
	public $forwarder_phone;
	public $merchant;
	public $merchant_email;
	public $merchant_phone;
	public $shipping_incharge;
	public $shipping_email;
	public $shipping_phone;
	public $account_incharge;
	public $accounts_email;
	public $accounts_phone;
	public $warehouse_incharge;
	public $warehouse_email;
	public $warehouse_phone;
	public $production_incharge;
	public $production_email;
	public $production_phone;
	public $qc_incharge;
	public $qc_email;
	public $qc_phone;
	public $uid;
	public $r_text;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'production_partner';
		$this->TableName = 'production_partner';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`production_partner`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('production_partner', 'production_partner', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->IsForeignKey = TRUE; // Foreign key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// name
		$this->name = new DbField('production_partner', 'production_partner', 'x_name', 'name', '`name`', '`name`', 200, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Nullable = FALSE; // NOT NULL field
		$this->name->Required = TRUE; // Required field
		$this->name->Sortable = TRUE; // Allow sort
		$this->fields['name'] = &$this->name;

		// code
		$this->code = new DbField('production_partner', 'production_partner', 'x_code', 'code', '`code`', '`code`', 200, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code->Required = TRUE; // Required field
		$this->code->Sortable = TRUE; // Allow sort
		$this->code->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['code'] = &$this->code;

		// country
		$this->country = new DbField('production_partner', 'production_partner', 'x_country', 'country', '`country`', '`country`', 18, -1, FALSE, '`country`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->country->Sortable = TRUE; // Allow sort
		$this->country->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->country->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->country->Lookup = new Lookup('country', 'world_country', FALSE, 'id', ["name","","",""], [], ["x_region"], [], [], [], [], '`name` ASC', '');
		$this->country->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['country'] = &$this->country;

		// region
		$this->region = new DbField('production_partner', 'production_partner', 'x_region', 'region', '`region`', '`region`', 19, -1, FALSE, '`region`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->region->Sortable = TRUE; // Allow sort
		$this->region->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->region->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->region->Lookup = new Lookup('region', 'world_state', FALSE, 'id', ["name","","",""], ["x_country"], ["x_city"], ["country_id"], ["x_country_id"], [], [], '`name` ASC', '');
		$this->region->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['region'] = &$this->region;

		// city
		$this->city = new DbField('production_partner', 'production_partner', 'x_city', 'city', '`city`', '`city`', 21, -1, FALSE, '`EV__city`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->city->Sortable = TRUE; // Allow sort
		$this->city->Lookup = new Lookup('city', 'world_city', FALSE, 'id', ["name","","",""], ["x_region"], [], ["state_id"], ["x_state_id"], [], [], '`name` ASC', '');
		$this->city->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['city'] = &$this->city;

		// address
		$this->address = new DbField('production_partner', 'production_partner', 'x_address', 'address', '`address`', '`address`', 200, -1, FALSE, '`address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->address->Sortable = TRUE; // Allow sort
		$this->fields['address'] = &$this->address;

		// mobile
		$this->mobile = new DbField('production_partner', 'production_partner', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 200, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Sortable = FALSE; // Allow sort
		$this->fields['mobile'] = &$this->mobile;

		// email
		$this->_email = new DbField('production_partner', 'production_partner', 'x__email', 'email', '`email`', '`email`', 200, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->fields['email'] = &$this->_email;

		// url
		$this->url = new DbField('production_partner', 'production_partner', 'x_url', 'url', '`url`', '`url`', 200, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->Sortable = TRUE; // Allow sort
		$this->fields['url'] = &$this->url;

		// grp
		$this->grp = new DbField('production_partner', 'production_partner', 'x_grp', 'grp', '`grp`', '`grp`', 200, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// category
		$this->category = new DbField('production_partner', 'production_partner', 'x_category', 'category', '`category`', '`category`', 2, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->category->Nullable = FALSE; // NOT NULL field
		$this->category->Required = TRUE; // Required field
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->category->Lookup = new Lookup('category', 'pp_category', FALSE, 'id', ["category","","",""], [], [], [], [], [], [], '`category` ASC', '');
		$this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['category'] = &$this->category;

		// reports_to
		$this->reports_to = new DbField('production_partner', 'production_partner', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 18, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->reports_to->Nullable = FALSE; // NOT NULL field
		$this->reports_to->Required = TRUE; // Required field
		$this->reports_to->Sortable = TRUE; // Allow sort
		$this->reports_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->reports_to->Lookup = new Lookup('reports_to', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reports_to'] = &$this->reports_to;

		// status
		$this->status = new DbField('production_partner', 'production_partner', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'production_partner', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// performance
		$this->performance = new DbField('production_partner', 'production_partner', 'x_performance', 'performance', '`performance`', '`performance`', 16, -1, FALSE, '`performance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->performance->Sortable = TRUE; // Allow sort
		$this->performance->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['performance'] = &$this->performance;

		// operator
		$this->operator = new DbField('production_partner', 'production_partner', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('production_partner', 'production_partner', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// type
		$this->type = new DbField('production_partner', 'production_partner', 'x_type', 'type', '`type`', '`type`', 17, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->type->Nullable = FALSE; // NOT NULL field
		$this->type->Required = TRUE; // Required field
		$this->type->Sortable = TRUE; // Allow sort
		$this->type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->type->Lookup = new Lookup('type', 'production_partner', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->type->OptionCount = 5;
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// tax_registration
		$this->tax_registration = new DbField('production_partner', 'production_partner', 'x_tax_registration', 'tax_registration', '`tax_registration`', '`tax_registration`', 200, -1, FALSE, '`tax_registration`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tax_registration->Sortable = TRUE; // Allow sort
		$this->fields['tax_registration'] = &$this->tax_registration;

		// cin
		$this->cin = new DbField('production_partner', 'production_partner', 'x_cin', 'cin', '`cin`', '`cin`', 200, -1, FALSE, '`cin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cin->Sortable = TRUE; // Allow sort
		$this->fields['cin'] = &$this->cin;

		// pan
		$this->pan = new DbField('production_partner', 'production_partner', 'x_pan', 'pan', '`pan`', '`pan`', 200, -1, FALSE, '`pan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan->Sortable = TRUE; // Allow sort
		$this->fields['pan'] = &$this->pan;

		// tan
		$this->tan = new DbField('production_partner', 'production_partner', 'x_tan', 'tan', '`tan`', '`tan`', 200, -1, FALSE, '`tan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tan->Sortable = TRUE; // Allow sort
		$this->fields['tan'] = &$this->tan;

		// msme
		$this->msme = new DbField('production_partner', 'production_partner', 'x_msme', 'msme', '`msme`', '`msme`', 200, -1, FALSE, '`msme`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->msme->Sortable = TRUE; // Allow sort
		$this->fields['msme'] = &$this->msme;

		// incoterm
		$this->incoterm = new DbField('production_partner', 'production_partner', 'x_incoterm', 'incoterm', '`incoterm`', '`incoterm`', 200, -1, FALSE, '`incoterm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->incoterm->Sortable = FALSE; // Allow sort
		$this->incoterm->SelectMultiple = TRUE; // Multiple select
		$this->incoterm->Lookup = new Lookup('incoterm', 'incoterm', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['incoterm'] = &$this->incoterm;

		// port_air
		$this->port_air = new DbField('production_partner', 'production_partner', 'x_port_air', 'port_air', '`port_air`', '`port_air`', 18, -1, FALSE, '`port_air`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->port_air->Sortable = TRUE; // Allow sort
		$this->port_air->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->port_air->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->port_air->Lookup = new Lookup('port_air', 'port', FALSE, 'id', ["port","code","",""], [], [], [], [], [], [], '`port` ASC', '');
		$this->fields['port_air'] = &$this->port_air;

		// port_sea
		$this->port_sea = new DbField('production_partner', 'production_partner', 'x_port_sea', 'port_sea', '`port_sea`', '`port_sea`', 18, -1, FALSE, '`port_sea`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->port_sea->Sortable = TRUE; // Allow sort
		$this->port_sea->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->port_sea->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->port_sea->Lookup = new Lookup('port_sea', 'port', FALSE, 'id', ["port","code","",""], [], [], [], [], [], [], '`port` ASC', '');
		$this->fields['port_sea'] = &$this->port_sea;

		// iec
		$this->iec = new DbField('production_partner', 'production_partner', 'x_iec', 'iec', '`iec`', '`iec`', 200, -1, FALSE, '`iec`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->iec->Sortable = TRUE; // Allow sort
		$this->fields['iec'] = &$this->iec;

		// rex
		$this->rex = new DbField('production_partner', 'production_partner', 'x_rex', 'rex', '`rex`', '`rex`', 200, -1, FALSE, '`rex`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rex->Sortable = TRUE; // Allow sort
		$this->fields['rex'] = &$this->rex;

		// rcmc
		$this->rcmc = new DbField('production_partner', 'production_partner', 'x_rcmc', 'rcmc', '`rcmc`', '`rcmc`', 200, -1, FALSE, '`rcmc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rcmc->Sortable = TRUE; // Allow sort
		$this->fields['rcmc'] = &$this->rcmc;

		// delivery_terms
		$this->delivery_terms = new DbField('production_partner', 'production_partner', 'x_delivery_terms', 'delivery_terms', '`delivery_terms`', '`delivery_terms`', 200, -1, FALSE, '`delivery_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->delivery_terms->Sortable = TRUE; // Allow sort
		$this->fields['delivery_terms'] = &$this->delivery_terms;

		// shipping_terms
		$this->shipping_terms = new DbField('production_partner', 'production_partner', 'x_shipping_terms', 'shipping_terms', '`shipping_terms`', '`shipping_terms`', 200, -1, FALSE, '`shipping_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_terms->Sortable = TRUE; // Allow sort
		$this->fields['shipping_terms'] = &$this->shipping_terms;

		// payment_terms
		$this->payment_terms = new DbField('production_partner', 'production_partner', 'x_payment_terms', 'payment_terms', '`payment_terms`', '`payment_terms`', 200, -1, FALSE, '`payment_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment_terms->Sortable = TRUE; // Allow sort
		$this->fields['payment_terms'] = &$this->payment_terms;

		// export_type
		$this->export_type = new DbField('production_partner', 'production_partner', 'x_export_type', 'export_type', '`export_type`', '`export_type`', 200, -1, FALSE, '`export_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->export_type->Sortable = TRUE; // Allow sort
		$this->fields['export_type'] = &$this->export_type;

		// lead_time_ss
		$this->lead_time_ss = new DbField('production_partner', 'production_partner', 'x_lead_time_ss', 'lead_time_ss', '`lead_time_ss`', '`lead_time_ss`', 200, -1, FALSE, '`lead_time_ss`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lead_time_ss->Sortable = TRUE; // Allow sort
		$this->lead_time_ss->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['lead_time_ss'] = &$this->lead_time_ss;

		// lead_time_cs
		$this->lead_time_cs = new DbField('production_partner', 'production_partner', 'x_lead_time_cs', 'lead_time_cs', '`lead_time_cs`', '`lead_time_cs`', 200, -1, FALSE, '`lead_time_cs`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lead_time_cs->Sortable = TRUE; // Allow sort
		$this->lead_time_cs->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['lead_time_cs'] = &$this->lead_time_cs;

		// cha
		$this->cha = new DbField('production_partner', 'production_partner', 'x_cha', 'cha', '`cha`', '`cha`', 200, -1, FALSE, '`cha`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->cha->Sortable = TRUE; // Allow sort
		$this->cha->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cha'] = &$this->cha;

		// cha_email
		$this->cha_email = new DbField('production_partner', 'production_partner', 'x_cha_email', 'cha_email', '`cha_email`', '`cha_email`', 200, -1, FALSE, '`cha_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->cha_email->Sortable = TRUE; // Allow sort
		$this->fields['cha_email'] = &$this->cha_email;

		// cha_phone
		$this->cha_phone = new DbField('production_partner', 'production_partner', 'x_cha_phone', 'cha_phone', '`cha_phone`', '`cha_phone`', 200, -1, FALSE, '`cha_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->cha_phone->Sortable = TRUE; // Allow sort
		$this->fields['cha_phone'] = &$this->cha_phone;

		// forwarder
		$this->forwarder = new DbField('production_partner', 'production_partner', 'x_forwarder', 'forwarder', '`forwarder`', '`forwarder`', 200, -1, FALSE, '`forwarder`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->forwarder->Sortable = TRUE; // Allow sort
		$this->forwarder->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['forwarder'] = &$this->forwarder;

		// forwarder_email
		$this->forwarder_email = new DbField('production_partner', 'production_partner', 'x_forwarder_email', 'forwarder_email', '`forwarder_email`', '`forwarder_email`', 200, -1, FALSE, '`forwarder_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->forwarder_email->Sortable = TRUE; // Allow sort
		$this->fields['forwarder_email'] = &$this->forwarder_email;

		// forwarder_phone
		$this->forwarder_phone = new DbField('production_partner', 'production_partner', 'x_forwarder_phone', 'forwarder_phone', '`forwarder_phone`', '`forwarder_phone`', 200, -1, FALSE, '`forwarder_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->forwarder_phone->Sortable = TRUE; // Allow sort
		$this->fields['forwarder_phone'] = &$this->forwarder_phone;

		// merchant
		$this->merchant = new DbField('production_partner', 'production_partner', 'x_merchant', 'merchant', '`merchant`', '`merchant`', 200, -1, FALSE, '`merchant`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->merchant->Sortable = TRUE; // Allow sort
		$this->fields['merchant'] = &$this->merchant;

		// merchant_email
		$this->merchant_email = new DbField('production_partner', 'production_partner', 'x_merchant_email', 'merchant_email', '`merchant_email`', '`merchant_email`', 200, -1, FALSE, '`merchant_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->merchant_email->Sortable = TRUE; // Allow sort
		$this->fields['merchant_email'] = &$this->merchant_email;

		// merchant_phone
		$this->merchant_phone = new DbField('production_partner', 'production_partner', 'x_merchant_phone', 'merchant_phone', '`merchant_phone`', '`merchant_phone`', 200, -1, FALSE, '`merchant_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->merchant_phone->Sortable = TRUE; // Allow sort
		$this->fields['merchant_phone'] = &$this->merchant_phone;

		// shipping_incharge
		$this->shipping_incharge = new DbField('production_partner', 'production_partner', 'x_shipping_incharge', 'shipping_incharge', '`shipping_incharge`', '`shipping_incharge`', 200, -1, FALSE, '`shipping_incharge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->shipping_incharge->Sortable = TRUE; // Allow sort
		$this->fields['shipping_incharge'] = &$this->shipping_incharge;

		// shipping_email
		$this->shipping_email = new DbField('production_partner', 'production_partner', 'x_shipping_email', 'shipping_email', '`shipping_email`', '`shipping_email`', 200, -1, FALSE, '`shipping_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->shipping_email->Sortable = TRUE; // Allow sort
		$this->fields['shipping_email'] = &$this->shipping_email;

		// shipping_phone
		$this->shipping_phone = new DbField('production_partner', 'production_partner', 'x_shipping_phone', 'shipping_phone', '`shipping_phone`', '`shipping_phone`', 200, -1, FALSE, '`shipping_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->shipping_phone->Sortable = TRUE; // Allow sort
		$this->fields['shipping_phone'] = &$this->shipping_phone;

		// account_incharge
		$this->account_incharge = new DbField('production_partner', 'production_partner', 'x_account_incharge', 'account_incharge', '`account_incharge`', '`account_incharge`', 200, -1, FALSE, '`account_incharge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->account_incharge->Sortable = TRUE; // Allow sort
		$this->fields['account_incharge'] = &$this->account_incharge;

		// accounts_email
		$this->accounts_email = new DbField('production_partner', 'production_partner', 'x_accounts_email', 'accounts_email', '`accounts_email`', '`accounts_email`', 200, -1, FALSE, '`accounts_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->accounts_email->Sortable = TRUE; // Allow sort
		$this->fields['accounts_email'] = &$this->accounts_email;

		// accounts_phone
		$this->accounts_phone = new DbField('production_partner', 'production_partner', 'x_accounts_phone', 'accounts_phone', '`accounts_phone`', '`accounts_phone`', 200, -1, FALSE, '`accounts_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->accounts_phone->Sortable = TRUE; // Allow sort
		$this->fields['accounts_phone'] = &$this->accounts_phone;

		// warehouse_incharge
		$this->warehouse_incharge = new DbField('production_partner', 'production_partner', 'x_warehouse_incharge', 'warehouse_incharge', '`warehouse_incharge`', '`warehouse_incharge`', 200, -1, FALSE, '`warehouse_incharge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->warehouse_incharge->Sortable = TRUE; // Allow sort
		$this->fields['warehouse_incharge'] = &$this->warehouse_incharge;

		// warehouse_email
		$this->warehouse_email = new DbField('production_partner', 'production_partner', 'x_warehouse_email', 'warehouse_email', '`warehouse_email`', '`warehouse_email`', 200, -1, FALSE, '`warehouse_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->warehouse_email->Sortable = TRUE; // Allow sort
		$this->fields['warehouse_email'] = &$this->warehouse_email;

		// warehouse_phone
		$this->warehouse_phone = new DbField('production_partner', 'production_partner', 'x_warehouse_phone', 'warehouse_phone', '`warehouse_phone`', '`warehouse_phone`', 200, -1, FALSE, '`warehouse_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->warehouse_phone->Sortable = TRUE; // Allow sort
		$this->fields['warehouse_phone'] = &$this->warehouse_phone;

		// production_incharge
		$this->production_incharge = new DbField('production_partner', 'production_partner', 'x_production_incharge', 'production_incharge', '`production_incharge`', '`production_incharge`', 200, -1, FALSE, '`production_incharge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->production_incharge->Sortable = TRUE; // Allow sort
		$this->fields['production_incharge'] = &$this->production_incharge;

		// production_email
		$this->production_email = new DbField('production_partner', 'production_partner', 'x_production_email', 'production_email', '`production_email`', '`production_email`', 200, -1, FALSE, '`production_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->production_email->Sortable = TRUE; // Allow sort
		$this->fields['production_email'] = &$this->production_email;

		// production_phone
		$this->production_phone = new DbField('production_partner', 'production_partner', 'x_production_phone', 'production_phone', '`production_phone`', '`production_phone`', 200, -1, FALSE, '`production_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->production_phone->Sortable = TRUE; // Allow sort
		$this->fields['production_phone'] = &$this->production_phone;

		// qc_incharge
		$this->qc_incharge = new DbField('production_partner', 'production_partner', 'x_qc_incharge', 'qc_incharge', '`qc_incharge`', '`qc_incharge`', 200, -1, FALSE, '`qc_incharge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->qc_incharge->Sortable = TRUE; // Allow sort
		$this->fields['qc_incharge'] = &$this->qc_incharge;

		// qc_email
		$this->qc_email = new DbField('production_partner', 'production_partner', 'x_qc_email', 'qc_email', '`qc_email`', '`qc_email`', 200, -1, FALSE, '`qc_email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->qc_email->Sortable = TRUE; // Allow sort
		$this->fields['qc_email'] = &$this->qc_email;

		// qc_phone
		$this->qc_phone = new DbField('production_partner', 'production_partner', 'x_qc_phone', 'qc_phone', '`qc_phone`', '`qc_phone`', 200, -1, FALSE, '`qc_phone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->qc_phone->Sortable = TRUE; // Allow sort
		$this->fields['qc_phone'] = &$this->qc_phone;

		// uid
		$this->uid = new DbField('production_partner', 'production_partner', 'x_uid', 'uid', '`uid`', '`uid`', 200, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->uid->Sortable = FALSE; // Allow sort
		$this->uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['uid'] = &$this->uid;

		// r_text
		$this->r_text = new DbField('production_partner', 'production_partner', 'x_r_text', 'r_text', '`r_text`', '`r_text`', 201, -1, FALSE, '`r_text`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->r_text->Sortable = FALSE; // Allow sort
		$this->fields['r_text'] = &$this->r_text;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "shipping_address") {
			$detailUrl = $GLOBALS["shipping_address"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "_bank_info") {
			$detailUrl = $GLOBALS["_bank_info"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "capacity_plan") {
			$detailUrl = $GLOBALS["capacity_plan"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "production_partnerlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`production_partner`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `world_city` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `production_partner`.`city` LIMIT 1) AS `EV__city` FROM `production_partner`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = User_Company_ID() == 0 ? "" : "`id` = " . User_Company_ID();
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`name` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->city->AdvancedSearch->SearchValue <> "" ||
			$this->city->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->city->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->city->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->name->DbValue = $row['name'];
		$this->code->DbValue = $row['code'];
		$this->country->DbValue = $row['country'];
		$this->region->DbValue = $row['region'];
		$this->city->DbValue = $row['city'];
		$this->address->DbValue = $row['address'];
		$this->mobile->DbValue = $row['mobile'];
		$this->_email->DbValue = $row['email'];
		$this->url->DbValue = $row['url'];
		$this->grp->DbValue = $row['grp'];
		$this->category->DbValue = $row['category'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->status->DbValue = $row['status'];
		$this->performance->DbValue = $row['performance'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->type->DbValue = $row['type'];
		$this->tax_registration->DbValue = $row['tax_registration'];
		$this->cin->DbValue = $row['cin'];
		$this->pan->DbValue = $row['pan'];
		$this->tan->DbValue = $row['tan'];
		$this->msme->DbValue = $row['msme'];
		$this->incoterm->DbValue = $row['incoterm'];
		$this->port_air->DbValue = $row['port_air'];
		$this->port_sea->DbValue = $row['port_sea'];
		$this->iec->DbValue = $row['iec'];
		$this->rex->DbValue = $row['rex'];
		$this->rcmc->DbValue = $row['rcmc'];
		$this->delivery_terms->DbValue = $row['delivery_terms'];
		$this->shipping_terms->DbValue = $row['shipping_terms'];
		$this->payment_terms->DbValue = $row['payment_terms'];
		$this->export_type->DbValue = $row['export_type'];
		$this->lead_time_ss->DbValue = $row['lead_time_ss'];
		$this->lead_time_cs->DbValue = $row['lead_time_cs'];
		$this->cha->DbValue = $row['cha'];
		$this->cha_email->DbValue = $row['cha_email'];
		$this->cha_phone->DbValue = $row['cha_phone'];
		$this->forwarder->DbValue = $row['forwarder'];
		$this->forwarder_email->DbValue = $row['forwarder_email'];
		$this->forwarder_phone->DbValue = $row['forwarder_phone'];
		$this->merchant->DbValue = $row['merchant'];
		$this->merchant_email->DbValue = $row['merchant_email'];
		$this->merchant_phone->DbValue = $row['merchant_phone'];
		$this->shipping_incharge->DbValue = $row['shipping_incharge'];
		$this->shipping_email->DbValue = $row['shipping_email'];
		$this->shipping_phone->DbValue = $row['shipping_phone'];
		$this->account_incharge->DbValue = $row['account_incharge'];
		$this->accounts_email->DbValue = $row['accounts_email'];
		$this->accounts_phone->DbValue = $row['accounts_phone'];
		$this->warehouse_incharge->DbValue = $row['warehouse_incharge'];
		$this->warehouse_email->DbValue = $row['warehouse_email'];
		$this->warehouse_phone->DbValue = $row['warehouse_phone'];
		$this->production_incharge->DbValue = $row['production_incharge'];
		$this->production_email->DbValue = $row['production_email'];
		$this->production_phone->DbValue = $row['production_phone'];
		$this->qc_incharge->DbValue = $row['qc_incharge'];
		$this->qc_email->DbValue = $row['qc_email'];
		$this->qc_phone->DbValue = $row['qc_phone'];
		$this->uid->DbValue = $row['uid'];
		$this->r_text->DbValue = $row['r_text'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "production_partnerlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "production_partnerview.php")
			return $Language->phrase("View");
		elseif ($pageName == "production_partneredit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "production_partneradd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "production_partnerlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("production_partnerview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("production_partnerview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "production_partneradd.php?" . $this->getUrlParm($parm);
		else
			$url = "production_partneradd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("production_partneredit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("production_partneredit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("production_partneradd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("production_partneradd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("production_partnerdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->name->setDbValue($rs->fields('name'));
		$this->code->setDbValue($rs->fields('code'));
		$this->country->setDbValue($rs->fields('country'));
		$this->region->setDbValue($rs->fields('region'));
		$this->city->setDbValue($rs->fields('city'));
		$this->address->setDbValue($rs->fields('address'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->_email->setDbValue($rs->fields('email'));
		$this->url->setDbValue($rs->fields('url'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->category->setDbValue($rs->fields('category'));
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->status->setDbValue($rs->fields('status'));
		$this->performance->setDbValue($rs->fields('performance'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->type->setDbValue($rs->fields('type'));
		$this->tax_registration->setDbValue($rs->fields('tax_registration'));
		$this->cin->setDbValue($rs->fields('cin'));
		$this->pan->setDbValue($rs->fields('pan'));
		$this->tan->setDbValue($rs->fields('tan'));
		$this->msme->setDbValue($rs->fields('msme'));
		$this->incoterm->setDbValue($rs->fields('incoterm'));
		$this->port_air->setDbValue($rs->fields('port_air'));
		$this->port_sea->setDbValue($rs->fields('port_sea'));
		$this->iec->setDbValue($rs->fields('iec'));
		$this->rex->setDbValue($rs->fields('rex'));
		$this->rcmc->setDbValue($rs->fields('rcmc'));
		$this->delivery_terms->setDbValue($rs->fields('delivery_terms'));
		$this->shipping_terms->setDbValue($rs->fields('shipping_terms'));
		$this->payment_terms->setDbValue($rs->fields('payment_terms'));
		$this->export_type->setDbValue($rs->fields('export_type'));
		$this->lead_time_ss->setDbValue($rs->fields('lead_time_ss'));
		$this->lead_time_cs->setDbValue($rs->fields('lead_time_cs'));
		$this->cha->setDbValue($rs->fields('cha'));
		$this->cha_email->setDbValue($rs->fields('cha_email'));
		$this->cha_phone->setDbValue($rs->fields('cha_phone'));
		$this->forwarder->setDbValue($rs->fields('forwarder'));
		$this->forwarder_email->setDbValue($rs->fields('forwarder_email'));
		$this->forwarder_phone->setDbValue($rs->fields('forwarder_phone'));
		$this->merchant->setDbValue($rs->fields('merchant'));
		$this->merchant_email->setDbValue($rs->fields('merchant_email'));
		$this->merchant_phone->setDbValue($rs->fields('merchant_phone'));
		$this->shipping_incharge->setDbValue($rs->fields('shipping_incharge'));
		$this->shipping_email->setDbValue($rs->fields('shipping_email'));
		$this->shipping_phone->setDbValue($rs->fields('shipping_phone'));
		$this->account_incharge->setDbValue($rs->fields('account_incharge'));
		$this->accounts_email->setDbValue($rs->fields('accounts_email'));
		$this->accounts_phone->setDbValue($rs->fields('accounts_phone'));
		$this->warehouse_incharge->setDbValue($rs->fields('warehouse_incharge'));
		$this->warehouse_email->setDbValue($rs->fields('warehouse_email'));
		$this->warehouse_phone->setDbValue($rs->fields('warehouse_phone'));
		$this->production_incharge->setDbValue($rs->fields('production_incharge'));
		$this->production_email->setDbValue($rs->fields('production_email'));
		$this->production_phone->setDbValue($rs->fields('production_phone'));
		$this->qc_incharge->setDbValue($rs->fields('qc_incharge'));
		$this->qc_email->setDbValue($rs->fields('qc_email'));
		$this->qc_phone->setDbValue($rs->fields('qc_phone'));
		$this->uid->setDbValue($rs->fields('uid'));
		$this->r_text->setDbValue($rs->fields('r_text'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// name
		// code
		// country
		// region
		// city
		// address
		// mobile
		// email
		// url
		// grp
		// category
		// reports_to
		// status
		// performance
		// operator
		// datetime
		// type
		// tax_registration
		// cin
		// pan
		// tan
		// msme
		// incoterm

		$this->incoterm->CellCssStyle = "white-space: nowrap;";

		// port_air
		// port_sea
		// iec
		// rex
		// rcmc
		// delivery_terms
		// shipping_terms
		// payment_terms
		// export_type
		// lead_time_ss
		// lead_time_cs
		// cha
		// cha_email
		// cha_phone
		// forwarder
		// forwarder_email
		// forwarder_phone
		// merchant
		// merchant_email
		// merchant_phone
		// shipping_incharge
		// shipping_email
		// shipping_phone
		// account_incharge
		// accounts_email
		// accounts_phone
		// warehouse_incharge
		// warehouse_email
		// warehouse_phone
		// production_incharge
		// production_email
		// production_phone
		// qc_incharge
		// qc_email
		// qc_phone
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// r_text
		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$this->name->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// country
		$curVal = strval($this->country->CurrentValue);
		if ($curVal <> "") {
			$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
			if ($this->country->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->country->ViewValue = $this->country->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->country->ViewValue = $this->country->CurrentValue;
				}
			}
		} else {
			$this->country->ViewValue = NULL;
		}
		$this->country->ViewCustomAttributes = "";

		// region
		$curVal = strval($this->region->CurrentValue);
		if ($curVal <> "") {
			$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
			if ($this->region->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->region->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->region->ViewValue = $this->region->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->region->ViewValue = $this->region->CurrentValue;
				}
			}
		} else {
			$this->region->ViewValue = NULL;
		}
		$this->region->ViewCustomAttributes = "";

		// city
		if ($this->city->VirtualValue <> "") {
			$this->city->ViewValue = $this->city->VirtualValue;
		} else {
			$this->city->ViewValue = $this->city->CurrentValue;
		$curVal = strval($this->city->CurrentValue);
		if ($curVal <> "") {
			$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
			if ($this->city->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->city->ViewValue = $this->city->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->city->ViewValue = $this->city->CurrentValue;
				}
			}
		} else {
			$this->city->ViewValue = NULL;
		}
		}
		$this->city->ViewCustomAttributes = "";

		// address
		$this->address->ViewValue = $this->address->CurrentValue;
		$this->address->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$this->mobile->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// category
		$curVal = strval($this->category->CurrentValue);
		if ($curVal <> "") {
			$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			if ($this->category->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->category->ViewValue = $this->category->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->category->ViewValue = $this->category->CurrentValue;
				}
			}
		} else {
			$this->category->ViewValue = NULL;
		}
		$this->category->ViewCustomAttributes = "";

		// reports_to
		$curVal = strval($this->reports_to->CurrentValue);
		if ($curVal <> "") {
			$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			if ($this->reports_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
				}
			}
		} else {
			$this->reports_to->ViewValue = NULL;
		}
		$this->reports_to->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// performance
		$this->performance->ViewValue = $this->performance->CurrentValue;
		$this->performance->ViewValue = FormatNumber($this->performance->ViewValue, 0, -2, -2, -2);
		$this->performance->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// type
		if (strval($this->type->CurrentValue) <> "") {
			$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
		} else {
			$this->type->ViewValue = NULL;
		}
		$this->type->ViewCustomAttributes = "";

		// tax_registration
		$this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;
		$this->tax_registration->ViewCustomAttributes = "";

		// cin
		$this->cin->ViewValue = $this->cin->CurrentValue;
		$this->cin->ViewCustomAttributes = "";

		// pan
		$this->pan->ViewValue = $this->pan->CurrentValue;
		$this->pan->ViewCustomAttributes = "";

		// tan
		$this->tan->ViewValue = $this->tan->CurrentValue;
		$this->tan->ViewCustomAttributes = "";

		// msme
		$this->msme->ViewValue = $this->msme->CurrentValue;
		$this->msme->ViewCustomAttributes = "";

		// incoterm
		$curVal = strval($this->incoterm->CurrentValue);
		if ($curVal <> "") {
			$this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
			if ($this->incoterm->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->incoterm->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->incoterm->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->incoterm->ViewValue->add($this->incoterm->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->incoterm->ViewValue = $this->incoterm->CurrentValue;
				}
			}
		} else {
			$this->incoterm->ViewValue = NULL;
		}
		$this->incoterm->ViewCustomAttributes = "";

		// port_air
		$curVal = strval($this->port_air->CurrentValue);
		if ($curVal <> "") {
			$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
			if ($this->port_air->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`mode`=1 and status =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_air->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->port_air->ViewValue = $this->port_air->CurrentValue;
				}
			}
		} else {
			$this->port_air->ViewValue = NULL;
		}
		$this->port_air->ViewCustomAttributes = "";

		// port_sea
		$curVal = strval($this->port_sea->CurrentValue);
		if ($curVal <> "") {
			$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
			if ($this->port_sea->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`mode`=0 and status =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_sea->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->port_sea->ViewValue = $this->port_sea->CurrentValue;
				}
			}
		} else {
			$this->port_sea->ViewValue = NULL;
		}
		$this->port_sea->ViewCustomAttributes = "";

		// iec
		$this->iec->ViewValue = $this->iec->CurrentValue;
		$this->iec->ViewCustomAttributes = "";

		// rex
		$this->rex->ViewValue = $this->rex->CurrentValue;
		$this->rex->ViewCustomAttributes = "";

		// rcmc
		$this->rcmc->ViewValue = $this->rcmc->CurrentValue;
		$this->rcmc->ViewCustomAttributes = "";

		// delivery_terms
		$this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
		$this->delivery_terms->ViewCustomAttributes = "";

		// shipping_terms
		$this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;
		$this->shipping_terms->ViewCustomAttributes = "";

		// payment_terms
		$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
		$this->payment_terms->ViewCustomAttributes = "";

		// export_type
		$this->export_type->ViewValue = $this->export_type->CurrentValue;
		$this->export_type->ViewCustomAttributes = "";

		// lead_time_ss
		$this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;
		$this->lead_time_ss->ViewCustomAttributes = "";

		// lead_time_cs
		$this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;
		$this->lead_time_cs->ViewCustomAttributes = "";

		// cha
		$this->cha->ViewValue = $this->cha->CurrentValue;
		$this->cha->ViewCustomAttributes = "";

		// cha_email
		$this->cha_email->ViewValue = $this->cha_email->CurrentValue;
		$this->cha_email->ViewCustomAttributes = "";

		// cha_phone
		$this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;
		$this->cha_phone->ViewCustomAttributes = "";

		// forwarder
		$this->forwarder->ViewValue = $this->forwarder->CurrentValue;
		$this->forwarder->ViewCustomAttributes = "";

		// forwarder_email
		$this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;
		$this->forwarder_email->ViewCustomAttributes = "";

		// forwarder_phone
		$this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;
		$this->forwarder_phone->ViewCustomAttributes = "";

		// merchant
		$this->merchant->ViewValue = $this->merchant->CurrentValue;
		$this->merchant->ViewCustomAttributes = "";

		// merchant_email
		$this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;
		$this->merchant_email->ViewCustomAttributes = "";

		// merchant_phone
		$this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;
		$this->merchant_phone->ViewCustomAttributes = "";

		// shipping_incharge
		$this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;
		$this->shipping_incharge->ViewCustomAttributes = "";

		// shipping_email
		$this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;
		$this->shipping_email->ViewCustomAttributes = "";

		// shipping_phone
		$this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;
		$this->shipping_phone->ViewCustomAttributes = "";

		// account_incharge
		$this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;
		$this->account_incharge->ViewCustomAttributes = "";

		// accounts_email
		$this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;
		$this->accounts_email->ViewCustomAttributes = "";

		// accounts_phone
		$this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;
		$this->accounts_phone->ViewCustomAttributes = "";

		// warehouse_incharge
		$this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;
		$this->warehouse_incharge->ViewCustomAttributes = "";

		// warehouse_email
		$this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;
		$this->warehouse_email->ViewCustomAttributes = "";

		// warehouse_phone
		$this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;
		$this->warehouse_phone->ViewCustomAttributes = "";

		// production_incharge
		$this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;
		$this->production_incharge->ViewCustomAttributes = "";

		// production_email
		$this->production_email->ViewValue = $this->production_email->CurrentValue;
		$this->production_email->ViewCustomAttributes = "";

		// production_phone
		$this->production_phone->ViewValue = $this->production_phone->CurrentValue;
		$this->production_phone->ViewCustomAttributes = "";

		// qc_incharge
		$this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;
		$this->qc_incharge->ViewCustomAttributes = "";

		// qc_email
		$this->qc_email->ViewValue = $this->qc_email->CurrentValue;
		$this->qc_email->ViewCustomAttributes = "";

		// qc_phone
		$this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;
		$this->qc_phone->ViewCustomAttributes = "";

		// uid
		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// r_text
		$this->r_text->ViewValue = $this->r_text->CurrentValue;
		$this->r_text->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		$this->name->HrefValue = "";
		$this->name->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		$this->code->HrefValue = "";
		$this->code->TooltipValue = "";

		// country
		$this->country->LinkCustomAttributes = "";
		$this->country->HrefValue = "";
		$this->country->TooltipValue = "";

		// region
		$this->region->LinkCustomAttributes = "";
		$this->region->HrefValue = "";
		$this->region->TooltipValue = "";

		// city
		$this->city->LinkCustomAttributes = "";
		$this->city->HrefValue = "";
		$this->city->TooltipValue = "";

		// address
		$this->address->LinkCustomAttributes = "";
		$this->address->HrefValue = "";
		$this->address->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// performance
		$this->performance->LinkCustomAttributes = "";
		$this->performance->HrefValue = "";
		$this->performance->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// tax_registration
		$this->tax_registration->LinkCustomAttributes = "";
		$this->tax_registration->HrefValue = "";
		$this->tax_registration->TooltipValue = "";

		// cin
		$this->cin->LinkCustomAttributes = "";
		$this->cin->HrefValue = "";
		$this->cin->TooltipValue = "";

		// pan
		$this->pan->LinkCustomAttributes = "";
		$this->pan->HrefValue = "";
		$this->pan->TooltipValue = "";

		// tan
		$this->tan->LinkCustomAttributes = "";
		$this->tan->HrefValue = "";
		$this->tan->TooltipValue = "";

		// msme
		$this->msme->LinkCustomAttributes = "";
		$this->msme->HrefValue = "";
		$this->msme->TooltipValue = "";

		// incoterm
		$this->incoterm->LinkCustomAttributes = "";
		$this->incoterm->HrefValue = "";
		$this->incoterm->TooltipValue = "";

		// port_air
		$this->port_air->LinkCustomAttributes = "";
		$this->port_air->HrefValue = "";
		$this->port_air->TooltipValue = "";

		// port_sea
		$this->port_sea->LinkCustomAttributes = "";
		$this->port_sea->HrefValue = "";
		$this->port_sea->TooltipValue = "";

		// iec
		$this->iec->LinkCustomAttributes = "";
		$this->iec->HrefValue = "";
		$this->iec->TooltipValue = "";

		// rex
		$this->rex->LinkCustomAttributes = "";
		$this->rex->HrefValue = "";
		$this->rex->TooltipValue = "";

		// rcmc
		$this->rcmc->LinkCustomAttributes = "";
		$this->rcmc->HrefValue = "";
		$this->rcmc->TooltipValue = "";

		// delivery_terms
		$this->delivery_terms->LinkCustomAttributes = "";
		$this->delivery_terms->HrefValue = "";
		$this->delivery_terms->TooltipValue = "";

		// shipping_terms
		$this->shipping_terms->LinkCustomAttributes = "";
		$this->shipping_terms->HrefValue = "";
		$this->shipping_terms->TooltipValue = "";

		// payment_terms
		$this->payment_terms->LinkCustomAttributes = "";
		$this->payment_terms->HrefValue = "";
		$this->payment_terms->TooltipValue = "";

		// export_type
		$this->export_type->LinkCustomAttributes = "";
		$this->export_type->HrefValue = "";
		$this->export_type->TooltipValue = "";

		// lead_time_ss
		$this->lead_time_ss->LinkCustomAttributes = "";
		$this->lead_time_ss->HrefValue = "";
		$this->lead_time_ss->TooltipValue = "";

		// lead_time_cs
		$this->lead_time_cs->LinkCustomAttributes = "";
		$this->lead_time_cs->HrefValue = "";
		$this->lead_time_cs->TooltipValue = "";

		// cha
		$this->cha->LinkCustomAttributes = "";
		$this->cha->HrefValue = "";
		$this->cha->TooltipValue = "";

		// cha_email
		$this->cha_email->LinkCustomAttributes = "";
		$this->cha_email->HrefValue = "";
		$this->cha_email->TooltipValue = "";

		// cha_phone
		$this->cha_phone->LinkCustomAttributes = "";
		$this->cha_phone->HrefValue = "";
		$this->cha_phone->TooltipValue = "";

		// forwarder
		$this->forwarder->LinkCustomAttributes = "";
		$this->forwarder->HrefValue = "";
		$this->forwarder->TooltipValue = "";

		// forwarder_email
		$this->forwarder_email->LinkCustomAttributes = "";
		$this->forwarder_email->HrefValue = "";
		$this->forwarder_email->TooltipValue = "";

		// forwarder_phone
		$this->forwarder_phone->LinkCustomAttributes = "";
		$this->forwarder_phone->HrefValue = "";
		$this->forwarder_phone->TooltipValue = "";

		// merchant
		$this->merchant->LinkCustomAttributes = "";
		$this->merchant->HrefValue = "";
		$this->merchant->TooltipValue = "";

		// merchant_email
		$this->merchant_email->LinkCustomAttributes = "";
		$this->merchant_email->HrefValue = "";
		$this->merchant_email->TooltipValue = "";

		// merchant_phone
		$this->merchant_phone->LinkCustomAttributes = "";
		$this->merchant_phone->HrefValue = "";
		$this->merchant_phone->TooltipValue = "";

		// shipping_incharge
		$this->shipping_incharge->LinkCustomAttributes = "";
		$this->shipping_incharge->HrefValue = "";
		$this->shipping_incharge->TooltipValue = "";

		// shipping_email
		$this->shipping_email->LinkCustomAttributes = "";
		$this->shipping_email->HrefValue = "";
		$this->shipping_email->TooltipValue = "";

		// shipping_phone
		$this->shipping_phone->LinkCustomAttributes = "";
		$this->shipping_phone->HrefValue = "";
		$this->shipping_phone->TooltipValue = "";

		// account_incharge
		$this->account_incharge->LinkCustomAttributes = "";
		$this->account_incharge->HrefValue = "";
		$this->account_incharge->TooltipValue = "";

		// accounts_email
		$this->accounts_email->LinkCustomAttributes = "";
		$this->accounts_email->HrefValue = "";
		$this->accounts_email->TooltipValue = "";

		// accounts_phone
		$this->accounts_phone->LinkCustomAttributes = "";
		$this->accounts_phone->HrefValue = "";
		$this->accounts_phone->TooltipValue = "";

		// warehouse_incharge
		$this->warehouse_incharge->LinkCustomAttributes = "";
		$this->warehouse_incharge->HrefValue = "";
		$this->warehouse_incharge->TooltipValue = "";

		// warehouse_email
		$this->warehouse_email->LinkCustomAttributes = "";
		$this->warehouse_email->HrefValue = "";
		$this->warehouse_email->TooltipValue = "";

		// warehouse_phone
		$this->warehouse_phone->LinkCustomAttributes = "";
		$this->warehouse_phone->HrefValue = "";
		$this->warehouse_phone->TooltipValue = "";

		// production_incharge
		$this->production_incharge->LinkCustomAttributes = "";
		$this->production_incharge->HrefValue = "";
		$this->production_incharge->TooltipValue = "";

		// production_email
		$this->production_email->LinkCustomAttributes = "";
		$this->production_email->HrefValue = "";
		$this->production_email->TooltipValue = "";

		// production_phone
		$this->production_phone->LinkCustomAttributes = "";
		$this->production_phone->HrefValue = "";
		$this->production_phone->TooltipValue = "";

		// qc_incharge
		$this->qc_incharge->LinkCustomAttributes = "";
		$this->qc_incharge->HrefValue = "";
		$this->qc_incharge->TooltipValue = "";

		// qc_email
		$this->qc_email->LinkCustomAttributes = "";
		$this->qc_email->HrefValue = "";
		$this->qc_email->TooltipValue = "";

		// qc_phone
		$this->qc_phone->LinkCustomAttributes = "";
		$this->qc_phone->HrefValue = "";
		$this->qc_phone->TooltipValue = "";

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// r_text
		$this->r_text->LinkCustomAttributes = "";
		$this->r_text->HrefValue = "";
		$this->r_text->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->PlaceHolder = RemoveHtml($this->code->caption());

		// country
		$this->country->EditAttrs["class"] = "form-control";
		$this->country->EditCustomAttributes = "";

		// region
		$this->region->EditAttrs["class"] = "form-control";
		$this->region->EditCustomAttributes = "";

		// city
		$this->city->EditAttrs["class"] = "form-control";
		$this->city->EditCustomAttributes = "";
		$this->city->EditValue = $this->city->CurrentValue;
		$this->city->PlaceHolder = RemoveHtml($this->city->caption());

		// address
		$this->address->EditAttrs["class"] = "form-control";
		$this->address->EditCustomAttributes = "";
		$this->address->EditValue = $this->address->CurrentValue;
		$this->address->PlaceHolder = RemoveHtml($this->address->caption());

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// grp
		$this->grp->EditCustomAttributes = "";

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// performance
		$this->performance->EditAttrs["class"] = "form-control";
		$this->performance->EditCustomAttributes = "";
		$this->performance->EditValue = $this->performance->CurrentValue;
		$this->performance->PlaceHolder = RemoveHtml($this->performance->caption());

		// operator
		// datetime
		// type

		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		$this->type->EditValue = $this->type->options(TRUE);

		// tax_registration
		$this->tax_registration->EditAttrs["class"] = "form-control";
		$this->tax_registration->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->tax_registration->CurrentValue = HtmlDecode($this->tax_registration->CurrentValue);
		$this->tax_registration->EditValue = $this->tax_registration->CurrentValue;
		$this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

		// cin
		$this->cin->EditAttrs["class"] = "form-control";
		$this->cin->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->cin->CurrentValue = HtmlDecode($this->cin->CurrentValue);
		$this->cin->EditValue = $this->cin->CurrentValue;
		$this->cin->PlaceHolder = RemoveHtml($this->cin->caption());

		// pan
		$this->pan->EditAttrs["class"] = "form-control";
		$this->pan->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pan->CurrentValue = HtmlDecode($this->pan->CurrentValue);
		$this->pan->EditValue = $this->pan->CurrentValue;
		$this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

		// tan
		$this->tan->EditAttrs["class"] = "form-control";
		$this->tan->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->tan->CurrentValue = HtmlDecode($this->tan->CurrentValue);
		$this->tan->EditValue = $this->tan->CurrentValue;
		$this->tan->PlaceHolder = RemoveHtml($this->tan->caption());

		// msme
		$this->msme->EditAttrs["class"] = "form-control";
		$this->msme->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->msme->CurrentValue = HtmlDecode($this->msme->CurrentValue);
		$this->msme->EditValue = $this->msme->CurrentValue;
		$this->msme->PlaceHolder = RemoveHtml($this->msme->caption());

		// incoterm
		$this->incoterm->EditAttrs["class"] = "form-control";
		$this->incoterm->EditCustomAttributes = "";

		// port_air
		$this->port_air->EditAttrs["class"] = "form-control";
		$this->port_air->EditCustomAttributes = "";

		// port_sea
		$this->port_sea->EditAttrs["class"] = "form-control";
		$this->port_sea->EditCustomAttributes = "";

		// iec
		$this->iec->EditAttrs["class"] = "form-control";
		$this->iec->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->iec->CurrentValue = HtmlDecode($this->iec->CurrentValue);
		$this->iec->EditValue = $this->iec->CurrentValue;
		$this->iec->PlaceHolder = RemoveHtml($this->iec->caption());

		// rex
		$this->rex->EditAttrs["class"] = "form-control";
		$this->rex->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rex->CurrentValue = HtmlDecode($this->rex->CurrentValue);
		$this->rex->EditValue = $this->rex->CurrentValue;
		$this->rex->PlaceHolder = RemoveHtml($this->rex->caption());

		// rcmc
		$this->rcmc->EditAttrs["class"] = "form-control";
		$this->rcmc->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rcmc->CurrentValue = HtmlDecode($this->rcmc->CurrentValue);
		$this->rcmc->EditValue = $this->rcmc->CurrentValue;
		$this->rcmc->PlaceHolder = RemoveHtml($this->rcmc->caption());

		// delivery_terms
		$this->delivery_terms->EditAttrs["class"] = "form-control";
		$this->delivery_terms->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->delivery_terms->CurrentValue = HtmlDecode($this->delivery_terms->CurrentValue);
		$this->delivery_terms->EditValue = $this->delivery_terms->CurrentValue;
		$this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

		// shipping_terms
		$this->shipping_terms->EditAttrs["class"] = "form-control";
		$this->shipping_terms->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->shipping_terms->CurrentValue = HtmlDecode($this->shipping_terms->CurrentValue);
		$this->shipping_terms->EditValue = $this->shipping_terms->CurrentValue;
		$this->shipping_terms->PlaceHolder = RemoveHtml($this->shipping_terms->caption());

		// payment_terms
		$this->payment_terms->EditAttrs["class"] = "form-control";
		$this->payment_terms->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment_terms->CurrentValue = HtmlDecode($this->payment_terms->CurrentValue);
		$this->payment_terms->EditValue = $this->payment_terms->CurrentValue;
		$this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

		// export_type
		$this->export_type->EditAttrs["class"] = "form-control";
		$this->export_type->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->export_type->CurrentValue = HtmlDecode($this->export_type->CurrentValue);
		$this->export_type->EditValue = $this->export_type->CurrentValue;
		$this->export_type->PlaceHolder = RemoveHtml($this->export_type->caption());

		// lead_time_ss
		$this->lead_time_ss->EditAttrs["class"] = "form-control";
		$this->lead_time_ss->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lead_time_ss->CurrentValue = HtmlDecode($this->lead_time_ss->CurrentValue);
		$this->lead_time_ss->EditValue = $this->lead_time_ss->CurrentValue;
		$this->lead_time_ss->PlaceHolder = RemoveHtml($this->lead_time_ss->caption());

		// lead_time_cs
		$this->lead_time_cs->EditAttrs["class"] = "form-control";
		$this->lead_time_cs->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lead_time_cs->CurrentValue = HtmlDecode($this->lead_time_cs->CurrentValue);
		$this->lead_time_cs->EditValue = $this->lead_time_cs->CurrentValue;
		$this->lead_time_cs->PlaceHolder = RemoveHtml($this->lead_time_cs->caption());

		// cha
		$this->cha->EditAttrs["class"] = "form-control";
		$this->cha->EditCustomAttributes = "";
		$this->cha->EditValue = $this->cha->CurrentValue;
		$this->cha->PlaceHolder = RemoveHtml($this->cha->caption());

		// cha_email
		$this->cha_email->EditAttrs["class"] = "form-control";
		$this->cha_email->EditCustomAttributes = "";
		$this->cha_email->EditValue = $this->cha_email->CurrentValue;
		$this->cha_email->PlaceHolder = RemoveHtml($this->cha_email->caption());

		// cha_phone
		$this->cha_phone->EditAttrs["class"] = "form-control";
		$this->cha_phone->EditCustomAttributes = "";
		$this->cha_phone->EditValue = $this->cha_phone->CurrentValue;
		$this->cha_phone->PlaceHolder = RemoveHtml($this->cha_phone->caption());

		// forwarder
		$this->forwarder->EditAttrs["class"] = "form-control";
		$this->forwarder->EditCustomAttributes = "";
		$this->forwarder->EditValue = $this->forwarder->CurrentValue;
		$this->forwarder->PlaceHolder = RemoveHtml($this->forwarder->caption());

		// forwarder_email
		$this->forwarder_email->EditAttrs["class"] = "form-control";
		$this->forwarder_email->EditCustomAttributes = "";
		$this->forwarder_email->EditValue = $this->forwarder_email->CurrentValue;
		$this->forwarder_email->PlaceHolder = RemoveHtml($this->forwarder_email->caption());

		// forwarder_phone
		$this->forwarder_phone->EditAttrs["class"] = "form-control";
		$this->forwarder_phone->EditCustomAttributes = "";
		$this->forwarder_phone->EditValue = $this->forwarder_phone->CurrentValue;
		$this->forwarder_phone->PlaceHolder = RemoveHtml($this->forwarder_phone->caption());

		// merchant
		$this->merchant->EditAttrs["class"] = "form-control";
		$this->merchant->EditCustomAttributes = "";
		$this->merchant->EditValue = $this->merchant->CurrentValue;
		$this->merchant->PlaceHolder = RemoveHtml($this->merchant->caption());

		// merchant_email
		$this->merchant_email->EditAttrs["class"] = "form-control";
		$this->merchant_email->EditCustomAttributes = "";
		$this->merchant_email->EditValue = $this->merchant_email->CurrentValue;
		$this->merchant_email->PlaceHolder = RemoveHtml($this->merchant_email->caption());

		// merchant_phone
		$this->merchant_phone->EditAttrs["class"] = "form-control";
		$this->merchant_phone->EditCustomAttributes = "";
		$this->merchant_phone->EditValue = $this->merchant_phone->CurrentValue;
		$this->merchant_phone->PlaceHolder = RemoveHtml($this->merchant_phone->caption());

		// shipping_incharge
		$this->shipping_incharge->EditAttrs["class"] = "form-control";
		$this->shipping_incharge->EditCustomAttributes = "";
		$this->shipping_incharge->EditValue = $this->shipping_incharge->CurrentValue;
		$this->shipping_incharge->PlaceHolder = RemoveHtml($this->shipping_incharge->caption());

		// shipping_email
		$this->shipping_email->EditAttrs["class"] = "form-control";
		$this->shipping_email->EditCustomAttributes = "";
		$this->shipping_email->EditValue = $this->shipping_email->CurrentValue;
		$this->shipping_email->PlaceHolder = RemoveHtml($this->shipping_email->caption());

		// shipping_phone
		$this->shipping_phone->EditAttrs["class"] = "form-control";
		$this->shipping_phone->EditCustomAttributes = "";
		$this->shipping_phone->EditValue = $this->shipping_phone->CurrentValue;
		$this->shipping_phone->PlaceHolder = RemoveHtml($this->shipping_phone->caption());

		// account_incharge
		$this->account_incharge->EditAttrs["class"] = "form-control";
		$this->account_incharge->EditCustomAttributes = "";
		$this->account_incharge->EditValue = $this->account_incharge->CurrentValue;
		$this->account_incharge->PlaceHolder = RemoveHtml($this->account_incharge->caption());

		// accounts_email
		$this->accounts_email->EditAttrs["class"] = "form-control";
		$this->accounts_email->EditCustomAttributes = "";
		$this->accounts_email->EditValue = $this->accounts_email->CurrentValue;
		$this->accounts_email->PlaceHolder = RemoveHtml($this->accounts_email->caption());

		// accounts_phone
		$this->accounts_phone->EditAttrs["class"] = "form-control";
		$this->accounts_phone->EditCustomAttributes = "";
		$this->accounts_phone->EditValue = $this->accounts_phone->CurrentValue;
		$this->accounts_phone->PlaceHolder = RemoveHtml($this->accounts_phone->caption());

		// warehouse_incharge
		$this->warehouse_incharge->EditAttrs["class"] = "form-control";
		$this->warehouse_incharge->EditCustomAttributes = "";
		$this->warehouse_incharge->EditValue = $this->warehouse_incharge->CurrentValue;
		$this->warehouse_incharge->PlaceHolder = RemoveHtml($this->warehouse_incharge->caption());

		// warehouse_email
		$this->warehouse_email->EditAttrs["class"] = "form-control";
		$this->warehouse_email->EditCustomAttributes = "";
		$this->warehouse_email->EditValue = $this->warehouse_email->CurrentValue;
		$this->warehouse_email->PlaceHolder = RemoveHtml($this->warehouse_email->caption());

		// warehouse_phone
		$this->warehouse_phone->EditAttrs["class"] = "form-control";
		$this->warehouse_phone->EditCustomAttributes = "";
		$this->warehouse_phone->EditValue = $this->warehouse_phone->CurrentValue;
		$this->warehouse_phone->PlaceHolder = RemoveHtml($this->warehouse_phone->caption());

		// production_incharge
		$this->production_incharge->EditAttrs["class"] = "form-control";
		$this->production_incharge->EditCustomAttributes = "";
		$this->production_incharge->EditValue = $this->production_incharge->CurrentValue;
		$this->production_incharge->PlaceHolder = RemoveHtml($this->production_incharge->caption());

		// production_email
		$this->production_email->EditAttrs["class"] = "form-control";
		$this->production_email->EditCustomAttributes = "";
		$this->production_email->EditValue = $this->production_email->CurrentValue;
		$this->production_email->PlaceHolder = RemoveHtml($this->production_email->caption());

		// production_phone
		$this->production_phone->EditAttrs["class"] = "form-control";
		$this->production_phone->EditCustomAttributes = "";
		$this->production_phone->EditValue = $this->production_phone->CurrentValue;
		$this->production_phone->PlaceHolder = RemoveHtml($this->production_phone->caption());

		// qc_incharge
		$this->qc_incharge->EditAttrs["class"] = "form-control";
		$this->qc_incharge->EditCustomAttributes = "";
		$this->qc_incharge->EditValue = $this->qc_incharge->CurrentValue;
		$this->qc_incharge->PlaceHolder = RemoveHtml($this->qc_incharge->caption());

		// qc_email
		$this->qc_email->EditAttrs["class"] = "form-control";
		$this->qc_email->EditCustomAttributes = "";
		$this->qc_email->EditValue = $this->qc_email->CurrentValue;
		$this->qc_email->PlaceHolder = RemoveHtml($this->qc_email->caption());

		// qc_phone
		$this->qc_phone->EditAttrs["class"] = "form-control";
		$this->qc_phone->EditCustomAttributes = "";
		$this->qc_phone->EditValue = $this->qc_phone->CurrentValue;
		$this->qc_phone->PlaceHolder = RemoveHtml($this->qc_phone->caption());

		// uid
		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

		// r_text
		$this->r_text->EditAttrs["class"] = "form-control";
		$this->r_text->EditCustomAttributes = "";
		$this->r_text->EditValue = $this->r_text->CurrentValue;
		$this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->country);
					$doc->exportCaption($this->region);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->performance);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->tax_registration);
					$doc->exportCaption($this->cin);
					$doc->exportCaption($this->pan);
					$doc->exportCaption($this->tan);
					$doc->exportCaption($this->msme);
					$doc->exportCaption($this->port_air);
					$doc->exportCaption($this->port_sea);
					$doc->exportCaption($this->iec);
					$doc->exportCaption($this->rex);
					$doc->exportCaption($this->rcmc);
					$doc->exportCaption($this->delivery_terms);
					$doc->exportCaption($this->shipping_terms);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->export_type);
					$doc->exportCaption($this->lead_time_ss);
					$doc->exportCaption($this->lead_time_cs);
					$doc->exportCaption($this->cha);
					$doc->exportCaption($this->cha_email);
					$doc->exportCaption($this->cha_phone);
					$doc->exportCaption($this->forwarder);
					$doc->exportCaption($this->forwarder_email);
					$doc->exportCaption($this->forwarder_phone);
					$doc->exportCaption($this->merchant);
					$doc->exportCaption($this->merchant_email);
					$doc->exportCaption($this->merchant_phone);
					$doc->exportCaption($this->shipping_incharge);
					$doc->exportCaption($this->shipping_email);
					$doc->exportCaption($this->shipping_phone);
					$doc->exportCaption($this->account_incharge);
					$doc->exportCaption($this->accounts_email);
					$doc->exportCaption($this->accounts_phone);
					$doc->exportCaption($this->warehouse_incharge);
					$doc->exportCaption($this->warehouse_email);
					$doc->exportCaption($this->warehouse_phone);
					$doc->exportCaption($this->production_incharge);
					$doc->exportCaption($this->production_email);
					$doc->exportCaption($this->production_phone);
					$doc->exportCaption($this->qc_incharge);
					$doc->exportCaption($this->qc_email);
					$doc->exportCaption($this->qc_phone);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->country);
					$doc->exportCaption($this->region);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->performance);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->tax_registration);
					$doc->exportCaption($this->cin);
					$doc->exportCaption($this->pan);
					$doc->exportCaption($this->tan);
					$doc->exportCaption($this->msme);
					$doc->exportCaption($this->port_air);
					$doc->exportCaption($this->port_sea);
					$doc->exportCaption($this->iec);
					$doc->exportCaption($this->rex);
					$doc->exportCaption($this->rcmc);
					$doc->exportCaption($this->delivery_terms);
					$doc->exportCaption($this->shipping_terms);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->export_type);
					$doc->exportCaption($this->lead_time_ss);
					$doc->exportCaption($this->lead_time_cs);
					$doc->exportCaption($this->cha);
					$doc->exportCaption($this->cha_email);
					$doc->exportCaption($this->cha_phone);
					$doc->exportCaption($this->forwarder);
					$doc->exportCaption($this->forwarder_email);
					$doc->exportCaption($this->forwarder_phone);
					$doc->exportCaption($this->merchant);
					$doc->exportCaption($this->merchant_email);
					$doc->exportCaption($this->merchant_phone);
					$doc->exportCaption($this->shipping_incharge);
					$doc->exportCaption($this->shipping_email);
					$doc->exportCaption($this->shipping_phone);
					$doc->exportCaption($this->account_incharge);
					$doc->exportCaption($this->accounts_email);
					$doc->exportCaption($this->accounts_phone);
					$doc->exportCaption($this->warehouse_incharge);
					$doc->exportCaption($this->warehouse_email);
					$doc->exportCaption($this->warehouse_phone);
					$doc->exportCaption($this->production_incharge);
					$doc->exportCaption($this->production_email);
					$doc->exportCaption($this->production_phone);
					$doc->exportCaption($this->qc_incharge);
					$doc->exportCaption($this->qc_email);
					$doc->exportCaption($this->qc_phone);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->name);
						$doc->exportField($this->code);
						$doc->exportField($this->country);
						$doc->exportField($this->region);
						$doc->exportField($this->city);
						$doc->exportField($this->address);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->url);
						$doc->exportField($this->grp);
						$doc->exportField($this->category);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->status);
						$doc->exportField($this->performance);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->type);
						$doc->exportField($this->tax_registration);
						$doc->exportField($this->cin);
						$doc->exportField($this->pan);
						$doc->exportField($this->tan);
						$doc->exportField($this->msme);
						$doc->exportField($this->port_air);
						$doc->exportField($this->port_sea);
						$doc->exportField($this->iec);
						$doc->exportField($this->rex);
						$doc->exportField($this->rcmc);
						$doc->exportField($this->delivery_terms);
						$doc->exportField($this->shipping_terms);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->export_type);
						$doc->exportField($this->lead_time_ss);
						$doc->exportField($this->lead_time_cs);
						$doc->exportField($this->cha);
						$doc->exportField($this->cha_email);
						$doc->exportField($this->cha_phone);
						$doc->exportField($this->forwarder);
						$doc->exportField($this->forwarder_email);
						$doc->exportField($this->forwarder_phone);
						$doc->exportField($this->merchant);
						$doc->exportField($this->merchant_email);
						$doc->exportField($this->merchant_phone);
						$doc->exportField($this->shipping_incharge);
						$doc->exportField($this->shipping_email);
						$doc->exportField($this->shipping_phone);
						$doc->exportField($this->account_incharge);
						$doc->exportField($this->accounts_email);
						$doc->exportField($this->accounts_phone);
						$doc->exportField($this->warehouse_incharge);
						$doc->exportField($this->warehouse_email);
						$doc->exportField($this->warehouse_phone);
						$doc->exportField($this->production_incharge);
						$doc->exportField($this->production_email);
						$doc->exportField($this->production_phone);
						$doc->exportField($this->qc_incharge);
						$doc->exportField($this->qc_email);
						$doc->exportField($this->qc_phone);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->name);
						$doc->exportField($this->code);
						$doc->exportField($this->country);
						$doc->exportField($this->region);
						$doc->exportField($this->city);
						$doc->exportField($this->address);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->url);
						$doc->exportField($this->grp);
						$doc->exportField($this->category);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->status);
						$doc->exportField($this->performance);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->type);
						$doc->exportField($this->tax_registration);
						$doc->exportField($this->cin);
						$doc->exportField($this->pan);
						$doc->exportField($this->tan);
						$doc->exportField($this->msme);
						$doc->exportField($this->port_air);
						$doc->exportField($this->port_sea);
						$doc->exportField($this->iec);
						$doc->exportField($this->rex);
						$doc->exportField($this->rcmc);
						$doc->exportField($this->delivery_terms);
						$doc->exportField($this->shipping_terms);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->export_type);
						$doc->exportField($this->lead_time_ss);
						$doc->exportField($this->lead_time_cs);
						$doc->exportField($this->cha);
						$doc->exportField($this->cha_email);
						$doc->exportField($this->cha_phone);
						$doc->exportField($this->forwarder);
						$doc->exportField($this->forwarder_email);
						$doc->exportField($this->forwarder_phone);
						$doc->exportField($this->merchant);
						$doc->exportField($this->merchant_email);
						$doc->exportField($this->merchant_phone);
						$doc->exportField($this->shipping_incharge);
						$doc->exportField($this->shipping_email);
						$doc->exportField($this->shipping_phone);
						$doc->exportField($this->account_incharge);
						$doc->exportField($this->accounts_email);
						$doc->exportField($this->accounts_phone);
						$doc->exportField($this->warehouse_incharge);
						$doc->exportField($this->warehouse_email);
						$doc->exportField($this->warehouse_phone);
						$doc->exportField($this->production_incharge);
						$doc->exportField($this->production_email);
						$doc->exportField($this->production_phone);
						$doc->exportField($this->qc_incharge);
						$doc->exportField($this->qc_email);
						$doc->exportField($this->qc_phone);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>