<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class production_partner_edit extends production_partner
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'production_partner';

	// Page object name
	public $PageObjName = "production_partner_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (production_partner)
		if (!isset($GLOBALS["production_partner"]) || get_class($GLOBALS["production_partner"]) == PROJECT_NAMESPACE . "production_partner") {
			$GLOBALS["production_partner"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["production_partner"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $production_partner;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($production_partner);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "production_partnerview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("production_partnerlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->name->setVisibility();
		$this->code->setVisibility();
		$this->country->setVisibility();
		$this->region->setVisibility();
		$this->city->setVisibility();
		$this->address->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->url->setVisibility();
		$this->grp->setVisibility();
		$this->category->setVisibility();
		$this->reports_to->setVisibility();
		$this->status->setVisibility();
		$this->performance->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->type->setVisibility();
		$this->tax_registration->setVisibility();
		$this->cin->setVisibility();
		$this->pan->setVisibility();
		$this->tan->setVisibility();
		$this->msme->setVisibility();
		$this->incoterm->Visible = FALSE;
		$this->port_air->setVisibility();
		$this->port_sea->setVisibility();
		$this->iec->setVisibility();
		$this->rex->setVisibility();
		$this->rcmc->setVisibility();
		$this->delivery_terms->setVisibility();
		$this->shipping_terms->setVisibility();
		$this->payment_terms->setVisibility();
		$this->export_type->setVisibility();
		$this->lead_time_ss->setVisibility();
		$this->lead_time_cs->setVisibility();
		$this->cha->setVisibility();
		$this->cha_email->setVisibility();
		$this->cha_phone->setVisibility();
		$this->forwarder->setVisibility();
		$this->forwarder_email->setVisibility();
		$this->forwarder_phone->setVisibility();
		$this->merchant->setVisibility();
		$this->merchant_email->setVisibility();
		$this->merchant_phone->setVisibility();
		$this->shipping_incharge->setVisibility();
		$this->shipping_email->setVisibility();
		$this->shipping_phone->setVisibility();
		$this->account_incharge->setVisibility();
		$this->accounts_email->setVisibility();
		$this->accounts_phone->setVisibility();
		$this->warehouse_incharge->setVisibility();
		$this->warehouse_email->setVisibility();
		$this->warehouse_phone->setVisibility();
		$this->production_incharge->setVisibility();
		$this->production_email->setVisibility();
		$this->production_phone->setVisibility();
		$this->qc_incharge->setVisibility();
		$this->qc_email->setVisibility();
		$this->qc_phone->setVisibility();
		$this->uid->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->country);
		$this->setupLookupOptions($this->region);
		$this->setupLookupOptions($this->city);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->incoterm);
		$this->setupLookupOptions($this->port_air);
		$this->setupLookupOptions($this->port_sea);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("production_partnerlist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() <> "") // Master/detail edit
					$returnUrl = $this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "production_partnerlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'name' first before field var 'x_name'
		$val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
		if (!$this->name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->name->Visible = FALSE; // Disable update for API request
			else
				$this->name->setFormValue($val);
		}

		// Check field name 'code' first before field var 'x_code'
		$val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
		if (!$this->code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->code->Visible = FALSE; // Disable update for API request
			else
				$this->code->setFormValue($val);
		}

		// Check field name 'country' first before field var 'x_country'
		$val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
		if (!$this->country->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->country->Visible = FALSE; // Disable update for API request
			else
				$this->country->setFormValue($val);
		}

		// Check field name 'region' first before field var 'x_region'
		$val = $CurrentForm->hasValue("region") ? $CurrentForm->getValue("region") : $CurrentForm->getValue("x_region");
		if (!$this->region->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->region->Visible = FALSE; // Disable update for API request
			else
				$this->region->setFormValue($val);
		}

		// Check field name 'city' first before field var 'x_city'
		$val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
		if (!$this->city->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->city->Visible = FALSE; // Disable update for API request
			else
				$this->city->setFormValue($val);
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address->Visible = FALSE; // Disable update for API request
			else
				$this->address->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'url' first before field var 'x_url'
		$val = $CurrentForm->hasValue("url") ? $CurrentForm->getValue("url") : $CurrentForm->getValue("x_url");
		if (!$this->url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->url->Visible = FALSE; // Disable update for API request
			else
				$this->url->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'category' first before field var 'x_category'
		$val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
		if (!$this->category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->category->Visible = FALSE; // Disable update for API request
			else
				$this->category->setFormValue($val);
		}

		// Check field name 'reports_to' first before field var 'x_reports_to'
		$val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
		if (!$this->reports_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reports_to->Visible = FALSE; // Disable update for API request
			else
				$this->reports_to->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}

		// Check field name 'tax_registration' first before field var 'x_tax_registration'
		$val = $CurrentForm->hasValue("tax_registration") ? $CurrentForm->getValue("tax_registration") : $CurrentForm->getValue("x_tax_registration");
		if (!$this->tax_registration->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tax_registration->Visible = FALSE; // Disable update for API request
			else
				$this->tax_registration->setFormValue($val);
		}

		// Check field name 'cin' first before field var 'x_cin'
		$val = $CurrentForm->hasValue("cin") ? $CurrentForm->getValue("cin") : $CurrentForm->getValue("x_cin");
		if (!$this->cin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cin->Visible = FALSE; // Disable update for API request
			else
				$this->cin->setFormValue($val);
		}

		// Check field name 'pan' first before field var 'x_pan'
		$val = $CurrentForm->hasValue("pan") ? $CurrentForm->getValue("pan") : $CurrentForm->getValue("x_pan");
		if (!$this->pan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pan->Visible = FALSE; // Disable update for API request
			else
				$this->pan->setFormValue($val);
		}

		// Check field name 'tan' first before field var 'x_tan'
		$val = $CurrentForm->hasValue("tan") ? $CurrentForm->getValue("tan") : $CurrentForm->getValue("x_tan");
		if (!$this->tan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tan->Visible = FALSE; // Disable update for API request
			else
				$this->tan->setFormValue($val);
		}

		// Check field name 'msme' first before field var 'x_msme'
		$val = $CurrentForm->hasValue("msme") ? $CurrentForm->getValue("msme") : $CurrentForm->getValue("x_msme");
		if (!$this->msme->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->msme->Visible = FALSE; // Disable update for API request
			else
				$this->msme->setFormValue($val);
		}

		// Check field name 'port_air' first before field var 'x_port_air'
		$val = $CurrentForm->hasValue("port_air") ? $CurrentForm->getValue("port_air") : $CurrentForm->getValue("x_port_air");
		if (!$this->port_air->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_air->Visible = FALSE; // Disable update for API request
			else
				$this->port_air->setFormValue($val);
		}

		// Check field name 'port_sea' first before field var 'x_port_sea'
		$val = $CurrentForm->hasValue("port_sea") ? $CurrentForm->getValue("port_sea") : $CurrentForm->getValue("x_port_sea");
		if (!$this->port_sea->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_sea->Visible = FALSE; // Disable update for API request
			else
				$this->port_sea->setFormValue($val);
		}

		// Check field name 'iec' first before field var 'x_iec'
		$val = $CurrentForm->hasValue("iec") ? $CurrentForm->getValue("iec") : $CurrentForm->getValue("x_iec");
		if (!$this->iec->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->iec->Visible = FALSE; // Disable update for API request
			else
				$this->iec->setFormValue($val);
		}

		// Check field name 'rex' first before field var 'x_rex'
		$val = $CurrentForm->hasValue("rex") ? $CurrentForm->getValue("rex") : $CurrentForm->getValue("x_rex");
		if (!$this->rex->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rex->Visible = FALSE; // Disable update for API request
			else
				$this->rex->setFormValue($val);
		}

		// Check field name 'rcmc' first before field var 'x_rcmc'
		$val = $CurrentForm->hasValue("rcmc") ? $CurrentForm->getValue("rcmc") : $CurrentForm->getValue("x_rcmc");
		if (!$this->rcmc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rcmc->Visible = FALSE; // Disable update for API request
			else
				$this->rcmc->setFormValue($val);
		}

		// Check field name 'delivery_terms' first before field var 'x_delivery_terms'
		$val = $CurrentForm->hasValue("delivery_terms") ? $CurrentForm->getValue("delivery_terms") : $CurrentForm->getValue("x_delivery_terms");
		if (!$this->delivery_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_terms->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_terms->setFormValue($val);
		}

		// Check field name 'shipping_terms' first before field var 'x_shipping_terms'
		$val = $CurrentForm->hasValue("shipping_terms") ? $CurrentForm->getValue("shipping_terms") : $CurrentForm->getValue("x_shipping_terms");
		if (!$this->shipping_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_terms->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_terms->setFormValue($val);
		}

		// Check field name 'payment_terms' first before field var 'x_payment_terms'
		$val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
		if (!$this->payment_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_terms->Visible = FALSE; // Disable update for API request
			else
				$this->payment_terms->setFormValue($val);
		}

		// Check field name 'export_type' first before field var 'x_export_type'
		$val = $CurrentForm->hasValue("export_type") ? $CurrentForm->getValue("export_type") : $CurrentForm->getValue("x_export_type");
		if (!$this->export_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->export_type->Visible = FALSE; // Disable update for API request
			else
				$this->export_type->setFormValue($val);
		}

		// Check field name 'lead_time_ss' first before field var 'x_lead_time_ss'
		$val = $CurrentForm->hasValue("lead_time_ss") ? $CurrentForm->getValue("lead_time_ss") : $CurrentForm->getValue("x_lead_time_ss");
		if (!$this->lead_time_ss->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lead_time_ss->Visible = FALSE; // Disable update for API request
			else
				$this->lead_time_ss->setFormValue($val);
		}

		// Check field name 'lead_time_cs' first before field var 'x_lead_time_cs'
		$val = $CurrentForm->hasValue("lead_time_cs") ? $CurrentForm->getValue("lead_time_cs") : $CurrentForm->getValue("x_lead_time_cs");
		if (!$this->lead_time_cs->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lead_time_cs->Visible = FALSE; // Disable update for API request
			else
				$this->lead_time_cs->setFormValue($val);
		}

		// Check field name 'cha' first before field var 'x_cha'
		$val = $CurrentForm->hasValue("cha") ? $CurrentForm->getValue("cha") : $CurrentForm->getValue("x_cha");
		if (!$this->cha->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cha->Visible = FALSE; // Disable update for API request
			else
				$this->cha->setFormValue($val);
		}

		// Check field name 'cha_email' first before field var 'x_cha_email'
		$val = $CurrentForm->hasValue("cha_email") ? $CurrentForm->getValue("cha_email") : $CurrentForm->getValue("x_cha_email");
		if (!$this->cha_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cha_email->Visible = FALSE; // Disable update for API request
			else
				$this->cha_email->setFormValue($val);
		}

		// Check field name 'cha_phone' first before field var 'x_cha_phone'
		$val = $CurrentForm->hasValue("cha_phone") ? $CurrentForm->getValue("cha_phone") : $CurrentForm->getValue("x_cha_phone");
		if (!$this->cha_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cha_phone->Visible = FALSE; // Disable update for API request
			else
				$this->cha_phone->setFormValue($val);
		}

		// Check field name 'forwarder' first before field var 'x_forwarder'
		$val = $CurrentForm->hasValue("forwarder") ? $CurrentForm->getValue("forwarder") : $CurrentForm->getValue("x_forwarder");
		if (!$this->forwarder->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->forwarder->Visible = FALSE; // Disable update for API request
			else
				$this->forwarder->setFormValue($val);
		}

		// Check field name 'forwarder_email' first before field var 'x_forwarder_email'
		$val = $CurrentForm->hasValue("forwarder_email") ? $CurrentForm->getValue("forwarder_email") : $CurrentForm->getValue("x_forwarder_email");
		if (!$this->forwarder_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->forwarder_email->Visible = FALSE; // Disable update for API request
			else
				$this->forwarder_email->setFormValue($val);
		}

		// Check field name 'forwarder_phone' first before field var 'x_forwarder_phone'
		$val = $CurrentForm->hasValue("forwarder_phone") ? $CurrentForm->getValue("forwarder_phone") : $CurrentForm->getValue("x_forwarder_phone");
		if (!$this->forwarder_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->forwarder_phone->Visible = FALSE; // Disable update for API request
			else
				$this->forwarder_phone->setFormValue($val);
		}

		// Check field name 'merchant' first before field var 'x_merchant'
		$val = $CurrentForm->hasValue("merchant") ? $CurrentForm->getValue("merchant") : $CurrentForm->getValue("x_merchant");
		if (!$this->merchant->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->merchant->Visible = FALSE; // Disable update for API request
			else
				$this->merchant->setFormValue($val);
		}

		// Check field name 'merchant_email' first before field var 'x_merchant_email'
		$val = $CurrentForm->hasValue("merchant_email") ? $CurrentForm->getValue("merchant_email") : $CurrentForm->getValue("x_merchant_email");
		if (!$this->merchant_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->merchant_email->Visible = FALSE; // Disable update for API request
			else
				$this->merchant_email->setFormValue($val);
		}

		// Check field name 'merchant_phone' first before field var 'x_merchant_phone'
		$val = $CurrentForm->hasValue("merchant_phone") ? $CurrentForm->getValue("merchant_phone") : $CurrentForm->getValue("x_merchant_phone");
		if (!$this->merchant_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->merchant_phone->Visible = FALSE; // Disable update for API request
			else
				$this->merchant_phone->setFormValue($val);
		}

		// Check field name 'shipping_incharge' first before field var 'x_shipping_incharge'
		$val = $CurrentForm->hasValue("shipping_incharge") ? $CurrentForm->getValue("shipping_incharge") : $CurrentForm->getValue("x_shipping_incharge");
		if (!$this->shipping_incharge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_incharge->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_incharge->setFormValue($val);
		}

		// Check field name 'shipping_email' first before field var 'x_shipping_email'
		$val = $CurrentForm->hasValue("shipping_email") ? $CurrentForm->getValue("shipping_email") : $CurrentForm->getValue("x_shipping_email");
		if (!$this->shipping_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_email->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_email->setFormValue($val);
		}

		// Check field name 'shipping_phone' first before field var 'x_shipping_phone'
		$val = $CurrentForm->hasValue("shipping_phone") ? $CurrentForm->getValue("shipping_phone") : $CurrentForm->getValue("x_shipping_phone");
		if (!$this->shipping_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_phone->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_phone->setFormValue($val);
		}

		// Check field name 'account_incharge' first before field var 'x_account_incharge'
		$val = $CurrentForm->hasValue("account_incharge") ? $CurrentForm->getValue("account_incharge") : $CurrentForm->getValue("x_account_incharge");
		if (!$this->account_incharge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->account_incharge->Visible = FALSE; // Disable update for API request
			else
				$this->account_incharge->setFormValue($val);
		}

		// Check field name 'accounts_email' first before field var 'x_accounts_email'
		$val = $CurrentForm->hasValue("accounts_email") ? $CurrentForm->getValue("accounts_email") : $CurrentForm->getValue("x_accounts_email");
		if (!$this->accounts_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->accounts_email->Visible = FALSE; // Disable update for API request
			else
				$this->accounts_email->setFormValue($val);
		}

		// Check field name 'accounts_phone' first before field var 'x_accounts_phone'
		$val = $CurrentForm->hasValue("accounts_phone") ? $CurrentForm->getValue("accounts_phone") : $CurrentForm->getValue("x_accounts_phone");
		if (!$this->accounts_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->accounts_phone->Visible = FALSE; // Disable update for API request
			else
				$this->accounts_phone->setFormValue($val);
		}

		// Check field name 'warehouse_incharge' first before field var 'x_warehouse_incharge'
		$val = $CurrentForm->hasValue("warehouse_incharge") ? $CurrentForm->getValue("warehouse_incharge") : $CurrentForm->getValue("x_warehouse_incharge");
		if (!$this->warehouse_incharge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->warehouse_incharge->Visible = FALSE; // Disable update for API request
			else
				$this->warehouse_incharge->setFormValue($val);
		}

		// Check field name 'warehouse_email' first before field var 'x_warehouse_email'
		$val = $CurrentForm->hasValue("warehouse_email") ? $CurrentForm->getValue("warehouse_email") : $CurrentForm->getValue("x_warehouse_email");
		if (!$this->warehouse_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->warehouse_email->Visible = FALSE; // Disable update for API request
			else
				$this->warehouse_email->setFormValue($val);
		}

		// Check field name 'warehouse_phone' first before field var 'x_warehouse_phone'
		$val = $CurrentForm->hasValue("warehouse_phone") ? $CurrentForm->getValue("warehouse_phone") : $CurrentForm->getValue("x_warehouse_phone");
		if (!$this->warehouse_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->warehouse_phone->Visible = FALSE; // Disable update for API request
			else
				$this->warehouse_phone->setFormValue($val);
		}

		// Check field name 'production_incharge' first before field var 'x_production_incharge'
		$val = $CurrentForm->hasValue("production_incharge") ? $CurrentForm->getValue("production_incharge") : $CurrentForm->getValue("x_production_incharge");
		if (!$this->production_incharge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_incharge->Visible = FALSE; // Disable update for API request
			else
				$this->production_incharge->setFormValue($val);
		}

		// Check field name 'production_email' first before field var 'x_production_email'
		$val = $CurrentForm->hasValue("production_email") ? $CurrentForm->getValue("production_email") : $CurrentForm->getValue("x_production_email");
		if (!$this->production_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_email->Visible = FALSE; // Disable update for API request
			else
				$this->production_email->setFormValue($val);
		}

		// Check field name 'production_phone' first before field var 'x_production_phone'
		$val = $CurrentForm->hasValue("production_phone") ? $CurrentForm->getValue("production_phone") : $CurrentForm->getValue("x_production_phone");
		if (!$this->production_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_phone->Visible = FALSE; // Disable update for API request
			else
				$this->production_phone->setFormValue($val);
		}

		// Check field name 'qc_incharge' first before field var 'x_qc_incharge'
		$val = $CurrentForm->hasValue("qc_incharge") ? $CurrentForm->getValue("qc_incharge") : $CurrentForm->getValue("x_qc_incharge");
		if (!$this->qc_incharge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_incharge->Visible = FALSE; // Disable update for API request
			else
				$this->qc_incharge->setFormValue($val);
		}

		// Check field name 'qc_email' first before field var 'x_qc_email'
		$val = $CurrentForm->hasValue("qc_email") ? $CurrentForm->getValue("qc_email") : $CurrentForm->getValue("x_qc_email");
		if (!$this->qc_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_email->Visible = FALSE; // Disable update for API request
			else
				$this->qc_email->setFormValue($val);
		}

		// Check field name 'qc_phone' first before field var 'x_qc_phone'
		$val = $CurrentForm->hasValue("qc_phone") ? $CurrentForm->getValue("qc_phone") : $CurrentForm->getValue("x_qc_phone");
		if (!$this->qc_phone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_phone->Visible = FALSE; // Disable update for API request
			else
				$this->qc_phone->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->name->CurrentValue = $this->name->FormValue;
		$this->code->CurrentValue = $this->code->FormValue;
		$this->country->CurrentValue = $this->country->FormValue;
		$this->region->CurrentValue = $this->region->FormValue;
		$this->city->CurrentValue = $this->city->FormValue;
		$this->address->CurrentValue = $this->address->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->url->CurrentValue = $this->url->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->category->CurrentValue = $this->category->FormValue;
		$this->reports_to->CurrentValue = $this->reports_to->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->type->CurrentValue = $this->type->FormValue;
		$this->tax_registration->CurrentValue = $this->tax_registration->FormValue;
		$this->cin->CurrentValue = $this->cin->FormValue;
		$this->pan->CurrentValue = $this->pan->FormValue;
		$this->tan->CurrentValue = $this->tan->FormValue;
		$this->msme->CurrentValue = $this->msme->FormValue;
		$this->port_air->CurrentValue = $this->port_air->FormValue;
		$this->port_sea->CurrentValue = $this->port_sea->FormValue;
		$this->iec->CurrentValue = $this->iec->FormValue;
		$this->rex->CurrentValue = $this->rex->FormValue;
		$this->rcmc->CurrentValue = $this->rcmc->FormValue;
		$this->delivery_terms->CurrentValue = $this->delivery_terms->FormValue;
		$this->shipping_terms->CurrentValue = $this->shipping_terms->FormValue;
		$this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
		$this->export_type->CurrentValue = $this->export_type->FormValue;
		$this->lead_time_ss->CurrentValue = $this->lead_time_ss->FormValue;
		$this->lead_time_cs->CurrentValue = $this->lead_time_cs->FormValue;
		$this->cha->CurrentValue = $this->cha->FormValue;
		$this->cha_email->CurrentValue = $this->cha_email->FormValue;
		$this->cha_phone->CurrentValue = $this->cha_phone->FormValue;
		$this->forwarder->CurrentValue = $this->forwarder->FormValue;
		$this->forwarder_email->CurrentValue = $this->forwarder_email->FormValue;
		$this->forwarder_phone->CurrentValue = $this->forwarder_phone->FormValue;
		$this->merchant->CurrentValue = $this->merchant->FormValue;
		$this->merchant_email->CurrentValue = $this->merchant_email->FormValue;
		$this->merchant_phone->CurrentValue = $this->merchant_phone->FormValue;
		$this->shipping_incharge->CurrentValue = $this->shipping_incharge->FormValue;
		$this->shipping_email->CurrentValue = $this->shipping_email->FormValue;
		$this->shipping_phone->CurrentValue = $this->shipping_phone->FormValue;
		$this->account_incharge->CurrentValue = $this->account_incharge->FormValue;
		$this->accounts_email->CurrentValue = $this->accounts_email->FormValue;
		$this->accounts_phone->CurrentValue = $this->accounts_phone->FormValue;
		$this->warehouse_incharge->CurrentValue = $this->warehouse_incharge->FormValue;
		$this->warehouse_email->CurrentValue = $this->warehouse_email->FormValue;
		$this->warehouse_phone->CurrentValue = $this->warehouse_phone->FormValue;
		$this->production_incharge->CurrentValue = $this->production_incharge->FormValue;
		$this->production_email->CurrentValue = $this->production_email->FormValue;
		$this->production_phone->CurrentValue = $this->production_phone->FormValue;
		$this->qc_incharge->CurrentValue = $this->qc_incharge->FormValue;
		$this->qc_email->CurrentValue = $this->qc_email->FormValue;
		$this->qc_phone->CurrentValue = $this->qc_phone->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->name->setDbValue($row['name']);
		$this->code->setDbValue($row['code']);
		$this->country->setDbValue($row['country']);
		$this->region->setDbValue($row['region']);
		$this->city->setDbValue($row['city']);
		if (array_key_exists('EV__city', $rs->fields)) {
			$this->city->VirtualValue = $rs->fields('EV__city'); // Set up virtual field value
		} else {
			$this->city->VirtualValue = ""; // Clear value
		}
		$this->address->setDbValue($row['address']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->url->setDbValue($row['url']);
		$this->grp->setDbValue($row['grp']);
		$this->category->setDbValue($row['category']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->status->setDbValue($row['status']);
		$this->performance->setDbValue($row['performance']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->type->setDbValue($row['type']);
		$this->tax_registration->setDbValue($row['tax_registration']);
		$this->cin->setDbValue($row['cin']);
		$this->pan->setDbValue($row['pan']);
		$this->tan->setDbValue($row['tan']);
		$this->msme->setDbValue($row['msme']);
		$this->incoterm->setDbValue($row['incoterm']);
		$this->port_air->setDbValue($row['port_air']);
		$this->port_sea->setDbValue($row['port_sea']);
		$this->iec->setDbValue($row['iec']);
		$this->rex->setDbValue($row['rex']);
		$this->rcmc->setDbValue($row['rcmc']);
		$this->delivery_terms->setDbValue($row['delivery_terms']);
		$this->shipping_terms->setDbValue($row['shipping_terms']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->export_type->setDbValue($row['export_type']);
		$this->lead_time_ss->setDbValue($row['lead_time_ss']);
		$this->lead_time_cs->setDbValue($row['lead_time_cs']);
		$this->cha->setDbValue($row['cha']);
		$this->cha_email->setDbValue($row['cha_email']);
		$this->cha_phone->setDbValue($row['cha_phone']);
		$this->forwarder->setDbValue($row['forwarder']);
		$this->forwarder_email->setDbValue($row['forwarder_email']);
		$this->forwarder_phone->setDbValue($row['forwarder_phone']);
		$this->merchant->setDbValue($row['merchant']);
		$this->merchant_email->setDbValue($row['merchant_email']);
		$this->merchant_phone->setDbValue($row['merchant_phone']);
		$this->shipping_incharge->setDbValue($row['shipping_incharge']);
		$this->shipping_email->setDbValue($row['shipping_email']);
		$this->shipping_phone->setDbValue($row['shipping_phone']);
		$this->account_incharge->setDbValue($row['account_incharge']);
		$this->accounts_email->setDbValue($row['accounts_email']);
		$this->accounts_phone->setDbValue($row['accounts_phone']);
		$this->warehouse_incharge->setDbValue($row['warehouse_incharge']);
		$this->warehouse_email->setDbValue($row['warehouse_email']);
		$this->warehouse_phone->setDbValue($row['warehouse_phone']);
		$this->production_incharge->setDbValue($row['production_incharge']);
		$this->production_email->setDbValue($row['production_email']);
		$this->production_phone->setDbValue($row['production_phone']);
		$this->qc_incharge->setDbValue($row['qc_incharge']);
		$this->qc_email->setDbValue($row['qc_email']);
		$this->qc_phone->setDbValue($row['qc_phone']);
		$this->uid->setDbValue($row['uid']);
		$this->r_text->setDbValue($row['r_text']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['name'] = NULL;
		$row['code'] = NULL;
		$row['country'] = NULL;
		$row['region'] = NULL;
		$row['city'] = NULL;
		$row['address'] = NULL;
		$row['mobile'] = NULL;
		$row['email'] = NULL;
		$row['url'] = NULL;
		$row['grp'] = NULL;
		$row['category'] = NULL;
		$row['reports_to'] = NULL;
		$row['status'] = NULL;
		$row['performance'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['type'] = NULL;
		$row['tax_registration'] = NULL;
		$row['cin'] = NULL;
		$row['pan'] = NULL;
		$row['tan'] = NULL;
		$row['msme'] = NULL;
		$row['incoterm'] = NULL;
		$row['port_air'] = NULL;
		$row['port_sea'] = NULL;
		$row['iec'] = NULL;
		$row['rex'] = NULL;
		$row['rcmc'] = NULL;
		$row['delivery_terms'] = NULL;
		$row['shipping_terms'] = NULL;
		$row['payment_terms'] = NULL;
		$row['export_type'] = NULL;
		$row['lead_time_ss'] = NULL;
		$row['lead_time_cs'] = NULL;
		$row['cha'] = NULL;
		$row['cha_email'] = NULL;
		$row['cha_phone'] = NULL;
		$row['forwarder'] = NULL;
		$row['forwarder_email'] = NULL;
		$row['forwarder_phone'] = NULL;
		$row['merchant'] = NULL;
		$row['merchant_email'] = NULL;
		$row['merchant_phone'] = NULL;
		$row['shipping_incharge'] = NULL;
		$row['shipping_email'] = NULL;
		$row['shipping_phone'] = NULL;
		$row['account_incharge'] = NULL;
		$row['accounts_email'] = NULL;
		$row['accounts_phone'] = NULL;
		$row['warehouse_incharge'] = NULL;
		$row['warehouse_email'] = NULL;
		$row['warehouse_phone'] = NULL;
		$row['production_incharge'] = NULL;
		$row['production_email'] = NULL;
		$row['production_phone'] = NULL;
		$row['qc_incharge'] = NULL;
		$row['qc_email'] = NULL;
		$row['qc_phone'] = NULL;
		$row['uid'] = NULL;
		$row['r_text'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// name
		// code
		// country
		// region
		// city
		// address
		// mobile
		// email
		// url
		// grp
		// category
		// reports_to
		// status
		// performance
		// operator
		// datetime
		// type
		// tax_registration
		// cin
		// pan
		// tan
		// msme
		// incoterm
		// port_air
		// port_sea
		// iec
		// rex
		// rcmc
		// delivery_terms
		// shipping_terms
		// payment_terms
		// export_type
		// lead_time_ss
		// lead_time_cs
		// cha
		// cha_email
		// cha_phone
		// forwarder
		// forwarder_email
		// forwarder_phone
		// merchant
		// merchant_email
		// merchant_phone
		// shipping_incharge
		// shipping_email
		// shipping_phone
		// account_incharge
		// accounts_email
		// accounts_phone
		// warehouse_incharge
		// warehouse_email
		// warehouse_phone
		// production_incharge
		// production_email
		// production_phone
		// qc_incharge
		// qc_email
		// qc_phone
		// uid
		// r_text

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// country
			$curVal = strval($this->country->CurrentValue);
			if ($curVal <> "") {
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
				if ($this->country->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->country->ViewValue = $this->country->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->country->ViewValue = $this->country->CurrentValue;
					}
				}
			} else {
				$this->country->ViewValue = NULL;
			}
			$this->country->ViewCustomAttributes = "";

			// region
			$curVal = strval($this->region->CurrentValue);
			if ($curVal <> "") {
				$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
				if ($this->region->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->region->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->region->ViewValue = $this->region->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->region->ViewValue = $this->region->CurrentValue;
					}
				}
			} else {
				$this->region->ViewValue = NULL;
			}
			$this->region->ViewCustomAttributes = "";

			// city
			if ($this->city->VirtualValue <> "") {
				$this->city->ViewValue = $this->city->VirtualValue;
			} else {
				$this->city->ViewValue = $this->city->CurrentValue;
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->city->ViewValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->ViewValue = $this->city->CurrentValue;
					}
				}
			} else {
				$this->city->ViewValue = NULL;
			}
			}
			$this->city->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// performance
			$this->performance->ViewValue = $this->performance->CurrentValue;
			$this->performance->ViewValue = FormatNumber($this->performance->ViewValue, 0, -2, -2, -2);
			$this->performance->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// tax_registration
			$this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;
			$this->tax_registration->ViewCustomAttributes = "";

			// cin
			$this->cin->ViewValue = $this->cin->CurrentValue;
			$this->cin->ViewCustomAttributes = "";

			// pan
			$this->pan->ViewValue = $this->pan->CurrentValue;
			$this->pan->ViewCustomAttributes = "";

			// tan
			$this->tan->ViewValue = $this->tan->CurrentValue;
			$this->tan->ViewCustomAttributes = "";

			// msme
			$this->msme->ViewValue = $this->msme->CurrentValue;
			$this->msme->ViewCustomAttributes = "";

			// port_air
			$curVal = strval($this->port_air->CurrentValue);
			if ($curVal <> "") {
				$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
				if ($this->port_air->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=1 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_air->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_air->ViewValue = $this->port_air->CurrentValue;
					}
				}
			} else {
				$this->port_air->ViewValue = NULL;
			}
			$this->port_air->ViewCustomAttributes = "";

			// port_sea
			$curVal = strval($this->port_sea->CurrentValue);
			if ($curVal <> "") {
				$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
				if ($this->port_sea->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=0 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_sea->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_sea->ViewValue = $this->port_sea->CurrentValue;
					}
				}
			} else {
				$this->port_sea->ViewValue = NULL;
			}
			$this->port_sea->ViewCustomAttributes = "";

			// iec
			$this->iec->ViewValue = $this->iec->CurrentValue;
			$this->iec->ViewCustomAttributes = "";

			// rex
			$this->rex->ViewValue = $this->rex->CurrentValue;
			$this->rex->ViewCustomAttributes = "";

			// rcmc
			$this->rcmc->ViewValue = $this->rcmc->CurrentValue;
			$this->rcmc->ViewCustomAttributes = "";

			// delivery_terms
			$this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
			$this->delivery_terms->ViewCustomAttributes = "";

			// shipping_terms
			$this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;
			$this->shipping_terms->ViewCustomAttributes = "";

			// payment_terms
			$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
			$this->payment_terms->ViewCustomAttributes = "";

			// export_type
			$this->export_type->ViewValue = $this->export_type->CurrentValue;
			$this->export_type->ViewCustomAttributes = "";

			// lead_time_ss
			$this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;
			$this->lead_time_ss->ViewCustomAttributes = "";

			// lead_time_cs
			$this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;
			$this->lead_time_cs->ViewCustomAttributes = "";

			// cha
			$this->cha->ViewValue = $this->cha->CurrentValue;
			$this->cha->ViewCustomAttributes = "";

			// cha_email
			$this->cha_email->ViewValue = $this->cha_email->CurrentValue;
			$this->cha_email->ViewCustomAttributes = "";

			// cha_phone
			$this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;
			$this->cha_phone->ViewCustomAttributes = "";

			// forwarder
			$this->forwarder->ViewValue = $this->forwarder->CurrentValue;
			$this->forwarder->ViewCustomAttributes = "";

			// forwarder_email
			$this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;
			$this->forwarder_email->ViewCustomAttributes = "";

			// forwarder_phone
			$this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;
			$this->forwarder_phone->ViewCustomAttributes = "";

			// merchant
			$this->merchant->ViewValue = $this->merchant->CurrentValue;
			$this->merchant->ViewCustomAttributes = "";

			// merchant_email
			$this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;
			$this->merchant_email->ViewCustomAttributes = "";

			// merchant_phone
			$this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;
			$this->merchant_phone->ViewCustomAttributes = "";

			// shipping_incharge
			$this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;
			$this->shipping_incharge->ViewCustomAttributes = "";

			// shipping_email
			$this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;
			$this->shipping_email->ViewCustomAttributes = "";

			// shipping_phone
			$this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;
			$this->shipping_phone->ViewCustomAttributes = "";

			// account_incharge
			$this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;
			$this->account_incharge->ViewCustomAttributes = "";

			// accounts_email
			$this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;
			$this->accounts_email->ViewCustomAttributes = "";

			// accounts_phone
			$this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;
			$this->accounts_phone->ViewCustomAttributes = "";

			// warehouse_incharge
			$this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;
			$this->warehouse_incharge->ViewCustomAttributes = "";

			// warehouse_email
			$this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;
			$this->warehouse_email->ViewCustomAttributes = "";

			// warehouse_phone
			$this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;
			$this->warehouse_phone->ViewCustomAttributes = "";

			// production_incharge
			$this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;
			$this->production_incharge->ViewCustomAttributes = "";

			// production_email
			$this->production_email->ViewValue = $this->production_email->CurrentValue;
			$this->production_email->ViewCustomAttributes = "";

			// production_phone
			$this->production_phone->ViewValue = $this->production_phone->CurrentValue;
			$this->production_phone->ViewCustomAttributes = "";

			// qc_incharge
			$this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;
			$this->qc_incharge->ViewCustomAttributes = "";

			// qc_email
			$this->qc_email->ViewValue = $this->qc_email->CurrentValue;
			$this->qc_email->ViewCustomAttributes = "";

			// qc_phone
			$this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;
			$this->qc_phone->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";
			$this->country->TooltipValue = "";

			// region
			$this->region->LinkCustomAttributes = "";
			$this->region->HrefValue = "";
			$this->region->TooltipValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";
			$this->city->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// tax_registration
			$this->tax_registration->LinkCustomAttributes = "";
			$this->tax_registration->HrefValue = "";
			$this->tax_registration->TooltipValue = "";

			// cin
			$this->cin->LinkCustomAttributes = "";
			$this->cin->HrefValue = "";
			$this->cin->TooltipValue = "";

			// pan
			$this->pan->LinkCustomAttributes = "";
			$this->pan->HrefValue = "";
			$this->pan->TooltipValue = "";

			// tan
			$this->tan->LinkCustomAttributes = "";
			$this->tan->HrefValue = "";
			$this->tan->TooltipValue = "";

			// msme
			$this->msme->LinkCustomAttributes = "";
			$this->msme->HrefValue = "";
			$this->msme->TooltipValue = "";

			// port_air
			$this->port_air->LinkCustomAttributes = "";
			$this->port_air->HrefValue = "";
			$this->port_air->TooltipValue = "";

			// port_sea
			$this->port_sea->LinkCustomAttributes = "";
			$this->port_sea->HrefValue = "";
			$this->port_sea->TooltipValue = "";

			// iec
			$this->iec->LinkCustomAttributes = "";
			$this->iec->HrefValue = "";
			$this->iec->TooltipValue = "";

			// rex
			$this->rex->LinkCustomAttributes = "";
			$this->rex->HrefValue = "";
			$this->rex->TooltipValue = "";

			// rcmc
			$this->rcmc->LinkCustomAttributes = "";
			$this->rcmc->HrefValue = "";
			$this->rcmc->TooltipValue = "";

			// delivery_terms
			$this->delivery_terms->LinkCustomAttributes = "";
			$this->delivery_terms->HrefValue = "";
			$this->delivery_terms->TooltipValue = "";

			// shipping_terms
			$this->shipping_terms->LinkCustomAttributes = "";
			$this->shipping_terms->HrefValue = "";
			$this->shipping_terms->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// export_type
			$this->export_type->LinkCustomAttributes = "";
			$this->export_type->HrefValue = "";
			$this->export_type->TooltipValue = "";

			// lead_time_ss
			$this->lead_time_ss->LinkCustomAttributes = "";
			$this->lead_time_ss->HrefValue = "";
			$this->lead_time_ss->TooltipValue = "";

			// lead_time_cs
			$this->lead_time_cs->LinkCustomAttributes = "";
			$this->lead_time_cs->HrefValue = "";
			$this->lead_time_cs->TooltipValue = "";

			// cha
			$this->cha->LinkCustomAttributes = "";
			$this->cha->HrefValue = "";
			$this->cha->TooltipValue = "";

			// cha_email
			$this->cha_email->LinkCustomAttributes = "";
			$this->cha_email->HrefValue = "";
			$this->cha_email->TooltipValue = "";

			// cha_phone
			$this->cha_phone->LinkCustomAttributes = "";
			$this->cha_phone->HrefValue = "";
			$this->cha_phone->TooltipValue = "";

			// forwarder
			$this->forwarder->LinkCustomAttributes = "";
			$this->forwarder->HrefValue = "";
			$this->forwarder->TooltipValue = "";

			// forwarder_email
			$this->forwarder_email->LinkCustomAttributes = "";
			$this->forwarder_email->HrefValue = "";
			$this->forwarder_email->TooltipValue = "";

			// forwarder_phone
			$this->forwarder_phone->LinkCustomAttributes = "";
			$this->forwarder_phone->HrefValue = "";
			$this->forwarder_phone->TooltipValue = "";

			// merchant
			$this->merchant->LinkCustomAttributes = "";
			$this->merchant->HrefValue = "";
			$this->merchant->TooltipValue = "";

			// merchant_email
			$this->merchant_email->LinkCustomAttributes = "";
			$this->merchant_email->HrefValue = "";
			$this->merchant_email->TooltipValue = "";

			// merchant_phone
			$this->merchant_phone->LinkCustomAttributes = "";
			$this->merchant_phone->HrefValue = "";
			$this->merchant_phone->TooltipValue = "";

			// shipping_incharge
			$this->shipping_incharge->LinkCustomAttributes = "";
			$this->shipping_incharge->HrefValue = "";
			$this->shipping_incharge->TooltipValue = "";

			// shipping_email
			$this->shipping_email->LinkCustomAttributes = "";
			$this->shipping_email->HrefValue = "";
			$this->shipping_email->TooltipValue = "";

			// shipping_phone
			$this->shipping_phone->LinkCustomAttributes = "";
			$this->shipping_phone->HrefValue = "";
			$this->shipping_phone->TooltipValue = "";

			// account_incharge
			$this->account_incharge->LinkCustomAttributes = "";
			$this->account_incharge->HrefValue = "";
			$this->account_incharge->TooltipValue = "";

			// accounts_email
			$this->accounts_email->LinkCustomAttributes = "";
			$this->accounts_email->HrefValue = "";
			$this->accounts_email->TooltipValue = "";

			// accounts_phone
			$this->accounts_phone->LinkCustomAttributes = "";
			$this->accounts_phone->HrefValue = "";
			$this->accounts_phone->TooltipValue = "";

			// warehouse_incharge
			$this->warehouse_incharge->LinkCustomAttributes = "";
			$this->warehouse_incharge->HrefValue = "";
			$this->warehouse_incharge->TooltipValue = "";

			// warehouse_email
			$this->warehouse_email->LinkCustomAttributes = "";
			$this->warehouse_email->HrefValue = "";
			$this->warehouse_email->TooltipValue = "";

			// warehouse_phone
			$this->warehouse_phone->LinkCustomAttributes = "";
			$this->warehouse_phone->HrefValue = "";
			$this->warehouse_phone->TooltipValue = "";

			// production_incharge
			$this->production_incharge->LinkCustomAttributes = "";
			$this->production_incharge->HrefValue = "";
			$this->production_incharge->TooltipValue = "";

			// production_email
			$this->production_email->LinkCustomAttributes = "";
			$this->production_email->HrefValue = "";
			$this->production_email->TooltipValue = "";

			// production_phone
			$this->production_phone->LinkCustomAttributes = "";
			$this->production_phone->HrefValue = "";
			$this->production_phone->TooltipValue = "";

			// qc_incharge
			$this->qc_incharge->LinkCustomAttributes = "";
			$this->qc_incharge->HrefValue = "";
			$this->qc_incharge->TooltipValue = "";

			// qc_email
			$this->qc_email->LinkCustomAttributes = "";
			$this->qc_email->HrefValue = "";
			$this->qc_email->TooltipValue = "";

			// qc_phone
			$this->qc_phone->LinkCustomAttributes = "";
			$this->qc_phone->HrefValue = "";
			$this->qc_phone->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
			$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
			$this->code->EditValue = HtmlEncode($this->code->CurrentValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// country
			$this->country->EditAttrs["class"] = "form-control";
			$this->country->EditCustomAttributes = "";
			$curVal = trim(strval($this->country->CurrentValue));
			if ($curVal <> "")
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
			else
				$this->country->ViewValue = $this->country->Lookup !== NULL && is_array($this->country->Lookup->Options) ? $curVal : NULL;
			if ($this->country->ViewValue !== NULL) { // Load from cache
				$this->country->EditValue = array_values($this->country->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->country->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->country->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->country->EditValue = $arwrk;
			}

			// region
			$this->region->EditAttrs["class"] = "form-control";
			$this->region->EditCustomAttributes = "";
			$curVal = trim(strval($this->region->CurrentValue));
			if ($curVal <> "")
				$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
			else
				$this->region->ViewValue = $this->region->Lookup !== NULL && is_array($this->region->Lookup->Options) ? $curVal : NULL;
			if ($this->region->ViewValue !== NULL) { // Load from cache
				$this->region->EditValue = array_values($this->region->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->region->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->region->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->region->EditValue = $arwrk;
			}

			// city
			$this->city->EditAttrs["class"] = "form-control";
			$this->city->EditCustomAttributes = "";
			$this->city->EditValue = HtmlEncode($this->city->CurrentValue);
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->EditValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->city->EditValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->EditValue = HtmlEncode($this->city->CurrentValue);
					}
				}
			} else {
				$this->city->EditValue = NULL;
			}
			$this->city->PlaceHolder = RemoveHtml($this->city->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// url
			$this->url->EditAttrs["class"] = "form-control";
			$this->url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
			$this->url->EditValue = HtmlEncode($this->url->CurrentValue);
			$this->url->PlaceHolder = RemoveHtml($this->url->caption());

			// grp
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->CurrentValue));
			if ($curVal <> "")
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->CurrentValue));
			if ($curVal <> "")
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			// datetime
			// type

			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = $this->type->options(TRUE);

			// tax_registration
			$this->tax_registration->EditAttrs["class"] = "form-control";
			$this->tax_registration->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tax_registration->CurrentValue = HtmlDecode($this->tax_registration->CurrentValue);
			$this->tax_registration->EditValue = HtmlEncode($this->tax_registration->CurrentValue);
			$this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

			// cin
			$this->cin->EditAttrs["class"] = "form-control";
			$this->cin->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cin->CurrentValue = HtmlDecode($this->cin->CurrentValue);
			$this->cin->EditValue = HtmlEncode($this->cin->CurrentValue);
			$this->cin->PlaceHolder = RemoveHtml($this->cin->caption());

			// pan
			$this->pan->EditAttrs["class"] = "form-control";
			$this->pan->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan->CurrentValue = HtmlDecode($this->pan->CurrentValue);
			$this->pan->EditValue = HtmlEncode($this->pan->CurrentValue);
			$this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

			// tan
			$this->tan->EditAttrs["class"] = "form-control";
			$this->tan->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tan->CurrentValue = HtmlDecode($this->tan->CurrentValue);
			$this->tan->EditValue = HtmlEncode($this->tan->CurrentValue);
			$this->tan->PlaceHolder = RemoveHtml($this->tan->caption());

			// msme
			$this->msme->EditAttrs["class"] = "form-control";
			$this->msme->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->msme->CurrentValue = HtmlDecode($this->msme->CurrentValue);
			$this->msme->EditValue = HtmlEncode($this->msme->CurrentValue);
			$this->msme->PlaceHolder = RemoveHtml($this->msme->caption());

			// port_air
			$this->port_air->EditAttrs["class"] = "form-control";
			$this->port_air->EditCustomAttributes = "";
			$curVal = trim(strval($this->port_air->CurrentValue));
			if ($curVal <> "")
				$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
			else
				$this->port_air->ViewValue = $this->port_air->Lookup !== NULL && is_array($this->port_air->Lookup->Options) ? $curVal : NULL;
			if ($this->port_air->ViewValue !== NULL) { // Load from cache
				$this->port_air->EditValue = array_values($this->port_air->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->port_air->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`mode`=1 and status =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_air->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->port_air->EditValue = $arwrk;
			}

			// port_sea
			$this->port_sea->EditAttrs["class"] = "form-control";
			$this->port_sea->EditCustomAttributes = "";
			$curVal = trim(strval($this->port_sea->CurrentValue));
			if ($curVal <> "")
				$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
			else
				$this->port_sea->ViewValue = $this->port_sea->Lookup !== NULL && is_array($this->port_sea->Lookup->Options) ? $curVal : NULL;
			if ($this->port_sea->ViewValue !== NULL) { // Load from cache
				$this->port_sea->EditValue = array_values($this->port_sea->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->port_sea->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`mode`=0 and status =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_sea->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->port_sea->EditValue = $arwrk;
			}

			// iec
			$this->iec->EditAttrs["class"] = "form-control";
			$this->iec->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->iec->CurrentValue = HtmlDecode($this->iec->CurrentValue);
			$this->iec->EditValue = HtmlEncode($this->iec->CurrentValue);
			$this->iec->PlaceHolder = RemoveHtml($this->iec->caption());

			// rex
			$this->rex->EditAttrs["class"] = "form-control";
			$this->rex->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rex->CurrentValue = HtmlDecode($this->rex->CurrentValue);
			$this->rex->EditValue = HtmlEncode($this->rex->CurrentValue);
			$this->rex->PlaceHolder = RemoveHtml($this->rex->caption());

			// rcmc
			$this->rcmc->EditAttrs["class"] = "form-control";
			$this->rcmc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rcmc->CurrentValue = HtmlDecode($this->rcmc->CurrentValue);
			$this->rcmc->EditValue = HtmlEncode($this->rcmc->CurrentValue);
			$this->rcmc->PlaceHolder = RemoveHtml($this->rcmc->caption());

			// delivery_terms
			$this->delivery_terms->EditAttrs["class"] = "form-control";
			$this->delivery_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_terms->CurrentValue = HtmlDecode($this->delivery_terms->CurrentValue);
			$this->delivery_terms->EditValue = HtmlEncode($this->delivery_terms->CurrentValue);
			$this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

			// shipping_terms
			$this->shipping_terms->EditAttrs["class"] = "form-control";
			$this->shipping_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->shipping_terms->CurrentValue = HtmlDecode($this->shipping_terms->CurrentValue);
			$this->shipping_terms->EditValue = HtmlEncode($this->shipping_terms->CurrentValue);
			$this->shipping_terms->PlaceHolder = RemoveHtml($this->shipping_terms->caption());

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_terms->CurrentValue = HtmlDecode($this->payment_terms->CurrentValue);
			$this->payment_terms->EditValue = HtmlEncode($this->payment_terms->CurrentValue);
			$this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

			// export_type
			$this->export_type->EditAttrs["class"] = "form-control";
			$this->export_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->export_type->CurrentValue = HtmlDecode($this->export_type->CurrentValue);
			$this->export_type->EditValue = HtmlEncode($this->export_type->CurrentValue);
			$this->export_type->PlaceHolder = RemoveHtml($this->export_type->caption());

			// lead_time_ss
			$this->lead_time_ss->EditAttrs["class"] = "form-control";
			$this->lead_time_ss->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lead_time_ss->CurrentValue = HtmlDecode($this->lead_time_ss->CurrentValue);
			$this->lead_time_ss->EditValue = HtmlEncode($this->lead_time_ss->CurrentValue);
			$this->lead_time_ss->PlaceHolder = RemoveHtml($this->lead_time_ss->caption());

			// lead_time_cs
			$this->lead_time_cs->EditAttrs["class"] = "form-control";
			$this->lead_time_cs->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lead_time_cs->CurrentValue = HtmlDecode($this->lead_time_cs->CurrentValue);
			$this->lead_time_cs->EditValue = HtmlEncode($this->lead_time_cs->CurrentValue);
			$this->lead_time_cs->PlaceHolder = RemoveHtml($this->lead_time_cs->caption());

			// cha
			$this->cha->EditAttrs["class"] = "form-control";
			$this->cha->EditCustomAttributes = "";
			$this->cha->EditValue = HtmlEncode($this->cha->CurrentValue);
			$this->cha->PlaceHolder = RemoveHtml($this->cha->caption());

			// cha_email
			$this->cha_email->EditAttrs["class"] = "form-control";
			$this->cha_email->EditCustomAttributes = "";
			$this->cha_email->EditValue = HtmlEncode($this->cha_email->CurrentValue);
			$this->cha_email->PlaceHolder = RemoveHtml($this->cha_email->caption());

			// cha_phone
			$this->cha_phone->EditAttrs["class"] = "form-control";
			$this->cha_phone->EditCustomAttributes = "";
			$this->cha_phone->EditValue = HtmlEncode($this->cha_phone->CurrentValue);
			$this->cha_phone->PlaceHolder = RemoveHtml($this->cha_phone->caption());

			// forwarder
			$this->forwarder->EditAttrs["class"] = "form-control";
			$this->forwarder->EditCustomAttributes = "";
			$this->forwarder->EditValue = HtmlEncode($this->forwarder->CurrentValue);
			$this->forwarder->PlaceHolder = RemoveHtml($this->forwarder->caption());

			// forwarder_email
			$this->forwarder_email->EditAttrs["class"] = "form-control";
			$this->forwarder_email->EditCustomAttributes = "";
			$this->forwarder_email->EditValue = HtmlEncode($this->forwarder_email->CurrentValue);
			$this->forwarder_email->PlaceHolder = RemoveHtml($this->forwarder_email->caption());

			// forwarder_phone
			$this->forwarder_phone->EditAttrs["class"] = "form-control";
			$this->forwarder_phone->EditCustomAttributes = "";
			$this->forwarder_phone->EditValue = HtmlEncode($this->forwarder_phone->CurrentValue);
			$this->forwarder_phone->PlaceHolder = RemoveHtml($this->forwarder_phone->caption());

			// merchant
			$this->merchant->EditAttrs["class"] = "form-control";
			$this->merchant->EditCustomAttributes = "";
			$this->merchant->EditValue = HtmlEncode($this->merchant->CurrentValue);
			$this->merchant->PlaceHolder = RemoveHtml($this->merchant->caption());

			// merchant_email
			$this->merchant_email->EditAttrs["class"] = "form-control";
			$this->merchant_email->EditCustomAttributes = "";
			$this->merchant_email->EditValue = HtmlEncode($this->merchant_email->CurrentValue);
			$this->merchant_email->PlaceHolder = RemoveHtml($this->merchant_email->caption());

			// merchant_phone
			$this->merchant_phone->EditAttrs["class"] = "form-control";
			$this->merchant_phone->EditCustomAttributes = "";
			$this->merchant_phone->EditValue = HtmlEncode($this->merchant_phone->CurrentValue);
			$this->merchant_phone->PlaceHolder = RemoveHtml($this->merchant_phone->caption());

			// shipping_incharge
			$this->shipping_incharge->EditAttrs["class"] = "form-control";
			$this->shipping_incharge->EditCustomAttributes = "";
			$this->shipping_incharge->EditValue = HtmlEncode($this->shipping_incharge->CurrentValue);
			$this->shipping_incharge->PlaceHolder = RemoveHtml($this->shipping_incharge->caption());

			// shipping_email
			$this->shipping_email->EditAttrs["class"] = "form-control";
			$this->shipping_email->EditCustomAttributes = "";
			$this->shipping_email->EditValue = HtmlEncode($this->shipping_email->CurrentValue);
			$this->shipping_email->PlaceHolder = RemoveHtml($this->shipping_email->caption());

			// shipping_phone
			$this->shipping_phone->EditAttrs["class"] = "form-control";
			$this->shipping_phone->EditCustomAttributes = "";
			$this->shipping_phone->EditValue = HtmlEncode($this->shipping_phone->CurrentValue);
			$this->shipping_phone->PlaceHolder = RemoveHtml($this->shipping_phone->caption());

			// account_incharge
			$this->account_incharge->EditAttrs["class"] = "form-control";
			$this->account_incharge->EditCustomAttributes = "";
			$this->account_incharge->EditValue = HtmlEncode($this->account_incharge->CurrentValue);
			$this->account_incharge->PlaceHolder = RemoveHtml($this->account_incharge->caption());

			// accounts_email
			$this->accounts_email->EditAttrs["class"] = "form-control";
			$this->accounts_email->EditCustomAttributes = "";
			$this->accounts_email->EditValue = HtmlEncode($this->accounts_email->CurrentValue);
			$this->accounts_email->PlaceHolder = RemoveHtml($this->accounts_email->caption());

			// accounts_phone
			$this->accounts_phone->EditAttrs["class"] = "form-control";
			$this->accounts_phone->EditCustomAttributes = "";
			$this->accounts_phone->EditValue = HtmlEncode($this->accounts_phone->CurrentValue);
			$this->accounts_phone->PlaceHolder = RemoveHtml($this->accounts_phone->caption());

			// warehouse_incharge
			$this->warehouse_incharge->EditAttrs["class"] = "form-control";
			$this->warehouse_incharge->EditCustomAttributes = "";
			$this->warehouse_incharge->EditValue = HtmlEncode($this->warehouse_incharge->CurrentValue);
			$this->warehouse_incharge->PlaceHolder = RemoveHtml($this->warehouse_incharge->caption());

			// warehouse_email
			$this->warehouse_email->EditAttrs["class"] = "form-control";
			$this->warehouse_email->EditCustomAttributes = "";
			$this->warehouse_email->EditValue = HtmlEncode($this->warehouse_email->CurrentValue);
			$this->warehouse_email->PlaceHolder = RemoveHtml($this->warehouse_email->caption());

			// warehouse_phone
			$this->warehouse_phone->EditAttrs["class"] = "form-control";
			$this->warehouse_phone->EditCustomAttributes = "";
			$this->warehouse_phone->EditValue = HtmlEncode($this->warehouse_phone->CurrentValue);
			$this->warehouse_phone->PlaceHolder = RemoveHtml($this->warehouse_phone->caption());

			// production_incharge
			$this->production_incharge->EditAttrs["class"] = "form-control";
			$this->production_incharge->EditCustomAttributes = "";
			$this->production_incharge->EditValue = HtmlEncode($this->production_incharge->CurrentValue);
			$this->production_incharge->PlaceHolder = RemoveHtml($this->production_incharge->caption());

			// production_email
			$this->production_email->EditAttrs["class"] = "form-control";
			$this->production_email->EditCustomAttributes = "";
			$this->production_email->EditValue = HtmlEncode($this->production_email->CurrentValue);
			$this->production_email->PlaceHolder = RemoveHtml($this->production_email->caption());

			// production_phone
			$this->production_phone->EditAttrs["class"] = "form-control";
			$this->production_phone->EditCustomAttributes = "";
			$this->production_phone->EditValue = HtmlEncode($this->production_phone->CurrentValue);
			$this->production_phone->PlaceHolder = RemoveHtml($this->production_phone->caption());

			// qc_incharge
			$this->qc_incharge->EditAttrs["class"] = "form-control";
			$this->qc_incharge->EditCustomAttributes = "";
			$this->qc_incharge->EditValue = HtmlEncode($this->qc_incharge->CurrentValue);
			$this->qc_incharge->PlaceHolder = RemoveHtml($this->qc_incharge->caption());

			// qc_email
			$this->qc_email->EditAttrs["class"] = "form-control";
			$this->qc_email->EditCustomAttributes = "";
			$this->qc_email->EditValue = HtmlEncode($this->qc_email->CurrentValue);
			$this->qc_email->PlaceHolder = RemoveHtml($this->qc_email->caption());

			// qc_phone
			$this->qc_phone->EditAttrs["class"] = "form-control";
			$this->qc_phone->EditCustomAttributes = "";
			$this->qc_phone->EditValue = HtmlEncode($this->qc_phone->CurrentValue);
			$this->qc_phone->PlaceHolder = RemoveHtml($this->qc_phone->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";

			// region
			$this->region->LinkCustomAttributes = "";
			$this->region->HrefValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";

			// tax_registration
			$this->tax_registration->LinkCustomAttributes = "";
			$this->tax_registration->HrefValue = "";

			// cin
			$this->cin->LinkCustomAttributes = "";
			$this->cin->HrefValue = "";

			// pan
			$this->pan->LinkCustomAttributes = "";
			$this->pan->HrefValue = "";

			// tan
			$this->tan->LinkCustomAttributes = "";
			$this->tan->HrefValue = "";

			// msme
			$this->msme->LinkCustomAttributes = "";
			$this->msme->HrefValue = "";

			// port_air
			$this->port_air->LinkCustomAttributes = "";
			$this->port_air->HrefValue = "";

			// port_sea
			$this->port_sea->LinkCustomAttributes = "";
			$this->port_sea->HrefValue = "";

			// iec
			$this->iec->LinkCustomAttributes = "";
			$this->iec->HrefValue = "";

			// rex
			$this->rex->LinkCustomAttributes = "";
			$this->rex->HrefValue = "";

			// rcmc
			$this->rcmc->LinkCustomAttributes = "";
			$this->rcmc->HrefValue = "";

			// delivery_terms
			$this->delivery_terms->LinkCustomAttributes = "";
			$this->delivery_terms->HrefValue = "";

			// shipping_terms
			$this->shipping_terms->LinkCustomAttributes = "";
			$this->shipping_terms->HrefValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";

			// export_type
			$this->export_type->LinkCustomAttributes = "";
			$this->export_type->HrefValue = "";

			// lead_time_ss
			$this->lead_time_ss->LinkCustomAttributes = "";
			$this->lead_time_ss->HrefValue = "";

			// lead_time_cs
			$this->lead_time_cs->LinkCustomAttributes = "";
			$this->lead_time_cs->HrefValue = "";

			// cha
			$this->cha->LinkCustomAttributes = "";
			$this->cha->HrefValue = "";

			// cha_email
			$this->cha_email->LinkCustomAttributes = "";
			$this->cha_email->HrefValue = "";

			// cha_phone
			$this->cha_phone->LinkCustomAttributes = "";
			$this->cha_phone->HrefValue = "";

			// forwarder
			$this->forwarder->LinkCustomAttributes = "";
			$this->forwarder->HrefValue = "";

			// forwarder_email
			$this->forwarder_email->LinkCustomAttributes = "";
			$this->forwarder_email->HrefValue = "";

			// forwarder_phone
			$this->forwarder_phone->LinkCustomAttributes = "";
			$this->forwarder_phone->HrefValue = "";

			// merchant
			$this->merchant->LinkCustomAttributes = "";
			$this->merchant->HrefValue = "";

			// merchant_email
			$this->merchant_email->LinkCustomAttributes = "";
			$this->merchant_email->HrefValue = "";

			// merchant_phone
			$this->merchant_phone->LinkCustomAttributes = "";
			$this->merchant_phone->HrefValue = "";

			// shipping_incharge
			$this->shipping_incharge->LinkCustomAttributes = "";
			$this->shipping_incharge->HrefValue = "";

			// shipping_email
			$this->shipping_email->LinkCustomAttributes = "";
			$this->shipping_email->HrefValue = "";

			// shipping_phone
			$this->shipping_phone->LinkCustomAttributes = "";
			$this->shipping_phone->HrefValue = "";

			// account_incharge
			$this->account_incharge->LinkCustomAttributes = "";
			$this->account_incharge->HrefValue = "";

			// accounts_email
			$this->accounts_email->LinkCustomAttributes = "";
			$this->accounts_email->HrefValue = "";

			// accounts_phone
			$this->accounts_phone->LinkCustomAttributes = "";
			$this->accounts_phone->HrefValue = "";

			// warehouse_incharge
			$this->warehouse_incharge->LinkCustomAttributes = "";
			$this->warehouse_incharge->HrefValue = "";

			// warehouse_email
			$this->warehouse_email->LinkCustomAttributes = "";
			$this->warehouse_email->HrefValue = "";

			// warehouse_phone
			$this->warehouse_phone->LinkCustomAttributes = "";
			$this->warehouse_phone->HrefValue = "";

			// production_incharge
			$this->production_incharge->LinkCustomAttributes = "";
			$this->production_incharge->HrefValue = "";

			// production_email
			$this->production_email->LinkCustomAttributes = "";
			$this->production_email->HrefValue = "";

			// production_phone
			$this->production_phone->LinkCustomAttributes = "";
			$this->production_phone->HrefValue = "";

			// qc_incharge
			$this->qc_incharge->LinkCustomAttributes = "";
			$this->qc_incharge->HrefValue = "";

			// qc_email
			$this->qc_email->LinkCustomAttributes = "";
			$this->qc_email->HrefValue = "";

			// qc_phone
			$this->qc_phone->LinkCustomAttributes = "";
			$this->qc_phone->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id->FormValue)) {
			AddMessage($FormError, $this->id->errorMessage());
		}
		if ($this->name->Required) {
			if (!$this->name->IsDetailKey && $this->name->FormValue != NULL && $this->name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
			}
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->country->Required) {
			if (!$this->country->IsDetailKey && $this->country->FormValue != NULL && $this->country->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
			}
		}
		if ($this->region->Required) {
			if (!$this->region->IsDetailKey && $this->region->FormValue != NULL && $this->region->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->region->caption(), $this->region->RequiredErrorMessage));
			}
		}
		if ($this->city->Required) {
			if (!$this->city->IsDetailKey && $this->city->FormValue != NULL && $this->city->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
			}
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if ($this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->performance->Required) {
			if (!$this->performance->IsDetailKey && $this->performance->FormValue != NULL && $this->performance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->performance->caption(), $this->performance->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->tax_registration->Required) {
			if (!$this->tax_registration->IsDetailKey && $this->tax_registration->FormValue != NULL && $this->tax_registration->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax_registration->caption(), $this->tax_registration->RequiredErrorMessage));
			}
		}
		if ($this->cin->Required) {
			if (!$this->cin->IsDetailKey && $this->cin->FormValue != NULL && $this->cin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cin->caption(), $this->cin->RequiredErrorMessage));
			}
		}
		if ($this->pan->Required) {
			if (!$this->pan->IsDetailKey && $this->pan->FormValue != NULL && $this->pan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan->caption(), $this->pan->RequiredErrorMessage));
			}
		}
		if ($this->tan->Required) {
			if (!$this->tan->IsDetailKey && $this->tan->FormValue != NULL && $this->tan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tan->caption(), $this->tan->RequiredErrorMessage));
			}
		}
		if ($this->msme->Required) {
			if (!$this->msme->IsDetailKey && $this->msme->FormValue != NULL && $this->msme->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->msme->caption(), $this->msme->RequiredErrorMessage));
			}
		}
		if ($this->incoterm->Required) {
			if ($this->incoterm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->incoterm->caption(), $this->incoterm->RequiredErrorMessage));
			}
		}
		if ($this->port_air->Required) {
			if (!$this->port_air->IsDetailKey && $this->port_air->FormValue != NULL && $this->port_air->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_air->caption(), $this->port_air->RequiredErrorMessage));
			}
		}
		if ($this->port_sea->Required) {
			if (!$this->port_sea->IsDetailKey && $this->port_sea->FormValue != NULL && $this->port_sea->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_sea->caption(), $this->port_sea->RequiredErrorMessage));
			}
		}
		if ($this->iec->Required) {
			if (!$this->iec->IsDetailKey && $this->iec->FormValue != NULL && $this->iec->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->iec->caption(), $this->iec->RequiredErrorMessage));
			}
		}
		if ($this->rex->Required) {
			if (!$this->rex->IsDetailKey && $this->rex->FormValue != NULL && $this->rex->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rex->caption(), $this->rex->RequiredErrorMessage));
			}
		}
		if ($this->rcmc->Required) {
			if (!$this->rcmc->IsDetailKey && $this->rcmc->FormValue != NULL && $this->rcmc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rcmc->caption(), $this->rcmc->RequiredErrorMessage));
			}
		}
		if ($this->delivery_terms->Required) {
			if (!$this->delivery_terms->IsDetailKey && $this->delivery_terms->FormValue != NULL && $this->delivery_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_terms->caption(), $this->delivery_terms->RequiredErrorMessage));
			}
		}
		if ($this->shipping_terms->Required) {
			if (!$this->shipping_terms->IsDetailKey && $this->shipping_terms->FormValue != NULL && $this->shipping_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_terms->caption(), $this->shipping_terms->RequiredErrorMessage));
			}
		}
		if ($this->payment_terms->Required) {
			if (!$this->payment_terms->IsDetailKey && $this->payment_terms->FormValue != NULL && $this->payment_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
			}
		}
		if ($this->export_type->Required) {
			if (!$this->export_type->IsDetailKey && $this->export_type->FormValue != NULL && $this->export_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->export_type->caption(), $this->export_type->RequiredErrorMessage));
			}
		}
		if ($this->lead_time_ss->Required) {
			if (!$this->lead_time_ss->IsDetailKey && $this->lead_time_ss->FormValue != NULL && $this->lead_time_ss->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lead_time_ss->caption(), $this->lead_time_ss->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->lead_time_ss->FormValue)) {
			AddMessage($FormError, $this->lead_time_ss->errorMessage());
		}
		if ($this->lead_time_cs->Required) {
			if (!$this->lead_time_cs->IsDetailKey && $this->lead_time_cs->FormValue != NULL && $this->lead_time_cs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lead_time_cs->caption(), $this->lead_time_cs->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->lead_time_cs->FormValue)) {
			AddMessage($FormError, $this->lead_time_cs->errorMessage());
		}
		if ($this->cha->Required) {
			if (!$this->cha->IsDetailKey && $this->cha->FormValue != NULL && $this->cha->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cha->caption(), $this->cha->RequiredErrorMessage));
			}
		}
		if ($this->cha_email->Required) {
			if (!$this->cha_email->IsDetailKey && $this->cha_email->FormValue != NULL && $this->cha_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cha_email->caption(), $this->cha_email->RequiredErrorMessage));
			}
		}
		if ($this->cha_phone->Required) {
			if (!$this->cha_phone->IsDetailKey && $this->cha_phone->FormValue != NULL && $this->cha_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cha_phone->caption(), $this->cha_phone->RequiredErrorMessage));
			}
		}
		if ($this->forwarder->Required) {
			if (!$this->forwarder->IsDetailKey && $this->forwarder->FormValue != NULL && $this->forwarder->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->forwarder->caption(), $this->forwarder->RequiredErrorMessage));
			}
		}
		if ($this->forwarder_email->Required) {
			if (!$this->forwarder_email->IsDetailKey && $this->forwarder_email->FormValue != NULL && $this->forwarder_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->forwarder_email->caption(), $this->forwarder_email->RequiredErrorMessage));
			}
		}
		if ($this->forwarder_phone->Required) {
			if (!$this->forwarder_phone->IsDetailKey && $this->forwarder_phone->FormValue != NULL && $this->forwarder_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->forwarder_phone->caption(), $this->forwarder_phone->RequiredErrorMessage));
			}
		}
		if ($this->merchant->Required) {
			if (!$this->merchant->IsDetailKey && $this->merchant->FormValue != NULL && $this->merchant->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->merchant->caption(), $this->merchant->RequiredErrorMessage));
			}
		}
		if ($this->merchant_email->Required) {
			if (!$this->merchant_email->IsDetailKey && $this->merchant_email->FormValue != NULL && $this->merchant_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->merchant_email->caption(), $this->merchant_email->RequiredErrorMessage));
			}
		}
		if ($this->merchant_phone->Required) {
			if (!$this->merchant_phone->IsDetailKey && $this->merchant_phone->FormValue != NULL && $this->merchant_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->merchant_phone->caption(), $this->merchant_phone->RequiredErrorMessage));
			}
		}
		if ($this->shipping_incharge->Required) {
			if (!$this->shipping_incharge->IsDetailKey && $this->shipping_incharge->FormValue != NULL && $this->shipping_incharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_incharge->caption(), $this->shipping_incharge->RequiredErrorMessage));
			}
		}
		if ($this->shipping_email->Required) {
			if (!$this->shipping_email->IsDetailKey && $this->shipping_email->FormValue != NULL && $this->shipping_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_email->caption(), $this->shipping_email->RequiredErrorMessage));
			}
		}
		if ($this->shipping_phone->Required) {
			if (!$this->shipping_phone->IsDetailKey && $this->shipping_phone->FormValue != NULL && $this->shipping_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_phone->caption(), $this->shipping_phone->RequiredErrorMessage));
			}
		}
		if ($this->account_incharge->Required) {
			if (!$this->account_incharge->IsDetailKey && $this->account_incharge->FormValue != NULL && $this->account_incharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->account_incharge->caption(), $this->account_incharge->RequiredErrorMessage));
			}
		}
		if ($this->accounts_email->Required) {
			if (!$this->accounts_email->IsDetailKey && $this->accounts_email->FormValue != NULL && $this->accounts_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->accounts_email->caption(), $this->accounts_email->RequiredErrorMessage));
			}
		}
		if ($this->accounts_phone->Required) {
			if (!$this->accounts_phone->IsDetailKey && $this->accounts_phone->FormValue != NULL && $this->accounts_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->accounts_phone->caption(), $this->accounts_phone->RequiredErrorMessage));
			}
		}
		if ($this->warehouse_incharge->Required) {
			if (!$this->warehouse_incharge->IsDetailKey && $this->warehouse_incharge->FormValue != NULL && $this->warehouse_incharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->warehouse_incharge->caption(), $this->warehouse_incharge->RequiredErrorMessage));
			}
		}
		if ($this->warehouse_email->Required) {
			if (!$this->warehouse_email->IsDetailKey && $this->warehouse_email->FormValue != NULL && $this->warehouse_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->warehouse_email->caption(), $this->warehouse_email->RequiredErrorMessage));
			}
		}
		if ($this->warehouse_phone->Required) {
			if (!$this->warehouse_phone->IsDetailKey && $this->warehouse_phone->FormValue != NULL && $this->warehouse_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->warehouse_phone->caption(), $this->warehouse_phone->RequiredErrorMessage));
			}
		}
		if ($this->production_incharge->Required) {
			if (!$this->production_incharge->IsDetailKey && $this->production_incharge->FormValue != NULL && $this->production_incharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_incharge->caption(), $this->production_incharge->RequiredErrorMessage));
			}
		}
		if ($this->production_email->Required) {
			if (!$this->production_email->IsDetailKey && $this->production_email->FormValue != NULL && $this->production_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_email->caption(), $this->production_email->RequiredErrorMessage));
			}
		}
		if ($this->production_phone->Required) {
			if (!$this->production_phone->IsDetailKey && $this->production_phone->FormValue != NULL && $this->production_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_phone->caption(), $this->production_phone->RequiredErrorMessage));
			}
		}
		if ($this->qc_incharge->Required) {
			if (!$this->qc_incharge->IsDetailKey && $this->qc_incharge->FormValue != NULL && $this->qc_incharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_incharge->caption(), $this->qc_incharge->RequiredErrorMessage));
			}
		}
		if ($this->qc_email->Required) {
			if (!$this->qc_email->IsDetailKey && $this->qc_email->FormValue != NULL && $this->qc_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_email->caption(), $this->qc_email->RequiredErrorMessage));
			}
		}
		if ($this->qc_phone->Required) {
			if (!$this->qc_phone->IsDetailKey && $this->qc_phone->FormValue != NULL && $this->qc_phone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_phone->caption(), $this->qc_phone->RequiredErrorMessage));
			}
		}
		if ($this->uid->Required) {
			if (!$this->uid->IsDetailKey && $this->uid->FormValue != NULL && $this->uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
			}
		}
		if ($this->r_text->Required) {
			if (!$this->r_text->IsDetailKey && $this->r_text->FormValue != NULL && $this->r_text->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_text->caption(), $this->r_text->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("shipping_address", $detailTblVar) && $GLOBALS["shipping_address"]->DetailEdit) {
			if (!isset($GLOBALS["shipping_address_grid"]))
				$GLOBALS["shipping_address_grid"] = new shipping_address_grid(); // Get detail page object
			$GLOBALS["shipping_address_grid"]->validateGridForm();
		}
		if (in_array("_bank_info", $detailTblVar) && $GLOBALS["_bank_info"]->DetailEdit) {
			if (!isset($GLOBALS["_bank_info_grid"]))
				$GLOBALS["_bank_info_grid"] = new _bank_info_grid(); // Get detail page object
			$GLOBALS["_bank_info_grid"]->validateGridForm();
		}
		if (in_array("capacity_plan", $detailTblVar) && $GLOBALS["capacity_plan"]->DetailEdit) {
			if (!isset($GLOBALS["capacity_plan_grid"]))
				$GLOBALS["capacity_plan_grid"] = new capacity_plan_grid(); // Get detail page object
			$GLOBALS["capacity_plan_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->code->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`code` = '" . AdjustSql($this->code->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->code->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->code->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() <> "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// name
			$this->name->setDbValueDef($rsnew, $this->name->CurrentValue, "", $this->name->ReadOnly);

			// code
			$this->code->setDbValueDef($rsnew, $this->code->CurrentValue, NULL, $this->code->ReadOnly);

			// country
			$this->country->setDbValueDef($rsnew, $this->country->CurrentValue, NULL, $this->country->ReadOnly);

			// region
			$this->region->setDbValueDef($rsnew, $this->region->CurrentValue, NULL, $this->region->ReadOnly);

			// city
			$this->city->setDbValueDef($rsnew, $this->city->CurrentValue, NULL, $this->city->ReadOnly);

			// address
			$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, NULL, $this->address->ReadOnly);

			// mobile
			$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, $this->mobile->ReadOnly);

			// email
			$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, $this->_email->ReadOnly);

			// url
			$this->url->setDbValueDef($rsnew, $this->url->CurrentValue, NULL, $this->url->ReadOnly);

			// grp
			$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, $this->grp->ReadOnly);

			// category
			$this->category->setDbValueDef($rsnew, $this->category->CurrentValue, 0, $this->category->ReadOnly);

			// reports_to
			$this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, 0, $this->reports_to->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, $this->status->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// type
			$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, 0, $this->type->ReadOnly);

			// tax_registration
			$this->tax_registration->setDbValueDef($rsnew, $this->tax_registration->CurrentValue, NULL, $this->tax_registration->ReadOnly);

			// cin
			$this->cin->setDbValueDef($rsnew, $this->cin->CurrentValue, NULL, $this->cin->ReadOnly);

			// pan
			$this->pan->setDbValueDef($rsnew, $this->pan->CurrentValue, NULL, $this->pan->ReadOnly);

			// tan
			$this->tan->setDbValueDef($rsnew, $this->tan->CurrentValue, NULL, $this->tan->ReadOnly);

			// msme
			$this->msme->setDbValueDef($rsnew, $this->msme->CurrentValue, NULL, $this->msme->ReadOnly);

			// port_air
			$this->port_air->setDbValueDef($rsnew, $this->port_air->CurrentValue, NULL, $this->port_air->ReadOnly);

			// port_sea
			$this->port_sea->setDbValueDef($rsnew, $this->port_sea->CurrentValue, NULL, $this->port_sea->ReadOnly);

			// iec
			$this->iec->setDbValueDef($rsnew, $this->iec->CurrentValue, NULL, $this->iec->ReadOnly);

			// rex
			$this->rex->setDbValueDef($rsnew, $this->rex->CurrentValue, NULL, $this->rex->ReadOnly);

			// rcmc
			$this->rcmc->setDbValueDef($rsnew, $this->rcmc->CurrentValue, NULL, $this->rcmc->ReadOnly);

			// delivery_terms
			$this->delivery_terms->setDbValueDef($rsnew, $this->delivery_terms->CurrentValue, NULL, $this->delivery_terms->ReadOnly);

			// shipping_terms
			$this->shipping_terms->setDbValueDef($rsnew, $this->shipping_terms->CurrentValue, NULL, $this->shipping_terms->ReadOnly);

			// payment_terms
			$this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, NULL, $this->payment_terms->ReadOnly);

			// export_type
			$this->export_type->setDbValueDef($rsnew, $this->export_type->CurrentValue, NULL, $this->export_type->ReadOnly);

			// lead_time_ss
			$this->lead_time_ss->setDbValueDef($rsnew, $this->lead_time_ss->CurrentValue, NULL, $this->lead_time_ss->ReadOnly);

			// lead_time_cs
			$this->lead_time_cs->setDbValueDef($rsnew, $this->lead_time_cs->CurrentValue, NULL, $this->lead_time_cs->ReadOnly);

			// cha
			$this->cha->setDbValueDef($rsnew, $this->cha->CurrentValue, NULL, $this->cha->ReadOnly);

			// cha_email
			$this->cha_email->setDbValueDef($rsnew, $this->cha_email->CurrentValue, NULL, $this->cha_email->ReadOnly);

			// cha_phone
			$this->cha_phone->setDbValueDef($rsnew, $this->cha_phone->CurrentValue, NULL, $this->cha_phone->ReadOnly);

			// forwarder
			$this->forwarder->setDbValueDef($rsnew, $this->forwarder->CurrentValue, NULL, $this->forwarder->ReadOnly);

			// forwarder_email
			$this->forwarder_email->setDbValueDef($rsnew, $this->forwarder_email->CurrentValue, NULL, $this->forwarder_email->ReadOnly);

			// forwarder_phone
			$this->forwarder_phone->setDbValueDef($rsnew, $this->forwarder_phone->CurrentValue, NULL, $this->forwarder_phone->ReadOnly);

			// merchant
			$this->merchant->setDbValueDef($rsnew, $this->merchant->CurrentValue, NULL, $this->merchant->ReadOnly);

			// merchant_email
			$this->merchant_email->setDbValueDef($rsnew, $this->merchant_email->CurrentValue, NULL, $this->merchant_email->ReadOnly);

			// merchant_phone
			$this->merchant_phone->setDbValueDef($rsnew, $this->merchant_phone->CurrentValue, NULL, $this->merchant_phone->ReadOnly);

			// shipping_incharge
			$this->shipping_incharge->setDbValueDef($rsnew, $this->shipping_incharge->CurrentValue, NULL, $this->shipping_incharge->ReadOnly);

			// shipping_email
			$this->shipping_email->setDbValueDef($rsnew, $this->shipping_email->CurrentValue, NULL, $this->shipping_email->ReadOnly);

			// shipping_phone
			$this->shipping_phone->setDbValueDef($rsnew, $this->shipping_phone->CurrentValue, NULL, $this->shipping_phone->ReadOnly);

			// account_incharge
			$this->account_incharge->setDbValueDef($rsnew, $this->account_incharge->CurrentValue, NULL, $this->account_incharge->ReadOnly);

			// accounts_email
			$this->accounts_email->setDbValueDef($rsnew, $this->accounts_email->CurrentValue, NULL, $this->accounts_email->ReadOnly);

			// accounts_phone
			$this->accounts_phone->setDbValueDef($rsnew, $this->accounts_phone->CurrentValue, NULL, $this->accounts_phone->ReadOnly);

			// warehouse_incharge
			$this->warehouse_incharge->setDbValueDef($rsnew, $this->warehouse_incharge->CurrentValue, NULL, $this->warehouse_incharge->ReadOnly);

			// warehouse_email
			$this->warehouse_email->setDbValueDef($rsnew, $this->warehouse_email->CurrentValue, NULL, $this->warehouse_email->ReadOnly);

			// warehouse_phone
			$this->warehouse_phone->setDbValueDef($rsnew, $this->warehouse_phone->CurrentValue, NULL, $this->warehouse_phone->ReadOnly);

			// production_incharge
			$this->production_incharge->setDbValueDef($rsnew, $this->production_incharge->CurrentValue, NULL, $this->production_incharge->ReadOnly);

			// production_email
			$this->production_email->setDbValueDef($rsnew, $this->production_email->CurrentValue, NULL, $this->production_email->ReadOnly);

			// production_phone
			$this->production_phone->setDbValueDef($rsnew, $this->production_phone->CurrentValue, NULL, $this->production_phone->ReadOnly);

			// qc_incharge
			$this->qc_incharge->setDbValueDef($rsnew, $this->qc_incharge->CurrentValue, NULL, $this->qc_incharge->ReadOnly);

			// qc_email
			$this->qc_email->setDbValueDef($rsnew, $this->qc_email->CurrentValue, NULL, $this->qc_email->ReadOnly);

			// qc_phone
			$this->qc_phone->setDbValueDef($rsnew, $this->qc_phone->CurrentValue, NULL, $this->qc_phone->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("shipping_address", $detailTblVar) && $GLOBALS["shipping_address"]->DetailEdit) {
						if (!isset($GLOBALS["shipping_address_grid"]))
							$GLOBALS["shipping_address_grid"] = new shipping_address_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "shipping_address"); // Load user level of detail table
						$editRow = $GLOBALS["shipping_address_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("_bank_info", $detailTblVar) && $GLOBALS["_bank_info"]->DetailEdit) {
						if (!isset($GLOBALS["_bank_info_grid"]))
							$GLOBALS["_bank_info_grid"] = new _bank_info_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "bank_info"); // Load user level of detail table
						$editRow = $GLOBALS["_bank_info_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("capacity_plan", $detailTblVar) && $GLOBALS["capacity_plan"]->DetailEdit) {
						if (!isset($GLOBALS["capacity_plan_grid"]))
							$GLOBALS["capacity_plan_grid"] = new capacity_plan_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "capacity_plan"); // Load user level of detail table
						$editRow = $GLOBALS["capacity_plan_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() <> "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("shipping_address", $detailTblVar)) {
				if (!isset($GLOBALS["shipping_address_grid"]))
					$GLOBALS["shipping_address_grid"] = new shipping_address_grid();
				if ($GLOBALS["shipping_address_grid"]->DetailEdit) {
					$GLOBALS["shipping_address_grid"]->CurrentMode = "edit";
					$GLOBALS["shipping_address_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["shipping_address_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["shipping_address_grid"]->setStartRecordNumber(1);
					$GLOBALS["shipping_address_grid"]->_userid->IsDetailKey = TRUE;
					$GLOBALS["shipping_address_grid"]->_userid->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["shipping_address_grid"]->_userid->setSessionValue($GLOBALS["shipping_address_grid"]->_userid->CurrentValue);
				}
			}
			if (in_array("_bank_info", $detailTblVar)) {
				if (!isset($GLOBALS["_bank_info_grid"]))
					$GLOBALS["_bank_info_grid"] = new _bank_info_grid();
				if ($GLOBALS["_bank_info_grid"]->DetailEdit) {
					$GLOBALS["_bank_info_grid"]->CurrentMode = "edit";
					$GLOBALS["_bank_info_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["_bank_info_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["_bank_info_grid"]->setStartRecordNumber(1);
					$GLOBALS["_bank_info_grid"]->user_id->IsDetailKey = TRUE;
					$GLOBALS["_bank_info_grid"]->user_id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["_bank_info_grid"]->user_id->setSessionValue($GLOBALS["_bank_info_grid"]->user_id->CurrentValue);
				}
			}
			if (in_array("capacity_plan", $detailTblVar)) {
				if (!isset($GLOBALS["capacity_plan_grid"]))
					$GLOBALS["capacity_plan_grid"] = new capacity_plan_grid();
				if ($GLOBALS["capacity_plan_grid"]->DetailEdit) {
					$GLOBALS["capacity_plan_grid"]->CurrentMode = "edit";
					$GLOBALS["capacity_plan_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["capacity_plan_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["capacity_plan_grid"]->setStartRecordNumber(1);
					$GLOBALS["capacity_plan_grid"]->user_id->IsDetailKey = TRUE;
					$GLOBALS["capacity_plan_grid"]->user_id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["capacity_plan_grid"]->user_id->setSessionValue($GLOBALS["capacity_plan_grid"]->user_id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("production_partnerlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$pages->add(8);
		$pages->add(9);
		$pages->add(10);
		$pages->add(11);
		$pages->add(12);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_air":
					$lookupFilter = function() {
						return "`mode`=1 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_sea":
					$lookupFilter = function() {
						return "`mode`=0 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_country":
							break;
						case "x_region":
							break;
						case "x_city":
							break;
						case "x_grp":
							break;
						case "x_category":
							break;
						case "x_reports_to":
							break;
						case "x_operator":
							break;
						case "x_incoterm":
							break;
						case "x_port_air":
							break;
						case "x_port_sea":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'production_partner');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>