<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class production_partner_search extends production_partner
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'production_partner';

	// Page object name
	public $PageObjName = "production_partner_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (production_partner)
		if (!isset($GLOBALS["production_partner"]) || get_class($GLOBALS["production_partner"]) == PROJECT_NAMESPACE . "production_partner") {
			$GLOBALS["production_partner"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["production_partner"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $production_partner;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($production_partner);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "production_partnerview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("production_partnerlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->name->setVisibility();
		$this->code->setVisibility();
		$this->country->setVisibility();
		$this->region->setVisibility();
		$this->city->setVisibility();
		$this->address->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->url->setVisibility();
		$this->grp->setVisibility();
		$this->category->setVisibility();
		$this->reports_to->setVisibility();
		$this->status->setVisibility();
		$this->performance->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->type->Visible = FALSE;
		$this->tax_registration->setVisibility();
		$this->cin->setVisibility();
		$this->pan->setVisibility();
		$this->tan->setVisibility();
		$this->msme->setVisibility();
		$this->incoterm->Visible = FALSE;
		$this->port_air->Visible = FALSE;
		$this->port_sea->Visible = FALSE;
		$this->iec->setVisibility();
		$this->rex->setVisibility();
		$this->rcmc->setVisibility();
		$this->delivery_terms->setVisibility();
		$this->shipping_terms->setVisibility();
		$this->payment_terms->setVisibility();
		$this->export_type->setVisibility();
		$this->lead_time_ss->setVisibility();
		$this->lead_time_cs->setVisibility();
		$this->cha->setVisibility();
		$this->cha_email->setVisibility();
		$this->cha_phone->setVisibility();
		$this->forwarder->setVisibility();
		$this->forwarder_email->setVisibility();
		$this->forwarder_phone->setVisibility();
		$this->merchant->setVisibility();
		$this->merchant_email->setVisibility();
		$this->merchant_phone->setVisibility();
		$this->shipping_incharge->setVisibility();
		$this->shipping_email->setVisibility();
		$this->shipping_phone->setVisibility();
		$this->account_incharge->setVisibility();
		$this->accounts_email->setVisibility();
		$this->accounts_phone->setVisibility();
		$this->warehouse_incharge->setVisibility();
		$this->warehouse_email->setVisibility();
		$this->warehouse_phone->setVisibility();
		$this->production_incharge->setVisibility();
		$this->production_email->setVisibility();
		$this->production_phone->setVisibility();
		$this->qc_incharge->setVisibility();
		$this->qc_email->setVisibility();
		$this->qc_phone->setVisibility();
		$this->uid->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->country);
		$this->setupLookupOptions($this->region);
		$this->setupLookupOptions($this->city);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->incoterm);
		$this->setupLookupOptions($this->port_air);
		$this->setupLookupOptions($this->port_sea);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "production_partnerlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->name); // name
		$this->buildSearchUrl($srchUrl, $this->code); // code
		$this->buildSearchUrl($srchUrl, $this->country); // country
		$this->buildSearchUrl($srchUrl, $this->region); // region
		$this->buildSearchUrl($srchUrl, $this->city); // city
		$this->buildSearchUrl($srchUrl, $this->address); // address
		$this->buildSearchUrl($srchUrl, $this->mobile); // mobile
		$this->buildSearchUrl($srchUrl, $this->_email); // email
		$this->buildSearchUrl($srchUrl, $this->url); // url
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->category); // category
		$this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->performance); // performance
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->tax_registration); // tax_registration
		$this->buildSearchUrl($srchUrl, $this->cin); // cin
		$this->buildSearchUrl($srchUrl, $this->pan); // pan
		$this->buildSearchUrl($srchUrl, $this->tan); // tan
		$this->buildSearchUrl($srchUrl, $this->msme); // msme
		$this->buildSearchUrl($srchUrl, $this->iec); // iec
		$this->buildSearchUrl($srchUrl, $this->rex); // rex
		$this->buildSearchUrl($srchUrl, $this->rcmc); // rcmc
		$this->buildSearchUrl($srchUrl, $this->delivery_terms); // delivery_terms
		$this->buildSearchUrl($srchUrl, $this->shipping_terms); // shipping_terms
		$this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
		$this->buildSearchUrl($srchUrl, $this->export_type); // export_type
		$this->buildSearchUrl($srchUrl, $this->lead_time_ss); // lead_time_ss
		$this->buildSearchUrl($srchUrl, $this->lead_time_cs); // lead_time_cs
		$this->buildSearchUrl($srchUrl, $this->cha); // cha
		$this->buildSearchUrl($srchUrl, $this->cha_email); // cha_email
		$this->buildSearchUrl($srchUrl, $this->cha_phone); // cha_phone
		$this->buildSearchUrl($srchUrl, $this->forwarder); // forwarder
		$this->buildSearchUrl($srchUrl, $this->forwarder_email); // forwarder_email
		$this->buildSearchUrl($srchUrl, $this->forwarder_phone); // forwarder_phone
		$this->buildSearchUrl($srchUrl, $this->merchant); // merchant
		$this->buildSearchUrl($srchUrl, $this->merchant_email); // merchant_email
		$this->buildSearchUrl($srchUrl, $this->merchant_phone); // merchant_phone
		$this->buildSearchUrl($srchUrl, $this->shipping_incharge); // shipping_incharge
		$this->buildSearchUrl($srchUrl, $this->shipping_email); // shipping_email
		$this->buildSearchUrl($srchUrl, $this->shipping_phone); // shipping_phone
		$this->buildSearchUrl($srchUrl, $this->account_incharge); // account_incharge
		$this->buildSearchUrl($srchUrl, $this->accounts_email); // accounts_email
		$this->buildSearchUrl($srchUrl, $this->accounts_phone); // accounts_phone
		$this->buildSearchUrl($srchUrl, $this->warehouse_incharge); // warehouse_incharge
		$this->buildSearchUrl($srchUrl, $this->warehouse_email); // warehouse_email
		$this->buildSearchUrl($srchUrl, $this->warehouse_phone); // warehouse_phone
		$this->buildSearchUrl($srchUrl, $this->production_incharge); // production_incharge
		$this->buildSearchUrl($srchUrl, $this->production_email); // production_email
		$this->buildSearchUrl($srchUrl, $this->production_phone); // production_phone
		$this->buildSearchUrl($srchUrl, $this->qc_incharge); // qc_incharge
		$this->buildSearchUrl($srchUrl, $this->qc_email); // qc_email
		$this->buildSearchUrl($srchUrl, $this->qc_phone); // qc_phone
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// name
		if (!$this->isAddOrEdit())
			$this->name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_name"));
		$this->name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_name"));

		// code
		if (!$this->isAddOrEdit())
			$this->code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_code"));
		$this->code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_code"));

		// country
		if (!$this->isAddOrEdit())
			$this->country->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_country"));
		$this->country->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_country"));

		// region
		if (!$this->isAddOrEdit())
			$this->region->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_region"));
		$this->region->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_region"));

		// city
		if (!$this->isAddOrEdit())
			$this->city->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_city"));
		$this->city->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_city"));

		// address
		if (!$this->isAddOrEdit())
			$this->address->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_address"));
		$this->address->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_address"));

		// mobile
		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile"));
		$this->mobile->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile"));

		// email
		if (!$this->isAddOrEdit())
			$this->_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__email"));
		$this->_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__email"));

		// url
		if (!$this->isAddOrEdit())
			$this->url->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_url"));
		$this->url->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_url"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));
		if (is_array($this->grp->AdvancedSearch->SearchValue))
			$this->grp->AdvancedSearch->SearchValue = implode(",", $this->grp->AdvancedSearch->SearchValue);
		if (is_array($this->grp->AdvancedSearch->SearchValue2))
			$this->grp->AdvancedSearch->SearchValue2 = implode(",", $this->grp->AdvancedSearch->SearchValue2);

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));

		// reports_to
		if (!$this->isAddOrEdit())
			$this->reports_to->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_reports_to"));
		$this->reports_to->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_reports_to"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// performance
		if (!$this->isAddOrEdit())
			$this->performance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_performance"));
		$this->performance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_performance"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// tax_registration
		if (!$this->isAddOrEdit())
			$this->tax_registration->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_tax_registration"));
		$this->tax_registration->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_tax_registration"));

		// cin
		if (!$this->isAddOrEdit())
			$this->cin->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cin"));
		$this->cin->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cin"));

		// pan
		if (!$this->isAddOrEdit())
			$this->pan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pan"));
		$this->pan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pan"));

		// tan
		if (!$this->isAddOrEdit())
			$this->tan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_tan"));
		$this->tan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_tan"));

		// msme
		if (!$this->isAddOrEdit())
			$this->msme->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_msme"));
		$this->msme->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_msme"));

		// iec
		if (!$this->isAddOrEdit())
			$this->iec->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_iec"));
		$this->iec->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_iec"));

		// rex
		if (!$this->isAddOrEdit())
			$this->rex->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rex"));
		$this->rex->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rex"));

		// rcmc
		if (!$this->isAddOrEdit())
			$this->rcmc->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rcmc"));
		$this->rcmc->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rcmc"));

		// delivery_terms
		if (!$this->isAddOrEdit())
			$this->delivery_terms->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_delivery_terms"));
		$this->delivery_terms->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_delivery_terms"));

		// shipping_terms
		if (!$this->isAddOrEdit())
			$this->shipping_terms->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipping_terms"));
		$this->shipping_terms->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipping_terms"));

		// payment_terms
		if (!$this->isAddOrEdit())
			$this->payment_terms->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_terms"));
		$this->payment_terms->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_terms"));

		// export_type
		if (!$this->isAddOrEdit())
			$this->export_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_export_type"));
		$this->export_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_export_type"));

		// lead_time_ss
		if (!$this->isAddOrEdit())
			$this->lead_time_ss->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lead_time_ss"));
		$this->lead_time_ss->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lead_time_ss"));

		// lead_time_cs
		if (!$this->isAddOrEdit())
			$this->lead_time_cs->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lead_time_cs"));
		$this->lead_time_cs->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lead_time_cs"));

		// cha
		if (!$this->isAddOrEdit())
			$this->cha->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cha"));
		$this->cha->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cha"));

		// cha_email
		if (!$this->isAddOrEdit())
			$this->cha_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cha_email"));
		$this->cha_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cha_email"));

		// cha_phone
		if (!$this->isAddOrEdit())
			$this->cha_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cha_phone"));
		$this->cha_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cha_phone"));

		// forwarder
		if (!$this->isAddOrEdit())
			$this->forwarder->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_forwarder"));
		$this->forwarder->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_forwarder"));

		// forwarder_email
		if (!$this->isAddOrEdit())
			$this->forwarder_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_forwarder_email"));
		$this->forwarder_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_forwarder_email"));

		// forwarder_phone
		if (!$this->isAddOrEdit())
			$this->forwarder_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_forwarder_phone"));
		$this->forwarder_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_forwarder_phone"));

		// merchant
		if (!$this->isAddOrEdit())
			$this->merchant->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_merchant"));
		$this->merchant->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_merchant"));

		// merchant_email
		if (!$this->isAddOrEdit())
			$this->merchant_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_merchant_email"));
		$this->merchant_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_merchant_email"));

		// merchant_phone
		if (!$this->isAddOrEdit())
			$this->merchant_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_merchant_phone"));
		$this->merchant_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_merchant_phone"));

		// shipping_incharge
		if (!$this->isAddOrEdit())
			$this->shipping_incharge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipping_incharge"));
		$this->shipping_incharge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipping_incharge"));

		// shipping_email
		if (!$this->isAddOrEdit())
			$this->shipping_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipping_email"));
		$this->shipping_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipping_email"));

		// shipping_phone
		if (!$this->isAddOrEdit())
			$this->shipping_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipping_phone"));
		$this->shipping_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipping_phone"));

		// account_incharge
		if (!$this->isAddOrEdit())
			$this->account_incharge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_account_incharge"));
		$this->account_incharge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_account_incharge"));

		// accounts_email
		if (!$this->isAddOrEdit())
			$this->accounts_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_accounts_email"));
		$this->accounts_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_accounts_email"));

		// accounts_phone
		if (!$this->isAddOrEdit())
			$this->accounts_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_accounts_phone"));
		$this->accounts_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_accounts_phone"));

		// warehouse_incharge
		if (!$this->isAddOrEdit())
			$this->warehouse_incharge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_warehouse_incharge"));
		$this->warehouse_incharge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_warehouse_incharge"));

		// warehouse_email
		if (!$this->isAddOrEdit())
			$this->warehouse_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_warehouse_email"));
		$this->warehouse_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_warehouse_email"));

		// warehouse_phone
		if (!$this->isAddOrEdit())
			$this->warehouse_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_warehouse_phone"));
		$this->warehouse_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_warehouse_phone"));

		// production_incharge
		if (!$this->isAddOrEdit())
			$this->production_incharge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_production_incharge"));
		$this->production_incharge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_production_incharge"));

		// production_email
		if (!$this->isAddOrEdit())
			$this->production_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_production_email"));
		$this->production_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_production_email"));

		// production_phone
		if (!$this->isAddOrEdit())
			$this->production_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_production_phone"));
		$this->production_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_production_phone"));

		// qc_incharge
		if (!$this->isAddOrEdit())
			$this->qc_incharge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_incharge"));
		$this->qc_incharge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_incharge"));

		// qc_email
		if (!$this->isAddOrEdit())
			$this->qc_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_email"));
		$this->qc_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_email"));

		// qc_phone
		if (!$this->isAddOrEdit())
			$this->qc_phone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_phone"));
		$this->qc_phone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_phone"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// name
		// code
		// country
		// region
		// city
		// address
		// mobile
		// email
		// url
		// grp
		// category
		// reports_to
		// status
		// performance
		// operator
		// datetime
		// type
		// tax_registration
		// cin
		// pan
		// tan
		// msme
		// incoterm
		// port_air
		// port_sea
		// iec
		// rex
		// rcmc
		// delivery_terms
		// shipping_terms
		// payment_terms
		// export_type
		// lead_time_ss
		// lead_time_cs
		// cha
		// cha_email
		// cha_phone
		// forwarder
		// forwarder_email
		// forwarder_phone
		// merchant
		// merchant_email
		// merchant_phone
		// shipping_incharge
		// shipping_email
		// shipping_phone
		// account_incharge
		// accounts_email
		// accounts_phone
		// warehouse_incharge
		// warehouse_email
		// warehouse_phone
		// production_incharge
		// production_email
		// production_phone
		// qc_incharge
		// qc_email
		// qc_phone
		// uid
		// r_text

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// country
			$curVal = strval($this->country->CurrentValue);
			if ($curVal <> "") {
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
				if ($this->country->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->country->ViewValue = $this->country->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->country->ViewValue = $this->country->CurrentValue;
					}
				}
			} else {
				$this->country->ViewValue = NULL;
			}
			$this->country->ViewCustomAttributes = "";

			// region
			$curVal = strval($this->region->CurrentValue);
			if ($curVal <> "") {
				$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
				if ($this->region->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->region->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->region->ViewValue = $this->region->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->region->ViewValue = $this->region->CurrentValue;
					}
				}
			} else {
				$this->region->ViewValue = NULL;
			}
			$this->region->ViewCustomAttributes = "";

			// city
			if ($this->city->VirtualValue <> "") {
				$this->city->ViewValue = $this->city->VirtualValue;
			} else {
				$this->city->ViewValue = $this->city->CurrentValue;
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->city->ViewValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->ViewValue = $this->city->CurrentValue;
					}
				}
			} else {
				$this->city->ViewValue = NULL;
			}
			}
			$this->city->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// performance
			$this->performance->ViewValue = $this->performance->CurrentValue;
			$this->performance->ViewValue = FormatNumber($this->performance->ViewValue, 0, -2, -2, -2);
			$this->performance->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// tax_registration
			$this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;
			$this->tax_registration->ViewCustomAttributes = "";

			// cin
			$this->cin->ViewValue = $this->cin->CurrentValue;
			$this->cin->ViewCustomAttributes = "";

			// pan
			$this->pan->ViewValue = $this->pan->CurrentValue;
			$this->pan->ViewCustomAttributes = "";

			// tan
			$this->tan->ViewValue = $this->tan->CurrentValue;
			$this->tan->ViewCustomAttributes = "";

			// msme
			$this->msme->ViewValue = $this->msme->CurrentValue;
			$this->msme->ViewCustomAttributes = "";

			// port_air
			$curVal = strval($this->port_air->CurrentValue);
			if ($curVal <> "") {
				$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
				if ($this->port_air->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=1 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_air->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_air->ViewValue = $this->port_air->CurrentValue;
					}
				}
			} else {
				$this->port_air->ViewValue = NULL;
			}
			$this->port_air->ViewCustomAttributes = "";

			// port_sea
			$curVal = strval($this->port_sea->CurrentValue);
			if ($curVal <> "") {
				$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
				if ($this->port_sea->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=0 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_sea->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_sea->ViewValue = $this->port_sea->CurrentValue;
					}
				}
			} else {
				$this->port_sea->ViewValue = NULL;
			}
			$this->port_sea->ViewCustomAttributes = "";

			// iec
			$this->iec->ViewValue = $this->iec->CurrentValue;
			$this->iec->ViewCustomAttributes = "";

			// rex
			$this->rex->ViewValue = $this->rex->CurrentValue;
			$this->rex->ViewCustomAttributes = "";

			// rcmc
			$this->rcmc->ViewValue = $this->rcmc->CurrentValue;
			$this->rcmc->ViewCustomAttributes = "";

			// delivery_terms
			$this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
			$this->delivery_terms->ViewCustomAttributes = "";

			// shipping_terms
			$this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;
			$this->shipping_terms->ViewCustomAttributes = "";

			// payment_terms
			$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
			$this->payment_terms->ViewCustomAttributes = "";

			// export_type
			$this->export_type->ViewValue = $this->export_type->CurrentValue;
			$this->export_type->ViewCustomAttributes = "";

			// lead_time_ss
			$this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;
			$this->lead_time_ss->ViewCustomAttributes = "";

			// lead_time_cs
			$this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;
			$this->lead_time_cs->ViewCustomAttributes = "";

			// cha
			$this->cha->ViewValue = $this->cha->CurrentValue;
			$this->cha->ViewCustomAttributes = "";

			// cha_email
			$this->cha_email->ViewValue = $this->cha_email->CurrentValue;
			$this->cha_email->ViewCustomAttributes = "";

			// cha_phone
			$this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;
			$this->cha_phone->ViewCustomAttributes = "";

			// forwarder
			$this->forwarder->ViewValue = $this->forwarder->CurrentValue;
			$this->forwarder->ViewCustomAttributes = "";

			// forwarder_email
			$this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;
			$this->forwarder_email->ViewCustomAttributes = "";

			// forwarder_phone
			$this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;
			$this->forwarder_phone->ViewCustomAttributes = "";

			// merchant
			$this->merchant->ViewValue = $this->merchant->CurrentValue;
			$this->merchant->ViewCustomAttributes = "";

			// merchant_email
			$this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;
			$this->merchant_email->ViewCustomAttributes = "";

			// merchant_phone
			$this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;
			$this->merchant_phone->ViewCustomAttributes = "";

			// shipping_incharge
			$this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;
			$this->shipping_incharge->ViewCustomAttributes = "";

			// shipping_email
			$this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;
			$this->shipping_email->ViewCustomAttributes = "";

			// shipping_phone
			$this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;
			$this->shipping_phone->ViewCustomAttributes = "";

			// account_incharge
			$this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;
			$this->account_incharge->ViewCustomAttributes = "";

			// accounts_email
			$this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;
			$this->accounts_email->ViewCustomAttributes = "";

			// accounts_phone
			$this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;
			$this->accounts_phone->ViewCustomAttributes = "";

			// warehouse_incharge
			$this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;
			$this->warehouse_incharge->ViewCustomAttributes = "";

			// warehouse_email
			$this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;
			$this->warehouse_email->ViewCustomAttributes = "";

			// warehouse_phone
			$this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;
			$this->warehouse_phone->ViewCustomAttributes = "";

			// production_incharge
			$this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;
			$this->production_incharge->ViewCustomAttributes = "";

			// production_email
			$this->production_email->ViewValue = $this->production_email->CurrentValue;
			$this->production_email->ViewCustomAttributes = "";

			// production_phone
			$this->production_phone->ViewValue = $this->production_phone->CurrentValue;
			$this->production_phone->ViewCustomAttributes = "";

			// qc_incharge
			$this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;
			$this->qc_incharge->ViewCustomAttributes = "";

			// qc_email
			$this->qc_email->ViewValue = $this->qc_email->CurrentValue;
			$this->qc_email->ViewCustomAttributes = "";

			// qc_phone
			$this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;
			$this->qc_phone->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";
			$this->country->TooltipValue = "";

			// region
			$this->region->LinkCustomAttributes = "";
			$this->region->HrefValue = "";
			$this->region->TooltipValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";
			$this->city->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// performance
			$this->performance->LinkCustomAttributes = "";
			$this->performance->HrefValue = "";
			$this->performance->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// tax_registration
			$this->tax_registration->LinkCustomAttributes = "";
			$this->tax_registration->HrefValue = "";
			$this->tax_registration->TooltipValue = "";

			// cin
			$this->cin->LinkCustomAttributes = "";
			$this->cin->HrefValue = "";
			$this->cin->TooltipValue = "";

			// pan
			$this->pan->LinkCustomAttributes = "";
			$this->pan->HrefValue = "";
			$this->pan->TooltipValue = "";

			// tan
			$this->tan->LinkCustomAttributes = "";
			$this->tan->HrefValue = "";
			$this->tan->TooltipValue = "";

			// msme
			$this->msme->LinkCustomAttributes = "";
			$this->msme->HrefValue = "";
			$this->msme->TooltipValue = "";

			// iec
			$this->iec->LinkCustomAttributes = "";
			$this->iec->HrefValue = "";
			$this->iec->TooltipValue = "";

			// rex
			$this->rex->LinkCustomAttributes = "";
			$this->rex->HrefValue = "";
			$this->rex->TooltipValue = "";

			// rcmc
			$this->rcmc->LinkCustomAttributes = "";
			$this->rcmc->HrefValue = "";
			$this->rcmc->TooltipValue = "";

			// delivery_terms
			$this->delivery_terms->LinkCustomAttributes = "";
			$this->delivery_terms->HrefValue = "";
			$this->delivery_terms->TooltipValue = "";

			// shipping_terms
			$this->shipping_terms->LinkCustomAttributes = "";
			$this->shipping_terms->HrefValue = "";
			$this->shipping_terms->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// export_type
			$this->export_type->LinkCustomAttributes = "";
			$this->export_type->HrefValue = "";
			$this->export_type->TooltipValue = "";

			// lead_time_ss
			$this->lead_time_ss->LinkCustomAttributes = "";
			$this->lead_time_ss->HrefValue = "";
			$this->lead_time_ss->TooltipValue = "";

			// lead_time_cs
			$this->lead_time_cs->LinkCustomAttributes = "";
			$this->lead_time_cs->HrefValue = "";
			$this->lead_time_cs->TooltipValue = "";

			// cha
			$this->cha->LinkCustomAttributes = "";
			$this->cha->HrefValue = "";
			$this->cha->TooltipValue = "";

			// cha_email
			$this->cha_email->LinkCustomAttributes = "";
			$this->cha_email->HrefValue = "";
			$this->cha_email->TooltipValue = "";

			// cha_phone
			$this->cha_phone->LinkCustomAttributes = "";
			$this->cha_phone->HrefValue = "";
			$this->cha_phone->TooltipValue = "";

			// forwarder
			$this->forwarder->LinkCustomAttributes = "";
			$this->forwarder->HrefValue = "";
			$this->forwarder->TooltipValue = "";

			// forwarder_email
			$this->forwarder_email->LinkCustomAttributes = "";
			$this->forwarder_email->HrefValue = "";
			$this->forwarder_email->TooltipValue = "";

			// forwarder_phone
			$this->forwarder_phone->LinkCustomAttributes = "";
			$this->forwarder_phone->HrefValue = "";
			$this->forwarder_phone->TooltipValue = "";

			// merchant
			$this->merchant->LinkCustomAttributes = "";
			$this->merchant->HrefValue = "";
			$this->merchant->TooltipValue = "";

			// merchant_email
			$this->merchant_email->LinkCustomAttributes = "";
			$this->merchant_email->HrefValue = "";
			$this->merchant_email->TooltipValue = "";

			// merchant_phone
			$this->merchant_phone->LinkCustomAttributes = "";
			$this->merchant_phone->HrefValue = "";
			$this->merchant_phone->TooltipValue = "";

			// shipping_incharge
			$this->shipping_incharge->LinkCustomAttributes = "";
			$this->shipping_incharge->HrefValue = "";
			$this->shipping_incharge->TooltipValue = "";

			// shipping_email
			$this->shipping_email->LinkCustomAttributes = "";
			$this->shipping_email->HrefValue = "";
			$this->shipping_email->TooltipValue = "";

			// shipping_phone
			$this->shipping_phone->LinkCustomAttributes = "";
			$this->shipping_phone->HrefValue = "";
			$this->shipping_phone->TooltipValue = "";

			// account_incharge
			$this->account_incharge->LinkCustomAttributes = "";
			$this->account_incharge->HrefValue = "";
			$this->account_incharge->TooltipValue = "";

			// accounts_email
			$this->accounts_email->LinkCustomAttributes = "";
			$this->accounts_email->HrefValue = "";
			$this->accounts_email->TooltipValue = "";

			// accounts_phone
			$this->accounts_phone->LinkCustomAttributes = "";
			$this->accounts_phone->HrefValue = "";
			$this->accounts_phone->TooltipValue = "";

			// warehouse_incharge
			$this->warehouse_incharge->LinkCustomAttributes = "";
			$this->warehouse_incharge->HrefValue = "";
			$this->warehouse_incharge->TooltipValue = "";

			// warehouse_email
			$this->warehouse_email->LinkCustomAttributes = "";
			$this->warehouse_email->HrefValue = "";
			$this->warehouse_email->TooltipValue = "";

			// warehouse_phone
			$this->warehouse_phone->LinkCustomAttributes = "";
			$this->warehouse_phone->HrefValue = "";
			$this->warehouse_phone->TooltipValue = "";

			// production_incharge
			$this->production_incharge->LinkCustomAttributes = "";
			$this->production_incharge->HrefValue = "";
			$this->production_incharge->TooltipValue = "";

			// production_email
			$this->production_email->LinkCustomAttributes = "";
			$this->production_email->HrefValue = "";
			$this->production_email->TooltipValue = "";

			// production_phone
			$this->production_phone->LinkCustomAttributes = "";
			$this->production_phone->HrefValue = "";
			$this->production_phone->TooltipValue = "";

			// qc_incharge
			$this->qc_incharge->LinkCustomAttributes = "";
			$this->qc_incharge->HrefValue = "";
			$this->qc_incharge->TooltipValue = "";

			// qc_email
			$this->qc_email->LinkCustomAttributes = "";
			$this->qc_email->HrefValue = "";
			$this->qc_email->TooltipValue = "";

			// qc_phone
			$this->qc_phone->LinkCustomAttributes = "";
			$this->qc_phone->HrefValue = "";
			$this->qc_phone->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
			$this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->code->AdvancedSearch->SearchValue = HtmlDecode($this->code->AdvancedSearch->SearchValue);
			$this->code->EditValue = HtmlEncode($this->code->AdvancedSearch->SearchValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// country
			$this->country->EditAttrs["class"] = "form-control";
			$this->country->EditCustomAttributes = "";
			$curVal = trim(strval($this->country->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->country->AdvancedSearch->ViewValue = $this->country->lookupCacheOption($curVal);
			else
				$this->country->AdvancedSearch->ViewValue = $this->country->Lookup !== NULL && is_array($this->country->Lookup->Options) ? $curVal : NULL;
			if ($this->country->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->country->EditValue = array_values($this->country->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->country->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->country->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->country->EditValue = $arwrk;
			}

			// region
			$this->region->EditAttrs["class"] = "form-control";
			$this->region->EditCustomAttributes = "";
			$curVal = trim(strval($this->region->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->region->AdvancedSearch->ViewValue = $this->region->lookupCacheOption($curVal);
			else
				$this->region->AdvancedSearch->ViewValue = $this->region->Lookup !== NULL && is_array($this->region->Lookup->Options) ? $curVal : NULL;
			if ($this->region->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->region->EditValue = array_values($this->region->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->region->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->region->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->region->EditValue = $arwrk;
			}

			// city
			$this->city->EditAttrs["class"] = "form-control";
			$this->city->EditCustomAttributes = "";
			$this->city->EditValue = HtmlEncode($this->city->AdvancedSearch->SearchValue);
			$this->city->PlaceHolder = RemoveHtml($this->city->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// url
			$this->url->EditAttrs["class"] = "form-control";
			$this->url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->url->AdvancedSearch->SearchValue = HtmlDecode($this->url->AdvancedSearch->SearchValue);
			$this->url->EditValue = HtmlEncode($this->url->AdvancedSearch->SearchValue);
			$this->url->PlaceHolder = RemoveHtml($this->url->caption());

			// grp
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// performance
			$this->performance->EditAttrs["class"] = "form-control";
			$this->performance->EditCustomAttributes = "";
			$this->performance->EditValue = HtmlEncode($this->performance->AdvancedSearch->SearchValue);
			$this->performance->PlaceHolder = RemoveHtml($this->performance->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// tax_registration
			$this->tax_registration->EditAttrs["class"] = "form-control";
			$this->tax_registration->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tax_registration->AdvancedSearch->SearchValue = HtmlDecode($this->tax_registration->AdvancedSearch->SearchValue);
			$this->tax_registration->EditValue = HtmlEncode($this->tax_registration->AdvancedSearch->SearchValue);
			$this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

			// cin
			$this->cin->EditAttrs["class"] = "form-control";
			$this->cin->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cin->AdvancedSearch->SearchValue = HtmlDecode($this->cin->AdvancedSearch->SearchValue);
			$this->cin->EditValue = HtmlEncode($this->cin->AdvancedSearch->SearchValue);
			$this->cin->PlaceHolder = RemoveHtml($this->cin->caption());

			// pan
			$this->pan->EditAttrs["class"] = "form-control";
			$this->pan->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan->AdvancedSearch->SearchValue = HtmlDecode($this->pan->AdvancedSearch->SearchValue);
			$this->pan->EditValue = HtmlEncode($this->pan->AdvancedSearch->SearchValue);
			$this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

			// tan
			$this->tan->EditAttrs["class"] = "form-control";
			$this->tan->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tan->AdvancedSearch->SearchValue = HtmlDecode($this->tan->AdvancedSearch->SearchValue);
			$this->tan->EditValue = HtmlEncode($this->tan->AdvancedSearch->SearchValue);
			$this->tan->PlaceHolder = RemoveHtml($this->tan->caption());

			// msme
			$this->msme->EditAttrs["class"] = "form-control";
			$this->msme->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->msme->AdvancedSearch->SearchValue = HtmlDecode($this->msme->AdvancedSearch->SearchValue);
			$this->msme->EditValue = HtmlEncode($this->msme->AdvancedSearch->SearchValue);
			$this->msme->PlaceHolder = RemoveHtml($this->msme->caption());

			// iec
			$this->iec->EditAttrs["class"] = "form-control";
			$this->iec->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->iec->AdvancedSearch->SearchValue = HtmlDecode($this->iec->AdvancedSearch->SearchValue);
			$this->iec->EditValue = HtmlEncode($this->iec->AdvancedSearch->SearchValue);
			$this->iec->PlaceHolder = RemoveHtml($this->iec->caption());

			// rex
			$this->rex->EditAttrs["class"] = "form-control";
			$this->rex->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rex->AdvancedSearch->SearchValue = HtmlDecode($this->rex->AdvancedSearch->SearchValue);
			$this->rex->EditValue = HtmlEncode($this->rex->AdvancedSearch->SearchValue);
			$this->rex->PlaceHolder = RemoveHtml($this->rex->caption());

			// rcmc
			$this->rcmc->EditAttrs["class"] = "form-control";
			$this->rcmc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rcmc->AdvancedSearch->SearchValue = HtmlDecode($this->rcmc->AdvancedSearch->SearchValue);
			$this->rcmc->EditValue = HtmlEncode($this->rcmc->AdvancedSearch->SearchValue);
			$this->rcmc->PlaceHolder = RemoveHtml($this->rcmc->caption());

			// delivery_terms
			$this->delivery_terms->EditAttrs["class"] = "form-control";
			$this->delivery_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_terms->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_terms->AdvancedSearch->SearchValue);
			$this->delivery_terms->EditValue = HtmlEncode($this->delivery_terms->AdvancedSearch->SearchValue);
			$this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

			// shipping_terms
			$this->shipping_terms->EditAttrs["class"] = "form-control";
			$this->shipping_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->shipping_terms->AdvancedSearch->SearchValue = HtmlDecode($this->shipping_terms->AdvancedSearch->SearchValue);
			$this->shipping_terms->EditValue = HtmlEncode($this->shipping_terms->AdvancedSearch->SearchValue);
			$this->shipping_terms->PlaceHolder = RemoveHtml($this->shipping_terms->caption());

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_terms->AdvancedSearch->SearchValue = HtmlDecode($this->payment_terms->AdvancedSearch->SearchValue);
			$this->payment_terms->EditValue = HtmlEncode($this->payment_terms->AdvancedSearch->SearchValue);
			$this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

			// export_type
			$this->export_type->EditAttrs["class"] = "form-control";
			$this->export_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->export_type->AdvancedSearch->SearchValue = HtmlDecode($this->export_type->AdvancedSearch->SearchValue);
			$this->export_type->EditValue = HtmlEncode($this->export_type->AdvancedSearch->SearchValue);
			$this->export_type->PlaceHolder = RemoveHtml($this->export_type->caption());

			// lead_time_ss
			$this->lead_time_ss->EditAttrs["class"] = "form-control";
			$this->lead_time_ss->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lead_time_ss->AdvancedSearch->SearchValue = HtmlDecode($this->lead_time_ss->AdvancedSearch->SearchValue);
			$this->lead_time_ss->EditValue = HtmlEncode($this->lead_time_ss->AdvancedSearch->SearchValue);
			$this->lead_time_ss->PlaceHolder = RemoveHtml($this->lead_time_ss->caption());

			// lead_time_cs
			$this->lead_time_cs->EditAttrs["class"] = "form-control";
			$this->lead_time_cs->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lead_time_cs->AdvancedSearch->SearchValue = HtmlDecode($this->lead_time_cs->AdvancedSearch->SearchValue);
			$this->lead_time_cs->EditValue = HtmlEncode($this->lead_time_cs->AdvancedSearch->SearchValue);
			$this->lead_time_cs->PlaceHolder = RemoveHtml($this->lead_time_cs->caption());

			// cha
			$this->cha->EditAttrs["class"] = "form-control";
			$this->cha->EditCustomAttributes = "";
			$this->cha->EditValue = HtmlEncode($this->cha->AdvancedSearch->SearchValue);
			$this->cha->PlaceHolder = RemoveHtml($this->cha->caption());

			// cha_email
			$this->cha_email->EditAttrs["class"] = "form-control";
			$this->cha_email->EditCustomAttributes = "";
			$this->cha_email->EditValue = HtmlEncode($this->cha_email->AdvancedSearch->SearchValue);
			$this->cha_email->PlaceHolder = RemoveHtml($this->cha_email->caption());

			// cha_phone
			$this->cha_phone->EditAttrs["class"] = "form-control";
			$this->cha_phone->EditCustomAttributes = "";
			$this->cha_phone->EditValue = HtmlEncode($this->cha_phone->AdvancedSearch->SearchValue);
			$this->cha_phone->PlaceHolder = RemoveHtml($this->cha_phone->caption());

			// forwarder
			$this->forwarder->EditAttrs["class"] = "form-control";
			$this->forwarder->EditCustomAttributes = "";
			$this->forwarder->EditValue = HtmlEncode($this->forwarder->AdvancedSearch->SearchValue);
			$this->forwarder->PlaceHolder = RemoveHtml($this->forwarder->caption());

			// forwarder_email
			$this->forwarder_email->EditAttrs["class"] = "form-control";
			$this->forwarder_email->EditCustomAttributes = "";
			$this->forwarder_email->EditValue = HtmlEncode($this->forwarder_email->AdvancedSearch->SearchValue);
			$this->forwarder_email->PlaceHolder = RemoveHtml($this->forwarder_email->caption());

			// forwarder_phone
			$this->forwarder_phone->EditAttrs["class"] = "form-control";
			$this->forwarder_phone->EditCustomAttributes = "";
			$this->forwarder_phone->EditValue = HtmlEncode($this->forwarder_phone->AdvancedSearch->SearchValue);
			$this->forwarder_phone->PlaceHolder = RemoveHtml($this->forwarder_phone->caption());

			// merchant
			$this->merchant->EditAttrs["class"] = "form-control";
			$this->merchant->EditCustomAttributes = "";
			$this->merchant->EditValue = HtmlEncode($this->merchant->AdvancedSearch->SearchValue);
			$this->merchant->PlaceHolder = RemoveHtml($this->merchant->caption());

			// merchant_email
			$this->merchant_email->EditAttrs["class"] = "form-control";
			$this->merchant_email->EditCustomAttributes = "";
			$this->merchant_email->EditValue = HtmlEncode($this->merchant_email->AdvancedSearch->SearchValue);
			$this->merchant_email->PlaceHolder = RemoveHtml($this->merchant_email->caption());

			// merchant_phone
			$this->merchant_phone->EditAttrs["class"] = "form-control";
			$this->merchant_phone->EditCustomAttributes = "";
			$this->merchant_phone->EditValue = HtmlEncode($this->merchant_phone->AdvancedSearch->SearchValue);
			$this->merchant_phone->PlaceHolder = RemoveHtml($this->merchant_phone->caption());

			// shipping_incharge
			$this->shipping_incharge->EditAttrs["class"] = "form-control";
			$this->shipping_incharge->EditCustomAttributes = "";
			$this->shipping_incharge->EditValue = HtmlEncode($this->shipping_incharge->AdvancedSearch->SearchValue);
			$this->shipping_incharge->PlaceHolder = RemoveHtml($this->shipping_incharge->caption());

			// shipping_email
			$this->shipping_email->EditAttrs["class"] = "form-control";
			$this->shipping_email->EditCustomAttributes = "";
			$this->shipping_email->EditValue = HtmlEncode($this->shipping_email->AdvancedSearch->SearchValue);
			$this->shipping_email->PlaceHolder = RemoveHtml($this->shipping_email->caption());

			// shipping_phone
			$this->shipping_phone->EditAttrs["class"] = "form-control";
			$this->shipping_phone->EditCustomAttributes = "";
			$this->shipping_phone->EditValue = HtmlEncode($this->shipping_phone->AdvancedSearch->SearchValue);
			$this->shipping_phone->PlaceHolder = RemoveHtml($this->shipping_phone->caption());

			// account_incharge
			$this->account_incharge->EditAttrs["class"] = "form-control";
			$this->account_incharge->EditCustomAttributes = "";
			$this->account_incharge->EditValue = HtmlEncode($this->account_incharge->AdvancedSearch->SearchValue);
			$this->account_incharge->PlaceHolder = RemoveHtml($this->account_incharge->caption());

			// accounts_email
			$this->accounts_email->EditAttrs["class"] = "form-control";
			$this->accounts_email->EditCustomAttributes = "";
			$this->accounts_email->EditValue = HtmlEncode($this->accounts_email->AdvancedSearch->SearchValue);
			$this->accounts_email->PlaceHolder = RemoveHtml($this->accounts_email->caption());

			// accounts_phone
			$this->accounts_phone->EditAttrs["class"] = "form-control";
			$this->accounts_phone->EditCustomAttributes = "";
			$this->accounts_phone->EditValue = HtmlEncode($this->accounts_phone->AdvancedSearch->SearchValue);
			$this->accounts_phone->PlaceHolder = RemoveHtml($this->accounts_phone->caption());

			// warehouse_incharge
			$this->warehouse_incharge->EditAttrs["class"] = "form-control";
			$this->warehouse_incharge->EditCustomAttributes = "";
			$this->warehouse_incharge->EditValue = HtmlEncode($this->warehouse_incharge->AdvancedSearch->SearchValue);
			$this->warehouse_incharge->PlaceHolder = RemoveHtml($this->warehouse_incharge->caption());

			// warehouse_email
			$this->warehouse_email->EditAttrs["class"] = "form-control";
			$this->warehouse_email->EditCustomAttributes = "";
			$this->warehouse_email->EditValue = HtmlEncode($this->warehouse_email->AdvancedSearch->SearchValue);
			$this->warehouse_email->PlaceHolder = RemoveHtml($this->warehouse_email->caption());

			// warehouse_phone
			$this->warehouse_phone->EditAttrs["class"] = "form-control";
			$this->warehouse_phone->EditCustomAttributes = "";
			$this->warehouse_phone->EditValue = HtmlEncode($this->warehouse_phone->AdvancedSearch->SearchValue);
			$this->warehouse_phone->PlaceHolder = RemoveHtml($this->warehouse_phone->caption());

			// production_incharge
			$this->production_incharge->EditAttrs["class"] = "form-control";
			$this->production_incharge->EditCustomAttributes = "";
			$this->production_incharge->EditValue = HtmlEncode($this->production_incharge->AdvancedSearch->SearchValue);
			$this->production_incharge->PlaceHolder = RemoveHtml($this->production_incharge->caption());

			// production_email
			$this->production_email->EditAttrs["class"] = "form-control";
			$this->production_email->EditCustomAttributes = "";
			$this->production_email->EditValue = HtmlEncode($this->production_email->AdvancedSearch->SearchValue);
			$this->production_email->PlaceHolder = RemoveHtml($this->production_email->caption());

			// production_phone
			$this->production_phone->EditAttrs["class"] = "form-control";
			$this->production_phone->EditCustomAttributes = "";
			$this->production_phone->EditValue = HtmlEncode($this->production_phone->AdvancedSearch->SearchValue);
			$this->production_phone->PlaceHolder = RemoveHtml($this->production_phone->caption());

			// qc_incharge
			$this->qc_incharge->EditAttrs["class"] = "form-control";
			$this->qc_incharge->EditCustomAttributes = "";
			$this->qc_incharge->EditValue = HtmlEncode($this->qc_incharge->AdvancedSearch->SearchValue);
			$this->qc_incharge->PlaceHolder = RemoveHtml($this->qc_incharge->caption());

			// qc_email
			$this->qc_email->EditAttrs["class"] = "form-control";
			$this->qc_email->EditCustomAttributes = "";
			$this->qc_email->EditValue = HtmlEncode($this->qc_email->AdvancedSearch->SearchValue);
			$this->qc_email->PlaceHolder = RemoveHtml($this->qc_email->caption());

			// qc_phone
			$this->qc_phone->EditAttrs["class"] = "form-control";
			$this->qc_phone->EditCustomAttributes = "";
			$this->qc_phone->EditValue = HtmlEncode($this->qc_phone->AdvancedSearch->SearchValue);
			$this->qc_phone->PlaceHolder = RemoveHtml($this->qc_phone->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->performance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->performance->errorMessage());
		}
		if (!CheckNumber($this->lead_time_ss->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->lead_time_ss->errorMessage());
		}
		if (!CheckNumber($this->lead_time_cs->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->lead_time_cs->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->name->AdvancedSearch->load();
		$this->code->AdvancedSearch->load();
		$this->country->AdvancedSearch->load();
		$this->region->AdvancedSearch->load();
		$this->city->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->url->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->performance->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->tax_registration->AdvancedSearch->load();
		$this->cin->AdvancedSearch->load();
		$this->pan->AdvancedSearch->load();
		$this->tan->AdvancedSearch->load();
		$this->msme->AdvancedSearch->load();
		$this->iec->AdvancedSearch->load();
		$this->rex->AdvancedSearch->load();
		$this->rcmc->AdvancedSearch->load();
		$this->delivery_terms->AdvancedSearch->load();
		$this->shipping_terms->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->export_type->AdvancedSearch->load();
		$this->lead_time_ss->AdvancedSearch->load();
		$this->lead_time_cs->AdvancedSearch->load();
		$this->cha->AdvancedSearch->load();
		$this->cha_email->AdvancedSearch->load();
		$this->cha_phone->AdvancedSearch->load();
		$this->forwarder->AdvancedSearch->load();
		$this->forwarder_email->AdvancedSearch->load();
		$this->forwarder_phone->AdvancedSearch->load();
		$this->merchant->AdvancedSearch->load();
		$this->merchant_email->AdvancedSearch->load();
		$this->merchant_phone->AdvancedSearch->load();
		$this->shipping_incharge->AdvancedSearch->load();
		$this->shipping_email->AdvancedSearch->load();
		$this->shipping_phone->AdvancedSearch->load();
		$this->account_incharge->AdvancedSearch->load();
		$this->accounts_email->AdvancedSearch->load();
		$this->accounts_phone->AdvancedSearch->load();
		$this->warehouse_incharge->AdvancedSearch->load();
		$this->warehouse_email->AdvancedSearch->load();
		$this->warehouse_phone->AdvancedSearch->load();
		$this->production_incharge->AdvancedSearch->load();
		$this->production_email->AdvancedSearch->load();
		$this->production_phone->AdvancedSearch->load();
		$this->qc_incharge->AdvancedSearch->load();
		$this->qc_email->AdvancedSearch->load();
		$this->qc_phone->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("production_partnerlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$pages->add(8);
		$pages->add(9);
		$pages->add(10);
		$pages->add(11);
		$pages->add(12);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_air":
					$lookupFilter = function() {
						return "`mode`=1 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_sea":
					$lookupFilter = function() {
						return "`mode`=0 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_country":
							break;
						case "x_region":
							break;
						case "x_city":
							break;
						case "x_grp":
							break;
						case "x_category":
							break;
						case "x_reports_to":
							break;
						case "x_operator":
							break;
						case "x_incoterm":
							break;
						case "x_port_air":
							break;
						case "x_port_sea":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'production_partner');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>