<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class production_partner_view extends production_partner
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'production_partner';

	// Page object name
	public $PageObjName = "production_partner_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (production_partner)
		if (!isset($GLOBALS["production_partner"]) || get_class($GLOBALS["production_partner"]) == PROJECT_NAMESPACE . "production_partner") {
			$GLOBALS["production_partner"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["production_partner"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'production_partner');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $production_partner;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($production_partner);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "production_partnerview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("production_partnerlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->name->setVisibility();
		$this->code->setVisibility();
		$this->country->setVisibility();
		$this->region->setVisibility();
		$this->city->setVisibility();
		$this->address->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->url->setVisibility();
		$this->grp->setVisibility();
		$this->category->setVisibility();
		$this->reports_to->setVisibility();
		$this->status->setVisibility();
		$this->performance->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->type->setVisibility();
		$this->tax_registration->setVisibility();
		$this->cin->setVisibility();
		$this->pan->setVisibility();
		$this->tan->setVisibility();
		$this->msme->setVisibility();
		$this->incoterm->Visible = FALSE;
		$this->port_air->setVisibility();
		$this->port_sea->setVisibility();
		$this->iec->setVisibility();
		$this->rex->setVisibility();
		$this->rcmc->setVisibility();
		$this->delivery_terms->setVisibility();
		$this->shipping_terms->setVisibility();
		$this->payment_terms->setVisibility();
		$this->export_type->setVisibility();
		$this->lead_time_ss->setVisibility();
		$this->lead_time_cs->setVisibility();
		$this->cha->setVisibility();
		$this->cha_email->setVisibility();
		$this->cha_phone->setVisibility();
		$this->forwarder->setVisibility();
		$this->forwarder_email->setVisibility();
		$this->forwarder_phone->setVisibility();
		$this->merchant->setVisibility();
		$this->merchant_email->setVisibility();
		$this->merchant_phone->setVisibility();
		$this->shipping_incharge->setVisibility();
		$this->shipping_email->setVisibility();
		$this->shipping_phone->setVisibility();
		$this->account_incharge->setVisibility();
		$this->accounts_email->setVisibility();
		$this->accounts_phone->setVisibility();
		$this->warehouse_incharge->setVisibility();
		$this->warehouse_email->setVisibility();
		$this->warehouse_phone->setVisibility();
		$this->production_incharge->setVisibility();
		$this->production_email->setVisibility();
		$this->production_phone->setVisibility();
		$this->qc_incharge->setVisibility();
		$this->qc_email->setVisibility();
		$this->qc_phone->setVisibility();
		$this->uid->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->country);
		$this->setupLookupOptions($this->region);
		$this->setupLookupOptions($this->city);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->incoterm);
		$this->setupLookupOptions($this->port_air);
		$this->setupLookupOptions($this->port_sea);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "production_partnerlist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "production_partnerlist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "production_partnerlist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Set up detail parameters
		$this->setupDetailParms();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->canAdd());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->canDelete());
		$option = &$options["detail"];
		$detailTableLink = "";
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_shipping_address"
		$item = &$option->add("detail_shipping_address");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("shipping_address", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("shipping_addresslist.php?" . TABLE_SHOW_MASTER . "=production_partner&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["shipping_address_grid"]))
			$GLOBALS["shipping_address_grid"] = new shipping_address_grid();
		if ($GLOBALS["shipping_address_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'shipping_address')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=shipping_address")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "shipping_address";
		}
		if ($GLOBALS["shipping_address_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'shipping_address')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=shipping_address")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "shipping_address";
		}
		if ($GLOBALS["shipping_address_grid"]->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'shipping_address')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(TABLE_SHOW_DETAIL . "=shipping_address")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($detailCopyTblVar <> "")
				$detailCopyTblVar .= ",";
			$detailCopyTblVar .= "shipping_address";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'shipping_address');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "shipping_address";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail__bank_info"
		$item = &$option->add("detail__bank_info");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("_bank_info", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("_bank_infolist.php?" . TABLE_SHOW_MASTER . "=production_partner&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["_bank_info_grid"]))
			$GLOBALS["_bank_info_grid"] = new _bank_info_grid();
		if ($GLOBALS["_bank_info_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'bank_info')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=_bank_info")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "_bank_info";
		}
		if ($GLOBALS["_bank_info_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'bank_info')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=_bank_info")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "_bank_info";
		}
		if ($GLOBALS["_bank_info_grid"]->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'bank_info')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(TABLE_SHOW_DETAIL . "=_bank_info")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($detailCopyTblVar <> "")
				$detailCopyTblVar .= ",";
			$detailCopyTblVar .= "_bank_info";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'bank_info');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "_bank_info";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_capacity_plan"
		$item = &$option->add("detail_capacity_plan");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("capacity_plan", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("capacity_planlist.php?" . TABLE_SHOW_MASTER . "=production_partner&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["capacity_plan_grid"]))
			$GLOBALS["capacity_plan_grid"] = new capacity_plan_grid();
		if ($GLOBALS["capacity_plan_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'capacity_plan')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=capacity_plan")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "capacity_plan";
		}
		if ($GLOBALS["capacity_plan_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'capacity_plan')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=capacity_plan")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "capacity_plan";
		}
		if ($GLOBALS["capacity_plan_grid"]->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'capacity_plan')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(TABLE_SHOW_DETAIL . "=capacity_plan")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($detailCopyTblVar <> "")
				$detailCopyTblVar .= ",";
			$detailCopyTblVar .= "capacity_plan";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'capacity_plan');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "capacity_plan";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(TABLE_SHOW_DETAIL . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$opt = &$option->add("details");
			$opt->Body = $body;
		}

		// Set up detail default
		$option = &$options["detail"];
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$ar = explode(",", $detailTableLink);
		$cnt = count($ar);
		$option->UseDropDownButton = ($cnt > 1);
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->name->setDbValue($row['name']);
		$this->code->setDbValue($row['code']);
		$this->country->setDbValue($row['country']);
		$this->region->setDbValue($row['region']);
		$this->city->setDbValue($row['city']);
		if (array_key_exists('EV__city', $rs->fields)) {
			$this->city->VirtualValue = $rs->fields('EV__city'); // Set up virtual field value
		} else {
			$this->city->VirtualValue = ""; // Clear value
		}
		$this->address->setDbValue($row['address']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->url->setDbValue($row['url']);
		$this->grp->setDbValue($row['grp']);
		$this->category->setDbValue($row['category']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->status->setDbValue($row['status']);
		$this->performance->setDbValue($row['performance']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->type->setDbValue($row['type']);
		$this->tax_registration->setDbValue($row['tax_registration']);
		$this->cin->setDbValue($row['cin']);
		$this->pan->setDbValue($row['pan']);
		$this->tan->setDbValue($row['tan']);
		$this->msme->setDbValue($row['msme']);
		$this->incoterm->setDbValue($row['incoterm']);
		$this->port_air->setDbValue($row['port_air']);
		$this->port_sea->setDbValue($row['port_sea']);
		$this->iec->setDbValue($row['iec']);
		$this->rex->setDbValue($row['rex']);
		$this->rcmc->setDbValue($row['rcmc']);
		$this->delivery_terms->setDbValue($row['delivery_terms']);
		$this->shipping_terms->setDbValue($row['shipping_terms']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->export_type->setDbValue($row['export_type']);
		$this->lead_time_ss->setDbValue($row['lead_time_ss']);
		$this->lead_time_cs->setDbValue($row['lead_time_cs']);
		$this->cha->setDbValue($row['cha']);
		$this->cha_email->setDbValue($row['cha_email']);
		$this->cha_phone->setDbValue($row['cha_phone']);
		$this->forwarder->setDbValue($row['forwarder']);
		$this->forwarder_email->setDbValue($row['forwarder_email']);
		$this->forwarder_phone->setDbValue($row['forwarder_phone']);
		$this->merchant->setDbValue($row['merchant']);
		$this->merchant_email->setDbValue($row['merchant_email']);
		$this->merchant_phone->setDbValue($row['merchant_phone']);
		$this->shipping_incharge->setDbValue($row['shipping_incharge']);
		$this->shipping_email->setDbValue($row['shipping_email']);
		$this->shipping_phone->setDbValue($row['shipping_phone']);
		$this->account_incharge->setDbValue($row['account_incharge']);
		$this->accounts_email->setDbValue($row['accounts_email']);
		$this->accounts_phone->setDbValue($row['accounts_phone']);
		$this->warehouse_incharge->setDbValue($row['warehouse_incharge']);
		$this->warehouse_email->setDbValue($row['warehouse_email']);
		$this->warehouse_phone->setDbValue($row['warehouse_phone']);
		$this->production_incharge->setDbValue($row['production_incharge']);
		$this->production_email->setDbValue($row['production_email']);
		$this->production_phone->setDbValue($row['production_phone']);
		$this->qc_incharge->setDbValue($row['qc_incharge']);
		$this->qc_email->setDbValue($row['qc_email']);
		$this->qc_phone->setDbValue($row['qc_phone']);
		$this->uid->setDbValue($row['uid']);
		$this->r_text->setDbValue($row['r_text']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['name'] = NULL;
		$row['code'] = NULL;
		$row['country'] = NULL;
		$row['region'] = NULL;
		$row['city'] = NULL;
		$row['address'] = NULL;
		$row['mobile'] = NULL;
		$row['email'] = NULL;
		$row['url'] = NULL;
		$row['grp'] = NULL;
		$row['category'] = NULL;
		$row['reports_to'] = NULL;
		$row['status'] = NULL;
		$row['performance'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['type'] = NULL;
		$row['tax_registration'] = NULL;
		$row['cin'] = NULL;
		$row['pan'] = NULL;
		$row['tan'] = NULL;
		$row['msme'] = NULL;
		$row['incoterm'] = NULL;
		$row['port_air'] = NULL;
		$row['port_sea'] = NULL;
		$row['iec'] = NULL;
		$row['rex'] = NULL;
		$row['rcmc'] = NULL;
		$row['delivery_terms'] = NULL;
		$row['shipping_terms'] = NULL;
		$row['payment_terms'] = NULL;
		$row['export_type'] = NULL;
		$row['lead_time_ss'] = NULL;
		$row['lead_time_cs'] = NULL;
		$row['cha'] = NULL;
		$row['cha_email'] = NULL;
		$row['cha_phone'] = NULL;
		$row['forwarder'] = NULL;
		$row['forwarder_email'] = NULL;
		$row['forwarder_phone'] = NULL;
		$row['merchant'] = NULL;
		$row['merchant_email'] = NULL;
		$row['merchant_phone'] = NULL;
		$row['shipping_incharge'] = NULL;
		$row['shipping_email'] = NULL;
		$row['shipping_phone'] = NULL;
		$row['account_incharge'] = NULL;
		$row['accounts_email'] = NULL;
		$row['accounts_phone'] = NULL;
		$row['warehouse_incharge'] = NULL;
		$row['warehouse_email'] = NULL;
		$row['warehouse_phone'] = NULL;
		$row['production_incharge'] = NULL;
		$row['production_email'] = NULL;
		$row['production_phone'] = NULL;
		$row['qc_incharge'] = NULL;
		$row['qc_email'] = NULL;
		$row['qc_phone'] = NULL;
		$row['uid'] = NULL;
		$row['r_text'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// name
		// code
		// country
		// region
		// city
		// address
		// mobile
		// email
		// url
		// grp
		// category
		// reports_to
		// status
		// performance
		// operator
		// datetime
		// type
		// tax_registration
		// cin
		// pan
		// tan
		// msme
		// incoterm
		// port_air
		// port_sea
		// iec
		// rex
		// rcmc
		// delivery_terms
		// shipping_terms
		// payment_terms
		// export_type
		// lead_time_ss
		// lead_time_cs
		// cha
		// cha_email
		// cha_phone
		// forwarder
		// forwarder_email
		// forwarder_phone
		// merchant
		// merchant_email
		// merchant_phone
		// shipping_incharge
		// shipping_email
		// shipping_phone
		// account_incharge
		// accounts_email
		// accounts_phone
		// warehouse_incharge
		// warehouse_email
		// warehouse_phone
		// production_incharge
		// production_email
		// production_phone
		// qc_incharge
		// qc_email
		// qc_phone
		// uid
		// r_text

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// country
			$curVal = strval($this->country->CurrentValue);
			if ($curVal <> "") {
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
				if ($this->country->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->country->ViewValue = $this->country->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->country->ViewValue = $this->country->CurrentValue;
					}
				}
			} else {
				$this->country->ViewValue = NULL;
			}
			$this->country->ViewCustomAttributes = "";

			// region
			$curVal = strval($this->region->CurrentValue);
			if ($curVal <> "") {
				$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
				if ($this->region->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->region->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->region->ViewValue = $this->region->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->region->ViewValue = $this->region->CurrentValue;
					}
				}
			} else {
				$this->region->ViewValue = NULL;
			}
			$this->region->ViewCustomAttributes = "";

			// city
			if ($this->city->VirtualValue <> "") {
				$this->city->ViewValue = $this->city->VirtualValue;
			} else {
				$this->city->ViewValue = $this->city->CurrentValue;
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->city->ViewValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->ViewValue = $this->city->CurrentValue;
					}
				}
			} else {
				$this->city->ViewValue = NULL;
			}
			}
			$this->city->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// performance
			$this->performance->ViewValue = $this->performance->CurrentValue;
			$this->performance->ViewValue = FormatNumber($this->performance->ViewValue, 0, -2, -2, -2);
			$this->performance->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// tax_registration
			$this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;
			$this->tax_registration->ViewCustomAttributes = "";

			// cin
			$this->cin->ViewValue = $this->cin->CurrentValue;
			$this->cin->ViewCustomAttributes = "";

			// pan
			$this->pan->ViewValue = $this->pan->CurrentValue;
			$this->pan->ViewCustomAttributes = "";

			// tan
			$this->tan->ViewValue = $this->tan->CurrentValue;
			$this->tan->ViewCustomAttributes = "";

			// msme
			$this->msme->ViewValue = $this->msme->CurrentValue;
			$this->msme->ViewCustomAttributes = "";

			// port_air
			$curVal = strval($this->port_air->CurrentValue);
			if ($curVal <> "") {
				$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
				if ($this->port_air->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=1 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_air->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_air->ViewValue = $this->port_air->CurrentValue;
					}
				}
			} else {
				$this->port_air->ViewValue = NULL;
			}
			$this->port_air->ViewCustomAttributes = "";

			// port_sea
			$curVal = strval($this->port_sea->CurrentValue);
			if ($curVal <> "") {
				$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
				if ($this->port_sea->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=0 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_sea->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_sea->ViewValue = $this->port_sea->CurrentValue;
					}
				}
			} else {
				$this->port_sea->ViewValue = NULL;
			}
			$this->port_sea->ViewCustomAttributes = "";

			// iec
			$this->iec->ViewValue = $this->iec->CurrentValue;
			$this->iec->ViewCustomAttributes = "";

			// rex
			$this->rex->ViewValue = $this->rex->CurrentValue;
			$this->rex->ViewCustomAttributes = "";

			// rcmc
			$this->rcmc->ViewValue = $this->rcmc->CurrentValue;
			$this->rcmc->ViewCustomAttributes = "";

			// delivery_terms
			$this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
			$this->delivery_terms->ViewCustomAttributes = "";

			// shipping_terms
			$this->shipping_terms->ViewValue = $this->shipping_terms->CurrentValue;
			$this->shipping_terms->ViewCustomAttributes = "";

			// payment_terms
			$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
			$this->payment_terms->ViewCustomAttributes = "";

			// export_type
			$this->export_type->ViewValue = $this->export_type->CurrentValue;
			$this->export_type->ViewCustomAttributes = "";

			// lead_time_ss
			$this->lead_time_ss->ViewValue = $this->lead_time_ss->CurrentValue;
			$this->lead_time_ss->ViewCustomAttributes = "";

			// lead_time_cs
			$this->lead_time_cs->ViewValue = $this->lead_time_cs->CurrentValue;
			$this->lead_time_cs->ViewCustomAttributes = "";

			// cha
			$this->cha->ViewValue = $this->cha->CurrentValue;
			$this->cha->ViewCustomAttributes = "";

			// cha_email
			$this->cha_email->ViewValue = $this->cha_email->CurrentValue;
			$this->cha_email->ViewCustomAttributes = "";

			// cha_phone
			$this->cha_phone->ViewValue = $this->cha_phone->CurrentValue;
			$this->cha_phone->ViewCustomAttributes = "";

			// forwarder
			$this->forwarder->ViewValue = $this->forwarder->CurrentValue;
			$this->forwarder->ViewCustomAttributes = "";

			// forwarder_email
			$this->forwarder_email->ViewValue = $this->forwarder_email->CurrentValue;
			$this->forwarder_email->ViewCustomAttributes = "";

			// forwarder_phone
			$this->forwarder_phone->ViewValue = $this->forwarder_phone->CurrentValue;
			$this->forwarder_phone->ViewCustomAttributes = "";

			// merchant
			$this->merchant->ViewValue = $this->merchant->CurrentValue;
			$this->merchant->ViewCustomAttributes = "";

			// merchant_email
			$this->merchant_email->ViewValue = $this->merchant_email->CurrentValue;
			$this->merchant_email->ViewCustomAttributes = "";

			// merchant_phone
			$this->merchant_phone->ViewValue = $this->merchant_phone->CurrentValue;
			$this->merchant_phone->ViewCustomAttributes = "";

			// shipping_incharge
			$this->shipping_incharge->ViewValue = $this->shipping_incharge->CurrentValue;
			$this->shipping_incharge->ViewCustomAttributes = "";

			// shipping_email
			$this->shipping_email->ViewValue = $this->shipping_email->CurrentValue;
			$this->shipping_email->ViewCustomAttributes = "";

			// shipping_phone
			$this->shipping_phone->ViewValue = $this->shipping_phone->CurrentValue;
			$this->shipping_phone->ViewCustomAttributes = "";

			// account_incharge
			$this->account_incharge->ViewValue = $this->account_incharge->CurrentValue;
			$this->account_incharge->ViewCustomAttributes = "";

			// accounts_email
			$this->accounts_email->ViewValue = $this->accounts_email->CurrentValue;
			$this->accounts_email->ViewCustomAttributes = "";

			// accounts_phone
			$this->accounts_phone->ViewValue = $this->accounts_phone->CurrentValue;
			$this->accounts_phone->ViewCustomAttributes = "";

			// warehouse_incharge
			$this->warehouse_incharge->ViewValue = $this->warehouse_incharge->CurrentValue;
			$this->warehouse_incharge->ViewCustomAttributes = "";

			// warehouse_email
			$this->warehouse_email->ViewValue = $this->warehouse_email->CurrentValue;
			$this->warehouse_email->ViewCustomAttributes = "";

			// warehouse_phone
			$this->warehouse_phone->ViewValue = $this->warehouse_phone->CurrentValue;
			$this->warehouse_phone->ViewCustomAttributes = "";

			// production_incharge
			$this->production_incharge->ViewValue = $this->production_incharge->CurrentValue;
			$this->production_incharge->ViewCustomAttributes = "";

			// production_email
			$this->production_email->ViewValue = $this->production_email->CurrentValue;
			$this->production_email->ViewCustomAttributes = "";

			// production_phone
			$this->production_phone->ViewValue = $this->production_phone->CurrentValue;
			$this->production_phone->ViewCustomAttributes = "";

			// qc_incharge
			$this->qc_incharge->ViewValue = $this->qc_incharge->CurrentValue;
			$this->qc_incharge->ViewCustomAttributes = "";

			// qc_email
			$this->qc_email->ViewValue = $this->qc_email->CurrentValue;
			$this->qc_email->ViewCustomAttributes = "";

			// qc_phone
			$this->qc_phone->ViewValue = $this->qc_phone->CurrentValue;
			$this->qc_phone->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";
			$this->country->TooltipValue = "";

			// region
			$this->region->LinkCustomAttributes = "";
			$this->region->HrefValue = "";
			$this->region->TooltipValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";
			$this->city->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// performance
			$this->performance->LinkCustomAttributes = "";
			$this->performance->HrefValue = "";
			$this->performance->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// tax_registration
			$this->tax_registration->LinkCustomAttributes = "";
			$this->tax_registration->HrefValue = "";
			$this->tax_registration->TooltipValue = "";

			// cin
			$this->cin->LinkCustomAttributes = "";
			$this->cin->HrefValue = "";
			$this->cin->TooltipValue = "";

			// pan
			$this->pan->LinkCustomAttributes = "";
			$this->pan->HrefValue = "";
			$this->pan->TooltipValue = "";

			// tan
			$this->tan->LinkCustomAttributes = "";
			$this->tan->HrefValue = "";
			$this->tan->TooltipValue = "";

			// msme
			$this->msme->LinkCustomAttributes = "";
			$this->msme->HrefValue = "";
			$this->msme->TooltipValue = "";

			// port_air
			$this->port_air->LinkCustomAttributes = "";
			$this->port_air->HrefValue = "";
			$this->port_air->TooltipValue = "";

			// port_sea
			$this->port_sea->LinkCustomAttributes = "";
			$this->port_sea->HrefValue = "";
			$this->port_sea->TooltipValue = "";

			// iec
			$this->iec->LinkCustomAttributes = "";
			$this->iec->HrefValue = "";
			$this->iec->TooltipValue = "";

			// rex
			$this->rex->LinkCustomAttributes = "";
			$this->rex->HrefValue = "";
			$this->rex->TooltipValue = "";

			// rcmc
			$this->rcmc->LinkCustomAttributes = "";
			$this->rcmc->HrefValue = "";
			$this->rcmc->TooltipValue = "";

			// delivery_terms
			$this->delivery_terms->LinkCustomAttributes = "";
			$this->delivery_terms->HrefValue = "";
			$this->delivery_terms->TooltipValue = "";

			// shipping_terms
			$this->shipping_terms->LinkCustomAttributes = "";
			$this->shipping_terms->HrefValue = "";
			$this->shipping_terms->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// export_type
			$this->export_type->LinkCustomAttributes = "";
			$this->export_type->HrefValue = "";
			$this->export_type->TooltipValue = "";

			// lead_time_ss
			$this->lead_time_ss->LinkCustomAttributes = "";
			$this->lead_time_ss->HrefValue = "";
			$this->lead_time_ss->TooltipValue = "";

			// lead_time_cs
			$this->lead_time_cs->LinkCustomAttributes = "";
			$this->lead_time_cs->HrefValue = "";
			$this->lead_time_cs->TooltipValue = "";

			// cha
			$this->cha->LinkCustomAttributes = "";
			$this->cha->HrefValue = "";
			$this->cha->TooltipValue = "";

			// cha_email
			$this->cha_email->LinkCustomAttributes = "";
			$this->cha_email->HrefValue = "";
			$this->cha_email->TooltipValue = "";

			// cha_phone
			$this->cha_phone->LinkCustomAttributes = "";
			$this->cha_phone->HrefValue = "";
			$this->cha_phone->TooltipValue = "";

			// forwarder
			$this->forwarder->LinkCustomAttributes = "";
			$this->forwarder->HrefValue = "";
			$this->forwarder->TooltipValue = "";

			// forwarder_email
			$this->forwarder_email->LinkCustomAttributes = "";
			$this->forwarder_email->HrefValue = "";
			$this->forwarder_email->TooltipValue = "";

			// forwarder_phone
			$this->forwarder_phone->LinkCustomAttributes = "";
			$this->forwarder_phone->HrefValue = "";
			$this->forwarder_phone->TooltipValue = "";

			// merchant
			$this->merchant->LinkCustomAttributes = "";
			$this->merchant->HrefValue = "";
			$this->merchant->TooltipValue = "";

			// merchant_email
			$this->merchant_email->LinkCustomAttributes = "";
			$this->merchant_email->HrefValue = "";
			$this->merchant_email->TooltipValue = "";

			// merchant_phone
			$this->merchant_phone->LinkCustomAttributes = "";
			$this->merchant_phone->HrefValue = "";
			$this->merchant_phone->TooltipValue = "";

			// shipping_incharge
			$this->shipping_incharge->LinkCustomAttributes = "";
			$this->shipping_incharge->HrefValue = "";
			$this->shipping_incharge->TooltipValue = "";

			// shipping_email
			$this->shipping_email->LinkCustomAttributes = "";
			$this->shipping_email->HrefValue = "";
			$this->shipping_email->TooltipValue = "";

			// shipping_phone
			$this->shipping_phone->LinkCustomAttributes = "";
			$this->shipping_phone->HrefValue = "";
			$this->shipping_phone->TooltipValue = "";

			// account_incharge
			$this->account_incharge->LinkCustomAttributes = "";
			$this->account_incharge->HrefValue = "";
			$this->account_incharge->TooltipValue = "";

			// accounts_email
			$this->accounts_email->LinkCustomAttributes = "";
			$this->accounts_email->HrefValue = "";
			$this->accounts_email->TooltipValue = "";

			// accounts_phone
			$this->accounts_phone->LinkCustomAttributes = "";
			$this->accounts_phone->HrefValue = "";
			$this->accounts_phone->TooltipValue = "";

			// warehouse_incharge
			$this->warehouse_incharge->LinkCustomAttributes = "";
			$this->warehouse_incharge->HrefValue = "";
			$this->warehouse_incharge->TooltipValue = "";

			// warehouse_email
			$this->warehouse_email->LinkCustomAttributes = "";
			$this->warehouse_email->HrefValue = "";
			$this->warehouse_email->TooltipValue = "";

			// warehouse_phone
			$this->warehouse_phone->LinkCustomAttributes = "";
			$this->warehouse_phone->HrefValue = "";
			$this->warehouse_phone->TooltipValue = "";

			// production_incharge
			$this->production_incharge->LinkCustomAttributes = "";
			$this->production_incharge->HrefValue = "";
			$this->production_incharge->TooltipValue = "";

			// production_email
			$this->production_email->LinkCustomAttributes = "";
			$this->production_email->HrefValue = "";
			$this->production_email->TooltipValue = "";

			// production_phone
			$this->production_phone->LinkCustomAttributes = "";
			$this->production_phone->HrefValue = "";
			$this->production_phone->TooltipValue = "";

			// qc_incharge
			$this->qc_incharge->LinkCustomAttributes = "";
			$this->qc_incharge->HrefValue = "";
			$this->qc_incharge->TooltipValue = "";

			// qc_email
			$this->qc_email->LinkCustomAttributes = "";
			$this->qc_email->HrefValue = "";
			$this->qc_email->TooltipValue = "";

			// qc_phone
			$this->qc_phone->LinkCustomAttributes = "";
			$this->qc_phone->HrefValue = "";
			$this->qc_phone->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("shipping_address", $detailTblVar)) {
				if (!isset($GLOBALS["shipping_address_grid"]))
					$GLOBALS["shipping_address_grid"] = new shipping_address_grid();
				if ($GLOBALS["shipping_address_grid"]->DetailView) {
					$GLOBALS["shipping_address_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["shipping_address_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["shipping_address_grid"]->setStartRecordNumber(1);
					$GLOBALS["shipping_address_grid"]->_userid->IsDetailKey = TRUE;
					$GLOBALS["shipping_address_grid"]->_userid->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["shipping_address_grid"]->_userid->setSessionValue($GLOBALS["shipping_address_grid"]->_userid->CurrentValue);
				}
			}
			if (in_array("_bank_info", $detailTblVar)) {
				if (!isset($GLOBALS["_bank_info_grid"]))
					$GLOBALS["_bank_info_grid"] = new _bank_info_grid();
				if ($GLOBALS["_bank_info_grid"]->DetailView) {
					$GLOBALS["_bank_info_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["_bank_info_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["_bank_info_grid"]->setStartRecordNumber(1);
					$GLOBALS["_bank_info_grid"]->user_id->IsDetailKey = TRUE;
					$GLOBALS["_bank_info_grid"]->user_id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["_bank_info_grid"]->user_id->setSessionValue($GLOBALS["_bank_info_grid"]->user_id->CurrentValue);
				}
			}
			if (in_array("capacity_plan", $detailTblVar)) {
				if (!isset($GLOBALS["capacity_plan_grid"]))
					$GLOBALS["capacity_plan_grid"] = new capacity_plan_grid();
				if ($GLOBALS["capacity_plan_grid"]->DetailView) {
					$GLOBALS["capacity_plan_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["capacity_plan_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["capacity_plan_grid"]->setStartRecordNumber(1);
					$GLOBALS["capacity_plan_grid"]->user_id->IsDetailKey = TRUE;
					$GLOBALS["capacity_plan_grid"]->user_id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["capacity_plan_grid"]->user_id->setSessionValue($GLOBALS["capacity_plan_grid"]->user_id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("production_partnerlist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$pages->add(8);
		$pages->add(9);
		$pages->add(10);
		$pages->add(11);
		$pages->add(12);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('1', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_air":
					$lookupFilter = function() {
						return "`mode`=1 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_sea":
					$lookupFilter = function() {
						return "`mode`=0 and status =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_country":
							break;
						case "x_region":
							break;
						case "x_city":
							break;
						case "x_grp":
							break;
						case "x_category":
							break;
						case "x_reports_to":
							break;
						case "x_operator":
							break;
						case "x_incoterm":
							break;
						case "x_port_air":
							break;
						case "x_port_sea":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'production_partner');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>