<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for purchase_a
 */
class purchase_a extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $supplier;
	public $booking_reference;
	public $rid;
	public $lot_no;
	public $gross_weight;
	public $net_weight;
	public $packets;
	public $packing_type;
	public $containers;
	public $shipping_line;
	public $port_arrival_date;
	public $godown_arrival_date;
	public $godown;
	public $rack;
	public $invoice_details;
	public $invoice_value;
	public $currency_rate;
	public $purchase_amount_inr;
	public $duty_paid_by;
	public $custom_duty;
	public $transportation_charges;
	public $port_clearing_charge;
	public $cha_commission;
	public $cha_agent;
	public $clearance_bank;
	public $bank_charges;
	public $importer;
	public $remarks;
	public $fiba_fibd;
	public $fibc;
	public $operator;
	public $datetime;
	public $updated;
	public $grp;
	public $qc_remarks;
	public $qc_status;
	public $qc_operator;
	public $qc_datetime;
	public $rbi_compliance_date;
	public $age;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'purchase_a';
		$this->TableName = 'purchase_a';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`purchase_a`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('purchase_a', 'purchase_a', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// supplier
		$this->supplier = new DbField('purchase_a', 'purchase_a', 'x_supplier', 'supplier', '`supplier`', '`supplier`', 19, -1, FALSE, '`supplier`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->supplier->Nullable = FALSE; // NOT NULL field
		$this->supplier->Required = TRUE; // Required field
		$this->supplier->Sortable = TRUE; // Allow sort
		$this->supplier->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->supplier->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->supplier->Lookup = new Lookup('supplier', 'production_partner', TRUE, 'id', ["name","code","",""], [], ["x_booking_reference"], [], [], [], [], '`category` ASC', '');
		$this->supplier->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['supplier'] = &$this->supplier;

		// booking_reference
		$this->booking_reference = new DbField('purchase_a', 'purchase_a', 'x_booking_reference', 'booking_reference', '`booking_reference`', '`booking_reference`', 18, -1, FALSE, '`booking_reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->booking_reference->Nullable = FALSE; // NOT NULL field
		$this->booking_reference->Required = TRUE; // Required field
		$this->booking_reference->Sortable = TRUE; // Allow sort
		$this->booking_reference->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->booking_reference->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->booking_reference->Lookup = new Lookup('booking_reference', 'booking_ref', FALSE, 'id', ["ref","","",""], ["x_supplier"], [], ["supplier_id"], ["x_supplier_id"], ["rid"], ["x_rid"], '`ref` ASC', '');
		$this->booking_reference->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['booking_reference'] = &$this->booking_reference;

		// rid
		$this->rid = new DbField('purchase_a', 'purchase_a', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = FALSE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref', TRUE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// lot_no
		$this->lot_no = new DbField('purchase_a', 'purchase_a', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Nullable = FALSE; // NOT NULL field
		$this->lot_no->Required = TRUE; // Required field
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// gross_weight
		$this->gross_weight = new DbField('purchase_a', 'purchase_a', 'x_gross_weight', 'gross_weight', '`gross_weight`', '`gross_weight`', 131, -1, FALSE, '`gross_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gross_weight->Sortable = TRUE; // Allow sort
		$this->gross_weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['gross_weight'] = &$this->gross_weight;

		// net_weight
		$this->net_weight = new DbField('purchase_a', 'purchase_a', 'x_net_weight', 'net_weight', '`net_weight`', '`net_weight`', 131, -1, FALSE, '`net_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->net_weight->Nullable = FALSE; // NOT NULL field
		$this->net_weight->Required = TRUE; // Required field
		$this->net_weight->Sortable = TRUE; // Allow sort
		$this->net_weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['net_weight'] = &$this->net_weight;

		// packets
		$this->packets = new DbField('purchase_a', 'purchase_a', 'x_packets', 'packets', '`packets`', '`packets`', 18, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Required = TRUE; // Required field
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packets'] = &$this->packets;

		// packing_type
		$this->packing_type = new DbField('purchase_a', 'purchase_a', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 17, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","code","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// containers
		$this->containers = new DbField('purchase_a', 'purchase_a', 'x_containers', 'containers', '`containers`', '`containers`', 131, -1, FALSE, '`containers`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->containers->Nullable = FALSE; // NOT NULL field
		$this->containers->Required = TRUE; // Required field
		$this->containers->Sortable = TRUE; // Allow sort
		$this->containers->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['containers'] = &$this->containers;

		// shipping_line
		$this->shipping_line = new DbField('purchase_a', 'purchase_a', 'x_shipping_line', 'shipping_line', '`shipping_line`', '`shipping_line`', 17, -1, FALSE, '`shipping_line`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shipping_line->Sortable = TRUE; // Allow sort
		$this->shipping_line->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shipping_line->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shipping_line->Lookup = new Lookup('shipping_line', 'shipping_line', FALSE, 'id', ["shipping_line","","",""], [], [], [], [], [], [], '`shipping_line` ASC', '');
		$this->fields['shipping_line'] = &$this->shipping_line;

		// port_arrival_date
		$this->port_arrival_date = new DbField('purchase_a', 'purchase_a', 'x_port_arrival_date', 'port_arrival_date', '`port_arrival_date`', CastDateFieldForLike('`port_arrival_date`', 0, "DB"), 135, 0, FALSE, '`port_arrival_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->port_arrival_date->Sortable = TRUE; // Allow sort
		$this->port_arrival_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['port_arrival_date'] = &$this->port_arrival_date;

		// godown_arrival_date
		$this->godown_arrival_date = new DbField('purchase_a', 'purchase_a', 'x_godown_arrival_date', 'godown_arrival_date', '`godown_arrival_date`', CastDateFieldForLike('`godown_arrival_date`', 0, "DB"), 135, 0, FALSE, '`godown_arrival_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown_arrival_date->Sortable = TRUE; // Allow sort
		$this->godown_arrival_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['godown_arrival_date'] = &$this->godown_arrival_date;

		// godown
		$this->godown = new DbField('purchase_a', 'purchase_a', 'x_godown', 'godown', '`godown`', '`godown`', 17, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// rack
		$this->rack = new DbField('purchase_a', 'purchase_a', 'x_rack', 'rack', '`rack`', '`rack`', 200, -1, FALSE, '`rack`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rack->Nullable = FALSE; // NOT NULL field
		$this->rack->Required = TRUE; // Required field
		$this->rack->Sortable = TRUE; // Allow sort
		$this->fields['rack'] = &$this->rack;

		// invoice_details
		$this->invoice_details = new DbField('purchase_a', 'purchase_a', 'x_invoice_details', 'invoice_details', '`invoice_details`', '`invoice_details`', 200, -1, FALSE, '`invoice_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_details->Sortable = TRUE; // Allow sort
		$this->fields['invoice_details'] = &$this->invoice_details;

		// invoice_value
		$this->invoice_value = new DbField('purchase_a', 'purchase_a', 'x_invoice_value', 'invoice_value', '`invoice_value`', '`invoice_value`', 131, -1, FALSE, '`invoice_value`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_value->Sortable = TRUE; // Allow sort
		$this->invoice_value->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['invoice_value'] = &$this->invoice_value;

		// currency_rate
		$this->currency_rate = new DbField('purchase_a', 'purchase_a', 'x_currency_rate', 'currency_rate', '`currency_rate`', '`currency_rate`', 131, -1, FALSE, '`currency_rate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->currency_rate->Sortable = TRUE; // Allow sort
		$this->currency_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['currency_rate'] = &$this->currency_rate;

		// purchase_amount_inr
		$this->purchase_amount_inr = new DbField('purchase_a', 'purchase_a', 'x_purchase_amount_inr', 'purchase_amount_inr', '`purchase_amount_inr`', '`purchase_amount_inr`', 131, -1, FALSE, '`purchase_amount_inr`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->purchase_amount_inr->Sortable = TRUE; // Allow sort
		$this->purchase_amount_inr->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['purchase_amount_inr'] = &$this->purchase_amount_inr;

		// duty_paid_by
		$this->duty_paid_by = new DbField('purchase_a', 'purchase_a', 'x_duty_paid_by', 'duty_paid_by', '`duty_paid_by`', '`duty_paid_by`', 17, -1, FALSE, '`duty_paid_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->duty_paid_by->Sortable = TRUE; // Allow sort
		$this->duty_paid_by->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->duty_paid_by->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->duty_paid_by->Lookup = new Lookup('duty_paid_by', 'purchase_a', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->duty_paid_by->OptionCount = 2;
		$this->duty_paid_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['duty_paid_by'] = &$this->duty_paid_by;

		// custom_duty
		$this->custom_duty = new DbField('purchase_a', 'purchase_a', 'x_custom_duty', 'custom_duty', '`custom_duty`', '`custom_duty`', 131, -1, FALSE, '`custom_duty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->custom_duty->Sortable = TRUE; // Allow sort
		$this->custom_duty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['custom_duty'] = &$this->custom_duty;

		// transportation_charges
		$this->transportation_charges = new DbField('purchase_a', 'purchase_a', 'x_transportation_charges', 'transportation_charges', '`transportation_charges`', '`transportation_charges`', 131, -1, FALSE, '`transportation_charges`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->transportation_charges->Sortable = TRUE; // Allow sort
		$this->transportation_charges->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['transportation_charges'] = &$this->transportation_charges;

		// port_clearing_charge
		$this->port_clearing_charge = new DbField('purchase_a', 'purchase_a', 'x_port_clearing_charge', 'port_clearing_charge', '`port_clearing_charge`', '`port_clearing_charge`', 131, -1, FALSE, '`port_clearing_charge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->port_clearing_charge->Sortable = TRUE; // Allow sort
		$this->port_clearing_charge->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['port_clearing_charge'] = &$this->port_clearing_charge;

		// cha_commission
		$this->cha_commission = new DbField('purchase_a', 'purchase_a', 'x_cha_commission', 'cha_commission', '`cha_commission`', '`cha_commission`', 131, -1, FALSE, '`cha_commission`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cha_commission->Sortable = TRUE; // Allow sort
		$this->cha_commission->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cha_commission'] = &$this->cha_commission;

		// cha_agent
		$this->cha_agent = new DbField('purchase_a', 'purchase_a', 'x_cha_agent', 'cha_agent', '`cha_agent`', '`cha_agent`', 17, -1, FALSE, '`cha_agent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->cha_agent->Sortable = TRUE; // Allow sort
		$this->cha_agent->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->cha_agent->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->cha_agent->Lookup = new Lookup('cha_agent', 'cha_agent', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['cha_agent'] = &$this->cha_agent;

		// clearance_bank
		$this->clearance_bank = new DbField('purchase_a', 'purchase_a', 'x_clearance_bank', 'clearance_bank', '`clearance_bank`', '`clearance_bank`', 17, -1, FALSE, '`clearance_bank`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->clearance_bank->Sortable = TRUE; // Allow sort
		$this->clearance_bank->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->clearance_bank->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->clearance_bank->Lookup = new Lookup('clearance_bank', 'bank', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['clearance_bank'] = &$this->clearance_bank;

		// bank_charges
		$this->bank_charges = new DbField('purchase_a', 'purchase_a', 'x_bank_charges', 'bank_charges', '`bank_charges`', '`bank_charges`', 131, -1, FALSE, '`bank_charges`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_charges->Sortable = TRUE; // Allow sort
		$this->fields['bank_charges'] = &$this->bank_charges;

		// importer
		$this->importer = new DbField('purchase_a', 'purchase_a', 'x_importer', 'importer', '`importer`', '`importer`', 17, -1, FALSE, '`importer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->importer->Sortable = TRUE; // Allow sort
		$this->importer->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->importer->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->importer->Lookup = new Lookup('importer', 'importer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->importer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['importer'] = &$this->importer;

		// remarks
		$this->remarks = new DbField('purchase_a', 'purchase_a', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// fiba_fibd
		$this->fiba_fibd = new DbField('purchase_a', 'purchase_a', 'x_fiba_fibd', 'fiba_fibd', '`fiba_fibd`', '`fiba_fibd`', 200, -1, FALSE, '`fiba_fibd`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fiba_fibd->Nullable = FALSE; // NOT NULL field
		$this->fiba_fibd->Required = TRUE; // Required field
		$this->fiba_fibd->Sortable = TRUE; // Allow sort
		$this->fields['fiba_fibd'] = &$this->fiba_fibd;

		// fibc
		$this->fibc = new DbField('purchase_a', 'purchase_a', 'x_fibc', 'fibc', '`fibc`', '`fibc`', 200, -1, FALSE, '`fibc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fibc->Nullable = FALSE; // NOT NULL field
		$this->fibc->Required = TRUE; // Required field
		$this->fibc->Sortable = TRUE; // Allow sort
		$this->fields['fibc'] = &$this->fibc;

		// operator
		$this->operator = new DbField('purchase_a', 'purchase_a', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('purchase_a', 'purchase_a', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// updated
		$this->updated = new DbField('purchase_a', 'purchase_a', 'x_updated', 'updated', '`updated`', '`updated`', 16, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Nullable = FALSE; // NOT NULL field
		$this->updated->Sortable = FALSE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;

		// grp
		$this->grp = new DbField('purchase_a', 'purchase_a', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// qc_remarks
		$this->qc_remarks = new DbField('purchase_a', 'purchase_a', 'x_qc_remarks', 'qc_remarks', '`qc_remarks`', '`qc_remarks`', 201, -1, FALSE, '`qc_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->qc_remarks->Sortable = TRUE; // Allow sort
		$this->fields['qc_remarks'] = &$this->qc_remarks;

		// qc_status
		$this->qc_status = new DbField('purchase_a', 'purchase_a', 'x_qc_status', 'qc_status', '`qc_status`', '`qc_status`', 2, -1, FALSE, '`qc_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qc_status->Sortable = TRUE; // Allow sort
		$this->qc_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['qc_status'] = &$this->qc_status;

		// qc_operator
		$this->qc_operator = new DbField('purchase_a', 'purchase_a', 'x_qc_operator', 'qc_operator', '`qc_operator`', '`qc_operator`', 2, -1, FALSE, '`qc_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qc_operator->Sortable = TRUE; // Allow sort
		$this->qc_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['qc_operator'] = &$this->qc_operator;

		// qc_datetime
		$this->qc_datetime = new DbField('purchase_a', 'purchase_a', 'x_qc_datetime', 'qc_datetime', '`qc_datetime`', CastDateFieldForLike('`qc_datetime`', 0, "DB"), 135, 0, FALSE, '`qc_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qc_datetime->Sortable = TRUE; // Allow sort
		$this->qc_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['qc_datetime'] = &$this->qc_datetime;

		// rbi_compliance_date
		$this->rbi_compliance_date = new DbField('purchase_a', 'purchase_a', 'x_rbi_compliance_date', 'rbi_compliance_date', '`rbi_compliance_date`', CastDateFieldForLike('`rbi_compliance_date`', 0, "DB"), 133, 0, FALSE, '`rbi_compliance_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rbi_compliance_date->Sortable = TRUE; // Allow sort
		$this->rbi_compliance_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['rbi_compliance_date'] = &$this->rbi_compliance_date;

		// age
		$this->age = new DbField('purchase_a', 'purchase_a', 'x_age', 'age', '`age`', '`age`', 2, -1, FALSE, '`age`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->age->Nullable = FALSE; // NOT NULL field
		$this->age->Sortable = TRUE; // Allow sort
		$this->age->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['age'] = &$this->age;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`purchase_a`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->supplier->DbValue = $row['supplier'];
		$this->booking_reference->DbValue = $row['booking_reference'];
		$this->rid->DbValue = $row['rid'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->gross_weight->DbValue = $row['gross_weight'];
		$this->net_weight->DbValue = $row['net_weight'];
		$this->packets->DbValue = $row['packets'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->containers->DbValue = $row['containers'];
		$this->shipping_line->DbValue = $row['shipping_line'];
		$this->port_arrival_date->DbValue = $row['port_arrival_date'];
		$this->godown_arrival_date->DbValue = $row['godown_arrival_date'];
		$this->godown->DbValue = $row['godown'];
		$this->rack->DbValue = $row['rack'];
		$this->invoice_details->DbValue = $row['invoice_details'];
		$this->invoice_value->DbValue = $row['invoice_value'];
		$this->currency_rate->DbValue = $row['currency_rate'];
		$this->purchase_amount_inr->DbValue = $row['purchase_amount_inr'];
		$this->duty_paid_by->DbValue = $row['duty_paid_by'];
		$this->custom_duty->DbValue = $row['custom_duty'];
		$this->transportation_charges->DbValue = $row['transportation_charges'];
		$this->port_clearing_charge->DbValue = $row['port_clearing_charge'];
		$this->cha_commission->DbValue = $row['cha_commission'];
		$this->cha_agent->DbValue = $row['cha_agent'];
		$this->clearance_bank->DbValue = $row['clearance_bank'];
		$this->bank_charges->DbValue = $row['bank_charges'];
		$this->importer->DbValue = $row['importer'];
		$this->remarks->DbValue = $row['remarks'];
		$this->fiba_fibd->DbValue = $row['fiba_fibd'];
		$this->fibc->DbValue = $row['fibc'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->updated->DbValue = $row['updated'];
		$this->grp->DbValue = $row['grp'];
		$this->qc_remarks->DbValue = $row['qc_remarks'];
		$this->qc_status->DbValue = $row['qc_status'];
		$this->qc_operator->DbValue = $row['qc_operator'];
		$this->qc_datetime->DbValue = $row['qc_datetime'];
		$this->rbi_compliance_date->DbValue = $row['rbi_compliance_date'];
		$this->age->DbValue = $row['age'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "purchase_alist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "purchase_aview.php")
			return $Language->phrase("View");
		elseif ($pageName == "purchase_aedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "purchase_aadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "purchase_alist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("purchase_aview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("purchase_aview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "purchase_aadd.php?" . $this->getUrlParm($parm);
		else
			$url = "purchase_aadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("purchase_aedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("purchase_aadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("purchase_adelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->supplier->setDbValue($rs->fields('supplier'));
		$this->booking_reference->setDbValue($rs->fields('booking_reference'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->gross_weight->setDbValue($rs->fields('gross_weight'));
		$this->net_weight->setDbValue($rs->fields('net_weight'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->containers->setDbValue($rs->fields('containers'));
		$this->shipping_line->setDbValue($rs->fields('shipping_line'));
		$this->port_arrival_date->setDbValue($rs->fields('port_arrival_date'));
		$this->godown_arrival_date->setDbValue($rs->fields('godown_arrival_date'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->rack->setDbValue($rs->fields('rack'));
		$this->invoice_details->setDbValue($rs->fields('invoice_details'));
		$this->invoice_value->setDbValue($rs->fields('invoice_value'));
		$this->currency_rate->setDbValue($rs->fields('currency_rate'));
		$this->purchase_amount_inr->setDbValue($rs->fields('purchase_amount_inr'));
		$this->duty_paid_by->setDbValue($rs->fields('duty_paid_by'));
		$this->custom_duty->setDbValue($rs->fields('custom_duty'));
		$this->transportation_charges->setDbValue($rs->fields('transportation_charges'));
		$this->port_clearing_charge->setDbValue($rs->fields('port_clearing_charge'));
		$this->cha_commission->setDbValue($rs->fields('cha_commission'));
		$this->cha_agent->setDbValue($rs->fields('cha_agent'));
		$this->clearance_bank->setDbValue($rs->fields('clearance_bank'));
		$this->bank_charges->setDbValue($rs->fields('bank_charges'));
		$this->importer->setDbValue($rs->fields('importer'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->fiba_fibd->setDbValue($rs->fields('fiba_fibd'));
		$this->fibc->setDbValue($rs->fields('fibc'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->updated->setDbValue($rs->fields('updated'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->qc_remarks->setDbValue($rs->fields('qc_remarks'));
		$this->qc_status->setDbValue($rs->fields('qc_status'));
		$this->qc_operator->setDbValue($rs->fields('qc_operator'));
		$this->qc_datetime->setDbValue($rs->fields('qc_datetime'));
		$this->rbi_compliance_date->setDbValue($rs->fields('rbi_compliance_date'));
		$this->age->setDbValue($rs->fields('age'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// supplier
		// booking_reference
		// rid

		$this->rid->CellCssStyle = "white-space: nowrap;";

		// lot_no
		// gross_weight
		// net_weight
		// packets
		// packing_type
		// containers
		// shipping_line
		// port_arrival_date
		// godown_arrival_date
		// godown
		// rack
		// invoice_details
		// invoice_value
		// currency_rate
		// purchase_amount_inr
		// duty_paid_by
		// custom_duty
		// transportation_charges
		// port_clearing_charge
		// cha_commission
		// cha_agent
		// clearance_bank
		// bank_charges
		// importer
		// remarks
		// fiba_fibd
		// fibc
		// operator
		// datetime
		// updated

		$this->updated->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// qc_remarks
		// qc_status
		// qc_operator
		// qc_datetime
		// rbi_compliance_date
		// age
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// supplier
		$curVal = strval($this->supplier->CurrentValue);
		if ($curVal <> "") {
			$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
			if ($this->supplier->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `category` = 200";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->supplier->ViewValue = $this->supplier->CurrentValue;
				}
			}
		} else {
			$this->supplier->ViewValue = NULL;
		}
		$this->supplier->ViewCustomAttributes = "";

		// booking_reference
		$curVal = strval($this->booking_reference->CurrentValue);
		if ($curVal <> "") {
			$this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
			if ($this->booking_reference->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->booking_reference->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
				}
			}
		} else {
			$this->booking_reference->ViewValue = NULL;
		}
		$this->booking_reference->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// gross_weight
		$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
		$this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, 3, -2, -2, -2);
		$this->gross_weight->ViewCustomAttributes = "";

		// net_weight
		$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
		$this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, 3, -2, -2, -2);
		$this->net_weight->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
		$this->packets->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` = 1 and grp = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// containers
		$this->containers->ViewValue = $this->containers->CurrentValue;
		$this->containers->ViewValue = FormatNumber($this->containers->ViewValue, 2, -2, -2, -2);
		$this->containers->ViewCustomAttributes = "";

		// shipping_line
		$curVal = strval($this->shipping_line->CurrentValue);
		if ($curVal <> "") {
			$this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
			if ($this->shipping_line->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->shipping_line->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
				}
			}
		} else {
			$this->shipping_line->ViewValue = NULL;
		}
		$this->shipping_line->ViewCustomAttributes = "";

		// port_arrival_date
		$this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
		$this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, 0);
		$this->port_arrival_date->ViewCustomAttributes = "";

		// godown_arrival_date
		$this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
		$this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, 0);
		$this->godown_arrival_date->ViewCustomAttributes = "";

		// godown
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// rack
		$this->rack->ViewValue = $this->rack->CurrentValue;
		$this->rack->ViewCustomAttributes = "";

		// invoice_details
		$this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;
		$this->invoice_details->ViewCustomAttributes = "";

		// invoice_value
		$this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
		$this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, 2, -2, -2, -2);
		$this->invoice_value->ViewCustomAttributes = "";

		// currency_rate
		$this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
		$this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, 3, -2, -2, -2);
		$this->currency_rate->ViewCustomAttributes = "";

		// purchase_amount_inr
		$this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
		$this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, 2, -2, -2, -2);
		$this->purchase_amount_inr->ViewCustomAttributes = "";

		// duty_paid_by
		if (strval($this->duty_paid_by->CurrentValue) <> "") {
			$this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
		} else {
			$this->duty_paid_by->ViewValue = NULL;
		}
		$this->duty_paid_by->ViewCustomAttributes = "";

		// custom_duty
		$this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
		$this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, 2, -2, -2, -2);
		$this->custom_duty->ViewCustomAttributes = "";

		// transportation_charges
		$this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
		$this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, 2, -2, -2, -2);
		$this->transportation_charges->ViewCustomAttributes = "";

		// port_clearing_charge
		$this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
		$this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, 2, -2, -2, -2);
		$this->port_clearing_charge->ViewCustomAttributes = "";

		// cha_commission
		$this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
		$this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, 2, -2, -2, -2);
		$this->cha_commission->ViewCustomAttributes = "";

		// cha_agent
		$curVal = strval($this->cha_agent->CurrentValue);
		if ($curVal <> "") {
			$this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
			if ($this->cha_agent->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cha_agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
				}
			}
		} else {
			$this->cha_agent->ViewValue = NULL;
		}
		$this->cha_agent->ViewCustomAttributes = "";

		// clearance_bank
		$curVal = strval($this->clearance_bank->CurrentValue);
		if ($curVal <> "") {
			$this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
			if ($this->clearance_bank->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->clearance_bank->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
				}
			}
		} else {
			$this->clearance_bank->ViewValue = NULL;
		}
		$this->clearance_bank->ViewCustomAttributes = "";

		// bank_charges
		$this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
		$this->bank_charges->ViewCustomAttributes = "";

		// importer
		$curVal = strval($this->importer->CurrentValue);
		if ($curVal <> "") {
			$this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
			if ($this->importer->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` IN (0,1)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->importer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->importer->ViewValue = $this->importer->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->importer->ViewValue = $this->importer->CurrentValue;
				}
			}
		} else {
			$this->importer->ViewValue = NULL;
		}
		$this->importer->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// fiba_fibd
		$this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;
		$this->fiba_fibd->ViewCustomAttributes = "";

		// fibc
		$this->fibc->ViewValue = $this->fibc->CurrentValue;
		$this->fibc->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// qc_remarks
		$this->qc_remarks->ViewValue = $this->qc_remarks->CurrentValue;
		$this->qc_remarks->ViewCustomAttributes = "";

		// qc_status
		$this->qc_status->ViewValue = $this->qc_status->CurrentValue;
		$this->qc_status->ViewValue = FormatNumber($this->qc_status->ViewValue, 0, -2, -2, -2);
		$this->qc_status->ViewCustomAttributes = "";

		// qc_operator
		$this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
		$this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, 0, -2, -2, -2);
		$this->qc_operator->ViewCustomAttributes = "";

		// qc_datetime
		$this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
		$this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, 0);
		$this->qc_datetime->ViewCustomAttributes = "";

		// rbi_compliance_date
		$this->rbi_compliance_date->ViewValue = $this->rbi_compliance_date->CurrentValue;
		$this->rbi_compliance_date->ViewValue = FormatDateTime($this->rbi_compliance_date->ViewValue, 0);
		$this->rbi_compliance_date->ViewCustomAttributes = "";

		// age
		$this->age->ViewValue = $this->age->CurrentValue;
		$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
		$this->age->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// supplier
		$this->supplier->LinkCustomAttributes = "";
		if (!EmptyValue($this->supplier->CurrentValue)) {
			$this->supplier->HrefValue = "purchase_a_flist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
			$this->supplier->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
		} else {
			$this->supplier->HrefValue = "";
		}
		$this->supplier->TooltipValue = "";

		// booking_reference
		$this->booking_reference->LinkCustomAttributes = "";
		$this->booking_reference->HrefValue = "";
		$this->booking_reference->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "purchase_a_flist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// gross_weight
		$this->gross_weight->LinkCustomAttributes = "";
		$this->gross_weight->HrefValue = "";
		$this->gross_weight->TooltipValue = "";

		// net_weight
		$this->net_weight->LinkCustomAttributes = "";
		$this->net_weight->HrefValue = "";
		$this->net_weight->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->packing_type->CurrentValue)) {
			$this->packing_type->HrefValue = "purchase_a_flist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
			$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
		} else {
			$this->packing_type->HrefValue = "";
		}
		$this->packing_type->TooltipValue = "";

		// containers
		$this->containers->LinkCustomAttributes = "";
		$this->containers->HrefValue = "";
		$this->containers->TooltipValue = "";

		// shipping_line
		$this->shipping_line->LinkCustomAttributes = "";
		$this->shipping_line->HrefValue = "";
		$this->shipping_line->TooltipValue = "";

		// port_arrival_date
		$this->port_arrival_date->LinkCustomAttributes = "";
		$this->port_arrival_date->HrefValue = "";
		$this->port_arrival_date->TooltipValue = "";

		// godown_arrival_date
		$this->godown_arrival_date->LinkCustomAttributes = "";
		$this->godown_arrival_date->HrefValue = "";
		$this->godown_arrival_date->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "purchase_a_flist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// rack
		$this->rack->LinkCustomAttributes = "";
		$this->rack->HrefValue = "";
		$this->rack->TooltipValue = "";

		// invoice_details
		$this->invoice_details->LinkCustomAttributes = "";
		$this->invoice_details->HrefValue = "";
		$this->invoice_details->TooltipValue = "";

		// invoice_value
		$this->invoice_value->LinkCustomAttributes = "";
		$this->invoice_value->HrefValue = "";
		$this->invoice_value->TooltipValue = "";

		// currency_rate
		$this->currency_rate->LinkCustomAttributes = "";
		$this->currency_rate->HrefValue = "";
		$this->currency_rate->TooltipValue = "";

		// purchase_amount_inr
		$this->purchase_amount_inr->LinkCustomAttributes = "";
		$this->purchase_amount_inr->HrefValue = "";
		$this->purchase_amount_inr->TooltipValue = "";

		// duty_paid_by
		$this->duty_paid_by->LinkCustomAttributes = "";
		$this->duty_paid_by->HrefValue = "";
		$this->duty_paid_by->TooltipValue = "";

		// custom_duty
		$this->custom_duty->LinkCustomAttributes = "";
		$this->custom_duty->HrefValue = "";
		$this->custom_duty->TooltipValue = "";

		// transportation_charges
		$this->transportation_charges->LinkCustomAttributes = "";
		$this->transportation_charges->HrefValue = "";
		$this->transportation_charges->TooltipValue = "";

		// port_clearing_charge
		$this->port_clearing_charge->LinkCustomAttributes = "";
		$this->port_clearing_charge->HrefValue = "";
		$this->port_clearing_charge->TooltipValue = "";

		// cha_commission
		$this->cha_commission->LinkCustomAttributes = "";
		$this->cha_commission->HrefValue = "";
		$this->cha_commission->TooltipValue = "";

		// cha_agent
		$this->cha_agent->LinkCustomAttributes = "";
		$this->cha_agent->HrefValue = "";
		$this->cha_agent->TooltipValue = "";

		// clearance_bank
		$this->clearance_bank->LinkCustomAttributes = "";
		$this->clearance_bank->HrefValue = "";
		$this->clearance_bank->TooltipValue = "";

		// bank_charges
		$this->bank_charges->LinkCustomAttributes = "";
		$this->bank_charges->HrefValue = "";
		$this->bank_charges->TooltipValue = "";

		// importer
		$this->importer->LinkCustomAttributes = "";
		$this->importer->HrefValue = "";
		$this->importer->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// fiba_fibd
		$this->fiba_fibd->LinkCustomAttributes = "";
		$this->fiba_fibd->HrefValue = "";
		$this->fiba_fibd->TooltipValue = "";

		// fibc
		$this->fibc->LinkCustomAttributes = "";
		$this->fibc->HrefValue = "";
		$this->fibc->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// qc_remarks
		$this->qc_remarks->LinkCustomAttributes = "";
		$this->qc_remarks->HrefValue = "";
		$this->qc_remarks->TooltipValue = "";

		// qc_status
		$this->qc_status->LinkCustomAttributes = "";
		$this->qc_status->HrefValue = "";
		$this->qc_status->TooltipValue = "";

		// qc_operator
		$this->qc_operator->LinkCustomAttributes = "";
		$this->qc_operator->HrefValue = "";
		$this->qc_operator->TooltipValue = "";

		// qc_datetime
		$this->qc_datetime->LinkCustomAttributes = "";
		$this->qc_datetime->HrefValue = "";
		$this->qc_datetime->TooltipValue = "";

		// rbi_compliance_date
		$this->rbi_compliance_date->LinkCustomAttributes = "";
		$this->rbi_compliance_date->HrefValue = "";
		$this->rbi_compliance_date->TooltipValue = "";

		// age
		$this->age->LinkCustomAttributes = "";
		$this->age->HrefValue = "";
		$this->age->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// supplier
		$this->supplier->EditAttrs["class"] = "form-control";
		$this->supplier->EditCustomAttributes = "";
		$curVal = strval($this->supplier->CurrentValue);
		if ($curVal <> "") {
			$this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
			if ($this->supplier->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `category` = 200";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->supplier->EditValue = $this->supplier->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->supplier->EditValue = $this->supplier->CurrentValue;
				}
			}
		} else {
			$this->supplier->EditValue = NULL;
		}
		$this->supplier->ViewCustomAttributes = "";

		// booking_reference
		$this->booking_reference->EditAttrs["class"] = "form-control";
		$this->booking_reference->EditCustomAttributes = "";
		$curVal = strval($this->booking_reference->CurrentValue);
		if ($curVal <> "") {
			$this->booking_reference->EditValue = $this->booking_reference->lookupCacheOption($curVal);
			if ($this->booking_reference->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->booking_reference->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->booking_reference->EditValue = $this->booking_reference->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->booking_reference->EditValue = $this->booking_reference->CurrentValue;
				}
			}
		} else {
			$this->booking_reference->EditValue = NULL;
		}
		$this->booking_reference->ViewCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = 'ReadOnly';
		$this->rid->EditValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// gross_weight
		$this->gross_weight->EditAttrs["class"] = "form-control";
		$this->gross_weight->EditCustomAttributes = "";
		$this->gross_weight->EditValue = $this->gross_weight->CurrentValue;
		$this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());
		if (strval($this->gross_weight->EditValue) <> "" && is_numeric($this->gross_weight->EditValue))
			$this->gross_weight->EditValue = FormatNumber($this->gross_weight->EditValue, -2, -2, -2, -2);

		// net_weight
		$this->net_weight->EditAttrs["class"] = "form-control";
		$this->net_weight->EditCustomAttributes = "";
		$this->net_weight->EditValue = $this->net_weight->CurrentValue;
		$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
		if (strval($this->net_weight->EditValue) <> "" && is_numeric($this->net_weight->EditValue))
			$this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, -2, -2, -2, -2);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// containers
		$this->containers->EditAttrs["class"] = "form-control";
		$this->containers->EditCustomAttributes = "";
		$this->containers->EditValue = $this->containers->CurrentValue;
		$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
		if (strval($this->containers->EditValue) <> "" && is_numeric($this->containers->EditValue))
			$this->containers->EditValue = FormatNumber($this->containers->EditValue, -2, -2, -2, -2);

		// shipping_line
		$this->shipping_line->EditAttrs["class"] = "form-control";
		$this->shipping_line->EditCustomAttributes = "";

		// port_arrival_date
		$this->port_arrival_date->EditAttrs["class"] = "form-control";
		$this->port_arrival_date->EditCustomAttributes = "";
		$this->port_arrival_date->EditValue = FormatDateTime($this->port_arrival_date->CurrentValue, 8);
		$this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());

		// godown_arrival_date
		$this->godown_arrival_date->EditAttrs["class"] = "form-control";
		$this->godown_arrival_date->EditCustomAttributes = "";
		$this->godown_arrival_date->EditValue = FormatDateTime($this->godown_arrival_date->CurrentValue, 8);
		$this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";

		// rack
		$this->rack->EditAttrs["class"] = "form-control";
		$this->rack->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rack->CurrentValue = HtmlDecode($this->rack->CurrentValue);
		$this->rack->EditValue = $this->rack->CurrentValue;
		$this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

		// invoice_details
		$this->invoice_details->EditAttrs["class"] = "form-control";
		$this->invoice_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->invoice_details->CurrentValue = HtmlDecode($this->invoice_details->CurrentValue);
		$this->invoice_details->EditValue = $this->invoice_details->CurrentValue;
		$this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

		// invoice_value
		$this->invoice_value->EditAttrs["class"] = "form-control";
		$this->invoice_value->EditCustomAttributes = "";
		$this->invoice_value->EditValue = $this->invoice_value->CurrentValue;
		$this->invoice_value->PlaceHolder = RemoveHtml($this->invoice_value->caption());
		if (strval($this->invoice_value->EditValue) <> "" && is_numeric($this->invoice_value->EditValue))
			$this->invoice_value->EditValue = FormatNumber($this->invoice_value->EditValue, -2, -2, -2, -2);

		// currency_rate
		$this->currency_rate->EditAttrs["class"] = "form-control";
		$this->currency_rate->EditCustomAttributes = "";
		$this->currency_rate->EditValue = $this->currency_rate->CurrentValue;
		$this->currency_rate->PlaceHolder = RemoveHtml($this->currency_rate->caption());
		if (strval($this->currency_rate->EditValue) <> "" && is_numeric($this->currency_rate->EditValue))
			$this->currency_rate->EditValue = FormatNumber($this->currency_rate->EditValue, -2, -2, -2, -2);

		// purchase_amount_inr
		$this->purchase_amount_inr->EditAttrs["class"] = "form-control";
		$this->purchase_amount_inr->EditCustomAttributes = "";
		$this->purchase_amount_inr->EditValue = $this->purchase_amount_inr->CurrentValue;
		$this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());
		if (strval($this->purchase_amount_inr->EditValue) <> "" && is_numeric($this->purchase_amount_inr->EditValue))
			$this->purchase_amount_inr->EditValue = FormatNumber($this->purchase_amount_inr->EditValue, -2, -2, -2, -2);

		// duty_paid_by
		$this->duty_paid_by->EditAttrs["class"] = "form-control";
		$this->duty_paid_by->EditCustomAttributes = "";
		$this->duty_paid_by->EditValue = $this->duty_paid_by->options(TRUE);

		// custom_duty
		$this->custom_duty->EditAttrs["class"] = "form-control";
		$this->custom_duty->EditCustomAttributes = "";
		$this->custom_duty->EditValue = $this->custom_duty->CurrentValue;
		$this->custom_duty->PlaceHolder = RemoveHtml($this->custom_duty->caption());
		if (strval($this->custom_duty->EditValue) <> "" && is_numeric($this->custom_duty->EditValue))
			$this->custom_duty->EditValue = FormatNumber($this->custom_duty->EditValue, -2, -2, -2, -2);

		// transportation_charges
		$this->transportation_charges->EditAttrs["class"] = "form-control";
		$this->transportation_charges->EditCustomAttributes = "";
		$this->transportation_charges->EditValue = $this->transportation_charges->CurrentValue;
		$this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());
		if (strval($this->transportation_charges->EditValue) <> "" && is_numeric($this->transportation_charges->EditValue))
			$this->transportation_charges->EditValue = FormatNumber($this->transportation_charges->EditValue, -2, -2, -2, -2);

		// port_clearing_charge
		$this->port_clearing_charge->EditAttrs["class"] = "form-control";
		$this->port_clearing_charge->EditCustomAttributes = "";
		$this->port_clearing_charge->EditValue = $this->port_clearing_charge->CurrentValue;
		$this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());
		if (strval($this->port_clearing_charge->EditValue) <> "" && is_numeric($this->port_clearing_charge->EditValue))
			$this->port_clearing_charge->EditValue = FormatNumber($this->port_clearing_charge->EditValue, -2, -2, -2, -2);

		// cha_commission
		$this->cha_commission->EditAttrs["class"] = "form-control";
		$this->cha_commission->EditCustomAttributes = "";
		$this->cha_commission->EditValue = $this->cha_commission->CurrentValue;
		$this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());
		if (strval($this->cha_commission->EditValue) <> "" && is_numeric($this->cha_commission->EditValue))
			$this->cha_commission->EditValue = FormatNumber($this->cha_commission->EditValue, -2, -2, -2, -2);

		// cha_agent
		$this->cha_agent->EditAttrs["class"] = "form-control";
		$this->cha_agent->EditCustomAttributes = "";

		// clearance_bank
		$this->clearance_bank->EditAttrs["class"] = "form-control";
		$this->clearance_bank->EditCustomAttributes = "";

		// bank_charges
		$this->bank_charges->EditAttrs["class"] = "form-control";
		$this->bank_charges->EditCustomAttributes = "";
		$this->bank_charges->EditValue = $this->bank_charges->CurrentValue;
		$this->bank_charges->PlaceHolder = RemoveHtml($this->bank_charges->caption());
		if (strval($this->bank_charges->EditValue) <> "" && is_numeric($this->bank_charges->EditValue))
			$this->bank_charges->EditValue = FormatNumber($this->bank_charges->EditValue, -2, -1, -2, 0);

		// importer
		$this->importer->EditAttrs["class"] = "form-control";
		$this->importer->EditCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// fiba_fibd
		$this->fiba_fibd->EditAttrs["class"] = "form-control";
		$this->fiba_fibd->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->fiba_fibd->CurrentValue = HtmlDecode($this->fiba_fibd->CurrentValue);
		$this->fiba_fibd->EditValue = $this->fiba_fibd->CurrentValue;
		$this->fiba_fibd->PlaceHolder = RemoveHtml($this->fiba_fibd->caption());

		// fibc
		$this->fibc->EditAttrs["class"] = "form-control";
		$this->fibc->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->fibc->CurrentValue = HtmlDecode($this->fibc->CurrentValue);
		$this->fibc->EditValue = $this->fibc->CurrentValue;
		$this->fibc->PlaceHolder = RemoveHtml($this->fibc->caption());

		// operator
		// datetime
		// updated

		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// qc_remarks
		$this->qc_remarks->EditAttrs["class"] = "form-control";
		$this->qc_remarks->EditCustomAttributes = "";
		$this->qc_remarks->EditValue = $this->qc_remarks->CurrentValue;
		$this->qc_remarks->PlaceHolder = RemoveHtml($this->qc_remarks->caption());

		// qc_status
		$this->qc_status->EditAttrs["class"] = "form-control";
		$this->qc_status->EditCustomAttributes = "";
		$this->qc_status->EditValue = $this->qc_status->CurrentValue;
		$this->qc_status->PlaceHolder = RemoveHtml($this->qc_status->caption());

		// qc_operator
		$this->qc_operator->EditAttrs["class"] = "form-control";
		$this->qc_operator->EditCustomAttributes = "";
		$this->qc_operator->EditValue = $this->qc_operator->CurrentValue;
		$this->qc_operator->PlaceHolder = RemoveHtml($this->qc_operator->caption());

		// qc_datetime
		$this->qc_datetime->EditAttrs["class"] = "form-control";
		$this->qc_datetime->EditCustomAttributes = "";
		$this->qc_datetime->EditValue = FormatDateTime($this->qc_datetime->CurrentValue, 8);
		$this->qc_datetime->PlaceHolder = RemoveHtml($this->qc_datetime->caption());

		// rbi_compliance_date
		$this->rbi_compliance_date->EditAttrs["class"] = "form-control";
		$this->rbi_compliance_date->EditCustomAttributes = "";
		$this->rbi_compliance_date->EditValue = FormatDateTime($this->rbi_compliance_date->CurrentValue, 8);
		$this->rbi_compliance_date->PlaceHolder = RemoveHtml($this->rbi_compliance_date->caption());

		// age
		$this->age->EditAttrs["class"] = "form-control";
		$this->age->EditCustomAttributes = "";
		$this->age->EditValue = $this->age->CurrentValue;
		$this->age->PlaceHolder = RemoveHtml($this->age->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->supplier);
					$doc->exportCaption($this->booking_reference);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->gross_weight);
					$doc->exportCaption($this->net_weight);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->shipping_line);
					$doc->exportCaption($this->port_arrival_date);
					$doc->exportCaption($this->godown_arrival_date);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->rack);
					$doc->exportCaption($this->invoice_details);
					$doc->exportCaption($this->invoice_value);
					$doc->exportCaption($this->currency_rate);
					$doc->exportCaption($this->purchase_amount_inr);
					$doc->exportCaption($this->duty_paid_by);
					$doc->exportCaption($this->custom_duty);
					$doc->exportCaption($this->transportation_charges);
					$doc->exportCaption($this->port_clearing_charge);
					$doc->exportCaption($this->cha_commission);
					$doc->exportCaption($this->cha_agent);
					$doc->exportCaption($this->clearance_bank);
					$doc->exportCaption($this->bank_charges);
					$doc->exportCaption($this->importer);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->fiba_fibd);
					$doc->exportCaption($this->fibc);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->qc_remarks);
					$doc->exportCaption($this->qc_status);
					$doc->exportCaption($this->qc_operator);
					$doc->exportCaption($this->qc_datetime);
					$doc->exportCaption($this->rbi_compliance_date);
					$doc->exportCaption($this->age);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->supplier);
					$doc->exportCaption($this->booking_reference);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->gross_weight);
					$doc->exportCaption($this->net_weight);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->shipping_line);
					$doc->exportCaption($this->port_arrival_date);
					$doc->exportCaption($this->godown_arrival_date);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->rack);
					$doc->exportCaption($this->invoice_details);
					$doc->exportCaption($this->invoice_value);
					$doc->exportCaption($this->currency_rate);
					$doc->exportCaption($this->purchase_amount_inr);
					$doc->exportCaption($this->duty_paid_by);
					$doc->exportCaption($this->custom_duty);
					$doc->exportCaption($this->transportation_charges);
					$doc->exportCaption($this->port_clearing_charge);
					$doc->exportCaption($this->cha_commission);
					$doc->exportCaption($this->cha_agent);
					$doc->exportCaption($this->clearance_bank);
					$doc->exportCaption($this->bank_charges);
					$doc->exportCaption($this->importer);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->fiba_fibd);
					$doc->exportCaption($this->fibc);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->qc_status);
					$doc->exportCaption($this->qc_operator);
					$doc->exportCaption($this->qc_datetime);
					$doc->exportCaption($this->rbi_compliance_date);
					$doc->exportCaption($this->age);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->supplier);
						$doc->exportField($this->booking_reference);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->gross_weight);
						$doc->exportField($this->net_weight);
						$doc->exportField($this->packets);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->containers);
						$doc->exportField($this->shipping_line);
						$doc->exportField($this->port_arrival_date);
						$doc->exportField($this->godown_arrival_date);
						$doc->exportField($this->godown);
						$doc->exportField($this->rack);
						$doc->exportField($this->invoice_details);
						$doc->exportField($this->invoice_value);
						$doc->exportField($this->currency_rate);
						$doc->exportField($this->purchase_amount_inr);
						$doc->exportField($this->duty_paid_by);
						$doc->exportField($this->custom_duty);
						$doc->exportField($this->transportation_charges);
						$doc->exportField($this->port_clearing_charge);
						$doc->exportField($this->cha_commission);
						$doc->exportField($this->cha_agent);
						$doc->exportField($this->clearance_bank);
						$doc->exportField($this->bank_charges);
						$doc->exportField($this->importer);
						$doc->exportField($this->remarks);
						$doc->exportField($this->fiba_fibd);
						$doc->exportField($this->fibc);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->updated);
						$doc->exportField($this->qc_remarks);
						$doc->exportField($this->qc_status);
						$doc->exportField($this->qc_operator);
						$doc->exportField($this->qc_datetime);
						$doc->exportField($this->rbi_compliance_date);
						$doc->exportField($this->age);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->supplier);
						$doc->exportField($this->booking_reference);
						$doc->exportField($this->rid);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->gross_weight);
						$doc->exportField($this->net_weight);
						$doc->exportField($this->packets);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->containers);
						$doc->exportField($this->shipping_line);
						$doc->exportField($this->port_arrival_date);
						$doc->exportField($this->godown_arrival_date);
						$doc->exportField($this->godown);
						$doc->exportField($this->rack);
						$doc->exportField($this->invoice_details);
						$doc->exportField($this->invoice_value);
						$doc->exportField($this->currency_rate);
						$doc->exportField($this->purchase_amount_inr);
						$doc->exportField($this->duty_paid_by);
						$doc->exportField($this->custom_duty);
						$doc->exportField($this->transportation_charges);
						$doc->exportField($this->port_clearing_charge);
						$doc->exportField($this->cha_commission);
						$doc->exportField($this->cha_agent);
						$doc->exportField($this->clearance_bank);
						$doc->exportField($this->bank_charges);
						$doc->exportField($this->importer);
						$doc->exportField($this->remarks);
						$doc->exportField($this->fiba_fibd);
						$doc->exportField($this->fibc);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->qc_status);
						$doc->exportField($this->qc_operator);
						$doc->exportField($this->qc_datetime);
						$doc->exportField($this->rbi_compliance_date);
						$doc->exportField($this->age);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'purchase_a';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'purchase_a';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'purchase_a';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'purchase_a';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>