<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class purchase_a_add extends purchase_a
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'purchase_a';

	// Page object name
	public $PageObjName = "purchase_a_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (purchase_a)
		if (!isset($GLOBALS["purchase_a"]) || get_class($GLOBALS["purchase_a"]) == PROJECT_NAMESPACE . "purchase_a") {
			$GLOBALS["purchase_a"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["purchase_a"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_a');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $purchase_a;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($purchase_a);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "purchase_aview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("purchase_alist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->supplier->setVisibility();
		$this->booking_reference->setVisibility();
		$this->rid->setVisibility();
		$this->lot_no->setVisibility();
		$this->gross_weight->setVisibility();
		$this->net_weight->setVisibility();
		$this->packets->setVisibility();
		$this->packing_type->setVisibility();
		$this->containers->setVisibility();
		$this->shipping_line->setVisibility();
		$this->port_arrival_date->setVisibility();
		$this->godown_arrival_date->setVisibility();
		$this->godown->setVisibility();
		$this->rack->setVisibility();
		$this->invoice_details->setVisibility();
		$this->invoice_value->setVisibility();
		$this->currency_rate->setVisibility();
		$this->purchase_amount_inr->setVisibility();
		$this->duty_paid_by->setVisibility();
		$this->custom_duty->setVisibility();
		$this->transportation_charges->setVisibility();
		$this->port_clearing_charge->setVisibility();
		$this->cha_commission->setVisibility();
		$this->cha_agent->setVisibility();
		$this->clearance_bank->setVisibility();
		$this->bank_charges->setVisibility();
		$this->importer->setVisibility();
		$this->remarks->setVisibility();
		$this->fiba_fibd->setVisibility();
		$this->fibc->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->qc_remarks->setVisibility();
		$this->qc_status->setVisibility();
		$this->qc_operator->setVisibility();
		$this->qc_datetime->setVisibility();
		$this->rbi_compliance_date->setVisibility();
		$this->age->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->supplier);
		$this->setupLookupOptions($this->booking_reference);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->shipping_line);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->cha_agent);
		$this->setupLookupOptions($this->clearance_bank);
		$this->setupLookupOptions($this->importer);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("purchase_alist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "purchase_alist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "purchase_aview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->supplier->CurrentValue = NULL;
		$this->supplier->OldValue = $this->supplier->CurrentValue;
		$this->booking_reference->CurrentValue = NULL;
		$this->booking_reference->OldValue = $this->booking_reference->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->gross_weight->CurrentValue = NULL;
		$this->gross_weight->OldValue = $this->gross_weight->CurrentValue;
		$this->net_weight->CurrentValue = NULL;
		$this->net_weight->OldValue = $this->net_weight->CurrentValue;
		$this->packets->CurrentValue = NULL;
		$this->packets->OldValue = $this->packets->CurrentValue;
		$this->packing_type->CurrentValue = 1;
		$this->containers->CurrentValue = NULL;
		$this->containers->OldValue = $this->containers->CurrentValue;
		$this->shipping_line->CurrentValue = NULL;
		$this->shipping_line->OldValue = $this->shipping_line->CurrentValue;
		$this->port_arrival_date->CurrentValue = NULL;
		$this->port_arrival_date->OldValue = $this->port_arrival_date->CurrentValue;
		$this->godown_arrival_date->CurrentValue = NULL;
		$this->godown_arrival_date->OldValue = $this->godown_arrival_date->CurrentValue;
		$this->godown->CurrentValue = NULL;
		$this->godown->OldValue = $this->godown->CurrentValue;
		$this->rack->CurrentValue = 0;
		$this->invoice_details->CurrentValue = NULL;
		$this->invoice_details->OldValue = $this->invoice_details->CurrentValue;
		$this->invoice_value->CurrentValue = NULL;
		$this->invoice_value->OldValue = $this->invoice_value->CurrentValue;
		$this->currency_rate->CurrentValue = NULL;
		$this->currency_rate->OldValue = $this->currency_rate->CurrentValue;
		$this->purchase_amount_inr->CurrentValue = NULL;
		$this->purchase_amount_inr->OldValue = $this->purchase_amount_inr->CurrentValue;
		$this->duty_paid_by->CurrentValue = NULL;
		$this->duty_paid_by->OldValue = $this->duty_paid_by->CurrentValue;
		$this->custom_duty->CurrentValue = NULL;
		$this->custom_duty->OldValue = $this->custom_duty->CurrentValue;
		$this->transportation_charges->CurrentValue = NULL;
		$this->transportation_charges->OldValue = $this->transportation_charges->CurrentValue;
		$this->port_clearing_charge->CurrentValue = NULL;
		$this->port_clearing_charge->OldValue = $this->port_clearing_charge->CurrentValue;
		$this->cha_commission->CurrentValue = NULL;
		$this->cha_commission->OldValue = $this->cha_commission->CurrentValue;
		$this->cha_agent->CurrentValue = NULL;
		$this->cha_agent->OldValue = $this->cha_agent->CurrentValue;
		$this->clearance_bank->CurrentValue = NULL;
		$this->clearance_bank->OldValue = $this->clearance_bank->CurrentValue;
		$this->bank_charges->CurrentValue = NULL;
		$this->bank_charges->OldValue = $this->bank_charges->CurrentValue;
		$this->importer->CurrentValue = NULL;
		$this->importer->OldValue = $this->importer->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->fiba_fibd->CurrentValue = NULL;
		$this->fiba_fibd->OldValue = $this->fiba_fibd->CurrentValue;
		$this->fibc->CurrentValue = NULL;
		$this->fibc->OldValue = $this->fibc->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->updated->CurrentValue = 0;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->qc_remarks->CurrentValue = NULL;
		$this->qc_remarks->OldValue = $this->qc_remarks->CurrentValue;
		$this->qc_status->CurrentValue = NULL;
		$this->qc_status->OldValue = $this->qc_status->CurrentValue;
		$this->qc_operator->CurrentValue = NULL;
		$this->qc_operator->OldValue = $this->qc_operator->CurrentValue;
		$this->qc_datetime->CurrentValue = NULL;
		$this->qc_datetime->OldValue = $this->qc_datetime->CurrentValue;
		$this->rbi_compliance_date->CurrentValue = NULL;
		$this->rbi_compliance_date->OldValue = $this->rbi_compliance_date->CurrentValue;
		$this->age->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'supplier' first before field var 'x_supplier'
		$val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
		if (!$this->supplier->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->supplier->Visible = FALSE; // Disable update for API request
			else
				$this->supplier->setFormValue($val);
		}

		// Check field name 'booking_reference' first before field var 'x_booking_reference'
		$val = $CurrentForm->hasValue("booking_reference") ? $CurrentForm->getValue("booking_reference") : $CurrentForm->getValue("x_booking_reference");
		if (!$this->booking_reference->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->booking_reference->Visible = FALSE; // Disable update for API request
			else
				$this->booking_reference->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'gross_weight' first before field var 'x_gross_weight'
		$val = $CurrentForm->hasValue("gross_weight") ? $CurrentForm->getValue("gross_weight") : $CurrentForm->getValue("x_gross_weight");
		if (!$this->gross_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gross_weight->Visible = FALSE; // Disable update for API request
			else
				$this->gross_weight->setFormValue($val);
		}

		// Check field name 'net_weight' first before field var 'x_net_weight'
		$val = $CurrentForm->hasValue("net_weight") ? $CurrentForm->getValue("net_weight") : $CurrentForm->getValue("x_net_weight");
		if (!$this->net_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->net_weight->Visible = FALSE; // Disable update for API request
			else
				$this->net_weight->setFormValue($val);
		}

		// Check field name 'packets' first before field var 'x_packets'
		$val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
		if (!$this->packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets->Visible = FALSE; // Disable update for API request
			else
				$this->packets->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'containers' first before field var 'x_containers'
		$val = $CurrentForm->hasValue("containers") ? $CurrentForm->getValue("containers") : $CurrentForm->getValue("x_containers");
		if (!$this->containers->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->containers->Visible = FALSE; // Disable update for API request
			else
				$this->containers->setFormValue($val);
		}

		// Check field name 'shipping_line' first before field var 'x_shipping_line'
		$val = $CurrentForm->hasValue("shipping_line") ? $CurrentForm->getValue("shipping_line") : $CurrentForm->getValue("x_shipping_line");
		if (!$this->shipping_line->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_line->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_line->setFormValue($val);
		}

		// Check field name 'port_arrival_date' first before field var 'x_port_arrival_date'
		$val = $CurrentForm->hasValue("port_arrival_date") ? $CurrentForm->getValue("port_arrival_date") : $CurrentForm->getValue("x_port_arrival_date");
		if (!$this->port_arrival_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_arrival_date->Visible = FALSE; // Disable update for API request
			else
				$this->port_arrival_date->setFormValue($val);
			$this->port_arrival_date->CurrentValue = UnFormatDateTime($this->port_arrival_date->CurrentValue, 0);
		}

		// Check field name 'godown_arrival_date' first before field var 'x_godown_arrival_date'
		$val = $CurrentForm->hasValue("godown_arrival_date") ? $CurrentForm->getValue("godown_arrival_date") : $CurrentForm->getValue("x_godown_arrival_date");
		if (!$this->godown_arrival_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown_arrival_date->Visible = FALSE; // Disable update for API request
			else
				$this->godown_arrival_date->setFormValue($val);
			$this->godown_arrival_date->CurrentValue = UnFormatDateTime($this->godown_arrival_date->CurrentValue, 0);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'rack' first before field var 'x_rack'
		$val = $CurrentForm->hasValue("rack") ? $CurrentForm->getValue("rack") : $CurrentForm->getValue("x_rack");
		if (!$this->rack->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rack->Visible = FALSE; // Disable update for API request
			else
				$this->rack->setFormValue($val);
		}

		// Check field name 'invoice_details' first before field var 'x_invoice_details'
		$val = $CurrentForm->hasValue("invoice_details") ? $CurrentForm->getValue("invoice_details") : $CurrentForm->getValue("x_invoice_details");
		if (!$this->invoice_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_details->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_details->setFormValue($val);
		}

		// Check field name 'invoice_value' first before field var 'x_invoice_value'
		$val = $CurrentForm->hasValue("invoice_value") ? $CurrentForm->getValue("invoice_value") : $CurrentForm->getValue("x_invoice_value");
		if (!$this->invoice_value->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_value->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_value->setFormValue($val);
		}

		// Check field name 'currency_rate' first before field var 'x_currency_rate'
		$val = $CurrentForm->hasValue("currency_rate") ? $CurrentForm->getValue("currency_rate") : $CurrentForm->getValue("x_currency_rate");
		if (!$this->currency_rate->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency_rate->Visible = FALSE; // Disable update for API request
			else
				$this->currency_rate->setFormValue($val);
		}

		// Check field name 'purchase_amount_inr' first before field var 'x_purchase_amount_inr'
		$val = $CurrentForm->hasValue("purchase_amount_inr") ? $CurrentForm->getValue("purchase_amount_inr") : $CurrentForm->getValue("x_purchase_amount_inr");
		if (!$this->purchase_amount_inr->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->purchase_amount_inr->Visible = FALSE; // Disable update for API request
			else
				$this->purchase_amount_inr->setFormValue($val);
		}

		// Check field name 'duty_paid_by' first before field var 'x_duty_paid_by'
		$val = $CurrentForm->hasValue("duty_paid_by") ? $CurrentForm->getValue("duty_paid_by") : $CurrentForm->getValue("x_duty_paid_by");
		if (!$this->duty_paid_by->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->duty_paid_by->Visible = FALSE; // Disable update for API request
			else
				$this->duty_paid_by->setFormValue($val);
		}

		// Check field name 'custom_duty' first before field var 'x_custom_duty'
		$val = $CurrentForm->hasValue("custom_duty") ? $CurrentForm->getValue("custom_duty") : $CurrentForm->getValue("x_custom_duty");
		if (!$this->custom_duty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->custom_duty->Visible = FALSE; // Disable update for API request
			else
				$this->custom_duty->setFormValue($val);
		}

		// Check field name 'transportation_charges' first before field var 'x_transportation_charges'
		$val = $CurrentForm->hasValue("transportation_charges") ? $CurrentForm->getValue("transportation_charges") : $CurrentForm->getValue("x_transportation_charges");
		if (!$this->transportation_charges->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->transportation_charges->Visible = FALSE; // Disable update for API request
			else
				$this->transportation_charges->setFormValue($val);
		}

		// Check field name 'port_clearing_charge' first before field var 'x_port_clearing_charge'
		$val = $CurrentForm->hasValue("port_clearing_charge") ? $CurrentForm->getValue("port_clearing_charge") : $CurrentForm->getValue("x_port_clearing_charge");
		if (!$this->port_clearing_charge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_clearing_charge->Visible = FALSE; // Disable update for API request
			else
				$this->port_clearing_charge->setFormValue($val);
		}

		// Check field name 'cha_commission' first before field var 'x_cha_commission'
		$val = $CurrentForm->hasValue("cha_commission") ? $CurrentForm->getValue("cha_commission") : $CurrentForm->getValue("x_cha_commission");
		if (!$this->cha_commission->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cha_commission->Visible = FALSE; // Disable update for API request
			else
				$this->cha_commission->setFormValue($val);
		}

		// Check field name 'cha_agent' first before field var 'x_cha_agent'
		$val = $CurrentForm->hasValue("cha_agent") ? $CurrentForm->getValue("cha_agent") : $CurrentForm->getValue("x_cha_agent");
		if (!$this->cha_agent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cha_agent->Visible = FALSE; // Disable update for API request
			else
				$this->cha_agent->setFormValue($val);
		}

		// Check field name 'clearance_bank' first before field var 'x_clearance_bank'
		$val = $CurrentForm->hasValue("clearance_bank") ? $CurrentForm->getValue("clearance_bank") : $CurrentForm->getValue("x_clearance_bank");
		if (!$this->clearance_bank->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->clearance_bank->Visible = FALSE; // Disable update for API request
			else
				$this->clearance_bank->setFormValue($val);
		}

		// Check field name 'bank_charges' first before field var 'x_bank_charges'
		$val = $CurrentForm->hasValue("bank_charges") ? $CurrentForm->getValue("bank_charges") : $CurrentForm->getValue("x_bank_charges");
		if (!$this->bank_charges->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_charges->Visible = FALSE; // Disable update for API request
			else
				$this->bank_charges->setFormValue($val);
		}

		// Check field name 'importer' first before field var 'x_importer'
		$val = $CurrentForm->hasValue("importer") ? $CurrentForm->getValue("importer") : $CurrentForm->getValue("x_importer");
		if (!$this->importer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->importer->Visible = FALSE; // Disable update for API request
			else
				$this->importer->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'fiba_fibd' first before field var 'x_fiba_fibd'
		$val = $CurrentForm->hasValue("fiba_fibd") ? $CurrentForm->getValue("fiba_fibd") : $CurrentForm->getValue("x_fiba_fibd");
		if (!$this->fiba_fibd->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fiba_fibd->Visible = FALSE; // Disable update for API request
			else
				$this->fiba_fibd->setFormValue($val);
		}

		// Check field name 'fibc' first before field var 'x_fibc'
		$val = $CurrentForm->hasValue("fibc") ? $CurrentForm->getValue("fibc") : $CurrentForm->getValue("x_fibc");
		if (!$this->fibc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fibc->Visible = FALSE; // Disable update for API request
			else
				$this->fibc->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'qc_remarks' first before field var 'x_qc_remarks'
		$val = $CurrentForm->hasValue("qc_remarks") ? $CurrentForm->getValue("qc_remarks") : $CurrentForm->getValue("x_qc_remarks");
		if (!$this->qc_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->qc_remarks->setFormValue($val);
		}

		// Check field name 'qc_status' first before field var 'x_qc_status'
		$val = $CurrentForm->hasValue("qc_status") ? $CurrentForm->getValue("qc_status") : $CurrentForm->getValue("x_qc_status");
		if (!$this->qc_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_status->Visible = FALSE; // Disable update for API request
			else
				$this->qc_status->setFormValue($val);
		}

		// Check field name 'qc_operator' first before field var 'x_qc_operator'
		$val = $CurrentForm->hasValue("qc_operator") ? $CurrentForm->getValue("qc_operator") : $CurrentForm->getValue("x_qc_operator");
		if (!$this->qc_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_operator->Visible = FALSE; // Disable update for API request
			else
				$this->qc_operator->setFormValue($val);
		}

		// Check field name 'qc_datetime' first before field var 'x_qc_datetime'
		$val = $CurrentForm->hasValue("qc_datetime") ? $CurrentForm->getValue("qc_datetime") : $CurrentForm->getValue("x_qc_datetime");
		if (!$this->qc_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->qc_datetime->setFormValue($val);
			$this->qc_datetime->CurrentValue = UnFormatDateTime($this->qc_datetime->CurrentValue, 0);
		}

		// Check field name 'rbi_compliance_date' first before field var 'x_rbi_compliance_date'
		$val = $CurrentForm->hasValue("rbi_compliance_date") ? $CurrentForm->getValue("rbi_compliance_date") : $CurrentForm->getValue("x_rbi_compliance_date");
		if (!$this->rbi_compliance_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rbi_compliance_date->Visible = FALSE; // Disable update for API request
			else
				$this->rbi_compliance_date->setFormValue($val);
			$this->rbi_compliance_date->CurrentValue = UnFormatDateTime($this->rbi_compliance_date->CurrentValue, 0);
		}

		// Check field name 'age' first before field var 'x_age'
		$val = $CurrentForm->hasValue("age") ? $CurrentForm->getValue("age") : $CurrentForm->getValue("x_age");
		if (!$this->age->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->age->Visible = FALSE; // Disable update for API request
			else
				$this->age->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->supplier->CurrentValue = $this->supplier->FormValue;
		$this->booking_reference->CurrentValue = $this->booking_reference->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->gross_weight->CurrentValue = $this->gross_weight->FormValue;
		$this->net_weight->CurrentValue = $this->net_weight->FormValue;
		$this->packets->CurrentValue = $this->packets->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->containers->CurrentValue = $this->containers->FormValue;
		$this->shipping_line->CurrentValue = $this->shipping_line->FormValue;
		$this->port_arrival_date->CurrentValue = $this->port_arrival_date->FormValue;
		$this->port_arrival_date->CurrentValue = UnFormatDateTime($this->port_arrival_date->CurrentValue, 0);
		$this->godown_arrival_date->CurrentValue = $this->godown_arrival_date->FormValue;
		$this->godown_arrival_date->CurrentValue = UnFormatDateTime($this->godown_arrival_date->CurrentValue, 0);
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->rack->CurrentValue = $this->rack->FormValue;
		$this->invoice_details->CurrentValue = $this->invoice_details->FormValue;
		$this->invoice_value->CurrentValue = $this->invoice_value->FormValue;
		$this->currency_rate->CurrentValue = $this->currency_rate->FormValue;
		$this->purchase_amount_inr->CurrentValue = $this->purchase_amount_inr->FormValue;
		$this->duty_paid_by->CurrentValue = $this->duty_paid_by->FormValue;
		$this->custom_duty->CurrentValue = $this->custom_duty->FormValue;
		$this->transportation_charges->CurrentValue = $this->transportation_charges->FormValue;
		$this->port_clearing_charge->CurrentValue = $this->port_clearing_charge->FormValue;
		$this->cha_commission->CurrentValue = $this->cha_commission->FormValue;
		$this->cha_agent->CurrentValue = $this->cha_agent->FormValue;
		$this->clearance_bank->CurrentValue = $this->clearance_bank->FormValue;
		$this->bank_charges->CurrentValue = $this->bank_charges->FormValue;
		$this->importer->CurrentValue = $this->importer->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->fiba_fibd->CurrentValue = $this->fiba_fibd->FormValue;
		$this->fibc->CurrentValue = $this->fibc->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->qc_remarks->CurrentValue = $this->qc_remarks->FormValue;
		$this->qc_status->CurrentValue = $this->qc_status->FormValue;
		$this->qc_operator->CurrentValue = $this->qc_operator->FormValue;
		$this->qc_datetime->CurrentValue = $this->qc_datetime->FormValue;
		$this->qc_datetime->CurrentValue = UnFormatDateTime($this->qc_datetime->CurrentValue, 0);
		$this->rbi_compliance_date->CurrentValue = $this->rbi_compliance_date->FormValue;
		$this->rbi_compliance_date->CurrentValue = UnFormatDateTime($this->rbi_compliance_date->CurrentValue, 0);
		$this->age->CurrentValue = $this->age->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->supplier->setDbValue($row['supplier']);
		$this->booking_reference->setDbValue($row['booking_reference']);
		$this->rid->setDbValue($row['rid']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->gross_weight->setDbValue($row['gross_weight']);
		$this->net_weight->setDbValue($row['net_weight']);
		$this->packets->setDbValue($row['packets']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->containers->setDbValue($row['containers']);
		$this->shipping_line->setDbValue($row['shipping_line']);
		$this->port_arrival_date->setDbValue($row['port_arrival_date']);
		$this->godown_arrival_date->setDbValue($row['godown_arrival_date']);
		$this->godown->setDbValue($row['godown']);
		$this->rack->setDbValue($row['rack']);
		$this->invoice_details->setDbValue($row['invoice_details']);
		$this->invoice_value->setDbValue($row['invoice_value']);
		$this->currency_rate->setDbValue($row['currency_rate']);
		$this->purchase_amount_inr->setDbValue($row['purchase_amount_inr']);
		$this->duty_paid_by->setDbValue($row['duty_paid_by']);
		$this->custom_duty->setDbValue($row['custom_duty']);
		$this->transportation_charges->setDbValue($row['transportation_charges']);
		$this->port_clearing_charge->setDbValue($row['port_clearing_charge']);
		$this->cha_commission->setDbValue($row['cha_commission']);
		$this->cha_agent->setDbValue($row['cha_agent']);
		$this->clearance_bank->setDbValue($row['clearance_bank']);
		$this->bank_charges->setDbValue($row['bank_charges']);
		$this->importer->setDbValue($row['importer']);
		$this->remarks->setDbValue($row['remarks']);
		$this->fiba_fibd->setDbValue($row['fiba_fibd']);
		$this->fibc->setDbValue($row['fibc']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->updated->setDbValue($row['updated']);
		$this->grp->setDbValue($row['grp']);
		$this->qc_remarks->setDbValue($row['qc_remarks']);
		$this->qc_status->setDbValue($row['qc_status']);
		$this->qc_operator->setDbValue($row['qc_operator']);
		$this->qc_datetime->setDbValue($row['qc_datetime']);
		$this->rbi_compliance_date->setDbValue($row['rbi_compliance_date']);
		$this->age->setDbValue($row['age']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['supplier'] = $this->supplier->CurrentValue;
		$row['booking_reference'] = $this->booking_reference->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['gross_weight'] = $this->gross_weight->CurrentValue;
		$row['net_weight'] = $this->net_weight->CurrentValue;
		$row['packets'] = $this->packets->CurrentValue;
		$row['packing_type'] = $this->packing_type->CurrentValue;
		$row['containers'] = $this->containers->CurrentValue;
		$row['shipping_line'] = $this->shipping_line->CurrentValue;
		$row['port_arrival_date'] = $this->port_arrival_date->CurrentValue;
		$row['godown_arrival_date'] = $this->godown_arrival_date->CurrentValue;
		$row['godown'] = $this->godown->CurrentValue;
		$row['rack'] = $this->rack->CurrentValue;
		$row['invoice_details'] = $this->invoice_details->CurrentValue;
		$row['invoice_value'] = $this->invoice_value->CurrentValue;
		$row['currency_rate'] = $this->currency_rate->CurrentValue;
		$row['purchase_amount_inr'] = $this->purchase_amount_inr->CurrentValue;
		$row['duty_paid_by'] = $this->duty_paid_by->CurrentValue;
		$row['custom_duty'] = $this->custom_duty->CurrentValue;
		$row['transportation_charges'] = $this->transportation_charges->CurrentValue;
		$row['port_clearing_charge'] = $this->port_clearing_charge->CurrentValue;
		$row['cha_commission'] = $this->cha_commission->CurrentValue;
		$row['cha_agent'] = $this->cha_agent->CurrentValue;
		$row['clearance_bank'] = $this->clearance_bank->CurrentValue;
		$row['bank_charges'] = $this->bank_charges->CurrentValue;
		$row['importer'] = $this->importer->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['fiba_fibd'] = $this->fiba_fibd->CurrentValue;
		$row['fibc'] = $this->fibc->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['updated'] = $this->updated->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['qc_remarks'] = $this->qc_remarks->CurrentValue;
		$row['qc_status'] = $this->qc_status->CurrentValue;
		$row['qc_operator'] = $this->qc_operator->CurrentValue;
		$row['qc_datetime'] = $this->qc_datetime->CurrentValue;
		$row['rbi_compliance_date'] = $this->rbi_compliance_date->CurrentValue;
		$row['age'] = $this->age->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->gross_weight->FormValue == $this->gross_weight->CurrentValue && is_numeric(ConvertToFloatString($this->gross_weight->CurrentValue)))
			$this->gross_weight->CurrentValue = ConvertToFloatString($this->gross_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->net_weight->FormValue == $this->net_weight->CurrentValue && is_numeric(ConvertToFloatString($this->net_weight->CurrentValue)))
			$this->net_weight->CurrentValue = ConvertToFloatString($this->net_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->containers->FormValue == $this->containers->CurrentValue && is_numeric(ConvertToFloatString($this->containers->CurrentValue)))
			$this->containers->CurrentValue = ConvertToFloatString($this->containers->CurrentValue);

		// Convert decimal values if posted back
		if ($this->invoice_value->FormValue == $this->invoice_value->CurrentValue && is_numeric(ConvertToFloatString($this->invoice_value->CurrentValue)))
			$this->invoice_value->CurrentValue = ConvertToFloatString($this->invoice_value->CurrentValue);

		// Convert decimal values if posted back
		if ($this->currency_rate->FormValue == $this->currency_rate->CurrentValue && is_numeric(ConvertToFloatString($this->currency_rate->CurrentValue)))
			$this->currency_rate->CurrentValue = ConvertToFloatString($this->currency_rate->CurrentValue);

		// Convert decimal values if posted back
		if ($this->purchase_amount_inr->FormValue == $this->purchase_amount_inr->CurrentValue && is_numeric(ConvertToFloatString($this->purchase_amount_inr->CurrentValue)))
			$this->purchase_amount_inr->CurrentValue = ConvertToFloatString($this->purchase_amount_inr->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_duty->FormValue == $this->custom_duty->CurrentValue && is_numeric(ConvertToFloatString($this->custom_duty->CurrentValue)))
			$this->custom_duty->CurrentValue = ConvertToFloatString($this->custom_duty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->transportation_charges->FormValue == $this->transportation_charges->CurrentValue && is_numeric(ConvertToFloatString($this->transportation_charges->CurrentValue)))
			$this->transportation_charges->CurrentValue = ConvertToFloatString($this->transportation_charges->CurrentValue);

		// Convert decimal values if posted back
		if ($this->port_clearing_charge->FormValue == $this->port_clearing_charge->CurrentValue && is_numeric(ConvertToFloatString($this->port_clearing_charge->CurrentValue)))
			$this->port_clearing_charge->CurrentValue = ConvertToFloatString($this->port_clearing_charge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cha_commission->FormValue == $this->cha_commission->CurrentValue && is_numeric(ConvertToFloatString($this->cha_commission->CurrentValue)))
			$this->cha_commission->CurrentValue = ConvertToFloatString($this->cha_commission->CurrentValue);

		// Convert decimal values if posted back
		if ($this->bank_charges->FormValue == $this->bank_charges->CurrentValue && is_numeric(ConvertToFloatString($this->bank_charges->CurrentValue)))
			$this->bank_charges->CurrentValue = ConvertToFloatString($this->bank_charges->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// supplier
		// booking_reference
		// rid
		// lot_no
		// gross_weight
		// net_weight
		// packets
		// packing_type
		// containers
		// shipping_line
		// port_arrival_date
		// godown_arrival_date
		// godown
		// rack
		// invoice_details
		// invoice_value
		// currency_rate
		// purchase_amount_inr
		// duty_paid_by
		// custom_duty
		// transportation_charges
		// port_clearing_charge
		// cha_commission
		// cha_agent
		// clearance_bank
		// bank_charges
		// importer
		// remarks
		// fiba_fibd
		// fibc
		// operator
		// datetime
		// updated
		// grp
		// qc_remarks
		// qc_status
		// qc_operator
		// qc_datetime
		// rbi_compliance_date
		// age

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// supplier
			$curVal = strval($this->supplier->CurrentValue);
			if ($curVal <> "") {
				$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
				if ($this->supplier->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->supplier->ViewValue = $this->supplier->CurrentValue;
					}
				}
			} else {
				$this->supplier->ViewValue = NULL;
			}
			$this->supplier->ViewCustomAttributes = "";

			// booking_reference
			$curVal = strval($this->booking_reference->CurrentValue);
			if ($curVal <> "") {
				$this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
				if ($this->booking_reference->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->booking_reference->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
					}
				}
			} else {
				$this->booking_reference->ViewValue = NULL;
			}
			$this->booking_reference->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, 3, -2, -2, -2);
			$this->gross_weight->ViewCustomAttributes = "";

			// net_weight
			$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
			$this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, 3, -2, -2, -2);
			$this->net_weight->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// containers
			$this->containers->ViewValue = $this->containers->CurrentValue;
			$this->containers->ViewValue = FormatNumber($this->containers->ViewValue, 2, -2, -2, -2);
			$this->containers->ViewCustomAttributes = "";

			// shipping_line
			$curVal = strval($this->shipping_line->CurrentValue);
			if ($curVal <> "") {
				$this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
				if ($this->shipping_line->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->shipping_line->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
					}
				}
			} else {
				$this->shipping_line->ViewValue = NULL;
			}
			$this->shipping_line->ViewCustomAttributes = "";

			// port_arrival_date
			$this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
			$this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, 0);
			$this->port_arrival_date->ViewCustomAttributes = "";

			// godown_arrival_date
			$this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
			$this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, 0);
			$this->godown_arrival_date->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// rack
			$this->rack->ViewValue = $this->rack->CurrentValue;
			$this->rack->ViewCustomAttributes = "";

			// invoice_details
			$this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;
			$this->invoice_details->ViewCustomAttributes = "";

			// invoice_value
			$this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
			$this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, 2, -2, -2, -2);
			$this->invoice_value->ViewCustomAttributes = "";

			// currency_rate
			$this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
			$this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, 3, -2, -2, -2);
			$this->currency_rate->ViewCustomAttributes = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
			$this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, 2, -2, -2, -2);
			$this->purchase_amount_inr->ViewCustomAttributes = "";

			// duty_paid_by
			if (strval($this->duty_paid_by->CurrentValue) <> "") {
				$this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
			} else {
				$this->duty_paid_by->ViewValue = NULL;
			}
			$this->duty_paid_by->ViewCustomAttributes = "";

			// custom_duty
			$this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
			$this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, 2, -2, -2, -2);
			$this->custom_duty->ViewCustomAttributes = "";

			// transportation_charges
			$this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
			$this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, 2, -2, -2, -2);
			$this->transportation_charges->ViewCustomAttributes = "";

			// port_clearing_charge
			$this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
			$this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, 2, -2, -2, -2);
			$this->port_clearing_charge->ViewCustomAttributes = "";

			// cha_commission
			$this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
			$this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, 2, -2, -2, -2);
			$this->cha_commission->ViewCustomAttributes = "";

			// cha_agent
			$curVal = strval($this->cha_agent->CurrentValue);
			if ($curVal <> "") {
				$this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
				if ($this->cha_agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cha_agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
					}
				}
			} else {
				$this->cha_agent->ViewValue = NULL;
			}
			$this->cha_agent->ViewCustomAttributes = "";

			// clearance_bank
			$curVal = strval($this->clearance_bank->CurrentValue);
			if ($curVal <> "") {
				$this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
				if ($this->clearance_bank->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->clearance_bank->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
					}
				}
			} else {
				$this->clearance_bank->ViewValue = NULL;
			}
			$this->clearance_bank->ViewCustomAttributes = "";

			// bank_charges
			$this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
			$this->bank_charges->ViewCustomAttributes = "";

			// importer
			$curVal = strval($this->importer->CurrentValue);
			if ($curVal <> "") {
				$this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
				if ($this->importer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->importer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->importer->ViewValue = $this->importer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->importer->ViewValue = $this->importer->CurrentValue;
					}
				}
			} else {
				$this->importer->ViewValue = NULL;
			}
			$this->importer->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// fiba_fibd
			$this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;
			$this->fiba_fibd->ViewCustomAttributes = "";

			// fibc
			$this->fibc->ViewValue = $this->fibc->CurrentValue;
			$this->fibc->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// qc_remarks
			$this->qc_remarks->ViewValue = $this->qc_remarks->CurrentValue;
			$this->qc_remarks->ViewCustomAttributes = "";

			// qc_status
			$this->qc_status->ViewValue = $this->qc_status->CurrentValue;
			$this->qc_status->ViewValue = FormatNumber($this->qc_status->ViewValue, 0, -2, -2, -2);
			$this->qc_status->ViewCustomAttributes = "";

			// qc_operator
			$this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
			$this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, 0, -2, -2, -2);
			$this->qc_operator->ViewCustomAttributes = "";

			// qc_datetime
			$this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
			$this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, 0);
			$this->qc_datetime->ViewCustomAttributes = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->ViewValue = $this->rbi_compliance_date->CurrentValue;
			$this->rbi_compliance_date->ViewValue = FormatDateTime($this->rbi_compliance_date->ViewValue, 0);
			$this->rbi_compliance_date->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
			$this->age->ViewCustomAttributes = "";

			// supplier
			$this->supplier->LinkCustomAttributes = "";
			if (!EmptyValue($this->supplier->CurrentValue)) {
				$this->supplier->HrefValue = "purchase_a_flist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
				$this->supplier->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
			} else {
				$this->supplier->HrefValue = "";
			}
			$this->supplier->TooltipValue = "";

			// booking_reference
			$this->booking_reference->LinkCustomAttributes = "";
			$this->booking_reference->HrefValue = "";
			$this->booking_reference->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "purchase_a_flist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";
			$this->gross_weight->TooltipValue = "";

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";
			$this->net_weight->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "purchase_a_flist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// containers
			$this->containers->LinkCustomAttributes = "";
			$this->containers->HrefValue = "";
			$this->containers->TooltipValue = "";

			// shipping_line
			$this->shipping_line->LinkCustomAttributes = "";
			$this->shipping_line->HrefValue = "";
			$this->shipping_line->TooltipValue = "";

			// port_arrival_date
			$this->port_arrival_date->LinkCustomAttributes = "";
			$this->port_arrival_date->HrefValue = "";
			$this->port_arrival_date->TooltipValue = "";

			// godown_arrival_date
			$this->godown_arrival_date->LinkCustomAttributes = "";
			$this->godown_arrival_date->HrefValue = "";
			$this->godown_arrival_date->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "purchase_a_flist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// rack
			$this->rack->LinkCustomAttributes = "";
			$this->rack->HrefValue = "";
			$this->rack->TooltipValue = "";

			// invoice_details
			$this->invoice_details->LinkCustomAttributes = "";
			$this->invoice_details->HrefValue = "";
			$this->invoice_details->TooltipValue = "";

			// invoice_value
			$this->invoice_value->LinkCustomAttributes = "";
			$this->invoice_value->HrefValue = "";
			$this->invoice_value->TooltipValue = "";

			// currency_rate
			$this->currency_rate->LinkCustomAttributes = "";
			$this->currency_rate->HrefValue = "";
			$this->currency_rate->TooltipValue = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->LinkCustomAttributes = "";
			$this->purchase_amount_inr->HrefValue = "";
			$this->purchase_amount_inr->TooltipValue = "";

			// duty_paid_by
			$this->duty_paid_by->LinkCustomAttributes = "";
			$this->duty_paid_by->HrefValue = "";
			$this->duty_paid_by->TooltipValue = "";

			// custom_duty
			$this->custom_duty->LinkCustomAttributes = "";
			$this->custom_duty->HrefValue = "";
			$this->custom_duty->TooltipValue = "";

			// transportation_charges
			$this->transportation_charges->LinkCustomAttributes = "";
			$this->transportation_charges->HrefValue = "";
			$this->transportation_charges->TooltipValue = "";

			// port_clearing_charge
			$this->port_clearing_charge->LinkCustomAttributes = "";
			$this->port_clearing_charge->HrefValue = "";
			$this->port_clearing_charge->TooltipValue = "";

			// cha_commission
			$this->cha_commission->LinkCustomAttributes = "";
			$this->cha_commission->HrefValue = "";
			$this->cha_commission->TooltipValue = "";

			// cha_agent
			$this->cha_agent->LinkCustomAttributes = "";
			$this->cha_agent->HrefValue = "";
			$this->cha_agent->TooltipValue = "";

			// clearance_bank
			$this->clearance_bank->LinkCustomAttributes = "";
			$this->clearance_bank->HrefValue = "";
			$this->clearance_bank->TooltipValue = "";

			// bank_charges
			$this->bank_charges->LinkCustomAttributes = "";
			$this->bank_charges->HrefValue = "";
			$this->bank_charges->TooltipValue = "";

			// importer
			$this->importer->LinkCustomAttributes = "";
			$this->importer->HrefValue = "";
			$this->importer->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// fiba_fibd
			$this->fiba_fibd->LinkCustomAttributes = "";
			$this->fiba_fibd->HrefValue = "";
			$this->fiba_fibd->TooltipValue = "";

			// fibc
			$this->fibc->LinkCustomAttributes = "";
			$this->fibc->HrefValue = "";
			$this->fibc->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// qc_remarks
			$this->qc_remarks->LinkCustomAttributes = "";
			$this->qc_remarks->HrefValue = "";
			$this->qc_remarks->TooltipValue = "";

			// qc_status
			$this->qc_status->LinkCustomAttributes = "";
			$this->qc_status->HrefValue = "";
			$this->qc_status->TooltipValue = "";

			// qc_operator
			$this->qc_operator->LinkCustomAttributes = "";
			$this->qc_operator->HrefValue = "";
			$this->qc_operator->TooltipValue = "";

			// qc_datetime
			$this->qc_datetime->LinkCustomAttributes = "";
			$this->qc_datetime->HrefValue = "";
			$this->qc_datetime->TooltipValue = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->LinkCustomAttributes = "";
			$this->rbi_compliance_date->HrefValue = "";
			$this->rbi_compliance_date->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// supplier
			$this->supplier->EditAttrs["class"] = "form-control";
			$this->supplier->EditCustomAttributes = "";
			$curVal = trim(strval($this->supplier->CurrentValue));
			if ($curVal <> "")
				$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
			else
				$this->supplier->ViewValue = $this->supplier->Lookup !== NULL && is_array($this->supplier->Lookup->Options) ? $curVal : NULL;
			if ($this->supplier->ViewValue !== NULL) { // Load from cache
				$this->supplier->EditValue = array_values($this->supplier->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->supplier->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `category` = 200";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->supplier->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->supplier->EditValue = $arwrk;
			}

			// booking_reference
			$this->booking_reference->EditAttrs["class"] = "form-control";
			$this->booking_reference->EditCustomAttributes = "";
			$curVal = trim(strval($this->booking_reference->CurrentValue));
			if ($curVal <> "")
				$this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
			else
				$this->booking_reference->ViewValue = $this->booking_reference->Lookup !== NULL && is_array($this->booking_reference->Lookup->Options) ? $curVal : NULL;
			if ($this->booking_reference->ViewValue !== NULL) { // Load from cache
				$this->booking_reference->EditValue = array_values($this->booking_reference->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->booking_reference->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->booking_reference->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->booking_reference->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = 'ReadOnly';
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// gross_weight
			$this->gross_weight->EditAttrs["class"] = "form-control";
			$this->gross_weight->EditCustomAttributes = "";
			$this->gross_weight->EditValue = HtmlEncode($this->gross_weight->CurrentValue);
			$this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());
			if (strval($this->gross_weight->EditValue) <> "" && is_numeric($this->gross_weight->EditValue))
				$this->gross_weight->EditValue = FormatNumber($this->gross_weight->EditValue, -2, -2, -2, -2);

			// net_weight
			$this->net_weight->EditAttrs["class"] = "form-control";
			$this->net_weight->EditCustomAttributes = "";
			$this->net_weight->EditValue = HtmlEncode($this->net_weight->CurrentValue);
			$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
			if (strval($this->net_weight->EditValue) <> "" && is_numeric($this->net_weight->EditValue))
				$this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, -2, -2, -2, -2);

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->CurrentValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` = 1 and grp = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// containers
			$this->containers->EditAttrs["class"] = "form-control";
			$this->containers->EditCustomAttributes = "";
			$this->containers->EditValue = HtmlEncode($this->containers->CurrentValue);
			$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
			if (strval($this->containers->EditValue) <> "" && is_numeric($this->containers->EditValue))
				$this->containers->EditValue = FormatNumber($this->containers->EditValue, -2, -2, -2, -2);

			// shipping_line
			$this->shipping_line->EditAttrs["class"] = "form-control";
			$this->shipping_line->EditCustomAttributes = "";
			$curVal = trim(strval($this->shipping_line->CurrentValue));
			if ($curVal <> "")
				$this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
			else
				$this->shipping_line->ViewValue = $this->shipping_line->Lookup !== NULL && is_array($this->shipping_line->Lookup->Options) ? $curVal : NULL;
			if ($this->shipping_line->ViewValue !== NULL) { // Load from cache
				$this->shipping_line->EditValue = array_values($this->shipping_line->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->shipping_line->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->shipping_line->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shipping_line->EditValue = $arwrk;
			}

			// port_arrival_date
			$this->port_arrival_date->EditAttrs["class"] = "form-control";
			$this->port_arrival_date->EditCustomAttributes = "";
			$this->port_arrival_date->EditValue = HtmlEncode(FormatDateTime($this->port_arrival_date->CurrentValue, 8));
			$this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());

			// godown_arrival_date
			$this->godown_arrival_date->EditAttrs["class"] = "form-control";
			$this->godown_arrival_date->EditCustomAttributes = "";
			$this->godown_arrival_date->EditValue = HtmlEncode(FormatDateTime($this->godown_arrival_date->CurrentValue, 8));
			$this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->CurrentValue));
			if ($curVal <> "")
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// rack
			$this->rack->EditAttrs["class"] = "form-control";
			$this->rack->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rack->CurrentValue = HtmlDecode($this->rack->CurrentValue);
			$this->rack->EditValue = HtmlEncode($this->rack->CurrentValue);
			$this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

			// invoice_details
			$this->invoice_details->EditAttrs["class"] = "form-control";
			$this->invoice_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice_details->CurrentValue = HtmlDecode($this->invoice_details->CurrentValue);
			$this->invoice_details->EditValue = HtmlEncode($this->invoice_details->CurrentValue);
			$this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

			// invoice_value
			$this->invoice_value->EditAttrs["class"] = "form-control";
			$this->invoice_value->EditCustomAttributes = "";
			$this->invoice_value->EditValue = HtmlEncode($this->invoice_value->CurrentValue);
			$this->invoice_value->PlaceHolder = RemoveHtml($this->invoice_value->caption());
			if (strval($this->invoice_value->EditValue) <> "" && is_numeric($this->invoice_value->EditValue))
				$this->invoice_value->EditValue = FormatNumber($this->invoice_value->EditValue, -2, -2, -2, -2);

			// currency_rate
			$this->currency_rate->EditAttrs["class"] = "form-control";
			$this->currency_rate->EditCustomAttributes = "";
			$this->currency_rate->EditValue = HtmlEncode($this->currency_rate->CurrentValue);
			$this->currency_rate->PlaceHolder = RemoveHtml($this->currency_rate->caption());
			if (strval($this->currency_rate->EditValue) <> "" && is_numeric($this->currency_rate->EditValue))
				$this->currency_rate->EditValue = FormatNumber($this->currency_rate->EditValue, -2, -2, -2, -2);

			// purchase_amount_inr
			$this->purchase_amount_inr->EditAttrs["class"] = "form-control";
			$this->purchase_amount_inr->EditCustomAttributes = "";
			$this->purchase_amount_inr->EditValue = HtmlEncode($this->purchase_amount_inr->CurrentValue);
			$this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());
			if (strval($this->purchase_amount_inr->EditValue) <> "" && is_numeric($this->purchase_amount_inr->EditValue))
				$this->purchase_amount_inr->EditValue = FormatNumber($this->purchase_amount_inr->EditValue, -2, -2, -2, -2);

			// duty_paid_by
			$this->duty_paid_by->EditAttrs["class"] = "form-control";
			$this->duty_paid_by->EditCustomAttributes = "";
			$this->duty_paid_by->EditValue = $this->duty_paid_by->options(TRUE);

			// custom_duty
			$this->custom_duty->EditAttrs["class"] = "form-control";
			$this->custom_duty->EditCustomAttributes = "";
			$this->custom_duty->EditValue = HtmlEncode($this->custom_duty->CurrentValue);
			$this->custom_duty->PlaceHolder = RemoveHtml($this->custom_duty->caption());
			if (strval($this->custom_duty->EditValue) <> "" && is_numeric($this->custom_duty->EditValue))
				$this->custom_duty->EditValue = FormatNumber($this->custom_duty->EditValue, -2, -2, -2, -2);

			// transportation_charges
			$this->transportation_charges->EditAttrs["class"] = "form-control";
			$this->transportation_charges->EditCustomAttributes = "";
			$this->transportation_charges->EditValue = HtmlEncode($this->transportation_charges->CurrentValue);
			$this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());
			if (strval($this->transportation_charges->EditValue) <> "" && is_numeric($this->transportation_charges->EditValue))
				$this->transportation_charges->EditValue = FormatNumber($this->transportation_charges->EditValue, -2, -2, -2, -2);

			// port_clearing_charge
			$this->port_clearing_charge->EditAttrs["class"] = "form-control";
			$this->port_clearing_charge->EditCustomAttributes = "";
			$this->port_clearing_charge->EditValue = HtmlEncode($this->port_clearing_charge->CurrentValue);
			$this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());
			if (strval($this->port_clearing_charge->EditValue) <> "" && is_numeric($this->port_clearing_charge->EditValue))
				$this->port_clearing_charge->EditValue = FormatNumber($this->port_clearing_charge->EditValue, -2, -2, -2, -2);

			// cha_commission
			$this->cha_commission->EditAttrs["class"] = "form-control";
			$this->cha_commission->EditCustomAttributes = "";
			$this->cha_commission->EditValue = HtmlEncode($this->cha_commission->CurrentValue);
			$this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());
			if (strval($this->cha_commission->EditValue) <> "" && is_numeric($this->cha_commission->EditValue))
				$this->cha_commission->EditValue = FormatNumber($this->cha_commission->EditValue, -2, -2, -2, -2);

			// cha_agent
			$this->cha_agent->EditAttrs["class"] = "form-control";
			$this->cha_agent->EditCustomAttributes = "";
			$curVal = trim(strval($this->cha_agent->CurrentValue));
			if ($curVal <> "")
				$this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
			else
				$this->cha_agent->ViewValue = $this->cha_agent->Lookup !== NULL && is_array($this->cha_agent->Lookup->Options) ? $curVal : NULL;
			if ($this->cha_agent->ViewValue !== NULL) { // Load from cache
				$this->cha_agent->EditValue = array_values($this->cha_agent->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->cha_agent->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cha_agent->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->cha_agent->EditValue = $arwrk;
			}

			// clearance_bank
			$this->clearance_bank->EditAttrs["class"] = "form-control";
			$this->clearance_bank->EditCustomAttributes = "";
			$curVal = trim(strval($this->clearance_bank->CurrentValue));
			if ($curVal <> "")
				$this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
			else
				$this->clearance_bank->ViewValue = $this->clearance_bank->Lookup !== NULL && is_array($this->clearance_bank->Lookup->Options) ? $curVal : NULL;
			if ($this->clearance_bank->ViewValue !== NULL) { // Load from cache
				$this->clearance_bank->EditValue = array_values($this->clearance_bank->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->clearance_bank->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->clearance_bank->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->clearance_bank->EditValue = $arwrk;
			}

			// bank_charges
			$this->bank_charges->EditAttrs["class"] = "form-control";
			$this->bank_charges->EditCustomAttributes = "";
			$this->bank_charges->EditValue = HtmlEncode($this->bank_charges->CurrentValue);
			$this->bank_charges->PlaceHolder = RemoveHtml($this->bank_charges->caption());
			if (strval($this->bank_charges->EditValue) <> "" && is_numeric($this->bank_charges->EditValue))
				$this->bank_charges->EditValue = FormatNumber($this->bank_charges->EditValue, -2, -1, -2, 0);

			// importer
			$this->importer->EditAttrs["class"] = "form-control";
			$this->importer->EditCustomAttributes = "";
			$curVal = trim(strval($this->importer->CurrentValue));
			if ($curVal <> "")
				$this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
			else
				$this->importer->ViewValue = $this->importer->Lookup !== NULL && is_array($this->importer->Lookup->Options) ? $curVal : NULL;
			if ($this->importer->ViewValue !== NULL) { // Load from cache
				$this->importer->EditValue = array_values($this->importer->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->importer->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` IN (0,1)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->importer->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->importer->EditValue = $arwrk;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// fiba_fibd
			$this->fiba_fibd->EditAttrs["class"] = "form-control";
			$this->fiba_fibd->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->fiba_fibd->CurrentValue = HtmlDecode($this->fiba_fibd->CurrentValue);
			$this->fiba_fibd->EditValue = HtmlEncode($this->fiba_fibd->CurrentValue);
			$this->fiba_fibd->PlaceHolder = RemoveHtml($this->fiba_fibd->caption());

			// fibc
			$this->fibc->EditAttrs["class"] = "form-control";
			$this->fibc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->fibc->CurrentValue = HtmlDecode($this->fibc->CurrentValue);
			$this->fibc->EditValue = HtmlEncode($this->fibc->CurrentValue);
			$this->fibc->PlaceHolder = RemoveHtml($this->fibc->caption());

			// operator
			// datetime
			// qc_remarks

			$this->qc_remarks->EditAttrs["class"] = "form-control";
			$this->qc_remarks->EditCustomAttributes = "";
			$this->qc_remarks->EditValue = HtmlEncode($this->qc_remarks->CurrentValue);
			$this->qc_remarks->PlaceHolder = RemoveHtml($this->qc_remarks->caption());

			// qc_status
			$this->qc_status->EditAttrs["class"] = "form-control";
			$this->qc_status->EditCustomAttributes = "";
			$this->qc_status->EditValue = HtmlEncode($this->qc_status->CurrentValue);
			$this->qc_status->PlaceHolder = RemoveHtml($this->qc_status->caption());

			// qc_operator
			$this->qc_operator->EditAttrs["class"] = "form-control";
			$this->qc_operator->EditCustomAttributes = "";
			$this->qc_operator->EditValue = HtmlEncode($this->qc_operator->CurrentValue);
			$this->qc_operator->PlaceHolder = RemoveHtml($this->qc_operator->caption());

			// qc_datetime
			$this->qc_datetime->EditAttrs["class"] = "form-control";
			$this->qc_datetime->EditCustomAttributes = "";
			$this->qc_datetime->EditValue = HtmlEncode(FormatDateTime($this->qc_datetime->CurrentValue, 8));
			$this->qc_datetime->PlaceHolder = RemoveHtml($this->qc_datetime->caption());

			// rbi_compliance_date
			$this->rbi_compliance_date->EditAttrs["class"] = "form-control";
			$this->rbi_compliance_date->EditCustomAttributes = "";
			$this->rbi_compliance_date->EditValue = HtmlEncode(FormatDateTime($this->rbi_compliance_date->CurrentValue, 8));
			$this->rbi_compliance_date->PlaceHolder = RemoveHtml($this->rbi_compliance_date->caption());

			// age
			$this->age->EditAttrs["class"] = "form-control";
			$this->age->EditCustomAttributes = "";
			$this->age->EditValue = HtmlEncode($this->age->CurrentValue);
			$this->age->PlaceHolder = RemoveHtml($this->age->caption());

			// Add refer script
			// supplier

			$this->supplier->LinkCustomAttributes = "";
			if (!EmptyValue($this->supplier->CurrentValue)) {
				$this->supplier->HrefValue = "purchase_a_flist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
				$this->supplier->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
			} else {
				$this->supplier->HrefValue = "";
			}

			// booking_reference
			$this->booking_reference->LinkCustomAttributes = "";
			$this->booking_reference->HrefValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "purchase_a_flist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "purchase_a_flist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}

			// containers
			$this->containers->LinkCustomAttributes = "";
			$this->containers->HrefValue = "";

			// shipping_line
			$this->shipping_line->LinkCustomAttributes = "";
			$this->shipping_line->HrefValue = "";

			// port_arrival_date
			$this->port_arrival_date->LinkCustomAttributes = "";
			$this->port_arrival_date->HrefValue = "";

			// godown_arrival_date
			$this->godown_arrival_date->LinkCustomAttributes = "";
			$this->godown_arrival_date->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "purchase_a_flist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}

			// rack
			$this->rack->LinkCustomAttributes = "";
			$this->rack->HrefValue = "";

			// invoice_details
			$this->invoice_details->LinkCustomAttributes = "";
			$this->invoice_details->HrefValue = "";

			// invoice_value
			$this->invoice_value->LinkCustomAttributes = "";
			$this->invoice_value->HrefValue = "";

			// currency_rate
			$this->currency_rate->LinkCustomAttributes = "";
			$this->currency_rate->HrefValue = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->LinkCustomAttributes = "";
			$this->purchase_amount_inr->HrefValue = "";

			// duty_paid_by
			$this->duty_paid_by->LinkCustomAttributes = "";
			$this->duty_paid_by->HrefValue = "";

			// custom_duty
			$this->custom_duty->LinkCustomAttributes = "";
			$this->custom_duty->HrefValue = "";

			// transportation_charges
			$this->transportation_charges->LinkCustomAttributes = "";
			$this->transportation_charges->HrefValue = "";

			// port_clearing_charge
			$this->port_clearing_charge->LinkCustomAttributes = "";
			$this->port_clearing_charge->HrefValue = "";

			// cha_commission
			$this->cha_commission->LinkCustomAttributes = "";
			$this->cha_commission->HrefValue = "";

			// cha_agent
			$this->cha_agent->LinkCustomAttributes = "";
			$this->cha_agent->HrefValue = "";

			// clearance_bank
			$this->clearance_bank->LinkCustomAttributes = "";
			$this->clearance_bank->HrefValue = "";

			// bank_charges
			$this->bank_charges->LinkCustomAttributes = "";
			$this->bank_charges->HrefValue = "";

			// importer
			$this->importer->LinkCustomAttributes = "";
			$this->importer->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// fiba_fibd
			$this->fiba_fibd->LinkCustomAttributes = "";
			$this->fiba_fibd->HrefValue = "";

			// fibc
			$this->fibc->LinkCustomAttributes = "";
			$this->fibc->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// qc_remarks
			$this->qc_remarks->LinkCustomAttributes = "";
			$this->qc_remarks->HrefValue = "";

			// qc_status
			$this->qc_status->LinkCustomAttributes = "";
			$this->qc_status->HrefValue = "";

			// qc_operator
			$this->qc_operator->LinkCustomAttributes = "";
			$this->qc_operator->HrefValue = "";

			// qc_datetime
			$this->qc_datetime->LinkCustomAttributes = "";
			$this->qc_datetime->HrefValue = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->LinkCustomAttributes = "";
			$this->rbi_compliance_date->HrefValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->supplier->Required) {
			if (!$this->supplier->IsDetailKey && $this->supplier->FormValue != NULL && $this->supplier->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
			}
		}
		if ($this->booking_reference->Required) {
			if (!$this->booking_reference->IsDetailKey && $this->booking_reference->FormValue != NULL && $this->booking_reference->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->booking_reference->caption(), $this->booking_reference->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->rid->FormValue)) {
			AddMessage($FormError, $this->rid->errorMessage());
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->gross_weight->Required) {
			if (!$this->gross_weight->IsDetailKey && $this->gross_weight->FormValue != NULL && $this->gross_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gross_weight->caption(), $this->gross_weight->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->gross_weight->FormValue)) {
			AddMessage($FormError, $this->gross_weight->errorMessage());
		}
		if ($this->net_weight->Required) {
			if (!$this->net_weight->IsDetailKey && $this->net_weight->FormValue != NULL && $this->net_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->net_weight->caption(), $this->net_weight->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->net_weight->FormValue)) {
			AddMessage($FormError, $this->net_weight->errorMessage());
		}
		if ($this->packets->Required) {
			if (!$this->packets->IsDetailKey && $this->packets->FormValue != NULL && $this->packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->packets->FormValue)) {
			AddMessage($FormError, $this->packets->errorMessage());
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->containers->Required) {
			if (!$this->containers->IsDetailKey && $this->containers->FormValue != NULL && $this->containers->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->containers->caption(), $this->containers->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->containers->FormValue)) {
			AddMessage($FormError, $this->containers->errorMessage());
		}
		if ($this->shipping_line->Required) {
			if (!$this->shipping_line->IsDetailKey && $this->shipping_line->FormValue != NULL && $this->shipping_line->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_line->caption(), $this->shipping_line->RequiredErrorMessage));
			}
		}
		if ($this->port_arrival_date->Required) {
			if (!$this->port_arrival_date->IsDetailKey && $this->port_arrival_date->FormValue != NULL && $this->port_arrival_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_arrival_date->caption(), $this->port_arrival_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->port_arrival_date->FormValue)) {
			AddMessage($FormError, $this->port_arrival_date->errorMessage());
		}
		if ($this->godown_arrival_date->Required) {
			if (!$this->godown_arrival_date->IsDetailKey && $this->godown_arrival_date->FormValue != NULL && $this->godown_arrival_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown_arrival_date->caption(), $this->godown_arrival_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->godown_arrival_date->FormValue)) {
			AddMessage($FormError, $this->godown_arrival_date->errorMessage());
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if ($this->rack->Required) {
			if (!$this->rack->IsDetailKey && $this->rack->FormValue != NULL && $this->rack->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rack->caption(), $this->rack->RequiredErrorMessage));
			}
		}
		if ($this->invoice_details->Required) {
			if (!$this->invoice_details->IsDetailKey && $this->invoice_details->FormValue != NULL && $this->invoice_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_details->caption(), $this->invoice_details->RequiredErrorMessage));
			}
		}
		if ($this->invoice_value->Required) {
			if (!$this->invoice_value->IsDetailKey && $this->invoice_value->FormValue != NULL && $this->invoice_value->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_value->caption(), $this->invoice_value->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->invoice_value->FormValue)) {
			AddMessage($FormError, $this->invoice_value->errorMessage());
		}
		if ($this->currency_rate->Required) {
			if (!$this->currency_rate->IsDetailKey && $this->currency_rate->FormValue != NULL && $this->currency_rate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency_rate->caption(), $this->currency_rate->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->currency_rate->FormValue)) {
			AddMessage($FormError, $this->currency_rate->errorMessage());
		}
		if ($this->purchase_amount_inr->Required) {
			if (!$this->purchase_amount_inr->IsDetailKey && $this->purchase_amount_inr->FormValue != NULL && $this->purchase_amount_inr->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->purchase_amount_inr->caption(), $this->purchase_amount_inr->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->purchase_amount_inr->FormValue)) {
			AddMessage($FormError, $this->purchase_amount_inr->errorMessage());
		}
		if ($this->duty_paid_by->Required) {
			if (!$this->duty_paid_by->IsDetailKey && $this->duty_paid_by->FormValue != NULL && $this->duty_paid_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->duty_paid_by->caption(), $this->duty_paid_by->RequiredErrorMessage));
			}
		}
		if ($this->custom_duty->Required) {
			if (!$this->custom_duty->IsDetailKey && $this->custom_duty->FormValue != NULL && $this->custom_duty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->custom_duty->caption(), $this->custom_duty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->custom_duty->FormValue)) {
			AddMessage($FormError, $this->custom_duty->errorMessage());
		}
		if ($this->transportation_charges->Required) {
			if (!$this->transportation_charges->IsDetailKey && $this->transportation_charges->FormValue != NULL && $this->transportation_charges->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->transportation_charges->caption(), $this->transportation_charges->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->transportation_charges->FormValue)) {
			AddMessage($FormError, $this->transportation_charges->errorMessage());
		}
		if ($this->port_clearing_charge->Required) {
			if (!$this->port_clearing_charge->IsDetailKey && $this->port_clearing_charge->FormValue != NULL && $this->port_clearing_charge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_clearing_charge->caption(), $this->port_clearing_charge->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->port_clearing_charge->FormValue)) {
			AddMessage($FormError, $this->port_clearing_charge->errorMessage());
		}
		if ($this->cha_commission->Required) {
			if (!$this->cha_commission->IsDetailKey && $this->cha_commission->FormValue != NULL && $this->cha_commission->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cha_commission->caption(), $this->cha_commission->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cha_commission->FormValue)) {
			AddMessage($FormError, $this->cha_commission->errorMessage());
		}
		if ($this->cha_agent->Required) {
			if (!$this->cha_agent->IsDetailKey && $this->cha_agent->FormValue != NULL && $this->cha_agent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cha_agent->caption(), $this->cha_agent->RequiredErrorMessage));
			}
		}
		if ($this->clearance_bank->Required) {
			if (!$this->clearance_bank->IsDetailKey && $this->clearance_bank->FormValue != NULL && $this->clearance_bank->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->clearance_bank->caption(), $this->clearance_bank->RequiredErrorMessage));
			}
		}
		if ($this->bank_charges->Required) {
			if (!$this->bank_charges->IsDetailKey && $this->bank_charges->FormValue != NULL && $this->bank_charges->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_charges->caption(), $this->bank_charges->RequiredErrorMessage));
			}
		}
		if ($this->importer->Required) {
			if (!$this->importer->IsDetailKey && $this->importer->FormValue != NULL && $this->importer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->importer->caption(), $this->importer->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->fiba_fibd->Required) {
			if (!$this->fiba_fibd->IsDetailKey && $this->fiba_fibd->FormValue != NULL && $this->fiba_fibd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fiba_fibd->caption(), $this->fiba_fibd->RequiredErrorMessage));
			}
		}
		if ($this->fibc->Required) {
			if (!$this->fibc->IsDetailKey && $this->fibc->FormValue != NULL && $this->fibc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fibc->caption(), $this->fibc->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->qc_remarks->Required) {
			if (!$this->qc_remarks->IsDetailKey && $this->qc_remarks->FormValue != NULL && $this->qc_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_remarks->caption(), $this->qc_remarks->RequiredErrorMessage));
			}
		}
		if ($this->qc_status->Required) {
			if (!$this->qc_status->IsDetailKey && $this->qc_status->FormValue != NULL && $this->qc_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_status->caption(), $this->qc_status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->qc_status->FormValue)) {
			AddMessage($FormError, $this->qc_status->errorMessage());
		}
		if ($this->qc_operator->Required) {
			if (!$this->qc_operator->IsDetailKey && $this->qc_operator->FormValue != NULL && $this->qc_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_operator->caption(), $this->qc_operator->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->qc_operator->FormValue)) {
			AddMessage($FormError, $this->qc_operator->errorMessage());
		}
		if ($this->qc_datetime->Required) {
			if (!$this->qc_datetime->IsDetailKey && $this->qc_datetime->FormValue != NULL && $this->qc_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_datetime->caption(), $this->qc_datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->qc_datetime->FormValue)) {
			AddMessage($FormError, $this->qc_datetime->errorMessage());
		}
		if ($this->rbi_compliance_date->Required) {
			if (!$this->rbi_compliance_date->IsDetailKey && $this->rbi_compliance_date->FormValue != NULL && $this->rbi_compliance_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rbi_compliance_date->caption(), $this->rbi_compliance_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->rbi_compliance_date->FormValue)) {
			AddMessage($FormError, $this->rbi_compliance_date->errorMessage());
		}
		if ($this->age->Required) {
			if (!$this->age->IsDetailKey && $this->age->FormValue != NULL && $this->age->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->age->caption(), $this->age->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->age->FormValue)) {
			AddMessage($FormError, $this->age->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// supplier
		$this->supplier->setDbValueDef($rsnew, $this->supplier->CurrentValue, 0, FALSE);

		// booking_reference
		$this->booking_reference->setDbValueDef($rsnew, $this->booking_reference->CurrentValue, 0, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, 0, FALSE);

		// lot_no
		$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, "", FALSE);

		// gross_weight
		$this->gross_weight->setDbValueDef($rsnew, $this->gross_weight->CurrentValue, NULL, FALSE);

		// net_weight
		$this->net_weight->setDbValueDef($rsnew, $this->net_weight->CurrentValue, 0, FALSE);

		// packets
		$this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, NULL, FALSE);

		// packing_type
		$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, 0, FALSE);

		// containers
		$this->containers->setDbValueDef($rsnew, $this->containers->CurrentValue, 0, FALSE);

		// shipping_line
		$this->shipping_line->setDbValueDef($rsnew, $this->shipping_line->CurrentValue, NULL, FALSE);

		// port_arrival_date
		$this->port_arrival_date->setDbValueDef($rsnew, UnFormatDateTime($this->port_arrival_date->CurrentValue, 0), NULL, FALSE);

		// godown_arrival_date
		$this->godown_arrival_date->setDbValueDef($rsnew, UnFormatDateTime($this->godown_arrival_date->CurrentValue, 0), NULL, FALSE);

		// godown
		$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, NULL, FALSE);

		// rack
		$this->rack->setDbValueDef($rsnew, $this->rack->CurrentValue, "", FALSE);

		// invoice_details
		$this->invoice_details->setDbValueDef($rsnew, $this->invoice_details->CurrentValue, NULL, FALSE);

		// invoice_value
		$this->invoice_value->setDbValueDef($rsnew, $this->invoice_value->CurrentValue, NULL, FALSE);

		// currency_rate
		$this->currency_rate->setDbValueDef($rsnew, $this->currency_rate->CurrentValue, NULL, FALSE);

		// purchase_amount_inr
		$this->purchase_amount_inr->setDbValueDef($rsnew, $this->purchase_amount_inr->CurrentValue, NULL, strval($this->purchase_amount_inr->CurrentValue) == "");

		// duty_paid_by
		$this->duty_paid_by->setDbValueDef($rsnew, $this->duty_paid_by->CurrentValue, NULL, FALSE);

		// custom_duty
		$this->custom_duty->setDbValueDef($rsnew, $this->custom_duty->CurrentValue, NULL, FALSE);

		// transportation_charges
		$this->transportation_charges->setDbValueDef($rsnew, $this->transportation_charges->CurrentValue, NULL, FALSE);

		// port_clearing_charge
		$this->port_clearing_charge->setDbValueDef($rsnew, $this->port_clearing_charge->CurrentValue, NULL, FALSE);

		// cha_commission
		$this->cha_commission->setDbValueDef($rsnew, $this->cha_commission->CurrentValue, NULL, FALSE);

		// cha_agent
		$this->cha_agent->setDbValueDef($rsnew, $this->cha_agent->CurrentValue, NULL, FALSE);

		// clearance_bank
		$this->clearance_bank->setDbValueDef($rsnew, $this->clearance_bank->CurrentValue, NULL, FALSE);

		// bank_charges
		$this->bank_charges->setDbValueDef($rsnew, $this->bank_charges->CurrentValue, NULL, strval($this->bank_charges->CurrentValue) == "");

		// importer
		$this->importer->setDbValueDef($rsnew, $this->importer->CurrentValue, NULL, FALSE);

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// fiba_fibd
		$this->fiba_fibd->setDbValueDef($rsnew, $this->fiba_fibd->CurrentValue, "", FALSE);

		// fibc
		$this->fibc->setDbValueDef($rsnew, $this->fibc->CurrentValue, "", FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// qc_remarks
		$this->qc_remarks->setDbValueDef($rsnew, $this->qc_remarks->CurrentValue, NULL, FALSE);

		// qc_status
		$this->qc_status->setDbValueDef($rsnew, $this->qc_status->CurrentValue, NULL, FALSE);

		// qc_operator
		$this->qc_operator->setDbValueDef($rsnew, $this->qc_operator->CurrentValue, NULL, FALSE);

		// qc_datetime
		$this->qc_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->qc_datetime->CurrentValue, 0), NULL, FALSE);

		// rbi_compliance_date
		$this->rbi_compliance_date->setDbValueDef($rsnew, UnFormatDateTime($this->rbi_compliance_date->CurrentValue, 0), NULL, FALSE);

		// age
		$this->age->setDbValueDef($rsnew, $this->age->CurrentValue, 0, strval($this->age->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchase_alist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_supplier":
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_booking_reference":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cha_agent":
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_importer":
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_supplier":
							break;
						case "x_booking_reference":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_shipping_line":
							break;
						case "x_godown":
							break;
						case "x_cha_agent":
							break;
						case "x_clearance_bank":
							break;
						case "x_importer":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>