<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class purchase_a_list extends purchase_a
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'purchase_a';

	// Page object name
	public $PageObjName = "purchase_a_list";

	// Grid form hidden field names
	public $FormName = "fpurchase_alist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (purchase_a)
		if (!isset($GLOBALS["purchase_a"]) || get_class($GLOBALS["purchase_a"]) == PROJECT_NAMESPACE . "purchase_a") {
			$GLOBALS["purchase_a"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["purchase_a"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "purchase_aadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "purchase_adelete.php";
		$this->MultiUpdateUrl = "purchase_aupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_a');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fpurchase_alistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $purchase_a;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($purchase_a);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->supplier->Visible = FALSE;
		$this->booking_reference->Visible = FALSE;
		$this->rid->setVisibility();
		$this->lot_no->setVisibility();
		$this->gross_weight->Visible = FALSE;
		$this->net_weight->setVisibility();
		$this->packets->Visible = FALSE;
		$this->packing_type->setVisibility();
		$this->containers->Visible = FALSE;
		$this->shipping_line->Visible = FALSE;
		$this->port_arrival_date->Visible = FALSE;
		$this->godown_arrival_date->setVisibility();
		$this->godown->setVisibility();
		$this->rack->setVisibility();
		$this->invoice_details->setVisibility();
		$this->invoice_value->setVisibility();
		$this->currency_rate->setVisibility();
		$this->purchase_amount_inr->setVisibility();
		$this->duty_paid_by->setVisibility();
		$this->custom_duty->setVisibility();
		$this->transportation_charges->Visible = FALSE;
		$this->port_clearing_charge->setVisibility();
		$this->cha_commission->setVisibility();
		$this->cha_agent->setVisibility();
		$this->clearance_bank->Visible = FALSE;
		$this->bank_charges->setVisibility();
		$this->importer->setVisibility();
		$this->remarks->setVisibility();
		$this->fiba_fibd->setVisibility();
		$this->fibc->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->qc_remarks->Visible = FALSE;
		$this->qc_status->setVisibility();
		$this->qc_operator->setVisibility();
		$this->qc_datetime->setVisibility();
		$this->rbi_compliance_date->setVisibility();
		$this->age->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->supplier);
		$this->setupLookupOptions($this->booking_reference);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->shipping_line);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->cha_agent);
		$this->setupLookupOptions($this->clearance_bank);
		$this->setupLookupOptions($this->importer);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fpurchase_alistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->supplier->AdvancedSearch->toJson(), ","); // Field supplier
		$filterList = Concat($filterList, $this->booking_reference->AdvancedSearch->toJson(), ","); // Field booking_reference
		$filterList = Concat($filterList, $this->lot_no->AdvancedSearch->toJson(), ","); // Field lot_no
		$filterList = Concat($filterList, $this->gross_weight->AdvancedSearch->toJson(), ","); // Field gross_weight
		$filterList = Concat($filterList, $this->net_weight->AdvancedSearch->toJson(), ","); // Field net_weight
		$filterList = Concat($filterList, $this->packets->AdvancedSearch->toJson(), ","); // Field packets
		$filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
		$filterList = Concat($filterList, $this->containers->AdvancedSearch->toJson(), ","); // Field containers
		$filterList = Concat($filterList, $this->shipping_line->AdvancedSearch->toJson(), ","); // Field shipping_line
		$filterList = Concat($filterList, $this->port_arrival_date->AdvancedSearch->toJson(), ","); // Field port_arrival_date
		$filterList = Concat($filterList, $this->godown_arrival_date->AdvancedSearch->toJson(), ","); // Field godown_arrival_date
		$filterList = Concat($filterList, $this->godown->AdvancedSearch->toJson(), ","); // Field godown
		$filterList = Concat($filterList, $this->rack->AdvancedSearch->toJson(), ","); // Field rack
		$filterList = Concat($filterList, $this->invoice_details->AdvancedSearch->toJson(), ","); // Field invoice_details
		$filterList = Concat($filterList, $this->invoice_value->AdvancedSearch->toJson(), ","); // Field invoice_value
		$filterList = Concat($filterList, $this->currency_rate->AdvancedSearch->toJson(), ","); // Field currency_rate
		$filterList = Concat($filterList, $this->purchase_amount_inr->AdvancedSearch->toJson(), ","); // Field purchase_amount_inr
		$filterList = Concat($filterList, $this->duty_paid_by->AdvancedSearch->toJson(), ","); // Field duty_paid_by
		$filterList = Concat($filterList, $this->custom_duty->AdvancedSearch->toJson(), ","); // Field custom_duty
		$filterList = Concat($filterList, $this->transportation_charges->AdvancedSearch->toJson(), ","); // Field transportation_charges
		$filterList = Concat($filterList, $this->port_clearing_charge->AdvancedSearch->toJson(), ","); // Field port_clearing_charge
		$filterList = Concat($filterList, $this->cha_commission->AdvancedSearch->toJson(), ","); // Field cha_commission
		$filterList = Concat($filterList, $this->cha_agent->AdvancedSearch->toJson(), ","); // Field cha_agent
		$filterList = Concat($filterList, $this->clearance_bank->AdvancedSearch->toJson(), ","); // Field clearance_bank
		$filterList = Concat($filterList, $this->bank_charges->AdvancedSearch->toJson(), ","); // Field bank_charges
		$filterList = Concat($filterList, $this->importer->AdvancedSearch->toJson(), ","); // Field importer
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->fiba_fibd->AdvancedSearch->toJson(), ","); // Field fiba_fibd
		$filterList = Concat($filterList, $this->fibc->AdvancedSearch->toJson(), ","); // Field fibc
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->qc_remarks->AdvancedSearch->toJson(), ","); // Field qc_remarks
		$filterList = Concat($filterList, $this->qc_status->AdvancedSearch->toJson(), ","); // Field qc_status
		$filterList = Concat($filterList, $this->qc_operator->AdvancedSearch->toJson(), ","); // Field qc_operator
		$filterList = Concat($filterList, $this->qc_datetime->AdvancedSearch->toJson(), ","); // Field qc_datetime
		$filterList = Concat($filterList, $this->rbi_compliance_date->AdvancedSearch->toJson(), ","); // Field rbi_compliance_date
		$filterList = Concat($filterList, $this->age->AdvancedSearch->toJson(), ","); // Field age
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fpurchase_alistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field supplier
		$this->supplier->AdvancedSearch->SearchValue = @$filter["x_supplier"];
		$this->supplier->AdvancedSearch->SearchOperator = @$filter["z_supplier"];
		$this->supplier->AdvancedSearch->SearchCondition = @$filter["v_supplier"];
		$this->supplier->AdvancedSearch->SearchValue2 = @$filter["y_supplier"];
		$this->supplier->AdvancedSearch->SearchOperator2 = @$filter["w_supplier"];
		$this->supplier->AdvancedSearch->save();

		// Field booking_reference
		$this->booking_reference->AdvancedSearch->SearchValue = @$filter["x_booking_reference"];
		$this->booking_reference->AdvancedSearch->SearchOperator = @$filter["z_booking_reference"];
		$this->booking_reference->AdvancedSearch->SearchCondition = @$filter["v_booking_reference"];
		$this->booking_reference->AdvancedSearch->SearchValue2 = @$filter["y_booking_reference"];
		$this->booking_reference->AdvancedSearch->SearchOperator2 = @$filter["w_booking_reference"];
		$this->booking_reference->AdvancedSearch->save();

		// Field lot_no
		$this->lot_no->AdvancedSearch->SearchValue = @$filter["x_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator = @$filter["z_lot_no"];
		$this->lot_no->AdvancedSearch->SearchCondition = @$filter["v_lot_no"];
		$this->lot_no->AdvancedSearch->SearchValue2 = @$filter["y_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator2 = @$filter["w_lot_no"];
		$this->lot_no->AdvancedSearch->save();

		// Field gross_weight
		$this->gross_weight->AdvancedSearch->SearchValue = @$filter["x_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchOperator = @$filter["z_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchCondition = @$filter["v_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchValue2 = @$filter["y_gross_weight"];
		$this->gross_weight->AdvancedSearch->SearchOperator2 = @$filter["w_gross_weight"];
		$this->gross_weight->AdvancedSearch->save();

		// Field net_weight
		$this->net_weight->AdvancedSearch->SearchValue = @$filter["x_net_weight"];
		$this->net_weight->AdvancedSearch->SearchOperator = @$filter["z_net_weight"];
		$this->net_weight->AdvancedSearch->SearchCondition = @$filter["v_net_weight"];
		$this->net_weight->AdvancedSearch->SearchValue2 = @$filter["y_net_weight"];
		$this->net_weight->AdvancedSearch->SearchOperator2 = @$filter["w_net_weight"];
		$this->net_weight->AdvancedSearch->save();

		// Field packets
		$this->packets->AdvancedSearch->SearchValue = @$filter["x_packets"];
		$this->packets->AdvancedSearch->SearchOperator = @$filter["z_packets"];
		$this->packets->AdvancedSearch->SearchCondition = @$filter["v_packets"];
		$this->packets->AdvancedSearch->SearchValue2 = @$filter["y_packets"];
		$this->packets->AdvancedSearch->SearchOperator2 = @$filter["w_packets"];
		$this->packets->AdvancedSearch->save();

		// Field packing_type
		$this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
		$this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
		$this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
		$this->packing_type->AdvancedSearch->save();

		// Field containers
		$this->containers->AdvancedSearch->SearchValue = @$filter["x_containers"];
		$this->containers->AdvancedSearch->SearchOperator = @$filter["z_containers"];
		$this->containers->AdvancedSearch->SearchCondition = @$filter["v_containers"];
		$this->containers->AdvancedSearch->SearchValue2 = @$filter["y_containers"];
		$this->containers->AdvancedSearch->SearchOperator2 = @$filter["w_containers"];
		$this->containers->AdvancedSearch->save();

		// Field shipping_line
		$this->shipping_line->AdvancedSearch->SearchValue = @$filter["x_shipping_line"];
		$this->shipping_line->AdvancedSearch->SearchOperator = @$filter["z_shipping_line"];
		$this->shipping_line->AdvancedSearch->SearchCondition = @$filter["v_shipping_line"];
		$this->shipping_line->AdvancedSearch->SearchValue2 = @$filter["y_shipping_line"];
		$this->shipping_line->AdvancedSearch->SearchOperator2 = @$filter["w_shipping_line"];
		$this->shipping_line->AdvancedSearch->save();

		// Field port_arrival_date
		$this->port_arrival_date->AdvancedSearch->SearchValue = @$filter["x_port_arrival_date"];
		$this->port_arrival_date->AdvancedSearch->SearchOperator = @$filter["z_port_arrival_date"];
		$this->port_arrival_date->AdvancedSearch->SearchCondition = @$filter["v_port_arrival_date"];
		$this->port_arrival_date->AdvancedSearch->SearchValue2 = @$filter["y_port_arrival_date"];
		$this->port_arrival_date->AdvancedSearch->SearchOperator2 = @$filter["w_port_arrival_date"];
		$this->port_arrival_date->AdvancedSearch->save();

		// Field godown_arrival_date
		$this->godown_arrival_date->AdvancedSearch->SearchValue = @$filter["x_godown_arrival_date"];
		$this->godown_arrival_date->AdvancedSearch->SearchOperator = @$filter["z_godown_arrival_date"];
		$this->godown_arrival_date->AdvancedSearch->SearchCondition = @$filter["v_godown_arrival_date"];
		$this->godown_arrival_date->AdvancedSearch->SearchValue2 = @$filter["y_godown_arrival_date"];
		$this->godown_arrival_date->AdvancedSearch->SearchOperator2 = @$filter["w_godown_arrival_date"];
		$this->godown_arrival_date->AdvancedSearch->save();

		// Field godown
		$this->godown->AdvancedSearch->SearchValue = @$filter["x_godown"];
		$this->godown->AdvancedSearch->SearchOperator = @$filter["z_godown"];
		$this->godown->AdvancedSearch->SearchCondition = @$filter["v_godown"];
		$this->godown->AdvancedSearch->SearchValue2 = @$filter["y_godown"];
		$this->godown->AdvancedSearch->SearchOperator2 = @$filter["w_godown"];
		$this->godown->AdvancedSearch->save();

		// Field rack
		$this->rack->AdvancedSearch->SearchValue = @$filter["x_rack"];
		$this->rack->AdvancedSearch->SearchOperator = @$filter["z_rack"];
		$this->rack->AdvancedSearch->SearchCondition = @$filter["v_rack"];
		$this->rack->AdvancedSearch->SearchValue2 = @$filter["y_rack"];
		$this->rack->AdvancedSearch->SearchOperator2 = @$filter["w_rack"];
		$this->rack->AdvancedSearch->save();

		// Field invoice_details
		$this->invoice_details->AdvancedSearch->SearchValue = @$filter["x_invoice_details"];
		$this->invoice_details->AdvancedSearch->SearchOperator = @$filter["z_invoice_details"];
		$this->invoice_details->AdvancedSearch->SearchCondition = @$filter["v_invoice_details"];
		$this->invoice_details->AdvancedSearch->SearchValue2 = @$filter["y_invoice_details"];
		$this->invoice_details->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_details"];
		$this->invoice_details->AdvancedSearch->save();

		// Field invoice_value
		$this->invoice_value->AdvancedSearch->SearchValue = @$filter["x_invoice_value"];
		$this->invoice_value->AdvancedSearch->SearchOperator = @$filter["z_invoice_value"];
		$this->invoice_value->AdvancedSearch->SearchCondition = @$filter["v_invoice_value"];
		$this->invoice_value->AdvancedSearch->SearchValue2 = @$filter["y_invoice_value"];
		$this->invoice_value->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_value"];
		$this->invoice_value->AdvancedSearch->save();

		// Field currency_rate
		$this->currency_rate->AdvancedSearch->SearchValue = @$filter["x_currency_rate"];
		$this->currency_rate->AdvancedSearch->SearchOperator = @$filter["z_currency_rate"];
		$this->currency_rate->AdvancedSearch->SearchCondition = @$filter["v_currency_rate"];
		$this->currency_rate->AdvancedSearch->SearchValue2 = @$filter["y_currency_rate"];
		$this->currency_rate->AdvancedSearch->SearchOperator2 = @$filter["w_currency_rate"];
		$this->currency_rate->AdvancedSearch->save();

		// Field purchase_amount_inr
		$this->purchase_amount_inr->AdvancedSearch->SearchValue = @$filter["x_purchase_amount_inr"];
		$this->purchase_amount_inr->AdvancedSearch->SearchOperator = @$filter["z_purchase_amount_inr"];
		$this->purchase_amount_inr->AdvancedSearch->SearchCondition = @$filter["v_purchase_amount_inr"];
		$this->purchase_amount_inr->AdvancedSearch->SearchValue2 = @$filter["y_purchase_amount_inr"];
		$this->purchase_amount_inr->AdvancedSearch->SearchOperator2 = @$filter["w_purchase_amount_inr"];
		$this->purchase_amount_inr->AdvancedSearch->save();

		// Field duty_paid_by
		$this->duty_paid_by->AdvancedSearch->SearchValue = @$filter["x_duty_paid_by"];
		$this->duty_paid_by->AdvancedSearch->SearchOperator = @$filter["z_duty_paid_by"];
		$this->duty_paid_by->AdvancedSearch->SearchCondition = @$filter["v_duty_paid_by"];
		$this->duty_paid_by->AdvancedSearch->SearchValue2 = @$filter["y_duty_paid_by"];
		$this->duty_paid_by->AdvancedSearch->SearchOperator2 = @$filter["w_duty_paid_by"];
		$this->duty_paid_by->AdvancedSearch->save();

		// Field custom_duty
		$this->custom_duty->AdvancedSearch->SearchValue = @$filter["x_custom_duty"];
		$this->custom_duty->AdvancedSearch->SearchOperator = @$filter["z_custom_duty"];
		$this->custom_duty->AdvancedSearch->SearchCondition = @$filter["v_custom_duty"];
		$this->custom_duty->AdvancedSearch->SearchValue2 = @$filter["y_custom_duty"];
		$this->custom_duty->AdvancedSearch->SearchOperator2 = @$filter["w_custom_duty"];
		$this->custom_duty->AdvancedSearch->save();

		// Field transportation_charges
		$this->transportation_charges->AdvancedSearch->SearchValue = @$filter["x_transportation_charges"];
		$this->transportation_charges->AdvancedSearch->SearchOperator = @$filter["z_transportation_charges"];
		$this->transportation_charges->AdvancedSearch->SearchCondition = @$filter["v_transportation_charges"];
		$this->transportation_charges->AdvancedSearch->SearchValue2 = @$filter["y_transportation_charges"];
		$this->transportation_charges->AdvancedSearch->SearchOperator2 = @$filter["w_transportation_charges"];
		$this->transportation_charges->AdvancedSearch->save();

		// Field port_clearing_charge
		$this->port_clearing_charge->AdvancedSearch->SearchValue = @$filter["x_port_clearing_charge"];
		$this->port_clearing_charge->AdvancedSearch->SearchOperator = @$filter["z_port_clearing_charge"];
		$this->port_clearing_charge->AdvancedSearch->SearchCondition = @$filter["v_port_clearing_charge"];
		$this->port_clearing_charge->AdvancedSearch->SearchValue2 = @$filter["y_port_clearing_charge"];
		$this->port_clearing_charge->AdvancedSearch->SearchOperator2 = @$filter["w_port_clearing_charge"];
		$this->port_clearing_charge->AdvancedSearch->save();

		// Field cha_commission
		$this->cha_commission->AdvancedSearch->SearchValue = @$filter["x_cha_commission"];
		$this->cha_commission->AdvancedSearch->SearchOperator = @$filter["z_cha_commission"];
		$this->cha_commission->AdvancedSearch->SearchCondition = @$filter["v_cha_commission"];
		$this->cha_commission->AdvancedSearch->SearchValue2 = @$filter["y_cha_commission"];
		$this->cha_commission->AdvancedSearch->SearchOperator2 = @$filter["w_cha_commission"];
		$this->cha_commission->AdvancedSearch->save();

		// Field cha_agent
		$this->cha_agent->AdvancedSearch->SearchValue = @$filter["x_cha_agent"];
		$this->cha_agent->AdvancedSearch->SearchOperator = @$filter["z_cha_agent"];
		$this->cha_agent->AdvancedSearch->SearchCondition = @$filter["v_cha_agent"];
		$this->cha_agent->AdvancedSearch->SearchValue2 = @$filter["y_cha_agent"];
		$this->cha_agent->AdvancedSearch->SearchOperator2 = @$filter["w_cha_agent"];
		$this->cha_agent->AdvancedSearch->save();

		// Field clearance_bank
		$this->clearance_bank->AdvancedSearch->SearchValue = @$filter["x_clearance_bank"];
		$this->clearance_bank->AdvancedSearch->SearchOperator = @$filter["z_clearance_bank"];
		$this->clearance_bank->AdvancedSearch->SearchCondition = @$filter["v_clearance_bank"];
		$this->clearance_bank->AdvancedSearch->SearchValue2 = @$filter["y_clearance_bank"];
		$this->clearance_bank->AdvancedSearch->SearchOperator2 = @$filter["w_clearance_bank"];
		$this->clearance_bank->AdvancedSearch->save();

		// Field bank_charges
		$this->bank_charges->AdvancedSearch->SearchValue = @$filter["x_bank_charges"];
		$this->bank_charges->AdvancedSearch->SearchOperator = @$filter["z_bank_charges"];
		$this->bank_charges->AdvancedSearch->SearchCondition = @$filter["v_bank_charges"];
		$this->bank_charges->AdvancedSearch->SearchValue2 = @$filter["y_bank_charges"];
		$this->bank_charges->AdvancedSearch->SearchOperator2 = @$filter["w_bank_charges"];
		$this->bank_charges->AdvancedSearch->save();

		// Field importer
		$this->importer->AdvancedSearch->SearchValue = @$filter["x_importer"];
		$this->importer->AdvancedSearch->SearchOperator = @$filter["z_importer"];
		$this->importer->AdvancedSearch->SearchCondition = @$filter["v_importer"];
		$this->importer->AdvancedSearch->SearchValue2 = @$filter["y_importer"];
		$this->importer->AdvancedSearch->SearchOperator2 = @$filter["w_importer"];
		$this->importer->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field fiba_fibd
		$this->fiba_fibd->AdvancedSearch->SearchValue = @$filter["x_fiba_fibd"];
		$this->fiba_fibd->AdvancedSearch->SearchOperator = @$filter["z_fiba_fibd"];
		$this->fiba_fibd->AdvancedSearch->SearchCondition = @$filter["v_fiba_fibd"];
		$this->fiba_fibd->AdvancedSearch->SearchValue2 = @$filter["y_fiba_fibd"];
		$this->fiba_fibd->AdvancedSearch->SearchOperator2 = @$filter["w_fiba_fibd"];
		$this->fiba_fibd->AdvancedSearch->save();

		// Field fibc
		$this->fibc->AdvancedSearch->SearchValue = @$filter["x_fibc"];
		$this->fibc->AdvancedSearch->SearchOperator = @$filter["z_fibc"];
		$this->fibc->AdvancedSearch->SearchCondition = @$filter["v_fibc"];
		$this->fibc->AdvancedSearch->SearchValue2 = @$filter["y_fibc"];
		$this->fibc->AdvancedSearch->SearchOperator2 = @$filter["w_fibc"];
		$this->fibc->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field qc_remarks
		$this->qc_remarks->AdvancedSearch->SearchValue = @$filter["x_qc_remarks"];
		$this->qc_remarks->AdvancedSearch->SearchOperator = @$filter["z_qc_remarks"];
		$this->qc_remarks->AdvancedSearch->SearchCondition = @$filter["v_qc_remarks"];
		$this->qc_remarks->AdvancedSearch->SearchValue2 = @$filter["y_qc_remarks"];
		$this->qc_remarks->AdvancedSearch->SearchOperator2 = @$filter["w_qc_remarks"];
		$this->qc_remarks->AdvancedSearch->save();

		// Field qc_status
		$this->qc_status->AdvancedSearch->SearchValue = @$filter["x_qc_status"];
		$this->qc_status->AdvancedSearch->SearchOperator = @$filter["z_qc_status"];
		$this->qc_status->AdvancedSearch->SearchCondition = @$filter["v_qc_status"];
		$this->qc_status->AdvancedSearch->SearchValue2 = @$filter["y_qc_status"];
		$this->qc_status->AdvancedSearch->SearchOperator2 = @$filter["w_qc_status"];
		$this->qc_status->AdvancedSearch->save();

		// Field qc_operator
		$this->qc_operator->AdvancedSearch->SearchValue = @$filter["x_qc_operator"];
		$this->qc_operator->AdvancedSearch->SearchOperator = @$filter["z_qc_operator"];
		$this->qc_operator->AdvancedSearch->SearchCondition = @$filter["v_qc_operator"];
		$this->qc_operator->AdvancedSearch->SearchValue2 = @$filter["y_qc_operator"];
		$this->qc_operator->AdvancedSearch->SearchOperator2 = @$filter["w_qc_operator"];
		$this->qc_operator->AdvancedSearch->save();

		// Field qc_datetime
		$this->qc_datetime->AdvancedSearch->SearchValue = @$filter["x_qc_datetime"];
		$this->qc_datetime->AdvancedSearch->SearchOperator = @$filter["z_qc_datetime"];
		$this->qc_datetime->AdvancedSearch->SearchCondition = @$filter["v_qc_datetime"];
		$this->qc_datetime->AdvancedSearch->SearchValue2 = @$filter["y_qc_datetime"];
		$this->qc_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_qc_datetime"];
		$this->qc_datetime->AdvancedSearch->save();

		// Field rbi_compliance_date
		$this->rbi_compliance_date->AdvancedSearch->SearchValue = @$filter["x_rbi_compliance_date"];
		$this->rbi_compliance_date->AdvancedSearch->SearchOperator = @$filter["z_rbi_compliance_date"];
		$this->rbi_compliance_date->AdvancedSearch->SearchCondition = @$filter["v_rbi_compliance_date"];
		$this->rbi_compliance_date->AdvancedSearch->SearchValue2 = @$filter["y_rbi_compliance_date"];
		$this->rbi_compliance_date->AdvancedSearch->SearchOperator2 = @$filter["w_rbi_compliance_date"];
		$this->rbi_compliance_date->AdvancedSearch->save();

		// Field age
		$this->age->AdvancedSearch->SearchValue = @$filter["x_age"];
		$this->age->AdvancedSearch->SearchOperator = @$filter["z_age"];
		$this->age->AdvancedSearch->SearchCondition = @$filter["v_age"];
		$this->age->AdvancedSearch->SearchValue2 = @$filter["y_age"];
		$this->age->AdvancedSearch->SearchOperator2 = @$filter["w_age"];
		$this->age->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->supplier, $default, FALSE); // supplier
		$this->buildSearchSql($where, $this->booking_reference, $default, FALSE); // booking_reference
		$this->buildSearchSql($where, $this->lot_no, $default, FALSE); // lot_no
		$this->buildSearchSql($where, $this->gross_weight, $default, FALSE); // gross_weight
		$this->buildSearchSql($where, $this->net_weight, $default, FALSE); // net_weight
		$this->buildSearchSql($where, $this->packets, $default, FALSE); // packets
		$this->buildSearchSql($where, $this->packing_type, $default, FALSE); // packing_type
		$this->buildSearchSql($where, $this->containers, $default, FALSE); // containers
		$this->buildSearchSql($where, $this->shipping_line, $default, FALSE); // shipping_line
		$this->buildSearchSql($where, $this->port_arrival_date, $default, FALSE); // port_arrival_date
		$this->buildSearchSql($where, $this->godown_arrival_date, $default, FALSE); // godown_arrival_date
		$this->buildSearchSql($where, $this->godown, $default, FALSE); // godown
		$this->buildSearchSql($where, $this->rack, $default, FALSE); // rack
		$this->buildSearchSql($where, $this->invoice_details, $default, FALSE); // invoice_details
		$this->buildSearchSql($where, $this->invoice_value, $default, FALSE); // invoice_value
		$this->buildSearchSql($where, $this->currency_rate, $default, FALSE); // currency_rate
		$this->buildSearchSql($where, $this->purchase_amount_inr, $default, FALSE); // purchase_amount_inr
		$this->buildSearchSql($where, $this->duty_paid_by, $default, FALSE); // duty_paid_by
		$this->buildSearchSql($where, $this->custom_duty, $default, FALSE); // custom_duty
		$this->buildSearchSql($where, $this->transportation_charges, $default, FALSE); // transportation_charges
		$this->buildSearchSql($where, $this->port_clearing_charge, $default, FALSE); // port_clearing_charge
		$this->buildSearchSql($where, $this->cha_commission, $default, FALSE); // cha_commission
		$this->buildSearchSql($where, $this->cha_agent, $default, FALSE); // cha_agent
		$this->buildSearchSql($where, $this->clearance_bank, $default, FALSE); // clearance_bank
		$this->buildSearchSql($where, $this->bank_charges, $default, FALSE); // bank_charges
		$this->buildSearchSql($where, $this->importer, $default, FALSE); // importer
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->fiba_fibd, $default, FALSE); // fiba_fibd
		$this->buildSearchSql($where, $this->fibc, $default, FALSE); // fibc
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->qc_remarks, $default, FALSE); // qc_remarks
		$this->buildSearchSql($where, $this->qc_status, $default, FALSE); // qc_status
		$this->buildSearchSql($where, $this->qc_operator, $default, FALSE); // qc_operator
		$this->buildSearchSql($where, $this->qc_datetime, $default, FALSE); // qc_datetime
		$this->buildSearchSql($where, $this->rbi_compliance_date, $default, FALSE); // rbi_compliance_date
		$this->buildSearchSql($where, $this->age, $default, FALSE); // age

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->supplier->AdvancedSearch->save(); // supplier
			$this->booking_reference->AdvancedSearch->save(); // booking_reference
			$this->lot_no->AdvancedSearch->save(); // lot_no
			$this->gross_weight->AdvancedSearch->save(); // gross_weight
			$this->net_weight->AdvancedSearch->save(); // net_weight
			$this->packets->AdvancedSearch->save(); // packets
			$this->packing_type->AdvancedSearch->save(); // packing_type
			$this->containers->AdvancedSearch->save(); // containers
			$this->shipping_line->AdvancedSearch->save(); // shipping_line
			$this->port_arrival_date->AdvancedSearch->save(); // port_arrival_date
			$this->godown_arrival_date->AdvancedSearch->save(); // godown_arrival_date
			$this->godown->AdvancedSearch->save(); // godown
			$this->rack->AdvancedSearch->save(); // rack
			$this->invoice_details->AdvancedSearch->save(); // invoice_details
			$this->invoice_value->AdvancedSearch->save(); // invoice_value
			$this->currency_rate->AdvancedSearch->save(); // currency_rate
			$this->purchase_amount_inr->AdvancedSearch->save(); // purchase_amount_inr
			$this->duty_paid_by->AdvancedSearch->save(); // duty_paid_by
			$this->custom_duty->AdvancedSearch->save(); // custom_duty
			$this->transportation_charges->AdvancedSearch->save(); // transportation_charges
			$this->port_clearing_charge->AdvancedSearch->save(); // port_clearing_charge
			$this->cha_commission->AdvancedSearch->save(); // cha_commission
			$this->cha_agent->AdvancedSearch->save(); // cha_agent
			$this->clearance_bank->AdvancedSearch->save(); // clearance_bank
			$this->bank_charges->AdvancedSearch->save(); // bank_charges
			$this->importer->AdvancedSearch->save(); // importer
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->fiba_fibd->AdvancedSearch->save(); // fiba_fibd
			$this->fibc->AdvancedSearch->save(); // fibc
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->qc_remarks->AdvancedSearch->save(); // qc_remarks
			$this->qc_status->AdvancedSearch->save(); // qc_status
			$this->qc_operator->AdvancedSearch->save(); // qc_operator
			$this->qc_datetime->AdvancedSearch->save(); // qc_datetime
			$this->rbi_compliance_date->AdvancedSearch->save(); // rbi_compliance_date
			$this->age->AdvancedSearch->save(); // age
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->shipping_line, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->rack, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cha_agent, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->clearance_bank, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->fiba_fibd, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->fibc, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->qc_remarks, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->supplier->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->booking_reference->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lot_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gross_weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->net_weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packets->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packing_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->containers->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->shipping_line->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->port_arrival_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->godown_arrival_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->godown->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rack->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_details->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_value->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->currency_rate->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->purchase_amount_inr->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->duty_paid_by->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->custom_duty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->transportation_charges->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->port_clearing_charge->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cha_commission->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cha_agent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->clearance_bank->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->bank_charges->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->importer->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fiba_fibd->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fibc->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qc_remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qc_status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qc_operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qc_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rbi_compliance_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->age->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->supplier->AdvancedSearch->unsetSession();
		$this->booking_reference->AdvancedSearch->unsetSession();
		$this->lot_no->AdvancedSearch->unsetSession();
		$this->gross_weight->AdvancedSearch->unsetSession();
		$this->net_weight->AdvancedSearch->unsetSession();
		$this->packets->AdvancedSearch->unsetSession();
		$this->packing_type->AdvancedSearch->unsetSession();
		$this->containers->AdvancedSearch->unsetSession();
		$this->shipping_line->AdvancedSearch->unsetSession();
		$this->port_arrival_date->AdvancedSearch->unsetSession();
		$this->godown_arrival_date->AdvancedSearch->unsetSession();
		$this->godown->AdvancedSearch->unsetSession();
		$this->rack->AdvancedSearch->unsetSession();
		$this->invoice_details->AdvancedSearch->unsetSession();
		$this->invoice_value->AdvancedSearch->unsetSession();
		$this->currency_rate->AdvancedSearch->unsetSession();
		$this->purchase_amount_inr->AdvancedSearch->unsetSession();
		$this->duty_paid_by->AdvancedSearch->unsetSession();
		$this->custom_duty->AdvancedSearch->unsetSession();
		$this->transportation_charges->AdvancedSearch->unsetSession();
		$this->port_clearing_charge->AdvancedSearch->unsetSession();
		$this->cha_commission->AdvancedSearch->unsetSession();
		$this->cha_agent->AdvancedSearch->unsetSession();
		$this->clearance_bank->AdvancedSearch->unsetSession();
		$this->bank_charges->AdvancedSearch->unsetSession();
		$this->importer->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->fiba_fibd->AdvancedSearch->unsetSession();
		$this->fibc->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->qc_remarks->AdvancedSearch->unsetSession();
		$this->qc_status->AdvancedSearch->unsetSession();
		$this->qc_operator->AdvancedSearch->unsetSession();
		$this->qc_datetime->AdvancedSearch->unsetSession();
		$this->rbi_compliance_date->AdvancedSearch->unsetSession();
		$this->age->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->supplier->AdvancedSearch->load();
		$this->booking_reference->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->gross_weight->AdvancedSearch->load();
		$this->net_weight->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->containers->AdvancedSearch->load();
		$this->shipping_line->AdvancedSearch->load();
		$this->port_arrival_date->AdvancedSearch->load();
		$this->godown_arrival_date->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->rack->AdvancedSearch->load();
		$this->invoice_details->AdvancedSearch->load();
		$this->invoice_value->AdvancedSearch->load();
		$this->currency_rate->AdvancedSearch->load();
		$this->purchase_amount_inr->AdvancedSearch->load();
		$this->duty_paid_by->AdvancedSearch->load();
		$this->custom_duty->AdvancedSearch->load();
		$this->transportation_charges->AdvancedSearch->load();
		$this->port_clearing_charge->AdvancedSearch->load();
		$this->cha_commission->AdvancedSearch->load();
		$this->cha_agent->AdvancedSearch->load();
		$this->clearance_bank->AdvancedSearch->load();
		$this->bank_charges->AdvancedSearch->load();
		$this->importer->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->fiba_fibd->AdvancedSearch->load();
		$this->fibc->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->qc_remarks->AdvancedSearch->load();
		$this->qc_status->AdvancedSearch->load();
		$this->qc_operator->AdvancedSearch->load();
		$this->qc_datetime->AdvancedSearch->load();
		$this->rbi_compliance_date->AdvancedSearch->load();
		$this->age->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->rid, $ctrl); // rid
			$this->updateSort($this->lot_no, $ctrl); // lot_no
			$this->updateSort($this->net_weight, $ctrl); // net_weight
			$this->updateSort($this->packing_type, $ctrl); // packing_type
			$this->updateSort($this->godown_arrival_date, $ctrl); // godown_arrival_date
			$this->updateSort($this->godown, $ctrl); // godown
			$this->updateSort($this->rack, $ctrl); // rack
			$this->updateSort($this->invoice_details, $ctrl); // invoice_details
			$this->updateSort($this->invoice_value, $ctrl); // invoice_value
			$this->updateSort($this->currency_rate, $ctrl); // currency_rate
			$this->updateSort($this->purchase_amount_inr, $ctrl); // purchase_amount_inr
			$this->updateSort($this->duty_paid_by, $ctrl); // duty_paid_by
			$this->updateSort($this->custom_duty, $ctrl); // custom_duty
			$this->updateSort($this->port_clearing_charge, $ctrl); // port_clearing_charge
			$this->updateSort($this->cha_commission, $ctrl); // cha_commission
			$this->updateSort($this->cha_agent, $ctrl); // cha_agent
			$this->updateSort($this->bank_charges, $ctrl); // bank_charges
			$this->updateSort($this->importer, $ctrl); // importer
			$this->updateSort($this->remarks, $ctrl); // remarks
			$this->updateSort($this->fiba_fibd, $ctrl); // fiba_fibd
			$this->updateSort($this->fibc, $ctrl); // fibc
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->qc_status, $ctrl); // qc_status
			$this->updateSort($this->qc_operator, $ctrl); // qc_operator
			$this->updateSort($this->qc_datetime, $ctrl); // qc_datetime
			$this->updateSort($this->rbi_compliance_date, $ctrl); // rbi_compliance_date
			$this->updateSort($this->age, $ctrl); // age
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->rid->setSort("");
				$this->lot_no->setSort("");
				$this->net_weight->setSort("");
				$this->packing_type->setSort("");
				$this->godown_arrival_date->setSort("");
				$this->godown->setSort("");
				$this->rack->setSort("");
				$this->invoice_details->setSort("");
				$this->invoice_value->setSort("");
				$this->currency_rate->setSort("");
				$this->purchase_amount_inr->setSort("");
				$this->duty_paid_by->setSort("");
				$this->custom_duty->setSort("");
				$this->port_clearing_charge->setSort("");
				$this->cha_commission->setSort("");
				$this->cha_agent->setSort("");
				$this->bank_charges->setSort("");
				$this->importer->setSort("");
				$this->remarks->setSort("");
				$this->fiba_fibd->setSort("");
				$this->fibc->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->qc_status->setSort("");
				$this->qc_operator->setSort("");
				$this->qc_datetime->setSort("");
				$this->rbi_compliance_date->setSort("");
				$this->age->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fpurchase_alistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpurchase_alistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fpurchase_alist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fpurchase_alistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"purchase_asrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fpurchase_alistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// supplier
		if (!$this->isAddOrEdit())
			$this->supplier->AdvancedSearch->setSearchValue(Get("x_supplier", Get("supplier", "")));
		if ($this->supplier->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->supplier->AdvancedSearch->setSearchOperator(Get("z_supplier", ""));

		// booking_reference
		if (!$this->isAddOrEdit())
			$this->booking_reference->AdvancedSearch->setSearchValue(Get("x_booking_reference", Get("booking_reference", "")));
		if ($this->booking_reference->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->booking_reference->AdvancedSearch->setSearchOperator(Get("z_booking_reference", ""));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue(Get("x_lot_no", Get("lot_no", "")));
		if ($this->lot_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->lot_no->AdvancedSearch->setSearchOperator(Get("z_lot_no", ""));

		// gross_weight
		if (!$this->isAddOrEdit())
			$this->gross_weight->AdvancedSearch->setSearchValue(Get("x_gross_weight", Get("gross_weight", "")));
		if ($this->gross_weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gross_weight->AdvancedSearch->setSearchOperator(Get("z_gross_weight", ""));

		// net_weight
		if (!$this->isAddOrEdit())
			$this->net_weight->AdvancedSearch->setSearchValue(Get("x_net_weight", Get("net_weight", "")));
		if ($this->net_weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->net_weight->AdvancedSearch->setSearchOperator(Get("z_net_weight", ""));
		$this->net_weight->AdvancedSearch->setSearchCondition(Get("v_net_weight", ""));
		$this->net_weight->AdvancedSearch->setSearchValue2(Get("y_net_weight", ""));
		if ($this->net_weight->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->net_weight->AdvancedSearch->setSearchOperator2(Get("w_net_weight", ""));

		// packets
		if (!$this->isAddOrEdit())
			$this->packets->AdvancedSearch->setSearchValue(Get("x_packets", Get("packets", "")));
		if ($this->packets->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packets->AdvancedSearch->setSearchOperator(Get("z_packets", ""));
		$this->packets->AdvancedSearch->setSearchCondition(Get("v_packets", ""));
		$this->packets->AdvancedSearch->setSearchValue2(Get("y_packets", ""));
		if ($this->packets->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packets->AdvancedSearch->setSearchOperator2(Get("w_packets", ""));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue(Get("x_packing_type", Get("packing_type", "")));
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packing_type->AdvancedSearch->setSearchOperator(Get("z_packing_type", ""));

		// containers
		if (!$this->isAddOrEdit())
			$this->containers->AdvancedSearch->setSearchValue(Get("x_containers", Get("containers", "")));
		if ($this->containers->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->containers->AdvancedSearch->setSearchOperator(Get("z_containers", ""));
		$this->containers->AdvancedSearch->setSearchCondition(Get("v_containers", ""));
		$this->containers->AdvancedSearch->setSearchValue2(Get("y_containers", ""));
		if ($this->containers->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->containers->AdvancedSearch->setSearchOperator2(Get("w_containers", ""));

		// shipping_line
		if (!$this->isAddOrEdit())
			$this->shipping_line->AdvancedSearch->setSearchValue(Get("x_shipping_line", Get("shipping_line", "")));
		if ($this->shipping_line->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->shipping_line->AdvancedSearch->setSearchOperator(Get("z_shipping_line", ""));

		// port_arrival_date
		if (!$this->isAddOrEdit())
			$this->port_arrival_date->AdvancedSearch->setSearchValue(Get("x_port_arrival_date", Get("port_arrival_date", "")));
		if ($this->port_arrival_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->port_arrival_date->AdvancedSearch->setSearchOperator(Get("z_port_arrival_date", ""));
		$this->port_arrival_date->AdvancedSearch->setSearchCondition(Get("v_port_arrival_date", ""));
		$this->port_arrival_date->AdvancedSearch->setSearchValue2(Get("y_port_arrival_date", ""));
		if ($this->port_arrival_date->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->port_arrival_date->AdvancedSearch->setSearchOperator2(Get("w_port_arrival_date", ""));

		// godown_arrival_date
		if (!$this->isAddOrEdit())
			$this->godown_arrival_date->AdvancedSearch->setSearchValue(Get("x_godown_arrival_date", Get("godown_arrival_date", "")));
		if ($this->godown_arrival_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->godown_arrival_date->AdvancedSearch->setSearchOperator(Get("z_godown_arrival_date", ""));
		$this->godown_arrival_date->AdvancedSearch->setSearchCondition(Get("v_godown_arrival_date", ""));
		$this->godown_arrival_date->AdvancedSearch->setSearchValue2(Get("y_godown_arrival_date", ""));
		if ($this->godown_arrival_date->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->godown_arrival_date->AdvancedSearch->setSearchOperator2(Get("w_godown_arrival_date", ""));

		// godown
		if (!$this->isAddOrEdit())
			$this->godown->AdvancedSearch->setSearchValue(Get("x_godown", Get("godown", "")));
		if ($this->godown->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->godown->AdvancedSearch->setSearchOperator(Get("z_godown", ""));

		// rack
		if (!$this->isAddOrEdit())
			$this->rack->AdvancedSearch->setSearchValue(Get("x_rack", Get("rack", "")));
		if ($this->rack->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rack->AdvancedSearch->setSearchOperator(Get("z_rack", ""));

		// invoice_details
		if (!$this->isAddOrEdit())
			$this->invoice_details->AdvancedSearch->setSearchValue(Get("x_invoice_details", Get("invoice_details", "")));
		if ($this->invoice_details->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_details->AdvancedSearch->setSearchOperator(Get("z_invoice_details", ""));

		// invoice_value
		if (!$this->isAddOrEdit())
			$this->invoice_value->AdvancedSearch->setSearchValue(Get("x_invoice_value", Get("invoice_value", "")));
		if ($this->invoice_value->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_value->AdvancedSearch->setSearchOperator(Get("z_invoice_value", ""));

		// currency_rate
		if (!$this->isAddOrEdit())
			$this->currency_rate->AdvancedSearch->setSearchValue(Get("x_currency_rate", Get("currency_rate", "")));
		if ($this->currency_rate->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->currency_rate->AdvancedSearch->setSearchOperator(Get("z_currency_rate", ""));

		// purchase_amount_inr
		if (!$this->isAddOrEdit())
			$this->purchase_amount_inr->AdvancedSearch->setSearchValue(Get("x_purchase_amount_inr", Get("purchase_amount_inr", "")));
		if ($this->purchase_amount_inr->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->purchase_amount_inr->AdvancedSearch->setSearchOperator(Get("z_purchase_amount_inr", ""));
		$this->purchase_amount_inr->AdvancedSearch->setSearchCondition(Get("v_purchase_amount_inr", ""));
		$this->purchase_amount_inr->AdvancedSearch->setSearchValue2(Get("y_purchase_amount_inr", ""));
		if ($this->purchase_amount_inr->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->purchase_amount_inr->AdvancedSearch->setSearchOperator2(Get("w_purchase_amount_inr", ""));

		// duty_paid_by
		if (!$this->isAddOrEdit())
			$this->duty_paid_by->AdvancedSearch->setSearchValue(Get("x_duty_paid_by", Get("duty_paid_by", "")));
		if ($this->duty_paid_by->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->duty_paid_by->AdvancedSearch->setSearchOperator(Get("z_duty_paid_by", ""));

		// custom_duty
		if (!$this->isAddOrEdit())
			$this->custom_duty->AdvancedSearch->setSearchValue(Get("x_custom_duty", Get("custom_duty", "")));
		if ($this->custom_duty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->custom_duty->AdvancedSearch->setSearchOperator(Get("z_custom_duty", ""));

		// transportation_charges
		if (!$this->isAddOrEdit())
			$this->transportation_charges->AdvancedSearch->setSearchValue(Get("x_transportation_charges", Get("transportation_charges", "")));
		if ($this->transportation_charges->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->transportation_charges->AdvancedSearch->setSearchOperator(Get("z_transportation_charges", ""));

		// port_clearing_charge
		if (!$this->isAddOrEdit())
			$this->port_clearing_charge->AdvancedSearch->setSearchValue(Get("x_port_clearing_charge", Get("port_clearing_charge", "")));
		if ($this->port_clearing_charge->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->port_clearing_charge->AdvancedSearch->setSearchOperator(Get("z_port_clearing_charge", ""));

		// cha_commission
		if (!$this->isAddOrEdit())
			$this->cha_commission->AdvancedSearch->setSearchValue(Get("x_cha_commission", Get("cha_commission", "")));
		if ($this->cha_commission->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cha_commission->AdvancedSearch->setSearchOperator(Get("z_cha_commission", ""));

		// cha_agent
		if (!$this->isAddOrEdit())
			$this->cha_agent->AdvancedSearch->setSearchValue(Get("x_cha_agent", Get("cha_agent", "")));
		if ($this->cha_agent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cha_agent->AdvancedSearch->setSearchOperator(Get("z_cha_agent", ""));

		// clearance_bank
		if (!$this->isAddOrEdit())
			$this->clearance_bank->AdvancedSearch->setSearchValue(Get("x_clearance_bank", Get("clearance_bank", "")));
		if ($this->clearance_bank->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->clearance_bank->AdvancedSearch->setSearchOperator(Get("z_clearance_bank", ""));

		// bank_charges
		if (!$this->isAddOrEdit())
			$this->bank_charges->AdvancedSearch->setSearchValue(Get("x_bank_charges", Get("bank_charges", "")));
		if ($this->bank_charges->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->bank_charges->AdvancedSearch->setSearchOperator(Get("z_bank_charges", ""));

		// importer
		if (!$this->isAddOrEdit())
			$this->importer->AdvancedSearch->setSearchValue(Get("x_importer", Get("importer", "")));
		if ($this->importer->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->importer->AdvancedSearch->setSearchOperator(Get("z_importer", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// fiba_fibd
		if (!$this->isAddOrEdit())
			$this->fiba_fibd->AdvancedSearch->setSearchValue(Get("x_fiba_fibd", Get("fiba_fibd", "")));
		if ($this->fiba_fibd->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fiba_fibd->AdvancedSearch->setSearchOperator(Get("z_fiba_fibd", ""));

		// fibc
		if (!$this->isAddOrEdit())
			$this->fibc->AdvancedSearch->setSearchValue(Get("x_fibc", Get("fibc", "")));
		if ($this->fibc->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fibc->AdvancedSearch->setSearchOperator(Get("z_fibc", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchCondition(Get("v_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchValue2(Get("y_datetime", ""));
		if ($this->datetime->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator2(Get("w_datetime", ""));

		// qc_remarks
		if (!$this->isAddOrEdit())
			$this->qc_remarks->AdvancedSearch->setSearchValue(Get("x_qc_remarks", Get("qc_remarks", "")));
		if ($this->qc_remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qc_remarks->AdvancedSearch->setSearchOperator(Get("z_qc_remarks", ""));

		// qc_status
		if (!$this->isAddOrEdit())
			$this->qc_status->AdvancedSearch->setSearchValue(Get("x_qc_status", Get("qc_status", "")));
		if ($this->qc_status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qc_status->AdvancedSearch->setSearchOperator(Get("z_qc_status", ""));

		// qc_operator
		if (!$this->isAddOrEdit())
			$this->qc_operator->AdvancedSearch->setSearchValue(Get("x_qc_operator", Get("qc_operator", "")));
		if ($this->qc_operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qc_operator->AdvancedSearch->setSearchOperator(Get("z_qc_operator", ""));

		// qc_datetime
		if (!$this->isAddOrEdit())
			$this->qc_datetime->AdvancedSearch->setSearchValue(Get("x_qc_datetime", Get("qc_datetime", "")));
		if ($this->qc_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qc_datetime->AdvancedSearch->setSearchOperator(Get("z_qc_datetime", ""));

		// rbi_compliance_date
		if (!$this->isAddOrEdit())
			$this->rbi_compliance_date->AdvancedSearch->setSearchValue(Get("x_rbi_compliance_date", Get("rbi_compliance_date", "")));
		if ($this->rbi_compliance_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rbi_compliance_date->AdvancedSearch->setSearchOperator(Get("z_rbi_compliance_date", ""));

		// age
		if (!$this->isAddOrEdit())
			$this->age->AdvancedSearch->setSearchValue(Get("x_age", Get("age", "")));
		if ($this->age->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->age->AdvancedSearch->setSearchOperator(Get("z_age", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->supplier->setDbValue($row['supplier']);
		$this->booking_reference->setDbValue($row['booking_reference']);
		$this->rid->setDbValue($row['rid']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->gross_weight->setDbValue($row['gross_weight']);
		$this->net_weight->setDbValue($row['net_weight']);
		$this->packets->setDbValue($row['packets']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->containers->setDbValue($row['containers']);
		$this->shipping_line->setDbValue($row['shipping_line']);
		$this->port_arrival_date->setDbValue($row['port_arrival_date']);
		$this->godown_arrival_date->setDbValue($row['godown_arrival_date']);
		$this->godown->setDbValue($row['godown']);
		$this->rack->setDbValue($row['rack']);
		$this->invoice_details->setDbValue($row['invoice_details']);
		$this->invoice_value->setDbValue($row['invoice_value']);
		$this->currency_rate->setDbValue($row['currency_rate']);
		$this->purchase_amount_inr->setDbValue($row['purchase_amount_inr']);
		$this->duty_paid_by->setDbValue($row['duty_paid_by']);
		$this->custom_duty->setDbValue($row['custom_duty']);
		$this->transportation_charges->setDbValue($row['transportation_charges']);
		$this->port_clearing_charge->setDbValue($row['port_clearing_charge']);
		$this->cha_commission->setDbValue($row['cha_commission']);
		$this->cha_agent->setDbValue($row['cha_agent']);
		$this->clearance_bank->setDbValue($row['clearance_bank']);
		$this->bank_charges->setDbValue($row['bank_charges']);
		$this->importer->setDbValue($row['importer']);
		$this->remarks->setDbValue($row['remarks']);
		$this->fiba_fibd->setDbValue($row['fiba_fibd']);
		$this->fibc->setDbValue($row['fibc']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->updated->setDbValue($row['updated']);
		$this->grp->setDbValue($row['grp']);
		$this->qc_remarks->setDbValue($row['qc_remarks']);
		$this->qc_status->setDbValue($row['qc_status']);
		$this->qc_operator->setDbValue($row['qc_operator']);
		$this->qc_datetime->setDbValue($row['qc_datetime']);
		$this->rbi_compliance_date->setDbValue($row['rbi_compliance_date']);
		$this->age->setDbValue($row['age']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['supplier'] = NULL;
		$row['booking_reference'] = NULL;
		$row['rid'] = NULL;
		$row['lot_no'] = NULL;
		$row['gross_weight'] = NULL;
		$row['net_weight'] = NULL;
		$row['packets'] = NULL;
		$row['packing_type'] = NULL;
		$row['containers'] = NULL;
		$row['shipping_line'] = NULL;
		$row['port_arrival_date'] = NULL;
		$row['godown_arrival_date'] = NULL;
		$row['godown'] = NULL;
		$row['rack'] = NULL;
		$row['invoice_details'] = NULL;
		$row['invoice_value'] = NULL;
		$row['currency_rate'] = NULL;
		$row['purchase_amount_inr'] = NULL;
		$row['duty_paid_by'] = NULL;
		$row['custom_duty'] = NULL;
		$row['transportation_charges'] = NULL;
		$row['port_clearing_charge'] = NULL;
		$row['cha_commission'] = NULL;
		$row['cha_agent'] = NULL;
		$row['clearance_bank'] = NULL;
		$row['bank_charges'] = NULL;
		$row['importer'] = NULL;
		$row['remarks'] = NULL;
		$row['fiba_fibd'] = NULL;
		$row['fibc'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['updated'] = NULL;
		$row['grp'] = NULL;
		$row['qc_remarks'] = NULL;
		$row['qc_status'] = NULL;
		$row['qc_operator'] = NULL;
		$row['qc_datetime'] = NULL;
		$row['rbi_compliance_date'] = NULL;
		$row['age'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->net_weight->FormValue == $this->net_weight->CurrentValue && is_numeric(ConvertToFloatString($this->net_weight->CurrentValue)))
			$this->net_weight->CurrentValue = ConvertToFloatString($this->net_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->invoice_value->FormValue == $this->invoice_value->CurrentValue && is_numeric(ConvertToFloatString($this->invoice_value->CurrentValue)))
			$this->invoice_value->CurrentValue = ConvertToFloatString($this->invoice_value->CurrentValue);

		// Convert decimal values if posted back
		if ($this->currency_rate->FormValue == $this->currency_rate->CurrentValue && is_numeric(ConvertToFloatString($this->currency_rate->CurrentValue)))
			$this->currency_rate->CurrentValue = ConvertToFloatString($this->currency_rate->CurrentValue);

		// Convert decimal values if posted back
		if ($this->purchase_amount_inr->FormValue == $this->purchase_amount_inr->CurrentValue && is_numeric(ConvertToFloatString($this->purchase_amount_inr->CurrentValue)))
			$this->purchase_amount_inr->CurrentValue = ConvertToFloatString($this->purchase_amount_inr->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_duty->FormValue == $this->custom_duty->CurrentValue && is_numeric(ConvertToFloatString($this->custom_duty->CurrentValue)))
			$this->custom_duty->CurrentValue = ConvertToFloatString($this->custom_duty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->port_clearing_charge->FormValue == $this->port_clearing_charge->CurrentValue && is_numeric(ConvertToFloatString($this->port_clearing_charge->CurrentValue)))
			$this->port_clearing_charge->CurrentValue = ConvertToFloatString($this->port_clearing_charge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cha_commission->FormValue == $this->cha_commission->CurrentValue && is_numeric(ConvertToFloatString($this->cha_commission->CurrentValue)))
			$this->cha_commission->CurrentValue = ConvertToFloatString($this->cha_commission->CurrentValue);

		// Convert decimal values if posted back
		if ($this->bank_charges->FormValue == $this->bank_charges->CurrentValue && is_numeric(ConvertToFloatString($this->bank_charges->CurrentValue)))
			$this->bank_charges->CurrentValue = ConvertToFloatString($this->bank_charges->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// supplier
		// booking_reference
		// rid

		$this->rid->CellCssStyle = "white-space: nowrap;";

		// lot_no
		// gross_weight
		// net_weight
		// packets
		// packing_type
		// containers
		// shipping_line
		// port_arrival_date
		// godown_arrival_date
		// godown
		// rack
		// invoice_details
		// invoice_value
		// currency_rate
		// purchase_amount_inr
		// duty_paid_by
		// custom_duty
		// transportation_charges
		// port_clearing_charge
		// cha_commission
		// cha_agent
		// clearance_bank
		// bank_charges
		// importer
		// remarks
		// fiba_fibd
		// fibc
		// operator
		// datetime
		// updated

		$this->updated->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// qc_remarks
		// qc_status
		// qc_operator
		// qc_datetime
		// rbi_compliance_date
		// age

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// supplier
			$curVal = strval($this->supplier->CurrentValue);
			if ($curVal <> "") {
				$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
				if ($this->supplier->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->supplier->ViewValue = $this->supplier->CurrentValue;
					}
				}
			} else {
				$this->supplier->ViewValue = NULL;
			}
			$this->supplier->ViewCustomAttributes = "";

			// booking_reference
			$curVal = strval($this->booking_reference->CurrentValue);
			if ($curVal <> "") {
				$this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
				if ($this->booking_reference->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->booking_reference->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
					}
				}
			} else {
				$this->booking_reference->ViewValue = NULL;
			}
			$this->booking_reference->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, 3, -2, -2, -2);
			$this->gross_weight->ViewCustomAttributes = "";

			// net_weight
			$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
			$this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, 3, -2, -2, -2);
			$this->net_weight->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// containers
			$this->containers->ViewValue = $this->containers->CurrentValue;
			$this->containers->ViewValue = FormatNumber($this->containers->ViewValue, 2, -2, -2, -2);
			$this->containers->ViewCustomAttributes = "";

			// shipping_line
			$curVal = strval($this->shipping_line->CurrentValue);
			if ($curVal <> "") {
				$this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
				if ($this->shipping_line->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->shipping_line->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
					}
				}
			} else {
				$this->shipping_line->ViewValue = NULL;
			}
			$this->shipping_line->ViewCustomAttributes = "";

			// port_arrival_date
			$this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
			$this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, 0);
			$this->port_arrival_date->ViewCustomAttributes = "";

			// godown_arrival_date
			$this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
			$this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, 0);
			$this->godown_arrival_date->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// rack
			$this->rack->ViewValue = $this->rack->CurrentValue;
			$this->rack->ViewCustomAttributes = "";

			// invoice_details
			$this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;
			$this->invoice_details->ViewCustomAttributes = "";

			// invoice_value
			$this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
			$this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, 2, -2, -2, -2);
			$this->invoice_value->ViewCustomAttributes = "";

			// currency_rate
			$this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
			$this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, 3, -2, -2, -2);
			$this->currency_rate->ViewCustomAttributes = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
			$this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, 2, -2, -2, -2);
			$this->purchase_amount_inr->ViewCustomAttributes = "";

			// duty_paid_by
			if (strval($this->duty_paid_by->CurrentValue) <> "") {
				$this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
			} else {
				$this->duty_paid_by->ViewValue = NULL;
			}
			$this->duty_paid_by->ViewCustomAttributes = "";

			// custom_duty
			$this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
			$this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, 2, -2, -2, -2);
			$this->custom_duty->ViewCustomAttributes = "";

			// transportation_charges
			$this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
			$this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, 2, -2, -2, -2);
			$this->transportation_charges->ViewCustomAttributes = "";

			// port_clearing_charge
			$this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
			$this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, 2, -2, -2, -2);
			$this->port_clearing_charge->ViewCustomAttributes = "";

			// cha_commission
			$this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
			$this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, 2, -2, -2, -2);
			$this->cha_commission->ViewCustomAttributes = "";

			// cha_agent
			$curVal = strval($this->cha_agent->CurrentValue);
			if ($curVal <> "") {
				$this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
				if ($this->cha_agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cha_agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
					}
				}
			} else {
				$this->cha_agent->ViewValue = NULL;
			}
			$this->cha_agent->ViewCustomAttributes = "";

			// clearance_bank
			$curVal = strval($this->clearance_bank->CurrentValue);
			if ($curVal <> "") {
				$this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
				if ($this->clearance_bank->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->clearance_bank->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
					}
				}
			} else {
				$this->clearance_bank->ViewValue = NULL;
			}
			$this->clearance_bank->ViewCustomAttributes = "";

			// bank_charges
			$this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
			$this->bank_charges->ViewCustomAttributes = "";

			// importer
			$curVal = strval($this->importer->CurrentValue);
			if ($curVal <> "") {
				$this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
				if ($this->importer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->importer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->importer->ViewValue = $this->importer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->importer->ViewValue = $this->importer->CurrentValue;
					}
				}
			} else {
				$this->importer->ViewValue = NULL;
			}
			$this->importer->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// fiba_fibd
			$this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;
			$this->fiba_fibd->ViewCustomAttributes = "";

			// fibc
			$this->fibc->ViewValue = $this->fibc->CurrentValue;
			$this->fibc->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// qc_status
			$this->qc_status->ViewValue = $this->qc_status->CurrentValue;
			$this->qc_status->ViewValue = FormatNumber($this->qc_status->ViewValue, 0, -2, -2, -2);
			$this->qc_status->ViewCustomAttributes = "";

			// qc_operator
			$this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
			$this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, 0, -2, -2, -2);
			$this->qc_operator->ViewCustomAttributes = "";

			// qc_datetime
			$this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
			$this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, 0);
			$this->qc_datetime->ViewCustomAttributes = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->ViewValue = $this->rbi_compliance_date->CurrentValue;
			$this->rbi_compliance_date->ViewValue = FormatDateTime($this->rbi_compliance_date->ViewValue, 0);
			$this->rbi_compliance_date->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
			$this->age->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "purchase_a_flist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";
			if (!$this->isExport())
				$this->lot_no->ViewValue = $this->highlightValue($this->lot_no);

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";
			$this->net_weight->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "purchase_a_flist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// godown_arrival_date
			$this->godown_arrival_date->LinkCustomAttributes = "";
			$this->godown_arrival_date->HrefValue = "";
			$this->godown_arrival_date->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "purchase_a_flist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// rack
			$this->rack->LinkCustomAttributes = "";
			$this->rack->HrefValue = "";
			$this->rack->TooltipValue = "";
			if (!$this->isExport())
				$this->rack->ViewValue = $this->highlightValue($this->rack);

			// invoice_details
			$this->invoice_details->LinkCustomAttributes = "";
			$this->invoice_details->HrefValue = "";
			$this->invoice_details->TooltipValue = "";
			if (!$this->isExport())
				$this->invoice_details->ViewValue = $this->highlightValue($this->invoice_details);

			// invoice_value
			$this->invoice_value->LinkCustomAttributes = "";
			$this->invoice_value->HrefValue = "";
			$this->invoice_value->TooltipValue = "";

			// currency_rate
			$this->currency_rate->LinkCustomAttributes = "";
			$this->currency_rate->HrefValue = "";
			$this->currency_rate->TooltipValue = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->LinkCustomAttributes = "";
			$this->purchase_amount_inr->HrefValue = "";
			$this->purchase_amount_inr->TooltipValue = "";

			// duty_paid_by
			$this->duty_paid_by->LinkCustomAttributes = "";
			$this->duty_paid_by->HrefValue = "";
			$this->duty_paid_by->TooltipValue = "";

			// custom_duty
			$this->custom_duty->LinkCustomAttributes = "";
			$this->custom_duty->HrefValue = "";
			$this->custom_duty->TooltipValue = "";

			// port_clearing_charge
			$this->port_clearing_charge->LinkCustomAttributes = "";
			$this->port_clearing_charge->HrefValue = "";
			$this->port_clearing_charge->TooltipValue = "";

			// cha_commission
			$this->cha_commission->LinkCustomAttributes = "";
			$this->cha_commission->HrefValue = "";
			$this->cha_commission->TooltipValue = "";

			// cha_agent
			$this->cha_agent->LinkCustomAttributes = "";
			$this->cha_agent->HrefValue = "";
			$this->cha_agent->TooltipValue = "";

			// bank_charges
			$this->bank_charges->LinkCustomAttributes = "";
			$this->bank_charges->HrefValue = "";
			$this->bank_charges->TooltipValue = "";
			if (!$this->isExport())
				$this->bank_charges->ViewValue = $this->highlightValue($this->bank_charges);

			// importer
			$this->importer->LinkCustomAttributes = "";
			$this->importer->HrefValue = "";
			$this->importer->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";
			if (!$this->isExport())
				$this->remarks->ViewValue = $this->highlightValue($this->remarks);

			// fiba_fibd
			$this->fiba_fibd->LinkCustomAttributes = "";
			$this->fiba_fibd->HrefValue = "";
			$this->fiba_fibd->TooltipValue = "";
			if (!$this->isExport())
				$this->fiba_fibd->ViewValue = $this->highlightValue($this->fiba_fibd);

			// fibc
			$this->fibc->LinkCustomAttributes = "";
			$this->fibc->HrefValue = "";
			$this->fibc->TooltipValue = "";
			if (!$this->isExport())
				$this->fibc->ViewValue = $this->highlightValue($this->fibc);

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// qc_status
			$this->qc_status->LinkCustomAttributes = "";
			$this->qc_status->HrefValue = "";
			$this->qc_status->TooltipValue = "";

			// qc_operator
			$this->qc_operator->LinkCustomAttributes = "";
			$this->qc_operator->HrefValue = "";
			$this->qc_operator->TooltipValue = "";

			// qc_datetime
			$this->qc_datetime->LinkCustomAttributes = "";
			$this->qc_datetime->HrefValue = "";
			$this->qc_datetime->TooltipValue = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->LinkCustomAttributes = "";
			$this->rbi_compliance_date->HrefValue = "";
			$this->rbi_compliance_date->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->supplier->AdvancedSearch->load();
		$this->booking_reference->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->gross_weight->AdvancedSearch->load();
		$this->net_weight->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->containers->AdvancedSearch->load();
		$this->shipping_line->AdvancedSearch->load();
		$this->port_arrival_date->AdvancedSearch->load();
		$this->godown_arrival_date->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->rack->AdvancedSearch->load();
		$this->invoice_details->AdvancedSearch->load();
		$this->invoice_value->AdvancedSearch->load();
		$this->currency_rate->AdvancedSearch->load();
		$this->purchase_amount_inr->AdvancedSearch->load();
		$this->duty_paid_by->AdvancedSearch->load();
		$this->custom_duty->AdvancedSearch->load();
		$this->transportation_charges->AdvancedSearch->load();
		$this->port_clearing_charge->AdvancedSearch->load();
		$this->cha_commission->AdvancedSearch->load();
		$this->cha_agent->AdvancedSearch->load();
		$this->clearance_bank->AdvancedSearch->load();
		$this->bank_charges->AdvancedSearch->load();
		$this->importer->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->fiba_fibd->AdvancedSearch->load();
		$this->fibc->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->qc_remarks->AdvancedSearch->load();
		$this->qc_status->AdvancedSearch->load();
		$this->qc_operator->AdvancedSearch->load();
		$this->qc_datetime->AdvancedSearch->load();
		$this->rbi_compliance_date->AdvancedSearch->load();
		$this->age->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fpurchase_alist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fpurchase_alist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fpurchase_alist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_purchase_a\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_purchase_a',hdr:ew.language.phrase('ExportToEmailText'),f:document.fpurchase_alist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_supplier":
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_booking_reference":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cha_agent":
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_importer":
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_supplier":
							break;
						case "x_booking_reference":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_shipping_line":
							break;
						case "x_godown":
							break;
						case "x_cha_agent":
							break;
						case "x_clearance_bank":
							break;
						case "x_importer":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>