<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class purchase_a_search extends purchase_a
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'purchase_a';

	// Page object name
	public $PageObjName = "purchase_a_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (purchase_a)
		if (!isset($GLOBALS["purchase_a"]) || get_class($GLOBALS["purchase_a"]) == PROJECT_NAMESPACE . "purchase_a") {
			$GLOBALS["purchase_a"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["purchase_a"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_a');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $purchase_a;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($purchase_a);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "purchase_aview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("purchase_alist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->supplier->setVisibility();
		$this->booking_reference->setVisibility();
		$this->rid->Visible = FALSE;
		$this->lot_no->setVisibility();
		$this->gross_weight->setVisibility();
		$this->net_weight->setVisibility();
		$this->packets->setVisibility();
		$this->packing_type->setVisibility();
		$this->containers->setVisibility();
		$this->shipping_line->setVisibility();
		$this->port_arrival_date->setVisibility();
		$this->godown_arrival_date->setVisibility();
		$this->godown->setVisibility();
		$this->rack->setVisibility();
		$this->invoice_details->setVisibility();
		$this->invoice_value->setVisibility();
		$this->currency_rate->setVisibility();
		$this->purchase_amount_inr->setVisibility();
		$this->duty_paid_by->setVisibility();
		$this->custom_duty->setVisibility();
		$this->transportation_charges->setVisibility();
		$this->port_clearing_charge->setVisibility();
		$this->cha_commission->setVisibility();
		$this->cha_agent->setVisibility();
		$this->clearance_bank->setVisibility();
		$this->bank_charges->setVisibility();
		$this->importer->setVisibility();
		$this->remarks->setVisibility();
		$this->fiba_fibd->setVisibility();
		$this->fibc->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->qc_remarks->setVisibility();
		$this->qc_status->setVisibility();
		$this->qc_operator->setVisibility();
		$this->qc_datetime->setVisibility();
		$this->rbi_compliance_date->setVisibility();
		$this->age->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->supplier);
		$this->setupLookupOptions($this->booking_reference);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->shipping_line);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->cha_agent);
		$this->setupLookupOptions($this->clearance_bank);
		$this->setupLookupOptions($this->importer);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "purchase_alist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->supplier); // supplier
		$this->buildSearchUrl($srchUrl, $this->booking_reference); // booking_reference
		$this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
		$this->buildSearchUrl($srchUrl, $this->gross_weight); // gross_weight
		$this->buildSearchUrl($srchUrl, $this->net_weight); // net_weight
		$this->buildSearchUrl($srchUrl, $this->packets); // packets
		$this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
		$this->buildSearchUrl($srchUrl, $this->containers); // containers
		$this->buildSearchUrl($srchUrl, $this->shipping_line); // shipping_line
		$this->buildSearchUrl($srchUrl, $this->port_arrival_date); // port_arrival_date
		$this->buildSearchUrl($srchUrl, $this->godown_arrival_date); // godown_arrival_date
		$this->buildSearchUrl($srchUrl, $this->godown); // godown
		$this->buildSearchUrl($srchUrl, $this->rack); // rack
		$this->buildSearchUrl($srchUrl, $this->invoice_details); // invoice_details
		$this->buildSearchUrl($srchUrl, $this->invoice_value); // invoice_value
		$this->buildSearchUrl($srchUrl, $this->currency_rate); // currency_rate
		$this->buildSearchUrl($srchUrl, $this->purchase_amount_inr); // purchase_amount_inr
		$this->buildSearchUrl($srchUrl, $this->duty_paid_by); // duty_paid_by
		$this->buildSearchUrl($srchUrl, $this->custom_duty); // custom_duty
		$this->buildSearchUrl($srchUrl, $this->transportation_charges); // transportation_charges
		$this->buildSearchUrl($srchUrl, $this->port_clearing_charge); // port_clearing_charge
		$this->buildSearchUrl($srchUrl, $this->cha_commission); // cha_commission
		$this->buildSearchUrl($srchUrl, $this->cha_agent); // cha_agent
		$this->buildSearchUrl($srchUrl, $this->clearance_bank); // clearance_bank
		$this->buildSearchUrl($srchUrl, $this->bank_charges); // bank_charges
		$this->buildSearchUrl($srchUrl, $this->importer); // importer
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->fiba_fibd); // fiba_fibd
		$this->buildSearchUrl($srchUrl, $this->fibc); // fibc
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->qc_remarks); // qc_remarks
		$this->buildSearchUrl($srchUrl, $this->qc_status); // qc_status
		$this->buildSearchUrl($srchUrl, $this->qc_operator); // qc_operator
		$this->buildSearchUrl($srchUrl, $this->qc_datetime); // qc_datetime
		$this->buildSearchUrl($srchUrl, $this->rbi_compliance_date); // rbi_compliance_date
		$this->buildSearchUrl($srchUrl, $this->age); // age
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// supplier
		if (!$this->isAddOrEdit())
			$this->supplier->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_supplier"));
		$this->supplier->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_supplier"));

		// booking_reference
		if (!$this->isAddOrEdit())
			$this->booking_reference->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_booking_reference"));
		$this->booking_reference->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_booking_reference"));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lot_no"));
		$this->lot_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lot_no"));

		// gross_weight
		if (!$this->isAddOrEdit())
			$this->gross_weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gross_weight"));
		$this->gross_weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gross_weight"));

		// net_weight
		if (!$this->isAddOrEdit())
			$this->net_weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_net_weight"));
		$this->net_weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_net_weight"));
		$this->net_weight->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_net_weight"));
		$this->net_weight->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_net_weight"));
		$this->net_weight->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_net_weight"));

		// packets
		if (!$this->isAddOrEdit())
			$this->packets->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packets"));
		$this->packets->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packets"));
		$this->packets->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_packets"));
		$this->packets->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_packets"));
		$this->packets->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_packets"));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_type"));
		$this->packing_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_type"));

		// containers
		if (!$this->isAddOrEdit())
			$this->containers->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_containers"));
		$this->containers->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_containers"));
		$this->containers->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_containers"));
		$this->containers->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_containers"));
		$this->containers->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_containers"));

		// shipping_line
		if (!$this->isAddOrEdit())
			$this->shipping_line->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipping_line"));
		$this->shipping_line->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipping_line"));

		// port_arrival_date
		if (!$this->isAddOrEdit())
			$this->port_arrival_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_port_arrival_date"));
		$this->port_arrival_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_port_arrival_date"));
		$this->port_arrival_date->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_port_arrival_date"));
		$this->port_arrival_date->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_port_arrival_date"));
		$this->port_arrival_date->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_port_arrival_date"));

		// godown_arrival_date
		if (!$this->isAddOrEdit())
			$this->godown_arrival_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_godown_arrival_date"));
		$this->godown_arrival_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_godown_arrival_date"));
		$this->godown_arrival_date->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_godown_arrival_date"));
		$this->godown_arrival_date->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_godown_arrival_date"));
		$this->godown_arrival_date->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_godown_arrival_date"));

		// godown
		if (!$this->isAddOrEdit())
			$this->godown->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_godown"));
		$this->godown->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_godown"));

		// rack
		if (!$this->isAddOrEdit())
			$this->rack->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rack"));
		$this->rack->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rack"));

		// invoice_details
		if (!$this->isAddOrEdit())
			$this->invoice_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_details"));
		$this->invoice_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_details"));

		// invoice_value
		if (!$this->isAddOrEdit())
			$this->invoice_value->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_value"));
		$this->invoice_value->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_value"));

		// currency_rate
		if (!$this->isAddOrEdit())
			$this->currency_rate->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_currency_rate"));
		$this->currency_rate->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_currency_rate"));

		// purchase_amount_inr
		if (!$this->isAddOrEdit())
			$this->purchase_amount_inr->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_purchase_amount_inr"));
		$this->purchase_amount_inr->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_purchase_amount_inr"));
		$this->purchase_amount_inr->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_purchase_amount_inr"));
		$this->purchase_amount_inr->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_purchase_amount_inr"));
		$this->purchase_amount_inr->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_purchase_amount_inr"));

		// duty_paid_by
		if (!$this->isAddOrEdit())
			$this->duty_paid_by->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_duty_paid_by"));
		$this->duty_paid_by->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_duty_paid_by"));

		// custom_duty
		if (!$this->isAddOrEdit())
			$this->custom_duty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_custom_duty"));
		$this->custom_duty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_custom_duty"));

		// transportation_charges
		if (!$this->isAddOrEdit())
			$this->transportation_charges->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_transportation_charges"));
		$this->transportation_charges->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_transportation_charges"));

		// port_clearing_charge
		if (!$this->isAddOrEdit())
			$this->port_clearing_charge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_port_clearing_charge"));
		$this->port_clearing_charge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_port_clearing_charge"));

		// cha_commission
		if (!$this->isAddOrEdit())
			$this->cha_commission->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cha_commission"));
		$this->cha_commission->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cha_commission"));

		// cha_agent
		if (!$this->isAddOrEdit())
			$this->cha_agent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cha_agent"));
		$this->cha_agent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cha_agent"));

		// clearance_bank
		if (!$this->isAddOrEdit())
			$this->clearance_bank->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_clearance_bank"));
		$this->clearance_bank->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_clearance_bank"));

		// bank_charges
		if (!$this->isAddOrEdit())
			$this->bank_charges->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_charges"));
		$this->bank_charges->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_charges"));

		// importer
		if (!$this->isAddOrEdit())
			$this->importer->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_importer"));
		$this->importer->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_importer"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// fiba_fibd
		if (!$this->isAddOrEdit())
			$this->fiba_fibd->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fiba_fibd"));
		$this->fiba_fibd->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fiba_fibd"));

		// fibc
		if (!$this->isAddOrEdit())
			$this->fibc->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fibc"));
		$this->fibc->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fibc"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
		$this->datetime->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_datetime"));
		$this->datetime->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_datetime"));

		// qc_remarks
		if (!$this->isAddOrEdit())
			$this->qc_remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_remarks"));
		$this->qc_remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_remarks"));

		// qc_status
		if (!$this->isAddOrEdit())
			$this->qc_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_status"));
		$this->qc_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_status"));

		// qc_operator
		if (!$this->isAddOrEdit())
			$this->qc_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_operator"));
		$this->qc_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_operator"));

		// qc_datetime
		if (!$this->isAddOrEdit())
			$this->qc_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_datetime"));
		$this->qc_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_datetime"));

		// rbi_compliance_date
		if (!$this->isAddOrEdit())
			$this->rbi_compliance_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rbi_compliance_date"));
		$this->rbi_compliance_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rbi_compliance_date"));

		// age
		if (!$this->isAddOrEdit())
			$this->age->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_age"));
		$this->age->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_age"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->gross_weight->FormValue == $this->gross_weight->CurrentValue && is_numeric(ConvertToFloatString($this->gross_weight->CurrentValue)))
			$this->gross_weight->CurrentValue = ConvertToFloatString($this->gross_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->net_weight->FormValue == $this->net_weight->CurrentValue && is_numeric(ConvertToFloatString($this->net_weight->CurrentValue)))
			$this->net_weight->CurrentValue = ConvertToFloatString($this->net_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->containers->FormValue == $this->containers->CurrentValue && is_numeric(ConvertToFloatString($this->containers->CurrentValue)))
			$this->containers->CurrentValue = ConvertToFloatString($this->containers->CurrentValue);

		// Convert decimal values if posted back
		if ($this->invoice_value->FormValue == $this->invoice_value->CurrentValue && is_numeric(ConvertToFloatString($this->invoice_value->CurrentValue)))
			$this->invoice_value->CurrentValue = ConvertToFloatString($this->invoice_value->CurrentValue);

		// Convert decimal values if posted back
		if ($this->currency_rate->FormValue == $this->currency_rate->CurrentValue && is_numeric(ConvertToFloatString($this->currency_rate->CurrentValue)))
			$this->currency_rate->CurrentValue = ConvertToFloatString($this->currency_rate->CurrentValue);

		// Convert decimal values if posted back
		if ($this->purchase_amount_inr->FormValue == $this->purchase_amount_inr->CurrentValue && is_numeric(ConvertToFloatString($this->purchase_amount_inr->CurrentValue)))
			$this->purchase_amount_inr->CurrentValue = ConvertToFloatString($this->purchase_amount_inr->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_duty->FormValue == $this->custom_duty->CurrentValue && is_numeric(ConvertToFloatString($this->custom_duty->CurrentValue)))
			$this->custom_duty->CurrentValue = ConvertToFloatString($this->custom_duty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->transportation_charges->FormValue == $this->transportation_charges->CurrentValue && is_numeric(ConvertToFloatString($this->transportation_charges->CurrentValue)))
			$this->transportation_charges->CurrentValue = ConvertToFloatString($this->transportation_charges->CurrentValue);

		// Convert decimal values if posted back
		if ($this->port_clearing_charge->FormValue == $this->port_clearing_charge->CurrentValue && is_numeric(ConvertToFloatString($this->port_clearing_charge->CurrentValue)))
			$this->port_clearing_charge->CurrentValue = ConvertToFloatString($this->port_clearing_charge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cha_commission->FormValue == $this->cha_commission->CurrentValue && is_numeric(ConvertToFloatString($this->cha_commission->CurrentValue)))
			$this->cha_commission->CurrentValue = ConvertToFloatString($this->cha_commission->CurrentValue);

		// Convert decimal values if posted back
		if ($this->bank_charges->FormValue == $this->bank_charges->CurrentValue && is_numeric(ConvertToFloatString($this->bank_charges->CurrentValue)))
			$this->bank_charges->CurrentValue = ConvertToFloatString($this->bank_charges->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// supplier
		// booking_reference
		// rid
		// lot_no
		// gross_weight
		// net_weight
		// packets
		// packing_type
		// containers
		// shipping_line
		// port_arrival_date
		// godown_arrival_date
		// godown
		// rack
		// invoice_details
		// invoice_value
		// currency_rate
		// purchase_amount_inr
		// duty_paid_by
		// custom_duty
		// transportation_charges
		// port_clearing_charge
		// cha_commission
		// cha_agent
		// clearance_bank
		// bank_charges
		// importer
		// remarks
		// fiba_fibd
		// fibc
		// operator
		// datetime
		// updated
		// grp
		// qc_remarks
		// qc_status
		// qc_operator
		// qc_datetime
		// rbi_compliance_date
		// age

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// supplier
			$curVal = strval($this->supplier->CurrentValue);
			if ($curVal <> "") {
				$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
				if ($this->supplier->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->supplier->ViewValue = $this->supplier->CurrentValue;
					}
				}
			} else {
				$this->supplier->ViewValue = NULL;
			}
			$this->supplier->ViewCustomAttributes = "";

			// booking_reference
			$curVal = strval($this->booking_reference->CurrentValue);
			if ($curVal <> "") {
				$this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
				if ($this->booking_reference->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->booking_reference->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
					}
				}
			} else {
				$this->booking_reference->ViewValue = NULL;
			}
			$this->booking_reference->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, 3, -2, -2, -2);
			$this->gross_weight->ViewCustomAttributes = "";

			// net_weight
			$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
			$this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, 3, -2, -2, -2);
			$this->net_weight->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// containers
			$this->containers->ViewValue = $this->containers->CurrentValue;
			$this->containers->ViewValue = FormatNumber($this->containers->ViewValue, 2, -2, -2, -2);
			$this->containers->ViewCustomAttributes = "";

			// shipping_line
			$curVal = strval($this->shipping_line->CurrentValue);
			if ($curVal <> "") {
				$this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
				if ($this->shipping_line->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->shipping_line->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
					}
				}
			} else {
				$this->shipping_line->ViewValue = NULL;
			}
			$this->shipping_line->ViewCustomAttributes = "";

			// port_arrival_date
			$this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
			$this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, 0);
			$this->port_arrival_date->ViewCustomAttributes = "";

			// godown_arrival_date
			$this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
			$this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, 0);
			$this->godown_arrival_date->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// rack
			$this->rack->ViewValue = $this->rack->CurrentValue;
			$this->rack->ViewCustomAttributes = "";

			// invoice_details
			$this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;
			$this->invoice_details->ViewCustomAttributes = "";

			// invoice_value
			$this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
			$this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, 2, -2, -2, -2);
			$this->invoice_value->ViewCustomAttributes = "";

			// currency_rate
			$this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
			$this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, 3, -2, -2, -2);
			$this->currency_rate->ViewCustomAttributes = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
			$this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, 2, -2, -2, -2);
			$this->purchase_amount_inr->ViewCustomAttributes = "";

			// duty_paid_by
			if (strval($this->duty_paid_by->CurrentValue) <> "") {
				$this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
			} else {
				$this->duty_paid_by->ViewValue = NULL;
			}
			$this->duty_paid_by->ViewCustomAttributes = "";

			// custom_duty
			$this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
			$this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, 2, -2, -2, -2);
			$this->custom_duty->ViewCustomAttributes = "";

			// transportation_charges
			$this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
			$this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, 2, -2, -2, -2);
			$this->transportation_charges->ViewCustomAttributes = "";

			// port_clearing_charge
			$this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
			$this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, 2, -2, -2, -2);
			$this->port_clearing_charge->ViewCustomAttributes = "";

			// cha_commission
			$this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
			$this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, 2, -2, -2, -2);
			$this->cha_commission->ViewCustomAttributes = "";

			// cha_agent
			$curVal = strval($this->cha_agent->CurrentValue);
			if ($curVal <> "") {
				$this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
				if ($this->cha_agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cha_agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
					}
				}
			} else {
				$this->cha_agent->ViewValue = NULL;
			}
			$this->cha_agent->ViewCustomAttributes = "";

			// clearance_bank
			$curVal = strval($this->clearance_bank->CurrentValue);
			if ($curVal <> "") {
				$this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
				if ($this->clearance_bank->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->clearance_bank->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
					}
				}
			} else {
				$this->clearance_bank->ViewValue = NULL;
			}
			$this->clearance_bank->ViewCustomAttributes = "";

			// bank_charges
			$this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
			$this->bank_charges->ViewCustomAttributes = "";

			// importer
			$curVal = strval($this->importer->CurrentValue);
			if ($curVal <> "") {
				$this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
				if ($this->importer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->importer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->importer->ViewValue = $this->importer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->importer->ViewValue = $this->importer->CurrentValue;
					}
				}
			} else {
				$this->importer->ViewValue = NULL;
			}
			$this->importer->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// fiba_fibd
			$this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;
			$this->fiba_fibd->ViewCustomAttributes = "";

			// fibc
			$this->fibc->ViewValue = $this->fibc->CurrentValue;
			$this->fibc->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// qc_remarks
			$this->qc_remarks->ViewValue = $this->qc_remarks->CurrentValue;
			$this->qc_remarks->ViewCustomAttributes = "";

			// qc_status
			$this->qc_status->ViewValue = $this->qc_status->CurrentValue;
			$this->qc_status->ViewValue = FormatNumber($this->qc_status->ViewValue, 0, -2, -2, -2);
			$this->qc_status->ViewCustomAttributes = "";

			// qc_operator
			$this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
			$this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, 0, -2, -2, -2);
			$this->qc_operator->ViewCustomAttributes = "";

			// qc_datetime
			$this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
			$this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, 0);
			$this->qc_datetime->ViewCustomAttributes = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->ViewValue = $this->rbi_compliance_date->CurrentValue;
			$this->rbi_compliance_date->ViewValue = FormatDateTime($this->rbi_compliance_date->ViewValue, 0);
			$this->rbi_compliance_date->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
			$this->age->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// supplier
			$this->supplier->LinkCustomAttributes = "";
			if (!EmptyValue($this->supplier->CurrentValue)) {
				$this->supplier->HrefValue = "purchase_a_flist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
				$this->supplier->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
			} else {
				$this->supplier->HrefValue = "";
			}
			$this->supplier->TooltipValue = "";

			// booking_reference
			$this->booking_reference->LinkCustomAttributes = "";
			$this->booking_reference->HrefValue = "";
			$this->booking_reference->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";
			$this->gross_weight->TooltipValue = "";

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";
			$this->net_weight->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "purchase_a_flist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// containers
			$this->containers->LinkCustomAttributes = "";
			$this->containers->HrefValue = "";
			$this->containers->TooltipValue = "";

			// shipping_line
			$this->shipping_line->LinkCustomAttributes = "";
			$this->shipping_line->HrefValue = "";
			$this->shipping_line->TooltipValue = "";

			// port_arrival_date
			$this->port_arrival_date->LinkCustomAttributes = "";
			$this->port_arrival_date->HrefValue = "";
			$this->port_arrival_date->TooltipValue = "";

			// godown_arrival_date
			$this->godown_arrival_date->LinkCustomAttributes = "";
			$this->godown_arrival_date->HrefValue = "";
			$this->godown_arrival_date->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "purchase_a_flist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// rack
			$this->rack->LinkCustomAttributes = "";
			$this->rack->HrefValue = "";
			$this->rack->TooltipValue = "";

			// invoice_details
			$this->invoice_details->LinkCustomAttributes = "";
			$this->invoice_details->HrefValue = "";
			$this->invoice_details->TooltipValue = "";

			// invoice_value
			$this->invoice_value->LinkCustomAttributes = "";
			$this->invoice_value->HrefValue = "";
			$this->invoice_value->TooltipValue = "";

			// currency_rate
			$this->currency_rate->LinkCustomAttributes = "";
			$this->currency_rate->HrefValue = "";
			$this->currency_rate->TooltipValue = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->LinkCustomAttributes = "";
			$this->purchase_amount_inr->HrefValue = "";
			$this->purchase_amount_inr->TooltipValue = "";

			// duty_paid_by
			$this->duty_paid_by->LinkCustomAttributes = "";
			$this->duty_paid_by->HrefValue = "";
			$this->duty_paid_by->TooltipValue = "";

			// custom_duty
			$this->custom_duty->LinkCustomAttributes = "";
			$this->custom_duty->HrefValue = "";
			$this->custom_duty->TooltipValue = "";

			// transportation_charges
			$this->transportation_charges->LinkCustomAttributes = "";
			$this->transportation_charges->HrefValue = "";
			$this->transportation_charges->TooltipValue = "";

			// port_clearing_charge
			$this->port_clearing_charge->LinkCustomAttributes = "";
			$this->port_clearing_charge->HrefValue = "";
			$this->port_clearing_charge->TooltipValue = "";

			// cha_commission
			$this->cha_commission->LinkCustomAttributes = "";
			$this->cha_commission->HrefValue = "";
			$this->cha_commission->TooltipValue = "";

			// cha_agent
			$this->cha_agent->LinkCustomAttributes = "";
			$this->cha_agent->HrefValue = "";
			$this->cha_agent->TooltipValue = "";

			// clearance_bank
			$this->clearance_bank->LinkCustomAttributes = "";
			$this->clearance_bank->HrefValue = "";
			$this->clearance_bank->TooltipValue = "";

			// bank_charges
			$this->bank_charges->LinkCustomAttributes = "";
			$this->bank_charges->HrefValue = "";
			$this->bank_charges->TooltipValue = "";

			// importer
			$this->importer->LinkCustomAttributes = "";
			$this->importer->HrefValue = "";
			$this->importer->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// fiba_fibd
			$this->fiba_fibd->LinkCustomAttributes = "";
			$this->fiba_fibd->HrefValue = "";
			$this->fiba_fibd->TooltipValue = "";

			// fibc
			$this->fibc->LinkCustomAttributes = "";
			$this->fibc->HrefValue = "";
			$this->fibc->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// qc_remarks
			$this->qc_remarks->LinkCustomAttributes = "";
			$this->qc_remarks->HrefValue = "";
			$this->qc_remarks->TooltipValue = "";

			// qc_status
			$this->qc_status->LinkCustomAttributes = "";
			$this->qc_status->HrefValue = "";
			$this->qc_status->TooltipValue = "";

			// qc_operator
			$this->qc_operator->LinkCustomAttributes = "";
			$this->qc_operator->HrefValue = "";
			$this->qc_operator->TooltipValue = "";

			// qc_datetime
			$this->qc_datetime->LinkCustomAttributes = "";
			$this->qc_datetime->HrefValue = "";
			$this->qc_datetime->TooltipValue = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->LinkCustomAttributes = "";
			$this->rbi_compliance_date->HrefValue = "";
			$this->rbi_compliance_date->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// supplier
			$this->supplier->EditAttrs["class"] = "form-control";
			$this->supplier->EditCustomAttributes = "";
			$curVal = trim(strval($this->supplier->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->supplier->AdvancedSearch->ViewValue = $this->supplier->lookupCacheOption($curVal);
			else
				$this->supplier->AdvancedSearch->ViewValue = $this->supplier->Lookup !== NULL && is_array($this->supplier->Lookup->Options) ? $curVal : NULL;
			if ($this->supplier->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->supplier->EditValue = array_values($this->supplier->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->supplier->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `category` = 200";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->supplier->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->supplier->EditValue = $arwrk;
			}

			// booking_reference
			$this->booking_reference->EditAttrs["class"] = "form-control";
			$this->booking_reference->EditCustomAttributes = "";
			$curVal = trim(strval($this->booking_reference->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->booking_reference->AdvancedSearch->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
			else
				$this->booking_reference->AdvancedSearch->ViewValue = $this->booking_reference->Lookup !== NULL && is_array($this->booking_reference->Lookup->Options) ? $curVal : NULL;
			if ($this->booking_reference->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->booking_reference->EditValue = array_values($this->booking_reference->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->booking_reference->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->booking_reference->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->booking_reference->EditValue = $arwrk;
			}

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// gross_weight
			$this->gross_weight->EditAttrs["class"] = "form-control";
			$this->gross_weight->EditCustomAttributes = "";
			$this->gross_weight->EditValue = HtmlEncode($this->gross_weight->AdvancedSearch->SearchValue);
			$this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

			// net_weight
			$this->net_weight->EditAttrs["class"] = "form-control";
			$this->net_weight->EditCustomAttributes = "";
			$this->net_weight->EditValue = HtmlEncode($this->net_weight->AdvancedSearch->SearchValue);
			$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
			$this->net_weight->EditAttrs["class"] = "form-control";
			$this->net_weight->EditCustomAttributes = "";
			$this->net_weight->EditValue2 = HtmlEncode($this->net_weight->AdvancedSearch->SearchValue2);
			$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->AdvancedSearch->SearchValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue2 = HtmlEncode($this->packets->AdvancedSearch->SearchValue2);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` = 1 and grp = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// containers
			$this->containers->EditAttrs["class"] = "form-control";
			$this->containers->EditCustomAttributes = "";
			$this->containers->EditValue = HtmlEncode($this->containers->AdvancedSearch->SearchValue);
			$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
			$this->containers->EditAttrs["class"] = "form-control";
			$this->containers->EditCustomAttributes = "";
			$this->containers->EditValue2 = HtmlEncode($this->containers->AdvancedSearch->SearchValue2);
			$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());

			// shipping_line
			$this->shipping_line->EditAttrs["class"] = "form-control";
			$this->shipping_line->EditCustomAttributes = "";
			$curVal = trim(strval($this->shipping_line->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->shipping_line->AdvancedSearch->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
			else
				$this->shipping_line->AdvancedSearch->ViewValue = $this->shipping_line->Lookup !== NULL && is_array($this->shipping_line->Lookup->Options) ? $curVal : NULL;
			if ($this->shipping_line->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->shipping_line->EditValue = array_values($this->shipping_line->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->shipping_line->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->shipping_line->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shipping_line->EditValue = $arwrk;
			}

			// port_arrival_date
			$this->port_arrival_date->EditAttrs["class"] = "form-control";
			$this->port_arrival_date->EditCustomAttributes = "";
			$this->port_arrival_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->port_arrival_date->AdvancedSearch->SearchValue, 0), 8));
			$this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());
			$this->port_arrival_date->EditAttrs["class"] = "form-control";
			$this->port_arrival_date->EditCustomAttributes = "";
			$this->port_arrival_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->port_arrival_date->AdvancedSearch->SearchValue2, 0), 8));
			$this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());

			// godown_arrival_date
			$this->godown_arrival_date->EditAttrs["class"] = "form-control";
			$this->godown_arrival_date->EditCustomAttributes = "";
			$this->godown_arrival_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->godown_arrival_date->AdvancedSearch->SearchValue, 0), 8));
			$this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());
			$this->godown_arrival_date->EditAttrs["class"] = "form-control";
			$this->godown_arrival_date->EditCustomAttributes = "";
			$this->godown_arrival_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->godown_arrival_date->AdvancedSearch->SearchValue2, 0), 8));
			$this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->godown->AdvancedSearch->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->AdvancedSearch->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// rack
			$this->rack->EditAttrs["class"] = "form-control";
			$this->rack->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rack->AdvancedSearch->SearchValue = HtmlDecode($this->rack->AdvancedSearch->SearchValue);
			$this->rack->EditValue = HtmlEncode($this->rack->AdvancedSearch->SearchValue);
			$this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

			// invoice_details
			$this->invoice_details->EditAttrs["class"] = "form-control";
			$this->invoice_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice_details->AdvancedSearch->SearchValue = HtmlDecode($this->invoice_details->AdvancedSearch->SearchValue);
			$this->invoice_details->EditValue = HtmlEncode($this->invoice_details->AdvancedSearch->SearchValue);
			$this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

			// invoice_value
			$this->invoice_value->EditAttrs["class"] = "form-control";
			$this->invoice_value->EditCustomAttributes = "";
			$this->invoice_value->EditValue = HtmlEncode($this->invoice_value->AdvancedSearch->SearchValue);
			$this->invoice_value->PlaceHolder = RemoveHtml($this->invoice_value->caption());

			// currency_rate
			$this->currency_rate->EditAttrs["class"] = "form-control";
			$this->currency_rate->EditCustomAttributes = "";
			$this->currency_rate->EditValue = HtmlEncode($this->currency_rate->AdvancedSearch->SearchValue);
			$this->currency_rate->PlaceHolder = RemoveHtml($this->currency_rate->caption());

			// purchase_amount_inr
			$this->purchase_amount_inr->EditAttrs["class"] = "form-control";
			$this->purchase_amount_inr->EditCustomAttributes = "";
			$this->purchase_amount_inr->EditValue = HtmlEncode($this->purchase_amount_inr->AdvancedSearch->SearchValue);
			$this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());
			$this->purchase_amount_inr->EditAttrs["class"] = "form-control";
			$this->purchase_amount_inr->EditCustomAttributes = "";
			$this->purchase_amount_inr->EditValue2 = HtmlEncode($this->purchase_amount_inr->AdvancedSearch->SearchValue2);
			$this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());

			// duty_paid_by
			$this->duty_paid_by->EditAttrs["class"] = "form-control";
			$this->duty_paid_by->EditCustomAttributes = "";
			$this->duty_paid_by->EditValue = $this->duty_paid_by->options(TRUE);

			// custom_duty
			$this->custom_duty->EditAttrs["class"] = "form-control";
			$this->custom_duty->EditCustomAttributes = "";
			$this->custom_duty->EditValue = HtmlEncode($this->custom_duty->AdvancedSearch->SearchValue);
			$this->custom_duty->PlaceHolder = RemoveHtml($this->custom_duty->caption());

			// transportation_charges
			$this->transportation_charges->EditAttrs["class"] = "form-control";
			$this->transportation_charges->EditCustomAttributes = "";
			$this->transportation_charges->EditValue = HtmlEncode($this->transportation_charges->AdvancedSearch->SearchValue);
			$this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());

			// port_clearing_charge
			$this->port_clearing_charge->EditAttrs["class"] = "form-control";
			$this->port_clearing_charge->EditCustomAttributes = "";
			$this->port_clearing_charge->EditValue = HtmlEncode($this->port_clearing_charge->AdvancedSearch->SearchValue);
			$this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());

			// cha_commission
			$this->cha_commission->EditAttrs["class"] = "form-control";
			$this->cha_commission->EditCustomAttributes = "";
			$this->cha_commission->EditValue = HtmlEncode($this->cha_commission->AdvancedSearch->SearchValue);
			$this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());

			// cha_agent
			$this->cha_agent->EditAttrs["class"] = "form-control";
			$this->cha_agent->EditCustomAttributes = "";
			$curVal = trim(strval($this->cha_agent->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->cha_agent->AdvancedSearch->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
			else
				$this->cha_agent->AdvancedSearch->ViewValue = $this->cha_agent->Lookup !== NULL && is_array($this->cha_agent->Lookup->Options) ? $curVal : NULL;
			if ($this->cha_agent->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->cha_agent->EditValue = array_values($this->cha_agent->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->cha_agent->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cha_agent->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->cha_agent->EditValue = $arwrk;
			}

			// clearance_bank
			$this->clearance_bank->EditAttrs["class"] = "form-control";
			$this->clearance_bank->EditCustomAttributes = "";
			$curVal = trim(strval($this->clearance_bank->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->clearance_bank->AdvancedSearch->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
			else
				$this->clearance_bank->AdvancedSearch->ViewValue = $this->clearance_bank->Lookup !== NULL && is_array($this->clearance_bank->Lookup->Options) ? $curVal : NULL;
			if ($this->clearance_bank->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->clearance_bank->EditValue = array_values($this->clearance_bank->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->clearance_bank->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->clearance_bank->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->clearance_bank->EditValue = $arwrk;
			}

			// bank_charges
			$this->bank_charges->EditAttrs["class"] = "form-control";
			$this->bank_charges->EditCustomAttributes = "";
			$this->bank_charges->EditValue = HtmlEncode($this->bank_charges->AdvancedSearch->SearchValue);
			$this->bank_charges->PlaceHolder = RemoveHtml($this->bank_charges->caption());

			// importer
			$this->importer->EditAttrs["class"] = "form-control";
			$this->importer->EditCustomAttributes = "";
			$curVal = trim(strval($this->importer->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->importer->AdvancedSearch->ViewValue = $this->importer->lookupCacheOption($curVal);
			else
				$this->importer->AdvancedSearch->ViewValue = $this->importer->Lookup !== NULL && is_array($this->importer->Lookup->Options) ? $curVal : NULL;
			if ($this->importer->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->importer->EditValue = array_values($this->importer->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->importer->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` IN (0,1)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->importer->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->importer->EditValue = $arwrk;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// fiba_fibd
			$this->fiba_fibd->EditAttrs["class"] = "form-control";
			$this->fiba_fibd->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->fiba_fibd->AdvancedSearch->SearchValue = HtmlDecode($this->fiba_fibd->AdvancedSearch->SearchValue);
			$this->fiba_fibd->EditValue = HtmlEncode($this->fiba_fibd->AdvancedSearch->SearchValue);
			$this->fiba_fibd->PlaceHolder = RemoveHtml($this->fiba_fibd->caption());

			// fibc
			$this->fibc->EditAttrs["class"] = "form-control";
			$this->fibc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->fibc->AdvancedSearch->SearchValue = HtmlDecode($this->fibc->AdvancedSearch->SearchValue);
			$this->fibc->EditValue = HtmlEncode($this->fibc->AdvancedSearch->SearchValue);
			$this->fibc->PlaceHolder = RemoveHtml($this->fibc->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// qc_remarks
			$this->qc_remarks->EditAttrs["class"] = "form-control";
			$this->qc_remarks->EditCustomAttributes = "";
			$this->qc_remarks->EditValue = HtmlEncode($this->qc_remarks->AdvancedSearch->SearchValue);
			$this->qc_remarks->PlaceHolder = RemoveHtml($this->qc_remarks->caption());

			// qc_status
			$this->qc_status->EditAttrs["class"] = "form-control";
			$this->qc_status->EditCustomAttributes = "";
			$this->qc_status->EditValue = HtmlEncode($this->qc_status->AdvancedSearch->SearchValue);
			$this->qc_status->PlaceHolder = RemoveHtml($this->qc_status->caption());

			// qc_operator
			$this->qc_operator->EditAttrs["class"] = "form-control";
			$this->qc_operator->EditCustomAttributes = "";
			$this->qc_operator->EditValue = HtmlEncode($this->qc_operator->AdvancedSearch->SearchValue);
			$this->qc_operator->PlaceHolder = RemoveHtml($this->qc_operator->caption());

			// qc_datetime
			$this->qc_datetime->EditAttrs["class"] = "form-control";
			$this->qc_datetime->EditCustomAttributes = "";
			$this->qc_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->qc_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->qc_datetime->PlaceHolder = RemoveHtml($this->qc_datetime->caption());

			// rbi_compliance_date
			$this->rbi_compliance_date->EditAttrs["class"] = "form-control";
			$this->rbi_compliance_date->EditCustomAttributes = "";
			$this->rbi_compliance_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->rbi_compliance_date->AdvancedSearch->SearchValue, 0), 8));
			$this->rbi_compliance_date->PlaceHolder = RemoveHtml($this->rbi_compliance_date->caption());

			// age
			$this->age->EditAttrs["class"] = "form-control";
			$this->age->EditCustomAttributes = "";
			$this->age->EditValue = HtmlEncode($this->age->AdvancedSearch->SearchValue);
			$this->age->PlaceHolder = RemoveHtml($this->age->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckNumber($this->gross_weight->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->gross_weight->errorMessage());
		}
		if (!CheckNumber($this->net_weight->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->net_weight->errorMessage());
		}
		if (!CheckNumber($this->net_weight->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->net_weight->errorMessage());
		}
		if (!CheckInteger($this->packets->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->packets->errorMessage());
		}
		if (!CheckInteger($this->packets->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->packets->errorMessage());
		}
		if (!CheckNumber($this->containers->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->containers->errorMessage());
		}
		if (!CheckNumber($this->containers->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->containers->errorMessage());
		}
		if (!CheckDate($this->port_arrival_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->port_arrival_date->errorMessage());
		}
		if (!CheckDate($this->port_arrival_date->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->port_arrival_date->errorMessage());
		}
		if (!CheckDate($this->godown_arrival_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->godown_arrival_date->errorMessage());
		}
		if (!CheckDate($this->godown_arrival_date->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->godown_arrival_date->errorMessage());
		}
		if (!CheckNumber($this->invoice_value->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->invoice_value->errorMessage());
		}
		if (!CheckNumber($this->currency_rate->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->currency_rate->errorMessage());
		}
		if (!CheckNumber($this->purchase_amount_inr->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->purchase_amount_inr->errorMessage());
		}
		if (!CheckNumber($this->purchase_amount_inr->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->purchase_amount_inr->errorMessage());
		}
		if (!CheckNumber($this->custom_duty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->custom_duty->errorMessage());
		}
		if (!CheckNumber($this->transportation_charges->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->transportation_charges->errorMessage());
		}
		if (!CheckNumber($this->port_clearing_charge->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->port_clearing_charge->errorMessage());
		}
		if (!CheckNumber($this->cha_commission->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cha_commission->errorMessage());
		}
		if (!CheckInteger($this->qc_status->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qc_status->errorMessage());
		}
		if (!CheckInteger($this->qc_operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qc_operator->errorMessage());
		}
		if (!CheckDate($this->qc_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qc_datetime->errorMessage());
		}
		if (!CheckDate($this->rbi_compliance_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->rbi_compliance_date->errorMessage());
		}
		if (!CheckInteger($this->age->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->age->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->supplier->AdvancedSearch->load();
		$this->booking_reference->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->gross_weight->AdvancedSearch->load();
		$this->net_weight->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->containers->AdvancedSearch->load();
		$this->shipping_line->AdvancedSearch->load();
		$this->port_arrival_date->AdvancedSearch->load();
		$this->godown_arrival_date->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->rack->AdvancedSearch->load();
		$this->invoice_details->AdvancedSearch->load();
		$this->invoice_value->AdvancedSearch->load();
		$this->currency_rate->AdvancedSearch->load();
		$this->purchase_amount_inr->AdvancedSearch->load();
		$this->duty_paid_by->AdvancedSearch->load();
		$this->custom_duty->AdvancedSearch->load();
		$this->transportation_charges->AdvancedSearch->load();
		$this->port_clearing_charge->AdvancedSearch->load();
		$this->cha_commission->AdvancedSearch->load();
		$this->cha_agent->AdvancedSearch->load();
		$this->clearance_bank->AdvancedSearch->load();
		$this->bank_charges->AdvancedSearch->load();
		$this->importer->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->fiba_fibd->AdvancedSearch->load();
		$this->fibc->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->qc_remarks->AdvancedSearch->load();
		$this->qc_status->AdvancedSearch->load();
		$this->qc_operator->AdvancedSearch->load();
		$this->qc_datetime->AdvancedSearch->load();
		$this->rbi_compliance_date->AdvancedSearch->load();
		$this->age->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchase_alist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_supplier":
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_booking_reference":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cha_agent":
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_importer":
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_supplier":
							break;
						case "x_booking_reference":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_shipping_line":
							break;
						case "x_godown":
							break;
						case "x_cha_agent":
							break;
						case "x_clearance_bank":
							break;
						case "x_importer":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>