<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class purchase_a_view extends purchase_a
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'purchase_a';

	// Page object name
	public $PageObjName = "purchase_a_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (purchase_a)
		if (!isset($GLOBALS["purchase_a"]) || get_class($GLOBALS["purchase_a"]) == PROJECT_NAMESPACE . "purchase_a") {
			$GLOBALS["purchase_a"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["purchase_a"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_a');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $purchase_a;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($purchase_a);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "purchase_aview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("purchase_alist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->supplier->setVisibility();
		$this->booking_reference->setVisibility();
		$this->rid->Visible = FALSE;
		$this->lot_no->setVisibility();
		$this->gross_weight->setVisibility();
		$this->net_weight->setVisibility();
		$this->packets->setVisibility();
		$this->packing_type->setVisibility();
		$this->containers->setVisibility();
		$this->shipping_line->setVisibility();
		$this->port_arrival_date->setVisibility();
		$this->godown_arrival_date->setVisibility();
		$this->godown->setVisibility();
		$this->rack->setVisibility();
		$this->invoice_details->setVisibility();
		$this->invoice_value->setVisibility();
		$this->currency_rate->setVisibility();
		$this->purchase_amount_inr->setVisibility();
		$this->duty_paid_by->setVisibility();
		$this->custom_duty->setVisibility();
		$this->transportation_charges->setVisibility();
		$this->port_clearing_charge->setVisibility();
		$this->cha_commission->setVisibility();
		$this->cha_agent->setVisibility();
		$this->clearance_bank->setVisibility();
		$this->bank_charges->setVisibility();
		$this->importer->setVisibility();
		$this->remarks->setVisibility();
		$this->fiba_fibd->setVisibility();
		$this->fibc->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->setVisibility();
		$this->grp->Visible = FALSE;
		$this->qc_remarks->setVisibility();
		$this->qc_status->setVisibility();
		$this->qc_operator->setVisibility();
		$this->qc_datetime->setVisibility();
		$this->rbi_compliance_date->setVisibility();
		$this->age->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->supplier);
		$this->setupLookupOptions($this->booking_reference);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->shipping_line);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->cha_agent);
		$this->setupLookupOptions($this->clearance_bank);
		$this->setupLookupOptions($this->importer);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "purchase_alist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "purchase_alist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "purchase_alist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		if ($this->AuditTrailOnView)
			$this->writeAuditTrailOnView($row);
		$this->id->setDbValue($row['id']);
		$this->supplier->setDbValue($row['supplier']);
		$this->booking_reference->setDbValue($row['booking_reference']);
		$this->rid->setDbValue($row['rid']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->gross_weight->setDbValue($row['gross_weight']);
		$this->net_weight->setDbValue($row['net_weight']);
		$this->packets->setDbValue($row['packets']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->containers->setDbValue($row['containers']);
		$this->shipping_line->setDbValue($row['shipping_line']);
		$this->port_arrival_date->setDbValue($row['port_arrival_date']);
		$this->godown_arrival_date->setDbValue($row['godown_arrival_date']);
		$this->godown->setDbValue($row['godown']);
		$this->rack->setDbValue($row['rack']);
		$this->invoice_details->setDbValue($row['invoice_details']);
		$this->invoice_value->setDbValue($row['invoice_value']);
		$this->currency_rate->setDbValue($row['currency_rate']);
		$this->purchase_amount_inr->setDbValue($row['purchase_amount_inr']);
		$this->duty_paid_by->setDbValue($row['duty_paid_by']);
		$this->custom_duty->setDbValue($row['custom_duty']);
		$this->transportation_charges->setDbValue($row['transportation_charges']);
		$this->port_clearing_charge->setDbValue($row['port_clearing_charge']);
		$this->cha_commission->setDbValue($row['cha_commission']);
		$this->cha_agent->setDbValue($row['cha_agent']);
		$this->clearance_bank->setDbValue($row['clearance_bank']);
		$this->bank_charges->setDbValue($row['bank_charges']);
		$this->importer->setDbValue($row['importer']);
		$this->remarks->setDbValue($row['remarks']);
		$this->fiba_fibd->setDbValue($row['fiba_fibd']);
		$this->fibc->setDbValue($row['fibc']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->updated->setDbValue($row['updated']);
		$this->grp->setDbValue($row['grp']);
		$this->qc_remarks->setDbValue($row['qc_remarks']);
		$this->qc_status->setDbValue($row['qc_status']);
		$this->qc_operator->setDbValue($row['qc_operator']);
		$this->qc_datetime->setDbValue($row['qc_datetime']);
		$this->rbi_compliance_date->setDbValue($row['rbi_compliance_date']);
		$this->age->setDbValue($row['age']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['supplier'] = NULL;
		$row['booking_reference'] = NULL;
		$row['rid'] = NULL;
		$row['lot_no'] = NULL;
		$row['gross_weight'] = NULL;
		$row['net_weight'] = NULL;
		$row['packets'] = NULL;
		$row['packing_type'] = NULL;
		$row['containers'] = NULL;
		$row['shipping_line'] = NULL;
		$row['port_arrival_date'] = NULL;
		$row['godown_arrival_date'] = NULL;
		$row['godown'] = NULL;
		$row['rack'] = NULL;
		$row['invoice_details'] = NULL;
		$row['invoice_value'] = NULL;
		$row['currency_rate'] = NULL;
		$row['purchase_amount_inr'] = NULL;
		$row['duty_paid_by'] = NULL;
		$row['custom_duty'] = NULL;
		$row['transportation_charges'] = NULL;
		$row['port_clearing_charge'] = NULL;
		$row['cha_commission'] = NULL;
		$row['cha_agent'] = NULL;
		$row['clearance_bank'] = NULL;
		$row['bank_charges'] = NULL;
		$row['importer'] = NULL;
		$row['remarks'] = NULL;
		$row['fiba_fibd'] = NULL;
		$row['fibc'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['updated'] = NULL;
		$row['grp'] = NULL;
		$row['qc_remarks'] = NULL;
		$row['qc_status'] = NULL;
		$row['qc_operator'] = NULL;
		$row['qc_datetime'] = NULL;
		$row['rbi_compliance_date'] = NULL;
		$row['age'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->gross_weight->FormValue == $this->gross_weight->CurrentValue && is_numeric(ConvertToFloatString($this->gross_weight->CurrentValue)))
			$this->gross_weight->CurrentValue = ConvertToFloatString($this->gross_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->net_weight->FormValue == $this->net_weight->CurrentValue && is_numeric(ConvertToFloatString($this->net_weight->CurrentValue)))
			$this->net_weight->CurrentValue = ConvertToFloatString($this->net_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->containers->FormValue == $this->containers->CurrentValue && is_numeric(ConvertToFloatString($this->containers->CurrentValue)))
			$this->containers->CurrentValue = ConvertToFloatString($this->containers->CurrentValue);

		// Convert decimal values if posted back
		if ($this->invoice_value->FormValue == $this->invoice_value->CurrentValue && is_numeric(ConvertToFloatString($this->invoice_value->CurrentValue)))
			$this->invoice_value->CurrentValue = ConvertToFloatString($this->invoice_value->CurrentValue);

		// Convert decimal values if posted back
		if ($this->currency_rate->FormValue == $this->currency_rate->CurrentValue && is_numeric(ConvertToFloatString($this->currency_rate->CurrentValue)))
			$this->currency_rate->CurrentValue = ConvertToFloatString($this->currency_rate->CurrentValue);

		// Convert decimal values if posted back
		if ($this->purchase_amount_inr->FormValue == $this->purchase_amount_inr->CurrentValue && is_numeric(ConvertToFloatString($this->purchase_amount_inr->CurrentValue)))
			$this->purchase_amount_inr->CurrentValue = ConvertToFloatString($this->purchase_amount_inr->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_duty->FormValue == $this->custom_duty->CurrentValue && is_numeric(ConvertToFloatString($this->custom_duty->CurrentValue)))
			$this->custom_duty->CurrentValue = ConvertToFloatString($this->custom_duty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->transportation_charges->FormValue == $this->transportation_charges->CurrentValue && is_numeric(ConvertToFloatString($this->transportation_charges->CurrentValue)))
			$this->transportation_charges->CurrentValue = ConvertToFloatString($this->transportation_charges->CurrentValue);

		// Convert decimal values if posted back
		if ($this->port_clearing_charge->FormValue == $this->port_clearing_charge->CurrentValue && is_numeric(ConvertToFloatString($this->port_clearing_charge->CurrentValue)))
			$this->port_clearing_charge->CurrentValue = ConvertToFloatString($this->port_clearing_charge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cha_commission->FormValue == $this->cha_commission->CurrentValue && is_numeric(ConvertToFloatString($this->cha_commission->CurrentValue)))
			$this->cha_commission->CurrentValue = ConvertToFloatString($this->cha_commission->CurrentValue);

		// Convert decimal values if posted back
		if ($this->bank_charges->FormValue == $this->bank_charges->CurrentValue && is_numeric(ConvertToFloatString($this->bank_charges->CurrentValue)))
			$this->bank_charges->CurrentValue = ConvertToFloatString($this->bank_charges->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// supplier
		// booking_reference
		// rid
		// lot_no
		// gross_weight
		// net_weight
		// packets
		// packing_type
		// containers
		// shipping_line
		// port_arrival_date
		// godown_arrival_date
		// godown
		// rack
		// invoice_details
		// invoice_value
		// currency_rate
		// purchase_amount_inr
		// duty_paid_by
		// custom_duty
		// transportation_charges
		// port_clearing_charge
		// cha_commission
		// cha_agent
		// clearance_bank
		// bank_charges
		// importer
		// remarks
		// fiba_fibd
		// fibc
		// operator
		// datetime
		// updated
		// grp
		// qc_remarks
		// qc_status
		// qc_operator
		// qc_datetime
		// rbi_compliance_date
		// age

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// supplier
			$curVal = strval($this->supplier->CurrentValue);
			if ($curVal <> "") {
				$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
				if ($this->supplier->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->supplier->ViewValue = $this->supplier->CurrentValue;
					}
				}
			} else {
				$this->supplier->ViewValue = NULL;
			}
			$this->supplier->ViewCustomAttributes = "";

			// booking_reference
			$curVal = strval($this->booking_reference->CurrentValue);
			if ($curVal <> "") {
				$this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
				if ($this->booking_reference->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->booking_reference->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
					}
				}
			} else {
				$this->booking_reference->ViewValue = NULL;
			}
			$this->booking_reference->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, 3, -2, -2, -2);
			$this->gross_weight->ViewCustomAttributes = "";

			// net_weight
			$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
			$this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, 3, -2, -2, -2);
			$this->net_weight->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// containers
			$this->containers->ViewValue = $this->containers->CurrentValue;
			$this->containers->ViewValue = FormatNumber($this->containers->ViewValue, 2, -2, -2, -2);
			$this->containers->ViewCustomAttributes = "";

			// shipping_line
			$curVal = strval($this->shipping_line->CurrentValue);
			if ($curVal <> "") {
				$this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
				if ($this->shipping_line->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->shipping_line->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
					}
				}
			} else {
				$this->shipping_line->ViewValue = NULL;
			}
			$this->shipping_line->ViewCustomAttributes = "";

			// port_arrival_date
			$this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
			$this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, 0);
			$this->port_arrival_date->ViewCustomAttributes = "";

			// godown_arrival_date
			$this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
			$this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, 0);
			$this->godown_arrival_date->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// rack
			$this->rack->ViewValue = $this->rack->CurrentValue;
			$this->rack->ViewCustomAttributes = "";

			// invoice_details
			$this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;
			$this->invoice_details->ViewCustomAttributes = "";

			// invoice_value
			$this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
			$this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, 2, -2, -2, -2);
			$this->invoice_value->ViewCustomAttributes = "";

			// currency_rate
			$this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
			$this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, 3, -2, -2, -2);
			$this->currency_rate->ViewCustomAttributes = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
			$this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, 2, -2, -2, -2);
			$this->purchase_amount_inr->ViewCustomAttributes = "";

			// duty_paid_by
			if (strval($this->duty_paid_by->CurrentValue) <> "") {
				$this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
			} else {
				$this->duty_paid_by->ViewValue = NULL;
			}
			$this->duty_paid_by->ViewCustomAttributes = "";

			// custom_duty
			$this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
			$this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, 2, -2, -2, -2);
			$this->custom_duty->ViewCustomAttributes = "";

			// transportation_charges
			$this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
			$this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, 2, -2, -2, -2);
			$this->transportation_charges->ViewCustomAttributes = "";

			// port_clearing_charge
			$this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
			$this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, 2, -2, -2, -2);
			$this->port_clearing_charge->ViewCustomAttributes = "";

			// cha_commission
			$this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
			$this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, 2, -2, -2, -2);
			$this->cha_commission->ViewCustomAttributes = "";

			// cha_agent
			$curVal = strval($this->cha_agent->CurrentValue);
			if ($curVal <> "") {
				$this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
				if ($this->cha_agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cha_agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
					}
				}
			} else {
				$this->cha_agent->ViewValue = NULL;
			}
			$this->cha_agent->ViewCustomAttributes = "";

			// clearance_bank
			$curVal = strval($this->clearance_bank->CurrentValue);
			if ($curVal <> "") {
				$this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
				if ($this->clearance_bank->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->clearance_bank->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
					}
				}
			} else {
				$this->clearance_bank->ViewValue = NULL;
			}
			$this->clearance_bank->ViewCustomAttributes = "";

			// bank_charges
			$this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
			$this->bank_charges->ViewCustomAttributes = "";

			// importer
			$curVal = strval($this->importer->CurrentValue);
			if ($curVal <> "") {
				$this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
				if ($this->importer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->importer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->importer->ViewValue = $this->importer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->importer->ViewValue = $this->importer->CurrentValue;
					}
				}
			} else {
				$this->importer->ViewValue = NULL;
			}
			$this->importer->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// fiba_fibd
			$this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;
			$this->fiba_fibd->ViewCustomAttributes = "";

			// fibc
			$this->fibc->ViewValue = $this->fibc->CurrentValue;
			$this->fibc->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// updated
			$this->updated->ViewValue = $this->updated->CurrentValue;
			$this->updated->ViewCustomAttributes = "";

			// qc_remarks
			$this->qc_remarks->ViewValue = $this->qc_remarks->CurrentValue;
			$this->qc_remarks->ViewCustomAttributes = "";

			// qc_status
			$this->qc_status->ViewValue = $this->qc_status->CurrentValue;
			$this->qc_status->ViewValue = FormatNumber($this->qc_status->ViewValue, 0, -2, -2, -2);
			$this->qc_status->ViewCustomAttributes = "";

			// qc_operator
			$this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
			$this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, 0, -2, -2, -2);
			$this->qc_operator->ViewCustomAttributes = "";

			// qc_datetime
			$this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
			$this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, 0);
			$this->qc_datetime->ViewCustomAttributes = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->ViewValue = $this->rbi_compliance_date->CurrentValue;
			$this->rbi_compliance_date->ViewValue = FormatDateTime($this->rbi_compliance_date->ViewValue, 0);
			$this->rbi_compliance_date->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
			$this->age->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// supplier
			$this->supplier->LinkCustomAttributes = "";
			if (!EmptyValue($this->supplier->CurrentValue)) {
				$this->supplier->HrefValue = "purchase_a_flist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
				$this->supplier->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
			} else {
				$this->supplier->HrefValue = "";
			}
			$this->supplier->TooltipValue = "";

			// booking_reference
			$this->booking_reference->LinkCustomAttributes = "";
			$this->booking_reference->HrefValue = "";
			$this->booking_reference->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";
			$this->gross_weight->TooltipValue = "";

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";
			$this->net_weight->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "purchase_a_flist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// containers
			$this->containers->LinkCustomAttributes = "";
			$this->containers->HrefValue = "";
			$this->containers->TooltipValue = "";

			// shipping_line
			$this->shipping_line->LinkCustomAttributes = "";
			$this->shipping_line->HrefValue = "";
			$this->shipping_line->TooltipValue = "";

			// port_arrival_date
			$this->port_arrival_date->LinkCustomAttributes = "";
			$this->port_arrival_date->HrefValue = "";
			$this->port_arrival_date->TooltipValue = "";

			// godown_arrival_date
			$this->godown_arrival_date->LinkCustomAttributes = "";
			$this->godown_arrival_date->HrefValue = "";
			$this->godown_arrival_date->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "purchase_a_flist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// rack
			$this->rack->LinkCustomAttributes = "";
			$this->rack->HrefValue = "";
			$this->rack->TooltipValue = "";

			// invoice_details
			$this->invoice_details->LinkCustomAttributes = "";
			$this->invoice_details->HrefValue = "";
			$this->invoice_details->TooltipValue = "";

			// invoice_value
			$this->invoice_value->LinkCustomAttributes = "";
			$this->invoice_value->HrefValue = "";
			$this->invoice_value->TooltipValue = "";

			// currency_rate
			$this->currency_rate->LinkCustomAttributes = "";
			$this->currency_rate->HrefValue = "";
			$this->currency_rate->TooltipValue = "";

			// purchase_amount_inr
			$this->purchase_amount_inr->LinkCustomAttributes = "";
			$this->purchase_amount_inr->HrefValue = "";
			$this->purchase_amount_inr->TooltipValue = "";

			// duty_paid_by
			$this->duty_paid_by->LinkCustomAttributes = "";
			$this->duty_paid_by->HrefValue = "";
			$this->duty_paid_by->TooltipValue = "";

			// custom_duty
			$this->custom_duty->LinkCustomAttributes = "";
			$this->custom_duty->HrefValue = "";
			$this->custom_duty->TooltipValue = "";

			// transportation_charges
			$this->transportation_charges->LinkCustomAttributes = "";
			$this->transportation_charges->HrefValue = "";
			$this->transportation_charges->TooltipValue = "";

			// port_clearing_charge
			$this->port_clearing_charge->LinkCustomAttributes = "";
			$this->port_clearing_charge->HrefValue = "";
			$this->port_clearing_charge->TooltipValue = "";

			// cha_commission
			$this->cha_commission->LinkCustomAttributes = "";
			$this->cha_commission->HrefValue = "";
			$this->cha_commission->TooltipValue = "";

			// cha_agent
			$this->cha_agent->LinkCustomAttributes = "";
			$this->cha_agent->HrefValue = "";
			$this->cha_agent->TooltipValue = "";

			// clearance_bank
			$this->clearance_bank->LinkCustomAttributes = "";
			$this->clearance_bank->HrefValue = "";
			$this->clearance_bank->TooltipValue = "";

			// bank_charges
			$this->bank_charges->LinkCustomAttributes = "";
			$this->bank_charges->HrefValue = "";
			$this->bank_charges->TooltipValue = "";

			// importer
			$this->importer->LinkCustomAttributes = "";
			$this->importer->HrefValue = "";
			$this->importer->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// fiba_fibd
			$this->fiba_fibd->LinkCustomAttributes = "";
			$this->fiba_fibd->HrefValue = "";
			$this->fiba_fibd->TooltipValue = "";

			// fibc
			$this->fibc->LinkCustomAttributes = "";
			$this->fibc->HrefValue = "";
			$this->fibc->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";
			$this->updated->TooltipValue = "";

			// qc_remarks
			$this->qc_remarks->LinkCustomAttributes = "";
			$this->qc_remarks->HrefValue = "";
			$this->qc_remarks->TooltipValue = "";

			// qc_status
			$this->qc_status->LinkCustomAttributes = "";
			$this->qc_status->HrefValue = "";
			$this->qc_status->TooltipValue = "";

			// qc_operator
			$this->qc_operator->LinkCustomAttributes = "";
			$this->qc_operator->HrefValue = "";
			$this->qc_operator->TooltipValue = "";

			// qc_datetime
			$this->qc_datetime->LinkCustomAttributes = "";
			$this->qc_datetime->HrefValue = "";
			$this->qc_datetime->TooltipValue = "";

			// rbi_compliance_date
			$this->rbi_compliance_date->LinkCustomAttributes = "";
			$this->rbi_compliance_date->HrefValue = "";
			$this->rbi_compliance_date->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchase_alist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_supplier":
					$lookupFilter = function() {
						return "`status`=1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_booking_reference":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`id` = 1 and grp = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cha_agent":
					$lookupFilter = function() {
						return "`grp` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_importer":
					$lookupFilter = function() {
						return "`grp` IN (0,1)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_supplier":
							break;
						case "x_booking_reference":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_shipping_line":
							break;
						case "x_godown":
							break;
						case "x_cha_agent":
							break;
						case "x_clearance_bank":
							break;
						case "x_importer":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>