<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for purchase_l_audit
 */
class purchase_l_audit extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $type;
	public $company_id;
	public $supplier;
	public $rid;
	public $rid_return;
	public $avg_quantity;
	public $grp;
	public $s_grp;
	public $product;
	public $lot_no;
	public $_barcode;
	public $net_weight;
	public $packets;
	public $packing_type;
	public $_40;
	public $amount;
	public $godown;
	public $rack;
	public $dated;
	public $goods_inward;
	public $invoice_details;
	public $invoice_dated;
	public $return_details;
	public $operator;
	public $datetime;
	public $remarks;
	public $audit;
	public $a_operator;
	public $a_datetime;
	public $url;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'purchase_l_audit';
		$this->TableName = 'purchase_l_audit';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`purchase_l_audit`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// type
		$this->type = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_type', 'type', '`type`', '`type`', 18, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->type->Nullable = FALSE; // NOT NULL field
		$this->type->Required = TRUE; // Required field
		$this->type->Sortable = TRUE; // Allow sort
		$this->type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->type->Lookup = new Lookup('type', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// company_id
		$this->company_id = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Nullable = FALSE; // NOT NULL field
		$this->company_id->Required = TRUE; // Required field
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// supplier
		$this->supplier = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_supplier', 'supplier', '`supplier`', '`supplier`', 19, -1, FALSE, '`supplier`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->supplier->Required = TRUE; // Required field
		$this->supplier->Sortable = TRUE; // Allow sort
		$this->supplier->Lookup = new Lookup('supplier', 'buyer_seller_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->supplier->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['supplier'] = &$this->supplier;

		// rid
		$this->rid = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`EV__rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], ["x_product"], [], ["product"], ["x_product"], ["b_01"], ["x_avg_quantity"], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// rid_return
		$this->rid_return = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_rid_return', 'rid_return', '`rid_return`', '`rid_return`', 200, -1, FALSE, '`EV__rid_return`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->rid_return->Sortable = FALSE; // Allow sort
		$this->rid_return->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid_return->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid_return->Lookup = new Lookup('rid_return', 'stock_lcgp', FALSE, 'id', ["product_code","Balance","packing_type_n","lot_no"], ["x_product","x_godown"], [], ["product","godown"], ["x_product","x_godown"], ["rid","packing_type","lot_no","avg_quantity"], ["x_rid","x_packing_type","x_lot_no","x_avg_quantity"], '`product_code` ASC', '');
		$this->rid_return->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid_return'] = &$this->rid_return;

		// avg_quantity
		$this->avg_quantity = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_avg_quantity', 'avg_quantity', '`avg_quantity`', '`avg_quantity`', 18, -1, FALSE, '`avg_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->Sortable = FALSE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// grp
		$this->grp = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', FALSE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid","x_rid_return"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// lot_no
		$this->lot_no = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`EV__lot_no`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Required = TRUE; // Required field
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->lot_no->Lookup = new Lookup('lot_no', 'purchase_l', TRUE, 'lot_no', ["lot_no","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->fields['lot_no'] = &$this->lot_no;

		// barcode
		$this->_barcode = new DbField('purchase_l_audit', 'purchase_l_audit', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->fields['barcode'] = &$this->_barcode;

		// net_weight
		$this->net_weight = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_net_weight', 'net_weight', '`net_weight`', '`net_weight`', 131, -1, FALSE, '`net_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->net_weight->Required = TRUE; // Required field
		$this->net_weight->Sortable = TRUE; // Allow sort
		$this->net_weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['net_weight'] = &$this->net_weight;

		// packets
		$this->packets = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_packets', 'packets', '`packets`', '`packets`', 131, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Required = TRUE; // Required field
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packets'] = &$this->packets;

		// packing_type
		$this->packing_type = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","code","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// @
		$this->_40 = new DbField('purchase_l_audit', 'purchase_l_audit', 'x__40', '@', '`@`', '`@`', 131, -1, FALSE, '`@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40->Sortable = TRUE; // Allow sort
		$this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@'] = &$this->_40;

		// amount
		$this->amount = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// godown
		$this->godown = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_godown', 'godown', '`godown`', '`godown`', 19, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["name","location","code",""], [], ["x_rid_return"], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// rack
		$this->rack = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_rack', 'rack', '`rack`', '`rack`', 200, -1, FALSE, '`rack`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rack->Sortable = TRUE; // Allow sort
		$this->fields['rack'] = &$this->rack;

		// dated
		$this->dated = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 135, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Required = TRUE; // Required field
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// goods_inward
		$this->goods_inward = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_goods_inward', 'goods_inward', '`goods_inward`', '`goods_inward`', 200, -1, FALSE, '`goods_inward`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->goods_inward->Sortable = TRUE; // Allow sort
		$this->fields['goods_inward'] = &$this->goods_inward;

		// invoice_details
		$this->invoice_details = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_invoice_details', 'invoice_details', '`invoice_details`', '`invoice_details`', 200, -1, FALSE, '`invoice_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_details->Nullable = FALSE; // NOT NULL field
		$this->invoice_details->Required = TRUE; // Required field
		$this->invoice_details->Sortable = TRUE; // Allow sort
		$this->fields['invoice_details'] = &$this->invoice_details;

		// invoice_dated
		$this->invoice_dated = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_invoice_dated', 'invoice_dated', '`invoice_dated`', CastDateFieldForLike('`invoice_dated`', 0, "DB"), 133, 0, FALSE, '`invoice_dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_dated->Sortable = FALSE; // Allow sort
		$this->invoice_dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['invoice_dated'] = &$this->invoice_dated;

		// return_details
		$this->return_details = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_return_details', 'return_details', '`return_details`', '`return_details`', 200, -1, FALSE, '`return_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->return_details->Sortable = TRUE; // Allow sort
		$this->fields['return_details'] = &$this->return_details;

		// operator
		$this->operator = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// remarks
		$this->remarks = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// audit
		$this->audit = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_audit', 'audit', '`audit`', '`audit`', 16, -1, FALSE, '`audit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->audit->Nullable = FALSE; // NOT NULL field
		$this->audit->Sortable = FALSE; // Allow sort
		$this->audit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->audit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->audit->Lookup = new Lookup('audit', 'purchase_l_audit', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->audit->OptionCount = 2;
		$this->audit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['audit'] = &$this->audit;

		// a_operator
		$this->a_operator = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 2, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_operator->Sortable = FALSE; // Allow sort
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_a_datetime', 'a_datetime', '`a_datetime`', '`a_datetime`', 2, -1, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = FALSE; // Allow sort
		$this->a_datetime->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_datetime'] = &$this->a_datetime;

		// url
		$this->url = new DbField('purchase_l_audit', 'purchase_l_audit', 'x_url', 'url', '`url`', '`url`', 200, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->Nullable = FALSE; // NOT NULL field
		$this->url->Required = TRUE; // Required field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`purchase_l_audit`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `purchase_l_audit`.`rid` LIMIT 1) AS `EV__rid`, (SELECT CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->rid_return) . "',COALESCE(`Balance`,''),'" . ValueSeparator(2, $this->rid_return) . "',COALESCE(`packing_type_n`,''),'" . ValueSeparator(3, $this->rid_return) . "',COALESCE(`lot_no`,'')) FROM `stock_lcgp` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `purchase_l_audit`.`rid_return` LIMIT 1) AS `EV__rid_return`, (SELECT DISTINCT `lot_no` FROM `purchase_l` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`lot_no` = `purchase_l_audit`.`lot_no` LIMIT 1) AS `EV__lot_no` FROM `purchase_l_audit`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if ($this->rid_return->AdvancedSearch->SearchValue <> "" ||
			$this->rid_return->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid_return->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid_return->VirtualExpression . " "))
			return TRUE;
		if ($this->lot_no->AdvancedSearch->SearchValue <> "" ||
			$this->lot_no->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->lot_no->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->lot_no->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->type->DbValue = $row['type'];
		$this->company_id->DbValue = $row['company_id'];
		$this->supplier->DbValue = $row['supplier'];
		$this->rid->DbValue = $row['rid'];
		$this->rid_return->DbValue = $row['rid_return'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->net_weight->DbValue = $row['net_weight'];
		$this->packets->DbValue = $row['packets'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->_40->DbValue = $row['@'];
		$this->amount->DbValue = $row['amount'];
		$this->godown->DbValue = $row['godown'];
		$this->rack->DbValue = $row['rack'];
		$this->dated->DbValue = $row['dated'];
		$this->goods_inward->DbValue = $row['goods_inward'];
		$this->invoice_details->DbValue = $row['invoice_details'];
		$this->invoice_dated->DbValue = $row['invoice_dated'];
		$this->return_details->DbValue = $row['return_details'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->remarks->DbValue = $row['remarks'];
		$this->audit->DbValue = $row['audit'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->url->DbValue = $row['url'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "purchase_l_auditlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "purchase_l_auditview.php")
			return $Language->phrase("View");
		elseif ($pageName == "purchase_l_auditedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "purchase_l_auditadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "purchase_l_auditlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("purchase_l_auditview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("purchase_l_auditview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "purchase_l_auditadd.php?" . $this->getUrlParm($parm);
		else
			$url = "purchase_l_auditadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("purchase_l_auditedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("purchase_l_auditadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("purchase_l_auditdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->type->setDbValue($rs->fields('type'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->supplier->setDbValue($rs->fields('supplier'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->rid_return->setDbValue($rs->fields('rid_return'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->net_weight->setDbValue($rs->fields('net_weight'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->_40->setDbValue($rs->fields('@'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->rack->setDbValue($rs->fields('rack'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->goods_inward->setDbValue($rs->fields('goods_inward'));
		$this->invoice_details->setDbValue($rs->fields('invoice_details'));
		$this->invoice_dated->setDbValue($rs->fields('invoice_dated'));
		$this->return_details->setDbValue($rs->fields('return_details'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->audit->setDbValue($rs->fields('audit'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->url->setDbValue($rs->fields('url'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// type
		// company_id
		// supplier
		// rid
		// rid_return

		$this->rid_return->CellCssStyle = "white-space: nowrap;";

		// avg_quantity
		// grp
		// s_grp
		// product
		// lot_no
		// barcode
		// net_weight
		// packets
		// packing_type
		// @
		// amount
		// godown
		// rack
		// dated
		// goods_inward
		// invoice_details
		// invoice_dated
		// return_details
		// operator
		// datetime
		// remarks
		// audit

		$this->audit->CellCssStyle = "white-space: nowrap;";

		// a_operator
		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// a_datetime
		$this->a_datetime->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		$curVal = strval($this->type->CurrentValue);
		if ($curVal <> "") {
			$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
			if ($this->type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add")  ? "`grp`=80 and `id` != 74" : "`grp`=80";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->type->ViewValue = $this->type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->type->ViewValue = $this->type->CurrentValue;
				}
			}
		} else {
			$this->type->ViewValue = NULL;
		}
		$this->type->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`= 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// supplier
		$this->supplier->ViewValue = $this->supplier->CurrentValue;
		$curVal = strval($this->supplier->CurrentValue);
		if ($curVal <> "") {
			$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
			if ($this->supplier->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->supplier->ViewValue = $this->supplier->CurrentValue;
				}
			}
		} else {
			$this->supplier->ViewValue = NULL;
		}
		$this->supplier->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `product_type` <> 9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// rid_return
		if ($this->rid_return->VirtualValue <> "") {
			$this->rid_return->ViewValue = $this->rid_return->VirtualValue;
		} else {
		$curVal = strval($this->rid_return->CurrentValue);
		if ($curVal <> "") {
			$this->rid_return->ViewValue = $this->rid_return->lookupCacheOption($curVal);
			if ($this->rid_return->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$sqlWrk = $this->rid_return->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->rid_return->ViewValue = $this->rid_return->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_return->ViewValue = $this->rid_return->CurrentValue;
				}
			}
		} else {
			$this->rid_return->ViewValue = NULL;
		}
		}
		$this->rid_return->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 0, -2, -2, -2);
		$this->avg_quantity->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// lot_no
		if ($this->lot_no->VirtualValue <> "") {
			$this->lot_no->ViewValue = $this->lot_no->VirtualValue;
		} else {
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$curVal = strval($this->lot_no->CurrentValue);
		if ($curVal <> "") {
			$this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
			if ($this->lot_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`lot_no`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->lot_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->lot_no->ViewValue = $this->lot_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
				}
			}
		} else {
			$this->lot_no->ViewValue = NULL;
		}
		}
		$this->lot_no->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// net_weight
		$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
		$this->net_weight->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// @
		$this->_40->ViewValue = $this->_40->CurrentValue;
		$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 4, -2, -2, -2);
		$this->_40->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// godown
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `id`>1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// rack
		$this->rack->ViewValue = $this->rack->CurrentValue;
		$this->rack->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// goods_inward
		$this->goods_inward->ViewValue = $this->goods_inward->CurrentValue;
		$this->goods_inward->ViewCustomAttributes = "";

		// invoice_details
		$this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;
		$this->invoice_details->ViewCustomAttributes = "";

		// invoice_dated
		$this->invoice_dated->ViewValue = $this->invoice_dated->CurrentValue;
		$this->invoice_dated->ViewValue = FormatDateTime($this->invoice_dated->ViewValue, 0);
		$this->invoice_dated->ViewCustomAttributes = "";

		// return_details
		$this->return_details->ViewValue = $this->return_details->CurrentValue;
		$this->return_details->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// audit
		if (strval($this->audit->CurrentValue) <> "") {
			$this->audit->ViewValue = $this->audit->optionCaption($this->audit->CurrentValue);
		} else {
			$this->audit->ViewValue = NULL;
		}
		$this->audit->ViewCustomAttributes = "";

		// a_operator
		$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
		$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatNumber($this->a_datetime->ViewValue, 0, -2, -2, -2);
		$this->a_datetime->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// supplier
		$this->supplier->LinkCustomAttributes = "";
		if (!EmptyValue($this->supplier->CurrentValue)) {
			$this->supplier->HrefValue = "purchase_llist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
			$this->supplier->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
		} else {
			$this->supplier->HrefValue = "";
		}
		$this->supplier->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "purchase_llist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// rid_return
		$this->rid_return->LinkCustomAttributes = "";
		$this->rid_return->HrefValue = "";
		$this->rid_return->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "purchase_llist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "purchase_llist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// net_weight
		$this->net_weight->LinkCustomAttributes = "";
		$this->net_weight->HrefValue = "";
		$this->net_weight->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->packing_type->CurrentValue)) {
			$this->packing_type->HrefValue = "purchase_llist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
			$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
		} else {
			$this->packing_type->HrefValue = "";
		}
		$this->packing_type->TooltipValue = "";

		// @
		$this->_40->LinkCustomAttributes = "";
		$this->_40->HrefValue = "";
		$this->_40->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "purchase_llist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// rack
		$this->rack->LinkCustomAttributes = "";
		$this->rack->HrefValue = "";
		$this->rack->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// goods_inward
		$this->goods_inward->LinkCustomAttributes = "";
		$this->goods_inward->HrefValue = "";
		$this->goods_inward->TooltipValue = "";

		// invoice_details
		$this->invoice_details->LinkCustomAttributes = "";
		if (!EmptyValue($this->invoice_details->CurrentValue)) {
			$this->invoice_details->HrefValue = "purchase_llist.php?x_invoice_details=" . $this->invoice_details->CurrentValue; // Add prefix/suffix
			$this->invoice_details->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->invoice_details->HrefValue = FullUrl($this->invoice_details->HrefValue, "href");
		} else {
			$this->invoice_details->HrefValue = "";
		}
		$this->invoice_details->TooltipValue = "";

		// invoice_dated
		$this->invoice_dated->LinkCustomAttributes = "";
		if (!EmptyValue($this->invoice_details->CurrentValue)) {
			$this->invoice_dated->HrefValue = "purchase_llist.php?x_invoice_dated=" . $this->invoice_details->CurrentValue; // Add prefix/suffix
			$this->invoice_dated->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->invoice_dated->HrefValue = FullUrl($this->invoice_dated->HrefValue, "href");
		} else {
			$this->invoice_dated->HrefValue = "";
		}
		$this->invoice_dated->TooltipValue = "";

		// return_details
		$this->return_details->LinkCustomAttributes = "";
		$this->return_details->HrefValue = "";
		$this->return_details->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// audit
		$this->audit->LinkCustomAttributes = "";
		$this->audit->HrefValue = "";
		$this->audit->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		$curVal = strval($this->type->CurrentValue);
		if ($curVal <> "") {
			$this->type->EditValue = $this->type->lookupCacheOption($curVal);
			if ($this->type->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add")  ? "`grp`=80 and `id` != 74" : "`grp`=80";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->type->EditValue = $this->type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->type->EditValue = $this->type->CurrentValue;
				}
			}
		} else {
			$this->type->EditValue = NULL;
		}
		$this->type->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// supplier
		$this->supplier->EditAttrs["class"] = "form-control";
		$this->supplier->EditCustomAttributes = "";
		$this->supplier->EditValue = $this->supplier->CurrentValue;
		$curVal = strval($this->supplier->CurrentValue);
		if ($curVal <> "") {
			$this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
			if ($this->supplier->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->supplier->EditValue = $this->supplier->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->supplier->EditValue = $this->supplier->CurrentValue;
				}
			}
		} else {
			$this->supplier->EditValue = NULL;
		}
		$this->supplier->ViewCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if ($this->rid->VirtualValue <> "") {
			$this->rid->EditValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `product_type` <> 9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// rid_return
		$this->rid_return->EditAttrs["class"] = "form-control";
		$this->rid_return->EditCustomAttributes = "";
		if ($this->rid_return->VirtualValue <> "") {
			$this->rid_return->EditValue = $this->rid_return->VirtualValue;
		} else {
		$curVal = strval($this->rid_return->CurrentValue);
		if ($curVal <> "") {
			$this->rid_return->EditValue = $this->rid_return->lookupCacheOption($curVal);
			if ($this->rid_return->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
				$sqlWrk = $this->rid_return->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->rid_return->EditValue = $this->rid_return->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid_return->EditValue = $this->rid_return->CurrentValue;
				}
			}
		} else {
			$this->rid_return->EditValue = NULL;
		}
		}
		$this->rid_return->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = "";
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->EditValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->EditValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->EditValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->EditValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->EditValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->EditValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if ($this->lot_no->VirtualValue <> "") {
			$this->lot_no->EditValue = $this->lot_no->VirtualValue;
		} else {
			$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$curVal = strval($this->lot_no->CurrentValue);
		if ($curVal <> "") {
			$this->lot_no->EditValue = $this->lot_no->lookupCacheOption($curVal);
			if ($this->lot_no->EditValue === NULL) { // Lookup from database
				$filterWrk = "`lot_no`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->lot_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->lot_no->EditValue = $this->lot_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->lot_no->EditValue = $this->lot_no->CurrentValue;
				}
			}
		} else {
			$this->lot_no->EditValue = NULL;
		}
		}
		$this->lot_no->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// net_weight
		$this->net_weight->EditAttrs["class"] = "form-control";
		$this->net_weight->EditCustomAttributes = "";
		$this->net_weight->EditValue = $this->net_weight->CurrentValue;
		$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
		if (strval($this->net_weight->EditValue) <> "" && is_numeric($this->net_weight->EditValue))
			$this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, -2, -1, -2, 0);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
		if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
			$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -1, -2, 0);

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// @
		$this->_40->EditAttrs["class"] = "form-control";
		$this->_40->EditCustomAttributes = "";
		$this->_40->EditValue = $this->_40->CurrentValue;
		$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
		if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
			$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = 'ReadOnly';
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";

		// rack
		$this->rack->EditAttrs["class"] = "form-control";
		$this->rack->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rack->CurrentValue = HtmlDecode($this->rack->CurrentValue);
		$this->rack->EditValue = $this->rack->CurrentValue;
		$this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, 8);
		$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

		// goods_inward
		$this->goods_inward->EditAttrs["class"] = "form-control";
		$this->goods_inward->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->goods_inward->CurrentValue = HtmlDecode($this->goods_inward->CurrentValue);
		$this->goods_inward->EditValue = $this->goods_inward->CurrentValue;
		$this->goods_inward->PlaceHolder = RemoveHtml($this->goods_inward->caption());

		// invoice_details
		$this->invoice_details->EditAttrs["class"] = "form-control";
		$this->invoice_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->invoice_details->CurrentValue = HtmlDecode($this->invoice_details->CurrentValue);
		$this->invoice_details->EditValue = $this->invoice_details->CurrentValue;
		$this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

		// invoice_dated
		$this->invoice_dated->EditAttrs["class"] = "form-control";
		$this->invoice_dated->EditCustomAttributes = "";
		$this->invoice_dated->EditValue = FormatDateTime($this->invoice_dated->CurrentValue, 8);
		$this->invoice_dated->PlaceHolder = RemoveHtml($this->invoice_dated->caption());

		// return_details
		$this->return_details->EditAttrs["class"] = "form-control";
		$this->return_details->EditCustomAttributes = "";
		$this->return_details->EditValue = $this->return_details->CurrentValue;
		$this->return_details->PlaceHolder = RemoveHtml($this->return_details->caption());

		// operator
		$this->operator->EditAttrs["class"] = "form-control";
		$this->operator->EditCustomAttributes = "";
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->EditValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->EditValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->EditValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->EditAttrs["class"] = "form-control";
		$this->datetime->EditCustomAttributes = "";
		$this->datetime->EditValue = $this->datetime->CurrentValue;
		$this->datetime->EditValue = FormatDateTime($this->datetime->EditValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// audit
		$this->audit->EditAttrs["class"] = "form-control";
		$this->audit->EditCustomAttributes = "";
		$this->audit->EditValue = $this->audit->options(TRUE);

		// a_operator
		// a_datetime
		// url

		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->net_weight->CurrentValue))
				$this->net_weight->Total += $this->net_weight->CurrentValue; // Accumulate total
			if (is_numeric($this->packets->CurrentValue))
				$this->packets->Total += $this->packets->CurrentValue; // Accumulate total
			if (is_numeric($this->amount->CurrentValue))
				$this->amount->Total += $this->amount->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->net_weight->CurrentValue = $this->net_weight->Total;
			$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
			$this->net_weight->ViewCustomAttributes = "";
			$this->net_weight->HrefValue = ""; // Clear href value
			$this->packets->CurrentValue = $this->packets->Total;
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";
			$this->packets->HrefValue = ""; // Clear href value
			$this->amount->CurrentValue = $this->amount->Total;
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";
			$this->amount->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->supplier);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->rid_return);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->net_weight);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->rack);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->goods_inward);
					$doc->exportCaption($this->invoice_details);
					$doc->exportCaption($this->return_details);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->remarks);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->supplier);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->net_weight);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->rack);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->goods_inward);
					$doc->exportCaption($this->invoice_details);
					$doc->exportCaption($this->return_details);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->remarks);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->company_id);
						$doc->exportField($this->supplier);
						$doc->exportField($this->rid);
						$doc->exportField($this->rid_return);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->net_weight);
						$doc->exportField($this->packets);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->_40);
						$doc->exportField($this->amount);
						$doc->exportField($this->godown);
						$doc->exportField($this->rack);
						$doc->exportField($this->dated);
						$doc->exportField($this->goods_inward);
						$doc->exportField($this->invoice_details);
						$doc->exportField($this->return_details);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->remarks);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->company_id);
						$doc->exportField($this->supplier);
						$doc->exportField($this->rid);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->net_weight);
						$doc->exportField($this->packets);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->_40);
						$doc->exportField($this->amount);
						$doc->exportField($this->godown);
						$doc->exportField($this->rack);
						$doc->exportField($this->dated);
						$doc->exportField($this->goods_inward);
						$doc->exportField($this->invoice_details);
						$doc->exportField($this->return_details);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->remarks);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->type, '');
				$doc->exportAggregate($this->company_id, '');
				$doc->exportAggregate($this->supplier, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->s_grp, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->lot_no, '');
				$doc->exportAggregate($this->_barcode, '');
				$doc->exportAggregate($this->net_weight, 'TOTAL');
				$doc->exportAggregate($this->packets, 'TOTAL');
				$doc->exportAggregate($this->packing_type, '');
				$doc->exportAggregate($this->_40, '');
				$doc->exportAggregate($this->amount, 'TOTAL');
				$doc->exportAggregate($this->godown, '');
				$doc->exportAggregate($this->rack, '');
				$doc->exportAggregate($this->dated, '');
				$doc->exportAggregate($this->goods_inward, '');
				$doc->exportAggregate($this->invoice_details, '');
				$doc->exportAggregate($this->return_details, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'purchase_l_audit';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'purchase_l_audit';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'purchase_l_audit';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'purchase_l_audit';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>