<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class purchase_l_edit extends purchase_l
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'purchase_l';

	// Page object name
	public $PageObjName = "purchase_l_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (purchase_l)
		if (!isset($GLOBALS["purchase_l"]) || get_class($GLOBALS["purchase_l"]) == PROJECT_NAMESPACE . "purchase_l") {
			$GLOBALS["purchase_l"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["purchase_l"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_l');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $purchase_l;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($purchase_l);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "purchase_lview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("purchase_llist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->type->setVisibility();
		$this->supplier->setVisibility();
		$this->po->setVisibility();
		$this->po_return->setVisibility();
		$this->company_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid_return->setVisibility();
		$this->rid->setVisibility();
		$this->packing_type->setVisibility();
		$this->lot_no->setVisibility();
		$this->avg_quantity->Visible = FALSE;
		$this->packets->setVisibility();
		$this->net_weight->setVisibility();
		$this->_40->setVisibility();
		$this->amount->setVisibility();
		$this->godown->setVisibility();
		$this->dated->setVisibility();
		$this->operator->setVisibility();
		$this->rack->setVisibility();
		$this->updated->Visible = FALSE;
		$this->datetime->setVisibility();
		$this->remarks->setVisibility();
		$this->goods_inward->setVisibility();
		$this->invoice_details->setVisibility();
		$this->invoice_dated->Visible = FALSE;
		$this->_barcode->setVisibility();
		$this->country->Visible = FALSE;
		$this->wool_type->Visible = FALSE;
		$this->quality->Visible = FALSE;
		$this->sorting_type->Visible = FALSE;
		$this->scouring_type->Visible = FALSE;
		$this->dye_type->Visible = FALSE;
		$this->importer->Visible = FALSE;
		$this->grade->Visible = FALSE;
		$this->return_details->setVisibility();
		$this->audit->Visible = FALSE;
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->agent->Visible = FALSE;
		$this->qc_remarks->setVisibility();
		$this->qc_status->setVisibility();
		$this->qc_operator->setVisibility();
		$this->qc_datetime->setVisibility();
		$this->age->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->type->Required = FALSE;
		$this->supplier->Required = FALSE;
		$this->grp->Required = FALSE;
		$this->s_grp->Required = FALSE;
		$this->product->Required = FALSE;
		$this->rid->Required = FALSE;
		$this->lot_no->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->type);
		$this->setupLookupOptions($this->supplier);
		$this->setupLookupOptions($this->po);
		$this->setupLookupOptions($this->po_return);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid_return);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->lot_no);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->sorting_type);
		$this->setupLookupOptions($this->scouring_type);
		$this->setupLookupOptions($this->importer);
		$this->setupLookupOptions($this->agent);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("purchase_llist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "purchase_llist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}

		// Check field name 'supplier' first before field var 'x_supplier'
		$val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
		if (!$this->supplier->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->supplier->Visible = FALSE; // Disable update for API request
			else
				$this->supplier->setFormValue($val);
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'po_return' first before field var 'x_po_return'
		$val = $CurrentForm->hasValue("po_return") ? $CurrentForm->getValue("po_return") : $CurrentForm->getValue("x_po_return");
		if (!$this->po_return->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_return->Visible = FALSE; // Disable update for API request
			else
				$this->po_return->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid_return' first before field var 'x_rid_return'
		$val = $CurrentForm->hasValue("rid_return") ? $CurrentForm->getValue("rid_return") : $CurrentForm->getValue("x_rid_return");
		if (!$this->rid_return->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid_return->Visible = FALSE; // Disable update for API request
			else
				$this->rid_return->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'packets' first before field var 'x_packets'
		$val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
		if (!$this->packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets->Visible = FALSE; // Disable update for API request
			else
				$this->packets->setFormValue($val);
		}

		// Check field name 'net_weight' first before field var 'x_net_weight'
		$val = $CurrentForm->hasValue("net_weight") ? $CurrentForm->getValue("net_weight") : $CurrentForm->getValue("x_net_weight");
		if (!$this->net_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->net_weight->Visible = FALSE; // Disable update for API request
			else
				$this->net_weight->setFormValue($val);
		}

		// Check field name '@' first before field var 'x__40'
		$val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
		if (!$this->_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40->Visible = FALSE; // Disable update for API request
			else
				$this->_40->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'rack' first before field var 'x_rack'
		$val = $CurrentForm->hasValue("rack") ? $CurrentForm->getValue("rack") : $CurrentForm->getValue("x_rack");
		if (!$this->rack->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rack->Visible = FALSE; // Disable update for API request
			else
				$this->rack->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'goods_inward' first before field var 'x_goods_inward'
		$val = $CurrentForm->hasValue("goods_inward") ? $CurrentForm->getValue("goods_inward") : $CurrentForm->getValue("x_goods_inward");
		if (!$this->goods_inward->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->goods_inward->Visible = FALSE; // Disable update for API request
			else
				$this->goods_inward->setFormValue($val);
		}

		// Check field name 'invoice_details' first before field var 'x_invoice_details'
		$val = $CurrentForm->hasValue("invoice_details") ? $CurrentForm->getValue("invoice_details") : $CurrentForm->getValue("x_invoice_details");
		if (!$this->invoice_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_details->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_details->setFormValue($val);
		}

		// Check field name 'barcode' first before field var 'x__barcode'
		$val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
		if (!$this->_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->_barcode->setFormValue($val);
		}

		// Check field name 'return_details' first before field var 'x_return_details'
		$val = $CurrentForm->hasValue("return_details") ? $CurrentForm->getValue("return_details") : $CurrentForm->getValue("x_return_details");
		if (!$this->return_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->return_details->Visible = FALSE; // Disable update for API request
			else
				$this->return_details->setFormValue($val);
		}

		// Check field name 'qc_remarks' first before field var 'x_qc_remarks'
		$val = $CurrentForm->hasValue("qc_remarks") ? $CurrentForm->getValue("qc_remarks") : $CurrentForm->getValue("x_qc_remarks");
		if (!$this->qc_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->qc_remarks->setFormValue($val);
		}

		// Check field name 'qc_status' first before field var 'x_qc_status'
		$val = $CurrentForm->hasValue("qc_status") ? $CurrentForm->getValue("qc_status") : $CurrentForm->getValue("x_qc_status");
		if (!$this->qc_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_status->Visible = FALSE; // Disable update for API request
			else
				$this->qc_status->setFormValue($val);
		}

		// Check field name 'qc_operator' first before field var 'x_qc_operator'
		$val = $CurrentForm->hasValue("qc_operator") ? $CurrentForm->getValue("qc_operator") : $CurrentForm->getValue("x_qc_operator");
		if (!$this->qc_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_operator->Visible = FALSE; // Disable update for API request
			else
				$this->qc_operator->setFormValue($val);
		}

		// Check field name 'qc_datetime' first before field var 'x_qc_datetime'
		$val = $CurrentForm->hasValue("qc_datetime") ? $CurrentForm->getValue("qc_datetime") : $CurrentForm->getValue("x_qc_datetime");
		if (!$this->qc_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->qc_datetime->setFormValue($val);
			$this->qc_datetime->CurrentValue = UnFormatDateTime($this->qc_datetime->CurrentValue, 0);
		}

		// Check field name 'age' first before field var 'x_age'
		$val = $CurrentForm->hasValue("age") ? $CurrentForm->getValue("age") : $CurrentForm->getValue("x_age");
		if (!$this->age->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->age->Visible = FALSE; // Disable update for API request
			else
				$this->age->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->type->CurrentValue = $this->type->FormValue;
		$this->supplier->CurrentValue = $this->supplier->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->po_return->CurrentValue = $this->po_return->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid_return->CurrentValue = $this->rid_return->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->packets->CurrentValue = $this->packets->FormValue;
		$this->net_weight->CurrentValue = $this->net_weight->FormValue;
		$this->_40->CurrentValue = $this->_40->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->rack->CurrentValue = $this->rack->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->goods_inward->CurrentValue = $this->goods_inward->FormValue;
		$this->invoice_details->CurrentValue = $this->invoice_details->FormValue;
		$this->_barcode->CurrentValue = $this->_barcode->FormValue;
		$this->return_details->CurrentValue = $this->return_details->FormValue;
		$this->qc_remarks->CurrentValue = $this->qc_remarks->FormValue;
		$this->qc_status->CurrentValue = $this->qc_status->FormValue;
		$this->qc_operator->CurrentValue = $this->qc_operator->FormValue;
		$this->qc_datetime->CurrentValue = $this->qc_datetime->FormValue;
		$this->qc_datetime->CurrentValue = UnFormatDateTime($this->qc_datetime->CurrentValue, 0);
		$this->age->CurrentValue = $this->age->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->type->setDbValue($row['type']);
		$this->supplier->setDbValue($row['supplier']);
		$this->po->setDbValue($row['po']);
		if (array_key_exists('EV__po', $rs->fields)) {
			$this->po->VirtualValue = $rs->fields('EV__po'); // Set up virtual field value
		} else {
			$this->po->VirtualValue = ""; // Clear value
		}
		$this->po_return->setDbValue($row['po_return']);
		$this->company_id->setDbValue($row['company_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid_return->setDbValue($row['rid_return']);
		if (array_key_exists('EV__rid_return', $rs->fields)) {
			$this->rid_return->VirtualValue = $rs->fields('EV__rid_return'); // Set up virtual field value
		} else {
			$this->rid_return->VirtualValue = ""; // Clear value
		}
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->packing_type->setDbValue($row['packing_type']);
		$this->lot_no->setDbValue($row['lot_no']);
		if (array_key_exists('EV__lot_no', $rs->fields)) {
			$this->lot_no->VirtualValue = $rs->fields('EV__lot_no'); // Set up virtual field value
		} else {
			$this->lot_no->VirtualValue = ""; // Clear value
		}
		$this->avg_quantity->setDbValue($row['avg_quantity']);
		$this->packets->setDbValue($row['packets']);
		$this->net_weight->setDbValue($row['net_weight']);
		$this->_40->setDbValue($row['@']);
		$this->amount->setDbValue($row['amount']);
		$this->godown->setDbValue($row['godown']);
		$this->dated->setDbValue($row['dated']);
		$this->operator->setDbValue($row['operator']);
		$this->rack->setDbValue($row['rack']);
		$this->updated->setDbValue($row['updated']);
		$this->datetime->setDbValue($row['datetime']);
		$this->remarks->setDbValue($row['remarks']);
		$this->goods_inward->setDbValue($row['goods_inward']);
		$this->invoice_details->setDbValue($row['invoice_details']);
		$this->invoice_dated->setDbValue($row['invoice_dated']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->country->setDbValue($row['country']);
		$this->wool_type->setDbValue($row['wool_type']);
		$this->quality->setDbValue($row['quality']);
		$this->sorting_type->setDbValue($row['sorting_type']);
		$this->scouring_type->setDbValue($row['scouring_type']);
		$this->dye_type->setDbValue($row['dye_type']);
		$this->importer->setDbValue($row['importer']);
		$this->grade->setDbValue($row['grade']);
		$this->return_details->setDbValue($row['return_details']);
		$this->audit->setDbValue($row['audit']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->agent->setDbValue($row['agent']);
		$this->qc_remarks->setDbValue($row['qc_remarks']);
		$this->qc_status->setDbValue($row['qc_status']);
		$this->qc_operator->setDbValue($row['qc_operator']);
		$this->qc_datetime->setDbValue($row['qc_datetime']);
		$this->age->setDbValue($row['age']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['type'] = NULL;
		$row['supplier'] = NULL;
		$row['po'] = NULL;
		$row['po_return'] = NULL;
		$row['company_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid_return'] = NULL;
		$row['rid'] = NULL;
		$row['packing_type'] = NULL;
		$row['lot_no'] = NULL;
		$row['avg_quantity'] = NULL;
		$row['packets'] = NULL;
		$row['net_weight'] = NULL;
		$row['@'] = NULL;
		$row['amount'] = NULL;
		$row['godown'] = NULL;
		$row['dated'] = NULL;
		$row['operator'] = NULL;
		$row['rack'] = NULL;
		$row['updated'] = NULL;
		$row['datetime'] = NULL;
		$row['remarks'] = NULL;
		$row['goods_inward'] = NULL;
		$row['invoice_details'] = NULL;
		$row['invoice_dated'] = NULL;
		$row['barcode'] = NULL;
		$row['country'] = NULL;
		$row['wool_type'] = NULL;
		$row['quality'] = NULL;
		$row['sorting_type'] = NULL;
		$row['scouring_type'] = NULL;
		$row['dye_type'] = NULL;
		$row['importer'] = NULL;
		$row['grade'] = NULL;
		$row['return_details'] = NULL;
		$row['audit'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['agent'] = NULL;
		$row['qc_remarks'] = NULL;
		$row['qc_status'] = NULL;
		$row['qc_operator'] = NULL;
		$row['qc_datetime'] = NULL;
		$row['age'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->packets->FormValue == $this->packets->CurrentValue && is_numeric(ConvertToFloatString($this->packets->CurrentValue)))
			$this->packets->CurrentValue = ConvertToFloatString($this->packets->CurrentValue);

		// Convert decimal values if posted back
		if ($this->net_weight->FormValue == $this->net_weight->CurrentValue && is_numeric(ConvertToFloatString($this->net_weight->CurrentValue)))
			$this->net_weight->CurrentValue = ConvertToFloatString($this->net_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// type
		// supplier
		// po
		// po_return
		// company_id
		// grp
		// s_grp
		// product
		// rid_return
		// rid
		// packing_type
		// lot_no
		// avg_quantity
		// packets
		// net_weight
		// @
		// amount
		// godown
		// dated
		// operator
		// rack
		// updated
		// datetime
		// remarks
		// goods_inward
		// invoice_details
		// invoice_dated
		// barcode
		// country
		// wool_type
		// quality
		// sorting_type
		// scouring_type
		// dye_type
		// importer
		// grade
		// return_details
		// audit
		// a_operator
		// a_datetime
		// agent
		// qc_remarks
		// qc_status
		// qc_operator
		// qc_datetime
		// age

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// type
			$curVal = strval($this->type->CurrentValue);
			if ($curVal <> "") {
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`grp`=80 and `id` != 74 and `status` =1" : "`grp`=80 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->type->ViewValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->ViewValue = $this->type->CurrentValue;
					}
				}
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// supplier
			$this->supplier->ViewValue = $this->supplier->CurrentValue;
			$curVal = strval($this->supplier->CurrentValue);
			if ($curVal <> "") {
				$this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
				if ($this->supplier->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`partner_type` = 1 and `status` = 1" : "`partner_type` < 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->supplier->ViewValue = $this->supplier->CurrentValue;
					}
				}
			} else {
				$this->supplier->ViewValue = NULL;
			}
			$this->supplier->ViewCustomAttributes = "";

			// po
			if ($this->po->VirtualValue <> "") {
				$this->po->ViewValue = $this->po->VirtualValue;
			} else {
				$this->po->ViewValue = $this->po->CurrentValue;
			$curVal = strval($this->po->CurrentValue);
			if ($curVal <> "") {
				$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
				if ($this->po->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`cart_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`pending_qty` > 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->po->ViewValue = $this->po->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po->ViewValue = $this->po->CurrentValue;
					}
				}
			} else {
				$this->po->ViewValue = NULL;
			}
			}
			$this->po->ViewCustomAttributes = "";

			// po_return
			$this->po_return->ViewValue = $this->po_return->CurrentValue;
			$curVal = strval($this->po_return->CurrentValue);
			if ($curVal <> "") {
				$this->po_return->ViewValue = $this->po_return->lookupCacheOption($curVal);
				if ($this->po_return->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`cart_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_return->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->po_return->ViewValue = $this->po_return->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_return->ViewValue = $this->po_return->CurrentValue;
					}
				}
			} else {
				$this->po_return->ViewValue = NULL;
			}
			$this->po_return->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid_return
			if ($this->rid_return->VirtualValue <> "") {
				$this->rid_return->ViewValue = $this->rid_return->VirtualValue;
			} else {
			$curVal = strval($this->rid_return->CurrentValue);
			if ($curVal <> "") {
				$this->rid_return->ViewValue = $this->rid_return->lookupCacheOption($curVal);
				if ($this->rid_return->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid_return->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->rid_return->ViewValue = $this->rid_return->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_return->ViewValue = $this->rid_return->CurrentValue;
					}
				}
			} else {
				$this->rid_return->ViewValue = NULL;
			}
			}
			$this->rid_return->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
				$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `product_type` <> 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// lot_no
			if ($this->lot_no->VirtualValue <> "") {
				$this->lot_no->ViewValue = $this->lot_no->VirtualValue;
			} else {
				$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->lot_no->CurrentValue;
			$this->lot_no->ViewValue = $this->lot_no->displayValue($arwrk);
			}
			$this->lot_no->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// net_weight
			$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
			$this->net_weight->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 4, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return User_Site() == 0 ?  "`status`=1 and `id` > 1 && `id` != 10" : "`status`=1 and `id` > 0 && `id` != 10 and FIND_IN_SET(id, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// rack
			$this->rack->ViewValue = $this->rack->CurrentValue;
			$this->rack->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// goods_inward
			$this->goods_inward->ViewValue = $this->goods_inward->CurrentValue;
			$this->goods_inward->ViewCustomAttributes = "";

			// invoice_details
			$this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;
			$this->invoice_details->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// return_details
			$this->return_details->ViewValue = $this->return_details->CurrentValue;
			$this->return_details->ViewCustomAttributes = "";

			// qc_remarks
			$this->qc_remarks->ViewValue = $this->qc_remarks->CurrentValue;
			$this->qc_remarks->ViewCustomAttributes = "";

			// qc_status
			$this->qc_status->ViewValue = $this->qc_status->CurrentValue;
			$this->qc_status->ViewValue = FormatNumber($this->qc_status->ViewValue, 0, -2, -2, -2);
			$this->qc_status->ViewCustomAttributes = "";

			// qc_operator
			$this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
			$this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, 0, -2, -2, -2);
			$this->qc_operator->ViewCustomAttributes = "";

			// qc_datetime
			$this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
			$this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, 0);
			$this->qc_datetime->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewValue = FormatNumber($this->age->ViewValue, 0, -2, -2, -2);
			$this->age->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// supplier
			$this->supplier->LinkCustomAttributes = "";
			if (!EmptyValue($this->supplier->CurrentValue)) {
				$this->supplier->HrefValue = "purchase_llist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
				$this->supplier->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
			} else {
				$this->supplier->HrefValue = "";
			}
			$this->supplier->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// po_return
			$this->po_return->LinkCustomAttributes = "";
			$this->po_return->HrefValue = "";
			$this->po_return->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "purchase_llist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "purchase_llist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid_return
			$this->rid_return->LinkCustomAttributes = "";
			$this->rid_return->HrefValue = "";
			$this->rid_return->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "purchase_llist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "purchase_llist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";
			$this->net_weight->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "purchase_llist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// rack
			$this->rack->LinkCustomAttributes = "";
			$this->rack->HrefValue = "";
			$this->rack->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// goods_inward
			$this->goods_inward->LinkCustomAttributes = "";
			$this->goods_inward->HrefValue = "";
			$this->goods_inward->TooltipValue = "";

			// invoice_details
			$this->invoice_details->LinkCustomAttributes = "";
			if (!EmptyValue($this->invoice_details->CurrentValue)) {
				$this->invoice_details->HrefValue = "purchase_llist.php?x_invoice_details=" . $this->invoice_details->CurrentValue; // Add prefix/suffix
				$this->invoice_details->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->invoice_details->HrefValue = FullUrl($this->invoice_details->HrefValue, "href");
			} else {
				$this->invoice_details->HrefValue = "";
			}
			$this->invoice_details->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// return_details
			$this->return_details->LinkCustomAttributes = "";
			$this->return_details->HrefValue = "";
			$this->return_details->TooltipValue = "";

			// qc_remarks
			$this->qc_remarks->LinkCustomAttributes = "";
			$this->qc_remarks->HrefValue = "";
			$this->qc_remarks->TooltipValue = "";

			// qc_status
			$this->qc_status->LinkCustomAttributes = "";
			$this->qc_status->HrefValue = "";
			$this->qc_status->TooltipValue = "";

			// qc_operator
			$this->qc_operator->LinkCustomAttributes = "";
			$this->qc_operator->HrefValue = "";
			$this->qc_operator->TooltipValue = "";

			// qc_datetime
			$this->qc_datetime->LinkCustomAttributes = "";
			$this->qc_datetime->HrefValue = "";
			$this->qc_datetime->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$curVal = strval($this->type->CurrentValue);
			if ($curVal <> "") {
				$this->type->EditValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`grp`=80 and `id` != 74 and `status` =1" : "`grp`=80 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->type->EditValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->EditValue = $this->type->CurrentValue;
					}
				}
			} else {
				$this->type->EditValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// supplier
			$this->supplier->EditAttrs["class"] = "form-control";
			$this->supplier->EditCustomAttributes = "";
			$this->supplier->EditValue = $this->supplier->CurrentValue;
			$curVal = strval($this->supplier->CurrentValue);
			if ($curVal <> "") {
				$this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
				if ($this->supplier->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`partner_type` = 1 and `status` = 1" : "`partner_type` < 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->supplier->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->supplier->EditValue = $this->supplier->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->supplier->EditValue = $this->supplier->CurrentValue;
					}
				}
			} else {
				$this->supplier->EditValue = NULL;
			}
			$this->supplier->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po->CurrentValue = HtmlDecode($this->po->CurrentValue);
			$this->po->EditValue = HtmlEncode($this->po->CurrentValue);
			$curVal = strval($this->po->CurrentValue);
			if ($curVal <> "") {
				$this->po->EditValue = $this->po->lookupCacheOption($curVal);
				if ($this->po->EditValue === NULL) { // Lookup from database
					$filterWrk = "`cart_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`pending_qty` > 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode(FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$arwrk[4] = HtmlEncode(FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2));
						$this->po->EditValue = $this->po->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po->EditValue = HtmlEncode($this->po->CurrentValue);
					}
				}
			} else {
				$this->po->EditValue = NULL;
			}
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// po_return
			$this->po_return->EditAttrs["class"] = "form-control";
			$this->po_return->EditCustomAttributes = "";
			$this->po_return->EditValue = HtmlEncode($this->po_return->CurrentValue);
			$curVal = strval($this->po_return->CurrentValue);
			if ($curVal <> "") {
				$this->po_return->EditValue = $this->po_return->lookupCacheOption($curVal);
				if ($this->po_return->EditValue === NULL) { // Lookup from database
					$filterWrk = "`cart_id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_return->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode(FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$arwrk[4] = HtmlEncode(FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2));
						$this->po_return->EditValue = $this->po_return->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_return->EditValue = HtmlEncode($this->po_return->CurrentValue);
					}
				}
			} else {
				$this->po_return->EditValue = NULL;
			}
			$this->po_return->PlaceHolder = RemoveHtml($this->po_return->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid_return
			$this->rid_return->EditAttrs["class"] = "form-control";
			$this->rid_return->EditCustomAttributes = "";
			if ($this->rid_return->VirtualValue <> "") {
				$this->rid_return->EditValue = $this->rid_return->VirtualValue;
			} else {
			$curVal = strval($this->rid_return->CurrentValue);
			if ($curVal <> "") {
				$this->rid_return->EditValue = $this->rid_return->lookupCacheOption($curVal);
				if ($this->rid_return->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid_return->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->rid_return->EditValue = $this->rid_return->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid_return->EditValue = $this->rid_return->CurrentValue;
					}
				}
			} else {
				$this->rid_return->EditValue = NULL;
			}
			}
			$this->rid_return->ViewCustomAttributes = "";

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if ($this->rid->VirtualValue <> "") {
				$this->rid->EditValue = $this->rid->VirtualValue;
			} else {
				$this->rid->EditValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `product_type` <> 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if ($this->lot_no->VirtualValue <> "") {
				$this->lot_no->EditValue = $this->lot_no->VirtualValue;
			} else {
				$this->lot_no->EditValue = $this->lot_no->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->lot_no->CurrentValue;
			$this->lot_no->EditValue = $this->lot_no->displayValue($arwrk);
			}
			$this->lot_no->ViewCustomAttributes = "";

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->CurrentValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
			if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
				$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -1, -2, 0);

			// net_weight
			$this->net_weight->EditAttrs["class"] = "form-control";
			$this->net_weight->EditCustomAttributes = "";
			$this->net_weight->EditValue = HtmlEncode($this->net_weight->CurrentValue);
			$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
			if (strval($this->net_weight->EditValue) <> "" && is_numeric($this->net_weight->EditValue))
				$this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, -2, -1, -2, 0);

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->CurrentValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
			if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
				$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
			if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
				$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->CurrentValue));
			if ($curVal <> "")
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return User_Site() == 0 ?  "`status`=1 and `id` > 1 && `id` != 10" : "`status`=1 and `id` > 0 && `id` != 10 and FIND_IN_SET(id, " . User_Site() . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// operator
			// rack

			$this->rack->EditAttrs["class"] = "form-control";
			$this->rack->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->rack->CurrentValue = HtmlDecode($this->rack->CurrentValue);
			$this->rack->EditValue = HtmlEncode($this->rack->CurrentValue);
			$this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

			// datetime
			// remarks

			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// goods_inward
			$this->goods_inward->EditAttrs["class"] = "form-control";
			$this->goods_inward->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->goods_inward->CurrentValue = HtmlDecode($this->goods_inward->CurrentValue);
			$this->goods_inward->EditValue = HtmlEncode($this->goods_inward->CurrentValue);
			$this->goods_inward->PlaceHolder = RemoveHtml($this->goods_inward->caption());

			// invoice_details
			$this->invoice_details->EditAttrs["class"] = "form-control";
			$this->invoice_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice_details->CurrentValue = HtmlDecode($this->invoice_details->CurrentValue);
			$this->invoice_details->EditValue = HtmlEncode($this->invoice_details->CurrentValue);
			$this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// return_details
			$this->return_details->EditAttrs["class"] = "form-control";
			$this->return_details->EditCustomAttributes = "";
			$this->return_details->EditValue = HtmlEncode($this->return_details->CurrentValue);
			$this->return_details->PlaceHolder = RemoveHtml($this->return_details->caption());

			// qc_remarks
			$this->qc_remarks->EditAttrs["class"] = "form-control";
			$this->qc_remarks->EditCustomAttributes = "";
			$this->qc_remarks->EditValue = HtmlEncode($this->qc_remarks->CurrentValue);
			$this->qc_remarks->PlaceHolder = RemoveHtml($this->qc_remarks->caption());

			// qc_status
			$this->qc_status->EditAttrs["class"] = "form-control";
			$this->qc_status->EditCustomAttributes = "";
			$this->qc_status->EditValue = HtmlEncode($this->qc_status->CurrentValue);
			$this->qc_status->PlaceHolder = RemoveHtml($this->qc_status->caption());

			// qc_operator
			$this->qc_operator->EditAttrs["class"] = "form-control";
			$this->qc_operator->EditCustomAttributes = "";
			$this->qc_operator->EditValue = HtmlEncode($this->qc_operator->CurrentValue);
			$this->qc_operator->PlaceHolder = RemoveHtml($this->qc_operator->caption());

			// qc_datetime
			$this->qc_datetime->EditAttrs["class"] = "form-control";
			$this->qc_datetime->EditCustomAttributes = "";
			$this->qc_datetime->EditValue = HtmlEncode(FormatDateTime($this->qc_datetime->CurrentValue, 8));
			$this->qc_datetime->PlaceHolder = RemoveHtml($this->qc_datetime->caption());

			// age
			$this->age->EditAttrs["class"] = "form-control";
			$this->age->EditCustomAttributes = "";
			$this->age->EditValue = HtmlEncode($this->age->CurrentValue);
			$this->age->PlaceHolder = RemoveHtml($this->age->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// supplier
			$this->supplier->LinkCustomAttributes = "";
			if (!EmptyValue($this->supplier->CurrentValue)) {
				$this->supplier->HrefValue = "purchase_llist.php?x_supplier=" . $this->supplier->CurrentValue; // Add prefix/suffix
				$this->supplier->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
			} else {
				$this->supplier->HrefValue = "";
			}
			$this->supplier->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";

			// po_return
			$this->po_return->LinkCustomAttributes = "";
			$this->po_return->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "purchase_llist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "purchase_llist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid_return
			$this->rid_return->LinkCustomAttributes = "";
			$this->rid_return->HrefValue = "";
			$this->rid_return->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "purchase_llist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "purchase_llist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "purchase_llist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// rack
			$this->rack->LinkCustomAttributes = "";
			$this->rack->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// goods_inward
			$this->goods_inward->LinkCustomAttributes = "";
			$this->goods_inward->HrefValue = "";

			// invoice_details
			$this->invoice_details->LinkCustomAttributes = "";
			if (!EmptyValue($this->invoice_details->CurrentValue)) {
				$this->invoice_details->HrefValue = "purchase_llist.php?x_invoice_details=" . $this->invoice_details->CurrentValue; // Add prefix/suffix
				$this->invoice_details->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->invoice_details->HrefValue = FullUrl($this->invoice_details->HrefValue, "href");
			} else {
				$this->invoice_details->HrefValue = "";
			}

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// return_details
			$this->return_details->LinkCustomAttributes = "";
			$this->return_details->HrefValue = "";

			// qc_remarks
			$this->qc_remarks->LinkCustomAttributes = "";
			$this->qc_remarks->HrefValue = "";

			// qc_status
			$this->qc_status->LinkCustomAttributes = "";
			$this->qc_status->HrefValue = "";

			// qc_operator
			$this->qc_operator->LinkCustomAttributes = "";
			$this->qc_operator->HrefValue = "";

			// qc_datetime
			$this->qc_datetime->LinkCustomAttributes = "";
			$this->qc_datetime->HrefValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->supplier->Required) {
			if (!$this->supplier->IsDetailKey && $this->supplier->FormValue != NULL && $this->supplier->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->po_return->Required) {
			if (!$this->po_return->IsDetailKey && $this->po_return->FormValue != NULL && $this->po_return->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_return->caption(), $this->po_return->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po_return->FormValue)) {
			AddMessage($FormError, $this->po_return->errorMessage());
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid_return->Required) {
			if (!$this->rid_return->IsDetailKey && $this->rid_return->FormValue != NULL && $this->rid_return->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_return->caption(), $this->rid_return->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->avg_quantity->Required) {
			if (!$this->avg_quantity->IsDetailKey && $this->avg_quantity->FormValue != NULL && $this->avg_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->avg_quantity->caption(), $this->avg_quantity->RequiredErrorMessage));
			}
		}
		if ($this->packets->Required) {
			if (!$this->packets->IsDetailKey && $this->packets->FormValue != NULL && $this->packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->packets->FormValue)) {
			AddMessage($FormError, $this->packets->errorMessage());
		}
		if ($this->net_weight->Required) {
			if (!$this->net_weight->IsDetailKey && $this->net_weight->FormValue != NULL && $this->net_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->net_weight->caption(), $this->net_weight->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->net_weight->FormValue)) {
			AddMessage($FormError, $this->net_weight->errorMessage());
		}
		if ($this->_40->Required) {
			if (!$this->_40->IsDetailKey && $this->_40->FormValue != NULL && $this->_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->_40->FormValue)) {
			AddMessage($FormError, $this->_40->errorMessage());
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount->FormValue)) {
			AddMessage($FormError, $this->amount->errorMessage());
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dated->FormValue)) {
			AddMessage($FormError, $this->dated->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->rack->Required) {
			if (!$this->rack->IsDetailKey && $this->rack->FormValue != NULL && $this->rack->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rack->caption(), $this->rack->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->goods_inward->Required) {
			if (!$this->goods_inward->IsDetailKey && $this->goods_inward->FormValue != NULL && $this->goods_inward->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->goods_inward->caption(), $this->goods_inward->RequiredErrorMessage));
			}
		}
		if ($this->invoice_details->Required) {
			if (!$this->invoice_details->IsDetailKey && $this->invoice_details->FormValue != NULL && $this->invoice_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_details->caption(), $this->invoice_details->RequiredErrorMessage));
			}
		}
		if ($this->invoice_dated->Required) {
			if (!$this->invoice_dated->IsDetailKey && $this->invoice_dated->FormValue != NULL && $this->invoice_dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_dated->caption(), $this->invoice_dated->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->country->Required) {
			if (!$this->country->IsDetailKey && $this->country->FormValue != NULL && $this->country->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
			}
		}
		if ($this->wool_type->Required) {
			if (!$this->wool_type->IsDetailKey && $this->wool_type->FormValue != NULL && $this->wool_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wool_type->caption(), $this->wool_type->RequiredErrorMessage));
			}
		}
		if ($this->quality->Required) {
			if (!$this->quality->IsDetailKey && $this->quality->FormValue != NULL && $this->quality->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quality->caption(), $this->quality->RequiredErrorMessage));
			}
		}
		if ($this->sorting_type->Required) {
			if (!$this->sorting_type->IsDetailKey && $this->sorting_type->FormValue != NULL && $this->sorting_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sorting_type->caption(), $this->sorting_type->RequiredErrorMessage));
			}
		}
		if ($this->scouring_type->Required) {
			if (!$this->scouring_type->IsDetailKey && $this->scouring_type->FormValue != NULL && $this->scouring_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->scouring_type->caption(), $this->scouring_type->RequiredErrorMessage));
			}
		}
		if ($this->dye_type->Required) {
			if (!$this->dye_type->IsDetailKey && $this->dye_type->FormValue != NULL && $this->dye_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dye_type->caption(), $this->dye_type->RequiredErrorMessage));
			}
		}
		if ($this->importer->Required) {
			if (!$this->importer->IsDetailKey && $this->importer->FormValue != NULL && $this->importer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->importer->caption(), $this->importer->RequiredErrorMessage));
			}
		}
		if ($this->grade->Required) {
			if (!$this->grade->IsDetailKey && $this->grade->FormValue != NULL && $this->grade->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grade->caption(), $this->grade->RequiredErrorMessage));
			}
		}
		if ($this->return_details->Required) {
			if (!$this->return_details->IsDetailKey && $this->return_details->FormValue != NULL && $this->return_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->return_details->caption(), $this->return_details->RequiredErrorMessage));
			}
		}
		if ($this->audit->Required) {
			if (!$this->audit->IsDetailKey && $this->audit->FormValue != NULL && $this->audit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->audit->caption(), $this->audit->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->agent->Required) {
			if (!$this->agent->IsDetailKey && $this->agent->FormValue != NULL && $this->agent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
			}
		}
		if ($this->qc_remarks->Required) {
			if (!$this->qc_remarks->IsDetailKey && $this->qc_remarks->FormValue != NULL && $this->qc_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_remarks->caption(), $this->qc_remarks->RequiredErrorMessage));
			}
		}
		if ($this->qc_status->Required) {
			if (!$this->qc_status->IsDetailKey && $this->qc_status->FormValue != NULL && $this->qc_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_status->caption(), $this->qc_status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->qc_status->FormValue)) {
			AddMessage($FormError, $this->qc_status->errorMessage());
		}
		if ($this->qc_operator->Required) {
			if (!$this->qc_operator->IsDetailKey && $this->qc_operator->FormValue != NULL && $this->qc_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_operator->caption(), $this->qc_operator->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->qc_operator->FormValue)) {
			AddMessage($FormError, $this->qc_operator->errorMessage());
		}
		if ($this->qc_datetime->Required) {
			if (!$this->qc_datetime->IsDetailKey && $this->qc_datetime->FormValue != NULL && $this->qc_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_datetime->caption(), $this->qc_datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->qc_datetime->FormValue)) {
			AddMessage($FormError, $this->qc_datetime->errorMessage());
		}
		if ($this->age->Required) {
			if (!$this->age->IsDetailKey && $this->age->FormValue != NULL && $this->age->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->age->caption(), $this->age->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->age->FormValue)) {
			AddMessage($FormError, $this->age->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// po
			$this->po->setDbValueDef($rsnew, $this->po->CurrentValue, NULL, $this->po->ReadOnly);

			// po_return
			$this->po_return->setDbValueDef($rsnew, $this->po_return->CurrentValue, NULL, $this->po_return->ReadOnly);

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, 0, $this->company_id->ReadOnly);

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, 0, $this->packing_type->ReadOnly);

			// packets
			$this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, NULL, $this->packets->ReadOnly);

			// net_weight
			$this->net_weight->setDbValueDef($rsnew, $this->net_weight->CurrentValue, NULL, $this->net_weight->ReadOnly);

			// @
			$this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, NULL, $this->_40->ReadOnly);

			// amount
			$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, NULL, $this->amount->ReadOnly);

			// godown
			$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, NULL, $this->godown->ReadOnly);

			// dated
			$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 0), NULL, $this->dated->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// rack
			$this->rack->setDbValueDef($rsnew, $this->rack->CurrentValue, NULL, $this->rack->ReadOnly);

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// goods_inward
			$this->goods_inward->setDbValueDef($rsnew, $this->goods_inward->CurrentValue, NULL, $this->goods_inward->ReadOnly);

			// invoice_details
			$this->invoice_details->setDbValueDef($rsnew, $this->invoice_details->CurrentValue, "", $this->invoice_details->ReadOnly);

			// return_details
			$this->return_details->setDbValueDef($rsnew, $this->return_details->CurrentValue, NULL, $this->return_details->ReadOnly);

			// qc_remarks
			$this->qc_remarks->setDbValueDef($rsnew, $this->qc_remarks->CurrentValue, NULL, $this->qc_remarks->ReadOnly);

			// qc_status
			$this->qc_status->setDbValueDef($rsnew, $this->qc_status->CurrentValue, NULL, $this->qc_status->ReadOnly);

			// qc_operator
			$this->qc_operator->setDbValueDef($rsnew, $this->qc_operator->CurrentValue, NULL, $this->qc_operator->ReadOnly);

			// qc_datetime
			$this->qc_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->qc_datetime->CurrentValue, 0), NULL, $this->qc_datetime->ReadOnly);

			// age
			$this->age->setDbValueDef($rsnew, $this->age->CurrentValue, 0, $this->age->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchase_llist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_type":
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`grp`=80 and `id` != 74 and `status` =1" : "`grp`=80 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_supplier":
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`partner_type` = 1 and `status` = 1" : "`partner_type` < 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_po":
					$lookupFilter = function() {
						return (CurrentPageID() == "add")  ? "`pending_qty` > 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return "`category`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` = 1 and `product_type` <> 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return User_Site() == 0 ?  "`status`=1 and `id` > 1 && `id` != 10" : "`status`=1 and `id` > 0 && `id` != 10 and FIND_IN_SET(id, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_operator":
					$lookupFilter = function() {
						return "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_sorting_type":
					$lookupFilter = function() {
						return "`process` = 11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_scouring_type":
					$lookupFilter = function() {
						return "`process`=12";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_importer":
					$lookupFilter = function() {
						return "`grp` = 1 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_type":
							break;
						case "x_supplier":
							break;
						case "x_po":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_po_return":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid_return":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_lot_no":
							break;
						case "x_godown":
							break;
						case "x_operator":
							break;
						case "x_sorting_type":
							break;
						case "x_scouring_type":
							break;
						case "x_importer":
							break;
						case "x_agent":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'purchase_l');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		extract($_POST,EXTR_OVERWRITE);
		$_SESSION[SESSION_MESSAGE] = '';
		if (($x_type != 73) && (($x_rid == '') || is_null($x_rid))) 
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= 'Please Select Required Field Code';
			return false;
			}
		if (($x_type == 73) && (($x_rid_return == '') || is_null($x_rid_return))) 
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= 'Please Select Required Field Code';
			return false;
			}
	return TRUE;
	}
}
?>