<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for qc
 */
class qc extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $location;
	public $qc_stage;
	public $_barcode;
	public $lines_in_30cm;
	public $size_actual;
	public $weight_actual;
	public $defect_nature;
	public $defect_percentage;
	public $deduction;
	public $comments;
	public $status;
	public $operator;
	public $datetime;
	public $e_operator;
	public $e_datetime;
	public $_action;
	public $remarks;
	public $design;
	public $size;
	public $a_operator;
	public $a_datetime;
	public $uid;
	public $bcode_status;
	public $product_image;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'qc';
		$this->TableName = 'qc';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`qc`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('qc', 'qc', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// location
		$this->location = new DbField('qc', 'qc', 'x_location', 'location', '`location`', '`location`', 18, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->Nullable = FALSE; // NOT NULL field
		$this->location->Required = TRUE; // Required field
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->location->Lookup = new Lookup('location', 'godown', TRUE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// qc_stage
		$this->qc_stage = new DbField('qc', 'qc', 'x_qc_stage', 'qc_stage', '`qc_stage`', '`qc_stage`', 17, -1, FALSE, '`qc_stage`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->qc_stage->Nullable = FALSE; // NOT NULL field
		$this->qc_stage->Required = TRUE; // Required field
		$this->qc_stage->Sortable = TRUE; // Allow sort
		$this->qc_stage->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->qc_stage->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->qc_stage->Lookup = new Lookup('qc_stage', 'qc_items', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->qc_stage->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['qc_stage'] = &$this->qc_stage;

		// barcode
		$this->_barcode = new DbField('qc', 'qc', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Nullable = FALSE; // NOT NULL field
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['barcode'] = &$this->_barcode;

		// lines_in_30cm
		$this->lines_in_30cm = new DbField('qc', 'qc', 'x_lines_in_30cm', 'lines_in_30cm', '`lines_in_30cm`', '`lines_in_30cm`', 131, -1, FALSE, '`lines_in_30cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lines_in_30cm->Sortable = TRUE; // Allow sort
		$this->lines_in_30cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['lines_in_30cm'] = &$this->lines_in_30cm;

		// size_actual
		$this->size_actual = new DbField('qc', 'qc', 'x_size_actual', 'size_actual', '`size_actual`', '`size_actual`', 200, -1, FALSE, '`size_actual`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_actual->Required = TRUE; // Required field
		$this->size_actual->Sortable = TRUE; // Allow sort
		$this->fields['size_actual'] = &$this->size_actual;

		// weight_actual
		$this->weight_actual = new DbField('qc', 'qc', 'x_weight_actual', 'weight_actual', '`weight_actual`', '`weight_actual`', 131, -1, FALSE, '`weight_actual`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weight_actual->Sortable = TRUE; // Allow sort
		$this->weight_actual->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['weight_actual'] = &$this->weight_actual;

		// defect_nature
		$this->defect_nature = new DbField('qc', 'qc', 'x_defect_nature', 'defect_nature', '`defect_nature`', '`defect_nature`', 200, -1, FALSE, '`defect_nature`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->defect_nature->Nullable = FALSE; // NOT NULL field
		$this->defect_nature->Required = TRUE; // Required field
		$this->defect_nature->Sortable = TRUE; // Allow sort
		$this->defect_nature->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->defect_nature->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->defect_nature->Lookup = new Lookup('defect_nature', 'qc_items', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->fields['defect_nature'] = &$this->defect_nature;

		// defect_percentage
		$this->defect_percentage = new DbField('qc', 'qc', 'x_defect_percentage', 'defect_percentage', '`defect_percentage`', '`defect_percentage`', 17, -1, FALSE, '`defect_percentage`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->defect_percentage->Required = TRUE; // Required field
		$this->defect_percentage->Sortable = TRUE; // Allow sort
		$this->defect_percentage->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->defect_percentage->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->defect_percentage->Lookup = new Lookup('defect_percentage', 'qc_items', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->defect_percentage->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['defect_percentage'] = &$this->defect_percentage;

		// deduction
		$this->deduction = new DbField('qc', 'qc', 'x_deduction', 'deduction', '`deduction`', '`deduction`', 18, -1, FALSE, '`deduction`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->deduction->Required = TRUE; // Required field
		$this->deduction->Sortable = TRUE; // Allow sort
		$this->deduction->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['deduction'] = &$this->deduction;

		// comments
		$this->comments = new DbField('qc', 'qc', 'x_comments', 'comments', '`comments`', '`comments`', 200, -1, FALSE, '`comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->comments->Sortable = TRUE; // Allow sort
		$this->fields['comments'] = &$this->comments;

		// status
		$this->status = new DbField('qc', 'qc', 'x_status', 'status', '`status`', '`status`', 18, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'qc_items', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('qc', 'qc', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('qc', 'qc', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 117, "DB"), 135, 117, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// e_operator
		$this->e_operator = new DbField('qc', 'qc', 'x_e_operator', 'e_operator', '`e_operator`', '`e_operator`', 18, -1, FALSE, '`e_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->e_operator->Sortable = TRUE; // Allow sort
		$this->e_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->e_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->e_operator->Lookup = new Lookup('e_operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->e_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['e_operator'] = &$this->e_operator;

		// e_datetime
		$this->e_datetime = new DbField('qc', 'qc', 'x_e_datetime', 'e_datetime', '`e_datetime`', CastDateFieldForLike('`e_datetime`', 117, "DB"), 135, 117, FALSE, '`e_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->e_datetime->Sortable = TRUE; // Allow sort
		$this->e_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['e_datetime'] = &$this->e_datetime;

		// action
		$this->_action = new DbField('qc', 'qc', 'x__action', 'action', '`action`', '`action`', 17, -1, FALSE, '`action`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_action->Sortable = TRUE; // Allow sort
		$this->_action->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['action'] = &$this->_action;

		// remarks
		$this->remarks = new DbField('qc', 'qc', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// design
		$this->design = new DbField('qc', 'qc', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Sortable = TRUE; // Allow sort
		$this->fields['design'] = &$this->design;

		// size
		$this->size = new DbField('qc', 'qc', 'x_size', 'size', '`size`', '`size`', 200, -1, FALSE, '`size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size->Sortable = TRUE; // Allow sort
		$this->fields['size'] = &$this->size;

		// a_operator
		$this->a_operator = new DbField('qc', 'qc', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin', FALSE, 'id', ["id","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('qc', 'qc', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 117, "DB"), 135, 117, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = TRUE; // Allow sort
		$this->a_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['a_datetime'] = &$this->a_datetime;

		// uid
		$this->uid = new DbField('qc', 'qc', 'x_uid', 'uid', '`uid`', '`uid`', 200, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->uid->Sortable = FALSE; // Allow sort
		$this->fields['uid'] = &$this->uid;

		// bcode_status
		$this->bcode_status = new DbField('qc', 'qc', 'x_bcode_status', 'bcode_status', '`bcode_status`', '`bcode_status`', 2, -1, FALSE, '`bcode_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bcode_status->Sortable = TRUE; // Allow sort
		$this->bcode_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['bcode_status'] = &$this->bcode_status;

		// product_image
		$this->product_image = new DbField('qc', 'qc', 'x_product_image', 'product_image', '`product_image`', '`product_image`', 200, -1, FALSE, '`product_image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_image->Sortable = TRUE; // Allow sort
		$this->fields['product_image'] = &$this->product_image;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`qc`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`operator` = " .  CurrentUserID();
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->location->DbValue = $row['location'];
		$this->qc_stage->DbValue = $row['qc_stage'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->lines_in_30cm->DbValue = $row['lines_in_30cm'];
		$this->size_actual->DbValue = $row['size_actual'];
		$this->weight_actual->DbValue = $row['weight_actual'];
		$this->defect_nature->DbValue = $row['defect_nature'];
		$this->defect_percentage->DbValue = $row['defect_percentage'];
		$this->deduction->DbValue = $row['deduction'];
		$this->comments->DbValue = $row['comments'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->e_operator->DbValue = $row['e_operator'];
		$this->e_datetime->DbValue = $row['e_datetime'];
		$this->_action->DbValue = $row['action'];
		$this->remarks->DbValue = $row['remarks'];
		$this->design->DbValue = $row['design'];
		$this->size->DbValue = $row['size'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->uid->DbValue = $row['uid'];
		$this->bcode_status->DbValue = $row['bcode_status'];
		$this->product_image->DbValue = $row['product_image'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "qclist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "qcview.php")
			return $Language->phrase("View");
		elseif ($pageName == "qcedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "qcadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "qclist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("qcview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("qcview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "qcadd.php?" . $this->getUrlParm($parm);
		else
			$url = "qcadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("qcedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("qcadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("qcdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->location->setDbValue($rs->fields('location'));
		$this->qc_stage->setDbValue($rs->fields('qc_stage'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->lines_in_30cm->setDbValue($rs->fields('lines_in_30cm'));
		$this->size_actual->setDbValue($rs->fields('size_actual'));
		$this->weight_actual->setDbValue($rs->fields('weight_actual'));
		$this->defect_nature->setDbValue($rs->fields('defect_nature'));
		$this->defect_percentage->setDbValue($rs->fields('defect_percentage'));
		$this->deduction->setDbValue($rs->fields('deduction'));
		$this->comments->setDbValue($rs->fields('comments'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->e_operator->setDbValue($rs->fields('e_operator'));
		$this->e_datetime->setDbValue($rs->fields('e_datetime'));
		$this->_action->setDbValue($rs->fields('action'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->design->setDbValue($rs->fields('design'));
		$this->size->setDbValue($rs->fields('size'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->uid->setDbValue($rs->fields('uid'));
		$this->bcode_status->setDbValue($rs->fields('bcode_status'));
		$this->product_image->setDbValue($rs->fields('product_image'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// location
		// qc_stage
		// barcode
		// lines_in_30cm
		// size_actual
		// weight_actual
		// defect_nature
		// defect_percentage
		// deduction

		$this->deduction->CellCssStyle = "white-space: nowrap;";

		// comments
		// status
		// operator
		// datetime
		// e_operator
		// e_datetime
		// action
		// remarks
		// design
		// size
		// a_operator
		// a_datetime
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// bcode_status
		// product_image
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// location
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// qc_stage
		$curVal = strval($this->qc_stage->CurrentValue);
		if ($curVal <> "") {
			$this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
			if ($this->qc_stage->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 2 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->qc_stage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->qc_stage->ViewValue = $this->qc_stage->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->qc_stage->ViewValue = $this->qc_stage->CurrentValue;
				}
			}
		} else {
			$this->qc_stage->ViewValue = NULL;
		}
		$this->qc_stage->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, 0, 0, 0);
		$this->_barcode->ViewCustomAttributes = "";

		// lines_in_30cm
		$this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
		$this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, 2, -2, -2, -2);
		$this->lines_in_30cm->ViewCustomAttributes = "";

		// size_actual
		$this->size_actual->ViewValue = $this->size_actual->CurrentValue;
		$this->size_actual->ViewCustomAttributes = "";

		// weight_actual
		$this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
		$this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, 2, -2, -2, -2);
		$this->weight_actual->ViewCustomAttributes = "";

		// defect_nature
		$curVal = strval($this->defect_nature->CurrentValue);
		if ($curVal <> "") {
			$this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
			if ($this->defect_nature->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 3 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->defect_nature->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->defect_nature->ViewValue = $this->defect_nature->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->defect_nature->ViewValue = $this->defect_nature->CurrentValue;
				}
			}
		} else {
			$this->defect_nature->ViewValue = NULL;
		}
		$this->defect_nature->ViewCustomAttributes = "";

		// defect_percentage
		$curVal = strval($this->defect_percentage->CurrentValue);
		if ($curVal <> "") {
			$this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
			if ($this->defect_percentage->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 4 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->defect_percentage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->defect_percentage->ViewValue = $this->defect_percentage->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->defect_percentage->ViewValue = $this->defect_percentage->CurrentValue;
				}
			}
		} else {
			$this->defect_percentage->ViewValue = NULL;
		}
		$this->defect_percentage->ViewCustomAttributes = "";

		// deduction
		$this->deduction->ViewValue = $this->deduction->CurrentValue;
		$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 0, -2, -2, -2);
		$this->deduction->ViewCustomAttributes = "";

		// comments
		$this->comments->ViewValue = $this->comments->CurrentValue;
		$this->comments->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 5 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 117);
		$this->datetime->ViewCustomAttributes = "";

		// e_operator
		$curVal = strval($this->e_operator->CurrentValue);
		if ($curVal <> "") {
			$this->e_operator->ViewValue = $this->e_operator->lookupCacheOption($curVal);
			if ($this->e_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->e_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->e_operator->ViewValue = $this->e_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->e_operator->ViewValue = $this->e_operator->CurrentValue;
				}
			}
		} else {
			$this->e_operator->ViewValue = NULL;
		}
		$this->e_operator->ViewCustomAttributes = "";

		// e_datetime
		$this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
		$this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, 117);
		$this->e_datetime->ViewCustomAttributes = "";

		// action
		$this->_action->ViewValue = $this->_action->CurrentValue;
		$this->_action->ViewValue = FormatNumber($this->_action->ViewValue, 0, -2, -2, -2);
		$this->_action->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$this->design->ViewCustomAttributes = "";

		// size
		$this->size->ViewValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 117);
		$this->a_datetime->ViewCustomAttributes = "";

		// uid
		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// bcode_status
		$this->bcode_status->ViewValue = $this->bcode_status->CurrentValue;
		$this->bcode_status->ViewValue = FormatNumber($this->bcode_status->ViewValue, 0, -2, -2, -2);
		$this->bcode_status->ViewCustomAttributes = "";

		// product_image
		$this->product_image->ViewValue = $this->product_image->CurrentValue;
		$this->product_image->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// qc_stage
		$this->qc_stage->LinkCustomAttributes = "";
		$this->qc_stage->HrefValue = "";
		$this->qc_stage->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// lines_in_30cm
		$this->lines_in_30cm->LinkCustomAttributes = "";
		$this->lines_in_30cm->HrefValue = "";
		$this->lines_in_30cm->TooltipValue = "";

		// size_actual
		$this->size_actual->LinkCustomAttributes = "";
		$this->size_actual->HrefValue = "";
		$this->size_actual->TooltipValue = "";

		// weight_actual
		$this->weight_actual->LinkCustomAttributes = "";
		$this->weight_actual->HrefValue = "";
		$this->weight_actual->TooltipValue = "";

		// defect_nature
		$this->defect_nature->LinkCustomAttributes = "";
		$this->defect_nature->HrefValue = "";
		$this->defect_nature->TooltipValue = "";

		// defect_percentage
		$this->defect_percentage->LinkCustomAttributes = "";
		$this->defect_percentage->HrefValue = "";
		$this->defect_percentage->TooltipValue = "";

		// deduction
		$this->deduction->LinkCustomAttributes = "";
		$this->deduction->HrefValue = "";
		$this->deduction->TooltipValue = "";

		// comments
		$this->comments->LinkCustomAttributes = "";
		$this->comments->HrefValue = "";
		$this->comments->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// e_operator
		$this->e_operator->LinkCustomAttributes = "";
		$this->e_operator->HrefValue = "";
		$this->e_operator->TooltipValue = "";

		// e_datetime
		$this->e_datetime->LinkCustomAttributes = "";
		$this->e_datetime->HrefValue = "";
		$this->e_datetime->TooltipValue = "";

		// action
		$this->_action->LinkCustomAttributes = "";
		$this->_action->HrefValue = "";
		$this->_action->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// size
		$this->size->LinkCustomAttributes = "";
		$this->size->HrefValue = "";
		$this->size->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// bcode_status
		$this->bcode_status->LinkCustomAttributes = "";
		$this->bcode_status->HrefValue = "";
		$this->bcode_status->TooltipValue = "";

		// product_image
		$this->product_image->LinkCustomAttributes = "";
		$this->product_image->HrefValue = "";
		$this->product_image->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";

		// qc_stage
		$this->qc_stage->EditAttrs["class"] = "form-control";
		$this->qc_stage->EditCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, 0, 0, 0, 0);
		$this->_barcode->ViewCustomAttributes = "";

		// lines_in_30cm
		$this->lines_in_30cm->EditAttrs["class"] = "form-control";
		$this->lines_in_30cm->EditCustomAttributes = "";
		$this->lines_in_30cm->EditValue = $this->lines_in_30cm->CurrentValue;
		$this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());
		if (strval($this->lines_in_30cm->EditValue) <> "" && is_numeric($this->lines_in_30cm->EditValue))
			$this->lines_in_30cm->EditValue = FormatNumber($this->lines_in_30cm->EditValue, -2, -2, -2, -2);

		// size_actual
		$this->size_actual->EditAttrs["class"] = "form-control";
		$this->size_actual->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_actual->CurrentValue = HtmlDecode($this->size_actual->CurrentValue);
		$this->size_actual->EditValue = $this->size_actual->CurrentValue;
		$this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

		// weight_actual
		$this->weight_actual->EditAttrs["class"] = "form-control";
		$this->weight_actual->EditCustomAttributes = "";
		$this->weight_actual->EditValue = $this->weight_actual->CurrentValue;
		$this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());
		if (strval($this->weight_actual->EditValue) <> "" && is_numeric($this->weight_actual->EditValue))
			$this->weight_actual->EditValue = FormatNumber($this->weight_actual->EditValue, -2, -2, -2, -2);

		// defect_nature
		$this->defect_nature->EditAttrs["class"] = "form-control";
		$this->defect_nature->EditCustomAttributes = "";

		// defect_percentage
		$this->defect_percentage->EditAttrs["class"] = "form-control";
		$this->defect_percentage->EditCustomAttributes = "";

		// deduction
		$this->deduction->EditAttrs["class"] = "form-control";
		$this->deduction->EditCustomAttributes = "";
		$this->deduction->EditValue = $this->deduction->CurrentValue;
		$this->deduction->EditValue = FormatNumber($this->deduction->EditValue, 0, -2, -2, -2);
		$this->deduction->ViewCustomAttributes = "";

		// comments
		$this->comments->EditAttrs["class"] = "form-control";
		$this->comments->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->comments->CurrentValue = HtmlDecode($this->comments->CurrentValue);
		$this->comments->EditValue = $this->comments->CurrentValue;
		$this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// operator
		// datetime
		// e_operator
		// e_datetime
		// action

		$this->_action->EditAttrs["class"] = "form-control";
		$this->_action->EditCustomAttributes = "";
		$this->_action->EditValue = $this->_action->CurrentValue;
		$this->_action->PlaceHolder = RemoveHtml($this->_action->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->PlaceHolder = RemoveHtml($this->design->caption());

		// size
		$this->size->EditAttrs["class"] = "form-control";
		$this->size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
		$this->size->EditValue = $this->size->CurrentValue;
		$this->size->PlaceHolder = RemoveHtml($this->size->caption());

		// a_operator
		// a_datetime
		// uid

		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

		// bcode_status
		$this->bcode_status->EditAttrs["class"] = "form-control";
		$this->bcode_status->EditCustomAttributes = "";
		$this->bcode_status->EditValue = $this->bcode_status->CurrentValue;
		$this->bcode_status->PlaceHolder = RemoveHtml($this->bcode_status->caption());

		// product_image
		$this->product_image->EditAttrs["class"] = "form-control";
		$this->product_image->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_image->CurrentValue = HtmlDecode($this->product_image->CurrentValue);
		$this->product_image->EditValue = $this->product_image->CurrentValue;
		$this->product_image->PlaceHolder = RemoveHtml($this->product_image->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->qc_stage);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->lines_in_30cm);
					$doc->exportCaption($this->size_actual);
					$doc->exportCaption($this->weight_actual);
					$doc->exportCaption($this->defect_nature);
					$doc->exportCaption($this->defect_percentage);
					$doc->exportCaption($this->deduction);
					$doc->exportCaption($this->comments);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->e_operator);
					$doc->exportCaption($this->e_datetime);
					$doc->exportCaption($this->_action);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->bcode_status);
					$doc->exportCaption($this->product_image);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->qc_stage);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->lines_in_30cm);
					$doc->exportCaption($this->size_actual);
					$doc->exportCaption($this->weight_actual);
					$doc->exportCaption($this->defect_nature);
					$doc->exportCaption($this->defect_percentage);
					$doc->exportCaption($this->deduction);
					$doc->exportCaption($this->comments);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->e_operator);
					$doc->exportCaption($this->e_datetime);
					$doc->exportCaption($this->_action);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->bcode_status);
					$doc->exportCaption($this->product_image);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->location);
						$doc->exportField($this->qc_stage);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->lines_in_30cm);
						$doc->exportField($this->size_actual);
						$doc->exportField($this->weight_actual);
						$doc->exportField($this->defect_nature);
						$doc->exportField($this->defect_percentage);
						$doc->exportField($this->deduction);
						$doc->exportField($this->comments);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->e_operator);
						$doc->exportField($this->e_datetime);
						$doc->exportField($this->_action);
						$doc->exportField($this->remarks);
						$doc->exportField($this->design);
						$doc->exportField($this->size);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->bcode_status);
						$doc->exportField($this->product_image);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->location);
						$doc->exportField($this->qc_stage);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->lines_in_30cm);
						$doc->exportField($this->size_actual);
						$doc->exportField($this->weight_actual);
						$doc->exportField($this->defect_nature);
						$doc->exportField($this->defect_percentage);
						$doc->exportField($this->deduction);
						$doc->exportField($this->comments);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->e_operator);
						$doc->exportField($this->e_datetime);
						$doc->exportField($this->_action);
						$doc->exportField($this->remarks);
						$doc->exportField($this->design);
						$doc->exportField($this->size);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->bcode_status);
						$doc->exportField($this->product_image);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>