<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class qc_authorised_edit extends qc_authorised
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'qc_authorised';

	// Page object name
	public $PageObjName = "qc_authorised_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (qc_authorised)
		if (!isset($GLOBALS["qc_authorised"]) || get_class($GLOBALS["qc_authorised"]) == PROJECT_NAMESPACE . "qc_authorised") {
			$GLOBALS["qc_authorised"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["qc_authorised"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'qc_authorised');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $qc_authorised;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($qc_authorised);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "qc_authorisedview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("qc_authorisedlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->location->setVisibility();
		$this->_barcode->setVisibility();
		$this->defect_nature->setVisibility();
		$this->qc_stage->setVisibility();
		$this->defect_percentage->setVisibility();
		$this->deduction->setVisibility();
		$this->comments->setVisibility();
		$this->design->setVisibility();
		$this->size->setVisibility();
		$this->status->setVisibility();
		$this->remarks->setVisibility();
		$this->_action->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->a_operator->setVisibility();
		$this->a_datetime->setVisibility();
		$this->bcode_status->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->location->Required = FALSE;
		$this->_barcode->Required = FALSE;
		$this->defect_nature->Required = FALSE;
		$this->qc_stage->Required = FALSE;
		$this->defect_percentage->Required = FALSE;
		$this->status->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->defect_nature);
		$this->setupLookupOptions($this->qc_stage);
		$this->setupLookupOptions($this->defect_percentage);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->_action);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("qc_authorisedlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "qc_authorisedlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'location' first before field var 'x_location'
		$val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
		if (!$this->location->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->location->Visible = FALSE; // Disable update for API request
			else
				$this->location->setFormValue($val);
		}

		// Check field name 'barcode' first before field var 'x__barcode'
		$val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
		if (!$this->_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->_barcode->setFormValue($val);
		}

		// Check field name 'defect_nature' first before field var 'x_defect_nature'
		$val = $CurrentForm->hasValue("defect_nature") ? $CurrentForm->getValue("defect_nature") : $CurrentForm->getValue("x_defect_nature");
		if (!$this->defect_nature->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->defect_nature->Visible = FALSE; // Disable update for API request
			else
				$this->defect_nature->setFormValue($val);
		}

		// Check field name 'qc_stage' first before field var 'x_qc_stage'
		$val = $CurrentForm->hasValue("qc_stage") ? $CurrentForm->getValue("qc_stage") : $CurrentForm->getValue("x_qc_stage");
		if (!$this->qc_stage->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qc_stage->Visible = FALSE; // Disable update for API request
			else
				$this->qc_stage->setFormValue($val);
		}

		// Check field name 'defect_percentage' first before field var 'x_defect_percentage'
		$val = $CurrentForm->hasValue("defect_percentage") ? $CurrentForm->getValue("defect_percentage") : $CurrentForm->getValue("x_defect_percentage");
		if (!$this->defect_percentage->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->defect_percentage->Visible = FALSE; // Disable update for API request
			else
				$this->defect_percentage->setFormValue($val);
		}

		// Check field name 'deduction' first before field var 'x_deduction'
		$val = $CurrentForm->hasValue("deduction") ? $CurrentForm->getValue("deduction") : $CurrentForm->getValue("x_deduction");
		if (!$this->deduction->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->deduction->Visible = FALSE; // Disable update for API request
			else
				$this->deduction->setFormValue($val);
		}

		// Check field name 'comments' first before field var 'x_comments'
		$val = $CurrentForm->hasValue("comments") ? $CurrentForm->getValue("comments") : $CurrentForm->getValue("x_comments");
		if (!$this->comments->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->comments->Visible = FALSE; // Disable update for API request
			else
				$this->comments->setFormValue($val);
		}

		// Check field name 'design' first before field var 'x_design'
		$val = $CurrentForm->hasValue("design") ? $CurrentForm->getValue("design") : $CurrentForm->getValue("x_design");
		if (!$this->design->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->design->Visible = FALSE; // Disable update for API request
			else
				$this->design->setFormValue($val);
		}

		// Check field name 'size' first before field var 'x_size'
		$val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
		if (!$this->size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size->Visible = FALSE; // Disable update for API request
			else
				$this->size->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name '_action' first before field var 'x__action'
		$val = $CurrentForm->hasValue("_action") ? $CurrentForm->getValue("_action") : $CurrentForm->getValue("x__action");
		if (!$this->_action->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_action->Visible = FALSE; // Disable update for API request
			else
				$this->_action->setFormValue($val);
		}

		// Check field name 'a_operator' first before field var 'x_a_operator'
		$val = $CurrentForm->hasValue("a_operator") ? $CurrentForm->getValue("a_operator") : $CurrentForm->getValue("x_a_operator");
		if (!$this->a_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->a_operator->Visible = FALSE; // Disable update for API request
			else
				$this->a_operator->setFormValue($val);
		}

		// Check field name 'a_datetime' first before field var 'x_a_datetime'
		$val = $CurrentForm->hasValue("a_datetime") ? $CurrentForm->getValue("a_datetime") : $CurrentForm->getValue("x_a_datetime");
		if (!$this->a_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->a_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->a_datetime->setFormValue($val);
			$this->a_datetime->CurrentValue = UnFormatDateTime($this->a_datetime->CurrentValue, 117);
		}

		// Check field name 'bcode_status' first before field var 'x_bcode_status'
		$val = $CurrentForm->hasValue("bcode_status") ? $CurrentForm->getValue("bcode_status") : $CurrentForm->getValue("x_bcode_status");
		if (!$this->bcode_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bcode_status->Visible = FALSE; // Disable update for API request
			else
				$this->bcode_status->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->location->CurrentValue = $this->location->FormValue;
		$this->_barcode->CurrentValue = $this->_barcode->FormValue;
		$this->defect_nature->CurrentValue = $this->defect_nature->FormValue;
		$this->qc_stage->CurrentValue = $this->qc_stage->FormValue;
		$this->defect_percentage->CurrentValue = $this->defect_percentage->FormValue;
		$this->deduction->CurrentValue = $this->deduction->FormValue;
		$this->comments->CurrentValue = $this->comments->FormValue;
		$this->design->CurrentValue = $this->design->FormValue;
		$this->size->CurrentValue = $this->size->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->_action->CurrentValue = $this->_action->FormValue;
		$this->a_operator->CurrentValue = $this->a_operator->FormValue;
		$this->a_datetime->CurrentValue = $this->a_datetime->FormValue;
		$this->a_datetime->CurrentValue = UnFormatDateTime($this->a_datetime->CurrentValue, 117);
		$this->bcode_status->CurrentValue = $this->bcode_status->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->location->setDbValue($row['location']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->defect_nature->setDbValue($row['defect_nature']);
		$this->qc_stage->setDbValue($row['qc_stage']);
		$this->defect_percentage->setDbValue($row['defect_percentage']);
		$this->deduction->setDbValue($row['deduction']);
		$this->comments->setDbValue($row['comments']);
		$this->design->setDbValue($row['design']);
		$this->size->setDbValue($row['size']);
		$this->status->setDbValue($row['status']);
		$this->remarks->setDbValue($row['remarks']);
		$this->_action->setDbValue($row['action']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->bcode_status->setDbValue($row['bcode_status']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['location'] = NULL;
		$row['barcode'] = NULL;
		$row['defect_nature'] = NULL;
		$row['qc_stage'] = NULL;
		$row['defect_percentage'] = NULL;
		$row['deduction'] = NULL;
		$row['comments'] = NULL;
		$row['design'] = NULL;
		$row['size'] = NULL;
		$row['status'] = NULL;
		$row['remarks'] = NULL;
		$row['action'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['bcode_status'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// location
		// barcode
		// defect_nature
		// qc_stage
		// defect_percentage
		// deduction
		// comments
		// design
		// size
		// status
		// remarks
		// action
		// operator
		// datetime
		// a_operator
		// a_datetime
		// bcode_status

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// defect_nature
			$curVal = strval($this->defect_nature->CurrentValue);
			if ($curVal <> "") {
				$this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
				if ($this->defect_nature->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->defect_nature->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->defect_nature->ViewValue = $this->defect_nature->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->defect_nature->ViewValue = $this->defect_nature->CurrentValue;
					}
				}
			} else {
				$this->defect_nature->ViewValue = NULL;
			}
			$this->defect_nature->ViewCustomAttributes = "";

			// qc_stage
			$curVal = strval($this->qc_stage->CurrentValue);
			if ($curVal <> "") {
				$this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
				if ($this->qc_stage->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->qc_stage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->qc_stage->ViewValue = $this->qc_stage->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->qc_stage->ViewValue = $this->qc_stage->CurrentValue;
					}
				}
			} else {
				$this->qc_stage->ViewValue = NULL;
			}
			$this->qc_stage->ViewCustomAttributes = "";

			// defect_percentage
			$curVal = strval($this->defect_percentage->CurrentValue);
			if ($curVal <> "") {
				$this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
				if ($this->defect_percentage->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 4 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->defect_percentage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->defect_percentage->ViewValue = $this->defect_percentage->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->defect_percentage->ViewValue = $this->defect_percentage->CurrentValue;
					}
				}
			} else {
				$this->defect_percentage->ViewValue = NULL;
			}
			$this->defect_percentage->ViewCustomAttributes = "";

			// deduction
			$this->deduction->ViewValue = $this->deduction->CurrentValue;
			$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 0, -2, -2, -2);
			$this->deduction->ViewCustomAttributes = "";

			// comments
			$this->comments->ViewValue = $this->comments->CurrentValue;
			$this->comments->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 5 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// action
			$curVal = strval($this->_action->CurrentValue);
			if ($curVal <> "") {
				$this->_action->ViewValue = $this->_action->lookupCacheOption($curVal);
				if ($this->_action->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_action->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_action->ViewValue = $this->_action->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_action->ViewValue = $this->_action->CurrentValue;
					}
				}
			} else {
				$this->_action->ViewValue = NULL;
			}
			$this->_action->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 117);
			$this->a_datetime->ViewCustomAttributes = "";

			// bcode_status
			$this->bcode_status->ViewValue = $this->bcode_status->CurrentValue;
			$this->bcode_status->ViewValue = FormatNumber($this->bcode_status->ViewValue, 0, -2, -2, -2);
			$this->bcode_status->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// defect_nature
			$this->defect_nature->LinkCustomAttributes = "";
			$this->defect_nature->HrefValue = "";
			$this->defect_nature->TooltipValue = "";

			// qc_stage
			$this->qc_stage->LinkCustomAttributes = "";
			$this->qc_stage->HrefValue = "";
			$this->qc_stage->TooltipValue = "";

			// defect_percentage
			$this->defect_percentage->LinkCustomAttributes = "";
			$this->defect_percentage->HrefValue = "";
			$this->defect_percentage->TooltipValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";
			$this->deduction->TooltipValue = "";

			// comments
			$this->comments->LinkCustomAttributes = "";
			$this->comments->HrefValue = "";
			$this->comments->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// action
			$this->_action->LinkCustomAttributes = "";
			$this->_action->HrefValue = "";
			$this->_action->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
			$this->a_datetime->TooltipValue = "";

			// bcode_status
			$this->bcode_status->LinkCustomAttributes = "";
			$this->bcode_status->HrefValue = "";
			$this->bcode_status->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->EditValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->EditValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->EditValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->EditValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = $this->_barcode->CurrentValue;
			$this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// defect_nature
			$this->defect_nature->EditAttrs["class"] = "form-control";
			$this->defect_nature->EditCustomAttributes = "";
			$curVal = strval($this->defect_nature->CurrentValue);
			if ($curVal <> "") {
				$this->defect_nature->EditValue = $this->defect_nature->lookupCacheOption($curVal);
				if ($this->defect_nature->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->defect_nature->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->defect_nature->EditValue = $this->defect_nature->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->defect_nature->EditValue = $this->defect_nature->CurrentValue;
					}
				}
			} else {
				$this->defect_nature->EditValue = NULL;
			}
			$this->defect_nature->ViewCustomAttributes = "";

			// qc_stage
			$this->qc_stage->EditAttrs["class"] = "form-control";
			$this->qc_stage->EditCustomAttributes = "";
			$curVal = strval($this->qc_stage->CurrentValue);
			if ($curVal <> "") {
				$this->qc_stage->EditValue = $this->qc_stage->lookupCacheOption($curVal);
				if ($this->qc_stage->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->qc_stage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->qc_stage->EditValue = $this->qc_stage->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->qc_stage->EditValue = $this->qc_stage->CurrentValue;
					}
				}
			} else {
				$this->qc_stage->EditValue = NULL;
			}
			$this->qc_stage->ViewCustomAttributes = "";

			// defect_percentage
			$this->defect_percentage->EditAttrs["class"] = "form-control";
			$this->defect_percentage->EditCustomAttributes = "";
			$curVal = strval($this->defect_percentage->CurrentValue);
			if ($curVal <> "") {
				$this->defect_percentage->EditValue = $this->defect_percentage->lookupCacheOption($curVal);
				if ($this->defect_percentage->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 4 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->defect_percentage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->defect_percentage->EditValue = $this->defect_percentage->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->defect_percentage->EditValue = $this->defect_percentage->CurrentValue;
					}
				}
			} else {
				$this->defect_percentage->EditValue = NULL;
			}
			$this->defect_percentage->ViewCustomAttributes = "";

			// deduction
			$this->deduction->EditAttrs["class"] = "form-control";
			$this->deduction->EditCustomAttributes = "";
			$this->deduction->EditValue = HtmlEncode($this->deduction->CurrentValue);
			$this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());

			// comments
			$this->comments->EditAttrs["class"] = "form-control";
			$this->comments->EditCustomAttributes = "";
			$this->comments->EditValue = $this->comments->CurrentValue;
			$this->comments->ViewCustomAttributes = "";

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			$this->design->EditValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			$this->size->EditValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->EditValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 5 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->EditValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->EditValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// action
			$this->_action->EditCustomAttributes = "";
			$curVal = trim(strval($this->_action->CurrentValue));
			if ($curVal <> "")
				$this->_action->ViewValue = $this->_action->lookupCacheOption($curVal);
			else
				$this->_action->ViewValue = $this->_action->Lookup !== NULL && is_array($this->_action->Lookup->Options) ? $curVal : NULL;
			if ($this->_action->ViewValue !== NULL) { // Load from cache
				$this->_action->EditValue = array_values($this->_action->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->_action->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->_action->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->_action->EditValue = $arwrk;
			}

			// a_operator
			// a_datetime
			// bcode_status

			$this->bcode_status->EditAttrs["class"] = "form-control";
			$this->bcode_status->EditCustomAttributes = "";
			$this->bcode_status->EditValue = HtmlEncode($this->bcode_status->CurrentValue);
			$this->bcode_status->PlaceHolder = RemoveHtml($this->bcode_status->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// defect_nature
			$this->defect_nature->LinkCustomAttributes = "";
			$this->defect_nature->HrefValue = "";
			$this->defect_nature->TooltipValue = "";

			// qc_stage
			$this->qc_stage->LinkCustomAttributes = "";
			$this->qc_stage->HrefValue = "";
			$this->qc_stage->TooltipValue = "";

			// defect_percentage
			$this->defect_percentage->LinkCustomAttributes = "";
			$this->defect_percentage->HrefValue = "";
			$this->defect_percentage->TooltipValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";

			// comments
			$this->comments->LinkCustomAttributes = "";
			$this->comments->HrefValue = "";
			$this->comments->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// action
			$this->_action->LinkCustomAttributes = "";
			$this->_action->HrefValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";

			// bcode_status
			$this->bcode_status->LinkCustomAttributes = "";
			$this->bcode_status->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->defect_nature->Required) {
			if (!$this->defect_nature->IsDetailKey && $this->defect_nature->FormValue != NULL && $this->defect_nature->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->defect_nature->caption(), $this->defect_nature->RequiredErrorMessage));
			}
		}
		if ($this->qc_stage->Required) {
			if (!$this->qc_stage->IsDetailKey && $this->qc_stage->FormValue != NULL && $this->qc_stage->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_stage->caption(), $this->qc_stage->RequiredErrorMessage));
			}
		}
		if ($this->defect_percentage->Required) {
			if (!$this->defect_percentage->IsDetailKey && $this->defect_percentage->FormValue != NULL && $this->defect_percentage->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->defect_percentage->caption(), $this->defect_percentage->RequiredErrorMessage));
			}
		}
		if ($this->deduction->Required) {
			if (!$this->deduction->IsDetailKey && $this->deduction->FormValue != NULL && $this->deduction->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->deduction->caption(), $this->deduction->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->deduction->FormValue)) {
			AddMessage($FormError, $this->deduction->errorMessage());
		}
		if ($this->comments->Required) {
			if (!$this->comments->IsDetailKey && $this->comments->FormValue != NULL && $this->comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->comments->caption(), $this->comments->RequiredErrorMessage));
			}
		}
		if ($this->design->Required) {
			if (!$this->design->IsDetailKey && $this->design->FormValue != NULL && $this->design->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
			}
		}
		if ($this->size->Required) {
			if (!$this->size->IsDetailKey && $this->size->FormValue != NULL && $this->size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->_action->Required) {
			if ($this->_action->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_action->caption(), $this->_action->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->bcode_status->Required) {
			if (!$this->bcode_status->IsDetailKey && $this->bcode_status->FormValue != NULL && $this->bcode_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bcode_status->caption(), $this->bcode_status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->bcode_status->FormValue)) {
			AddMessage($FormError, $this->bcode_status->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// deduction
			$this->deduction->setDbValueDef($rsnew, $this->deduction->CurrentValue, NULL, $this->deduction->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// action
			$this->_action->setDbValueDef($rsnew, $this->_action->CurrentValue, NULL, $this->_action->ReadOnly);

			// a_operator
			$this->a_operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['a_operator'] = &$this->a_operator->DbValue;

			// a_datetime
			$this->a_datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['a_datetime'] = &$this->a_datetime->DbValue;

			// bcode_status
			$this->bcode_status->setDbValueDef($rsnew, $this->bcode_status->CurrentValue, NULL, $this->bcode_status->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("qc_authorisedlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_defect_nature":
					$lookupFilter = function() {
						return "`grp` = 3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_qc_stage":
					$lookupFilter = function() {
						return "`grp` = 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_defect_percentage":
					$lookupFilter = function() {
						return "`grp` = 4 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`grp` = 5 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__action":
					$lookupFilter = function() {
						return "`grp` = 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_defect_nature":
							break;
						case "x_qc_stage":
							break;
						case "x_defect_percentage":
							break;
						case "x_status":
							break;
						case "x__action":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>