<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class qc_authorised_search extends qc_authorised
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'qc_authorised';

	// Page object name
	public $PageObjName = "qc_authorised_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (qc_authorised)
		if (!isset($GLOBALS["qc_authorised"]) || get_class($GLOBALS["qc_authorised"]) == PROJECT_NAMESPACE . "qc_authorised") {
			$GLOBALS["qc_authorised"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["qc_authorised"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'qc_authorised');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $qc_authorised;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($qc_authorised);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "qc_authorisedview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("qc_authorisedlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->location->setVisibility();
		$this->_barcode->setVisibility();
		$this->defect_nature->setVisibility();
		$this->qc_stage->setVisibility();
		$this->defect_percentage->setVisibility();
		$this->deduction->setVisibility();
		$this->comments->setVisibility();
		$this->design->setVisibility();
		$this->size->setVisibility();
		$this->status->setVisibility();
		$this->remarks->setVisibility();
		$this->_action->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->setVisibility();
		$this->a_datetime->setVisibility();
		$this->bcode_status->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->defect_nature);
		$this->setupLookupOptions($this->qc_stage);
		$this->setupLookupOptions($this->defect_percentage);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->_action);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "qc_authorisedlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->location); // location
		$this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
		$this->buildSearchUrl($srchUrl, $this->defect_nature); // defect_nature
		$this->buildSearchUrl($srchUrl, $this->qc_stage); // qc_stage
		$this->buildSearchUrl($srchUrl, $this->defect_percentage); // defect_percentage
		$this->buildSearchUrl($srchUrl, $this->deduction); // deduction
		$this->buildSearchUrl($srchUrl, $this->comments); // comments
		$this->buildSearchUrl($srchUrl, $this->design); // design
		$this->buildSearchUrl($srchUrl, $this->size); // size
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->_action); // action
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
		$this->buildSearchUrl($srchUrl, $this->a_datetime); // a_datetime
		$this->buildSearchUrl($srchUrl, $this->bcode_status); // bcode_status
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_location"));
		$this->location->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_location"));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__barcode"));
		$this->_barcode->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v__barcode"));
		$this->_barcode->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w__barcode"));

		// defect_nature
		if (!$this->isAddOrEdit())
			$this->defect_nature->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_defect_nature"));
		$this->defect_nature->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_defect_nature"));
		$this->defect_nature->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_defect_nature"));
		$this->defect_nature->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_defect_nature"));
		$this->defect_nature->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_defect_nature"));

		// qc_stage
		if (!$this->isAddOrEdit())
			$this->qc_stage->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qc_stage"));
		$this->qc_stage->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qc_stage"));

		// defect_percentage
		if (!$this->isAddOrEdit())
			$this->defect_percentage->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_defect_percentage"));
		$this->defect_percentage->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_defect_percentage"));

		// deduction
		if (!$this->isAddOrEdit())
			$this->deduction->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_deduction"));
		$this->deduction->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_deduction"));

		// comments
		if (!$this->isAddOrEdit())
			$this->comments->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_comments"));
		$this->comments->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_comments"));

		// design
		if (!$this->isAddOrEdit())
			$this->design->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design"));
		$this->design->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design"));

		// size
		if (!$this->isAddOrEdit())
			$this->size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size"));
		$this->size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// action
		if (!$this->isAddOrEdit())
			$this->_action->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__action"));
		$this->_action->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__action"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// a_operator
		if (!$this->isAddOrEdit())
			$this->a_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_operator"));
		$this->a_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_operator"));

		// a_datetime
		if (!$this->isAddOrEdit())
			$this->a_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_datetime"));
		$this->a_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_datetime"));

		// bcode_status
		if (!$this->isAddOrEdit())
			$this->bcode_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bcode_status"));
		$this->bcode_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bcode_status"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// location
		// barcode
		// defect_nature
		// qc_stage
		// defect_percentage
		// deduction
		// comments
		// design
		// size
		// status
		// remarks
		// action
		// operator
		// datetime
		// a_operator
		// a_datetime
		// bcode_status

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// defect_nature
			$curVal = strval($this->defect_nature->CurrentValue);
			if ($curVal <> "") {
				$this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
				if ($this->defect_nature->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->defect_nature->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->defect_nature->ViewValue = $this->defect_nature->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->defect_nature->ViewValue = $this->defect_nature->CurrentValue;
					}
				}
			} else {
				$this->defect_nature->ViewValue = NULL;
			}
			$this->defect_nature->ViewCustomAttributes = "";

			// qc_stage
			$curVal = strval($this->qc_stage->CurrentValue);
			if ($curVal <> "") {
				$this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
				if ($this->qc_stage->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->qc_stage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->qc_stage->ViewValue = $this->qc_stage->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->qc_stage->ViewValue = $this->qc_stage->CurrentValue;
					}
				}
			} else {
				$this->qc_stage->ViewValue = NULL;
			}
			$this->qc_stage->ViewCustomAttributes = "";

			// defect_percentage
			$curVal = strval($this->defect_percentage->CurrentValue);
			if ($curVal <> "") {
				$this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
				if ($this->defect_percentage->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 4 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->defect_percentage->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->defect_percentage->ViewValue = $this->defect_percentage->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->defect_percentage->ViewValue = $this->defect_percentage->CurrentValue;
					}
				}
			} else {
				$this->defect_percentage->ViewValue = NULL;
			}
			$this->defect_percentage->ViewCustomAttributes = "";

			// deduction
			$this->deduction->ViewValue = $this->deduction->CurrentValue;
			$this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, 0, -2, -2, -2);
			$this->deduction->ViewCustomAttributes = "";

			// comments
			$this->comments->ViewValue = $this->comments->CurrentValue;
			$this->comments->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 5 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// action
			$curVal = strval($this->_action->CurrentValue);
			if ($curVal <> "") {
				$this->_action->ViewValue = $this->_action->lookupCacheOption($curVal);
				if ($this->_action->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_action->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_action->ViewValue = $this->_action->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_action->ViewValue = $this->_action->CurrentValue;
					}
				}
			} else {
				$this->_action->ViewValue = NULL;
			}
			$this->_action->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 117);
			$this->a_datetime->ViewCustomAttributes = "";

			// bcode_status
			$this->bcode_status->ViewValue = $this->bcode_status->CurrentValue;
			$this->bcode_status->ViewValue = FormatNumber($this->bcode_status->ViewValue, 0, -2, -2, -2);
			$this->bcode_status->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// defect_nature
			$this->defect_nature->LinkCustomAttributes = "";
			$this->defect_nature->HrefValue = "";
			$this->defect_nature->TooltipValue = "";

			// qc_stage
			$this->qc_stage->LinkCustomAttributes = "";
			$this->qc_stage->HrefValue = "";
			$this->qc_stage->TooltipValue = "";

			// defect_percentage
			$this->defect_percentage->LinkCustomAttributes = "";
			$this->defect_percentage->HrefValue = "";
			$this->defect_percentage->TooltipValue = "";

			// deduction
			$this->deduction->LinkCustomAttributes = "";
			$this->deduction->HrefValue = "";
			$this->deduction->TooltipValue = "";

			// comments
			$this->comments->LinkCustomAttributes = "";
			$this->comments->HrefValue = "";
			$this->comments->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// action
			$this->_action->LinkCustomAttributes = "";
			$this->_action->HrefValue = "";
			$this->_action->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
			$this->a_datetime->TooltipValue = "";

			// bcode_status
			$this->bcode_status->LinkCustomAttributes = "";
			$this->bcode_status->HrefValue = "";
			$this->bcode_status->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->location->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue2 = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue2);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// defect_nature
			$this->defect_nature->EditAttrs["class"] = "form-control";
			$this->defect_nature->EditCustomAttributes = "";
			$curVal = trim(strval($this->defect_nature->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->defect_nature->AdvancedSearch->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
			else
				$this->defect_nature->AdvancedSearch->ViewValue = $this->defect_nature->Lookup !== NULL && is_array($this->defect_nature->Lookup->Options) ? $curVal : NULL;
			if ($this->defect_nature->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->defect_nature->EditValue = array_values($this->defect_nature->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->defect_nature->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 3 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->defect_nature->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->defect_nature->EditValue = $arwrk;
			}
			$this->defect_nature->EditAttrs["class"] = "form-control";
			$this->defect_nature->EditCustomAttributes = "";
			$curVal = trim(strval($this->defect_nature->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->defect_nature->AdvancedSearch->ViewValue2 = $this->defect_nature->lookupCacheOption($curVal);
			else
				$this->defect_nature->AdvancedSearch->ViewValue2 = $this->defect_nature->Lookup !== NULL && is_array($this->defect_nature->Lookup->Options) ? $curVal : NULL;
			if ($this->defect_nature->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->defect_nature->EditValue2 = array_values($this->defect_nature->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->defect_nature->AdvancedSearch->SearchValue2, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 3 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->defect_nature->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->defect_nature->EditValue2 = $arwrk;
			}

			// qc_stage
			$this->qc_stage->EditAttrs["class"] = "form-control";
			$this->qc_stage->EditCustomAttributes = "";
			$curVal = trim(strval($this->qc_stage->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->qc_stage->AdvancedSearch->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
			else
				$this->qc_stage->AdvancedSearch->ViewValue = $this->qc_stage->Lookup !== NULL && is_array($this->qc_stage->Lookup->Options) ? $curVal : NULL;
			if ($this->qc_stage->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->qc_stage->EditValue = array_values($this->qc_stage->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->qc_stage->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 2 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->qc_stage->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->qc_stage->EditValue = $arwrk;
			}

			// defect_percentage
			$this->defect_percentage->EditAttrs["class"] = "form-control";
			$this->defect_percentage->EditCustomAttributes = "";
			$curVal = trim(strval($this->defect_percentage->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->defect_percentage->AdvancedSearch->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
			else
				$this->defect_percentage->AdvancedSearch->ViewValue = $this->defect_percentage->Lookup !== NULL && is_array($this->defect_percentage->Lookup->Options) ? $curVal : NULL;
			if ($this->defect_percentage->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->defect_percentage->EditValue = array_values($this->defect_percentage->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->defect_percentage->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 4 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->defect_percentage->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->defect_percentage->EditValue = $arwrk;
			}

			// deduction
			$this->deduction->EditAttrs["class"] = "form-control";
			$this->deduction->EditCustomAttributes = "";
			$this->deduction->EditValue = HtmlEncode($this->deduction->AdvancedSearch->SearchValue);
			$this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());

			// comments
			$this->comments->EditAttrs["class"] = "form-control";
			$this->comments->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->comments->AdvancedSearch->SearchValue = HtmlDecode($this->comments->AdvancedSearch->SearchValue);
			$this->comments->EditValue = HtmlEncode($this->comments->AdvancedSearch->SearchValue);
			$this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
			$this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
			$this->design->PlaceHolder = RemoveHtml($this->design->caption());

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size->AdvancedSearch->SearchValue = HtmlDecode($this->size->AdvancedSearch->SearchValue);
			$this->size->EditValue = HtmlEncode($this->size->AdvancedSearch->SearchValue);
			$this->size->PlaceHolder = RemoveHtml($this->size->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 5 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// action
			$this->_action->EditCustomAttributes = "";
			$curVal = trim(strval($this->_action->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->_action->AdvancedSearch->ViewValue = $this->_action->lookupCacheOption($curVal);
			else
				$this->_action->AdvancedSearch->ViewValue = $this->_action->Lookup !== NULL && is_array($this->_action->Lookup->Options) ? $curVal : NULL;
			if ($this->_action->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->_action->EditValue = array_values($this->_action->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->_action->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->_action->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->_action->EditValue = $arwrk;
			}

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// a_operator
			$this->a_operator->EditAttrs["class"] = "form-control";
			$this->a_operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			else
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== NULL && is_array($this->a_operator->Lookup->Options) ? $curVal : NULL;
			if ($this->a_operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->a_operator->EditValue = array_values($this->a_operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->a_operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->a_operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->a_operator->EditValue = $arwrk;
			}

			// a_datetime
			$this->a_datetime->EditAttrs["class"] = "form-control";
			$this->a_datetime->EditCustomAttributes = "";
			$this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, 117), 117));
			$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

			// bcode_status
			$this->bcode_status->EditAttrs["class"] = "form-control";
			$this->bcode_status->EditCustomAttributes = "";
			$this->bcode_status->EditValue = HtmlEncode($this->bcode_status->AdvancedSearch->SearchValue);
			$this->bcode_status->PlaceHolder = RemoveHtml($this->bcode_status->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}
		if (!CheckInteger($this->deduction->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->deduction->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckDate($this->a_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->a_datetime->errorMessage());
		}
		if (!CheckInteger($this->bcode_status->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->bcode_status->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->defect_nature->AdvancedSearch->load();
		$this->qc_stage->AdvancedSearch->load();
		$this->defect_percentage->AdvancedSearch->load();
		$this->deduction->AdvancedSearch->load();
		$this->comments->AdvancedSearch->load();
		$this->design->AdvancedSearch->load();
		$this->size->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->_action->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->a_datetime->AdvancedSearch->load();
		$this->bcode_status->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("qc_authorisedlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, " . User_Site() . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_defect_nature":
					$lookupFilter = function() {
						return "`grp` = 3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_qc_stage":
					$lookupFilter = function() {
						return "`grp` = 2 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_defect_percentage":
					$lookupFilter = function() {
						return "`grp` = 4 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`grp` = 5 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__action":
					$lookupFilter = function() {
						return "`grp` = 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_defect_nature":
							break;
						case "x_qc_stage":
							break;
						case "x_defect_percentage":
							break;
						case "x_status":
							break;
						case "x__action":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>