<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for query_oms
 */
class query_oms extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $buyers_id;
	public $order_week;
	public $order_date;
	public $buyer_order;
	public $po;
	public $item;
	public $buyer_ref;
	public $design;
	public $size_buyer;
	public $width;
	public $length;
	public $qty;
	public $revised_qty;
	public $sqm;
	public $ex_factory;
	public $ex_factory_p;
	public $shipping_mode;
	public $remarks;
	public $d_qty;
	public $pl_no;
	public $invoice_date;
	public $sailing_week;
	public $pending;
	public $pending_sqm;
	public $cbm;
	public $total_cbm;
	public $offloom;
	public $status;
	public $rejection;
	public $completed;
	public $reports_to;
	public $weight_sqm;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'query_oms';
		$this->TableName = 'query_oms';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`query_oms`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('query_oms', 'query_oms', 'x_id', 'id', '`id`', '`id`', 21, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// buyers_id
		$this->buyers_id = new DbField('query_oms', 'query_oms', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyers_id->Lookup = new Lookup('buyers_id', 'buyer', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// order_week
		$this->order_week = new DbField('query_oms', 'query_oms', 'x_order_week', 'order_week', '`order_week`', '`order_week`', 18, -1, FALSE, '`order_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->order_week->Sortable = TRUE; // Allow sort
		$this->order_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->order_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->order_week->Lookup = new Lookup('order_week', 'not_week', FALSE, 'id', ["week","","",""], [], [], [], [], [], [], '`week` ASC', '');
		$this->order_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['order_week'] = &$this->order_week;

		// order_date
		$this->order_date = new DbField('query_oms', 'query_oms', 'x_order_date', 'order_date', '`order_date`', CastDateFieldForLike('`order_date`', 2, "DB"), 133, 2, FALSE, '`order_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_date->Sortable = TRUE; // Allow sort
		$this->order_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['order_date'] = &$this->order_date;

		// buyer_order
		$this->buyer_order = new DbField('query_oms', 'query_oms', 'x_buyer_order', 'buyer_order', '`buyer_order`', '`buyer_order`', 201, -1, FALSE, '`buyer_order`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_order->Sortable = TRUE; // Allow sort
		$this->fields['buyer_order'] = &$this->buyer_order;

		// po
		$this->po = new DbField('query_oms', 'query_oms', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// item
		$this->item = new DbField('query_oms', 'query_oms', 'x_item', 'item', '`item`', '`item`', 200, -1, FALSE, '`item`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->item->Sortable = TRUE; // Allow sort
		$this->fields['item'] = &$this->item;

		// buyer_ref
		$this->buyer_ref = new DbField('query_oms', 'query_oms', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 200, -1, FALSE, '`buyer_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// design
		$this->design = new DbField('query_oms', 'query_oms', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Sortable = TRUE; // Allow sort
		$this->fields['design'] = &$this->design;

		// size_buyer
		$this->size_buyer = new DbField('query_oms', 'query_oms', 'x_size_buyer', 'size_buyer', '`size_buyer`', '`size_buyer`', 200, -1, FALSE, '`size_buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_buyer->Sortable = TRUE; // Allow sort
		$this->fields['size_buyer'] = &$this->size_buyer;

		// width
		$this->width = new DbField('query_oms', 'query_oms', 'x_width', 'width', '`width`', '`width`', 18, -1, FALSE, '`width`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->width->Sortable = TRUE; // Allow sort
		$this->width->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['width'] = &$this->width;

		// length
		$this->length = new DbField('query_oms', 'query_oms', 'x_length', 'length', '`length`', '`length`', 18, -1, FALSE, '`length`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->length->Sortable = TRUE; // Allow sort
		$this->length->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['length'] = &$this->length;

		// qty
		$this->qty = new DbField('query_oms', 'query_oms', 'x_qty', 'qty', '`qty`', '`qty`', 18, -1, FALSE, '`qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty->Sortable = TRUE; // Allow sort
		$this->qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['qty'] = &$this->qty;

		// revised_qty
		$this->revised_qty = new DbField('query_oms', 'query_oms', 'x_revised_qty', 'revised_qty', '`revised_qty`', '`revised_qty`', 20, -1, FALSE, '`revised_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->revised_qty->Sortable = TRUE; // Allow sort
		$this->revised_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['revised_qty'] = &$this->revised_qty;

		// sqm
		$this->sqm = new DbField('query_oms', 'query_oms', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// ex_factory
		$this->ex_factory = new DbField('query_oms', 'query_oms', 'x_ex_factory', 'ex_factory', '`ex_factory`', '`ex_factory`', 18, -1, FALSE, '`ex_factory`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ex_factory->Sortable = TRUE; // Allow sort
		$this->ex_factory->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ex_factory->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->ex_factory->Lookup = new Lookup('ex_factory', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->ex_factory->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ex_factory'] = &$this->ex_factory;

		// ex_factory_p
		$this->ex_factory_p = new DbField('query_oms', 'query_oms', 'x_ex_factory_p', 'ex_factory_p', '`ex_factory_p`', '`ex_factory_p`', 201, -1, FALSE, '`ex_factory_p`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->ex_factory_p->Sortable = TRUE; // Allow sort
		$this->fields['ex_factory_p'] = &$this->ex_factory_p;

		// shipping_mode
		$this->shipping_mode = new DbField('query_oms', 'query_oms', 'x_shipping_mode', 'shipping_mode', '`shipping_mode`', '`shipping_mode`', 200, -1, FALSE, '`shipping_mode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_mode->Sortable = TRUE; // Allow sort
		$this->fields['shipping_mode'] = &$this->shipping_mode;

		// remarks
		$this->remarks = new DbField('query_oms', 'query_oms', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// d_qty
		$this->d_qty = new DbField('query_oms', 'query_oms', 'x_d_qty', 'd_qty', '`d_qty`', '`d_qty`', 131, -1, FALSE, '`d_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_qty->Sortable = TRUE; // Allow sort
		$this->d_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['d_qty'] = &$this->d_qty;

		// pl_no
		$this->pl_no = new DbField('query_oms', 'query_oms', 'x_pl_no', 'pl_no', '`pl_no`', '`pl_no`', 201, -1, FALSE, '`pl_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->pl_no->Sortable = TRUE; // Allow sort
		$this->fields['pl_no'] = &$this->pl_no;

		// invoice_date
		$this->invoice_date = new DbField('query_oms', 'query_oms', 'x_invoice_date', 'invoice_date', '`invoice_date`', '`invoice_date`', 201, -1, FALSE, '`invoice_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->invoice_date->Nullable = FALSE; // NOT NULL field
		$this->invoice_date->Required = TRUE; // Required field
		$this->invoice_date->Sortable = TRUE; // Allow sort
		$this->fields['invoice_date'] = &$this->invoice_date;

		// sailing_week
		$this->sailing_week = new DbField('query_oms', 'query_oms', 'x_sailing_week', 'sailing_week', '`sailing_week`', '`sailing_week`', 201, -1, FALSE, '`sailing_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->sailing_week->Nullable = FALSE; // NOT NULL field
		$this->sailing_week->Required = TRUE; // Required field
		$this->sailing_week->Sortable = TRUE; // Allow sort
		$this->fields['sailing_week'] = &$this->sailing_week;

		// pending
		$this->pending = new DbField('query_oms', 'query_oms', 'x_pending', 'pending', '`pending`', '`pending`', 131, -1, FALSE, '`pending`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending->Sortable = TRUE; // Allow sort
		$this->pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pending'] = &$this->pending;

		// pending_sqm
		$this->pending_sqm = new DbField('query_oms', 'query_oms', 'x_pending_sqm', 'pending_sqm', '`pending_sqm`', '`pending_sqm`', 131, -1, FALSE, '`pending_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending_sqm->Sortable = TRUE; // Allow sort
		$this->pending_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pending_sqm'] = &$this->pending_sqm;

		// cbm
		$this->cbm = new DbField('query_oms', 'query_oms', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 201, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->cbm->Nullable = FALSE; // NOT NULL field
		$this->cbm->Required = TRUE; // Required field
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->fields['cbm'] = &$this->cbm;

		// total_cbm
		$this->total_cbm = new DbField('query_oms', 'query_oms', 'x_total_cbm', 'total_cbm', '`total_cbm`', '`total_cbm`', 201, -1, FALSE, '`total_cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->total_cbm->Nullable = FALSE; // NOT NULL field
		$this->total_cbm->Required = TRUE; // Required field
		$this->total_cbm->Sortable = TRUE; // Allow sort
		$this->fields['total_cbm'] = &$this->total_cbm;

		// offloom
		$this->offloom = new DbField('query_oms', 'query_oms', 'x_offloom', 'offloom', '`offloom`', '`offloom`', 131, -1, FALSE, '`offloom`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->offloom->Sortable = TRUE; // Allow sort
		$this->offloom->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['offloom'] = &$this->offloom;

		// status
		$this->status = new DbField('query_oms', 'query_oms', 'x_status', 'status', '`status`', '`status`', 201, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->SelectMultiple = TRUE; // Multiple select
		$this->status->Lookup = new Lookup('status', 'status', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['status'] = &$this->status;

		// rejection
		$this->rejection = new DbField('query_oms', 'query_oms', 'x_rejection', 'rejection', '`rejection`', '`rejection`', 3, -1, FALSE, '`rejection`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rejection->Nullable = FALSE; // NOT NULL field
		$this->rejection->Sortable = TRUE; // Allow sort
		$this->rejection->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rejection'] = &$this->rejection;

		// completed
		$this->completed = new DbField('query_oms', 'query_oms', 'x_completed', 'completed', '`completed`', '`completed`', 201, -1, FALSE, '`completed`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->completed->Sortable = TRUE; // Allow sort
		$this->completed->Lookup = new Lookup('completed', 'query_oms', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->completed->OptionCount = 2;
		$this->fields['completed'] = &$this->completed;

		// reports_to
		$this->reports_to = new DbField('query_oms', 'query_oms', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 200, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reports_to->Sortable = TRUE; // Allow sort
		$this->fields['reports_to'] = &$this->reports_to;

		// weight_sqm
		$this->weight_sqm = new DbField('query_oms', 'query_oms', 'x_weight_sqm', 'weight_sqm', '`weight_sqm`', '`weight_sqm`', 131, -1, FALSE, '`weight_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weight_sqm->Sortable = TRUE; // Allow sort
		$this->weight_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['weight_sqm'] = &$this->weight_sqm;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`query_oms`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->order_week->DbValue = $row['order_week'];
		$this->order_date->DbValue = $row['order_date'];
		$this->buyer_order->DbValue = $row['buyer_order'];
		$this->po->DbValue = $row['po'];
		$this->item->DbValue = $row['item'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->design->DbValue = $row['design'];
		$this->size_buyer->DbValue = $row['size_buyer'];
		$this->width->DbValue = $row['width'];
		$this->length->DbValue = $row['length'];
		$this->qty->DbValue = $row['qty'];
		$this->revised_qty->DbValue = $row['revised_qty'];
		$this->sqm->DbValue = $row['sqm'];
		$this->ex_factory->DbValue = $row['ex_factory'];
		$this->ex_factory_p->DbValue = $row['ex_factory_p'];
		$this->shipping_mode->DbValue = $row['shipping_mode'];
		$this->remarks->DbValue = $row['remarks'];
		$this->d_qty->DbValue = $row['d_qty'];
		$this->pl_no->DbValue = $row['pl_no'];
		$this->invoice_date->DbValue = $row['invoice_date'];
		$this->sailing_week->DbValue = $row['sailing_week'];
		$this->pending->DbValue = $row['pending'];
		$this->pending_sqm->DbValue = $row['pending_sqm'];
		$this->cbm->DbValue = $row['cbm'];
		$this->total_cbm->DbValue = $row['total_cbm'];
		$this->offloom->DbValue = $row['offloom'];
		$this->status->DbValue = $row['status'];
		$this->rejection->DbValue = $row['rejection'];
		$this->completed->DbValue = $row['completed'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->weight_sqm->DbValue = $row['weight_sqm'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "query_omslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "query_omsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "query_omsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "query_omsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "query_omslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("query_omsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("query_omsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "query_omsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "query_omsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("query_omsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("query_omsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("query_omsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->order_week->setDbValue($rs->fields('order_week'));
		$this->order_date->setDbValue($rs->fields('order_date'));
		$this->buyer_order->setDbValue($rs->fields('buyer_order'));
		$this->po->setDbValue($rs->fields('po'));
		$this->item->setDbValue($rs->fields('item'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->design->setDbValue($rs->fields('design'));
		$this->size_buyer->setDbValue($rs->fields('size_buyer'));
		$this->width->setDbValue($rs->fields('width'));
		$this->length->setDbValue($rs->fields('length'));
		$this->qty->setDbValue($rs->fields('qty'));
		$this->revised_qty->setDbValue($rs->fields('revised_qty'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->ex_factory->setDbValue($rs->fields('ex_factory'));
		$this->ex_factory_p->setDbValue($rs->fields('ex_factory_p'));
		$this->shipping_mode->setDbValue($rs->fields('shipping_mode'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->d_qty->setDbValue($rs->fields('d_qty'));
		$this->pl_no->setDbValue($rs->fields('pl_no'));
		$this->invoice_date->setDbValue($rs->fields('invoice_date'));
		$this->sailing_week->setDbValue($rs->fields('sailing_week'));
		$this->pending->setDbValue($rs->fields('pending'));
		$this->pending_sqm->setDbValue($rs->fields('pending_sqm'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->total_cbm->setDbValue($rs->fields('total_cbm'));
		$this->offloom->setDbValue($rs->fields('offloom'));
		$this->status->setDbValue($rs->fields('status'));
		$this->rejection->setDbValue($rs->fields('rejection'));
		$this->completed->setDbValue($rs->fields('completed'));
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->weight_sqm->setDbValue($rs->fields('weight_sqm'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// buyers_id
		// order_week
		// order_date
		// buyer_order
		// po
		// item
		// buyer_ref
		// design
		// size_buyer
		// width
		// length
		// qty
		// revised_qty
		// sqm
		// ex_factory
		// ex_factory_p
		// shipping_mode
		// remarks
		// d_qty
		// pl_no
		// invoice_date
		// sailing_week
		// pending
		// pending_sqm
		// cbm
		// total_cbm
		// offloom
		// status
		// rejection
		// completed
		// reports_to
		// weight_sqm
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// buyers_id
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->ViewValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// order_week
		$curVal = strval($this->order_week->CurrentValue);
		if ($curVal <> "") {
			$this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
			if ($this->order_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->order_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->order_week->ViewValue = $this->order_week->CurrentValue;
				}
			}
		} else {
			$this->order_week->ViewValue = NULL;
		}
		$this->order_week->ViewCustomAttributes = "";

		// order_date
		$this->order_date->ViewValue = $this->order_date->CurrentValue;
		$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 2);
		$this->order_date->ViewCustomAttributes = "";

		// buyer_order
		$this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;
		$this->buyer_order->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// item
		$this->item->ViewValue = $this->item->CurrentValue;
		$this->item->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
		$this->buyer_ref->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$this->design->ViewCustomAttributes = "";

		// size_buyer
		$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// width
		$this->width->ViewValue = $this->width->CurrentValue;
		$this->width->ViewValue = FormatNumber($this->width->ViewValue, 0, -2, -2, -2);
		$this->width->ViewCustomAttributes = "";

		// length
		$this->length->ViewValue = $this->length->CurrentValue;
		$this->length->ViewValue = FormatNumber($this->length->ViewValue, 0, -2, -2, -2);
		$this->length->ViewCustomAttributes = "";

		// qty
		$this->qty->ViewValue = $this->qty->CurrentValue;
		$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
		$this->qty->ViewCustomAttributes = "";

		// revised_qty
		$this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
		$this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, 0, -2, -2, -2);
		$this->revised_qty->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// ex_factory
		$curVal = strval($this->ex_factory->CurrentValue);
		if ($curVal <> "") {
			$this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
			if ($this->ex_factory->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ex_factory->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ex_factory->ViewValue = $this->ex_factory->CurrentValue;
				}
			}
		} else {
			$this->ex_factory->ViewValue = NULL;
		}
		$this->ex_factory->ViewCustomAttributes = "";

		// ex_factory_p
		$this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;
		$this->ex_factory_p->ViewCustomAttributes = "";

		// shipping_mode
		$this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;
		$this->shipping_mode->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// d_qty
		$this->d_qty->ViewValue = $this->d_qty->CurrentValue;
		$this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, 2, -2, -2, -2);
		$this->d_qty->ViewCustomAttributes = "";

		// pl_no
		$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
		$this->pl_no->ViewCustomAttributes = "";

		// invoice_date
		$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
		$this->invoice_date->ViewCustomAttributes = "";

		// sailing_week
		$this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;
		$this->sailing_week->ViewCustomAttributes = "";

		// pending
		$this->pending->ViewValue = $this->pending->CurrentValue;
		$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 0, -1, -2, -2);
		$this->pending->ViewCustomAttributes = "";

		// pending_sqm
		$this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
		$this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, 2, -2, -2, -2);
		$this->pending_sqm->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewCustomAttributes = "";

		// total_cbm
		$this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;
		$this->total_cbm->ViewCustomAttributes = "";

		// offloom
		$this->offloom->ViewValue = $this->offloom->CurrentValue;
		$this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, 0, -2, -2, -2);
		$this->offloom->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->status->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue->add($this->status->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// rejection
		$this->rejection->ViewValue = $this->rejection->CurrentValue;
		$this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, 0, -2, -2, -2);
		$this->rejection->ViewCustomAttributes = "";

		// completed
		if (strval($this->completed->CurrentValue) <> "") {
			$this->completed->ViewValue = new OptionValues();
			$arwrk = explode(",", strval($this->completed->CurrentValue));
			$cnt = count($arwrk);
			for ($ari = 0; $ari < $cnt; $ari++)
				$this->completed->ViewValue->add($this->completed->optionCaption(trim($arwrk[$ari])));
		} else {
			$this->completed->ViewValue = NULL;
		}
		$this->completed->ViewCustomAttributes = "";

		// reports_to
		$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
		$this->reports_to->ViewCustomAttributes = "";

		// weight_sqm
		$this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
		$this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, 2, -2, -2, -2);
		$this->weight_sqm->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		$this->buyers_id->HrefValue = "";
		$this->buyers_id->TooltipValue = "";

		// order_week
		$this->order_week->LinkCustomAttributes = "";
		$this->order_week->HrefValue = "";
		$this->order_week->TooltipValue = "";

		// order_date
		$this->order_date->LinkCustomAttributes = "";
		$this->order_date->HrefValue = "";
		$this->order_date->TooltipValue = "";

		// buyer_order
		$this->buyer_order->LinkCustomAttributes = "";
		$this->buyer_order->HrefValue = "";
		$this->buyer_order->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// item
		$this->item->LinkCustomAttributes = "";
		$this->item->HrefValue = "";
		$this->item->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		$this->buyer_ref->HrefValue = "";
		$this->buyer_ref->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// size_buyer
		$this->size_buyer->LinkCustomAttributes = "";
		$this->size_buyer->HrefValue = "";
		$this->size_buyer->TooltipValue = "";

		// width
		$this->width->LinkCustomAttributes = "";
		$this->width->HrefValue = "";
		$this->width->TooltipValue = "";

		// length
		$this->length->LinkCustomAttributes = "";
		$this->length->HrefValue = "";
		$this->length->TooltipValue = "";

		// qty
		$this->qty->LinkCustomAttributes = "";
		$this->qty->HrefValue = "";
		$this->qty->TooltipValue = "";

		// revised_qty
		$this->revised_qty->LinkCustomAttributes = "";
		$this->revised_qty->HrefValue = "";
		$this->revised_qty->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// ex_factory
		$this->ex_factory->LinkCustomAttributes = "";
		$this->ex_factory->HrefValue = "";
		$this->ex_factory->TooltipValue = "";

		// ex_factory_p
		$this->ex_factory_p->LinkCustomAttributes = "";
		$this->ex_factory_p->HrefValue = "";
		$this->ex_factory_p->TooltipValue = "";

		// shipping_mode
		$this->shipping_mode->LinkCustomAttributes = "";
		$this->shipping_mode->HrefValue = "";
		$this->shipping_mode->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// d_qty
		$this->d_qty->LinkCustomAttributes = "";
		$this->d_qty->HrefValue = "";
		$this->d_qty->TooltipValue = "";

		// pl_no
		$this->pl_no->LinkCustomAttributes = "";
		$this->pl_no->HrefValue = "";
		$this->pl_no->TooltipValue = "";

		// invoice_date
		$this->invoice_date->LinkCustomAttributes = "";
		$this->invoice_date->HrefValue = "";
		$this->invoice_date->TooltipValue = "";

		// sailing_week
		$this->sailing_week->LinkCustomAttributes = "";
		$this->sailing_week->HrefValue = "";
		$this->sailing_week->TooltipValue = "";

		// pending
		$this->pending->LinkCustomAttributes = "";
		$this->pending->HrefValue = "";
		$this->pending->TooltipValue = "";

		// pending_sqm
		$this->pending_sqm->LinkCustomAttributes = "";
		$this->pending_sqm->HrefValue = "";
		$this->pending_sqm->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// total_cbm
		$this->total_cbm->LinkCustomAttributes = "";
		$this->total_cbm->HrefValue = "";
		$this->total_cbm->TooltipValue = "";

		// offloom
		$this->offloom->LinkCustomAttributes = "";
		$this->offloom->HrefValue = "";
		$this->offloom->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// rejection
		$this->rejection->LinkCustomAttributes = "";
		$this->rejection->HrefValue = "";
		$this->rejection->TooltipValue = "";

		// completed
		$this->completed->LinkCustomAttributes = "";
		$this->completed->HrefValue = "";
		$this->completed->TooltipValue = "";

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// weight_sqm
		$this->weight_sqm->LinkCustomAttributes = "";
		$this->weight_sqm->HrefValue = "";
		$this->weight_sqm->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";

		// order_week
		$this->order_week->EditAttrs["class"] = "form-control";
		$this->order_week->EditCustomAttributes = "";

		// order_date
		$this->order_date->EditAttrs["class"] = "form-control";
		$this->order_date->EditCustomAttributes = "";
		$this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, 2);
		$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

		// buyer_order
		$this->buyer_order->EditAttrs["class"] = "form-control";
		$this->buyer_order->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_order->CurrentValue = HtmlDecode($this->buyer_order->CurrentValue);
		$this->buyer_order->EditValue = $this->buyer_order->CurrentValue;
		$this->buyer_order->PlaceHolder = RemoveHtml($this->buyer_order->caption());

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// item
		$this->item->EditAttrs["class"] = "form-control";
		$this->item->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
		$this->item->EditValue = $this->item->CurrentValue;
		$this->item->PlaceHolder = RemoveHtml($this->item->caption());

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_ref->CurrentValue = HtmlDecode($this->buyer_ref->CurrentValue);
		$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
		$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->PlaceHolder = RemoveHtml($this->design->caption());

		// size_buyer
		$this->size_buyer->EditAttrs["class"] = "form-control";
		$this->size_buyer->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_buyer->CurrentValue = HtmlDecode($this->size_buyer->CurrentValue);
		$this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

		// width
		$this->width->EditAttrs["class"] = "form-control";
		$this->width->EditCustomAttributes = "";
		$this->width->EditValue = $this->width->CurrentValue;
		$this->width->PlaceHolder = RemoveHtml($this->width->caption());

		// length
		$this->length->EditAttrs["class"] = "form-control";
		$this->length->EditCustomAttributes = "";
		$this->length->EditValue = $this->length->CurrentValue;
		$this->length->PlaceHolder = RemoveHtml($this->length->caption());

		// qty
		$this->qty->EditAttrs["class"] = "form-control";
		$this->qty->EditCustomAttributes = "";
		$this->qty->EditValue = $this->qty->CurrentValue;
		$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

		// revised_qty
		$this->revised_qty->EditAttrs["class"] = "form-control";
		$this->revised_qty->EditCustomAttributes = "";
		$this->revised_qty->EditValue = $this->revised_qty->CurrentValue;
		$this->revised_qty->PlaceHolder = RemoveHtml($this->revised_qty->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// ex_factory
		$this->ex_factory->EditAttrs["class"] = "form-control";
		$this->ex_factory->EditCustomAttributes = "";

		// ex_factory_p
		$this->ex_factory_p->EditAttrs["class"] = "form-control";
		$this->ex_factory_p->EditCustomAttributes = "";
		$this->ex_factory_p->EditValue = $this->ex_factory_p->CurrentValue;
		$this->ex_factory_p->PlaceHolder = RemoveHtml($this->ex_factory_p->caption());

		// shipping_mode
		$this->shipping_mode->EditAttrs["class"] = "form-control";
		$this->shipping_mode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->shipping_mode->CurrentValue = HtmlDecode($this->shipping_mode->CurrentValue);
		$this->shipping_mode->EditValue = $this->shipping_mode->CurrentValue;
		$this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// d_qty
		$this->d_qty->EditAttrs["class"] = "form-control";
		$this->d_qty->EditCustomAttributes = "";
		$this->d_qty->EditValue = $this->d_qty->CurrentValue;
		$this->d_qty->PlaceHolder = RemoveHtml($this->d_qty->caption());
		if (strval($this->d_qty->EditValue) <> "" && is_numeric($this->d_qty->EditValue))
			$this->d_qty->EditValue = FormatNumber($this->d_qty->EditValue, -2, -2, -2, -2);

		// pl_no
		$this->pl_no->EditAttrs["class"] = "form-control";
		$this->pl_no->EditCustomAttributes = "";
		$this->pl_no->EditValue = $this->pl_no->CurrentValue;
		$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

		// invoice_date
		$this->invoice_date->EditAttrs["class"] = "form-control";
		$this->invoice_date->EditCustomAttributes = "";
		$this->invoice_date->EditValue = $this->invoice_date->CurrentValue;
		$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

		// sailing_week
		$this->sailing_week->EditAttrs["class"] = "form-control";
		$this->sailing_week->EditCustomAttributes = "";
		$this->sailing_week->EditValue = $this->sailing_week->CurrentValue;
		$this->sailing_week->PlaceHolder = RemoveHtml($this->sailing_week->caption());

		// pending
		$this->pending->EditAttrs["class"] = "form-control";
		$this->pending->EditCustomAttributes = "";
		$this->pending->EditValue = $this->pending->CurrentValue;
		$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
		if (strval($this->pending->EditValue) <> "" && is_numeric($this->pending->EditValue))
			$this->pending->EditValue = FormatNumber($this->pending->EditValue, -2, -1, -2, -2);

		// pending_sqm
		$this->pending_sqm->EditAttrs["class"] = "form-control";
		$this->pending_sqm->EditCustomAttributes = "";
		$this->pending_sqm->EditValue = $this->pending_sqm->CurrentValue;
		$this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());
		if (strval($this->pending_sqm->EditValue) <> "" && is_numeric($this->pending_sqm->EditValue))
			$this->pending_sqm->EditValue = FormatNumber($this->pending_sqm->EditValue, -2, -2, -2, -2);

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = "";
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

		// total_cbm
		$this->total_cbm->EditAttrs["class"] = "form-control";
		$this->total_cbm->EditCustomAttributes = "";
		$this->total_cbm->EditValue = $this->total_cbm->CurrentValue;
		$this->total_cbm->PlaceHolder = RemoveHtml($this->total_cbm->caption());

		// offloom
		$this->offloom->EditAttrs["class"] = "form-control";
		$this->offloom->EditCustomAttributes = "";
		$this->offloom->EditValue = $this->offloom->CurrentValue;
		$this->offloom->PlaceHolder = RemoveHtml($this->offloom->caption());
		if (strval($this->offloom->EditValue) <> "" && is_numeric($this->offloom->EditValue))
			$this->offloom->EditValue = FormatNumber($this->offloom->EditValue, -2, -2, -2, -2);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// rejection
		$this->rejection->EditAttrs["class"] = "form-control";
		$this->rejection->EditCustomAttributes = "";
		$this->rejection->EditValue = $this->rejection->CurrentValue;
		$this->rejection->PlaceHolder = RemoveHtml($this->rejection->caption());

		// completed
		$this->completed->EditCustomAttributes = "";
		$this->completed->EditValue = $this->completed->options(FALSE);

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->reports_to->CurrentValue = HtmlDecode($this->reports_to->CurrentValue);
		$this->reports_to->EditValue = $this->reports_to->CurrentValue;
		$this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

		// weight_sqm
		$this->weight_sqm->EditAttrs["class"] = "form-control";
		$this->weight_sqm->EditCustomAttributes = "";
		$this->weight_sqm->EditValue = $this->weight_sqm->CurrentValue;
		$this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
		if (strval($this->weight_sqm->EditValue) <> "" && is_numeric($this->weight_sqm->EditValue))
			$this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->order_week);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->buyer_order);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->width);
					$doc->exportCaption($this->length);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->revised_qty);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->ex_factory);
					$doc->exportCaption($this->ex_factory_p);
					$doc->exportCaption($this->shipping_mode);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->d_qty);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->sailing_week);
					$doc->exportCaption($this->pending);
					$doc->exportCaption($this->pending_sqm);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->total_cbm);
					$doc->exportCaption($this->offloom);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->rejection);
					$doc->exportCaption($this->completed);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->weight_sqm);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->order_week);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->buyer_order);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->width);
					$doc->exportCaption($this->length);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->revised_qty);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->ex_factory);
					$doc->exportCaption($this->shipping_mode);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->d_qty);
					$doc->exportCaption($this->pending);
					$doc->exportCaption($this->pending_sqm);
					$doc->exportCaption($this->offloom);
					$doc->exportCaption($this->rejection);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->weight_sqm);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->order_week);
						$doc->exportField($this->order_date);
						$doc->exportField($this->buyer_order);
						$doc->exportField($this->po);
						$doc->exportField($this->item);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->design);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->width);
						$doc->exportField($this->length);
						$doc->exportField($this->qty);
						$doc->exportField($this->revised_qty);
						$doc->exportField($this->sqm);
						$doc->exportField($this->ex_factory);
						$doc->exportField($this->ex_factory_p);
						$doc->exportField($this->shipping_mode);
						$doc->exportField($this->remarks);
						$doc->exportField($this->d_qty);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->sailing_week);
						$doc->exportField($this->pending);
						$doc->exportField($this->pending_sqm);
						$doc->exportField($this->cbm);
						$doc->exportField($this->total_cbm);
						$doc->exportField($this->offloom);
						$doc->exportField($this->status);
						$doc->exportField($this->rejection);
						$doc->exportField($this->completed);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->weight_sqm);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->order_week);
						$doc->exportField($this->order_date);
						$doc->exportField($this->buyer_order);
						$doc->exportField($this->po);
						$doc->exportField($this->item);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->design);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->width);
						$doc->exportField($this->length);
						$doc->exportField($this->qty);
						$doc->exportField($this->revised_qty);
						$doc->exportField($this->sqm);
						$doc->exportField($this->ex_factory);
						$doc->exportField($this->shipping_mode);
						$doc->exportField($this->remarks);
						$doc->exportField($this->d_qty);
						$doc->exportField($this->pending);
						$doc->exportField($this->pending_sqm);
						$doc->exportField($this->offloom);
						$doc->exportField($this->rejection);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->weight_sqm);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>