<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for query_pppo_pending
 */
class query_pppo_pending extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $po;
	public $design_id;
	public $size_cm;
	public $despatch_week;
	public $Order;
	public $Received;
	public $Pending;
	public $Received_BC;
	public $Pending_BC;
	public $size_buyer;
	public $buyer_ref;
	public $buyers_id;
	public $pp_id;
	public $design;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'query_pppo_pending';
		$this->TableName = 'query_pppo_pending';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`query_pppo_pending`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// po
		$this->po = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// design_id
		$this->design_id = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`design_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->design_id->Sortable = TRUE; // Allow sort
		$this->design_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->design_id->Lookup = new Lookup('design_id', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design_id'] = &$this->design_id;

		// size_cm
		$this->size_cm = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Nullable = FALSE; // NOT NULL field
		$this->size_cm->Required = TRUE; // Required field
		$this->size_cm->Sortable = TRUE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// despatch_week
		$this->despatch_week = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// Order
		$this->Order = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_Order', 'Order', '`Order`', '`Order`', 20, -1, FALSE, '`Order`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Order->Nullable = FALSE; // NOT NULL field
		$this->Order->Required = TRUE; // Required field
		$this->Order->Sortable = TRUE; // Allow sort
		$this->Order->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Order'] = &$this->Order;

		// Received
		$this->Received = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_Received', 'Received', '`Received`', '`Received`', 20, -1, FALSE, '`Received`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Received->Nullable = FALSE; // NOT NULL field
		$this->Received->Required = TRUE; // Required field
		$this->Received->Sortable = TRUE; // Allow sort
		$this->Received->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Received'] = &$this->Received;

		// Pending
		$this->Pending = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_Pending', 'Pending', '`Pending`', '`Pending`', 20, -1, FALSE, '`Pending`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pending->Nullable = FALSE; // NOT NULL field
		$this->Pending->Required = TRUE; // Required field
		$this->Pending->Sortable = TRUE; // Allow sort
		$this->Pending->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Pending'] = &$this->Pending;

		// Received BC
		$this->Received_BC = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_Received_BC', 'Received BC', '`Received BC`', '`Received BC`', 201, -1, FALSE, '`Received BC`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Received_BC->Nullable = FALSE; // NOT NULL field
		$this->Received_BC->Required = TRUE; // Required field
		$this->Received_BC->Sortable = TRUE; // Allow sort
		$this->fields['Received BC'] = &$this->Received_BC;

		// Pending BC
		$this->Pending_BC = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_Pending_BC', 'Pending BC', '`Pending BC`', '`Pending BC`', 201, -1, FALSE, '`Pending BC`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Pending_BC->Nullable = FALSE; // NOT NULL field
		$this->Pending_BC->Required = TRUE; // Required field
		$this->Pending_BC->Sortable = TRUE; // Allow sort
		$this->fields['Pending BC'] = &$this->Pending_BC;

		// size_buyer
		$this->size_buyer = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_size_buyer', 'size_buyer', '`size_buyer`', '`size_buyer`', 200, -1, FALSE, '`size_buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_buyer->Sortable = TRUE; // Allow sort
		$this->fields['size_buyer'] = &$this->size_buyer;

		// buyer_ref
		$this->buyer_ref = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 201, -1, FALSE, '`buyer_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->buyer_ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_ref->Lookup = new Lookup('buyer_ref', 'partner_product_ref', FALSE, 'id', ["partner_ref","","",""], ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], '`partner_ref` ASC', '');
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// buyers_id
		$this->buyers_id = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyers_id->Lookup = new Lookup('buyers_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], ["x_buyer_ref"], [], [], [], [], '`name` ASC', '');
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// pp_id
		$this->pp_id = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_pp_id', 'pp_id', '`pp_id`', '`pp_id`', 19, -1, FALSE, '`pp_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pp_id->Sortable = TRUE; // Allow sort
		$this->pp_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pp_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pp_id->Lookup = new Lookup('pp_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pp_id'] = &$this->pp_id;

		// design
		$this->design = new DbField('query_pppo_pending', 'query_pppo_pending', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Sortable = FALSE; // Allow sort
		$this->design->Lookup = new Lookup('design', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design'] = &$this->design;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`query_pppo_pending`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`po` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->po->DbValue = $row['po'];
		$this->design_id->DbValue = $row['design_id'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->Order->DbValue = $row['Order'];
		$this->Received->DbValue = $row['Received'];
		$this->Pending->DbValue = $row['Pending'];
		$this->Received_BC->DbValue = $row['Received BC'];
		$this->Pending_BC->DbValue = $row['Pending BC'];
		$this->size_buyer->DbValue = $row['size_buyer'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->pp_id->DbValue = $row['pp_id'];
		$this->design->DbValue = $row['design'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "query_pppo_pendinglist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "query_pppo_pendingview.php")
			return $Language->phrase("View");
		elseif ($pageName == "query_pppo_pendingedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "query_pppo_pendingadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "query_pppo_pendinglist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("query_pppo_pendingview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("query_pppo_pendingview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "query_pppo_pendingadd.php?" . $this->getUrlParm($parm);
		else
			$url = "query_pppo_pendingadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("query_pppo_pendingedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("query_pppo_pendingadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("query_pppo_pendingdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->po->setDbValue($rs->fields('po'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->Order->setDbValue($rs->fields('Order'));
		$this->Received->setDbValue($rs->fields('Received'));
		$this->Pending->setDbValue($rs->fields('Pending'));
		$this->Received_BC->setDbValue($rs->fields('Received BC'));
		$this->Pending_BC->setDbValue($rs->fields('Pending BC'));
		$this->size_buyer->setDbValue($rs->fields('size_buyer'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->pp_id->setDbValue($rs->fields('pp_id'));
		$this->design->setDbValue($rs->fields('design'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// po
		// design_id
		// size_cm
		// despatch_week
		// Order
		// Received
		// Pending
		// Received BC
		// Pending BC
		// size_buyer
		// buyer_ref
		// buyers_id
		// pp_id
		// design

		$this->design->CellCssStyle = "white-space: nowrap;";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// design_id
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->ViewValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->ViewValue = NULL;
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// Order
		$this->Order->ViewValue = $this->Order->CurrentValue;
		$this->Order->ViewValue = FormatNumber($this->Order->ViewValue, 0, -2, -2, -2);
		$this->Order->ViewCustomAttributes = "";

		// Received
		$this->Received->ViewValue = $this->Received->CurrentValue;
		$this->Received->ViewValue = FormatNumber($this->Received->ViewValue, 0, -2, -2, -2);
		$this->Received->ViewCustomAttributes = "";

		// Pending
		$this->Pending->ViewValue = $this->Pending->CurrentValue;
		$this->Pending->ViewValue = FormatNumber($this->Pending->ViewValue, 0, -2, -2, -2);
		$this->Pending->ViewCustomAttributes = "";

		// Received BC
		$this->Received_BC->ViewValue = $this->Received_BC->CurrentValue;
		$this->Received_BC->ViewCustomAttributes = "";

		// Pending BC
		$this->Pending_BC->ViewValue = $this->Pending_BC->CurrentValue;
		$this->Pending_BC->ViewCustomAttributes = "";

		// size_buyer
		$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// buyer_ref
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->ViewValue = NULL;
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// buyers_id
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type` = 2 and `id` >= 1000 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->ViewValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// pp_id
		$curVal = strval($this->pp_id->CurrentValue);
		if ($curVal <> "") {
			$this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
			if ($this->pp_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type` = 1 and `id` >= 200000 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
				}
			}
		} else {
			$this->pp_id->ViewValue = NULL;
		}
		$this->pp_id->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$curVal = strval($this->design->CurrentValue);
		if ($curVal <> "") {
			$this->design->ViewValue = $this->design->lookupCacheOption($curVal);
			if ($this->design->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design->ViewValue = $this->design->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design->ViewValue = $this->design->CurrentValue;
				}
			}
		} else {
			$this->design->ViewValue = NULL;
		}
		$this->design->ViewCustomAttributes = "";

		// po
		$this->po->LinkCustomAttributes = "";
		if (!EmptyValue($this->po->CurrentValue)) {
			$this->po->HrefValue = "query_pppo_pendinglist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
			$this->po->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
		} else {
			$this->po->HrefValue = "";
		}
		$this->po->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->design_id->CurrentValue)) {
			$this->design_id->HrefValue = "query_pppo_pendinglist.php?x_design_id=" . $this->design_id->CurrentValue; // Add prefix/suffix
			$this->design_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
		} else {
			$this->design_id->HrefValue = "";
		}
		$this->design_id->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		if (!EmptyValue($this->size_cm->CurrentValue)) {
			$this->size_cm->HrefValue = "query_pppo_pendinglist.php?x_size_cm=" . $this->size_cm->CurrentValue; // Add prefix/suffix
			$this->size_cm->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->size_cm->HrefValue = FullUrl($this->size_cm->HrefValue, "href");
		} else {
			$this->size_cm->HrefValue = "";
		}
		$this->size_cm->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		if (!EmptyValue($this->despatch_week->CurrentValue)) {
			$this->despatch_week->HrefValue = "query_pppo_pendinglist.php?x_despatch_week=" . $this->despatch_week->CurrentValue; // Add prefix/suffix
			$this->despatch_week->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->despatch_week->HrefValue = FullUrl($this->despatch_week->HrefValue, "href");
		} else {
			$this->despatch_week->HrefValue = "";
		}
		$this->despatch_week->TooltipValue = "";

		// Order
		$this->Order->LinkCustomAttributes = "";
		$this->Order->HrefValue = "";
		$this->Order->TooltipValue = "";

		// Received
		$this->Received->LinkCustomAttributes = "";
		$this->Received->HrefValue = "";
		$this->Received->TooltipValue = "";

		// Pending
		$this->Pending->LinkCustomAttributes = "";
		$this->Pending->HrefValue = "";
		$this->Pending->TooltipValue = "";

		// Received BC
		$this->Received_BC->LinkCustomAttributes = "";
		$this->Received_BC->HrefValue = "";
		$this->Received_BC->TooltipValue = "";

		// Pending BC
		$this->Pending_BC->LinkCustomAttributes = "";
		$this->Pending_BC->HrefValue = "";
		$this->Pending_BC->TooltipValue = "";

		// size_buyer
		$this->size_buyer->LinkCustomAttributes = "";
		$this->size_buyer->HrefValue = "";
		$this->size_buyer->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyer_ref->CurrentValue)) {
			$this->buyer_ref->HrefValue = "query_pppo_pendinglist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
			$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
		} else {
			$this->buyer_ref->HrefValue = "";
		}
		$this->buyer_ref->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyers_id->CurrentValue)) {
			$this->buyers_id->HrefValue = "query_pppo_pendinglist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
			$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
		} else {
			$this->buyers_id->HrefValue = "";
		}
		$this->buyers_id->TooltipValue = "";

		// pp_id
		$this->pp_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->pp_id->CurrentValue)) {
			$this->pp_id->HrefValue = "query_pppo_pendinglist.php?x_pp_id=" . $this->pp_id->CurrentValue; // Add prefix/suffix
			$this->pp_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->pp_id->HrefValue = FullUrl($this->pp_id->HrefValue, "href");
		} else {
			$this->pp_id->HrefValue = "";
		}
		$this->pp_id->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->EditValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->EditValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->EditValue = NULL;
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";

		// Order
		$this->Order->EditAttrs["class"] = "form-control";
		$this->Order->EditCustomAttributes = "";
		$this->Order->EditValue = $this->Order->CurrentValue;
		$this->Order->PlaceHolder = RemoveHtml($this->Order->caption());

		// Received
		$this->Received->EditAttrs["class"] = "form-control";
		$this->Received->EditCustomAttributes = "";
		$this->Received->EditValue = $this->Received->CurrentValue;
		$this->Received->PlaceHolder = RemoveHtml($this->Received->caption());

		// Pending
		$this->Pending->EditAttrs["class"] = "form-control";
		$this->Pending->EditCustomAttributes = "";
		$this->Pending->EditValue = $this->Pending->CurrentValue;
		$this->Pending->PlaceHolder = RemoveHtml($this->Pending->caption());

		// Received BC
		$this->Received_BC->EditAttrs["class"] = "form-control";
		$this->Received_BC->EditCustomAttributes = "";
		$this->Received_BC->EditValue = $this->Received_BC->CurrentValue;
		$this->Received_BC->PlaceHolder = RemoveHtml($this->Received_BC->caption());

		// Pending BC
		$this->Pending_BC->EditAttrs["class"] = "form-control";
		$this->Pending_BC->EditCustomAttributes = "";
		$this->Pending_BC->EditValue = $this->Pending_BC->CurrentValue;
		$this->Pending_BC->PlaceHolder = RemoveHtml($this->Pending_BC->caption());

		// size_buyer
		$this->size_buyer->EditAttrs["class"] = "form-control";
		$this->size_buyer->EditCustomAttributes = "";
		$this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->EditValue = NULL;
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type` = 2 and `id` >= 1000 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->EditValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// pp_id
		$this->pp_id->EditAttrs["class"] = "form-control";
		$this->pp_id->EditCustomAttributes = "";

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->PlaceHolder = RemoveHtml($this->design->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->Order->CurrentValue))
				$this->Order->Total += $this->Order->CurrentValue; // Accumulate total
			if (is_numeric($this->Received->CurrentValue))
				$this->Received->Total += $this->Received->CurrentValue; // Accumulate total
			if (is_numeric($this->Pending->CurrentValue))
				$this->Pending->Total += $this->Pending->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->Order->CurrentValue = $this->Order->Total;
			$this->Order->ViewValue = $this->Order->CurrentValue;
			$this->Order->ViewValue = FormatNumber($this->Order->ViewValue, 0, -2, -2, -2);
			$this->Order->ViewCustomAttributes = "";
			$this->Order->HrefValue = ""; // Clear href value
			$this->Received->CurrentValue = $this->Received->Total;
			$this->Received->ViewValue = $this->Received->CurrentValue;
			$this->Received->ViewValue = FormatNumber($this->Received->ViewValue, 0, -2, -2, -2);
			$this->Received->ViewCustomAttributes = "";
			$this->Received->HrefValue = ""; // Clear href value
			$this->Pending->CurrentValue = $this->Pending->Total;
			$this->Pending->ViewValue = $this->Pending->CurrentValue;
			$this->Pending->ViewValue = FormatNumber($this->Pending->ViewValue, 0, -2, -2, -2);
			$this->Pending->ViewCustomAttributes = "";
			$this->Pending->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->Order);
					$doc->exportCaption($this->Received);
					$doc->exportCaption($this->Pending);
					$doc->exportCaption($this->Received_BC);
					$doc->exportCaption($this->Pending_BC);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->pp_id);
				} else {
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->Order);
					$doc->exportCaption($this->Received);
					$doc->exportCaption($this->Pending);
					$doc->exportCaption($this->Received_BC);
					$doc->exportCaption($this->Pending_BC);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->pp_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->po);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->Order);
						$doc->exportField($this->Received);
						$doc->exportField($this->Pending);
						$doc->exportField($this->Received_BC);
						$doc->exportField($this->Pending_BC);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->pp_id);
					} else {
						$doc->exportField($this->po);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->Order);
						$doc->exportField($this->Received);
						$doc->exportField($this->Pending);
						$doc->exportField($this->Received_BC);
						$doc->exportField($this->Pending_BC);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->pp_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->design_id, '');
				$doc->exportAggregate($this->size_cm, '');
				$doc->exportAggregate($this->despatch_week, '');
				$doc->exportAggregate($this->Order, 'TOTAL');
				$doc->exportAggregate($this->Received, 'TOTAL');
				$doc->exportAggregate($this->Pending, 'TOTAL');
				$doc->exportAggregate($this->Received_BC, '');
				$doc->exportAggregate($this->Pending_BC, '');
				$doc->exportAggregate($this->size_buyer, '');
				$doc->exportAggregate($this->buyer_ref, '');
				$doc->exportAggregate($this->buyers_id, '');
				$doc->exportAggregate($this->pp_id, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>