<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class query_production_search extends query_production
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'query_production';

	// Page object name
	public $PageObjName = "query_production_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (query_production)
		if (!isset($GLOBALS["query_production"]) || get_class($GLOBALS["query_production"]) == PROJECT_NAMESPACE . "query_production") {
			$GLOBALS["query_production"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["query_production"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'query_production');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $query_production;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($query_production);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "query_productionview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("query_productionlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->buyer->setVisibility();
		$this->po->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->design->Visible = FALSE;
		$this->size->Visible = FALSE;
		$this->design_id->setVisibility();
		$this->size_cm->setVisibility();
		$this->Weaving->setVisibility();
		$this->Packing->setVisibility();
		$this->order_quantity->setVisibility();
		$this->count->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_a->setVisibility();
		$this->process_c->Visible = FALSE;
		$this->process_d->Visible = FALSE;
		$this->status->setVisibility();
		$this->_barcode->setVisibility();
		$this->dispatch_week_p->setVisibility();
		$this->current_works->setVisibility();
		$this->shipping_type->setVisibility();
		$this->batch_no->setVisibility();
		$this->process->setVisibility();
		$this->url->Visible = FALSE;
		$this->URL_DSP->Visible = FALSE;
		$this->id->Visible = FALSE;
		$this->buyer_barcode->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->po);
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->dispatch_week_p);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->shipping_type);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->process);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "query_productionlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->buyer); // buyer
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
		$this->buildSearchUrl($srchUrl, $this->design_id); // design_id
		$this->buildSearchUrl($srchUrl, $this->size_cm); // size_cm
		$this->buildSearchUrl($srchUrl, $this->Weaving); // Weaving
		$this->buildSearchUrl($srchUrl, $this->Packing); // Packing
		$this->buildSearchUrl($srchUrl, $this->order_quantity); // order_quantity
		$this->buildSearchUrl($srchUrl, $this->count); // count
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->sqm_a); // sqm_a
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
		$this->buildSearchUrl($srchUrl, $this->dispatch_week_p); // dispatch_week_p
		$this->buildSearchUrl($srchUrl, $this->current_works); // current_works
		$this->buildSearchUrl($srchUrl, $this->shipping_type); // shipping_type
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->process); // process
		$this->buildSearchUrl($srchUrl, $this->buyer_barcode); // buyer_barcode
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// buyer

		if (!$this->isAddOrEdit())
			$this->buyer->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer"));
		$this->buyer->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));
		$this->po->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_po"));
		$this->po->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_po"));
		$this->po->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_po"));

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_ref"));
		$this->buyer_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_ref"));

		// design_id
		if (!$this->isAddOrEdit())
			$this->design_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design_id"));
		$this->design_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design_id"));

		// size_cm
		if (!$this->isAddOrEdit())
			$this->size_cm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size_cm"));
		$this->size_cm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size_cm"));

		// Weaving
		if (!$this->isAddOrEdit())
			$this->Weaving->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Weaving"));
		$this->Weaving->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Weaving"));
		$this->Weaving->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_Weaving"));
		$this->Weaving->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_Weaving"));
		$this->Weaving->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_Weaving"));

		// Packing
		if (!$this->isAddOrEdit())
			$this->Packing->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Packing"));
		$this->Packing->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Packing"));
		$this->Packing->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_Packing"));
		$this->Packing->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_Packing"));
		$this->Packing->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_Packing"));

		// order_quantity
		if (!$this->isAddOrEdit())
			$this->order_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_quantity"));
		$this->order_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_quantity"));

		// count
		if (!$this->isAddOrEdit())
			$this->count->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_count"));
		$this->count->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_count"));
		$this->count->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_count"));
		$this->count->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_count"));
		$this->count->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_count"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// sqm_a
		if (!$this->isAddOrEdit())
			$this->sqm_a->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm_a"));
		$this->sqm_a->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm_a"));

		// process_c
		if (!$this->isAddOrEdit())
			$this->process_c->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_c"));
		$this->process_c->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_c"));

		// process_d
		if (!$this->isAddOrEdit())
			$this->process_d->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_d"));
		$this->process_d->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_d"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__barcode"));
		$this->_barcode->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v__barcode"));
		$this->_barcode->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w__barcode"));

		// dispatch_week_p
		if (!$this->isAddOrEdit())
			$this->dispatch_week_p->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dispatch_week_p"));
		$this->dispatch_week_p->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dispatch_week_p"));
		$this->dispatch_week_p->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_dispatch_week_p"));
		$this->dispatch_week_p->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_dispatch_week_p"));
		$this->dispatch_week_p->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_dispatch_week_p"));

		// current_works
		if (!$this->isAddOrEdit())
			$this->current_works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_current_works"));
		$this->current_works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_current_works"));

		// shipping_type
		if (!$this->isAddOrEdit())
			$this->shipping_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipping_type"));
		$this->shipping_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipping_type"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process"));
		$this->process->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process"));
		if (is_array($this->process->AdvancedSearch->SearchValue))
			$this->process->AdvancedSearch->SearchValue = implode(",", $this->process->AdvancedSearch->SearchValue);
		if (is_array($this->process->AdvancedSearch->SearchValue2))
			$this->process->AdvancedSearch->SearchValue2 = implode(",", $this->process->AdvancedSearch->SearchValue2);

		// buyer_barcode
		if (!$this->isAddOrEdit())
			$this->buyer_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_barcode"));
		$this->buyer_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_barcode"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_a->FormValue == $this->sqm_a->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_a->CurrentValue)))
			$this->sqm_a->CurrentValue = ConvertToFloatString($this->sqm_a->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// buyer
		// po
		// buyer_ref
		// design
		// size
		// design_id
		// size_cm
		// Weaving
		// Packing
		// order_quantity
		// count
		// sqm
		// sqm_a
		// process_c
		// process_d
		// status
		// barcode
		// dispatch_week_p
		// current_works
		// shipping_type
		// batch_no
		// process
		// url
		// URL_DSP
		// id
		// buyer_barcode

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// buyer
			if ($this->buyer->VirtualValue <> "") {
				$this->buyer->ViewValue = $this->buyer->VirtualValue;
			} else {
				$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			}
			$this->buyer->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$curVal = strval($this->po->CurrentValue);
			if ($curVal <> "") {
				$this->po->ViewValue = $this->po->lookupCacheOption($curVal);
				if ($this->po->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`po`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->po->ViewValue = $this->po->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po->ViewValue = $this->po->CurrentValue;
					}
				}
			} else {
				$this->po->ViewValue = NULL;
			}
			$this->po->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
			$this->buyer_ref->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// design_id
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->ViewValue = $this->design_id->VirtualValue;
			} else {
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// Weaving
			if (strval($this->Weaving->CurrentValue) <> "") {
				$this->Weaving->ViewValue = $this->Weaving->optionCaption($this->Weaving->CurrentValue);
			} else {
				$this->Weaving->ViewValue = NULL;
			}
			$this->Weaving->ViewCustomAttributes = "";

			// Packing
			if (strval($this->Packing->CurrentValue) <> "") {
				$this->Packing->ViewValue = $this->Packing->optionCaption($this->Packing->CurrentValue);
			} else {
				$this->Packing->ViewValue = NULL;
			}
			$this->Packing->ViewCustomAttributes = "";

			// order_quantity
			$this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
			$this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, 0, -2, -2, -2);
			$this->order_quantity->ViewCustomAttributes = "";

			// count
			$this->count->ViewValue = $this->count->CurrentValue;
			$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
			$this->count->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_a
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";

			// process_c
			$this->process_c->ViewValue = $this->process_c->CurrentValue;
			$this->process_c->ViewCustomAttributes = "";

			// process_d
			$this->process_d->ViewValue = $this->process_d->CurrentValue;
			$this->process_d->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// dispatch_week_p
			$curVal = strval($this->dispatch_week_p->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
				if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`weekstartday` >= date_add(NOW(), INTERVAL -28 Day)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatDateTime($rswrk->fields('df2'), 0);
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
					}
				}
			} else {
				$this->dispatch_week_p->ViewValue = NULL;
			}
			$this->dispatch_week_p->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// shipping_type
			$curVal = strval($this->shipping_type->CurrentValue);
			if ($curVal <> "") {
				$this->shipping_type->ViewValue = $this->shipping_type->lookupCacheOption($curVal);
				if ($this->shipping_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shipping_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shipping_type->ViewValue = $this->shipping_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shipping_type->ViewValue = $this->shipping_type->CurrentValue;
					}
				}
			} else {
				$this->shipping_type->ViewValue = NULL;
			}
			$this->shipping_type->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// process
			if ($this->process->VirtualValue <> "") {
				$this->process->ViewValue = $this->process->VirtualValue;
			} else {
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process->ViewValue->add($this->process->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			}
			$this->process->ViewCustomAttributes = "";

			// buyer_barcode
			$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
			$this->buyer_barcode->ViewCustomAttributes = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer->CurrentValue)) {
				$this->buyer->HrefValue = "query_productionlist.php?x_buyer=" . $this->buyer->CurrentValue; // Add prefix/suffix
				$this->buyer->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer->HrefValue = FullUrl($this->buyer->HrefValue, "href");
			} else {
				$this->buyer->HrefValue = "";
			}
			$this->buyer->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			if (!EmptyValue($this->po->CurrentValue)) {
				$this->po->HrefValue = "query_productionlist.php?x_design_id=" . $this->po->CurrentValue; // Add prefix/suffix
				$this->po->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
			} else {
				$this->po->HrefValue = "";
			}
			$this->po->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->design_id->CurrentValue)) {
				$this->design_id->HrefValue = "query_productionlist.php?x_design_id=" . ((!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue)) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
				$this->design_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
			} else {
				$this->design_id->HrefValue = "";
			}
			$this->design_id->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			if (!EmptyValue($this->URL_DSP->CurrentValue)) {
				$this->size_cm->HrefValue = $this->URL_DSP->CurrentValue; // Add prefix/suffix
				$this->size_cm->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->size_cm->HrefValue = FullUrl($this->size_cm->HrefValue, "href");
			} else {
				$this->size_cm->HrefValue = "";
			}
			$this->size_cm->TooltipValue = "";

			// Weaving
			$this->Weaving->LinkCustomAttributes = "";
			if (!EmptyValue($this->Weaving->CurrentValue)) {
				$this->Weaving->HrefValue = "query_productionlist.php?x_Weaving=" . $this->Weaving->CurrentValue; // Add prefix/suffix
				$this->Weaving->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->Weaving->HrefValue = FullUrl($this->Weaving->HrefValue, "href");
			} else {
				$this->Weaving->HrefValue = "";
			}
			$this->Weaving->TooltipValue = "";

			// Packing
			$this->Packing->LinkCustomAttributes = "";
			if (!EmptyValue($this->Packing->CurrentValue)) {
				$this->Packing->HrefValue = "query_productionlist.php?x_Packing=" . $this->Packing->CurrentValue; // Add prefix/suffix
				$this->Packing->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->Packing->HrefValue = FullUrl($this->Packing->HrefValue, "href");
			} else {
				$this->Packing->HrefValue = "";
			}
			$this->Packing->TooltipValue = "";

			// order_quantity
			$this->order_quantity->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->order_quantity->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->order_quantity->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->order_quantity->HrefValue = FullUrl($this->order_quantity->HrefValue, "href");
			} else {
				$this->order_quantity->HrefValue = "";
			}
			$this->order_quantity->TooltipValue = "";

			// count
			$this->count->LinkCustomAttributes = "";
			$this->count->HrefValue = "";
			$this->count->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_a
			$this->sqm_a->LinkCustomAttributes = "";
			$this->sqm_a->HrefValue = "";
			$this->sqm_a->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->_barcode->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->_barcode->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->_barcode->HrefValue = FullUrl($this->_barcode->HrefValue, "href");
			} else {
				$this->_barcode->HrefValue = "";
			}
			$this->_barcode->TooltipValue = "";

			// dispatch_week_p
			$this->dispatch_week_p->LinkCustomAttributes = "";
			$this->dispatch_week_p->HrefValue = "";
			$this->dispatch_week_p->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";
			$this->current_works->TooltipValue = "";

			// shipping_type
			$this->shipping_type->LinkCustomAttributes = "";
			$this->shipping_type->HrefValue = "";
			$this->shipping_type->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// buyer_barcode
			$this->buyer_barcode->LinkCustomAttributes = "";
			$this->buyer_barcode->HrefValue = "";
			$this->buyer_barcode->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$curVal = strval($this->po->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->po->EditValue = $this->po->lookupCacheOption($curVal);
				if ($this->po->EditValue === NULL) { // Lookup from database
					$filterWrk = "`po`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$this->po->EditValue = $this->po->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->po->EditValue = NULL;
			}
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$curVal = strval($this->po->AdvancedSearch->SearchValue2);
			if ($curVal <> "") {
				$this->po->EditValue2 = $this->po->lookupCacheOption($curVal);
				if ($this->po->EditValue2 === NULL) { // Lookup from database
					$filterWrk = "`po`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$this->po->EditValue2 = $this->po->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
					}
				}
			} else {
				$this->po->EditValue2 = NULL;
			}
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// design_id
			$this->design_id->EditAttrs["class"] = "form-control";
			$this->design_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design_id->AdvancedSearch->SearchValue = HtmlDecode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->EditValue = HtmlEncode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

			// size_cm
			$this->size_cm->EditAttrs["class"] = "form-control";
			$this->size_cm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

			// Weaving
			$this->Weaving->EditAttrs["class"] = "form-control";
			$this->Weaving->EditCustomAttributes = "";
			$this->Weaving->EditValue = $this->Weaving->options(TRUE);
			$this->Weaving->EditAttrs["class"] = "form-control";
			$this->Weaving->EditCustomAttributes = "";
			$this->Weaving->EditValue2 = $this->Weaving->options(TRUE);

			// Packing
			$this->Packing->EditAttrs["class"] = "form-control";
			$this->Packing->EditCustomAttributes = "";
			$this->Packing->EditValue = $this->Packing->options(TRUE);
			$this->Packing->EditAttrs["class"] = "form-control";
			$this->Packing->EditCustomAttributes = "";
			$this->Packing->EditValue2 = $this->Packing->options(TRUE);

			// order_quantity
			$this->order_quantity->EditAttrs["class"] = "form-control";
			$this->order_quantity->EditCustomAttributes = "";
			$this->order_quantity->EditValue = HtmlEncode($this->order_quantity->AdvancedSearch->SearchValue);
			$this->order_quantity->PlaceHolder = RemoveHtml($this->order_quantity->caption());

			// count
			$this->count->EditAttrs["class"] = "form-control";
			$this->count->EditCustomAttributes = "";
			$this->count->EditValue = HtmlEncode($this->count->AdvancedSearch->SearchValue);
			$this->count->PlaceHolder = RemoveHtml($this->count->caption());
			$this->count->EditAttrs["class"] = "form-control";
			$this->count->EditCustomAttributes = "";
			$this->count->EditValue2 = HtmlEncode($this->count->AdvancedSearch->SearchValue2);
			$this->count->PlaceHolder = RemoveHtml($this->count->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// sqm_a
			$this->sqm_a->EditAttrs["class"] = "form-control";
			$this->sqm_a->EditCustomAttributes = "";
			$this->sqm_a->EditValue = HtmlEncode($this->sqm_a->AdvancedSearch->SearchValue);
			$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_barcode->AdvancedSearch->SearchValue2 = HtmlDecode($this->_barcode->AdvancedSearch->SearchValue2);
			$this->_barcode->EditValue2 = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue2);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// dispatch_week_p
			$this->dispatch_week_p->EditAttrs["class"] = "form-control";
			$this->dispatch_week_p->EditCustomAttributes = "";
			$curVal = trim(strval($this->dispatch_week_p->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
			else
				$this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->Lookup !== NULL && is_array($this->dispatch_week_p->Lookup->Options) ? $curVal : NULL;
			if ($this->dispatch_week_p->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->dispatch_week_p->EditValue = array_values($this->dispatch_week_p->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->dispatch_week_p->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`weekstartday` >= date_add(NOW(), INTERVAL -28 Day)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->dispatch_week_p->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatDateTime($arwrk[$i][2], 0);
				}
				$this->dispatch_week_p->EditValue = $arwrk;
			}
			$this->dispatch_week_p->EditAttrs["class"] = "form-control";
			$this->dispatch_week_p->EditCustomAttributes = "";
			$curVal = trim(strval($this->dispatch_week_p->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->dispatch_week_p->AdvancedSearch->ViewValue2 = $this->dispatch_week_p->lookupCacheOption($curVal);
			else
				$this->dispatch_week_p->AdvancedSearch->ViewValue2 = $this->dispatch_week_p->Lookup !== NULL && is_array($this->dispatch_week_p->Lookup->Options) ? $curVal : NULL;
			if ($this->dispatch_week_p->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->dispatch_week_p->EditValue2 = array_values($this->dispatch_week_p->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->dispatch_week_p->AdvancedSearch->SearchValue2, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`weekstartday` >= date_add(NOW(), INTERVAL -28 Day)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->dispatch_week_p->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatDateTime($arwrk[$i][2], 0);
				}
				$this->dispatch_week_p->EditValue2 = $arwrk;
			}

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
			else
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== NULL && is_array($this->current_works->Lookup->Options) ? $curVal : NULL;
			if ($this->current_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->current_works->EditValue = array_values($this->current_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->current_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->current_works->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->current_works->EditValue = $arwrk;
			}

			// shipping_type
			$this->shipping_type->EditAttrs["class"] = "form-control";
			$this->shipping_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->shipping_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->shipping_type->AdvancedSearch->ViewValue = $this->shipping_type->lookupCacheOption($curVal);
			else
				$this->shipping_type->AdvancedSearch->ViewValue = $this->shipping_type->Lookup !== NULL && is_array($this->shipping_type->Lookup->Options) ? $curVal : NULL;
			if ($this->shipping_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->shipping_type->EditValue = array_values($this->shipping_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->shipping_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 82";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shipping_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shipping_type->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->process->AdvancedSearch->SearchValue = HtmlDecode($this->process->AdvancedSearch->SearchValue);
			$this->process->EditValue = HtmlEncode($this->process->AdvancedSearch->SearchValue);
			$this->process->PlaceHolder = RemoveHtml($this->process->caption());

			// buyer_barcode
			$this->buyer_barcode->EditAttrs["class"] = "form-control";
			$this->buyer_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->order_quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->order_quantity->errorMessage());
		}
		if (!CheckInteger($this->count->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->count->errorMessage());
		}
		if (!CheckInteger($this->count->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->count->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckNumber($this->sqm_a->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm_a->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->buyer->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->size_cm->AdvancedSearch->load();
		$this->Weaving->AdvancedSearch->load();
		$this->Packing->AdvancedSearch->load();
		$this->order_quantity->AdvancedSearch->load();
		$this->count->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_a->AdvancedSearch->load();
		$this->process_c->AdvancedSearch->load();
		$this->process_d->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->dispatch_week_p->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->shipping_type->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->buyer_barcode->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("query_productionlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_design_id":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_dispatch_week_p":
					$lookupFilter = function() {
						return "`weekstartday` >= date_add(NOW(), INTERVAL -28 Day)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shipping_type":
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer":
							break;
						case "x_po":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_design_id":
							break;
						case "x_status":
							break;
						case "x_dispatch_week_p":
							$row[2] = FormatDateTime($row[2], 0);
							$row['df2'] = $row[2];
							break;
						case "x_current_works":
							break;
						case "x_shipping_type":
							break;
						case "x_batch_no":
							break;
						case "x_process":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>