<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for query_production_table
 */
class query_production_table extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $buyer;
	public $po;
	public $buyer_ref;
	public $design_id;
	public $size_cm;
	public $Weaving;
	public $Packing;
	public $order_quantity;
	public $count;
	public $sqm;
	public $sqm_a;
	public $process_c;
	public $process_d;
	public $_barcode;
	public $status;
	public $dispatch_week_p;
	public $current_works;
	public $batch_no;
	public $process;
	public $url;
	public $id;
	public $URL_DSP;
	public $buyer_barcode;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'query_production_table';
		$this->TableName = 'query_production_table';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`query_production_table`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// buyer
		$this->buyer = new DbField('query_production_table', 'query_production_table', 'x_buyer', 'buyer', '`buyer`', '`buyer`', 18, -1, FALSE, '`EV__buyer`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer->Sortable = TRUE; // Allow sort
		$this->buyer->Lookup = new Lookup('buyer', 'buyer', FALSE, 'id', ["code","","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->fields['buyer'] = &$this->buyer;

		// po
		$this->po = new DbField('query_production_table', 'query_production_table', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->fields['po'] = &$this->po;

		// buyer_ref
		$this->buyer_ref = new DbField('query_production_table', 'query_production_table', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 201, -1, FALSE, '`buyer_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// design_id
		$this->design_id = new DbField('query_production_table', 'query_production_table', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`EV__design_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->design_id->Sortable = FALSE; // Allow sort
		$this->design_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->design_id->Lookup = new Lookup('design_id', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design_id'] = &$this->design_id;

		// size_cm
		$this->size_cm = new DbField('query_production_table', 'query_production_table', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Sortable = TRUE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// Weaving
		$this->Weaving = new DbField('query_production_table', 'query_production_table', 'x_Weaving', 'Weaving', '`Weaving`', '`Weaving`', 200, -1, FALSE, '`Weaving`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Weaving->Required = TRUE; // Required field
		$this->Weaving->Sortable = TRUE; // Allow sort
		$this->Weaving->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Weaving->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->Weaving->Lookup = new Lookup('Weaving', 'query_production_table', TRUE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Weaving->OptionCount = 2;
		$this->fields['Weaving'] = &$this->Weaving;

		// Packing
		$this->Packing = new DbField('query_production_table', 'query_production_table', 'x_Packing', 'Packing', '`Packing`', '`Packing`', 200, -1, FALSE, '`Packing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Packing->Sortable = TRUE; // Allow sort
		$this->Packing->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->Packing->Lookup = new Lookup('Packing', 'query_production', TRUE, 'Packing', ["Packing","","",""], [], [], [], [], [], [], '`Packing` ASC', '');
		$this->Packing->OptionCount = 3;
		$this->fields['Packing'] = &$this->Packing;

		// order_quantity
		$this->order_quantity = new DbField('query_production_table', 'query_production_table', 'x_order_quantity', 'order_quantity', '`order_quantity`', '`order_quantity`', 18, -1, FALSE, '`order_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_quantity->Sortable = TRUE; // Allow sort
		$this->order_quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['order_quantity'] = &$this->order_quantity;

		// count
		$this->count = new DbField('query_production_table', 'query_production_table', 'x_count', 'count', '`count`', '`count`', 18, -1, FALSE, '`count`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->count->Sortable = TRUE; // Allow sort
		$this->count->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['count'] = &$this->count;

		// sqm
		$this->sqm = new DbField('query_production_table', 'query_production_table', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// sqm_a
		$this->sqm_a = new DbField('query_production_table', 'query_production_table', 'x_sqm_a', 'sqm_a', '`sqm_a`', '`sqm_a`', 131, -1, FALSE, '`sqm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_a->Sortable = TRUE; // Allow sort
		$this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_a'] = &$this->sqm_a;

		// process_c
		$this->process_c = new DbField('query_production_table', 'query_production_table', 'x_process_c', 'process_c', '`process_c`', '`process_c`', 200, -1, FALSE, '`process_c`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process_c->Sortable = TRUE; // Allow sort
		$this->fields['process_c'] = &$this->process_c;

		// process_d
		$this->process_d = new DbField('query_production_table', 'query_production_table', 'x_process_d', 'process_d', '`process_d`', '`process_d`', 200, -1, FALSE, '`process_d`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process_d->Sortable = TRUE; // Allow sort
		$this->fields['process_d'] = &$this->process_d;

		// barcode
		$this->_barcode = new DbField('query_production_table', 'query_production_table', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 201, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->fields['barcode'] = &$this->_barcode;

		// status
		$this->status = new DbField('query_production_table', 'query_production_table', 'x_status', 'status', '`status`', '`status`', 2, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'status', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// dispatch_week_p
		$this->dispatch_week_p = new DbField('query_production_table', 'query_production_table', 'x_dispatch_week_p', 'dispatch_week_p', '`dispatch_week_p`', '`dispatch_week_p`', 18, -1, FALSE, '`dispatch_week_p`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->dispatch_week_p->Nullable = FALSE; // NOT NULL field
		$this->dispatch_week_p->Required = TRUE; // Required field
		$this->dispatch_week_p->Sortable = TRUE; // Allow sort
		$this->dispatch_week_p->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->dispatch_week_p->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->dispatch_week_p->Lookup = new Lookup('dispatch_week_p', 'not_week', FALSE, 'id', ["week","wsd","",""], [], [], [], [], [], [], '`week` ASC', '');
		$this->dispatch_week_p->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['dispatch_week_p'] = &$this->dispatch_week_p;

		// current_works
		$this->current_works = new DbField('query_production_table', 'query_production_table', 'x_current_works', 'current_works', '`current_works`', '`current_works`', 18, -1, FALSE, '`current_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->current_works->Sortable = TRUE; // Allow sort
		$this->current_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->current_works->Lookup = new Lookup('current_works', 'godown', FALSE, 'id', ["code","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['current_works'] = &$this->current_works;

		// batch_no
		$this->batch_no = new DbField('query_production_table', 'query_production_table', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","","",""], [], [], [], [], [], [], '`batch_no` ASC', '');
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// process
		$this->process = new DbField('query_production_table', 'query_production_table', 'x_process', 'process', '`process`', '`process`', 200, -1, FALSE, '`EV__process`', TRUE, TRUE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process->Sortable = FALSE; // Allow sort
		$this->process->SelectMultiple = TRUE; // Multiple select
		$this->process->Lookup = new Lookup('process', 'sub_process_type', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process'] = &$this->process;

		// url
		$this->url = new DbField('query_production_table', 'query_production_table', 'x_url', 'url', '`url`', '`url`', 201, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;

		// id
		$this->id = new DbField('query_production_table', 'query_production_table', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = FALSE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// URL_DSP
		$this->URL_DSP = new DbField('query_production_table', 'query_production_table', 'x_URL_DSP', 'URL_DSP', 'concat(\'query_production_tablelist.php?x_size_cm=\', `size_cm`, \'&x_po=\', `po`)', 'concat(\'query_production_tablelist.php?x_size_cm=\', `size_cm`, \'&x_po=\', `po`)', 201, -1, FALSE, 'concat(\'query_production_tablelist.php?x_size_cm=\', `size_cm`, \'&x_po=\', `po`)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->URL_DSP->IsCustom = TRUE; // Custom field
		$this->URL_DSP->Sortable = TRUE; // Allow sort
		$this->fields['URL_DSP'] = &$this->URL_DSP;

		// buyer_barcode
		$this->buyer_barcode = new DbField('query_production_table', 'query_production_table', 'x_buyer_barcode', 'buyer_barcode', '`buyer_barcode`', '`buyer_barcode`', 200, -1, FALSE, '`buyer_barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_barcode->Sortable = TRUE; // Allow sort
		$this->fields['buyer_barcode'] = &$this->buyer_barcode;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`query_production_table`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, concat('query_production_tablelist.php?x_size_cm=', `size_cm`, '&x_po=', `po`) AS `URL_DSP` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, concat('query_production_tablelist.php?x_size_cm=', `size_cm`, '&x_po=', `po`) AS `URL_DSP`, (SELECT `code` FROM `buyer` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `query_production_table`.`buyer` LIMIT 1) AS `EV__buyer`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `query_production_table`.`design_id` LIMIT 1) AS `EV__design_id`, (SELECT `name` FROM `sub_process_type` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `query_production_table`.`process` LIMIT 1) AS `EV__process` FROM `query_production_table`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`po` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->buyer->AdvancedSearch->SearchValue <> "" ||
			$this->buyer->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->buyer->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->buyer->VirtualExpression . " "))
			return TRUE;
		if ($this->design_id->AdvancedSearch->SearchValue <> "" ||
			$this->design_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->design_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->design_id->VirtualExpression . " "))
			return TRUE;
		if ($this->process->AdvancedSearch->SearchValue <> "" ||
			$this->process->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->process->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->process->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->buyer->DbValue = $row['buyer'];
		$this->po->DbValue = $row['po'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->design_id->DbValue = $row['design_id'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->Weaving->DbValue = $row['Weaving'];
		$this->Packing->DbValue = $row['Packing'];
		$this->order_quantity->DbValue = $row['order_quantity'];
		$this->count->DbValue = $row['count'];
		$this->sqm->DbValue = $row['sqm'];
		$this->sqm_a->DbValue = $row['sqm_a'];
		$this->process_c->DbValue = $row['process_c'];
		$this->process_d->DbValue = $row['process_d'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->status->DbValue = $row['status'];
		$this->dispatch_week_p->DbValue = $row['dispatch_week_p'];
		$this->current_works->DbValue = $row['current_works'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->process->DbValue = $row['process'];
		$this->url->DbValue = $row['url'];
		$this->id->DbValue = $row['id'];
		$this->URL_DSP->DbValue = $row['URL_DSP'];
		$this->buyer_barcode->DbValue = $row['buyer_barcode'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "query_production_tablelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "query_production_tableview.php")
			return $Language->phrase("View");
		elseif ($pageName == "query_production_tableedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "query_production_tableadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "query_production_tablelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("query_production_tableview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("query_production_tableview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "query_production_tableadd.php?" . $this->getUrlParm($parm);
		else
			$url = "query_production_tableadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("query_production_tableedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("query_production_tableadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("query_production_tabledelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->buyer->setDbValue($rs->fields('buyer'));
		$this->po->setDbValue($rs->fields('po'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->Weaving->setDbValue($rs->fields('Weaving'));
		$this->Packing->setDbValue($rs->fields('Packing'));
		$this->order_quantity->setDbValue($rs->fields('order_quantity'));
		$this->count->setDbValue($rs->fields('count'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->sqm_a->setDbValue($rs->fields('sqm_a'));
		$this->process_c->setDbValue($rs->fields('process_c'));
		$this->process_d->setDbValue($rs->fields('process_d'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->status->setDbValue($rs->fields('status'));
		$this->dispatch_week_p->setDbValue($rs->fields('dispatch_week_p'));
		$this->current_works->setDbValue($rs->fields('current_works'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->process->setDbValue($rs->fields('process'));
		$this->url->setDbValue($rs->fields('url'));
		$this->id->setDbValue($rs->fields('id'));
		$this->URL_DSP->setDbValue($rs->fields('URL_DSP'));
		$this->buyer_barcode->setDbValue($rs->fields('buyer_barcode'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// buyer
		// po
		// buyer_ref
		// design_id

		$this->design_id->CellCssStyle = "white-space: nowrap;";

		// size_cm
		// Weaving
		// Packing
		// order_quantity
		// count
		// sqm
		// sqm_a
		// process_c
		// process_d
		// barcode

		$this->_barcode->CellCssStyle = "width: 300px;";

		// status
		// dispatch_week_p
		// current_works
		// batch_no
		// process

		$this->process->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->CellCssStyle = "white-space: nowrap;";

		// URL_DSP
		// buyer_barcode
		// buyer

		if ($this->buyer->VirtualValue <> "") {
			$this->buyer->ViewValue = $this->buyer->VirtualValue;
		} else {
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
		$curVal = strval($this->buyer->CurrentValue);
		if ($curVal <> "") {
			$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
			if ($this->buyer->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer->ViewValue = $this->buyer->CurrentValue;
				}
			}
		} else {
			$this->buyer->ViewValue = NULL;
		}
		}
		$this->buyer->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
		$this->buyer_ref->ViewCustomAttributes = "";

		// design_id
		if ($this->design_id->VirtualValue <> "") {
			$this->design_id->ViewValue = $this->design_id->VirtualValue;
		} else {
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1 and `grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->ViewValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->ViewValue = NULL;
		}
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// Weaving
		if (strval($this->Weaving->CurrentValue) <> "") {
			$this->Weaving->ViewValue = $this->Weaving->optionCaption($this->Weaving->CurrentValue);
		} else {
			$this->Weaving->ViewValue = NULL;
		}
		$this->Weaving->ViewCustomAttributes = "";

		// Packing
		if (strval($this->Packing->CurrentValue) <> "") {
			$this->Packing->ViewValue = $this->Packing->optionCaption($this->Packing->CurrentValue);
		} else {
			$this->Packing->ViewValue = NULL;
		}
		$this->Packing->ViewCustomAttributes = "";

		// order_quantity
		$this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
		$this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, 0, -2, -2, -2);
		$this->order_quantity->ViewCustomAttributes = "";

		// count
		$this->count->ViewValue = $this->count->CurrentValue;
		$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
		$this->count->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_a
		$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
		$this->sqm_a->ViewCustomAttributes = "";

		// process_c
		$this->process_c->ViewValue = $this->process_c->CurrentValue;
		$this->process_c->ViewCustomAttributes = "";

		// process_d
		$this->process_d->ViewValue = $this->process_d->CurrentValue;
		$this->process_d->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// dispatch_week_p
		$curVal = strval($this->dispatch_week_p->CurrentValue);
		if ($curVal <> "") {
			$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
			if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
				}
			}
		} else {
			$this->dispatch_week_p->ViewValue = NULL;
		}
		$this->dispatch_week_p->ViewCustomAttributes = "";

		// current_works
		$curVal = strval($this->current_works->CurrentValue);
		if ($curVal <> "") {
			$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
			if ($this->current_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->current_works->ViewValue = $this->current_works->CurrentValue;
				}
			}
		} else {
			$this->current_works->ViewValue = NULL;
		}
		$this->current_works->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// process
		if ($this->process->VirtualValue <> "") {
			$this->process->ViewValue = $this->process->VirtualValue;
		} else {
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue->add($this->process->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		}
		$this->process->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// URL_DSP
		$this->URL_DSP->ViewValue = $this->URL_DSP->CurrentValue;
		$this->URL_DSP->ViewCustomAttributes = "";

		// buyer_barcode
		$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
		$this->buyer_barcode->ViewCustomAttributes = "";

		// buyer
		$this->buyer->LinkCustomAttributes = "";
		$this->buyer->HrefValue = "";
		$this->buyer->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		if (!EmptyValue($this->po->CurrentValue)) {
			$this->po->HrefValue = "query_production_tablelist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
			$this->po->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
		} else {
			$this->po->HrefValue = "";
		}
		$this->po->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		$this->buyer_ref->HrefValue = "";
		$this->buyer_ref->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		$this->design_id->HrefValue = "";
		$this->design_id->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		if (!EmptyValue($this->URL_DSP->CurrentValue)) {
			$this->size_cm->HrefValue = $this->URL_DSP->CurrentValue; // Add prefix/suffix
			$this->size_cm->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->size_cm->HrefValue = FullUrl($this->size_cm->HrefValue, "href");
		} else {
			$this->size_cm->HrefValue = "";
		}
		$this->size_cm->TooltipValue = "";

		// Weaving
		$this->Weaving->LinkCustomAttributes = "";
		if (!EmptyValue($this->Weaving->CurrentValue)) {
			$this->Weaving->HrefValue = "query_production_tablelist.php?x_Weaving=" . $this->Weaving->CurrentValue; // Add prefix/suffix
			$this->Weaving->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->Weaving->HrefValue = FullUrl($this->Weaving->HrefValue, "href");
		} else {
			$this->Weaving->HrefValue = "";
		}
		$this->Weaving->TooltipValue = "";

		// Packing
		$this->Packing->LinkCustomAttributes = "";
		if (!EmptyValue($this->Packing->CurrentValue)) {
			$this->Packing->HrefValue = "query_production_tablelist.php?x_Packing=" . $this->Packing->CurrentValue; // Add prefix/suffix
			$this->Packing->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->Packing->HrefValue = FullUrl($this->Packing->HrefValue, "href");
		} else {
			$this->Packing->HrefValue = "";
		}
		$this->Packing->TooltipValue = "";

		// order_quantity
		$this->order_quantity->LinkCustomAttributes = "";
		$this->order_quantity->HrefValue = "";
		$this->order_quantity->TooltipValue = "";

		// count
		$this->count->LinkCustomAttributes = "";
		$this->count->HrefValue = "";
		$this->count->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// sqm_a
		$this->sqm_a->LinkCustomAttributes = "";
		$this->sqm_a->HrefValue = "";
		$this->sqm_a->TooltipValue = "";

		// process_c
		$this->process_c->LinkCustomAttributes = "";
		$this->process_c->HrefValue = "";
		$this->process_c->TooltipValue = "";

		// process_d
		$this->process_d->LinkCustomAttributes = "";
		$this->process_d->HrefValue = "";
		$this->process_d->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->_barcode->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->_barcode->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->_barcode->HrefValue = FullUrl($this->_barcode->HrefValue, "href");
		} else {
			$this->_barcode->HrefValue = "";
		}
		$this->_barcode->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// dispatch_week_p
		$this->dispatch_week_p->LinkCustomAttributes = "";
		$this->dispatch_week_p->HrefValue = "";
		$this->dispatch_week_p->TooltipValue = "";

		// current_works
		$this->current_works->LinkCustomAttributes = "";
		if (!EmptyValue($this->current_works->CurrentValue)) {
			$this->current_works->HrefValue = "query_production_tablelist.php?x_current_works=" . $this->current_works->CurrentValue; // Add prefix/suffix
			$this->current_works->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->current_works->HrefValue = FullUrl($this->current_works->HrefValue, "href");
		} else {
			$this->current_works->HrefValue = "";
		}
		$this->current_works->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// URL_DSP
		$this->URL_DSP->LinkCustomAttributes = "";
		$this->URL_DSP->HrefValue = "";
		$this->URL_DSP->TooltipValue = "";

		// buyer_barcode
		$this->buyer_barcode->LinkCustomAttributes = "";
		$this->buyer_barcode->HrefValue = "";
		$this->buyer_barcode->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// buyer
		$this->buyer->EditAttrs["class"] = "form-control";
		$this->buyer->EditCustomAttributes = "";
		$this->buyer->EditValue = $this->buyer->CurrentValue;
		$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_ref->CurrentValue = HtmlDecode($this->buyer_ref->CurrentValue);
		$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
		$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// Weaving
		$this->Weaving->EditAttrs["class"] = "form-control";
		$this->Weaving->EditCustomAttributes = "";
		$this->Weaving->EditValue = $this->Weaving->options(TRUE);

		// Packing
		$this->Packing->EditAttrs["class"] = "form-control";
		$this->Packing->EditCustomAttributes = "";
		$this->Packing->EditValue = $this->Packing->options(TRUE);

		// order_quantity
		$this->order_quantity->EditAttrs["class"] = "form-control";
		$this->order_quantity->EditCustomAttributes = "";
		$this->order_quantity->EditValue = $this->order_quantity->CurrentValue;
		$this->order_quantity->PlaceHolder = RemoveHtml($this->order_quantity->caption());

		// count
		$this->count->EditAttrs["class"] = "form-control";
		$this->count->EditCustomAttributes = "";
		$this->count->EditValue = $this->count->CurrentValue;
		$this->count->PlaceHolder = RemoveHtml($this->count->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// sqm_a
		$this->sqm_a->EditAttrs["class"] = "form-control";
		$this->sqm_a->EditCustomAttributes = "";
		$this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
		if (strval($this->sqm_a->EditValue) <> "" && is_numeric($this->sqm_a->EditValue))
			$this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, -2, -2, -2, -2);

		// process_c
		$this->process_c->EditAttrs["class"] = "form-control";
		$this->process_c->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->process_c->CurrentValue = HtmlDecode($this->process_c->CurrentValue);
		$this->process_c->EditValue = $this->process_c->CurrentValue;
		$this->process_c->PlaceHolder = RemoveHtml($this->process_c->caption());

		// process_d
		$this->process_d->EditAttrs["class"] = "form-control";
		$this->process_d->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->process_d->CurrentValue = HtmlDecode($this->process_d->CurrentValue);
		$this->process_d->EditValue = $this->process_d->CurrentValue;
		$this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// dispatch_week_p
		$this->dispatch_week_p->EditAttrs["class"] = "form-control";
		$this->dispatch_week_p->EditCustomAttributes = "";

		// current_works
		$this->current_works->EditAttrs["class"] = "form-control";
		$this->current_works->EditCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// URL_DSP
		$this->URL_DSP->EditAttrs["class"] = "form-control";
		$this->URL_DSP->EditCustomAttributes = "";
		$this->URL_DSP->EditValue = $this->URL_DSP->CurrentValue;
		$this->URL_DSP->PlaceHolder = RemoveHtml($this->URL_DSP->caption());

		// buyer_barcode
		$this->buyer_barcode->EditAttrs["class"] = "form-control";
		$this->buyer_barcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_barcode->CurrentValue = HtmlDecode($this->buyer_barcode->CurrentValue);
		$this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;
		$this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->count->CurrentValue))
				$this->count->Total += $this->count->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm_a->CurrentValue))
				$this->sqm_a->Total += $this->sqm_a->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->count->CurrentValue = $this->count->Total;
			$this->count->ViewValue = $this->count->CurrentValue;
			$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
			$this->count->ViewCustomAttributes = "";
			$this->count->HrefValue = ""; // Clear href value
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value
			$this->sqm_a->CurrentValue = $this->sqm_a->Total;
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";
			$this->sqm_a->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->Weaving);
					$doc->exportCaption($this->Packing);
					$doc->exportCaption($this->order_quantity);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->sqm_a);
					$doc->exportCaption($this->process_c);
					$doc->exportCaption($this->process_d);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->dispatch_week_p);
					$doc->exportCaption($this->current_works);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->URL_DSP);
					$doc->exportCaption($this->buyer_barcode);
				} else {
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->Weaving);
					$doc->exportCaption($this->Packing);
					$doc->exportCaption($this->order_quantity);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->sqm_a);
					$doc->exportCaption($this->process_c);
					$doc->exportCaption($this->process_d);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->dispatch_week_p);
					$doc->exportCaption($this->current_works);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->buyer_barcode);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->buyer);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->Weaving);
						$doc->exportField($this->Packing);
						$doc->exportField($this->order_quantity);
						$doc->exportField($this->count);
						$doc->exportField($this->sqm);
						$doc->exportField($this->sqm_a);
						$doc->exportField($this->process_c);
						$doc->exportField($this->process_d);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->status);
						$doc->exportField($this->dispatch_week_p);
						$doc->exportField($this->current_works);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->process);
						$doc->exportField($this->URL_DSP);
						$doc->exportField($this->buyer_barcode);
					} else {
						$doc->exportField($this->buyer);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->Weaving);
						$doc->exportField($this->Packing);
						$doc->exportField($this->order_quantity);
						$doc->exportField($this->count);
						$doc->exportField($this->sqm);
						$doc->exportField($this->sqm_a);
						$doc->exportField($this->process_c);
						$doc->exportField($this->process_d);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->status);
						$doc->exportField($this->dispatch_week_p);
						$doc->exportField($this->current_works);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->process);
						$doc->exportField($this->buyer_barcode);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->buyer, '');
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->buyer_ref, '');
				$doc->exportAggregate($this->size_cm, '');
				$doc->exportAggregate($this->Weaving, '');
				$doc->exportAggregate($this->Packing, '');
				$doc->exportAggregate($this->order_quantity, '');
				$doc->exportAggregate($this->count, 'TOTAL');
				$doc->exportAggregate($this->sqm, 'TOTAL');
				$doc->exportAggregate($this->sqm_a, 'TOTAL');
				$doc->exportAggregate($this->process_c, '');
				$doc->exportAggregate($this->process_d, '');
				$doc->exportAggregate($this->_barcode, '');
				$doc->exportAggregate($this->status, '');
				$doc->exportAggregate($this->dispatch_week_p, '');
				$doc->exportAggregate($this->current_works, '');
				$doc->exportAggregate($this->batch_no, '');
				$doc->exportAggregate($this->process, '');
				$doc->exportAggregate($this->buyer_barcode, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>