<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class query_production_table_list extends query_production_table
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'query_production_table';

	// Page object name
	public $PageObjName = "query_production_table_list";

	// Grid form hidden field names
	public $FormName = "fquery_production_tablelist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (query_production_table)
		if (!isset($GLOBALS["query_production_table"]) || get_class($GLOBALS["query_production_table"]) == PROJECT_NAMESPACE . "query_production_table") {
			$GLOBALS["query_production_table"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["query_production_table"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "query_production_tableadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "query_production_tabledelete.php";
		$this->MultiUpdateUrl = "query_production_tableupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'query_production_table');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fquery_production_tablelistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $query_production_table;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($query_production_table);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->buyer->setVisibility();
		$this->po->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->design_id->Visible = FALSE;
		$this->size_cm->setVisibility();
		$this->Weaving->setVisibility();
		$this->Packing->setVisibility();
		$this->order_quantity->setVisibility();
		$this->count->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_a->setVisibility();
		$this->process_c->setVisibility();
		$this->process_d->setVisibility();
		$this->_barcode->setVisibility();
		$this->status->setVisibility();
		$this->dispatch_week_p->setVisibility();
		$this->current_works->setVisibility();
		$this->batch_no->setVisibility();
		$this->process->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->id->Visible = FALSE;
		$this->URL_DSP->Visible = FALSE;
		$this->buyer_barcode->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->dispatch_week_p);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->process);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fquery_production_tablelistsrch");
		$filterList = Concat($filterList, $this->buyer->AdvancedSearch->toJson(), ","); // Field buyer
		$filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
		$filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
		$filterList = Concat($filterList, $this->design_id->AdvancedSearch->toJson(), ","); // Field design_id
		$filterList = Concat($filterList, $this->size_cm->AdvancedSearch->toJson(), ","); // Field size_cm
		$filterList = Concat($filterList, $this->Weaving->AdvancedSearch->toJson(), ","); // Field Weaving
		$filterList = Concat($filterList, $this->Packing->AdvancedSearch->toJson(), ","); // Field Packing
		$filterList = Concat($filterList, $this->order_quantity->AdvancedSearch->toJson(), ","); // Field order_quantity
		$filterList = Concat($filterList, $this->count->AdvancedSearch->toJson(), ","); // Field count
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->sqm_a->AdvancedSearch->toJson(), ","); // Field sqm_a
		$filterList = Concat($filterList, $this->process_c->AdvancedSearch->toJson(), ","); // Field process_c
		$filterList = Concat($filterList, $this->process_d->AdvancedSearch->toJson(), ","); // Field process_d
		$filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->dispatch_week_p->AdvancedSearch->toJson(), ","); // Field dispatch_week_p
		$filterList = Concat($filterList, $this->current_works->AdvancedSearch->toJson(), ","); // Field current_works
		$filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
		$filterList = Concat($filterList, $this->URL_DSP->AdvancedSearch->toJson(), ","); // Field URL_DSP
		$filterList = Concat($filterList, $this->buyer_barcode->AdvancedSearch->toJson(), ","); // Field buyer_barcode
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fquery_production_tablelistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field buyer
		$this->buyer->AdvancedSearch->SearchValue = @$filter["x_buyer"];
		$this->buyer->AdvancedSearch->SearchOperator = @$filter["z_buyer"];
		$this->buyer->AdvancedSearch->SearchCondition = @$filter["v_buyer"];
		$this->buyer->AdvancedSearch->SearchValue2 = @$filter["y_buyer"];
		$this->buyer->AdvancedSearch->SearchOperator2 = @$filter["w_buyer"];
		$this->buyer->AdvancedSearch->save();

		// Field po
		$this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
		$this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
		$this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
		$this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
		$this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
		$this->po->AdvancedSearch->save();

		// Field buyer_ref
		$this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->save();

		// Field design_id
		$this->design_id->AdvancedSearch->SearchValue = @$filter["x_design_id"];
		$this->design_id->AdvancedSearch->SearchOperator = @$filter["z_design_id"];
		$this->design_id->AdvancedSearch->SearchCondition = @$filter["v_design_id"];
		$this->design_id->AdvancedSearch->SearchValue2 = @$filter["y_design_id"];
		$this->design_id->AdvancedSearch->SearchOperator2 = @$filter["w_design_id"];
		$this->design_id->AdvancedSearch->save();

		// Field size_cm
		$this->size_cm->AdvancedSearch->SearchValue = @$filter["x_size_cm"];
		$this->size_cm->AdvancedSearch->SearchOperator = @$filter["z_size_cm"];
		$this->size_cm->AdvancedSearch->SearchCondition = @$filter["v_size_cm"];
		$this->size_cm->AdvancedSearch->SearchValue2 = @$filter["y_size_cm"];
		$this->size_cm->AdvancedSearch->SearchOperator2 = @$filter["w_size_cm"];
		$this->size_cm->AdvancedSearch->save();

		// Field Weaving
		$this->Weaving->AdvancedSearch->SearchValue = @$filter["x_Weaving"];
		$this->Weaving->AdvancedSearch->SearchOperator = @$filter["z_Weaving"];
		$this->Weaving->AdvancedSearch->SearchCondition = @$filter["v_Weaving"];
		$this->Weaving->AdvancedSearch->SearchValue2 = @$filter["y_Weaving"];
		$this->Weaving->AdvancedSearch->SearchOperator2 = @$filter["w_Weaving"];
		$this->Weaving->AdvancedSearch->save();

		// Field Packing
		$this->Packing->AdvancedSearch->SearchValue = @$filter["x_Packing"];
		$this->Packing->AdvancedSearch->SearchOperator = @$filter["z_Packing"];
		$this->Packing->AdvancedSearch->SearchCondition = @$filter["v_Packing"];
		$this->Packing->AdvancedSearch->SearchValue2 = @$filter["y_Packing"];
		$this->Packing->AdvancedSearch->SearchOperator2 = @$filter["w_Packing"];
		$this->Packing->AdvancedSearch->save();

		// Field order_quantity
		$this->order_quantity->AdvancedSearch->SearchValue = @$filter["x_order_quantity"];
		$this->order_quantity->AdvancedSearch->SearchOperator = @$filter["z_order_quantity"];
		$this->order_quantity->AdvancedSearch->SearchCondition = @$filter["v_order_quantity"];
		$this->order_quantity->AdvancedSearch->SearchValue2 = @$filter["y_order_quantity"];
		$this->order_quantity->AdvancedSearch->SearchOperator2 = @$filter["w_order_quantity"];
		$this->order_quantity->AdvancedSearch->save();

		// Field count
		$this->count->AdvancedSearch->SearchValue = @$filter["x_count"];
		$this->count->AdvancedSearch->SearchOperator = @$filter["z_count"];
		$this->count->AdvancedSearch->SearchCondition = @$filter["v_count"];
		$this->count->AdvancedSearch->SearchValue2 = @$filter["y_count"];
		$this->count->AdvancedSearch->SearchOperator2 = @$filter["w_count"];
		$this->count->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field sqm_a
		$this->sqm_a->AdvancedSearch->SearchValue = @$filter["x_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchOperator = @$filter["z_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchCondition = @$filter["v_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchValue2 = @$filter["y_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchOperator2 = @$filter["w_sqm_a"];
		$this->sqm_a->AdvancedSearch->save();

		// Field process_c
		$this->process_c->AdvancedSearch->SearchValue = @$filter["x_process_c"];
		$this->process_c->AdvancedSearch->SearchOperator = @$filter["z_process_c"];
		$this->process_c->AdvancedSearch->SearchCondition = @$filter["v_process_c"];
		$this->process_c->AdvancedSearch->SearchValue2 = @$filter["y_process_c"];
		$this->process_c->AdvancedSearch->SearchOperator2 = @$filter["w_process_c"];
		$this->process_c->AdvancedSearch->save();

		// Field process_d
		$this->process_d->AdvancedSearch->SearchValue = @$filter["x_process_d"];
		$this->process_d->AdvancedSearch->SearchOperator = @$filter["z_process_d"];
		$this->process_d->AdvancedSearch->SearchCondition = @$filter["v_process_d"];
		$this->process_d->AdvancedSearch->SearchValue2 = @$filter["y_process_d"];
		$this->process_d->AdvancedSearch->SearchOperator2 = @$filter["w_process_d"];
		$this->process_d->AdvancedSearch->save();

		// Field barcode
		$this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
		$this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
		$this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
		$this->_barcode->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field dispatch_week_p
		$this->dispatch_week_p->AdvancedSearch->SearchValue = @$filter["x_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchOperator = @$filter["z_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchCondition = @$filter["v_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchValue2 = @$filter["y_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchOperator2 = @$filter["w_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->save();

		// Field current_works
		$this->current_works->AdvancedSearch->SearchValue = @$filter["x_current_works"];
		$this->current_works->AdvancedSearch->SearchOperator = @$filter["z_current_works"];
		$this->current_works->AdvancedSearch->SearchCondition = @$filter["v_current_works"];
		$this->current_works->AdvancedSearch->SearchValue2 = @$filter["y_current_works"];
		$this->current_works->AdvancedSearch->SearchOperator2 = @$filter["w_current_works"];
		$this->current_works->AdvancedSearch->save();

		// Field batch_no
		$this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
		$this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
		$this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
		$this->batch_no->AdvancedSearch->save();

		// Field URL_DSP
		$this->URL_DSP->AdvancedSearch->SearchValue = @$filter["x_URL_DSP"];
		$this->URL_DSP->AdvancedSearch->SearchOperator = @$filter["z_URL_DSP"];
		$this->URL_DSP->AdvancedSearch->SearchCondition = @$filter["v_URL_DSP"];
		$this->URL_DSP->AdvancedSearch->SearchValue2 = @$filter["y_URL_DSP"];
		$this->URL_DSP->AdvancedSearch->SearchOperator2 = @$filter["w_URL_DSP"];
		$this->URL_DSP->AdvancedSearch->save();

		// Field buyer_barcode
		$this->buyer_barcode->AdvancedSearch->SearchValue = @$filter["x_buyer_barcode"];
		$this->buyer_barcode->AdvancedSearch->SearchOperator = @$filter["z_buyer_barcode"];
		$this->buyer_barcode->AdvancedSearch->SearchCondition = @$filter["v_buyer_barcode"];
		$this->buyer_barcode->AdvancedSearch->SearchValue2 = @$filter["y_buyer_barcode"];
		$this->buyer_barcode->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_barcode"];
		$this->buyer_barcode->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->buyer, $default, FALSE); // buyer
		$this->buildSearchSql($where, $this->po, $default, FALSE); // po
		$this->buildSearchSql($where, $this->buyer_ref, $default, FALSE); // buyer_ref
		$this->buildSearchSql($where, $this->design_id, $default, FALSE); // design_id
		$this->buildSearchSql($where, $this->size_cm, $default, FALSE); // size_cm
		$this->buildSearchSql($where, $this->Weaving, $default, FALSE); // Weaving
		$this->buildSearchSql($where, $this->Packing, $default, FALSE); // Packing
		$this->buildSearchSql($where, $this->order_quantity, $default, FALSE); // order_quantity
		$this->buildSearchSql($where, $this->count, $default, FALSE); // count
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->sqm_a, $default, FALSE); // sqm_a
		$this->buildSearchSql($where, $this->process_c, $default, FALSE); // process_c
		$this->buildSearchSql($where, $this->process_d, $default, FALSE); // process_d
		$this->buildSearchSql($where, $this->_barcode, $default, FALSE); // barcode
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->dispatch_week_p, $default, FALSE); // dispatch_week_p
		$this->buildSearchSql($where, $this->current_works, $default, FALSE); // current_works
		$this->buildSearchSql($where, $this->batch_no, $default, FALSE); // batch_no
		$this->buildSearchSql($where, $this->URL_DSP, $default, FALSE); // URL_DSP
		$this->buildSearchSql($where, $this->buyer_barcode, $default, FALSE); // buyer_barcode

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->buyer->AdvancedSearch->save(); // buyer
			$this->po->AdvancedSearch->save(); // po
			$this->buyer_ref->AdvancedSearch->save(); // buyer_ref
			$this->design_id->AdvancedSearch->save(); // design_id
			$this->size_cm->AdvancedSearch->save(); // size_cm
			$this->Weaving->AdvancedSearch->save(); // Weaving
			$this->Packing->AdvancedSearch->save(); // Packing
			$this->order_quantity->AdvancedSearch->save(); // order_quantity
			$this->count->AdvancedSearch->save(); // count
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->sqm_a->AdvancedSearch->save(); // sqm_a
			$this->process_c->AdvancedSearch->save(); // process_c
			$this->process_d->AdvancedSearch->save(); // process_d
			$this->_barcode->AdvancedSearch->save(); // barcode
			$this->status->AdvancedSearch->save(); // status
			$this->dispatch_week_p->AdvancedSearch->save(); // dispatch_week_p
			$this->current_works->AdvancedSearch->save(); // current_works
			$this->batch_no->AdvancedSearch->save(); // batch_no
			$this->URL_DSP->AdvancedSearch->save(); // URL_DSP
			$this->buyer_barcode->AdvancedSearch->save(); // buyer_barcode
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->buyer, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->size_cm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Weaving, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Packing, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->process_c, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->process_d, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_barcode, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->batch_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->URL_DSP, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_barcode, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->buyer->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->design_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->size_cm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Weaving->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Packing->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->order_quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->count->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm_a->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process_c->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process_d->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_barcode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->dispatch_week_p->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->current_works->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->batch_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->URL_DSP->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_barcode->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->buyer->AdvancedSearch->unsetSession();
		$this->po->AdvancedSearch->unsetSession();
		$this->buyer_ref->AdvancedSearch->unsetSession();
		$this->design_id->AdvancedSearch->unsetSession();
		$this->size_cm->AdvancedSearch->unsetSession();
		$this->Weaving->AdvancedSearch->unsetSession();
		$this->Packing->AdvancedSearch->unsetSession();
		$this->order_quantity->AdvancedSearch->unsetSession();
		$this->count->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->sqm_a->AdvancedSearch->unsetSession();
		$this->process_c->AdvancedSearch->unsetSession();
		$this->process_d->AdvancedSearch->unsetSession();
		$this->_barcode->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->dispatch_week_p->AdvancedSearch->unsetSession();
		$this->current_works->AdvancedSearch->unsetSession();
		$this->batch_no->AdvancedSearch->unsetSession();
		$this->URL_DSP->AdvancedSearch->unsetSession();
		$this->buyer_barcode->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->buyer->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->size_cm->AdvancedSearch->load();
		$this->Weaving->AdvancedSearch->load();
		$this->Packing->AdvancedSearch->load();
		$this->order_quantity->AdvancedSearch->load();
		$this->count->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_a->AdvancedSearch->load();
		$this->process_c->AdvancedSearch->load();
		$this->process_d->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->dispatch_week_p->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->URL_DSP->AdvancedSearch->load();
		$this->buyer_barcode->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->buyer, $ctrl); // buyer
			$this->updateSort($this->po, $ctrl); // po
			$this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
			$this->updateSort($this->size_cm, $ctrl); // size_cm
			$this->updateSort($this->Weaving, $ctrl); // Weaving
			$this->updateSort($this->Packing, $ctrl); // Packing
			$this->updateSort($this->order_quantity, $ctrl); // order_quantity
			$this->updateSort($this->count, $ctrl); // count
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->sqm_a, $ctrl); // sqm_a
			$this->updateSort($this->process_c, $ctrl); // process_c
			$this->updateSort($this->process_d, $ctrl); // process_d
			$this->updateSort($this->_barcode, $ctrl); // barcode
			$this->updateSort($this->status, $ctrl); // status
			$this->updateSort($this->dispatch_week_p, $ctrl); // dispatch_week_p
			$this->updateSort($this->current_works, $ctrl); // current_works
			$this->updateSort($this->batch_no, $ctrl); // batch_no
			$this->updateSort($this->buyer_barcode, $ctrl); // buyer_barcode
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->po->setSort("ASC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->buyer->setSort("");
				$this->po->setSort("");
				$this->buyer_ref->setSort("");
				$this->size_cm->setSort("");
				$this->Weaving->setSort("");
				$this->Packing->setSort("");
				$this->order_quantity->setSort("");
				$this->count->setSort("");
				$this->sqm->setSort("");
				$this->sqm_a->setSort("");
				$this->process_c->setSort("");
				$this->process_d->setSort("");
				$this->_barcode->setSort("");
				$this->status->setSort("");
				$this->dispatch_week_p->setSort("");
				$this->current_works->setSort("");
				$this->batch_no->setSort("");
				$this->buyer_barcode->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fquery_production_tablelistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fquery_production_tablelistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fquery_production_tablelist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fquery_production_tablelistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"query_production_tablesrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"query_production_table\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'query_production_tablesrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fquery_production_tablelistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// buyer

		if (!$this->isAddOrEdit())
			$this->buyer->AdvancedSearch->setSearchValue(Get("x_buyer", Get("buyer", "")));
		if ($this->buyer->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer->AdvancedSearch->setSearchOperator(Get("z_buyer", ""));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue(Get("x_po", Get("po", "")));
		if ($this->po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator(Get("z_po", ""));

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue(Get("x_buyer_ref", Get("buyer_ref", "")));
		if ($this->buyer_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_ref->AdvancedSearch->setSearchOperator(Get("z_buyer_ref", ""));

		// design_id
		if (!$this->isAddOrEdit())
			$this->design_id->AdvancedSearch->setSearchValue(Get("x_design_id", Get("design_id", "")));
		if ($this->design_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->design_id->AdvancedSearch->setSearchOperator(Get("z_design_id", ""));

		// size_cm
		if (!$this->isAddOrEdit())
			$this->size_cm->AdvancedSearch->setSearchValue(Get("x_size_cm", Get("size_cm", "")));
		if ($this->size_cm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->size_cm->AdvancedSearch->setSearchOperator(Get("z_size_cm", ""));

		// Weaving
		if (!$this->isAddOrEdit())
			$this->Weaving->AdvancedSearch->setSearchValue(Get("x_Weaving", Get("Weaving", "")));
		if ($this->Weaving->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Weaving->AdvancedSearch->setSearchOperator(Get("z_Weaving", ""));
		$this->Weaving->AdvancedSearch->setSearchCondition(Get("v_Weaving", ""));
		$this->Weaving->AdvancedSearch->setSearchValue2(Get("y_Weaving", ""));
		if ($this->Weaving->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Weaving->AdvancedSearch->setSearchOperator2(Get("w_Weaving", ""));

		// Packing
		if (!$this->isAddOrEdit())
			$this->Packing->AdvancedSearch->setSearchValue(Get("x_Packing", Get("Packing", "")));
		if ($this->Packing->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Packing->AdvancedSearch->setSearchOperator(Get("z_Packing", ""));
		$this->Packing->AdvancedSearch->setSearchCondition(Get("v_Packing", ""));
		$this->Packing->AdvancedSearch->setSearchValue2(Get("y_Packing", ""));
		if ($this->Packing->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Packing->AdvancedSearch->setSearchOperator2(Get("w_Packing", ""));

		// order_quantity
		if (!$this->isAddOrEdit())
			$this->order_quantity->AdvancedSearch->setSearchValue(Get("x_order_quantity", Get("order_quantity", "")));
		if ($this->order_quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->order_quantity->AdvancedSearch->setSearchOperator(Get("z_order_quantity", ""));

		// count
		if (!$this->isAddOrEdit())
			$this->count->AdvancedSearch->setSearchValue(Get("x_count", Get("count", "")));
		if ($this->count->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->count->AdvancedSearch->setSearchOperator(Get("z_count", ""));
		$this->count->AdvancedSearch->setSearchCondition(Get("v_count", ""));
		$this->count->AdvancedSearch->setSearchValue2(Get("y_count", ""));
		if ($this->count->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->count->AdvancedSearch->setSearchOperator2(Get("w_count", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));
		$this->sqm->AdvancedSearch->setSearchCondition(Get("v_sqm", ""));
		$this->sqm->AdvancedSearch->setSearchValue2(Get("y_sqm", ""));
		if ($this->sqm->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator2(Get("w_sqm", ""));

		// sqm_a
		if (!$this->isAddOrEdit())
			$this->sqm_a->AdvancedSearch->setSearchValue(Get("x_sqm_a", Get("sqm_a", "")));
		if ($this->sqm_a->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm_a->AdvancedSearch->setSearchOperator(Get("z_sqm_a", ""));
		$this->sqm_a->AdvancedSearch->setSearchCondition(Get("v_sqm_a", ""));
		$this->sqm_a->AdvancedSearch->setSearchValue2(Get("y_sqm_a", ""));
		if ($this->sqm_a->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm_a->AdvancedSearch->setSearchOperator2(Get("w_sqm_a", ""));

		// process_c
		if (!$this->isAddOrEdit())
			$this->process_c->AdvancedSearch->setSearchValue(Get("x_process_c", Get("process_c", "")));
		if ($this->process_c->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process_c->AdvancedSearch->setSearchOperator(Get("z_process_c", ""));

		// process_d
		if (!$this->isAddOrEdit())
			$this->process_d->AdvancedSearch->setSearchValue(Get("x_process_d", Get("process_d", "")));
		if ($this->process_d->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process_d->AdvancedSearch->setSearchOperator(Get("z_process_d", ""));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue(Get("x__barcode", Get("_barcode", "")));
		if ($this->_barcode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_barcode->AdvancedSearch->setSearchOperator(Get("z__barcode", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// dispatch_week_p
		if (!$this->isAddOrEdit())
			$this->dispatch_week_p->AdvancedSearch->setSearchValue(Get("x_dispatch_week_p", Get("dispatch_week_p", "")));
		if ($this->dispatch_week_p->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->dispatch_week_p->AdvancedSearch->setSearchOperator(Get("z_dispatch_week_p", ""));

		// current_works
		if (!$this->isAddOrEdit())
			$this->current_works->AdvancedSearch->setSearchValue(Get("x_current_works", Get("current_works", "")));
		if ($this->current_works->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->current_works->AdvancedSearch->setSearchOperator(Get("z_current_works", ""));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue(Get("x_batch_no", Get("batch_no", "")));
		if ($this->batch_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->batch_no->AdvancedSearch->setSearchOperator(Get("z_batch_no", ""));

		// URL_DSP
		if (!$this->isAddOrEdit())
			$this->URL_DSP->AdvancedSearch->setSearchValue(Get("x_URL_DSP", Get("URL_DSP", "")));
		if ($this->URL_DSP->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->URL_DSP->AdvancedSearch->setSearchOperator(Get("z_URL_DSP", ""));

		// buyer_barcode
		if (!$this->isAddOrEdit())
			$this->buyer_barcode->AdvancedSearch->setSearchValue(Get("x_buyer_barcode", Get("buyer_barcode", "")));
		if ($this->buyer_barcode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_barcode->AdvancedSearch->setSearchOperator(Get("z_buyer_barcode", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->buyer->setDbValue($row['buyer']);
		if (array_key_exists('EV__buyer', $rs->fields)) {
			$this->buyer->VirtualValue = $rs->fields('EV__buyer'); // Set up virtual field value
		} else {
			$this->buyer->VirtualValue = ""; // Clear value
		}
		$this->po->setDbValue($row['po']);
		$this->buyer_ref->setDbValue($row['buyer_ref']);
		$this->design_id->setDbValue($row['design_id']);
		if (array_key_exists('EV__design_id', $rs->fields)) {
			$this->design_id->VirtualValue = $rs->fields('EV__design_id'); // Set up virtual field value
		} else {
			$this->design_id->VirtualValue = ""; // Clear value
		}
		$this->size_cm->setDbValue($row['size_cm']);
		$this->Weaving->setDbValue($row['Weaving']);
		$this->Packing->setDbValue($row['Packing']);
		$this->order_quantity->setDbValue($row['order_quantity']);
		$this->count->setDbValue($row['count']);
		$this->sqm->setDbValue($row['sqm']);
		$this->sqm_a->setDbValue($row['sqm_a']);
		$this->process_c->setDbValue($row['process_c']);
		$this->process_d->setDbValue($row['process_d']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->status->setDbValue($row['status']);
		$this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
		$this->current_works->setDbValue($row['current_works']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->process->setDbValue($row['process']);
		if (array_key_exists('EV__process', $rs->fields)) {
			$this->process->VirtualValue = $rs->fields('EV__process'); // Set up virtual field value
		} else {
			$this->process->VirtualValue = ""; // Clear value
		}
		$this->url->setDbValue($row['url']);
		$this->id->setDbValue($row['id']);
		$this->URL_DSP->setDbValue($row['URL_DSP']);
		$this->buyer_barcode->setDbValue($row['buyer_barcode']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['buyer'] = NULL;
		$row['po'] = NULL;
		$row['buyer_ref'] = NULL;
		$row['design_id'] = NULL;
		$row['size_cm'] = NULL;
		$row['Weaving'] = NULL;
		$row['Packing'] = NULL;
		$row['order_quantity'] = NULL;
		$row['count'] = NULL;
		$row['sqm'] = NULL;
		$row['sqm_a'] = NULL;
		$row['process_c'] = NULL;
		$row['process_d'] = NULL;
		$row['barcode'] = NULL;
		$row['status'] = NULL;
		$row['dispatch_week_p'] = NULL;
		$row['current_works'] = NULL;
		$row['batch_no'] = NULL;
		$row['process'] = NULL;
		$row['url'] = NULL;
		$row['id'] = NULL;
		$row['URL_DSP'] = NULL;
		$row['buyer_barcode'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_a->FormValue == $this->sqm_a->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_a->CurrentValue)))
			$this->sqm_a->CurrentValue = ConvertToFloatString($this->sqm_a->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// buyer
		// po
		// buyer_ref
		// design_id

		$this->design_id->CellCssStyle = "white-space: nowrap;";

		// size_cm
		// Weaving
		// Packing
		// order_quantity
		// count
		// sqm
		// sqm_a
		// process_c
		// process_d
		// barcode

		$this->_barcode->CellCssStyle = "width: 300px;";

		// status
		// dispatch_week_p
		// current_works
		// batch_no
		// process

		$this->process->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->CellCssStyle = "white-space: nowrap;";

		// URL_DSP
		// buyer_barcode
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->count->CurrentValue))
				$this->count->Total += $this->count->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm_a->CurrentValue))
				$this->sqm_a->Total += $this->sqm_a->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// buyer
			if ($this->buyer->VirtualValue <> "") {
				$this->buyer->ViewValue = $this->buyer->VirtualValue;
			} else {
				$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			}
			$this->buyer->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
			$this->buyer_ref->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// Weaving
			if (strval($this->Weaving->CurrentValue) <> "") {
				$this->Weaving->ViewValue = $this->Weaving->optionCaption($this->Weaving->CurrentValue);
			} else {
				$this->Weaving->ViewValue = NULL;
			}
			$this->Weaving->ViewCustomAttributes = "";

			// Packing
			if (strval($this->Packing->CurrentValue) <> "") {
				$this->Packing->ViewValue = $this->Packing->optionCaption($this->Packing->CurrentValue);
			} else {
				$this->Packing->ViewValue = NULL;
			}
			$this->Packing->ViewCustomAttributes = "";

			// order_quantity
			$this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
			$this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, 0, -2, -2, -2);
			$this->order_quantity->ViewCustomAttributes = "";

			// count
			$this->count->ViewValue = $this->count->CurrentValue;
			$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
			$this->count->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_a
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";

			// process_c
			$this->process_c->ViewValue = $this->process_c->CurrentValue;
			$this->process_c->ViewCustomAttributes = "";

			// process_d
			$this->process_d->ViewValue = $this->process_d->CurrentValue;
			$this->process_d->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// dispatch_week_p
			$curVal = strval($this->dispatch_week_p->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
				if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
					}
				}
			} else {
				$this->dispatch_week_p->ViewValue = NULL;
			}
			$this->dispatch_week_p->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// process
			if ($this->process->VirtualValue <> "") {
				$this->process->ViewValue = $this->process->VirtualValue;
			} else {
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process->ViewValue->add($this->process->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			}
			$this->process->ViewCustomAttributes = "";

			// buyer_barcode
			$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
			$this->buyer_barcode->ViewCustomAttributes = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer->ViewValue = $this->highlightValue($this->buyer);

			// po
			$this->po->LinkCustomAttributes = "";
			if (!EmptyValue($this->po->CurrentValue)) {
				$this->po->HrefValue = "query_production_tablelist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
				$this->po->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
			} else {
				$this->po->HrefValue = "";
			}
			$this->po->TooltipValue = "";
			if (!$this->isExport())
				$this->po->ViewValue = $this->highlightValue($this->po);

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			if (!EmptyValue($this->URL_DSP->CurrentValue)) {
				$this->size_cm->HrefValue = $this->URL_DSP->CurrentValue; // Add prefix/suffix
				$this->size_cm->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->size_cm->HrefValue = FullUrl($this->size_cm->HrefValue, "href");
			} else {
				$this->size_cm->HrefValue = "";
			}
			$this->size_cm->TooltipValue = "";
			if (!$this->isExport())
				$this->size_cm->ViewValue = $this->highlightValue($this->size_cm);

			// Weaving
			$this->Weaving->LinkCustomAttributes = "";
			if (!EmptyValue($this->Weaving->CurrentValue)) {
				$this->Weaving->HrefValue = "query_production_tablelist.php?x_Weaving=" . $this->Weaving->CurrentValue; // Add prefix/suffix
				$this->Weaving->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->Weaving->HrefValue = FullUrl($this->Weaving->HrefValue, "href");
			} else {
				$this->Weaving->HrefValue = "";
			}
			$this->Weaving->TooltipValue = "";

			// Packing
			$this->Packing->LinkCustomAttributes = "";
			if (!EmptyValue($this->Packing->CurrentValue)) {
				$this->Packing->HrefValue = "query_production_tablelist.php?x_Packing=" . $this->Packing->CurrentValue; // Add prefix/suffix
				$this->Packing->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->Packing->HrefValue = FullUrl($this->Packing->HrefValue, "href");
			} else {
				$this->Packing->HrefValue = "";
			}
			$this->Packing->TooltipValue = "";

			// order_quantity
			$this->order_quantity->LinkCustomAttributes = "";
			$this->order_quantity->HrefValue = "";
			$this->order_quantity->TooltipValue = "";

			// count
			$this->count->LinkCustomAttributes = "";
			$this->count->HrefValue = "";
			$this->count->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_a
			$this->sqm_a->LinkCustomAttributes = "";
			$this->sqm_a->HrefValue = "";
			$this->sqm_a->TooltipValue = "";

			// process_c
			$this->process_c->LinkCustomAttributes = "";
			$this->process_c->HrefValue = "";
			$this->process_c->TooltipValue = "";
			if (!$this->isExport())
				$this->process_c->ViewValue = $this->highlightValue($this->process_c);

			// process_d
			$this->process_d->LinkCustomAttributes = "";
			$this->process_d->HrefValue = "";
			$this->process_d->TooltipValue = "";
			if (!$this->isExport())
				$this->process_d->ViewValue = $this->highlightValue($this->process_d);

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->_barcode->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->_barcode->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->_barcode->HrefValue = FullUrl($this->_barcode->HrefValue, "href");
			} else {
				$this->_barcode->HrefValue = "";
			}
			$this->_barcode->TooltipValue = "";
			if (!$this->isExport())
				$this->_barcode->ViewValue = $this->highlightValue($this->_barcode);

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// dispatch_week_p
			$this->dispatch_week_p->LinkCustomAttributes = "";
			$this->dispatch_week_p->HrefValue = "";
			$this->dispatch_week_p->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			if (!EmptyValue($this->current_works->CurrentValue)) {
				$this->current_works->HrefValue = "query_production_tablelist.php?x_current_works=" . $this->current_works->CurrentValue; // Add prefix/suffix
				$this->current_works->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->current_works->HrefValue = FullUrl($this->current_works->HrefValue, "href");
			} else {
				$this->current_works->HrefValue = "";
			}
			$this->current_works->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// buyer_barcode
			$this->buyer_barcode->LinkCustomAttributes = "";
			$this->buyer_barcode->HrefValue = "";
			$this->buyer_barcode->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_barcode->ViewValue = $this->highlightValue($this->buyer_barcode);
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// size_cm
			$this->size_cm->EditAttrs["class"] = "form-control";
			$this->size_cm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

			// Weaving
			$this->Weaving->EditAttrs["class"] = "form-control";
			$this->Weaving->EditCustomAttributes = "";
			$this->Weaving->EditValue = $this->Weaving->options(TRUE);
			$this->Weaving->EditAttrs["class"] = "form-control";
			$this->Weaving->EditCustomAttributes = "";
			$this->Weaving->EditValue2 = $this->Weaving->options(TRUE);

			// Packing
			$this->Packing->EditAttrs["class"] = "form-control";
			$this->Packing->EditCustomAttributes = "";
			$this->Packing->EditValue = $this->Packing->options(TRUE);
			$this->Packing->EditAttrs["class"] = "form-control";
			$this->Packing->EditCustomAttributes = "";
			$this->Packing->EditValue2 = $this->Packing->options(TRUE);

			// order_quantity
			$this->order_quantity->EditAttrs["class"] = "form-control";
			$this->order_quantity->EditCustomAttributes = "";
			$this->order_quantity->EditValue = HtmlEncode($this->order_quantity->AdvancedSearch->SearchValue);
			$this->order_quantity->PlaceHolder = RemoveHtml($this->order_quantity->caption());

			// count
			$this->count->EditAttrs["class"] = "form-control";
			$this->count->EditCustomAttributes = "";
			$this->count->EditValue = HtmlEncode($this->count->AdvancedSearch->SearchValue);
			$this->count->PlaceHolder = RemoveHtml($this->count->caption());
			$this->count->EditAttrs["class"] = "form-control";
			$this->count->EditCustomAttributes = "";
			$this->count->EditValue2 = HtmlEncode($this->count->AdvancedSearch->SearchValue2);
			$this->count->PlaceHolder = RemoveHtml($this->count->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue2 = HtmlEncode($this->sqm->AdvancedSearch->SearchValue2);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// sqm_a
			$this->sqm_a->EditAttrs["class"] = "form-control";
			$this->sqm_a->EditCustomAttributes = "";
			$this->sqm_a->EditValue = HtmlEncode($this->sqm_a->AdvancedSearch->SearchValue);
			$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
			$this->sqm_a->EditAttrs["class"] = "form-control";
			$this->sqm_a->EditCustomAttributes = "";
			$this->sqm_a->EditValue2 = HtmlEncode($this->sqm_a->AdvancedSearch->SearchValue2);
			$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());

			// process_c
			$this->process_c->EditAttrs["class"] = "form-control";
			$this->process_c->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->process_c->AdvancedSearch->SearchValue = HtmlDecode($this->process_c->AdvancedSearch->SearchValue);
			$this->process_c->EditValue = HtmlEncode($this->process_c->AdvancedSearch->SearchValue);
			$this->process_c->PlaceHolder = RemoveHtml($this->process_c->caption());

			// process_d
			$this->process_d->EditAttrs["class"] = "form-control";
			$this->process_d->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->process_d->AdvancedSearch->SearchValue = HtmlDecode($this->process_d->AdvancedSearch->SearchValue);
			$this->process_d->EditValue = HtmlEncode($this->process_d->AdvancedSearch->SearchValue);
			$this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";

			// dispatch_week_p
			$this->dispatch_week_p->EditAttrs["class"] = "form-control";
			$this->dispatch_week_p->EditCustomAttributes = "";

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
			else
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== NULL && is_array($this->current_works->Lookup->Options) ? $curVal : NULL;
			if ($this->current_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->current_works->EditValue = array_values($this->current_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->current_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->current_works->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";

			// buyer_barcode
			$this->buyer_barcode->EditAttrs["class"] = "form-control";
			$this->buyer_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->count->Total = 0; // Initialize total
			$this->sqm->Total = 0; // Initialize total
			$this->sqm_a->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->count->CurrentValue = $this->count->Total;
			$this->count->ViewValue = $this->count->CurrentValue;
			$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
			$this->count->ViewCustomAttributes = "";
			$this->count->HrefValue = ""; // Clear href value
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value
			$this->sqm_a->CurrentValue = $this->sqm_a->Total;
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";
			$this->sqm_a->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->buyer->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->size_cm->AdvancedSearch->load();
		$this->Weaving->AdvancedSearch->load();
		$this->Packing->AdvancedSearch->load();
		$this->order_quantity->AdvancedSearch->load();
		$this->count->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_a->AdvancedSearch->load();
		$this->process_c->AdvancedSearch->load();
		$this->process_d->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->dispatch_week_p->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->URL_DSP->AdvancedSearch->load();
		$this->buyer_barcode->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fquery_production_tablelist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fquery_production_tablelist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fquery_production_tablelist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_query_production_table\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_query_production_table',hdr:ew.language.phrase('ExportToEmailText'),f:document.fquery_production_tablelist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_design_id":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1 and `grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer":
							break;
						case "x_design_id":
							break;
						case "x_status":
							break;
						case "x_dispatch_week_p":
							break;
						case "x_current_works":
							break;
						case "x_batch_no":
							break;
						case "x_process":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		ExecuteStatement("SET @@group_concat_max_len = 100000;");
		IF (isset($_GET['CID']))
		{
		ExecuteStatement("UPDATE `qpb_setup` SET `qpb_setup`.`refresh` = (`refresh`+1)");	
		}
		$item = &$this->OtherOptions['action']->Add("Change Buyer");
		$item->Body = '<button class="btn btn-danger ew-action" onclick="ew.modalDialogShow({btn:\'SaveBtn\',url:\'qpb_setupedit.php?id=1\'});">Change Buyer</button>';
		$item->Visible = True;
		$item = &$this->OtherOptions['action']->Add("Re-fresh");
		$item->Body = '<a href="query_production_tablelist.php?CID=7fa7" data-original-title ="Re-fresh"><i data-phrase="Re-fresh"  class="fa fa-refresh ew-icon" ></i></a>';
		$item->Visible = True;	
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
			$msg = '<button class="btn btn-danger ew-action" onclick="ew.modalDialogShow({btn:\'SaveBtn\',url:\'qpb_setupedit.php?id=1\'});">Change Buyer</button>';
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'query_production_table');	
		$item = &$this->OtherOptions['action']->Add("Change Buyer");
		$item->Body = '<button class="btn btn-danger ew-action" onclick="ew.modalDialogShow({btn:\'SaveBtn\',url:\'qpb_setupedit.php?id=1\'});">Change Buyer</button>';
		$item->Visible = True;
		$item = &$this->OtherOptions['action']->Add("Re-fresh");
		$item->Body = '<a href="query_production_tablelist.php?CID=7fa7" data-original-title ="Re-fresh"><i data-phrase="Re-fresh"  class="fa fa-refresh ew-icon" ></i></a>';
		$item->Visible = True;	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>