<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for quotation
 */
class quotation extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $main_image;
	public $godown_id;
	public $product;
	public $product_code;
	public $Balance;
	public $price;
	public $price_kg;
	public $price_unit;
	public $b_12;
	public $b_01;
	public $v_01;
	public $v_02;
	public $v_03;
	public $v_04;
	public $v_05;
	public $Amount;
	public $packing_type;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'quotation';
		$this->TableName = 'quotation';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`quotation`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('quotation', 'quotation', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// main_image
		$this->main_image = new DbField('quotation', 'quotation', 'x_main_image', 'main_image', '`main_image`', '`main_image`', 200, -1, TRUE, '`main_image`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->main_image->Sortable = TRUE; // Allow sort
		$this->fields['main_image'] = &$this->main_image;

		// godown_id
		$this->godown_id = new DbField('quotation', 'quotation', 'x_godown_id', 'godown_id', '`godown_id`', '`godown_id`', 131, -1, FALSE, '`godown_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->godown_id->Sortable = TRUE; // Allow sort
		$this->godown_id->Lookup = new Lookup('godown_id', 'godown_table', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->godown_id->AdvancedSearch->SearchValueDefault = 1;
		$this->godown_id->AdvancedSearch->SearchOperatorDefault = "=";
		$this->godown_id->AdvancedSearch->SearchOperatorDefault2 = "";
		$this->godown_id->AdvancedSearch->SearchConditionDefault = "AND";
		$this->fields['godown_id'] = &$this->godown_id;

		// product
		$this->product = new DbField('quotation', 'quotation', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product_g', TRUE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// product_code
		$this->product_code = new DbField('quotation', 'quotation', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// Balance
		$this->Balance = new DbField('quotation', 'quotation', 'x_Balance', 'Balance', '`Balance`', '`Balance`', 200, -1, FALSE, '`Balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Balance->Sortable = TRUE; // Allow sort
		$this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Balance'] = &$this->Balance;

		// price
		$this->price = new DbField('quotation', 'quotation', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// price_kg
		$this->price_kg = new DbField('quotation', 'quotation', 'x_price_kg', 'price_kg', '`price_kg`', '`price_kg`', 5, -1, FALSE, '`price_kg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price_kg->Sortable = TRUE; // Allow sort
		$this->price_kg->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price_kg'] = &$this->price_kg;

		// price_unit
		$this->price_unit = new DbField('quotation', 'quotation', 'x_price_unit', 'price_unit', '`price_unit`', '`price_unit`', 5, -1, FALSE, '`price_unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price_unit->Sortable = TRUE; // Allow sort
		$this->price_unit->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price_unit'] = &$this->price_unit;

		// b_12
		$this->b_12 = new DbField('quotation', 'quotation', 'x_b_12', 'b_12', '`b_12`', '`b_12`', 200, -1, FALSE, '`b_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_12->Sortable = TRUE; // Allow sort
		$this->fields['b_12'] = &$this->b_12;

		// b_01
		$this->b_01 = new DbField('quotation', 'quotation', 'x_b_01', 'b_01', '`b_01`', '`b_01`', 200, -1, FALSE, '`b_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_01->Sortable = TRUE; // Allow sort
		$this->fields['b_01'] = &$this->b_01;

		// v_01
		$this->v_01 = new DbField('quotation', 'quotation', 'x_v_01', 'v_01', '`v_01`', '`v_01`', 200, -1, FALSE, '`v_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_01->Required = TRUE; // Required field
		$this->v_01->Sortable = TRUE; // Allow sort
		$this->v_01->Lookup = new Lookup('v_01', '_varient_view', TRUE, 'code', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['v_01'] = &$this->v_01;

		// v_02
		$this->v_02 = new DbField('quotation', 'quotation', 'x_v_02', 'v_02', '`v_02`', '`v_02`', 200, -1, FALSE, '`v_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_02->Required = TRUE; // Required field
		$this->v_02->Sortable = TRUE; // Allow sort
		$this->v_02->Lookup = new Lookup('v_02', '_varient_view', TRUE, 'code', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['v_02'] = &$this->v_02;

		// v_03
		$this->v_03 = new DbField('quotation', 'quotation', 'x_v_03', 'v_03', '`v_03`', '`v_03`', 200, -1, FALSE, '`v_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_03->Required = TRUE; // Required field
		$this->v_03->Sortable = TRUE; // Allow sort
		$this->v_03->Lookup = new Lookup('v_03', '_varient_view', TRUE, 'code', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['v_03'] = &$this->v_03;

		// v_04
		$this->v_04 = new DbField('quotation', 'quotation', 'x_v_04', 'v_04', '`v_04`', '`v_04`', 200, -1, FALSE, '`v_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_04->Required = TRUE; // Required field
		$this->v_04->Sortable = TRUE; // Allow sort
		$this->v_04->Lookup = new Lookup('v_04', '_varient_view', TRUE, 'code', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['v_04'] = &$this->v_04;

		// v_05
		$this->v_05 = new DbField('quotation', 'quotation', 'x_v_05', 'v_05', '`v_05`', '`v_05`', 200, -1, FALSE, '`v_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_05->Required = TRUE; // Required field
		$this->v_05->Sortable = TRUE; // Allow sort
		$this->v_05->Lookup = new Lookup('v_05', 'varient', TRUE, 'code', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['v_05'] = &$this->v_05;

		// Amount
		$this->Amount = new DbField('quotation', 'quotation', 'x_Amount', 'Amount', '`Amount`', '`Amount`', 131, -1, FALSE, '`Amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Amount->Sortable = TRUE; // Allow sort
		$this->Amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Amount'] = &$this->Amount;

		// packing_type
		$this->packing_type = new DbField('quotation', 'quotation', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 131, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packing_type'] = &$this->packing_type;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`quotation`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->godown_id->DbValue = $row['godown_id'];
		$this->product->DbValue = $row['product'];
		$this->product_code->DbValue = $row['product_code'];
		$this->Balance->DbValue = $row['Balance'];
		$this->price->DbValue = $row['price'];
		$this->price_kg->DbValue = $row['price_kg'];
		$this->price_unit->DbValue = $row['price_unit'];
		$this->b_12->DbValue = $row['b_12'];
		$this->b_01->DbValue = $row['b_01'];
		$this->v_01->DbValue = $row['v_01'];
		$this->v_02->DbValue = $row['v_02'];
		$this->v_03->DbValue = $row['v_03'];
		$this->v_04->DbValue = $row['v_04'];
		$this->v_05->DbValue = $row['v_05'];
		$this->Amount->DbValue = $row['Amount'];
		$this->packing_type->DbValue = $row['packing_type'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->main_image->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['main_image']) ? [] : [$row['main_image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->main_image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->main_image->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "quotationlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "quotationview.php")
			return $Language->phrase("View");
		elseif ($pageName == "quotationedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "quotationadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "quotationlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("quotationview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("quotationview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "quotationadd.php?" . $this->getUrlParm($parm);
		else
			$url = "quotationadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("quotationedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("quotationadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("quotationdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->main_image->Upload->DbValue = $rs->fields('main_image');
		$this->godown_id->setDbValue($rs->fields('godown_id'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->Balance->setDbValue($rs->fields('Balance'));
		$this->price->setDbValue($rs->fields('price'));
		$this->price_kg->setDbValue($rs->fields('price_kg'));
		$this->price_unit->setDbValue($rs->fields('price_unit'));
		$this->b_12->setDbValue($rs->fields('b_12'));
		$this->b_01->setDbValue($rs->fields('b_01'));
		$this->v_01->setDbValue($rs->fields('v_01'));
		$this->v_02->setDbValue($rs->fields('v_02'));
		$this->v_03->setDbValue($rs->fields('v_03'));
		$this->v_04->setDbValue($rs->fields('v_04'));
		$this->v_05->setDbValue($rs->fields('v_05'));
		$this->Amount->setDbValue($rs->fields('Amount'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// main_image
		// godown_id
		// product
		// product_code
		// Balance
		// price
		// price_kg
		// price_unit
		// b_12
		// b_01
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// Amount
		// packing_type
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// main_image
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->ImageWidth = 0;
			$this->main_image->ImageHeight = 50;
			$this->main_image->ImageAlt = $this->main_image->alt();
			$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
		} else {
			$this->main_image->ViewValue = "";
		}
		$this->main_image->ViewCustomAttributes = "";

		// godown_id
		$curVal = strval($this->godown_id->CurrentValue);
		if ($curVal <> "") {
			$this->godown_id->ViewValue = $this->godown_id->lookupCacheOption($curVal);
			if ($this->godown_id->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->godown_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->godown_id->ViewValue->add($this->godown_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->godown_id->ViewValue = $this->godown_id->CurrentValue;
				}
			}
		} else {
			$this->godown_id->ViewValue = NULL;
		}
		$this->godown_id->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// Balance
		$this->Balance->ViewValue = $this->Balance->CurrentValue;
		$this->Balance->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// price_kg
		$this->price_kg->ViewValue = $this->price_kg->CurrentValue;
		$this->price_kg->ViewValue = FormatNumber($this->price_kg->ViewValue, 2, -2, -2, -2);
		$this->price_kg->ViewCustomAttributes = "";

		// price_unit
		$this->price_unit->ViewValue = $this->price_unit->CurrentValue;
		$this->price_unit->ViewValue = FormatNumber($this->price_unit->ViewValue, 2, -2, -2, -2);
		$this->price_unit->ViewCustomAttributes = "";

		// b_12
		$this->b_12->ViewValue = $this->b_12->CurrentValue;
		$this->b_12->ViewCustomAttributes = "";

		// b_01
		$this->b_01->ViewValue = $this->b_01->CurrentValue;
		$this->b_01->ViewCustomAttributes = "";

		// v_01
		$curVal = strval($this->v_01->CurrentValue);
		if ($curVal <> "") {
			$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
			if ($this->v_01->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 101";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_01->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_01->ViewValue = $this->v_01->CurrentValue;
				}
			}
		} else {
			$this->v_01->ViewValue = NULL;
		}
		$this->v_01->ViewCustomAttributes = "";

		// v_02
		$curVal = strval($this->v_02->CurrentValue);
		if ($curVal <> "") {
			$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
			if ($this->v_02->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 102";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_02->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_02->ViewValue = $this->v_02->CurrentValue;
				}
			}
		} else {
			$this->v_02->ViewValue = NULL;
		}
		$this->v_02->ViewCustomAttributes = "";

		// v_03
		$curVal = strval($this->v_03->CurrentValue);
		if ($curVal <> "") {
			$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
			if ($this->v_03->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 103";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_03->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_03->ViewValue = $this->v_03->CurrentValue;
				}
			}
		} else {
			$this->v_03->ViewValue = NULL;
		}
		$this->v_03->ViewCustomAttributes = "";

		// v_04
		$curVal = strval($this->v_04->CurrentValue);
		if ($curVal <> "") {
			$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
			if ($this->v_04->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 104";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_04->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_04->ViewValue = $this->v_04->CurrentValue;
				}
			}
		} else {
			$this->v_04->ViewValue = NULL;
		}
		$this->v_04->ViewCustomAttributes = "";

		// v_05
		$curVal = strval($this->v_05->CurrentValue);
		if ($curVal <> "") {
			$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
			if ($this->v_05->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 105";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_05->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_05->ViewValue = $this->v_05->CurrentValue;
				}
			}
		} else {
			$this->v_05->ViewValue = NULL;
		}
		$this->v_05->ViewCustomAttributes = "";

		// Amount
		$this->Amount->ViewValue = $this->Amount->CurrentValue;
		$this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, 2, -2, -2, -2);
		$this->Amount->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 2, -2, -2, -2);
		$this->packing_type->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// main_image
		$this->main_image->LinkCustomAttributes = "";
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->Upload->DbValue); // Add prefix/suffix
			$this->main_image->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
		} else {
			$this->main_image->HrefValue = "";
		}
		$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
		$this->main_image->TooltipValue = "";
		if ($this->main_image->UseColorbox) {
			if (EmptyValue($this->main_image->TooltipValue))
				$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->main_image->LinkAttrs["data-rel"] = "quotation_x_main_image";
			AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
		}

		// godown_id
		$this->godown_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown_id->CurrentValue)) {
			$this->godown_id->HrefValue = "quotationlist.php?x_godown_id=" . $this->godown_id->CurrentValue; // Add prefix/suffix
			$this->godown_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown_id->HrefValue = FullUrl($this->godown_id->HrefValue, "href");
		} else {
			$this->godown_id->HrefValue = "";
		}
		$this->godown_id->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "quotationlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		if (!EmptyValue($this->product_code->CurrentValue)) {
			$this->product_code->HrefValue = "quotationlist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
			$this->product_code->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
		} else {
			$this->product_code->HrefValue = "";
		}
		$this->product_code->TooltipValue = "";

		// Balance
		$this->Balance->LinkCustomAttributes = "";
		$this->Balance->HrefValue = "";
		$this->Balance->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// price_kg
		$this->price_kg->LinkCustomAttributes = "";
		$this->price_kg->HrefValue = "";
		$this->price_kg->TooltipValue = "";

		// price_unit
		$this->price_unit->LinkCustomAttributes = "";
		$this->price_unit->HrefValue = "";
		$this->price_unit->TooltipValue = "";

		// b_12
		$this->b_12->LinkCustomAttributes = "";
		$this->b_12->HrefValue = "";
		$this->b_12->TooltipValue = "";

		// b_01
		$this->b_01->LinkCustomAttributes = "";
		$this->b_01->HrefValue = "";
		$this->b_01->TooltipValue = "";

		// v_01
		$this->v_01->LinkCustomAttributes = "";
		if (!EmptyValue($this->v_01->CurrentValue)) {
			$this->v_01->HrefValue = "quotationlist.php?x_v_01=" . $this->v_01->CurrentValue; // Add prefix/suffix
			$this->v_01->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->v_01->HrefValue = FullUrl($this->v_01->HrefValue, "href");
		} else {
			$this->v_01->HrefValue = "";
		}
		$this->v_01->TooltipValue = "";

		// v_02
		$this->v_02->LinkCustomAttributes = "";
		if (!EmptyValue($this->v_02->CurrentValue)) {
			$this->v_02->HrefValue = "quotationlist.php?x_v_02=" . $this->v_02->CurrentValue; // Add prefix/suffix
			$this->v_02->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->v_02->HrefValue = FullUrl($this->v_02->HrefValue, "href");
		} else {
			$this->v_02->HrefValue = "";
		}
		$this->v_02->TooltipValue = "";

		// v_03
		$this->v_03->LinkCustomAttributes = "";
		if (!EmptyValue($this->v_03->CurrentValue)) {
			$this->v_03->HrefValue = "quotationlist.php?x_v_03=" . $this->v_03->CurrentValue; // Add prefix/suffix
			$this->v_03->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->v_03->HrefValue = FullUrl($this->v_03->HrefValue, "href");
		} else {
			$this->v_03->HrefValue = "";
		}
		$this->v_03->TooltipValue = "";

		// v_04
		$this->v_04->LinkCustomAttributes = "";
		if (!EmptyValue($this->v_04->CurrentValue)) {
			$this->v_04->HrefValue = "quotationlist.php?x_v_04=" . $this->v_04->CurrentValue; // Add prefix/suffix
			$this->v_04->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->v_04->HrefValue = FullUrl($this->v_04->HrefValue, "href");
		} else {
			$this->v_04->HrefValue = "";
		}
		$this->v_04->TooltipValue = "";

		// v_05
		$this->v_05->LinkCustomAttributes = "";
		if (!EmptyValue($this->v_05->CurrentValue)) {
			$this->v_05->HrefValue = "quotationlist.php?x_v_05=" . $this->v_05->CurrentValue; // Add prefix/suffix
			$this->v_05->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->v_05->HrefValue = FullUrl($this->v_05->HrefValue, "href");
		} else {
			$this->v_05->HrefValue = "";
		}
		$this->v_05->TooltipValue = "";

		// Amount
		$this->Amount->LinkCustomAttributes = "";
		$this->Amount->HrefValue = "";
		$this->Amount->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// main_image
		$this->main_image->EditAttrs["class"] = "form-control";
		$this->main_image->EditCustomAttributes = "";
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->ImageWidth = 0;
			$this->main_image->ImageHeight = 50;
			$this->main_image->ImageAlt = $this->main_image->alt();
			$this->main_image->EditValue = $this->main_image->Upload->DbValue;
		} else {
			$this->main_image->EditValue = "";
		}
		if (!EmptyValue($this->main_image->CurrentValue))
				$this->main_image->Upload->FileName = $this->main_image->CurrentValue;

		// godown_id
		$this->godown_id->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// Balance
		$this->Balance->EditAttrs["class"] = "form-control";
		$this->Balance->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->Balance->CurrentValue = HtmlDecode($this->Balance->CurrentValue);
		$this->Balance->EditValue = $this->Balance->CurrentValue;
		$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

		// price_kg
		$this->price_kg->EditAttrs["class"] = "form-control";
		$this->price_kg->EditCustomAttributes = "";
		$this->price_kg->EditValue = $this->price_kg->CurrentValue;
		$this->price_kg->PlaceHolder = RemoveHtml($this->price_kg->caption());
		if (strval($this->price_kg->EditValue) <> "" && is_numeric($this->price_kg->EditValue))
			$this->price_kg->EditValue = FormatNumber($this->price_kg->EditValue, -2, -2, -2, -2);

		// price_unit
		$this->price_unit->EditAttrs["class"] = "form-control";
		$this->price_unit->EditCustomAttributes = "";
		$this->price_unit->EditValue = $this->price_unit->CurrentValue;
		$this->price_unit->PlaceHolder = RemoveHtml($this->price_unit->caption());
		if (strval($this->price_unit->EditValue) <> "" && is_numeric($this->price_unit->EditValue))
			$this->price_unit->EditValue = FormatNumber($this->price_unit->EditValue, -2, -2, -2, -2);

		// b_12
		$this->b_12->EditAttrs["class"] = "form-control";
		$this->b_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
		$this->b_12->EditValue = $this->b_12->CurrentValue;
		$this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

		// b_01
		$this->b_01->EditAttrs["class"] = "form-control";
		$this->b_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
		$this->b_01->EditValue = $this->b_01->CurrentValue;
		$this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

		// v_01
		$this->v_01->EditCustomAttributes = "";

		// v_02
		$this->v_02->EditCustomAttributes = "";

		// v_03
		$this->v_03->EditCustomAttributes = "";

		// v_04
		$this->v_04->EditCustomAttributes = "";

		// v_05
		$this->v_05->EditCustomAttributes = "";

		// Amount
		$this->Amount->EditAttrs["class"] = "form-control";
		$this->Amount->EditCustomAttributes = "";
		$this->Amount->EditValue = $this->Amount->CurrentValue;
		$this->Amount->PlaceHolder = RemoveHtml($this->Amount->caption());
		if (strval($this->Amount->EditValue) <> "" && is_numeric($this->Amount->EditValue))
			$this->Amount->EditValue = FormatNumber($this->Amount->EditValue, -2, -2, -2, -2);

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
		if (strval($this->packing_type->EditValue) <> "" && is_numeric($this->packing_type->EditValue))
			$this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->Balance->CurrentValue))
				$this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
			$this->price_kg->Count++; // Increment count
			if (is_numeric($this->price_kg->CurrentValue))
				$this->price_kg->Total += $this->price_kg->CurrentValue; // Accumulate total
			if (is_numeric($this->Amount->CurrentValue))
				$this->Amount->Total += $this->Amount->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->Balance->CurrentValue = $this->Balance->Total;
			$this->Balance->ViewValue = $this->Balance->CurrentValue;
			$this->Balance->ViewCustomAttributes = "";
			$this->Balance->HrefValue = ""; // Clear href value
			if ($this->price_kg->Count > 0) {
				$this->price_kg->CurrentValue = $this->price_kg->Total / $this->price_kg->Count;
			}
			$this->price_kg->ViewValue = $this->price_kg->CurrentValue;
			$this->price_kg->ViewValue = FormatNumber($this->price_kg->ViewValue, 2, -2, -2, -2);
			$this->price_kg->ViewCustomAttributes = "";
			$this->price_kg->HrefValue = ""; // Clear href value
			$this->Amount->CurrentValue = $this->Amount->Total;
			$this->Amount->ViewValue = $this->Amount->CurrentValue;
			$this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, 2, -2, -2, -2);
			$this->Amount->ViewCustomAttributes = "";
			$this->Amount->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->godown_id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->price_kg);
					$doc->exportCaption($this->price_unit);
					$doc->exportCaption($this->b_12);
					$doc->exportCaption($this->b_01);
					$doc->exportCaption($this->v_01);
					$doc->exportCaption($this->v_02);
					$doc->exportCaption($this->v_03);
					$doc->exportCaption($this->v_04);
					$doc->exportCaption($this->v_05);
					$doc->exportCaption($this->Amount);
					$doc->exportCaption($this->packing_type);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->godown_id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->price_kg);
					$doc->exportCaption($this->price_unit);
					$doc->exportCaption($this->b_12);
					$doc->exportCaption($this->b_01);
					$doc->exportCaption($this->v_01);
					$doc->exportCaption($this->v_02);
					$doc->exportCaption($this->v_03);
					$doc->exportCaption($this->v_04);
					$doc->exportCaption($this->v_05);
					$doc->exportCaption($this->Amount);
					$doc->exportCaption($this->packing_type);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->main_image);
						$doc->exportField($this->godown_id);
						$doc->exportField($this->product);
						$doc->exportField($this->product_code);
						$doc->exportField($this->Balance);
						$doc->exportField($this->price);
						$doc->exportField($this->price_kg);
						$doc->exportField($this->price_unit);
						$doc->exportField($this->b_12);
						$doc->exportField($this->b_01);
						$doc->exportField($this->v_01);
						$doc->exportField($this->v_02);
						$doc->exportField($this->v_03);
						$doc->exportField($this->v_04);
						$doc->exportField($this->v_05);
						$doc->exportField($this->Amount);
						$doc->exportField($this->packing_type);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->main_image);
						$doc->exportField($this->godown_id);
						$doc->exportField($this->product);
						$doc->exportField($this->product_code);
						$doc->exportField($this->Balance);
						$doc->exportField($this->price);
						$doc->exportField($this->price_kg);
						$doc->exportField($this->price_unit);
						$doc->exportField($this->b_12);
						$doc->exportField($this->b_01);
						$doc->exportField($this->v_01);
						$doc->exportField($this->v_02);
						$doc->exportField($this->v_03);
						$doc->exportField($this->v_04);
						$doc->exportField($this->v_05);
						$doc->exportField($this->Amount);
						$doc->exportField($this->packing_type);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->main_image, '');
				$doc->exportAggregate($this->godown_id, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->product_code, '');
				$doc->exportAggregate($this->Balance, 'TOTAL');
				$doc->exportAggregate($this->price, '');
				$doc->exportAggregate($this->price_kg, 'AVERAGE');
				$doc->exportAggregate($this->price_unit, '');
				$doc->exportAggregate($this->b_12, '');
				$doc->exportAggregate($this->b_01, '');
				$doc->exportAggregate($this->v_01, '');
				$doc->exportAggregate($this->v_02, '');
				$doc->exportAggregate($this->v_03, '');
				$doc->exportAggregate($this->v_04, '');
				$doc->exportAggregate($this->v_05, '');
				$doc->exportAggregate($this->Amount, 'TOTAL');
				$doc->exportAggregate($this->packing_type, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'main_image') {
			$fldName = "main_image";
			$fileNameFld = "main_image";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 0) {
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>