<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class quotation_list extends quotation
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'quotation';

	// Page object name
	public $PageObjName = "quotation_list";

	// Grid form hidden field names
	public $FormName = "fquotationlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (quotation)
		if (!isset($GLOBALS["quotation"]) || get_class($GLOBALS["quotation"]) == PROJECT_NAMESPACE . "quotation") {
			$GLOBALS["quotation"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["quotation"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "quotationadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "quotationdelete.php";
		$this->MultiUpdateUrl = "quotationupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'quotation');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fquotationlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $quotation;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($quotation);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->main_image->setVisibility();
		$this->godown_id->setVisibility();
		$this->product->setVisibility();
		$this->product_code->setVisibility();
		$this->Balance->setVisibility();
		$this->price->setVisibility();
		$this->price_kg->setVisibility();
		$this->price_unit->setVisibility();
		$this->b_12->setVisibility();
		$this->b_01->setVisibility();
		$this->v_01->setVisibility();
		$this->v_02->setVisibility();
		$this->v_03->setVisibility();
		$this->v_04->setVisibility();
		$this->v_05->setVisibility();
		$this->Amount->setVisibility();
		$this->packing_type->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->godown_id);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->v_01);
		$this->setupLookupOptions($this->v_02);
		$this->setupLookupOptions($this->v_03);
		$this->setupLookupOptions($this->v_04);
		$this->setupLookupOptions($this->v_05);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fquotationlistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->main_image->AdvancedSearch->toJson(), ","); // Field main_image
		$filterList = Concat($filterList, $this->godown_id->AdvancedSearch->toJson(), ","); // Field godown_id
		$filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
		$filterList = Concat($filterList, $this->product_code->AdvancedSearch->toJson(), ","); // Field product_code
		$filterList = Concat($filterList, $this->Balance->AdvancedSearch->toJson(), ","); // Field Balance
		$filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
		$filterList = Concat($filterList, $this->price_kg->AdvancedSearch->toJson(), ","); // Field price_kg
		$filterList = Concat($filterList, $this->price_unit->AdvancedSearch->toJson(), ","); // Field price_unit
		$filterList = Concat($filterList, $this->b_12->AdvancedSearch->toJson(), ","); // Field b_12
		$filterList = Concat($filterList, $this->b_01->AdvancedSearch->toJson(), ","); // Field b_01
		$filterList = Concat($filterList, $this->v_01->AdvancedSearch->toJson(), ","); // Field v_01
		$filterList = Concat($filterList, $this->v_02->AdvancedSearch->toJson(), ","); // Field v_02
		$filterList = Concat($filterList, $this->v_03->AdvancedSearch->toJson(), ","); // Field v_03
		$filterList = Concat($filterList, $this->v_04->AdvancedSearch->toJson(), ","); // Field v_04
		$filterList = Concat($filterList, $this->v_05->AdvancedSearch->toJson(), ","); // Field v_05
		$filterList = Concat($filterList, $this->Amount->AdvancedSearch->toJson(), ","); // Field Amount
		$filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fquotationlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field main_image
		$this->main_image->AdvancedSearch->SearchValue = @$filter["x_main_image"];
		$this->main_image->AdvancedSearch->SearchOperator = @$filter["z_main_image"];
		$this->main_image->AdvancedSearch->SearchCondition = @$filter["v_main_image"];
		$this->main_image->AdvancedSearch->SearchValue2 = @$filter["y_main_image"];
		$this->main_image->AdvancedSearch->SearchOperator2 = @$filter["w_main_image"];
		$this->main_image->AdvancedSearch->save();

		// Field godown_id
		$this->godown_id->AdvancedSearch->SearchValue = @$filter["x_godown_id"];
		$this->godown_id->AdvancedSearch->SearchOperator = @$filter["z_godown_id"];
		$this->godown_id->AdvancedSearch->SearchCondition = @$filter["v_godown_id"];
		$this->godown_id->AdvancedSearch->SearchValue2 = @$filter["y_godown_id"];
		$this->godown_id->AdvancedSearch->SearchOperator2 = @$filter["w_godown_id"];
		$this->godown_id->AdvancedSearch->save();

		// Field product
		$this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
		$this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
		$this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
		$this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
		$this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
		$this->product->AdvancedSearch->save();

		// Field product_code
		$this->product_code->AdvancedSearch->SearchValue = @$filter["x_product_code"];
		$this->product_code->AdvancedSearch->SearchOperator = @$filter["z_product_code"];
		$this->product_code->AdvancedSearch->SearchCondition = @$filter["v_product_code"];
		$this->product_code->AdvancedSearch->SearchValue2 = @$filter["y_product_code"];
		$this->product_code->AdvancedSearch->SearchOperator2 = @$filter["w_product_code"];
		$this->product_code->AdvancedSearch->save();

		// Field Balance
		$this->Balance->AdvancedSearch->SearchValue = @$filter["x_Balance"];
		$this->Balance->AdvancedSearch->SearchOperator = @$filter["z_Balance"];
		$this->Balance->AdvancedSearch->SearchCondition = @$filter["v_Balance"];
		$this->Balance->AdvancedSearch->SearchValue2 = @$filter["y_Balance"];
		$this->Balance->AdvancedSearch->SearchOperator2 = @$filter["w_Balance"];
		$this->Balance->AdvancedSearch->save();

		// Field price
		$this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
		$this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
		$this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
		$this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
		$this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
		$this->price->AdvancedSearch->save();

		// Field price_kg
		$this->price_kg->AdvancedSearch->SearchValue = @$filter["x_price_kg"];
		$this->price_kg->AdvancedSearch->SearchOperator = @$filter["z_price_kg"];
		$this->price_kg->AdvancedSearch->SearchCondition = @$filter["v_price_kg"];
		$this->price_kg->AdvancedSearch->SearchValue2 = @$filter["y_price_kg"];
		$this->price_kg->AdvancedSearch->SearchOperator2 = @$filter["w_price_kg"];
		$this->price_kg->AdvancedSearch->save();

		// Field price_unit
		$this->price_unit->AdvancedSearch->SearchValue = @$filter["x_price_unit"];
		$this->price_unit->AdvancedSearch->SearchOperator = @$filter["z_price_unit"];
		$this->price_unit->AdvancedSearch->SearchCondition = @$filter["v_price_unit"];
		$this->price_unit->AdvancedSearch->SearchValue2 = @$filter["y_price_unit"];
		$this->price_unit->AdvancedSearch->SearchOperator2 = @$filter["w_price_unit"];
		$this->price_unit->AdvancedSearch->save();

		// Field b_12
		$this->b_12->AdvancedSearch->SearchValue = @$filter["x_b_12"];
		$this->b_12->AdvancedSearch->SearchOperator = @$filter["z_b_12"];
		$this->b_12->AdvancedSearch->SearchCondition = @$filter["v_b_12"];
		$this->b_12->AdvancedSearch->SearchValue2 = @$filter["y_b_12"];
		$this->b_12->AdvancedSearch->SearchOperator2 = @$filter["w_b_12"];
		$this->b_12->AdvancedSearch->save();

		// Field b_01
		$this->b_01->AdvancedSearch->SearchValue = @$filter["x_b_01"];
		$this->b_01->AdvancedSearch->SearchOperator = @$filter["z_b_01"];
		$this->b_01->AdvancedSearch->SearchCondition = @$filter["v_b_01"];
		$this->b_01->AdvancedSearch->SearchValue2 = @$filter["y_b_01"];
		$this->b_01->AdvancedSearch->SearchOperator2 = @$filter["w_b_01"];
		$this->b_01->AdvancedSearch->save();

		// Field v_01
		$this->v_01->AdvancedSearch->SearchValue = @$filter["x_v_01"];
		$this->v_01->AdvancedSearch->SearchOperator = @$filter["z_v_01"];
		$this->v_01->AdvancedSearch->SearchCondition = @$filter["v_v_01"];
		$this->v_01->AdvancedSearch->SearchValue2 = @$filter["y_v_01"];
		$this->v_01->AdvancedSearch->SearchOperator2 = @$filter["w_v_01"];
		$this->v_01->AdvancedSearch->save();

		// Field v_02
		$this->v_02->AdvancedSearch->SearchValue = @$filter["x_v_02"];
		$this->v_02->AdvancedSearch->SearchOperator = @$filter["z_v_02"];
		$this->v_02->AdvancedSearch->SearchCondition = @$filter["v_v_02"];
		$this->v_02->AdvancedSearch->SearchValue2 = @$filter["y_v_02"];
		$this->v_02->AdvancedSearch->SearchOperator2 = @$filter["w_v_02"];
		$this->v_02->AdvancedSearch->save();

		// Field v_03
		$this->v_03->AdvancedSearch->SearchValue = @$filter["x_v_03"];
		$this->v_03->AdvancedSearch->SearchOperator = @$filter["z_v_03"];
		$this->v_03->AdvancedSearch->SearchCondition = @$filter["v_v_03"];
		$this->v_03->AdvancedSearch->SearchValue2 = @$filter["y_v_03"];
		$this->v_03->AdvancedSearch->SearchOperator2 = @$filter["w_v_03"];
		$this->v_03->AdvancedSearch->save();

		// Field v_04
		$this->v_04->AdvancedSearch->SearchValue = @$filter["x_v_04"];
		$this->v_04->AdvancedSearch->SearchOperator = @$filter["z_v_04"];
		$this->v_04->AdvancedSearch->SearchCondition = @$filter["v_v_04"];
		$this->v_04->AdvancedSearch->SearchValue2 = @$filter["y_v_04"];
		$this->v_04->AdvancedSearch->SearchOperator2 = @$filter["w_v_04"];
		$this->v_04->AdvancedSearch->save();

		// Field v_05
		$this->v_05->AdvancedSearch->SearchValue = @$filter["x_v_05"];
		$this->v_05->AdvancedSearch->SearchOperator = @$filter["z_v_05"];
		$this->v_05->AdvancedSearch->SearchCondition = @$filter["v_v_05"];
		$this->v_05->AdvancedSearch->SearchValue2 = @$filter["y_v_05"];
		$this->v_05->AdvancedSearch->SearchOperator2 = @$filter["w_v_05"];
		$this->v_05->AdvancedSearch->save();

		// Field Amount
		$this->Amount->AdvancedSearch->SearchValue = @$filter["x_Amount"];
		$this->Amount->AdvancedSearch->SearchOperator = @$filter["z_Amount"];
		$this->Amount->AdvancedSearch->SearchCondition = @$filter["v_Amount"];
		$this->Amount->AdvancedSearch->SearchValue2 = @$filter["y_Amount"];
		$this->Amount->AdvancedSearch->SearchOperator2 = @$filter["w_Amount"];
		$this->Amount->AdvancedSearch->save();

		// Field packing_type
		$this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
		$this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
		$this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
		$this->packing_type->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->main_image, $default, FALSE); // main_image
		$this->buildSearchSql($where, $this->godown_id, $default, FALSE); // godown_id
		$this->buildSearchSql($where, $this->product, $default, FALSE); // product
		$this->buildSearchSql($where, $this->product_code, $default, FALSE); // product_code
		$this->buildSearchSql($where, $this->Balance, $default, FALSE); // Balance
		$this->buildSearchSql($where, $this->price, $default, FALSE); // price
		$this->buildSearchSql($where, $this->price_kg, $default, FALSE); // price_kg
		$this->buildSearchSql($where, $this->price_unit, $default, FALSE); // price_unit
		$this->buildSearchSql($where, $this->b_12, $default, FALSE); // b_12
		$this->buildSearchSql($where, $this->b_01, $default, FALSE); // b_01
		$this->buildSearchSql($where, $this->v_01, $default, TRUE); // v_01
		$this->buildSearchSql($where, $this->v_02, $default, TRUE); // v_02
		$this->buildSearchSql($where, $this->v_03, $default, TRUE); // v_03
		$this->buildSearchSql($where, $this->v_04, $default, TRUE); // v_04
		$this->buildSearchSql($where, $this->v_05, $default, TRUE); // v_05
		$this->buildSearchSql($where, $this->Amount, $default, FALSE); // Amount
		$this->buildSearchSql($where, $this->packing_type, $default, FALSE); // packing_type

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->main_image->AdvancedSearch->save(); // main_image
			$this->godown_id->AdvancedSearch->save(); // godown_id
			$this->product->AdvancedSearch->save(); // product
			$this->product_code->AdvancedSearch->save(); // product_code
			$this->Balance->AdvancedSearch->save(); // Balance
			$this->price->AdvancedSearch->save(); // price
			$this->price_kg->AdvancedSearch->save(); // price_kg
			$this->price_unit->AdvancedSearch->save(); // price_unit
			$this->b_12->AdvancedSearch->save(); // b_12
			$this->b_01->AdvancedSearch->save(); // b_01
			$this->v_01->AdvancedSearch->save(); // v_01
			$this->v_02->AdvancedSearch->save(); // v_02
			$this->v_03->AdvancedSearch->save(); // v_03
			$this->v_04->AdvancedSearch->save(); // v_04
			$this->v_05->AdvancedSearch->save(); // v_05
			$this->Amount->AdvancedSearch->save(); // Amount
			$this->packing_type->AdvancedSearch->save(); // packing_type
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->main_image, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product_code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_12, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_05, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->main_image->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->godown_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Balance->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price_kg->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price_unit->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packing_type->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		$this->godown_id->AdvancedSearch->loadDefault();
		return TRUE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->main_image->AdvancedSearch->unsetSession();
		$this->godown_id->AdvancedSearch->unsetSession();
		$this->product->AdvancedSearch->unsetSession();
		$this->product_code->AdvancedSearch->unsetSession();
		$this->Balance->AdvancedSearch->unsetSession();
		$this->price->AdvancedSearch->unsetSession();
		$this->price_kg->AdvancedSearch->unsetSession();
		$this->price_unit->AdvancedSearch->unsetSession();
		$this->b_12->AdvancedSearch->unsetSession();
		$this->b_01->AdvancedSearch->unsetSession();
		$this->v_01->AdvancedSearch->unsetSession();
		$this->v_02->AdvancedSearch->unsetSession();
		$this->v_03->AdvancedSearch->unsetSession();
		$this->v_04->AdvancedSearch->unsetSession();
		$this->v_05->AdvancedSearch->unsetSession();
		$this->Amount->AdvancedSearch->unsetSession();
		$this->packing_type->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->main_image->AdvancedSearch->load();
		$this->godown_id->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->product_code->AdvancedSearch->load();
		$this->Balance->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->price_kg->AdvancedSearch->load();
		$this->price_unit->AdvancedSearch->load();
		$this->b_12->AdvancedSearch->load();
		$this->b_01->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->Amount->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->main_image, $ctrl); // main_image
			$this->updateSort($this->godown_id, $ctrl); // godown_id
			$this->updateSort($this->product, $ctrl); // product
			$this->updateSort($this->product_code, $ctrl); // product_code
			$this->updateSort($this->Balance, $ctrl); // Balance
			$this->updateSort($this->price, $ctrl); // price
			$this->updateSort($this->price_kg, $ctrl); // price_kg
			$this->updateSort($this->price_unit, $ctrl); // price_unit
			$this->updateSort($this->b_12, $ctrl); // b_12
			$this->updateSort($this->b_01, $ctrl); // b_01
			$this->updateSort($this->v_01, $ctrl); // v_01
			$this->updateSort($this->v_02, $ctrl); // v_02
			$this->updateSort($this->v_03, $ctrl); // v_03
			$this->updateSort($this->v_04, $ctrl); // v_04
			$this->updateSort($this->v_05, $ctrl); // v_05
			$this->updateSort($this->Amount, $ctrl); // Amount
			$this->updateSort($this->packing_type, $ctrl); // packing_type
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->main_image->setSort("");
				$this->godown_id->setSort("");
				$this->product->setSort("");
				$this->product_code->setSort("");
				$this->Balance->setSort("");
				$this->price->setSort("");
				$this->price_kg->setSort("");
				$this->price_unit->setSort("");
				$this->b_12->setSort("");
				$this->b_01->setSort("");
				$this->v_01->setSort("");
				$this->v_02->setSort("");
				$this->v_03->setSort("");
				$this->v_04->setSort("");
				$this->v_05->setSort("");
				$this->Amount->setSort("");
				$this->packing_type->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fquotationlistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fquotationlistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fquotationlist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fquotationlistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ResetSearch") . "\" data-caption=\"" . $Language->phrase("ResetSearch") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ResetSearchBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"quotationsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fquotationlistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// main_image
		if (!$this->isAddOrEdit())
			$this->main_image->AdvancedSearch->setSearchValue(Get("x_main_image", Get("main_image", "")));
		if ($this->main_image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->main_image->AdvancedSearch->setSearchOperator(Get("z_main_image", ""));

		// godown_id
		if (!$this->isAddOrEdit())
			$this->godown_id->AdvancedSearch->setSearchValue(Get("x_godown_id", Get("godown_id", "")));
		if ($this->godown_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->godown_id->AdvancedSearch->setSearchOperator(Get("z_godown_id", ""));
		if (is_array($this->godown_id->AdvancedSearch->SearchValue))
			$this->godown_id->AdvancedSearch->SearchValue = implode(",", $this->godown_id->AdvancedSearch->SearchValue);
		if (is_array($this->godown_id->AdvancedSearch->SearchValue2))
			$this->godown_id->AdvancedSearch->SearchValue2 = implode(",", $this->godown_id->AdvancedSearch->SearchValue2);

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue(Get("x_product", Get("product", "")));
		if ($this->product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product->AdvancedSearch->setSearchOperator(Get("z_product", ""));

		// product_code
		if (!$this->isAddOrEdit())
			$this->product_code->AdvancedSearch->setSearchValue(Get("x_product_code", Get("product_code", "")));
		if ($this->product_code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_code->AdvancedSearch->setSearchOperator(Get("z_product_code", ""));

		// Balance
		if (!$this->isAddOrEdit())
			$this->Balance->AdvancedSearch->setSearchValue(Get("x_Balance", Get("Balance", "")));
		if ($this->Balance->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Balance->AdvancedSearch->setSearchOperator(Get("z_Balance", ""));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue(Get("x_price", Get("price", "")));
		if ($this->price->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price->AdvancedSearch->setSearchOperator(Get("z_price", ""));

		// price_kg
		if (!$this->isAddOrEdit())
			$this->price_kg->AdvancedSearch->setSearchValue(Get("x_price_kg", Get("price_kg", "")));
		if ($this->price_kg->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price_kg->AdvancedSearch->setSearchOperator(Get("z_price_kg", ""));

		// price_unit
		if (!$this->isAddOrEdit())
			$this->price_unit->AdvancedSearch->setSearchValue(Get("x_price_unit", Get("price_unit", "")));
		if ($this->price_unit->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price_unit->AdvancedSearch->setSearchOperator(Get("z_price_unit", ""));

		// b_12
		if (!$this->isAddOrEdit())
			$this->b_12->AdvancedSearch->setSearchValue(Get("x_b_12", Get("b_12", "")));
		if ($this->b_12->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_12->AdvancedSearch->setSearchOperator(Get("z_b_12", ""));

		// b_01
		if (!$this->isAddOrEdit())
			$this->b_01->AdvancedSearch->setSearchValue(Get("x_b_01", Get("b_01", "")));
		if ($this->b_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_01->AdvancedSearch->setSearchOperator(Get("z_b_01", ""));

		// v_01
		if (!$this->isAddOrEdit())
			$this->v_01->AdvancedSearch->setSearchValue(Get("x_v_01", Get("v_01", "")));
		if ($this->v_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_01->AdvancedSearch->setSearchOperator(Get("z_v_01", ""));
		if (is_array($this->v_01->AdvancedSearch->SearchValue))
			$this->v_01->AdvancedSearch->SearchValue = implode(",", $this->v_01->AdvancedSearch->SearchValue);
		if (is_array($this->v_01->AdvancedSearch->SearchValue2))
			$this->v_01->AdvancedSearch->SearchValue2 = implode(",", $this->v_01->AdvancedSearch->SearchValue2);

		// v_02
		if (!$this->isAddOrEdit())
			$this->v_02->AdvancedSearch->setSearchValue(Get("x_v_02", Get("v_02", "")));
		if ($this->v_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_02->AdvancedSearch->setSearchOperator(Get("z_v_02", ""));
		if (is_array($this->v_02->AdvancedSearch->SearchValue))
			$this->v_02->AdvancedSearch->SearchValue = implode(",", $this->v_02->AdvancedSearch->SearchValue);
		if (is_array($this->v_02->AdvancedSearch->SearchValue2))
			$this->v_02->AdvancedSearch->SearchValue2 = implode(",", $this->v_02->AdvancedSearch->SearchValue2);

		// v_03
		if (!$this->isAddOrEdit())
			$this->v_03->AdvancedSearch->setSearchValue(Get("x_v_03", Get("v_03", "")));
		if ($this->v_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_03->AdvancedSearch->setSearchOperator(Get("z_v_03", ""));
		if (is_array($this->v_03->AdvancedSearch->SearchValue))
			$this->v_03->AdvancedSearch->SearchValue = implode(",", $this->v_03->AdvancedSearch->SearchValue);
		if (is_array($this->v_03->AdvancedSearch->SearchValue2))
			$this->v_03->AdvancedSearch->SearchValue2 = implode(",", $this->v_03->AdvancedSearch->SearchValue2);

		// v_04
		if (!$this->isAddOrEdit())
			$this->v_04->AdvancedSearch->setSearchValue(Get("x_v_04", Get("v_04", "")));
		if ($this->v_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_04->AdvancedSearch->setSearchOperator(Get("z_v_04", ""));
		if (is_array($this->v_04->AdvancedSearch->SearchValue))
			$this->v_04->AdvancedSearch->SearchValue = implode(",", $this->v_04->AdvancedSearch->SearchValue);
		if (is_array($this->v_04->AdvancedSearch->SearchValue2))
			$this->v_04->AdvancedSearch->SearchValue2 = implode(",", $this->v_04->AdvancedSearch->SearchValue2);

		// v_05
		if (!$this->isAddOrEdit())
			$this->v_05->AdvancedSearch->setSearchValue(Get("x_v_05", Get("v_05", "")));
		if ($this->v_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_05->AdvancedSearch->setSearchOperator(Get("z_v_05", ""));
		if (is_array($this->v_05->AdvancedSearch->SearchValue))
			$this->v_05->AdvancedSearch->SearchValue = implode(",", $this->v_05->AdvancedSearch->SearchValue);
		if (is_array($this->v_05->AdvancedSearch->SearchValue2))
			$this->v_05->AdvancedSearch->SearchValue2 = implode(",", $this->v_05->AdvancedSearch->SearchValue2);

		// Amount
		if (!$this->isAddOrEdit())
			$this->Amount->AdvancedSearch->setSearchValue(Get("x_Amount", Get("Amount", "")));
		if ($this->Amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Amount->AdvancedSearch->setSearchOperator(Get("z_Amount", ""));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue(Get("x_packing_type", Get("packing_type", "")));
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packing_type->AdvancedSearch->setSearchOperator(Get("z_packing_type", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->main_image->setDbValue($this->main_image->Upload->DbValue);
		$this->godown_id->setDbValue($row['godown_id']);
		$this->product->setDbValue($row['product']);
		$this->product_code->setDbValue($row['product_code']);
		$this->Balance->setDbValue($row['Balance']);
		$this->price->setDbValue($row['price']);
		$this->price_kg->setDbValue($row['price_kg']);
		$this->price_unit->setDbValue($row['price_unit']);
		$this->b_12->setDbValue($row['b_12']);
		$this->b_01->setDbValue($row['b_01']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_05->setDbValue($row['v_05']);
		$this->Amount->setDbValue($row['Amount']);
		$this->packing_type->setDbValue($row['packing_type']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['main_image'] = NULL;
		$row['godown_id'] = NULL;
		$row['product'] = NULL;
		$row['product_code'] = NULL;
		$row['Balance'] = NULL;
		$row['price'] = NULL;
		$row['price_kg'] = NULL;
		$row['price_unit'] = NULL;
		$row['b_12'] = NULL;
		$row['b_01'] = NULL;
		$row['v_01'] = NULL;
		$row['v_02'] = NULL;
		$row['v_03'] = NULL;
		$row['v_04'] = NULL;
		$row['v_05'] = NULL;
		$row['Amount'] = NULL;
		$row['packing_type'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{
		return FALSE;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price_kg->FormValue == $this->price_kg->CurrentValue && is_numeric(ConvertToFloatString($this->price_kg->CurrentValue)))
			$this->price_kg->CurrentValue = ConvertToFloatString($this->price_kg->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price_unit->FormValue == $this->price_unit->CurrentValue && is_numeric(ConvertToFloatString($this->price_unit->CurrentValue)))
			$this->price_unit->CurrentValue = ConvertToFloatString($this->price_unit->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Amount->FormValue == $this->Amount->CurrentValue && is_numeric(ConvertToFloatString($this->Amount->CurrentValue)))
			$this->Amount->CurrentValue = ConvertToFloatString($this->Amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packing_type->FormValue == $this->packing_type->CurrentValue && is_numeric(ConvertToFloatString($this->packing_type->CurrentValue)))
			$this->packing_type->CurrentValue = ConvertToFloatString($this->packing_type->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// main_image
		// godown_id
		// product
		// product_code
		// Balance
		// price
		// price_kg
		// price_unit
		// b_12
		// b_01
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// Amount
		// packing_type
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->Balance->CurrentValue))
				$this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
			$this->price_kg->Count++; // Increment count
			if (is_numeric($this->price_kg->CurrentValue))
				$this->price_kg->Total += $this->price_kg->CurrentValue; // Accumulate total
			if (is_numeric($this->Amount->CurrentValue))
				$this->Amount->Total += $this->Amount->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// main_image
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 50;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->ViewValue = "";
			}
			$this->main_image->ViewCustomAttributes = "";

			// godown_id
			$curVal = strval($this->godown_id->CurrentValue);
			if ($curVal <> "") {
				$this->godown_id->ViewValue = $this->godown_id->lookupCacheOption($curVal);
				if ($this->godown_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->godown_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->godown_id->ViewValue->add($this->godown_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->godown_id->ViewValue = $this->godown_id->CurrentValue;
					}
				}
			} else {
				$this->godown_id->ViewValue = NULL;
			}
			$this->godown_id->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// Balance
			$this->Balance->ViewValue = $this->Balance->CurrentValue;
			$this->Balance->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// price_kg
			$this->price_kg->ViewValue = $this->price_kg->CurrentValue;
			$this->price_kg->ViewValue = FormatNumber($this->price_kg->ViewValue, 2, -2, -2, -2);
			$this->price_kg->ViewCustomAttributes = "";

			// price_unit
			$this->price_unit->ViewValue = $this->price_unit->CurrentValue;
			$this->price_unit->ViewValue = FormatNumber($this->price_unit->ViewValue, 2, -2, -2, -2);
			$this->price_unit->ViewCustomAttributes = "";

			// b_12
			$this->b_12->ViewValue = $this->b_12->CurrentValue;
			$this->b_12->ViewCustomAttributes = "";

			// b_01
			$this->b_01->ViewValue = $this->b_01->CurrentValue;
			$this->b_01->ViewCustomAttributes = "";

			// v_01
			$curVal = strval($this->v_01->CurrentValue);
			if ($curVal <> "") {
				$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
				if ($this->v_01->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_01->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_01->ViewValue = $this->v_01->CurrentValue;
					}
				}
			} else {
				$this->v_01->ViewValue = NULL;
			}
			$this->v_01->ViewCustomAttributes = "";

			// v_02
			$curVal = strval($this->v_02->CurrentValue);
			if ($curVal <> "") {
				$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
				if ($this->v_02->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_02->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_02->ViewValue = $this->v_02->CurrentValue;
					}
				}
			} else {
				$this->v_02->ViewValue = NULL;
			}
			$this->v_02->ViewCustomAttributes = "";

			// v_03
			$curVal = strval($this->v_03->CurrentValue);
			if ($curVal <> "") {
				$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
				if ($this->v_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_03->ViewValue = $this->v_03->CurrentValue;
					}
				}
			} else {
				$this->v_03->ViewValue = NULL;
			}
			$this->v_03->ViewCustomAttributes = "";

			// v_04
			$curVal = strval($this->v_04->CurrentValue);
			if ($curVal <> "") {
				$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
				if ($this->v_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_04->ViewValue = $this->v_04->CurrentValue;
					}
				}
			} else {
				$this->v_04->ViewValue = NULL;
			}
			$this->v_04->ViewCustomAttributes = "";

			// v_05
			$curVal = strval($this->v_05->CurrentValue);
			if ($curVal <> "") {
				$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
				if ($this->v_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_05->ViewValue = $this->v_05->CurrentValue;
					}
				}
			} else {
				$this->v_05->ViewValue = NULL;
			}
			$this->v_05->ViewCustomAttributes = "";

			// Amount
			$this->Amount->ViewValue = $this->Amount->CurrentValue;
			$this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, 2, -2, -2, -2);
			$this->Amount->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 2, -2, -2, -2);
			$this->packing_type->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// main_image
			$this->main_image->LinkCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->Upload->DbValue); // Add prefix/suffix
				$this->main_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
			} else {
				$this->main_image->HrefValue = "";
			}
			$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
			$this->main_image->TooltipValue = "";
			if ($this->main_image->UseColorbox) {
				if (EmptyValue($this->main_image->TooltipValue))
					$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->main_image->LinkAttrs["data-rel"] = "quotation_x" . $this->RowCnt . "_main_image";
				AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
			}

			// godown_id
			$this->godown_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown_id->CurrentValue)) {
				$this->godown_id->HrefValue = "quotationlist.php?x_godown_id=" . $this->godown_id->CurrentValue; // Add prefix/suffix
				$this->godown_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown_id->HrefValue = FullUrl($this->godown_id->HrefValue, "href");
			} else {
				$this->godown_id->HrefValue = "";
			}
			$this->godown_id->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "quotationlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "quotationlist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}
			$this->product_code->TooltipValue = "";
			if (!$this->isExport())
				$this->product_code->ViewValue = $this->highlightValue($this->product_code);

			// Balance
			$this->Balance->LinkCustomAttributes = "";
			$this->Balance->HrefValue = "";
			$this->Balance->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// price_kg
			$this->price_kg->LinkCustomAttributes = "";
			$this->price_kg->HrefValue = "";
			$this->price_kg->TooltipValue = "";

			// price_unit
			$this->price_unit->LinkCustomAttributes = "";
			$this->price_unit->HrefValue = "";
			$this->price_unit->TooltipValue = "";

			// b_12
			$this->b_12->LinkCustomAttributes = "";
			$this->b_12->HrefValue = "";
			$this->b_12->TooltipValue = "";
			if (!$this->isExport())
				$this->b_12->ViewValue = $this->highlightValue($this->b_12);

			// b_01
			$this->b_01->LinkCustomAttributes = "";
			$this->b_01->HrefValue = "";
			$this->b_01->TooltipValue = "";
			if (!$this->isExport())
				$this->b_01->ViewValue = $this->highlightValue($this->b_01);

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			if (!EmptyValue($this->v_01->CurrentValue)) {
				$this->v_01->HrefValue = "quotationlist.php?x_v_01=" . $this->v_01->CurrentValue; // Add prefix/suffix
				$this->v_01->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->v_01->HrefValue = FullUrl($this->v_01->HrefValue, "href");
			} else {
				$this->v_01->HrefValue = "";
			}
			$this->v_01->TooltipValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			if (!EmptyValue($this->v_02->CurrentValue)) {
				$this->v_02->HrefValue = "quotationlist.php?x_v_02=" . $this->v_02->CurrentValue; // Add prefix/suffix
				$this->v_02->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->v_02->HrefValue = FullUrl($this->v_02->HrefValue, "href");
			} else {
				$this->v_02->HrefValue = "";
			}
			$this->v_02->TooltipValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			if (!EmptyValue($this->v_03->CurrentValue)) {
				$this->v_03->HrefValue = "quotationlist.php?x_v_03=" . $this->v_03->CurrentValue; // Add prefix/suffix
				$this->v_03->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->v_03->HrefValue = FullUrl($this->v_03->HrefValue, "href");
			} else {
				$this->v_03->HrefValue = "";
			}
			$this->v_03->TooltipValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			if (!EmptyValue($this->v_04->CurrentValue)) {
				$this->v_04->HrefValue = "quotationlist.php?x_v_04=" . $this->v_04->CurrentValue; // Add prefix/suffix
				$this->v_04->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->v_04->HrefValue = FullUrl($this->v_04->HrefValue, "href");
			} else {
				$this->v_04->HrefValue = "";
			}
			$this->v_04->TooltipValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			if (!EmptyValue($this->v_05->CurrentValue)) {
				$this->v_05->HrefValue = "quotationlist.php?x_v_05=" . $this->v_05->CurrentValue; // Add prefix/suffix
				$this->v_05->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->v_05->HrefValue = FullUrl($this->v_05->HrefValue, "href");
			} else {
				$this->v_05->HrefValue = "";
			}
			$this->v_05->TooltipValue = "";

			// Amount
			$this->Amount->LinkCustomAttributes = "";
			$this->Amount->HrefValue = "";
			$this->Amount->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// main_image
			$this->main_image->EditAttrs["class"] = "form-control";
			$this->main_image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->main_image->AdvancedSearch->SearchValue = HtmlDecode($this->main_image->AdvancedSearch->SearchValue);
			$this->main_image->EditValue = HtmlEncode($this->main_image->AdvancedSearch->SearchValue);
			$this->main_image->PlaceHolder = RemoveHtml($this->main_image->caption());

			// godown_id
			$this->godown_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->godown_id->AdvancedSearch->ViewValue = $this->godown_id->lookupCacheOption($curVal);
			else
				$this->godown_id->AdvancedSearch->ViewValue = $this->godown_id->Lookup !== NULL && is_array($this->godown_id->Lookup->Options) ? $curVal : NULL;
			if ($this->godown_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->godown_id->EditValue = array_values($this->godown_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`id` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown_id->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// Balance
			$this->Balance->EditAttrs["class"] = "form-control";
			$this->Balance->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Balance->AdvancedSearch->SearchValue = HtmlDecode($this->Balance->AdvancedSearch->SearchValue);
			$this->Balance->EditValue = HtmlEncode($this->Balance->AdvancedSearch->SearchValue);
			$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->AdvancedSearch->SearchValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());

			// price_kg
			$this->price_kg->EditAttrs["class"] = "form-control";
			$this->price_kg->EditCustomAttributes = "";
			$this->price_kg->EditValue = HtmlEncode($this->price_kg->AdvancedSearch->SearchValue);
			$this->price_kg->PlaceHolder = RemoveHtml($this->price_kg->caption());

			// price_unit
			$this->price_unit->EditAttrs["class"] = "form-control";
			$this->price_unit->EditCustomAttributes = "";
			$this->price_unit->EditValue = HtmlEncode($this->price_unit->AdvancedSearch->SearchValue);
			$this->price_unit->PlaceHolder = RemoveHtml($this->price_unit->caption());

			// b_12
			$this->b_12->EditAttrs["class"] = "form-control";
			$this->b_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_12->AdvancedSearch->SearchValue = HtmlDecode($this->b_12->AdvancedSearch->SearchValue);
			$this->b_12->EditValue = HtmlEncode($this->b_12->AdvancedSearch->SearchValue);
			$this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

			// b_01
			$this->b_01->EditAttrs["class"] = "form-control";
			$this->b_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_01->AdvancedSearch->SearchValue = HtmlDecode($this->b_01->AdvancedSearch->SearchValue);
			$this->b_01->EditValue = HtmlEncode($this->b_01->AdvancedSearch->SearchValue);
			$this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

			// v_01
			$this->v_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_01->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_01->AdvancedSearch->ViewValue = $this->v_01->lookupCacheOption($curVal);
			else
				$this->v_01->AdvancedSearch->ViewValue = $this->v_01->Lookup !== NULL && is_array($this->v_01->Lookup->Options) ? $curVal : NULL;
			if ($this->v_01->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_01->EditValue = array_values($this->v_01->Lookup->Options);
				if ($this->v_01->AdvancedSearch->ViewValue == "")
					$this->v_01->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 101";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_01->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->v_01->AdvancedSearch->ViewValue->add($this->v_01->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->v_01->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_01->EditValue = $arwrk;
			}

			// v_02
			$this->v_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_02->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_02->AdvancedSearch->ViewValue = $this->v_02->lookupCacheOption($curVal);
			else
				$this->v_02->AdvancedSearch->ViewValue = $this->v_02->Lookup !== NULL && is_array($this->v_02->Lookup->Options) ? $curVal : NULL;
			if ($this->v_02->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_02->EditValue = array_values($this->v_02->Lookup->Options);
				if ($this->v_02->AdvancedSearch->ViewValue == "")
					$this->v_02->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 102";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_02->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->v_02->AdvancedSearch->ViewValue->add($this->v_02->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->v_02->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_02->EditValue = $arwrk;
			}

			// v_03
			$this->v_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_03->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_03->AdvancedSearch->ViewValue = $this->v_03->lookupCacheOption($curVal);
			else
				$this->v_03->AdvancedSearch->ViewValue = $this->v_03->Lookup !== NULL && is_array($this->v_03->Lookup->Options) ? $curVal : NULL;
			if ($this->v_03->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_03->EditValue = array_values($this->v_03->Lookup->Options);
				if ($this->v_03->AdvancedSearch->ViewValue == "")
					$this->v_03->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 103";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_03->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->v_03->AdvancedSearch->ViewValue->add($this->v_03->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->v_03->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_03->EditValue = $arwrk;
			}

			// v_04
			$this->v_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_04->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_04->AdvancedSearch->ViewValue = $this->v_04->lookupCacheOption($curVal);
			else
				$this->v_04->AdvancedSearch->ViewValue = $this->v_04->Lookup !== NULL && is_array($this->v_04->Lookup->Options) ? $curVal : NULL;
			if ($this->v_04->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_04->EditValue = array_values($this->v_04->Lookup->Options);
				if ($this->v_04->AdvancedSearch->ViewValue == "")
					$this->v_04->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 104";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_04->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->v_04->AdvancedSearch->ViewValue->add($this->v_04->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->v_04->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_04->EditValue = $arwrk;
			}

			// v_05
			$this->v_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_05->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_05->AdvancedSearch->ViewValue = $this->v_05->lookupCacheOption($curVal);
			else
				$this->v_05->AdvancedSearch->ViewValue = $this->v_05->Lookup !== NULL && is_array($this->v_05->Lookup->Options) ? $curVal : NULL;
			if ($this->v_05->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_05->EditValue = array_values($this->v_05->Lookup->Options);
				if ($this->v_05->AdvancedSearch->ViewValue == "")
					$this->v_05->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 105";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_05->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->v_05->AdvancedSearch->ViewValue->add($this->v_05->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->v_05->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_05->EditValue = $arwrk;
			}

			// Amount
			$this->Amount->EditAttrs["class"] = "form-control";
			$this->Amount->EditCustomAttributes = "";
			$this->Amount->EditValue = HtmlEncode($this->Amount->AdvancedSearch->SearchValue);
			$this->Amount->PlaceHolder = RemoveHtml($this->Amount->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->AdvancedSearch->SearchValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->Balance->Total = 0; // Initialize total
			$this->price_kg->Count = 0; // Initialize count
			$this->price_kg->Total = 0; // Initialize total
			$this->Amount->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->Balance->CurrentValue = $this->Balance->Total;
			$this->Balance->ViewValue = $this->Balance->CurrentValue;
			$this->Balance->ViewCustomAttributes = "";
			$this->Balance->HrefValue = ""; // Clear href value
			if ($this->price_kg->Count > 0) {
				$this->price_kg->CurrentValue = $this->price_kg->Total / $this->price_kg->Count;
			}
			$this->price_kg->ViewValue = $this->price_kg->CurrentValue;
			$this->price_kg->ViewValue = FormatNumber($this->price_kg->ViewValue, 2, -2, -2, -2);
			$this->price_kg->ViewCustomAttributes = "";
			$this->price_kg->HrefValue = ""; // Clear href value
			$this->Amount->CurrentValue = $this->Amount->Total;
			$this->Amount->ViewValue = $this->Amount->CurrentValue;
			$this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, 2, -2, -2, -2);
			$this->Amount->ViewCustomAttributes = "";
			$this->Amount->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->main_image->AdvancedSearch->load();
		$this->godown_id->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->product_code->AdvancedSearch->load();
		$this->Balance->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->price_kg->AdvancedSearch->load();
		$this->price_unit->AdvancedSearch->load();
		$this->b_12->AdvancedSearch->load();
		$this->b_01->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->Amount->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fquotationlist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fquotationlist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fquotationlist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_quotation\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_quotation',hdr:ew.language.phrase('ExportToEmailText'),f:document.fquotationlist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_godown_id":
					$lookupFilter = function() {
						return "`id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_01":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_02":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_godown_id":
							break;
						case "x_product":
							break;
						case "x_v_01":
							break;
						case "x_v_02":
							break;
						case "x_v_03":
							break;
						case "x_v_04":
							break;
						case "x_v_05":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'quotation');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>