<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ref_edit extends ref
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ref';

	// Page object name
	public $PageObjName = "ref_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ref)
		if (!isset($GLOBALS["ref"]) || get_class($GLOBALS["ref"]) == PROJECT_NAMESPACE . "ref") {
			$GLOBALS["ref"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ref"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ref;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ref);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "refview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("reflist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->oid->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_type->setVisibility();
		$this->packing_type->setVisibility();
		$this->product_n->setVisibility();
		$this->_barcode->setVisibility();
		$this->product_code_type->setVisibility();
		$this->product_code->setVisibility();
		$this->gcode->Visible = FALSE;
		$this->code->Visible = FALSE;
		$this->product_id->Visible = FALSE;
		$this->print_name->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->set_ref->setVisibility();
		$this->v_00->setVisibility();
		$this->v_01->setVisibility();
		$this->v_02->setVisibility();
		$this->v_03->setVisibility();
		$this->v_04->setVisibility();
		$this->v_05->setVisibility();
		$this->v_06->setVisibility();
		$this->v_07->setVisibility();
		$this->v_08->setVisibility();
		$this->v_09->setVisibility();
		$this->v_10->setVisibility();
		$this->cbm->setVisibility();
		$this->sqm->setVisibility();
		$this->shape->setVisibility();
		$this->q_sku->setVisibility();
		$this->b_01->setVisibility();
		$this->b_02->setVisibility();
		$this->b_03->setVisibility();
		$this->b_04->setVisibility();
		$this->b_05->setVisibility();
		$this->b_06->setVisibility();
		$this->b_07->setVisibility();
		$this->b_08->setVisibility();
		$this->b_09->setVisibility();
		$this->b_10->setVisibility();
		$this->b_11->setVisibility();
		$this->b_12->setVisibility();
		$this->b_13->setVisibility();
		$this->b_14->setVisibility();
		$this->b_15->setVisibility();
		$this->t_01->setVisibility();
		$this->t_02->setVisibility();
		$this->t_03->setVisibility();
		$this->t_04->setVisibility();
		$this->t_05->setVisibility();
		$this->t_06->setVisibility();
		$this->t_07->setVisibility();
		$this->t_08->setVisibility();
		$this->t_09->setVisibility();
		$this->t_10->setVisibility();
		$this->t_11->setVisibility();
		$this->t_12->setVisibility();
		$this->t_13->setVisibility();
		$this->t_14->setVisibility();
		$this->t_15->setVisibility();
		$this->d_head_01->setVisibility();
		$this->d_description_01->setVisibility();
		$this->d_head_02->setVisibility();
		$this->d_description_02->setVisibility();
		$this->main_image->setVisibility();
		$this->top_view->setVisibility();
		$this->front_view->setVisibility();
		$this->corner_view->setVisibility();
		$this->back_view->setVisibility();
		$this->color_options->setVisibility();
		$this->other_options->setVisibility();
		$this->group_image->setVisibility();
		$this->video_url->setVisibility();
		$this->image->setVisibility();
		$this->last_price->setVisibility();
		$this->currency->setVisibility();
		$this->hsn->setVisibility();
		$this->composition->setVisibility();
		$this->category->setVisibility();
		$this->moq->setVisibility();
		$this->in->Visible = FALSE;
		$this->out->Visible = FALSE;
		$this->required->Visible = FALSE;
		$this->blocked->Visible = FALSE;
		$this->ordered->Visible = FALSE;
		$this->status->setVisibility();
		$this->publish->setVisibility();
		$this->keywords->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->supplier->Visible = FALSE;
		$this->country->Visible = FALSE;
		$this->minimum_stock->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->set_ref);
		$this->setupLookupOptions($this->v_01);
		$this->setupLookupOptions($this->v_02);
		$this->setupLookupOptions($this->v_03);
		$this->setupLookupOptions($this->v_04);
		$this->setupLookupOptions($this->v_05);
		$this->setupLookupOptions($this->v_06);
		$this->setupLookupOptions($this->v_07);
		$this->setupLookupOptions($this->v_08);
		$this->setupLookupOptions($this->v_09);
		$this->setupLookupOptions($this->v_10);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->b_03);
		$this->setupLookupOptions($this->b_04);
		$this->setupLookupOptions($this->b_05);
		$this->setupLookupOptions($this->b_06);
		$this->setupLookupOptions($this->b_07);
		$this->setupLookupOptions($this->b_08);
		$this->setupLookupOptions($this->b_09);
		$this->setupLookupOptions($this->b_10);
		$this->setupLookupOptions($this->t_03);
		$this->setupLookupOptions($this->t_04);
		$this->setupLookupOptions($this->t_05);
		$this->setupLookupOptions($this->t_06);
		$this->setupLookupOptions($this->t_07);
		$this->setupLookupOptions($this->t_08);
		$this->setupLookupOptions($this->t_09);
		$this->setupLookupOptions($this->t_10);
		$this->setupLookupOptions($this->t_11);
		$this->setupLookupOptions($this->t_12);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->hsn);
		$this->setupLookupOptions($this->composition);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("reflist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() <> "") // Master/detail edit
					$returnUrl = $this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "reflist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->main_image->Upload->Index = $CurrentForm->Index;
		$this->main_image->Upload->uploadFile();
		$this->main_image->CurrentValue = $this->main_image->Upload->FileName;
		$this->top_view->Upload->Index = $CurrentForm->Index;
		$this->top_view->Upload->uploadFile();
		$this->top_view->CurrentValue = $this->top_view->Upload->FileName;
		$this->front_view->Upload->Index = $CurrentForm->Index;
		$this->front_view->Upload->uploadFile();
		$this->front_view->CurrentValue = $this->front_view->Upload->FileName;
		$this->corner_view->Upload->Index = $CurrentForm->Index;
		$this->corner_view->Upload->uploadFile();
		$this->corner_view->CurrentValue = $this->corner_view->Upload->FileName;
		$this->back_view->Upload->Index = $CurrentForm->Index;
		$this->back_view->Upload->uploadFile();
		$this->back_view->CurrentValue = $this->back_view->Upload->FileName;
		$this->color_options->Upload->Index = $CurrentForm->Index;
		$this->color_options->Upload->uploadFile();
		$this->color_options->CurrentValue = $this->color_options->Upload->FileName;
		$this->other_options->Upload->Index = $CurrentForm->Index;
		$this->other_options->Upload->uploadFile();
		$this->other_options->CurrentValue = $this->other_options->Upload->FileName;
		$this->group_image->Upload->Index = $CurrentForm->Index;
		$this->group_image->Upload->uploadFile();
		$this->group_image->CurrentValue = $this->group_image->Upload->FileName;
		$this->image->Upload->Index = $CurrentForm->Index;
		$this->image->Upload->uploadFile();
		$this->image->CurrentValue = $this->image->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'product_n' first before field var 'x_product_n'
		$val = $CurrentForm->hasValue("product_n") ? $CurrentForm->getValue("product_n") : $CurrentForm->getValue("x_product_n");
		if (!$this->product_n->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_n->Visible = FALSE; // Disable update for API request
			else
				$this->product_n->setFormValue($val);
		}

		// Check field name 'barcode' first before field var 'x__barcode'
		$val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
		if (!$this->_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->_barcode->setFormValue($val);
		}

		// Check field name 'product_code_type' first before field var 'x_product_code_type'
		$val = $CurrentForm->hasValue("product_code_type") ? $CurrentForm->getValue("product_code_type") : $CurrentForm->getValue("x_product_code_type");
		if (!$this->product_code_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_code_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_code_type->setFormValue($val);
		}

		// Check field name 'product_code' first before field var 'x_product_code'
		$val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
		if (!$this->product_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_code->Visible = FALSE; // Disable update for API request
			else
				$this->product_code->setFormValue($val);
		}

		// Check field name 'set_ref' first before field var 'x_set_ref'
		$val = $CurrentForm->hasValue("set_ref") ? $CurrentForm->getValue("set_ref") : $CurrentForm->getValue("x_set_ref");
		if (!$this->set_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->set_ref->Visible = FALSE; // Disable update for API request
			else
				$this->set_ref->setFormValue($val);
		}

		// Check field name 'v_00' first before field var 'x_v_00'
		$val = $CurrentForm->hasValue("v_00") ? $CurrentForm->getValue("v_00") : $CurrentForm->getValue("x_v_00");
		if (!$this->v_00->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_00->Visible = FALSE; // Disable update for API request
			else
				$this->v_00->setFormValue($val);
		}

		// Check field name 'v_01' first before field var 'x_v_01'
		$val = $CurrentForm->hasValue("v_01") ? $CurrentForm->getValue("v_01") : $CurrentForm->getValue("x_v_01");
		if (!$this->v_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_01->Visible = FALSE; // Disable update for API request
			else
				$this->v_01->setFormValue($val);
		}

		// Check field name 'v_02' first before field var 'x_v_02'
		$val = $CurrentForm->hasValue("v_02") ? $CurrentForm->getValue("v_02") : $CurrentForm->getValue("x_v_02");
		if (!$this->v_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_02->Visible = FALSE; // Disable update for API request
			else
				$this->v_02->setFormValue($val);
		}

		// Check field name 'v_03' first before field var 'x_v_03'
		$val = $CurrentForm->hasValue("v_03") ? $CurrentForm->getValue("v_03") : $CurrentForm->getValue("x_v_03");
		if (!$this->v_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_03->Visible = FALSE; // Disable update for API request
			else
				$this->v_03->setFormValue($val);
		}

		// Check field name 'v_04' first before field var 'x_v_04'
		$val = $CurrentForm->hasValue("v_04") ? $CurrentForm->getValue("v_04") : $CurrentForm->getValue("x_v_04");
		if (!$this->v_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_04->Visible = FALSE; // Disable update for API request
			else
				$this->v_04->setFormValue($val);
		}

		// Check field name 'v_05' first before field var 'x_v_05'
		$val = $CurrentForm->hasValue("v_05") ? $CurrentForm->getValue("v_05") : $CurrentForm->getValue("x_v_05");
		if (!$this->v_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_05->Visible = FALSE; // Disable update for API request
			else
				$this->v_05->setFormValue($val);
		}

		// Check field name 'v_06' first before field var 'x_v_06'
		$val = $CurrentForm->hasValue("v_06") ? $CurrentForm->getValue("v_06") : $CurrentForm->getValue("x_v_06");
		if (!$this->v_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_06->Visible = FALSE; // Disable update for API request
			else
				$this->v_06->setFormValue($val);
		}

		// Check field name 'v_07' first before field var 'x_v_07'
		$val = $CurrentForm->hasValue("v_07") ? $CurrentForm->getValue("v_07") : $CurrentForm->getValue("x_v_07");
		if (!$this->v_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_07->Visible = FALSE; // Disable update for API request
			else
				$this->v_07->setFormValue($val);
		}

		// Check field name 'v_08' first before field var 'x_v_08'
		$val = $CurrentForm->hasValue("v_08") ? $CurrentForm->getValue("v_08") : $CurrentForm->getValue("x_v_08");
		if (!$this->v_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_08->Visible = FALSE; // Disable update for API request
			else
				$this->v_08->setFormValue($val);
		}

		// Check field name 'v_09' first before field var 'x_v_09'
		$val = $CurrentForm->hasValue("v_09") ? $CurrentForm->getValue("v_09") : $CurrentForm->getValue("x_v_09");
		if (!$this->v_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_09->Visible = FALSE; // Disable update for API request
			else
				$this->v_09->setFormValue($val);
		}

		// Check field name 'v_10' first before field var 'x_v_10'
		$val = $CurrentForm->hasValue("v_10") ? $CurrentForm->getValue("v_10") : $CurrentForm->getValue("x_v_10");
		if (!$this->v_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->v_10->Visible = FALSE; // Disable update for API request
			else
				$this->v_10->setFormValue($val);
		}

		// Check field name 'cbm' first before field var 'x_cbm'
		$val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
		if (!$this->cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cbm->Visible = FALSE; // Disable update for API request
			else
				$this->cbm->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'shape' first before field var 'x_shape'
		$val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
		if (!$this->shape->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shape->Visible = FALSE; // Disable update for API request
			else
				$this->shape->setFormValue($val);
		}

		// Check field name 'q_sku' first before field var 'x_q_sku'
		$val = $CurrentForm->hasValue("q_sku") ? $CurrentForm->getValue("q_sku") : $CurrentForm->getValue("x_q_sku");
		if (!$this->q_sku->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->q_sku->Visible = FALSE; // Disable update for API request
			else
				$this->q_sku->setFormValue($val);
		}

		// Check field name 'b_01' first before field var 'x_b_01'
		$val = $CurrentForm->hasValue("b_01") ? $CurrentForm->getValue("b_01") : $CurrentForm->getValue("x_b_01");
		if (!$this->b_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_01->Visible = FALSE; // Disable update for API request
			else
				$this->b_01->setFormValue($val);
		}

		// Check field name 'b_02' first before field var 'x_b_02'
		$val = $CurrentForm->hasValue("b_02") ? $CurrentForm->getValue("b_02") : $CurrentForm->getValue("x_b_02");
		if (!$this->b_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_02->Visible = FALSE; // Disable update for API request
			else
				$this->b_02->setFormValue($val);
		}

		// Check field name 'b_03' first before field var 'x_b_03'
		$val = $CurrentForm->hasValue("b_03") ? $CurrentForm->getValue("b_03") : $CurrentForm->getValue("x_b_03");
		if (!$this->b_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_03->Visible = FALSE; // Disable update for API request
			else
				$this->b_03->setFormValue($val);
		}

		// Check field name 'b_04' first before field var 'x_b_04'
		$val = $CurrentForm->hasValue("b_04") ? $CurrentForm->getValue("b_04") : $CurrentForm->getValue("x_b_04");
		if (!$this->b_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_04->Visible = FALSE; // Disable update for API request
			else
				$this->b_04->setFormValue($val);
		}

		// Check field name 'b_05' first before field var 'x_b_05'
		$val = $CurrentForm->hasValue("b_05") ? $CurrentForm->getValue("b_05") : $CurrentForm->getValue("x_b_05");
		if (!$this->b_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_05->Visible = FALSE; // Disable update for API request
			else
				$this->b_05->setFormValue($val);
		}

		// Check field name 'b_06' first before field var 'x_b_06'
		$val = $CurrentForm->hasValue("b_06") ? $CurrentForm->getValue("b_06") : $CurrentForm->getValue("x_b_06");
		if (!$this->b_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_06->Visible = FALSE; // Disable update for API request
			else
				$this->b_06->setFormValue($val);
		}

		// Check field name 'b_07' first before field var 'x_b_07'
		$val = $CurrentForm->hasValue("b_07") ? $CurrentForm->getValue("b_07") : $CurrentForm->getValue("x_b_07");
		if (!$this->b_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_07->Visible = FALSE; // Disable update for API request
			else
				$this->b_07->setFormValue($val);
		}

		// Check field name 'b_08' first before field var 'x_b_08'
		$val = $CurrentForm->hasValue("b_08") ? $CurrentForm->getValue("b_08") : $CurrentForm->getValue("x_b_08");
		if (!$this->b_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_08->Visible = FALSE; // Disable update for API request
			else
				$this->b_08->setFormValue($val);
		}

		// Check field name 'b_09' first before field var 'x_b_09'
		$val = $CurrentForm->hasValue("b_09") ? $CurrentForm->getValue("b_09") : $CurrentForm->getValue("x_b_09");
		if (!$this->b_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_09->Visible = FALSE; // Disable update for API request
			else
				$this->b_09->setFormValue($val);
		}

		// Check field name 'b_10' first before field var 'x_b_10'
		$val = $CurrentForm->hasValue("b_10") ? $CurrentForm->getValue("b_10") : $CurrentForm->getValue("x_b_10");
		if (!$this->b_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_10->Visible = FALSE; // Disable update for API request
			else
				$this->b_10->setFormValue($val);
		}

		// Check field name 'b_11' first before field var 'x_b_11'
		$val = $CurrentForm->hasValue("b_11") ? $CurrentForm->getValue("b_11") : $CurrentForm->getValue("x_b_11");
		if (!$this->b_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_11->Visible = FALSE; // Disable update for API request
			else
				$this->b_11->setFormValue($val);
		}

		// Check field name 'b_12' first before field var 'x_b_12'
		$val = $CurrentForm->hasValue("b_12") ? $CurrentForm->getValue("b_12") : $CurrentForm->getValue("x_b_12");
		if (!$this->b_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_12->Visible = FALSE; // Disable update for API request
			else
				$this->b_12->setFormValue($val);
		}

		// Check field name 'b_13' first before field var 'x_b_13'
		$val = $CurrentForm->hasValue("b_13") ? $CurrentForm->getValue("b_13") : $CurrentForm->getValue("x_b_13");
		if (!$this->b_13->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_13->Visible = FALSE; // Disable update for API request
			else
				$this->b_13->setFormValue($val);
		}

		// Check field name 'b_14' first before field var 'x_b_14'
		$val = $CurrentForm->hasValue("b_14") ? $CurrentForm->getValue("b_14") : $CurrentForm->getValue("x_b_14");
		if (!$this->b_14->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_14->Visible = FALSE; // Disable update for API request
			else
				$this->b_14->setFormValue($val);
		}

		// Check field name 'b_15' first before field var 'x_b_15'
		$val = $CurrentForm->hasValue("b_15") ? $CurrentForm->getValue("b_15") : $CurrentForm->getValue("x_b_15");
		if (!$this->b_15->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_15->Visible = FALSE; // Disable update for API request
			else
				$this->b_15->setFormValue($val);
		}

		// Check field name 't_01' first before field var 'x_t_01'
		$val = $CurrentForm->hasValue("t_01") ? $CurrentForm->getValue("t_01") : $CurrentForm->getValue("x_t_01");
		if (!$this->t_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_01->Visible = FALSE; // Disable update for API request
			else
				$this->t_01->setFormValue($val);
		}

		// Check field name 't_02' first before field var 'x_t_02'
		$val = $CurrentForm->hasValue("t_02") ? $CurrentForm->getValue("t_02") : $CurrentForm->getValue("x_t_02");
		if (!$this->t_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_02->Visible = FALSE; // Disable update for API request
			else
				$this->t_02->setFormValue($val);
		}

		// Check field name 't_03' first before field var 'x_t_03'
		$val = $CurrentForm->hasValue("t_03") ? $CurrentForm->getValue("t_03") : $CurrentForm->getValue("x_t_03");
		if (!$this->t_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_03->Visible = FALSE; // Disable update for API request
			else
				$this->t_03->setFormValue($val);
		}

		// Check field name 't_04' first before field var 'x_t_04'
		$val = $CurrentForm->hasValue("t_04") ? $CurrentForm->getValue("t_04") : $CurrentForm->getValue("x_t_04");
		if (!$this->t_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_04->Visible = FALSE; // Disable update for API request
			else
				$this->t_04->setFormValue($val);
		}

		// Check field name 't_05' first before field var 'x_t_05'
		$val = $CurrentForm->hasValue("t_05") ? $CurrentForm->getValue("t_05") : $CurrentForm->getValue("x_t_05");
		if (!$this->t_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_05->Visible = FALSE; // Disable update for API request
			else
				$this->t_05->setFormValue($val);
		}

		// Check field name 't_06' first before field var 'x_t_06'
		$val = $CurrentForm->hasValue("t_06") ? $CurrentForm->getValue("t_06") : $CurrentForm->getValue("x_t_06");
		if (!$this->t_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_06->Visible = FALSE; // Disable update for API request
			else
				$this->t_06->setFormValue($val);
		}

		// Check field name 't_07' first before field var 'x_t_07'
		$val = $CurrentForm->hasValue("t_07") ? $CurrentForm->getValue("t_07") : $CurrentForm->getValue("x_t_07");
		if (!$this->t_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_07->Visible = FALSE; // Disable update for API request
			else
				$this->t_07->setFormValue($val);
		}

		// Check field name 't_08' first before field var 'x_t_08'
		$val = $CurrentForm->hasValue("t_08") ? $CurrentForm->getValue("t_08") : $CurrentForm->getValue("x_t_08");
		if (!$this->t_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_08->Visible = FALSE; // Disable update for API request
			else
				$this->t_08->setFormValue($val);
		}

		// Check field name 't_09' first before field var 'x_t_09'
		$val = $CurrentForm->hasValue("t_09") ? $CurrentForm->getValue("t_09") : $CurrentForm->getValue("x_t_09");
		if (!$this->t_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_09->Visible = FALSE; // Disable update for API request
			else
				$this->t_09->setFormValue($val);
		}

		// Check field name 't_10' first before field var 'x_t_10'
		$val = $CurrentForm->hasValue("t_10") ? $CurrentForm->getValue("t_10") : $CurrentForm->getValue("x_t_10");
		if (!$this->t_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_10->Visible = FALSE; // Disable update for API request
			else
				$this->t_10->setFormValue($val);
		}

		// Check field name 't_11' first before field var 'x_t_11'
		$val = $CurrentForm->hasValue("t_11") ? $CurrentForm->getValue("t_11") : $CurrentForm->getValue("x_t_11");
		if (!$this->t_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_11->Visible = FALSE; // Disable update for API request
			else
				$this->t_11->setFormValue($val);
		}

		// Check field name 't_12' first before field var 'x_t_12'
		$val = $CurrentForm->hasValue("t_12") ? $CurrentForm->getValue("t_12") : $CurrentForm->getValue("x_t_12");
		if (!$this->t_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_12->Visible = FALSE; // Disable update for API request
			else
				$this->t_12->setFormValue($val);
		}

		// Check field name 't_13' first before field var 'x_t_13'
		$val = $CurrentForm->hasValue("t_13") ? $CurrentForm->getValue("t_13") : $CurrentForm->getValue("x_t_13");
		if (!$this->t_13->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_13->Visible = FALSE; // Disable update for API request
			else
				$this->t_13->setFormValue($val);
		}

		// Check field name 't_14' first before field var 'x_t_14'
		$val = $CurrentForm->hasValue("t_14") ? $CurrentForm->getValue("t_14") : $CurrentForm->getValue("x_t_14");
		if (!$this->t_14->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_14->Visible = FALSE; // Disable update for API request
			else
				$this->t_14->setFormValue($val);
		}

		// Check field name 't_15' first before field var 'x_t_15'
		$val = $CurrentForm->hasValue("t_15") ? $CurrentForm->getValue("t_15") : $CurrentForm->getValue("x_t_15");
		if (!$this->t_15->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_15->Visible = FALSE; // Disable update for API request
			else
				$this->t_15->setFormValue($val);
		}

		// Check field name 'd_head_01' first before field var 'x_d_head_01'
		$val = $CurrentForm->hasValue("d_head_01") ? $CurrentForm->getValue("d_head_01") : $CurrentForm->getValue("x_d_head_01");
		if (!$this->d_head_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_head_01->Visible = FALSE; // Disable update for API request
			else
				$this->d_head_01->setFormValue($val);
		}

		// Check field name 'd_description_01' first before field var 'x_d_description_01'
		$val = $CurrentForm->hasValue("d_description_01") ? $CurrentForm->getValue("d_description_01") : $CurrentForm->getValue("x_d_description_01");
		if (!$this->d_description_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_description_01->Visible = FALSE; // Disable update for API request
			else
				$this->d_description_01->setFormValue($val);
		}

		// Check field name 'd_head_02' first before field var 'x_d_head_02'
		$val = $CurrentForm->hasValue("d_head_02") ? $CurrentForm->getValue("d_head_02") : $CurrentForm->getValue("x_d_head_02");
		if (!$this->d_head_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_head_02->Visible = FALSE; // Disable update for API request
			else
				$this->d_head_02->setFormValue($val);
		}

		// Check field name 'd_description_02' first before field var 'x_d_description_02'
		$val = $CurrentForm->hasValue("d_description_02") ? $CurrentForm->getValue("d_description_02") : $CurrentForm->getValue("x_d_description_02");
		if (!$this->d_description_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_description_02->Visible = FALSE; // Disable update for API request
			else
				$this->d_description_02->setFormValue($val);
		}

		// Check field name 'video_url' first before field var 'x_video_url'
		$val = $CurrentForm->hasValue("video_url") ? $CurrentForm->getValue("video_url") : $CurrentForm->getValue("x_video_url");
		if (!$this->video_url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->video_url->Visible = FALSE; // Disable update for API request
			else
				$this->video_url->setFormValue($val);
		}

		// Check field name 'last_price' first before field var 'x_last_price'
		$val = $CurrentForm->hasValue("last_price") ? $CurrentForm->getValue("last_price") : $CurrentForm->getValue("x_last_price");
		if (!$this->last_price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->last_price->Visible = FALSE; // Disable update for API request
			else
				$this->last_price->setFormValue($val);
		}

		// Check field name 'currency' first before field var 'x_currency'
		$val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
		if (!$this->currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency->Visible = FALSE; // Disable update for API request
			else
				$this->currency->setFormValue($val);
		}

		// Check field name 'hsn' first before field var 'x_hsn'
		$val = $CurrentForm->hasValue("hsn") ? $CurrentForm->getValue("hsn") : $CurrentForm->getValue("x_hsn");
		if (!$this->hsn->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->hsn->Visible = FALSE; // Disable update for API request
			else
				$this->hsn->setFormValue($val);
		}

		// Check field name 'composition' first before field var 'x_composition'
		$val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
		if (!$this->composition->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->composition->Visible = FALSE; // Disable update for API request
			else
				$this->composition->setFormValue($val);
		}

		// Check field name 'category' first before field var 'x_category'
		$val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
		if (!$this->category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->category->Visible = FALSE; // Disable update for API request
			else
				$this->category->setFormValue($val);
		}

		// Check field name 'moq' first before field var 'x_moq'
		$val = $CurrentForm->hasValue("moq") ? $CurrentForm->getValue("moq") : $CurrentForm->getValue("x_moq");
		if (!$this->moq->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->moq->Visible = FALSE; // Disable update for API request
			else
				$this->moq->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'publish' first before field var 'x_publish'
		$val = $CurrentForm->hasValue("publish") ? $CurrentForm->getValue("publish") : $CurrentForm->getValue("x_publish");
		if (!$this->publish->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->publish->Visible = FALSE; // Disable update for API request
			else
				$this->publish->setFormValue($val);
		}

		// Check field name 'keywords' first before field var 'x_keywords'
		$val = $CurrentForm->hasValue("keywords") ? $CurrentForm->getValue("keywords") : $CurrentForm->getValue("x_keywords");
		if (!$this->keywords->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->keywords->Visible = FALSE; // Disable update for API request
			else
				$this->keywords->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->product_n->CurrentValue = $this->product_n->FormValue;
		$this->_barcode->CurrentValue = $this->_barcode->FormValue;
		$this->product_code_type->CurrentValue = $this->product_code_type->FormValue;
		$this->product_code->CurrentValue = $this->product_code->FormValue;
		$this->set_ref->CurrentValue = $this->set_ref->FormValue;
		$this->v_00->CurrentValue = $this->v_00->FormValue;
		$this->v_01->CurrentValue = $this->v_01->FormValue;
		$this->v_02->CurrentValue = $this->v_02->FormValue;
		$this->v_03->CurrentValue = $this->v_03->FormValue;
		$this->v_04->CurrentValue = $this->v_04->FormValue;
		$this->v_05->CurrentValue = $this->v_05->FormValue;
		$this->v_06->CurrentValue = $this->v_06->FormValue;
		$this->v_07->CurrentValue = $this->v_07->FormValue;
		$this->v_08->CurrentValue = $this->v_08->FormValue;
		$this->v_09->CurrentValue = $this->v_09->FormValue;
		$this->v_10->CurrentValue = $this->v_10->FormValue;
		$this->cbm->CurrentValue = $this->cbm->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->shape->CurrentValue = $this->shape->FormValue;
		$this->q_sku->CurrentValue = $this->q_sku->FormValue;
		$this->b_01->CurrentValue = $this->b_01->FormValue;
		$this->b_02->CurrentValue = $this->b_02->FormValue;
		$this->b_03->CurrentValue = $this->b_03->FormValue;
		$this->b_04->CurrentValue = $this->b_04->FormValue;
		$this->b_05->CurrentValue = $this->b_05->FormValue;
		$this->b_06->CurrentValue = $this->b_06->FormValue;
		$this->b_07->CurrentValue = $this->b_07->FormValue;
		$this->b_08->CurrentValue = $this->b_08->FormValue;
		$this->b_09->CurrentValue = $this->b_09->FormValue;
		$this->b_10->CurrentValue = $this->b_10->FormValue;
		$this->b_11->CurrentValue = $this->b_11->FormValue;
		$this->b_12->CurrentValue = $this->b_12->FormValue;
		$this->b_13->CurrentValue = $this->b_13->FormValue;
		$this->b_14->CurrentValue = $this->b_14->FormValue;
		$this->b_15->CurrentValue = $this->b_15->FormValue;
		$this->t_01->CurrentValue = $this->t_01->FormValue;
		$this->t_02->CurrentValue = $this->t_02->FormValue;
		$this->t_03->CurrentValue = $this->t_03->FormValue;
		$this->t_04->CurrentValue = $this->t_04->FormValue;
		$this->t_05->CurrentValue = $this->t_05->FormValue;
		$this->t_06->CurrentValue = $this->t_06->FormValue;
		$this->t_07->CurrentValue = $this->t_07->FormValue;
		$this->t_08->CurrentValue = $this->t_08->FormValue;
		$this->t_09->CurrentValue = $this->t_09->FormValue;
		$this->t_10->CurrentValue = $this->t_10->FormValue;
		$this->t_11->CurrentValue = $this->t_11->FormValue;
		$this->t_12->CurrentValue = $this->t_12->FormValue;
		$this->t_13->CurrentValue = $this->t_13->FormValue;
		$this->t_14->CurrentValue = $this->t_14->FormValue;
		$this->t_15->CurrentValue = $this->t_15->FormValue;
		$this->d_head_01->CurrentValue = $this->d_head_01->FormValue;
		$this->d_description_01->CurrentValue = $this->d_description_01->FormValue;
		$this->d_head_02->CurrentValue = $this->d_head_02->FormValue;
		$this->d_description_02->CurrentValue = $this->d_description_02->FormValue;
		$this->video_url->CurrentValue = $this->video_url->FormValue;
		$this->last_price->CurrentValue = $this->last_price->FormValue;
		$this->currency->CurrentValue = $this->currency->FormValue;
		$this->hsn->CurrentValue = $this->hsn->FormValue;
		$this->composition->CurrentValue = $this->composition->FormValue;
		$this->category->CurrentValue = $this->category->FormValue;
		$this->moq->CurrentValue = $this->moq->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->publish->CurrentValue = $this->publish->FormValue;
		$this->keywords->CurrentValue = $this->keywords->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->oid->setDbValue($row['oid']);
		$this->company_id->setDbValue($row['company_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_type->setDbValue($row['product_type']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->product_n->setDbValue($row['product_n']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->product_code_type->setDbValue($row['product_code_type']);
		$this->product_code->setDbValue($row['product_code']);
		$this->gcode->setDbValue($row['gcode']);
		$this->code->setDbValue($row['code']);
		$this->product_id->setDbValue($row['product_id']);
		$this->print_name->setDbValue($row['print_name']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->set_ref->setDbValue($row['set_ref']);
		$this->v_00->setDbValue($row['v_00']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_10->setDbValue($row['v_10']);
		$this->cbm->setDbValue($row['cbm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->shape->setDbValue($row['shape']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->b_01->setDbValue($row['b_01']);
		$this->b_02->setDbValue($row['b_02']);
		$this->b_03->setDbValue($row['b_03']);
		$this->b_04->setDbValue($row['b_04']);
		$this->b_05->setDbValue($row['b_05']);
		$this->b_06->setDbValue($row['b_06']);
		$this->b_07->setDbValue($row['b_07']);
		$this->b_08->setDbValue($row['b_08']);
		$this->b_09->setDbValue($row['b_09']);
		$this->b_10->setDbValue($row['b_10']);
		$this->b_11->setDbValue($row['b_11']);
		$this->b_12->setDbValue($row['b_12']);
		$this->b_13->setDbValue($row['b_13']);
		$this->b_14->setDbValue($row['b_14']);
		$this->b_15->setDbValue($row['b_15']);
		$this->t_01->setDbValue($row['t_01']);
		$this->t_02->setDbValue($row['t_02']);
		$this->t_03->setDbValue($row['t_03']);
		$this->t_04->setDbValue($row['t_04']);
		$this->t_05->setDbValue($row['t_05']);
		$this->t_06->setDbValue($row['t_06']);
		$this->t_07->setDbValue($row['t_07']);
		$this->t_08->setDbValue($row['t_08']);
		$this->t_09->setDbValue($row['t_09']);
		$this->t_10->setDbValue($row['t_10']);
		$this->t_11->setDbValue($row['t_11']);
		$this->t_12->setDbValue($row['t_12']);
		$this->t_13->setDbValue($row['t_13']);
		$this->t_14->setDbValue($row['t_14']);
		$this->t_15->setDbValue($row['t_15']);
		$this->d_head_01->setDbValue($row['d_head_01']);
		$this->d_description_01->setDbValue($row['d_description_01']);
		$this->d_head_02->setDbValue($row['d_head_02']);
		$this->d_description_02->setDbValue($row['d_description_02']);
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->main_image->setDbValue($this->main_image->Upload->DbValue);
		$this->top_view->Upload->DbValue = $row['top_view'];
		$this->top_view->setDbValue($this->top_view->Upload->DbValue);
		$this->front_view->Upload->DbValue = $row['front_view'];
		$this->front_view->setDbValue($this->front_view->Upload->DbValue);
		$this->corner_view->Upload->DbValue = $row['corner_view'];
		$this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
		$this->back_view->Upload->DbValue = $row['back_view'];
		$this->back_view->setDbValue($this->back_view->Upload->DbValue);
		$this->color_options->Upload->DbValue = $row['color_options'];
		$this->color_options->setDbValue($this->color_options->Upload->DbValue);
		$this->other_options->Upload->DbValue = $row['other_options'];
		$this->other_options->setDbValue($this->other_options->Upload->DbValue);
		$this->group_image->Upload->DbValue = $row['group_image'];
		$this->group_image->setDbValue($this->group_image->Upload->DbValue);
		$this->video_url->setDbValue($row['video_url']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->last_price->setDbValue($row['last_price']);
		$this->currency->setDbValue($row['currency']);
		$this->hsn->setDbValue($row['hsn']);
		$this->composition->setDbValue($row['composition']);
		$this->category->setDbValue($row['category']);
		$this->moq->setDbValue($row['moq']);
		$this->in->setDbValue($row['in']);
		$this->out->setDbValue($row['out']);
		$this->required->setDbValue($row['required']);
		$this->blocked->setDbValue($row['blocked']);
		$this->ordered->setDbValue($row['ordered']);
		$this->status->setDbValue($row['status']);
		$this->publish->setDbValue($row['publish']);
		$this->keywords->setDbValue($row['keywords']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->supplier->setDbValue($row['supplier']);
		$this->country->setDbValue($row['country']);
		$this->minimum_stock->setDbValue($row['minimum_stock']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['oid'] = NULL;
		$row['company_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_type'] = NULL;
		$row['packing_type'] = NULL;
		$row['product_n'] = NULL;
		$row['barcode'] = NULL;
		$row['product_code_type'] = NULL;
		$row['product_code'] = NULL;
		$row['gcode'] = NULL;
		$row['code'] = NULL;
		$row['product_id'] = NULL;
		$row['print_name'] = NULL;
		$row['batch_no'] = NULL;
		$row['set_ref'] = NULL;
		$row['v_00'] = NULL;
		$row['v_01'] = NULL;
		$row['v_02'] = NULL;
		$row['v_03'] = NULL;
		$row['v_04'] = NULL;
		$row['v_05'] = NULL;
		$row['v_06'] = NULL;
		$row['v_07'] = NULL;
		$row['v_08'] = NULL;
		$row['v_09'] = NULL;
		$row['v_10'] = NULL;
		$row['cbm'] = NULL;
		$row['sqm'] = NULL;
		$row['shape'] = NULL;
		$row['q_sku'] = NULL;
		$row['b_01'] = NULL;
		$row['b_02'] = NULL;
		$row['b_03'] = NULL;
		$row['b_04'] = NULL;
		$row['b_05'] = NULL;
		$row['b_06'] = NULL;
		$row['b_07'] = NULL;
		$row['b_08'] = NULL;
		$row['b_09'] = NULL;
		$row['b_10'] = NULL;
		$row['b_11'] = NULL;
		$row['b_12'] = NULL;
		$row['b_13'] = NULL;
		$row['b_14'] = NULL;
		$row['b_15'] = NULL;
		$row['t_01'] = NULL;
		$row['t_02'] = NULL;
		$row['t_03'] = NULL;
		$row['t_04'] = NULL;
		$row['t_05'] = NULL;
		$row['t_06'] = NULL;
		$row['t_07'] = NULL;
		$row['t_08'] = NULL;
		$row['t_09'] = NULL;
		$row['t_10'] = NULL;
		$row['t_11'] = NULL;
		$row['t_12'] = NULL;
		$row['t_13'] = NULL;
		$row['t_14'] = NULL;
		$row['t_15'] = NULL;
		$row['d_head_01'] = NULL;
		$row['d_description_01'] = NULL;
		$row['d_head_02'] = NULL;
		$row['d_description_02'] = NULL;
		$row['main_image'] = NULL;
		$row['top_view'] = NULL;
		$row['front_view'] = NULL;
		$row['corner_view'] = NULL;
		$row['back_view'] = NULL;
		$row['color_options'] = NULL;
		$row['other_options'] = NULL;
		$row['group_image'] = NULL;
		$row['video_url'] = NULL;
		$row['image'] = NULL;
		$row['last_price'] = NULL;
		$row['currency'] = NULL;
		$row['hsn'] = NULL;
		$row['composition'] = NULL;
		$row['category'] = NULL;
		$row['moq'] = NULL;
		$row['in'] = NULL;
		$row['out'] = NULL;
		$row['required'] = NULL;
		$row['blocked'] = NULL;
		$row['ordered'] = NULL;
		$row['status'] = NULL;
		$row['publish'] = NULL;
		$row['keywords'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['supplier'] = NULL;
		$row['country'] = NULL;
		$row['minimum_stock'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->q_sku->FormValue == $this->q_sku->CurrentValue && is_numeric(ConvertToFloatString($this->q_sku->CurrentValue)))
			$this->q_sku->CurrentValue = ConvertToFloatString($this->q_sku->CurrentValue);

		// Convert decimal values if posted back
		if ($this->moq->FormValue == $this->moq->CurrentValue && is_numeric(ConvertToFloatString($this->moq->CurrentValue)))
			$this->moq->CurrentValue = ConvertToFloatString($this->moq->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// oid
		// company_id
		// grp
		// s_grp
		// product
		// product_type
		// packing_type
		// product_n
		// barcode
		// product_code_type
		// product_code
		// gcode
		// code
		// product_id
		// print_name
		// batch_no
		// set_ref
		// v_00
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// v_06
		// v_07
		// v_08
		// v_09
		// v_10
		// cbm
		// sqm
		// shape
		// q_sku
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// group_image
		// video_url
		// image
		// last_price
		// currency
		// hsn
		// composition
		// category
		// moq
		// in
		// out
		// required
		// blocked
		// ordered
		// status
		// publish
		// keywords
		// operator
		// datetime
		// supplier
		// country
		// minimum_stock

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` >= 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` >= 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->company_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// product_n
			$this->product_n->ViewValue = $this->product_n->CurrentValue;
			$this->product_n->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// product_code_type
			if (strval($this->product_code_type->CurrentValue) <> "") {
				$this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
			} else {
				$this->product_code_type->ViewValue = NULL;
			}
			$this->product_code_type->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			if ($this->product_code->ViewValue != NULL) $this->product_code->ViewValue = str_replace("\n", "<br>", $this->product_code->ViewValue);
			$this->product_code->ViewCustomAttributes = "";

			// set_ref
			$curVal = strval($this->set_ref->CurrentValue);
			if ($curVal <> "") {
				$this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
				if ($this->set_ref->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->set_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->set_ref->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->set_ref->ViewValue = $this->set_ref->CurrentValue;
					}
				}
			} else {
				$this->set_ref->ViewValue = NULL;
			}
			$this->set_ref->ViewCustomAttributes = "";

			// v_00
			$this->v_00->ViewValue = $this->v_00->CurrentValue;
			$this->v_00->ViewCustomAttributes = "";

			// v_01
			$curVal = strval($this->v_01->CurrentValue);
			if ($curVal <> "") {
				$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
				if ($this->v_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_01->ViewValue = $this->v_01->CurrentValue;
					}
				}
			} else {
				$this->v_01->ViewValue = NULL;
			}
			$this->v_01->ViewCustomAttributes = "";

			// v_02
			$curVal = strval($this->v_02->CurrentValue);
			if ($curVal <> "") {
				$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
				if ($this->v_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_02->ViewValue = $this->v_02->CurrentValue;
					}
				}
			} else {
				$this->v_02->ViewValue = NULL;
			}
			$this->v_02->ViewCustomAttributes = "";

			// v_03
			$curVal = strval($this->v_03->CurrentValue);
			if ($curVal <> "") {
				$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
				if ($this->v_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_03->ViewValue = $this->v_03->CurrentValue;
					}
				}
			} else {
				$this->v_03->ViewValue = NULL;
			}
			$this->v_03->ViewCustomAttributes = "";

			// v_04
			$curVal = strval($this->v_04->CurrentValue);
			if ($curVal <> "") {
				$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
				if ($this->v_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_04->ViewValue = $this->v_04->CurrentValue;
					}
				}
			} else {
				$this->v_04->ViewValue = NULL;
			}
			$this->v_04->ViewCustomAttributes = "";

			// v_05
			$curVal = strval($this->v_05->CurrentValue);
			if ($curVal <> "") {
				$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
				if ($this->v_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_05->ViewValue = $this->v_05->CurrentValue;
					}
				}
			} else {
				$this->v_05->ViewValue = NULL;
			}
			$this->v_05->ViewCustomAttributes = "";

			// v_06
			$curVal = strval($this->v_06->CurrentValue);
			if ($curVal <> "") {
				$this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
				if ($this->v_06->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_06->ViewValue = $this->v_06->CurrentValue;
					}
				}
			} else {
				$this->v_06->ViewValue = NULL;
			}
			$this->v_06->ViewCustomAttributes = "";

			// v_07
			$curVal = strval($this->v_07->CurrentValue);
			if ($curVal <> "") {
				$this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
				if ($this->v_07->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_07->ViewValue = $this->v_07->CurrentValue;
					}
				}
			} else {
				$this->v_07->ViewValue = NULL;
			}
			$this->v_07->ViewCustomAttributes = "";

			// v_08
			$curVal = strval($this->v_08->CurrentValue);
			if ($curVal <> "") {
				$this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
				if ($this->v_08->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_08->ViewValue = $this->v_08->CurrentValue;
					}
				}
			} else {
				$this->v_08->ViewValue = NULL;
			}
			$this->v_08->ViewCustomAttributes = "";

			// v_09
			$curVal = strval($this->v_09->CurrentValue);
			if ($curVal <> "") {
				$this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
				if ($this->v_09->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_09->ViewValue = $this->v_09->CurrentValue;
					}
				}
			} else {
				$this->v_09->ViewValue = NULL;
			}
			$this->v_09->ViewCustomAttributes = "";

			// v_10
			$curVal = strval($this->v_10->CurrentValue);
			if ($curVal <> "") {
				$this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
				if ($this->v_10->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`code`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->v_10->ViewValue = $this->v_10->CurrentValue;
					}
				}
			} else {
				$this->v_10->ViewValue = NULL;
			}
			$this->v_10->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, 2, -2, -2, -2);
			$this->q_sku->ViewCustomAttributes = "";

			// b_01
			$this->b_01->ViewValue = $this->b_01->CurrentValue;
			$this->b_01->ViewCustomAttributes = "";

			// b_02
			$this->b_02->ViewValue = $this->b_02->CurrentValue;
			$this->b_02->ViewCustomAttributes = "";

			// b_03
			$curVal = strval($this->b_03->CurrentValue);
			if ($curVal <> "") {
				$this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
				if ($this->b_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_03->ViewValue = $this->b_03->CurrentValue;
					}
				}
			} else {
				$this->b_03->ViewValue = NULL;
			}
			$this->b_03->ViewCustomAttributes = "";

			// b_04
			$curVal = strval($this->b_04->CurrentValue);
			if ($curVal <> "") {
				$this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
				if ($this->b_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_04->ViewValue = $this->b_04->CurrentValue;
					}
				}
			} else {
				$this->b_04->ViewValue = NULL;
			}
			$this->b_04->ViewCustomAttributes = "";

			// b_05
			$curVal = strval($this->b_05->CurrentValue);
			if ($curVal <> "") {
				$this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
				if ($this->b_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_05->ViewValue = $this->b_05->CurrentValue;
					}
				}
			} else {
				$this->b_05->ViewValue = NULL;
			}
			$this->b_05->ViewCustomAttributes = "";

			// b_06
			$curVal = strval($this->b_06->CurrentValue);
			if ($curVal <> "") {
				$this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
				if ($this->b_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_06->ViewValue = $this->b_06->CurrentValue;
					}
				}
			} else {
				$this->b_06->ViewValue = NULL;
			}
			$this->b_06->ViewCustomAttributes = "";

			// b_07
			$curVal = strval($this->b_07->CurrentValue);
			if ($curVal <> "") {
				$this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
				if ($this->b_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_07->ViewValue = $this->b_07->CurrentValue;
					}
				}
			} else {
				$this->b_07->ViewValue = NULL;
			}
			$this->b_07->ViewCustomAttributes = "";

			// b_08
			$curVal = strval($this->b_08->CurrentValue);
			if ($curVal <> "") {
				$this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
				if ($this->b_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_08->ViewValue = $this->b_08->CurrentValue;
					}
				}
			} else {
				$this->b_08->ViewValue = NULL;
			}
			$this->b_08->ViewCustomAttributes = "";

			// b_09
			$curVal = strval($this->b_09->CurrentValue);
			if ($curVal <> "") {
				$this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
				if ($this->b_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_09->ViewValue = $this->b_09->CurrentValue;
					}
				}
			} else {
				$this->b_09->ViewValue = NULL;
			}
			$this->b_09->ViewCustomAttributes = "";

			// b_10
			$curVal = strval($this->b_10->CurrentValue);
			if ($curVal <> "") {
				$this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
				if ($this->b_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_10->ViewValue = $this->b_10->CurrentValue;
					}
				}
			} else {
				$this->b_10->ViewValue = NULL;
			}
			$this->b_10->ViewCustomAttributes = "";

			// b_11
			$this->b_11->ViewValue = $this->b_11->CurrentValue;
			$this->b_11->ViewCustomAttributes = "";

			// b_12
			$this->b_12->ViewValue = $this->b_12->CurrentValue;
			$this->b_12->ViewCustomAttributes = "";

			// b_13
			$this->b_13->ViewValue = $this->b_13->CurrentValue;
			$this->b_13->ViewCustomAttributes = "";

			// b_14
			$this->b_14->ViewValue = $this->b_14->CurrentValue;
			$this->b_14->ViewCustomAttributes = "";

			// b_15
			$this->b_15->ViewValue = $this->b_15->CurrentValue;
			$this->b_15->ViewCustomAttributes = "";

			// t_01
			$this->t_01->ViewValue = $this->t_01->CurrentValue;
			$this->t_01->ViewCustomAttributes = "";

			// t_02
			$this->t_02->ViewValue = $this->t_02->CurrentValue;
			$this->t_02->ViewCustomAttributes = "";

			// t_03
			$curVal = strval($this->t_03->CurrentValue);
			if ($curVal <> "") {
				$this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
				if ($this->t_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_03->ViewValue = $this->t_03->CurrentValue;
					}
				}
			} else {
				$this->t_03->ViewValue = NULL;
			}
			$this->t_03->ViewCustomAttributes = "";

			// t_04
			$curVal = strval($this->t_04->CurrentValue);
			if ($curVal <> "") {
				$this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
				if ($this->t_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_04->ViewValue = $this->t_04->CurrentValue;
					}
				}
			} else {
				$this->t_04->ViewValue = NULL;
			}
			$this->t_04->ViewCustomAttributes = "";

			// t_05
			$curVal = strval($this->t_05->CurrentValue);
			if ($curVal <> "") {
				$this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
				if ($this->t_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_05->ViewValue = $this->t_05->CurrentValue;
					}
				}
			} else {
				$this->t_05->ViewValue = NULL;
			}
			$this->t_05->ViewCustomAttributes = "";

			// t_06
			$curVal = strval($this->t_06->CurrentValue);
			if ($curVal <> "") {
				$this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
				if ($this->t_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_06->ViewValue = $this->t_06->CurrentValue;
					}
				}
			} else {
				$this->t_06->ViewValue = NULL;
			}
			$this->t_06->ViewCustomAttributes = "";

			// t_07
			$curVal = strval($this->t_07->CurrentValue);
			if ($curVal <> "") {
				$this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
				if ($this->t_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_07->ViewValue = $this->t_07->CurrentValue;
					}
				}
			} else {
				$this->t_07->ViewValue = NULL;
			}
			$this->t_07->ViewCustomAttributes = "";

			// t_08
			$curVal = strval($this->t_08->CurrentValue);
			if ($curVal <> "") {
				$this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
				if ($this->t_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_08->ViewValue = $this->t_08->CurrentValue;
					}
				}
			} else {
				$this->t_08->ViewValue = NULL;
			}
			$this->t_08->ViewCustomAttributes = "";

			// t_09
			$curVal = strval($this->t_09->CurrentValue);
			if ($curVal <> "") {
				$this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
				if ($this->t_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_09->ViewValue = $this->t_09->CurrentValue;
					}
				}
			} else {
				$this->t_09->ViewValue = NULL;
			}
			$this->t_09->ViewCustomAttributes = "";

			// t_10
			$curVal = strval($this->t_10->CurrentValue);
			if ($curVal <> "") {
				$this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
				if ($this->t_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_10->ViewValue = $this->t_10->CurrentValue;
					}
				}
			} else {
				$this->t_10->ViewValue = NULL;
			}
			$this->t_10->ViewCustomAttributes = "";

			// t_11
			$this->t_11->ViewValue = $this->t_11->CurrentValue;
			$curVal = strval($this->t_11->CurrentValue);
			if ($curVal <> "") {
				$this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
				if ($this->t_11->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_11->ViewValue = $this->t_11->CurrentValue;
					}
				}
			} else {
				$this->t_11->ViewValue = NULL;
			}
			$this->t_11->ViewCustomAttributes = "";

			// t_12
			$this->t_12->ViewValue = $this->t_12->CurrentValue;
			$curVal = strval($this->t_12->CurrentValue);
			if ($curVal <> "") {
				$this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
				if ($this->t_12->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_12->ViewValue = $this->t_12->CurrentValue;
					}
				}
			} else {
				$this->t_12->ViewValue = NULL;
			}
			$this->t_12->ViewCustomAttributes = "";

			// t_13
			$this->t_13->ViewValue = $this->t_13->CurrentValue;
			$this->t_13->ViewCustomAttributes = "";

			// t_14
			$this->t_14->ViewValue = $this->t_14->CurrentValue;
			$this->t_14->ViewCustomAttributes = "";

			// t_15
			$this->t_15->ViewValue = $this->t_15->CurrentValue;
			$this->t_15->ViewCustomAttributes = "";

			// d_head_01
			$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
			$this->d_head_01->ViewCustomAttributes = "";

			// d_description_01
			$this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;
			$this->d_description_01->ViewCustomAttributes = "";

			// d_head_02
			$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
			$this->d_head_02->ViewCustomAttributes = "";

			// d_description_02
			$this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;
			$this->d_description_02->ViewCustomAttributes = "";

			// main_image
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->ViewValue = "";
			}
			$this->main_image->ViewCustomAttributes = "";

			// top_view
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->ViewValue = "";
			}
			$this->top_view->ViewCustomAttributes = "";

			// front_view
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->ViewValue = "";
			}
			$this->front_view->ViewCustomAttributes = "";

			// corner_view
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->ViewValue = "";
			}
			$this->corner_view->ViewCustomAttributes = "";

			// back_view
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->ViewValue = "";
			}
			$this->back_view->ViewCustomAttributes = "";

			// color_options
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->ViewValue = "";
			}
			$this->color_options->ViewCustomAttributes = "";

			// other_options
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->ViewValue = "";
			}
			$this->other_options->ViewCustomAttributes = "";

			// group_image
			$this->group_image->UploadPath = '/product_images/o/group_image/' ;
			if (!EmptyValue($this->group_image->Upload->DbValue)) {
				$this->group_image->ViewValue = $this->group_image->Upload->DbValue;
			} else {
				$this->group_image->ViewValue = "";
			}
			$this->group_image->ViewCustomAttributes = "";

			// video_url
			$this->video_url->ViewValue = $this->video_url->CurrentValue;
			$this->video_url->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// last_price
			$this->last_price->ViewValue = $this->last_price->CurrentValue;
			$this->last_price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// hsn
			$curVal = strval($this->hsn->CurrentValue);
			if ($curVal <> "") {
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
				if ($this->hsn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hsn->ViewValue = $this->hsn->CurrentValue;
					}
				}
			} else {
				$this->hsn->ViewValue = NULL;
			}
			$this->hsn->ViewCustomAttributes = "";

			// composition
			$curVal = strval($this->composition->CurrentValue);
			if ($curVal <> "") {
				$this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
				if ($this->composition->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->composition->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->composition->ViewValue = $this->composition->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->composition->ViewValue = $this->composition->CurrentValue;
					}
				}
			} else {
				$this->composition->ViewValue = NULL;
			}
			$this->composition->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// moq
			$this->moq->ViewValue = $this->moq->CurrentValue;
			$this->moq->ViewValue = FormatNumber($this->moq->ViewValue, 2, -2, -2, -2);
			$this->moq->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// publish
			if (strval($this->publish->CurrentValue) <> "") {
				$this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
			} else {
				$this->publish->ViewValue = NULL;
			}
			$this->publish->ViewCustomAttributes = "";

			// keywords
			$this->keywords->ViewValue = $this->keywords->CurrentValue;
			$this->keywords->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "reflist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// product_n
			$this->product_n->LinkCustomAttributes = "";
			$this->product_n->HrefValue = "";
			$this->product_n->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// product_code_type
			$this->product_code_type->LinkCustomAttributes = "";
			$this->product_code_type->HrefValue = "";
			$this->product_code_type->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";
			$this->product_code->TooltipValue = "";

			// set_ref
			$this->set_ref->LinkCustomAttributes = "";
			$this->set_ref->HrefValue = "";
			$this->set_ref->TooltipValue = "";

			// v_00
			$this->v_00->LinkCustomAttributes = "";
			$this->v_00->HrefValue = "";
			$this->v_00->TooltipValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";
			$this->v_01->TooltipValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";
			$this->v_02->TooltipValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";
			$this->v_03->TooltipValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";
			$this->v_04->TooltipValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";
			$this->v_05->TooltipValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";
			$this->v_06->TooltipValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";
			$this->v_07->TooltipValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";
			$this->v_08->TooltipValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";
			$this->v_09->TooltipValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";
			$this->v_10->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// b_01
			$this->b_01->LinkCustomAttributes = "";
			$this->b_01->HrefValue = "";
			$this->b_01->TooltipValue = "";

			// b_02
			$this->b_02->LinkCustomAttributes = "";
			$this->b_02->HrefValue = "";
			$this->b_02->TooltipValue = "";

			// b_03
			$this->b_03->LinkCustomAttributes = "";
			$this->b_03->HrefValue = "";
			$this->b_03->TooltipValue = "";

			// b_04
			$this->b_04->LinkCustomAttributes = "";
			$this->b_04->HrefValue = "";
			$this->b_04->TooltipValue = "";

			// b_05
			$this->b_05->LinkCustomAttributes = "";
			$this->b_05->HrefValue = "";
			$this->b_05->TooltipValue = "";

			// b_06
			$this->b_06->LinkCustomAttributes = "";
			$this->b_06->HrefValue = "";
			$this->b_06->TooltipValue = "";

			// b_07
			$this->b_07->LinkCustomAttributes = "";
			$this->b_07->HrefValue = "";
			$this->b_07->TooltipValue = "";

			// b_08
			$this->b_08->LinkCustomAttributes = "";
			$this->b_08->HrefValue = "";
			$this->b_08->TooltipValue = "";

			// b_09
			$this->b_09->LinkCustomAttributes = "";
			$this->b_09->HrefValue = "";
			$this->b_09->TooltipValue = "";

			// b_10
			$this->b_10->LinkCustomAttributes = "";
			$this->b_10->HrefValue = "";
			$this->b_10->TooltipValue = "";

			// b_11
			$this->b_11->LinkCustomAttributes = "";
			$this->b_11->HrefValue = "";
			$this->b_11->TooltipValue = "";

			// b_12
			$this->b_12->LinkCustomAttributes = "";
			$this->b_12->HrefValue = "";
			$this->b_12->TooltipValue = "";

			// b_13
			$this->b_13->LinkCustomAttributes = "";
			$this->b_13->HrefValue = "";
			$this->b_13->TooltipValue = "";

			// b_14
			$this->b_14->LinkCustomAttributes = "";
			$this->b_14->HrefValue = "";
			$this->b_14->TooltipValue = "";

			// b_15
			$this->b_15->LinkCustomAttributes = "";
			$this->b_15->HrefValue = "";
			$this->b_15->TooltipValue = "";

			// t_01
			$this->t_01->LinkCustomAttributes = "";
			$this->t_01->HrefValue = "";
			$this->t_01->TooltipValue = "";

			// t_02
			$this->t_02->LinkCustomAttributes = "";
			$this->t_02->HrefValue = "";
			$this->t_02->TooltipValue = "";

			// t_03
			$this->t_03->LinkCustomAttributes = "";
			$this->t_03->HrefValue = "";
			$this->t_03->TooltipValue = "";

			// t_04
			$this->t_04->LinkCustomAttributes = "";
			$this->t_04->HrefValue = "";
			$this->t_04->TooltipValue = "";

			// t_05
			$this->t_05->LinkCustomAttributes = "";
			$this->t_05->HrefValue = "";
			$this->t_05->TooltipValue = "";

			// t_06
			$this->t_06->LinkCustomAttributes = "";
			$this->t_06->HrefValue = "";
			$this->t_06->TooltipValue = "";

			// t_07
			$this->t_07->LinkCustomAttributes = "";
			$this->t_07->HrefValue = "";
			$this->t_07->TooltipValue = "";

			// t_08
			$this->t_08->LinkCustomAttributes = "";
			$this->t_08->HrefValue = "";
			$this->t_08->TooltipValue = "";

			// t_09
			$this->t_09->LinkCustomAttributes = "";
			$this->t_09->HrefValue = "";
			$this->t_09->TooltipValue = "";

			// t_10
			$this->t_10->LinkCustomAttributes = "";
			$this->t_10->HrefValue = "";
			$this->t_10->TooltipValue = "";

			// t_11
			$this->t_11->LinkCustomAttributes = "";
			$this->t_11->HrefValue = "";
			$this->t_11->TooltipValue = "";

			// t_12
			$this->t_12->LinkCustomAttributes = "";
			$this->t_12->HrefValue = "";
			$this->t_12->TooltipValue = "";

			// t_13
			$this->t_13->LinkCustomAttributes = "";
			$this->t_13->HrefValue = "";
			$this->t_13->TooltipValue = "";

			// t_14
			$this->t_14->LinkCustomAttributes = "";
			$this->t_14->HrefValue = "";
			$this->t_14->TooltipValue = "";

			// t_15
			$this->t_15->LinkCustomAttributes = "";
			$this->t_15->HrefValue = "";
			$this->t_15->TooltipValue = "";

			// d_head_01
			$this->d_head_01->LinkCustomAttributes = "";
			$this->d_head_01->HrefValue = "";
			$this->d_head_01->TooltipValue = "";

			// d_description_01
			$this->d_description_01->LinkCustomAttributes = "";
			$this->d_description_01->HrefValue = "";
			$this->d_description_01->TooltipValue = "";

			// d_head_02
			$this->d_head_02->LinkCustomAttributes = "";
			$this->d_head_02->HrefValue = "";
			$this->d_head_02->TooltipValue = "";

			// d_description_02
			$this->d_description_02->LinkCustomAttributes = "";
			$this->d_description_02->HrefValue = "";
			$this->d_description_02->TooltipValue = "";

			// main_image
			$this->main_image->LinkCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->Upload->DbValue); // Add prefix/suffix
				$this->main_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
			} else {
				$this->main_image->HrefValue = "";
			}
			$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
			$this->main_image->TooltipValue = "";
			if ($this->main_image->UseColorbox) {
				if (EmptyValue($this->main_image->TooltipValue))
					$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->main_image->LinkAttrs["data-rel"] = "ref_x_main_image";
				AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
			}

			// top_view
			$this->top_view->LinkCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->HrefValue = "%u"; // Add prefix/suffix
				$this->top_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
			} else {
				$this->top_view->HrefValue = "";
			}
			$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
			$this->top_view->TooltipValue = "";
			if ($this->top_view->UseColorbox) {
				if (EmptyValue($this->top_view->TooltipValue))
					$this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->top_view->LinkAttrs["data-rel"] = "ref_x_top_view";
				AppendClass($this->top_view->LinkAttrs["class"], "ew-lightbox");
			}

			// front_view
			$this->front_view->LinkCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->HrefValue = "%u"; // Add prefix/suffix
				$this->front_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
			} else {
				$this->front_view->HrefValue = "";
			}
			$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
			$this->front_view->TooltipValue = "";
			if ($this->front_view->UseColorbox) {
				if (EmptyValue($this->front_view->TooltipValue))
					$this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->front_view->LinkAttrs["data-rel"] = "ref_x_front_view";
				AppendClass($this->front_view->LinkAttrs["class"], "ew-lightbox");
			}

			// corner_view
			$this->corner_view->LinkCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
				$this->corner_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
			} else {
				$this->corner_view->HrefValue = "";
			}
			$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
			$this->corner_view->TooltipValue = "";
			if ($this->corner_view->UseColorbox) {
				if (EmptyValue($this->corner_view->TooltipValue))
					$this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->corner_view->LinkAttrs["data-rel"] = "ref_x_corner_view";
				AppendClass($this->corner_view->LinkAttrs["class"], "ew-lightbox");
			}

			// back_view
			$this->back_view->LinkCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->HrefValue = "%u"; // Add prefix/suffix
				$this->back_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
			} else {
				$this->back_view->HrefValue = "";
			}
			$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
			$this->back_view->TooltipValue = "";
			if ($this->back_view->UseColorbox) {
				if (EmptyValue($this->back_view->TooltipValue))
					$this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->back_view->LinkAttrs["data-rel"] = "ref_x_back_view";
				AppendClass($this->back_view->LinkAttrs["class"], "ew-lightbox");
			}

			// color_options
			$this->color_options->LinkCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->HrefValue = "%u"; // Add prefix/suffix
				$this->color_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
			} else {
				$this->color_options->HrefValue = "";
			}
			$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
			$this->color_options->TooltipValue = "";
			if ($this->color_options->UseColorbox) {
				if (EmptyValue($this->color_options->TooltipValue))
					$this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->color_options->LinkAttrs["data-rel"] = "ref_x_color_options";
				AppendClass($this->color_options->LinkAttrs["class"], "ew-lightbox");
			}

			// other_options
			$this->other_options->LinkCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->HrefValue = "%u"; // Add prefix/suffix
				$this->other_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
			} else {
				$this->other_options->HrefValue = "";
			}
			$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
			$this->other_options->TooltipValue = "";
			if ($this->other_options->UseColorbox) {
				if (EmptyValue($this->other_options->TooltipValue))
					$this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->other_options->LinkAttrs["data-rel"] = "ref_x_other_options";
				AppendClass($this->other_options->LinkAttrs["class"], "ew-lightbox");
			}

			// group_image
			$this->group_image->LinkCustomAttributes = "";
			$this->group_image->HrefValue = "";
			$this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;
			$this->group_image->TooltipValue = "";

			// video_url
			$this->video_url->LinkCustomAttributes = "";
			$this->video_url->HrefValue = "";
			$this->video_url->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = "%u"; // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "ref_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}

			// last_price
			$this->last_price->LinkCustomAttributes = "";
			$this->last_price->HrefValue = "";
			$this->last_price->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";
			$this->hsn->TooltipValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";
			$this->composition->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// moq
			$this->moq->LinkCustomAttributes = "";
			$this->moq->HrefValue = "";
			$this->moq->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// publish
			$this->publish->LinkCustomAttributes = "";
			$this->publish->HrefValue = "";
			$this->publish->TooltipValue = "";

			// keywords
			$this->keywords->LinkCustomAttributes = "";
			$this->keywords->HrefValue = "";
			$this->keywords->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->CurrentValue));
			if ($curVal <> "")
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
				if ($this->company_id->ViewValue == "")
					$this->company_id->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1 and `id` >= 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` >= 200000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->company_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->company_id->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->CurrentValue));
			if ($curVal <> "")
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// product_n
			$this->product_n->EditAttrs["class"] = "form-control";
			$this->product_n->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
			$this->product_n->EditValue = HtmlEncode($this->product_n->CurrentValue);
			$this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->CurrentValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// product_code_type
			$this->product_code_type->EditAttrs["class"] = "form-control";
			$this->product_code_type->EditCustomAttributes = "";
			$this->product_code_type->EditValue = $this->product_code_type->options(TRUE);

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			$this->product_code->EditValue = HtmlEncode($this->product_code->CurrentValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// set_ref
			$this->set_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->set_ref->CurrentValue));
			if ($curVal <> "")
				$this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
			else
				$this->set_ref->ViewValue = $this->set_ref->Lookup !== NULL && is_array($this->set_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->set_ref->ViewValue !== NULL) { // Load from cache
				$this->set_ref->EditValue = array_values($this->set_ref->Lookup->Options);
				if ($this->set_ref->ViewValue == "")
					$this->set_ref->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->set_ref->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->set_ref->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->set_ref->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->set_ref->EditValue = $arwrk;
			}

			// v_00
			$this->v_00->EditAttrs["class"] = "form-control";
			$this->v_00->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
			$this->v_00->EditValue = HtmlEncode($this->v_00->CurrentValue);
			$this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

			// v_01
			$this->v_01->EditAttrs["class"] = "form-control";
			$this->v_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_01->CurrentValue));
			if ($curVal <> "")
				$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
			else
				$this->v_01->ViewValue = $this->v_01->Lookup !== NULL && is_array($this->v_01->Lookup->Options) ? $curVal : NULL;
			if ($this->v_01->ViewValue !== NULL) { // Load from cache
				$this->v_01->EditValue = array_values($this->v_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_01->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 101 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_01->EditValue = $arwrk;
			}

			// v_02
			$this->v_02->EditAttrs["class"] = "form-control";
			$this->v_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_02->CurrentValue));
			if ($curVal <> "")
				$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
			else
				$this->v_02->ViewValue = $this->v_02->Lookup !== NULL && is_array($this->v_02->Lookup->Options) ? $curVal : NULL;
			if ($this->v_02->ViewValue !== NULL) { // Load from cache
				$this->v_02->EditValue = array_values($this->v_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_02->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 102 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_02->EditValue = $arwrk;
			}

			// v_03
			$this->v_03->EditAttrs["class"] = "form-control";
			$this->v_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_03->CurrentValue));
			if ($curVal <> "")
				$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
			else
				$this->v_03->ViewValue = $this->v_03->Lookup !== NULL && is_array($this->v_03->Lookup->Options) ? $curVal : NULL;
			if ($this->v_03->ViewValue !== NULL) { // Load from cache
				$this->v_03->EditValue = array_values($this->v_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_03->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 103 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_03->EditValue = $arwrk;
			}

			// v_04
			$this->v_04->EditAttrs["class"] = "form-control";
			$this->v_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_04->CurrentValue));
			if ($curVal <> "")
				$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
			else
				$this->v_04->ViewValue = $this->v_04->Lookup !== NULL && is_array($this->v_04->Lookup->Options) ? $curVal : NULL;
			if ($this->v_04->ViewValue !== NULL) { // Load from cache
				$this->v_04->EditValue = array_values($this->v_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_04->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 104 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_04->EditValue = $arwrk;
			}

			// v_05
			$this->v_05->EditAttrs["class"] = "form-control";
			$this->v_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_05->CurrentValue));
			if ($curVal <> "")
				$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
			else
				$this->v_05->ViewValue = $this->v_05->Lookup !== NULL && is_array($this->v_05->Lookup->Options) ? $curVal : NULL;
			if ($this->v_05->ViewValue !== NULL) { // Load from cache
				$this->v_05->EditValue = array_values($this->v_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_05->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 105 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_05->EditValue = $arwrk;
			}

			// v_06
			$this->v_06->EditAttrs["class"] = "form-control";
			$this->v_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_06->CurrentValue));
			if ($curVal <> "")
				$this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
			else
				$this->v_06->ViewValue = $this->v_06->Lookup !== NULL && is_array($this->v_06->Lookup->Options) ? $curVal : NULL;
			if ($this->v_06->ViewValue !== NULL) { // Load from cache
				$this->v_06->EditValue = array_values($this->v_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_06->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 106 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_06->EditValue = $arwrk;
			}

			// v_07
			$this->v_07->EditAttrs["class"] = "form-control";
			$this->v_07->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_07->CurrentValue));
			if ($curVal <> "")
				$this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
			else
				$this->v_07->ViewValue = $this->v_07->Lookup !== NULL && is_array($this->v_07->Lookup->Options) ? $curVal : NULL;
			if ($this->v_07->ViewValue !== NULL) { // Load from cache
				$this->v_07->EditValue = array_values($this->v_07->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_07->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 107 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_07->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_07->EditValue = $arwrk;
			}

			// v_08
			$this->v_08->EditAttrs["class"] = "form-control";
			$this->v_08->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_08->CurrentValue));
			if ($curVal <> "")
				$this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
			else
				$this->v_08->ViewValue = $this->v_08->Lookup !== NULL && is_array($this->v_08->Lookup->Options) ? $curVal : NULL;
			if ($this->v_08->ViewValue !== NULL) { // Load from cache
				$this->v_08->EditValue = array_values($this->v_08->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_08->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 108 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_08->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_08->EditValue = $arwrk;
			}

			// v_09
			$this->v_09->EditAttrs["class"] = "form-control";
			$this->v_09->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_09->CurrentValue));
			if ($curVal <> "")
				$this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
			else
				$this->v_09->ViewValue = $this->v_09->Lookup !== NULL && is_array($this->v_09->Lookup->Options) ? $curVal : NULL;
			if ($this->v_09->ViewValue !== NULL) { // Load from cache
				$this->v_09->EditValue = array_values($this->v_09->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_09->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 109 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_09->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_09->EditValue = $arwrk;
			}

			// v_10
			$this->v_10->EditAttrs["class"] = "form-control";
			$this->v_10->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_10->CurrentValue));
			if ($curVal <> "")
				$this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
			else
				$this->v_10->ViewValue = $this->v_10->Lookup !== NULL && is_array($this->v_10->Lookup->Options) ? $curVal : NULL;
			if ($this->v_10->ViewValue !== NULL) { // Load from cache
				$this->v_10->EditValue = array_values($this->v_10->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`code`" . SearchString("=", $this->v_10->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 110 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_10->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_10->EditValue = $arwrk;
			}

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			$this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
			if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
				$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -1, -2, 0);

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
			if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
				$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -1, -2, 0);

			// shape
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->CurrentValue));
			if ($curVal <> "")
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// q_sku
			$this->q_sku->EditAttrs["class"] = "form-control";
			$this->q_sku->EditCustomAttributes = "";
			$this->q_sku->EditValue = HtmlEncode($this->q_sku->CurrentValue);
			$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
			if (strval($this->q_sku->EditValue) <> "" && is_numeric($this->q_sku->EditValue))
				$this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, -2, -2, -2, -2);

			// b_01
			$this->b_01->EditAttrs["class"] = "form-control";
			$this->b_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
			$this->b_01->EditValue = HtmlEncode($this->b_01->CurrentValue);
			$this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

			// b_02
			$this->b_02->EditAttrs["class"] = "form-control";
			$this->b_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_02->CurrentValue = HtmlDecode($this->b_02->CurrentValue);
			$this->b_02->EditValue = HtmlEncode($this->b_02->CurrentValue);
			$this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

			// b_03
			$this->b_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_03->CurrentValue));
			if ($curVal <> "")
				$this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
			else
				$this->b_03->ViewValue = $this->b_03->Lookup !== NULL && is_array($this->b_03->Lookup->Options) ? $curVal : NULL;
			if ($this->b_03->ViewValue !== NULL) { // Load from cache
				$this->b_03->EditValue = array_values($this->b_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 203 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_03->EditValue = $arwrk;
			}

			// b_04
			$this->b_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_04->CurrentValue));
			if ($curVal <> "")
				$this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
			else
				$this->b_04->ViewValue = $this->b_04->Lookup !== NULL && is_array($this->b_04->Lookup->Options) ? $curVal : NULL;
			if ($this->b_04->ViewValue !== NULL) { // Load from cache
				$this->b_04->EditValue = array_values($this->b_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 204 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_04->EditValue = $arwrk;
			}

			// b_05
			$this->b_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_05->CurrentValue));
			if ($curVal <> "")
				$this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
			else
				$this->b_05->ViewValue = $this->b_05->Lookup !== NULL && is_array($this->b_05->Lookup->Options) ? $curVal : NULL;
			if ($this->b_05->ViewValue !== NULL) { // Load from cache
				$this->b_05->EditValue = array_values($this->b_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 205 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_05->EditValue = $arwrk;
			}

			// b_06
			$this->b_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_06->CurrentValue));
			if ($curVal <> "")
				$this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
			else
				$this->b_06->ViewValue = $this->b_06->Lookup !== NULL && is_array($this->b_06->Lookup->Options) ? $curVal : NULL;
			if ($this->b_06->ViewValue !== NULL) { // Load from cache
				$this->b_06->EditValue = array_values($this->b_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 206 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_06->EditValue = $arwrk;
			}

			// b_07
			$this->b_07->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_07->CurrentValue));
			if ($curVal <> "")
				$this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
			else
				$this->b_07->ViewValue = $this->b_07->Lookup !== NULL && is_array($this->b_07->Lookup->Options) ? $curVal : NULL;
			if ($this->b_07->ViewValue !== NULL) { // Load from cache
				$this->b_07->EditValue = array_values($this->b_07->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 207 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_07->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_07->EditValue = $arwrk;
			}

			// b_08
			$this->b_08->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_08->CurrentValue));
			if ($curVal <> "")
				$this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
			else
				$this->b_08->ViewValue = $this->b_08->Lookup !== NULL && is_array($this->b_08->Lookup->Options) ? $curVal : NULL;
			if ($this->b_08->ViewValue !== NULL) { // Load from cache
				$this->b_08->EditValue = array_values($this->b_08->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 208 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_08->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_08->EditValue = $arwrk;
			}

			// b_09
			$this->b_09->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_09->CurrentValue));
			if ($curVal <> "")
				$this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
			else
				$this->b_09->ViewValue = $this->b_09->Lookup !== NULL && is_array($this->b_09->Lookup->Options) ? $curVal : NULL;
			if ($this->b_09->ViewValue !== NULL) { // Load from cache
				$this->b_09->EditValue = array_values($this->b_09->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 209 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_09->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_09->EditValue = $arwrk;
			}

			// b_10
			$this->b_10->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_10->CurrentValue));
			if ($curVal <> "")
				$this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
			else
				$this->b_10->ViewValue = $this->b_10->Lookup !== NULL && is_array($this->b_10->Lookup->Options) ? $curVal : NULL;
			if ($this->b_10->ViewValue !== NULL) { // Load from cache
				$this->b_10->EditValue = array_values($this->b_10->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 210 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_10->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_10->EditValue = $arwrk;
			}

			// b_11
			$this->b_11->EditAttrs["class"] = "form-control";
			$this->b_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_11->CurrentValue = HtmlDecode($this->b_11->CurrentValue);
			$this->b_11->EditValue = HtmlEncode($this->b_11->CurrentValue);
			$this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

			// b_12
			$this->b_12->EditAttrs["class"] = "form-control";
			$this->b_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
			$this->b_12->EditValue = HtmlEncode($this->b_12->CurrentValue);
			$this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

			// b_13
			$this->b_13->EditAttrs["class"] = "form-control";
			$this->b_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_13->CurrentValue = HtmlDecode($this->b_13->CurrentValue);
			$this->b_13->EditValue = HtmlEncode($this->b_13->CurrentValue);
			$this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

			// b_14
			$this->b_14->EditAttrs["class"] = "form-control";
			$this->b_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_14->CurrentValue = HtmlDecode($this->b_14->CurrentValue);
			$this->b_14->EditValue = HtmlEncode($this->b_14->CurrentValue);
			$this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

			// b_15
			$this->b_15->EditAttrs["class"] = "form-control";
			$this->b_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_15->CurrentValue = HtmlDecode($this->b_15->CurrentValue);
			$this->b_15->EditValue = HtmlEncode($this->b_15->CurrentValue);
			$this->b_15->PlaceHolder = RemoveHtml($this->b_15->caption());

			// t_01
			$this->t_01->EditAttrs["class"] = "form-control";
			$this->t_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_01->CurrentValue = HtmlDecode($this->t_01->CurrentValue);
			$this->t_01->EditValue = HtmlEncode($this->t_01->CurrentValue);
			$this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

			// t_02
			$this->t_02->EditAttrs["class"] = "form-control";
			$this->t_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_02->CurrentValue = HtmlDecode($this->t_02->CurrentValue);
			$this->t_02->EditValue = HtmlEncode($this->t_02->CurrentValue);
			$this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

			// t_03
			$this->t_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_03->CurrentValue));
			if ($curVal <> "")
				$this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
			else
				$this->t_03->ViewValue = $this->t_03->Lookup !== NULL && is_array($this->t_03->Lookup->Options) ? $curVal : NULL;
			if ($this->t_03->ViewValue !== NULL) { // Load from cache
				$this->t_03->EditValue = array_values($this->t_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 303 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_03->EditValue = $arwrk;
			}

			// t_04
			$this->t_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_04->CurrentValue));
			if ($curVal <> "")
				$this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
			else
				$this->t_04->ViewValue = $this->t_04->Lookup !== NULL && is_array($this->t_04->Lookup->Options) ? $curVal : NULL;
			if ($this->t_04->ViewValue !== NULL) { // Load from cache
				$this->t_04->EditValue = array_values($this->t_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 304 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_04->EditValue = $arwrk;
			}

			// t_05
			$this->t_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_05->CurrentValue));
			if ($curVal <> "")
				$this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
			else
				$this->t_05->ViewValue = $this->t_05->Lookup !== NULL && is_array($this->t_05->Lookup->Options) ? $curVal : NULL;
			if ($this->t_05->ViewValue !== NULL) { // Load from cache
				$this->t_05->EditValue = array_values($this->t_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 305 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_05->EditValue = $arwrk;
			}

			// t_06
			$this->t_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_06->CurrentValue));
			if ($curVal <> "")
				$this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
			else
				$this->t_06->ViewValue = $this->t_06->Lookup !== NULL && is_array($this->t_06->Lookup->Options) ? $curVal : NULL;
			if ($this->t_06->ViewValue !== NULL) { // Load from cache
				$this->t_06->EditValue = array_values($this->t_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 306 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_06->EditValue = $arwrk;
			}

			// t_07
			$this->t_07->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_07->CurrentValue));
			if ($curVal <> "")
				$this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
			else
				$this->t_07->ViewValue = $this->t_07->Lookup !== NULL && is_array($this->t_07->Lookup->Options) ? $curVal : NULL;
			if ($this->t_07->ViewValue !== NULL) { // Load from cache
				$this->t_07->EditValue = array_values($this->t_07->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 307 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_07->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_07->EditValue = $arwrk;
			}

			// t_08
			$this->t_08->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_08->CurrentValue));
			if ($curVal <> "")
				$this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
			else
				$this->t_08->ViewValue = $this->t_08->Lookup !== NULL && is_array($this->t_08->Lookup->Options) ? $curVal : NULL;
			if ($this->t_08->ViewValue !== NULL) { // Load from cache
				$this->t_08->EditValue = array_values($this->t_08->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 308 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_08->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_08->EditValue = $arwrk;
			}

			// t_09
			$this->t_09->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_09->CurrentValue));
			if ($curVal <> "")
				$this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
			else
				$this->t_09->ViewValue = $this->t_09->Lookup !== NULL && is_array($this->t_09->Lookup->Options) ? $curVal : NULL;
			if ($this->t_09->ViewValue !== NULL) { // Load from cache
				$this->t_09->EditValue = array_values($this->t_09->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 309 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_09->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_09->EditValue = $arwrk;
			}

			// t_10
			$this->t_10->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_10->CurrentValue));
			if ($curVal <> "")
				$this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
			else
				$this->t_10->ViewValue = $this->t_10->Lookup !== NULL && is_array($this->t_10->Lookup->Options) ? $curVal : NULL;
			if ($this->t_10->ViewValue !== NULL) { // Load from cache
				$this->t_10->EditValue = array_values($this->t_10->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 310 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_10->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_10->EditValue = $arwrk;
			}

			// t_11
			$this->t_11->EditAttrs["class"] = "form-control";
			$this->t_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_11->CurrentValue = HtmlDecode($this->t_11->CurrentValue);
			$this->t_11->EditValue = HtmlEncode($this->t_11->CurrentValue);
			$curVal = strval($this->t_11->CurrentValue);
			if ($curVal <> "") {
				$this->t_11->EditValue = $this->t_11->lookupCacheOption($curVal);
				if ($this->t_11->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->t_11->EditValue = $this->t_11->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_11->EditValue = HtmlEncode($this->t_11->CurrentValue);
					}
				}
			} else {
				$this->t_11->EditValue = NULL;
			}
			$this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

			// t_12
			$this->t_12->EditAttrs["class"] = "form-control";
			$this->t_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_12->CurrentValue = HtmlDecode($this->t_12->CurrentValue);
			$this->t_12->EditValue = HtmlEncode($this->t_12->CurrentValue);
			$curVal = strval($this->t_12->CurrentValue);
			if ($curVal <> "") {
				$this->t_12->EditValue = $this->t_12->lookupCacheOption($curVal);
				if ($this->t_12->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->t_12->EditValue = $this->t_12->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_12->EditValue = HtmlEncode($this->t_12->CurrentValue);
					}
				}
			} else {
				$this->t_12->EditValue = NULL;
			}
			$this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

			// t_13
			$this->t_13->EditAttrs["class"] = "form-control";
			$this->t_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_13->CurrentValue = HtmlDecode($this->t_13->CurrentValue);
			$this->t_13->EditValue = HtmlEncode($this->t_13->CurrentValue);
			$this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

			// t_14
			$this->t_14->EditAttrs["class"] = "form-control";
			$this->t_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_14->CurrentValue = HtmlDecode($this->t_14->CurrentValue);
			$this->t_14->EditValue = HtmlEncode($this->t_14->CurrentValue);
			$this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

			// t_15
			$this->t_15->EditAttrs["class"] = "form-control";
			$this->t_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_15->CurrentValue = HtmlDecode($this->t_15->CurrentValue);
			$this->t_15->EditValue = HtmlEncode($this->t_15->CurrentValue);
			$this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

			// d_head_01
			$this->d_head_01->EditAttrs["class"] = "form-control";
			$this->d_head_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_head_01->CurrentValue = HtmlDecode($this->d_head_01->CurrentValue);
			$this->d_head_01->EditValue = HtmlEncode($this->d_head_01->CurrentValue);
			$this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

			// d_description_01
			$this->d_description_01->EditAttrs["class"] = "form-control";
			$this->d_description_01->EditCustomAttributes = "";
			$this->d_description_01->EditValue = HtmlEncode($this->d_description_01->CurrentValue);
			$this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

			// d_head_02
			$this->d_head_02->EditAttrs["class"] = "form-control";
			$this->d_head_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_head_02->CurrentValue = HtmlDecode($this->d_head_02->CurrentValue);
			$this->d_head_02->EditValue = HtmlEncode($this->d_head_02->CurrentValue);
			$this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

			// d_description_02
			$this->d_description_02->EditAttrs["class"] = "form-control";
			$this->d_description_02->EditCustomAttributes = "";
			$this->d_description_02->EditValue = HtmlEncode($this->d_description_02->CurrentValue);
			$this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

			// main_image
			$this->main_image->EditAttrs["class"] = "form-control";
			$this->main_image->EditCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->EditValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->EditValue = "";
			}
			if (!EmptyValue($this->main_image->CurrentValue))
					$this->main_image->Upload->FileName = $this->main_image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->main_image);

			// top_view
			$this->top_view->EditAttrs["class"] = "form-control";
			$this->top_view->EditCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->EditValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->EditValue = "";
			}
			if (!EmptyValue($this->top_view->CurrentValue))
					$this->top_view->Upload->FileName = $this->top_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->top_view);

			// front_view
			$this->front_view->EditAttrs["class"] = "form-control";
			$this->front_view->EditCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->EditValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->EditValue = "";
			}
			if (!EmptyValue($this->front_view->CurrentValue))
					$this->front_view->Upload->FileName = $this->front_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->front_view);

			// corner_view
			$this->corner_view->EditAttrs["class"] = "form-control";
			$this->corner_view->EditCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->EditValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->EditValue = "";
			}
			if (!EmptyValue($this->corner_view->CurrentValue))
					$this->corner_view->Upload->FileName = $this->corner_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->corner_view);

			// back_view
			$this->back_view->EditAttrs["class"] = "form-control";
			$this->back_view->EditCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->EditValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->EditValue = "";
			}
			if (!EmptyValue($this->back_view->CurrentValue))
					$this->back_view->Upload->FileName = $this->back_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->back_view);

			// color_options
			$this->color_options->EditAttrs["class"] = "form-control";
			$this->color_options->EditCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->EditValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->EditValue = "";
			}
			if (!EmptyValue($this->color_options->CurrentValue))
					$this->color_options->Upload->FileName = $this->color_options->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->color_options);

			// other_options
			$this->other_options->EditAttrs["class"] = "form-control";
			$this->other_options->EditCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->EditValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->EditValue = "";
			}
			if (!EmptyValue($this->other_options->CurrentValue))
					$this->other_options->Upload->FileName = $this->other_options->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->other_options);

			// group_image
			$this->group_image->EditAttrs["class"] = "form-control";
			$this->group_image->EditCustomAttributes = "";
			$this->group_image->UploadPath = '/product_images/o/group_image/' ;
			if (!EmptyValue($this->group_image->Upload->DbValue)) {
				$this->group_image->EditValue = $this->group_image->Upload->DbValue;
			} else {
				$this->group_image->EditValue = "";
			}
			if (!EmptyValue($this->group_image->CurrentValue))
					$this->group_image->Upload->FileName = $this->group_image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->group_image);

			// video_url
			$this->video_url->EditAttrs["class"] = "form-control";
			$this->video_url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
			$this->video_url->EditValue = HtmlEncode($this->video_url->CurrentValue);
			$this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->EditValue = $this->image->Upload->DbValue;
			} else {
				$this->image->EditValue = "";
			}
			if (!EmptyValue($this->image->CurrentValue))
					$this->image->Upload->FileName = $this->image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->image);

			// last_price
			$this->last_price->EditAttrs["class"] = "form-control";
			$this->last_price->EditCustomAttributes = "";
			$this->last_price->EditValue = $this->last_price->CurrentValue;
			$this->last_price->ViewCustomAttributes = "";

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->CurrentValue));
			if ($curVal <> "")
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// hsn
			$this->hsn->EditAttrs["class"] = "form-control";
			$this->hsn->EditCustomAttributes = "";
			$curVal = trim(strval($this->hsn->CurrentValue));
			if ($curVal <> "")
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
			else
				$this->hsn->ViewValue = $this->hsn->Lookup !== NULL && is_array($this->hsn->Lookup->Options) ? $curVal : NULL;
			if ($this->hsn->ViewValue !== NULL) { // Load from cache
				$this->hsn->EditValue = array_values($this->hsn->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->hsn->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->hsn->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
				}
				$this->hsn->EditValue = $arwrk;
			}

			// composition
			$this->composition->EditAttrs["class"] = "form-control";
			$this->composition->EditCustomAttributes = "";
			$curVal = trim(strval($this->composition->CurrentValue));
			if ($curVal <> "")
				$this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
			else
				$this->composition->ViewValue = $this->composition->Lookup !== NULL && is_array($this->composition->Lookup->Options) ? $curVal : NULL;
			if ($this->composition->ViewValue !== NULL) { // Load from cache
				$this->composition->EditValue = array_values($this->composition->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->composition->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->composition->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->composition->EditValue = $arwrk;
			}

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->CurrentValue));
			if ($curVal <> "")
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// moq
			$this->moq->EditAttrs["class"] = "form-control";
			$this->moq->EditCustomAttributes = "";
			$this->moq->EditValue = HtmlEncode($this->moq->CurrentValue);
			$this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
			if (strval($this->moq->EditValue) <> "" && is_numeric($this->moq->EditValue))
				$this->moq->EditValue = FormatNumber($this->moq->EditValue, -2, -2, -2, -2);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// publish
			$this->publish->EditAttrs["class"] = "form-control";
			$this->publish->EditCustomAttributes = "";
			$this->publish->EditValue = $this->publish->options(TRUE);

			// keywords
			$this->keywords->EditAttrs["class"] = "form-control";
			$this->keywords->EditCustomAttributes = "";
			$this->keywords->EditValue = HtmlEncode($this->keywords->CurrentValue);
			$this->keywords->PlaceHolder = RemoveHtml($this->keywords->caption());

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "reflist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// product_n
			$this->product_n->LinkCustomAttributes = "";
			$this->product_n->HrefValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";

			// product_code_type
			$this->product_code_type->LinkCustomAttributes = "";
			$this->product_code_type->HrefValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";

			// set_ref
			$this->set_ref->LinkCustomAttributes = "";
			$this->set_ref->HrefValue = "";

			// v_00
			$this->v_00->LinkCustomAttributes = "";
			$this->v_00->HrefValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";

			// b_01
			$this->b_01->LinkCustomAttributes = "";
			$this->b_01->HrefValue = "";

			// b_02
			$this->b_02->LinkCustomAttributes = "";
			$this->b_02->HrefValue = "";

			// b_03
			$this->b_03->LinkCustomAttributes = "";
			$this->b_03->HrefValue = "";

			// b_04
			$this->b_04->LinkCustomAttributes = "";
			$this->b_04->HrefValue = "";

			// b_05
			$this->b_05->LinkCustomAttributes = "";
			$this->b_05->HrefValue = "";

			// b_06
			$this->b_06->LinkCustomAttributes = "";
			$this->b_06->HrefValue = "";

			// b_07
			$this->b_07->LinkCustomAttributes = "";
			$this->b_07->HrefValue = "";

			// b_08
			$this->b_08->LinkCustomAttributes = "";
			$this->b_08->HrefValue = "";

			// b_09
			$this->b_09->LinkCustomAttributes = "";
			$this->b_09->HrefValue = "";

			// b_10
			$this->b_10->LinkCustomAttributes = "";
			$this->b_10->HrefValue = "";

			// b_11
			$this->b_11->LinkCustomAttributes = "";
			$this->b_11->HrefValue = "";

			// b_12
			$this->b_12->LinkCustomAttributes = "";
			$this->b_12->HrefValue = "";

			// b_13
			$this->b_13->LinkCustomAttributes = "";
			$this->b_13->HrefValue = "";

			// b_14
			$this->b_14->LinkCustomAttributes = "";
			$this->b_14->HrefValue = "";

			// b_15
			$this->b_15->LinkCustomAttributes = "";
			$this->b_15->HrefValue = "";

			// t_01
			$this->t_01->LinkCustomAttributes = "";
			$this->t_01->HrefValue = "";

			// t_02
			$this->t_02->LinkCustomAttributes = "";
			$this->t_02->HrefValue = "";

			// t_03
			$this->t_03->LinkCustomAttributes = "";
			$this->t_03->HrefValue = "";

			// t_04
			$this->t_04->LinkCustomAttributes = "";
			$this->t_04->HrefValue = "";

			// t_05
			$this->t_05->LinkCustomAttributes = "";
			$this->t_05->HrefValue = "";

			// t_06
			$this->t_06->LinkCustomAttributes = "";
			$this->t_06->HrefValue = "";

			// t_07
			$this->t_07->LinkCustomAttributes = "";
			$this->t_07->HrefValue = "";

			// t_08
			$this->t_08->LinkCustomAttributes = "";
			$this->t_08->HrefValue = "";

			// t_09
			$this->t_09->LinkCustomAttributes = "";
			$this->t_09->HrefValue = "";

			// t_10
			$this->t_10->LinkCustomAttributes = "";
			$this->t_10->HrefValue = "";

			// t_11
			$this->t_11->LinkCustomAttributes = "";
			$this->t_11->HrefValue = "";

			// t_12
			$this->t_12->LinkCustomAttributes = "";
			$this->t_12->HrefValue = "";

			// t_13
			$this->t_13->LinkCustomAttributes = "";
			$this->t_13->HrefValue = "";

			// t_14
			$this->t_14->LinkCustomAttributes = "";
			$this->t_14->HrefValue = "";

			// t_15
			$this->t_15->LinkCustomAttributes = "";
			$this->t_15->HrefValue = "";

			// d_head_01
			$this->d_head_01->LinkCustomAttributes = "";
			$this->d_head_01->HrefValue = "";

			// d_description_01
			$this->d_description_01->LinkCustomAttributes = "";
			$this->d_description_01->HrefValue = "";

			// d_head_02
			$this->d_head_02->LinkCustomAttributes = "";
			$this->d_head_02->HrefValue = "";

			// d_description_02
			$this->d_description_02->LinkCustomAttributes = "";
			$this->d_description_02->HrefValue = "";

			// main_image
			$this->main_image->LinkCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->Upload->DbValue); // Add prefix/suffix
				$this->main_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
			} else {
				$this->main_image->HrefValue = "";
			}
			$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;

			// top_view
			$this->top_view->LinkCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->HrefValue = "%u"; // Add prefix/suffix
				$this->top_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
			} else {
				$this->top_view->HrefValue = "";
			}
			$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;

			// front_view
			$this->front_view->LinkCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->HrefValue = "%u"; // Add prefix/suffix
				$this->front_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
			} else {
				$this->front_view->HrefValue = "";
			}
			$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;

			// corner_view
			$this->corner_view->LinkCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
				$this->corner_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
			} else {
				$this->corner_view->HrefValue = "";
			}
			$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;

			// back_view
			$this->back_view->LinkCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->HrefValue = "%u"; // Add prefix/suffix
				$this->back_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
			} else {
				$this->back_view->HrefValue = "";
			}
			$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;

			// color_options
			$this->color_options->LinkCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->HrefValue = "%u"; // Add prefix/suffix
				$this->color_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
			} else {
				$this->color_options->HrefValue = "";
			}
			$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;

			// other_options
			$this->other_options->LinkCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->HrefValue = "%u"; // Add prefix/suffix
				$this->other_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
			} else {
				$this->other_options->HrefValue = "";
			}
			$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;

			// group_image
			$this->group_image->LinkCustomAttributes = "";
			$this->group_image->HrefValue = "";
			$this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;

			// video_url
			$this->video_url->LinkCustomAttributes = "";
			$this->video_url->HrefValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = "%u"; // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

			// last_price
			$this->last_price->LinkCustomAttributes = "";
			$this->last_price->HrefValue = "";
			$this->last_price->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";

			// moq
			$this->moq->LinkCustomAttributes = "";
			$this->moq->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// publish
			$this->publish->LinkCustomAttributes = "";
			$this->publish->HrefValue = "";

			// keywords
			$this->keywords->LinkCustomAttributes = "";
			$this->keywords->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->oid->Required) {
			if (!$this->oid->IsDetailKey && $this->oid->FormValue != NULL && $this->oid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->oid->caption(), $this->oid->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if ($this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->product_n->Required) {
			if (!$this->product_n->IsDetailKey && $this->product_n->FormValue != NULL && $this->product_n->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_n->caption(), $this->product_n->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->product_code_type->Required) {
			if (!$this->product_code_type->IsDetailKey && $this->product_code_type->FormValue != NULL && $this->product_code_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_code_type->caption(), $this->product_code_type->RequiredErrorMessage));
			}
		}
		if ($this->product_code->Required) {
			if (!$this->product_code->IsDetailKey && $this->product_code->FormValue != NULL && $this->product_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
			}
		}
		if ($this->gcode->Required) {
			if (!$this->gcode->IsDetailKey && $this->gcode->FormValue != NULL && $this->gcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gcode->caption(), $this->gcode->RequiredErrorMessage));
			}
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->product_id->Required) {
			if (!$this->product_id->IsDetailKey && $this->product_id->FormValue != NULL && $this->product_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
			}
		}
		if ($this->print_name->Required) {
			if (!$this->print_name->IsDetailKey && $this->print_name->FormValue != NULL && $this->print_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->print_name->caption(), $this->print_name->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->set_ref->Required) {
			if ($this->set_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->set_ref->caption(), $this->set_ref->RequiredErrorMessage));
			}
		}
		if ($this->v_00->Required) {
			if (!$this->v_00->IsDetailKey && $this->v_00->FormValue != NULL && $this->v_00->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_00->caption(), $this->v_00->RequiredErrorMessage));
			}
		}
		if ($this->v_01->Required) {
			if (!$this->v_01->IsDetailKey && $this->v_01->FormValue != NULL && $this->v_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_01->caption(), $this->v_01->RequiredErrorMessage));
			}
		}
		if ($this->v_02->Required) {
			if (!$this->v_02->IsDetailKey && $this->v_02->FormValue != NULL && $this->v_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_02->caption(), $this->v_02->RequiredErrorMessage));
			}
		}
		if ($this->v_03->Required) {
			if (!$this->v_03->IsDetailKey && $this->v_03->FormValue != NULL && $this->v_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_03->caption(), $this->v_03->RequiredErrorMessage));
			}
		}
		if ($this->v_04->Required) {
			if (!$this->v_04->IsDetailKey && $this->v_04->FormValue != NULL && $this->v_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_04->caption(), $this->v_04->RequiredErrorMessage));
			}
		}
		if ($this->v_05->Required) {
			if (!$this->v_05->IsDetailKey && $this->v_05->FormValue != NULL && $this->v_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_05->caption(), $this->v_05->RequiredErrorMessage));
			}
		}
		if ($this->v_06->Required) {
			if (!$this->v_06->IsDetailKey && $this->v_06->FormValue != NULL && $this->v_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_06->caption(), $this->v_06->RequiredErrorMessage));
			}
		}
		if ($this->v_07->Required) {
			if (!$this->v_07->IsDetailKey && $this->v_07->FormValue != NULL && $this->v_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_07->caption(), $this->v_07->RequiredErrorMessage));
			}
		}
		if ($this->v_08->Required) {
			if (!$this->v_08->IsDetailKey && $this->v_08->FormValue != NULL && $this->v_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_08->caption(), $this->v_08->RequiredErrorMessage));
			}
		}
		if ($this->v_09->Required) {
			if (!$this->v_09->IsDetailKey && $this->v_09->FormValue != NULL && $this->v_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_09->caption(), $this->v_09->RequiredErrorMessage));
			}
		}
		if ($this->v_10->Required) {
			if (!$this->v_10->IsDetailKey && $this->v_10->FormValue != NULL && $this->v_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->v_10->caption(), $this->v_10->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if ($this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->q_sku->Required) {
			if (!$this->q_sku->IsDetailKey && $this->q_sku->FormValue != NULL && $this->q_sku->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->q_sku->FormValue)) {
			AddMessage($FormError, $this->q_sku->errorMessage());
		}
		if ($this->b_01->Required) {
			if (!$this->b_01->IsDetailKey && $this->b_01->FormValue != NULL && $this->b_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_01->caption(), $this->b_01->RequiredErrorMessage));
			}
		}
		if ($this->b_02->Required) {
			if (!$this->b_02->IsDetailKey && $this->b_02->FormValue != NULL && $this->b_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_02->caption(), $this->b_02->RequiredErrorMessage));
			}
		}
		if ($this->b_03->Required) {
			if ($this->b_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_03->caption(), $this->b_03->RequiredErrorMessage));
			}
		}
		if ($this->b_04->Required) {
			if ($this->b_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_04->caption(), $this->b_04->RequiredErrorMessage));
			}
		}
		if ($this->b_05->Required) {
			if ($this->b_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_05->caption(), $this->b_05->RequiredErrorMessage));
			}
		}
		if ($this->b_06->Required) {
			if ($this->b_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_06->caption(), $this->b_06->RequiredErrorMessage));
			}
		}
		if ($this->b_07->Required) {
			if ($this->b_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_07->caption(), $this->b_07->RequiredErrorMessage));
			}
		}
		if ($this->b_08->Required) {
			if ($this->b_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_08->caption(), $this->b_08->RequiredErrorMessage));
			}
		}
		if ($this->b_09->Required) {
			if ($this->b_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_09->caption(), $this->b_09->RequiredErrorMessage));
			}
		}
		if ($this->b_10->Required) {
			if ($this->b_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_10->caption(), $this->b_10->RequiredErrorMessage));
			}
		}
		if ($this->b_11->Required) {
			if (!$this->b_11->IsDetailKey && $this->b_11->FormValue != NULL && $this->b_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_11->caption(), $this->b_11->RequiredErrorMessage));
			}
		}
		if ($this->b_12->Required) {
			if (!$this->b_12->IsDetailKey && $this->b_12->FormValue != NULL && $this->b_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_12->caption(), $this->b_12->RequiredErrorMessage));
			}
		}
		if ($this->b_13->Required) {
			if (!$this->b_13->IsDetailKey && $this->b_13->FormValue != NULL && $this->b_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_13->caption(), $this->b_13->RequiredErrorMessage));
			}
		}
		if ($this->b_14->Required) {
			if (!$this->b_14->IsDetailKey && $this->b_14->FormValue != NULL && $this->b_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_14->caption(), $this->b_14->RequiredErrorMessage));
			}
		}
		if ($this->b_15->Required) {
			if (!$this->b_15->IsDetailKey && $this->b_15->FormValue != NULL && $this->b_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_15->caption(), $this->b_15->RequiredErrorMessage));
			}
		}
		if ($this->t_01->Required) {
			if (!$this->t_01->IsDetailKey && $this->t_01->FormValue != NULL && $this->t_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_01->caption(), $this->t_01->RequiredErrorMessage));
			}
		}
		if ($this->t_02->Required) {
			if (!$this->t_02->IsDetailKey && $this->t_02->FormValue != NULL && $this->t_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_02->caption(), $this->t_02->RequiredErrorMessage));
			}
		}
		if ($this->t_03->Required) {
			if ($this->t_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_03->caption(), $this->t_03->RequiredErrorMessage));
			}
		}
		if ($this->t_04->Required) {
			if ($this->t_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_04->caption(), $this->t_04->RequiredErrorMessage));
			}
		}
		if ($this->t_05->Required) {
			if ($this->t_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_05->caption(), $this->t_05->RequiredErrorMessage));
			}
		}
		if ($this->t_06->Required) {
			if ($this->t_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_06->caption(), $this->t_06->RequiredErrorMessage));
			}
		}
		if ($this->t_07->Required) {
			if ($this->t_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_07->caption(), $this->t_07->RequiredErrorMessage));
			}
		}
		if ($this->t_08->Required) {
			if ($this->t_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_08->caption(), $this->t_08->RequiredErrorMessage));
			}
		}
		if ($this->t_09->Required) {
			if ($this->t_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_09->caption(), $this->t_09->RequiredErrorMessage));
			}
		}
		if ($this->t_10->Required) {
			if ($this->t_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_10->caption(), $this->t_10->RequiredErrorMessage));
			}
		}
		if ($this->t_11->Required) {
			if (!$this->t_11->IsDetailKey && $this->t_11->FormValue != NULL && $this->t_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_11->caption(), $this->t_11->RequiredErrorMessage));
			}
		}
		if ($this->t_12->Required) {
			if (!$this->t_12->IsDetailKey && $this->t_12->FormValue != NULL && $this->t_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_12->caption(), $this->t_12->RequiredErrorMessage));
			}
		}
		if ($this->t_13->Required) {
			if (!$this->t_13->IsDetailKey && $this->t_13->FormValue != NULL && $this->t_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_13->caption(), $this->t_13->RequiredErrorMessage));
			}
		}
		if ($this->t_14->Required) {
			if (!$this->t_14->IsDetailKey && $this->t_14->FormValue != NULL && $this->t_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_14->caption(), $this->t_14->RequiredErrorMessage));
			}
		}
		if ($this->t_15->Required) {
			if (!$this->t_15->IsDetailKey && $this->t_15->FormValue != NULL && $this->t_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_15->caption(), $this->t_15->RequiredErrorMessage));
			}
		}
		if ($this->d_head_01->Required) {
			if (!$this->d_head_01->IsDetailKey && $this->d_head_01->FormValue != NULL && $this->d_head_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_head_01->caption(), $this->d_head_01->RequiredErrorMessage));
			}
		}
		if ($this->d_description_01->Required) {
			if (!$this->d_description_01->IsDetailKey && $this->d_description_01->FormValue != NULL && $this->d_description_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_description_01->caption(), $this->d_description_01->RequiredErrorMessage));
			}
		}
		if ($this->d_head_02->Required) {
			if (!$this->d_head_02->IsDetailKey && $this->d_head_02->FormValue != NULL && $this->d_head_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_head_02->caption(), $this->d_head_02->RequiredErrorMessage));
			}
		}
		if ($this->d_description_02->Required) {
			if (!$this->d_description_02->IsDetailKey && $this->d_description_02->FormValue != NULL && $this->d_description_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_description_02->caption(), $this->d_description_02->RequiredErrorMessage));
			}
		}
		if ($this->main_image->Required) {
			if ($this->main_image->Upload->FileName == "" && !$this->main_image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->main_image->caption(), $this->main_image->RequiredErrorMessage));
			}
		}
		if ($this->top_view->Required) {
			if ($this->top_view->Upload->FileName == "" && !$this->top_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->top_view->caption(), $this->top_view->RequiredErrorMessage));
			}
		}
		if ($this->front_view->Required) {
			if ($this->front_view->Upload->FileName == "" && !$this->front_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->front_view->caption(), $this->front_view->RequiredErrorMessage));
			}
		}
		if ($this->corner_view->Required) {
			if ($this->corner_view->Upload->FileName == "" && !$this->corner_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->corner_view->caption(), $this->corner_view->RequiredErrorMessage));
			}
		}
		if ($this->back_view->Required) {
			if ($this->back_view->Upload->FileName == "" && !$this->back_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->back_view->caption(), $this->back_view->RequiredErrorMessage));
			}
		}
		if ($this->color_options->Required) {
			if ($this->color_options->Upload->FileName == "" && !$this->color_options->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->color_options->caption(), $this->color_options->RequiredErrorMessage));
			}
		}
		if ($this->other_options->Required) {
			if ($this->other_options->Upload->FileName == "" && !$this->other_options->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->other_options->caption(), $this->other_options->RequiredErrorMessage));
			}
		}
		if ($this->group_image->Required) {
			if ($this->group_image->Upload->FileName == "" && !$this->group_image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->group_image->caption(), $this->group_image->RequiredErrorMessage));
			}
		}
		if ($this->video_url->Required) {
			if (!$this->video_url->IsDetailKey && $this->video_url->FormValue != NULL && $this->video_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->video_url->caption(), $this->video_url->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->last_price->Required) {
			if (!$this->last_price->IsDetailKey && $this->last_price->FormValue != NULL && $this->last_price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_price->caption(), $this->last_price->RequiredErrorMessage));
			}
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->hsn->Required) {
			if (!$this->hsn->IsDetailKey && $this->hsn->FormValue != NULL && $this->hsn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
			}
		}
		if ($this->composition->Required) {
			if (!$this->composition->IsDetailKey && $this->composition->FormValue != NULL && $this->composition->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
			}
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->moq->Required) {
			if (!$this->moq->IsDetailKey && $this->moq->FormValue != NULL && $this->moq->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->moq->caption(), $this->moq->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->moq->FormValue)) {
			AddMessage($FormError, $this->moq->errorMessage());
		}
		if ($this->in->Required) {
			if (!$this->in->IsDetailKey && $this->in->FormValue != NULL && $this->in->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->in->caption(), $this->in->RequiredErrorMessage));
			}
		}
		if ($this->out->Required) {
			if (!$this->out->IsDetailKey && $this->out->FormValue != NULL && $this->out->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->out->caption(), $this->out->RequiredErrorMessage));
			}
		}
		if ($this->required->Required) {
			if (!$this->required->IsDetailKey && $this->required->FormValue != NULL && $this->required->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->required->caption(), $this->required->RequiredErrorMessage));
			}
		}
		if ($this->blocked->Required) {
			if (!$this->blocked->IsDetailKey && $this->blocked->FormValue != NULL && $this->blocked->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->blocked->caption(), $this->blocked->RequiredErrorMessage));
			}
		}
		if ($this->ordered->Required) {
			if (!$this->ordered->IsDetailKey && $this->ordered->FormValue != NULL && $this->ordered->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ordered->caption(), $this->ordered->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->publish->Required) {
			if (!$this->publish->IsDetailKey && $this->publish->FormValue != NULL && $this->publish->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->publish->caption(), $this->publish->RequiredErrorMessage));
			}
		}
		if ($this->keywords->Required) {
			if (!$this->keywords->IsDetailKey && $this->keywords->FormValue != NULL && $this->keywords->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->keywords->caption(), $this->keywords->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->supplier->Required) {
			if (!$this->supplier->IsDetailKey && $this->supplier->FormValue != NULL && $this->supplier->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
			}
		}
		if ($this->country->Required) {
			if (!$this->country->IsDetailKey && $this->country->FormValue != NULL && $this->country->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
			}
		}
		if ($this->minimum_stock->Required) {
			if (!$this->minimum_stock->IsDetailKey && $this->minimum_stock->FormValue != NULL && $this->minimum_stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->minimum_stock->caption(), $this->minimum_stock->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("multiple_price", $detailTblVar) && $GLOBALS["multiple_price"]->DetailEdit) {
			if (!isset($GLOBALS["multiple_price_grid"]))
				$GLOBALS["multiple_price_grid"] = new multiple_price_grid(); // Get detail page object
			$GLOBALS["multiple_price_grid"]->validateGridForm();
		}
		if (in_array("partner_product_ref", $detailTblVar) && $GLOBALS["partner_product_ref"]->DetailEdit) {
			if (!isset($GLOBALS["partner_product_ref_grid"]))
				$GLOBALS["partner_product_ref_grid"] = new partner_product_ref_grid(); // Get detail page object
			$GLOBALS["partner_product_ref_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->product_code->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`product_code` = '" . AdjustSql($this->product_code->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->product_code->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->product_code->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() <> "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->main_image->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->main_image->UploadPath = $this->main_image->OldUploadPath;
			$this->top_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->top_view->UploadPath = $this->top_view->OldUploadPath;
			$this->front_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->front_view->UploadPath = $this->front_view->OldUploadPath;
			$this->corner_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
			$this->back_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->back_view->UploadPath = $this->back_view->OldUploadPath;
			$this->color_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->color_options->UploadPath = $this->color_options->OldUploadPath;
			$this->other_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->other_options->UploadPath = $this->other_options->OldUploadPath;
			$this->group_image->OldUploadPath = '/product_images/o/group_image/' ;
			$this->group_image->UploadPath = $this->group_image->OldUploadPath;
			$this->image->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->image->UploadPath = $this->image->OldUploadPath;
			$rsnew = [];

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// grp
			$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, $this->grp->ReadOnly);

			// s_grp
			$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, $this->s_grp->ReadOnly);

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, $this->product->ReadOnly);

			// product_type
			$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, NULL, $this->product_type->ReadOnly);

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, $this->packing_type->ReadOnly);

			// product_n
			$this->product_n->setDbValueDef($rsnew, $this->product_n->CurrentValue, NULL, $this->product_n->ReadOnly);

			// barcode
			$this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, NULL, $this->_barcode->ReadOnly);

			// product_code_type
			$this->product_code_type->setDbValueDef($rsnew, $this->product_code_type->CurrentValue, 0, $this->product_code_type->ReadOnly);

			// product_code
			$this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, NULL, $this->product_code->ReadOnly);

			// set_ref
			$this->set_ref->setDbValueDef($rsnew, $this->set_ref->CurrentValue, NULL, $this->set_ref->ReadOnly);

			// v_00
			$this->v_00->setDbValueDef($rsnew, $this->v_00->CurrentValue, NULL, $this->v_00->ReadOnly);

			// v_01
			$this->v_01->setDbValueDef($rsnew, $this->v_01->CurrentValue, NULL, $this->v_01->ReadOnly);

			// v_02
			$this->v_02->setDbValueDef($rsnew, $this->v_02->CurrentValue, NULL, $this->v_02->ReadOnly);

			// v_03
			$this->v_03->setDbValueDef($rsnew, $this->v_03->CurrentValue, NULL, $this->v_03->ReadOnly);

			// v_04
			$this->v_04->setDbValueDef($rsnew, $this->v_04->CurrentValue, NULL, $this->v_04->ReadOnly);

			// v_05
			$this->v_05->setDbValueDef($rsnew, $this->v_05->CurrentValue, NULL, $this->v_05->ReadOnly);

			// v_06
			$this->v_06->setDbValueDef($rsnew, $this->v_06->CurrentValue, NULL, $this->v_06->ReadOnly);

			// v_07
			$this->v_07->setDbValueDef($rsnew, $this->v_07->CurrentValue, NULL, $this->v_07->ReadOnly);

			// v_08
			$this->v_08->setDbValueDef($rsnew, $this->v_08->CurrentValue, NULL, $this->v_08->ReadOnly);

			// v_09
			$this->v_09->setDbValueDef($rsnew, $this->v_09->CurrentValue, NULL, $this->v_09->ReadOnly);

			// v_10
			$this->v_10->setDbValueDef($rsnew, $this->v_10->CurrentValue, NULL, $this->v_10->ReadOnly);

			// cbm
			$this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, NULL, $this->cbm->ReadOnly);

			// sqm
			$this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, NULL, $this->sqm->ReadOnly);

			// shape
			$this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, NULL, $this->shape->ReadOnly);

			// q_sku
			$this->q_sku->setDbValueDef($rsnew, $this->q_sku->CurrentValue, 0, $this->q_sku->ReadOnly);

			// b_01
			$this->b_01->setDbValueDef($rsnew, $this->b_01->CurrentValue, NULL, $this->b_01->ReadOnly);

			// b_02
			$this->b_02->setDbValueDef($rsnew, $this->b_02->CurrentValue, NULL, $this->b_02->ReadOnly);

			// b_03
			$this->b_03->setDbValueDef($rsnew, $this->b_03->CurrentValue, NULL, $this->b_03->ReadOnly);

			// b_04
			$this->b_04->setDbValueDef($rsnew, $this->b_04->CurrentValue, NULL, $this->b_04->ReadOnly);

			// b_05
			$this->b_05->setDbValueDef($rsnew, $this->b_05->CurrentValue, NULL, $this->b_05->ReadOnly);

			// b_06
			$this->b_06->setDbValueDef($rsnew, $this->b_06->CurrentValue, NULL, $this->b_06->ReadOnly);

			// b_07
			$this->b_07->setDbValueDef($rsnew, $this->b_07->CurrentValue, NULL, $this->b_07->ReadOnly);

			// b_08
			$this->b_08->setDbValueDef($rsnew, $this->b_08->CurrentValue, NULL, $this->b_08->ReadOnly);

			// b_09
			$this->b_09->setDbValueDef($rsnew, $this->b_09->CurrentValue, NULL, $this->b_09->ReadOnly);

			// b_10
			$this->b_10->setDbValueDef($rsnew, $this->b_10->CurrentValue, NULL, $this->b_10->ReadOnly);

			// b_11
			$this->b_11->setDbValueDef($rsnew, $this->b_11->CurrentValue, NULL, $this->b_11->ReadOnly);

			// b_12
			$this->b_12->setDbValueDef($rsnew, $this->b_12->CurrentValue, NULL, $this->b_12->ReadOnly);

			// b_13
			$this->b_13->setDbValueDef($rsnew, $this->b_13->CurrentValue, NULL, $this->b_13->ReadOnly);

			// b_14
			$this->b_14->setDbValueDef($rsnew, $this->b_14->CurrentValue, NULL, $this->b_14->ReadOnly);

			// b_15
			$this->b_15->setDbValueDef($rsnew, $this->b_15->CurrentValue, NULL, $this->b_15->ReadOnly);

			// t_01
			$this->t_01->setDbValueDef($rsnew, $this->t_01->CurrentValue, NULL, $this->t_01->ReadOnly);

			// t_02
			$this->t_02->setDbValueDef($rsnew, $this->t_02->CurrentValue, NULL, $this->t_02->ReadOnly);

			// t_03
			$this->t_03->setDbValueDef($rsnew, $this->t_03->CurrentValue, NULL, $this->t_03->ReadOnly);

			// t_04
			$this->t_04->setDbValueDef($rsnew, $this->t_04->CurrentValue, NULL, $this->t_04->ReadOnly);

			// t_05
			$this->t_05->setDbValueDef($rsnew, $this->t_05->CurrentValue, NULL, $this->t_05->ReadOnly);

			// t_06
			$this->t_06->setDbValueDef($rsnew, $this->t_06->CurrentValue, NULL, $this->t_06->ReadOnly);

			// t_07
			$this->t_07->setDbValueDef($rsnew, $this->t_07->CurrentValue, NULL, $this->t_07->ReadOnly);

			// t_08
			$this->t_08->setDbValueDef($rsnew, $this->t_08->CurrentValue, NULL, $this->t_08->ReadOnly);

			// t_09
			$this->t_09->setDbValueDef($rsnew, $this->t_09->CurrentValue, NULL, $this->t_09->ReadOnly);

			// t_10
			$this->t_10->setDbValueDef($rsnew, $this->t_10->CurrentValue, NULL, $this->t_10->ReadOnly);

			// t_11
			$this->t_11->setDbValueDef($rsnew, $this->t_11->CurrentValue, NULL, $this->t_11->ReadOnly);

			// t_12
			$this->t_12->setDbValueDef($rsnew, $this->t_12->CurrentValue, NULL, $this->t_12->ReadOnly);

			// t_13
			$this->t_13->setDbValueDef($rsnew, $this->t_13->CurrentValue, NULL, $this->t_13->ReadOnly);

			// t_14
			$this->t_14->setDbValueDef($rsnew, $this->t_14->CurrentValue, NULL, $this->t_14->ReadOnly);

			// t_15
			$this->t_15->setDbValueDef($rsnew, $this->t_15->CurrentValue, NULL, $this->t_15->ReadOnly);

			// d_head_01
			$this->d_head_01->setDbValueDef($rsnew, $this->d_head_01->CurrentValue, NULL, $this->d_head_01->ReadOnly);

			// d_description_01
			$this->d_description_01->setDbValueDef($rsnew, $this->d_description_01->CurrentValue, NULL, $this->d_description_01->ReadOnly);

			// d_head_02
			$this->d_head_02->setDbValueDef($rsnew, $this->d_head_02->CurrentValue, NULL, $this->d_head_02->ReadOnly);

			// d_description_02
			$this->d_description_02->setDbValueDef($rsnew, $this->d_description_02->CurrentValue, NULL, $this->d_description_02->ReadOnly);

			// main_image
			if ($this->main_image->Visible && !$this->main_image->ReadOnly && !$this->main_image->Upload->KeepFile) {
				$this->main_image->Upload->DbValue = $rsold['main_image']; // Get original value
				if ($this->main_image->Upload->FileName == "") {
					$rsnew['main_image'] = NULL;
				} else {
					$rsnew['main_image'] = $this->main_image->Upload->FileName;
				}
				$this->main_image->ImageWidth = 640; // Resize width
				$this->main_image->ImageHeight = 640; // Resize height
			}

			// top_view
			if ($this->top_view->Visible && !$this->top_view->ReadOnly && !$this->top_view->Upload->KeepFile) {
				$this->top_view->Upload->DbValue = $rsold['top_view']; // Get original value
				if ($this->top_view->Upload->FileName == "") {
					$rsnew['top_view'] = NULL;
				} else {
					$rsnew['top_view'] = $this->top_view->Upload->FileName;
				}
				$this->top_view->ImageWidth = 640; // Resize width
				$this->top_view->ImageHeight = 640; // Resize height
			}

			// front_view
			if ($this->front_view->Visible && !$this->front_view->ReadOnly && !$this->front_view->Upload->KeepFile) {
				$this->front_view->Upload->DbValue = $rsold['front_view']; // Get original value
				if ($this->front_view->Upload->FileName == "") {
					$rsnew['front_view'] = NULL;
				} else {
					$rsnew['front_view'] = $this->front_view->Upload->FileName;
				}
				$this->front_view->ImageWidth = 640; // Resize width
				$this->front_view->ImageHeight = 640; // Resize height
			}

			// corner_view
			if ($this->corner_view->Visible && !$this->corner_view->ReadOnly && !$this->corner_view->Upload->KeepFile) {
				$this->corner_view->Upload->DbValue = $rsold['corner_view']; // Get original value
				if ($this->corner_view->Upload->FileName == "") {
					$rsnew['corner_view'] = NULL;
				} else {
					$rsnew['corner_view'] = $this->corner_view->Upload->FileName;
				}
				$this->corner_view->ImageWidth = 640; // Resize width
				$this->corner_view->ImageHeight = 640; // Resize height
			}

			// back_view
			if ($this->back_view->Visible && !$this->back_view->ReadOnly && !$this->back_view->Upload->KeepFile) {
				$this->back_view->Upload->DbValue = $rsold['back_view']; // Get original value
				if ($this->back_view->Upload->FileName == "") {
					$rsnew['back_view'] = NULL;
				} else {
					$rsnew['back_view'] = $this->back_view->Upload->FileName;
				}
				$this->back_view->ImageWidth = 640; // Resize width
				$this->back_view->ImageHeight = 640; // Resize height
			}

			// color_options
			if ($this->color_options->Visible && !$this->color_options->ReadOnly && !$this->color_options->Upload->KeepFile) {
				$this->color_options->Upload->DbValue = $rsold['color_options']; // Get original value
				if ($this->color_options->Upload->FileName == "") {
					$rsnew['color_options'] = NULL;
				} else {
					$rsnew['color_options'] = $this->color_options->Upload->FileName;
				}
				$this->color_options->ImageWidth = 640; // Resize width
				$this->color_options->ImageHeight = 640; // Resize height
			}

			// other_options
			if ($this->other_options->Visible && !$this->other_options->ReadOnly && !$this->other_options->Upload->KeepFile) {
				$this->other_options->Upload->DbValue = $rsold['other_options']; // Get original value
				if ($this->other_options->Upload->FileName == "") {
					$rsnew['other_options'] = NULL;
				} else {
					$rsnew['other_options'] = $this->other_options->Upload->FileName;
				}
				$this->other_options->ImageWidth = 640; // Resize width
				$this->other_options->ImageHeight = 640; // Resize height
			}

			// group_image
			if ($this->group_image->Visible && !$this->group_image->ReadOnly && !$this->group_image->Upload->KeepFile) {
				$this->group_image->Upload->DbValue = $rsold['group_image']; // Get original value
				if ($this->group_image->Upload->FileName == "") {
					$rsnew['group_image'] = NULL;
				} else {
					$rsnew['group_image'] = $this->group_image->Upload->FileName;
				}
				$this->group_image->ImageWidth = 700; // Resize width
				$this->group_image->ImageHeight = 700; // Resize height
			}

			// video_url
			$this->video_url->setDbValueDef($rsnew, $this->video_url->CurrentValue, NULL, $this->video_url->ReadOnly);

			// image
			if ($this->image->Visible && !$this->image->ReadOnly && !$this->image->Upload->KeepFile) {
				$this->image->Upload->DbValue = $rsold['image']; // Get original value
				if ($this->image->Upload->FileName == "") {
					$rsnew['image'] = NULL;
				} else {
					$rsnew['image'] = $this->image->Upload->FileName;
				}
				$this->image->ImageWidth = 640; // Resize width
				$this->image->ImageHeight = 640; // Resize height
			}

			// currency
			$this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, 0, $this->currency->ReadOnly);

			// hsn
			$this->hsn->setDbValueDef($rsnew, $this->hsn->CurrentValue, NULL, $this->hsn->ReadOnly);

			// composition
			$this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, NULL, $this->composition->ReadOnly);

			// category
			$this->category->setDbValueDef($rsnew, $this->category->CurrentValue, NULL, $this->category->ReadOnly);

			// moq
			$this->moq->setDbValueDef($rsnew, $this->moq->CurrentValue, NULL, $this->moq->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, $this->status->ReadOnly);

			// publish
			$this->publish->setDbValueDef($rsnew, $this->publish->CurrentValue, NULL, $this->publish->ReadOnly);

			// keywords
			$this->keywords->setDbValueDef($rsnew, $this->keywords->CurrentValue, NULL, $this->keywords->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;
			if ($this->main_image->Visible && !$this->main_image->Upload->KeepFile) {
				$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->main_image->Upload->DbValue) ? array() : array($this->main_image->Upload->DbValue);
				if (!EmptyValue($this->main_image->Upload->FileName)) {
					$newFiles = array($this->main_image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->main_image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file1) || file_exists($this->main_image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->main_image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file, UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->main_image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->main_image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->main_image->setDbValueDef($rsnew, $this->main_image->Upload->FileName, NULL, $this->main_image->ReadOnly);
				}
			}
			if ($this->top_view->Visible && !$this->top_view->Upload->KeepFile) {
				$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->top_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->top_view->Upload->DbValue));
				if (!EmptyValue($this->top_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->top_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->top_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file1) || file_exists($this->top_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->top_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file, UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->top_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->top_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->top_view->setDbValueDef($rsnew, $this->top_view->Upload->FileName, NULL, $this->top_view->ReadOnly);
				}
			}
			if ($this->front_view->Visible && !$this->front_view->Upload->KeepFile) {
				$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->front_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->front_view->Upload->DbValue));
				if (!EmptyValue($this->front_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->front_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->front_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file1) || file_exists($this->front_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->front_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file, UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->front_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->front_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->front_view->setDbValueDef($rsnew, $this->front_view->Upload->FileName, NULL, $this->front_view->ReadOnly);
				}
			}
			if ($this->corner_view->Visible && !$this->corner_view->Upload->KeepFile) {
				$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->corner_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->corner_view->Upload->DbValue));
				if (!EmptyValue($this->corner_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->corner_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->corner_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file1) || file_exists($this->corner_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->corner_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file, UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->corner_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->corner_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->corner_view->setDbValueDef($rsnew, $this->corner_view->Upload->FileName, NULL, $this->corner_view->ReadOnly);
				}
			}
			if ($this->back_view->Visible && !$this->back_view->Upload->KeepFile) {
				$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->back_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->back_view->Upload->DbValue));
				if (!EmptyValue($this->back_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->back_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->back_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file1) || file_exists($this->back_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->back_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file, UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->back_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->back_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->back_view->setDbValueDef($rsnew, $this->back_view->Upload->FileName, NULL, $this->back_view->ReadOnly);
				}
			}
			if ($this->color_options->Visible && !$this->color_options->Upload->KeepFile) {
				$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->color_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->color_options->Upload->DbValue));
				if (!EmptyValue($this->color_options->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->color_options->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->color_options->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file1) || file_exists($this->color_options->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->color_options->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file, UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->color_options->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->color_options->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->color_options->setDbValueDef($rsnew, $this->color_options->Upload->FileName, NULL, $this->color_options->ReadOnly);
				}
			}
			if ($this->other_options->Visible && !$this->other_options->Upload->KeepFile) {
				$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->other_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->other_options->Upload->DbValue));
				if (!EmptyValue($this->other_options->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->other_options->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->other_options->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file1) || file_exists($this->other_options->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->other_options->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file, UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->other_options->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->other_options->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->other_options->setDbValueDef($rsnew, $this->other_options->Upload->FileName, NULL, $this->other_options->ReadOnly);
				}
			}
			if ($this->group_image->Visible && !$this->group_image->Upload->KeepFile) {
				$this->group_image->UploadPath = '/product_images/o/group_image/' ;
				$oldFiles = EmptyValue($this->group_image->Upload->DbValue) ? array() : array($this->group_image->Upload->DbValue);
				if (!EmptyValue($this->group_image->Upload->FileName)) {
					$newFiles = array($this->group_image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->group_image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file1) || file_exists($this->group_image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->group_image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file, UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->group_image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->group_image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->group_image->setDbValueDef($rsnew, $this->group_image->Upload->FileName, NULL, $this->group_image->ReadOnly);
				}
			}
			if ($this->image->Visible && !$this->image->Upload->KeepFile) {
				$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->image->Upload->DbValue));
				if (!EmptyValue($this->image->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->image->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file1) || file_exists($this->image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->image, $this->image->Upload->Index) . $file, UploadTempPath($this->image, $this->image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, NULL, $this->image->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->main_image->Visible && !$this->main_image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->main_image->Upload->DbValue) ? array() : array($this->main_image->Upload->DbValue);
						if (!EmptyValue($this->main_image->Upload->FileName)) {
							$newFiles = array($this->main_image->Upload->FileName);
							$newFiles2 = array($rsnew['main_image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->main_image->Upload->resizeAndSaveToFile($this->main_image->ImageWidth, $this->main_image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->main_image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->top_view->Visible && !$this->top_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->top_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->top_view->Upload->DbValue));
						if (!EmptyValue($this->top_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->top_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['top_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->top_view->Upload->resizeAndSaveToFile($this->top_view->ImageWidth, $this->top_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->top_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->front_view->Visible && !$this->front_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->front_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->front_view->Upload->DbValue));
						if (!EmptyValue($this->front_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->front_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['front_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->front_view->Upload->resizeAndSaveToFile($this->front_view->ImageWidth, $this->front_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->front_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->corner_view->Visible && !$this->corner_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->corner_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->corner_view->Upload->DbValue));
						if (!EmptyValue($this->corner_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->corner_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['corner_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->corner_view->Upload->resizeAndSaveToFile($this->corner_view->ImageWidth, $this->corner_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->corner_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->back_view->Visible && !$this->back_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->back_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->back_view->Upload->DbValue));
						if (!EmptyValue($this->back_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->back_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['back_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->back_view->Upload->resizeAndSaveToFile($this->back_view->ImageWidth, $this->back_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->back_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->color_options->Visible && !$this->color_options->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->color_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->color_options->Upload->DbValue));
						if (!EmptyValue($this->color_options->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->color_options->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['color_options']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->color_options->Upload->resizeAndSaveToFile($this->color_options->ImageWidth, $this->color_options->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->color_options->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->other_options->Visible && !$this->other_options->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->other_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->other_options->Upload->DbValue));
						if (!EmptyValue($this->other_options->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->other_options->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['other_options']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->other_options->Upload->resizeAndSaveToFile($this->other_options->ImageWidth, $this->other_options->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->other_options->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->group_image->Visible && !$this->group_image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->group_image->Upload->DbValue) ? array() : array($this->group_image->Upload->DbValue);
						if (!EmptyValue($this->group_image->Upload->FileName)) {
							$newFiles = array($this->group_image->Upload->FileName);
							$newFiles2 = array($rsnew['group_image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->group_image->Upload->resizeAndSaveToFile($this->group_image->ImageWidth, $this->group_image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->group_image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->image->Visible && !$this->image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->image->Upload->DbValue));
						if (!EmptyValue($this->image->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->image->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->image->Upload->resizeAndSaveToFile($this->image->ImageWidth, $this->image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("multiple_price", $detailTblVar) && $GLOBALS["multiple_price"]->DetailEdit) {
						if (!isset($GLOBALS["multiple_price_grid"]))
							$GLOBALS["multiple_price_grid"] = new multiple_price_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "multiple_price"); // Load user level of detail table
						$editRow = $GLOBALS["multiple_price_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("partner_product_ref", $detailTblVar) && $GLOBALS["partner_product_ref"]->DetailEdit) {
						if (!isset($GLOBALS["partner_product_ref_grid"]))
							$GLOBALS["partner_product_ref_grid"] = new partner_product_ref_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "partner_product_ref"); // Load user level of detail table
						$editRow = $GLOBALS["partner_product_ref_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() <> "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// main_image
		if ($this->main_image->Upload->FileToken <> "")
			CleanUploadTempPath($this->main_image->Upload->FileToken, $this->main_image->Upload->Index);
		else
			CleanUploadTempPath($this->main_image, $this->main_image->Upload->Index);

		// top_view
		if ($this->top_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->top_view->Upload->FileToken, $this->top_view->Upload->Index);
		else
			CleanUploadTempPath($this->top_view, $this->top_view->Upload->Index);

		// front_view
		if ($this->front_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->front_view->Upload->FileToken, $this->front_view->Upload->Index);
		else
			CleanUploadTempPath($this->front_view, $this->front_view->Upload->Index);

		// corner_view
		if ($this->corner_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->corner_view->Upload->FileToken, $this->corner_view->Upload->Index);
		else
			CleanUploadTempPath($this->corner_view, $this->corner_view->Upload->Index);

		// back_view
		if ($this->back_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->back_view->Upload->FileToken, $this->back_view->Upload->Index);
		else
			CleanUploadTempPath($this->back_view, $this->back_view->Upload->Index);

		// color_options
		if ($this->color_options->Upload->FileToken <> "")
			CleanUploadTempPath($this->color_options->Upload->FileToken, $this->color_options->Upload->Index);
		else
			CleanUploadTempPath($this->color_options, $this->color_options->Upload->Index);

		// other_options
		if ($this->other_options->Upload->FileToken <> "")
			CleanUploadTempPath($this->other_options->Upload->FileToken, $this->other_options->Upload->Index);
		else
			CleanUploadTempPath($this->other_options, $this->other_options->Upload->Index);

		// group_image
		if ($this->group_image->Upload->FileToken <> "")
			CleanUploadTempPath($this->group_image->Upload->FileToken, $this->group_image->Upload->Index);
		else
			CleanUploadTempPath($this->group_image, $this->group_image->Upload->Index);

		// image
		if ($this->image->Upload->FileToken <> "")
			CleanUploadTempPath($this->image->Upload->FileToken, $this->image->Upload->Index);
		else
			CleanUploadTempPath($this->image, $this->image->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("multiple_price", $detailTblVar)) {
				if (!isset($GLOBALS["multiple_price_grid"]))
					$GLOBALS["multiple_price_grid"] = new multiple_price_grid();
				if ($GLOBALS["multiple_price_grid"]->DetailEdit) {
					$GLOBALS["multiple_price_grid"]->CurrentMode = "edit";
					$GLOBALS["multiple_price_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["multiple_price_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["multiple_price_grid"]->setStartRecordNumber(1);
					$GLOBALS["multiple_price_grid"]->code->IsDetailKey = TRUE;
					$GLOBALS["multiple_price_grid"]->code->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["multiple_price_grid"]->code->setSessionValue($GLOBALS["multiple_price_grid"]->code->CurrentValue);
				}
			}
			if (in_array("partner_product_ref", $detailTblVar)) {
				if (!isset($GLOBALS["partner_product_ref_grid"]))
					$GLOBALS["partner_product_ref_grid"] = new partner_product_ref_grid();
				if ($GLOBALS["partner_product_ref_grid"]->DetailEdit) {
					$GLOBALS["partner_product_ref_grid"]->CurrentMode = "edit";
					$GLOBALS["partner_product_ref_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["partner_product_ref_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["partner_product_ref_grid"]->setStartRecordNumber(1);
					$GLOBALS["partner_product_ref_grid"]->rid->IsDetailKey = TRUE;
					$GLOBALS["partner_product_ref_grid"]->rid->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["partner_product_ref_grid"]->rid->setSessionValue($GLOBALS["partner_product_ref_grid"]->rid->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("reflist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` >= 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` >= 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_set_ref":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_01":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_02":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_11":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_12":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_hsn":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_composition":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_type":
							break;
						case "x_packing_type":
							break;
						case "x_set_ref":
							break;
						case "x_v_01":
							break;
						case "x_v_02":
							break;
						case "x_v_03":
							break;
						case "x_v_04":
							break;
						case "x_v_05":
							break;
						case "x_v_06":
							break;
						case "x_v_07":
							break;
						case "x_v_08":
							break;
						case "x_v_09":
							break;
						case "x_v_10":
							break;
						case "x_shape":
							break;
						case "x_b_03":
							break;
						case "x_b_04":
							break;
						case "x_b_05":
							break;
						case "x_b_06":
							break;
						case "x_b_07":
							break;
						case "x_b_08":
							break;
						case "x_b_09":
							break;
						case "x_b_10":
							break;
						case "x_t_03":
							break;
						case "x_t_04":
							break;
						case "x_t_05":
							break;
						case "x_t_06":
							break;
						case "x_t_07":
							break;
						case "x_t_08":
							break;
						case "x_t_09":
							break;
						case "x_t_10":
							break;
						case "x_t_11":
							break;
						case "x_t_12":
							break;
						case "x_currency":
							break;
						case "x_hsn":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_composition":
							break;
						case "x_category":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'ref');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		extract($_POST,EXTR_OVERWRITE);
		$Head = ExecuteRow("SELECT `v_01`, `v_02`, `v_03`, `v_04`, `v_05`, `v_06`, `v_07`, `v_08`, `v_09`, `v_10`, `b_01_head`, `b_02_head`, `b_03_head`, `b_04_head`, `b_05_head`, `b_06_head`, `b_07_head`, `b_08_head`,`b_09_head`,`b_10_head`,`b_11_head`,`b_12_head`, `b_13_head`,`b_14_head`,`b_15_head`, `t_01_head`, `t_02_head`, `t_03_head`, `t_04_head`, `t_05_head`, `t_06_head`, `t_07_head`,  `t_08_head`, `t_09_head`,`t_10_head`,`t_11_head`,`t_12_head`, `t_13_head`,`t_14_head`,`t_15_head` FROM `product_group` WHERE `id` = $x_s_grp LIMIT 1");
	$_SESSION[SESSION_WARNING_MESSAGE] = '';
			if  ((($x_v_01 == null) ? '0' : count($x_v_01)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_01']. "<br>";
			}
			if  ((($x_v_02 == null) ? '0' : count($x_v_02)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_02']. "<br>";
			}
			if  ((($x_v_03 == null) ? '0' : count($x_v_03)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_03']. "<br>";
			}
			if  ((($x_v_04 == null) ? '0' : count($x_v_04)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_04']. "<br>";
			}
			if  ((($x_v_05 == null) ? '0' : count($x_v_05)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_05']. "<br>";
			}
			if  ((($x_v_06 == null) ? '0' : count($x_v_06)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_06']. "<br>";
			}
			if  ((($x_v_07 == null) ? '0' : count($x_v_07)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_07']. "<br>";
			}
			if  ((($x_v_08 == null) ? '0' : count($x_v_08)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_08']. "<br>";
			}
			if  ((($x_v_09 == null) ? '0' : count($x_v_09)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_09']. "<br>";
			}
			if  ((($x_v_10 == null) ? '0' : count($x_v_10)) >1)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Single Value for " .$Head['v_10']. "<br>";
			}
			if (($x_product_tpye) == 9)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Selection of Product Specification is not Allowed. <br>";
			}
			if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
			{return TRUE;}
			else
			{return FALSE;}
	}
}
?>