<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for ref_image
 */
class ref_image extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $grp;
	public $s_grp;
	public $product;
	public $product_code;
	public $main_image;
	public $top_view;
	public $front_view;
	public $corner_view;
	public $back_view;
	public $color_options;
	public $other_options;
	public $video_url;
	public $group_image;
	public $status;
	public $company_id;
	public $product_type;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'ref_image';
		$this->TableName = 'ref_image';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`ref_image`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('ref_image', 'ref_image', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// grp
		$this->grp = new DbField('ref_image', 'ref_image', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('ref_image', 'ref_image', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('ref_image', 'ref_image', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp[]"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// product_code
		$this->product_code = new DbField('ref_image', 'ref_image', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// main_image
		$this->main_image = new DbField('ref_image', 'ref_image', 'x_main_image', 'main_image', '`main_image`', '`main_image`', 200, -1, TRUE, '`main_image`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->main_image->Sortable = TRUE; // Allow sort
		$this->main_image->ImageResize = TRUE;
		$this->fields['main_image'] = &$this->main_image;

		// top_view
		$this->top_view = new DbField('ref_image', 'ref_image', 'x_top_view', 'top_view', '`top_view`', '`top_view`', 200, -1, TRUE, '`top_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->top_view->Sortable = TRUE; // Allow sort
		$this->top_view->ImageResize = TRUE;
		$this->top_view->UploadMultiple = TRUE;
		$this->top_view->Upload->UploadMultiple = TRUE;
		$this->top_view->UploadMaxFileCount = 0;
		$this->fields['top_view'] = &$this->top_view;

		// front_view
		$this->front_view = new DbField('ref_image', 'ref_image', 'x_front_view', 'front_view', '`front_view`', '`front_view`', 200, -1, TRUE, '`front_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->front_view->Sortable = TRUE; // Allow sort
		$this->front_view->ImageResize = TRUE;
		$this->front_view->UploadMultiple = TRUE;
		$this->front_view->Upload->UploadMultiple = TRUE;
		$this->front_view->UploadMaxFileCount = 0;
		$this->fields['front_view'] = &$this->front_view;

		// corner_view
		$this->corner_view = new DbField('ref_image', 'ref_image', 'x_corner_view', 'corner_view', '`corner_view`', '`corner_view`', 200, -1, TRUE, '`corner_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->corner_view->Sortable = TRUE; // Allow sort
		$this->corner_view->ImageResize = TRUE;
		$this->corner_view->UploadMultiple = TRUE;
		$this->corner_view->Upload->UploadMultiple = TRUE;
		$this->corner_view->UploadMaxFileCount = 0;
		$this->fields['corner_view'] = &$this->corner_view;

		// back_view
		$this->back_view = new DbField('ref_image', 'ref_image', 'x_back_view', 'back_view', '`back_view`', '`back_view`', 200, -1, TRUE, '`back_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->back_view->Sortable = TRUE; // Allow sort
		$this->back_view->ImageResize = TRUE;
		$this->back_view->UploadMultiple = TRUE;
		$this->back_view->Upload->UploadMultiple = TRUE;
		$this->back_view->UploadMaxFileCount = 0;
		$this->fields['back_view'] = &$this->back_view;

		// color_options
		$this->color_options = new DbField('ref_image', 'ref_image', 'x_color_options', 'color_options', '`color_options`', '`color_options`', 200, -1, TRUE, '`color_options`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->color_options->Sortable = TRUE; // Allow sort
		$this->color_options->ImageResize = TRUE;
		$this->color_options->UploadMultiple = TRUE;
		$this->color_options->Upload->UploadMultiple = TRUE;
		$this->color_options->UploadMaxFileCount = 0;
		$this->fields['color_options'] = &$this->color_options;

		// other_options
		$this->other_options = new DbField('ref_image', 'ref_image', 'x_other_options', 'other_options', '`other_options`', '`other_options`', 200, -1, TRUE, '`other_options`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->other_options->Sortable = TRUE; // Allow sort
		$this->other_options->ImageResize = TRUE;
		$this->other_options->UploadMultiple = TRUE;
		$this->other_options->Upload->UploadMultiple = TRUE;
		$this->other_options->UploadMaxFileCount = 0;
		$this->fields['other_options'] = &$this->other_options;

		// video_url
		$this->video_url = new DbField('ref_image', 'ref_image', 'x_video_url', 'video_url', '`video_url`', '`video_url`', 200, -1, FALSE, '`video_url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->video_url->Sortable = TRUE; // Allow sort
		$this->fields['video_url'] = &$this->video_url;

		// group_image
		$this->group_image = new DbField('ref_image', 'ref_image', 'x_group_image', 'group_image', '`group_image`', '`group_image`', 200, -1, TRUE, '`group_image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->group_image->Sortable = TRUE; // Allow sort
		$this->fields['group_image'] = &$this->group_image;

		// status
		$this->status = new DbField('ref_image', 'ref_image', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'ref_image', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// company_id
		$this->company_id = new DbField('ref_image', 'ref_image', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 201, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// product_type
		$this->product_type = new DbField('ref_image', 'ref_image', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 200, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_type->Lookup = new Lookup('product_type', 'product_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->fields['product_type'] = &$this->product_type;

		// operator
		$this->operator = new DbField('ref_image', 'ref_image', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('ref_image', 'ref_image', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`ref_image`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Company_ID() == 0) ? "product_type != 9" : "`company_id` = " .  User_Company_ID()  . " and `product_type` != 9 and `status` = 1";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->product_code->DbValue = $row['product_code'];
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->top_view->Upload->DbValue = $row['top_view'];
		$this->front_view->Upload->DbValue = $row['front_view'];
		$this->corner_view->Upload->DbValue = $row['corner_view'];
		$this->back_view->Upload->DbValue = $row['back_view'];
		$this->color_options->Upload->DbValue = $row['color_options'];
		$this->other_options->Upload->DbValue = $row['other_options'];
		$this->video_url->DbValue = $row['video_url'];
		$this->group_image->Upload->DbValue = $row['group_image'];
		$this->status->DbValue = $row['status'];
		$this->company_id->DbValue = $row['company_id'];
		$this->product_type->DbValue = $row['product_type'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->main_image->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['main_image']) ? [] : [$row['main_image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->main_image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->main_image->oldPhysicalUploadPath() . $oldFile);
		}
		$this->top_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['top_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['top_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->top_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->top_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->front_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['front_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['front_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->front_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->front_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->corner_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['corner_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['corner_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->corner_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->corner_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->back_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['back_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['back_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->back_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->back_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->color_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['color_options']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['color_options']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->color_options->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->color_options->oldPhysicalUploadPath() . $oldFile);
		}
		$this->other_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['other_options']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['other_options']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->other_options->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->other_options->oldPhysicalUploadPath() . $oldFile);
		}
		$this->group_image->OldUploadPath = '/product_images/o/group_image/' ;
		$oldFiles = EmptyValue($row['group_image']) ? [] : [$row['group_image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->group_image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->group_image->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "ref_imagelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "ref_imageview.php")
			return $Language->phrase("View");
		elseif ($pageName == "ref_imageedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "ref_imageadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "ref_imagelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("ref_imageview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ref_imageview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "ref_imageadd.php?" . $this->getUrlParm($parm);
		else
			$url = "ref_imageadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("ref_imageedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("ref_imageadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("ref_imagedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->main_image->Upload->DbValue = $rs->fields('main_image');
		$this->top_view->Upload->DbValue = $rs->fields('top_view');
		$this->front_view->Upload->DbValue = $rs->fields('front_view');
		$this->corner_view->Upload->DbValue = $rs->fields('corner_view');
		$this->back_view->Upload->DbValue = $rs->fields('back_view');
		$this->color_options->Upload->DbValue = $rs->fields('color_options');
		$this->other_options->Upload->DbValue = $rs->fields('other_options');
		$this->video_url->setDbValue($rs->fields('video_url'));
		$this->group_image->Upload->DbValue = $rs->fields('group_image');
		$this->status->setDbValue($rs->fields('status'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// grp
		// s_grp
		// product
		// product_code
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// video_url
		// group_image
		// status
		// company_id
		// product_type
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// main_image
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->ImageWidth = 0;
			$this->main_image->ImageHeight = 40;
			$this->main_image->ImageAlt = $this->main_image->alt();
			$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
		} else {
			$this->main_image->ViewValue = "";
		}
		$this->main_image->ViewCustomAttributes = "";

		// top_view
		$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->top_view->Upload->DbValue)) {
			$this->top_view->ImageWidth = 0;
			$this->top_view->ImageHeight = 40;
			$this->top_view->ImageAlt = $this->top_view->alt();
			$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
		} else {
			$this->top_view->ViewValue = "";
		}
		$this->top_view->ViewCustomAttributes = "";

		// front_view
		$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->front_view->Upload->DbValue)) {
			$this->front_view->ImageWidth = 0;
			$this->front_view->ImageHeight = 40;
			$this->front_view->ImageAlt = $this->front_view->alt();
			$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
		} else {
			$this->front_view->ViewValue = "";
		}
		$this->front_view->ViewCustomAttributes = "";

		// corner_view
		$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->corner_view->Upload->DbValue)) {
			$this->corner_view->ImageWidth = 0;
			$this->corner_view->ImageHeight = 40;
			$this->corner_view->ImageAlt = $this->corner_view->alt();
			$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
		} else {
			$this->corner_view->ViewValue = "";
		}
		$this->corner_view->ViewCustomAttributes = "";

		// back_view
		$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->back_view->Upload->DbValue)) {
			$this->back_view->ImageWidth = 0;
			$this->back_view->ImageHeight = 40;
			$this->back_view->ImageAlt = $this->back_view->alt();
			$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
		} else {
			$this->back_view->ViewValue = "";
		}
		$this->back_view->ViewCustomAttributes = "";

		// color_options
		$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->color_options->Upload->DbValue)) {
			$this->color_options->ImageWidth = 0;
			$this->color_options->ImageHeight = 40;
			$this->color_options->ImageAlt = $this->color_options->alt();
			$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
		} else {
			$this->color_options->ViewValue = "";
		}
		$this->color_options->ViewCustomAttributes = "";

		// other_options
		$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->other_options->Upload->DbValue)) {
			$this->other_options->ImageWidth = 0;
			$this->other_options->ImageHeight = 40;
			$this->other_options->ImageAlt = $this->other_options->alt();
			$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
		} else {
			$this->other_options->ViewValue = "";
		}
		$this->other_options->ViewCustomAttributes = "";

		// video_url
		$this->video_url->ViewValue = $this->video_url->CurrentValue;
		$this->video_url->ViewCustomAttributes = "";

		// group_image
		$this->group_image->UploadPath = '/product_images/o/group_image/' ;
		if (!EmptyValue($this->group_image->Upload->DbValue)) {
			$this->group_image->ViewValue = $this->group_image->Upload->DbValue;
		} else {
			$this->group_image->ViewValue = "";
		}
		$this->group_image->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1" : "`id` = " .  User_Company_ID()  . " and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// product_type
		$curVal = strval($this->product_type->CurrentValue);
		if ($curVal <> "") {
			$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			if ($this->product_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_type->ViewValue = $this->product_type->CurrentValue;
				}
			}
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "ref_imagelist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "ref_imagelist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "ref_imagelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		if (!EmptyValue($this->product_code->CurrentValue)) {
			$this->product_code->HrefValue = "ref_imagelist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
			$this->product_code->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
		} else {
			$this->product_code->HrefValue = "";
		}
		$this->product_code->TooltipValue = "";

		// main_image
		$this->main_image->LinkCustomAttributes = "";
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->Upload->DbValue); // Add prefix/suffix
			$this->main_image->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
		} else {
			$this->main_image->HrefValue = "";
		}
		$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
		$this->main_image->TooltipValue = "";
		if ($this->main_image->UseColorbox) {
			if (EmptyValue($this->main_image->TooltipValue))
				$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->main_image->LinkAttrs["data-rel"] = "ref_image_x_main_image";
			AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
		}

		// top_view
		$this->top_view->LinkCustomAttributes = "";
		$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->top_view->Upload->DbValue)) {
			$this->top_view->HrefValue = "%u"; // Add prefix/suffix
			$this->top_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
		} else {
			$this->top_view->HrefValue = "";
		}
		$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
		$this->top_view->TooltipValue = "";
		if ($this->top_view->UseColorbox) {
			if (EmptyValue($this->top_view->TooltipValue))
				$this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->top_view->LinkAttrs["data-rel"] = "ref_image_x_top_view";
			AppendClass($this->top_view->LinkAttrs["class"], "ew-lightbox");
		}

		// front_view
		$this->front_view->LinkCustomAttributes = "";
		$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->front_view->Upload->DbValue)) {
			$this->front_view->HrefValue = "%u"; // Add prefix/suffix
			$this->front_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
		} else {
			$this->front_view->HrefValue = "";
		}
		$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
		$this->front_view->TooltipValue = "";
		if ($this->front_view->UseColorbox) {
			if (EmptyValue($this->front_view->TooltipValue))
				$this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->front_view->LinkAttrs["data-rel"] = "ref_image_x_front_view";
			AppendClass($this->front_view->LinkAttrs["class"], "ew-lightbox");
		}

		// corner_view
		$this->corner_view->LinkCustomAttributes = "";
		$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->corner_view->Upload->DbValue)) {
			$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
			$this->corner_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
		} else {
			$this->corner_view->HrefValue = "";
		}
		$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
		$this->corner_view->TooltipValue = "";
		if ($this->corner_view->UseColorbox) {
			if (EmptyValue($this->corner_view->TooltipValue))
				$this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->corner_view->LinkAttrs["data-rel"] = "ref_image_x_corner_view";
			AppendClass($this->corner_view->LinkAttrs["class"], "ew-lightbox");
		}

		// back_view
		$this->back_view->LinkCustomAttributes = "";
		$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->back_view->Upload->DbValue)) {
			$this->back_view->HrefValue = "%u"; // Add prefix/suffix
			$this->back_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
		} else {
			$this->back_view->HrefValue = "";
		}
		$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
		$this->back_view->TooltipValue = "";
		if ($this->back_view->UseColorbox) {
			if (EmptyValue($this->back_view->TooltipValue))
				$this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->back_view->LinkAttrs["data-rel"] = "ref_image_x_back_view";
			AppendClass($this->back_view->LinkAttrs["class"], "ew-lightbox");
		}

		// color_options
		$this->color_options->LinkCustomAttributes = "";
		$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->color_options->Upload->DbValue)) {
			$this->color_options->HrefValue = "%u"; // Add prefix/suffix
			$this->color_options->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
		} else {
			$this->color_options->HrefValue = "";
		}
		$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
		$this->color_options->TooltipValue = "";
		if ($this->color_options->UseColorbox) {
			if (EmptyValue($this->color_options->TooltipValue))
				$this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->color_options->LinkAttrs["data-rel"] = "ref_image_x_color_options";
			AppendClass($this->color_options->LinkAttrs["class"], "ew-lightbox");
		}

		// other_options
		$this->other_options->LinkCustomAttributes = "";
		$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->other_options->Upload->DbValue)) {
			$this->other_options->HrefValue = "%u"; // Add prefix/suffix
			$this->other_options->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
		} else {
			$this->other_options->HrefValue = "";
		}
		$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
		$this->other_options->TooltipValue = "";
		if ($this->other_options->UseColorbox) {
			if (EmptyValue($this->other_options->TooltipValue))
				$this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->other_options->LinkAttrs["data-rel"] = "ref_image_x_other_options";
			AppendClass($this->other_options->LinkAttrs["class"], "ew-lightbox");
		}

		// video_url
		$this->video_url->LinkCustomAttributes = "";
		$this->video_url->HrefValue = "";
		$this->video_url->TooltipValue = "";

		// group_image
		$this->group_image->LinkCustomAttributes = "";
		$this->group_image->HrefValue = "";
		$this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;
		$this->group_image->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->company_id->CurrentValue)) {
			$this->company_id->HrefValue = "ref_imagelist.php?x_company_id=" . $this->company_id->CurrentValue; // Add prefix/suffix
			$this->company_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->company_id->HrefValue = FullUrl($this->company_id->HrefValue, "href");
		} else {
			$this->company_id->HrefValue = "";
		}
		$this->company_id->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		if (!EmptyValue($this->operator->CurrentValue)) {
			$this->operator->HrefValue = "ref_imagelist.php?x_operator=" . $this->operator->CurrentValue; // Add prefix/suffix
			$this->operator->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
		} else {
			$this->operator->HrefValue = "";
		}
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->EditValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->EditValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->EditValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->EditValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->EditValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->EditValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// main_image
		$this->main_image->EditAttrs["class"] = "form-control";
		$this->main_image->EditCustomAttributes = "";
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->ImageWidth = 0;
			$this->main_image->ImageHeight = 40;
			$this->main_image->ImageAlt = $this->main_image->alt();
			$this->main_image->EditValue = $this->main_image->Upload->DbValue;
		} else {
			$this->main_image->EditValue = "";
		}
		if (!EmptyValue($this->main_image->CurrentValue))
				$this->main_image->Upload->FileName = $this->main_image->CurrentValue;

		// top_view
		$this->top_view->EditAttrs["class"] = "form-control";
		$this->top_view->EditCustomAttributes = "";
		$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->top_view->Upload->DbValue)) {
			$this->top_view->ImageWidth = 0;
			$this->top_view->ImageHeight = 40;
			$this->top_view->ImageAlt = $this->top_view->alt();
			$this->top_view->EditValue = $this->top_view->Upload->DbValue;
		} else {
			$this->top_view->EditValue = "";
		}
		if (!EmptyValue($this->top_view->CurrentValue))
				$this->top_view->Upload->FileName = $this->top_view->CurrentValue;

		// front_view
		$this->front_view->EditAttrs["class"] = "form-control";
		$this->front_view->EditCustomAttributes = "";
		$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->front_view->Upload->DbValue)) {
			$this->front_view->ImageWidth = 0;
			$this->front_view->ImageHeight = 40;
			$this->front_view->ImageAlt = $this->front_view->alt();
			$this->front_view->EditValue = $this->front_view->Upload->DbValue;
		} else {
			$this->front_view->EditValue = "";
		}
		if (!EmptyValue($this->front_view->CurrentValue))
				$this->front_view->Upload->FileName = $this->front_view->CurrentValue;

		// corner_view
		$this->corner_view->EditAttrs["class"] = "form-control";
		$this->corner_view->EditCustomAttributes = "";
		$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->corner_view->Upload->DbValue)) {
			$this->corner_view->ImageWidth = 0;
			$this->corner_view->ImageHeight = 40;
			$this->corner_view->ImageAlt = $this->corner_view->alt();
			$this->corner_view->EditValue = $this->corner_view->Upload->DbValue;
		} else {
			$this->corner_view->EditValue = "";
		}
		if (!EmptyValue($this->corner_view->CurrentValue))
				$this->corner_view->Upload->FileName = $this->corner_view->CurrentValue;

		// back_view
		$this->back_view->EditAttrs["class"] = "form-control";
		$this->back_view->EditCustomAttributes = "";
		$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->back_view->Upload->DbValue)) {
			$this->back_view->ImageWidth = 0;
			$this->back_view->ImageHeight = 40;
			$this->back_view->ImageAlt = $this->back_view->alt();
			$this->back_view->EditValue = $this->back_view->Upload->DbValue;
		} else {
			$this->back_view->EditValue = "";
		}
		if (!EmptyValue($this->back_view->CurrentValue))
				$this->back_view->Upload->FileName = $this->back_view->CurrentValue;

		// color_options
		$this->color_options->EditAttrs["class"] = "form-control";
		$this->color_options->EditCustomAttributes = "";
		$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->color_options->Upload->DbValue)) {
			$this->color_options->ImageWidth = 0;
			$this->color_options->ImageHeight = 40;
			$this->color_options->ImageAlt = $this->color_options->alt();
			$this->color_options->EditValue = $this->color_options->Upload->DbValue;
		} else {
			$this->color_options->EditValue = "";
		}
		if (!EmptyValue($this->color_options->CurrentValue))
				$this->color_options->Upload->FileName = $this->color_options->CurrentValue;

		// other_options
		$this->other_options->EditAttrs["class"] = "form-control";
		$this->other_options->EditCustomAttributes = "";
		$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->other_options->Upload->DbValue)) {
			$this->other_options->ImageWidth = 0;
			$this->other_options->ImageHeight = 40;
			$this->other_options->ImageAlt = $this->other_options->alt();
			$this->other_options->EditValue = $this->other_options->Upload->DbValue;
		} else {
			$this->other_options->EditValue = "";
		}
		if (!EmptyValue($this->other_options->CurrentValue))
				$this->other_options->Upload->FileName = $this->other_options->CurrentValue;

		// video_url
		$this->video_url->EditAttrs["class"] = "form-control";
		$this->video_url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
		$this->video_url->EditValue = $this->video_url->CurrentValue;
		$this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

		// group_image
		$this->group_image->EditAttrs["class"] = "form-control";
		$this->group_image->EditCustomAttributes = "";
		$this->group_image->UploadPath = '/product_images/o/group_image/' ;
		if (!EmptyValue($this->group_image->Upload->DbValue)) {
			$this->group_image->EditValue = $this->group_image->Upload->DbValue;
		} else {
			$this->group_image->EditValue = "";
		}
		if (!EmptyValue($this->group_image->CurrentValue))
				$this->group_image->Upload->FileName = $this->group_image->CurrentValue;

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1" : "`id` = " .  User_Company_ID()  . " and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->EditValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->EditValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";
		$curVal = strval($this->product_type->CurrentValue);
		if ($curVal <> "") {
			$this->product_type->EditValue = $this->product_type->lookupCacheOption($curVal);
			if ($this->product_type->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_type->EditValue = $this->product_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_type->EditValue = $this->product_type->CurrentValue;
				}
			}
		} else {
			$this->product_type->EditValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->top_view);
					$doc->exportCaption($this->front_view);
					$doc->exportCaption($this->corner_view);
					$doc->exportCaption($this->back_view);
					$doc->exportCaption($this->color_options);
					$doc->exportCaption($this->other_options);
					$doc->exportCaption($this->video_url);
					$doc->exportCaption($this->group_image);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->top_view);
					$doc->exportCaption($this->front_view);
					$doc->exportCaption($this->corner_view);
					$doc->exportCaption($this->back_view);
					$doc->exportCaption($this->color_options);
					$doc->exportCaption($this->other_options);
					$doc->exportCaption($this->video_url);
					$doc->exportCaption($this->group_image);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_code);
						$doc->exportField($this->main_image);
						$doc->exportField($this->top_view);
						$doc->exportField($this->front_view);
						$doc->exportField($this->corner_view);
						$doc->exportField($this->back_view);
						$doc->exportField($this->color_options);
						$doc->exportField($this->other_options);
						$doc->exportField($this->video_url);
						$doc->exportField($this->group_image);
						$doc->exportField($this->status);
						$doc->exportField($this->company_id);
						$doc->exportField($this->product_type);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_code);
						$doc->exportField($this->main_image);
						$doc->exportField($this->top_view);
						$doc->exportField($this->front_view);
						$doc->exportField($this->corner_view);
						$doc->exportField($this->back_view);
						$doc->exportField($this->color_options);
						$doc->exportField($this->other_options);
						$doc->exportField($this->video_url);
						$doc->exportField($this->group_image);
						$doc->exportField($this->status);
						$doc->exportField($this->company_id);
						$doc->exportField($this->product_type);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'main_image') {
			$fldName = "main_image";
			$fileNameFld = "main_image";
		} elseif ($fldparm == 'top_view') {
			$fldName = "top_view";
			$fileNameFld = "top_view";
		} elseif ($fldparm == 'front_view') {
			$fldName = "front_view";
			$fileNameFld = "front_view";
		} elseif ($fldparm == 'corner_view') {
			$fldName = "corner_view";
			$fileNameFld = "corner_view";
		} elseif ($fldparm == 'back_view') {
			$fldName = "back_view";
			$fileNameFld = "back_view";
		} elseif ($fldparm == 'color_options') {
			$fldName = "color_options";
			$fileNameFld = "color_options";
		} elseif ($fldparm == 'other_options') {
			$fldName = "other_options";
			$fileNameFld = "other_options";
		} elseif ($fldparm == 'group_image') {
			$fldName = "group_image";
			$fileNameFld = "group_image";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'ref_image';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'ref_image';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'ref_image';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'ref_image';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>