<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ref_image_edit extends ref_image
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ref_image';

	// Page object name
	public $PageObjName = "ref_image_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ref_image)
		if (!isset($GLOBALS["ref_image"]) || get_class($GLOBALS["ref_image"]) == PROJECT_NAMESPACE . "ref_image") {
			$GLOBALS["ref_image"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ref_image"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_image');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ref_image;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ref_image);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ref_imageview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ref_imagelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_code->setVisibility();
		$this->main_image->setVisibility();
		$this->top_view->setVisibility();
		$this->front_view->setVisibility();
		$this->corner_view->setVisibility();
		$this->back_view->setVisibility();
		$this->color_options->setVisibility();
		$this->other_options->setVisibility();
		$this->video_url->setVisibility();
		$this->group_image->setVisibility();
		$this->status->setVisibility();
		$this->company_id->setVisibility();
		$this->product_type->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->grp->Required = FALSE;
		$this->s_grp->Required = FALSE;
		$this->status->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("ref_imagelist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "ref_imagelist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->main_image->Upload->Index = $CurrentForm->Index;
		$this->main_image->Upload->uploadFile();
		$this->main_image->CurrentValue = $this->main_image->Upload->FileName;
		$this->top_view->Upload->Index = $CurrentForm->Index;
		$this->top_view->Upload->uploadFile();
		$this->top_view->CurrentValue = $this->top_view->Upload->FileName;
		$this->front_view->Upload->Index = $CurrentForm->Index;
		$this->front_view->Upload->uploadFile();
		$this->front_view->CurrentValue = $this->front_view->Upload->FileName;
		$this->corner_view->Upload->Index = $CurrentForm->Index;
		$this->corner_view->Upload->uploadFile();
		$this->corner_view->CurrentValue = $this->corner_view->Upload->FileName;
		$this->back_view->Upload->Index = $CurrentForm->Index;
		$this->back_view->Upload->uploadFile();
		$this->back_view->CurrentValue = $this->back_view->Upload->FileName;
		$this->color_options->Upload->Index = $CurrentForm->Index;
		$this->color_options->Upload->uploadFile();
		$this->color_options->CurrentValue = $this->color_options->Upload->FileName;
		$this->other_options->Upload->Index = $CurrentForm->Index;
		$this->other_options->Upload->uploadFile();
		$this->other_options->CurrentValue = $this->other_options->Upload->FileName;
		$this->group_image->Upload->Index = $CurrentForm->Index;
		$this->group_image->Upload->uploadFile();
		$this->group_image->CurrentValue = $this->group_image->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'product_code' first before field var 'x_product_code'
		$val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
		if (!$this->product_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_code->Visible = FALSE; // Disable update for API request
			else
				$this->product_code->setFormValue($val);
		}

		// Check field name 'video_url' first before field var 'x_video_url'
		$val = $CurrentForm->hasValue("video_url") ? $CurrentForm->getValue("video_url") : $CurrentForm->getValue("x_video_url");
		if (!$this->video_url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->video_url->Visible = FALSE; // Disable update for API request
			else
				$this->video_url->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->product_code->CurrentValue = $this->product_code->FormValue;
		$this->video_url->CurrentValue = $this->video_url->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_code->setDbValue($row['product_code']);
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->main_image->setDbValue($this->main_image->Upload->DbValue);
		$this->top_view->Upload->DbValue = $row['top_view'];
		$this->top_view->setDbValue($this->top_view->Upload->DbValue);
		$this->front_view->Upload->DbValue = $row['front_view'];
		$this->front_view->setDbValue($this->front_view->Upload->DbValue);
		$this->corner_view->Upload->DbValue = $row['corner_view'];
		$this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
		$this->back_view->Upload->DbValue = $row['back_view'];
		$this->back_view->setDbValue($this->back_view->Upload->DbValue);
		$this->color_options->Upload->DbValue = $row['color_options'];
		$this->color_options->setDbValue($this->color_options->Upload->DbValue);
		$this->other_options->Upload->DbValue = $row['other_options'];
		$this->other_options->setDbValue($this->other_options->Upload->DbValue);
		$this->video_url->setDbValue($row['video_url']);
		$this->group_image->Upload->DbValue = $row['group_image'];
		$this->group_image->setDbValue($this->group_image->Upload->DbValue);
		$this->status->setDbValue($row['status']);
		$this->company_id->setDbValue($row['company_id']);
		$this->product_type->setDbValue($row['product_type']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_code'] = NULL;
		$row['main_image'] = NULL;
		$row['top_view'] = NULL;
		$row['front_view'] = NULL;
		$row['corner_view'] = NULL;
		$row['back_view'] = NULL;
		$row['color_options'] = NULL;
		$row['other_options'] = NULL;
		$row['video_url'] = NULL;
		$row['group_image'] = NULL;
		$row['status'] = NULL;
		$row['company_id'] = NULL;
		$row['product_type'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// s_grp
		// product
		// product_code
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// video_url
		// group_image
		// status
		// company_id
		// product_type
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// main_image
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->ViewValue = "";
			}
			$this->main_image->ViewCustomAttributes = "";

			// top_view
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->ViewValue = "";
			}
			$this->top_view->ViewCustomAttributes = "";

			// front_view
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->ViewValue = "";
			}
			$this->front_view->ViewCustomAttributes = "";

			// corner_view
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->ViewValue = "";
			}
			$this->corner_view->ViewCustomAttributes = "";

			// back_view
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->ViewValue = "";
			}
			$this->back_view->ViewCustomAttributes = "";

			// color_options
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->ViewValue = "";
			}
			$this->color_options->ViewCustomAttributes = "";

			// other_options
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->ViewValue = "";
			}
			$this->other_options->ViewCustomAttributes = "";

			// video_url
			$this->video_url->ViewValue = $this->video_url->CurrentValue;
			$this->video_url->ViewCustomAttributes = "";

			// group_image
			$this->group_image->UploadPath = '/product_images/o/group_image/' ;
			if (!EmptyValue($this->group_image->Upload->DbValue)) {
				$this->group_image->ViewValue = $this->group_image->Upload->DbValue;
			} else {
				$this->group_image->ViewValue = "";
			}
			$this->group_image->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1" : "`id` = " .  User_Company_ID()  . " and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "ref_imagelist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "ref_imagelist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_imagelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "ref_imagelist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}
			$this->product_code->TooltipValue = "";

			// main_image
			$this->main_image->LinkCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->Upload->DbValue); // Add prefix/suffix
				$this->main_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
			} else {
				$this->main_image->HrefValue = "";
			}
			$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
			$this->main_image->TooltipValue = "";
			if ($this->main_image->UseColorbox) {
				if (EmptyValue($this->main_image->TooltipValue))
					$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->main_image->LinkAttrs["data-rel"] = "ref_image_x_main_image";
				AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
			}

			// top_view
			$this->top_view->LinkCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->HrefValue = "%u"; // Add prefix/suffix
				$this->top_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
			} else {
				$this->top_view->HrefValue = "";
			}
			$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
			$this->top_view->TooltipValue = "";
			if ($this->top_view->UseColorbox) {
				if (EmptyValue($this->top_view->TooltipValue))
					$this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->top_view->LinkAttrs["data-rel"] = "ref_image_x_top_view";
				AppendClass($this->top_view->LinkAttrs["class"], "ew-lightbox");
			}

			// front_view
			$this->front_view->LinkCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->HrefValue = "%u"; // Add prefix/suffix
				$this->front_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
			} else {
				$this->front_view->HrefValue = "";
			}
			$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
			$this->front_view->TooltipValue = "";
			if ($this->front_view->UseColorbox) {
				if (EmptyValue($this->front_view->TooltipValue))
					$this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->front_view->LinkAttrs["data-rel"] = "ref_image_x_front_view";
				AppendClass($this->front_view->LinkAttrs["class"], "ew-lightbox");
			}

			// corner_view
			$this->corner_view->LinkCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
				$this->corner_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
			} else {
				$this->corner_view->HrefValue = "";
			}
			$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
			$this->corner_view->TooltipValue = "";
			if ($this->corner_view->UseColorbox) {
				if (EmptyValue($this->corner_view->TooltipValue))
					$this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->corner_view->LinkAttrs["data-rel"] = "ref_image_x_corner_view";
				AppendClass($this->corner_view->LinkAttrs["class"], "ew-lightbox");
			}

			// back_view
			$this->back_view->LinkCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->HrefValue = "%u"; // Add prefix/suffix
				$this->back_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
			} else {
				$this->back_view->HrefValue = "";
			}
			$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
			$this->back_view->TooltipValue = "";
			if ($this->back_view->UseColorbox) {
				if (EmptyValue($this->back_view->TooltipValue))
					$this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->back_view->LinkAttrs["data-rel"] = "ref_image_x_back_view";
				AppendClass($this->back_view->LinkAttrs["class"], "ew-lightbox");
			}

			// color_options
			$this->color_options->LinkCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->HrefValue = "%u"; // Add prefix/suffix
				$this->color_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
			} else {
				$this->color_options->HrefValue = "";
			}
			$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
			$this->color_options->TooltipValue = "";
			if ($this->color_options->UseColorbox) {
				if (EmptyValue($this->color_options->TooltipValue))
					$this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->color_options->LinkAttrs["data-rel"] = "ref_image_x_color_options";
				AppendClass($this->color_options->LinkAttrs["class"], "ew-lightbox");
			}

			// other_options
			$this->other_options->LinkCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->HrefValue = "%u"; // Add prefix/suffix
				$this->other_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
			} else {
				$this->other_options->HrefValue = "";
			}
			$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
			$this->other_options->TooltipValue = "";
			if ($this->other_options->UseColorbox) {
				if (EmptyValue($this->other_options->TooltipValue))
					$this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->other_options->LinkAttrs["data-rel"] = "ref_image_x_other_options";
				AppendClass($this->other_options->LinkAttrs["class"], "ew-lightbox");
			}

			// video_url
			$this->video_url->LinkCustomAttributes = "";
			$this->video_url->HrefValue = "";
			$this->video_url->TooltipValue = "";

			// group_image
			$this->group_image->LinkCustomAttributes = "";
			$this->group_image->HrefValue = "";
			$this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;
			$this->group_image->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->company_id->CurrentValue)) {
				$this->company_id->HrefValue = "ref_imagelist.php?x_company_id=" . $this->company_id->CurrentValue; // Add prefix/suffix
				$this->company_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->company_id->HrefValue = FullUrl($this->company_id->HrefValue, "href");
			} else {
				$this->company_id->HrefValue = "";
			}
			$this->company_id->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			if (!EmptyValue($this->operator->CurrentValue)) {
				$this->operator->HrefValue = "ref_imagelist.php?x_operator=" . $this->operator->CurrentValue; // Add prefix/suffix
				$this->operator->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
			} else {
				$this->operator->HrefValue = "";
			}
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			$this->product_code->EditValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// main_image
			$this->main_image->EditAttrs["class"] = "form-control";
			$this->main_image->EditCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->EditValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->EditValue = "";
			}
			if (!EmptyValue($this->main_image->CurrentValue))
					$this->main_image->Upload->FileName = $this->main_image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->main_image);

			// top_view
			$this->top_view->EditAttrs["class"] = "form-control";
			$this->top_view->EditCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->EditValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->EditValue = "";
			}
			if (!EmptyValue($this->top_view->CurrentValue))
					$this->top_view->Upload->FileName = $this->top_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->top_view);

			// front_view
			$this->front_view->EditAttrs["class"] = "form-control";
			$this->front_view->EditCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->EditValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->EditValue = "";
			}
			if (!EmptyValue($this->front_view->CurrentValue))
					$this->front_view->Upload->FileName = $this->front_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->front_view);

			// corner_view
			$this->corner_view->EditAttrs["class"] = "form-control";
			$this->corner_view->EditCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->EditValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->EditValue = "";
			}
			if (!EmptyValue($this->corner_view->CurrentValue))
					$this->corner_view->Upload->FileName = $this->corner_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->corner_view);

			// back_view
			$this->back_view->EditAttrs["class"] = "form-control";
			$this->back_view->EditCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->EditValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->EditValue = "";
			}
			if (!EmptyValue($this->back_view->CurrentValue))
					$this->back_view->Upload->FileName = $this->back_view->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->back_view);

			// color_options
			$this->color_options->EditAttrs["class"] = "form-control";
			$this->color_options->EditCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->EditValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->EditValue = "";
			}
			if (!EmptyValue($this->color_options->CurrentValue))
					$this->color_options->Upload->FileName = $this->color_options->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->color_options);

			// other_options
			$this->other_options->EditAttrs["class"] = "form-control";
			$this->other_options->EditCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->EditValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->EditValue = "";
			}
			if (!EmptyValue($this->other_options->CurrentValue))
					$this->other_options->Upload->FileName = $this->other_options->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->other_options);

			// video_url
			$this->video_url->EditAttrs["class"] = "form-control";
			$this->video_url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
			$this->video_url->EditValue = HtmlEncode($this->video_url->CurrentValue);
			$this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

			// group_image
			$this->group_image->EditAttrs["class"] = "form-control";
			$this->group_image->EditCustomAttributes = "";
			$this->group_image->UploadPath = '/product_images/o/group_image/' ;
			if (!EmptyValue($this->group_image->Upload->DbValue)) {
				$this->group_image->EditValue = $this->group_image->Upload->DbValue;
			} else {
				$this->group_image->EditValue = "";
			}
			if (!EmptyValue($this->group_image->CurrentValue))
					$this->group_image->Upload->FileName = $this->group_image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->group_image);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1" : "`id` = " .  User_Company_ID()  . " and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->EditValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->EditValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->EditValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->EditValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "ref_imagelist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "ref_imagelist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_imagelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "ref_imagelist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}
			$this->product_code->TooltipValue = "";

			// main_image
			$this->main_image->LinkCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->Upload->DbValue); // Add prefix/suffix
				$this->main_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
			} else {
				$this->main_image->HrefValue = "";
			}
			$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;

			// top_view
			$this->top_view->LinkCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->HrefValue = "%u"; // Add prefix/suffix
				$this->top_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
			} else {
				$this->top_view->HrefValue = "";
			}
			$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;

			// front_view
			$this->front_view->LinkCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->HrefValue = "%u"; // Add prefix/suffix
				$this->front_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
			} else {
				$this->front_view->HrefValue = "";
			}
			$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;

			// corner_view
			$this->corner_view->LinkCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
				$this->corner_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
			} else {
				$this->corner_view->HrefValue = "";
			}
			$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;

			// back_view
			$this->back_view->LinkCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->HrefValue = "%u"; // Add prefix/suffix
				$this->back_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
			} else {
				$this->back_view->HrefValue = "";
			}
			$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;

			// color_options
			$this->color_options->LinkCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->HrefValue = "%u"; // Add prefix/suffix
				$this->color_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
			} else {
				$this->color_options->HrefValue = "";
			}
			$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;

			// other_options
			$this->other_options->LinkCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->HrefValue = "%u"; // Add prefix/suffix
				$this->other_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
			} else {
				$this->other_options->HrefValue = "";
			}
			$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;

			// video_url
			$this->video_url->LinkCustomAttributes = "";
			$this->video_url->HrefValue = "";

			// group_image
			$this->group_image->LinkCustomAttributes = "";
			$this->group_image->HrefValue = "";
			$this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->company_id->CurrentValue)) {
				$this->company_id->HrefValue = "ref_imagelist.php?x_company_id=" . $this->company_id->CurrentValue; // Add prefix/suffix
				$this->company_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->company_id->HrefValue = FullUrl($this->company_id->HrefValue, "href");
			} else {
				$this->company_id->HrefValue = "";
			}
			$this->company_id->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			if (!EmptyValue($this->operator->CurrentValue)) {
				$this->operator->HrefValue = "ref_imagelist.php?x_operator=" . $this->operator->CurrentValue; // Add prefix/suffix
				$this->operator->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
			} else {
				$this->operator->HrefValue = "";
			}

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->product_code->Required) {
			if (!$this->product_code->IsDetailKey && $this->product_code->FormValue != NULL && $this->product_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
			}
		}
		if ($this->main_image->Required) {
			if ($this->main_image->Upload->FileName == "" && !$this->main_image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->main_image->caption(), $this->main_image->RequiredErrorMessage));
			}
		}
		if ($this->top_view->Required) {
			if ($this->top_view->Upload->FileName == "" && !$this->top_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->top_view->caption(), $this->top_view->RequiredErrorMessage));
			}
		}
		if ($this->front_view->Required) {
			if ($this->front_view->Upload->FileName == "" && !$this->front_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->front_view->caption(), $this->front_view->RequiredErrorMessage));
			}
		}
		if ($this->corner_view->Required) {
			if ($this->corner_view->Upload->FileName == "" && !$this->corner_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->corner_view->caption(), $this->corner_view->RequiredErrorMessage));
			}
		}
		if ($this->back_view->Required) {
			if ($this->back_view->Upload->FileName == "" && !$this->back_view->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->back_view->caption(), $this->back_view->RequiredErrorMessage));
			}
		}
		if ($this->color_options->Required) {
			if ($this->color_options->Upload->FileName == "" && !$this->color_options->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->color_options->caption(), $this->color_options->RequiredErrorMessage));
			}
		}
		if ($this->other_options->Required) {
			if ($this->other_options->Upload->FileName == "" && !$this->other_options->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->other_options->caption(), $this->other_options->RequiredErrorMessage));
			}
		}
		if ($this->video_url->Required) {
			if (!$this->video_url->IsDetailKey && $this->video_url->FormValue != NULL && $this->video_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->video_url->caption(), $this->video_url->RequiredErrorMessage));
			}
		}
		if ($this->group_image->Required) {
			if ($this->group_image->Upload->FileName == "" && !$this->group_image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->group_image->caption(), $this->group_image->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->product_code->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`product_code` = '" . AdjustSql($this->product_code->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->product_code->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->product_code->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->main_image->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->main_image->UploadPath = $this->main_image->OldUploadPath;
			$this->top_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->top_view->UploadPath = $this->top_view->OldUploadPath;
			$this->front_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->front_view->UploadPath = $this->front_view->OldUploadPath;
			$this->corner_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
			$this->back_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->back_view->UploadPath = $this->back_view->OldUploadPath;
			$this->color_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->color_options->UploadPath = $this->color_options->OldUploadPath;
			$this->other_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			$this->other_options->UploadPath = $this->other_options->OldUploadPath;
			$this->group_image->OldUploadPath = '/product_images/o/group_image/' ;
			$this->group_image->UploadPath = $this->group_image->OldUploadPath;
			$rsnew = [];

			// main_image
			if ($this->main_image->Visible && !$this->main_image->ReadOnly && !$this->main_image->Upload->KeepFile) {
				$this->main_image->Upload->DbValue = $rsold['main_image']; // Get original value
				if ($this->main_image->Upload->FileName == "") {
					$rsnew['main_image'] = NULL;
				} else {
					$rsnew['main_image'] = $this->main_image->Upload->FileName;
				}
				$this->main_image->ImageWidth = 640; // Resize width
				$this->main_image->ImageHeight = 640; // Resize height
			}

			// top_view
			if ($this->top_view->Visible && !$this->top_view->ReadOnly && !$this->top_view->Upload->KeepFile) {
				$this->top_view->Upload->DbValue = $rsold['top_view']; // Get original value
				if ($this->top_view->Upload->FileName == "") {
					$rsnew['top_view'] = NULL;
				} else {
					$rsnew['top_view'] = $this->top_view->Upload->FileName;
				}
				$this->top_view->ImageWidth = 640; // Resize width
				$this->top_view->ImageHeight = 640; // Resize height
			}

			// front_view
			if ($this->front_view->Visible && !$this->front_view->ReadOnly && !$this->front_view->Upload->KeepFile) {
				$this->front_view->Upload->DbValue = $rsold['front_view']; // Get original value
				if ($this->front_view->Upload->FileName == "") {
					$rsnew['front_view'] = NULL;
				} else {
					$rsnew['front_view'] = $this->front_view->Upload->FileName;
				}
				$this->front_view->ImageWidth = 640; // Resize width
				$this->front_view->ImageHeight = 640; // Resize height
			}

			// corner_view
			if ($this->corner_view->Visible && !$this->corner_view->ReadOnly && !$this->corner_view->Upload->KeepFile) {
				$this->corner_view->Upload->DbValue = $rsold['corner_view']; // Get original value
				if ($this->corner_view->Upload->FileName == "") {
					$rsnew['corner_view'] = NULL;
				} else {
					$rsnew['corner_view'] = $this->corner_view->Upload->FileName;
				}
				$this->corner_view->ImageWidth = 640; // Resize width
				$this->corner_view->ImageHeight = 640; // Resize height
			}

			// back_view
			if ($this->back_view->Visible && !$this->back_view->ReadOnly && !$this->back_view->Upload->KeepFile) {
				$this->back_view->Upload->DbValue = $rsold['back_view']; // Get original value
				if ($this->back_view->Upload->FileName == "") {
					$rsnew['back_view'] = NULL;
				} else {
					$rsnew['back_view'] = $this->back_view->Upload->FileName;
				}
				$this->back_view->ImageWidth = 640; // Resize width
				$this->back_view->ImageHeight = 640; // Resize height
			}

			// color_options
			if ($this->color_options->Visible && !$this->color_options->ReadOnly && !$this->color_options->Upload->KeepFile) {
				$this->color_options->Upload->DbValue = $rsold['color_options']; // Get original value
				if ($this->color_options->Upload->FileName == "") {
					$rsnew['color_options'] = NULL;
				} else {
					$rsnew['color_options'] = $this->color_options->Upload->FileName;
				}
				$this->color_options->ImageWidth = 640; // Resize width
				$this->color_options->ImageHeight = 640; // Resize height
			}

			// other_options
			if ($this->other_options->Visible && !$this->other_options->ReadOnly && !$this->other_options->Upload->KeepFile) {
				$this->other_options->Upload->DbValue = $rsold['other_options']; // Get original value
				if ($this->other_options->Upload->FileName == "") {
					$rsnew['other_options'] = NULL;
				} else {
					$rsnew['other_options'] = $this->other_options->Upload->FileName;
				}
				$this->other_options->ImageWidth = 640; // Resize width
				$this->other_options->ImageHeight = 640; // Resize height
			}

			// video_url
			$this->video_url->setDbValueDef($rsnew, $this->video_url->CurrentValue, NULL, $this->video_url->ReadOnly);

			// group_image
			if ($this->group_image->Visible && !$this->group_image->ReadOnly && !$this->group_image->Upload->KeepFile) {
				$this->group_image->Upload->DbValue = $rsold['group_image']; // Get original value
				if ($this->group_image->Upload->FileName == "") {
					$rsnew['group_image'] = NULL;
				} else {
					$rsnew['group_image'] = $this->group_image->Upload->FileName;
				}
				$this->group_image->ImageWidth = 700; // Resize width
				$this->group_image->ImageHeight = 700; // Resize height
			}

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;
			if ($this->main_image->Visible && !$this->main_image->Upload->KeepFile) {
				$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->main_image->Upload->DbValue) ? array() : array($this->main_image->Upload->DbValue);
				if (!EmptyValue($this->main_image->Upload->FileName)) {
					$newFiles = array($this->main_image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->main_image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file1) || file_exists($this->main_image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->main_image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file, UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->main_image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->main_image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->main_image->setDbValueDef($rsnew, $this->main_image->Upload->FileName, NULL, $this->main_image->ReadOnly);
				}
			}
			if ($this->top_view->Visible && !$this->top_view->Upload->KeepFile) {
				$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->top_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->top_view->Upload->DbValue));
				if (!EmptyValue($this->top_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->top_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->top_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file1) || file_exists($this->top_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->top_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file, UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->top_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->top_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->top_view->setDbValueDef($rsnew, $this->top_view->Upload->FileName, NULL, $this->top_view->ReadOnly);
				}
			}
			if ($this->front_view->Visible && !$this->front_view->Upload->KeepFile) {
				$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->front_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->front_view->Upload->DbValue));
				if (!EmptyValue($this->front_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->front_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->front_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file1) || file_exists($this->front_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->front_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file, UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->front_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->front_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->front_view->setDbValueDef($rsnew, $this->front_view->Upload->FileName, NULL, $this->front_view->ReadOnly);
				}
			}
			if ($this->corner_view->Visible && !$this->corner_view->Upload->KeepFile) {
				$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->corner_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->corner_view->Upload->DbValue));
				if (!EmptyValue($this->corner_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->corner_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->corner_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file1) || file_exists($this->corner_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->corner_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file, UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->corner_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->corner_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->corner_view->setDbValueDef($rsnew, $this->corner_view->Upload->FileName, NULL, $this->corner_view->ReadOnly);
				}
			}
			if ($this->back_view->Visible && !$this->back_view->Upload->KeepFile) {
				$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->back_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->back_view->Upload->DbValue));
				if (!EmptyValue($this->back_view->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->back_view->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->back_view->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file1) || file_exists($this->back_view->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->back_view->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file, UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->back_view->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->back_view->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->back_view->setDbValueDef($rsnew, $this->back_view->Upload->FileName, NULL, $this->back_view->ReadOnly);
				}
			}
			if ($this->color_options->Visible && !$this->color_options->Upload->KeepFile) {
				$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->color_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->color_options->Upload->DbValue));
				if (!EmptyValue($this->color_options->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->color_options->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->color_options->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file1) || file_exists($this->color_options->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->color_options->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file, UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->color_options->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->color_options->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->color_options->setDbValueDef($rsnew, $this->color_options->Upload->FileName, NULL, $this->color_options->ReadOnly);
				}
			}
			if ($this->other_options->Visible && !$this->other_options->Upload->KeepFile) {
				$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->other_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->other_options->Upload->DbValue));
				if (!EmptyValue($this->other_options->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->other_options->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->other_options->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file1) || file_exists($this->other_options->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->other_options->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file, UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->other_options->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->other_options->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->other_options->setDbValueDef($rsnew, $this->other_options->Upload->FileName, NULL, $this->other_options->ReadOnly);
				}
			}
			if ($this->group_image->Visible && !$this->group_image->Upload->KeepFile) {
				$this->group_image->UploadPath = '/product_images/o/group_image/' ;
				$oldFiles = EmptyValue($this->group_image->Upload->DbValue) ? array() : array($this->group_image->Upload->DbValue);
				if (!EmptyValue($this->group_image->Upload->FileName)) {
					$newFiles = array($this->group_image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->group_image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file1) || file_exists($this->group_image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->group_image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file, UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->group_image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->group_image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->group_image->setDbValueDef($rsnew, $this->group_image->Upload->FileName, NULL, $this->group_image->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->main_image->Visible && !$this->main_image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->main_image->Upload->DbValue) ? array() : array($this->main_image->Upload->DbValue);
						if (!EmptyValue($this->main_image->Upload->FileName)) {
							$newFiles = array($this->main_image->Upload->FileName);
							$newFiles2 = array($rsnew['main_image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->main_image, $this->main_image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->main_image->Upload->resizeAndSaveToFile($this->main_image->ImageWidth, $this->main_image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->main_image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->top_view->Visible && !$this->top_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->top_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->top_view->Upload->DbValue));
						if (!EmptyValue($this->top_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->top_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['top_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->top_view, $this->top_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->top_view->Upload->resizeAndSaveToFile($this->top_view->ImageWidth, $this->top_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->top_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->front_view->Visible && !$this->front_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->front_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->front_view->Upload->DbValue));
						if (!EmptyValue($this->front_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->front_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['front_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->front_view, $this->front_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->front_view->Upload->resizeAndSaveToFile($this->front_view->ImageWidth, $this->front_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->front_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->corner_view->Visible && !$this->corner_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->corner_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->corner_view->Upload->DbValue));
						if (!EmptyValue($this->corner_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->corner_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['corner_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->corner_view, $this->corner_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->corner_view->Upload->resizeAndSaveToFile($this->corner_view->ImageWidth, $this->corner_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->corner_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->back_view->Visible && !$this->back_view->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->back_view->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->back_view->Upload->DbValue));
						if (!EmptyValue($this->back_view->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->back_view->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['back_view']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->back_view, $this->back_view->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->back_view->Upload->resizeAndSaveToFile($this->back_view->ImageWidth, $this->back_view->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->back_view->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->color_options->Visible && !$this->color_options->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->color_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->color_options->Upload->DbValue));
						if (!EmptyValue($this->color_options->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->color_options->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['color_options']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->color_options, $this->color_options->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->color_options->Upload->resizeAndSaveToFile($this->color_options->ImageWidth, $this->color_options->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->color_options->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->other_options->Visible && !$this->other_options->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->other_options->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->other_options->Upload->DbValue));
						if (!EmptyValue($this->other_options->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->other_options->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['other_options']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->other_options, $this->other_options->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->other_options->Upload->resizeAndSaveToFile($this->other_options->ImageWidth, $this->other_options->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->other_options->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->group_image->Visible && !$this->group_image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->group_image->Upload->DbValue) ? array() : array($this->group_image->Upload->DbValue);
						if (!EmptyValue($this->group_image->Upload->FileName)) {
							$newFiles = array($this->group_image->Upload->FileName);
							$newFiles2 = array($rsnew['group_image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->group_image, $this->group_image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->group_image->Upload->resizeAndSaveToFile($this->group_image->ImageWidth, $this->group_image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->group_image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// main_image
		if ($this->main_image->Upload->FileToken <> "")
			CleanUploadTempPath($this->main_image->Upload->FileToken, $this->main_image->Upload->Index);
		else
			CleanUploadTempPath($this->main_image, $this->main_image->Upload->Index);

		// top_view
		if ($this->top_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->top_view->Upload->FileToken, $this->top_view->Upload->Index);
		else
			CleanUploadTempPath($this->top_view, $this->top_view->Upload->Index);

		// front_view
		if ($this->front_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->front_view->Upload->FileToken, $this->front_view->Upload->Index);
		else
			CleanUploadTempPath($this->front_view, $this->front_view->Upload->Index);

		// corner_view
		if ($this->corner_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->corner_view->Upload->FileToken, $this->corner_view->Upload->Index);
		else
			CleanUploadTempPath($this->corner_view, $this->corner_view->Upload->Index);

		// back_view
		if ($this->back_view->Upload->FileToken <> "")
			CleanUploadTempPath($this->back_view->Upload->FileToken, $this->back_view->Upload->Index);
		else
			CleanUploadTempPath($this->back_view, $this->back_view->Upload->Index);

		// color_options
		if ($this->color_options->Upload->FileToken <> "")
			CleanUploadTempPath($this->color_options->Upload->FileToken, $this->color_options->Upload->Index);
		else
			CleanUploadTempPath($this->color_options, $this->color_options->Upload->Index);

		// other_options
		if ($this->other_options->Upload->FileToken <> "")
			CleanUploadTempPath($this->other_options->Upload->FileToken, $this->other_options->Upload->Index);
		else
			CleanUploadTempPath($this->other_options, $this->other_options->Upload->Index);

		// group_image
		if ($this->group_image->Upload->FileToken <> "")
			CleanUploadTempPath($this->group_image->Upload->FileToken, $this->group_image->Upload->Index);
		else
			CleanUploadTempPath($this->group_image, $this->group_image->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ref_imagelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1" : "`id` = " .  User_Company_ID()  . " and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_company_id":
							break;
						case "x_product_type":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		$this->company_id->ReadOnly = True;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>