<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for ref_multi
 */
class ref_multi extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $oid;
	public $_barcode;
	public $company_id;
	public $grp;
	public $s_grp;
	public $product;
	public $product_n;
	public $product_type;
	public $product_code;
	public $gcode;
	public $code;
	public $product_id;
	public $print_name;
	public $batch_no;
	public $last_price;
	public $v_01;
	public $v_02;
	public $v_03;
	public $v_04;
	public $v_05;
	public $v_06;
	public $v_07;
	public $v_08;
	public $v_09;
	public $v_10;
	public $cbm;
	public $sqm;
	public $shape;
	public $b_01;
	public $b_02;
	public $b_03;
	public $b_04;
	public $b_05;
	public $b_06;
	public $b_07;
	public $b_08;
	public $b_09;
	public $b_10;
	public $b_11;
	public $b_12;
	public $b_13;
	public $b_14;
	public $b_15;
	public $t_01;
	public $t_02;
	public $t_03;
	public $t_04;
	public $t_05;
	public $t_06;
	public $t_07;
	public $t_08;
	public $t_09;
	public $t_10;
	public $t_11;
	public $t_12;
	public $t_13;
	public $t_14;
	public $t_15;
	public $d_head_01;
	public $d_description_01;
	public $d_head_02;
	public $d_description_02;
	public $main_image;
	public $top_view;
	public $front_view;
	public $corner_view;
	public $back_view;
	public $color_options;
	public $other_options;
	public $image;
	public $video_url;
	public $currency;
	public $hsn;
	public $minimum_stock;
	public $in;
	public $out;
	public $required;
	public $blocked;
	public $ordered;
	public $status;
	public $publish;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'ref_multi';
		$this->TableName = 'ref_multi';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`ref_multi`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = TRUE; // Allow detail add
		$this->DetailEdit = TRUE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('ref_multi', 'ref_multi', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->IsForeignKey = TRUE; // Foreign key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// oid
		$this->oid = new DbField('ref_multi', 'ref_multi', 'x_oid', 'oid', '`oid`', '`oid`', 200, -1, FALSE, '`oid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->oid->Sortable = FALSE; // Allow sort
		$this->oid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['oid'] = &$this->oid;

		// barcode
		$this->_barcode = new DbField('ref_multi', 'ref_multi', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 200, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Sortable = FALSE; // Allow sort
		$this->fields['barcode'] = &$this->_barcode;

		// company_id
		$this->company_id = new DbField('ref_multi', 'ref_multi', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 201, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// grp
		$this->grp = new DbField('ref_multi', 'ref_multi', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('ref_multi', 'ref_multi', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product","x_v_01[]","x_v_02[]","x_v_03[]","x_v_04[]","x_v_05[]","x_v_06[]","x_v_07[]","x_v_08[]","x_v_09[]","x_v_10[]","x_b_03[]","x_b_04[]","x_b_05[]","x_b_06[]","x_b_07[]","x_b_08[]","x_b_09[]","x_b_10[]","x_t_03[]","x_t_04[]","x_t_05[]","x_t_06[]","x_t_07[]","x_t_08[]","x_t_09[]","x_t_10[]"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('ref_multi', 'ref_multi', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp[]"], ["product"], ["x_product_n"], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// product_n
		$this->product_n = new DbField('ref_multi', 'ref_multi', 'x_product_n', 'product_n', '`product_n`', '`product_n`', 200, -1, FALSE, '`product_n`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_n->Required = TRUE; // Required field
		$this->product_n->Sortable = TRUE; // Allow sort
		$this->fields['product_n'] = &$this->product_n;

		// product_type
		$this->product_type = new DbField('ref_multi', 'ref_multi', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 200, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->Lookup = new Lookup('product_type', 'product_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['product_type'] = &$this->product_type;

		// product_code
		$this->product_code = new DbField('ref_multi', 'ref_multi', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = FALSE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// gcode
		$this->gcode = new DbField('ref_multi', 'ref_multi', 'x_gcode', 'gcode', '`gcode`', '`gcode`', 200, -1, FALSE, '`gcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gcode->Sortable = FALSE; // Allow sort
		$this->fields['gcode'] = &$this->gcode;

		// code
		$this->code = new DbField('ref_multi', 'ref_multi', 'x_code', 'code', '`code`', '`code`', 200, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code->Sortable = FALSE; // Allow sort
		$this->fields['code'] = &$this->code;

		// product_id
		$this->product_id = new DbField('ref_multi', 'ref_multi', 'x_product_id', 'product_id', '`product_id`', '`product_id`', 200, -1, FALSE, '`product_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_id->Sortable = FALSE; // Allow sort
		$this->fields['product_id'] = &$this->product_id;

		// print_name
		$this->print_name = new DbField('ref_multi', 'ref_multi', 'x_print_name', 'print_name', '`print_name`', '`print_name`', 200, -1, FALSE, '`print_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->print_name->Sortable = FALSE; // Allow sort
		$this->print_name->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['print_name'] = &$this->print_name;

		// batch_no
		$this->batch_no = new DbField('ref_multi', 'ref_multi', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 200, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Sortable = FALSE; // Allow sort
		$this->fields['batch_no'] = &$this->batch_no;

		// last_price
		$this->last_price = new DbField('ref_multi', 'ref_multi', 'x_last_price', 'last_price', '`last_price`', '`last_price`', 200, -1, FALSE, '`last_price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->last_price->Sortable = TRUE; // Allow sort
		$this->last_price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['last_price'] = &$this->last_price;

		// v_01
		$this->v_01 = new DbField('ref_multi', 'ref_multi', 'x_v_01', 'v_01', '`v_01`', '`v_01`', 200, -1, FALSE, '`v_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_01->Required = TRUE; // Required field
		$this->v_01->Sortable = TRUE; // Allow sort
		$this->v_01->Lookup = new Lookup('v_01', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`code` ASC', '');
		$this->fields['v_01'] = &$this->v_01;

		// v_02
		$this->v_02 = new DbField('ref_multi', 'ref_multi', 'x_v_02', 'v_02', '`v_02`', '`v_02`', 200, -1, FALSE, '`v_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_02->Required = TRUE; // Required field
		$this->v_02->Sortable = TRUE; // Allow sort
		$this->v_02->Lookup = new Lookup('v_02', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_02'] = &$this->v_02;

		// v_03
		$this->v_03 = new DbField('ref_multi', 'ref_multi', 'x_v_03', 'v_03', '`v_03`', '`v_03`', 200, -1, FALSE, '`v_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_03->Required = TRUE; // Required field
		$this->v_03->Sortable = TRUE; // Allow sort
		$this->v_03->Lookup = new Lookup('v_03', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_03'] = &$this->v_03;

		// v_04
		$this->v_04 = new DbField('ref_multi', 'ref_multi', 'x_v_04', 'v_04', '`v_04`', '`v_04`', 200, -1, FALSE, '`v_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_04->Required = TRUE; // Required field
		$this->v_04->Sortable = TRUE; // Allow sort
		$this->v_04->Lookup = new Lookup('v_04', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_04'] = &$this->v_04;

		// v_05
		$this->v_05 = new DbField('ref_multi', 'ref_multi', 'x_v_05', 'v_05', '`v_05`', '`v_05`', 200, -1, FALSE, '`v_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_05->Required = TRUE; // Required field
		$this->v_05->Sortable = TRUE; // Allow sort
		$this->v_05->Lookup = new Lookup('v_05', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_05'] = &$this->v_05;

		// v_06
		$this->v_06 = new DbField('ref_multi', 'ref_multi', 'x_v_06', 'v_06', '`v_06`', '`v_06`', 200, -1, FALSE, '`v_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_06->Sortable = TRUE; // Allow sort
		$this->v_06->Lookup = new Lookup('v_06', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_06'] = &$this->v_06;

		// v_07
		$this->v_07 = new DbField('ref_multi', 'ref_multi', 'x_v_07', 'v_07', '`v_07`', '`v_07`', 200, -1, FALSE, '`v_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_07->Sortable = TRUE; // Allow sort
		$this->v_07->Lookup = new Lookup('v_07', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_07'] = &$this->v_07;

		// v_08
		$this->v_08 = new DbField('ref_multi', 'ref_multi', 'x_v_08', 'v_08', '`v_08`', '`v_08`', 200, -1, FALSE, '`v_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_08->Sortable = TRUE; // Allow sort
		$this->v_08->Lookup = new Lookup('v_08', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_08'] = &$this->v_08;

		// v_09
		$this->v_09 = new DbField('ref_multi', 'ref_multi', 'x_v_09', 'v_09', '`v_09`', '`v_09`', 200, -1, FALSE, '`v_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_09->Sortable = TRUE; // Allow sort
		$this->v_09->Lookup = new Lookup('v_09', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_09'] = &$this->v_09;

		// v_10
		$this->v_10 = new DbField('ref_multi', 'ref_multi', 'x_v_10', 'v_10', '`v_10`', '`v_10`', 200, -1, FALSE, '`v_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->v_10->Sortable = TRUE; // Allow sort
		$this->v_10->Lookup = new Lookup('v_10', '_varient_view', TRUE, 'code', ["code","name","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['v_10'] = &$this->v_10;

		// cbm
		$this->cbm = new DbField('ref_multi', 'ref_multi', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 4, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->fields['cbm'] = &$this->cbm;

		// sqm
		$this->sqm = new DbField('ref_multi', 'ref_multi', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 4, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->fields['sqm'] = &$this->sqm;

		// shape
		$this->shape = new DbField('ref_multi', 'ref_multi', 'x_shape', 'shape', '`shape`', '`shape`', 200, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Sortable = TRUE; // Allow sort
		$this->shape->SelectMultiple = TRUE; // Multiple select
		$this->shape->Lookup = new Lookup('shape', 'shape', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['shape'] = &$this->shape;

		// b_01
		$this->b_01 = new DbField('ref_multi', 'ref_multi', 'x_b_01', 'b_01', '`b_01`', '`b_01`', 200, -1, FALSE, '`b_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_01->Sortable = TRUE; // Allow sort
		$this->fields['b_01'] = &$this->b_01;

		// b_02
		$this->b_02 = new DbField('ref_multi', 'ref_multi', 'x_b_02', 'b_02', '`b_02`', '`b_02`', 200, -1, FALSE, '`b_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_02->Sortable = TRUE; // Allow sort
		$this->fields['b_02'] = &$this->b_02;

		// b_03
		$this->b_03 = new DbField('ref_multi', 'ref_multi', 'x_b_03', 'b_03', '`b_03`', '`b_03`', 200, -1, FALSE, '`b_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_03->Sortable = TRUE; // Allow sort
		$this->b_03->Lookup = new Lookup('b_03', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_03'] = &$this->b_03;

		// b_04
		$this->b_04 = new DbField('ref_multi', 'ref_multi', 'x_b_04', 'b_04', '`b_04`', '`b_04`', 200, -1, FALSE, '`b_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_04->Sortable = TRUE; // Allow sort
		$this->b_04->Lookup = new Lookup('b_04', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_04'] = &$this->b_04;

		// b_05
		$this->b_05 = new DbField('ref_multi', 'ref_multi', 'x_b_05', 'b_05', '`b_05`', '`b_05`', 200, -1, FALSE, '`b_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_05->Sortable = TRUE; // Allow sort
		$this->b_05->Lookup = new Lookup('b_05', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_05'] = &$this->b_05;

		// b_06
		$this->b_06 = new DbField('ref_multi', 'ref_multi', 'x_b_06', 'b_06', '`b_06`', '`b_06`', 200, -1, FALSE, '`b_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_06->Sortable = TRUE; // Allow sort
		$this->b_06->Lookup = new Lookup('b_06', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_06'] = &$this->b_06;

		// b_07
		$this->b_07 = new DbField('ref_multi', 'ref_multi', 'x_b_07', 'b_07', '`b_07`', '`b_07`', 200, -1, FALSE, '`b_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_07->Sortable = TRUE; // Allow sort
		$this->b_07->Lookup = new Lookup('b_07', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_07'] = &$this->b_07;

		// b_08
		$this->b_08 = new DbField('ref_multi', 'ref_multi', 'x_b_08', 'b_08', '`b_08`', '`b_08`', 200, -1, FALSE, '`b_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_08->Sortable = TRUE; // Allow sort
		$this->b_08->Lookup = new Lookup('b_08', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_08'] = &$this->b_08;

		// b_09
		$this->b_09 = new DbField('ref_multi', 'ref_multi', 'x_b_09', 'b_09', '`b_09`', '`b_09`', 200, -1, FALSE, '`b_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_09->Sortable = TRUE; // Allow sort
		$this->b_09->Lookup = new Lookup('b_09', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_09'] = &$this->b_09;

		// b_10
		$this->b_10 = new DbField('ref_multi', 'ref_multi', 'x_b_10', 'b_10', '`b_10`', '`b_10`', 200, -1, FALSE, '`b_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->b_10->Sortable = TRUE; // Allow sort
		$this->b_10->Lookup = new Lookup('b_10', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['b_10'] = &$this->b_10;

		// b_11
		$this->b_11 = new DbField('ref_multi', 'ref_multi', 'x_b_11', 'b_11', '`b_11`', '`b_11`', 200, -1, FALSE, '`b_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_11->Sortable = TRUE; // Allow sort
		$this->fields['b_11'] = &$this->b_11;

		// b_12
		$this->b_12 = new DbField('ref_multi', 'ref_multi', 'x_b_12', 'b_12', '`b_12`', '`b_12`', 200, -1, FALSE, '`b_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_12->Sortable = TRUE; // Allow sort
		$this->fields['b_12'] = &$this->b_12;

		// b_13
		$this->b_13 = new DbField('ref_multi', 'ref_multi', 'x_b_13', 'b_13', '`b_13`', '`b_13`', 200, -1, FALSE, '`b_13`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_13->Sortable = TRUE; // Allow sort
		$this->fields['b_13'] = &$this->b_13;

		// b_14
		$this->b_14 = new DbField('ref_multi', 'ref_multi', 'x_b_14', 'b_14', '`b_14`', '`b_14`', 200, -1, FALSE, '`b_14`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_14->Sortable = TRUE; // Allow sort
		$this->fields['b_14'] = &$this->b_14;

		// b_15
		$this->b_15 = new DbField('ref_multi', 'ref_multi', 'x_b_15', 'b_15', '`b_15`', '`b_15`', 200, -1, FALSE, '`b_15`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->b_15->Sortable = TRUE; // Allow sort
		$this->b_15->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->b_15->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->fields['b_15'] = &$this->b_15;

		// t_01
		$this->t_01 = new DbField('ref_multi', 'ref_multi', 'x_t_01', 't_01', '`t_01`', '`t_01`', 200, -1, FALSE, '`t_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_01->Sortable = TRUE; // Allow sort
		$this->fields['t_01'] = &$this->t_01;

		// t_02
		$this->t_02 = new DbField('ref_multi', 'ref_multi', 'x_t_02', 't_02', '`t_02`', '`t_02`', 200, -1, FALSE, '`t_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_02->Sortable = TRUE; // Allow sort
		$this->fields['t_02'] = &$this->t_02;

		// t_03
		$this->t_03 = new DbField('ref_multi', 'ref_multi', 'x_t_03', 't_03', '`t_03`', '`t_03`', 200, -1, FALSE, '`t_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_03->Sortable = TRUE; // Allow sort
		$this->t_03->Lookup = new Lookup('t_03', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_03'] = &$this->t_03;

		// t_04
		$this->t_04 = new DbField('ref_multi', 'ref_multi', 'x_t_04', 't_04', '`t_04`', '`t_04`', 200, -1, FALSE, '`t_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_04->Sortable = TRUE; // Allow sort
		$this->t_04->Lookup = new Lookup('t_04', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_04'] = &$this->t_04;

		// t_05
		$this->t_05 = new DbField('ref_multi', 'ref_multi', 'x_t_05', 't_05', '`t_05`', '`t_05`', 200, -1, FALSE, '`t_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_05->Sortable = TRUE; // Allow sort
		$this->t_05->Lookup = new Lookup('t_05', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_05'] = &$this->t_05;

		// t_06
		$this->t_06 = new DbField('ref_multi', 'ref_multi', 'x_t_06', 't_06', '`t_06`', '`t_06`', 200, -1, FALSE, '`t_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_06->Sortable = TRUE; // Allow sort
		$this->t_06->Lookup = new Lookup('t_06', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_06'] = &$this->t_06;

		// t_07
		$this->t_07 = new DbField('ref_multi', 'ref_multi', 'x_t_07', 't_07', '`t_07`', '`t_07`', 200, -1, FALSE, '`t_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_07->Sortable = TRUE; // Allow sort
		$this->t_07->Lookup = new Lookup('t_07', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_07'] = &$this->t_07;

		// t_08
		$this->t_08 = new DbField('ref_multi', 'ref_multi', 'x_t_08', 't_08', '`t_08`', '`t_08`', 200, -1, FALSE, '`t_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_08->Sortable = TRUE; // Allow sort
		$this->t_08->Lookup = new Lookup('t_08', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_08'] = &$this->t_08;

		// t_09
		$this->t_09 = new DbField('ref_multi', 'ref_multi', 'x_t_09', 't_09', '`t_09`', '`t_09`', 200, -1, FALSE, '`t_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_09->Sortable = TRUE; // Allow sort
		$this->t_09->Lookup = new Lookup('t_09', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_09'] = &$this->t_09;

		// t_10
		$this->t_10 = new DbField('ref_multi', 'ref_multi', 'x_t_10', 't_10', '`t_10`', '`t_10`', 200, -1, FALSE, '`t_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->t_10->Sortable = TRUE; // Allow sort
		$this->t_10->Lookup = new Lookup('t_10', '_varient_view', TRUE, 'name', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], '`name` ASC', '');
		$this->fields['t_10'] = &$this->t_10;

		// t_11
		$this->t_11 = new DbField('ref_multi', 'ref_multi', 'x_t_11', 't_11', '`t_11`', '`t_11`', 200, -1, FALSE, '`t_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_11->Sortable = TRUE; // Allow sort
		$this->t_11->Lookup = new Lookup('t_11', '_varient_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['t_11'] = &$this->t_11;

		// t_12
		$this->t_12 = new DbField('ref_multi', 'ref_multi', 'x_t_12', 't_12', '`t_12`', '`t_12`', 200, -1, FALSE, '`t_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_12->Sortable = TRUE; // Allow sort
		$this->t_12->Lookup = new Lookup('t_12', '_varient_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['t_12'] = &$this->t_12;

		// t_13
		$this->t_13 = new DbField('ref_multi', 'ref_multi', 'x_t_13', 't_13', '`t_13`', '`t_13`', 200, -1, FALSE, '`t_13`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_13->Sortable = TRUE; // Allow sort
		$this->fields['t_13'] = &$this->t_13;

		// t_14
		$this->t_14 = new DbField('ref_multi', 'ref_multi', 'x_t_14', 't_14', '`t_14`', '`t_14`', 200, -1, FALSE, '`t_14`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_14->Sortable = TRUE; // Allow sort
		$this->fields['t_14'] = &$this->t_14;

		// t_15
		$this->t_15 = new DbField('ref_multi', 'ref_multi', 'x_t_15', 't_15', '`t_15`', '`t_15`', 200, -1, FALSE, '`t_15`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_15->Sortable = TRUE; // Allow sort
		$this->fields['t_15'] = &$this->t_15;

		// d_head_01
		$this->d_head_01 = new DbField('ref_multi', 'ref_multi', 'x_d_head_01', 'd_head_01', '`d_head_01`', '`d_head_01`', 200, -1, FALSE, '`d_head_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_head_01->Sortable = TRUE; // Allow sort
		$this->fields['d_head_01'] = &$this->d_head_01;

		// d_description_01
		$this->d_description_01 = new DbField('ref_multi', 'ref_multi', 'x_d_description_01', 'd_description_01', '`d_description_01`', '`d_description_01`', 201, -1, FALSE, '`d_description_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->d_description_01->Sortable = TRUE; // Allow sort
		$this->fields['d_description_01'] = &$this->d_description_01;

		// d_head_02
		$this->d_head_02 = new DbField('ref_multi', 'ref_multi', 'x_d_head_02', 'd_head_02', '`d_head_02`', '`d_head_02`', 200, -1, FALSE, '`d_head_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_head_02->Sortable = TRUE; // Allow sort
		$this->fields['d_head_02'] = &$this->d_head_02;

		// d_description_02
		$this->d_description_02 = new DbField('ref_multi', 'ref_multi', 'x_d_description_02', 'd_description_02', '`d_description_02`', '`d_description_02`', 201, -1, FALSE, '`d_description_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->d_description_02->Sortable = TRUE; // Allow sort
		$this->fields['d_description_02'] = &$this->d_description_02;

		// main_image
		$this->main_image = new DbField('ref_multi', 'ref_multi', 'x_main_image', 'main_image', '`main_image`', '`main_image`', 200, -1, TRUE, '`main_image`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->main_image->Sortable = TRUE; // Allow sort
		$this->main_image->UploadMultiple = TRUE;
		$this->main_image->Upload->UploadMultiple = TRUE;
		$this->main_image->UploadMaxFileCount = 0;
		$this->fields['main_image'] = &$this->main_image;

		// top_view
		$this->top_view = new DbField('ref_multi', 'ref_multi', 'x_top_view', 'top_view', '`top_view`', '`top_view`', 200, -1, TRUE, '`top_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->top_view->Sortable = TRUE; // Allow sort
		$this->top_view->UploadMultiple = TRUE;
		$this->top_view->Upload->UploadMultiple = TRUE;
		$this->top_view->UploadMaxFileCount = 0;
		$this->fields['top_view'] = &$this->top_view;

		// front_view
		$this->front_view = new DbField('ref_multi', 'ref_multi', 'x_front_view', 'front_view', '`front_view`', '`front_view`', 200, -1, TRUE, '`front_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->front_view->Sortable = TRUE; // Allow sort
		$this->front_view->UploadMultiple = TRUE;
		$this->front_view->Upload->UploadMultiple = TRUE;
		$this->front_view->UploadMaxFileCount = 0;
		$this->fields['front_view'] = &$this->front_view;

		// corner_view
		$this->corner_view = new DbField('ref_multi', 'ref_multi', 'x_corner_view', 'corner_view', '`corner_view`', '`corner_view`', 200, -1, TRUE, '`corner_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->corner_view->Sortable = TRUE; // Allow sort
		$this->corner_view->UploadMultiple = TRUE;
		$this->corner_view->Upload->UploadMultiple = TRUE;
		$this->corner_view->UploadMaxFileCount = 0;
		$this->fields['corner_view'] = &$this->corner_view;

		// back_view
		$this->back_view = new DbField('ref_multi', 'ref_multi', 'x_back_view', 'back_view', '`back_view`', '`back_view`', 200, -1, TRUE, '`back_view`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->back_view->Sortable = TRUE; // Allow sort
		$this->back_view->UploadMultiple = TRUE;
		$this->back_view->Upload->UploadMultiple = TRUE;
		$this->back_view->UploadMaxFileCount = 0;
		$this->fields['back_view'] = &$this->back_view;

		// color_options
		$this->color_options = new DbField('ref_multi', 'ref_multi', 'x_color_options', 'color_options', '`color_options`', '`color_options`', 200, -1, TRUE, '`color_options`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->color_options->Sortable = TRUE; // Allow sort
		$this->color_options->UploadMultiple = TRUE;
		$this->color_options->Upload->UploadMultiple = TRUE;
		$this->color_options->UploadMaxFileCount = 0;
		$this->fields['color_options'] = &$this->color_options;

		// other_options
		$this->other_options = new DbField('ref_multi', 'ref_multi', 'x_other_options', 'other_options', '`other_options`', '`other_options`', 200, -1, TRUE, '`other_options`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->other_options->Sortable = TRUE; // Allow sort
		$this->other_options->UploadMultiple = TRUE;
		$this->other_options->Upload->UploadMultiple = TRUE;
		$this->other_options->UploadMaxFileCount = 0;
		$this->fields['other_options'] = &$this->other_options;

		// image
		$this->image = new DbField('ref_multi', 'ref_multi', 'x_image', 'image', '`image`', '`image`', 200, -1, TRUE, '`image`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->image->Sortable = TRUE; // Allow sort
		$this->image->ImageResize = TRUE;
		$this->image->UploadMultiple = TRUE;
		$this->image->Upload->UploadMultiple = TRUE;
		$this->image->UploadMaxFileCount = 0;
		$this->fields['image'] = &$this->image;

		// video_url
		$this->video_url = new DbField('ref_multi', 'ref_multi', 'x_video_url', 'video_url', '`video_url`', '`video_url`', 200, -1, FALSE, '`video_url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->video_url->Sortable = TRUE; // Allow sort
		$this->fields['video_url'] = &$this->video_url;

		// currency
		$this->currency = new DbField('ref_multi', 'ref_multi', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Nullable = FALSE; // NOT NULL field
		$this->currency->Required = TRUE; // Required field
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// hsn
		$this->hsn = new DbField('ref_multi', 'ref_multi', 'x_hsn', 'hsn', '`hsn`', '`hsn`', 3, -1, FALSE, '`hsn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->hsn->Sortable = TRUE; // Allow sort
		$this->hsn->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->hsn->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->hsn->Lookup = new Lookup('hsn', 'tax_category', TRUE, 'id', ["item","hsn_code","tax_percent",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->hsn->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['hsn'] = &$this->hsn;

		// minimum_stock
		$this->minimum_stock = new DbField('ref_multi', 'ref_multi', 'x_minimum_stock', 'minimum_stock', '`minimum_stock`', '`minimum_stock`', 131, -1, FALSE, '`minimum_stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->minimum_stock->Nullable = FALSE; // NOT NULL field
		$this->minimum_stock->Sortable = FALSE; // Allow sort
		$this->minimum_stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['minimum_stock'] = &$this->minimum_stock;

		// in
		$this->in = new DbField('ref_multi', 'ref_multi', 'x_in', 'in', '`in`', '`in`', 131, -1, FALSE, '`in`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->in->Nullable = FALSE; // NOT NULL field
		$this->in->Required = TRUE; // Required field
		$this->in->Sortable = FALSE; // Allow sort
		$this->in->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['in'] = &$this->in;

		// out
		$this->out = new DbField('ref_multi', 'ref_multi', 'x_out', 'out', '`out`', '`out`', 131, -1, FALSE, '`out`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->out->Nullable = FALSE; // NOT NULL field
		$this->out->Required = TRUE; // Required field
		$this->out->Sortable = FALSE; // Allow sort
		$this->out->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['out'] = &$this->out;

		// required
		$this->required = new DbField('ref_multi', 'ref_multi', 'x_required', 'required', '`required`', '`required`', 131, -1, FALSE, '`required`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->required->Nullable = FALSE; // NOT NULL field
		$this->required->Required = TRUE; // Required field
		$this->required->Sortable = FALSE; // Allow sort
		$this->required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['required'] = &$this->required;

		// blocked
		$this->blocked = new DbField('ref_multi', 'ref_multi', 'x_blocked', 'blocked', '`blocked`', '`blocked`', 131, -1, FALSE, '`blocked`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->blocked->Nullable = FALSE; // NOT NULL field
		$this->blocked->Required = TRUE; // Required field
		$this->blocked->Sortable = FALSE; // Allow sort
		$this->blocked->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['blocked'] = &$this->blocked;

		// ordered
		$this->ordered = new DbField('ref_multi', 'ref_multi', 'x_ordered', 'ordered', '`ordered`', '`ordered`', 131, -1, FALSE, '`ordered`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ordered->Nullable = FALSE; // NOT NULL field
		$this->ordered->Required = TRUE; // Required field
		$this->ordered->Sortable = FALSE; // Allow sort
		$this->ordered->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ordered'] = &$this->ordered;

		// status
		$this->status = new DbField('ref_multi', 'ref_multi', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'ref_multi', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// publish
		$this->publish = new DbField('ref_multi', 'ref_multi', 'x_publish', 'publish', '`publish`', '`publish`', 2, -1, FALSE, '`publish`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->publish->Sortable = TRUE; // Allow sort
		$this->publish->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->publish->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->publish->Lookup = new Lookup('publish', 'ref_multi', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->publish->OptionCount = 2;
		$this->fields['publish'] = &$this->publish;

		// operator
		$this->operator = new DbField('ref_multi', 'ref_multi', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('ref_multi', 'ref_multi', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "_ref_view") {
			$detailUrl = $GLOBALS["_ref_view"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "ref_multilist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`ref_multi`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Company_ID() == 0) ? "product_type = 9" : "`company_id` = " .  User_Company_ID()  . " and product_type = 9";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->oid->DbValue = $row['oid'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->company_id->DbValue = $row['company_id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->product_n->DbValue = $row['product_n'];
		$this->product_type->DbValue = $row['product_type'];
		$this->product_code->DbValue = $row['product_code'];
		$this->gcode->DbValue = $row['gcode'];
		$this->code->DbValue = $row['code'];
		$this->product_id->DbValue = $row['product_id'];
		$this->print_name->DbValue = $row['print_name'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->last_price->DbValue = $row['last_price'];
		$this->v_01->DbValue = $row['v_01'];
		$this->v_02->DbValue = $row['v_02'];
		$this->v_03->DbValue = $row['v_03'];
		$this->v_04->DbValue = $row['v_04'];
		$this->v_05->DbValue = $row['v_05'];
		$this->v_06->DbValue = $row['v_06'];
		$this->v_07->DbValue = $row['v_07'];
		$this->v_08->DbValue = $row['v_08'];
		$this->v_09->DbValue = $row['v_09'];
		$this->v_10->DbValue = $row['v_10'];
		$this->cbm->DbValue = $row['cbm'];
		$this->sqm->DbValue = $row['sqm'];
		$this->shape->DbValue = $row['shape'];
		$this->b_01->DbValue = $row['b_01'];
		$this->b_02->DbValue = $row['b_02'];
		$this->b_03->DbValue = $row['b_03'];
		$this->b_04->DbValue = $row['b_04'];
		$this->b_05->DbValue = $row['b_05'];
		$this->b_06->DbValue = $row['b_06'];
		$this->b_07->DbValue = $row['b_07'];
		$this->b_08->DbValue = $row['b_08'];
		$this->b_09->DbValue = $row['b_09'];
		$this->b_10->DbValue = $row['b_10'];
		$this->b_11->DbValue = $row['b_11'];
		$this->b_12->DbValue = $row['b_12'];
		$this->b_13->DbValue = $row['b_13'];
		$this->b_14->DbValue = $row['b_14'];
		$this->b_15->DbValue = $row['b_15'];
		$this->t_01->DbValue = $row['t_01'];
		$this->t_02->DbValue = $row['t_02'];
		$this->t_03->DbValue = $row['t_03'];
		$this->t_04->DbValue = $row['t_04'];
		$this->t_05->DbValue = $row['t_05'];
		$this->t_06->DbValue = $row['t_06'];
		$this->t_07->DbValue = $row['t_07'];
		$this->t_08->DbValue = $row['t_08'];
		$this->t_09->DbValue = $row['t_09'];
		$this->t_10->DbValue = $row['t_10'];
		$this->t_11->DbValue = $row['t_11'];
		$this->t_12->DbValue = $row['t_12'];
		$this->t_13->DbValue = $row['t_13'];
		$this->t_14->DbValue = $row['t_14'];
		$this->t_15->DbValue = $row['t_15'];
		$this->d_head_01->DbValue = $row['d_head_01'];
		$this->d_description_01->DbValue = $row['d_description_01'];
		$this->d_head_02->DbValue = $row['d_head_02'];
		$this->d_description_02->DbValue = $row['d_description_02'];
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->top_view->Upload->DbValue = $row['top_view'];
		$this->front_view->Upload->DbValue = $row['front_view'];
		$this->corner_view->Upload->DbValue = $row['corner_view'];
		$this->back_view->Upload->DbValue = $row['back_view'];
		$this->color_options->Upload->DbValue = $row['color_options'];
		$this->other_options->Upload->DbValue = $row['other_options'];
		$this->image->Upload->DbValue = $row['image'];
		$this->video_url->DbValue = $row['video_url'];
		$this->currency->DbValue = $row['currency'];
		$this->hsn->DbValue = $row['hsn'];
		$this->minimum_stock->DbValue = $row['minimum_stock'];
		$this->in->DbValue = $row['in'];
		$this->out->DbValue = $row['out'];
		$this->required->DbValue = $row['required'];
		$this->blocked->DbValue = $row['blocked'];
		$this->ordered->DbValue = $row['ordered'];
		$this->status->DbValue = $row['status'];
		$this->publish->DbValue = $row['publish'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->main_image->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['main_image']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['main_image']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->main_image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->main_image->oldPhysicalUploadPath() . $oldFile);
		}
		$this->top_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['top_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['top_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->top_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->top_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->front_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['front_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['front_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->front_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->front_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->corner_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['corner_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['corner_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->corner_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->corner_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->back_view->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['back_view']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['back_view']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->back_view->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->back_view->oldPhysicalUploadPath() . $oldFile);
		}
		$this->color_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['color_options']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['color_options']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->color_options->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->color_options->oldPhysicalUploadPath() . $oldFile);
		}
		$this->other_options->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['other_options']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['other_options']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->other_options->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->other_options->oldPhysicalUploadPath() . $oldFile);
		}
		$this->image->OldUploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['image']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['image']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "ref_multilist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "ref_multiview.php")
			return $Language->phrase("View");
		elseif ($pageName == "ref_multiedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "ref_multiadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "ref_multilist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("ref_multiview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ref_multiview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "ref_multiadd.php?" . $this->getUrlParm($parm);
		else
			$url = "ref_multiadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("ref_multiedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ref_multiedit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("ref_multiadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ref_multiadd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("ref_multidelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->oid->setDbValue($rs->fields('oid'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_n->setDbValue($rs->fields('product_n'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->gcode->setDbValue($rs->fields('gcode'));
		$this->code->setDbValue($rs->fields('code'));
		$this->product_id->setDbValue($rs->fields('product_id'));
		$this->print_name->setDbValue($rs->fields('print_name'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->last_price->setDbValue($rs->fields('last_price'));
		$this->v_01->setDbValue($rs->fields('v_01'));
		$this->v_02->setDbValue($rs->fields('v_02'));
		$this->v_03->setDbValue($rs->fields('v_03'));
		$this->v_04->setDbValue($rs->fields('v_04'));
		$this->v_05->setDbValue($rs->fields('v_05'));
		$this->v_06->setDbValue($rs->fields('v_06'));
		$this->v_07->setDbValue($rs->fields('v_07'));
		$this->v_08->setDbValue($rs->fields('v_08'));
		$this->v_09->setDbValue($rs->fields('v_09'));
		$this->v_10->setDbValue($rs->fields('v_10'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->b_01->setDbValue($rs->fields('b_01'));
		$this->b_02->setDbValue($rs->fields('b_02'));
		$this->b_03->setDbValue($rs->fields('b_03'));
		$this->b_04->setDbValue($rs->fields('b_04'));
		$this->b_05->setDbValue($rs->fields('b_05'));
		$this->b_06->setDbValue($rs->fields('b_06'));
		$this->b_07->setDbValue($rs->fields('b_07'));
		$this->b_08->setDbValue($rs->fields('b_08'));
		$this->b_09->setDbValue($rs->fields('b_09'));
		$this->b_10->setDbValue($rs->fields('b_10'));
		$this->b_11->setDbValue($rs->fields('b_11'));
		$this->b_12->setDbValue($rs->fields('b_12'));
		$this->b_13->setDbValue($rs->fields('b_13'));
		$this->b_14->setDbValue($rs->fields('b_14'));
		$this->b_15->setDbValue($rs->fields('b_15'));
		$this->t_01->setDbValue($rs->fields('t_01'));
		$this->t_02->setDbValue($rs->fields('t_02'));
		$this->t_03->setDbValue($rs->fields('t_03'));
		$this->t_04->setDbValue($rs->fields('t_04'));
		$this->t_05->setDbValue($rs->fields('t_05'));
		$this->t_06->setDbValue($rs->fields('t_06'));
		$this->t_07->setDbValue($rs->fields('t_07'));
		$this->t_08->setDbValue($rs->fields('t_08'));
		$this->t_09->setDbValue($rs->fields('t_09'));
		$this->t_10->setDbValue($rs->fields('t_10'));
		$this->t_11->setDbValue($rs->fields('t_11'));
		$this->t_12->setDbValue($rs->fields('t_12'));
		$this->t_13->setDbValue($rs->fields('t_13'));
		$this->t_14->setDbValue($rs->fields('t_14'));
		$this->t_15->setDbValue($rs->fields('t_15'));
		$this->d_head_01->setDbValue($rs->fields('d_head_01'));
		$this->d_description_01->setDbValue($rs->fields('d_description_01'));
		$this->d_head_02->setDbValue($rs->fields('d_head_02'));
		$this->d_description_02->setDbValue($rs->fields('d_description_02'));
		$this->main_image->Upload->DbValue = $rs->fields('main_image');
		$this->top_view->Upload->DbValue = $rs->fields('top_view');
		$this->front_view->Upload->DbValue = $rs->fields('front_view');
		$this->corner_view->Upload->DbValue = $rs->fields('corner_view');
		$this->back_view->Upload->DbValue = $rs->fields('back_view');
		$this->color_options->Upload->DbValue = $rs->fields('color_options');
		$this->other_options->Upload->DbValue = $rs->fields('other_options');
		$this->image->Upload->DbValue = $rs->fields('image');
		$this->video_url->setDbValue($rs->fields('video_url'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->hsn->setDbValue($rs->fields('hsn'));
		$this->minimum_stock->setDbValue($rs->fields('minimum_stock'));
		$this->in->setDbValue($rs->fields('in'));
		$this->out->setDbValue($rs->fields('out'));
		$this->required->setDbValue($rs->fields('required'));
		$this->blocked->setDbValue($rs->fields('blocked'));
		$this->ordered->setDbValue($rs->fields('ordered'));
		$this->status->setDbValue($rs->fields('status'));
		$this->publish->setDbValue($rs->fields('publish'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// oid

		$this->oid->CellCssStyle = "white-space: nowrap;";

		// barcode
		$this->_barcode->CellCssStyle = "white-space: nowrap;";

		// company_id
		// grp
		// s_grp
		// product
		// product_n
		// product_type
		// product_code

		$this->product_code->CellCssStyle = "white-space: nowrap;";

		// gcode
		$this->gcode->CellCssStyle = "white-space: nowrap;";

		// code
		$this->code->CellCssStyle = "white-space: nowrap;";

		// product_id
		$this->product_id->CellCssStyle = "white-space: nowrap;";

		// print_name
		$this->print_name->CellCssStyle = "white-space: nowrap;";

		// batch_no
		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// last_price
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// v_06
		// v_07
		// v_08
		// v_09
		// v_10
		// cbm
		// sqm
		// shape
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// image
		// video_url
		// currency
		// hsn
		// minimum_stock

		$this->minimum_stock->CellCssStyle = "white-space: nowrap;";

		// in
		$this->in->CellCssStyle = "white-space: nowrap;";

		// out
		$this->out->CellCssStyle = "white-space: nowrap;";

		// required
		$this->required->CellCssStyle = "white-space: nowrap;";

		// blocked
		$this->blocked->CellCssStyle = "white-space: nowrap;";

		// ordered
		$this->ordered->CellCssStyle = "white-space: nowrap;";

		// status
		// publish
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// oid
		$this->oid->ViewValue = $this->oid->CurrentValue;
		$this->oid->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// product_n
		$this->product_n->ViewValue = $this->product_n->CurrentValue;
		$this->product_n->ViewCustomAttributes = "";

		// product_type
		$this->product_type->ViewValue = $this->product_type->CurrentValue;
		$curVal = strval($this->product_type->CurrentValue);
		if ($curVal <> "") {
			$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			if ($this->product_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `id` = 9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_type->ViewValue = $this->product_type->CurrentValue;
				}
			}
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// gcode
		$this->gcode->ViewValue = $this->gcode->CurrentValue;
		$this->gcode->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// product_id
		$this->product_id->ViewValue = $this->product_id->CurrentValue;
		$this->product_id->ViewCustomAttributes = "";

		// print_name
		$this->print_name->ViewValue = $this->print_name->CurrentValue;
		$this->print_name->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewCustomAttributes = "";

		// last_price
		$this->last_price->ViewValue = $this->last_price->CurrentValue;
		$this->last_price->ViewCustomAttributes = "";

		// v_01
		$curVal = strval($this->v_01->CurrentValue);
		if ($curVal <> "") {
			$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
			if ($this->v_01->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 101 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_01->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_01->ViewValue = $this->v_01->CurrentValue;
				}
			}
		} else {
			$this->v_01->ViewValue = NULL;
		}
		$this->v_01->ViewCustomAttributes = "";

		// v_02
		$curVal = strval($this->v_02->CurrentValue);
		if ($curVal <> "") {
			$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
			if ($this->v_02->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 102 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_02->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_02->ViewValue = $this->v_02->CurrentValue;
				}
			}
		} else {
			$this->v_02->ViewValue = NULL;
		}
		$this->v_02->ViewCustomAttributes = "";

		// v_03
		$curVal = strval($this->v_03->CurrentValue);
		if ($curVal <> "") {
			$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
			if ($this->v_03->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 103 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_03->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_03->ViewValue = $this->v_03->CurrentValue;
				}
			}
		} else {
			$this->v_03->ViewValue = NULL;
		}
		$this->v_03->ViewCustomAttributes = "";

		// v_04
		$curVal = strval($this->v_04->CurrentValue);
		if ($curVal <> "") {
			$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
			if ($this->v_04->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 104 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_04->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_04->ViewValue = $this->v_04->CurrentValue;
				}
			}
		} else {
			$this->v_04->ViewValue = NULL;
		}
		$this->v_04->ViewCustomAttributes = "";

		// v_05
		$curVal = strval($this->v_05->CurrentValue);
		if ($curVal <> "") {
			$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
			if ($this->v_05->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 105 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_05->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_05->ViewValue = $this->v_05->CurrentValue;
				}
			}
		} else {
			$this->v_05->ViewValue = NULL;
		}
		$this->v_05->ViewCustomAttributes = "";

		// v_06
		$curVal = strval($this->v_06->CurrentValue);
		if ($curVal <> "") {
			$this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
			if ($this->v_06->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 106 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_06->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_06->ViewValue->add($this->v_06->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_06->ViewValue = $this->v_06->CurrentValue;
				}
			}
		} else {
			$this->v_06->ViewValue = NULL;
		}
		$this->v_06->ViewCustomAttributes = "";

		// v_07
		$curVal = strval($this->v_07->CurrentValue);
		if ($curVal <> "") {
			$this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
			if ($this->v_07->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 107 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_07->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_07->ViewValue->add($this->v_07->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_07->ViewValue = $this->v_07->CurrentValue;
				}
			}
		} else {
			$this->v_07->ViewValue = NULL;
		}
		$this->v_07->ViewCustomAttributes = "";

		// v_08
		$curVal = strval($this->v_08->CurrentValue);
		if ($curVal <> "") {
			$this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
			if ($this->v_08->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 108 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_08->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_08->ViewValue->add($this->v_08->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_08->ViewValue = $this->v_08->CurrentValue;
				}
			}
		} else {
			$this->v_08->ViewValue = NULL;
		}
		$this->v_08->ViewCustomAttributes = "";

		// v_09
		$curVal = strval($this->v_09->CurrentValue);
		if ($curVal <> "") {
			$this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
			if ($this->v_09->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 109 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_09->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_09->ViewValue->add($this->v_09->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_09->ViewValue = $this->v_09->CurrentValue;
				}
			}
		} else {
			$this->v_09->ViewValue = NULL;
		}
		$this->v_09->ViewCustomAttributes = "";

		// v_10
		$curVal = strval($this->v_10->CurrentValue);
		if ($curVal <> "") {
			$this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
			if ($this->v_10->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 110 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->v_10->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->v_10->ViewValue->add($this->v_10->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->v_10->ViewValue = $this->v_10->CurrentValue;
				}
			}
		} else {
			$this->v_10->ViewValue = NULL;
		}
		$this->v_10->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->shape->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// b_01
		$this->b_01->ViewValue = $this->b_01->CurrentValue;
		$this->b_01->ViewCustomAttributes = "";

		// b_02
		$this->b_02->ViewValue = $this->b_02->CurrentValue;
		$this->b_02->ViewCustomAttributes = "";

		// b_03
		$curVal = strval($this->b_03->CurrentValue);
		if ($curVal <> "") {
			$this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
			if ($this->b_03->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 203 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_03->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_03->ViewValue = $this->b_03->CurrentValue;
				}
			}
		} else {
			$this->b_03->ViewValue = NULL;
		}
		$this->b_03->ViewCustomAttributes = "";

		// b_04
		$curVal = strval($this->b_04->CurrentValue);
		if ($curVal <> "") {
			$this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
			if ($this->b_04->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 204 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_04->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_04->ViewValue = $this->b_04->CurrentValue;
				}
			}
		} else {
			$this->b_04->ViewValue = NULL;
		}
		$this->b_04->ViewCustomAttributes = "";

		// b_05
		$curVal = strval($this->b_05->CurrentValue);
		if ($curVal <> "") {
			$this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
			if ($this->b_05->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 205 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_05->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_05->ViewValue = $this->b_05->CurrentValue;
				}
			}
		} else {
			$this->b_05->ViewValue = NULL;
		}
		$this->b_05->ViewCustomAttributes = "";

		// b_06
		$curVal = strval($this->b_06->CurrentValue);
		if ($curVal <> "") {
			$this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
			if ($this->b_06->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 206 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_06->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_06->ViewValue = $this->b_06->CurrentValue;
				}
			}
		} else {
			$this->b_06->ViewValue = NULL;
		}
		$this->b_06->ViewCustomAttributes = "";

		// b_07
		$curVal = strval($this->b_07->CurrentValue);
		if ($curVal <> "") {
			$this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
			if ($this->b_07->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 207 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_07->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_07->ViewValue = $this->b_07->CurrentValue;
				}
			}
		} else {
			$this->b_07->ViewValue = NULL;
		}
		$this->b_07->ViewCustomAttributes = "";

		// b_08
		$curVal = strval($this->b_08->CurrentValue);
		if ($curVal <> "") {
			$this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
			if ($this->b_08->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 208 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_08->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_08->ViewValue = $this->b_08->CurrentValue;
				}
			}
		} else {
			$this->b_08->ViewValue = NULL;
		}
		$this->b_08->ViewCustomAttributes = "";

		// b_09
		$curVal = strval($this->b_09->CurrentValue);
		if ($curVal <> "") {
			$this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
			if ($this->b_09->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 209 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_09->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_09->ViewValue = $this->b_09->CurrentValue;
				}
			}
		} else {
			$this->b_09->ViewValue = NULL;
		}
		$this->b_09->ViewCustomAttributes = "";

		// b_10
		$curVal = strval($this->b_10->CurrentValue);
		if ($curVal <> "") {
			$this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
			if ($this->b_10->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 210 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->b_10->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->b_10->ViewValue = $this->b_10->CurrentValue;
				}
			}
		} else {
			$this->b_10->ViewValue = NULL;
		}
		$this->b_10->ViewCustomAttributes = "";

		// b_11
		$this->b_11->ViewValue = $this->b_11->CurrentValue;
		$this->b_11->ViewCustomAttributes = "";

		// b_12
		$this->b_12->ViewValue = $this->b_12->CurrentValue;
		$this->b_12->ViewCustomAttributes = "";

		// b_13
		$this->b_13->ViewValue = $this->b_13->CurrentValue;
		$this->b_13->ViewCustomAttributes = "";

		// b_14
		$this->b_14->ViewValue = $this->b_14->CurrentValue;
		$this->b_14->ViewCustomAttributes = "";

		// b_15
		$this->b_15->ViewCustomAttributes = "";

		// t_01
		$this->t_01->ViewValue = $this->t_01->CurrentValue;
		$this->t_01->ViewCustomAttributes = "";

		// t_02
		$this->t_02->ViewValue = $this->t_02->CurrentValue;
		$this->t_02->ViewCustomAttributes = "";

		// t_03
		$curVal = strval($this->t_03->CurrentValue);
		if ($curVal <> "") {
			$this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
			if ($this->t_03->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 303 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_03->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_03->ViewValue = $this->t_03->CurrentValue;
				}
			}
		} else {
			$this->t_03->ViewValue = NULL;
		}
		$this->t_03->ViewCustomAttributes = "";

		// t_04
		$curVal = strval($this->t_04->CurrentValue);
		if ($curVal <> "") {
			$this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
			if ($this->t_04->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 304 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_04->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_04->ViewValue = $this->t_04->CurrentValue;
				}
			}
		} else {
			$this->t_04->ViewValue = NULL;
		}
		$this->t_04->ViewCustomAttributes = "";

		// t_05
		$curVal = strval($this->t_05->CurrentValue);
		if ($curVal <> "") {
			$this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
			if ($this->t_05->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 305 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_05->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_05->ViewValue = $this->t_05->CurrentValue;
				}
			}
		} else {
			$this->t_05->ViewValue = NULL;
		}
		$this->t_05->ViewCustomAttributes = "";

		// t_06
		$curVal = strval($this->t_06->CurrentValue);
		if ($curVal <> "") {
			$this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
			if ($this->t_06->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 306 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_06->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_06->ViewValue = $this->t_06->CurrentValue;
				}
			}
		} else {
			$this->t_06->ViewValue = NULL;
		}
		$this->t_06->ViewCustomAttributes = "";

		// t_07
		$curVal = strval($this->t_07->CurrentValue);
		if ($curVal <> "") {
			$this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
			if ($this->t_07->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 307 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_07->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_07->ViewValue = $this->t_07->CurrentValue;
				}
			}
		} else {
			$this->t_07->ViewValue = NULL;
		}
		$this->t_07->ViewCustomAttributes = "";

		// t_08
		$curVal = strval($this->t_08->CurrentValue);
		if ($curVal <> "") {
			$this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
			if ($this->t_08->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 308 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_08->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_08->ViewValue = $this->t_08->CurrentValue;
				}
			}
		} else {
			$this->t_08->ViewValue = NULL;
		}
		$this->t_08->ViewCustomAttributes = "";

		// t_09
		$curVal = strval($this->t_09->CurrentValue);
		if ($curVal <> "") {
			$this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
			if ($this->t_09->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 309 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_09->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_09->ViewValue = $this->t_09->CurrentValue;
				}
			}
		} else {
			$this->t_09->ViewValue = NULL;
		}
		$this->t_09->ViewCustomAttributes = "";

		// t_10
		$curVal = strval($this->t_10->CurrentValue);
		if ($curVal <> "") {
			$this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
			if ($this->t_10->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 310 and (
		(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->t_10->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->t_10->ViewValue = $this->t_10->CurrentValue;
				}
			}
		} else {
			$this->t_10->ViewValue = NULL;
		}
		$this->t_10->ViewCustomAttributes = "";

		// t_11
		$this->t_11->ViewValue = $this->t_11->CurrentValue;
		$curVal = strval($this->t_11->CurrentValue);
		if ($curVal <> "") {
			$this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
			if ($this->t_11->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 311";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->t_11->ViewValue = $this->t_11->CurrentValue;
				}
			}
		} else {
			$this->t_11->ViewValue = NULL;
		}
		$this->t_11->ViewCustomAttributes = "";

		// t_12
		$this->t_12->ViewValue = $this->t_12->CurrentValue;
		$curVal = strval($this->t_12->CurrentValue);
		if ($curVal <> "") {
			$this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
			if ($this->t_12->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 312";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->t_12->ViewValue = $this->t_12->CurrentValue;
				}
			}
		} else {
			$this->t_12->ViewValue = NULL;
		}
		$this->t_12->ViewCustomAttributes = "";

		// t_13
		$this->t_13->ViewValue = $this->t_13->CurrentValue;
		$this->t_13->ViewCustomAttributes = "";

		// t_14
		$this->t_14->ViewValue = $this->t_14->CurrentValue;
		$this->t_14->ViewCustomAttributes = "";

		// t_15
		$this->t_15->ViewValue = $this->t_15->CurrentValue;
		$this->t_15->ViewCustomAttributes = "";

		// d_head_01
		$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
		$this->d_head_01->ViewCustomAttributes = "";

		// d_description_01
		$this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;
		$this->d_description_01->ViewCustomAttributes = "";

		// d_head_02
		$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
		$this->d_head_02->ViewCustomAttributes = "";

		// d_description_02
		$this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;
		$this->d_description_02->ViewCustomAttributes = "";

		// main_image
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->ImageWidth = 0;
			$this->main_image->ImageHeight = 40;
			$this->main_image->ImageAlt = $this->main_image->alt();
			$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
		} else {
			$this->main_image->ViewValue = "";
		}
		$this->main_image->ViewCustomAttributes = "";

		// top_view
		$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->top_view->Upload->DbValue)) {
			$this->top_view->ImageWidth = 0;
			$this->top_view->ImageHeight = 40;
			$this->top_view->ImageAlt = $this->top_view->alt();
			$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
		} else {
			$this->top_view->ViewValue = "";
		}
		$this->top_view->ViewCustomAttributes = "";

		// front_view
		$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->front_view->Upload->DbValue)) {
			$this->front_view->ImageWidth = 0;
			$this->front_view->ImageHeight = 40;
			$this->front_view->ImageAlt = $this->front_view->alt();
			$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
		} else {
			$this->front_view->ViewValue = "";
		}
		$this->front_view->ViewCustomAttributes = "";

		// corner_view
		$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->corner_view->Upload->DbValue)) {
			$this->corner_view->ImageWidth = 0;
			$this->corner_view->ImageHeight = 40;
			$this->corner_view->ImageAlt = $this->corner_view->alt();
			$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
		} else {
			$this->corner_view->ViewValue = "";
		}
		$this->corner_view->ViewCustomAttributes = "";

		// back_view
		$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->back_view->Upload->DbValue)) {
			$this->back_view->ImageWidth = 0;
			$this->back_view->ImageHeight = 40;
			$this->back_view->ImageAlt = $this->back_view->alt();
			$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
		} else {
			$this->back_view->ViewValue = "";
		}
		$this->back_view->ViewCustomAttributes = "";

		// color_options
		$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->color_options->Upload->DbValue)) {
			$this->color_options->ImageWidth = 0;
			$this->color_options->ImageHeight = 40;
			$this->color_options->ImageAlt = $this->color_options->alt();
			$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
		} else {
			$this->color_options->ViewValue = "";
		}
		$this->color_options->ViewCustomAttributes = "";

		// other_options
		$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->other_options->Upload->DbValue)) {
			$this->other_options->ImageWidth = 0;
			$this->other_options->ImageHeight = 40;
			$this->other_options->ImageAlt = $this->other_options->alt();
			$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
		} else {
			$this->other_options->ViewValue = "";
		}
		$this->other_options->ViewCustomAttributes = "";

		// image
		$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 50;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->ViewValue = $this->image->Upload->DbValue;
		} else {
			$this->image->ViewValue = "";
		}
		$this->image->ViewCustomAttributes = "";

		// video_url
		$this->video_url->ViewValue = $this->video_url->CurrentValue;
		$this->video_url->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// hsn
		$curVal = strval($this->hsn->CurrentValue);
		if ($curVal <> "") {
			$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
			if ($this->hsn->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
					$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->hsn->ViewValue = $this->hsn->CurrentValue;
				}
			}
		} else {
			$this->hsn->ViewValue = NULL;
		}
		$this->hsn->ViewCustomAttributes = "";

		// minimum_stock
		$this->minimum_stock->ViewValue = $this->minimum_stock->CurrentValue;
		$this->minimum_stock->ViewValue = FormatNumber($this->minimum_stock->ViewValue, 2, -2, -2, -2);
		$this->minimum_stock->ViewCustomAttributes = "";

		// in
		$this->in->ViewValue = $this->in->CurrentValue;
		$this->in->ViewValue = FormatNumber($this->in->ViewValue, 2, -2, -2, -2);
		$this->in->ViewCustomAttributes = "";

		// out
		$this->out->ViewValue = $this->out->CurrentValue;
		$this->out->ViewValue = FormatNumber($this->out->ViewValue, 2, -2, -2, -2);
		$this->out->ViewCustomAttributes = "";

		// required
		$this->required->ViewValue = $this->required->CurrentValue;
		$this->required->ViewValue = FormatNumber($this->required->ViewValue, 2, -2, -2, -2);
		$this->required->ViewCustomAttributes = "";

		// blocked
		$this->blocked->ViewValue = $this->blocked->CurrentValue;
		$this->blocked->ViewValue = FormatNumber($this->blocked->ViewValue, 2, -2, -2, -2);
		$this->blocked->ViewCustomAttributes = "";

		// ordered
		$this->ordered->ViewValue = $this->ordered->CurrentValue;
		$this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, 2, -2, -2, -2);
		$this->ordered->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// publish
		if (strval($this->publish->CurrentValue) <> "") {
			$this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
		} else {
			$this->publish->ViewValue = NULL;
		}
		$this->publish->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// oid
		$this->oid->LinkCustomAttributes = "";
		$this->oid->HrefValue = "";
		$this->oid->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "ref_list.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// product_n
		$this->product_n->LinkCustomAttributes = "";
		$this->product_n->HrefValue = "";
		$this->product_n->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// gcode
		$this->gcode->LinkCustomAttributes = "";
		$this->gcode->HrefValue = "";
		$this->gcode->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		$this->code->HrefValue = "";
		$this->code->TooltipValue = "";

		// product_id
		$this->product_id->LinkCustomAttributes = "";
		$this->product_id->HrefValue = "";
		$this->product_id->TooltipValue = "";

		// print_name
		$this->print_name->LinkCustomAttributes = "";
		$this->print_name->HrefValue = "";
		$this->print_name->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// last_price
		$this->last_price->LinkCustomAttributes = "";
		$this->last_price->HrefValue = "";
		$this->last_price->TooltipValue = "";

		// v_01
		$this->v_01->LinkCustomAttributes = "";
		$this->v_01->HrefValue = "";
		$this->v_01->TooltipValue = "";

		// v_02
		$this->v_02->LinkCustomAttributes = "";
		$this->v_02->HrefValue = "";
		$this->v_02->TooltipValue = "";

		// v_03
		$this->v_03->LinkCustomAttributes = "";
		$this->v_03->HrefValue = "";
		$this->v_03->TooltipValue = "";

		// v_04
		$this->v_04->LinkCustomAttributes = "";
		$this->v_04->HrefValue = "";
		$this->v_04->TooltipValue = "";

		// v_05
		$this->v_05->LinkCustomAttributes = "";
		$this->v_05->HrefValue = "";
		$this->v_05->TooltipValue = "";

		// v_06
		$this->v_06->LinkCustomAttributes = "";
		$this->v_06->HrefValue = "";
		$this->v_06->TooltipValue = "";

		// v_07
		$this->v_07->LinkCustomAttributes = "";
		$this->v_07->HrefValue = "";
		$this->v_07->TooltipValue = "";

		// v_08
		$this->v_08->LinkCustomAttributes = "";
		$this->v_08->HrefValue = "";
		$this->v_08->TooltipValue = "";

		// v_09
		$this->v_09->LinkCustomAttributes = "";
		$this->v_09->HrefValue = "";
		$this->v_09->TooltipValue = "";

		// v_10
		$this->v_10->LinkCustomAttributes = "";
		$this->v_10->HrefValue = "";
		$this->v_10->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// b_01
		$this->b_01->LinkCustomAttributes = "";
		$this->b_01->HrefValue = "";
		$this->b_01->TooltipValue = "";

		// b_02
		$this->b_02->LinkCustomAttributes = "";
		$this->b_02->HrefValue = "";
		$this->b_02->TooltipValue = "";

		// b_03
		$this->b_03->LinkCustomAttributes = "";
		$this->b_03->HrefValue = "";
		$this->b_03->TooltipValue = "";

		// b_04
		$this->b_04->LinkCustomAttributes = "";
		$this->b_04->HrefValue = "";
		$this->b_04->TooltipValue = "";

		// b_05
		$this->b_05->LinkCustomAttributes = "";
		$this->b_05->HrefValue = "";
		$this->b_05->TooltipValue = "";

		// b_06
		$this->b_06->LinkCustomAttributes = "";
		$this->b_06->HrefValue = "";
		$this->b_06->TooltipValue = "";

		// b_07
		$this->b_07->LinkCustomAttributes = "";
		$this->b_07->HrefValue = "";
		$this->b_07->TooltipValue = "";

		// b_08
		$this->b_08->LinkCustomAttributes = "";
		$this->b_08->HrefValue = "";
		$this->b_08->TooltipValue = "";

		// b_09
		$this->b_09->LinkCustomAttributes = "";
		$this->b_09->HrefValue = "";
		$this->b_09->TooltipValue = "";

		// b_10
		$this->b_10->LinkCustomAttributes = "";
		$this->b_10->HrefValue = "";
		$this->b_10->TooltipValue = "";

		// b_11
		$this->b_11->LinkCustomAttributes = "";
		$this->b_11->HrefValue = "";
		$this->b_11->TooltipValue = "";

		// b_12
		$this->b_12->LinkCustomAttributes = "";
		$this->b_12->HrefValue = "";
		$this->b_12->TooltipValue = "";

		// b_13
		$this->b_13->LinkCustomAttributes = "";
		$this->b_13->HrefValue = "";
		$this->b_13->TooltipValue = "";

		// b_14
		$this->b_14->LinkCustomAttributes = "";
		$this->b_14->HrefValue = "";
		$this->b_14->TooltipValue = "";

		// b_15
		$this->b_15->LinkCustomAttributes = "";
		$this->b_15->HrefValue = "";
		$this->b_15->TooltipValue = "";

		// t_01
		$this->t_01->LinkCustomAttributes = "";
		$this->t_01->HrefValue = "";
		$this->t_01->TooltipValue = "";

		// t_02
		$this->t_02->LinkCustomAttributes = "";
		$this->t_02->HrefValue = "";
		$this->t_02->TooltipValue = "";

		// t_03
		$this->t_03->LinkCustomAttributes = "";
		$this->t_03->HrefValue = "";
		$this->t_03->TooltipValue = "";

		// t_04
		$this->t_04->LinkCustomAttributes = "";
		$this->t_04->HrefValue = "";
		$this->t_04->TooltipValue = "";

		// t_05
		$this->t_05->LinkCustomAttributes = "";
		$this->t_05->HrefValue = "";
		$this->t_05->TooltipValue = "";

		// t_06
		$this->t_06->LinkCustomAttributes = "";
		$this->t_06->HrefValue = "";
		$this->t_06->TooltipValue = "";

		// t_07
		$this->t_07->LinkCustomAttributes = "";
		$this->t_07->HrefValue = "";
		$this->t_07->TooltipValue = "";

		// t_08
		$this->t_08->LinkCustomAttributes = "";
		$this->t_08->HrefValue = "";
		$this->t_08->TooltipValue = "";

		// t_09
		$this->t_09->LinkCustomAttributes = "";
		$this->t_09->HrefValue = "";
		$this->t_09->TooltipValue = "";

		// t_10
		$this->t_10->LinkCustomAttributes = "";
		$this->t_10->HrefValue = "";
		$this->t_10->TooltipValue = "";

		// t_11
		$this->t_11->LinkCustomAttributes = "";
		$this->t_11->HrefValue = "";
		$this->t_11->TooltipValue = "";

		// t_12
		$this->t_12->LinkCustomAttributes = "";
		$this->t_12->HrefValue = "";
		$this->t_12->TooltipValue = "";

		// t_13
		$this->t_13->LinkCustomAttributes = "";
		$this->t_13->HrefValue = "";
		$this->t_13->TooltipValue = "";

		// t_14
		$this->t_14->LinkCustomAttributes = "";
		$this->t_14->HrefValue = "";
		$this->t_14->TooltipValue = "";

		// t_15
		$this->t_15->LinkCustomAttributes = "";
		$this->t_15->HrefValue = "";
		$this->t_15->TooltipValue = "";

		// d_head_01
		$this->d_head_01->LinkCustomAttributes = "";
		$this->d_head_01->HrefValue = "";
		$this->d_head_01->TooltipValue = "";

		// d_description_01
		$this->d_description_01->LinkCustomAttributes = "";
		$this->d_description_01->HrefValue = "";
		$this->d_description_01->TooltipValue = "";

		// d_head_02
		$this->d_head_02->LinkCustomAttributes = "";
		$this->d_head_02->HrefValue = "";
		$this->d_head_02->TooltipValue = "";

		// d_description_02
		$this->d_description_02->LinkCustomAttributes = "";
		$this->d_description_02->HrefValue = "";
		$this->d_description_02->TooltipValue = "";

		// main_image
		$this->main_image->LinkCustomAttributes = "";
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->HrefValue = "%u"; // Add prefix/suffix
			$this->main_image->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
		} else {
			$this->main_image->HrefValue = "";
		}
		$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
		$this->main_image->TooltipValue = "";
		if ($this->main_image->UseColorbox) {
			if (EmptyValue($this->main_image->TooltipValue))
				$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->main_image->LinkAttrs["data-rel"] = "ref_multi_x_main_image";
			AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
		}

		// top_view
		$this->top_view->LinkCustomAttributes = "";
		$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->top_view->Upload->DbValue)) {
			$this->top_view->HrefValue = "%u"; // Add prefix/suffix
			$this->top_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
		} else {
			$this->top_view->HrefValue = "";
		}
		$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
		$this->top_view->TooltipValue = "";
		if ($this->top_view->UseColorbox) {
			if (EmptyValue($this->top_view->TooltipValue))
				$this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->top_view->LinkAttrs["data-rel"] = "ref_multi_x_top_view";
			AppendClass($this->top_view->LinkAttrs["class"], "ew-lightbox");
		}

		// front_view
		$this->front_view->LinkCustomAttributes = "";
		$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->front_view->Upload->DbValue)) {
			$this->front_view->HrefValue = "%u"; // Add prefix/suffix
			$this->front_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
		} else {
			$this->front_view->HrefValue = "";
		}
		$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
		$this->front_view->TooltipValue = "";
		if ($this->front_view->UseColorbox) {
			if (EmptyValue($this->front_view->TooltipValue))
				$this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->front_view->LinkAttrs["data-rel"] = "ref_multi_x_front_view";
			AppendClass($this->front_view->LinkAttrs["class"], "ew-lightbox");
		}

		// corner_view
		$this->corner_view->LinkCustomAttributes = "";
		$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->corner_view->Upload->DbValue)) {
			$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
			$this->corner_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
		} else {
			$this->corner_view->HrefValue = "";
		}
		$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
		$this->corner_view->TooltipValue = "";
		if ($this->corner_view->UseColorbox) {
			if (EmptyValue($this->corner_view->TooltipValue))
				$this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->corner_view->LinkAttrs["data-rel"] = "ref_multi_x_corner_view";
			AppendClass($this->corner_view->LinkAttrs["class"], "ew-lightbox");
		}

		// back_view
		$this->back_view->LinkCustomAttributes = "";
		$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->back_view->Upload->DbValue)) {
			$this->back_view->HrefValue = "%u"; // Add prefix/suffix
			$this->back_view->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
		} else {
			$this->back_view->HrefValue = "";
		}
		$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
		$this->back_view->TooltipValue = "";
		if ($this->back_view->UseColorbox) {
			if (EmptyValue($this->back_view->TooltipValue))
				$this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->back_view->LinkAttrs["data-rel"] = "ref_multi_x_back_view";
			AppendClass($this->back_view->LinkAttrs["class"], "ew-lightbox");
		}

		// color_options
		$this->color_options->LinkCustomAttributes = "";
		$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->color_options->Upload->DbValue)) {
			$this->color_options->HrefValue = "%u"; // Add prefix/suffix
			$this->color_options->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
		} else {
			$this->color_options->HrefValue = "";
		}
		$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
		$this->color_options->TooltipValue = "";
		if ($this->color_options->UseColorbox) {
			if (EmptyValue($this->color_options->TooltipValue))
				$this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->color_options->LinkAttrs["data-rel"] = "ref_multi_x_color_options";
			AppendClass($this->color_options->LinkAttrs["class"], "ew-lightbox");
		}

		// other_options
		$this->other_options->LinkCustomAttributes = "";
		$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->other_options->Upload->DbValue)) {
			$this->other_options->HrefValue = "%u"; // Add prefix/suffix
			$this->other_options->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
		} else {
			$this->other_options->HrefValue = "";
		}
		$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
		$this->other_options->TooltipValue = "";
		if ($this->other_options->UseColorbox) {
			if (EmptyValue($this->other_options->TooltipValue))
				$this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->other_options->LinkAttrs["data-rel"] = "ref_multi_x_other_options";
			AppendClass($this->other_options->LinkAttrs["class"], "ew-lightbox");
		}

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->HrefValue = "%u"; // Add prefix/suffix
			$this->image->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
		} else {
			$this->image->HrefValue = "";
		}
		$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		$this->image->TooltipValue = "";
		if ($this->image->UseColorbox) {
			if (EmptyValue($this->image->TooltipValue))
				$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->image->LinkAttrs["data-rel"] = "ref_multi_x_image";
			AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
		}

		// video_url
		$this->video_url->LinkCustomAttributes = "";
		$this->video_url->HrefValue = "";
		$this->video_url->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// hsn
		$this->hsn->LinkCustomAttributes = "";
		$this->hsn->HrefValue = "";
		$this->hsn->TooltipValue = "";

		// minimum_stock
		$this->minimum_stock->LinkCustomAttributes = "";
		$this->minimum_stock->HrefValue = "";
		$this->minimum_stock->TooltipValue = "";

		// in
		$this->in->LinkCustomAttributes = "";
		$this->in->HrefValue = "";
		$this->in->TooltipValue = "";

		// out
		$this->out->LinkCustomAttributes = "";
		$this->out->HrefValue = "";
		$this->out->TooltipValue = "";

		// required
		$this->required->LinkCustomAttributes = "";
		$this->required->HrefValue = "";
		$this->required->TooltipValue = "";

		// blocked
		$this->blocked->LinkCustomAttributes = "";
		$this->blocked->HrefValue = "";
		$this->blocked->TooltipValue = "";

		// ordered
		$this->ordered->LinkCustomAttributes = "";
		$this->ordered->HrefValue = "";
		$this->ordered->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// publish
		$this->publish->LinkCustomAttributes = "";
		$this->publish->HrefValue = "";
		$this->publish->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// oid
		$this->oid->EditAttrs["class"] = "form-control";
		$this->oid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->oid->CurrentValue = HtmlDecode($this->oid->CurrentValue);
		$this->oid->EditValue = $this->oid->CurrentValue;
		$this->oid->PlaceHolder = RemoveHtml($this->oid->caption());

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// product_n
		$this->product_n->EditAttrs["class"] = "form-control";
		$this->product_n->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
		$this->product_n->EditValue = $this->product_n->CurrentValue;
		$this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = 'ReadOnly';
		if (REMOVE_XSS)
			$this->product_type->CurrentValue = HtmlDecode($this->product_type->CurrentValue);
		$this->product_type->EditValue = $this->product_type->CurrentValue;
		$this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// gcode
		$this->gcode->EditAttrs["class"] = "form-control";
		$this->gcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->gcode->CurrentValue = HtmlDecode($this->gcode->CurrentValue);
		$this->gcode->EditValue = $this->gcode->CurrentValue;
		$this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->PlaceHolder = RemoveHtml($this->code->caption());

		// product_id
		$this->product_id->EditAttrs["class"] = "form-control";
		$this->product_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_id->CurrentValue = HtmlDecode($this->product_id->CurrentValue);
		$this->product_id->EditValue = $this->product_id->CurrentValue;
		$this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

		// print_name
		$this->print_name->EditAttrs["class"] = "form-control";
		$this->print_name->EditCustomAttributes = "ReadOnly";
		if (REMOVE_XSS)
			$this->print_name->CurrentValue = HtmlDecode($this->print_name->CurrentValue);
		$this->print_name->EditValue = $this->print_name->CurrentValue;
		$this->print_name->PlaceHolder = RemoveHtml($this->print_name->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->batch_no->CurrentValue = HtmlDecode($this->batch_no->CurrentValue);
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// last_price
		$this->last_price->EditAttrs["class"] = "form-control";
		$this->last_price->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->last_price->CurrentValue = HtmlDecode($this->last_price->CurrentValue);
		$this->last_price->EditValue = $this->last_price->CurrentValue;
		$this->last_price->PlaceHolder = RemoveHtml($this->last_price->caption());

		// v_01
		$this->v_01->EditCustomAttributes = "";

		// v_02
		$this->v_02->EditCustomAttributes = "";

		// v_03
		$this->v_03->EditCustomAttributes = "";

		// v_04
		$this->v_04->EditCustomAttributes = "";

		// v_05
		$this->v_05->EditCustomAttributes = "";

		// v_06
		$this->v_06->EditCustomAttributes = "";

		// v_07
		$this->v_07->EditCustomAttributes = "";

		// v_08
		$this->v_08->EditCustomAttributes = "";

		// v_09
		$this->v_09->EditCustomAttributes = "";

		// v_10
		$this->v_10->EditCustomAttributes = "";

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = "";
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
		if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
			$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -1, -2, 0);

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -1, -2, 0);

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";

		// b_01
		$this->b_01->EditAttrs["class"] = "form-control";
		$this->b_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
		$this->b_01->EditValue = $this->b_01->CurrentValue;
		$this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

		// b_02
		$this->b_02->EditAttrs["class"] = "form-control";
		$this->b_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_02->CurrentValue = HtmlDecode($this->b_02->CurrentValue);
		$this->b_02->EditValue = $this->b_02->CurrentValue;
		$this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

		// b_03
		$this->b_03->EditCustomAttributes = "";

		// b_04
		$this->b_04->EditCustomAttributes = "";

		// b_05
		$this->b_05->EditCustomAttributes = "";

		// b_06
		$this->b_06->EditCustomAttributes = "";

		// b_07
		$this->b_07->EditCustomAttributes = "";

		// b_08
		$this->b_08->EditCustomAttributes = "";

		// b_09
		$this->b_09->EditCustomAttributes = "";

		// b_10
		$this->b_10->EditCustomAttributes = "";

		// b_11
		$this->b_11->EditAttrs["class"] = "form-control";
		$this->b_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_11->CurrentValue = HtmlDecode($this->b_11->CurrentValue);
		$this->b_11->EditValue = $this->b_11->CurrentValue;
		$this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

		// b_12
		$this->b_12->EditAttrs["class"] = "form-control";
		$this->b_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
		$this->b_12->EditValue = $this->b_12->CurrentValue;
		$this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

		// b_13
		$this->b_13->EditAttrs["class"] = "form-control";
		$this->b_13->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_13->CurrentValue = HtmlDecode($this->b_13->CurrentValue);
		$this->b_13->EditValue = $this->b_13->CurrentValue;
		$this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

		// b_14
		$this->b_14->EditAttrs["class"] = "form-control";
		$this->b_14->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_14->CurrentValue = HtmlDecode($this->b_14->CurrentValue);
		$this->b_14->EditValue = $this->b_14->CurrentValue;
		$this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

		// b_15
		$this->b_15->EditAttrs["class"] = "form-control";
		$this->b_15->EditCustomAttributes = "";

		// t_01
		$this->t_01->EditAttrs["class"] = "form-control";
		$this->t_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_01->CurrentValue = HtmlDecode($this->t_01->CurrentValue);
		$this->t_01->EditValue = $this->t_01->CurrentValue;
		$this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

		// t_02
		$this->t_02->EditAttrs["class"] = "form-control";
		$this->t_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_02->CurrentValue = HtmlDecode($this->t_02->CurrentValue);
		$this->t_02->EditValue = $this->t_02->CurrentValue;
		$this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

		// t_03
		$this->t_03->EditCustomAttributes = "";

		// t_04
		$this->t_04->EditCustomAttributes = "";

		// t_05
		$this->t_05->EditCustomAttributes = "";

		// t_06
		$this->t_06->EditCustomAttributes = "";

		// t_07
		$this->t_07->EditCustomAttributes = "";

		// t_08
		$this->t_08->EditCustomAttributes = "";

		// t_09
		$this->t_09->EditCustomAttributes = "";

		// t_10
		$this->t_10->EditCustomAttributes = "";

		// t_11
		$this->t_11->EditAttrs["class"] = "form-control";
		$this->t_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_11->CurrentValue = HtmlDecode($this->t_11->CurrentValue);
		$this->t_11->EditValue = $this->t_11->CurrentValue;
		$this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

		// t_12
		$this->t_12->EditAttrs["class"] = "form-control";
		$this->t_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_12->CurrentValue = HtmlDecode($this->t_12->CurrentValue);
		$this->t_12->EditValue = $this->t_12->CurrentValue;
		$this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

		// t_13
		$this->t_13->EditAttrs["class"] = "form-control";
		$this->t_13->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_13->CurrentValue = HtmlDecode($this->t_13->CurrentValue);
		$this->t_13->EditValue = $this->t_13->CurrentValue;
		$this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

		// t_14
		$this->t_14->EditAttrs["class"] = "form-control";
		$this->t_14->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_14->CurrentValue = HtmlDecode($this->t_14->CurrentValue);
		$this->t_14->EditValue = $this->t_14->CurrentValue;
		$this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

		// t_15
		$this->t_15->EditAttrs["class"] = "form-control";
		$this->t_15->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_15->CurrentValue = HtmlDecode($this->t_15->CurrentValue);
		$this->t_15->EditValue = $this->t_15->CurrentValue;
		$this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

		// d_head_01
		$this->d_head_01->EditAttrs["class"] = "form-control";
		$this->d_head_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_head_01->CurrentValue = HtmlDecode($this->d_head_01->CurrentValue);
		$this->d_head_01->EditValue = $this->d_head_01->CurrentValue;
		$this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

		// d_description_01
		$this->d_description_01->EditAttrs["class"] = "form-control";
		$this->d_description_01->EditCustomAttributes = "";
		$this->d_description_01->EditValue = $this->d_description_01->CurrentValue;
		$this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

		// d_head_02
		$this->d_head_02->EditAttrs["class"] = "form-control";
		$this->d_head_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_head_02->CurrentValue = HtmlDecode($this->d_head_02->CurrentValue);
		$this->d_head_02->EditValue = $this->d_head_02->CurrentValue;
		$this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

		// d_description_02
		$this->d_description_02->EditAttrs["class"] = "form-control";
		$this->d_description_02->EditCustomAttributes = "";
		$this->d_description_02->EditValue = $this->d_description_02->CurrentValue;
		$this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

		// main_image
		$this->main_image->EditAttrs["class"] = "form-control";
		$this->main_image->EditCustomAttributes = "";
		$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->main_image->Upload->DbValue)) {
			$this->main_image->ImageWidth = 0;
			$this->main_image->ImageHeight = 40;
			$this->main_image->ImageAlt = $this->main_image->alt();
			$this->main_image->EditValue = $this->main_image->Upload->DbValue;
		} else {
			$this->main_image->EditValue = "";
		}
		if (!EmptyValue($this->main_image->CurrentValue))
				$this->main_image->Upload->FileName = $this->main_image->CurrentValue;

		// top_view
		$this->top_view->EditAttrs["class"] = "form-control";
		$this->top_view->EditCustomAttributes = "";
		$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->top_view->Upload->DbValue)) {
			$this->top_view->ImageWidth = 0;
			$this->top_view->ImageHeight = 40;
			$this->top_view->ImageAlt = $this->top_view->alt();
			$this->top_view->EditValue = $this->top_view->Upload->DbValue;
		} else {
			$this->top_view->EditValue = "";
		}
		if (!EmptyValue($this->top_view->CurrentValue))
				$this->top_view->Upload->FileName = $this->top_view->CurrentValue;

		// front_view
		$this->front_view->EditAttrs["class"] = "form-control";
		$this->front_view->EditCustomAttributes = "";
		$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->front_view->Upload->DbValue)) {
			$this->front_view->ImageWidth = 0;
			$this->front_view->ImageHeight = 40;
			$this->front_view->ImageAlt = $this->front_view->alt();
			$this->front_view->EditValue = $this->front_view->Upload->DbValue;
		} else {
			$this->front_view->EditValue = "";
		}
		if (!EmptyValue($this->front_view->CurrentValue))
				$this->front_view->Upload->FileName = $this->front_view->CurrentValue;

		// corner_view
		$this->corner_view->EditAttrs["class"] = "form-control";
		$this->corner_view->EditCustomAttributes = "";
		$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->corner_view->Upload->DbValue)) {
			$this->corner_view->ImageWidth = 0;
			$this->corner_view->ImageHeight = 40;
			$this->corner_view->ImageAlt = $this->corner_view->alt();
			$this->corner_view->EditValue = $this->corner_view->Upload->DbValue;
		} else {
			$this->corner_view->EditValue = "";
		}
		if (!EmptyValue($this->corner_view->CurrentValue))
				$this->corner_view->Upload->FileName = $this->corner_view->CurrentValue;

		// back_view
		$this->back_view->EditAttrs["class"] = "form-control";
		$this->back_view->EditCustomAttributes = "";
		$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->back_view->Upload->DbValue)) {
			$this->back_view->ImageWidth = 0;
			$this->back_view->ImageHeight = 40;
			$this->back_view->ImageAlt = $this->back_view->alt();
			$this->back_view->EditValue = $this->back_view->Upload->DbValue;
		} else {
			$this->back_view->EditValue = "";
		}
		if (!EmptyValue($this->back_view->CurrentValue))
				$this->back_view->Upload->FileName = $this->back_view->CurrentValue;

		// color_options
		$this->color_options->EditAttrs["class"] = "form-control";
		$this->color_options->EditCustomAttributes = "";
		$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->color_options->Upload->DbValue)) {
			$this->color_options->ImageWidth = 0;
			$this->color_options->ImageHeight = 40;
			$this->color_options->ImageAlt = $this->color_options->alt();
			$this->color_options->EditValue = $this->color_options->Upload->DbValue;
		} else {
			$this->color_options->EditValue = "";
		}
		if (!EmptyValue($this->color_options->CurrentValue))
				$this->color_options->Upload->FileName = $this->color_options->CurrentValue;

		// other_options
		$this->other_options->EditAttrs["class"] = "form-control";
		$this->other_options->EditCustomAttributes = "";
		$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->other_options->Upload->DbValue)) {
			$this->other_options->ImageWidth = 0;
			$this->other_options->ImageHeight = 40;
			$this->other_options->ImageAlt = $this->other_options->alt();
			$this->other_options->EditValue = $this->other_options->Upload->DbValue;
		} else {
			$this->other_options->EditValue = "";
		}
		if (!EmptyValue($this->other_options->CurrentValue))
				$this->other_options->Upload->FileName = $this->other_options->CurrentValue;

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 50;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->EditValue = $this->image->Upload->DbValue;
		} else {
			$this->image->EditValue = "";
		}
		if (!EmptyValue($this->image->CurrentValue))
				$this->image->Upload->FileName = $this->image->CurrentValue;

		// video_url
		$this->video_url->EditAttrs["class"] = "form-control";
		$this->video_url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
		$this->video_url->EditValue = $this->video_url->CurrentValue;
		$this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// hsn
		$this->hsn->EditAttrs["class"] = "form-control";
		$this->hsn->EditCustomAttributes = "";

		// minimum_stock
		$this->minimum_stock->EditAttrs["class"] = "form-control";
		$this->minimum_stock->EditCustomAttributes = "";
		$this->minimum_stock->EditValue = $this->minimum_stock->CurrentValue;
		$this->minimum_stock->PlaceHolder = RemoveHtml($this->minimum_stock->caption());
		if (strval($this->minimum_stock->EditValue) <> "" && is_numeric($this->minimum_stock->EditValue))
			$this->minimum_stock->EditValue = FormatNumber($this->minimum_stock->EditValue, -2, -2, -2, -2);

		// in
		$this->in->EditAttrs["class"] = "form-control";
		$this->in->EditCustomAttributes = "";
		$this->in->EditValue = $this->in->CurrentValue;
		$this->in->PlaceHolder = RemoveHtml($this->in->caption());
		if (strval($this->in->EditValue) <> "" && is_numeric($this->in->EditValue))
			$this->in->EditValue = FormatNumber($this->in->EditValue, -2, -2, -2, -2);

		// out
		$this->out->EditAttrs["class"] = "form-control";
		$this->out->EditCustomAttributes = "";
		$this->out->EditValue = $this->out->CurrentValue;
		$this->out->PlaceHolder = RemoveHtml($this->out->caption());
		if (strval($this->out->EditValue) <> "" && is_numeric($this->out->EditValue))
			$this->out->EditValue = FormatNumber($this->out->EditValue, -2, -2, -2, -2);

		// required
		$this->required->EditAttrs["class"] = "form-control";
		$this->required->EditCustomAttributes = "";
		$this->required->EditValue = $this->required->CurrentValue;
		$this->required->PlaceHolder = RemoveHtml($this->required->caption());
		if (strval($this->required->EditValue) <> "" && is_numeric($this->required->EditValue))
			$this->required->EditValue = FormatNumber($this->required->EditValue, -2, -2, -2, -2);

		// blocked
		$this->blocked->EditAttrs["class"] = "form-control";
		$this->blocked->EditCustomAttributes = "";
		$this->blocked->EditValue = $this->blocked->CurrentValue;
		$this->blocked->PlaceHolder = RemoveHtml($this->blocked->caption());
		if (strval($this->blocked->EditValue) <> "" && is_numeric($this->blocked->EditValue))
			$this->blocked->EditValue = FormatNumber($this->blocked->EditValue, -2, -2, -2, -2);

		// ordered
		$this->ordered->EditAttrs["class"] = "form-control";
		$this->ordered->EditCustomAttributes = "";
		$this->ordered->EditValue = $this->ordered->CurrentValue;
		$this->ordered->PlaceHolder = RemoveHtml($this->ordered->caption());
		if (strval($this->ordered->EditValue) <> "" && is_numeric($this->ordered->EditValue))
			$this->ordered->EditValue = FormatNumber($this->ordered->EditValue, -2, -2, -2, -2);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// publish
		$this->publish->EditAttrs["class"] = "form-control";
		$this->publish->EditCustomAttributes = "";
		$this->publish->EditValue = $this->publish->options(TRUE);

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_n);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->last_price);
					$doc->exportCaption($this->v_01);
					$doc->exportCaption($this->v_02);
					$doc->exportCaption($this->v_03);
					$doc->exportCaption($this->v_04);
					$doc->exportCaption($this->v_05);
					$doc->exportCaption($this->v_06);
					$doc->exportCaption($this->v_07);
					$doc->exportCaption($this->v_08);
					$doc->exportCaption($this->v_09);
					$doc->exportCaption($this->v_10);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->b_01);
					$doc->exportCaption($this->b_02);
					$doc->exportCaption($this->b_03);
					$doc->exportCaption($this->b_04);
					$doc->exportCaption($this->b_05);
					$doc->exportCaption($this->b_06);
					$doc->exportCaption($this->b_07);
					$doc->exportCaption($this->b_08);
					$doc->exportCaption($this->b_09);
					$doc->exportCaption($this->b_10);
					$doc->exportCaption($this->b_11);
					$doc->exportCaption($this->b_12);
					$doc->exportCaption($this->b_13);
					$doc->exportCaption($this->b_14);
					$doc->exportCaption($this->b_15);
					$doc->exportCaption($this->t_01);
					$doc->exportCaption($this->t_02);
					$doc->exportCaption($this->t_03);
					$doc->exportCaption($this->t_04);
					$doc->exportCaption($this->t_05);
					$doc->exportCaption($this->t_06);
					$doc->exportCaption($this->t_07);
					$doc->exportCaption($this->t_08);
					$doc->exportCaption($this->t_09);
					$doc->exportCaption($this->t_10);
					$doc->exportCaption($this->t_11);
					$doc->exportCaption($this->t_12);
					$doc->exportCaption($this->t_13);
					$doc->exportCaption($this->t_14);
					$doc->exportCaption($this->t_15);
					$doc->exportCaption($this->d_head_01);
					$doc->exportCaption($this->d_description_01);
					$doc->exportCaption($this->d_head_02);
					$doc->exportCaption($this->d_description_02);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->top_view);
					$doc->exportCaption($this->front_view);
					$doc->exportCaption($this->corner_view);
					$doc->exportCaption($this->back_view);
					$doc->exportCaption($this->color_options);
					$doc->exportCaption($this->other_options);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->video_url);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->publish);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_n);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->last_price);
					$doc->exportCaption($this->v_01);
					$doc->exportCaption($this->v_02);
					$doc->exportCaption($this->v_03);
					$doc->exportCaption($this->v_04);
					$doc->exportCaption($this->v_05);
					$doc->exportCaption($this->v_06);
					$doc->exportCaption($this->v_07);
					$doc->exportCaption($this->v_08);
					$doc->exportCaption($this->v_09);
					$doc->exportCaption($this->v_10);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->b_01);
					$doc->exportCaption($this->b_02);
					$doc->exportCaption($this->b_03);
					$doc->exportCaption($this->b_04);
					$doc->exportCaption($this->b_05);
					$doc->exportCaption($this->b_06);
					$doc->exportCaption($this->b_07);
					$doc->exportCaption($this->b_08);
					$doc->exportCaption($this->b_09);
					$doc->exportCaption($this->b_10);
					$doc->exportCaption($this->b_11);
					$doc->exportCaption($this->b_12);
					$doc->exportCaption($this->b_13);
					$doc->exportCaption($this->b_14);
					$doc->exportCaption($this->b_15);
					$doc->exportCaption($this->t_01);
					$doc->exportCaption($this->t_02);
					$doc->exportCaption($this->t_03);
					$doc->exportCaption($this->t_04);
					$doc->exportCaption($this->t_05);
					$doc->exportCaption($this->t_06);
					$doc->exportCaption($this->t_07);
					$doc->exportCaption($this->t_08);
					$doc->exportCaption($this->t_09);
					$doc->exportCaption($this->t_10);
					$doc->exportCaption($this->t_11);
					$doc->exportCaption($this->t_12);
					$doc->exportCaption($this->t_13);
					$doc->exportCaption($this->t_14);
					$doc->exportCaption($this->t_15);
					$doc->exportCaption($this->d_head_01);
					$doc->exportCaption($this->d_description_01);
					$doc->exportCaption($this->d_head_02);
					$doc->exportCaption($this->d_description_02);
					$doc->exportCaption($this->main_image);
					$doc->exportCaption($this->top_view);
					$doc->exportCaption($this->front_view);
					$doc->exportCaption($this->corner_view);
					$doc->exportCaption($this->back_view);
					$doc->exportCaption($this->color_options);
					$doc->exportCaption($this->other_options);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->video_url);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->publish);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_n);
						$doc->exportField($this->product_type);
						$doc->exportField($this->last_price);
						$doc->exportField($this->v_01);
						$doc->exportField($this->v_02);
						$doc->exportField($this->v_03);
						$doc->exportField($this->v_04);
						$doc->exportField($this->v_05);
						$doc->exportField($this->v_06);
						$doc->exportField($this->v_07);
						$doc->exportField($this->v_08);
						$doc->exportField($this->v_09);
						$doc->exportField($this->v_10);
						$doc->exportField($this->cbm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->shape);
						$doc->exportField($this->b_01);
						$doc->exportField($this->b_02);
						$doc->exportField($this->b_03);
						$doc->exportField($this->b_04);
						$doc->exportField($this->b_05);
						$doc->exportField($this->b_06);
						$doc->exportField($this->b_07);
						$doc->exportField($this->b_08);
						$doc->exportField($this->b_09);
						$doc->exportField($this->b_10);
						$doc->exportField($this->b_11);
						$doc->exportField($this->b_12);
						$doc->exportField($this->b_13);
						$doc->exportField($this->b_14);
						$doc->exportField($this->b_15);
						$doc->exportField($this->t_01);
						$doc->exportField($this->t_02);
						$doc->exportField($this->t_03);
						$doc->exportField($this->t_04);
						$doc->exportField($this->t_05);
						$doc->exportField($this->t_06);
						$doc->exportField($this->t_07);
						$doc->exportField($this->t_08);
						$doc->exportField($this->t_09);
						$doc->exportField($this->t_10);
						$doc->exportField($this->t_11);
						$doc->exportField($this->t_12);
						$doc->exportField($this->t_13);
						$doc->exportField($this->t_14);
						$doc->exportField($this->t_15);
						$doc->exportField($this->d_head_01);
						$doc->exportField($this->d_description_01);
						$doc->exportField($this->d_head_02);
						$doc->exportField($this->d_description_02);
						$doc->exportField($this->main_image);
						$doc->exportField($this->top_view);
						$doc->exportField($this->front_view);
						$doc->exportField($this->corner_view);
						$doc->exportField($this->back_view);
						$doc->exportField($this->color_options);
						$doc->exportField($this->other_options);
						$doc->exportField($this->image);
						$doc->exportField($this->video_url);
						$doc->exportField($this->currency);
						$doc->exportField($this->hsn);
						$doc->exportField($this->status);
						$doc->exportField($this->publish);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_n);
						$doc->exportField($this->product_type);
						$doc->exportField($this->last_price);
						$doc->exportField($this->v_01);
						$doc->exportField($this->v_02);
						$doc->exportField($this->v_03);
						$doc->exportField($this->v_04);
						$doc->exportField($this->v_05);
						$doc->exportField($this->v_06);
						$doc->exportField($this->v_07);
						$doc->exportField($this->v_08);
						$doc->exportField($this->v_09);
						$doc->exportField($this->v_10);
						$doc->exportField($this->cbm);
						$doc->exportField($this->sqm);
						$doc->exportField($this->shape);
						$doc->exportField($this->b_01);
						$doc->exportField($this->b_02);
						$doc->exportField($this->b_03);
						$doc->exportField($this->b_04);
						$doc->exportField($this->b_05);
						$doc->exportField($this->b_06);
						$doc->exportField($this->b_07);
						$doc->exportField($this->b_08);
						$doc->exportField($this->b_09);
						$doc->exportField($this->b_10);
						$doc->exportField($this->b_11);
						$doc->exportField($this->b_12);
						$doc->exportField($this->b_13);
						$doc->exportField($this->b_14);
						$doc->exportField($this->b_15);
						$doc->exportField($this->t_01);
						$doc->exportField($this->t_02);
						$doc->exportField($this->t_03);
						$doc->exportField($this->t_04);
						$doc->exportField($this->t_05);
						$doc->exportField($this->t_06);
						$doc->exportField($this->t_07);
						$doc->exportField($this->t_08);
						$doc->exportField($this->t_09);
						$doc->exportField($this->t_10);
						$doc->exportField($this->t_11);
						$doc->exportField($this->t_12);
						$doc->exportField($this->t_13);
						$doc->exportField($this->t_14);
						$doc->exportField($this->t_15);
						$doc->exportField($this->d_head_01);
						$doc->exportField($this->d_description_01);
						$doc->exportField($this->d_head_02);
						$doc->exportField($this->d_description_02);
						$doc->exportField($this->main_image);
						$doc->exportField($this->top_view);
						$doc->exportField($this->front_view);
						$doc->exportField($this->corner_view);
						$doc->exportField($this->back_view);
						$doc->exportField($this->color_options);
						$doc->exportField($this->other_options);
						$doc->exportField($this->image);
						$doc->exportField($this->video_url);
						$doc->exportField($this->currency);
						$doc->exportField($this->hsn);
						$doc->exportField($this->status);
						$doc->exportField($this->publish);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'main_image') {
			$fldName = "main_image";
			$fileNameFld = "main_image";
		} elseif ($fldparm == 'top_view') {
			$fldName = "top_view";
			$fileNameFld = "top_view";
		} elseif ($fldparm == 'front_view') {
			$fldName = "front_view";
			$fileNameFld = "front_view";
		} elseif ($fldparm == 'corner_view') {
			$fldName = "corner_view";
			$fileNameFld = "corner_view";
		} elseif ($fldparm == 'back_view') {
			$fldName = "back_view";
			$fileNameFld = "back_view";
		} elseif ($fldparm == 'color_options') {
			$fldName = "color_options";
			$fileNameFld = "color_options";
		} elseif ($fldparm == 'other_options') {
			$fldName = "other_options";
			$fileNameFld = "other_options";
		} elseif ($fldparm == 'image') {
			$fldName = "image";
			$fileNameFld = "image";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'ref_multi';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'ref_multi';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'ref_multi';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'ref_multi';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>